

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDDBPerformance.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDDBPerformance.sp,v $ $Id: ParseDDBPerformance.sp,v 1.4.60.14 2020/12/18 10:35:15 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseDDBPerformance')
BEGIN
	print '>>> Drop Stored Procedure: ParseDDBPerformance <<<'
	drop procedure ParseDDBPerformance
END
IF EXISTS (select * from GxQscripts where name='ParseDDBPerformance')
	delete from GxQscripts where name = 'ParseDDBPerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDDBPerformance')
	delete from GXDBVersions where aliasname = 'ParseDDBPerformance'
GO
print '... Creating Procedure: ParseDDBPerformance'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseDDBPerformance
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseDDBPerformanceTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO [cf_SurveyDDBPerformance]
	(	 [CommServUniqueId]
        ,[SurveyResultId]
        ,[LogDateUTC]
        ,[LogDate]
        ,[SidbStoreId]
        ,[SidbStoreName]
        ,[LastRecordedTime]
        ,[AvgQITime]
        ,[CreatedTime]
        ,[PrimaryRecords]
		,[DDBSizeMB]
		,[ZeroRefCount]
		,[SecondaryRecords]
		,[TotalDataSizeMB]
		,[InstancedDataSizeMB]
		,[FrontendBackupMB]
		,[FrontendArchiveMB]
		,[BaseLineSizeMB]				-- MR 172535
		,[Readiness]
		,[MediaAgentNames]
		,[CopyId]
		,[AppSizeMB]
		,[DedupeRatio]
		,[ExtendedFlags]
		,[NeedUpgrade]
	)
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@StoreId', 'int') as SidbStoreId,
		csInfo.n.value('@StoreName', 'NVARCHAR(255)') as SidbStoreName,
		csInfo.n.value('@LastRecordedTime', 'datetime') as LastRecordedTime,
		csInfo.n.value('@AvgQITime', 'bigint')	as AvgQITime,
		ISNULL(csInfo.n.value('@CreatedTime','datetime'),-1) as CreatedTime,
		ISNULL(csInfo.n.value('@PrimaryRecords','bigint'),-1) as PrimaryRecords,
		ISNULL(csInfo.n.value('@DDBSizeMB','bigint'),-1) as DDBSizeMB,
		ISNULL(csInfo.n.value('@ZeroRefRecords','bigint'),-1) as ZeroRefCount,
		ISNULL(csInfo.n.value('@SecondaryRecords','bigint'), -1),
		ISNULL(csInfo.n.value('@TotalDataSizeMB','bigint'), -1),
		ISNULL(csInfo.n.value('@InstancedDataSizeMB','bigint'), -1),
		ISNULL(csInfo.n.value('@FrontendBackupMB','bigint'), -1),
		ISNULL(csInfo.n.value('@FrontendArchiveMB','bigint'), -1),
		ISNULL(csInfo.n.value('@BaseLineSizeMB','bigint'), -1),				-- MR 172535
		ISNULL(csInfo.n.value('@Readiness', 'VARCHAR(128)'), ''),
		ISNULL(csInfo.n.value('@MediaAgentNames', 'NVARCHAR(1024)'), ''),
		ISNULL(csInfo.n.value('@CopyId','INT'), -1),
		ISNULL(csInfo.n.value('@AppSizeMB', 'BIGINT'), -1),
		ISNULL(csInfo.n.value('@DedupeRatio', 'FLOAT'), -1),
		ISNULL(csInfo.n.value('@ExtendedFlags', 'BIGINT'), -1),
		ISNULL(csInfo.n.value('@NeedUpgrade', 'INT'), -1)
	FROM
	 	@ResultXml.nodes('/DDBPerformance/Metric') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO [cf_SurveyPartitionPerformance]
	(	 [SurveyResultId]
        ,[SidbStoreId]
		,[SubStoreId]
        ,[LastRecordedTime]
        ,[AvgQITime]
        ,[PrimaryRecords]
		,[ZeroRefCount]
		,[SecondaryRecords]
		,[PartitionSizeMB]
		,[MediaAgentName]
		,[CopyId]
		,[AccessPath]
	)
	SELECT
		@ResultId,
		csInfo.n.value('@StoreId', 'int') as SidbStoreId,
		partitionData.d.value('@SubStoreId', 'bigint') as SubStoreId,
		partitionData.d.value('@LastRecordedTime', 'datetime') as LastRecordedTime,
		partitionData.d.value('@AvgQITime', 'bigint')	as AvgQITime,
		partitionData.d.value('@PrimaryRecords','bigint') as PrimaryRecords,
		partitionData.d.value('@ZeroRefCount','bigint') as ZeroRefCount,
		partitionData.d.value('@SecondaryRecords','bigint') as SecondaryRecords,
		partitionData.d.value('@PartitionSize','bigint') as PartitionSizeMB,
		partitionData.d.value('@MediaAgentName', 'NVARCHAR(1024)') as MediaAgentName,
		partitionData.d.value('@CopyId','INT') as CopyId,
		partitionData.d.value('@AccessPath', 'NVARCHAR(1024)') as AccessPath
	FROM
	 	@ResultXml.nodes('/DDBPerformance/Metric') AS csInfo(n)
		CROSS apply n.nodes('PartitionInfo') AS partitionData(d)
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseDDBPerformanceTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDDBPerformance')
	delete from GxQscripts where name = 'ParseDDBPerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDDBPerformance')
	delete from GXDBVersions where aliasname = 'ParseDDBPerformance'
GO

insert into GXDBVersions values(2, 'ParseDDBPerformance',  '00010004006000140000', 'ParseDDBPerformance', '00010004006000140000')
GO

