

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCopyBasicRetention.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCopyBasicRetention.sp,v $ $Id: ParseCopyBasicRetention.sp,v 1.7.2.10 2020/12/17 02:54:59 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCopyBasicRetention')
BEGIN
	print '>>> Drop Stored Procedure: ParseCopyBasicRetention <<<'
	drop procedure ParseCopyBasicRetention
END
IF EXISTS (select * from GxQscripts where name='ParseCopyBasicRetention')
	delete from GxQscripts where name = 'ParseCopyBasicRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCopyBasicRetention')
	delete from GXDBVersions where aliasname = 'ParseCopyBasicRetention'
GO
print '... Creating Procedure: ParseCopyBasicRetention'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCopyBasicRetention
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCopyBasicRetentionTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #CopyBasicRetention
(
	PolicyId			INT,
	PolicyName			NVARCHAR(144),
	CopyId				INT,
	CopyName			NVARCHAR(64),
	CopyType			INT,
	IsDefaultCopy		INT,
	IsSnapCopy			INT,
	RetentionDays		INT NULL,
	ArchiverRetDays		INT NULL,
	RetentionCycles		INT NULL,
	AgingFlags			INT NULL,
	ExtRretentionRules	INT NULL,
	DedupeFlags			INT NULL,
	DefaultLibrary		NVARCHAR(128) NULL,
	DefaultLibraryID	INT NULL,
	PolicyFlags			INT NULL,
	IsActiveCopy		INT NULL,
	SourceCopyId		INT NULL,
	CopyFlags			INT NULL,
	ExtendedFlags		BIGINT NULL
)
CREATE TABLE #ArchSelectiveCopy (
	CommservUniqueId	INT,
	CopyId				INT,
	type				INT,
	NumPeriod			INT,
	dayNumber			INT,
	copyflag			INT
)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #CopyBasicRetention (
		PolicyId, PolicyName, CopyId, CopyName, CopyType, IsDefaultCopy, IsSnapCopy,
		RetentionDays, ArchiverRetDays, RetentionCycles, AgingFlags, ExtRretentionRules,
		DedupeFlags, DefaultLibrary, DefaultLibraryID, PolicyFlags, IsActiveCopy,
		SourceCopyId, CopyFlags, ExtendedFlags)
	SELECT
		csInfo.n.value('@policyId','INT'),
		csInfo.n.value('@policyName','NVARCHAR(144)'),
		csInfo.n.value('@copyId','INT'),
		csInfo.n.value('@copyName','VARCHAR(64)'),
		csInfo.n.value('@copyType','INT'),
		csInfo.n.value('@isDefaultCopy','INT'),
		csInfo.n.value('@isSnapCopy','INT'),
		csInfo.n.value('@retentionDays','INT'),
		csInfo.n.value('@archiverRetDays','INT'),
		csInfo.n.value('@retentionCycles','INT'),
		csInfo.n.value('@agingFlags','INT'),
		csInfo.n.value('@extRretentionRules','INT'),
		csInfo.n.value('@dedupeFlags','INT'),
		csInfo.n.value('@defaultLibrary','NVARCHAR(128)'),
		csInfo.n.value('@defaultLibraryid','INT'),
		csInfo.n.value('@policyFlags','INT'),
		csInfo.n.value('@isActiveCopy','INT'),
		csInfo.n.value('@sourceCopyId','INT'),
		csInfo.n.value('@copyFlags','INT'),
		csInfo.n.value('@extendedFlags','BIGINT')
	FROM
		@ResultXml.nodes('Copy') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #ArchSelectiveCopy (CommservUniqueId,
		CopyId, type, NumPeriod, dayNumber, copyflag)
	SELECT
		@CSUniqueId,
		csInfo.n.value('@copyId','INT'),
		csInfo.n.value('@type','TINYINT'),
        csInfo.n.value('@numPeriod','TINYINT'),
        csInfo.n.value('@dayNumber','SMALLINT'),
        csInfo.n.value('@copyflags','INT')
	FROM
		@ResultXml.nodes('ArchSelectiveCopy') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	C
	FROM	cf_SurveyCopyBasicRetention C INNER JOIN #CopyBasicRetention T
			ON C.CommservUniqueId = @CSUniqueId AND C.CopyId = T.CopyId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	C SET PolicyName = T.PolicyName
	FROM	cf_SurveyCopyBasicRetention C INNER JOIN (SELECT DISTINCT PolicyId, PolicyName FROM #CopyBasicRetention) T
			ON C.CommservUniqueId = @CSUniqueId AND C.PolicyId = T.PolicyId AND C.PolicyName <> T.PolicyName
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	cf_SurveyCopyBasicRetention SET Deleted = 1
	WHERE	CommservUniqueId = @CSUniqueId AND Deleted = 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyCopyBasicRetention (CommservUniqueId,
			PolicyId, PolicyName, CopyId, CopyName, CopyType, IsDefaultCopy, IsSnapCopy,
			RetentionDays, ArchiverRetDays, RetentionCycles, AgingFlags, ExtRretentionRules,
			Deleted, DedupeFlags, DefaultLibrary, DefaultLibraryID, PolicyFlags, IsActiveCopy,
			SourceCopyId, CopyFlags, ExtendedFlags)
	SELECT	@CSUniqueId, PolicyId, PolicyName, CopyId, CopyName, CopyType, IsDefaultCopy, IsSnapCopy,
			RetentionDays, ArchiverRetDays, RetentionCycles, AgingFlags, ExtRretentionRules,
			0, DedupeFlags, DefaultLibrary, DefaultLibraryID, PolicyFlags, IsActiveCopy,
			SourceCopyId, CopyFlags, ExtendedFlags
	FROM	#CopyBasicRetention
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE cf_SurveyArchSelectiveCopy WHERE CommservUniqueId = @CSUniqueId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyArchSelectiveCopy (CommservUniqueId,
		CopyId, type, NumPeriod, dayNumber, copyflag)
	SELECT	CommservUniqueId, CopyId, type, NumPeriod, dayNumber, copyflag
	FROM	#ArchSelectiveCopy
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCopyBasicRetentionTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCopyBasicRetention')
	delete from GxQscripts where name = 'ParseCopyBasicRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCopyBasicRetention')
	delete from GXDBVersions where aliasname = 'ParseCopyBasicRetention'
GO

insert into GXDBVersions values(2, 'ParseCopyBasicRetention',  '00010007000200100000', 'ParseCopyBasicRetention', '00010007000200100000')
GO

