

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCommServDetails.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCommServDetails.sp,v $ $Id: ParseCommServDetails.sp,v 1.3.42.11.4.1 2021/04/30 20:51:12 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCommServDetails')
BEGIN
	print '>>> Drop Stored Procedure: ParseCommServDetails <<<'
	drop procedure ParseCommServDetails
END
IF EXISTS (select * from GxQscripts where name='ParseCommServDetails')
	delete from GxQscripts where name = 'ParseCommServDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommServDetails')
	delete from GXDBVersions where aliasname = 'ParseCommServDetails'
GO
print '... Creating Procedure: ParseCommServDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCommServDetails
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCommServDetailsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @isPrivate          INT = 0
SELECT  @isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig (NoLOCK) WHERE Name = 'isPrivate'
DECLARE @OldCommServHostName nvarchar(1020), @NewCommServHostName nvarchar(1020)
DECLARE @OldCurrCSIpAddress nvarchar(1024), @NewCurrCSIpAddress nvarchar(1024)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyCSDetailsInfo (
				CommServUniqueId, SurveyResultId, LogDateUTC, LogDate,
				CommServTZ, CommServVersion, QNetRegCount, LicExpirationDate, SQLVersion, LicUsageCollectionTime, LSR_enabled)
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		ISNULL(csInfo.n.value('@CommServTZ', 'NVARCHAR(MAX)'), ''),
		ISNULL(csInfo.n.value('@CommServVersion', 'NVARCHAR(MAX)'),''),
		ISNULL(csInfo.n.value('@QNetRegCount', 'INTEGER'),-1),
		ISNULL(csInfo.n.value('@LicExpirationDate', 'INTEGER'),0),
		ISNULL(csInfo.n.value('@SQLVersion', 'NVARCHAR(MAX)'), ''),
		ISNULL(csInfo.n.value('@LicUsageCollectionTime', 'BIGINT'),0),
		ISNULL(csInfo.n.value('@LSR_enabled', 'INT'),0)
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/CommServerInfo') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND @isPrivate = 0
BEGIN
	DECLARE @OldestBKPTime BIGINT = NULL
	DECLARE @OldestRSTTime BIGINT = NULL
	SELECT @OldestBKPTime = csInfo.n.value('@OldestBKPTime', 'INTEGER'), @OldestRSTTime = csInfo.n.value('@OldestRSTTime', 'INTEGER')
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/CommServerInfo') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	IF NOT EXISTS (SELECT top 1 * FROM cf_CommCellOnBoarding WITH (NOLOCK) WHERE CommServUniqueId = @CSUniqueId)
    BEGIN
        INSERT INTO cf_CommCellOnBoarding
        SELECT @CSUniqueId, dbo.getDateTime(@OldestBkpTime), dbo.getDateTime(@OldestRSTTime)
    END
    ELSE
    IF EXISTS (SELECT top 1 * FROM cf_CommCellOnBoarding WITH (NOLOCK) WHERE CommServUniqueId = @CSUniqueId AND (OldestBkpTime IS NULL OR OldestRSTTime IS NULL))
    BEGIN
        IF @OldestBkpTime IS NOT NULL
	        UPDATE cf_CommCellOnBoarding
	        SET OldestBkpTime = dbo.getDateTime(@OldestBkpTime)
	        WHERE CommServUniqueId = @CSUniqueId AND OldestBkpTime IS NULL
        IF @OldestRSTTime IS NOT NULL
	        UPDATE cf_CommCellOnBoarding
	        SET OldestRSTTime = dbo.getDateTime(@OldestRSTTime)
	        WHERE CommServUniqueId = @CSUniqueId AND OldestRSTTime IS NULL
    END
END
IF 	@ErrorCode = 0
BEGIN
	SET @OldCommServHostName = ''
	SET @NewCommServHostName = ''
	SET @OldCurrCSIpAddress = ''
	SET @NewCurrCSIpAddress = ''
	SELECT @OldCommServHostName = ISNULL(CommServHostName, ''), @OldCurrCSIpAddress = ISNULL(CurrCSIpAddress, '') FROM cf_CommcellIdNameMap WITH(NOLOCK) WHERE ID = @CSUniqueId
	SELECT
		@NewCommServHostName = ISNULL(csInfo.n.value('@CommServHostName', 'NVARCHAR(1020)'), ''),
		@NewCurrCSIpAddress = ISNULL(csInfo.n.value('@CurrCSIpAddress', 'VARCHAR(1024)'), '')
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/CommServerInfo') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE CC SET
		CC.CommServHostName = @NewCommServHostName,
		CC.CurrCSIpAddress = @NewCurrCSIpAddress
	FROM cf_CommcellIdNameMap CC
	WHERE ID = @CSUniqueId AND (@OldCommServHostName <> @NewCommServHostName OR @OldCurrCSIpAddress <> @NewCurrCSIpAddress)
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCommServDetailsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCommServDetails')
	delete from GxQscripts where name = 'ParseCommServDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCommServDetails')
	delete from GXDBVersions where aliasname = 'ParseCommServDetails'
GO

insert into GXDBVersions values(2, 'ParseCommServDetails',  'v1.3.42.11.4.1', 'ParseCommServDetails', 'v1.3.42.11.4.1')
GO

