

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCollectedResultsForSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCollectedResultsForSurvey.sp,v $ $Id: ParseCollectedResultsForSurvey.sp,v 1.7.60.13.4.1 2021/03/03 04:17:05 rshibu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCollectedResultsForSurvey')
BEGIN
	print '>>> Drop Stored Procedure: ParseCollectedResultsForSurvey <<<'
	drop procedure ParseCollectedResultsForSurvey
END
IF EXISTS (select * from GxQscripts where name='ParseCollectedResultsForSurvey')
	delete from GxQscripts where name = 'ParseCollectedResultsForSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCollectedResultsForSurvey')
	delete from GXDBVersions where aliasname = 'ParseCollectedResultsForSurvey'
GO
print '... Creating Procedure: ParseCollectedResultsForSurvey'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCollectedResultsForSurvey
  @XmlFileId INTEGER,
  @ShredStatus INTEGER OUTPUT,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON
--Execute corresponding Parser script by building Dynamic Query
DECLARE @LogString		NVARCHAR(MAX)
DECLARE @SQLString		NVARCHAR(500)
DECLARE @ParmDefinition NVARCHAR(500)
DECLARE	@TranName		NVARCHAR(256)
DECLARE	@TranCount		INT
DECLARE	@ErrCode		INT
DECLARE @ErrorMsg		NVARCHAR(MAX)
DECLARE @ShredStatusTbl TABLE (ShredStatus INT, nResults INT)
DECLARE	@StartDate		DATETIME= GETUTCDATE()
DECLARE	@TempDate		DATETIME
DECLARE	@Duration		INTEGER = 0
DECLARE @RollbackTime	INTEGER = 0
DECLARE @QueryId		INTEGER
DECLARE @ResultId		BIGINT
DECLARE @CSUniqueId		INTEGER
DECLARE @LogDateUTC		DATETIME
DECLARE @LogDate		DATETIME
DECLARE @ParseSP		SYSNAME
DECLARE @nSuccess		INT = 0
DECLARE @nFailed		INT = 0
DECLARE @nSkipped		INT = 0
SET @StartDate	= GETUTCDATE()
SET @Duration	= 0
DECLARE	SurveyResultCur CURSOR LOCAL FAST_FORWARD FOR
SELECT	Q.QueryId, Q.ParserScript, R.CommservSurveyResults_ID, R.CommcellIdNameMap_ID, R.LogDateUTC, R.LogDate
FROM	cf_CommservSurveyResults AS R
		INNER JOIN cf_CommservSurveyQueries AS Q ON R.QueryId = Q.QueryId
WHERE	R.CustomerFeedbackXmlFile_ID = @XmlFileId AND R.ShredStatus = 1 AND LEN(ParserScript) > 0
ORDER BY Q.QueryId, R.CommservSurveyResults_ID
OPEN SurveyResultCur
	FETCH FROM SurveyResultCur INTO @QueryId, @ParseSP, @ResultId, @CSUniqueId, @LogDateUTC, @LogDate
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @SQLString = N'EXEC ' + @ParseSP + ' @iQueryId, @iResultId, @iCSUniqueId, @iLogDateUTC, @iLogDate, @iLogLevel'
	SET @ParmDefinition = N'@iQueryId INTEGER, @iResultId INTEGER, @iCSUniqueId INTEGER, @iLogDateUTC DATETIME, @iLogDate DATETIME, @iLogLevel INTEGER'
	SET @LogString = ''
	BEGIN TRY
		EXEC @ErrCode = sp_executesql @SQLString, @ParmDefinition, @iQueryId = @QueryId, @iResultId = @ResultId, @iCSUniqueId = @CSUniqueId, @iLogDateUTC = @LogDateUTC, @iLogDate = @LogDate, @iLogLevel = @LogLevel
		IF	@ErrCode <> 0
			SET @LogString += ' - ERROR CODE ' + CAST(@ErrCode AS VARCHAR(20)) + ' is returned from sp_executesql ' + @ParseSP
	END TRY
	BEGIN CATCH
		SELECT	@ErrCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE()
		SET @LogString += ' - Exception from ' + @ParseSP + ' procedure. ERROR CODE: ' + CAST(@ErrCode AS VARCHAR(20)) + ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '')
	END CATCH
	SET @TranCount = @@TRANCOUNT
	IF  @TranCount > 0
	BEGIN
		SELECT	@TranName = A.name
		FROM	sys.dm_tran_active_transactions A
				INNER JOIN sys.dm_tran_session_transactions S ON A.transaction_id = S.transaction_id
		WHERE	S.session_id = @@SPID
		SET @LogString += ' - Rollback uncommitted transaction ' + ISNULL(@TranName, '') + ' (Previous TRANCOUNT = ' + CAST(@TranCount AS VARCHAR(20)) + ')'
		SET @TempDate = GETUTCDATE()
		ROLLBACK TRANSACTION
		SET @Duration = DATEDIFF(SS, @TempDate,  GETUTCDATE())
		SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(20)) + ' (sec).'
	END
	IF @LogString <> ''
	BEGIN
		SET @LogString = ('Session ' + CAST(@@SPID AS VARCHAR(20)) + ' -- Parsing result ' + CAST(@ResultId AS VARCHAR(20))
			+ ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')'	+ @LogString)
		INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
	END
	IF	@ErrCode <> 0
		UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId AND ShredStatus = 1
	FETCH FROM SurveyResultCur INTO @QueryId, @ParseSP, @ResultId, @CSUniqueId, @LogDateUTC, @LogDate
END
CLOSE SurveyResultCur
DEALLOCATE SurveyResultCur
INSERT	INTO @ShredStatusTbl
SELECT	ShredStatus, COUNT(*)
FROM	cf_CommservSurveyResults
WHERE	CustomerFeedbackXmlFile_ID = @XmlFileId
GROUP BY ShredStatus
SELECT	@nFailed  = nResults FROM @ShredStatusTbl WHERE ShredStatus = 3
SELECT	@nSuccess = nResults FROM @ShredStatusTbl WHERE ShredStatus = 2
SELECT	@nSkipped = nResults FROM @ShredStatusTbl WHERE ShredStatus = 1
IF	@nSkipped > 0
	SET @ShredStatus = 0
ELSE
IF	@nSuccess > 0 AND @nFailed = 0
	SET @ShredStatus = 2
ELSE
	SET @ShredStatus = 3
UPDATE cf_CustomerFeedbackXmlFile SET ShredStatus = @ShredStatus WHERE ID = @XmlFileId
IF	@nSkipped > 0
	UPDATE cf_CommservSurveyResults SET ShredStatus = 0 WHERE CustomerFeedbackXmlFile_ID = @XmlFileId AND ShredStatus = 1
IF	@LogLevel > 0 OR @ShredStatus <> 2
BEGIN
	SET	@Duration  = DATEDIFF(SS, @StartDate, GETUTCDATE())
	SET @LogString = 'Session ' + CAST(@@SPID AS VARCHAR(10))
			+ ' -- Parsing results of xml File ' + CAST(@XmlFileId AS VARCHAR(10)) + ' of CommServ (Unique ID ' +  CAST(@CSUniqueId AS VARCHAR(10))
			+ ') - Succeeded: ' + CAST(@nSuccess AS VARCHAR(10)) + ', Failed: ' + CAST(@nFailed AS VARCHAR(10)) + ', Skipped: ' + CAST(@nSkipped AS VARCHAR(10))
			+ '. Duration: ' + CAST(@Duration AS VARCHAR(10)) + ' (sec)'
	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
END
DECLARE @param_useSurveyResultsToUpdate INT = 0
SELECT  @param_useSurveyResultsToUpdate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'useSurveyResultsToUpdate'
IF @param_useSurveyResultsToUpdate = 1
	BEGIN
	IF OBJECT_ID('tempdb.DBO.#SurveyResultsToUpdate') IS NOT NULL DROP TABLE #SurveyResultsToUpdate
	       CREATE TABLE #SurveyResultsToUpdate (logdateUTC DATETIME ,CommcellIdNameMap_ID  int , queryid INT, lastlatestlogdateUTC DATETIME )
		INSERT  INTO #SurveyResultsToUpdate
			SELECT  max(A.LogDateUTC),A.CommcellIdNameMap_ID, A.QueryId,0
		FROM cf_CommservSurveyResults A
			WHERE a.CommcellIdNameMap_ID =@CSUniqueId AND A.Flags =0 and a.ShredStatus = 2
		GROUP BY A.CommcellIdNameMap_ID, A.QueryId
		UPDATE  T SET T.lastlatestlogdateUTC =R.logdateUTC
			FROM    #SurveyResultsToUpdate T
		INNER JOIN cf_CommservSurveyResults R
		ON  R.QueryId=T.queryid and R.CommcellIdNameMap_ID=T.CommcellIdNameMap_ID
		WHERE R.Flags =1
	 BEGIN TRANSACTION
			UPDATE  R SET R.Flags =0
			FROM    cf_CommservSurveyResults R
			INNER JOIN #SurveyResultsToUpdate T
			ON   R.LogDateUTC = T.lastlatestlogdateUTC and R.QueryId=T.queryid and R.CommcellIdNameMap_ID=T.CommcellIdNameMap_ID
				where R.Flags =1 AND T.lastlatestlogdateUTC<T.logdateUTC
			UPDATE  R SET R.Flags =1
			FROM    cf_CommservSurveyResults R
			INNER JOIN #SurveyResultsToUpdate T
			ON   R.LogDateUTC = T.logdateUTC and R.QueryId=T.queryid and R.CommcellIdNameMap_ID=T.CommcellIdNameMap_ID
			WHERE R.Flags =0 AND T.lastlatestlogdateUTC<T.logdateUTC AND R.ShredStatus = 2
	SELECT @ErrCode = @@ERROR
	 IF @ErrCode = 0
	        COMMIT TRANSACTION
	 ELSE
	    BEGIN
	        ROLLBACK TRANSACTION
	        SET @LogString  = 'UPDATE CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ' - Failed with error :: ' + ERROR_MESSAGE()
	        INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString)
	 	END
	 END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCollectedResultsForSurvey')
	delete from GxQscripts where name = 'ParseCollectedResultsForSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCollectedResultsForSurvey')
	delete from GXDBVersions where aliasname = 'ParseCollectedResultsForSurvey'
GO

insert into GXDBVersions values(2, 'ParseCollectedResultsForSurvey',  'v1.7.60.13.4.1', 'ParseCollectedResultsForSurvey', 'v1.7.60.13.4.1')
GO

