

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseClientGroups.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseClientGroups.sp,v $ $Id: ParseClientGroups.sp,v 1.1.2.10 2020/12/17 02:52:53 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseClientGroups')
BEGIN
	print '>>> Drop Stored Procedure: ParseClientGroups <<<'
	drop procedure ParseClientGroups
END
IF EXISTS (select * from GxQscripts where name='ParseClientGroups')
	delete from GxQscripts where name = 'ParseClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientGroups')
	delete from GXDBVersions where aliasname = 'ParseClientGroups'
GO
print '... Creating Procedure: ParseClientGroups'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseClientGroups
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseClientGroupsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #ClientGroupOld
(
	CommservUniqueId	INT,
	ClientGroupId		INT,
	ClientGroupName		NVARCHAR(512),
	AddedDate			DATETIME NULL,
	DeletedDate			DATETIME NULL,
	ClientGroupFlag		INT,
	TenantName			NVARCHAR(256),
	UpdateFlag			INT NULL
)
CREATE TABLE #ClientGroupNew
(
	CommservUniqueId	INT,
	ClientGroupId		INT,
	ClientGroupName		NVARCHAR(512),
	AddedDate			DATETIME NULL,
	DeletedDate			DATETIME,
	ClientGroupFlag		INT,
	TenantName			NVARCHAR(256),
	UpdateFlag			INT NULL
)
CREATE TABLE #ClientGroupAssociationOld
(
	CommservUniqueId	INT,
	ClientGroupId		INT,
	ClientId			INT,
	DeletedDate			DATETIME
)
CREATE TABLE #ClientGroupAssociationNew
(
	CommservUniqueId	INT,
	ClientGroupId		INT,
	ClientId			INT
)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #ClientGroupNew (
		CommservUniqueId, ClientGroupId, ClientGroupName, AddedDate, ClientGroupFlag, TenantName)
	SELECT
		@CSUniqueId,
		csInfo.n.value('@clientGroupId','INT'),
		csInfo.n.value('@clientGroupName','NVARCHAR(512)'),
		@LogDate,
		ISNULL(csInfo.n.value('@flag','INT'), 0),
		ISNULL(csInfo.n.value('@tenantName','NVARCHAR(256)'), '')
	FROM
		@ResultXml.nodes('ClientGroupAssociation/ClientGroup') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #ClientGroupAssociationNew (
		CommservUniqueId, ClientGroupId, ClientId)
	SELECT
		@CSUniqueId,
		csInfo.n.value('@clientGroupId','INT'),
		csInfo.n.value('@clientId','INT')
	FROM
		@ResultXml.nodes('ClientGroupAssociation/Association') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT	INTO #ClientGroupOld (
			CommservUniqueId, ClientGroupId, ClientGroupName, AddedDate, DeletedDate, ClientGroupFlag, TenantName)
	SELECT	CommservUniqueId, ClientGroupId, ClientGroupName, AddedDate, DeletedDate, ClientGroupFlag, TenantName
	FROM	cf_SurveyClientGroup
	WHERE	CommservUniqueId = @CSUniqueId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	O SET ClientGroupName = N.ClientGroupName, DeletedDate = NULL,
			ClientGroupFlag = N.ClientGroupFlag, TenantName = N.TenantName, UpdateFlag = 2
	FROM	#ClientGroupOld AS O
			INNER JOIN #ClientGroupNew AS N
		 ON N.CommservUniqueId = O.CommservUniqueId AND N.ClientGroupId = O.ClientGroupId
	WHERE	O.ClientGroupName <> N.ClientGroupName OR O.DeletedDate IS NOT NULL
			OR ISNULL(O.ClientGroupFlag,0) <> N.ClientGroupFlag
			OR ISNULL(O.TenantName,'') <> N.TenantName
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	O SET UpdateFlag = 1
	FROM	#ClientGroupOld AS O
			INNER JOIN #ClientGroupNew AS N
		 ON N.CommservUniqueId = O.CommservUniqueId AND N.ClientGroupId = O.ClientGroupId
	WHERE	O.UpdateFlag IS NULL
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	N
	FROM	#ClientGroupNew AS N
			INNER JOIN #ClientGroupOld AS O
		 ON N.CommservUniqueId = O.CommservUniqueId AND N.ClientGroupId = O.ClientGroupId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	#ClientGroupOld SET DeletedDate = @LogDate, UpdateFlag = 2
	WHERE	DeletedDate IS NULL AND UpdateFlag IS NULL
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	#ClientGroupOld
	WHERE	ISNULL(UpdateFlag, 0) <> 2
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT * FROM #ClientGroupAssociationNew)
BEGIN
	INSERT INTO #ClientGroupAssociationOld (
			CommservUniqueId, ClientGroupId, ClientId, DeletedDate)
	SELECT	O.CommservUniqueId, O.ClientGroupId, O.ClientId, CASE WHEN O.DeletedDate IS NULL THEN @LogDate ELSE NULL END
	FROM	cf_SurveyClientGroupAssociation O
			LEFT OUTER JOIN #ClientGroupAssociationNew N
		 ON N.CommservUniqueId = O.CommservUniqueId AND N.ClientGroupId = O.ClientGroupId AND N.ClientId = O.ClientId
	WHERE	O.CommservUniqueId = @CSUniqueId AND (N.ClientId IS NULL AND O.DeletedDate IS NULL OR N.ClientId IS NOT NULL AND O.DeletedDate IS NOT NULL)
	SELECT @ErrorCode = @@ERROR
	IF 	@ErrorCode = 0
	BEGIN
		DELETE	N
		FROM	#ClientGroupAssociationNew N
				INNER JOIN cf_SurveyClientGroupAssociation AS CGA
			 ON CGA.CommservUniqueId = N.CommservUniqueId AND CGA.ClientGroupId = N.ClientGroupId AND CGA.ClientId = N.ClientId
		SELECT @ErrorCode = @@ERROR
	END
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT ClientGroupId FROM #ClientGroupOld)
BEGIN
	UPDATE	CG SET ClientGroupName = O.ClientGroupName, DeletedDate = O.DeletedDate,
			ClientGroupFlag = O.ClientGroupFlag, TenantName = O.TenantName
	FROM	cf_SurveyClientGroup AS CG
			INNER JOIN #ClientGroupOld AS O
		 ON CG.CommservUniqueId = O.CommservUniqueId AND CG.ClientGroupId = O.ClientGroupId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT ClientGroupId FROM #ClientGroupNew)
BEGIN
	INSERT	INTO cf_SurveyClientGroup (
			CommservUniqueId, ClientGroupId, ClientGroupName, AddedDate, DeletedDate, TenantName)
	SELECT	CommservUniqueId, ClientGroupId, ClientGroupName, AddedDate, DeletedDate, TenantName
	FROM	#ClientGroupNew
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT ClientId FROM #ClientGroupAssociationOld)
BEGIN
	UPDATE	CGA SET DeletedDate = O.DeletedDate
	FROM	cf_SurveyClientGroupAssociation AS CGA
			INNER JOIN #ClientGroupAssociationOld AS O
		 ON CGA.CommservUniqueId = O.CommservUniqueId AND CGA.ClientGroupId = O.ClientGroupId AND CGA.ClientId = O.ClientId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT ClientId FROM #ClientGroupAssociationNew)
BEGIN
	INSERT	INTO cf_SurveyClientGroupAssociation (
			CommservUniqueId, ClientGroupId, ClientId, AddedDate, DeletedDate)
	SELECT	CommservUniqueId, ClientGroupId, ClientId, @LogDate, NULL
	FROM	#ClientGroupAssociationNew
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(MAX))
	INSERT INTO #ClientGroupsString
	SELECT DISTINCT CommservUniqueId, ClientId, N'' FROM #ClientGroupAssociationNew
	UNION
	SELECT DISTINCT CommservUniqueId, ClientId, N'' FROM #ClientGroupAssociationOld
IF EXISTS (SELECT 1 FROM #ClientGroupsString)
BEGIN
	EXEC GetClientGroupsString @CSUniqueId
	UPDATE C
	SET C.ClientGroups = CG.ClientGroups
	FROM cf_SurveyClient C
	INNER JOIN #ClientGroupsString CG ON C.CommServUniqueId = CG.CommservUniqueId AND C.ClientId = CG.ClientId
	WHERE C.CommServUniqueID = @CSUniqueId
END
	DROP TABLE #ClientGroupsString
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseClientGroupsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseClientGroups')
	delete from GxQscripts where name = 'ParseClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseClientGroups')
	delete from GXDBVersions where aliasname = 'ParseClientGroups'
GO

insert into GXDBVersions values(2, 'ParseClientGroups',  '00010001000200100000', 'ParseClientGroups', '00010001000200100000')
GO

