

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCapacityUsageHistory.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCapacityUsageHistory.sp,v $ $Id: ParseCapacityUsageHistory.sp,v 1.5.2.16 2020/12/17 02:50:59 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseCapacityUsageHistory')
BEGIN
	print '>>> Drop Stored Procedure: ParseCapacityUsageHistory <<<'
	drop procedure ParseCapacityUsageHistory
END
IF EXISTS (select * from GxQscripts where name='ParseCapacityUsageHistory')
	delete from GxQscripts where name = 'ParseCapacityUsageHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCapacityUsageHistory')
	delete from GXDBVersions where aliasname = 'ParseCapacityUsageHistory'
GO
print '... Creating Procedure: ParseCapacityUsageHistory'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseCapacityUsageHistory
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
CREATE TABLE #CommCellCapacityUsage
(
	CommservUniqueId	INT,
	AsOfDate			DATETIME NOT NULL,
	BackupSizeMB		BIGINT NULL,
	ArchiveSizeMB		BIGINT NULL,
	SnapshotSizeMB		BIGINT NULL,
	ReplicationSizeMB	BIGINT NULL
)
CREATE TABLE #CapacityUsageHistory
(
	SurveyResultId		BIGINT,
	Month				DATETIME,
	EnterpriseBackupSizeMB	BIGINT,
	CoreBackupSizeMB	BIGINT,
	EnterpriseArchiveSizeMB	BIGINT,
	CoreArchiveSizeMB	BIGINT,
	SnapSizeMB			BIGINT,
	ReplicationSizeMB	BIGINT
)
CREATE TABLE #SurveyAgentSize
(
	SurveyResultId		BIGINT,
	AppTypeId			INT,
	AgentName			VARCHAR(256),
	AppSizeMB			BIGINT,
	SizeOnMediaMB		BIGINT,
	NumOfClients		INT
)
CREATE TABLE #SurveyClientGroupSize
(
	SurveyResultId		BIGINT,
	ClientGroupId		INT,
	AppSizeMB			BIGINT,
	SizeOnMediaMB		BIGINT,
	NumOfClients		INT
)
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCapacityUsageHistoryTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
DECLARE @MonthStart DATETIME = DATEADD(MONTH, DATEDIFF(MONTH, 0, @LogDate), 0)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #CommCellCapacityUsage (
			CommservUniqueId, AsOfDate, BackupSizeMB, ArchiveSizeMB, SnapshotSizeMB, ReplicationSizeMB)
	SELECT DISTINCT
			@CSUniqueId,
			csInfo.n.value('@AsOfDate', 'DATETIME'),
			csInfo.n.value('@BackupSizeMB', 'BIGINT'),
			csInfo.n.value('@ArchiveSizeMB', 'BIGINT'),
			csInfo.n.value('@SnapshotSizeMB', 'BIGINT'),
			csInfo.n.value('@ReplicationSizeMB', 'BIGINT')
	FROM
		@ResultXml.nodes('CommCellCapacityUsage') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	#CommCellCapacityUsage
	FROM	#CommCellCapacityUsage T INNER JOIN cf_SurveyCommCellCapacityUsage U
			ON U.CommservUniqueId = @CSUniqueId AND T.AsOfDate = U.AsOfDate
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #CapacityUsageHistory (
		SurveyResultId, Month, EnterpriseBackupSizeMB, CoreBackupSizeMB, EnterpriseArchiveSizeMB, CoreArchiveSizeMB, SnapSizeMB, ReplicationSizeMB)
	SELECT
		@ResultId,
		csInfo.n.value('@Month','DATETIME'),
		csInfo.n.value('@EnterpriseBackupSizeMB','BIGINT'),
		csInfo.n.value('@CoreBackupSizeMB','BIGINT'),
		csInfo.n.value('@EnterpriseArchiveSizeMB','BIGINT'),
		csInfo.n.value('@CoreArchiveSizeMB','BIGINT'),
		csInfo.n.value('@SnapSizeMB','BIGINT'),
		csInfo.n.value('@ReplicationSizeMB','BIGINT')
	FROM
		@ResultXml.nodes('CapacityUsageHistory') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0 AND EXISTS (SELECT a.n.value('@AppTypeId','INT') FROM @ResultXml.nodes('AgentDataSize') AS a(n))
BEGIN
	INSERT INTO #SurveyAgentSize (
		SurveyResultId, AppTypeId, AgentName, AppSizeMB, SizeOnMediaMB, NumOfClients)
	SELECT
		@ResultId,
		csInfo.n.value('@AppTypeId','INT'),
		csInfo.n.value('@AppTypeName','VARCHAR(256)'),
		ISNULL(csInfo.n.value('@AppSizeMB','BIGINT'), 0),
		ISNULL(csInfo.n.value('@SizeOnMediaMB','BIGINT'), 0),
		ISNULL(csInfo.n.value('@NumOfClients','INT'), 0)
	FROM
		@ResultXml.nodes('AgentDataSize') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT a.n.value('@ClientGroupId','INT') FROM @ResultXml.nodes('ClientGroupDataSize') AS a(n))
BEGIN
	INSERT INTO #SurveyClientGroupSize (
		SurveyResultId, ClientGroupId, AppSizeMB, SizeOnMediaMB, NumOfClients)
	SELECT
		@ResultId,
		csInfo.n.value('@ClientGroupId','INT'),
		ISNULL(csInfo.n.value('@AppSizeMB','BIGINT'), 0),
		ISNULL(csInfo.n.value('@SizeOnMediaMB','BIGINT'), 0),
		ISNULL(csInfo.n.value('@NumOfClients','INT'), 0)
	FROM
		@ResultXml.nodes('ClientGroupDataSize') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyCommCellCapacityUsage (
			CommservUniqueId, AsOfDate, BackupSizeMB, ArchiveSizeMB, SnapshotSizeMB, ReplicationSizeMB)
	SELECT	CommservUniqueId, AsOfDate, BackupSizeMB, ArchiveSizeMB, SnapshotSizeMB, ReplicationSizeMB
	FROM	#CommCellCapacityUsage
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyCapacityUsageHistory (
			SurveyResultId, Month, EnterpriseBackupSizeMB, CoreBackupSizeMB, EnterpriseArchiveSizeMB, CoreArchiveSizeMB, SnapSizeMB, ReplicationSizeMB)
	SELECT	SurveyResultId, Month, EnterpriseBackupSizeMB, CoreBackupSizeMB, EnterpriseArchiveSizeMB, CoreArchiveSizeMB, SnapSizeMB, ReplicationSizeMB
	FROM	#CapacityUsageHistory
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	MERGE cf_SurveyCapacityLicensePeakUsage S
	USING
		(SELECT @CSUniqueId AS CommServUniqueId,
				Month AS MonthStart,
				MAX(EnterpriseBackupSizeMB + CoreBackupSizeMB) AS BackupSize,
				MAX(EnterpriseArchiveSizeMB + CoreArchiveSizeMB) AS ArchiveSize,
				MAX(SnapSizeMB) AS SnapshotSize,
				MAX(ReplicationSizeMB) AS ReplicationSize
			FROM	cf_SurveyCapacityUsageHistory
			WHERE SurveyResultId = @ResultId
			GROUP BY Month
		) T ON T.CommServUniqueId = S.CommServUniqueId AND T.MonthStart = S.MonthStart
	WHEN MATCHED AND (S.BackupSize <> T.BackupSize OR S.ArchiveSize <> T.ArchiveSize OR S.SnapshotSize <> T.SnapshotSize OR S.ReplicationSize <> T.ReplicationSize) THEN
			UPDATE SET BackupSize = T.BackupSize, ArchiveSize = T.ArchiveSize, SnapshotSize = T.SnapshotSize, ReplicationSize = T.ReplicationSize
	WHEN NOT MATCHED THEN
			INSERT (CommServUniqueId, MonthStart, BackupSize, ArchiveSize, SnapshotSize, ReplicationSize)
			VALUES (T.CommServUniqueId, T.MonthStart, T.BackupSize, T.ArchiveSize, T.SnapshotSize, T.ReplicationSize);
	SELECT @ErrorCode = @@ERROR
END
IF EXISTS (SELECT 1 FROM #SurveyAgentSize)
BEGIN
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO cf_SurveyAgentSize (
				SurveyResultId, AppTypeId, AgentName, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT	SurveyResultId, AppTypeId, AgentName, AppSizeMB, SizeOnMediaMB, NumOfClients
		FROM	#SurveyAgentSize
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO cf_SurveyAgentSize (
			SurveyResultId, AppTypeId, AgentName, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT
			@ResultId, 0, '', SUM(AppSizeMB), SUM(SizeOnMediaMB), SUM(NumOfClients)
		FROM
			cf_SurveyAgentSize
		WHERE
			SurveyResultId = @ResultId
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		UPDATE cf_SurveyAgentPeakSize
		SET	AppSizeMB = CASE WHEN S.AppSizeMB > P.AppSizeMB THEN S.AppSizeMB ELSE P.AppSizeMB END,
			SizeOnMediaMB = CASE WHEN S.SizeOnMediaMB > P.SizeOnMediaMB THEN S.SizeOnMediaMB ELSE P.SizeOnMediaMB END,
			NumOfClients = CASE WHEN S.NumOfClients > P.NumOfClients THEN S.NumOfClients ELSE P.NumOfClients END
		FROM
			cf_SurveyAgentSize S
			INNER JOIN cf_SurveyAgentPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.AppTypeId = S.AppTypeId AND P.AgentName = S.AgentName
		WHERE
			S.SurveyResultId = @ResultId
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO cf_SurveyAgentPeakSize (
			CommServUniqueId, MonthStart, AppTypeId, AgentName, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT
			@CSUniqueId, @MonthStart, S.AppTypeId, S.AgentName, MAX(S.AppSizeMB), MAX(S.SizeOnMediaMB), MAX(S.NumOfClients)
		FROM
			cf_SurveyAgentSize S
			LEFT OUTER JOIN cf_SurveyAgentPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.AppTypeId = S.AppTypeId AND P.AgentName = S.AgentName
		WHERE
			S.SurveyResultId = @ResultId AND P.MonthStart IS NULL
		GROUP BY S.AppTypeId, S.AgentName
		SELECT @ErrorCode = @@ERROR
	END
END
IF EXISTS (SELECT 1 FROM #SurveyClientGroupSize)
BEGIN
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO cf_SurveyClientGroupSize (
				SurveyResultId, ClientGroupId, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT	SurveyResultId, ClientGroupId, AppSizeMB, SizeOnMediaMB, NumOfClients
		FROM	#SurveyClientGroupSize
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		UPDATE cf_SurveyClientGroupPeakSize
		SET	AppSizeMB = CASE WHEN S.AppSizeMB > P.AppSizeMB THEN S.AppSizeMB ELSE P.AppSizeMB END,
			SizeOnMediaMB = CASE WHEN S.SizeOnMediaMB > P.SizeOnMediaMB THEN S.SizeOnMediaMB ELSE P.SizeOnMediaMB END,
			NumOfClients = CASE WHEN S.NumOfClients > P.NumOfClients THEN S.NumOfClients ELSE P.NumOfClients END
		FROM
			cf_SurveyClientGroupSize S
			INNER JOIN cf_SurveyClientGroupPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.ClientGroupId = S.ClientGroupId
		WHERE
			S.SurveyResultId = @ResultId
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		INSERT INTO cf_SurveyClientGroupPeakSize (
			CommServUniqueId, MonthStart, ClientGroupId, AppSizeMB, SizeOnMediaMB, NumOfClients)
		SELECT
			@CSUniqueId, @MonthStart, S.ClientGroupId, MAX(S.AppSizeMB), MAX(S.SizeOnMediaMB), MAX(S.NumOfClients)
		FROM
			cf_SurveyClientGroupSize S
			LEFT OUTER JOIN cf_SurveyClientGroupPeakSize P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.ClientGroupId = S.ClientGroupId
		WHERE
			S.SurveyResultId = @ResultId AND P.MonthStart IS NULL
		GROUP BY S.ClientGroupId
		SELECT @ErrorCode = @@ERROR
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCapacityUsageHistoryTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCapacityUsageHistory')
	delete from GxQscripts where name = 'ParseCapacityUsageHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCapacityUsageHistory')
	delete from GXDBVersions where aliasname = 'ParseCapacityUsageHistory'
GO

insert into GXDBVersions values(2, 'ParseCapacityUsageHistory',  '00010005000200160000', 'ParseCapacityUsageHistory', '00010005000200160000')
GO

