

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCCRTapeLibrary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCCRTapeLibrary.sp,v $ $Id: ParseCCRTapeLibrary.sp,v 1.1.2.6 2018/12/27 18:52:53 vikashkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParseCCRTapeLibrary')
BEGIN
	print '>>> Drop Stored Procedure: ParseCCRTapeLibrary <<<'
	drop procedure ParseCCRTapeLibrary
END
IF EXISTS (select * from GxQscripts where name='ParseCCRTapeLibrary')
	delete from GxQscripts where name = 'ParseCCRTapeLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRTapeLibrary')
	delete from GXDBVersions where aliasname = 'ParseCCRTapeLibrary'
GO
print '... Creating Procedure: ParseCCRTapeLibrary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCCRTapeLibrary
  @CSUID INT,
  @UpdateTime DATETIME,
  @FullFileName VARCHAR(1024),
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
--   BULK INSERT from a csv file
-------------------------------------------------------------------------------
	SET NOCOUNT ON
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parsing CCRTapeLibrary'
	IF @isPrintOn = 1 PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	DECLARE @ProcessSurveyResultTran INT = 0
	IF OBJECT_ID('tempdb..#TempCCRTapeLibrary') IS NOT NULL DROP TABLE #TempCCRTapeLibrary
	CREATE TABLE #TempCCRTapeLibrary
	(
		Library nvarchar(256),
		ScratchPool nvarchar(512),
		NumberOfSpares int,
		LowWatermark int
	)
	DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #TempCCRTapeLibrary FROM ''' + @FullFileName + ''' WITH (FIRSTROW = 2, FIELDTERMINATOR ='','', ROWTERMINATOR ='',\n'' )';
	BEGIN TRY
		EXEC(@sql);
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRTapeLibrary - BULK INSERT failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF @ErrorCode = 0
	BEGIN
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		DELETE FROM CCRTapeLibrary WHERE CommservUniqueId = @CSUID AND UpdateTime <= @UpdateTime
		IF EXISTS (SELECT * FROM #TempCCRTapeLibrary)
		BEGIN
			INSERT INTO CCRTapeLibrary (CommservUniqueId, UpdateTime, Library, ScratchPool, NumberOfSpares, LowWatermark)
			SELECT	@CSUID, @UpdateTime, Library, ScratchPool, NumberOfSpares, LowWatermark FROM #TempCCRTapeLibrary
		END
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			IF (@ProcessSurveyResultTran = 1)
			BEGIN
				ROLLBACK TRANSACTION ProcessSurveyResultTran
				SET @ProcessSurveyResultTran = 0
			END
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRTapeLibrary - INSERT INTO CCRTapeLibrary failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		IF @isPrintOn = 1 PRINT @ErrorString
			INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END
	DROP TABLE #TempCCRTapeLibrary
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCCRTapeLibrary')
	delete from GxQscripts where name = 'ParseCCRTapeLibrary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRTapeLibrary')
	delete from GXDBVersions where aliasname = 'ParseCCRTapeLibrary'
GO

insert into GXDBVersions values(2, 'ParseCCRTapeLibrary',  '00010001000200060000', 'ParseCCRTapeLibrary', '00010001000200060000')
GO

