

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCCRNetwork.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCCRNetwork.sp,v $ $Id: ParseCCRNetwork.sp,v 1.1.2.6 2018/12/27 18:58:08 vikashkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParseCCRNetwork')
BEGIN
	print '>>> Drop Stored Procedure: ParseCCRNetwork <<<'
	drop procedure ParseCCRNetwork
END
IF EXISTS (select * from GxQscripts where name='ParseCCRNetwork')
	delete from GxQscripts where name = 'ParseCCRNetwork'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRNetwork')
	delete from GXDBVersions where aliasname = 'ParseCCRNetwork'
GO
print '... Creating Procedure: ParseCCRNetwork'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCCRNetwork
  @CSUID INT,
  @UpdateTime DATETIME,
  @FullFileName VARCHAR(1024),
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
--   BULK INSERT from a csv file
-------------------------------------------------------------------------------
	SET NOCOUNT ON
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parsing CCRNetwork'
	IF @isPrintOn = 1 PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	DECLARE @ProcessSurveyResultTran INT = 0
	IF OBJECT_ID('tempdb..#TempCCRNetwork') IS NOT NULL DROP TABLE #TempCCRNetwork
	CREATE TABLE #TempCCRNetwork
	(
		Client nvarchar(256),
		Agent nvarchar(256),
		Instance nvarchar(256),
		BackupSet nvarchar(256),
		Subclient nvarchar(512),
		StoragePolicy nvarchar(256),
		CopyType nvarchar(256),
		DDBInformation nvarchar(256) NULL,
		IsDefaultDataPath nvarchar(256),
		MediaAgent nvarchar(256),
		Library nvarchar(256),
		MasterDrivePool nvarchar(256),
		DrivePool nvarchar(256),
		MediaAgentInterface nvarchar(256),
		ClientInterface nvarchar(256),
		ReadinessStatus nvarchar(2048)
	)
	DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #TempCCRNetwork FROM ''' + @FullFileName + ''' WITH (FIRSTROW = 2, FIELDTERMINATOR ='','', ROWTERMINATOR ='',\n'' )';
	BEGIN TRY
		EXEC(@sql);
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRNetwork - BULK INSERT failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF @ErrorCode = 0
	BEGIN
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		DELETE FROM CCRNetwork WHERE CommservUniqueId = @CSUID AND UpdateTime <= @UpdateTime
		IF EXISTS (SELECT * FROM #TempCCRNetwork)
		BEGIN
			INSERT INTO CCRNetwork (
				CommservUniqueId,
				UpdateTime,
				Client,
				Agent,
				Instance,
				BackupSet,
				Subclient,
				StoragePolicy,
				CopyType,
				DDBInformation,
				IsDefaultDataPath,
				MediaAgent,
				Library,
				MasterDrivePool,
				DrivePool,
				MediaAgentInterface,
				ClientInterface,
				ReadinessStatus
				)
			SELECT
				@CSUID,
				@UpdateTime,
				Client,
				Agent,
				Instance,
				BackupSet,
				Subclient,
				StoragePolicy,
				CopyType,
				DDBInformation,
				IsDefaultDataPath,
				MediaAgent,
				Library,
				MasterDrivePool,
				DrivePool,
				MediaAgentInterface,
				ClientInterface,
				ReadinessStatus
			FROM #TempCCRNetwork
		END
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			IF (@ProcessSurveyResultTran = 1)
			BEGIN
				ROLLBACK TRANSACTION ProcessSurveyResultTran
				SET @ProcessSurveyResultTran = 0
			END
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRNetwork - INSERT INTO CCRNetwork failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		IF @isPrintOn = 1 PRINT @ErrorString
			INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END
	DROP TABLE #TempCCRNetwork
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCCRNetwork')
	delete from GxQscripts where name = 'ParseCCRNetwork'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRNetwork')
	delete from GXDBVersions where aliasname = 'ParseCCRNetwork'
GO

insert into GXDBVersions values(2, 'ParseCCRNetwork',  '00010001000200060000', 'ParseCCRNetwork', '00010001000200060000')
GO

