

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseCCRIndexCache.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseCCRIndexCache.sp,v $ $Id: ParseCCRIndexCache.sp,v 1.1.2.6 2018/12/27 18:54:53 vikashkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParseCCRIndexCache')
BEGIN
	print '>>> Drop Stored Procedure: ParseCCRIndexCache <<<'
	drop procedure ParseCCRIndexCache
END
IF EXISTS (select * from GxQscripts where name='ParseCCRIndexCache')
	delete from GxQscripts where name = 'ParseCCRIndexCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRIndexCache')
	delete from GXDBVersions where aliasname = 'ParseCCRIndexCache'
GO
print '... Creating Procedure: ParseCCRIndexCache'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParseCCRIndexCache
  @CSUID INT,
  @UpdateTime DATETIME,
  @FullFileName VARCHAR(1024),
  @ErrorCode INTEGER OUTPUT,
  @ErrorString NVARCHAR(MAX) OUTPUT,
  @isPrintOn INTEGER = 0
AS
-------------------------------------------------------------------------------
--   BULK INSERT from a csv file
-------------------------------------------------------------------------------
	SET NOCOUNT ON
	SELECT @ErrorCode = 0
	SELECT @ErrorString = 'Parsing CCRIndexCache'
	IF @isPrintOn = 1 PRINT @ErrorString
	INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
	DECLARE @ProcessSurveyResultTran INT = 0
	IF OBJECT_ID('tempdb..#TempCCRIndexCache') IS NOT NULL DROP TABLE #TempCCRIndexCache
	CREATE TABLE #TempCCRIndexCache
	(
		MediaAgent nvarchar(256),
		IndexCache nvarchar(256),
		ReadinessStatus nvarchar(2048)
	)
	DECLARE @sql NVARCHAR(2000) = 'BULK INSERT #TempCCRIndexCache FROM ''' + @FullFileName + ''' WITH (FIRSTROW = 2, FIELDTERMINATOR ='','', ROWTERMINATOR ='',\n'' )';
	BEGIN TRY
		EXEC(@sql);
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRIndexCache - BULK INSERT failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF @ErrorCode = 0
	BEGIN
	BEGIN TRY
		IF (@@TRANCOUNT = 0)
		BEGIN
			BEGIN TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 1
		END
		DELETE FROM CCRIndexCache WHERE CommservUniqueId = @CSUID AND UpdateTime <= @UpdateTime
		IF EXISTS (SELECT * FROM #TempCCRIndexCache)
		BEGIN
			INSERT INTO CCRIndexCache (CommservUniqueId, UpdateTime, MediaAgent, IndexCache, ReadinessStatus)
			SELECT	@CSUID, @UpdateTime, MediaAgent, IndexCache, ReadinessStatus FROM #TempCCRIndexCache
		END
		IF (@ProcessSurveyResultTran = 1)
		BEGIN
			COMMIT TRANSACTION ProcessSurveyResultTran
			SET @ProcessSurveyResultTran = 0
		END
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		IF (XACT_STATE() <> 0)
		BEGIN
			IF (@ProcessSurveyResultTran = 1)
			BEGIN
				ROLLBACK TRANSACTION ProcessSurveyResultTran
				SET @ProcessSurveyResultTran = 0
			END
			SELECT @ErrorCode = 1
			SELECT @ErrorString = 'CCRIndexCache - INSERT INTO CCRIndexCache failed with error :: ' + ERROR_MESSAGE()
		END
	END CATCH
	IF  @ErrorCode <> 0
	BEGIN
		IF @isPrintOn = 1 PRINT @ErrorString
			INSERT INTO cf_SurveyLogger(Message) VALUES(@ErrorString)
		END
	END
	DROP TABLE #TempCCRIndexCache
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseCCRIndexCache')
	delete from GxQscripts where name = 'ParseCCRIndexCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseCCRIndexCache')
	delete from GXDBVersions where aliasname = 'ParseCCRIndexCache'
GO

insert into GXDBVersions values(2, 'ParseCCRIndexCache',  '00010001000200060000', 'ParseCCRIndexCache', '00010001000200060000')
GO

