

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseAgentCapacityLicenseSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseAgentCapacityLicenseSurvey.sp,v $ $Id: ParseAgentCapacityLicenseSurvey.sp,v 1.7.2.12 2020/12/17 02:49:26 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseAgentCapacityLicenseSurvey')
BEGIN
	print '>>> Drop Stored Procedure: ParseAgentCapacityLicenseSurvey <<<'
	drop procedure ParseAgentCapacityLicenseSurvey
END
IF EXISTS (select * from GxQscripts where name='ParseAgentCapacityLicenseSurvey')
	delete from GxQscripts where name = 'ParseAgentCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseAgentCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'ParseAgentCapacityLicenseSurvey'
GO
print '... Creating Procedure: ParseAgentCapacityLicenseSurvey'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseAgentCapacityLicenseSurvey
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseAgentCapacityLicenseTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
DECLARE @MonthStart DATETIME = DATEADD(MONTH, DATEDIFF(MONTH, 0, @LogDate), 0)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyAgentLicenseUsage (
		SurveyResultId, TypeId, TypeName,
		PermLicensesIssued, PermLicensesAvailable, PermLicensesUsed,
		EvalLicensesIssued, EvalLicensesAvailable, EvalLicensesUsed, EvalLicenseExpiryDate
		)
	SELECT
		@ResultId,
		csInfo.n.value('@Type', 'INTEGER'),
		csInfo.n.value('@Name', 'VARCHAR(1024)'),
		csInfo.n.value('@PermLicensesIssued', 'INTEGER'),
		csInfo.n.value('@PermLicensesAvailable', 'INTEGER'),
		CASE
			WHEN csInfo.n.value('@PermLicensesUsed', 'INTEGER') IS NOT NULL THEN csInfo.n.value('@PermLicensesUsed', 'INTEGER')
			WHEN csInfo.n.value('@PermLicensesUsed', 'INTEGER') IS NULL AND csInfo.n.value('@PermLicensesIssued', 'INTEGER') = -1 THEN 0
			ELSE csInfo.n.value('@PermLicensesIssued', 'INTEGER') - csInfo.n.value('@PermLicensesAvailable', 'INTEGER')
		END,
		csInfo.n.value('@EvalLicensesIssued', 'INTEGER'),
		csInfo.n.value('@EvalLicensesAvailable', 'INTEGER'),
		CASE
			WHEN csInfo.n.value('@EvalLicensesUsed', 'INTEGER') IS NOT NULL THEN csInfo.n.value('@EvalLicensesUsed', 'INTEGER')
			WHEN csInfo.n.value('@EvalLicensesUsed', 'INTEGER') IS NULL AND csInfo.n.value('@EvalLicensesIssued', 'INTEGER') = -1 THEN 0
			ELSE csInfo.n.value('@EvalLicensesIssued', 'INTEGER') - csInfo.n.value('@EvalLicensesAvailable', 'INTEGER')
		END,
		csInfo.n.value('@EvalLicenseExpiryDate', 'DATETIME')
	FROM
		@ResultXml.nodes('/AgentCapacityLicenseUsage') AS csInfo(n)
	WHERE
		csInfo.n.value('@IsLicType', 'INTEGER') = 1
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyAgentCapacityUsage (
		SurveyResultId, TypeId, TypeName,
		BackupSize, ArchiveSize, SnapshotSize, ReplicationSize, UsedAgents, LicType, Flag
		)
	SELECT
		S.SurveyResultId, S.TypeId, S.TypeName,
		MAX(BackupSize), MAX(ArchiveSize), MAX(SnapshotSize), MAX(ReplicationSize), MAX(UsedAgents), S.LicType, MAX(S.Flag)
	FROM
		(SELECT
			@ResultId AS SurveyResultId,
			csInfo.n.value('@Type', 'INTEGER') AS TypeId,
			csInfo.n.value('@Name', 'VARCHAR(1024)') AS TypeName,
			ISNULL(csInfo.n.value('@UsedBackupSize', 'BIGINT'), 0) AS BackupSize,
			ISNULL(csInfo.n.value('@UsedArchiveSize', 'BIGINT'), 0) AS ArchiveSize,
			ISNULL(csInfo.n.value('@UsedSnapSize', 'BIGINT'), 0) AS SnapshotSize,
			ISNULL(csInfo.n.value('@UsedReplicationSize', 'BIGINT'), 0) AS ReplicationSize,
			ISNULL(csInfo.n.value('@UsedAgents', 'INTEGER'), 0) AS UsedAgents,
			ISNULL(csInfo.n.value('@LicType', 'INTEGER'), 0) AS LicType,
			ISNULL(csInfo.n.value('@Flag', 'INTEGER'), 0) AS Flag
		FROM
			@ResultXml.nodes('/AgentCapacityLicenseUsage') AS csInfo(n)
		WHERE
			csInfo.n.value('@IsLicType', 'INTEGER') = 0
		) S
	GROUP BY S.SurveyResultId, S.TypeId, S.TypeName, S.LicType
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyCloudAppsCapacityUsage (
		SurveyResultId, InstanceTypeId, BackupSize, ArchiveSize, SnapshotSize, ReplicationSize, UsedAgents
		)
	SELECT
		@ResultId,
		csInfo.n.value('@InstanceTypeId', 'INTEGER'),
		ISNULL(csInfo.n.value('@BackupSize', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@ArchiveSize', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@SnapSize', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@ReplicationSize', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@Agents', 'INTEGER'), 0)
	FROM
		@ResultXml.nodes('/CloudAppsCapacityUsage') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE cf_SurveyAgentLicensePeakUsage
	SET	PermLicensesUsed = CASE WHEN U.PermLicensesUsed > P.PermLicensesUsed THEN U.PermLicensesUsed ELSE P.PermLicensesUsed END,
		EvalLicensesUsed = CASE WHEN U.EvalLicensesUsed > P.EvalLicensesUsed THEN U.EvalLicensesUsed ELSE P.EvalLicensesUsed END
	FROM
		cf_SurveyAgentLicenseUsage U
		INNER JOIN cf_SurveyAgentLicensePeakUsage P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.TypeId = U.TypeId AND P.TypeName = U.TypeName
	WHERE
		U.SurveyResultId = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyAgentLicensePeakUsage (
		CommServUniqueId, MonthStart, TypeId, TypeName,
		PermLicensesUsed, EvalLicensesUsed
		)
	SELECT
		@CSUniqueId, @MonthStart, U.TypeId, U.TypeName,
		MAX(U.PermLicensesUsed), MAX(U.EvalLicensesUsed)
	FROM
		cf_SurveyAgentLicenseUsage U
		LEFT OUTER JOIN cf_SurveyAgentLicensePeakUsage P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.TypeId = U.TypeId
	WHERE
		U.SurveyResultId = @ResultId AND P.TypeId IS NULL
	GROUP BY U.TypeId, U.TypeName
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE cf_SurveyAgentCapacityPeakUsage
	SET	BackupSize = CASE WHEN T.BackupSize > P.BackupSize THEN T.BackupSize ELSE P.BackupSize END,
		ArchiveSize = CASE WHEN T.ArchiveSize > P.ArchiveSize THEN T.ArchiveSize ELSE P.ArchiveSize END,
		SnapshotSize = CASE WHEN T.SnapshotSize > P.SnapshotSize THEN T.SnapshotSize ELSE P.SnapshotSize END,
		ReplicationSize = CASE WHEN T.ReplicationSize > P.ReplicationSize THEN T.ReplicationSize ELSE P.ReplicationSize END,
		UsedAgents = CASE WHEN T.UsedAgents > P.UsedAgents THEN T.UsedAgents ELSE P.UsedAgents END
	FROM
		(SELECT TypeId, LicType,
				SUM(BackupSize) AS BackupSize, SUM(ArchiveSize) AS ArchiveSize,
				SUM(SnapshotSize) AS SnapshotSize, SUM(ReplicationSize) AS ReplicationSize, MAX(UsedAgents) AS UsedAgents
		FROM	cf_SurveyAgentCapacityUsage
		WHERE	SurveyResultId = @ResultId
		GROUP BY TypeId, LicType
		) T
		INNER JOIN cf_SurveyAgentCapacityPeakUsage P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.TypeId = T.TypeId AND P.LicType = T.LicType
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyAgentCapacityPeakUsage (
		CommServUniqueId, MonthStart, TypeId, TypeName,
		BackupSize, ArchiveSize, SnapshotSize, ReplicationSize, UsedAgents, LicType, Flag
		)
	SELECT
		@CSUniqueId, @MonthStart, U.TypeId, U.TypeName,
		MAX(U.BackupSize), MAX(U.ArchiveSize), MAX(U.SnapshotSize), MAX(U.ReplicationSize), MAX(U.UsedAgents), U.LicType, MAX(U.Flag)
	FROM
		cf_SurveyAgentCapacityUsage U
		LEFT OUTER JOIN cf_SurveyAgentCapacityPeakUsage P ON P.CommServUniqueId = @CSUniqueId AND P.MonthStart = @MonthStart AND P.TypeId = U.TypeId AND P.LicType = U.LicType
	WHERE
		U.SurveyResultId = @ResultId AND P.TypeId IS NULL
	GROUP BY U.TypeId, U.TypeName, U.LicType
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseAgentCapacityLicenseTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseAgentCapacityLicenseSurvey')
	delete from GxQscripts where name = 'ParseAgentCapacityLicenseSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseAgentCapacityLicenseSurvey')
	delete from GXDBVersions where aliasname = 'ParseAgentCapacityLicenseSurvey'
GO

insert into GXDBVersions values(2, 'ParseAgentCapacityLicenseSurvey',  '00010007000200120000', 'ParseAgentCapacityLicenseSurvey', '00010007000200120000')
GO

