

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/GetProblemCommCellsChargeback.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/GetProblemCommCellsChargeback.sp,v $ $Id: GetProblemCommCellsChargeback.sp,v 1.1.2.1 2019/10/29 13:35:46 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetProblemCommCellsChargeback')
BEGIN
	print '>>> Drop Stored Procedure: GetProblemCommCellsChargeback <<<'
	drop procedure GetProblemCommCellsChargeback
END
IF EXISTS (select * from GxQscripts where name='GetProblemCommCellsChargeback')
	delete from GxQscripts where name = 'GetProblemCommCellsChargeback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetProblemCommCellsChargeback')
	delete from GXDBVersions where aliasname = 'GetProblemCommCellsChargeback'
GO
print '... Creating Procedure: GetProblemCommCellsChargeback'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetProblemCommCellsChargeback
  @monthsback INTEGER
AS
BEGIN
set nocount on
DECLARE @RptMetricsTrendInput INT = 4
if @monthsback > 6
begin
set @RptMetricsTrendInput = 5
end
DECLARE @fromdate DATETIME = CAST(DATEADD(mm, -@monthsback-1, getdate()) AS DATE)
;with X as
(
select distinct cf_CommcellIdNameMap.ID, cf_CommcellIdNameMap.CommCellSurveyServices from cf_CommcellIdNameMap WITH (NOLOCK)
inner join cf_CustomerFeedbackXmlFile on cf_CommcellIdNameMap.ID = cf_CustomerFeedbackXmlFile.CommcellIdNameMap_ID WHERE ParseTime > (select Value from cf_SurveyConfig WITH (NOLOCK) where Name = 'LastMetricsAutoCorrectionTime')
)
select * into #tmpChargeback from
(
SELECT X.ID, (SELECT CAST(cf_SurveyMonthlyChargeback.StartDate as DATE)) as JobEndDate from cf_SurveyMonthlyChargeback WITH (NOLOCK)
inner join X on X.ID = cf_SurveyMonthlyChargeback.CommServUniqueId AND StartDate >= @fromdate where X.CommCellSurveyServices & 32 = 32 group by X.ID, cf_SurveyMonthlyChargeback.StartDate -- get recent commcells w/ monthly chargeback
) T
select * into #tempDates from (select STARTDATE from RptMetricsTrend(@RptMetricsTrendInput)) T
select * into #tempDatesFormatted from #tempDates where STARTDATE IN
(
select min(STARTDATE)
from #tempDates
group by month(STARTDATE),year(STARTDATE)
)
CREATE TABLE #tmpDateRange (CSUID int, [Date] datetime)
INSERT INTO #tmpDateRange
SELECT distinct ID, b.STARTDATE from #tmpChargeback a, #tempDatesFormatted b
delete t from #tmpDateRange t
inner join (SELECT ID, min(JobEndDate) MinJobDate, max(JobEndDate) MaxJobDate FROM #tmpChargeback group by ID) j
	on t.CSUID = j.ID
	and (t.[Date] < j.MinJobDate or t.[Date] > j.MaxJobDate)
insert into CommServAnomalies (QueryId,CommServUniqueId,MinProblemDate)
select 136, CSUID as CommServUniqueId, min([Date]) as MinProblemDate from
(
select * from #tmpChargeback a
right outer join #tmpDateRange b on a.ID = b.CSUID and a.JobEndDate = b.[Date]
) k where JobEndDate is null and not exists (select CommServUniqueId from CommServAnomalies WITH (NOLOCK) where k.CSUID = CommServAnomalies.CommServUniqueId) GROUP BY CSUID
drop table #tmpChargeback, #tmpDateRange, #tempDates, #tempDatesFormatted
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetProblemCommCellsChargeback')
	delete from GxQscripts where name = 'GetProblemCommCellsChargeback'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetProblemCommCellsChargeback')
	delete from GXDBVersions where aliasname = 'GetProblemCommCellsChargeback'
GO

insert into GXDBVersions values(2, 'GetProblemCommCellsChargeback',  '00010001000200010000', 'GetProblemCommCellsChargeback', '00010001000200010000')
GO

