

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/GetProblemCommCellsBackupActivity.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/GetProblemCommCellsBackupActivity.sp,v $ $Id: GetProblemCommCellsBackupActivity.sp,v 1.1.2.1 2019/10/29 13:36:00 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetProblemCommCellsBackupActivity')
BEGIN
	print '>>> Drop Stored Procedure: GetProblemCommCellsBackupActivity <<<'
	drop procedure GetProblemCommCellsBackupActivity
END
IF EXISTS (select * from GxQscripts where name='GetProblemCommCellsBackupActivity')
	delete from GxQscripts where name = 'GetProblemCommCellsBackupActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetProblemCommCellsBackupActivity')
	delete from GXDBVersions where aliasname = 'GetProblemCommCellsBackupActivity'
GO
print '... Creating Procedure: GetProblemCommCellsBackupActivity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetProblemCommCellsBackupActivity
  @monthsback INTEGER
AS
BEGIN
set nocount on
DECLARE @RptMetricsTrendInput INT = 2
if @monthsback > 1
begin
set @RptMetricsTrendInput = 3
end
if @monthsback > 3
begin
set @RptMetricsTrendInput = 4
end
if @monthsback > 6
begin
set @RptMetricsTrendInput = 5
end
DECLARE @fromdate DATETIME = CAST(DATEADD(mm, -@monthsback, getdate()) AS DATE)
;with X as
(
select distinct cf_CommcellIdNameMap.ID, cf_CommcellIdNameMap.CommCellSurveyServices from cf_CommcellIdNameMap WITH (NOLOCK)
inner join cf_CustomerFeedbackXmlFile on cf_CommcellIdNameMap.ID = cf_CustomerFeedbackXmlFile.CommcellIdNameMap_ID WHERE ParseTime > (select Value from cf_SurveyConfig WITH (NOLOCK) where Name = 'LastMetricsAutoCorrectionTime')
)
select * into #tmpAllJobs from
(
SELECT X.ID, (SELECT CAST(cf_SurveyIDADailyBkpJobStats.JobEndDate as DATE)) as JobEndDate, SUM(cf_SurveyIDADailyBkpJobStats.TotalJobs) as TotalJobs from cf_SurveyIDADailyBkpJobStats WITH (NOLOCK)
inner join X on X.ID = cf_SurveyIDADailyBkpJobStats.CommServUniqueId AND JobEndDate >= @fromdate where X.CommCellSurveyServices & 4 = 4 group by X.ID, cf_SurveyIDADailyBkpJobStats.JobEndDate -- get recent commcells w/ activity enabled
) T
CREATE TABLE #tmpDateRange (CSUID int, [Date] datetime)
INSERT INTO #tmpDateRange
SELECT distinct ID, b.STARTDATE from #tmpAllJobs a, dbo.RptMetricsTrend(@RptMetricsTrendInput) b
delete t from #tmpDateRange t
inner join (SELECT ID, min(JobEndDate) MinJobDate, max(JobEndDate) MaxJobDate FROM #tmpAllJobs group by ID) j
	on t.CSUID = j.ID
	and (t.[Date] < j.MinJobDate or t.[Date] > j.MaxJobDate)
insert into CommServAnomalies (QueryId,CommServUniqueId,MinProblemDate)
select 173, CSUID as CommServUniqueId, min([Date]) as MinProblemDate from
(
select * from #tmpAllJobs a
right outer join #tmpDateRange b on a.ID = b.CSUID and a.JobEndDate = b.[Date]
) k where TotalJobs is null and not exists (select CommServUniqueId from CommServAnomalies WITH (NOLOCK) where k.CSUID = CommServAnomalies.CommServUniqueId) GROUP BY CSUID
drop table #tmpAllJobs, #tmpDateRange
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetProblemCommCellsBackupActivity')
	delete from GxQscripts where name = 'GetProblemCommCellsBackupActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetProblemCommCellsBackupActivity')
	delete from GXDBVersions where aliasname = 'GetProblemCommCellsBackupActivity'
GO

insert into GXDBVersions values(2, 'GetProblemCommCellsBackupActivity',  '00010001000200010000', 'GetProblemCommCellsBackupActivity', '00010001000200010000')
GO

