

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/GetEntityRunningOutOfSpace.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/GetEntityRunningOutOfSpace.sp,v $ $Id: GetEntityRunningOutOfSpace.sp,v 1.1.2.3 2020/10/29 01:13:15 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetEntityRunningOutOfSpace')
BEGIN
	print '>>> Drop Stored Procedure: GetEntityRunningOutOfSpace <<<'
	drop procedure GetEntityRunningOutOfSpace
END
IF EXISTS (select * from GxQscripts where name='GetEntityRunningOutOfSpace')
	delete from GxQscripts where name = 'GetEntityRunningOutOfSpace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetEntityRunningOutOfSpace')
	delete from GXDBVersions where aliasname = 'GetEntityRunningOutOfSpace'
GO
print '... Creating Procedure: GetEntityRunningOutOfSpace'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetEntityRunningOutOfSpace
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommServUniqueID INT = 0,
  @i_Options INT = 0
-- i_Options = 1 => Fetch MA List for index cache prediction
-- i_Options = 2 => Fetch Library List for disk lib prediction
-- i_Options = 4 => Fetch DDB List for ddb prediction
AS
SET NOCOUNT ON
DECLARE @DateToBeFull BIGINT = dbo.getUnixtimebig(DATEADD(DAY, 30, GETUTCDATE()))
IF object_id('tempdb.dbo.#EntityList') is not null DROP TABLE #EntityList
CREATE  TABLE #EntityList ( ID VARCHAR(10), EntityName NVARCHAR(MAX))
IF @i_Options&1 > 0
BEGIN
	IF object_id('tempdb.dbo.#IndexCache_rowsFromSP') is not null DROP TABLE #IndexCache_rowsFromSP
	CREATE TABLE #IndexCache_rowsFromSP (
		CommServUniqueId        INT
		,MediaAgentName         NVARCHAR(256)
		,IndexCachePath         NVARCHAR(256)
		,TotalCapacity	        BIGINT -- SizeMB
		,DiskUsage   	        BIGINT -- SizeMB
		,FreeDiskSpace 		    BIGINT -- SizeMB
		,FreeDiskSpacePercent   BIGINT -- NumberNA
		,DateToBeFull			BIGINT
		,HealthStatus           VARCHAR(40)
		,CriticalFreeSpace		BIGINT
		,WarningFreeSpace		BIGINT
	)
	INSERT INTO #IndexCache_rowsFromSP
	EXEC RptIndexCacheSpaceUsage @i_UserId, @i_GroupId, 0, 1, @i_CommServUniqueID
	INSERT INTO #EntityList
	SELECT DISTINCT 'MA', MediaAgentName FROM #IndexCache_rowsFromSP WHERE DateToBeFull < @DateToBeFull
	DROP TABLE #IndexCache_rowsFromSP
END
IF @i_Options&2 > 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#RptDiskLibraryUsageWrapper_Output') IS NOT NULL DROP TABLE #RptDiskLibraryUsageWrapper_Output
	CREATE TABLE #RptDiskLibraryUsageWrapper_Output (
		CommServUniqueId      INT,
		CommCellName          NVARCHAR(256),
		Library               NVARCHAR(256),
		MountPathShared       NVARCHAR(32),
		CapacityMB            BIGINT,
		FreeSpaceMB           BIGINT,
		AvailableSpaceMB      BIGINT,
		AvailableSpacePct     DECIMAL(10,2),
		ReserveSpaceMB        BIGINT,
		DateToBeFull          NVARCHAR(256),
		RangeOfDateToBeFull   NVARCHAR(256),
		DataWrittenMB         BIGINT,
		AppSizeMB             BIGINT,
		PrevMonthChangeMB     BIGINT,
		PrevMonthChangePct    DECIMAL(10,2),
		CurrMonthChangeMB     BIGINT,
		CurrMonthChangePct    DECIMAL(10,2),
		LowWatermarkPct       NVARCHAR(256),
		ReachLowWatermark     BIGINT,
		SixMonthGrowthMB      BIGINT,
		TwelveMonthGrowthMB   BIGINT,
		EighteenMonthGrowthMB BIGINT,
		Status                NVARCHAR(32)
	)
	EXEC RptDiskLibraryUsageWrapper @i_UserId, @i_GroupId, 0, 1, @i_CommServUniqueID
	INSERT INTO #EntityList
	SELECT DISTINCT 'LIB', Library FROM #RptDiskLibraryUsageWrapper_Output WHERE DateToBeFull < @DateToBeFull
	DROP TABLE #RptDiskLibraryUsageWrapper_Output
END
IF @i_Options&4 > 0
BEGIN
	IF object_id('tempdb.dbo.#DDB_rowsFromSP') is not null DROP TABLE #DDB_rowsFromSP
	CREATE TABLE #DDB_rowsFromSP (
		CommServUniqueId        INT
		,DDBName 	            NVARCHAR(MAX)
		,MediaAgent         	NVARCHAR(256)
		,DDBPath	            NVARCHAR(256)
		,SizeOfDDBpathMB        BIGINT
		,DDB_diskSpace_Total    BIGINT
		,DDB_diskSpace_Free     BIGINT
		,FreeSpacePercent		DECIMAL(5,2)
		,DateToBeFull			BIGINT
		,HealthStatus           VARCHAR(40)
	)
	INSERT #DDB_rowsFromSP
    EXEC RptDDBDiskSpaceUsage @i_UserId, @i_GroupId, 0, 1, @i_CommServUniqueID
	INSERT INTO #EntityList
	SELECT DISTINCT 'DDB', MediaAgent FROM #DDB_rowsFromSP WHERE DateToBeFull < @DateToBeFull
	DROP TABLE #DDB_rowsFromSP
END
SELECT DISTINCT ID, EntityName FROM #EntityList
DROP TABLE #EntityList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetEntityRunningOutOfSpace')
	delete from GxQscripts where name = 'GetEntityRunningOutOfSpace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetEntityRunningOutOfSpace')
	delete from GXDBVersions where aliasname = 'GetEntityRunningOutOfSpace'
GO

insert into GXDBVersions values(2, 'GetEntityRunningOutOfSpace',  '00010001000200030000', 'GetEntityRunningOutOfSpace', '00010001000200030000')
GO

