

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/DefragmentIndexes.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/DefragmentIndexes.sp,v $ $Id: DefragmentIndexes.sp,v 1.1.2.3 2019/10/04 04:49:21 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='DefragmentIndexes')
BEGIN
	print '>>> Drop Stored Procedure: DefragmentIndexes <<<'
	drop procedure DefragmentIndexes
END
IF EXISTS (select * from GxQscripts where name='DefragmentIndexes')
	delete from GxQscripts where name = 'DefragmentIndexes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DefragmentIndexes')
	delete from GXDBVersions where aliasname = 'DefragmentIndexes'
GO
print '... Creating Procedure: DefragmentIndexes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure DefragmentIndexes
  @TopN INT	= 10,
  @MinFragPct INT = 30,
  @MinPageCount INT = 1000
AS
SET NOCOUNT ON
DECLARE @ErrCode	INT = 0
DECLARE @ErrMsg		NVARCHAR(MAX)
DECLARE @LogStr		NVARCHAR(MAX)
DECLARE	@StartDate	DATETIME = GETUTCDATE()
IF EXISTS (SELECT 1 FROM cf_SurveyConfig WHERE Name = 'DefragmentIndexes_TopN')
	SELECT @TopN = Value FROM cf_SurveyConfig WHERE Name = 'DefragmentIndexes_TopN'
IF EXISTS (SELECT 1 FROM cf_SurveyConfig WHERE Name = 'DefragmentIndexes_MinFragPct')
	SELECT @MinFragPct = Value FROM cf_SurveyConfig WHERE Name = 'DefragmentIndexes_MinFragPct'
IF EXISTS (SELECT 1 FROM cf_SurveyConfig WHERE Name = 'DefragmentIndexes_MinPageCount')
	SELECT @MinPageCount = Value FROM cf_SurveyConfig WHERE Name = 'DefragmentIndexes_MinPageCount'
IF @TopN <= 0
	RETURN
SELECT @LogStr = 'DefragmentIndexes - Start'
INSERT INTO cf_SurveyLogger(Message) VALUES(@LogStr)
DECLARE @SqlStr  NVARCHAR(MAX)
DECLARE @TblName NVARCHAR(128)
DECLARE @IdxName SYSNAME
DECLARE @FragPct INT
DECLARE @PageCnt INT
DECLARE @nIndex  INT = 0
DECLARE FragIndex CURSOR FOR
SELECT	TOP (@TopN)
		OBJECT_NAME(I.[object_id]) AS [Table],
		I.[name] AS [Index],
		P.[avg_fragmentation_in_percent] AS AvgFragPct,
		P.[page_count] AS PageCount
FROM	sys.dm_db_index_physical_stats (DB_ID(), NULL, NULL, NULL, NULL) AS P
		INNER JOIN sys.indexes AS I ON I.[object_id] = P.[object_id] AND P.[index_id] = I.[index_id]
WHERE	P.[database_id] = DB_ID()
	AND P.[avg_fragmentation_in_percent] > @MinFragPct
	AND P.[page_count] > @MinPageCount
	AND I.[type] <> 0
ORDER BY AvgFragPct DESC
OPEN FragIndex
	FETCH NEXT FROM FragIndex INTO @TblName, @IdxName, @FragPct, @PageCnt
WHILE @@FETCH_STATUS = 0
BEGIN
	BEGIN TRY
		SET @SqlStr = 'ALTER INDEX ' + @IdxName + ' ON ' + @TblName + ' REBUILD'
		EXEC sp_executesql @SqlStr
	END TRY
	BEGIN CATCH
		SELECT	@ErrCode = ERROR_NUMBER(), @ErrMsg = ERROR_MESSAGE()
		SET @LogStr = 'DefragmentIndexes - Exception from ' + @SqlStr + '. ERROR CODE: ' + CAST(@ErrCode AS VARCHAR(20)) + ' ERROR MESSAGE: ' + ISNULL(@ErrMsg, '')
		INSERT INTO cf_SurveyLogger(Message) VALUES(@LogStr)
		BREAK
	END CATCH
	SET @LogStr = 'DefragmentIndexes - ' + @SqlStr + ' Completed. Previous avg_fragmentation_in_percent = ' + CAST(@FragPct AS VARCHAR(20))
			+ ' page_count = ' + CAST(@PageCnt AS VARCHAR(20))
	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogStr)
	SET @nIndex += 1
	FETCH NEXT FROM FragIndex INTO @TblName, @IdxName, @FragPct, @PageCnt
END
CLOSE FragIndex
DEALLOCATE FragIndex
IF @ErrCode = 0
BEGIN
	SET @LogStr = 'DefragmentIndexes - Complete in ' + CAST(DATEDIFF(SS, @StartDate, GETUTCDATE()) AS VARCHAR(10)) + 'sec. Number of indexes defragmented: ' + CAST(@nIndex AS VARCHAR(20))
	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogStr)
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'DefragmentIndexes')
	delete from GxQscripts where name = 'DefragmentIndexes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='DefragmentIndexes')
	delete from GXDBVersions where aliasname = 'DefragmentIndexes'
GO

insert into GXDBVersions values(2, 'DefragmentIndexes',  '00010001000200030000', 'DefragmentIndexes', '00010001000200030000')
GO

