

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CommServeConnectionStatus.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='CommServeConnectionStatus')
BEGIN
	print '>>> Drop Stored Procedure: CommServeConnectionStatus <<<'
	drop procedure CommServeConnectionStatus
END
IF EXISTS (select * from GxQscripts where name='CommServeConnectionStatus')
	delete from GxQscripts where name = 'CommServeConnectionStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CommServeConnectionStatus')
	delete from GXDBVersions where aliasname = 'CommServeConnectionStatus'
GO
print '... Creating Procedure: CommServeConnectionStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure CommServeConnectionStatus
  @i_UserId INT = NULL,
  @i_CommServUniqueID INT
AS
BEGIN
    SET NOCOUNT ON;
DECLARE @retStatusType INT = -1
        DECLARE @retMessage NVARCHAR(255) = 'Commserv connection status is not available'
        DECLARE @LogDate DATETIME = NULL
    BEGIN TRY
        IF(@i_CommServUniqueID <= 0)
			GOTO PROC_EXIT
        IF EXISTS(SELECT CommservUniqueId FROM CVMetricsServiceConnections WITH(NOLOCK) WHERE CommservUniqueId = @i_CommServUniqueID
AND STATUS IN (3, 4)) --row with csuniqueId with status CONNECT OR RECONNECT
        BEGIN
SET @retStatusType = 1
DECLARE @lastStatus  INT = -1
            DECLARE @xml XML
            DECLARE @respMsg NVARCHAR(MAX)
            DECLARE @CreateDate DATETIME = 0
            DECLARE @ModDate DATETIME = 0
            SET @retMessage = 'CommServ is registered.'
            SELECT TOP 1 @lastStatus= Status,
                   @CreateDate = cvm.CreatedTime,
                   @ModDate = cvm.ModifiedTime,
                   @respMsg = ResponseMessage
                   FROM CVMetricsServiceClientRequest cvm WITH(NOLOCK)
                   INNER JOIN cf_CommcellIdNameMap csinfo WITH (NOLOCK) ON
                   csinfo.ID = ServiceConnectionId
                   WHERE ServiceConnectionId = @i_CommServUniqueID
                    ORDER by cvm.ModifiedTime desc
IF (@lastStatus IN (6, 7))  --Status is Refresh or Processing
                BEGIN
SET @retStatusType = 3
                    SET @retMessage = 'Last request is in progress.'
                END
ELSE IF (@lastStatus = 10)  --Survey disabled.
                    BEGIN
SET @retStatusType = 4
                        SET @xml = CAST (@respMsg AS xml)
                        IF (@xml IS NOT NULL )
                        BEGIN
                            SELECT @retMessage = N.response.value('@content', 'NVARCHAR(255)')
                                FROM @xml.nodes('CVGui_MetricServiceRequest')  AS N(response)
                        END
                    END
ELSE IF (@lastStatus = 1)  --Last Refresh failed
                BEGIN
SET @retStatusType = 5
                    SET @xml = CAST (@respMsg AS xml)
                    IF (@xml IS NOT NULL )
                    BEGIN
                        DECLARE @statusMsg NVARCHAR(MAX) = ''
                        SELECT @statusMsg = N.response.value('@content', 'NVARCHAR(255)')
                            FROM @xml.nodes('CVGui_MetricServiceRequest')  AS N(response)
                        IF LEN (@statusMsg) >  0
                            SET @retMessage = 'Last request failed with error [' + @statusMsg + ']'
                        ELSE
                            SET @retMessage = 'Last request failed to process.'
                    END
                END
ELSE IF (@lastStatus = 0) OR (@lastStatus = 11) OR (@lastStatus = 12)--SUCCESS, SUBMITTASK, SUBMITCOMMAND
                BEGIN
SET @retStatusType = 1
					SET @retMessage = 'CommServ is registered.'
                END
ELSE IF (@lastStatus = -1) --NO ENTRY in CVMetricsServiceClientRequest. So no requests made so far from cloud to commserver.
				BEGIN
SET @retStatusType = 1
					SET @retMessage = 'CommServ is registered.'
				END
            ELSE -- Anything else set to inactive,
                BEGIN
SET @retStatusType = 2
                    SET @retMessage = 'Last request status is invalid.'
                END
            END
        ELSE
        BEGIN
SET @retStatusType = 2
            SET @retMessage = 'Push Notification is not enabled.'
        END
		IF OBJECT_ID('tempdb..#LastConnectionTimeResults') IS NOT NULL
			DROP TABLE #LastConnectionTimeResults
		create table #LastConnectionTimeResults (
			CSID int,
			LastConnectionTimeDate datetime
		)
		insert into #LastConnectionTimeResults
		select @i_CommServUniqueID, 0
		exec CalculateLastConnectionTime
		select @LogDate = LastConnectionTimeDate from #LastConnectionTimeResults
		if @LogDate = 0
			set @LogDate = NULL
		IF OBJECT_ID('tempdb..#LastConnectionTimeResults') IS NOT NULL
			DROP TABLE #LastConnectionTimeResults
    END TRY
	BEGIN CATCH --Any exception, set to not registered and return error message.
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
SET @retStatusType = 2
		SET @retMessage = 'CommServeConnectionStatus failed with error :: ' + ERROR_MESSAGE()
		SET @LogDate = NULL
	END CATCH
	PROC_EXIT:
    SELECT @retStatusType AS 'Status', @retMessage AS 'Message', CASE WHEN @LogDate IS NULL THEN 0 ELSE DATEDIFF(SECOND, '01/01/1970', @LogDate) END AS 'LastConnectionTime'
END
GO

IF EXISTS (select * from GxQscripts where name = 'CommServeConnectionStatus')
	delete from GxQscripts where name = 'CommServeConnectionStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CommServeConnectionStatus')
	delete from GXDBVersions where aliasname = 'CommServeConnectionStatus'
GO

insert into GXDBVersions values(2, 'CommServeConnectionStatus',  '00000000000000000000', 'CommServeConnectionStatus', '00000000000000000000')
GO

