

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CM_RptContractManagement.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CM_RptContractManagement.sp,v $ $Id: CM_RptContractManagement.sp,v 1.1.2.27 2020/12/19 05:11:49 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CM_RptContractManagement')
BEGIN
	print '>>> Drop Stored Procedure: CM_RptContractManagement <<<'
	drop procedure CM_RptContractManagement
END
IF EXISTS (select * from GxQscripts where name='CM_RptContractManagement')
	delete from GxQscripts where name = 'CM_RptContractManagement'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_RptContractManagement')
	delete from GXDBVersions where aliasname = 'CM_RptContractManagement'
GO
print '... Creating Procedure: CM_RptContractManagement'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CM_RptContractManagement
  @i_UserId INT = NULL,
  @i_Option INT = 0,
  @i_RptId INT = 0,
  @i_ClientGroups VARCHAR(MAX) = '-99'
AS
--Option 1,  Get list of all contracts to billing group mappings
--Option 2,  Get list of client groups associated with some contract
--Option 3,  Get list of client groups not associated with any contract
--Option 4,  Get list of all billing groups to license mappings
--Option 5,  Get license list
--Option 6,  Get Agent list
--Option 7,  Get list of available contracts
--Option 8,  Get list of available billing groups
--Option 9,  Get details of the given billing group
--Option 10, Get list of billing groups under a given contract
--Option 11, Get list of currency codes
--Option 12, Get list of aggregators associated with some contract
--Option 13, Get list of aggregators not associated with any contract
--Option 14, Get aggregator-contract association details
--Option 15, Get commcell group-contract association details
--Option 16, Get list of all aggregators
--Option 17, Get commcell group list
--Option 18, Get aggregator-commcell group association details
--Option 19, Get currency symbol corresponding to the currency code
--Option 20, Get list of partners associated with some contract
--Option 21, Get list of partners not associated with any contract
--Option 22, Get partner-contract association details
--Option 23, Get list of all partners
--Option 24, Get service provider list
--Option 25, Get partner-service provider association details
--Option 26, Get list of available tenants
--Option 27, Get list of available plans
--Option 28, Get list of available base plans
--Option 29, Get volume discount for a given commcell group or service provider or partner
IF @i_Option = 1 --Get list of all contracts to billing group mappings
BEGIN
	DECLARE @tempTable1 TABLE(id INT IDENTITY(1,1),contractId INT,contractName NVARCHAR(1024),description NVARCHAR(MAX),status INT,billingGroupId INT,billingGroupName NVARCHAR(1024),countingType INT,baseLine FLOAT,price FLOAT,lowerLimit FLOAT,upperLimit FLOAT,currency NVARCHAR(10),contractType INT,tenantId NVARCHAR(40),tenantName NVARCHAR(1024),includeInVolDiscount INT)
	--first insert CommCell based contracts
	INSERT @tempTable1
	SELECT A.contractId, contractName, ISNULL(B.description,''), B.status, min(A.billingGroupId),
	billingGroupName, countingType,0,
	ISNULL(price,0), ISNULL(lowerLimit,0), ISNULL(upperLimit,0), B.currencyCode, B.flag,'','', A.flag
	FROM cm_ContractToBillingGroupMap A WITH (NOLOCK)
	LEFT JOIN dbo.cm_Contract B WITH (NOLOCK) ON A.contractId = B.contractId
	LEFT JOIN dbo.cm_BillingGroup C WITH (NOLOCK) ON A.billingGroupId = C.billingGroupId
	WHERE price > 0
	AND B.flag=0
	GROUP BY A.contractId,contractName,B.description,B.status,billingGroupName,countingType,lowerLimit,upperLimit,price,B.currencyCode,B.flag,A.flag
	--below update statement is only required for CommCell based contracts
	UPDATE T
	SET T.baseLine=C.upperLimit
	FROM @tempTable1 T
	INNER JOIN cm_ContractToBillingGroupMap C WITH (NOLOCK)
	ON T.contractId = C.contractId AND T.billingGroupId = C.billingGroupId
	WHERE C.price=0 AND C.lowerLimit=0 AND C.upperLimit<>0
	--below update statement is only required for CommCell based contracts
	UPDATE @tempTable1 SET lowerLimit=0
	WHERE baseLine=lowerLimit
	--next insert Tenant based contracts
	INSERT @tempTable1
	SELECT A.contractId, contractName, ISNULL(B.description,''), B.status, MIN(A.billingGroupId),
	billingGroupName, countingType,MIN(baseline),
	price, lowerLimit, upperLimit, B.currencyCode, B.flag,A.tenantId,A.tenantName,A.flag
	FROM cm_ContractToTenantToBillingGroupMap A WITH (NOLOCK)
	LEFT JOIN dbo.cm_Contract B WITH (NOLOCK) ON A.contractId = B.contractId
	LEFT JOIN dbo.cm_BillingGroup C WITH (NOLOCK) ON A.billingGroupId = C.billingGroupId
	WHERE price > 0
	AND B.flag=1
	GROUP BY A.contractId,contractName,B.description,B.status,A.tenantName,A.tenantId,billingGroupName,countingType,lowerLimit,upperLimit,price,B.currencyCode,B.flag,A.flag
	DECLARE @tempTable2 TABLE(id INT,contractId INT,contractName NVARCHAR(1024),description NVARCHAR(MAX),status INT,billingGroupId INT,billingGroupName NVARCHAR(1024),countingType VARCHAR(50),baseLine FLOAT,price VARCHAR(MAX),lowerLimit VARCHAR(MAX),upperLimit VARCHAR(MAX),currency NVARCHAR(10),contractType INT,tenantId NVARCHAR(40),tenantName NVARCHAR(1024),includeInVolDiscount INT)
	INSERT @tempTable2
	SELECT min(id) AS id,T.contractId AS contractId, T.contractName AS contractName, T.description AS description, T.status AS status, T.billingGroupId AS billingGroupId,
	T.billingGroupName AS billingGroupName, CASE WHEN T.countingType=1 THEN 'Capacity' ELSE 'Client Access' END AS countingType, baseLine AS baseLine,
	STUFF(
         (SELECT ',' + CONVERT(VARCHAR(10),price)
          FROM @tempTable1
          WHERE contractId=T.contractId AND contractName=T.contractName AND billingGroupId=T.billingGroupId
		  AND billingGroupName=T.billingGroupName AND countingType=T.countingType AND tenantId=T.tenantId AND tenantName=T.tenantName
		  GROUP BY billingGroupId,lowerLimit,price
		  ORDER BY lowerLimit
          FOR XML PATH (''))
          , 1, 1, '')  AS price,
	STUFF(
         (SELECT ',' + CONVERT(VARCHAR(10),lowerLimit)
          FROM @tempTable1
          WHERE contractId=T.contractId AND contractName=T.contractName AND billingGroupId=T.billingGroupId
		  AND billingGroupName=T.billingGroupName AND countingType=T.countingType AND tenantId=T.tenantId AND tenantName=T.tenantName
		  GROUP BY billingGroupId,lowerLimit,price
		  ORDER BY lowerLimit
          FOR XML PATH (''))
          , 1, 1, '')  AS lowerLimit,
	STUFF(
         (SELECT ',' + CONVERT(VARCHAR(10),upperLimit)
          FROM @tempTable1
          WHERE contractId=T.contractId AND contractName=T.contractName AND billingGroupId=T.billingGroupId
		  AND billingGroupName=T.billingGroupName AND countingType=T.countingType AND tenantId=T.tenantId AND tenantName=T.tenantName
		  GROUP BY billingGroupId,lowerLimit,upperLimit
		  ORDER BY lowerLimit
          FOR XML PATH (''))
          , 1, 1, '')  AS upperLimit,
	T.currency AS currency,T.contractType AS contractType,T.tenantId,T.tenantName,T.includeInVolDiscount
	FROM @tempTable1 T
	GROUP BY contractId,contractName,description,status,tenantName,tenantId,billingGroupId,billingGroupName,countingType,baseLine,currency,contractType,includeInVolDiscount
	ORDER BY contractName,tenantName,billingGroupName,lowerLimit
	--insert those contracts that got created but not yet assigned to any billing group
	INSERT @tempTable2
	SELECT 0,contractId,contractName,description,status,0,'','',0,'','','','',flag,'','',0
	FROM cm_contract WITH (NOLOCK)
	WHERE contractId NOT IN
	(SELECT DISTINCT contractId FROM cm_ContractToBillingGroupMap WITH (NOLOCK))
	AND contractId NOT IN
	(SELECT DISTINCT contractId FROM cm_ContractToTenantToBillingGroupMap WITH (NOLOCK))
	--insert those CommCell contracts that are mapped to some billing group but no price tiers are defined (i.e., having rows with only price=0)
	INSERT @tempTable2
	SELECT 0,C.contractId,C.contractName,C.description,C.status,B.BillingGroupId,B.BillingGroupName,
	CASE WHEN B.CountingType=0 THEN 'Client Access' WHEN B.CountingType=1 THEN 'Capacity' ELSE '' END AS CountingType,
	0,'','','',C.currencyCode,C.flag,'','',0
	FROM cm_contract C WITH (NOLOCK)
	INNER JOIN
	cm_ContractToBillingGroupMap M WITH (NOLOCK)
	ON C.ContractId = M.ContractId
	INNER JOIN
	cm_BillingGroup B WITH (NOLOCK)
	ON B.BillingGroupId = M.BillingGroupId
	WHERE price=0
	AND C.ContractId NOT IN (SELECT DISTINCT contractId FROM @tempTable2)
	GROUP BY C.contractId,C.contractName,C.description,C.status,B.BillingGroupId,B.BillingGroupName,B.CountingType,C.currencyCode,C.flag
	--insert those Tenant contracts that are mapped to some billing group but no price tiers are defined (i.e., having rows with only price=0)
	INSERT @tempTable2
	SELECT 0,C.contractId,C.contractName,C.description,C.status,B.BillingGroupId,B.BillingGroupName,
	CASE WHEN B.CountingType=0 THEN 'Client Access' WHEN B.CountingType=1 THEN 'Capacity' ELSE '' END AS CountingType,
	0,'','','',C.currencyCode,C.flag,M.tenantId,M.tenantName,0
	FROM cm_contract C WITH (NOLOCK)
	INNER JOIN
	cm_ContractToTenantToBillingGroupMap M WITH (NOLOCK)
	ON C.ContractId = M.ContractId
	INNER JOIN
	cm_BillingGroup B WITH (NOLOCK)
	ON B.BillingGroupId = M.BillingGroupId
	WHERE price=0
	AND C.ContractId NOT IN (SELECT DISTINCT contractId FROM @tempTable2)
	GROUP BY C.contractId,C.contractName,C.description,C.status,M.tenantId,M.tenantName,B.BillingGroupId,B.BillingGroupName,B.CountingType,C.currencyCode,C.flag
	--now return back the resultset to the UI
	SELECT contractId AS 'Billing Group ID <DONOTSHOW>',T.contractName AS 'Billing Group',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable2 R WHERE R.contractId = T.contractId ORDER BY id) THEN T.description ElSE '' END AS 'Description',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable2 R WHERE R.contractId = T.contractId ORDER BY id) THEN CASE WHEN T.contractType=0 THEN 'CommCell based' ELSE 'Tenant based' END ElSE '' END AS 'Billing Group Type',
	CASE WHEN T.contractType=0 THEN '' ELSE T.tenantId END AS 'Tenant ID <HIDDEN>',CASE WHEN T.contractType=0 THEN '' ELSE T.tenantName END AS 'Tenant',
	billingGroupId AS 'SKU ID <DONOTSHOW>', billingGroupName AS 'SKU', countingType AS 'Counting Type',
	baseLine AS 'Baseline', price AS 'Unit Price',	lowerLimit AS 'Lower Limit', upperLimit AS 'Upper Limit',
	CASE WHEN T.includeInVolDiscount=1 THEN 'Yes' ELSE 'No' END AS 'Include SKU in Volume Discount',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable2 R WHERE R.contractId = T.contractId ORDER BY id) THEN ISNULL(T.currency,'') ElSE '' END AS 'Currency',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable2 R WHERE R.contractId = T.contractId ORDER BY id) THEN T.status ElSE '-1' END AS 'Approved'
	FROM @tempTable2 T
	WHERE T.contractName<>'Legacy Partner Contract'
	ORDER BY contractName,id
END
ELSE IF @i_Option=2 --Get list of client groups associated with some contract
	SELECT clientGroupId AS 'Group ID <DONOTSHOW>', cga.name AS 'CommCell Group',
	B.contractId AS 'Billing Group ID <DONOTSHOW>', contractName AS 'Billing Group'
	,currencyCode AS 'Currency'
	FROM cm_ClientGroupToContractMap A WITH (NOLOCK)
	INNER JOIN cm_Contract B WITH (NOLOCK) ON A.contractId = B.contractId
	INNER JOIN cf_CommcellGroup cga WITH (NOLOCK) ON cga.id = A.clientGroupId
	AND clientGroupId IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
	ORDER BY [CommCell Group],[Billing Group]
ELSE IF @i_Option = 3 --Get list of client groups not associated with any contract
	SELECT id AS 'Group ID <DONOTSHOW>', name AS 'CommCell Group'  FROM cf_CommcellGroup WITH (NOLOCK)
	WHERE id NOT IN (SELECT clientGroupId FROM cm_ClientGroupToContractMap WITH (NOLOCK))
	AND id IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
	ORDER BY [CommCell Group]
ELSE IF @i_Option = 4 --Get list of all billing groups to license mappings
BEGIN
	DECLARE @tempTable3 TABLE (id INT IDENTITY(1,1),billingGroupId INT, billingGroup NVARCHAR(1024), description NVARCHAR(MAX), countingType NVARCHAR(256), entityType INT, licenseName NVARCHAR(1024), planType INT, planName NVARCHAR(1024))
    INSERT @tempTable3
    SELECT B.billingGroupId,B.billingGroupName,B.description,B.countingType,entityType,
    CASE WHEN L.entityType=0 THEN agType.Name ELSE licType.Name END AS licenseName, B.flag, B.planName
    FROM cm_BillingGroupToLicenseMap L WITH (NOLOCK)
    LEFT JOIN dbo.cm_BillingGroup B WITH (NOLOCK) ON L.billingGroupId = B.billingGroupId
    LEFT JOIN dbo.cf_SurveyLicType licType WITH (NOLOCK) ON L.entityId = licType.id
    LEFT JOIN dbo.cf_SurveyAgentType agType WITH (NOLOCK) ON L.entityId = agType.id
    ORDER BY B.billingGroupName, entityType
	SELECT T.billingGroupId AS 'SKU ID <DONOTSHOW>', T.countingType AS 'Counting Type ID <DONOTSHOW>', T.billingGroupId AS 'SKU ID <HIDDEN>', T.billingGroup AS 'SKU',
    T.description AS 'Description', CASE WHEN T.countingType=1 THEN 'Capacity' ELSE 'Client Access' END 'Counting Type',
    CASE WHEN T.entityType=1 THEN 'License' ELSE 'Agent' END AS 'Entity Type',
        STUFF(
            (SELECT ',' + licenseName
            FROM @tempTable3
            WHERE billingGroupId=T.billingGroupId AND countingType=T.countingType AND billingGroup=T.billingGroup AND description=T.description AND entityType=T.entityType
            GROUP BY billingGroupId,entityType,licenseName
            ORDER BY licenseName
            FOR XML PATH (''))
            , 1, 1, '') AS 'License Name'
	,CASE WHEN T.planType=1 THEN 'Plan associated' WHEN T.planType=2 THEN 'Base plan associated' ELSE 'Regular' END AS 'SKU Type', planName AS 'Plan'
    FROM @tempTable3 T
    GROUP BY billingGroupId,countingType,billingGroup,description,entityType,planType,planName
    ORDER BY T.billingGroup
END
ELSE IF @i_Option = 5 --Get license list
	SELECT min(id) AS id, name FROM cf_SurveyLicType WITH (NOLOCK) WHERE id > 0 GROUP BY name ORDER BY name
ELSE IF @i_Option = 6 --Get Agent list
	SELECT min(id) AS id, name FROM cf_SurveyAgentType WITH (NOLOCK) WHERE id > 0 GROUP BY name ORDER BY name
ELSE IF @i_Option = 7 --Get list of available contracts
	SELECT contractId AS 'Billing Group ID <DONOTSHOW>', contractName AS 'Billing Group' FROM cm_Contract WITH (NOLOCK) WHERE contractName<>'Legacy Partner Contract' ORDER BY contractName
ELSE IF @i_Option = 8 --Get list of available billing groups
	SELECT billingGroupId AS 'SKU ID <DONOTSHOW>', CASE WHEN countingType=1 THEN 'Capacity' ELSE 'Client Access' END AS 'Counting Type',
	billingGroupName AS 'SKU'
	FROM cm_BillingGroup WITH (NOLOCK) ORDER BY billingGroupName
ELSE IF @i_Option = 9 --Get details of the given billing group
	SELECT B.billingGroupId AS 'SKU ID <DONOTSHOW>',B.countingType AS 'Counting Type ID <DONOTSHOW>',
	entityType AS 'Entity Type ID <DONOTSHOW>',B.billingGroupName AS 'SKU',B.description AS 'Description',
	CASE WHEN L.entityType=0 THEN 'Agent' ELSE 'License' END AS 'Entity Type', entityId AS 'License ID <DONOTSHOW>',
	CASE WHEN L.entityType=0 THEN agType.Name ELSE licType.Name END AS licenseName,	B.flag AS 'SKU Type', B.planName AS 'Plan'
	FROM cm_BillingGroupToLicenseMap L WITH (NOLOCK)
	LEFT JOIN dbo.cm_BillingGroup B WITH (NOLOCK) ON L.billingGroupId = B.billingGroupId
	LEFT JOIN dbo.cf_SurveyLicType licType WITH (NOLOCK) ON L.entityId = licType.id
	LEFT JOIN dbo.cf_SurveyAgentType agType WITH (NOLOCK) ON L.entityId = agType.id
	WHERE B.billingGroupId = @i_RptId
	ORDER BY B.billingGroupName, entityType
ELSE IF @i_Option = 10 --Get list of billing groups under a given contract
BEGIN
	DECLARE @contractType INT = 0
	SELECT @contractType=flag FROM cm_Contract WHERE contractId=@i_RptId
	DECLARE @tempTable11 TABLE(id INT IDENTITY(1,1),contractId INT,contractName NVARCHAR(1024),description NVARCHAR(MAX),status INT,billingGroupId INT,billingGroupName NVARCHAR(1024),countingType INT,baseLine FLOAT,price FLOAT,lowerLimit FLOAT,upperLimit FLOAT,currency NVARCHAR(10),contractType INT,tenantId NVARCHAR(40),tenantName NVARCHAR(1024),includeInVolDiscount INT)
	IF @contractType=0
	BEGIN
		INSERT @tempTable11--get details of CommCell based contract
		SELECT A.contractId, contractName, B.description, B.status, min(A.billingGroupId),
		billingGroupName, countingType,0,
		price, lowerLimit, upperLimit, B.currencyCode,B.flag,'-1','(default)',A.flag
		FROM cm_ContractToBillingGroupMap A WITH (NOLOCK)
		LEFT JOIN dbo.cm_Contract B WITH (NOLOCK) ON A.contractId = B.contractId
		LEFT JOIN dbo.cm_BillingGroup C WITH (NOLOCK) ON A.billingGroupId = C.billingGroupId
		WHERE price > 0
		AND A.contractId=@i_RptId
		AND B.flag=0
		GROUP BY A.contractId,contractName,B.description,B.status,billingGroupName,countingType,lowerLimit,upperLimit,price,B.currencyCode,B.flag,A.flag
		--below update statement is only required for CommCell based contracts
		UPDATE T
		SET T.baseLine=C.upperLimit
		FROM @tempTable11 T
		INNER JOIN cm_ContractToBillingGroupMap C WITH (NOLOCK)
		ON T.contractId = C.contractId AND T.billingGroupId = C.billingGroupId
		WHERE C.price=0 AND C.lowerLimit=0 AND C.upperLimit<>0
		--below update statement is only required for CommCell based contracts
		UPDATE @tempTable11 SET lowerLimit=0
		WHERE baseLine=lowerLimit
		SELECT billingGroupId AS 'SKU ID <DONOTSHOW>', tenantId AS 'Tenant ID <DONOTSHOW>', tenantName AS 'Tenant', billingGroupName AS 'SKU',
		CASE WHEN T.countingType=1 THEN 'Capacity' ELSE 'Client Access' END AS 'Counting Type',
		baseLine AS 'Baseline', price AS 'Unit Price',	lowerLimit AS 'Lower Limit', upperLimit AS 'Upper Limit'
		, CASE WHEN includeInVolDiscount=1 THEN 'Yes' ELSE 'No' END AS 'Include SKU in Volume Discount'
		FROM @tempTable11 T
		ORDER BY billingGroupName, lowerLimit
	END
	ELSE
	BEGIN
		INSERT @tempTable11--get details of Tenant based contract
		SELECT A.contractId, contractName, B.description, B.status, min(A.billingGroupId),
		billingGroupName, countingType,MIN(baseline),
		price, lowerLimit, upperLimit, B.currencyCode,B.flag,A.tenantId,A.tenantName,A.flag
		FROM cm_ContractToTenantToBillingGroupMap A WITH (NOLOCK)
		LEFT JOIN dbo.cm_Contract B WITH (NOLOCK) ON A.contractId = B.contractId
		LEFT JOIN dbo.cm_BillingGroup C WITH (NOLOCK) ON A.billingGroupId = C.billingGroupId
		WHERE price > 0
		AND A.contractId=@i_RptId
		AND B.flag=1
		GROUP BY A.contractId,contractName,B.description,B.status,A.tenantId,A.tenantName,billingGroupName,countingType,baseline,lowerLimit,upperLimit,price,B.currencyCode,B.flag,A.flag
		SELECT billingGroupId AS 'SKU ID <DONOTSHOW>', tenantId AS 'Tenant ID <DONOTSHOW>', tenantName AS 'Tenant', billingGroupName AS 'SKU',
		CASE WHEN T.countingType=1 THEN 'Capacity' ELSE 'Client Access' END AS 'Counting Type',
		baseLine AS 'Baseline', price AS 'Unit Price',	lowerLimit AS 'Lower Limit', upperLimit AS 'Upper Limit'
		, CASE WHEN includeInVolDiscount=1 THEN 'Yes' ELSE 'No' END AS 'Include SKU in Volume Discount'
		FROM @tempTable11 T
		ORDER BY tenantName, billingGroupName, lowerLimit
	END
END
ELSE IF @i_Option = 11 --Get list of currency codes
BEGIN
	DECLARE @tempCurrency TABLE (currencyCode NVARCHAR(10))
	DECLARE @doc INT = 0
	DECLARE @xml NVARCHAR(MAX) = ''
	SELECT @xml=Value
	FROM cf_SurveyConfig
	WHERE Name='BillingCurrencyList'
	EXEC sp_xml_preparedocument @doc OUTPUT, @xml
	INSERT @tempCurrency
	SELECT currencyCode
	FROM OPENXML(@doc, '/BillingCurrencies/Currency', 3)
	WITH (currencyCode NVARCHAR(10))
	SELECT currencyCode AS 'Currency'
	FROM @tempCurrency
END
ELSE IF @i_Option=12 --Get list of aggregators associated with some contract
BEGIN
	DECLARE @tempTable8 TABLE (aggregatorId INT, aggregatorName NVARCHAR(512), minimumFee FLOAT, billCycle NVARCHAR(10), useAsPO NVARCHAR(10),currency NVARCHAR(10))
	INSERT INTO @tempTable8
	SELECT agg.aggregatorId, agg.aggregatorName,ISNULL(minimumFee,0),
	CASE WHEN billingType=0 THEN 'Monthly' WHEN billingType=1 THEN 'Quarterly' ELSE '' END,
	CASE WHEN useAsPO=0 THEN 'Yes' WHEN useAsPO=1 THEN 'No' ELSE '' END,'USD'
	FROM cm_AggregatorToContractMap A WITH (NOLOCK)
	INNER JOIN cm_Aggregator agg WITH (NOLOCK) ON agg.aggregatorId = A.aggregatorId
	INNER JOIN cm_AggregatorAssoc AA WITH (NOLOCK) ON AA.aggregatorId = agg.aggregatorId
	INNER JOIN cf_CommcellGroup C WITH (NOLOCK) ON C.id = AA.commCellGroupId
	WHERE AA.commCellGroupId IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
	GROUP BY agg.aggregatorId,agg.aggregatorName,minimumFee,billingType,useAsPO
	ORDER BY agg.aggregatorName
	UPDATE T SET T.currency = (SELECT currencyCode FROM cm_Contract WHERE contractId =  (SELECT contractId FROM cm_ClientGroupToContractMap WHERE clientGroupId =
	(SELECT TOP 1 commCellGroupId FROM cm_AggregatorAssoc WHERE aggregatorId = T.aggregatorId)))
	FROM @tempTable8 T
	SELECT aggregatorId AS 'Group ID <DONOTSHOW>',aggregatorName AS 'Service Provider', minimumFee AS 'Minimum Fee', billCycle AS 'Billing Cycle',
	useAsPO AS 'Use As Purchase Order',currency AS 'Currency' FROM @tempTable8
	ORDER BY aggregatorName
END
ELSE IF @i_Option = 13 --Get list of aggregators not associated with any contract
	SELECT A.aggregatorId AS 'Group ID <DONOTSHOW>', aggregatorName AS 'Service Provider'  FROM cm_Aggregator A WITH (NOLOCK)
	INNER JOIN cm_AggregatorAssoc AA WITH (NOLOCK) ON AA.aggregatorId=A.aggregatorId
	WHERE A.aggregatorId NOT IN (SELECT aggregatorId FROM cm_AggregatorToContractMap WITH (NOLOCK))
	AND AA.commCellGroupId IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
	GROUP BY A.aggregatorId,aggregatorName
	ORDER BY aggregatorName
ELSE IF @i_Option = 14 --Get aggregator-contract association details
BEGIN
	--starting V11SP10 currency will always be that of clientGroup because aggregators and partners are always associated to legacy contract
	DECLARE @t_aggCurrency VARCHAR(10) = ''
	select @t_aggCurrency=currencyCode from cm_Contract where contractId =  (select contractId from cm_ClientGroupToContractMap where clientGroupId =
	(select top 1 commCellGroupId from cm_AggregatorAssoc where aggregatorId = @i_RptId))
	DECLARE @hasVolumeDiscount INT=0
	IF EXISTS (SELECT 1 FROM cm_ReportToVolumeDiscountMap WITH (NOLOCK) WHERE reportType=1 AND reportId=@i_RptId)
		SET @hasVolumeDiscount=1
	SELECT AA.commCellGroupId, A.aggregatorName, AC.useAsPO, @t_aggCurrency currency, ISNULL(AC.minimumFee,0) minimumFee
	, @hasVolumeDiscount hasVolumeDiscount
    FROM cm_AggregatorAssoc AA WITH (NOLOCK)
    INNER JOIN cm_Aggregator A WITH (NOLOCK) ON A.aggregatorId=AA.aggregatorId
    INNER JOIN cm_AggregatorToContractMap AC WITH (NOLOCK) ON AC.aggregatorId = A.aggregatorId
    INNER JOIN cm_Contract C WITH (NOLOCK) ON C.contractId = AC.contractId
    WHERE AA.aggregatorId=@i_RptId
END
ELSE IF @i_Option = 15 --Get commcell group-contract association details
	SELECT C.currencyCode,CC.useAsPO
	FROM cm_Contract C WITH (NOLOCK)
	INNER JOIN cm_ClientGroupToContractMap CC WITH (NOLOCK) ON CC.contractId = C.contractId
	WHERE CC.clientGroupId=@i_RptId
ELSE IF @i_Option = 16 --Get list of all aggregators
BEGIN
	DECLARE @tempTable5 TABLE (id INT IDENTITY(1,1),aggregatorId INT, aggregatorName NVARCHAR(512), aggregatorDescription NVARCHAR(MAX), commCellGroupId NVARCHAR(512), commcellGroupName NVARCHAR(512))
	INSERT @tempTable5
	SELECT A.aggregatorId, A.aggregatorName, A.aggregatorDescription,AA.commCellGroupId,C.name
	FROM cm_AggregatorAssoc AA WITH (NOLOCK)
	LEFT JOIN cm_Aggregator A WITH (NOLOCK)	ON AA.aggregatorId = A.aggregatorId
	LEFT JOIN cf_CommcellGroup C WITH (NOLOCK) ON C.id = AA.commCellGroupId
	WHERE AA.commCellGroupId IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
	ORDER BY A.aggregatorName,AA.commCellGroupId,C.name
	--add aggregators having only stale commcellGroups (CCGroups that are removed) into the list to display
	INSERT @tempTable5
	SELECT aggregatorId, aggregatorName, aggregatorDescription,'','' FROM cm_Aggregator WHERE aggregatorId IN
	(SELECT aggregatorId FROM cm_AggregatorAssoc WHERE commCellGroupId NOT IN (SELECT DISTINCT id FROM cf_CommcellGroup) AND aggregatorId NOT IN (SELECT aggregatorId FROM @tempTable5))
	SELECT aggregatorId AS 'Service Provider ID <DONOTSHOW>',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable5 R WHERE R.aggregatorId = T.aggregatorId ORDER BY id) THEN CONVERT(VARCHAR(25),T.aggregatorId) ElSE '-1' END AS 'SPID <DONOTSHOW>',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable5 R WHERE R.aggregatorId = T.aggregatorId ORDER BY id) THEN CONVERT(VARCHAR(25),T.aggregatorId) ElSE '' END AS 'Service Provider ID <HIDDEN>',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable5 R WHERE R.aggregatorId = T.aggregatorId ORDER BY id) THEN T.aggregatorName ElSE '' END AS 'Service Provider',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable5 R WHERE R.aggregatorId = T.aggregatorId ORDER BY id) THEN T.aggregatorDescription ElSE '' END AS 'Description',
	commCellGroupId AS 'CommCell Group ID <HIDDEN>',commCellGroupName AS 'CommCell Group'
	FROM @tempTable5 T
	ORDER BY aggregatorName,aggregatorId
END
ELSE IF @i_Option = 17 --Get commcell group list
	IF @i_RptId=0
	BEGIN
		SELECT id, name FROM cf_CommcellGroup WITH (NOLOCK) WHERE id > 0
		AND id IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
		ORDER BY name
	END
	ELSE
	BEGIN
		--SELECT -1 AS 'CommCell Group ID <HIDDEN>', 'ALL' AS 'CommCell Group'
		--UNION
		SELECT id AS 'CommCell Group ID <HIDDEN>', name AS 'CommCell Group' FROM cf_CommcellGroup WITH (NOLOCK) WHERE id > 0
		AND id IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
		ORDER BY 'CommCell Group'
	END
ELSE IF @i_Option = 18 --Get aggregator-commcell group association details
	SELECT A.aggregatorId AS 'Service Provider ID <DONOTSHOW>',A.aggregatorName AS 'Service Provider',A.aggregatorDescription AS 'Description',
	C.id AS 'CommCell Group ID <HIDDEN>', C.name AS 'CommCell Group'
	FROM cm_AggregatorAssoc AA WITH (NOLOCK)
	RIGHT JOIN cm_Aggregator A WITH (NOLOCK) ON AA.aggregatorId = A.aggregatorId
	LEFT JOIN cf_CommcellGroup C WITH (NOLOCK) ON C.id = AA.commCellGroupId
	WHERE A.aggregatorId = @i_RptId
	ORDER BY A.aggregatorName, C.name
ELSE IF @i_Option = 19 --Get currency symbol corresponding to the currency code
BEGIN
	DECLARE @currencySymbol NVARCHAR(10) = ''
	DECLARE @xml1 XML
	SELECT @xml1=Value
	FROM cf_SurveyConfig
	WHERE Name='BillingCurrencyList'
	SELECT @currencySymbol=doc.currency.value('@currencySymbol', 'NVARCHAR(10)')
	FROM @xml1.nodes('/BillingCurrencies/Currency') doc(currency)
	WHERE doc.currency.value('@currencyCode', 'NVARCHAR(10)')=@i_ClientGroups--this variable is used as a placeholder for the currency code input
	SELECT CASE WHEN ISNULL(@currencySymbol,'')='' THEN @i_ClientGroups ELSE @currencySymbol END AS 'CurrencySymbol'
END
ELSE IF @i_Option=20 --Get list of partners associated with some contract
BEGIN
	DECLARE @tempTable9 TABLE (partnerId INT, partnerName NVARCHAR(512), discountPercent FLOAT, billCycle NVARCHAR(10), useAsPO NVARCHAR(10),currency NVARCHAR(10))
	INSERT INTO @tempTable9
	SELECT part.partnerId, part.partnerName, ISNULL(discountPercentage,0),
	CASE WHEN billingType=0 THEN 'Monthly' WHEN billingType=1 THEN 'Quarterly' ELSE '' END,
	CASE WHEN useAsPO=0 THEN 'Yes' WHEN useAsPO=1 THEN 'No' ELSE '' END,'USD'
	FROM cm_PartnerToContractMap P WITH (NOLOCK)
	INNER JOIN cm_Partner part WITH (NOLOCK) ON part.partnerId = P.partnerId
	INNER JOIN cm_PartnerAssoc PA WITH (NOLOCK) ON PA.partnerId = part.partnerId
	INNER JOIN cm_AggregatorAssoc AA WITH (NOLOCK) ON AA.aggregatorId = PA.aggregatorId
	INNER JOIN cf_CommcellGroup C WITH (NOLOCK) ON C.id = AA.commCellGroupId
	WHERE AA.commCellGroupId IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
	GROUP BY part.partnerId,part.partnerName,discountPercentage,billingType,useAsPO
	ORDER BY part.partnerName
	UPDATE T SET T.currency = (SELECT currencyCode FROM cm_Contract where contractId =  (select contractId from cm_ClientGroupToContractMap where clientGroupId =
	(select top 1 commCellGroupId from cm_AggregatorAssoc where aggregatorId = (select top 1 aggregatorId from cm_PartnerAssoc where partnerId=T.partnerId))))
	FROM @tempTable9 T
	SELECT partnerId AS 'Group ID <DONOTSHOW>',partnerName AS 'Partner', discountPercent AS 'Discount Percentage', billCycle AS 'Billing Cycle',
	useAsPO AS 'Use As Purchase Order',currency AS 'Currency' FROM @tempTable9
	ORDER BY partnerName
END
ELSE IF @i_Option = 21 --Get list of partners not associated with any contract
	SELECT P.partnerId AS 'Group ID <DONOTSHOW>', partnerName AS 'Partner' FROM cm_Partner P WITH (NOLOCK)
	INNER JOIN cm_PartnerAssoc PA WITH (NOLOCK) ON PA.partnerId=P.partnerId
	INNER JOIN cm_AggregatorAssoc AA ON AA.aggregatorId = PA.aggregatorId
	WHERE P.partnerId NOT IN (SELECT partnerId FROM cm_PartnerToContractMap WITH (NOLOCK))
	AND AA.commCellGroupId IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
	GROUP BY P.partnerId,partnerName
	ORDER BY partnerName
ELSE IF @i_Option = 22 --Get partner-contract association details
BEGIN
	--starting V11SP10 currency will always be that of clientGroup because aggregators and partners are always associated to legacy contract
	DECLARE @tCurrency VARCHAR(10) = ''
	select @tCurrency=currencyCode from cm_Contract where contractId =  (select contractId from cm_ClientGroupToContractMap where clientGroupId =
	(select top 1 commCellGroupId from cm_AggregatorAssoc where aggregatorId = (select top 1 aggregatorId from cm_PartnerAssoc where partnerId=@i_RptId)))
	DECLARE @hasPartnerVolumeDiscount INT=0
	IF EXISTS (SELECT 1 FROM cm_ReportToVolumeDiscountMap WITH (NOLOCK) WHERE reportType=2 AND reportId=@i_RptId)
		SET @hasPartnerVolumeDiscount=1
    SELECT PA.aggregatorId, P.partnerName, PC.useAsPO, @tCurrency currency, ISNULL(PC.discountPercentage,0) discountPercentage
	, @hasPartnerVolumeDiscount hasVolumeDiscount
    FROM cm_PartnerAssoc PA WITH (NOLOCK)
    INNER JOIN cm_Partner P WITH (NOLOCK) ON P.partnerId=PA.partnerId
    INNER JOIN cm_PartnerToContractMap PC WITH (NOLOCK) ON PC.partnerId = P.partnerId
    WHERE PA.partnerId=@i_RptId
END
ELSE IF @i_Option = 23 --Get list of all partners
BEGIN
	DECLARE @tempTable7 TABLE (id INT IDENTITY(1,1),partnerId INT, partnerName NVARCHAR(512), partnerDescription NVARCHAR(MAX), aggregatorId NVARCHAR(512), aggregatorName NVARCHAR(512))
	INSERT @tempTable7
	SELECT P.partnerId, P.partnerName, P.partnerDescription,A.aggregatorId,A.aggregatorName
	FROM cm_PartnerAssoc PA WITH (NOLOCK)
	LEFT JOIN cm_Partner P WITH (NOLOCK)	ON PA.partnerId = P.partnerId
	LEFT JOIN cm_Aggregator A WITH (NOLOCK)	ON A.aggregatorId = PA.aggregatorId
	LEFT JOIN cm_AggregatorAssoc AA WITH (NOLOCK) ON A.aggregatorId = AA.aggregatorId
	LEFT JOIN cf_CommcellGroup C WITH (NOLOCK) ON C.id = AA.commCellGroupId
	WHERE AA.commCellGroupId IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
	GROUP BY P.partnerId, P.partnerName, P.partnerDescription,A.aggregatorId,A.aggregatorName
	ORDER BY P.partnerName,A.aggregatorId,A.aggregatorName
	--add partners without any aggregator associations into the list to display
	INSERT @tempTable7
	SELECT partnerId, partnerName, partnerDescription,'','' FROM cm_Partner WHERE partnerId NOT IN (SELECT DISTINCT partnerId FROM cm_PartnerAssoc)
	SELECT partnerId AS 'Partner ID <DONOTSHOW>',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable7 R WHERE R.partnerId = T.partnerId ORDER BY id) THEN CONVERT(VARCHAR(25),T.partnerId) ElSE '-1' END AS 'PartID <DONOTSHOW>',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable7 R WHERE R.partnerId = T.partnerId ORDER BY id) THEN CONVERT(VARCHAR(25),T.partnerId) ElSE '' END AS 'Partner ID <HIDDEN>',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable7 R WHERE R.partnerId = T.partnerId ORDER BY id) THEN T.partnerName ElSE '' END AS 'Partner',
	CASE WHEN T.id = (SELECT TOP 1 id FROM @tempTable7 R WHERE R.partnerId = T.partnerId ORDER BY id) THEN T.partnerDescription ElSE '' END AS 'Description',
	aggregatorId AS 'Service Provider ID <HIDDEN>',aggregatorName AS 'Service Provider'
	FROM @tempTable7 T
	ORDER BY partnerName,partnerId
END
ELSE IF @i_Option = 24 --Get service provider list
	SELECT A.aggregatorId AS id, aggregatorName AS name FROM cm_Aggregator A WITH (NOLOCK)
	INNER JOIN cm_AggregatorAssoc AA WITH (NOLOCK) ON A.aggregatorId=AA.aggregatorId
	LEFT JOIN cf_CommcellGroup WITH (NOLOCK) ON AA.commCellGroupId=id WHERE id > 0
	AND id IN (SELECT _ID FROM dbo.SplitStringByDelimiter(@i_ClientGroups,','))
	GROUP BY A.aggregatorId, aggregatorName
	ORDER BY aggregatorName
ELSE IF @i_Option = 25 --Get partner-aggregator association details
	SELECT P.partnerId AS 'Partner ID <DONOTSHOW>',P.partnerName AS 'Partner',P.partnerDescription AS 'Description',
	A.aggregatorId AS 'Service Provider ID <HIDDEN>', aggregatorName 'Service Provider'
	FROM cm_PartnerAssoc PA WITH (NOLOCK)
	RIGHT JOIN cm_Partner P WITH (NOLOCK) ON PA.partnerId = P.partnerId
	LEFT JOIN cm_Aggregator A WITH (NOLOCK) ON A.aggregatorId = PA.aggregatorId
	WHERE P.partnerId = @i_RptId
	ORDER BY P.partnerName, A.aggregatorName
ELSE IF @i_Option = 26 --Get list of available tenants
BEGIN
	DECLARE @tempTable6 TABLE (tenantId NVARCHAR(40),tenantName NVARCHAR(1024))
    INSERT INTO @tempTable6 VALUES ('-1', '(default)')--insert default organization. This should always be the first entry
	--add rest of the available organization
	IF @i_RptId<=0
	BEGIN
		INSERT @tempTable6
		SELECT DISTINCT OrgGUID, Organization
		FROM cf_SurveyLicPeakUsageDetails WITH (NOLOCK)
		WHERE OrgGUID IS NOT NULL AND Organization IS NOT NULL AND OrgGUID<>'NULL' AND Organization<>'NULL'
		UNION
		SELECT DISTINCT CONVERT(VARCHAR(40),OrgGUID), ISNULL(T.TenantName,'N/A')
		FROM Lic_PeakUsage P WITH (NOLOCK)
		LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=P.OrgGUID
		WHERE OrgGUID IS NOT NULL
	END
	ELSE
	BEGIN
		INSERT @tempTable6
		SELECT DISTINCT OrgGUID, Organization
		FROM cf_SurveyLicPeakUsageDetails WITH (NOLOCK)
		WHERE OrgGUID IS NOT NULL AND Organization IS NOT NULL AND OrgGUID<>'NULL' AND Organization<>'NULL'
		AND CommServUniqueId IN (SELECT DISTINCT CommcellIdNameMap_ID FROM cf_CommcellGroupAssoc WITH (NOLOCK) WHERE CommCellGroupId=@i_RptId)
		UNION
		SELECT DISTINCT CONVERT(VARCHAR(40),OrgGUID), ISNULL(T.TenantName,'N/A')
		FROM Lic_PeakUsage P WITH (NOLOCK)
		LEFT JOIN cf_SurveyTenants T WITH(NOLOCK) ON T.TenantGUID=P.OrgGUID
		WHERE OrgGUID IS NOT NULL
		AND P.CommServUniqueId IN (SELECT DISTINCT CommcellIdNameMap_ID FROM cf_CommcellGroupAssoc WITH (NOLOCK) WHERE CommCellGroupId=@i_RptId)
	END
	SELECT tenantId AS 'Tenant ID <DONOTSHOW>', tenantName AS 'Tenant'
	FROM @tempTable6 ORDER BY Tenant
END
ELSE IF @i_Option = 27 --Get list of available plans
BEGIN
	IF @i_RptId<=0
	BEGIN
		SELECT DISTINCT PlanName AS 'Plan'
		FROM Lic_CurrentUsage WITH (NOLOCK)
		WHERE PlanName IS NOT NULL AND PlanName<>'NULL' AND PlanName<>'N/A'
		ORDER BY 'Plan'
	END
	ELSE
	BEGIN
		SELECT DISTINCT PlanName AS 'Plan'
		FROM Lic_CurrentUsage WITH (NOLOCK)
		WHERE PlanName IS NOT NULL AND PlanName<>'NULL' AND PlanName<>'N/A'
		AND CommServUniqueId IN (SELECT DISTINCT CommcellIdNameMap_ID FROM cf_CommcellGroupAssoc WITH (NOLOCK) WHERE CommCellGroupId=@i_RptId)
		ORDER BY 'Plan'
	END
END
ELSE IF @i_Option = 28 --Get list of available base plans
BEGIN
	IF @i_RptId<=0
	BEGIN
		SELECT DISTINCT BasePlanName AS 'Base Plan'
		FROM Lic_CurrentUsage WITH (NOLOCK)
		WHERE BasePlanName IS NOT NULL AND BasePlanName<>'NULL' AND BasePlanName<>'N/A'
		ORDER BY 'Base Plan'
	END
	ELSE
	BEGIN
		SELECT DISTINCT BasePlanName AS 'Base Plan'
		FROM Lic_CurrentUsage WITH (NOLOCK)
		WHERE BasePlanName IS NOT NULL AND BasePlanName<>'NULL' AND BasePlanName<>'N/A'
		AND CommServUniqueId IN (SELECT DISTINCT CommcellIdNameMap_ID FROM cf_CommcellGroupAssoc WITH (NOLOCK) WHERE CommCellGroupId=@i_RptId)
		ORDER BY 'Base Plan'
	END
END
ELSE IF @i_Option = 29 --Get volume discount for a given commcell group or service provider
BEGIN
	--@i_ClientGroups=reportType (0=commcell group, 1=service provider, 2=partner), @i_RptId=reportId
	SELECT V.lowerThreshold 'Lower Threshold', V.upperThreshold 'Upper Threshold', discountPercentage 'Discount Percentage' FROM cm_VolumeDiscount V WITH (NOLOCK)
	INNER JOIN cm_ReportToVolumeDiscountMap R WITH (NOLOCK) ON R.reportToVolumeDiscountMapId=V.reportToVolumeDiscountMapId
	WHERE R.reportType=CONVERT(INT, @i_ClientGroups) AND R.reportId=@i_RptId
	ORDER BY V.lowerThreshold, V.upperThreshold
END
GO

IF EXISTS (select * from GxQscripts where name = 'CM_RptContractManagement')
	delete from GxQscripts where name = 'CM_RptContractManagement'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_RptContractManagement')
	delete from GXDBVersions where aliasname = 'CM_RptContractManagement'
GO

insert into GXDBVersions values(2, 'CM_RptContractManagement',  '00010001000200270000', 'CM_RptContractManagement', '00010001000200270000')
GO

