

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/CM_ManageContract.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/CM_ManageContract.sp,v $ $Id: CM_ManageContract.sp,v 1.1.2.10 2020/12/19 05:11:52 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='CM_ManageContract')
BEGIN
	print '>>> Drop Stored Procedure: CM_ManageContract <<<'
	drop procedure CM_ManageContract
END
IF EXISTS (select * from GxQscripts where name='CM_ManageContract')
	delete from GxQscripts where name = 'CM_ManageContract'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_ManageContract')
	delete from GXDBVersions where aliasname = 'CM_ManageContract'
GO
print '... Creating Procedure: CM_ManageContract'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure CM_ManageContract
  @i_UserId INT = NULL,
  @i_Option INT = 1,
  @i_XML NTEXT = ''
AS
--Option = 1, Add a contract & its billing group associations
--Option = 2, Modify an existing contract & its billing group associations
--Option = 3, Delete an existing contract & its billing group associations
--Option = 4, Change the Contract status to approved/unapproved
SET NOCOUNT ON
-- ----------------------------------------------------------------------------
--   VARIABLES
-- ----------------------------------------------------------------------------
DECLARE @idoc			INT
DECLARE @retValue		INT
DECLARE @contractId		INT = 0
DECLARE @contractName	NVARCHAR(1024) = ''
DECLARE @description	NVARCHAR(MAX) = ''
DECLARE @status			INT = 0
DECLARE @errMsg			NVARCHAR(256)
DECLARE @currency		NVARCHAR(10)
DECLARE @contractType	INT = 0
-- ----------------------------------------------------------------------------
--   Start a Transaction
-- ----------------------------------------------------------------------------
BEGIN TRANSACTION
	-- ----------------------------------------------------------------------------
	--   SETTINGS
	-- ----------------------------------------------------------------------------
	SET @retValue       = 0
	SET @errMsg      = 'Procedure Completed Successfully'
	-- ----------------------------------------------------------------------------
	--   TRY-CATCH Block
	-- ----------------------------------------------------------------------------
	BEGIN TRY
		--   PARSE XML
		EXEC sp_xml_preparedocument @idoc OUTPUT, @i_XML
		IF @i_Option = 4 --Update status column in cm_Contract table. 0=Contract is unapproved, 1=Contract is Approved
		BEGIN
			SELECT @contractId = contractId, @status = status
			FROM   OPENXML(@idoc, '/WebReport_Contract', 3)
			WITH   (contractId INTEGER,
					status INTEGER)
			UPDATE cm_Contract SET status=@status WHERE contractId=@contractId
			SET @errMsg='Contract status has been updated'
		END
		ELSE
		BEGIN
			SELECT @contractId = contractId, @contractName = contractName, @description = description, @currency = currency, @contractType=contractType
			FROM   OPENXML(@idoc, '/WebReport_Contract', 3)
			WITH   (contractId INTEGER,
					contractName NVARCHAR(1024),
					description NVARCHAR(MAX),
					currency NVARCHAR(10),
					contractType INTEGER)
			DECLARE @temp TABLE (billingGroupId INT, price FLOAT, baseLine FLOAT, lowerLimit FLOAT, upperLimit FLOAT, tenantId NVARCHAR(40),tenantName NVARCHAR(1024), includeInVolumeDiscount INT)
			DECLARE @bgid INT = 0
			DECLARE @baseline INT = 0
			DECLARE @includeInVolumeDiscount INT = 0
			IF @i_Option = 1 --Add new contract and its billing group associations
			BEGIN
				IF EXISTS (SELECT * FROM cm_Contract WITH (NOLOCK) WHERE contractName=@contractName)
				BEGIN
					SET @errMsg='Insertion not allowed as this contract name already exists'
					SET @retValue = -1
				END
				ELSE
				BEGIN
					INSERT INTO cm_Contract VALUES (@contractName,@description,@contractType,0,@currency)
					SELECT @contractId=SCOPE_IDENTITY()
					INSERT @temp
					SELECT billingGroupId AS billingGroupId,CAST(price AS FLOAT) AS price,
						ISNULL(baseLine,0) AS baseLine,ISNULL(lowerLimit,0) AS lowerLimit,ISNULL(upperLimit,0) AS upperLimit,ISNULL(tenantId,'-1') AS tenantId, ISNULL(tenantName,'(default)') AS tenantName, ISNULL(includeInVolumeDiscount, 0) AS includeInVolumeDiscount
						FROM   OPENXML(@idoc, '/WebReport_Contract/billingGroup', 3)
						WITH	(billingGroupId	INTEGER,
									price			VARCHAR(1024),
									baseLine		FLOAT,
									lowerLimit		FLOAT,
									upperLimit		FLOAT,
									tenantId		NVARCHAR(40),
									tenantName		NVARCHAR(1024),
									includeInVolumeDiscount	INTEGER)
					IF @contractType=0--enter CommCell based contracts
					BEGIN
						DECLARE billingGroup_cursor CURSOR FOR
							SELECT distinct billingGroupId, MAX(includeInVolumeDiscount) FROM @temp GROUP BY billingGroupId
						OPEN billingGroup_cursor
						FETCH NEXT FROM billingGroup_cursor INTO @bgid, @includeInVolumeDiscount
						WHILE @@FETCH_STATUS = 0
						BEGIN
							--find the baseline for this billing group
							SELECT top 1 @baseline=CAST(baseLine AS INT) FROM @temp WHERE billingGroupId=@bgid
							--make the baseline as the first entry in the mapping table
							INSERT cm_ContractToBillingGroupMap
							SELECT @contractId AS contractId, @bgid, 0, 0, @baseline, @includeInVolumeDiscount
							--now make the other entries into mapping table
							INSERT cm_ContractToBillingGroupMap
							SELECT @contractId AS contractId, @bgid, price, CAST(lowerLimit AS INT), CAST(upperLimit AS INT), @includeInVolumeDiscount
							FROM @temp
							WHERE billingGroupId=@bgid
							--now update the rows having lowerlimit=0 with lowerlimit=baseline
							UPDATE cm_ContractToBillingGroupMap SET lowerLimit=@baseline
							WHERE lowerLimit=0 AND billingGroupId=@bgid AND price > 0 AND contractId=@contractId
							--now update the rows having upperlimit=0 with upperlimit=-1
							UPDATE cm_ContractToBillingGroupMap SET upperLimit=-1
							WHERE upperLimit=0 AND billingGroupId=@bgid AND price > 0 AND contractId=@contractId
						FETCH NEXT FROM billingGroup_cursor INTO @bgid, @includeInVolumeDiscount
						END
						CLOSE billingGroup_cursor
						DEALLOCATE billingGroup_cursor
					END
					ELSE--enter Tenant based contracts
					BEGIN
						--make entries into mapping table
						INSERT cm_ContractToTenantToBillingGroupMap
						SELECT @contractId, tenantId, tenantName, billingGroupId, baseLine, lowerLimit, upperLimit, price, includeInVolumeDiscount, 0
						FROM @temp
					END
					SET @errMsg='Contract has been created successfully'
				END
			END
			ELSE IF @i_Option = 2 --Contract already existing hence, modify it & its billing group association
			BEGIN
				IF EXISTS (SELECT * FROM cm_Contract WITH (NOLOCK) WHERE contractName=@contractName AND contractId <> @contractId)
				BEGIN
					SET @errMsg='Updation not allowed as this contract name already exists'
					SET @retValue = -1
				END
				ELSE
				BEGIN
					UPDATE cm_Contract SET contractName=@contractName, description=@description, flag=@contractType, currencyCode=@currency WHERE contractId=@contractId
					INSERT @temp
					SELECT billingGroupId AS billingGroupId,CAST(price AS FLOAT) AS price,
						ISNULL(baseLine,0) AS baseLine,ISNULL(lowerLimit,0) AS lowerLimit,ISNULL(upperLimit,0) AS upperLimit,ISNULL(tenantId,'-1') AS tenantId,ISNULL(tenantName,'(default)') AS tenantName, ISNULL(includeInVolumeDiscount, 0) AS includeInVolumeDiscount
						FROM   OPENXML(@idoc, '/WebReport_Contract/billingGroup', 3)
						WITH	(billingGroupId	INTEGER,
								price			VARCHAR(1024),
								baseLine		FLOAT,
								lowerLimit		FLOAT,
								upperLimit		FLOAT,
								tenantId		NVARCHAR(40),
								tenantName		NVARCHAR(1024),
								includeInVolumeDiscount INTEGER)
					--delete all existing billing group associations to this contract
					--both these tables should be cleaned up before new updations
					--if delete statements are put inside IF-ELSE, stale entries will get retained in cases where contract type is changed
					DELETE FROM cm_ContractToBillingGroupMap WHERE contractId=@contractId
					DELETE FROM cm_ContractToTenantToBillingGroupMap WHERE contractId=@contractId
					--insert new associations
					IF @contractType=0--enter CommCell based contracts
					BEGIN
						DECLARE billingGroup_cursor CURSOR FOR
							SELECT distinct billingGroupId, MAX(includeInVolumeDiscount) FROM @temp GROUP BY billingGroupId
						OPEN billingGroup_cursor
						FETCH NEXT FROM billingGroup_cursor INTO @bgid, @includeInVolumeDiscount
						WHILE @@FETCH_STATUS = 0
						BEGIN
							--find the baseline for this billing group
							SELECT top 1 @baseline=CAST(baseLine AS INT) FROM @temp WHERE billingGroupId=@bgid
							--make the baseline as the first entry in the mapping table
							INSERT cm_ContractToBillingGroupMap
							SELECT @contractId AS contractId, @bgid, 0, 0, @baseline, @includeInVolumeDiscount
							--now make the other entries into mapping table
							INSERT cm_ContractToBillingGroupMap
							SELECT @contractId AS contractId, @bgid, price, CAST(lowerLimit AS INT), CAST(upperLimit AS INT), @includeInVolumeDiscount
							FROM @temp
							WHERE billingGroupId=@bgid
							--now update the rows having lowerlimit=0 with lowerlimit=baseline
							UPDATE cm_ContractToBillingGroupMap SET lowerLimit=@baseline
							WHERE lowerLimit=0 AND billingGroupId=@bgid AND price > 0 AND contractId=@contractId
							--now update the rows having upperlimit=0 with upperlimit=-1
							UPDATE cm_ContractToBillingGroupMap SET upperLimit=-1
							WHERE upperLimit=0 AND billingGroupId=@bgid AND price > 0 AND contractId=@contractId
						FETCH NEXT FROM billingGroup_cursor INTO @bgid, @includeInVolumeDiscount
						END
						CLOSE billingGroup_cursor
						DEALLOCATE billingGroup_cursor
					END
					ELSE
					BEGIN
						INSERT cm_ContractToTenantToBillingGroupMap
						SELECT @contractId, tenantId, tenantName, billingGroupId, baseLine, lowerLimit, upperLimit, price, includeInVolumeDiscount, 0
						FROM @temp
					END
					SET @errMsg='Contract has been modified successfully'
				END
			END
			ELSE IF @i_Option = 3
			BEGIN
				--delete a contract and all its associations to billing groups & tenants
				DELETE FROM cm_ContractToTenantToBillingGroupMap WHERE contractId=@contractId
				DELETE FROM cm_ContractToBillingGroupMap WHERE contractId=@contractId
				DELETE FROM cm_ClientGroupToContractMap WHERE contractId=@contractId
				DELETE FROM cm_Contract WHERE contractId=@contractId
				SET @errMsg='Contract has been deleted successfully'
			END
		END
	END TRY
	BEGIN CATCH
/*
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
*/
		SET @retValue=ERROR_NUMBER()
		SET @errMsg=ERROR_MESSAGE()
	END CATCH
---- ----------------------------------------------------------------------------
----   CLEAN UP
---- ----------------------------------------------------------------------------
EXEC sp_xml_removedocument @idoc
IF @retValue <> 0
	ROLLBACK TRANSACTION
ELSE
	COMMIT TRANSACTION
-- ----------------------------------------------------------------------------
--   Return back transaction details
-- ----------------------------------------------------------------------------
SELECT @retValue AS errorCode, @errMsg AS errorMessage
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'CM_ManageContract')
	delete from GxQscripts where name = 'CM_ManageContract'
GO

IF EXISTS (select * from GXDBVersions where aliasname='CM_ManageContract')
	delete from GXDBVersions where aliasname = 'CM_ManageContract'
GO

insert into GXDBVersions values(2, 'CM_ManageContract',  '00010001000200100000', 'CM_ManageContract', '00010001000200100000')
GO

