

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/SplitVersionString.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: SplitVersionString'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[SplitVersionString]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[SplitVersionString]
  delete from GXDBVersions where name = 'SplitVersionString' and type = 5
END
GO

	CREATE FUNCTION dbo.SplitVersionString
	(
		@Version NVARCHAR(50)
	)
	RETURNS
	@Result table
	(
		Release	INT,
		ServicePack	INT,
		MaintenanceRelease INT
	)
	AS
 	BEGIN
	SET @Version = RTRIM(LTRIM(@Version))

	DECLARE @posSP  INT = 0
	DECLARE @relNo  INT = 0
	DECLARE @spNo   INT = 0
	DECLARE @hpkNo   INT = 0
	DECLARE @posSPEnd INT = 0

	IF @Version <> '' AND LEFT(@Version,1) like '[0-9]%'
	BEGIN
		SET @Version  = (REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(@Version,'(BUILD80)',''),' R2', ''),'.0 SP', '.'),' SP', '.'),' HPK', '.'),'+', ''),'-', ''),'a', '.1'),'b', '.2'),'c', '.3'), ' ', ''))
		SET @Version =
			CASE LEN(@Version) - LEN(REPLACE(@Version, '.', ''))
				WHEN 0 THEN CONCAT(@Version, '.0.0')
				WHEN 1 THEN CONCAT(@Version, '.0')
				WHEN 2 THEN @Version
			END

		SET @posSP = CHARINDEX('.', @Version)
	 	SET @relNo = CAST(SUBSTRING(@Version, 0, @posSP) AS FLOAT)
	 	SET @posSPEnd = CHARINDEX('.', @Version, @posSP+1)
	 	SET @spNo = CAST(SUBSTRING(@Version, @posSP+1, CASE WHEN @posSPEnd > 0 THEN @posSPEnd ELSE LEN(@Version) END) AS FLOAT)
		IF @posSPEnd > 0 SET @hpkNo = CAST(SUBSTRING(@Version, @posSPEnd+1, LEN(@Version)) AS FLOAT)
	END

	INSERT INTO @Result
	SELECT @relNo, @spNo, @hpkNo
	RETURN
	END
	GO


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [SplitVersionString]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'SplitVersionString' AND revision = '1.1.4.5')

  insert into GXDBVersions values(5, 'SplitVersionString',  '1.1.4.5', 'SplitVersionString', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
