

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptMetricsTrend.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptMetricsTrend'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptMetricsTrend]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptMetricsTrend]
  delete from GXDBVersions where name = 'RptMetricsTrend' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptMetricsTrend]
	(
		@i_trend int = 0
	)
	RETURNS @Results TABLE
	(
		STARTDATE DATE,
		ENDDATE DATE
	)
	AS
	BEGIN
	DECLARE @CNT INT
	DECLARE @ENDDATE DATE=DATEADD(DAY,1,GETUTCDATE())
    DECLARE @STARTDATE DATE=DATEADD(DAY,-1,@ENDDATE)

	SELECT @CNT=(CASE
		WHEN @i_trend = 1 THEN 7
		WHEN @i_trend = 2 THEN DATEDIFF(DAY,GETDATE(),DATEADD(MONTH,1,GETDATE()))
		WHEN @i_trend = 3 THEN DATEDIFF(DAY,GETDATE(),DATEADD(MONTH,3,GETDATE()))
		WHEN @i_trend = 4 THEN DATEDIFF(DAY,GETDATE(),DATEADD(MONTH,6,GETDATE()))
		WHEN @i_trend = 5 THEN DATEDIFF(DAY,GETDATE(),DATEADD(YEAR,1,GETDATE()))
		END)
	WHILE @CNT >0
	BEGIN
		INSERT INTO @Results values(@STARTDATE,@ENDDATE)
		SET @ENDDATE = @STARTDATE
		SET @STARTDATE=DATEADD(DAY,-1,@ENDDATE)
		SET @CNT=@CNT-1
	END

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptMetricsTrend]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptMetricsTrend' AND revision = '1.3')

  insert into GXDBVersions values(5, 'RptMetricsTrend',  '1.3', 'RptMetricsTrend', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
