

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptMetricsReportsFlags.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptMetricsReportsFlags'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptMetricsReportsFlags]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptMetricsReportsFlags]
  delete from GXDBVersions where name = 'RptMetricsReportsFlags' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptMetricsReportsFlags] (
		@ReportId int = 0
		)
		RETURNS @MetricsReportsTable TABLE (
			ReportId			int,
			ReportName			NVARCHAR(MAX),
			Status				int,
			OpFlags				int,
			DispFlag			int,
			Retention			int,
			isInternal			int,
			AltNamesXml			xml
		)
	AS
	BEGIN

		INSERT INTO @MetricsReportsTable
		SELECT
			ReportId,
			Name,
			ISNULL(userprops.u.value('@status', 'int'), Status),
			ISNULL(userprops.u.value('@opflags', 'int'), OpFlags),
			ISNULL(userprops.u.value('@dispflag', 'int'), DispFlag),
			ISNULL(userprops.u.value('@retention', 'int'),0),
			0,
			AltNamesXml
		FROM cf_WebConsoleReports R
			OUTER APPLY R.userModifiedProps.nodes('/userModifiedProps') AS userprops(u)
		WHERE (@ReportId = 0 OR R.ReportId = @ReportId)

		DECLARE @tblInternalReports TABLE (ReportId int)
		INSERT INTO @tblInternalReports
		SELECT R.ReportId
		FROM @MetricsReportsTable R
			INNER JOIN cf_WebConsoleReportQueryMap RMap ON RMap.ReportId = R.ReportId
			INNER JOIN cf_CommservSurveyGroupMap GMap ON GMap.SurveyId = RMap.QueryId
			INNER JOIN cf_CommservSurveyGroups G ON GMap.GroupId = G.SurveyGroupId
		WHERE G.Flags & 1 = 1

		UPDATE R
		SET isInternal = 1
		FROM @MetricsReportsTable R INNER JOIN @tblInternalReports I ON R.ReportId = I.ReportId

		DECLARE @tblRetention TABLE (ReportId int, Retention int)

		INSERT INTO @tblRetention
		SELECT R.ReportId, CASE WHEN R.Retention > 0 THEN R.Retention ELSE MIN(Q.DataRetentionDays) END
		FROM @MetricsReportsTable R
				INNER JOIN cf_WebConsoleReportQueryMap M WITH(NOLOCK) ON R.ReportId = M.ReportId
				INNER JOIN cf_CommservSurveyQueries Q WITH(NOLOCK) ON M.QueryId = Q.QueryId
		GROUP BY R.reportId, R.Retention

		UPDATE R
		SET Retention = Q.Retention
		FROM @MetricsReportsTable R INNER JOIN @tblRetention Q ON R.ReportId = Q.ReportId

		RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptMetricsReportsFlags]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptMetricsReportsFlags' AND revision = '1.1.2.5')

  insert into GXDBVersions values(5, 'RptMetricsReportsFlags',  '1.1.2.5', 'RptMetricsReportsFlags', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
