

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptMetricsCommCellDetails.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptMetricsCommCellDetails'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptMetricsCommCellDetails]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptMetricsCommCellDetails]
  delete from GXDBVersions where name = 'RptMetricsCommCellDetails' and type = 5
END
GO

	declare @sqlQuery nvarchar(256)
	IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr enabled' AND CAST(value_in_use AS INT) = 0)
	BEGIN
	set @sqlQuery = 'USE MASTER;
	  EXEC sp_configure ''clr enabled'' , 1;
	  RECONFIGURE;
	 '
	EXECUTE sp_executeSql @sqlQuery
	END
	IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr strict security' AND CAST(value_in_use AS INT) = 0)
	BEGIN
	set @sqlQuery = 'USE MASTER;
	  EXEC sp_configure ''clr strict security'' , 1;
	  RECONFIGURE;
	 '
	EXECUTE sp_executeSql @sqlQuery
	END
	go
	CREATE FUNCTION [dbo].[RptMetricsCommCellDetails]
	(
		@i_CSUniqueId INT = 0,
		@i_CSGroupId INT = -1,
		@QueryId INT = 0,
		@i_UserId INT = 0,
		@i_OpType INT = 1
	)
	RETURNS @Results TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		CommCellID VARCHAR(32) NOT NULL,
		CommServIP VARCHAR(256) NOT NULL,
		CSDBIPAddr VARCHAR(256) NOT NULL,
		CommServGUID VARCHAR(256) NOT NULL,
		CommCellName NVARCHAR(256) NOT NULL,
		CustomerName NVARCHAR(256),
		CommServName NVARCHAR(256),
		CommServTZ VARCHAR(256),
		CommServVersion VARCHAR(256),
		CommServEdition VARCHAR(256),
		CommServInstallDate DATE,
		MonitoredClientGroup NVARCHAR(MAX),
		LastCollectionTime DATETIME,
		IsHealthEnabled varchar(4),
		LastHealthCollectionTime DATETIME,
		IsUCEnabled varchar(4),
		LastUCCollectionTime DATETIME,
		IsUREnabled varchar(4),
		LastURCollectionTime DATETIME,
		IsActivityEnabled varchar(4),
		LastActivityCollectionTime DATETIME,
		IsChargeBackEnabled varchar(4),
		LastchargeBackTime DATETIME,
		IsAuditEnabled varchar(4),
		LastHeartbeatTime DATETIME,
		LastAuditTime DATETIME,
		LicExpirationDate VARCHAR(12),
		LicenseServerFlags INT
	)
	AS
	BEGIN


	IF @QueryId <= 0
		SET @QueryId = 2
	ELSE IF @QueryId = 77
		SET @QueryId = 67
	ELSE IF @QueryId IN (99, 100, 112)
		SET @QueryId = 23
	ELSE IF @QueryId IN (98, 101, 102)
		SET @QueryId = 24
	ELSE IF @QueryId = 105
		SET @QueryId = 39
	ELSE IF @QueryId = 111
		SET @QueryId = 26

	INSERT INTO @Results
	SELECT
		cc.CommServUniqueId, cc.CommCellID, cc.CommServIP, map.CSDBIPAddr, cc.CommServGUID, cc.DisplayName,
		cc.CustomerName, cc.CommServName, cc.CommServTimeZone, cc.CommServVersion,
		CASE
			WHEN cc.CommServEdition = '0'   THEN 'CommVault'
			WHEN cc.CommServEdition = '1'   THEN 'CommVault'
			WHEN cc.CommServEdition = '6'   THEN 'DELL Express'  -- Deprecated brand
			WHEN cc.CommServEdition = '8'   THEN 'DELL Enterprise'  -- Deprecated brand
			WHEN cc.CommServEdition = '13'  THEN 'DELL Cowboy'  -- Deprecated brand
			WHEN cc.CommServEdition = '14'  THEN 'Hitachi'
			WHEN cc.CommServEdition = '16'  THEN 'CommVault Express'
			WHEN cc.CommServEdition = '17'  THEN 'BULL'
			WHEN cc.CommServEdition = '101' THEN 'Custom'
			WHEN cc.CommServEdition = '102'  THEN 'GTS'
			WHEN cc.CommServEdition = '105' THEN 'NetApp'
			WHEN cc.CommServEdition = '106' THEN 'Virtual Server'
			WHEN cc.CommServEdition = '107' THEN 'Medical Imaging'
			WHEN cc.CommServEdition = '108' THEN 'IntelliSnap Recovery Manager'
			WHEN cc.CommServEdition = '110' THEN 'Fujitsu'
			WHEN cc.CommServEdition = '111' THEN 'Sapphire'
			WHEN cc.CommServEdition = '113' THEN 'Commvault Edge'
			WHEN cc.CommServEdition = '114' THEN 'MSP'
			WHEN cc.CommServEdition = '115' THEN 'IntelliSnap For NetApp'
			WHEN cc.CommServEdition = '100' OR cc.CommServEdition = 'DocTeam' OR cc.CommServEdition = '109'  THEN 'Obsolete'
			WHEN LEN(cc.CommServEdition) > 0 THEN  cc.CommServEdition
			ELSE 'Obsolete'
		END,
		NULL,
		'N/A',
		dbo.UTCToLocalDateTimeConversion(map.ModifiedTime,cc.CommServTimeZone),'No', NULL, 'No', NULL, 'No', NULL, 'No', NULL, 'No', NULL,'No', NULL, NULL,
		CASE WHEN ISNULL(info.LicExpirationDate, 0) <= 0 THEN ''
			 ELSE CONVERT(NVARCHAR(12), dbo.UTCToLocalDateTimeConversion(dbo.GetDateTime(info.LicExpirationDate), cc.CommServTimeZone), 107)
		END,
		0
	FROM dbo.cf_SurveyResultFuncV1(2, @i_CSUniqueId, 1, NULL, NULL, @i_UserId, @i_CSGroupId) as cc
		INNER JOIN cf_SurveyCSDetailsInfo as info ON info.SurveyResultId = cc.SurverResultId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId
	order by map.ModifiedTime desc

	--Update CS Install Date
	UPDATE result SET result.CommServInstallDate = sub.InstallDate
		FROM @Results AS result
		INNER JOIN
			(SELECT
				resultView.CommServUniqueId AS CommServUniqueId,
				CAST(csInfo.InstallTime AS DATE) AS InstallDate,
				ROW_NUMBER() OVER (PARTITION BY resultView.CommServUniqueId ORDER BY csInfo.ReleaseId ) AS RowId
				FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(38, @i_CSUniqueId, 1, NULL, NULL, @i_UserId, @i_CSGroupId) AS resultView
					ON resultView.SurverResultId = csInfo.SurveyResultId
					AND csInfo.ReleaseId > 0
				)sub
		ON sub.RowId = 1 AND sub.CommServUniqueId = result.CommServUniqueId

	--Update Monitored Client Group
	UPDATE @Results SET MonitoredClientGroup = J.ClientGroups
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(23, @i_CSUniqueId, 1, NULL, NULL, @i_UserId, @i_CSGroupId) AS cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_SurveyLargestClientsByBKPSize AS J WITH (NOLOCK)
			ON J.SurveyResultId = cc.SurverResultId

	UPDATE @Results SET LastCollectionTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(2, @i_CSUniqueId, 1, NULL, NULL, @i_UserId, @i_CSGroupId) AS cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId


	--Update Health Check Status
	UPDATE @Results SET IsHealthEnabled = CASE WHEN (CommCellSurveyServices&1)=1 THEN 'Yes' ELSE 'NO' END , LastHealthCollectionTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(23, @i_CSUniqueId, 1, NULL, NULL, @i_UserId, @i_CSGroupId) AS cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId


	--Update Upgrade Check Status
	UPDATE @Results	SET IsUCEnabled = CASE WHEN (CommCellSurveyServices&2)=2 THEN 'Yes' ELSE 'NO' END , LastUCCollectionTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(40, @i_CSUniqueId, 1, NULL, NULL, @i_UserId, @i_CSGroupId) as cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId


	--Update Activity Status
	UPDATE @Results SET IsActivityEnabled = CASE WHEN (CommCellSurveyServices&4)=4 THEN 'Yes' ELSE 'NO' END , LastActivityCollectionTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(51, @i_CSUniqueId, 1, NULL, NULL, @i_UserId, @i_CSGroupId) as cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId


	--Update Charge Back Status
	UPDATE @Results SET IsChargeBackEnabled = CASE WHEN (CommCellSurveyServices&32)=32 THEN 'Yes' ELSE 'NO' END , LastchargeBackTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(136, @i_CSUniqueId, 1, NULL, NULL, @i_UserId, @i_CSGroupId) as cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId



	--Update Audit Status
	UPDATE @Results SET IsAuditEnabled = CASE WHEN (CommCellSurveyServices&16)=16 THEN'Yes' ELSE 'NO' END , LastAuditTime = cc.LogDate
	FROM @Results AS result
		INNER JOIN dbo.cf_SurveyResultFuncV1(63, @i_CSUniqueId, 1, NULL, NULL, @i_UserId, @i_CSGroupId) as cc
			ON result.CommServUniqueId = cc.CommServUniqueId
		INNER JOIN cf_CommcellIdNameMap AS map WITH (NOLOCK)
			ON map.ID = cc.CommServUniqueId

	--Update Heartbeat Time
	UPDATE @Results SET LastHeartbeatTime = cs.ModifiedTime
	FROM @Results as result
		INNER JOIN cf_CommcellIdNameMap as cs
			ON result.CommServUniqueId = cs.ID


	UPDATE @Results SET LicenseServerFlags = LS.LicenseServerFlags
	FROM @Results AS result
		INNER JOIN (
		SELECT	R.CommcellIdNameMap_ID, MAX(S.QuotaEnabled) AS LicenseServerFlags
		FROM	cf_CommservSurveyResults R WITH (NOLOCK)
				INNER JOIN (SELECT SurveyResultId, MAX(QuotaEnabled&(1|4)) AS QuotaEnabled
					FROM cf_SurveyClientGroupQuotaUsage WITH (NOLOCK)
					WHERE ClientGroupName = 'CommCell Inherited Capacity'
					GROUP BY SurveyResultId) S ON R.CommservSurveyResults_ID = S.SurveyResultId
		GROUP BY R.CommcellIdNameMap_ID
		) LS ON result.CommServUniqueId = LS.CommcellIdNameMap_ID

	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptMetricsCommCellDetails]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptMetricsCommCellDetails' AND revision = '1.18.2.13')

  insert into GXDBVersions values(5, 'RptMetricsCommCellDetails',  '1.18.2.13', 'RptMetricsCommCellDetails', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
