

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetValueAssessmentFunc.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: RptGetValueAssessmentFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetValueAssessmentFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetValueAssessmentFunc]
  delete from GXDBVersions where name = 'RptGetValueAssessmentFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetValueAssessmentFunc]
	(
		@i_CommServUniqueId INT = 0,
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL
	)
	RETURNS @TblSurveyResult TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		MonitorId INTEGER NOT NULL,
		Monitor NVARCHAR(MAX) NOT NULL,
		Status VARCHAR(10) NOT NULL,
		Result NVARCHAR(MAX),
		Recommendation NVARCHAR(MAX)
	)
	AS
	BEGIN
	DECLARE @strGood		VARCHAR(10) = '1_Good'
	DECLARE @strInfo		VARCHAR(10) = '2_Info'
	DECLARE @strwarning		VARCHAR(10) = '3_Warning'
	DECLARE @strCritical	VARCHAR(10) = '4_Critical'
	DECLARE @strUnknown		VARCHAR(10) = '0_Unknown'

	DECLARE @queryId			INT = 97
	DECLARE @parameterName		NVARCHAR(256)
	DECLARE @warningThreshold	INT
	DECLARE @criticalThreshold	INT
	DECLARE @infoMessage		NVARCHAR(MAX)
	DECLARE @goodMessage		NVARCHAR(MAX)
	DECLARE @warningMessage		NVARCHAR(MAX)
	DECLARE @criticalMessage	NVARCHAR(MAX)

	IF (@i_CommServUniqueId IS NULL OR @i_CommServUniqueId = 0)
		RETURN
	IF NOT EXISTS (SELECT * FROM dbo.cf_SurveyResultFuncV1(97, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId))
		RETURN

	INSERT INTO @TblSurveyResult
			SELECT	@i_CommServUniqueId, survey.QueryId, CASE WHEN LEN(map.ParameterName) > 0 THEN map.ParameterName ELSE survey.Name END, @strUnknown, '', ''
	FROM	cf_CommservSurveyQueries AS survey
			INNER JOIN dbo.RptGetMetricsQueryFlags(0) qflags ON survey.QueryId = qFlags.QueryId
			INNER JOIN cf_CommservSurveyGroupMap AS map
				ON map.SurveyId = survey.QueryId
				AND qflags.QueryFlags & 4 = 4
				AND map.GroupId = 15
				AND map.SurveyId <> 171
			INNER JOIN cf_CommservSurveyGroups as sGroup
				ON sGroup.SurveyGroupId = map.GroupId

	DECLARE @TblLatestResult TABLE (QueryId INT, SurveyResultId BIGINT, LogDate DATETIME)

	INSERT	INTO @TblLatestResult
	SELECT	DISTINCT R.QueryId, R.CommservSurveyResults_ID, R.LogDate
	FROM	cf_CommservSurveyResults R WITH (NOLOCK)
	INNER JOIN @TblSurveyResult S ON (R.QueryId = S.MonitorId OR R.QueryId IN (23, 24, 26))
	WHERE	R.CommcellIdNameMap_ID = @i_CommServUniqueId AND R.Flags = 1

	--If NO health check done - return
	IF NOT EXISTS (SELECT * FROM @TblLatestResult WHERE QueryID = @queryId)
	BEGIN
		DELETE FROM @TblSurveyResult
		RETURN
	END

	DECLARE @tmpStatus VARCHAR(10) = @strInfo
	DECLARE @tmpLogDate VARCHAR(20)
	DECLARE @tmpResult NVARCHAR(MAX) = ''
	DECLARE @tmpRecommendation NVARCHAR(MAX) = ''

	SELECT	@tmpLogDate = csInfo.LogDate
	FROM	cf_SurveySourceDeDupEfficiency AS csInfo WITH (NOLOCK)
	INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND result.QueryID = @queryId

	DECLARE @totSCs INT = 0
	DECLARE @SCsWithLongJobs INT = 0
	DECLARE @SCsWithLongJobsPercent DECIMAL(32,2) = 0
	DECLARE	HealthQueryCur CURSOR FOR
	SELECT	QueryId,
		ParameterName,
			WarningThreshold,
			CriticalThreshold,
			InfoMessage,
			GoodMessage,
			WarningMessage,
			CriticalMessage
	FROM	cf_ReportParameterView where ParamId IN (30, 31, 32, 33, 34, 35, 38, 39, 40, 41)

	OPEN HealthQueryCur

	FETCH NEXT FROM HealthQueryCur
	INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage

	WHILE @@FETCH_STATUS <> -1
	BEGIN
		SET @tmpStatus = @strUnknown
		SET @tmpResult = ''
		SET @tmpRecommendation = @infoMessage

		--Network Efficiency
		IF @queryId = 97
		BEGIN
				DECLARE @NonMASubClients INT = 0
				DECLARE @NonMASCWithSourceDeDup INT = 0
				DECLARE @NonMASCWithSourceDeDupPercent DECIMAL(32,2) = 0
			DECLARE @AvgNetworkSavingsFrmDeDupe DECIMAL(32,2) = 0

			SELECT @NonMASubClients = csInfo.NonMASubClients, @NonMASCWithSourceDeDup = csInfo.NonMASCWithSourceDeDup,
					@AvgNetworkSavingsFrmDeDupe = csInfo.AvgDeDupSavings
			FROM	cf_SurveySourceDeDupEfficiency AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId

			SELECT @NonMASCWithSourceDeDupPercent = CASE WHEN @NonMASubClients = 0 THEN 0 ELSE (@NonMASCWithSourceDeDup*100.0)/@NonMASubClients END

			SET @tmpStatus =
			CASE
				WHEN @NonMASubClients = 0 THEN @strInfo
				WHEN @NonMASCWithSourceDeDupPercent >= @warningThreshold THEN @strGood
				WHEN @NonMASCWithSourceDeDupPercent > @criticalThreshold AND @NonMASCWithSourceDeDupPercent < @warningThreshold THEN @strWarning
				ELSE @strCritical
			END

			SET @tmpResult =
			CASE
				WHEN @NonMASubClients = 0 THEN 'No Subclients are found protected over the network (LAN) by deduplication storage policies.'
				ELSE '<b>' + CAST(@NonMASCWithSourceDeDup AS VARCHAR(MAX)) + ' (' + CAST(@NonMASCWithSourceDeDupPercent AS VARCHAR(MAX))
					+ '%)</b> out of <b>' + CAST(@NonMASubClients AS VARCHAR(MAX))
					+ '</b> Subclient(s) protected over the network (LAN) by deduplication storage policies have source side deduplication enabled.<BR>'
					+ 'Average networks savings from  '
					+ 'deduplication is <b>' + CAST(@AvgNetworkSavingsFrmDeDupe AS VARCHAR(14)) + '%</b>.<DELIM>'
			END

			SET @tmpRecommendation =
			CASE
				WHEN @NonMASubClients = 0 THEN @infoMessage
				WHEN @NonMASCWithSourceDeDupPercent = 100 THEN @goodMessage
				WHEN @NonMASCWithSourceDeDupPercent >= @warningThreshold THEN @goodMessage + '<VDL>'
				WHEN @NonMASCWithSourceDeDupPercent > @criticalThreshold AND @NonMASCWithSourceDeDupPercent < @warningThreshold THEN @warningMessage
				ELSE @criticalMessage
			END
		END
		--file system Backup Efficiency
		ELSE IF @queryId = 98
		BEGIN
			SET @totSCs = 0
			SET @SCsWithLongJobs = 0
			SELECT @totSCs = csInfo.TotalSCCount , @SCsWithLongJobs = csInfo.LongRunningSCs, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
			FROM	cf_SurveyLongRunningFSFullJobs AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 24
						AND csInfo.JobId = 0
			SELECT @SCsWithLongJobsPercent = CASE WHEN @totSCs = 0 THEN 0 ELSE (@SCsWithLongJobs*100.0)/@totSCs END
			SET @tmpStatus =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @strCritical
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @strWarning
				ELSE @strGood
			END
			SET @tmpResult =
			CASE
				WHEN @SCsWithLongJobs > 0 THEN 'Found <b>' + CAST(@SCsWithLongJobs AS VARCHAR(MAX))
				+ ' (' + CAST(@SCsWithLongJobsPercent AS VARCHAR(MAX)) + '%)'
				+ '</b> out of <b>' + CAST(@totSCs AS VARCHAR(MAX))
				+ '</b> file system Subclient(s) with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
				ELSE 'No file system Subclients are found with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @criticalMessage
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @warningMessage
				ELSE @goodMessage
			END
		END
		--File Data Placement
		ELSE IF @queryId = 99
		BEGIN
				DECLARE @totFSC INT = 0
				DECLARE @totNoArcFSC INT = 0
				DECLARE @totNoArcFSCPercent DECIMAL(32,2) = 0
				SELECT @totFSC = csInfo.TotalClients, @totNoArcFSC = csInfo.TotalNoArchiveClients, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveyLargestNoArchiveFSClients AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 23
							AND csInfo.ClientId = 0
				SELECT @totNoArcFSCPercent = CASE WHEN @totFSC = 0 THEN 0 ELSE (@totNoArcFSC*100.0)/@totFSC END
				SET @tmpStatus =
				CASE
					WHEN @totNoArcFSCPercent >= @criticalThreshold THEN @strCritical
					WHEN @totNoArcFSCPercent < @criticalThreshold AND @totNoArcFSCPercent > @warningThreshold THEN @strWarning
					ELSE @strGood
				END
				SET @tmpResult =
				CASE
					WHEN @totFSC > 0 THEN 'Found <b>' + CAST(@totNoArcFSC AS VARCHAR(MAX))
						+ ' (' + CAST(@totNoArcFSCPercent AS VARCHAR(MAX))
						+ '%) </b> out of <b>' + CAST(@totFSC AS VARCHAR(MAX)) +
						+ '</b> file system client(s) with <b>application size > 1 TB</b> that may be candidates for archiving in last 30 days  (last full backups).<DELIM>'
					ELSE 'No file system clients are found with application size > 1 TB that may be candidates for archiving in last 30 days  (last full backups).<DELIM>'
				END
				SET @tmpRecommendation =
				CASE
					WHEN @totNoArcFSCPercent >= @criticalThreshold THEN @criticalMessage
					WHEN @totNoArcFSCPercent < @criticalThreshold AND @totNoArcFSCPercent > @warningThreshold THEN @warningMessage
					ELSE @goodMessage
				END
		END
		--Rapid Recovery Capability
		ELSE IF @queryId = 100
		BEGIN
			DECLARE @warningClientCount INT = 0
			DECLARE @totNoAppSnapC INT = 0
			DECLARE @avgRestoreThroughput DECIMAL(32, 2) = 0

			SELECT
				@totNoAppSnapC = ISNULL(MAX(sub.TotalNoSnapClients), 0),
				@avgRestoreThroughput = ISNULL(MAX(sub.avgThroughput), 0),
				@warningClientCount = COUNT(*),
				@tmpLogDate = CONVERT(VARCHAR(20), MAX(sub.LogDate), 100)
			FROM
			(SELECT
				csInfo.TotalNoSnapClients,
				CAST(csInfo.AvgRestoreThroughput AS DECIMAL(32,2)) AS avgThroughput,
				csInfo.LogDate
				FROM	cf_SurveyLargestNoSnapClients AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 23
						AND csInfo.ClientId <> 0
						AND csInfo.RestoreThroughput > 0
						AND (csInfo.ApplicationSizeTB*1024.0)/csInfo.RestoreThroughput > 8
			)AS sub
			SET @tmpStatus = CASE
				WHEN @warningClientCount > 0 THEN @strWarning
				ELSE @strGood
			END
			SET @tmpResult =
			CASE
				WHEN @warningClientCount > 0
					THEN 'Found <b>' + CAST(@warningClientCount AS VARCHAR(MAX)) + '</b> application client(s) that may take longer than <b>8 hours</b> to restore (based on latest full backup jobs in the last 30 days).<DELIM>'
					+ 'Average Restore Throughput is <b>' + CAST(@avgRestoreThroughput AS VARCHAR(MAX)) + ' GB/HR</b>'
				ELSE 'No Application clients are found that may take longer than <b>8 hours</b> to restore (based on latest full backup jobs in the last 30 days).<DELIM>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @warningClientCount > 0 THEN @warningMessage
				WHEN @totNoAppSnapC > 0 THEN @infoMessage
				ELSE @goodMessage
			END
		END
		--VM Backup Efficiency
		ELSE IF @queryId = 101
		BEGIN
			SET @totSCs = 0
			SET @SCsWithLongJobs = 0
			SELECT @totSCs = csInfo.TotalSCCount, @SCsWithLongJobs = csInfo.LongRunningSCs, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
			FROM	cf_SurveyLongRunningVSAFullJobs AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 24
						AND csInfo.JobId = 0
			SELECT @SCsWithLongJobsPercent = CASE WHEN @totSCs = 0 THEN 0 ELSE (@SCsWithLongJobs*100.0)/@totSCs END
			SET @tmpStatus =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @strCritical
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @strWarning
				ELSE @strGood
			END
			SET @tmpResult =
			CASE
				WHEN @SCsWithLongJobs > 0 THEN 'Found <b>' + CAST(@SCsWithLongJobs AS VARCHAR(MAX))
				+ ' (' + CAST(@SCsWithLongJobsPercent AS VARCHAR(MAX)) + '%)'
				+ '</b> out of <b>' + CAST(@totSCs AS VARCHAR(MAX))
				+ '</b> Subclient(s) with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
				ELSE 'No Subclients are found with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @criticalMessage
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @warningMessage
				ELSE @goodMessage
			END
		END
		--Application Backup Efficiency
		ELSE IF @queryId = 102
		BEGIN
			SET @totSCs = 0
			SET @SCsWithLongJobs = 0
			SELECT @totSCs = csInfo.TotalSCCount, @SCsWithLongJobs = csInfo.LongRunningSCs, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
			FROM	cf_SurveyLongRunningFullJobs AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 24
						AND csInfo.JobId = 0
			SELECT @SCsWithLongJobsPercent = CASE WHEN @totSCs = 0 THEN 0 ELSE (@SCsWithLongJobs*100.0)/@totSCs END
			SET @tmpStatus =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @strCritical
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @strWarning
				ELSE @strGood
			END
			SET @tmpResult =
			CASE
				WHEN @SCsWithLongJobs > 0 THEN 'Found <b>' + CAST(@SCsWithLongJobs AS VARCHAR(MAX))
				+ ' (' + CAST(@SCsWithLongJobsPercent AS VARCHAR(MAX)) + '%)'
				+ '</b> out of <b>' + CAST(@totSCs AS VARCHAR(MAX))
				+ '</b> Subclient(s) with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
				ELSE 'No Subclients are found with jobs having a transfer time of more than <b>8 hours</b> in last 30 days (last full backups).<DELIM>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @SCsWithLongJobsPercent >= @criticalThreshold THEN @criticalMessage
				WHEN @SCsWithLongJobsPercent < @criticalThreshold AND @SCsWithLongJobsPercent > @warningThreshold THEN @warningMessage
				ELSE @goodMessage
			END
		END
		--Disk Protection Tier Savings
		ELSE IF @queryId = 111
		BEGIN
			DECLARE @totPrimCopies INT = 0
			DECLARE @totDeDupPrimCopies INT = 0
			DECLARE @AppSizeGB FLOAT = 0
			DECLARE @TotSizeOnMediaGB FLOAT = 0
			DECLARE @DeDupRatio DECIMAL(20, 2) = 0
			DECLARE @DeDupPrimCopiesPercent DECIMAL(32,2) = 0
			SELECT TOP 1 @totPrimCopies = csInfo.PrimaryCopies, @totDeDupPrimCopies = csInfo.DeDupPrimaryCopies, @AppSizeGB = csInfo.TotalAppSize, @TotSizeOnMediaGB = csInfo.TotalSizeOnMedia, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
			FROM	cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
					INNER JOIN @TblLatestResult AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 26
						AND csInfo.PrimaryCopies > 0
			SELECT @DeDupPrimCopiesPercent = CASE WHEN @totPrimCopies = 0 THEN 0 ELSE (@totDeDupPrimCopies*100.0)/@totPrimCopies END
			SELECT @DeDupRatio = CASE WHEN @AppSizeGB = 0 THEN 0 ELSE CAST((100.0*(@AppSizeGB-@TotSizeOnMediaGB)/@AppSizeGB) AS Decimal(20,2)) END
			SET @tmpStatus = @strInfo
			IF @totPrimCopies = 0
				SET @tmpResult = 'Primary Copies are not found.'
			ELSE
			BEGIN
				SET @tmpResult =
					'Found <b>' + CAST(@totDeDupPrimCopies AS VARCHAR(MAX))
						+ ' (' + CAST(@DeDupPrimCopiesPercent AS VARCHAR(MAX)) + '%)'
						+ '</b> out of <b>' + CAST(@totPrimCopies AS VARCHAR(MAX))
						+ '</b> Primary Copies with DeDuplication enabled in last 30 days.<DELIM>'
						+ 'For all Primary copies with DeDuplication enabled:<DELIM>'
						+ 'Application Size of Protected Data: <b>' + dbo.FormatBytes(@AppSizeGB, 'GB') + ' </b><DELIM>'
						+ 'Media Size : <b>' + dbo.FormatBytes(@TotSizeOnMediaGB, 'GB') + '</b><DELIM>'
				IF @totDeDupPrimCopies > 0
					SET @tmpResult += 'Savings : <b>' + CAST(@DeDupRatio AS VARCHAR(MAX)) + '%</b>'
				ELSE
					SET @tmpResult += 'If Deduplication is used, estimated savings based on 85% reduction: <b>' + dbo.FormatBytes(@AppSizeGB*0.85, 'GB') + '</b>'
			END
			SET @tmpRecommendation =
			CASE
				WHEN @totPrimCopies = 0 THEN 'Primary Copies are not found.'
				WHEN @DeDupPrimCopiesPercent < @criticalThreshold THEN @criticalMessage
				WHEN @DeDupPrimCopiesPercent >= @criticalThreshold AND @DeDupPrimCopiesPercent <= @warningThreshold THEN @warningMessage
				ELSE @goodMessage
			END
		END
		--Email Data Placement
		ELSE IF @queryId = 112
		BEGIN
				DECLARE @totEmailClients INT = 0
				DECLARE @totNoArcEmailClients INT = 0
				DECLARE @totNoArcEmailCPercent DECIMAL(32,2) = 0
				SELECT @totEmailClients = csInfo.TotalClients, @totNoArcEmailClients = csInfo.TotalNoArchiveClients, @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveyLargestNoArcEmailClients AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 23
							AND csInfo.ClientId = 0
				SELECT @totNoArcEmailCPercent = CASE WHEN @totEmailClients = 0 THEN 0 ELSE (@totNoArcEmailClients*100.0)/@totEmailClients END
				SET @tmpStatus =
				CASE
					WHEN @totNoArcEmailCPercent >= @criticalThreshold THEN @strCritical
					WHEN @totNoArcEmailCPercent < @criticalThreshold AND @totNoArcEmailCPercent > @warningThreshold THEN @strWarning
					ELSE @strGood
				END
				SET @tmpResult =
				CASE
					WHEN @totEmailClients > 0 THEN 'Found <b>' + CAST(@totNoArcEmailClients AS VARCHAR(MAX))
						+ ' (' + CAST(@totNoArcEmailCPercent AS VARCHAR(MAX))
						+ '%) </b> out of <b>' + CAST(@totEmailClients AS VARCHAR(MAX)) +
						+ '</b> email client(s) with <b>application size > 1 TB</b> that may be candidates for archiving in last 30 days (last full backups).<DELIM>'
					ELSE 'No email clients are found with application size > 1 TB that may be candidates for archiving in last 30 days (last full backups).<DELIM>'
				END
				SET @tmpRecommendation =
				CASE
					WHEN @totNoArcEmailCPercent >= @criticalThreshold THEN @criticalMessage
					WHEN @totNoArcEmailCPercent < @criticalThreshold AND @totNoArcEmailCPercent > @warningThreshold THEN @warningMessage
					ELSE @goodMessage
				END
		END
		--Tape Media Management
		ELSE IF @queryId = 113
		BEGIN
				DECLARE @TapeLibUsed INT = 0
				DECLARE @VTPolicyUsed INT = 0
				DECLARE @VTEntFeatureEnabled INT = 0
				SELECT
					@TapeLibUsed = ISNULL(csInfo.TapeLibUsed, 0),
					@VTPolicyUsed = ISNULL(csInfo.VTPolicyUsed, 0),
					@VTEntFeatureEnabled = ISNULL(csInfo.VTEntFeatureEnabled, 0), @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveyTapeMediaMgmt AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				SET @tmpStatus =
				CASE
					WHEN @TapeLibUsed = 0  OR (@TapeLibUsed > 0 AND @VTPolicyUsed > 0 AND @VTEntFeatureEnabled > 0) THEN @strGood
					WHEN (@TapeLibUsed > 0 AND @VTPolicyUsed > 0 AND @VTEntFeatureEnabled = 0) THEN @strWarning
					WHEN (@TapeLibUsed > 0 AND @VTPolicyUsed = 0) THEN @strCritical
					ELSE @strCritical
				END
				SET @tmpResult = ''
				IF @TapeLibUsed = 0
					SET @tmpResult = 'No Tape Libraries are in use.'
				ELSE
				BEGIN
					SET @tmpResult = 'Tape Libraries exist.<DELIM>'
					IF @VTPolicyUsed > 0
						SET @tmpResult += 'Vault Tracker Policies are configured.<DELIM>'
					ELSE
						SET @tmpResult += 'Vault Tracker Policies are not configured.<DELIM>'
					IF @VTEntFeatureEnabled > 0
						SET @tmpResult += 'Vault Tracker Enterprise Feature is in use.<DELIM>'
					ELSE
						SET @tmpResult += 'Vault Tracker Enterprise Feature is not in use.<DELIM>'
				END
				SET @tmpRecommendation =
				CASE
					WHEN @TapeLibUsed = 0  OR (@TapeLibUsed > 0 AND @VTPolicyUsed > 0 AND @VTEntFeatureEnabled > 0) THEN @goodMessage
					WHEN (@TapeLibUsed > 0 AND @VTPolicyUsed > 0 AND @VTEntFeatureEnabled = 0) THEN @warningMessage
					WHEN (@TapeLibUsed > 0 AND @VTPolicyUsed = 0) THEN @criticalMessage
					ELSE @criticalMessage
				END
		END
		--Self-Service
		ELSE IF @queryId = 114
		BEGIN
				DECLARE @WCClients INT = 0
				SELECT @WCClients = ISNULL(csInfo.ClientCounts, 0), @tmpLogDate = CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM	cf_SurveySelfServiceInfo AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
							AND csInfo.PackageId = 726
				SET @tmpStatus =
				CASE
					WHEN @WCClients > 0 THEN @strGood
					ELSE @strWarning
				END
				SET @tmpResult =
				CASE
					WHEN @WCClients > 0 THEN 'WebConsole is installed'
					ELSE 'WebConsole is not installed'
				END
				SET @tmpRecommendation =
				CASE
					WHEN @WCClients > 0 THEN @goodMessage
					ELSE @warningMessage
				END
		END

		UPDATE	@TblSurveyResult
		SET		Status = ISNULL(@tmpStatus, @strUnknown),
				Result = @tmpResult,
				Recommendation = @tmpRecommendation
		WHERE	MonitorId = @queryId AND (@parameterName = '' OR Monitor = @parameterName)

		FETCH NEXT FROM HealthQueryCur
		INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage
	END

	CLOSE HealthQueryCur
	DEALLOCATE HealthQueryCur

	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetValueAssessmentFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetValueAssessmentFunc' AND revision = '1.3.2.6')

  insert into GXDBVersions values(5, 'RptGetValueAssessmentFunc',  '1.3.2.6', 'RptGetValueAssessmentFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
