

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetScaleHealthFunc.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: RptGetScaleHealthFunc'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetScaleHealthFunc]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetScaleHealthFunc]
  delete from GXDBVersions where name = 'RptGetScaleHealthFunc' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetScaleHealthFunc]
	(
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL,
		@blaggregate INT = 0,
		@blLatestSurvey INT = 1,
		@i_CommServUniqueID INT = 0,
		@i_LogDateStart DATETIME = NULL,
		@i_LogDateEND DATETIME = NUll,
		@i_GroupType VARCHAR(128) = 'HourlyFormat',
		@bneedHealthinfoonly INT= 0
	)
	RETURNS @outputParam TABLE
	(
		Id				INTEGER NOT NULL IDENTITY (1,1),
		GroupName  varchar(256),
		ParameterName  varchar(256),
		status		  varchar(20),
		LastHour		  float,
		Last24Hour	  float,
		unit			  varchar(10),
		dbParameterName  varchar(256),
		outcome		varchar(1024),
		remarks		varchar(256),
		statusINT	INT,
		ParamId		INT
	)
	AS
	BEGIN

		DECLARE @i_QueryId BIGINT = 7
		DECLARE @strGood		VARCHAR(10) = '1_Good'
		DECLARE @strInfo		VARCHAR(10) = '2_Info'
		DECLARE @strwarning		VARCHAR(10) = '3_Warning'
	    DECLARE @strCritical	VARCHAR(10) = '4_Critical'
	    DECLARE @ParamId			INT = 16
		DECLARE @parameterName		NVARCHAR(256)
		DECLARE @warningThreshold	INT
		DECLARE @criticalThreshold	INT
		DECLARE @infoMessage		NVARCHAR(MAX)
		DECLARE @goodMessage		NVARCHAR(MAX)
		DECLARE @warningMessage		NVARCHAR(MAX)
		DECLARE @criticalMessage	NVARCHAR(MAX)
	    DECLARE @surveyResultId bigint
	    set @surveyResultId =	(select SurverResultId from dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId ) )

		DECLARE @TempDBCustomReportLink NVARCHAR(MAX) = '../../reportsplus/reportViewer.jsp?reportId=TempDBSizeTrend&input.ccGroupId=' + CAST(ISNULL(@i_GroupId, 0) AS NVARCHAR(10)) + '&&input.commUniId=' + CAST(ISNULL(@i_CommServUniqueID, 0) AS NVARCHAR(10))
		DECLARE @TempDBSizeVDLAnchor NVARCHAR(MAX) = '<a href="' + @TempDBCustomReportLink + '">View Details<a>'

		DECLARE @SQLServerEdition INT
		DECLARE @SQLServerExpressEdition INT = 4
		SELECT @SQLServerEdition = csInfo.LastHour FROM cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK) WHERE csInfo.SurveyResultId = @surveyResultid and csInfo.Property = 'SQL Server Version'
		DECLARE	ScaleQueryCur CURSOR FOR
		SELECT	ParamId,
				ParameterName,
				WarningThreshold,
				CriticalThreshold,
				InfoMessage,
				GoodMessage,
				WarningMessage,
				CriticalMessage
		FROM	cf_ReportParameterView where ParamId >= 700 AND queryId = 7 order by ParamId

		OPEN ScaleQueryCur

		FETCH NEXT FROM ScaleQueryCur
		INTO @ParamId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage

		WHILE @@FETCH_STATUS <> -1
		BEGIN

			IF @ParamId = 721 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Database', @parameterName, @strInfo, NULL, NULL, 'GB', @parameterName, NULL, @TempDBSizeVDLAnchor,0,@ParamId)

				DECLARE @TempDBSize Float
				SET @TempDBSize = (select csInfo.LastHour
				FROM cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
							WHERE   csInfo.SurveyResultId = @surveyResultid
							and csInfo.Property = @parameterName)

				update @outputParam
				set LastHour = @TempDBSize
				FROM @outputParam outParam
				where outParam.dbParameterName = @parameterName

				update @outputParam
				set status = ( case when LastHour > @criticalThreshold  then @strCritical
									when (LastHour >@warningThreshold and LastHour <= @criticalThreshold)  then @strwarning
									when LastHour <=@warningThreshold then @strGood
							   end
							  ),
					statusINT = ( case when LastHour > @criticalThreshold  then 3
									when (LastHour >@warningThreshold and LastHour <=@criticalThreshold)  then 2
									when LastHour <=@warningThreshold then 1
							   end
							  )
				where ParameterName = @parameterName

				IF ((select statusINT from @outputParam where ParameterName = @parameterName) > 1)
				BEGIN
								DECLARE @CommservDBDisk NVARCHAR(8) = NULL
								DECLARE @TempDBDisk NVARCHAR(8) = NULL

								SET @CommservDBDisk = (select Unit
									from cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
									where  csInfo.SurveyResultId = @surveyResultid
									and csInfo.Property = 'Volume of CommServ DB')

								SET @TempDBDisk = (select Unit
									from cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
									where  csInfo.SurveyResultId = @surveyResultid
									and csInfo.Property = 'Volume of Temp DB')

									IF (@CommservDBDisk IS NOT NULL AND @TempDBDisk IS NOT NULL AND (@CommservDBDisk <> @TempDBDisk ))
									BEGIN

											DECLARE @TempDBUsedPerc INT
											SET @TempDBUsedPerc = (@TempDBSize/(select csInfo.LastHour
																		from cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
																	where  csInfo.SurveyResultId = @surveyResultid
																		and csInfo.Property = 'Disk Size of TempDB'))*100
											UPDATE @outputParam
											SET status = CASE WHEN @TempDBUsedPerc < 50 THEN @strGood
															  WHEN @TempDBUsedPerc >= 75 THEN @strCritical
															  ELSE @strwarning
														 END,
												statusINT = CASE WHEN @TempDBUsedPerc < 50 THEN 1
																 WHEN @TempDBUsedPerc >= 75  THEN 3
																 ELSE 2
															END
											where ParameterName = @parameterName

									END
									ELSE
									IF (@CommservDBDisk IS NOT NULL AND @TempDBDisk IS NOT NULL AND (@CommservDBDisk = @TempDBDisk ))
									BEGIN
											DECLARE @CSDBSize FLOAT
											DECLARE @TempDBCSPerc INT

											SET @TempDBCSPerc = (@TempDBSize/(select LastHour from
																					cf_SurveyScaleReportInfo
																					where Property = 'Commserv Database Size'  AND   SurveyResultId = @surveyResultid))*100

											UPDATE @outputParam
											SET status = CASE WHEN @TempDBCSPerc < 25 THEN @strGood
															  WHEN @TempDBCSPerc > 20 AND statusINT > 2 THEN @strCritical
															  ELSE @strwarning
														 END,
												statusINT = CASE WHEN @TempDBCSPerc < 25 THEN 1
																 WHEN @TempDBCSPerc > 20 AND statusINT > 2 THEN 3
																 ELSE 2
															END
											where ParameterName = @parameterName

									END
					END
			END
			ELSE IF @ParamId = 722 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Database', @parameterName, @strInfo, NULL, NULL, 'GB', @parameterName, NULL, @TempDBSizeVDLAnchor,0,@ParamId)


			DECLARE @TempDBLogsSize Float
			SET @TempDBLogsSize = (select csInfo.LastHour
			FROM cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
						WHERE   csInfo.SurveyResultId = @surveyResultid
						and csInfo.Property = @parameterName)

			update @outputParam
			set LastHour = @TempDBLogsSize
			FROM @outputParam outParam
			where outParam.dbParameterName = @parameterName

				update @outputParam
				set status = ( case when LastHour > @criticalThreshold  then @strCritical
									when (LastHour >@warningThreshold and LastHour <= @criticalThreshold)  then @strwarning
									when LastHour <=@warningThreshold then @strGood
							   end
							  ),
					statusINT = ( case when LastHour > @criticalThreshold  then 3
									when (LastHour >@warningThreshold and LastHour <=@criticalThreshold)  then 2
									when LastHour <=@warningThreshold then 1
							   end
							  )
				where ParameterName = @parameterName

				IF((select statusINT from @outputParam where ParameterName = @parameterName) > 1)
				BEGIN
						DECLARE @CommservDBDiskTDbLog NVARCHAR(8) = NULL
						DECLARE @TempDBDiskTDbLog NVARCHAR(8) = NULL

						SET @CommservDBDiskTDbLog = (select Unit
							from cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
							where  csInfo.SurveyResultId = @surveyResultid
									and csInfo.Property = 'Volume of CommServ DB')

						SET @TempDBDiskTDbLog = (select Unit
							from cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
							where  csInfo.SurveyResultId = @surveyResultid
								and csInfo.Property = 'Volume of Temp DB')



								IF (@CommservDBDiskTDbLog IS NOT NULL AND @TempDBDiskTDbLog IS NOT NULL AND (@CommservDBDiskTDbLog <> @TempDBDiskTDbLog))
								BEGIN
										DECLARE @TempDBLogDriveSize Float
										DECLARE @TempDBLogsUsedPerc INT
										SET @TempDBLogsUsedPerc = (@TempDBLogsSize/(select csInfo.LastHour
																	from cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
															  where  csInfo.SurveyResultId = @surveyResultid
																	and csInfo.Property = 'Disk Size of TempDB'))*100

											UPDATE @outputParam
											SET status = CASE WHEN @TempDBLogsUsedPerc < 50 THEN @strGood
															  WHEN @TempDBLogsUsedPerc > 75 THEN @strCritical
															  ELSE @strwarning
														 END,
												statusINT = CASE WHEN @TempDBLogsUsedPerc < 50 THEN 1
																 WHEN @TempDBLogsUsedPerc > 75 THEN 3
																 ELSE 2
															END
											where ParameterName = @parameterName
								END
								ELSE
								IF (@CommservDBDiskTDbLog IS NOT NULL AND @TempDBDiskTDbLog IS NOT NULL AND (@CommservDBDiskTDbLog = @TempDBDiskTDbLog))
								BEGIN
										DECLARE @CSDBSizeTLog FLOAT
										DECLARE @TempDBLogCSPerc INT
										SET @TempDBLogCSPerc = (@TempDBLogsSize/(select LastHour from  cf_SurveyScaleReportInfo
																								where Property = 'Commserv Database Size'  AND   SurveyResultId = @surveyResultid))*100

											UPDATE @outputParam
											SET status = CASE WHEN @TempDBLogCSPerc < 25 THEN @strGood
															  WHEN @TempDBLogCSPerc > 30 AND statusINT > 2 THEN @strCritical
															  ELSE @strwarning
														 END,
											statusINT = CASE WHEN @TempDBLogCSPerc < 25 THEN 1
															 WHEN @TempDBLogCSPerc > 30 AND statusINT > 2 THEN 3
															 ELSE 2
														END
											where ParameterName = @parameterName
								END
					END
			END
			ELSE IF @ParamId = 723 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam
				SELECT 'Database', csInfo.Property, @strInfo, NULL, NULL, 'GB', @parameterName, NULL, '',0,@ParamId
				FROM cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
				WHERE csInfo.SurveyResultId = @surveyResultid
					and csInfo.Property IN ('Commserv Database Size', 'CVCloud Database Size', 'DM2 Database Size',
												'WFEngine Database Size','History Database Size','Audit Database Size','Cache Database Size','ResourceMgr Database Size',
														'Template Database Size','TroubleShooting Database Size')
				ORDER BY csInfo.Property

				update @outputParam
				set LastHour = csInfo.LastHour,
					Last24Hour = csInfo.Last24Hours
				from @outputParam outParam
				INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
					ON  csInfo.SurveyResultId = @surveyResultid
					and csInfo.Property = outParam.ParameterName
					and outparam.ParamId = @ParamId

				update @outputParam set
					status = CASE
								WHEN (@SQLServerEdition <> @SQLServerExpressEdition) THEN @strInfo
								WHEN (@SQLServerEdition = @SQLServerExpressEdition) AND ((@SQLServerEdition = @SQLServerExpressEdition) AND (LastHour < @warningThreshold)) THEN @strGood
								WHEN (@SQLServerEdition = @SQLServerExpressEdition) AND (LastHour >= @warningThreshold) AND (LastHour < @criticalThreshold) THEN @strwarning
								WHEN (@SQLServerEdition = @SQLServerExpressEdition) AND (LastHour >= @criticalThreshold) THEN @strCritical
							END,
					statusINT = CASE
									WHEN (@SQLServerEdition <> @SQLServerExpressEdition) THEN 0
									WHEN(@SQLServerEdition = @SQLServerExpressEdition) AND ((@SQLServerEdition = @SQLServerExpressEdition) AND (LastHour < @warningThreshold)) THEN 1
									WHEN (@SQLServerEdition = @SQLServerExpressEdition) AND (LastHour >= @warningThreshold) AND (LastHour < @criticalThreshold) THEN 2
									WHEN (@SQLServerEdition = @SQLServerExpressEdition) AND (LastHour >= @criticalThreshold) THEN 3
								END,
					remarks = CASE
									WHEN (@SQLServerEdition <> @SQLServerExpressEdition) THEN @infoMessage
									WHEN (@SQLServerEdition = @SQLServerExpressEdition) AND ((@SQLServerEdition = @SQLServerExpressEdition) AND (LastHour < @warningThreshold)) THEN @goodMessage
									WHEN (@SQLServerEdition = @SQLServerExpressEdition) AND (LastHour >= @warningThreshold) AND (LastHour < @criticalThreshold) THEN @warningMessage
									WHEN (@SQLServerEdition = @SQLServerExpressEdition) AND (LastHour >= @criticalThreshold) THEN @criticalMessage
								END
				from @outputParam outParam where outparam.ParamId = @ParamId

				DECLARE @CommservDatabaseSizeWarningThreshold INT = (select WarningThreshold from cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=7 and ParamId = 730)
				DECLARE @CommservDatabaseSizeCriticalThreshold INT = (select CriticalThreshold from cf_SurveyHealthParam WITH (NOLOCK) WHERE QueryId=7 and ParamId = 730)

				update @outputParam
				set remarks = CASE WHEN outparam.LastHour >= @CommservDatabaseSizeWarningThreshold THEN 'Commserv Database needs attention <br>' ELSE '' END + remarks + '<VDL>',
					status = CASE WHEN outparam.LastHour >= @CommservDatabaseSizeCriticalThreshold THEN @strCritical WHEN outparam.LastHour >= @CommservDatabaseSizeWarningThreshold THEN @strwarning ELSE status END
				from @outputParam outParam
				where outparam.ParameterName = 'Commserv Database Size'

			END
			ELSE IF @ParamId = 724 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Database', @parameterName, @strInfo, NULL, NULL, '', '', 'Top 10 Largest Tables by Size', '<VDL>',0,@ParamId)

				declare @tableData4tblsize xml = (
				select cast(csInfo.Unit as XML)
				FROM cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
						WHERE  csInfo.SurveyResultId = @surveyResultid
						and csInfo.Property = 'Largest Tables by Size'
				)

				DECLARE @tableDataInfo TABLE
				(
					TableName				varchar(100),
					DataSizeinMB			bigint
				)
				 insert into @tableDataInfo(TableName, DataSizeinMB)
					SELECT
					T.n.value('@TableName', 'varchar(100)') ,
					cast(T.n.value('@DataSizeinKB', 'bigint') /1024.0    as BIGINT)
					FROM @tableData4tblsize.nodes('/TableData') AS T(n)


				IF EXISTS(SELECT * FROM @tableDataInfo WHERE DataSizeinMB > @criticalThreshold)
					update @outputParam
					set status =   @strCritical, statusINT =3,
						remarks = 'Table bloating detected <DELIM>' + remarks,
						dbParameterName = 'Some tables exceed the recommended size.'
					where ParameterName = @parameterName
				ELSE IF EXISTS(SELECT * FROM @tableDataInfo WHERE DataSizeinMB >= @WarningThreshold and DataSizeinMB <= @criticalThreshold)
					update @outputParam
					set status =   @strwarning, statusINT =2,
						remarks = 'Table bloating detected <DELIM>' + remarks,
						dbParameterName = 'Some tables exceed the recommended size.'
					where ParameterName = @parameterName
				ELSE
					update @outputParam
					set status =   @strGood, statusINT =1,
						dbParameterName = 'All tables are within the recommended size limit.'
					where ParameterName = @parameterName
			END
            ELSE IF @ParamId = 728 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
            BEGIN
                insert into @outputParam  values
                ( 'Database', @parameterName, @strInfo, NULL, NULL, '', 'LAST DBMAINTAINENCE DT',NULL,'',0,@ParamId)
            END
			ELSE IF @ParamId = 725 AND ( @i_GroupType = 'DatabaseFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Database', @parameterName, @strInfo, NULL, NULL, '', '', 'Top 10 Largest Tables by Row Count', '<VDL>',0,@ParamId)
				declare @tableData4tblrows xml = (
				select cast(csInfo.Unit as XML)
				FROM cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
						WHERE  csInfo.SurveyResultId = @surveyResultid
						and csInfo.Property = 'Largest Tables by Rows'
				)
				DECLARE @tableDataInfo2 TABLE
				(
					TableName				varchar(100),
					TotalRows				bigint

				)
				 insert into @tableDataInfo2(TableName, TotalRows)
					SELECT
					T.n.value('@TableName', 'varchar(100)') ,
					T.n.value('@TotalRows', 'bigint')
					FROM @tableData4tblrows.nodes('/TableData') AS T(n)


				IF EXISTS(SELECT * FROM @tableDataInfo2 WHERE TotalRows > @criticalThreshold)
					update @outputParam
					set status =   @strCritical, statusINT =3,
						remarks = 'Table bloating detected <DELIM>' + remarks,
						dbParameterName = 'Some tables exceed the recommended row count.'
					where ParameterName = @parameterName

				ELSE IF EXISTS(SELECT * FROM @tableDataInfo2 WHERE TotalRows >= @WarningThreshold and TotalRows <= @criticalThreshold)
					update @outputParam
					set status =   @strwarning, statusINT =2,
						remarks = 'Table bloating detected <DELIM>' + remarks,
						dbParameterName = 'Some tables exceed the recommended row count.'
					where ParameterName = @parameterName

				ELSE
					update @outputParam
					set status =   @strGood, statusINT =1,
						dbParameterName = 'All tables are within the recommended row count limit.'
					where ParameterName = @parameterName

			END
			ELSE IF @ParamId = 726 AND ( @i_GroupType = 'Client' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Client', @parameterName, @strInfo, NULL, NULL, '', @parameterName, NULL, '',0,@ParamId)
				Declare @percentActiveClients INT = 0
				Declare @ScaleLimit INT = 0
				Declare @ActiveClient INT = ISNULL((select TotalActiveClients - ISNULL(TotalActiveVMs,0) from cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK) where CommServUniqueId = @i_CommServUniqueID
				and SurveyResultId = (select max(SurveyResultId) from cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK) where CommServUniqueId = @i_CommServUniqueID )),0)

				set @ScaleLimit = ISNULL((select cast(csInfo.Unit as INT)
				FROM @outputParam outParam
				INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
					ON  csInfo.SurveyResultId = @surveyResultid
					and csInfo.Property = outParam.dbParameterName AND outParam.ParamId = @ParamId ),4000)
                IF(@ScaleLimit>0)
    				SET @percentActiveClients =  @ActiveClient*100/@ScaleLimit
    			ELSE
					SET @percentActiveClients = 100
				update @outputParam
				set status = ( case when @percentActiveClients > @criticalThreshold  then @strCritical
									when (@percentActiveClients  >@warningThreshold and @percentActiveClients  <= @criticalThreshold)  then @strwarning
									when @percentActiveClients  <=@warningThreshold then @strGood
							   end
							  ),
					statusINT = ( case when @percentActiveClients  > @criticalThreshold  then 3
									when (@percentActiveClients  >@warningThreshold and @percentActiveClients  <=@criticalThreshold)  then 2
									when @percentActiveClients  <=@warningThreshold then 1
							   end
							  ),
				remarks		=( case when @percentActiveClients > @criticalThreshold  then @criticalMessage
									when (@percentActiveClients  >@warningThreshold and @percentActiveClients  <= @criticalThreshold)  then @warningMessage
								else ''
							 end)
				where ParamId = @ParamId
				DECLARE @outComeInfo table
				(
					dbParameterName varchar(256),
					name			varchar(1024),
					LastHour		float
				)
				insert into @outComeInfo (dbParameterName,name, LastHour)
				select 'Client Scale Limit', 'Client Scale Limit : ', @ScaleLimit
				insert into @outComeInfo (dbParameterName,name, LastHour)
				select 'Active Clients', 'Active Clients : ', @ActiveClient
				update @outputParam
				set outcome= (select (select ' ' + name + '  <b>' +CAST(lasthour as varchar(10)) +
							   case when name ='Client Scale Limit : ' then '</b> <DELIM>'
							   ELSE '</b>' end
							  from @outComeInfo
							  for XML path(''),root('valueStr'), TYPE).value('/valueStr[1]','varchar(1024)'))
				where ParamId = @ParamId
			END

			ELSE IF @ParamId = 727 AND @i_GroupType = 'DatabaseFormat'
			BEGIN
				INSERT INTO @outputParam  VALUES
				('Database', @parameterName, @strInfo, NULL, NULL, '', @parameterName, NULL, @infoMessage,0,@ParamId)

				DECLARE @tblDriveUsage TABLE (DriveName NVARCHAR(MAX), TotalSpaceMB BIGINT, FreeSpaceMB BIGINT, PercentFreeSpace DECIMAL(5,2))
				DECLARE @DriveUsageXml XML = (SELECT CAST(Unit AS XML) FROM cf_SurveyScaleReportInfo AS csInfo WITH(NOLOCK) WHERE csInfo.SurveyResultId = @surveyResultid AND csInfo.Property = @parameterName)

				INSERT INTO @tblDriveUsage (DriveName, TotalSpaceMB, FreeSpaceMB)
				SELECT
					drive.d.value('@Drive', 'NVARCHAR(MAX)'),
					drive.d.value('@TotalSpaceMB', 'BIGINT'),
					drive.d.value('@FreeSpaceMB', 'BIGINT')
				FROM @DriveUsageXml.nodes('/Drive')  AS drive(d)

				UPDATE @tblDriveUsage SET PercentFreeSpace = CAST(FreeSpaceMB * 100.0 / TotalSpaceMB AS DECIMAL(5,2))

                DECLARE @TotalCount INT, @WarningCount INT, @CriticalCount INT
                SELECT @TotalCount = COUNT(*) FROM @tblDriveUsage
                SELECT @WarningCount = COUNT(*) FROM @tblDriveUsage WHERE PercentFreeSpace <= @warningThreshold AND PercentFreeSpace >= @criticalThreshold
                SELECT @CriticalCount = COUNT(*) FROM @tblDriveUsage WHERE PercentFreeSpace < @criticalThreshold

    			IF @CriticalCount > 0
    			BEGIN
					UPDATE @OutputParam
					SET status = @strCritical,
						remarks = @criticalMessage
					WHERE ParamId = @ParamId
				END
    			ELSE IF @WarningCount > 0
    			BEGIN
					UPDATE @OutputParam
					SET status = @strWarning,
						remarks = @warningMessage
					WHERE ParamId = @ParamId
				END
    			ELSE IF @TotalCount > 0
    			BEGIN
					UPDATE @OutputParam
					SET status = @strGood,
						remarks = @goodMessage
					WHERE ParamId = @ParamId
				END

				UPDATE @OutputParam
				SET outcome =  CASE WHEN @TotalCount > 0 THEN 'Total Drives : <b>' + CAST((@TotalCount) AS VARCHAR(10))
                        + '</b>&nbsp&nbspCritical : <b>' + CAST(@CriticalCount AS VARCHAR(10))
                        + '</b>&nbsp&nbspWarning : <b>' + CAST(@WarningCount AS VARCHAR(10))
                        + '</b>&nbsp&nbspGood : <b>' + CAST(@TotalCount - @CriticalCount - @WarningCount AS VARCHAR(10)) + '</b>'
				ELSE 'No Information' END
				WHERE ParamId = @ParamId

			END

			ELSE IF @ParamId = 701 AND (@i_GroupType = 'HourlyFormat' OR @bneedHealthinfoonly = 1)
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, '', 'AVG NO. OF ATMPTS PER JOB',NULL,'',0,@ParamId)


				update @outputParam
							set LastHour = csInfo.LastHour,
								Last24Hour = csInfo.Last24Hours
							FROM @outputParam outParam
							INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
								ON  csInfo.SurveyResultId = @surveyResultid
								and csInfo.Property = outParam.dbParameterName
								AND outParam.dbParameterName = @parameterName

				update @outputParam
				set status = ( case when LastHour >=2 or Last24Hour >=2 then @strCritical
				                when LastHour >= 1.5 or Last24Hour >=1.5 then @strwarning
									else @strGood
							   end
							  ),
				    statusINT = ( case when LastHour >= 2 or Last24Hour >= 2 then 3
				                  when LastHour >= 1.5 or Last24Hour >= 1.5 then 2
									else 1
							   end
							  )
					where ParameterName =@parameterName

			END
			ELSE IF @ParamId = 702 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, 'GB/HR', 'AVG JOB THROUGHPUT',NULL,'',0,@ParamId)

			END
			ELSE IF @ParamId = 703 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, '%', 'JOBS COMPLETED IN ONE ATMPT',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 704 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, '', 'JOBS COMPLETED',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 705 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Jobs', @parameterName, @strInfo, NULL, NULL, '', 'Job Load',NULL,'<VDL>',0,@ParamId)

				DECLARE @jobLoad table
				(
					dbParameterName varchar(256),
					name			varchar(1024),
					LastHour		float
				)
				insert into @jobLoad values
				('JOBS IN QUEUE(RUNNING)', 'Running : ', NULL)
				insert into @jobLoad values
				('JOBS IN QUEUE(PENDING)', 'Pending : ', NULL)
				insert into @jobLoad values
				('JOBS IN QUEUE(WAITING)', 'Waiting : ', NULL)
				insert into @jobLoad values
				('JOBS IN QUEUE(QUEUED)', 'Queued : ', NULL)
				insert into @jobLoad values
				('JOBS IN QUEUE(SUSPENDED)', 'Suspended : ', NULL)
				update @jobLoad
				set LastHour = csInfo.LastHour
				FROM @jobLoad outParam
				INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
					ON  csInfo.SurveyResultId = @surveyResultid
					and csInfo.Property = outParam.dbParameterName

				insert into @jobLoad (dbParameterName,name, LastHour)
				select 'TOTAL JOBS', 'Total Jobs: ', SUM(LastHour) from @jobLoad
				update @outputParam
				set outcome= (select (select ' ' + name + '  <b>' +CAST(lasthour as varchar(10)) +
							   case when name ='Waiting : ' then '</b> <DELIM>'
							   ELSE '</b>' end
							  from @jobLoad
							  for XML path(''),root('valueStr'), TYPE).value('/valueStr[1]','varchar(1024)'))
				where dbParameterName ='Job Load'

			END
			ELSE IF @ParamId = 711 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL,' Chunks/Hr', 'CHUNKS CLOSED',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 712 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL,  'GB/HR', 'SIZE OF CHUNKS',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 713 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL, '', 'MAX NO. OF STRMS TRANSF. DATA',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 714 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL, '', 'AVG NO. OF STRMS TRANSF. DATA',NULL,'',0,@ParamId)
			END
			ELSE IF @ParamId = 715 AND @i_GroupType = 'HourlyFormat'
			BEGIN
				insert into @outputParam  values
				( 'Media And Data transfer', @parameterName, @strInfo, NULL, NULL, '', 'NO. OF RESERVATIONS',NULL,'',0,@ParamId)
			END


			FETCH NEXT FROM ScaleQueryCur
			INTO @ParamId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage

		END
		CLOSE ScaleQueryCur
		DEALLOCATE ScaleQueryCur

		update @outputParam
		set LastHour = csInfo.LastHour,
			Last24Hour = csInfo.Last24Hours
		FROM @outputParam outParam
		INNER JOIN cf_SurveyScaleReportInfo AS csInfo WITH (NOLOCK)
			ON  csInfo.SurveyResultId = @surveyResultid
			and csInfo.Property = outParam.dbParameterName and outparam.ParamId NOT IN (723, 726, 727)

		IF (@bneedHealthinfoonly = 1)
		BEGIN
			DECLARE @statusInt INT= (SELECT MAX(statusINT) FROM @outputParam)
			IF (@statusInt>1) -- update outcome with below message only for warning and critical case
			BEGIN
				DELETE FROM @outputParam WHERE statusINT <> @statusInt AND ParameterName <> 'Commserv Database Size'
				UPDATE @outputParam
				set outcome = CASE WHEN ParamId = 721 THEN 'The tempdb database size is too large.'
								   WHEN ParamId = 722 THEN 'The tempdb log size is too large.'
								   WHEN ParamId IN (724,725) THEN 'The CommServe database tables are too large.'
								   WHEN ParamId = 701 THEN 'The average attempts per job is too high.'
								   WHEN ParamId = 726 THEN 'Contact Support to increase the client scale limits.'
								   WHEN ParamId IN (723) THEN 'Commserv database size is ' + CAST(LastHour AS NVARCHAR(20)) + ' GB'
								   END
			END
			ELSE 	-- update outcome with below message only for good case
			BEGIN
				DELETE FROM @outputParam WHERE ParameterName <> 'Commserv Database Size'
				UPDATE @outputParam SET outcome = 'Commserv database size is ' + CAST(LastHour AS NVARCHAR(20)) + ' GB', status = @strGood, statusINT = 1
			END
		END

	RETURN
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetScaleHealthFunc]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetScaleHealthFunc' AND revision = '1.10.52.15')

  insert into GXDBVersions values(5, 'RptGetScaleHealthFunc',  '1.10.52.15', 'RptGetScaleHealthFunc', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
