

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetCommcellCount.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetCommcellCount'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetCommcellCount]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetCommcellCount]
  delete from GXDBVersions where name = 'RptGetCommcellCount' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetCommcellCount]
	(
		@i_optype INT = 0,
		@i_UserId  INT = NULL,
		@i_GroupId INT = NULL,
		@i_IncludeDisabledCC INT = 0,
		@i_TenantName NVARCHAR(255) = NULL
	)
	RETURNS BIGINT
	AS
	BEGIN
	DECLARE @total BIGINT
	DECLARE @activityTotal BIGINT
	DECLARE @healthTotal BIGINT
	DECLARE @retVal BIGINT =0
	DECLARE @blLatestSurvey INT = 1
	IF @i_IncludeDisabledCC = 1
		SET @blLatestSurvey = 3

		DECLARE @param_isPrivate INT = 0
		SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'

		DECLARE @UserCapability INT = 0
		SET @UserCapability = (SELECT surveycapability FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)

		IF (@param_isPrivate = 0 AND @UserCapability = 0)
		BEGIN
			DECLARE @UserProp xml
			SET @UserProp=(SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)

			DECLARE @VisibleCommcells TABLE(CommServGUID VARCHAR(256))
			INSERT INTO @VisibleCommcells
			SELECT commcells.value('@csGUID', '[NVARCHAR](MAX)') FROM @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
				CROSS APPLY resp.nodes('commcells') AS commcells(commcells)

			SELECT  @activityTotal= sum(case when (csInfo.CommCellSurveyServices & 4) =4 then 1 else 0 end ) ,
					@healthTotal= sum(case when (csInfo.CommCellSurveyServices & 1) =1 then 1 else 0 end ) ,
					@total = count(*)
			FROM cf_SurveyResultFuncV1(146, 0, @blLatestSurvey, NULL, NULL, @i_UserId, @i_GroupId) as resultFn
				INNER JOIN cf_CommcellIdNameMap csinfo WITH (NOLOCK)
					ON resultFn.CommServUniqueId = csinfo.ID
				RIGHT OUTER JOIN @VisibleCommcells VC
					ON VC.CommServGUID = resultFn.CommServGUID
		END
		ELSE
		BEGIN
			IF @i_TenantName = ''
			BEGIN
				SET @i_TenantName = NULL
			END

			IF @i_TenantName is NOT NULL
			BEGIN
				DECLARE @TenantCommcells TABLE(CommServUniqueId INT)
				INSERT INTO @TenantCommcells
				SELECT DISTINCT CommServUniqueId FROM cf_SurveyTenants WITH (NOLOCK)
					WHERE (TenantName = @i_TenantName AND @i_TenantName <> '/All') OR (@i_TenantName = '/All')
			END

			SELECT  @activityTotal= sum(case when (csInfo.CommCellSurveyServices & 4) =4 then 1 else 0 end ) ,
					@healthTotal= sum(case when (csInfo.CommCellSurveyServices & 1) =1 then 1 else 0 end ) ,
					@total = count(*)
			FROM cf_SurveyResultFuncV1(146, 0, @blLatestSurvey, NULL, NULL, @i_UserId, @i_GroupId) as resultFn
				INNER JOIN cf_CommcellIdNameMap csinfo WITH (NOLOCK)
					ON resultFn.CommServUniqueId = csinfo.ID
				LEFT OUTER JOIN @TenantCommcells TC
					ON TC.CommServUniqueId = csinfo.ID
			WHERE (@i_TenantName is not NULL AND TC.CommServUniqueId is not NULL) OR (@i_TenantName is NULL AND TC.CommServUniqueId is NULL)
		END

	IF (@i_optype = 1)	-- THIS IS FOR ACTIVITY
	BEGIN
		SET @retVal = @activityTotal
	END
	ELSE IF(@i_optype = 0) -- THIS IS FOR general
	BEGIN
		SET @retVal = @total
	END
	ELSE IF(@i_optype = 2) -- THIS IS FOR health
	BEGIN
		SET @retVal = @healthTotal
	END
	RETURN @retVal
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetCommcellCount]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetCommcellCount' AND revision = '1.7.2.2')

  insert into GXDBVersions values(5, 'RptGetCommcellCount',  '1.7.2.2', 'RptGetCommcellCount', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
