

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/RptGetCommCellsInGroup.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: RptGetCommCellsInGroup'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[RptGetCommCellsInGroup]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[RptGetCommCellsInGroup]
  delete from GXDBVersions where name = 'RptGetCommCellsInGroup' and type = 5
END
GO

	CREATE FUNCTION [dbo].[RptGetCommCellsInGroup] (
		@i_UserId INT = NULL,
		@i_GroupId INT = NULL,
		@i_IncludeDisabledCC INT = 0
		)
	RETURNS @ResultTable TABLE
	(
		CommServUniqueId INTEGER NOT NULL,
		CommCellID VARCHAR(32) NOT NULL,
		CommServGUID VARCHAR(256) NOT NULL,
		DisplayName NVARCHAR(256) NOT NULL,
		CommCellName NVARCHAR(256) NOT NULL,
		CommServTZ VARCHAR(256),
		CommServVersion VARCHAR(256),
		IncludedInGroup INT
	)
	AS
	BEGIN
		DECLARE @blLatestSurvey INT = 1
		IF @i_IncludeDisabledCC = 1
			SET @blLatestSurvey = 3

		DECLARE @param_isPrivate INT = 0
		SELECT	@param_isPrivate = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'

		INSERT INTO @ResultTable
		SELECT
	            csinfo.ID,
	            csinfo.CommCellID,
	            csinfo.CommServGUID,
	            CASE
					WHEN @param_isPrivate = 1 THEN ISNULL(csinfo.CommServName, '')
					ELSE ISNULL(csinfo.CustomerName,'')
	            END,
				CASE
					WHEN @param_isPrivate = 1 THEN ISNULL(csinfo.CommServName, '')
	                ELSE ISNULL(csinfo.CustomerName,'') + ' - ' + ISNULL(csinfo.CommServName, '')
	            END,
	            CommServTimeZone,
				csinfo.CommServVersion,
				0
		FROM
	            cf_CommcellIdNameMap csinfo WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(146, 0, @blLatestSurvey, NULL, NULL, @i_UserId, -1) AS resultView
	                    on resultView.CommServUniqueId = csinfo.ID

		UPDATE @ResultTable SET IncludedInGroup = 1
		FROM @ResultTable AS r
			INNER JOIN cf_CommCellGroupAssoc AS cga WITH (NOLOCK)
				ON cga.CommcellIdNameMap_ID = r.CommServUniqueId
				AND cga.CommCellGroupId = @i_GroupId

	RETURN
	END



GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [RptGetCommCellsInGroup]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'RptGetCommCellsInGroup' AND revision = '1.4')

  insert into GXDBVersions values(5, 'RptGetCommCellsInGroup',  '1.4', 'RptGetCommCellsInGroup', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
