

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/HumaniseDays.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: HumaniseDays'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[HumaniseDays]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[HumaniseDays]
  delete from GXDBVersions where name = 'HumaniseDays' and type = 5
END
GO

    CREATE FUNCTION HumaniseDays (@days int, @roundMonths int)
    RETURNS nvarchar(50)
    AS
    BEGIN
    DECLARE @years INT
    DECLARE @months INT
    SET @years = @days/365
    SET @days = @days - @years * 365
    SET @months = FLOOR( ( CONVERT(FLOAT, @days) + 1.0 ) / 30.41  )
    SET @days = @days - @months * 30.41
    IF( @days > 30)
    	BEGIN
    	SET @days = 29
    	END
	IF (@roundMonths = 1)
		BEGIN
		IF (@days >15)
			BEGIN
			SET @days = 0
			SET @months = @months + 1
			IF (@months > 11)
				BEGIN
				SET @years = @years + 1
				SET @months = 0
				END
			END
		ELSE
			SET @days = 0
		END
    DECLARE @formatted nvarchar(max)
    SET @formatted = CASE WHEN @years>0 THEN CONVERT(NVARCHAR(255), @years) + (CASE WHEN @years>1 THEN ' years' ELSE ' year' END)  ELSE '' END
    SET @formatted = @formatted + CASE WHEN @months>0 THEN (CASE WHEN @formatted = '' THEN '' ELSE ', ' END)
    							+ CONVERT(NVARCHAR(255), @months)
    							+ (CASE WHEN @months>1 THEN ' months' ELSE ' month'	END) ELSE '' END
    SET @formatted = @formatted + CASE WHEN @days>0 THEN (CASE WHEN @formatted = '' THEN '' ELSE ' and ' END)
    							+ CONVERT(NVARCHAR(255), @days)
    							+ (CASE WHEN @days>1 THEN ' days' ELSE ' day' END)  ELSE '' END
    RETURN @formatted
    END;


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [HumaniseDays]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'HumaniseDays' AND revision = '1.1.2.2')

  insert into GXDBVersions values(5, 'HumaniseDays',  '1.1.2.2', 'HumaniseDays', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
