

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/GetAppTypesByAppGroupFlags.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: GetAppTypesByAppGroupFlags'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[GetAppTypesByAppGroupFlags]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[GetAppTypesByAppGroupFlags]
  delete from GXDBVersions where name = 'GetAppTypesByAppGroupFlags' and type = 5
END
GO

 CREATE FUNCTION GetAppTypesByAppGroupFlags (@AppGroupFlags INT)
 RETURNS @AppTypeTbl TABLE (appTypeId INT)
 AS
 BEGIN
    IF @AppGroupFlags = 0
	BEGIN
		INSERT	INTO @AppTypeTbl
		SELECT  id
		FROM	cf_SurveyAgentType WITH(NOLOCK)
		WHERE	id > 0 AND id < 600 OR id = 1000

		RETURN
	END

    IF @AppGroupFlags&1 > 0 -- RPT_APPGROUP_FILE_SYSTEM (select appTypeId from APP_AppTypeGroups where App = 'File System')
		INSERT INTO @AppTypeTbl
		VALUES (1), (11), (12), (13), (17), (18), (19), (20), (21), (25), (28), (29), (33), (34), (36), (38), (40), (42), (43), (63), (64), (74), (86), (88), (91)

    IF @AppGroupFlags&2 > 0 -- RPT_APPGROUP_DATABASE (select appTypeId from APP_AppTypeGroups where App <> 'File System' and appGroup = 'Database')
		INSERT INTO @AppTypeTbl
		VALUES (2), (3), (4), (5), (16), (22), (23), (37), (61), (62), (70), (71), (79), (80), (81), (103), (104), (125), (126), (135), (136)

    IF @AppGroupFlags&4 > 0 -- RPT_APPGROUP_EXCHANGE (select appTypeId from APP_AppTypeGroups where App <> 'File System' and appGroup = 'Exchange')
		INSERT	INTO @AppTypeTbl
		VALUES (8), (9), (14), (15), (26), (27), (30), (31), (35), (44), (45), (53), (54), (55), (56), (57), (67), (68), (82), (105), (137)

    IF @AppGroupFlags&8 > 0 -- RPT_APPGROUP_LOTUS_NOTES (select appTypeId from APP_AppTypeGroups where App <> 'File System' and appGroup = 'Lotus Notes')
		INSERT INTO @AppTypeTbl
		VALUES (6), (7), (51), (52), (59), (60), (77), (90)

    IF @AppGroupFlags&16 > 0 -- RPT_APPGROUP_SHAREPOINT (select appTypeId from APP_AppTypeGroups where App <> 'File System' and appGroup = 'SharePoint')
		INSERT INTO @AppTypeTbl
		VALUES (32), (46), (69), (78), (89)

    IF @AppGroupFlags&32 > 0 -- RPT_APPGROUP_VIRTUAL_SERVER
		INSERT INTO @AppTypeTbl
		VALUES (106)

	RETURN
 END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [GetAppTypesByAppGroupFlags]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'GetAppTypesByAppGroupFlags' AND revision = '1.1.2.1')

  insert into GXDBVersions values(5, 'GetAppTypesByAppGroupFlags',  '1.1.2.1', 'GetAppTypesByAppGroupFlags', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
