

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Function/ConvertSecondsToStdFormat.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: ConvertSecondsToStdFormat'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[ConvertSecondsToStdFormat]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[ConvertSecondsToStdFormat]
  delete from GXDBVersions where name = 'ConvertSecondsToStdFormat' and type = 5
END
GO

	CREATE FUNCTION ConvertSecondsToStdFormat(@seconds int)
	RETURNS NVARCHAR(256)
	AS
	BEGIN
	DECLARE @days INT = 0;
	DECLARE @hrs INT = 0;
	DECLARE @min INT = 0;
	DECLARE @sec INT = 0;
	DECLARE @res NVARCHAR(256) = '';
	SET @days = @seconds/86400
	SET @hrs = (@seconds%86400)/3600
	SET @min = (@seconds%3600)/60
	SET @sec = @seconds%60
	SET @res = CASE @days WHEN 0 THEN '' WHEN 1 THEN CAST(@days AS VARCHAR(20)) + ' day ' ELSE CAST(@days AS VARCHAR(20)) + ' days ' END + CASE WHEN @seconds < 3600 OR @hrs = 0 THEN '' WHEN @hrs = 1 THEN CAST(@hrs AS VARCHAR(20)) + ' hour ' ELSE CAST(@hrs AS VARCHAR(20)) + ' hours ' END + CASE WHEN @seconds < 60 OR @min = 0 THEN '' WHEN @min = 1 THEN CAST(@min AS VARCHAR(20)) + ' minute' ELSE CAST(@min AS VARCHAR(20)) + ' minutes' END + CASE WHEN @seconds IN (0,1) THEN CAST(@seconds AS VARCHAR(20)) + ' second' WHEN @seconds < 60 THEN CAST(@seconds AS VARCHAR(20)) + ' seconds' ELSE '' END
	RETURN @res
	END;


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [ConvertSecondsToStdFormat]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'ConvertSecondsToStdFormat' AND revision = '')

  insert into GXDBVersions values(5, 'ConvertSecondsToStdFormat',  '', 'ConvertSecondsToStdFormat', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
