

--  ------------  Generated from [../../../Source/CommServer/AppStudioDB/Sp/SQLRepairOrphanedDBUsers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
-- This proc needs to execute as sqladmin_cv login and not as dbo to be able to
-- successfully call sp_change_users_login with UPDATE_ONE.
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SQLRepairOrphanedDBUsers')
BEGIN
	print '>>> Drop Stored Procedure: SQLRepairOrphanedDBUsers <<<'
	drop procedure SQLRepairOrphanedDBUsers
END
IF EXISTS (select * from GxQscripts where name='SQLRepairOrphanedDBUsers')
	delete from GxQscripts where name = 'SQLRepairOrphanedDBUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLRepairOrphanedDBUsers')
	delete from GXDBVersions where aliasname = 'SQLRepairOrphanedDBUsers'
GO
print '... Creating Procedure: SQLRepairOrphanedDBUsers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SQLRepairOrphanedDBUsers
AS
  DECLARE @RepairedUserName NVARCHAR(128)
BEGIN TRY
    -- Remember results because this is a two pass op.
    CREATE TABLE #OrphanedUsers
    (UserName NVARCHAR(128), UserSID varbinary(85))
    -- Find out who all got orphaned.
    INSERT INTO #OrphanedUsers
    EXEC sp_change_users_login 'REPORT'
    -- Eliminate people we dont care about.
    DELETE FROM #OrphanedUsers
    WHERE UserName NOT IN ('sqladmin_cv', 'sqlexec_cv')
    -- Do sqladmin_cv.
    IF EXISTS (SELECT * FROM #OrphanedUsers WHERE UserName = 'sqladmin_cv')
    EXEC sp_change_users_login 'UPDATE_ONE', 'sqladmin_cv', 'sqladmin_cv'
    -- Do sqlexec_cv.
    IF EXISTS (SELECT * FROM #OrphanedUsers WHERE UserName = 'sqlexec_cv')
    EXEC sp_change_users_login 'UPDATE_ONE', 'sqlexec_cv', 'sqlexec_cv'
    -- Let the caller know what's up.
    SELECT UserName
    FROM #OrphanedUsers
    -- Clean up.
    DROP TABLE #OrphanedUsers
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    DECLARE @ErrMsg NVARCHAR(4000) = ERROR_MESSAGE()
    DECLARE @ErrSev INT = ERROR_SEVERITY()
    DECLARE @ErrState INT = ERROR_STATE()
    RAISERROR (@ErrMsg, @ErrSev, @ErrState)
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'SQLRepairOrphanedDBUsers')
	delete from GxQscripts where name = 'SQLRepairOrphanedDBUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLRepairOrphanedDBUsers')
	delete from GXDBVersions where aliasname = 'SQLRepairOrphanedDBUsers'
GO

insert into GXDBVersions values(2, 'SQLRepairOrphanedDBUsers',  '00000000000000000000', 'SQLRepairOrphanedDBUsers', '00000000000000000000')
GO

