SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SQLServerSetMAXDOP')
BEGIN
	print '>>> Drop Stored Procedure: SQLServerSetMAXDOP <<<'
	drop procedure SQLServerSetMAXDOP
END
IF EXISTS (select * from GxQscripts where name='SQLServerSetMAXDOP')
	delete from GxQscripts where name = 'SQLServerSetMAXDOP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerSetMAXDOP')
	delete from GXDBVersions where aliasname = 'SQLServerSetMAXDOP'
GO
print '... Creating Procedure: SQLServerSetMAXDOP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SQLServerSetMAXDOP
--  User Input arguments
-- opType Settings:
--		1 - compute and set default MAXDOP
--		2 - override MAXDOP with inputted value and @inMAXDOP is required >=0 and <=8
  @opType INT = 1,
-- -1 means not set
  @inMAXDOP INT = -1,
  @help INT = 0
AS
BEGIN
	SET NOCOUNT ON
	IF (@help <> 0)
	BEGIN
		PRINT 'Usage: '
		PRINT '	EXEC SQLServerSetMAXDOP @opType=1, @inMAXDOP=-1, @help=0'
		PRINT '		@opType: '
		PRINT '			1 - compute and set default MAXDOP'
		PRINT '			2 - override MAXDOP with inputted value, requires @inMAXDOP >=0 and <=8'
		PRINT '		@inMAXDOP: >=0 and <= 8 required if @opType=2'
		PRINT '		@help: This usage message if <> 0'
		RETURN 0
	END
	-- Validate inputs
	IF (@opType NOT IN (1,2))
	BEGIN
		PRINT 'SQLServerSetMAXDOP: Error - invalid @opType'
		RETURN 1
	END
	IF (@opType = 2 AND (@inMAXDOP < 0 OR @inMAXDOP > 8))
	BEGIN
		PRINT 'SQLServerSetMAXDOP: Error - invalid @inMAXDOP <0 OR >8'
		RETURN 1
	END
	-- Local Variables
	DECLARE @sqlCmd NVARCHAR(MAX) = N''
	DECLARE @sqlReConfig NVARCHAR(32) = 'RECONFIGURE WITH OVERRIDE;'
	DECLARE @rc INT = 0
	DECLARE @sqlConfigXML XML = NULL
	DECLARE @sqlConfigId INT = NULL
	DECLARE @xmlCfgMaxDop INT = 0
	DECLARE @xmlCfgDT DATETIME
	DECLARE @xmlCfgOpType INT = -1
	DECLARE @NUMAs INT = 0
	DECLARE @AvgCPUsPerNUMA INT = 0
	DECLARE @MinCPUsPerNUMA INT = 0
	DECLARE @totalCPUs INT = 0
	DECLARE @nowDT DATETIME = GETUTCDATE()
	DECLARE @now INT = DATEDIFF(SECOND, '01/01/1970', @nowDT)
	DECLARE @ComputedMaxDOP INT = 0
	DECLARE @SetMaxDOP INT = 0
	DECLARE @sqlMaxDop INT
	DECLARE @sqlAdvOpt INT
	-- Warnings
	DECLARE @sqlAffinity INT = NULL
	DECLARE @sqlAffinity64 INT = NULL
	DECLARE @sqlCPUBoost INT = NULL
	DECLARE @xmlAffinity XML = NULL
	DECLARE @xmlCPUBoost XML = NULL
	DECLARE @csDbName SYSNAME = 'commserv'
	-- Get SQL Release to determine how to query the local SQL Server
	DECLARE @versionNumber VARCHAR(128) = CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(128))
	DECLARE @releaseNumber VARCHAR(128) = LEFT(@versionNumber, CHARINDEX('.', @versionNumber) - 1)
	-- Will only compute MAXDOP on SQL Server 2014+
	IF (@releaseNumber < 12)    -- 12->SQL2014
	BEGIN
		PRINT 'SQLServerSetMAXDOP: usage not supported on this version of SQL Server'
		RETURN 1
	END
	-- Get current SQL Server Config XML Document for CSDb and parse it
	IF (DB_NAME() = @csDbName)
	BEGIN
		-- Since SP may be in another CV database, create SQL script to commserv database value
		SET @sqlCmd = N'
			SELECT
				@sqlConfigId = g.id,
				@sqlConfigXML = g.value
			FROM GXGlobalParam g WITH(NOLOCK)
			WHERE
				g.name = N''SQLServerConfigXML''
				AND g.modified = 0
		'
		EXEC @rc = sp_executesql @stmt = @sqlCmd, @params = N'@sqlConfigXML XML OUTPUT, @sqlConfigId INT OUTPUT', @sqlConfigXML = @sqlConfigXML OUTPUT, @sqlConfigId = @sqlConfigId OUTPUT
		--SELECT @sqlConfigXML insqlConfigXML
		IF (@rc = 0 AND @sqlConfigXML IS NOT NULL)
		BEGIN
			SELECT
				@xmlCfgDT = s.value('@DateTime', 'DATETIME'),
				@xmlCfgOpType = s.value('@OpType', 'INT'),
				@xmlCfgMaxDop = s.value('@MAXDOP', 'INT')
			FROM
				@sqlConfigXML.nodes('/SQLServerConfigSettings/MAXDOP') d(s)
		END
	END
	-- Get current CPU Affinity Settings
	SELECT
		@sqlAffinity = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'affinity mask'
	SELECT
		@sqlAffinity64 = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'affinity64 mask'
	IF (@sqlAffinity > 0 OR @sqlAffinity64 > 0)
	BEGIN
		PRINT 'SQLServerSetMAXDOP: Warning manual Processor Affinity configured on this SQL Server'
		SET @xmlAffinity = (
			SELECT
				@nowDT '@DateTime',
				'Warning' '@message',
				@sqlAffinity '@affinityMask',
				@sqlAffinity64 '@affinity64Mask'
			FOR XML PATH('CPUAffinity'), TYPE
		)
	END
	-- Get current CPU Priority Boost
	SELECT
		@sqlCPUBoost = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'priority boost'
	IF (@sqlCPUBoost > 0)
	BEGIN
		PRINT 'SQLServerSetMAXDOP: Warning CPU Priority Boost configured on this SQL Server'
		SET @xmlCPUBoost = (
			SELECT
				@nowDT '@DateTime',
				'Warning' '@message',
				@sqlCPUBoost '@priorityBoost'
			FOR XML PATH('CPUBoost'), TYPE
		)
	END
	-- Get the currently set SQL Server MAXDOP
	SELECT
		@sqlMaxDop = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'max degree of parallelism'
	-- May need to enable this option to change MAXDOP
	SELECT
		@sqlAdvOpt = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'show advanced options'
	-- Compute what MAXDOP should be set to
	-- Includes hyperthreading in CPUs count - no easy way to compute Physical CPUs per Core from SQL Server.  Powershell yes.
	-- Count is Logical CPUs
	--SELECT
	--	@totalCPUs = COUNT(DISTINCT a.scheduler_id)
	--FROM sys.dm_os_nodes n
	--	INNER JOIN sys.dm_os_schedulers  a ON
	--		a.parent_node_id = n.node_id
	--		AND a.scheduler_id < 1048576
	--		AND a.is_online = 1
	--WHERE
	--	n.node_state_desc NOT LIKE '%DAC%'
	SELECT
		@NUMAs = COUNT(q.node_id),
		@AvgCPUsPerNUMA = AVG(q.CPUs),
		@MinCPUsPerNUMA = MIN(q.CPUs)
	FROM (
			-- Count all the SQL licensed CPUs on each NUMA
			SELECT
				n.node_id,
				COUNT(DISTINCT a.scheduler_id) CPUs
			FROM sys.dm_os_nodes n
				INNER JOIN sys.dm_os_schedulers  a ON
					a.parent_node_id = n.node_id
					AND a.scheduler_id < 1048576
					AND a.is_online = 1
			WHERE
				n.node_state_desc NOT LIKE '%DAC%'
			GROUP BY
				n.node_id
		) q
	-- For Commserver settings
	SET @ComputedMaxDOP = (
		CASE
			WHEN @AvgCPUsPerNUMA > 4 AND @MinCPUsPerNUMA > 4 THEN 4
			WHEN @AvgCPUsPerNUMA = 4 AND @MinCPUsPerNUMA >= 3 THEN 3
			ELSE @MinCPUsPerNUMA		-- this is to avoid overloading the smallest configure NUMA with limited CPU resources for executing parallel queries
		END
	)
	--SELECT @ComputedMaxDOP ComputedMaxDOP
	-- Perform the requested operation type
	IF (@opType = 1)
	BEGIN
		-- Compute and set MAXDOP
		SET @SetMaxDOP = (
			CASE
				WHEN @xmlCfgOpType = -1 THEN @ComputedMaxDOP			-- not set
				WHEN @xmlCfgOpType = 1 THEN @ComputedMaxDOP				-- re-computing MAXDOP setting
				ELSE --  @xmlCfgOpType = 2 it has been overridden previous leave unchanged
					@xmlCfgMaxDop
			END
		)
	END
	ELSE
	BEGIN
		-- Override MAXDOP Setting
		-- Validate the inputted MAXDOP does not exceed CPUs on NUMAs
		IF (@InMAXDOP > @AvgCPUsPerNUMA OR @InMAXDOP > @MinCPUsPerNUMA)
		BEGIN
			PRINT 'SQLServerSetMAXDOP: Error - inputted @InMAXDOP exceeds Average / Minimal CPUs per NUMA [' + CAST(@AvgCPUsPerNUMA AS VARCHAR(12)) + ':' + CAST(@MinCPUsPerNUMA AS VARCHAR(12)) + ']'
			RETURN 1
		END
		SET @SetMaxDOP = @InMAXDOP
	END
	--SELECT @SetMaxDOP SetMaxDOP
	-- Set SQL Server MAXDOP
	IF (@SetMaxDOP <> @sqlMaxDop)
	BEGIN
		-- Value to set is different then the current running SQL Server MAXDOP
		IF (@sqlAdvOpt <> 1)
		BEGIN
			-- Need to enable this option to change MAXDOP
			SET @sqlCmd = 'EXEC sp_configure ''show advanced options'', 1;'
			EXEC(@sqlCmd)
			EXEC(@sqlReConfig)
		END
		SET @sqlCmd = 'EXEC sp_configure ''max degree of parallelism'', ' + CAST(@SetMaxDOP AS NVARCHAR(12)) + ';'
		EXEC(@sqlCmd)
		EXEC(@sqlReConfig)
		IF (@sqlAdvOpt <> 1)
		BEGIN
			-- Need to disable this option back to its default setting
			SET @sqlCmd = 'EXEC sp_configure ''show advanced options'', 0;'
			EXEC(@sqlCmd)
			EXEC(@sqlReConfig)
		END
	END
	ELSE
	BEGIN
		-- values are equal nothing to change
		PRINT 'SQLServerSetMAXDOP: Current running SQL Server MAXDOP is fine!'
		IF (@sqlConfigXML IS NOT NULL)
		BEGIN
			RETURN 0
		END
	END
	-- Update Commserv GXGlobalParam Configuration for SQLServerConfigXML
	DECLARE @insXMLCfg TINYINT = 0
	IF (DB_NAME() = @csDbName)
	BEGIN
		IF (@sqlConfigXML IS NULL)
		BEGIN
			SET @sqlConfigXML = (
				SELECT
					@nowDT '@DateTime',
					@opType '@OpType',
					@SetMaxDOP '@MAXDOP'
				FOR XML PATH('MAXDOP'), ROOT('SQLServerConfigSettings'), TYPE
			)
			SET @insXMLCfg = 1
		END
		ELSE
		BEGIN
			IF (@SetMaxDOP <> @sqlMaxDop)
			BEGIN
				DECLARE @maxDopXML XML
				SET @maxDopXML = (
					SELECT
						@nowDT '@DateTime',
						@opType '@OpType',
						@SetMaxDOP '@MAXDOP'
					FOR XML PATH('MAXDOP'), TYPE
				)
				IF (@xmlCfgOpType <> -1)
				BEGIN
					-- Delete existing MAXDOP node from SQLServerConfigSettings XML
					SET @sqlConfigXML.modify('delete (/SQLServerConfigSettings/MAXDOP)[1]')
				END
				-- Insert new node
				SET @sqlConfigXML.modify('insert sql:variable("@maxDopXML") into (/SQLServerConfigSettings)[1]')
				SET @sqlCmd = N'
					UPDATE g
						SET modified = ' + CAST(@now AS NVARCHAR(12)) +  N'
					FROM GXGlobalParam g WITH(NOLOCK)
					WHERE
						g.id = ' + CAST(@sqlConfigId AS NVARCHAR(12)) + N'
				'
				EXEC @rc = sp_executesql @stmt = @sqlCmd
				SET @insXMLCfg = 1
			END
		END
		--SELECT @sqlConfigXML sqlConfigXML
		IF (@sqlConfigXML IS NOT NULL)
		BEGIN
			SET @sqlConfigXML.modify('delete (/SQLServerConfigSettings/CPUAffinity)[1]')
			SET @sqlConfigXML.modify('insert sql:variable("@xmlAffinity") into (/SQLServerConfigSettings)[1]')
		END
		IF (@xmlCPUBoost IS NOT NULL)
		BEGIN
			SET @sqlConfigXML.modify('delete (/SQLServerConfigSettings/CPUBoost)[1]')
			SET @sqlConfigXML.modify('insert sql:variable("@xmlCPUBoost") into (/SQLServerConfigSettings)[1]')
		END
		IF (@insXMLCfg = 1)
		BEGIN
			SET @sqlCmd = N'
				INSERT INTO GXGlobalParam (name, value, created, modified)
					VALUES (N''SQLServerConfigXML'', ''' + CAST(@sqlConfigXML AS NVARCHAR(MAX)) + N''', ' +  CAST(@now AS NVARCHAR(12)) + N', 0)
			'
			EXEC @rc = sp_executesql @stmt = @sqlCmd
		END
	END
	RETURN 0
END

IF EXISTS (select * from GxQscripts where name = 'SQLServerSetMAXDOP')
	delete from GxQscripts where name = 'SQLServerSetMAXDOP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerSetMAXDOP')
	delete from GXDBVersions where aliasname = 'SQLServerSetMAXDOP'
GO

insert into GXDBVersions values(2, 'SQLServerSetMAXDOP',  '00010001000200010000', 'SQLServerSetMAXDOP', '00010001000200010000')
GO

EXEC SQLServerSetMAXDOP %d, %d

