DECLARE	@spMajor	INTEGER = 0
DECLARE	@spMinor	INTEGER = 0
DECLARE	@spTransactionId	INTEGER = 0


IF EXISTS (SELECT	*
			FROM	PatchDBSPInfo)
BEGIN
	IF EXISTS (SELECT * FROM Sys.columns WHERE OBJECT_ID = OBJECT_ID('PatchDBSPInfo') AND name = 'TransactionID')
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#spTable') IS NOT NULL DROP TABLE #spTable

		CREATE TABLE  #spTable  (SPNumber INTEGER, SPMinorVersion INTEGER, SPTransactionId INTEGER)

		DECLARE @sqlStatement NVARCHAR(MAX) = 'INSERT INTO #spTable SELECT	SPNumber, SpMinorVersion, TransactionID FROM	PatchDBSPInfo ORDER BY SPNumber DESC, SpMinorVersion DESC, TransactionID DESC'

		EXEC sp_executesql @sqlStatement

		SELECT	TOP 1 @spMajor = SPNumber, @spMinor = SpMinorVersion, @spTransactionId = SPTransactionId
		FROM	#spTable
		ORDER BY SPNumber DESC, SpMinorVersion DESC

		IF OBJECT_ID('tempdb.dbo.#spTable') IS NOT NULL DROP TABLE #spTable
	END

END
/*
ELSE IF OBJECT_ID('archFile') IS NOT NULL -- If commserv database, get service pack information from SimInstalledPackages tables
BEGIN

	IF OBJECT_ID('tempdb.dbo.#spTable') IS NOT NULL DROP TABLE #spTable

	CREATE TABLE  #spTable  (SPNumber INTEGER, SPMinorVersion INTEGER)

	DECLARE @sqlStatement NVARCHAR(MAX) = 'INSERT INTO #spTable SELECT	HighestSP, SpMinorVersion FROM	simInstalledPackages WHERE ClientId = 2 AND simPackageID = 801'

	EXEC sp_executesql @sqlStatement

	SELECT	TOP 1 @spMajor = SPNumber, @spMinor = SpMinorVersion
	FROM	#spTable
	ORDER BY SPNumber DESC, SpMinorVersion DESC

	IF OBJECT_ID('tempdb.dbo.#spTable') IS NOT NULL DROP TABLE #spTable
END
*/

SELECT @spTransactionId AS SPTransactionId
