DECLARE	@spMajor	INTEGER = 0
DECLARE	@spMinor	INTEGER = 0


IF EXISTS (SELECT	*
			FROM	PatchDBSPInfo)
BEGIN
	SELECT	TOP 1 @spMajor = SPNumber, @spMinor = SpMinorVersion
	FROM	PatchDBSPInfo
	ORDER BY SPNumber DESC, SpMinorVersion DESC
END
ELSE IF OBJECT_ID('archFile') IS NOT NULL -- If commserv database, get service pack information from SimInstalledPackages tables
BEGIN

	IF OBJECT_ID('tempdb.dbo.#spTable') IS NOT NULL DROP TABLE #spTable

	CREATE TABLE  #spTable  (SPNumber INTEGER, SPMinorVersion INTEGER)

	DECLARE @sqlStatement NVARCHAR(MAX) = 'INSERT INTO #spTable SELECT	HighestSP, SpMinorVersion FROM	simInstalledPackages WHERE ClientId = 2 AND simPackageID = 801'

	EXEC sp_executesql @sqlStatement

	SELECT	TOP 1 @spMajor = SPNumber, @spMinor = SpMinorVersion
	FROM	#spTable
	ORDER BY SPNumber DESC, SpMinorVersion DESC

	IF OBJECT_ID('tempdb.dbo.#spTable') IS NOT NULL DROP TABLE #spTable
END

SELECT @spMinor AS SPMinor