IF NOT EXISTS(SELECT * FROM sys.columns where Name = N'buildNum' and Object_ID = Object_ID(N'SIMAllGalaxyRel'))
BEGIN
	IF EXISTS (SELECT * FROM sys.tables WHERE name='LicUsage')
	BEGIN
  		SELECT	TOP 1 CAST(REPLACE(REPLACE(Build,'0(BUILD',''), ')', '') AS INT) * 100 AS BUILDNO
		FROM	LicUsage
		WHERE	AppType = 1000
			AND LicType = 50331648
	END
	ELSE 
	  SELECT 0 AS BUILDNO 	
END
ELSE
BEGIN
	DECLARE @ReleaseId INTEGER = (SELECT TOP 1 id FROM simAllGalaxyRel ORDER BY id DESC)
	DECLARE	@sqlString NVARCHAR(1024)
	DECLARE @ParmDefinition NVARCHAR(500);
	DECLARE @BuildNum INTEGER;

	SET @SQLString = N'SELECT @BuildNumOUT = BuildNum
	   FROM SimAllGalaxyRel
	   WHERE id = @ReleaseIdIN';
	SET @ParmDefinition = N'@ReleaseIdIN INTEGER, @BuildNumOUT INTEGER OUTPUT';

	EXECUTE sp_executesql @SQLString, @ParmDefinition, @ReleaseIdIN = @ReleaseId, @BuildNumOUT=@BuildNum OUTPUT;
	SELECT @BuildNum;
END
