SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO

DECLARE @errorCode INTEGER
DECLARE @ProcNameCursorFlag INTEGER
DECLARE @FuncNameCursorFlag INTEGER
DECLARE @AggregateNameCursorFlag INTEGER

SET @errorCode  = 0
SET @ProcNameCursorFlag = 0
SET @FuncNameCursorFlag = 0
SET @AggregateNameCursorFlag = 0
	
DECLARE @ProcName nvarchar(256)
DECLARE @FuncName nvarchar(256)
DECLARE @AggregateName nvarchar(256)

-- Cursor Declarations

DECLARE ProcNameListCursor CURSOR STATIC FOR
SELECT distinct name
FROM sysobjects
WHERE xtype IN ('P', 'PC')
AND OBJECTPROPERTY(id, N'IsProcedure') = 1
AND (name LIKE '%_CVupdate%' OR name LIKE '%_PreRelease%')

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT

IF EXISTS (
	SELECT	* 
	FROM	INFORMATION_SCHEMA.TABLES 
	WHERE	TABLE_TYPE = 'BASE TABLE'
	AND		TABLE_NAME = 'App_SCGProperty')
BEGIN
	DECLARE FuncNameListCursor CURSOR STATIC FOR
	SELECT DISTINCT name
	FROM sysobjects
	WHERE   xtype IN ('FN', 'TF', 'FS', 'FT')
	AND OBJECTPROPERTY(id, N'IsInlineFunction') = 0
	AND name NOT IN (SELECT DISTINCT SUBSTRING(funcName, 5, LEN(funcName)) FROM App_SCGProperty SCG
					LEFT JOIN GXDBVersions GX ON GX.name = SUBSTRING(funcName, 5, LEN(funcName)) AND GX.TYPE = 5 
					WHERE GX.id is NULL)
	AND (name LIKE '%_CVupdate%' OR name LIKE '%_PreRelease%')
END	
ELSE
BEGIN
	DECLARE FuncNameListCursor CURSOR STATIC FOR
	SELECT DISTINCT name
	FROM sysobjects
	WHERE   xtype IN ('FN', 'TF', 'FS', 'FT')
	AND OBJECTPROPERTY(id, N'IsInlineFunction') = 0
	AND (name LIKE '%_CVupdate%' OR name LIKE '%_PreRelease%')
END

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT

DECLARE AggregateNameListCursor CURSOR STATIC FOR
SELECT DISTINCT name
FROM sysobjects 
WHERE   xtype IN ('AF')
AND OBJECTPROPERTY(id, N'IsInlineFunction') = 0
AND(name LIKE '%_CVupdate%' OR name LIKE '%_PreRelease%')

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT

-- Procedures

SET @ProcNameCursorFlag = 1
OPEN ProcNameListCursor

FETCH NEXT 
FROM ProcNameListCursor
INTO @ProcName

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT
	
WHILE @@FETCH_STATUS = 0
BEGIN
	IF EXISTS (select * from sys.objects where name = @ProcName and OBJECTPROPERTY(object_id, N'IsProcedure') = 1) 
	BEGIN
		PRINT '>>> Drop Stored Procedure: ' + @ProcName + ' <<<'
		EXEC ('DROP PROCEDURE [' + @ProcName + ']')
	END
				
	IF EXISTS (select * from GXDBVersions where aliasname = @ProcName AND type = 2)
		DELETE FROM GXDBVersions WHERE aliasname = @ProcName AND type = 2 
								
	FETCH NEXT 
	FROM ProcNameListCursor
	INTO @ProcName     
END

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT

IF @ProcNameCursorFlag = 1
BEGIN
	CLOSE ProcNameListCursor
	DEALLOCATE ProcNameListCursor
END

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT

-- Functions

SET @FuncNameCursorFlag = 1
OPEN FuncNameListCursor

FETCH NEXT 
FROM FuncNameListCursor
INTO @FuncName

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT
    
WHILE @@FETCH_STATUS = 0
BEGIN                
	IF EXISTS (select * from sysobjects where name = @FuncName and OBJECTPROPERTY(id, N'IsInlineFunction') = 0)
	BEGIN
		print '>>> Drop Function: ' + @FuncName + ' <<<'
		EXEC ('DROP FUNCTION [' + @FuncName + ']')
	END
                    
	IF EXISTS (select * from GXDBVersions where aliasname = @FuncName AND type = 5)
		DELETE FROM GXDBVersions WHERE aliasname = @FuncName AND type = 5

	FETCH NEXT 
	FROM FuncNameListCursor
	INTO @FuncName
END

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT

IF @FuncNameCursorFlag = 1
BEGIN
	CLOSE FuncNameListCursor
	DEALLOCATE FuncNameListCursor
END

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT

-- Aggregates

SET @AggregateNameCursorFlag = 1
OPEN AggregateNameListCursor

FETCH NEXT 
FROM AggregateNameListCursor
INTO @AggregateName

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT
    
WHILE @@FETCH_STATUS = 0
BEGIN          
	IF EXISTS (select * from sysobjects where name = @AggregateName and OBJECTPROPERTY(id, N'IsInlineFunction') = 0)
	BEGIN
		print '>>> Drop Aggregate: ' + @AggregateName + ' <<<'
		EXEC ('DROP AGGREGATE [' + @AggregateName + ']')
	END

	FETCH NEXT 
	FROM AggregateNameListCursor
	INTO @AggregateName
END

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT

IF @AggregateNameCursorFlag = 1
BEGIN
	CLOSE AggregateNameListCursor
	DEALLOCATE AggregateNameListCursor
END

SET @errorCode  =   @@ERROR
IF  @errorCode != 0 GOTO CX_EXIT

-- Exit 

CX_EXIT:
SELECT @errorCode
RETURN 
GO
