#!/usr/bin/env bash

# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This script should be sourced into other zookeeper
# scripts to setup the env variables

# We use ZOOCFGDIR if defined,
# otherwise we use /etc/zookeeper
# or the conf directory that is
# a sibling of this script's directory
ZOOBINDIR="${ZOOBINDIR:-/usr/bin}"
ZOOKEEPER_PREFIX="${ZOOBINDIR}/.."

CV_LOG_DIR=`cat ${CVREG}/Galaxy/${GALAXY_INST}/EventManager/.properties | grep dEVLOGDIR | awk '{print $2}'`
CV_INS_DIR=`cat ${CVREG}/Galaxy/${GALAXY_INST}/Base/.properties | grep dGALAXYHOME | awk '{print $2}'`
CV_LOG_LEVEL=`cat ${CVREG}/Galaxy/${GALAXY_INST}/Monitoring/.properties | grep zkLogLevel | awk '{print $2}'`
CV_MAX_JVM=`cat ${CVREG}/Galaxy/${GALAXY_INST}/Monitoring/.properties | grep zkMaxJvm | awk '{print $2}'`
CV_MIN_JVM=`cat ${CVREG}/Galaxy/${GALAXY_INST}/Monitoring/.properties | grep zkMinJvm | awk '{print $2}'`
CV_STACK_SIZE=`cat ${CVREG}/Galaxy/${GALAXY_INST}/Monitoring/.properties | grep zkStackSize | awk '{print $2}'`

if [ "x$ZOOCFGDIR" = "x" ]
then
  if [ -e "${ZOOKEEPER_PREFIX}/conf" ]; then
    ZOOCFGDIR="$ZOOBINDIR/../conf"
  else
    ZOOCFGDIR="$ZOOBINDIR/../etc/zookeeper"
  fi
fi

if [ -f "${ZOOCFGDIR}/zookeeper-env.sh" ]; then
  . "${ZOOCFGDIR}/zookeeper-env.sh"
fi

if [ "x$ZOOCFG" = "x" ]
then
    ZOOCFG="zoo.cfg"
fi

################################################################################################

####
#keeping defauls similar to Zookeeper.ini
####

if [ "x$CV_LOG_LEVEL" = "x" ]
then
    CV_LOG_LEVEL="INFO"
fi

if [ "x$CV_MAX_JVM" = "x" ]
then
    CV_MAX_JVM="2048"
fi

if [ "x$CV_MIN_JVM" = "x" ]
then
    CV_MIN_JVM="1024"
fi

if [ "x$CV_STACK_SIZE" = "x" ]
then
    CV_STACK_SIZE="512"
fi

####
#set it to CV_JVM_OPTIONS
####

CV_JVM_FLAGS="$CV_JVM_FLAGS -DZooKeeperLogLevel=${CV_LOG_LEVEL} -Xmx${CV_MAX_JVM}m -Xms${CV_MIN_JVM}m -Xss${CV_STACK_SIZE}k"

#############################################################################################


ZOOCFG="$ZOOCFGDIR/$ZOOCFG"

if [ -f "$ZOOCFGDIR/java.env" ]
then
    . "$ZOOCFGDIR/java.env"
fi

if [ "x${ZOO_LOG_DIR}" = "x" ]
then
    ZOO_LOG_DIR="$CV_LOG_DIR"
fi

if [ "x${ZOO_LOG4J_PROP}" = "x" ]
then
    ZOO_LOG4J_PROP="INFO,CONSOLE"
fi

if [ -e "$CV_INS_DIR/jre/bin/java" ]; then
    JAVA="$CV_INS_DIR/jre/bin/java"
else
    JAVA=java
fi

#add the zoocfg dir to classpath
CLASSPATH="$ZOOCFGDIR:$CLASSPATH"

for i in "$ZOOBINDIR"/../src/java/lib/*.jar
do
    CLASSPATH="$i:$CLASSPATH"
done

#make it work in the binary package
#(use array for LIBPATH to account for spaces within wildcard expansion)
if [ -e "${ZOOKEEPER_PREFIX}"/share/zookeeper/zookeeper-*.jar ]; then
  LIBPATH=("${ZOOKEEPER_PREFIX}"/share/zookeeper/*.jar)
else
  #release tarball format
  for i in "$ZOOBINDIR"/../zookeeper-*.jar
  do
    CLASSPATH="$i:$CLASSPATH"
  done
  LIBPATH=("${ZOOBINDIR}"/../lib/*.jar)
fi

for i in "${LIBPATH[@]}"
do
    CLASSPATH="$i:$CLASSPATH"
done

#make it work for developers
for d in "$ZOOBINDIR"/../build/lib/*.jar
do
   CLASSPATH="$d:$CLASSPATH"
done

#make it work for developers
CLASSPATH="$ZOOBINDIR/../build/classes:$CLASSPATH"

case "`uname`" in
    CYGWIN*) cygwin=true ;;
    *) cygwin=false ;;
esac

if $cygwin
then
    CLASSPATH=`cygpath -wp "$CLASSPATH"`
fi

#echo "CLASSPATH=$CLASSPATH"
