/*
 * Decompiled with CFR 0.152.
 */
package com.commvault.zookeeper.server.quorum;

import com.commvault.zookeeper.server.quorum.CvQuorumPeerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvZookeeperCustomEntry {
    private static final Logger LOG = LoggerFactory.getLogger(CvZookeeperCustomEntry.class);
    private static final String USAGE = "Usage: QuorumPeerMain configfile";
    public static CvQuorumPeerMain main;

    public static void main(String[] args) {
        String firstArgument = null;
        if (args.length == 1) {
            firstArgument = args[0];
        }
        System.err.println("Starting service...");
        if (firstArgument != null && firstArgument.equalsIgnoreCase("stop")) {
            if (main == null) {
                LOG.error("PeerMain object not initialized, so exiting abnormally.");
                System.exit(2);
            } else {
                try {
                    main.shutdownService();
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception, exiting abnormally", (Throwable)e);
                    System.err.println("Unexpected exception, exiting abnormally. " + e.getMessage());
                    System.exit(1);
                }
            }
        } else {
            main = new CvQuorumPeerMain();
            try {
                main.initializeAndRun(args);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid arguments, exiting abnormally", (Throwable)e);
                LOG.info(USAGE);
                System.err.println(USAGE);
                System.exit(2);
            }
            catch (QuorumPeerConfig.ConfigException e) {
                LOG.error("Invalid config, exiting abnormally", (Throwable)e);
                System.err.println("Invalid config, exiting abnormally");
                System.exit(2);
            }
            catch (Exception e) {
                LOG.error("Unexpected exception, exiting abnormally", (Throwable)e);
                System.exit(1);
            }
        }
        System.err.println("Exiting normally");
        LOG.info("Exiting normally");
        System.exit(0);
    }
}

