/*
 * Decompiled with CFR 0.152.
 */
package com.commvault.zookeeper.server.quorum;

import com.commvault.zookeeper.server.quorum.CvZooKeeperServerMain;
import java.io.IOException;
import org.apache.zookeeper.server.DatadirCleanupManager;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvQuorumPeerMain
extends QuorumPeerMain {
    private static final Logger LOG = LoggerFactory.getLogger(CvQuorumPeerMain.class);
    CvZooKeeperServerMain zkStandAloneMainInfo;

    protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
        QuorumPeerConfig config = new QuorumPeerConfig();
        if (args.length == 1) {
            config.parse(args[0]);
        }
        DatadirCleanupManager purgeMgr = new DatadirCleanupManager(config.getDataDir(), config.getDataLogDir(), config.getSnapRetainCount(), config.getPurgeInterval());
        purgeMgr.start();
        if (args.length == 1 && config.getServers().size() > 0) {
            this.runFromConfig(config);
        } else {
            LOG.warn("Either no config or no quorum defined in config, running  in standalone mode");
            this.zkStandAloneMainInfo = new CvZooKeeperServerMain();
            this.zkStandAloneMainInfo.initializeAndRun(args);
        }
    }

    public void shutdownService() {
        if (this.zkStandAloneMainInfo != null) {
            this.zkStandAloneMainInfo.shutdownService();
        } else {
            LOG.info("Trying to stop service.");
            System.err.println("Trying to stop service.");
            this.quorumPeer.shutdown();
            LOG.warn("Shutdown...");
        }
    }
}

