# coding: utf8
"""
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)
"""

from __future__ import unicode_literals

ADJECTIVES_WORDFORMS = {
'H-forma': ('H-forma',),
'H-formede': ('H-formet',),
'H-formet': ('H-formet',),
'H-formete': ('H-formet',),
'H-formetere': ('H-formet',),
'H-formetest': ('H-formet',),
'H-formeteste': ('H-formet',),
'PR-kåt': ('PR-kåt',),
'PR-kåte': ('PR-kåt',),
'PR-kåtere': ('PR-kåt',),
'PR-kåtest': ('PR-kåt',),
'PR-kåteste': ('PR-kåt',),
'T-forma': ('T-forma',),
'T-formede': ('T-formet',),
'T-formet': ('T-formet',),
'T-formete': ('T-formet',),
'T-formetere': ('T-formet',),
'T-formetest': ('T-formet',),
'T-formeteste': ('T-formet',),
'U-forma': ('U-forma',),
'U-formede': ('U-formet',),
'U-formet': ('U-formet',),
'U-formete': ('U-formet',),
'U-formetere': ('U-formet',),
'U-formetest': ('U-formet',),
'U-formeteste': ('U-formet',),
'V-forma': ('V-forma',),
'V-formede': ('V-formet',),
'V-formet': ('V-formet',),
'V-formete': ('V-formet',),
'V-formetere': ('V-formet',),
'V-formetest': ('V-formet',),
'V-formeteste': ('V-formet',),
'abandonerende': ('abandonere',),
'abandonert': ('abandonere',),
'abandonerte': ('abandonere',),
'abbrevierende': ('abbreviere',),
'abbreviert': ('abbreviere',),
'abbrevierte': ('abbreviere',),
'abdiserende': ('abdisere',),
'abdisert': ('abdisere',),
'abdiserte': ('abdisere',),
'abdominal': ('abdominal',),
'abdominale': ('abdominal',),
'abdominalere': ('abdominal',),
'abdominalest': ('abdominal',),
'abdominaleste': ('abdominal',),
'abdominalt': ('abdominal',),
'abessinsk': ('abessinsk',),
'abessinske': ('abessinsk',),
'abessinskere': ('abessinsk',),
'abessinskest': ('abessinsk',),
'abessinskeste': ('abessinsk',),
'abkhasisk': ('abkhasisk',),
'abkhasiske': ('abkhasisk',),
'abkhasiskere': ('abkhasisk',),
'abkhasiskest': ('abkhasisk',),
'abkhasiskeste': ('abkhasisk',),
'ablativisk': ('ablativisk',),
'ablativiske': ('ablativisk',),
'ablativiskere': ('ablativisk',),
'ablativiskest': ('ablativisk',),
'ablativiskeste': ('ablativisk',),
'abnorm': ('abnorm',),
'abnorme': ('abnorm',),
'abnormere': ('abnorm',),
'abnormest': ('abnorm',),
'abnormeste': ('abnorm',),
'abnormt': ('abnorm',),
'abonnerende': ('abonnere',),
'abonnert': ('abonnere',),
'abonnerte': ('abonnere',),
'aborterende': ('abortere',),
'abortert': ('abortere',),
'aborterte': ('abortere',),
'abortiv': ('abortiv',),
'abortive': ('abortiv',),
'abortivere': ('abortiv',),
'abortivest': ('abortiv',),
'abortiveste': ('abortiv',),
'abortivt': ('abortiv',),
'abortsøkende': ('abortsøkende',),
'abrupt': ('abrupt',),
'abrupte': ('abrupt',),
'abruptere': ('abrupt',),
'abruptest': ('abrupt',),
'abrupteste': ('abrupt',),
'absenterende': ('absentere',),
'absentert': ('absentere',),
'absenterte': ('absentere',),
'absolutistisk': ('absolutistisk',),
'absolutistiske': ('absolutistisk',),
'absolutistiskere': ('absolutistisk',),
'absolutistiskest': ('absolutistisk',),
'absolutistiskeste': ('absolutistisk',),
'absolutt': ('absolutt',),
'absolutte': ('absolutt',),
'absoluttere': ('absolutt',),
'absoluttest': ('absolutt',),
'absolutteste': ('absolutt',),
'absolverende': ('absolvere',),
'absolvert': ('absolvere',),
'absolverte': ('absolvere',),
'absorberende': ('absorbere',),
'absorbert': ('absorbere',),
'absorberte': ('absorbere',),
'absorptiv': ('absorptiv',),
'absorptive': ('absorptiv',),
'absorptivere': ('absorptiv',),
'absorptivest': ('absorptiv',),
'absorptiveste': ('absorptiv',),
'absorptivt': ('absorptiv',),
'abstinent': ('abstinent',),
'abstinente': ('abstinent',),
'abstinentere': ('abstinent',),
'abstinentest': ('abstinent',),
'abstinenteste': ('abstinent',),
'abstraherende': ('abstrahere',),
'abstrahert': ('abstrahere',),
'abstraherte': ('abstrahere',),
'abstrakt': ('abstrakt',),
'abstrakte': ('abstrakt',),
'abstraktere': ('abstrakt',),
'abstraktest': ('abstrakt',),
'abstrakteste': ('abstrakt',),
'absurd': ('absurd',),
'absurde': ('absurd',),
'absurdere': ('absurd',),
'absurdest': ('absurd',),
'absurdeste': ('absurd',),
'absurdistisk': ('absurdistisk',),
'absurdistiske': ('absurdistisk',),
'absurdistiskere': ('absurdistisk',),
'absurdistiskest': ('absurdistisk',),
'absurdistiskeste': ('absurdistisk',),
'adapterende': ('adaptere',),
'adaptert': ('adaptere',),
'adapterte': ('adaptere',),
'adaptiv': ('adaptiv',),
'adaptive': ('adaptiv',),
'adaptivere': ('adaptiv',),
'adaptivest': ('adaptiv',),
'adaptiveste': ('adaptiv',),
'adaptivt': ('adaptiv',),
'adderende': ('addere',),
'addert': ('addere',),
'adderte': ('addere',),
'additiv': ('additiv',),
'additive': ('additiv',),
'additivere': ('additiv',),
'additivest': ('additiv',),
'additiveste': ('additiv',),
'additivt': ('additiv',),
'adekvat': ('adekvat',),
'adekvate': ('adekvat',),
'adekvatere': ('adekvat',),
'adekvatest': ('adekvat',),
'adekvateste': ('adekvat',),
'adelig': ('adelig',),
'adelige': ('adelig',),
'adeligere': ('adelig',),
'adeligst': ('adelig',),
'adeligste': ('adelig',),
'adenoid': ('adenoid',),
'adenoide': ('adenoid',),
'adenoidere': ('adenoid',),
'adenoidest': ('adenoid',),
'adenoideste': ('adenoid',),
'adgangsberettiga': ('adgangsberettiga',),
'adgangsberettigede': ('adgangsberettiget',),
'adgangsberettiget': ('adgangsberettiget',),
'adgangsberettigete': ('adgangsberettiget',),
'adgangsberettigetere': ('adgangsberettiget',),
'adgangsberettigetest': ('adgangsberettiget',),
'adgangsberettigeteste': ('adgangsberettiget',),
'adhererende': ('adherere',),
'adherert': ('adherere',),
'adhererte': ('adherere',),
'adjektiverende': ('adjektivere',),
'adjektivert': ('adjektivere',),
'adjektiverte': ('adjektivere',),
'adjektivisk': ('adjektivisk',),
'adjektiviske': ('adjektivisk',),
'adjektiviskere': ('adjektivisk',),
'adjektiviskest': ('adjektivisk',),
'adjektiviskeste': ('adjektivisk',),
'adla': ('adle',),
'adlede': ('adle',),
'adlende': ('adle',),
'adlet': ('adle',),
'adlete': ('adle',),
'adlydende': ('adlyde',),
'adlydt': ('adlyde',),
'adlydte': ('adlyde',),
'administrativ': ('administrativ',),
'administrative': ('administrativ',),
'administrativere': ('administrativ',),
'administrativest': ('administrativ',),
'administrativeste': ('administrativ',),
'administrativt': ('administrativ',),
'administrerende': ('administrere',),
'administrert': ('administrere',),
'administrerte': ('administrere',),
'adonisk': ('adonisk',),
'adoniske': ('adonisk',),
'adoniskere': ('adonisk',),
'adoniskest': ('adonisk',),
'adoniskeste': ('adonisk',),
'adopterende': ('adoptere',),
'adoptert': ('adoptere',),
'adopterte': ('adoptere',),
'adresselaus': ('adresselaus',),
'adresselause': ('adresselaus',),
'adresselausere': ('adresselaus',),
'adresselausest': ('adresselaus',),
'adresselauseste': ('adresselaus',),
'adresselaust': ('adresselaus',),
'adresseløs': ('adresseløs',),
'adresseløse': ('adresseløs',),
'adresseløsere': ('adresseløs',),
'adresseløsest': ('adresseløs',),
'adresseløseste': ('adresseløs',),
'adresseløst': ('adresseløs',),
'adresserende': ('adressere',),
'adressert': ('adressere',),
'adresserte': ('adressere',),
'adsorberende': ('adsorbere',),
'adsorbert': ('adsorbere',),
'adsorberte': ('adsorbere',),
'adstadig': ('adstadig',),
'adstadige': ('adstadig',),
'adstadigere': ('adstadig',),
'adstadigst': ('adstadig',),
'adstadigste': ('adstadig',),
'adstringerende': ('adstringere',),
'adstringert': ('adstringere',),
'adstringerte': ('adstringere',),
'advarende': ('advare',),
'advart': ('advare',),
'advarte': ('advare',),
'advarende': ('advarende',),
'adverbial': ('adverbial',),
'adverbiale': ('adverbial',),
'adverbialere': ('adverbial',),
'adverbialest': ('adverbial',),
'adverbialeste': ('adverbial',),
'adverbialt': ('adverbial',),
'adviserende': ('advisere',),
'advisert': ('advisere',),
'adviserte': ('advisere',),
'advokatorisk': ('advokatorisk',),
'advokatoriske': ('advokatorisk',),
'advokatoriskere': ('advokatorisk',),
'advokatoriskest': ('advokatorisk',),
'advokatoriskeste': ('advokatorisk',),
'aerob': ('aerob',),
'aerobe': ('aerob',),
'aerobere': ('aerob',),
'aerobest': ('aerob',),
'aerobeste': ('aerob',),
'aerobt': ('aerob',),
'aerodynamisk': ('aerodynamisk',),
'aerodynamiske': ('aerodynamisk',),
'aerodynamiskere': ('aerodynamisk',),
'aerodynamiskest': ('aerodynamisk',),
'aerodynamiskeste': ('aerodynamisk',),
'afatisk': ('afatisk',),
'afatiske': ('afatisk',),
'afatiskere': ('afatisk',),
'afatiskest': ('afatisk',),
'afatiskeste': ('afatisk',),
'affekterende': ('affektere',),
'affektert': ('affektere',),
'affekterte': ('affektere',),
'affektert': ('affektert',),
'affekterte': ('affektert',),
'affektertere': ('affektert',),
'affektertest': ('affektert',),
'affekterteste': ('affektert',),
'affektiv': ('affektiv',),
'affektive': ('affektiv',),
'affektivere': ('affektiv',),
'affektivest': ('affektiv',),
'affektiveste': ('affektiv',),
'affektivt': ('affektiv',),
'affektlada': ('affektlada',),
'affektladd': ('affektladd',),
'affektladde': ('affektladd',),
'affektladdere': ('affektladd',),
'affektladdest': ('affektladd',),
'affektladdeste': ('affektladd',),
'affektladede': ('affektladet',),
'affektladet': ('affektladet',),
'affektladete': ('affektladet',),
'affektladetere': ('affektladet',),
'affektladetest': ('affektladet',),
'affektladeteste': ('affektladet',),
'affiserende': ('affisere',),
'affisert': ('affisere',),
'affiserte': ('affisere',),
'afghansk': ('afghansk',),
'afghanske': ('afghansk',),
'afghanskere': ('afghansk',),
'afghanskest': ('afghansk',),
'afghanskeste': ('afghansk',),
'aforistisk': ('aforistisk',),
'aforistiske': ('aforistisk',),
'aforistiskere': ('aforistisk',),
'aforistiskest': ('aforistisk',),
'aforistiskeste': ('aforistisk',),
'afrikaniserende': ('afrikanisere',),
'afrikanisert': ('afrikanisere',),
'afrikaniserte': ('afrikanisere',),
'afrikansk': ('afrikansk',),
'afrikanske': ('afrikansk',),
'afrikanskere': ('afrikansk',),
'afrikanskest': ('afrikansk',),
'afrikanskeste': ('afrikansk',),
'afroamerikansk': ('afroamerikansk',),
'afroamerikanske': ('afroamerikansk',),
'afroamerikanskere': ('afroamerikansk',),
'afroamerikanskest': ('afroamerikansk',),
'afroamerikanskeste': ('afroamerikansk',),
'afroasiatisk': ('afroasiatisk',),
'afroasiatiske': ('afroasiatisk',),
'afroasiatiskere': ('afroasiatisk',),
'afroasiatiskest': ('afroasiatisk',),
'afroasiatiskeste': ('afroasiatisk',),
'aga': ('age',),
'agede': ('age',),
'agende': ('age',),
'aget': ('age',),
'agete': ('age',),
'agelaus': ('agelaus',),
'agelause': ('agelaus',),
'agelausere': ('agelaus',),
'agelausest': ('agelaus',),
'agelauseste': ('agelaus',),
'agelaust': ('agelaus',),
'ageløs': ('ageløs',),
'ageløse': ('ageløs',),
'ageløsere': ('ageløs',),
'ageløsest': ('ageløs',),
'ageløseste': ('ageløs',),
'ageløst': ('ageløs',),
'agerende': ('agere',),
'agert': ('agere',),
'agerte': ('agere',),
'agglutinerende': ('agglutinere',),
'agglutinert': ('agglutinere',),
'agglutinerte': ('agglutinere',),
'aggressiv': ('aggressiv',),
'aggressive': ('aggressiv',),
'aggressivere': ('aggressiv',),
'aggressivest': ('aggressiv',),
'aggressiveste': ('aggressiv',),
'aggressivt': ('aggressiv',),
'agitatorisk': ('agitatorisk',),
'agitatoriske': ('agitatorisk',),
'agitatoriskere': ('agitatorisk',),
'agitatoriskest': ('agitatorisk',),
'agitatoriskeste': ('agitatorisk',),
'agiterende': ('agitere',),
'agitert': ('agitere',),
'agiterte': ('agitere',),
'agnatisk': ('agnatisk',),
'agnatiske': ('agnatisk',),
'agnatiskere': ('agnatisk',),
'agnatiskest': ('agnatisk',),
'agnatiskeste': ('agnatisk',),
'agna': ('agne',),
'agnede': ('agne',),
'agnende': ('agne',),
'agnet': ('agne',),
'agnete': ('agne',),
'agnostisk': ('agnostisk',),
'agnostiske': ('agnostisk',),
'agnostiskere': ('agnostisk',),
'agnostiskest': ('agnostisk',),
'agnostiskeste': ('agnostisk',),
'agrarisk': ('agrarisk',),
'agrariske': ('agrarisk',),
'agrariskere': ('agrarisk',),
'agrariskest': ('agrarisk',),
'agrariskeste': ('agrarisk',),
'agronomisk': ('agronomisk',),
'agronomiske': ('agronomisk',),
'agronomiskere': ('agronomisk',),
'agronomiskest': ('agronomisk',),
'agronomiskeste': ('agronomisk',),
'ahistorisk': ('ahistorisk',),
'ahistoriske': ('ahistorisk',),
'ahistoriskere': ('ahistorisk',),
'ahistoriskest': ('ahistorisk',),
'ahistoriskeste': ('ahistorisk',),
'ajourførende': ('ajourføre',),
'ajourført': ('ajourføre',),
'ajourførte': ('ajourføre',),
'akademisk': ('akademisk',),
'akademiske': ('akademisk',),
'akademiskere': ('akademisk',),
'akademiskest': ('akademisk',),
'akademiskeste': ('akademisk',),
'akende': ('ake',),
'akt': ('ake',),
'akte': ('ake',),
'akka': ('akke',),
'akkede': ('akke',),
'akkende': ('akke',),
'akket': ('akke',),
'akkete': ('akke',),
'akka': ('akke',),
'akkede': ('akke',),
'akkende': ('akke',),
'akket': ('akke',),
'akkete': ('akke',),
'akkederende': ('akkedere',),
'akkedert': ('akkedere',),
'akkederte': ('akkedere',),
'akklimatiserende': ('akklimatisere',),
'akklimatisert': ('akklimatisere',),
'akklimatiserte': ('akklimatisere',),
'akkommoderende': ('akkommodere',),
'akkommodert': ('akkommodere',),
'akkommoderte': ('akkommodere',),
'akkompagnerende': ('akkompagnere',),
'akkompagnert': ('akkompagnere',),
'akkompagnerte': ('akkompagnere',),
'akkorderende': ('akkordere',),
'akkordert': ('akkordere',),
'akkorderte': ('akkordere',),
'akkrediterende': ('akkreditere',),
'akkreditert': ('akkreditere',),
'akkrediterte': ('akkreditere',),
'akkumulerende': ('akkumulere',),
'akkumulert': ('akkumulere',),
'akkumulerte': ('akkumulere',),
'akkusativisk': ('akkusativisk',),
'akkusativiske': ('akkusativisk',),
'akkusativiskere': ('akkusativisk',),
'akkusativiskest': ('akkusativisk',),
'akkusativiskeste': ('akkusativisk',),
'akkvirerende': ('akkvirere',),
'akkvirert': ('akkvirere',),
'akkvirerte': ('akkvirere',),
'akrobatisk': ('akrobatisk',),
'akrobatiske': ('akrobatisk',),
'akrobatiskere': ('akrobatisk',),
'akrobatiskest': ('akrobatisk',),
'akrobatiskeste': ('akrobatisk',),
'akromatisk': ('akromatisk',),
'akromatiske': ('akromatisk',),
'akromatiskere': ('akromatisk',),
'akromatiskest': ('akromatisk',),
'akromatiskeste': ('akromatisk',),
'akselbred': ('akselbred',),
'akselbrede': ('akselbred',),
'akselbredere': ('akselbred',),
'akselbredest': ('akselbred',),
'akselbredeste': ('akselbred',),
'akselbredt': ('akselbred',),
'akselbrei': ('akselbrei',),
'akselbreie': ('akselbrei',),
'akselbreiere': ('akselbrei',),
'akselbreiest': ('akselbrei',),
'akselbreieste': ('akselbrei',),
'akselbreit': ('akselbrei',),
'akselbreitt': ('akselbrei',),
'akselererende': ('akselerere',),
'akselerert': ('akselerere',),
'akselererte': ('akselerere',),
'aksentuerende': ('aksentuere',),
'aksentuert': ('aksentuere',),
'aksentuerte': ('aksentuere',),
'akseptabel': ('akseptabel',),
'akseptabelt': ('akseptabel',),
'akseptable': ('akseptabel',),
'akseptablere': ('akseptabel',),
'akseptablest': ('akseptabel',),
'akseptableste': ('akseptabel',),
'aksepterende': ('akseptere',),
'akseptert': ('akseptere',),
'aksepterte': ('akseptere',),
'aksessorisk': ('aksessorisk',),
'aksessoriske': ('aksessorisk',),
'aksessoriskere': ('aksessorisk',),
'aksessoriskest': ('aksessorisk',),
'aksessoriskeste': ('aksessorisk',),
'aksial': ('aksial',),
'aksiale': ('aksial',),
'aksialere': ('aksial',),
'aksialest': ('aksial',),
'aksialeste': ('aksial',),
'aksialt': ('aksial',),
'aksiomatisk': ('aksiomatisk',),
'aksiomatiske': ('aksiomatisk',),
'aksiomatiskere': ('aksiomatisk',),
'aksiomatiskest': ('aksiomatisk',),
'aksiomatiskeste': ('aksiomatisk',),
'aksjonerende': ('aksjonere',),
'aksjonert': ('aksjonere',),
'aksjonerte': ('aksjonere',),
'aksla': ('aksle',),
'akslede': ('aksle',),
'akslende': ('aksle',),
'akslet': ('aksle',),
'akslete': ('aksle',),
'akslebred': ('akslebred',),
'akslebrede': ('akslebred',),
'akslebredere': ('akslebred',),
'akslebredest': ('akslebred',),
'akslebredeste': ('akslebred',),
'akslebredt': ('akslebred',),
'akslebrei': ('akslebrei',),
'akslebreie': ('akslebrei',),
'akslebreiere': ('akslebrei',),
'akslebreiest': ('akslebrei',),
'akslebreieste': ('akslebrei',),
'akslebreit': ('akslebrei',),
'akslebreitt': ('akslebrei',),
'akta': ('akta',),
'akta': ('akte',),
'aktede': ('akte',),
'aktende': ('akte',),
'aktet': ('akte',),
'aktete': ('akte',),
'akterlig': ('akterlig',),
'akterlige': ('akterlig',),
'akterligere': ('akterlig',),
'akterligst': ('akterlig',),
'akterligste': ('akterlig',),
'akterst': ('akterst',),
'akterste': ('akterst',),
'akterutsegla': ('akterutsegle',),
'akterutseglede': ('akterutsegle',),
'akterutseglende': ('akterutsegle',),
'akterutseglet': ('akterutsegle',),
'akterutseglete': ('akterutsegle',),
'akterutseilende': ('akterutseile',),
'akterutseilt': ('akterutseile',),
'akterutseilte': ('akterutseile',),
'aktede': ('aktet',),
'aktet': ('aktet',),
'aktete': ('aktet',),
'aktetere': ('aktet',),
'aktetest': ('aktet',),
'akteteste': ('aktet',),
'aktiv': ('aktiv',),
'aktive': ('aktiv',),
'aktivere': ('aktiv',),
'aktivest': ('aktiv',),
'aktiveste': ('aktiv',),
'aktivt': ('aktiv',),
'aktiverende': ('aktivere',),
'aktivert': ('aktivere',),
'aktiverte': ('aktivere',),
'aktiviserende': ('aktivisere',),
'aktivisert': ('aktivisere',),
'aktiviserte': ('aktivisere',),
'aktivistisk': ('aktivistisk',),
'aktivistiske': ('aktivistisk',),
'aktivistiskere': ('aktivistisk',),
'aktivistiskest': ('aktivistisk',),
'aktivistiskeste': ('aktivistisk',),
'aktpågivende': ('aktpågivende',),
'akterst': ('aktre',),
'akterste': ('aktre',),
'aktre': ('aktre',),
'aktsom': ('aktsom',),
'aktsomme': ('aktsom',),
'aktsommere': ('aktsom',),
'aktsomst': ('aktsom',),
'aktsomste': ('aktsom',),
'aktsomt': ('aktsom',),
'aktualiserende': ('aktualisere',),
'aktualisert': ('aktualisere',),
'aktualiserte': ('aktualisere',),
'aktuell': ('aktuell',),
'aktuelle': ('aktuell',),
'aktuellere': ('aktuell',),
'aktuellest': ('aktuell',),
'aktuelleste': ('aktuell',),
'aktuelt': ('aktuell',),
'aktverdig': ('aktverdig',),
'aktverdige': ('aktverdig',),
'aktverdigere': ('aktverdig',),
'aktverdigst': ('aktverdig',),
'aktverdigste': ('aktverdig',),
'akustisk': ('akustisk',),
'akustiske': ('akustisk',),
'akustiskere': ('akustisk',),
'akustiskest': ('akustisk',),
'akustiskeste': ('akustisk',),
'akutt': ('akutt',),
'akutte': ('akutt',),
'akuttere': ('akutt',),
'akuttest': ('akutt',),
'akutteste': ('akutt',),
'akvatisk': ('akvatisk',),
'akvatiske': ('akvatisk',),
'akvatiskere': ('akvatisk',),
'akvatiskest': ('akvatisk',),
'akvatiskeste': ('akvatisk',),
'alabasthvit': ('alabasthvit',),
'alabasthvite': ('alabasthvit',),
'alabasthvitere': ('alabasthvit',),
'alabasthvitest': ('alabasthvit',),
'alabasthviteste': ('alabasthvit',),
'alabasthvitt': ('alabasthvit',),
'alabasthvit': ('alabasthvit',),
'alabasthvite': ('alabasthvit',),
'alabasthvitere': ('alabasthvit',),
'alabasthvitest': ('alabasthvit',),
'alabasthviteste': ('alabasthvit',),
'alabasthvitt': ('alabasthvit',),
'alabastkvit': ('alabastkvit',),
'alabastkvite': ('alabastkvit',),
'alabastkvitere': ('alabastkvit',),
'alabastkvitest': ('alabastkvit',),
'alabastkviteste': ('alabastkvit',),
'alabastkvitt': ('alabastkvit',),
'alabastkvit': ('alabastkvit',),
'alabastkvite': ('alabastkvit',),
'alabastkvitere': ('alabastkvit',),
'alabastkvitest': ('alabastkvit',),
'alabastkviteste': ('alabastkvit',),
'alabastkvitt': ('alabastkvit',),
'alarmerende': ('alarmere',),
'alarmert': ('alarmere',),
'alarmerte': ('alarmere',),
'alarmerende': ('alarmerende',),
'alaskisk': ('alaskisk',),
'alaskiske': ('alaskisk',),
'alaskiskere': ('alaskisk',),
'alaskiskest': ('alaskisk',),
'alaskiskeste': ('alaskisk',),
'albansk': ('albansk',),
'albanske': ('albansk',),
'albanskere': ('albansk',),
'albanskest': ('albansk',),
'albanskeste': ('albansk',),
'albin': ('albin',),
'albine': ('albin',),
'albinere': ('albin',),
'albinest': ('albin',),
'albineste': ('albin',),
'albint': ('albin',),
'alboga': ('alboge',),
'albogede': ('alboge',),
'albogende': ('alboge',),
'alboget': ('alboge',),
'albogete': ('alboge',),
'albua': ('albue',),
'albuede': ('albue',),
'albuende': ('albue',),
'albuet': ('albue',),
'albuete': ('albue',),
'alderdommelig': ('alderdommelig',),
'alderdommelige': ('alderdommelig',),
'alderdommeligere': ('alderdommelig',),
'alderdommeligst': ('alderdommelig',),
'alderdommeligste': ('alderdommelig',),
'alderdomssløv': ('alderdomssløv',),
'alderdomssløve': ('alderdomssløv',),
'alderdomssløvere': ('alderdomssløv',),
'alderdomssløvest': ('alderdomssløv',),
'alderdomssløveste': ('alderdomssløv',),
'alderdomssløvt': ('alderdomssløv',),
'aldersbestemmende': ('aldersbestemme',),
'aldersbestemt': ('aldersbestemme',),
'aldersbestemte': ('aldersbestemme',),
'alderstegen': ('alderstegen',),
'alderstegent': ('alderstegen',),
'alderstegne': ('alderstegen',),
'alderstegnere': ('alderstegen',),
'alderstegnest': ('alderstegen',),
'alderstegneste': ('alderstegen',),
'aldra': ('aldre',),
'aldrede': ('aldre',),
'aldrende': ('aldre',),
'aldret': ('aldre',),
'aldrete': ('aldre',),
'aldrende': ('aldrende',),
'aldringsbestandig': ('aldringsbestandig',),
'aldringsbestandige': ('aldringsbestandig',),
'aldringsbestandigere': ('aldringsbestandig',),
'aldringsbestandigst': ('aldringsbestandig',),
'aldringsbestandigste': ('aldringsbestandig',),
'ala': ('ale',),
'alede': ('ale',),
'alende': ('ale',),
'alet': ('ale',),
'alete': ('ale',),
'alt': ('ale',),
'alte': ('ale',),
'aleksandrinsk': ('aleksandrinsk',),
'aleksandrinske': ('aleksandrinsk',),
'aleksandrinskere': ('aleksandrinsk',),
'aleksandrinskest': ('aleksandrinsk',),
'aleksandrinskeste': ('aleksandrinsk',),
'alemannisk': ('alemannisk',),
'alemanniske': ('alemannisk',),
'alemanniskere': ('alemannisk',),
'alemanniskest': ('alemannisk',),
'alemanniskeste': ('alemannisk',),
'aleutisk': ('aleutisk',),
'aleutiske': ('aleutisk',),
'aleutiskere': ('aleutisk',),
'aleutiskest': ('aleutisk',),
'aleutiskeste': ('aleutisk',),
'alfabetiserende': ('alfabetisere',),
'alfabetisert': ('alfabetisere',),
'alfabetiserte': ('alfabetisere',),
'alfabetisk': ('alfabetisk',),
'alfabetiske': ('alfabetisk',),
'alfabetiskere': ('alfabetisk',),
'alfabetiskest': ('alfabetisk',),
'alfabetiskeste': ('alfabetisk',),
'alfanumerisk': ('alfanumerisk',),
'alfanumeriske': ('alfanumerisk',),
'alfanumeriskere': ('alfanumerisk',),
'alfanumeriskest': ('alfanumerisk',),
'alfanumeriskeste': ('alfanumerisk',),
'algebraisk': ('algebraisk',),
'algebraiske': ('algebraisk',),
'algebraiskere': ('algebraisk',),
'algebraiskest': ('algebraisk',),
'algebraiskeste': ('algebraisk',),
'algerisk': ('algerisk',),
'algeriske': ('algerisk',),
'algeriskere': ('algerisk',),
'algeriskest': ('algerisk',),
'algeriskeste': ('algerisk',),
'algonkinsk': ('algonkinsk',),
'algonkinske': ('algonkinsk',),
'algonkinskere': ('algonkinsk',),
'algonkinskest': ('algonkinsk',),
'algonkinskeste': ('algonkinsk',),
'alienerende': ('alienere',),
'alienert': ('alienere',),
'alienerte': ('alienere',),
'alifatisk': ('alifatisk',),
'alifatiske': ('alifatisk',),
'alifatiskere': ('alifatisk',),
'alifatiskest': ('alifatisk',),
'alifatiskeste': ('alifatisk',),
'alkalisk': ('alkalisk',),
'alkaliske': ('alkalisk',),
'alkaliskere': ('alkalisk',),
'alkaliskest': ('alkalisk',),
'alkaliskeste': ('alkalisk',),
'alkoholholdig': ('alkoholholdig',),
'alkoholholdige': ('alkoholholdig',),
'alkoholholdigere': ('alkoholholdig',),
'alkoholholdigst': ('alkoholholdig',),
'alkoholholdigste': ('alkoholholdig',),
'alkoholiserende': ('alkoholisere',),
'alkoholisert': ('alkoholisere',),
'alkoholiserte': ('alkoholisere',),
'alkoholisk': ('alkoholisk',),
'alkoholiske': ('alkoholisk',),
'alkoholiskere': ('alkoholisk',),
'alkoholiskest': ('alkoholisk',),
'alkoholiskeste': ('alkoholisk',),
'alkoholpåvirka': ('alkoholpåvirka',),
'alkoholpåvirkede': ('alkoholpåvirket',),
'alkoholpåvirket': ('alkoholpåvirket',),
'alkoholpåvirkete': ('alkoholpåvirket',),
'alkoholpåvirketere': ('alkoholpåvirket',),
'alkoholpåvirketest': ('alkoholpåvirket',),
'alkoholpåvirketeste': ('alkoholpåvirket',),
'alkoholskada': ('alkoholskada',),
'alkoholskadd': ('alkoholskadd',),
'alkoholskadde': ('alkoholskadd',),
'alkoholskaddere': ('alkoholskadd',),
'alkoholskaddest': ('alkoholskadd',),
'alkoholskaddeste': ('alkoholskadd',),
'alkoholskadede': ('alkoholskadet',),
'alkoholskadet': ('alkoholskadet',),
'alkoholskadete': ('alkoholskadet',),
'alkoholskadetere': ('alkoholskadet',),
'alkoholskadetest': ('alkoholskadet',),
'alkoholskadeteste': ('alkoholskadet',),
'alkoholsvak': ('alkoholsvak',),
'alkoholsvake': ('alkoholsvak',),
'alkoholsvakere': ('alkoholsvak',),
'alkoholsvakest': ('alkoholsvak',),
'alkoholsvakeste': ('alkoholsvak',),
'alkoholsvakt': ('alkoholsvak',),
'all right': ('all right',),
'all righte': ('all right',),
'all rightere': ('all right',),
'all rightest': ('all right',),
'all righteste': ('all right',),
'all round': ('all round',),
'all slags': ('all slags',),
'allegorisk': ('allegorisk',),
'allegoriske': ('allegorisk',),
'allegoriskere': ('allegorisk',),
'allegoriskest': ('allegorisk',),
'allegoriskeste': ('allegorisk',),
'allehånde': ('allehånde',),
'allel': ('allel',),
'allele': ('allel',),
'allelere': ('allel',),
'allelest': ('allel',),
'alleleste': ('allel',),
'allelt': ('allel',),
'allergisk': ('allergisk',),
'allergiske': ('allergisk',),
'allergiskere': ('allergisk',),
'allergiskest': ('allergisk',),
'allergiskeste': ('allergisk',),
'allestedsnærværende': ('allestedsnærværende',),
'alleuropeisk': ('alleuropeisk',),
'alleuropeiske': ('alleuropeisk',),
'alleuropeiskere': ('alleuropeisk',),
'alleuropeiskest': ('alleuropeisk',),
'alleuropeiskeste': ('alleuropeisk',),
'allierende': ('alliere',),
'alliert': ('alliere',),
'allierte': ('alliere',),
'alliert': ('alliert',),
'allierte': ('alliert',),
'alliertere': ('alliert',),
'alliertest': ('alliert',),
'allierteste': ('alliert',),
'allittererende': ('allitterere',),
'allitterert': ('allitterere',),
'allittererte': ('allitterere',),
'allmektig': ('allmektig',),
'allmektige': ('allmektig',),
'allmektigere': ('allmektig',),
'allmektigst': ('allmektig',),
'allmektigste': ('allmektig',),
'allmenn': ('allmenn',),
'allmenne': ('allmenn',),
'allmennere': ('allmenn',),
'allmennest': ('allmenn',),
'allmenneste': ('allmenn',),
'allment': ('allmenn',),
'allmenn-nyttig': ('allmenn-nyttig',),
'allmenn-nyttige': ('allmenn-nyttig',),
'allmenn-nyttigere': ('allmenn-nyttig',),
'allmenn-nyttigst': ('allmenn-nyttig',),
'allmenn-nyttigste': ('allmenn-nyttig',),
'allmenndannende': ('allmenndannende',),
'allmenngyldig': ('allmenngyldig',),
'allmenngyldige': ('allmenngyldig',),
'allmenngyldigere': ('allmenngyldig',),
'allmenngyldigst': ('allmenngyldig',),
'allmenngyldigste': ('allmenngyldig',),
'allmennmenneskelig': ('allmennmenneskelig',),
'allmennmenneskelige': ('allmennmenneskelig',),
'allmennmenneskeligere': ('allmennmenneskelig',),
'allmennmenneskeligst': ('allmennmenneskelig',),
'allmennmenneskeligste': ('allmennmenneskelig',),
'allmennpraktiserende': ('allmennpraktiserende',),
'allmennpreventiv': ('allmennpreventiv',),
'allmennpreventive': ('allmennpreventiv',),
'allmennpreventivere': ('allmennpreventiv',),
'allmennpreventivest': ('allmennpreventiv',),
'allmennpreventiveste': ('allmennpreventiv',),
'allmennpreventivt': ('allmennpreventiv',),
'allmennyttig': ('allmennyttig',),
'allmennyttige': ('allmennyttig',),
'allmennyttigere': ('allmennyttig',),
'allmennyttigst': ('allmennyttig',),
'allmennyttigste': ('allmennyttig',),
'allofonisk': ('allofonisk',),
'allofoniske': ('allofonisk',),
'allofoniskere': ('allofonisk',),
'allofoniskest': ('allofonisk',),
'allofoniskeste': ('allofonisk',),
'allokerende': ('allokere',),
'allokert': ('allokere',),
'allokerte': ('allokere',),
'allomorfisk': ('allomorfisk',),
'allomorfiske': ('allomorfisk',),
'allomorfiskere': ('allomorfisk',),
'allomorfiskest': ('allomorfisk',),
'allomorfiskeste': ('allomorfisk',),
'allsidig': ('allsidig',),
'allsidige': ('allsidig',),
'allsidigere': ('allsidig',),
'allsidigst': ('allsidig',),
'allsidigste': ('allsidig',),
'allslags': ('allslags',),
'alltysk': ('alltysk',),
'alltyske': ('alltysk',),
'alltyskere': ('alltysk',),
'alltyskest': ('alltysk',),
'alltyskeste': ('alltysk',),
'alluderende': ('alludere',),
'alludert': ('alludere',),
'alluderte': ('alludere',),
'alluvial': ('alluvial',),
'alluviale': ('alluvial',),
'alluvialere': ('alluvial',),
'alluvialest': ('alluvial',),
'alluvialeste': ('alluvial',),
'alluvialt': ('alluvial',),
'allvitende': ('allvitende',),
'alminnelig': ('alminnelig',),
'alminnelige': ('alminnelig',),
'alminneligere': ('alminnelig',),
'alminneligst': ('alminnelig',),
'alminneligste': ('alminnelig',),
'alpin': ('alpin',),
'alpine': ('alpin',),
'alpinere': ('alpin',),
'alpinest': ('alpin',),
'alpineste': ('alpin',),
'alpint': ('alpin',),
'alpinsk': ('alpinsk',),
'alpinske': ('alpinsk',),
'alpinskere': ('alpinsk',),
'alpinskest': ('alpinsk',),
'alpinskeste': ('alpinsk',),
'alsasisk': ('alsasisk',),
'alsasiske': ('alsasisk',),
'alsasiskere': ('alsasisk',),
'alsasiskest': ('alsasisk',),
'alsasiskeste': ('alsasisk',),
'alskens': ('alskens',),
'altaisk': ('altaisk',),
'altaiske': ('altaisk',),
'altaiskere': ('altaisk',),
'altaiskest': ('altaisk',),
'altaiskeste': ('altaisk',),
'altererende': ('alterere',),
'alterert': ('alterere',),
'altererte': ('alterere',),
'alternativ': ('alternativ',),
'alternative': ('alternativ',),
'alternativere': ('alternativ',),
'alternativest': ('alternativ',),
'alternativeste': ('alternativ',),
'alternativt': ('alternativ',),
'alternerende': ('alternere',),
'alternert': ('alternere',),
'alternerte': ('alternere',),
'altetende': ('altetende',),
'altgjennomtrengende': ('altgjennomtrengende',),
'altomfattende': ('altomfattende',),
'altomspennende': ('altomspennende',),
'altoppslukende': ('altoppslukende',),
'altruistisk': ('altruistisk',),
'altruistiske': ('altruistisk',),
'altruistiskere': ('altruistisk',),
'altruistiskest': ('altruistisk',),
'altruistiskeste': ('altruistisk',),
'aluminerende': ('aluminere',),
'aluminert': ('aluminere',),
'aluminerte': ('aluminere',),
'alveolar': ('alveolar',),
'alveolare': ('alveolar',),
'alveolarere': ('alveolar',),
'alveolarest': ('alveolar',),
'alveolareste': ('alveolar',),
'alveolart': ('alveolar',),
'alvorlig': ('alvorlig',),
'alvorlige': ('alvorlig',),
'alvorligere': ('alvorlig',),
'alvorligst': ('alvorlig',),
'alvorligste': ('alvorlig',),
'alvorsfull': ('alvorsfull',),
'alvorsfulle': ('alvorsfull',),
'alvorsfullere': ('alvorsfull',),
'alvorsfullest': ('alvorsfull',),
'alvorsfulleste': ('alvorsfull',),
'alvorsfullt': ('alvorsfull',),
'alvorstung': ('alvorstung',),
'alvorstunge': ('alvorstung',),
'alvorstungere': ('alvorstung',),
'alvorstungest': ('alvorstung',),
'alvorstungeste': ('alvorstung',),
'alvorstungt': ('alvorstung',),
'alvorstyngre': ('alvorstung',),
'alvorstyngst': ('alvorstung',),
'alvorstyngste': ('alvorstung',),
'amalgamerende': ('amalgamere',),
'amalgamert': ('amalgamere',),
'amalgamerte': ('amalgamere',),
'amatørmessig': ('amatørmessig',),
'amatørmessige': ('amatørmessig',),
'amatørmessigere': ('amatørmessig',),
'amatørmessigst': ('amatørmessig',),
'amatørmessigste': ('amatørmessig',),
'ambiguøs': ('ambiguøs',),
'ambiguøse': ('ambiguøs',),
'ambiguøsere': ('ambiguøs',),
'ambiguøsest': ('ambiguøs',),
'ambiguøseste': ('ambiguøs',),
'ambiguøst': ('ambiguøs',),
'ambisiøs': ('ambisiøs',),
'ambisiøse': ('ambisiøs',),
'ambisiøsere': ('ambisiøs',),
'ambisiøsest': ('ambisiøs',),
'ambisiøseste': ('ambisiøs',),
'ambisiøst': ('ambisiøs',),
'ambivalent': ('ambivalent',),
'ambivalente': ('ambivalent',),
'ambivalentere': ('ambivalent',),
'ambivalentest': ('ambivalent',),
'ambivalenteste': ('ambivalent',),
'ambrosiansk': ('ambrosiansk',),
'ambrosianske': ('ambrosiansk',),
'ambrosianskere': ('ambrosiansk',),
'ambrosianskest': ('ambrosiansk',),
'ambrosianskeste': ('ambrosiansk',),
'ambrosisk': ('ambrosisk',),
'ambrosiske': ('ambrosisk',),
'ambrosiskere': ('ambrosisk',),
'ambrosiskest': ('ambrosisk',),
'ambrosiskeste': ('ambrosisk',),
'ambulant': ('ambulant',),
'ambulante': ('ambulant',),
'ambulantere': ('ambulant',),
'ambulantest': ('ambulant',),
'ambulanteste': ('ambulant',),
'ambulatorisk': ('ambulatorisk',),
'ambulatoriske': ('ambulatorisk',),
'ambulatoriskere': ('ambulatorisk',),
'ambulatoriskest': ('ambulatorisk',),
'ambulatoriskeste': ('ambulatorisk',),
'ambulerende': ('ambulere',),
'ambulert': ('ambulere',),
'ambulerte': ('ambulere',),
'ambulerende': ('ambulerende',),
'amerikaniserende': ('amerikanisere',),
'amerikanisert': ('amerikanisere',),
'amerikaniserte': ('amerikanisere',),
'amerikansk': ('amerikansk',),
'amerikanske': ('amerikansk',),
'amerikanskere': ('amerikansk',),
'amerikanskest': ('amerikansk',),
'amerikanskeste': ('amerikansk',),
'amfibisk': ('amfibisk',),
'amfibiske': ('amfibisk',),
'amfibiskere': ('amfibisk',),
'amfibiskest': ('amfibisk',),
'amfibiskeste': ('amfibisk',),
'amma': ('amme',),
'ammede': ('amme',),
'ammende': ('amme',),
'ammet': ('amme',),
'ammete': ('amme',),
'amoralsk': ('amoralsk',),
'amoralske': ('amoralsk',),
'amoralskere': ('amoralsk',),
'amoralskest': ('amoralsk',),
'amoralskeste': ('amoralsk',),
'amorf': ('amorf',),
'amorfe': ('amorf',),
'amorfere': ('amorf',),
'amorfest': ('amorf',),
'amorfeste': ('amorf',),
'amorft': ('amorf',),
'amortisabel': ('amortisabel',),
'amortisabelt': ('amortisabel',),
'amortisable': ('amortisabel',),
'amortisablere': ('amortisabel',),
'amortisablest': ('amortisabel',),
'amortisableste': ('amortisabel',),
'amortiserende': ('amortisere',),
'amortisert': ('amortisere',),
'amortiserte': ('amortisere',),
'amorøs': ('amorøs',),
'amorøse': ('amorøs',),
'amorøsere': ('amorøs',),
'amorøsest': ('amorøs',),
'amorøseste': ('amorøs',),
'amorøst': ('amorøs',),
'amper': ('amper',),
'ampert': ('amper',),
'ampre': ('amper',),
'amprere': ('amper',),
'amprest': ('amper',),
'ampreste': ('amper',),
'amputerende': ('amputere',),
'amputert': ('amputere',),
'amputerte': ('amputere',),
'amøbisk': ('amøbisk',),
'amøbiske': ('amøbisk',),
'amøbiskere': ('amøbisk',),
'amøbiskest': ('amøbisk',),
'amøbiskeste': ('amøbisk',),
'amøboid': ('amøboid',),
'amøboide': ('amøboid',),
'amøboidere': ('amøboid',),
'amøboidest': ('amøboid',),
'amøboideste': ('amøboid',),
'anabol': ('anabol',),
'anabole': ('anabol',),
'anabolere': ('anabol',),
'anabolest': ('anabol',),
'anaboleste': ('anabol',),
'anabolt': ('anabol',),
'anabolsk': ('anabolsk',),
'anabolske': ('anabolsk',),
'anabolskere': ('anabolsk',),
'anabolskest': ('anabolsk',),
'anabolskeste': ('anabolsk',),
'anaerob': ('anaerob',),
'anaerobe': ('anaerob',),
'anaerobere': ('anaerob',),
'anaerobest': ('anaerob',),
'anaerobeste': ('anaerob',),
'anaerobt': ('anaerob',),
'anaforisk': ('anaforisk',),
'anaforiske': ('anaforisk',),
'anaforiskere': ('anaforisk',),
'anaforiskest': ('anaforisk',),
'anaforiskeste': ('anaforisk',),
'anakolutisk': ('anakolutisk',),
'anakolutiske': ('anakolutisk',),
'anakolutiskere': ('anakolutisk',),
'anakolutiskest': ('anakolutisk',),
'anakolutiskeste': ('anakolutisk',),
'anakreontisk': ('anakreontisk',),
'anakreontiske': ('anakreontisk',),
'anakreontiskere': ('anakreontisk',),
'anakreontiskest': ('anakreontisk',),
'anakreontiskeste': ('anakreontisk',),
'anakronistisk': ('anakronistisk',),
'anakronistiske': ('anakronistisk',),
'anakronistiskere': ('anakronistisk',),
'anakronistiskest': ('anakronistisk',),
'anakronistiskeste': ('anakronistisk',),
'anal': ('anal',),
'anale': ('anal',),
'analere': ('anal',),
'analest': ('anal',),
'analeste': ('anal',),
'analt': ('anal',),
'analog': ('analog',),
'analoge': ('analog',),
'analogere': ('analog',),
'analogest': ('analog',),
'analogeste': ('analog',),
'analogt': ('analog',),
'analogisk': ('analogisk',),
'analogiske': ('analogisk',),
'analogiskere': ('analogisk',),
'analogiskest': ('analogisk',),
'analogiskeste': ('analogisk',),
'analyserende': ('analysere',),
'analysert': ('analysere',),
'analyserte': ('analysere',),
'analytisk': ('analytisk',),
'analytiske': ('analytisk',),
'analytiskere': ('analytisk',),
'analytiskest': ('analytisk',),
'analytiskeste': ('analytisk',),
'anapestisk': ('anapestisk',),
'anapestiske': ('anapestisk',),
'anapestiskere': ('anapestisk',),
'anapestiskest': ('anapestisk',),
'anapestiskeste': ('anapestisk',),
'anarkisk': ('anarkisk',),
'anarkiske': ('anarkisk',),
'anarkiskere': ('anarkisk',),
'anarkiskest': ('anarkisk',),
'anarkiskeste': ('anarkisk',),
'anarkistisk': ('anarkistisk',),
'anarkistiske': ('anarkistisk',),
'anarkistiskere': ('anarkistisk',),
'anarkistiskest': ('anarkistisk',),
'anarkistiskeste': ('anarkistisk',),
'anatomisk': ('anatomisk',),
'anatomiske': ('anatomisk',),
'anatomiskere': ('anatomisk',),
'anatomiskest': ('anatomisk',),
'anatomiskeste': ('anatomisk',),
'anbefalende': ('anbefale',),
'anbefalt': ('anbefale',),
'anbefalte': ('anbefale',),
'anbefalelsesverdig': ('anbefalelsesverdig',),
'anbefalelsesverdige': ('anbefalelsesverdig',),
'anbefalelsesverdigere': ('anbefalelsesverdig',),
'anbefalelsesverdigst': ('anbefalelsesverdig',),
'anbefalelsesverdigste': ('anbefalelsesverdig',),
'anbragt': ('anbringe',),
'anbragte': ('anbringe',),
'anbrakt': ('anbringe',),
'anbrakte': ('anbringe',),
'anbringende': ('anbringe',),
'andaktsfull': ('andaktsfull',),
'andaktsfulle': ('andaktsfull',),
'andaktsfullere': ('andaktsfull',),
'andaktsfullest': ('andaktsfull',),
'andaktsfulleste': ('andaktsfull',),
'andaktsfullt': ('andaktsfull',),
'andalusisk': ('andalusisk',),
'andalusiske': ('andalusisk',),
'andalusiskere': ('andalusisk',),
'andalusiskest': ('andalusisk',),
'andalusiskeste': ('andalusisk',),
'anda': ('ande',),
'andede': ('ande',),
'andende': ('ande',),
'andet': ('ande',),
'andete': ('ande',),
'andektig': ('andektig',),
'andektige': ('andektig',),
'andektigere': ('andektig',),
'andektigst': ('andektig',),
'andektigste': ('andektig',),
'andinsk': ('andinsk',),
'andinske': ('andinsk',),
'andinskere': ('andinsk',),
'andinskest': ('andinsk',),
'andinskeste': ('andinsk',),
'andorransk': ('andorransk',),
'andorranske': ('andorransk',),
'andorranskere': ('andorransk',),
'andorranskest': ('andorransk',),
'andorranskeste': ('andorransk',),
'andpusten': ('andpusten',),
'andpustent': ('andpusten',),
'andpustne': ('andpusten',),
'andpustnere': ('andpusten',),
'andpustnest': ('andpusten',),
'andpustneste': ('andpusten',),
'andradd': ('andra',),
'andradde': ('andra',),
'andragende': ('andra',),
'andratt': ('andra',),
'andratte': ('andra',),
'andre': ('andre',),
'andrehånds': ('andrehånds',),
'andreklasses': ('andreklasses',),
'andrerangs': ('andrerangs',),
'androgen': ('androgen',),
'androgene': ('androgen',),
'androgenere': ('androgen',),
'androgenest': ('androgen',),
'androgeneste': ('androgen',),
'androgent': ('androgen',),
'androgyn': ('androgyn',),
'androgyne': ('androgyn',),
'androgynere': ('androgyn',),
'androgynest': ('androgyn',),
'androgyneste': ('androgyn',),
'androgynt': ('androgyn',),
'anduva': ('anduve',),
'anduvede': ('anduve',),
'anduvende': ('anduve',),
'anduvet': ('anduve',),
'anduvete': ('anduve',),
'andøva': ('andøve',),
'andøvd': ('andøve',),
'andøvde': ('andøve',),
'andøvede': ('andøve',),
'andøvende': ('andøve',),
'andøvet': ('andøve',),
'andøvete': ('andøve',),
'anende': ('ane',),
'ant': ('ane',),
'ante': ('ane',),
'anekdotisk': ('anekdotisk',),
'anekdotiske': ('anekdotisk',),
'anekdotiskere': ('anekdotisk',),
'anekdotiskest': ('anekdotisk',),
'anekdotiskeste': ('anekdotisk',),
'anemisk': ('anemisk',),
'anemiske': ('anemisk',),
'anemiskere': ('anemisk',),
'anemiskest': ('anemisk',),
'anemiskeste': ('anemisk',),
'anemofil': ('anemofil',),
'anemofile': ('anemofil',),
'anemofilere': ('anemofil',),
'anemofilest': ('anemofil',),
'anemofileste': ('anemofil',),
'anemofilt': ('anemofil',),
'anerkjennende': ('anerkjenne',),
'anerkjent': ('anerkjenne',),
'anerkjente': ('anerkjenne',),
'anerkjennelsesverdig': ('anerkjennelsesverdig',),
'anerkjennelsesverdige': ('anerkjennelsesverdig',),
'anerkjennelsesverdigere': ('anerkjennelsesverdig',),
'anerkjennelsesverdigst': ('anerkjennelsesverdig',),
'anerkjennelsesverdigste': ('anerkjennelsesverdig',),
'anerkjennende': ('anerkjennende',),
'anerkjent': ('anerkjent',),
'anerkjente': ('anerkjent',),
'anerkjentere': ('anerkjent',),
'anerkjentest': ('anerkjent',),
'anerkjenteste': ('anerkjent',),
'anesteserende': ('anestesere',),
'anestesert': ('anestesere',),
'anesteserte': ('anestesere',),
'anestetisk': ('anestetisk',),
'anestetiske': ('anestetisk',),
'anestetiskere': ('anestetisk',),
'anestetiskest': ('anestetisk',),
'anestetiskeste': ('anestetisk',),
'anfallende': ('anfalle',),
'anfalt': ('anfalle',),
'anfalte': ('anfalle',),
'anfekta': ('anfekte',),
'anfektede': ('anfekte',),
'anfektende': ('anfekte',),
'anfektet': ('anfekte',),
'anfektete': ('anfekte',),
'anførende': ('anføre',),
'anført': ('anføre',),
'anførte': ('anføre',),
'anga': ('ange',),
'angede': ('ange',),
'angende': ('ange',),
'anget': ('ange',),
'angete': ('ange',),
'angelsaksisk': ('angelsaksisk',),
'angelsaksiske': ('angelsaksisk',),
'angelsaksiskere': ('angelsaksisk',),
'angelsaksiskest': ('angelsaksisk',),
'angelsaksiskeste': ('angelsaksisk',),
'angerfull': ('angerfull',),
'angerfulle': ('angerfull',),
'angerfullere': ('angerfull',),
'angerfullest': ('angerfull',),
'angerfulleste': ('angerfull',),
'angerfullt': ('angerfull',),
'angiende': ('angi',),
'angitt': ('angi',),
'angitte': ('angi',),
'angivende': ('angi',),
'angivelig': ('angivelig',),
'angivelige': ('angivelig',),
'angiveligere': ('angivelig',),
'angiveligst': ('angivelig',),
'angiveligste': ('angivelig',),
'angiversk': ('angiversk',),
'angiverske': ('angiversk',),
'angiverskere': ('angiversk',),
'angiverskest': ('angiversk',),
'angiverskeste': ('angiversk',),
'angjeldende': ('angjeldende',),
'angla': ('angle',),
'anglede': ('angle',),
'anglende': ('angle',),
'anglet': ('angle',),
'anglete': ('angle',),
'anglifiserende': ('anglifisere',),
'anglifisert': ('anglifisere',),
'anglifiserte': ('anglifisere',),
'anglikansk': ('anglikansk',),
'anglikanske': ('anglikansk',),
'anglikanskere': ('anglikansk',),
'anglikanskest': ('anglikansk',),
'anglikanskeste': ('anglikansk',),
'angliserende': ('anglisere',),
'anglisert': ('anglisere',),
'angliserte': ('anglisere',),
'angloamerikansk': ('angloamerikansk',),
'angloamerikanske': ('angloamerikansk',),
'angloamerikanskere': ('angloamerikansk',),
'angloamerikanskest': ('angloamerikansk',),
'angloamerikanskeste': ('angloamerikansk',),
'anglofil': ('anglofil',),
'anglofile': ('anglofil',),
'anglofilere': ('anglofil',),
'anglofilest': ('anglofil',),
'anglofileste': ('anglofil',),
'anglofilt': ('anglofil',),
'angolansk': ('angolansk',),
'angolanske': ('angolansk',),
'angolanskere': ('angolansk',),
'angolanskest': ('angolansk',),
'angolanskeste': ('angolansk',),
'angra': ('angre',),
'angrede': ('angre',),
'angrende': ('angre',),
'angret': ('angre',),
'angrete': ('angre',),
'angrende': ('angrende',),
'angrepslysten': ('angrepslysten',),
'angrepslystent': ('angrepslysten',),
'angrepslystne': ('angrepslysten',),
'angrepslystnere': ('angrepslysten',),
'angrepslystnest': ('angrepslysten',),
'angrepslystneste': ('angrepslysten',),
'angrepen': ('angripe',),
'angrepet': ('angripe',),
'angrepne': ('angripe',),
'angripende': ('angripe',),
'angripelig': ('angripelig',),
'angripelige': ('angripelig',),
'angripeligere': ('angripelig',),
'angripeligst': ('angripelig',),
'angripeligste': ('angripelig',),
'angstbitersk': ('angstbitersk',),
'angstbiterske': ('angstbitersk',),
'angstbiterskere': ('angstbitersk',),
'angstbiterskest': ('angstbitersk',),
'angstbiterskeste': ('angstbitersk',),
'angulær': ('angulær',),
'angulære': ('angulær',),
'angulærere': ('angulær',),
'angulærest': ('angulær',),
'angulæreste': ('angulær',),
'angulært': ('angulær',),
'angående': ('angå',),
'angått': ('angå',),
'angåtte': ('angå',),
'anholdende': ('anholde',),
'anholdt': ('anholde',),
'anholdte': ('anholde',),
'animal': ('animal',),
'animale': ('animal',),
'animalere': ('animal',),
'animalest': ('animal',),
'animaleste': ('animal',),
'animalt': ('animal',),
'animaliserende': ('animalisere',),
'animalisert': ('animalisere',),
'animaliserte': ('animalisere',),
'animalsk': ('animalsk',),
'animalske': ('animalsk',),
'animalskere': ('animalsk',),
'animalskest': ('animalsk',),
'animalskeste': ('animalsk',),
'animerende': ('animere',),
'animert': ('animere',),
'animerte': ('animere',),
'animistisk': ('animistisk',),
'animistiske': ('animistisk',),
'animistiskere': ('animistisk',),
'animistiskest': ('animistisk',),
'animistiskeste': ('animistisk',),
'anka': ('anke',),
'ankede': ('anke',),
'ankende': ('anke',),
'anket': ('anke',),
'ankete': ('anke',),
'ankeldjup': ('ankeldjup',),
'ankeldjupe': ('ankeldjup',),
'ankeldjupere': ('ankeldjup',),
'ankeldjupest': ('ankeldjup',),
'ankeldjupeste': ('ankeldjup',),
'ankeldjupt': ('ankeldjup',),
'ankeldyp': ('ankeldyp',),
'ankeldype': ('ankeldyp',),
'ankeldypere': ('ankeldyp',),
'ankeldypest': ('ankeldyp',),
'ankeldypeste': ('ankeldyp',),
'ankeldypt': ('ankeldyp',),
'ankelsid': ('ankelsid',),
'ankelside': ('ankelsid',),
'ankelsidere': ('ankelsid',),
'ankelsidest': ('ankelsid',),
'ankelsideste': ('ankelsid',),
'ankelsidt': ('ankelsid',),
'anklaga': ('anklage',),
'anklagd': ('anklage',),
'anklagde': ('anklage',),
'anklagede': ('anklage',),
'anklagende': ('anklage',),
'anklaget': ('anklage',),
'anklagete': ('anklage',),
'ankommen': ('ankomme',),
'ankommende': ('ankomme',),
'ankommet': ('ankomme',),
'ankomne': ('ankomme',),
'ankra': ('ankre',),
'ankrede': ('ankre',),
'ankrende': ('ankre',),
'ankret': ('ankre',),
'ankrete': ('ankre',),
'anlagt': ('anlagt',),
'anlagte': ('anlagt',),
'anlagtere': ('anlagt',),
'anlagtest': ('anlagt',),
'anlagteste': ('anlagt',),
'anlagt': ('anlegge',),
'anlagte': ('anlegge',),
'anleggende': ('anlegge',),
'anløpende': ('anløpe',),
'anløpet': ('anløpe',),
'anløpt': ('anløpe',),
'anløpte': ('anløpe',),
'anløpen': ('anløpen',),
'anløpent': ('anløpen',),
'anløpne': ('anløpen',),
'anløpnere': ('anløpen',),
'anløpnest': ('anløpen',),
'anløpneste': ('anløpen',),
'anmassa': ('anmasse',),
'anmassede': ('anmasse',),
'anmassende': ('anmasse',),
'anmasset': ('anmasse',),
'anmassete': ('anmasse',),
'anmassende': ('anmassende',),
'anmeldende': ('anmelde',),
'anmeldt': ('anmelde',),
'anmeldte': ('anmelde',),
'anmerka': ('anmerke',),
'anmerkede': ('anmerke',),
'anmerkende': ('anmerke',),
'anmerket': ('anmerke',),
'anmerkete': ('anmerke',),
'anmoda': ('anmode',),
'anmodede': ('anmode',),
'anmodende': ('anmode',),
'anmodet': ('anmode',),
'anmodete': ('anmode',),
'annalistisk': ('annalistisk',),
'annalistiske': ('annalistisk',),
'annalistiskere': ('annalistisk',),
'annalistiskest': ('annalistisk',),
'annalistiskeste': ('annalistisk',),
'annamma': ('annamme',),
'annammede': ('annamme',),
'annammende': ('annamme',),
'annammet': ('annamme',),
'annammete': ('annamme',),
'annekterende': ('annektere',),
'annektert': ('annektere',),
'annekterte': ('annektere',),
'annenhånds': ('annenhånds',),
'annenklasses': ('annenklasses',),
'annenrangs': ('annenrangs',),
'annerledes': ('annerledes',),
'annerledestenkende': ('annerledestenkende',),
'annleis': ('annleis',),
'annleistenkende': ('annleistenkende',),
'annonserende': ('annonsere',),
'annonsert': ('annonsere',),
'annonserte': ('annonsere',),
'annuell': ('annuell',),
'annuelle': ('annuell',),
'annuellere': ('annuell',),
'annuellest': ('annuell',),
'annuelleste': ('annuell',),
'annuelt': ('annuell',),
'annullerende': ('annullere',),
'annullert': ('annullere',),
'annullerte': ('annullere',),
'anodiserende': ('anodisere',),
'anodisert': ('anodisere',),
'anodiserte': ('anodisere',),
'anodisk': ('anodisk',),
'anodiske': ('anodisk',),
'anodiskere': ('anodisk',),
'anodiskest': ('anodisk',),
'anodiskeste': ('anodisk',),
'anomal': ('anomal',),
'anomale': ('anomal',),
'anomalere': ('anomal',),
'anomalest': ('anomal',),
'anomaleste': ('anomal',),
'anomalt': ('anomal',),
'anonym': ('anonym',),
'anonyme': ('anonym',),
'anonymere': ('anonym',),
'anonymest': ('anonym',),
'anonymeste': ('anonym',),
'anonymt': ('anonym',),
'anordna': ('anordne',),
'anordnede': ('anordne',),
'anordnende': ('anordne',),
'anordnet': ('anordne',),
'anordnete': ('anordne',),
'anorganisk': ('anorganisk',),
'anorganiske': ('anorganisk',),
'anorganiskere': ('anorganisk',),
'anorganiskest': ('anorganisk',),
'anorganiskeste': ('anorganisk',),
'anormal': ('anormal',),
'anormale': ('anormal',),
'anormalere': ('anormal',),
'anormalest': ('anormal',),
'anormaleste': ('anormal',),
'anormalt': ('anormal',),
'anretta': ('anrette',),
'anrettede': ('anrette',),
'anrettende': ('anrette',),
'anrettet': ('anrette',),
'anrettete': ('anrette',),
'anrika': ('anrike',),
'anrikede': ('anrike',),
'anrikende': ('anrike',),
'anriket': ('anrike',),
'anrikete': ('anrike',),
'anropende': ('anrope',),
'anropt': ('anrope',),
'anropte': ('anrope',),
'ansatt': ('ansatt',),
'ansatte': ('ansatt',),
'ansattere': ('ansatt',),
'ansattest': ('ansatt',),
'ansatteste': ('ansatt',),
'ansa': ('anse',),
'ansede': ('anse',),
'ansende': ('anse',),
'anset': ('anse',),
'ansete': ('anse',),
'anst': ('anse',),
'anste': ('anse',),
'anseende': ('anse',),
'ansett': ('anse',),
'ansette': ('anse',),
'anselig': ('anselig',),
'anselige': ('anselig',),
'anseligere': ('anselig',),
'anseligst': ('anselig',),
'anseligste': ('anselig',),
'ansett': ('ansett',),
'ansette': ('ansett',),
'ansettere': ('ansett',),
'ansettest': ('ansett',),
'ansetteste': ('ansett',),
'ansatt': ('ansette',),
'ansatte': ('ansette',),
'ansettende': ('ansette',),
'anskaffa': ('anskaffe',),
'anskaffede': ('anskaffe',),
'anskaffende': ('anskaffe',),
'anskaffet': ('anskaffe',),
'anskaffete': ('anskaffe',),
'anskreven': ('anskreven',),
'anskrevet': ('anskreven',),
'anskrevne': ('anskreven',),
'anskrevnere': ('anskreven',),
'anskrevnest': ('anskreven',),
'anskrevneste': ('anskreven',),
'anskrevet': ('anskrevet',),
'anskrevne': ('anskrevet',),
'anskrevnere': ('anskrevet',),
'anskrevnest': ('anskrevet',),
'anskrevneste': ('anskrevet',),
'anskua': ('anskue',),
'anskuede': ('anskue',),
'anskuende': ('anskue',),
'anskuet': ('anskue',),
'anskuete': ('anskue',),
'anskuelig': ('anskuelig',),
'anskuelige': ('anskuelig',),
'anskueligere': ('anskuelig',),
'anskueligst': ('anskuelig',),
'anskueligste': ('anskuelig',),
'anskueliggjort': ('anskueliggjøre',),
'anskueliggjorte': ('anskueliggjøre',),
'anskueliggjørende': ('anskueliggjøre',),
'anslående': ('anslå',),
'anslått': ('anslå',),
'anslåtte': ('anslå',),
'anspennende': ('anspenne',),
'anspent': ('anspenne',),
'anspente': ('anspenne',),
'anspent': ('anspent',),
'anspente': ('anspent',),
'anspentere': ('anspent',),
'anspentest': ('anspent',),
'anspenteste': ('anspent',),
'anspora': ('anspore',),
'ansporede': ('anspore',),
'ansporende': ('anspore',),
'ansporet': ('anspore',),
'ansporete': ('anspore',),
'ansport': ('anspore',),
'ansporte': ('anspore',),
'ansporende': ('ansporende',),
'anstendig': ('anstendig',),
'anstendige': ('anstendig',),
'anstendigere': ('anstendig',),
'anstendigst': ('anstendig',),
'anstendigste': ('anstendig',),
'anstifta': ('anstifte',),
'anstiftede': ('anstifte',),
'anstiftende': ('anstifte',),
'anstiftet': ('anstifte',),
'anstiftete': ('anstifte',),
'anstillende': ('anstille',),
'anstilt': ('anstille',),
'anstilte': ('anstille',),
'anstrengende': ('anstrenge',),
'anstrengt': ('anstrenge',),
'anstrengte': ('anstrenge',),
'anstrengende': ('anstrengende',),
'anstrengt': ('anstrengt',),
'anstrengte': ('anstrengt',),
'anstrengtere': ('anstrengt',),
'anstrengtest': ('anstrengt',),
'anstrengteste': ('anstrengt',),
'anstrøken': ('anstrøken',),
'anstrøkent': ('anstrøken',),
'anstrøket': ('anstrøken',),
'anstrøkne': ('anstrøken',),
'anstrøknere': ('anstrøken',),
'anstrøknest': ('anstrøken',),
'anstrøkneste': ('anstrøken',),
'anstående': ('anstå',),
'anstått': ('anstå',),
'anståtte': ('anstå',),
'anstøtelig': ('anstøtelig',),
'anstøtelige': ('anstøtelig',),
'anstøteligere': ('anstøtelig',),
'anstøteligst': ('anstøtelig',),
'anstøteligste': ('anstøtelig',),
'anstøtende': ('anstøtende',),
'ansvarlig': ('ansvarlig',),
'ansvarlige': ('ansvarlig',),
'ansvarligere': ('ansvarlig',),
'ansvarligst': ('ansvarlig',),
'ansvarligste': ('ansvarlig',),
'ansvarsbevisst': ('ansvarsbevisst',),
'ansvarsbevisste': ('ansvarsbevisst',),
'ansvarsbevisstere': ('ansvarsbevisst',),
'ansvarsbevisstest': ('ansvarsbevisst',),
'ansvarsbevissteste': ('ansvarsbevisst',),
'ansvarsfull': ('ansvarsfull',),
'ansvarsfulle': ('ansvarsfull',),
'ansvarsfullere': ('ansvarsfull',),
'ansvarsfullest': ('ansvarsfull',),
'ansvarsfulleste': ('ansvarsfull',),
'ansvarsfullt': ('ansvarsfull',),
'ansvarshavende': ('ansvarshavende',),
'ansvarslaus': ('ansvarslaus',),
'ansvarslause': ('ansvarslaus',),
'ansvarslausere': ('ansvarslaus',),
'ansvarslausest': ('ansvarslaus',),
'ansvarslauseste': ('ansvarslaus',),
'ansvarslaust': ('ansvarslaus',),
'ansvarsløs': ('ansvarsløs',),
'ansvarsløse': ('ansvarsløs',),
'ansvarsløsere': ('ansvarsløs',),
'ansvarsløsest': ('ansvarsløs',),
'ansvarsløseste': ('ansvarsløs',),
'ansvarsløst': ('ansvarsløs',),
'ansvarstung': ('ansvarstung',),
'ansvarstunge': ('ansvarstung',),
'ansvarstungere': ('ansvarstung',),
'ansvarstungest': ('ansvarstung',),
'ansvarstungeste': ('ansvarstung',),
'ansvarstungt': ('ansvarstung',),
'ansvarstyngre': ('ansvarstung',),
'ansvarstyngst': ('ansvarstung',),
'ansvarstyngste': ('ansvarstung',),
'ansøkende': ('ansøke',),
'ansøkt': ('ansøke',),
'ansøkte': ('ansøke',),
'antakende': ('anta',),
'antatt': ('anta',),
'antatte': ('anta',),
'antagonistisk': ('antagonistisk',),
'antagonistiske': ('antagonistisk',),
'antagonistiskere': ('antagonistisk',),
'antagonistiskest': ('antagonistisk',),
'antagonistiskeste': ('antagonistisk',),
'antakelig': ('antakelig',),
'antakelige': ('antakelig',),
'antakeligere': ('antakelig',),
'antakeligst': ('antakelig',),
'antakeligste': ('antakelig',),
'antarktisk': ('antarktisk',),
'antarktiske': ('antarktisk',),
'antarktiskere': ('antarktisk',),
'antarktiskest': ('antarktisk',),
'antarktiskeste': ('antarktisk',),
'antasta': ('antaste',),
'antastede': ('antaste',),
'antastende': ('antaste',),
'antastet': ('antaste',),
'antastete': ('antaste',),
'antedaterende': ('antedatere',),
'antedatert': ('antedatere',),
'antedaterte': ('antedatere',),
'antediluvial': ('antediluvial',),
'antediluviale': ('antediluvial',),
'antediluvialere': ('antediluvial',),
'antediluvialest': ('antediluvial',),
'antediluvialeste': ('antediluvial',),
'antediluvialt': ('antediluvial',),
'antediluviansk': ('antediluviansk',),
'antediluvianske': ('antediluviansk',),
'antediluvianskere': ('antediluviansk',),
'antediluvianskest': ('antediluviansk',),
'antediluvianskeste': ('antediluviansk',),
'antegna': ('antegne',),
'antegnede': ('antegne',),
'antegnende': ('antegne',),
'antegnet': ('antegne',),
'antegnete': ('antegne',),
'antennende': ('antenne',),
'antent': ('antenne',),
'antente': ('antenne',),
'antennelig': ('antennelig',),
'antennelige': ('antennelig',),
'antenneligere': ('antennelig',),
'antenneligst': ('antennelig',),
'antenneligste': ('antennelig',),
'antesiperende': ('antesipere',),
'antesipert': ('antesipere',),
'antesiperte': ('antesipere',),
'antibiotisk': ('antibiotisk',),
'antibiotiske': ('antibiotisk',),
'antibiotiskere': ('antibiotisk',),
'antibiotiskest': ('antibiotisk',),
'antibiotiskeste': ('antibiotisk',),
'antidemokratisk': ('antidemokratisk',),
'antidemokratiske': ('antidemokratisk',),
'antidemokratiskere': ('antidemokratisk',),
'antidemokratiskest': ('antidemokratisk',),
'antidemokratiskeste': ('antidemokratisk',),
'antigen': ('antigen',),
'antigene': ('antigen',),
'antigenere': ('antigen',),
'antigenest': ('antigen',),
'antigeneste': ('antigen',),
'antigent': ('antigen',),
'antiguansk': ('antiguansk',),
'antiguanske': ('antiguansk',),
'antiguanskere': ('antiguansk',),
'antiguanskest': ('antiguansk',),
'antiguanskeste': ('antiguansk',),
'antikiserende': ('antikisere',),
'antikisert': ('antikisere',),
'antikiserte': ('antikisere',),
'antikk': ('antikk',),
'antikke': ('antikk',),
'antikkere': ('antikk',),
'antikkest': ('antikk',),
'antikkeste': ('antikk',),
'antikt': ('antikk',),
'antiklerikal': ('antiklerikal',),
'antiklerikale': ('antiklerikal',),
'antiklerikalere': ('antiklerikal',),
'antiklerikalest': ('antiklerikal',),
'antiklerikaleste': ('antiklerikal',),
'antiklerikalt': ('antiklerikal',),
'antikommunistisk': ('antikommunistisk',),
'antikommunistiske': ('antikommunistisk',),
'antikommunistiskere': ('antikommunistisk',),
'antikommunistiskest': ('antikommunistisk',),
'antikommunistiskeste': ('antikommunistisk',),
'antikrympbehandla': ('antikrympbehandle',),
'antikrympbehandlede': ('antikrympbehandle',),
'antikrympbehandlende': ('antikrympbehandle',),
'antikrympbehandlet': ('antikrympbehandle',),
'antikrympbehandlete': ('antikrympbehandle',),
'antikrøllbehandla': ('antikrøllbehandle',),
'antikrøllbehandlede': ('antikrøllbehandle',),
'antikrøllbehandlende': ('antikrøllbehandle',),
'antikrøllbehandlet': ('antikrøllbehandle',),
'antikrøllbehandlete': ('antikrøllbehandle',),
'antikvarisk': ('antikvarisk',),
'antikvariske': ('antikvarisk',),
'antikvariskere': ('antikvarisk',),
'antikvariskest': ('antikvarisk',),
'antikvariskeste': ('antikvarisk',),
'antikvert': ('antikvert',),
'antikverte': ('antikvert',),
'antikvertere': ('antikvert',),
'antikvertest': ('antikvert',),
'antikverteste': ('antikvert',),
'antimilitaristisk': ('antimilitaristisk',),
'antimilitaristiske': ('antimilitaristisk',),
'antimilitaristiskere': ('antimilitaristisk',),
'antimilitaristiskest': ('antimilitaristisk',),
'antimilitaristiskeste': ('antimilitaristisk',),
'antipatisk': ('antipatisk',),
'antipatiske': ('antipatisk',),
'antipatiskere': ('antipatisk',),
'antipatiskest': ('antipatisk',),
'antipatiskeste': ('antipatisk',),
'antipodisk': ('antipodisk',),
'antipodiske': ('antipodisk',),
'antipodiskere': ('antipodisk',),
'antipodiskest': ('antipodisk',),
'antipodiskeste': ('antipodisk',),
'antirefleksbehandla': ('antirefleksbehandle',),
'antirefleksbehandlede': ('antirefleksbehandle',),
'antirefleksbehandlende': ('antirefleksbehandle',),
'antirefleksbehandlet': ('antirefleksbehandle',),
'antirefleksbehandlete': ('antirefleksbehandle',),
'antirustbehandla': ('antirustbehandle',),
'antirustbehandlede': ('antirustbehandle',),
'antirustbehandlende': ('antirustbehandle',),
'antirustbehandlet': ('antirustbehandle',),
'antirustbehandlete': ('antirustbehandle',),
'antisemittisk': ('antisemittisk',),
'antisemittiske': ('antisemittisk',),
'antisemittiskere': ('antisemittisk',),
'antisemittiskest': ('antisemittisk',),
'antisemittiskeste': ('antisemittisk',),
'antiseptisk': ('antiseptisk',),
'antiseptiske': ('antiseptisk',),
'antiseptiskere': ('antiseptisk',),
'antiseptiskest': ('antiseptisk',),
'antiseptiskeste': ('antiseptisk',),
'antistatbehandla': ('antistatbehandle',),
'antistatbehandlede': ('antistatbehandle',),
'antistatbehandlende': ('antistatbehandle',),
'antistatbehandlet': ('antistatbehandle',),
'antistatbehandlete': ('antistatbehandle',),
'antistatisk': ('antistatisk',),
'antistatiske': ('antistatisk',),
'antistatiskere': ('antistatisk',),
'antistatiskest': ('antistatisk',),
'antistatiskeste': ('antistatisk',),
'antitetisk': ('antitetisk',),
'antitetiske': ('antitetisk',),
'antitetiskere': ('antitetisk',),
'antitetiskest': ('antitetisk',),
'antitetiskeste': ('antitetisk',),
'antitoksisk': ('antitoksisk',),
'antitoksiske': ('antitoksisk',),
'antitoksiskere': ('antitoksisk',),
'antitoksiskest': ('antitoksisk',),
'antitoksiskeste': ('antitoksisk',),
'antologisk': ('antologisk',),
'antologiske': ('antologisk',),
'antologiskere': ('antologisk',),
'antologiskest': ('antologisk',),
'antologiskeste': ('antologisk',),
'antonym': ('antonym',),
'antonyme': ('antonym',),
'antonymere': ('antonym',),
'antonymest': ('antonym',),
'antonymeste': ('antonym',),
'antonymt': ('antonym',),
'antropofobisk': ('antropofobisk',),
'antropofobiske': ('antropofobisk',),
'antropofobiskere': ('antropofobisk',),
'antropofobiskest': ('antropofobisk',),
'antropofobiskeste': ('antropofobisk',),
'antropologisk': ('antropologisk',),
'antropologiske': ('antropologisk',),
'antropologiskere': ('antropologisk',),
'antropologiskest': ('antropologisk',),
'antropologiskeste': ('antropologisk',),
'antropomorf': ('antropomorf',),
'antropomorfe': ('antropomorf',),
'antropomorfere': ('antropomorf',),
'antropomorfest': ('antropomorf',),
'antropomorfeste': ('antropomorf',),
'antropomorft': ('antropomorf',),
'antroposofisk': ('antroposofisk',),
'antroposofiske': ('antroposofisk',),
'antroposofiskere': ('antroposofisk',),
'antroposofiskest': ('antroposofisk',),
'antroposofiskeste': ('antroposofisk',),
'antrukket': ('antrukket',),
'antrukne': ('antrukket',),
'antruknere': ('antrukket',),
'antruknest': ('antrukket',),
'antrukneste': ('antrukket',),
'antyda': ('antyde',),
'antydede': ('antyde',),
'antydende': ('antyde',),
'antydet': ('antyde',),
'antydete': ('antyde',),
'anvendende': ('anvende',),
'anvendt': ('anvende',),
'anvendte': ('anvende',),
'anvendelig': ('anvendelig',),
'anvendelige': ('anvendelig',),
'anvendeligere': ('anvendelig',),
'anvendeligst': ('anvendelig',),
'anvendeligste': ('anvendelig',),
'anvendt': ('anvendt',),
'anvendte': ('anvendt',),
'anvendtere': ('anvendt',),
'anvendtest': ('anvendt',),
'anvendteste': ('anvendt',),
'anvisende': ('anvise',),
'anvist': ('anvise',),
'anviste': ('anvise',),
'apalgrå': ('apalgrå',),
'apalgråe': ('apalgrå',),
'apalgråere': ('apalgrå',),
'apalgråest': ('apalgrå',),
'apalgråeste': ('apalgrå',),
'apalgrått': ('apalgrå',),
'aparte': ('aparte',),
'apatisk': ('apatisk',),
'apatiske': ('apatisk',),
'apatiskere': ('apatisk',),
'apatiskest': ('apatisk',),
'apatiskeste': ('apatisk',),
'apa': ('ape',),
'apede': ('ape',),
'apende': ('ape',),
'apet': ('ape',),
'apete': ('ape',),
'apt': ('ape',),
'apte': ('ape',),
'apikal': ('apikal',),
'apikale': ('apikal',),
'apikalere': ('apikal',),
'apikalest': ('apikal',),
'apikaleste': ('apikal',),
'apikalt': ('apikal',),
'apokalyptisk': ('apokalyptisk',),
'apokalyptiske': ('apokalyptisk',),
'apokalyptiskere': ('apokalyptisk',),
'apokalyptiskest': ('apokalyptisk',),
'apokalyptiskeste': ('apokalyptisk',),
'apokoperende': ('apokopere',),
'apokopert': ('apokopere',),
'apokoperte': ('apokopere',),
'apokryf': ('apokryf',),
'apokryfe': ('apokryf',),
'apokryfere': ('apokryf',),
'apokryfest': ('apokryf',),
'apokryfeste': ('apokryf',),
'apokryft': ('apokryf',),
'apokryfisk': ('apokryfisk',),
'apokryfiske': ('apokryfisk',),
'apokryfiskere': ('apokryfisk',),
'apokryfiskest': ('apokryfisk',),
'apokryfiskeste': ('apokryfisk',),
'apolitisk': ('apolitisk',),
'apolitiske': ('apolitisk',),
'apolitiskere': ('apolitisk',),
'apolitiskest': ('apolitisk',),
'apolitiskeste': ('apolitisk',),
'apollinsk': ('apollinsk',),
'apollinske': ('apollinsk',),
'apollinskere': ('apollinsk',),
'apollinskest': ('apollinsk',),
'apollinskeste': ('apollinsk',),
'apologetisk': ('apologetisk',),
'apologetiske': ('apologetisk',),
'apologetiskere': ('apologetisk',),
'apologetiskest': ('apologetisk',),
'apologetiskeste': ('apologetisk',),
'apoplektisk': ('apoplektisk',),
'apoplektiske': ('apoplektisk',),
'apoplektiskere': ('apoplektisk',),
'apoplektiskest': ('apoplektisk',),
'apoplektiskeste': ('apoplektisk',),
'aposteriorisk': ('aposteriorisk',),
'aposterioriske': ('aposteriorisk',),
'aposterioriskere': ('aposteriorisk',),
'aposterioriskest': ('aposteriorisk',),
'aposterioriskeste': ('aposteriorisk',),
'apostolisk': ('apostolisk',),
'apostoliske': ('apostolisk',),
'apostoliskere': ('apostolisk',),
'apostoliskest': ('apostolisk',),
'apostoliskeste': ('apostolisk',),
'apostroferende': ('apostrofere',),
'apostrofert': ('apostrofere',),
'apostroferte': ('apostrofere',),
'appellabel': ('appellabel',),
'appellabelt': ('appellabel',),
'appellable': ('appellabel',),
'appellablere': ('appellabel',),
'appellablest': ('appellabel',),
'appellableste': ('appellabel',),
'appellativisk': ('appellativisk',),
'appellativiske': ('appellativisk',),
'appellativiskere': ('appellativisk',),
'appellativiskest': ('appellativisk',),
'appellativiskeste': ('appellativisk',),
'appellerende': ('appellere',),
'appellert': ('appellere',),
'appellerte': ('appellere',),
'appetittlig': ('appetittlig',),
'appetittlige': ('appetittlig',),
'appetittligere': ('appetittlig',),
'appetittligst': ('appetittlig',),
'appetittligste': ('appetittlig',),
'appetittvekkende': ('appetittvekkende',),
'applauderende': ('applaudere',),
'applaudert': ('applaudere',),
'applauderte': ('applaudere',),
'applikerende': ('applikere',),
'applikert': ('applikere',),
'applikerte': ('applikere',),
'appliserende': ('applisere',),
'applisert': ('applisere',),
'appliserte': ('applisere',),
'apporterende': ('apportere',),
'apportert': ('apportere',),
'apporterte': ('apportere',),
'apposisjonell': ('apposisjonell',),
'apposisjonelle': ('apposisjonell',),
'apposisjonellere': ('apposisjonell',),
'apposisjonellest': ('apposisjonell',),
'apposisjonelleste': ('apposisjonell',),
'apposisjonelt': ('apposisjonell',),
'appreterende': ('appretere',),
'appretert': ('appretere',),
'appreterte': ('appretere',),
'approberende': ('approbere',),
'approbert': ('approbere',),
'approberte': ('approbere',),
'approksimativ': ('approksimativ',),
'approksimative': ('approksimativ',),
'approksimativere': ('approksimativ',),
'approksimativest': ('approksimativ',),
'approksimativeste': ('approksimativ',),
'approksimativt': ('approksimativ',),
'approprierende': ('appropriere',),
'appropriert': ('appropriere',),
'approprierte': ('appropriere',),
'aprikosfarga': ('aprikosfarga',),
'aprikosfargede': ('aprikosfarget',),
'aprikosfarget': ('aprikosfarget',),
'aprikosfargete': ('aprikosfarget',),
'aprikosfargetere': ('aprikosfarget',),
'aprikosfargetest': ('aprikosfarget',),
'aprikosfargeteste': ('aprikosfarget',),
'apriorisk': ('apriorisk',),
'aprioriske': ('apriorisk',),
'aprioriskere': ('apriorisk',),
'aprioriskest': ('apriorisk',),
'aprioriskeste': ('apriorisk',),
'apsidal': ('apsidal',),
'apsidale': ('apsidal',),
'apsidalere': ('apsidal',),
'apsidalest': ('apsidal',),
'apsidaleste': ('apsidal',),
'apsidalt': ('apsidal',),
'apterende': ('aptere',),
'aptert': ('aptere',),
'apterte': ('aptere',),
'arabisk': ('arabisk',),
'arabiske': ('arabisk',),
'arabiskere': ('arabisk',),
'arabiskest': ('arabisk',),
'arabiskeste': ('arabisk',),
'arameisk': ('arameisk',),
'arameiske': ('arameisk',),
'arameiskere': ('arameisk',),
'arameiskest': ('arameisk',),
'arameiskeste': ('arameisk',),
'arbeida': ('arbeide',),
'arbeidd': ('arbeide',),
'arbeidde': ('arbeide',),
'arbeidede': ('arbeide',),
'arbeidende': ('arbeide',),
'arbeidet': ('arbeide',),
'arbeidete': ('arbeide',),
'arbeidsbesparende': ('arbeidsbesparende',),
'arbeidsdyktig': ('arbeidsdyktig',),
'arbeidsdyktige': ('arbeidsdyktig',),
'arbeidsdyktigere': ('arbeidsdyktig',),
'arbeidsdyktigst': ('arbeidsdyktig',),
'arbeidsdyktigste': ('arbeidsdyktig',),
'arbeidsfør': ('arbeidsfør',),
'arbeidsføre': ('arbeidsfør',),
'arbeidsførere': ('arbeidsfør',),
'arbeidsførest': ('arbeidsfør',),
'arbeidsføreste': ('arbeidsfør',),
'arbeidsført': ('arbeidsfør',),
'arbeidsglad': ('arbeidsglad',),
'arbeidsglade': ('arbeidsglad',),
'arbeidsgladere': ('arbeidsglad',),
'arbeidsgladest': ('arbeidsglad',),
'arbeidsgladeste': ('arbeidsglad',),
'arbeidsintensiv': ('arbeidsintensiv',),
'arbeidsintensive': ('arbeidsintensiv',),
'arbeidsintensivere': ('arbeidsintensiv',),
'arbeidsintensivest': ('arbeidsintensiv',),
'arbeidsintensiveste': ('arbeidsintensiv',),
'arbeidsintensivt': ('arbeidsintensiv',),
'arbeidskrevende': ('arbeidskrevende',),
'arbeidslaus': ('arbeidslaus',),
'arbeidslause': ('arbeidslaus',),
'arbeidslausere': ('arbeidslaus',),
'arbeidslausest': ('arbeidslaus',),
'arbeidslauseste': ('arbeidslaus',),
'arbeidslaust': ('arbeidslaus',),
'arbeidsledig': ('arbeidsledig',),
'arbeidsledige': ('arbeidsledig',),
'arbeidsledigere': ('arbeidsledig',),
'arbeidsledigst': ('arbeidsledig',),
'arbeidsledigste': ('arbeidsledig',),
'arbeidsløs': ('arbeidsløs',),
'arbeidsløse': ('arbeidsløs',),
'arbeidsløsere': ('arbeidsløs',),
'arbeidsløsest': ('arbeidsløs',),
'arbeidsløseste': ('arbeidsløs',),
'arbeidsløst': ('arbeidsløs',),
'arbeidsom': ('arbeidsom',),
'arbeidsomme': ('arbeidsom',),
'arbeidsommere': ('arbeidsom',),
'arbeidsomst': ('arbeidsom',),
'arbeidsomste': ('arbeidsom',),
'arbeidsomt': ('arbeidsom',),
'arbeidssparende': ('arbeidssparende',),
'arbeidsudyktig': ('arbeidsudyktig',),
'arbeidsudyktige': ('arbeidsudyktig',),
'arbeidsudyktigere': ('arbeidsudyktig',),
'arbeidsudyktigst': ('arbeidsudyktig',),
'arbeidsudyktigste': ('arbeidsudyktig',),
'arbeidsufør': ('arbeidsufør',),
'arbeidsuføre': ('arbeidsufør',),
'arbeidsuførere': ('arbeidsufør',),
'arbeidsuførest': ('arbeidsufør',),
'arbeidsuføreste': ('arbeidsufør',),
'arbeidsuført': ('arbeidsufør',),
'arbitrær': ('arbitrær',),
'arbitrære': ('arbitrær',),
'arbitrærere': ('arbitrær',),
'arbitrærest': ('arbitrær',),
'arbitræreste': ('arbitrær',),
'arbitrært': ('arbitrær',),
'arda': ('arde',),
'ardede': ('arde',),
'ardende': ('arde',),
'ardet': ('arde',),
'ardete': ('arde',),
'arg': ('arg',),
'arge': ('arg',),
'argere': ('arg',),
'argest': ('arg',),
'argeste': ('arg',),
'argt': ('arg',),
'arga': ('arge',),
'argede': ('arge',),
'argende': ('arge',),
'arget': ('arge',),
'argete': ('arge',),
'argentinsk': ('argentinsk',),
'argentinske': ('argentinsk',),
'argentinskere': ('argentinsk',),
'argentinskest': ('argentinsk',),
'argentinskeste': ('argentinsk',),
'argumenterende': ('argumentere',),
'argumentert': ('argumentere',),
'argumenterte': ('argumentere',),
'arid': ('arid',),
'aride': ('arid',),
'aridere': ('arid',),
'aridest': ('arid',),
'arideste': ('arid',),
'arisk': ('arisk',),
'ariske': ('arisk',),
'ariskere': ('arisk',),
'ariskest': ('arisk',),
'ariskeste': ('arisk',),
'aristokratisk': ('aristokratisk',),
'aristokratiske': ('aristokratisk',),
'aristokratiskere': ('aristokratisk',),
'aristokratiskest': ('aristokratisk',),
'aristokratiskeste': ('aristokratisk',),
'aristotelisk': ('aristotelisk',),
'aristoteliske': ('aristotelisk',),
'aristoteliskere': ('aristotelisk',),
'aristoteliskest': ('aristotelisk',),
'aristoteliskeste': ('aristotelisk',),
'aritmetisk': ('aritmetisk',),
'aritmetiske': ('aritmetisk',),
'aritmetiskere': ('aritmetisk',),
'aritmetiskest': ('aritmetisk',),
'aritmetiskeste': ('aritmetisk',),
'arkaiserende': ('arkaisere',),
'arkaisert': ('arkaisere',),
'arkaiserte': ('arkaisere',),
'arkaisk': ('arkaisk',),
'arkaiske': ('arkaisk',),
'arkaiskere': ('arkaisk',),
'arkaiskest': ('arkaisk',),
'arkaiskeste': ('arkaisk',),
'arkaistisk': ('arkaistisk',),
'arkaistiske': ('arkaistisk',),
'arkaistiskere': ('arkaistisk',),
'arkaistiskest': ('arkaistisk',),
'arkaistiskeste': ('arkaistisk',),
'arkebuserende': ('arkebusere',),
'arkebusert': ('arkebusere',),
'arkebuserte': ('arkebusere',),
'arkeologisk': ('arkeologisk',),
'arkeologiske': ('arkeologisk',),
'arkeologiskere': ('arkeologisk',),
'arkeologiskest': ('arkeologisk',),
'arkeologiskeste': ('arkeologisk',),
'arketypisk': ('arketypisk',),
'arketypiske': ('arketypisk',),
'arketypiskere': ('arketypisk',),
'arketypiskest': ('arketypisk',),
'arketypiskeste': ('arketypisk',),
'arkitektonisk': ('arkitektonisk',),
'arkitektoniske': ('arkitektonisk',),
'arkitektoniskere': ('arkitektonisk',),
'arkitektoniskest': ('arkitektonisk',),
'arkitektoniskeste': ('arkitektonisk',),
'arkitekttegna': ('arkitekttegna',),
'arkitekttegnede': ('arkitekttegnet',),
'arkitekttegnet': ('arkitekttegnet',),
'arkitekttegnete': ('arkitekttegnet',),
'arkitekttegnetere': ('arkitekttegnet',),
'arkitekttegnetest': ('arkitekttegnet',),
'arkitekttegneteste': ('arkitekttegnet',),
'arkiverende': ('arkivere',),
'arkivert': ('arkivere',),
'arkiverte': ('arkivere',),
'arktisk': ('arktisk',),
'arktiske': ('arktisk',),
'arktiskere': ('arktisk',),
'arktiskest': ('arktisk',),
'arktiskeste': ('arktisk',),
'arm': ('arm',),
'arme': ('arm',),
'armere': ('arm',),
'armest': ('arm',),
'armeste': ('arm',),
'armt': ('arm',),
'arma': ('arme',),
'armede': ('arme',),
'armende': ('arme',),
'armet': ('arme',),
'armete': ('arme',),
'armensk': ('armensk',),
'armenske': ('armensk',),
'armenskere': ('armensk',),
'armenskest': ('armensk',),
'armenskeste': ('armensk',),
'armerende': ('armere',),
'armert': ('armere',),
'armerte': ('armere',),
'armodslig': ('armodslig',),
'armodslige': ('armodslig',),
'armodsligere': ('armodslig',),
'armodsligst': ('armodslig',),
'armodsligste': ('armodslig',),
'aromatiserende': ('aromatisere',),
'aromatisert': ('aromatisere',),
'aromatiserte': ('aromatisere',),
'aromatisk': ('aromatisk',),
'aromatiske': ('aromatisk',),
'aromatiskere': ('aromatisk',),
'aromatiskest': ('aromatisk',),
'aromatiskeste': ('aromatisk',),
'arrangerende': ('arrangere',),
'arrangert': ('arrangere',),
'arrangerte': ('arrangere',),
'arresterende': ('arrestere',),
'arrestert': ('arrestere',),
'arresterte': ('arrestere',),
'arret': ('arret',),
'arrete': ('arret',),
'arretere': ('arret',),
'arretest': ('arret',),
'arreteste': ('arret',),
'arrete': ('arrete',),
'arreterende': ('arretere',),
'arretert': ('arretere',),
'arreterte': ('arretere',),
'arrig': ('arrig',),
'arrige': ('arrig',),
'arrigere': ('arrig',),
'arrigst': ('arrig',),
'arrigste': ('arrig',),
'arriverende': ('arrivere',),
'arrivert': ('arrivere',),
'arriverte': ('arrivere',),
'arrogant': ('arrogant',),
'arrogante': ('arrogant',),
'arrogantere': ('arrogant',),
'arrogantest': ('arrogant',),
'arroganteste': ('arrogant',),
'arronderende': ('arrondere',),
'arrondert': ('arrondere',),
'arronderte': ('arrondere',),
'arsenikkholdig': ('arsenikkholdig',),
'arsenikkholdige': ('arsenikkholdig',),
'arsenikkholdigere': ('arsenikkholdig',),
'arsenikkholdigst': ('arsenikkholdig',),
'arsenikkholdigste': ('arsenikkholdig',),
'arta': ('arte',),
'artede': ('arte',),
'artende': ('arte',),
'artet': ('arte',),
'artete': ('arte',),
'arteriell': ('arteriell',),
'arterielle': ('arteriell',),
'arteriellere': ('arteriell',),
'arteriellest': ('arteriell',),
'arterielleste': ('arteriell',),
'arterielt': ('arteriell',),
'artesisk': ('artesisk',),
'artesiske': ('artesisk',),
'artesiskere': ('artesisk',),
'artesiskest': ('artesisk',),
'artesiskeste': ('artesisk',),
'artifisiell': ('artifisiell',),
'artifisielle': ('artifisiell',),
'artifisiellere': ('artifisiell',),
'artifisiellest': ('artifisiell',),
'artifisielleste': ('artifisiell',),
'artifisielt': ('artifisiell',),
'artig': ('artig',),
'artige': ('artig',),
'artigere': ('artig',),
'artigst': ('artig',),
'artigste': ('artig',),
'artikulatorisk': ('artikulatorisk',),
'artikulatoriske': ('artikulatorisk',),
'artikulatoriskere': ('artikulatorisk',),
'artikulatoriskest': ('artikulatorisk',),
'artikulatoriskeste': ('artikulatorisk',),
'artikulerende': ('artikulere',),
'artikulert': ('artikulere',),
'artikulerte': ('artikulere',),
'artistisk': ('artistisk',),
'artistiske': ('artistisk',),
'artistiskere': ('artistisk',),
'artistiskest': ('artistisk',),
'artistiskeste': ('artistisk',),
'artsbestemmende': ('artsbestemme',),
'artsbestemt': ('artsbestemme',),
'artsbestemte': ('artsbestemme',),
'artsfattig': ('artsfattig',),
'artsfattige': ('artsfattig',),
'artsfattigere': ('artsfattig',),
'artsfattigst': ('artsfattig',),
'artsfattigste': ('artsfattig',),
'artsforskjellig': ('artsforskjellig',),
'artsforskjellige': ('artsforskjellig',),
'artsforskjelligere': ('artsforskjellig',),
'artsforskjelligst': ('artsforskjellig',),
'artsforskjelligste': ('artsforskjellig',),
'artsrein': ('artsrein',),
'artsreine': ('artsrein',),
'artsreinere': ('artsrein',),
'artsreinest': ('artsrein',),
'artsreineste': ('artsrein',),
'artsreint': ('artsrein',),
'artsren': ('artsren',),
'artsrene': ('artsren',),
'artsrenere': ('artsren',),
'artsrenest': ('artsren',),
'artsreneste': ('artsren',),
'artsrent': ('artsren',),
'artsrik': ('artsrik',),
'artsrike': ('artsrik',),
'artsrikere': ('artsrik',),
'artsrikest': ('artsrik',),
'artsrikeste': ('artsrik',),
'artsrikt': ('artsrik',),
'artstypisk': ('artstypisk',),
'artstypiske': ('artstypisk',),
'artstypiskere': ('artstypisk',),
'artstypiskest': ('artstypisk',),
'artstypiskeste': ('artstypisk',),
'arva': ('arve',),
'arvede': ('arve',),
'arvende': ('arve',),
'arvet': ('arve',),
'arvete': ('arve',),
'arveberettiga': ('arveberettiga',),
'arveberettigede': ('arveberettiget',),
'arveberettiget': ('arveberettiget',),
'arveberettigete': ('arveberettiget',),
'arveberettigetere': ('arveberettiget',),
'arveberettigetest': ('arveberettiget',),
'arveberettigeteste': ('arveberettiget',),
'arvelaus': ('arvelaus',),
'arvelause': ('arvelaus',),
'arvelausere': ('arvelaus',),
'arvelausest': ('arvelaus',),
'arvelauseste': ('arvelaus',),
'arvelaust': ('arvelaus',),
'arvelig': ('arvelig',),
'arvelige': ('arvelig',),
'arveligere': ('arvelig',),
'arveligst': ('arvelig',),
'arveligste': ('arvelig',),
'arveløs': ('arveløs',),
'arveløse': ('arveløs',),
'arveløsere': ('arveløs',),
'arveløsest': ('arveløs',),
'arveløseste': ('arveløs',),
'arveløst': ('arveløs',),
'asa': ('ase',),
'asende': ('ase',),
'ast': ('ase',),
'aste': ('ase',),
'aseksuell': ('aseksuell',),
'aseksuelle': ('aseksuell',),
'aseksuellere': ('aseksuell',),
'aseksuellest': ('aseksuell',),
'aseksuelleste': ('aseksuell',),
'aseksuelt': ('aseksuell',),
'aseptisk': ('aseptisk',),
'aseptiske': ('aseptisk',),
'aseptiskere': ('aseptisk',),
'aseptiskest': ('aseptisk',),
'aseptiskeste': ('aseptisk',),
'aserbajdsjansk': ('aserbajdsjansk',),
'aserbajdsjanske': ('aserbajdsjansk',),
'aserbajdsjanskere': ('aserbajdsjansk',),
'aserbajdsjanskest': ('aserbajdsjansk',),
'aserbajdsjanskeste': ('aserbajdsjansk',),
'aset': ('aset',),
'asete': ('aset',),
'asetere': ('aset',),
'asetest': ('aset',),
'aseteste': ('aset',),
'asete': ('asete',),
'asfalterende': ('asfaltere',),
'asfaltert': ('asfaltere',),
'asfalterte': ('asfaltere',),
'asiatisk': ('asiatisk',),
'asiatiske': ('asiatisk',),
'asiatiskere': ('asiatisk',),
'asiatiskest': ('asiatisk',),
'asiatiskeste': ('asiatisk',),
'askeblond': ('askeblond',),
'askeblonde': ('askeblond',),
'askeblondere': ('askeblond',),
'askeblondest': ('askeblond',),
'askeblondeste': ('askeblond',),
'askeblondt': ('askeblond',),
'askeblond': ('askeblond',),
'askeblonde': ('askeblond',),
'askeblondere': ('askeblond',),
'askeblondest': ('askeblond',),
'askeblondeste': ('askeblond',),
'askeblondt': ('askeblond',),
'askegrå': ('askegrå',),
'askegråe': ('askegrå',),
'askegråere': ('askegrå',),
'askegråest': ('askegrå',),
'askegråeste': ('askegrå',),
'askegrått': ('askegrå',),
'askegrå': ('askegrå',),
'askegråe': ('askegrå',),
'askegråere': ('askegrå',),
'askegråest': ('askegrå',),
'askegråeste': ('askegrå',),
'askegrått': ('askegrå',),
'askenasisk': ('askenasisk',),
'askenasiske': ('askenasisk',),
'askenasiskere': ('askenasisk',),
'askenasiskest': ('askenasisk',),
'askenasiskeste': ('askenasisk',),
'asketisk': ('asketisk',),
'asketiske': ('asketisk',),
'asketiskere': ('asketisk',),
'asketiskest': ('asketisk',),
'asketiskeste': ('asketisk',),
'asomatisk': ('asomatisk',),
'asomatiske': ('asomatisk',),
'asomatiskere': ('asomatisk',),
'asomatiskest': ('asomatisk',),
'asomatiskeste': ('asomatisk',),
'asosial': ('asosial',),
'asosiale': ('asosial',),
'asosialere': ('asosial',),
'asosialest': ('asosial',),
'asosialeste': ('asosial',),
'asosialt': ('asosial',),
'aspiratorisk': ('aspiratorisk',),
'aspiratoriske': ('aspiratorisk',),
'aspiratoriskere': ('aspiratorisk',),
'aspiratoriskest': ('aspiratorisk',),
'aspiratoriskeste': ('aspiratorisk',),
'aspirerende': ('aspirere',),
'aspirert': ('aspirere',),
'aspirerte': ('aspirere',),
'assimilatorisk': ('assimilatorisk',),
'assimilatoriske': ('assimilatorisk',),
'assimilatoriskere': ('assimilatorisk',),
'assimilatoriskest': ('assimilatorisk',),
'assimilatoriskeste': ('assimilatorisk',),
'assimilerende': ('assimilere',),
'assimilert': ('assimilere',),
'assimilerte': ('assimilere',),
'assisterende': ('assistere',),
'assistert': ('assistere',),
'assisterte': ('assistere',),
'assorterende': ('assortere',),
'assortert': ('assortere',),
'assorterte': ('assortere',),
'assosiativ': ('assosiativ',),
'assosiative': ('assosiativ',),
'assosiativere': ('assosiativ',),
'assosiativest': ('assosiativ',),
'assosiativeste': ('assosiativ',),
'assosiativt': ('assosiativ',),
'assosierende': ('assosiere',),
'assosiert': ('assosiere',),
'assosierte': ('assosiere',),
'assurerende': ('assurere',),
'assurert': ('assurere',),
'assurerte': ('assurere',),
'assyrisk': ('assyrisk',),
'assyriske': ('assyrisk',),
'assyriskere': ('assyrisk',),
'assyriskest': ('assyrisk',),
'assyriskeste': ('assyrisk',),
'astenisk': ('astenisk',),
'asteniske': ('astenisk',),
'asteniskere': ('astenisk',),
'asteniskest': ('astenisk',),
'asteniskeste': ('astenisk',),
'astigmatisk': ('astigmatisk',),
'astigmatiske': ('astigmatisk',),
'astigmatiskere': ('astigmatisk',),
'astigmatiskest': ('astigmatisk',),
'astigmatiskeste': ('astigmatisk',),
'astmasjuk': ('astmasjuk',),
'astmasjuke': ('astmasjuk',),
'astmasjukere': ('astmasjuk',),
'astmasjukest': ('astmasjuk',),
'astmasjukeste': ('astmasjuk',),
'astmasjukt': ('astmasjuk',),
'astmasyk': ('astmasyk',),
'astmasyke': ('astmasyk',),
'astmasykere': ('astmasyk',),
'astmasykest': ('astmasyk',),
'astmasykeste': ('astmasyk',),
'astmasykt': ('astmasyk',),
'astmatisk': ('astmatisk',),
'astmatiske': ('astmatisk',),
'astmatiskere': ('astmatisk',),
'astmatiskest': ('astmatisk',),
'astmatiskeste': ('astmatisk',),
'astral': ('astral',),
'astrale': ('astral',),
'astralere': ('astral',),
'astralest': ('astral',),
'astraleste': ('astral',),
'astralt': ('astral',),
'astringerende': ('astringere',),
'astringert': ('astringere',),
'astringerte': ('astringere',),
'astrofysisk': ('astrofysisk',),
'astrofysiske': ('astrofysisk',),
'astrofysiskere': ('astrofysisk',),
'astrofysiskest': ('astrofysisk',),
'astrofysiskeste': ('astrofysisk',),
'astrologisk': ('astrologisk',),
'astrologiske': ('astrologisk',),
'astrologiskere': ('astrologisk',),
'astrologiskest': ('astrologisk',),
'astrologiskeste': ('astrologisk',),
'astronomisk': ('astronomisk',),
'astronomiske': ('astronomisk',),
'astronomiskere': ('astronomisk',),
'astronomiskest': ('astronomisk',),
'astronomiskeste': ('astronomisk',),
'asurblå': ('asurblå',),
'asurblåe': ('asurblå',),
'asurblåere': ('asurblå',),
'asurblåest': ('asurblå',),
'asurblåeste': ('asurblå',),
'asurblått': ('asurblå',),
'asymmetrisk': ('asymmetrisk',),
'asymmetriske': ('asymmetrisk',),
'asymmetriskere': ('asymmetrisk',),
'asymmetriskest': ('asymmetrisk',),
'asymmetriskeste': ('asymmetrisk',),
'asymptotisk': ('asymptotisk',),
'asymptotiske': ('asymptotisk',),
'asymptotiskere': ('asymptotisk',),
'asymptotiskest': ('asymptotisk',),
'asymptotiskeste': ('asymptotisk',),
'asyndetisk': ('asyndetisk',),
'asyndetiske': ('asyndetisk',),
'asyndetiskere': ('asyndetisk',),
'asyndetiskest': ('asyndetisk',),
'asyndetiskeste': ('asyndetisk',),
'asynkron': ('asynkron',),
'asynkrone': ('asynkron',),
'asynkronere': ('asynkron',),
'asynkronest': ('asynkron',),
'asynkroneste': ('asynkron',),
'asynkront': ('asynkron',),
'atal': ('atal',),
'atale': ('atal',),
'atalere': ('atal',),
'atalest': ('atal',),
'ataleste': ('atal',),
'atalt': ('atal',),
'atavistisk': ('atavistisk',),
'atavistiske': ('atavistisk',),
'atavistiskere': ('atavistisk',),
'atavistiskest': ('atavistisk',),
'atavistiskeste': ('atavistisk',),
'ateistisk': ('ateistisk',),
'ateistiske': ('ateistisk',),
'ateistiskere': ('ateistisk',),
'ateistiskest': ('ateistisk',),
'ateistiskeste': ('ateistisk',),
'atensk': ('atensk',),
'atenske': ('atensk',),
'atenskere': ('atensk',),
'atenskest': ('atensk',),
'atenskeste': ('atensk',),
'athensk': ('athensk',),
'athenske': ('athensk',),
'athenskere': ('athensk',),
'athenskest': ('athensk',),
'athenskeste': ('athensk',),
'atlantisk': ('atlantisk',),
'atlantiske': ('atlantisk',),
'atlantiskere': ('atlantisk',),
'atlantiskest': ('atlantisk',),
'atlantiskeste': ('atlantisk',),
'atlantocanadisk': ('atlantocanadisk',),
'atlantocanadiske': ('atlantocanadisk',),
'atlantocanadiskere': ('atlantocanadisk',),
'atlantocanadiskest': ('atlantocanadisk',),
'atlantocanadiskeste': ('atlantocanadisk',),
'atlantokanadisk': ('atlantokanadisk',),
'atlantokanadiske': ('atlantokanadisk',),
'atlantokanadiskere': ('atlantokanadisk',),
'atlantokanadiskest': ('atlantokanadisk',),
'atlantokanadiskeste': ('atlantokanadisk',),
'atlantoskandisk': ('atlantoskandisk',),
'atlantoskandiske': ('atlantoskandisk',),
'atlantoskandiskere': ('atlantoskandisk',),
'atlantoskandiskest': ('atlantoskandisk',),
'atlantoskandiskeste': ('atlantoskandisk',),
'atletisk': ('atletisk',),
'atletiske': ('atletisk',),
'atletiskere': ('atletisk',),
'atletiskest': ('atletisk',),
'atletiskeste': ('atletisk',),
'atmosfærisk': ('atmosfærisk',),
'atmosfæriske': ('atmosfærisk',),
'atmosfæriskere': ('atmosfærisk',),
'atmosfæriskest': ('atmosfærisk',),
'atmosfæriskeste': ('atmosfærisk',),
'atoksisk': ('atoksisk',),
'atoksiske': ('atoksisk',),
'atoksiskere': ('atoksisk',),
'atoksiskest': ('atoksisk',),
'atoksiskeste': ('atoksisk',),
'atomar': ('atomar',),
'atomare': ('atomar',),
'atomarere': ('atomar',),
'atomarest': ('atomar',),
'atomareste': ('atomar',),
'atomart': ('atomar',),
'atomdrevet': ('atomdrevet',),
'atomdrevne': ('atomdrevet',),
'atomdrevnere': ('atomdrevet',),
'atomdrevnest': ('atomdrevet',),
'atomdrevneste': ('atomdrevet',),
'atomiserende': ('atomisere',),
'atomisert': ('atomisere',),
'atomiserte': ('atomisere',),
'atomistisk': ('atomistisk',),
'atomistiske': ('atomistisk',),
'atomistiskere': ('atomistisk',),
'atomistiskest': ('atomistisk',),
'atomistiskeste': ('atomistisk',),
'atomær': ('atomær',),
'atomære': ('atomær',),
'atomærere': ('atomær',),
'atomærest': ('atomær',),
'atomæreste': ('atomær',),
'atomært': ('atomær',),
'atonal': ('atonal',),
'atonale': ('atonal',),
'atonalere': ('atonal',),
'atonalest': ('atonal',),
'atonaleste': ('atonal',),
'atonalt': ('atonal',),
'atrofierende': ('atrofiere',),
'atrofiert': ('atrofiere',),
'atrofierte': ('atrofiere',),
'atrofisk': ('atrofisk',),
'atrofiske': ('atrofisk',),
'atrofiskere': ('atrofisk',),
'atrofiskest': ('atrofisk',),
'atrofiskeste': ('atrofisk',),
'atskillende': ('atskille',),
'atskilt': ('atskille',),
'atskilte': ('atskille',),
'atskillig': ('atskillig',),
'atskillige': ('atskillig',),
'atskilligere': ('atskillig',),
'atskilligst': ('atskillig',),
'atskilligste': ('atskillig',),
'atskilt': ('atskilt',),
'atskilte': ('atskilt',),
'atskiltere': ('atskilt',),
'atskiltest': ('atskilt',),
'atskilteste': ('atskilt',),
'atspredd': ('atspre',),
'atspredde': ('atspre',),
'atspredt': ('atspre',),
'atspredte': ('atspre',),
'atspreende': ('atspre',),
'atspredd': ('atsprede',),
'atspredde': ('atsprede',),
'atspredende': ('atsprede',),
'atspredt': ('atsprede',),
'atspredte': ('atsprede',),
'atspredt': ('atspredt',),
'atspredte': ('atspredt',),
'atspredtere': ('atspredt',),
'atspredtest': ('atspredt',),
'atspredteste': ('atspredt',),
'attacherende': ('attachere',),
'attachert': ('attachere',),
'attacherte': ('attachere',),
'attakkerende': ('attakkere',),
'attakkert': ('attakkere',),
'attakkerte': ('attakkere',),
'attende': ('attende',),
'attenårig': ('attenårig',),
'attenårige': ('attenårig',),
'attenårigere': ('attenårig',),
'attenårigst': ('attenårig',),
'attenårigste': ('attenårig',),
'attenårs': ('attenårs',),
'attesterende': ('attestere',),
'attestert': ('attestere',),
'attesterte': ('attestere',),
'attisk': ('attisk',),
'attiske': ('attisk',),
'attiskere': ('attisk',),
'attiskest': ('attisk',),
'attiskeste': ('attisk',),
'attraherende': ('attrahere',),
'attrahert': ('attrahere',),
'attraherte': ('attrahere',),
'attraktiv': ('attraktiv',),
'attraktive': ('attraktiv',),
'attraktivere': ('attraktiv',),
'attraktivest': ('attraktiv',),
'attraktiveste': ('attraktiv',),
'attraktivt': ('attraktiv',),
'attributiv': ('attributiv',),
'attributive': ('attributiv',),
'attributivere': ('attributiv',),
'attributivest': ('attributiv',),
'attributiveste': ('attributiv',),
'attributivt': ('attributiv',),
'attrådd': ('attrå',),
'attrådde': ('attrå',),
'attrående': ('attrå',),
'attråvekkende': ('attråvekkende',),
'attråverdig': ('attråverdig',),
'attråverdige': ('attråverdig',),
'attråverdigere': ('attråverdig',),
'attråverdigst': ('attråverdig',),
'attråverdigste': ('attråverdig',),
'atypisk': ('atypisk',),
'atypiske': ('atypisk',),
'atypiskere': ('atypisk',),
'atypiskest': ('atypisk',),
'atypiskeste': ('atypisk',),
'audienssøkende': ('audienssøkende',),
'audiologisk': ('audiologisk',),
'audiologiske': ('audiologisk',),
'audiologiskere': ('audiologisk',),
'audiologiskest': ('audiologisk',),
'audiologiskeste': ('audiologisk',),
'audiovisuell': ('audiovisuell',),
'audiovisuelle': ('audiovisuell',),
'audiovisuellere': ('audiovisuell',),
'audiovisuellest': ('audiovisuell',),
'audiovisuelleste': ('audiovisuell',),
'audiovisuelt': ('audiovisuell',),
'auditiv': ('auditiv',),
'auditive': ('auditiv',),
'auditivere': ('auditiv',),
'auditivest': ('auditiv',),
'auditiveste': ('auditiv',),
'auditivt': ('auditiv',),
'augsburgsk': ('augsburgsk',),
'augsburgske': ('augsburgsk',),
'augsburgskere': ('augsburgsk',),
'augsburgskest': ('augsburgsk',),
'augsburgskeste': ('augsburgsk',),
'augustinsk': ('augustinsk',),
'augustinske': ('augustinsk',),
'augustinskere': ('augustinsk',),
'augustinskest': ('augustinsk',),
'augustinskeste': ('augustinsk',),
'auka': ('auke',),
'aukede': ('auke',),
'aukende': ('auke',),
'auket': ('auke',),
'aukete': ('auke',),
'aukt': ('auke',),
'aukte': ('auke',),
'auksjonerende': ('auksjonere',),
'auksjonert': ('auksjonere',),
'auksjonerte': ('auksjonere',),
'aura': ('aure',),
'aurede': ('aure',),
'aurende': ('aure',),
'auret': ('aure',),
'aurete': ('aure',),
'auret': ('auret',),
'aurete': ('auret',),
'auretere': ('auret',),
'auretest': ('auret',),
'aureteste': ('auret',),
'aurete': ('aurete',),
'ausende': ('ause',),
'aust': ('ause',),
'auste': ('ause',),
'austafjelsk': ('austafjelsk',),
'austafjelske': ('austafjelsk',),
'austafjelskere': ('austafjelsk',),
'austafjelskest': ('austafjelsk',),
'austafjelskeste': ('austafjelsk',),
'austasiatisk': ('austasiatisk',),
'austasiatiske': ('austasiatisk',),
'austasiatiskere': ('austasiatisk',),
'austasiatiskest': ('austasiatisk',),
'austasiatiskeste': ('austasiatisk',),
'austeuropeisk': ('austeuropeisk',),
'austeuropeiske': ('austeuropeisk',),
'austeuropeiskere': ('austeuropeisk',),
'austeuropeiskest': ('austeuropeisk',),
'austeuropeiskeste': ('austeuropeisk',),
'austgermansk': ('austgermansk',),
'austgermanske': ('austgermansk',),
'austgermanskere': ('austgermansk',),
'austgermanskest': ('austgermansk',),
'austgermanskeste': ('austgermansk',),
'austgermansk': ('austgermansk',),
'austgermanske': ('austgermansk',),
'austgermanskere': ('austgermansk',),
'austgermanskest': ('austgermansk',),
'austgermanskeste': ('austgermansk',),
'austgermansk': ('austgermansk',),
'austgermanske': ('austgermansk',),
'austgermanskere': ('austgermansk',),
'austgermanskest': ('austgermansk',),
'austgermanskeste': ('austgermansk',),
'austgotisk': ('austgotisk',),
'austgotiske': ('austgotisk',),
'austgotiskere': ('austgotisk',),
'austgotiskest': ('austgotisk',),
'austgotiskeste': ('austgotisk',),
'austlandsk': ('austlandsk',),
'austlandske': ('austlandsk',),
'austlandskere': ('austlandsk',),
'austlandskest': ('austlandsk',),
'austlandskeste': ('austlandsk',),
'austlig': ('austlig',),
'austlige': ('austlig',),
'austligere': ('austlig',),
'austligst': ('austlig',),
'austligste': ('austlig',),
'austnordisk': ('austnordisk',),
'austnordiske': ('austnordisk',),
'austnordiskere': ('austnordisk',),
'austnordiskest': ('austnordisk',),
'austnordiskeste': ('austnordisk',),
'austnordisk': ('austnordisk',),
'austnordiske': ('austnordisk',),
'austnordiskere': ('austnordisk',),
'austnordiskest': ('austnordisk',),
'austnordiskeste': ('austnordisk',),
'austnordisk': ('austnordisk',),
'austnordiske': ('austnordisk',),
'austnordiskere': ('austnordisk',),
'austnordiskest': ('austnordisk',),
'austnordiskeste': ('austnordisk',),
'austnorsk': ('austnorsk',),
'austnorske': ('austnorsk',),
'austnorskere': ('austnorsk',),
'austnorskest': ('austnorsk',),
'austnorskeste': ('austnorsk',),
'australsk': ('australsk',),
'australske': ('australsk',),
'australskere': ('australsk',),
'australskest': ('australsk',),
'australskeste': ('australsk',),
'austre': ('austre',),
'austromarxistisk': ('austromarxistisk',),
'austromarxistiske': ('austromarxistisk',),
'austromarxistiskere': ('austromarxistisk',),
'austromarxistiskest': ('austromarxistisk',),
'austromarxistiskeste': ('austromarxistisk',),
'austromersk': ('austromersk',),
'austromerske': ('austromersk',),
'austromerskere': ('austromersk',),
'austromerskest': ('austromersk',),
'austromerskeste': ('austromersk',),
'austtysk': ('austtysk',),
'austtyske': ('austtysk',),
'austtyskere': ('austtysk',),
'austtyskest': ('austtysk',),
'austtyskeste': ('austtysk',),
'austvendt': ('austvendt',),
'austvendte': ('austvendt',),
'austvendtere': ('austvendt',),
'austvendtest': ('austvendt',),
'austvendteste': ('austvendt',),
'autentisk': ('autentisk',),
'autentiske': ('autentisk',),
'autentiskere': ('autentisk',),
'autentiskest': ('autentisk',),
'autentiskeste': ('autentisk',),
'autistisk': ('autistisk',),
'autistiske': ('autistisk',),
'autistiskere': ('autistisk',),
'autistiskest': ('autistisk',),
'autistiskeste': ('autistisk',),
'autobiografisk': ('autobiografisk',),
'autobiografiske': ('autobiografisk',),
'autobiografiskere': ('autobiografisk',),
'autobiografiskest': ('autobiografisk',),
'autobiografiskeste': ('autobiografisk',),
'autodidaktisk': ('autodidaktisk',),
'autodidaktiske': ('autodidaktisk',),
'autodidaktiskere': ('autodidaktisk',),
'autodidaktiskest': ('autodidaktisk',),
'autodidaktiskeste': ('autodidaktisk',),
'autogen': ('autogen',),
'autogene': ('autogen',),
'autogenere': ('autogen',),
'autogenest': ('autogen',),
'autogeneste': ('autogen',),
'autogent': ('autogen',),
'autoklaverende': ('autoklavere',),
'autoklavert': ('autoklavere',),
'autoklaverte': ('autoklavere',),
'autokratisk': ('autokratisk',),
'autokratiske': ('autokratisk',),
'autokratiskere': ('autokratisk',),
'autokratiskest': ('autokratisk',),
'autokratiskeste': ('autokratisk',),
'automatiserende': ('automatisere',),
'automatisert': ('automatisere',),
'automatiserte': ('automatisere',),
'automatisk': ('automatisk',),
'automatiske': ('automatisk',),
'automatiskere': ('automatisk',),
'automatiskest': ('automatisk',),
'automatiskeste': ('automatisk',),
'autonom': ('autonom',),
'autonome': ('autonom',),
'autonomere': ('autonom',),
'autonomest': ('autonom',),
'autonomeste': ('autonom',),
'autonomt': ('autonom',),
'autoral': ('autoral',),
'autorale': ('autoral',),
'autoralere': ('autoral',),
'autoralest': ('autoral',),
'autoraleste': ('autoral',),
'autoralt': ('autoral',),
'autoriserende': ('autorisere',),
'autorisert': ('autorisere',),
'autoriserte': ('autorisere',),
'autoritativ': ('autoritativ',),
'autoritative': ('autoritativ',),
'autoritativere': ('autoritativ',),
'autoritativest': ('autoritativ',),
'autoritativeste': ('autoritativ',),
'autoritativt': ('autoritativ',),
'autoritær': ('autoritær',),
'autoritære': ('autoritær',),
'autoritærere': ('autoritær',),
'autoritærest': ('autoritær',),
'autoritæreste': ('autoritær',),
'autoritært': ('autoritær',),
'avalerende': ('avalere',),
'avalert': ('avalere',),
'avalerte': ('avalere',),
'avanserende': ('avansere',),
'avansert': ('avansere',),
'avanserte': ('avansere',),
'avantgardistisk': ('avantgardistisk',),
'avantgardistiske': ('avantgardistisk',),
'avantgardistiskere': ('avantgardistisk',),
'avantgardistiskest': ('avantgardistisk',),
'avantgardistiskeste': ('avantgardistisk',),
'avbaklig': ('avbaklig',),
'avbaklige': ('avbaklig',),
'avbakligere': ('avbaklig',),
'avbakligst': ('avbaklig',),
'avbakligste': ('avbaklig',),
'avbalanserende': ('avbalansere',),
'avbalansert': ('avbalansere',),
'avbalanserte': ('avbalansere',),
'avbalansert': ('avbalansert',),
'avbalanserte': ('avbalansert',),
'avbalansertere': ('avbalansert',),
'avbalansertest': ('avbalansert',),
'avbalanserteste': ('avbalansert',),
'avbestillende': ('avbestille',),
'avbestilt': ('avbestille',),
'avbestilte': ('avbestille',),
'avbetalende': ('avbetale',),
'avbetalt': ('avbetale',),
'avbetalte': ('avbetale',),
'avbilda': ('avbilde',),
'avbildede': ('avbilde',),
'avbildende': ('avbilde',),
'avbildet': ('avbilde',),
'avbildete': ('avbilde',),
'avbindende': ('avbinde',),
'avbunden': ('avbinde',),
'avbundet': ('avbinde',),
'avbundne': ('avbinde',),
'avbleikede': ('avbleiket',),
'avbleiket': ('avbleiket',),
'avbleikete': ('avbleiket',),
'avbleiketere': ('avbleiket',),
'avbleiketest': ('avbleiket',),
'avbleiketeste': ('avbleiket',),
'avbleikt': ('avbleikt',),
'avbleikte': ('avbleikt',),
'avbleiktere': ('avbleikt',),
'avbleiktest': ('avbleikt',),
'avbleikteste': ('avbleikt',),
'avblekede': ('avbleket',),
'avbleket': ('avbleket',),
'avblekete': ('avbleket',),
'avbleketere': ('avbleket',),
'avbleketest': ('avbleket',),
'avbleketeste': ('avbleket',),
'avblekt': ('avblekt',),
'avblekte': ('avblekt',),
'avblektere': ('avblekt',),
'avblektest': ('avblekt',),
'avblekteste': ('avblekt',),
'avblomstra': ('avblomstra',),
'avblomstrede': ('avblomstret',),
'avblomstret': ('avblomstret',),
'avblomstrete': ('avblomstret',),
'avblomstretere': ('avblomstret',),
'avblomstretest': ('avblomstret',),
'avblomstreteste': ('avblomstret',),
'avblåsende': ('avblåse',),
'avblåst': ('avblåse',),
'avblåste': ('avblåse',),
'avbrutt': ('avbryte',),
'avbrutte': ('avbryte',),
'avbrytende': ('avbryte',),
'avbøtende': ('avbøte',),
'avbøtt': ('avbøte',),
'avbøtte': ('avbøte',),
'avbøya': ('avbøye',),
'avbøyd': ('avbøye',),
'avbøyde': ('avbøye',),
'avbøyede': ('avbøye',),
'avbøyende': ('avbøye',),
'avbøyet': ('avbøye',),
'avbøyete': ('avbøye',),
'avdampa': ('avdampe',),
'avdampede': ('avdampe',),
'avdampende': ('avdampe',),
'avdampet': ('avdampe',),
'avdampete': ('avdampe',),
'avdanka': ('avdanka',),
'avdankede': ('avdanket',),
'avdanket': ('avdanket',),
'avdankete': ('avdanket',),
'avdanketere': ('avdanket',),
'avdanketest': ('avdanket',),
'avdanketeste': ('avdanket',),
'avdekka': ('avdekke',),
'avdekkede': ('avdekke',),
'avdekkende': ('avdekke',),
'avdekket': ('avdekke',),
'avdekkete': ('avdekke',),
'avdekt': ('avdekke',),
'avdekte': ('avdekke',),
'avdelende': ('avdele',),
'avdelt': ('avdele',),
'avdelte': ('avdele',),
'avdempa': ('avdempe',),
'avdempede': ('avdempe',),
'avdempende': ('avdempe',),
'avdempet': ('avdempe',),
'avdempete': ('avdempe',),
'avdradd': ('avdra',),
'avdradde': ('avdra',),
'avdragende': ('avdra',),
'avdratt': ('avdra',),
'avdratte': ('avdra',),
'avdragsfri': ('avdragsfri',),
'avdragsfrie': ('avdragsfri',),
'avdragsfriere': ('avdragsfri',),
'avdragsfriest': ('avdragsfri',),
'avdragsfrieste': ('avdragsfri',),
'avdragsfritt': ('avdragsfri',),
'avdramatiserende': ('avdramatisere',),
'avdramatisert': ('avdramatisere',),
'avdramatiserte': ('avdramatisere',),
'avduka': ('avduke',),
'avdukede': ('avduke',),
'avdukende': ('avduke',),
'avduket': ('avduke',),
'avdukete': ('avduke',),
'avdød': ('avdød',),
'avdøde': ('avdød',),
'avdødere': ('avdød',),
'avdødest': ('avdød',),
'avdødeste': ('avdød',),
'avdødt': ('avdød',),
'averterende': ('avertere',),
'avertert': ('avertere',),
'averterte': ('avertere',),
'avfalma': ('avfalma',),
'avfalmede': ('avfalmet',),
'avfalmet': ('avfalmet',),
'avfalmete': ('avfalmet',),
'avfalmetere': ('avfalmet',),
'avfalmetest': ('avfalmet',),
'avfalmeteste': ('avfalmet',),
'avfasa': ('avfase',),
'avfasede': ('avfase',),
'avfasende': ('avfase',),
'avfaset': ('avfase',),
'avfasete': ('avfase',),
'avfatta': ('avfatte',),
'avfattede': ('avfatte',),
'avfattende': ('avfatte',),
'avfattet': ('avfatte',),
'avfattete': ('avfatte',),
'avfeia': ('avfeie',),
'avfeid': ('avfeie',),
'avfeide': ('avfeie',),
'avfeiede': ('avfeie',),
'avfeiende': ('avfeie',),
'avfeiet': ('avfeie',),
'avfeiete': ('avfeie',),
'avfeldig': ('avfeldig',),
'avfeldige': ('avfeldig',),
'avfeldigere': ('avfeldig',),
'avfeldigst': ('avfeldig',),
'avfeldigste': ('avfeldig',),
'avferdiga': ('avferdige',),
'avferdigede': ('avferdige',),
'avferdigende': ('avferdige',),
'avferdiget': ('avferdige',),
'avferdigete': ('avferdige',),
'avfetta': ('avfette',),
'avfettede': ('avfette',),
'avfettende': ('avfette',),
'avfettet': ('avfette',),
'avfettete': ('avfette',),
'avfinnende': ('avfinne',),
'avfunne': ('avfinne',),
'avfunnen': ('avfinne',),
'avfunnet': ('avfinne',),
'avfolka': ('avfolke',),
'avfolkede': ('avfolke',),
'avfolkende': ('avfolke',),
'avfolket': ('avfolke',),
'avfolkete': ('avfolke',),
'avfyrende': ('avfyre',),
'avfyrt': ('avfyre',),
'avfyrte': ('avfyre',),
'avfødende': ('avføde',),
'avfødt': ('avføde',),
'avfødte': ('avføde',),
'avførende': ('avføre',),
'avført': ('avføre',),
'avførte': ('avføre',),
'avførende': ('avførende',),
'avgiende': ('avgi',),
'avgitt': ('avgi',),
'avgitte': ('avgi',),
'avgivende': ('avgi',),
'avgiftsfri': ('avgiftsfri',),
'avgiftsfrie': ('avgiftsfri',),
'avgiftsfriere': ('avgiftsfri',),
'avgiftsfriest': ('avgiftsfri',),
'avgiftsfrieste': ('avgiftsfri',),
'avgiftsfritt': ('avgiftsfri',),
'avgiftspliktig': ('avgiftspliktig',),
'avgiftspliktige': ('avgiftspliktig',),
'avgiftspliktigere': ('avgiftspliktig',),
'avgiftspliktigst': ('avgiftspliktig',),
'avgiftspliktigste': ('avgiftspliktig',),
'avgjort': ('avgjort',),
'avgjorte': ('avgjort',),
'avgjortere': ('avgjort',),
'avgjortest': ('avgjort',),
'avgjorteste': ('avgjort',),
'avgjort': ('avgjøre',),
'avgjorte': ('avgjøre',),
'avgjørende': ('avgjøre',),
'avgjørende': ('avgjørende',),
'avglemt': ('avglemt',),
'avglemte': ('avglemt',),
'avglemtere': ('avglemt',),
'avglemtest': ('avglemt',),
'avglemteste': ('avglemt',),
'avglømt': ('avglømt',),
'avglømte': ('avglømt',),
'avglømtere': ('avglømt',),
'avglømtest': ('avglømt',),
'avglømteste': ('avglømt',),
'avgrensa': ('avgrense',),
'avgrensede': ('avgrense',),
'avgrensende': ('avgrense',),
'avgrenset': ('avgrense',),
'avgrensete': ('avgrense',),
'avgrunnsdjup': ('avgrunnsdjup',),
'avgrunnsdjupe': ('avgrunnsdjup',),
'avgrunnsdjupere': ('avgrunnsdjup',),
'avgrunnsdjupest': ('avgrunnsdjup',),
'avgrunnsdjupeste': ('avgrunnsdjup',),
'avgrunnsdjupt': ('avgrunnsdjup',),
'avgrunnsdyp': ('avgrunnsdyp',),
'avgrunnsdype': ('avgrunnsdyp',),
'avgrunnsdypere': ('avgrunnsdyp',),
'avgrunnsdypest': ('avgrunnsdyp',),
'avgrunnsdypeste': ('avgrunnsdyp',),
'avgrunnsdypt': ('avgrunnsdyp',),
'avgrunnsmørk': ('avgrunnsmørk',),
'avgrunnsmørke': ('avgrunnsmørk',),
'avgrunnsmørkere': ('avgrunnsmørk',),
'avgrunnsmørkest': ('avgrunnsmørk',),
'avgrunnsmørkeste': ('avgrunnsmørk',),
'avgrunnsmørkt': ('avgrunnsmørk',),
'avgående': ('avgå',),
'avgått': ('avgå',),
'avgåtte': ('avgå',),
'avgående': ('avgående',),
'avgått': ('avgått',),
'avgåtte': ('avgått',),
'avgåttere': ('avgått',),
'avgåttest': ('avgått',),
'avgåtteste': ('avgått',),
'avheimla': ('avheimle',),
'avheimlede': ('avheimle',),
'avheimlende': ('avheimle',),
'avheimlet': ('avheimle',),
'avheimlete': ('avheimle',),
'avhenda': ('avhende',),
'avhendede': ('avhende',),
'avhendende': ('avhende',),
'avhendet': ('avhende',),
'avhendete': ('avhende',),
'avhendelig': ('avhendelig',),
'avhendelige': ('avhendelig',),
'avhendeligere': ('avhendelig',),
'avhendeligst': ('avhendelig',),
'avhendeligste': ('avhendelig',),
'avhengende': ('avhenge',),
'avhengt': ('avhenge',),
'avhengte': ('avhenge',),
'avhengig': ('avhengig',),
'avhengige': ('avhengig',),
'avhengigere': ('avhengig',),
'avhengigst': ('avhengig',),
'avhengigste': ('avhengig',),
'avhenta': ('avhente',),
'avhentede': ('avhente',),
'avhentende': ('avhente',),
'avhentet': ('avhente',),
'avhentete': ('avhente',),
'avherda': ('avherde',),
'avherdede': ('avherde',),
'avherdende': ('avherde',),
'avherdet': ('avherde',),
'avherdete': ('avherde',),
'avhjelpende': ('avhjelpe',),
'avhjulpen': ('avhjelpe',),
'avhjulpet': ('avhjelpe',),
'avhjulpne': ('avhjelpe',),
'avhjemla': ('avhjemle',),
'avhjemlede': ('avhjemle',),
'avhjemlende': ('avhjemle',),
'avhjemlet': ('avhjemle',),
'avhjemlete': ('avhjemle',),
'avholdende': ('avholde',),
'avholdt': ('avholde',),
'avholdte': ('avholde',),
'avholdende': ('avholdende',),
'avholdt': ('avholdt',),
'avholdte': ('avholdt',),
'avholdtere': ('avholdt',),
'avholdtest': ('avholdt',),
'avholdteste': ('avholdt',),
'avhørende': ('avhøre',),
'avhørt': ('avhøre',),
'avhørte': ('avhøre',),
'aviatisk': ('aviatisk',),
'aviatiske': ('aviatisk',),
'aviatiskere': ('aviatisk',),
'aviatiskest': ('aviatisk',),
'aviatiskeste': ('aviatisk',),
'avindsjuk': ('avindsjuk',),
'avindsjuke': ('avindsjuk',),
'avindsjukere': ('avindsjuk',),
'avindsjukest': ('avindsjuk',),
'avindsjukeste': ('avindsjuk',),
'avindsjukt': ('avindsjuk',),
'avindsyk': ('avindsyk',),
'avindsyke': ('avindsyk',),
'avindsykere': ('avindsyk',),
'avindsykest': ('avindsyk',),
'avindsykeste': ('avindsyk',),
'avindsykt': ('avindsyk',),
'avisende': ('avise',),
'avist': ('avise',),
'aviste': ('avise',),
'avkanta': ('avkante',),
'avkantede': ('avkante',),
'avkantende': ('avkante',),
'avkantet': ('avkante',),
'avkantete': ('avkante',),
'avkjølende': ('avkjøle',),
'avkjølt': ('avkjøle',),
'avkjølte': ('avkjøle',),
'avkjønna': ('avkjønne',),
'avkjønnede': ('avkjønne',),
'avkjønnende': ('avkjønne',),
'avkjønnet': ('avkjønne',),
'avkjønnete': ('avkjønne',),
'avklarende': ('avklare',),
'avklart': ('avklare',),
'avklarte': ('avklare',),
'avkledd': ('avkle',),
'avkledde': ('avkle',),
'avkledende': ('avkle',),
'avkleende': ('avkle',),
'avkledd': ('avkledd',),
'avkledde': ('avkledd',),
'avkleddere': ('avkledd',),
'avkleddest': ('avkledd',),
'avkleddeste': ('avkledd',),
'avkoda': ('avkode',),
'avkodede': ('avkode',),
'avkodende': ('avkode',),
'avkodet': ('avkode',),
'avkodete': ('avkode',),
'avkokende': ('avkoke',),
'avkokt': ('avkoke',),
'avkokte': ('avkoke',),
'avkoloniserende': ('avkolonisere',),
'avkolonisert': ('avkolonisere',),
'avkoloniserte': ('avkolonisere',),
'avkorta': ('avkorte',),
'avkortede': ('avkorte',),
'avkortende': ('avkorte',),
'avkortet': ('avkorte',),
'avkortete': ('avkorte',),
'avkrefta': ('avkrefte',),
'avkreftede': ('avkrefte',),
'avkreftende': ('avkrefte',),
'avkreftet': ('avkrefte',),
'avkreftete': ('avkrefte',),
'avkreva': ('avkreve',),
'avkrevd': ('avkreve',),
'avkrevde': ('avkreve',),
'avkrevede': ('avkreve',),
'avkrevende': ('avkreve',),
'avkrevet': ('avkreve',),
'avkrevete': ('avkreve',),
'avkriminaliserende': ('avkriminalisere',),
'avkriminalisert': ('avkriminalisere',),
'avkriminaliserte': ('avkriminalisere',),
'avkristna': ('avkristne',),
'avkristnede': ('avkristne',),
'avkristnende': ('avkristne',),
'avkristnet': ('avkristne',),
'avkristnete': ('avkristne',),
'avlagt': ('avlagt',),
'avlagte': ('avlagt',),
'avlagtere': ('avlagt',),
'avlagtest': ('avlagt',),
'avlagteste': ('avlagt',),
'avlang': ('avlang',),
'avlange': ('avlang',),
'avlangt': ('avlang',),
'avlenger': ('avlang',),
'avlengre': ('avlang',),
'avlengst': ('avlang',),
'avlengste': ('avlang',),
'avlasta': ('avlaste',),
'avlastede': ('avlaste',),
'avlastende': ('avlaste',),
'avlastet': ('avlaste',),
'avlastete': ('avlaste',),
'avla': ('avle',),
'avlede': ('avle',),
'avlende': ('avle',),
'avlet': ('avle',),
'avlete': ('avle',),
'avleda': ('avlede',),
'avledede': ('avlede',),
'avledende': ('avlede',),
'avledet': ('avlede',),
'avledete': ('avlede',),
'avledyktig': ('avledyktig',),
'avledyktige': ('avledyktig',),
'avledyktigere': ('avledyktig',),
'avledyktigst': ('avledyktig',),
'avledyktigste': ('avledyktig',),
'avlagt': ('avlegge',),
'avlagte': ('avlegge',),
'avleggende': ('avlegge',),
'avleggs': ('avleggs',),
'avleggse': ('avleggs',),
'avleggsere': ('avleggs',),
'avleggsest': ('avleggs',),
'avleggseste': ('avleggs',),
'avleid': ('avleie',),
'avleidd': ('avleie',),
'avleidde': ('avleie',),
'avleide': ('avleie',),
'avleiende': ('avleie',),
'avleira': ('avleire',),
'avleirede': ('avleire',),
'avleirende': ('avleire',),
'avleiret': ('avleire',),
'avleirete': ('avleire',),
'avlesbar': ('avlesbar',),
'avlesbare': ('avlesbar',),
'avlesbarere': ('avlesbar',),
'avlesbarest': ('avlesbar',),
'avlesbareste': ('avlesbar',),
'avlesbart': ('avlesbar',),
'avlesende': ('avlese',),
'avlest': ('avlese',),
'avleste': ('avlese',),
'avleverende': ('avlevere',),
'avlevert': ('avlevere',),
'avleverte': ('avlevere',),
'avliva': ('avlive',),
'avlivede': ('avlive',),
'avlivende': ('avlive',),
'avlivet': ('avlive',),
'avlivete': ('avlive',),
'avlokka': ('avlokke',),
'avlokkede': ('avlokke',),
'avlokkende': ('avlokke',),
'avlokket': ('avlokke',),
'avlokkete': ('avlokke',),
'avlsproduktiv': ('avlsproduktiv',),
'avlsproduktive': ('avlsproduktiv',),
'avlsproduktivere': ('avlsproduktiv',),
'avlsproduktivest': ('avlsproduktiv',),
'avlsproduktiveste': ('avlsproduktiv',),
'avlsproduktivt': ('avlsproduktiv',),
'avlurende': ('avlure',),
'avlurt': ('avlure',),
'avlurte': ('avlure',),
'avlusa': ('avluse',),
'avlusede': ('avluse',),
'avlusende': ('avluse',),
'avluset': ('avluse',),
'avlusete': ('avluse',),
'avlust': ('avluse',),
'avluste': ('avluse',),
'avlysende': ('avlyse',),
'avlyst': ('avlyse',),
'avlyste': ('avlyse',),
'avlytta': ('avlytte',),
'avlyttede': ('avlytte',),
'avlyttende': ('avlytte',),
'avlyttet': ('avlytte',),
'avlyttete': ('avlytte',),
'avlåsende': ('avlåse',),
'avlåst': ('avlåse',),
'avlåste': ('avlåse',),
'avlønna': ('avlønne',),
'avlønnede': ('avlønne',),
'avlønnende': ('avlønne',),
'avlønnet': ('avlønne',),
'avlønnete': ('avlønne',),
'avlønt': ('avlønne',),
'avlønte': ('avlønne',),
'avløsende': ('avløse',),
'avløst': ('avløse',),
'avløste': ('avløse',),
'avløysende': ('avløyse',),
'avløyst': ('avløyse',),
'avløyste': ('avløyse',),
'avmagnetiserende': ('avmagnetisere',),
'avmagnetisert': ('avmagnetisere',),
'avmagnetiserte': ('avmagnetisere',),
'avmagra': ('avmagre',),
'avmagrede': ('avmagre',),
'avmagrende': ('avmagre',),
'avmagret': ('avmagre',),
'avmagrete': ('avmagre',),
'avmarsjerende': ('avmarsjere',),
'avmarsjert': ('avmarsjere',),
'avmarsjerte': ('avmarsjere',),
'avmektig': ('avmektig',),
'avmektige': ('avmektig',),
'avmektigere': ('avmektig',),
'avmektigst': ('avmektig',),
'avmektigste': ('avmektig',),
'avmerka': ('avmerke',),
'avmerkede': ('avmerke',),
'avmerkende': ('avmerke',),
'avmerket': ('avmerke',),
'avmerkete': ('avmerke',),
'avmilitariserende': ('avmilitarisere',),
'avmilitarisert': ('avmilitarisere',),
'avmilitariserte': ('avmilitarisere',),
'avmytologiserende': ('avmytologisere',),
'avmytologisert': ('avmytologisere',),
'avmytologiserte': ('avmytologisere',),
'avmålende': ('avmåle',),
'avmålt': ('avmåle',),
'avmålte': ('avmåle',),
'avmålt': ('avmålt',),
'avmålte': ('avmålt',),
'avmåltere': ('avmålt',),
'avmåltest': ('avmålt',),
'avmålteste': ('avmålt',),
'avmønstra': ('avmønstre',),
'avmønstrede': ('avmønstre',),
'avmønstrende': ('avmønstre',),
'avmønstret': ('avmønstre',),
'avmønstrete': ('avmønstre',),
'avnasjonaliserende': ('avnasjonalisere',),
'avnasjonalisert': ('avnasjonalisere',),
'avnasjonaliserte': ('avnasjonalisere',),
'avnorska': ('avnorske',),
'avnorskede': ('avnorske',),
'avnorskende': ('avnorske',),
'avnorsket': ('avnorske',),
'avnorskete': ('avnorske',),
'avokadogrøn': ('avokadogrøn',),
'avokadogrøne': ('avokadogrøn',),
'avokadogrønere': ('avokadogrøn',),
'avokadogrønest': ('avokadogrøn',),
'avokadogrøneste': ('avokadogrøn',),
'avokadogrønt': ('avokadogrøn',),
'avokadogrønn': ('avokadogrønn',),
'avokadogrønne': ('avokadogrønn',),
'avokadogrønnere': ('avokadogrønn',),
'avokadogrønnest': ('avokadogrønn',),
'avokadogrønneste': ('avokadogrønn',),
'avokadogrønt': ('avokadogrønn',),
'avpassa': ('avpasse',),
'avpassede': ('avpasse',),
'avpassende': ('avpasse',),
'avpasset': ('avpasse',),
'avpassete': ('avpasse',),
'avpatruljerende': ('avpatruljere',),
'avpatruljert': ('avpatruljere',),
'avpatruljerte': ('avpatruljere',),
'avpolitiserende': ('avpolitisere',),
'avpolitisert': ('avpolitisere',),
'avpolitiserte': ('avpolitisere',),
'avreagerende': ('avreagere',),
'avreagert': ('avreagere',),
'avreagerte': ('avreagere',),
'avretta': ('avrette',),
'avrettede': ('avrette',),
'avrettende': ('avrette',),
'avrettet': ('avrette',),
'avrettete': ('avrette',),
'avrima': ('avrime',),
'avrimede': ('avrime',),
'avrimende': ('avrime',),
'avrimet': ('avrime',),
'avrimete': ('avrime',),
'avrunda': ('avrunde',),
'avrundede': ('avrunde',),
'avrundende': ('avrunde',),
'avrundet': ('avrunde',),
'avrundete': ('avrunde',),
'avrusa': ('avruse',),
'avrusede': ('avruse',),
'avrusende': ('avruse',),
'avruset': ('avruse',),
'avrusete': ('avruse',),
'avrusta': ('avruste',),
'avrustede': ('avruste',),
'avrustende': ('avruste',),
'avrustet': ('avruste',),
'avrustete': ('avruste',),
'avrusta': ('avruste',),
'avrustede': ('avruste',),
'avrustende': ('avruste',),
'avrustet': ('avruste',),
'avrustete': ('avruste',),
'avsanna': ('avsanne',),
'avsannede': ('avsanne',),
'avsannende': ('avsanne',),
'avsannet': ('avsanne',),
'avsannete': ('avsanne',),
'avseende': ('avse',),
'avsett': ('avse',),
'avsette': ('avse',),
'avsendende': ('avsende',),
'avsendt': ('avsende',),
'avsendte': ('avsende',),
'avsatt': ('avsette',),
'avsatte': ('avsette',),
'avsettende': ('avsette',),
'avsagt': ('avsi',),
'avsagte': ('avsi',),
'avsiende': ('avsi',),
'avsides': ('avsides',),
'avsidesliggende': ('avsidesliggende',),
'avsilende': ('avsile',),
'avsilt': ('avsile',),
'avsilte': ('avsile',),
'avsindig': ('avsindig',),
'avsindige': ('avsindig',),
'avsindigere': ('avsindig',),
'avsindigst': ('avsindig',),
'avsindigste': ('avsindig',),
'avsjela': ('avsjela',),
'avsjelede': ('avsjelet',),
'avsjelet': ('avsjelet',),
'avsjelete': ('avsjelet',),
'avsjeletere': ('avsjelet',),
'avsjeletest': ('avsjelet',),
'avsjeleteste': ('avsjelet',),
'avsjelt': ('avsjelt',),
'avsjelte': ('avsjelt',),
'avsjeltere': ('avsjelt',),
'avsjeltest': ('avsjelt',),
'avsjelteste': ('avsjelt',),
'avskaffa': ('avskaffe',),
'avskaffede': ('avskaffe',),
'avskaffende': ('avskaffe',),
'avskaffet': ('avskaffe',),
'avskaffete': ('avskaffe',),
'avskalla': ('avskalle',),
'avskallede': ('avskalle',),
'avskallende': ('avskalle',),
'avskallet': ('avskalle',),
'avskallete': ('avskalle',),
'avskilta': ('avskilte',),
'avskiltede': ('avskilte',),
'avskiltende': ('avskilte',),
'avskiltet': ('avskilte',),
'avskiltete': ('avskilte',),
'avskipa': ('avskipe',),
'avskipede': ('avskipe',),
'avskipende': ('avskipe',),
'avskipet': ('avskipe',),
'avskipete': ('avskipe',),
'avskjediga': ('avskjedige',),
'avskjedigede': ('avskjedige',),
'avskjedigende': ('avskjedige',),
'avskjediget': ('avskjedige',),
'avskjedigete': ('avskjedige',),
'avskjerma': ('avskjerme',),
'avskjermede': ('avskjerme',),
'avskjermende': ('avskjerme',),
'avskjermet': ('avskjerme',),
'avskjermete': ('avskjerme',),
'avskjærende': ('avskjære',),
'avskåren': ('avskjære',),
'avskåret': ('avskjære',),
'avskårne': ('avskjære',),
'avskoga': ('avskoge',),
'avskogede': ('avskoge',),
'avskogende': ('avskoge',),
'avskoget': ('avskoge',),
'avskogete': ('avskoge',),
'avskrapa': ('avskrape',),
'avskrapede': ('avskrape',),
'avskrapende': ('avskrape',),
'avskrapet': ('avskrape',),
'avskrapete': ('avskrape',),
'avskrapt': ('avskrape',),
'avskrapte': ('avskrape',),
'avskrekka': ('avskrekke',),
'avskrekkede': ('avskrekke',),
'avskrekkende': ('avskrekke',),
'avskrekket': ('avskrekke',),
'avskrekkete': ('avskrekke',),
'avskrekkende': ('avskrekkende',),
'avskreven': ('avskrive',),
'avskrevet': ('avskrive',),
'avskrevne': ('avskrive',),
'avskrivende': ('avskrive',),
'avskydd': ('avsky',),
'avskydde': ('avsky',),
'avskyende': ('avsky',),
'avskyelig': ('avskyelig',),
'avskyelige': ('avskyelig',),
'avskyeligere': ('avskyelig',),
'avskyeligst': ('avskyelig',),
'avskyeligste': ('avskyelig',),
'avskyvekkende': ('avskyvekkende',),
'avskåren': ('avskåren',),
'avskåret': ('avskåren',),
'avskårne': ('avskåren',),
'avskårnere': ('avskåren',),
'avskårnest': ('avskåren',),
'avskårneste': ('avskåren',),
'avskåret': ('avskåret',),
'avskårne': ('avskåret',),
'avskårnere': ('avskåret',),
'avskårnest': ('avskåret',),
'avskårneste': ('avskåret',),
'avslappa': ('avslappa',),
'avslappede': ('avslappet',),
'avslappet': ('avslappet',),
'avslappete': ('avslappet',),
'avslappetere': ('avslappet',),
'avslappetest': ('avslappet',),
'avslappeteste': ('avslappet',),
'avslepen': ('avslepen',),
'avslepent': ('avslepen',),
'avslepne': ('avslepen',),
'avslepnere': ('avslepen',),
'avslepnest': ('avslepen',),
'avslepneste': ('avslepen',),
'avslutta': ('avslutte',),
'avsluttede': ('avslutte',),
'avsluttende': ('avslutte',),
'avsluttet': ('avslutte',),
'avsluttete': ('avslutte',),
'avsluttende': ('avsluttende',),
'avslående': ('avslå',),
'avslått': ('avslå',),
'avslåtte': ('avslå',),
'avsløra': ('avsløre',),
'avslørede': ('avsløre',),
'avslørende': ('avsløre',),
'avsløret': ('avsløre',),
'avslørete': ('avsløre',),
'avslørt': ('avsløre',),
'avslørte': ('avsløre',),
'avslørende': ('avslørende',),
'avsondra': ('avsondre',),
'avsondrede': ('avsondre',),
'avsondrende': ('avsondre',),
'avsondret': ('avsondre',),
'avsondrete': ('avsondre',),
'avsona': ('avsone',),
'avsonede': ('avsone',),
'avsonende': ('avsone',),
'avsonet': ('avsone',),
'avsonete': ('avsone',),
'avsont': ('avsone',),
'avsonte': ('avsone',),
'avspalta': ('avspalte',),
'avspaltede': ('avspalte',),
'avspaltende': ('avspalte',),
'avspaltet': ('avspalte',),
'avspaltete': ('avspalte',),
'avspaserende': ('avspasere',),
'avspasert': ('avspasere',),
'avspaserte': ('avspasere',),
'avspeila': ('avspeile',),
'avspeilede': ('avspeile',),
'avspeilende': ('avspeile',),
'avspeilet': ('avspeile',),
'avspeilete': ('avspeile',),
'avspeilt': ('avspeile',),
'avspeilte': ('avspeile',),
'avspent': ('avspent',),
'avspente': ('avspent',),
'avspentere': ('avspent',),
'avspentest': ('avspent',),
'avspenteste': ('avspent',),
'avsperra': ('avsperre',),
'avsperrede': ('avsperre',),
'avsperrende': ('avsperre',),
'avsperret': ('avsperre',),
'avsperrete': ('avsperre',),
'avspisende': ('avspise',),
'avspist': ('avspise',),
'avspiste': ('avspise',),
'avspora': ('avspore',),
'avsporede': ('avspore',),
'avsporende': ('avspore',),
'avsporet': ('avspore',),
'avsporete': ('avspore',),
'avsport': ('avspore',),
'avsporte': ('avspore',),
'avstedkommen': ('avstedkomme',),
'avstedkommende': ('avstedkomme',),
'avstedkommet': ('avstedkomme',),
'avstedkomne': ('avstedkomme',),
'avstemmende': ('avstemme',),
'avstemt': ('avstemme',),
'avstemte': ('avstemme',),
'avstengt': ('avstengt',),
'avstengte': ('avstengt',),
'avstengtere': ('avstengt',),
'avstengtest': ('avstengt',),
'avstengteste': ('avstengt',),
'avstikkende': ('avstikkende',),
'avstiva': ('avstive',),
'avstivede': ('avstive',),
'avstivende': ('avstive',),
'avstivet': ('avstive',),
'avstivete': ('avstive',),
'avstraffa': ('avstraffe',),
'avstraffede': ('avstraffe',),
'avstraffende': ('avstraffe',),
'avstraffet': ('avstraffe',),
'avstraffete': ('avstraffe',),
'avstressa': ('avstresse',),
'avstressede': ('avstresse',),
'avstressende': ('avstresse',),
'avstresset': ('avstresse',),
'avstressete': ('avstresse',),
'avstumpa': ('avstumpa',),
'avstumpede': ('avstumpet',),
'avstumpet': ('avstumpet',),
'avstumpete': ('avstumpet',),
'avstumpetere': ('avstumpet',),
'avstumpetest': ('avstumpet',),
'avstumpeteste': ('avstumpet',),
'avstående': ('avstå',),
'avstått': ('avstå',),
'avståtte': ('avstå',),
'avstøpende': ('avstøpe',),
'avstøpt': ('avstøpe',),
'avstøpte': ('avstøpe',),
'avsvekka': ('avsvekke',),
'avsvekkede': ('avsvekke',),
'avsvekkende': ('avsvekke',),
'avsvekket': ('avsvekke',),
'avsvekkete': ('avsvekke',),
'avsvekt': ('avsvekke',),
'avsvekte': ('avsvekke',),
'avsverga': ('avsverge',),
'avsvergede': ('avsverge',),
'avsvergende': ('avsverge',),
'avsverget': ('avsverge',),
'avsvergete': ('avsverge',),
'avsvoren': ('avsverge',),
'avsvoret': ('avsverge',),
'avsvorne': ('avsverge',),
'avsverja': ('avsverje',),
'avsverjede': ('avsverje',),
'avsverjende': ('avsverje',),
'avsverjet': ('avsverje',),
'avsverjete': ('avsverje',),
'avsvoren': ('avsverje',),
'avsvoret': ('avsverje',),
'avsvorne': ('avsverje',),
'avsvidd': ('avsvi',),
'avsvidde': ('avsvi',),
'avsviende': ('avsvi',),
'avsungen': ('avsynge',),
'avsunget': ('avsynge',),
'avsungne': ('avsynge',),
'avsyngende': ('avsynge',),
'avtakende': ('avta',),
'avtatt': ('avta',),
'avtatte': ('avta',),
'avtagende': ('avtagende',),
'avtakbar': ('avtakbar',),
'avtakbare': ('avtakbar',),
'avtakbarere': ('avtakbar',),
'avtakbarest': ('avtakbar',),
'avtakbareste': ('avtakbar',),
'avtakbart': ('avtakbar',),
'avtakende': ('avtakende',),
'avtala': ('avtale',),
'avtalende': ('avtale',),
'avtalt': ('avtale',),
'avtalte': ('avtale',),
'avtalefesta': ('avtalefeste',),
'avtalefestede': ('avtalefeste',),
'avtalefestende': ('avtalefeste',),
'avtalefestet': ('avtalefeste',),
'avtalefestete': ('avtalefeste',),
'avtegna': ('avtegne',),
'avtegnede': ('avtegne',),
'avtegnende': ('avtegne',),
'avtegnet': ('avtegne',),
'avtegnete': ('avtegne',),
'avtjenende': ('avtjene',),
'avtjent': ('avtjene',),
'avtjente': ('avtjene',),
'avtrappa': ('avtrappe',),
'avtrappede': ('avtrappe',),
'avtrappende': ('avtrappe',),
'avtrappet': ('avtrappe',),
'avtrappete': ('avtrappe',),
'avtroppende': ('avtroppende',),
'avtvingende': ('avtvinge',),
'avtvungen': ('avtvinge',),
'avtvunget': ('avtvinge',),
'avtvungne': ('avtvinge',),
'avundsjuk': ('avundsjuk',),
'avundsjuke': ('avundsjuk',),
'avundsjukere': ('avundsjuk',),
'avundsjukest': ('avundsjuk',),
'avundsjukeste': ('avundsjuk',),
'avundsjukt': ('avundsjuk',),
'avveid': ('avveie',),
'avveide': ('avveie',),
'avveiede': ('avveie',),
'avveiende': ('avveie',),
'avveiet': ('avveie',),
'avveiete': ('avveie',),
'avvekslende': ('avvekslende',),
'avvendende': ('avvende',),
'avvendt': ('avvende',),
'avvendte': ('avvende',),
'avvendelig': ('avvendelig',),
'avvendelige': ('avvendelig',),
'avvendeligere': ('avvendelig',),
'avvendeligst': ('avvendelig',),
'avvendeligste': ('avvendelig',),
'avvenna': ('avvenne',),
'avvennede': ('avvenne',),
'avvennende': ('avvenne',),
'avvennet': ('avvenne',),
'avvennete': ('avvenne',),
'avvent': ('avvenne',),
'avvente': ('avvenne',),
'avventa': ('avvente',),
'avventede': ('avvente',),
'avventende': ('avvente',),
'avventet': ('avvente',),
'avventete': ('avvente',),
'avventende': ('avventende',),
'avverga': ('avverge',),
'avvergede': ('avverge',),
'avvergende': ('avverge',),
'avverget': ('avverge',),
'avvergete': ('avverge',),
'avvergende': ('avvergende',),
'avverja': ('avverje',),
'avverjede': ('avverje',),
'avverjende': ('avverje',),
'avverjet': ('avverje',),
'avverjete': ('avverje',),
'avverjende': ('avverjende',),
'avveken': ('avvike',),
'avveket': ('avvike',),
'avvekne': ('avvike',),
'avvikende': ('avvike',),
'avvikende': ('avvikende',),
'avvikla': ('avvikle',),
'avviklede': ('avvikle',),
'avviklende': ('avvikle',),
'avviklet': ('avvikle',),
'avviklete': ('avvikle',),
'avvirka': ('avvirke',),
'avvirkede': ('avvirke',),
'avvirkende': ('avvirke',),
'avvirket': ('avvirke',),
'avvirkete': ('avvirke',),
'avvisende': ('avvise',),
'avvist': ('avvise',),
'avviste': ('avvise',),
'avvisende': ('avvisende',),
'avvæpna': ('avvæpne',),
'avvæpnede': ('avvæpne',),
'avvæpnende': ('avvæpne',),
'avvæpnet': ('avvæpne',),
'avvæpnete': ('avvæpne',),
'aztekisk': ('aztekisk',),
'aztekiske': ('aztekisk',),
'aztekiskere': ('aztekisk',),
'aztekiskest': ('aztekisk',),
'aztekiskeste': ('aztekisk',),
'babelsk': ('babelsk',),
'babelske': ('babelsk',),
'babelskere': ('babelsk',),
'babelskest': ('babelsk',),
'babelskeste': ('babelsk',),
'babla': ('bable',),
'bablede': ('bable',),
'bablende': ('bable',),
'bablet': ('bable',),
'bablete': ('bable',),
'bablet': ('bablet',),
'bablete': ('bablet',),
'babletere': ('bablet',),
'babletest': ('bablet',),
'bableteste': ('bablet',),
'bablete': ('bablete',),
'babylonisk': ('babylonisk',),
'babyloniske': ('babylonisk',),
'babyloniskere': ('babylonisk',),
'babyloniskest': ('babylonisk',),
'babyloniskeste': ('babylonisk',),
'babylonsk': ('babylonsk',),
'babylonske': ('babylonsk',),
'babylonskere': ('babylonsk',),
'babylonskest': ('babylonsk',),
'babylonskeste': ('babylonsk',),
'bada': ('bade',),
'badede': ('bade',),
'badende': ('bade',),
'badet': ('bade',),
'badete': ('bade',),
'bagatelliserende': ('bagatellisere',),
'bagatellisert': ('bagatellisere',),
'bagatelliserte': ('bagatellisere',),
'bagatellmessig': ('bagatellmessig',),
'bagatellmessige': ('bagatellmessig',),
'bagatellmessigere': ('bagatellmessig',),
'bagatellmessigst': ('bagatellmessig',),
'bagatellmessigste': ('bagatellmessig',),
'bahamansk': ('bahamansk',),
'bahamanske': ('bahamansk',),
'bahamanskere': ('bahamansk',),
'bahamanskest': ('bahamansk',),
'bahamanskeste': ('bahamansk',),
'bahrainsk': ('bahrainsk',),
'bahrainske': ('bahrainsk',),
'bahrainskere': ('bahrainsk',),
'bahrainskest': ('bahrainsk',),
'bahrainskeste': ('bahrainsk',),
'baissa': ('baisse',),
'baissede': ('baisse',),
'baissende': ('baisse',),
'baisset': ('baisse',),
'baissete': ('baisse',),
'bakbindende': ('bakbinde',),
'bakbunden': ('bakbinde',),
'bakbundet': ('bakbinde',),
'bakbundne': ('bakbinde',),
'baka': ('bake',),
'bakende': ('bake',),
'bakt': ('bake',),
'bakte': ('bake',),
'bakerst': ('bakerst',),
'bakerste': ('bakerst',),
'bakglatt': ('bakglatt',),
'bakglatte': ('bakglatt',),
'bakglattere': ('bakglatt',),
'bakglattest': ('bakglatt',),
'bakglatteste': ('bakglatt',),
'bakhjulsdrevet': ('bakhjulsdrevet',),
'bakhjulsdrevne': ('bakhjulsdrevet',),
'bakhjulsdrevnere': ('bakhjulsdrevet',),
'bakhjulsdrevnest': ('bakhjulsdrevet',),
'bakhjulsdrevneste': ('bakhjulsdrevet',),
'bakkantisk': ('bakkantisk',),
'bakkantiske': ('bakkantisk',),
'bakkantiskere': ('bakkantisk',),
'bakkantiskest': ('bakkantisk',),
'bakkantiskeste': ('bakkantisk',),
'bakka': ('bakke',),
'bakkede': ('bakke',),
'bakkende': ('bakke',),
'bakket': ('bakke',),
'bakkete': ('bakke',),
'bakka': ('bakke',),
'bakkede': ('bakke',),
'bakkende': ('bakke',),
'bakket': ('bakke',),
'bakkete': ('bakke',),
'bakket': ('bakket',),
'bakkete': ('bakket',),
'bakketere': ('bakket',),
'bakketest': ('bakket',),
'bakketeste': ('bakket',),
'bakkete': ('bakkete',),
'bakknappa': ('bakknappa',),
'bakknappede': ('bakknappet',),
'bakknappet': ('bakknappet',),
'bakknappete': ('bakknappet',),
'bakknappetere': ('bakknappet',),
'bakknappetest': ('bakknappet',),
'bakknappeteste': ('bakknappet',),
'bakoverbøyd': ('bakoverbøyd',),
'bakoverbøyde': ('bakoverbøyd',),
'bakoverbøydere': ('bakoverbøyd',),
'bakoverbøydest': ('bakoverbøyd',),
'bakoverbøydeste': ('bakoverbøyd',),
'bakerst': ('bakre',),
'bakerste': ('bakre',),
'bakre': ('bakre',),
'baksa': ('bakse',),
'baksede': ('bakse',),
'baksende': ('bakse',),
'bakset': ('bakse',),
'baksete': ('bakse',),
'baksnakka': ('baksnakke',),
'baksnakkede': ('baksnakke',),
'baksnakkende': ('baksnakke',),
'baksnakket': ('baksnakke',),
'baksnakkete': ('baksnakke',),
'bakstreversk': ('bakstreversk',),
'bakstreverske': ('bakstreversk',),
'bakstreverskere': ('bakstreversk',),
'bakstreverskest': ('bakstreversk',),
'bakstreverskeste': ('bakstreversk',),
'baktala': ('baktale',),
'baktalende': ('baktale',),
'baktalt': ('baktale',),
'baktalte': ('baktale',),
'baktericid': ('baktericid',),
'bakteriedrepende': ('bakteriedrepende',),
'bakteriell': ('bakteriell',),
'bakterielle': ('bakteriell',),
'bakteriellere': ('bakteriell',),
'bakteriellest': ('bakteriell',),
'bakterielleste': ('bakteriell',),
'bakterielt': ('bakteriell',),
'bakteriologisk': ('bakteriologisk',),
'bakteriologiske': ('bakteriologisk',),
'bakteriologiskere': ('bakteriologisk',),
'bakteriologiskest': ('bakteriologisk',),
'bakteriologiskeste': ('bakteriologisk',),
'baktung': ('baktung',),
'baktunge': ('baktung',),
'baktungere': ('baktung',),
'baktungest': ('baktung',),
'baktungeste': ('baktung',),
'baktungt': ('baktung',),
'baktyngre': ('baktung',),
'baktyngst': ('baktung',),
'baktyngste': ('baktung',),
'bakvaska': ('bakvaske',),
'bakvaskede': ('bakvaske',),
'bakvaskende': ('bakvaske',),
'bakvasket': ('bakvaske',),
'bakvaskete': ('bakvaske',),
'bakvendt': ('bakvendt',),
'bakvendte': ('bakvendt',),
'bakvendtere': ('bakvendt',),
'bakvendtest': ('bakvendt',),
'bakvendteste': ('bakvendt',),
'balanserende': ('balansere',),
'balansert': ('balansere',),
'balanserte': ('balansere',),
'bala': ('bale',),
'balede': ('bale',),
'balende': ('bale',),
'balet': ('bale',),
'balete': ('bale',),
'balt': ('bale',),
'balte': ('bale',),
'balinesisk': ('balinesisk',),
'balinesiske': ('balinesisk',),
'balinesiskere': ('balinesisk',),
'balinesiskest': ('balinesisk',),
'balinesiskeste': ('balinesisk',),
'balkaniserende': ('balkanisere',),
'balkanisert': ('balkanisere',),
'balkaniserte': ('balkanisere',),
'balkansk': ('balkansk',),
'balkanske': ('balkansk',),
'balkanskere': ('balkansk',),
'balkanskest': ('balkansk',),
'balkanskeste': ('balkansk',),
'ballasta': ('ballaste',),
'ballastede': ('ballaste',),
'ballastende': ('ballaste',),
'ballastet': ('ballaste',),
'ballastete': ('ballaste',),
'balla': ('balle',),
'ballede': ('balle',),
'ballende': ('balle',),
'ballet': ('balle',),
'ballete': ('balle',),
'ballistisk': ('ballistisk',),
'ballistiske': ('ballistisk',),
'ballistiskere': ('ballistisk',),
'ballistiskest': ('ballistisk',),
'ballistiskeste': ('ballistisk',),
'ballongforma': ('ballongforma',),
'ballongformede': ('ballongformet',),
'ballongformet': ('ballongformet',),
'ballongformete': ('ballongformet',),
'ballongformetere': ('ballongformet',),
'ballongformetest': ('ballongformet',),
'ballongformeteste': ('ballongformet',),
'ballotterende': ('ballottere',),
'ballottert': ('ballottere',),
'ballotterte': ('ballottere',),
'balsamerende': ('balsamere',),
'balsamert': ('balsamere',),
'balsamerte': ('balsamere',),
'balstyren': ('balstyren',),
'balstyrent': ('balstyren',),
'balstyrne': ('balstyren',),
'balstyrnere': ('balstyren',),
'balstyrnest': ('balstyren',),
'balstyrneste': ('balstyren',),
'balstyrig': ('balstyrig',),
'balstyrige': ('balstyrig',),
'balstyrigere': ('balstyrig',),
'balstyrigst': ('balstyrig',),
'balstyrigste': ('balstyrig',),
'baltisk': ('baltisk',),
'baltiske': ('baltisk',),
'baltiskere': ('baltisk',),
'baltiskest': ('baltisk',),
'baltiskeste': ('baltisk',),
'banal': ('banal',),
'banale': ('banal',),
'banalere': ('banal',),
'banalest': ('banal',),
'banaleste': ('banal',),
'banalt': ('banal',),
'banaliserende': ('banalisere',),
'banalisert': ('banalisere',),
'banaliserte': ('banalisere',),
'bandasjerende': ('bandasjere',),
'bandasjert': ('bandasjere',),
'bandasjerte': ('bandasjere',),
'banda': ('bande',),
'bandede': ('bande',),
'bandende': ('bande',),
'bandet': ('bande',),
'bandete': ('bande',),
'bandlagt': ('bandlegge',),
'bandlagte': ('bandlegge',),
'bandleggende': ('bandlegge',),
'bana': ('bane',),
'banede': ('bane',),
'banende': ('bane',),
'banet': ('bane',),
'banete': ('bane',),
'bant': ('bane',),
'bante': ('bane',),
'banebrytende': ('banebrytende',),
'banepålagt': ('banepålagt',),
'banepålagte': ('banepålagt',),
'banepålagtere': ('banepålagt',),
'banepålagtest': ('banepålagt',),
'banepålagteste': ('banepålagt',),
'bange': ('bange',),
'bangladeshisk': ('bangladeshisk',),
'bangladeshiske': ('bangladeshisk',),
'bangladeshiskere': ('bangladeshisk',),
'bangladeshiskest': ('bangladeshisk',),
'bangladeshiskeste': ('bangladeshisk',),
'banka': ('banke',),
'bankede': ('banke',),
'bankende': ('banke',),
'banket': ('banke',),
'bankete': ('banke',),
'bankerott': ('bankerott',),
'bankerotte': ('bankerott',),
'bankerottere': ('bankerott',),
'bankerottest': ('bankerott',),
'bankerotteste': ('bankerott',),
'banna': ('banne',),
'bannede': ('banne',),
'bannende': ('banne',),
'bannet': ('banne',),
'bannete': ('banne',),
'bant': ('banne',),
'bante': ('banne',),
'bannlysende': ('bannlyse',),
'bannlyst': ('bannlyse',),
'bannlyste': ('bannlyse',),
'bannsatt': ('bannsette',),
'bannsatte': ('bannsette',),
'bannsettende': ('bannsette',),
'baptistisk': ('baptistisk',),
'baptistiske': ('baptistisk',),
'baptistiskere': ('baptistisk',),
'baptistiskest': ('baptistisk',),
'baptistiskeste': ('baptistisk',),
'bar': ('bar',),
'bare': ('bar',),
'barere': ('bar',),
'barest': ('bar',),
'bareste': ('bar',),
'bart': ('bar',),
'bararma': ('bararma',),
'bararmede': ('bararmet',),
'bararmet': ('bararmet',),
'bararmete': ('bararmet',),
'bararmetere': ('bararmet',),
'bararmetest': ('bararmet',),
'bararmeteste': ('bararmet',),
'barbadisk': ('barbadisk',),
'barbadiske': ('barbadisk',),
'barbadiskere': ('barbadisk',),
'barbadiskest': ('barbadisk',),
'barbadiskeste': ('barbadisk',),
'barbarisk': ('barbarisk',),
'barbariske': ('barbarisk',),
'barbariskere': ('barbarisk',),
'barbariskest': ('barbarisk',),
'barbariskeste': ('barbarisk',),
'barbeint': ('barbeint',),
'barbeinte': ('barbeint',),
'barbeintere': ('barbeint',),
'barbeintest': ('barbeint',),
'barbeinteste': ('barbeint',),
'barbent': ('barbent',),
'barbente': ('barbent',),
'barbentere': ('barbent',),
'barbentest': ('barbent',),
'barbenteste': ('barbent',),
'barberende': ('barbere',),
'barbert': ('barbere',),
'barberte': ('barbere',),
'bardunerende': ('bardunere',),
'bardunert': ('bardunere',),
'bardunerte': ('bardunere',),
'bardus': ('bardus',),
'barduse': ('bardus',),
'bardusere': ('bardus',),
'bardusest': ('bardus',),
'barduseste': ('bardus',),
'bardust': ('bardus',),
'bara': ('bare',),
'barede': ('bare',),
'barende': ('bare',),
'baret': ('bare',),
'barete': ('bare',),
'barfota': ('barfota',),
'barfotede': ('barfotet',),
'barfotet': ('barfotet',),
'barfotete': ('barfotet',),
'barfotetere': ('barfotet',),
'barfotetest': ('barfotet',),
'barfoteteste': ('barfotet',),
'barfrosne': ('barfrossen',),
'barfrosnere': ('barfrossen',),
'barfrosnest': ('barfrossen',),
'barfrosneste': ('barfrossen',),
'barfrossen': ('barfrossen',),
'barfrosset': ('barfrossen',),
'barfrosne': ('barfrosset',),
'barfrosnere': ('barfrosset',),
'barfrosnest': ('barfrosset',),
'barfrosneste': ('barfrosset',),
'barfrosset': ('barfrosset',),
'barføtt': ('barføtt',),
'barføtte': ('barføtt',),
'barføttere': ('barføtt',),
'barføttest': ('barføtt',),
'barføtteste': ('barføtt',),
'barhoda': ('barhoda',),
'barhodede': ('barhodet',),
'barhodet': ('barhodet',),
'barhodete': ('barhodet',),
'barhodetere': ('barhodet',),
'barhodetest': ('barhodet',),
'barhodeteste': ('barhodet',),
'barka': ('barka',),
'barka': ('barke',),
'barkede': ('barke',),
'barkende': ('barke',),
'barket': ('barke',),
'barkete': ('barke',),
'barkede': ('barket',),
'barket': ('barket',),
'barkete': ('barket',),
'barketere': ('barket',),
'barketest': ('barket',),
'barketeste': ('barket',),
'barmhjertig': ('barmhjertig',),
'barmhjertige': ('barmhjertig',),
'barmhjertigere': ('barmhjertig',),
'barmhjertigst': ('barmhjertig',),
'barmhjertigste': ('barmhjertig',),
'barnaktig': ('barnaktig',),
'barnaktige': ('barnaktig',),
'barnaktigere': ('barnaktig',),
'barnaktigst': ('barnaktig',),
'barnaktigste': ('barnaktig',),
'barnefødd': ('barnefødd',),
'barnefødde': ('barnefødd',),
'barneføddere': ('barnefødd',),
'barneføddest': ('barnefødd',),
'barneføddeste': ('barnefødd',),
'barnefødt': ('barnefødt',),
'barnefødte': ('barnefødt',),
'barnefødtere': ('barnefødt',),
'barnefødtest': ('barnefødt',),
'barnefødteste': ('barnefødt',),
'barnerik': ('barnerik',),
'barnerike': ('barnerik',),
'barnerikere': ('barnerik',),
'barnerikest': ('barnerik',),
'barnerikeste': ('barnerik',),
'barnerikt': ('barnerik',),
'barnesikker': ('barnesikker',),
'barnesikkert': ('barnesikker',),
'barnesikre': ('barnesikker',),
'barnesikrere': ('barnesikker',),
'barnesikrest': ('barnesikker',),
'barnesikreste': ('barnesikker',),
'barnevennlig': ('barnevennlig',),
'barnevennlige': ('barnevennlig',),
'barnevennligere': ('barnevennlig',),
'barnevennligst': ('barnevennlig',),
'barnevennligste': ('barnevennlig',),
'barnlaus': ('barnlaus',),
'barnlause': ('barnlaus',),
'barnlausere': ('barnlaus',),
'barnlausest': ('barnlaus',),
'barnlauseste': ('barnlaus',),
'barnlaust': ('barnlaus',),
'barnlig': ('barnlig',),
'barnlige': ('barnlig',),
'barnligere': ('barnlig',),
'barnligst': ('barnlig',),
'barnligste': ('barnlig',),
'barnløs': ('barnløs',),
'barnløse': ('barnløs',),
'barnløsere': ('barnløs',),
'barnløsest': ('barnløs',),
'barnløseste': ('barnløs',),
'barnløst': ('barnløs',),
'barnslig': ('barnslig',),
'barnslige': ('barnslig',),
'barnsligere': ('barnslig',),
'barnsligst': ('barnslig',),
'barnsligste': ('barnslig',),
'barokk': ('barokk',),
'barokke': ('barokk',),
'barokkere': ('barokk',),
'barokkest': ('barokk',),
'barokkeste': ('barokk',),
'barokt': ('barokk',),
'barometrisk': ('barometrisk',),
'barometriske': ('barometrisk',),
'barometriskere': ('barometrisk',),
'barometriskest': ('barometrisk',),
'barometriskeste': ('barometrisk',),
'barrikaderende': ('barrikadere',),
'barrikadert': ('barrikadere',),
'barrikaderte': ('barrikadere',),
'barsk': ('barsk',),
'barske': ('barsk',),
'barskere': ('barsk',),
'barskest': ('barsk',),
'barskeste': ('barsk',),
'barskt': ('barsk',),
'barska': ('barske',),
'barskede': ('barske',),
'barskende': ('barske',),
'barsket': ('barske',),
'barskete': ('barske',),
'basal': ('basal',),
'basale': ('basal',),
'basalere': ('basal',),
'basalest': ('basal',),
'basaleste': ('basal',),
'basalt': ('basal',),
'basaltisk': ('basaltisk',),
'basaltiske': ('basaltisk',),
'basaltiskere': ('basaltisk',),
'basaltiskest': ('basaltisk',),
'basaltiskeste': ('basaltisk',),
'basa': ('base',),
'basende': ('base',),
'bast': ('base',),
'baste': ('base',),
'baserende': ('basere',),
'basert': ('basere',),
'baserte': ('basere',),
'basisk': ('basisk',),
'basiske': ('basisk',),
'basiskere': ('basisk',),
'basiskest': ('basisk',),
'basiskeste': ('basisk',),
'baska': ('baske',),
'baskede': ('baske',),
'baskende': ('baske',),
'basket': ('baske',),
'baskete': ('baske',),
'baskisk': ('baskisk',),
'baskiske': ('baskisk',),
'baskiskere': ('baskisk',),
'baskiskest': ('baskisk',),
'baskiskeste': ('baskisk',),
'bastant': ('bastant',),
'bastante': ('bastant',),
'bastantere': ('bastant',),
'bastantest': ('bastant',),
'bastanteste': ('bastant',),
'basta': ('baste',),
'bastede': ('baste',),
'bastende': ('baste',),
'bastet': ('baste',),
'bastete': ('baste',),
'basunerende': ('basunere',),
'basunert': ('basunere',),
'basunerte': ('basunere',),
'batteridrevet': ('batteridrevet',),
'batteridrevne': ('batteridrevet',),
'batteridrevnere': ('batteridrevet',),
'batteridrevnest': ('batteridrevet',),
'batteridrevneste': ('batteridrevet',),
'bauta': ('baute',),
'bautede': ('baute',),
'bautende': ('baute',),
'bautet': ('baute',),
'bautete': ('baute',),
'bayersk': ('bayersk',),
'bayerske': ('bayersk',),
'bayerskere': ('bayersk',),
'bayerskest': ('bayersk',),
'bayerskeste': ('bayersk',),
'bedt': ('be',),
'bedte': ('be',),
'beende': ('be',),
'bearbeida': ('bearbeide',),
'bearbeidd': ('bearbeide',),
'bearbeidde': ('bearbeide',),
'bearbeidede': ('bearbeide',),
'bearbeidende': ('bearbeide',),
'bearbeidet': ('bearbeide',),
'bearbeidete': ('bearbeide',),
'bebodd': ('bebo',),
'bebodde': ('bebo',),
'beboende': ('bebo',),
'beboelig': ('beboelig',),
'beboelige': ('beboelig',),
'beboeligere': ('beboelig',),
'beboeligst': ('beboelig',),
'beboeligste': ('beboelig',),
'bebreida': ('bebreide',),
'bebreidede': ('bebreide',),
'bebreidende': ('bebreide',),
'bebreidet': ('bebreide',),
'bebreidete': ('bebreide',),
'bebreidende': ('bebreidende',),
'bebrilla': ('bebrilla',),
'bebrillede': ('bebrillet',),
'bebrillet': ('bebrillet',),
'bebrillete': ('bebrillet',),
'bebrilletere': ('bebrillet',),
'bebrilletest': ('bebrillet',),
'bebrilleteste': ('bebrillet',),
'bebuda': ('bebude',),
'bebudede': ('bebude',),
'bebudende': ('bebude',),
'bebudet': ('bebude',),
'bebudete': ('bebude',),
'bebygd': ('bebygge',),
'bebygde': ('bebygge',),
'bebygga': ('bebygge',),
'bebyggede': ('bebygge',),
'bebyggende': ('bebygge',),
'bebygget': ('bebygge',),
'bebyggete': ('bebygge',),
'bebyggelig': ('bebyggelig',),
'bebyggelige': ('bebyggelig',),
'bebyggeligere': ('bebyggelig',),
'bebyggeligst': ('bebyggelig',),
'bebyggeligste': ('bebyggelig',),
'bebyrda': ('bebyrde',),
'bebyrdede': ('bebyrde',),
'bebyrdende': ('bebyrde',),
'bebyrdet': ('bebyrde',),
'bebyrdete': ('bebyrde',),
'bedaga': ('bedaga',),
'bedaga': ('bedage',),
'bedagede': ('bedage',),
'bedagende': ('bedage',),
'bedaget': ('bedage',),
'bedagete': ('bedage',),
'bedagelig': ('bedagelig',),
'bedagelige': ('bedagelig',),
'bedageligere': ('bedagelig',),
'bedageligst': ('bedagelig',),
'bedageligste': ('bedagelig',),
'bedagede': ('bedaget',),
'bedaget': ('bedaget',),
'bedagete': ('bedaget',),
'bedagetere': ('bedaget',),
'bedagetest': ('bedaget',),
'bedageteste': ('bedaget',),
'bedende': ('bede',),
'bedt': ('bede',),
'bedte': ('bede',),
'bedekka': ('bedekke',),
'bedekkede': ('bedekke',),
'bedekkende': ('bedekke',),
'bedekket': ('bedekke',),
'bedekkete': ('bedekke',),
'bedekt': ('bedekke',),
'bedekte': ('bedekke',),
'bederva': ('bederva',),
'bedervelig': ('bedervelig',),
'bedervelige': ('bedervelig',),
'bederveligere': ('bedervelig',),
'bederveligst': ('bedervelig',),
'bederveligste': ('bedervelig',),
'bedervede': ('bedervet',),
'bedervet': ('bedervet',),
'bedervete': ('bedervet',),
'bedervetere': ('bedervet',),
'bedervetest': ('bedervet',),
'bederveteste': ('bedervet',),
'bedradd': ('bedra',),
'bedradde': ('bedra',),
'bedragende': ('bedra',),
'bedratt': ('bedra',),
'bedratte': ('bedra',),
'bedragerisk': ('bedragerisk',),
'bedrageriske': ('bedragerisk',),
'bedrageriskere': ('bedragerisk',),
'bedrageriskest': ('bedragerisk',),
'bedrageriskeste': ('bedragerisk',),
'bedragersk': ('bedragersk',),
'bedragerske': ('bedragersk',),
'bedragerskere': ('bedragersk',),
'bedragerskest': ('bedragersk',),
'bedragerskeste': ('bedragersk',),
'bedra': ('bedre',),
'bedrede': ('bedre',),
'bedrende': ('bedre',),
'bedret': ('bedre',),
'bedrete': ('bedre',),
'bedre': ('bedre',),
'bedrestilt': ('bedrestilt',),
'bedrestilte': ('bedrestilt',),
'bedrestiltere': ('bedrestilt',),
'bedrestiltest': ('bedrestilt',),
'bedrestilteste': ('bedrestilt',),
'bedrevitende': ('bedrevitende',),
'bedreven': ('bedrive',),
'bedrevet': ('bedrive',),
'bedrevne': ('bedrive',),
'bedrivende': ('bedrive',),
'bedrøva': ('bedrøve',),
'bedrøvede': ('bedrøve',),
'bedrøvende': ('bedrøve',),
'bedrøvet': ('bedrøve',),
'bedrøvete': ('bedrøve',),
'bedrøvelig': ('bedrøvelig',),
'bedrøvelige': ('bedrøvelig',),
'bedrøveligere': ('bedrøvelig',),
'bedrøveligst': ('bedrøvelig',),
'bedrøveligste': ('bedrøvelig',),
'bedugga': ('bedugga',),
'beduggede': ('bedugget',),
'bedugget': ('bedugget',),
'beduggete': ('bedugget',),
'beduggetere': ('bedugget',),
'beduggetest': ('bedugget',),
'beduggeteste': ('bedugget',),
'bedyra': ('bedyre',),
'bedyrede': ('bedyre',),
'bedyrende': ('bedyre',),
'bedyret': ('bedyre',),
'bedyrete': ('bedyre',),
'bedyrt': ('bedyre',),
'bedyrte': ('bedyre',),
'bedåra': ('bedåre',),
'bedårede': ('bedåre',),
'bedårende': ('bedåre',),
'bedåret': ('bedåre',),
'bedårete': ('bedåre',),
'bedårende': ('bedårende',),
'bedømmende': ('bedømme',),
'bedømt': ('bedømme',),
'bedømte': ('bedømme',),
'bedøva': ('bedøve',),
'bedøvd': ('bedøve',),
'bedøvde': ('bedøve',),
'bedøvede': ('bedøve',),
'bedøvende': ('bedøve',),
'bedøvet': ('bedøve',),
'bedøvete': ('bedøve',),
'beediga': ('beedige',),
'beedigede': ('beedige',),
'beedigende': ('beedige',),
'beediget': ('beedige',),
'beedigete': ('beedige',),
'befalende': ('befale',),
'befalt': ('befale',),
'befalte': ('befale',),
'befarende': ('befare',),
'befart': ('befare',),
'befarte': ('befare',),
'befaren': ('befaren',),
'befarent': ('befaren',),
'befarne': ('befaren',),
'befarnere': ('befaren',),
'befarnest': ('befaren',),
'befarneste': ('befaren',),
'befatta': ('befatte',),
'befattede': ('befatte',),
'befattende': ('befatte',),
'befattet': ('befatte',),
'befattete': ('befatte',),
'befengt': ('befengt',),
'befengte': ('befengt',),
'befengtere': ('befengt',),
'befengtest': ('befengt',),
'befengteste': ('befengt',),
'beferda': ('beferda',),
'beferdede': ('beferdet',),
'beferdet': ('beferdet',),
'beferdete': ('beferdet',),
'beferdetere': ('beferdet',),
'beferdetest': ('beferdet',),
'beferdeteste': ('beferdet',),
'befesta': ('befeste',),
'befestede': ('befeste',),
'befestende': ('befeste',),
'befestet': ('befeste',),
'befestete': ('befeste',),
'befinnende': ('befinne',),
'befunne': ('befinne',),
'befunnen': ('befinne',),
'befunnet': ('befinne',),
'befippa': ('befippa',),
'befippede': ('befippet',),
'befippet': ('befippet',),
'befippete': ('befippet',),
'befippetere': ('befippet',),
'befippetest': ('befippet',),
'befippeteste': ('befippet',),
'beflitta': ('beflitte',),
'beflittede': ('beflitte',),
'beflittende': ('beflitte',),
'beflittet': ('beflitte',),
'beflittete': ('beflitte',),
'befolka': ('befolke',),
'befolkede': ('befolke',),
'befolkende': ('befolke',),
'befolket': ('befolke',),
'befolkete': ('befolke',),
'befordra': ('befordre',),
'befordrede': ('befordre',),
'befordrende': ('befordre',),
'befordret': ('befordre',),
'befordrete': ('befordre',),
'befrakta': ('befrakte',),
'befraktede': ('befrakte',),
'befraktende': ('befrakte',),
'befraktet': ('befrakte',),
'befraktete': ('befrakte',),
'befridd': ('befri',),
'befridde': ('befri',),
'befriende': ('befri',),
'befriende': ('befriende',),
'befrukta': ('befrukte',),
'befruktede': ('befrukte',),
'befruktende': ('befrukte',),
'befruktet': ('befrukte',),
'befruktete': ('befrukte',),
'befruktningsdyktig': ('befruktningsdyktig',),
'befruktningsdyktige': ('befruktningsdyktig',),
'befruktningsdyktigere': ('befruktningsdyktig',),
'befruktningsdyktigst': ('befruktningsdyktig',),
'befruktningsdyktigste': ('befruktningsdyktig',),
'befruktningshindrende': ('befruktningshindrende',),
'befølende': ('beføle',),
'befølt': ('beføle',),
'befølte': ('beføle',),
'beføya': ('beføya',),
'beføyede': ('beføyet',),
'beføyet': ('beføyet',),
'beføyete': ('beføyet',),
'beføyetere': ('beføyet',),
'beføyetest': ('beføyet',),
'beføyeteste': ('beføyet',),
'begava': ('begava',),
'begavede': ('begavet',),
'begavet': ('begavet',),
'begavete': ('begavet',),
'begavetere': ('begavet',),
'begavetest': ('begavet',),
'begaveteste': ('begavet',),
'begeistra': ('begeistre',),
'begeistrede': ('begeistre',),
'begeistrende': ('begeistre',),
'begeistret': ('begeistre',),
'begeistrete': ('begeistre',),
'begiende': ('begi',),
'begitt': ('begi',),
'begitte': ('begi',),
'begivende': ('begi',),
'begivenhetslaus': ('begivenhetslaus',),
'begivenhetslause': ('begivenhetslaus',),
'begivenhetslausere': ('begivenhetslaus',),
'begivenhetslausest': ('begivenhetslaus',),
'begivenhetslauseste': ('begivenhetslaus',),
'begivenhetslaust': ('begivenhetslaus',),
'begivenhetsløs': ('begivenhetsløs',),
'begivenhetsløse': ('begivenhetsløs',),
'begivenhetsløsere': ('begivenhetsløs',),
'begivenhetsløsest': ('begivenhetsløs',),
'begivenhetsløseste': ('begivenhetsløs',),
'begivenhetsløst': ('begivenhetsløs',),
'begivenhetsrik': ('begivenhetsrik',),
'begivenhetsrike': ('begivenhetsrik',),
'begivenhetsrikere': ('begivenhetsrik',),
'begivenhetsrikest': ('begivenhetsrik',),
'begivenhetsrikeste': ('begivenhetsrik',),
'begivenhetsrikt': ('begivenhetsrik',),
'begjærende': ('begjære',),
'begjært': ('begjære',),
'begjærte': ('begjære',),
'begjærlig': ('begjærlig',),
'begjærlige': ('begjærlig',),
'begjærligere': ('begjærlig',),
'begjærligst': ('begjærlig',),
'begjærligste': ('begjærlig',),
'beglodd': ('beglo',),
'beglodde': ('beglo',),
'begloende': ('beglo',),
'begravd': ('begrave',),
'begravde': ('begrave',),
'begravede': ('begrave',),
'begravende': ('begrave',),
'begravet': ('begrave',),
'begravete': ('begrave',),
'begredelig': ('begredelig',),
'begredelige': ('begredelig',),
'begredeligere': ('begredelig',),
'begredeligst': ('begredelig',),
'begredeligste': ('begredelig',),
'begrensa': ('begrensa',),
'begrensa': ('begrense',),
'begrensede': ('begrense',),
'begrensende': ('begrense',),
'begrenset': ('begrense',),
'begrensete': ('begrense',),
'begrensede': ('begrenset',),
'begrenset': ('begrenset',),
'begrensete': ('begrenset',),
'begrensetere': ('begrenset',),
'begrensetest': ('begrenset',),
'begrenseteste': ('begrenset',),
'begrepsbestemmende': ('begrepsbestemme',),
'begrepsbestemt': ('begrepsbestemme',),
'begrepsbestemte': ('begrepsbestemme',),
'begrepsmessig': ('begrepsmessig',),
'begrepsmessige': ('begrepsmessig',),
'begrepsmessigere': ('begrepsmessig',),
'begrepsmessigst': ('begrepsmessig',),
'begrepsmessigste': ('begrepsmessig',),
'begrepen': ('begripe',),
'begrepet': ('begripe',),
'begrepne': ('begripe',),
'begripende': ('begripe',),
'begripelig': ('begripelig',),
'begripelige': ('begripelig',),
'begripeligere': ('begripelig',),
'begripeligst': ('begripelig',),
'begripeligste': ('begripelig',),
'begrodd': ('begrodd',),
'begrodde': ('begrodd',),
'begroddere': ('begrodd',),
'begroddest': ('begrodd',),
'begroddeste': ('begrodd',),
'begrunna': ('begrunne',),
'begrunnede': ('begrunne',),
'begrunnende': ('begrunne',),
'begrunnet': ('begrunne',),
'begrunnete': ('begrunne',),
'begunstiga': ('begunstige',),
'begunstigede': ('begunstige',),
'begunstigende': ('begunstige',),
'begunstiget': ('begunstige',),
'begunstigete': ('begunstige',),
'begynnende': ('begynne',),
'begynt': ('begynne',),
'begynte': ('begynne',),
'begående': ('begå',),
'begått': ('begå',),
'begåtte': ('begå',),
'behaga': ('behage',),
'behagede': ('behage',),
'behagende': ('behage',),
'behaget': ('behage',),
'behagete': ('behage',),
'behagelig': ('behagelig',),
'behagelige': ('behagelig',),
'behageligere': ('behagelig',),
'behageligst': ('behagelig',),
'behageligste': ('behagelig',),
'behandla': ('behandle',),
'behandlede': ('behandle',),
'behandlende': ('behandle',),
'behandlet': ('behandle',),
'behandlete': ('behandle',),
'behanska': ('behanska',),
'behanskede': ('behansket',),
'behansket': ('behansket',),
'behanskete': ('behansket',),
'behansketere': ('behansket',),
'behansketest': ('behansket',),
'behansketeste': ('behansket',),
'behefta': ('behefte',),
'beheftede': ('behefte',),
'beheftende': ('behefte',),
'beheftet': ('behefte',),
'beheftete': ('behefte',),
'behendig': ('behendig',),
'behendige': ('behendig',),
'behendigere': ('behendig',),
'behendigst': ('behendig',),
'behendigste': ('behendig',),
'behengt': ('behengt',),
'behengte': ('behengt',),
'behengtere': ('behengt',),
'behengtest': ('behengt',),
'behengteste': ('behengt',),
'beherska': ('beherska',),
'beherska': ('beherske',),
'beherskede': ('beherske',),
'beherskende': ('beherske',),
'behersket': ('beherske',),
'beherskete': ('beherske',),
'beherskede': ('behersket',),
'behersket': ('behersket',),
'beherskete': ('behersket',),
'behersketere': ('behersket',),
'behersketest': ('behersket',),
'behersketeste': ('behersket',),
'behjelpelig': ('behjelpelig',),
'behjelpelige': ('behjelpelig',),
'behjelpeligere': ('behjelpelig',),
'behjelpeligst': ('behjelpelig',),
'behjelpeligste': ('behjelpelig',),
'behjerta': ('behjerta',),
'behjertede': ('behjertet',),
'behjertet': ('behjertet',),
'behjertete': ('behjertet',),
'behjertetere': ('behjertet',),
'behjertetest': ('behjertet',),
'behjerteteste': ('behjertet',),
'beholdende': ('beholde',),
'beholdt': ('beholde',),
'beholdte': ('beholde',),
'behåra': ('behåra',),
'behårede': ('behåret',),
'behåret': ('behåret',),
'behårete': ('behåret',),
'behåretere': ('behåret',),
'behåretest': ('behåret',),
'behåreteste': ('behåret',),
'behørig': ('behørig',),
'behørige': ('behørig',),
'behørigere': ('behørig',),
'behørigst': ('behørig',),
'behørigste': ('behørig',),
'behøvd': ('behøve',),
'behøvde': ('behøve',),
'behøvende': ('behøve',),
'beige': ('beige',),
'beigere': ('beige',),
'beigest': ('beige',),
'beigeste': ('beige',),
'beila': ('beile',),
'beilede': ('beile',),
'beilende': ('beile',),
'beilet': ('beile',),
'beilete': ('beile',),
'beilt': ('beile',),
'beilte': ('beile',),
'bein': ('bein',),
'beine': ('bein',),
'beinere': ('bein',),
'beinest': ('bein',),
'beineste': ('bein',),
'beint': ('bein',),
'beina': ('beine',),
'beinede': ('beine',),
'beinende': ('beine',),
'beinet': ('beine',),
'beinete': ('beine',),
'beinet': ('beinet',),
'beinete': ('beinet',),
'beinetere': ('beinet',),
'beinetest': ('beinet',),
'beineteste': ('beinet',),
'beinete': ('beinete',),
'beinflydd': ('beinflyge',),
'beinflydde': ('beinflyge',),
'beinflygende': ('beinflyge',),
'beinfløyen': ('beinflyge',),
'beinfløyet': ('beinflyge',),
'beinfløyne': ('beinflyge',),
'beinhard': ('beinhard',),
'beinharde': ('beinhard',),
'beinhardere': ('beinhard',),
'beinhardest': ('beinhard',),
'beinhardeste': ('beinhard',),
'beinhardt': ('beinhard',),
'beinka': ('beinke',),
'beinkede': ('beinke',),
'beinkende': ('beinke',),
'beinket': ('beinke',),
'beinkete': ('beinke',),
'beinløs': ('beinløs',),
'beinløse': ('beinløs',),
'beinløsere': ('beinløs',),
'beinløsest': ('beinløs',),
'beinløseste': ('beinløs',),
'beinløst': ('beinløs',),
'beintfram': ('beintfram',),
'beintframme': ('beintfram',),
'beintframmere': ('beintfram',),
'beintframmest': ('beintfram',),
'beintframmeste': ('beintfram',),
'beintframt': ('beintfram',),
'beisa': ('beise',),
'beisede': ('beise',),
'beisende': ('beise',),
'beiset': ('beise',),
'beisete': ('beise',),
'beist': ('beise',),
'beiste': ('beise',),
'beisk': ('beisk',),
'beiske': ('beisk',),
'beiskere': ('beisk',),
'beiskest': ('beisk',),
'beiskeste': ('beisk',),
'beiskt': ('beisk',),
'beiskna': ('beiskne',),
'beisknede': ('beiskne',),
'beisknende': ('beiskne',),
'beisknet': ('beiskne',),
'beisknete': ('beiskne',),
'beita': ('beite',),
'beitede': ('beite',),
'beitende': ('beite',),
'beitet': ('beite',),
'beitete': ('beite',),
'beitt': ('beite',),
'beitte': ('beite',),
'bejaa': ('bejae',),
'bejaede': ('bejae',),
'bejaende': ('bejae',),
'bejaet': ('bejae',),
'bejaete': ('bejae',),
'beka': ('beke',),
'bekede': ('beke',),
'bekende': ('beke',),
'beket': ('beke',),
'bekete': ('beke',),
'bekt': ('beke',),
'bekte': ('beke',),
'bekjempa': ('bekjempe',),
'bekjempede': ('bekjempe',),
'bekjempende': ('bekjempe',),
'bekjempet': ('bekjempe',),
'bekjempete': ('bekjempe',),
'bekjennende': ('bekjenne',),
'bekjent': ('bekjenne',),
'bekjente': ('bekjenne',),
'bekjennelseslaus': ('bekjennelseslaus',),
'bekjennelseslause': ('bekjennelseslaus',),
'bekjennelseslausere': ('bekjennelseslaus',),
'bekjennelseslausest': ('bekjennelseslaus',),
'bekjennelseslauseste': ('bekjennelseslaus',),
'bekjennelseslaust': ('bekjennelseslaus',),
'bekjennelsesløs': ('bekjennelsesløs',),
'bekjennelsesløse': ('bekjennelsesløs',),
'bekjennelsesløsere': ('bekjennelsesløs',),
'bekjennelsesløsest': ('bekjennelsesløs',),
'bekjennelsesløseste': ('bekjennelsesløs',),
'bekjennelsesløst': ('bekjennelsesløs',),
'bekjent': ('bekjent',),
'bekjente': ('bekjent',),
'bekjentere': ('bekjent',),
'bekjentest': ('bekjent',),
'bekjenteste': ('bekjent',),
'bekjentgjort': ('bekjentgjøre',),
'bekjentgjorte': ('bekjentgjøre',),
'bekjentgjørende': ('bekjentgjøre',),
'beklaga': ('beklage',),
'beklagd': ('beklage',),
'beklagde': ('beklage',),
'beklagede': ('beklage',),
'beklagende': ('beklage',),
'beklaget': ('beklage',),
'beklagete': ('beklage',),
'beklagelig': ('beklagelig',),
'beklagelige': ('beklagelig',),
'beklageligere': ('beklagelig',),
'beklageligst': ('beklagelig',),
'beklageligste': ('beklagelig',),
'bekledd': ('bekle',),
'bekledde': ('bekle',),
'bekleende': ('bekle',),
'beklemmende': ('beklemmende',),
'beklemt': ('beklemt',),
'beklemte': ('beklemt',),
'beklemtere': ('beklemt',),
'beklemtest': ('beklemt',),
'beklemteste': ('beklemt',),
'beklippa': ('beklippe',),
'beklippede': ('beklippe',),
'beklippende': ('beklippe',),
'beklippet': ('beklippe',),
'beklippete': ('beklippe',),
'beklipt': ('beklippe',),
'beklipte': ('beklippe',),
'bekmørk': ('bekmørk',),
'bekmørke': ('bekmørk',),
'bekmørkere': ('bekmørk',),
'bekmørkest': ('bekmørk',),
'bekmørkeste': ('bekmørk',),
'bekmørkt': ('bekmørk',),
'bekommen': ('bekomme',),
'bekommende': ('bekomme',),
'bekommet': ('bekomme',),
'bekomne': ('bekomme',),
'bekosta': ('bekoste',),
'bekostede': ('bekoste',),
'bekostende': ('bekoste',),
'bekostet': ('bekoste',),
'bekostete': ('bekoste',),
'bekransa': ('bekranse',),
'bekransede': ('bekranse',),
'bekransende': ('bekranse',),
'bekranset': ('bekranse',),
'bekransete': ('bekranse',),
'bekrefta': ('bekrefte',),
'bekreftede': ('bekrefte',),
'bekreftende': ('bekrefte',),
'bekreftet': ('bekrefte',),
'bekreftete': ('bekrefte',),
'bekreftende': ('bekreftende',),
'beksla': ('beksle',),
'bekslede': ('beksle',),
'bekslende': ('beksle',),
'bekslet': ('beksle',),
'bekslete': ('beksle',),
'beksvart': ('beksvart',),
'beksvarte': ('beksvart',),
'beksvartere': ('beksvart',),
'beksvartest': ('beksvart',),
'beksvarteste': ('beksvart',),
'bekvem': ('bekvem',),
'bekvemme': ('bekvem',),
'bekvemmere': ('bekvem',),
'bekvemmest': ('bekvem',),
'bekvemmeste': ('bekvem',),
'bekvemt': ('bekvem',),
'bekvemma': ('bekvemme',),
'bekvemmede': ('bekvemme',),
'bekvemmende': ('bekvemme',),
'bekvemmet': ('bekvemme',),
'bekvemmete': ('bekvemme',),
'bekvemmelig': ('bekvemmelig',),
'bekvemmelige': ('bekvemmelig',),
'bekvemmeligere': ('bekvemmelig',),
'bekvemmeligst': ('bekvemmelig',),
'bekvemmeligste': ('bekvemmelig',),
'bekymra': ('bekymre',),
'bekymrede': ('bekymre',),
'bekymrende': ('bekymre',),
'bekymret': ('bekymre',),
'bekymrete': ('bekymre',),
'bekymringsfull': ('bekymringsfull',),
'bekymringsfulle': ('bekymringsfull',),
'bekymringsfullere': ('bekymringsfull',),
'bekymringsfullest': ('bekymringsfull',),
'bekymringsfulleste': ('bekymringsfull',),
'bekymringsfullt': ('bekymringsfull',),
'bekymringslaus': ('bekymringslaus',),
'bekymringslause': ('bekymringslaus',),
'bekymringslausere': ('bekymringslaus',),
'bekymringslausest': ('bekymringslaus',),
'bekymringslauseste': ('bekymringslaus',),
'bekymringslaust': ('bekymringslaus',),
'bekymringsløs': ('bekymringsløs',),
'bekymringsløse': ('bekymringsløs',),
'bekymringsløsere': ('bekymringsløs',),
'bekymringsløsest': ('bekymringsløs',),
'bekymringsløseste': ('bekymringsløs',),
'bekymringsløst': ('bekymringsløs',),
'belaga': ('belage',),
'belagd': ('belage',),
'belagde': ('belage',),
'belagede': ('belage',),
'belagende': ('belage',),
'belaget': ('belage',),
'belagete': ('belage',),
'belasta': ('belaste',),
'belastede': ('belaste',),
'belastende': ('belaste',),
'belastet': ('belaste',),
'belastete': ('belaste',),
'belagt': ('belegge',),
'belagte': ('belegge',),
'beleggende': ('belegge',),
'beleilig': ('beleilig',),
'beleilige': ('beleilig',),
'beleiligere': ('beleilig',),
'beleiligst': ('beleilig',),
'beleiligste': ('beleilig',),
'beleira': ('beleire',),
'beleirede': ('beleire',),
'beleirende': ('beleire',),
'beleiret': ('beleire',),
'beleirete': ('beleire',),
'belemra': ('belemre',),
'belemrede': ('belemre',),
'belemrende': ('belemre',),
'belemret': ('belemre',),
'belemrete': ('belemre',),
'belessa': ('belesse',),
'belessede': ('belesse',),
'belessende': ('belesse',),
'belesset': ('belesse',),
'belessete': ('belesse',),
'belest': ('belesse',),
'beleste': ('belesse',),
'belest': ('belest',),
'beleste': ('belest',),
'belestere': ('belest',),
'belestest': ('belest',),
'belesteste': ('belest',),
'beleven': ('beleven',),
'belevent': ('beleven',),
'belevne': ('beleven',),
'belevnere': ('beleven',),
'belevnest': ('beleven',),
'belevneste': ('beleven',),
'belgisk': ('belgisk',),
'belgiske': ('belgisk',),
'belgiskere': ('belgisk',),
'belgiskest': ('belgisk',),
'belgiskeste': ('belgisk',),
'belgmørk': ('belgmørk',),
'belgmørke': ('belgmørk',),
'belgmørkere': ('belgmørk',),
'belgmørkest': ('belgmørk',),
'belgmørkeste': ('belgmørk',),
'belgmørkt': ('belgmørk',),
'beliggende': ('beliggende',),
'beliva': ('beliva',),
'belivede': ('belivet',),
'belivet': ('belivet',),
'belivete': ('belivet',),
'belivetere': ('belivet',),
'belivetest': ('belivet',),
'beliveteste': ('belivet',),
'belizisk': ('belizisk',),
'beliziske': ('belizisk',),
'beliziskere': ('belizisk',),
'beliziskest': ('belizisk',),
'beliziskeste': ('belizisk',),
'belja': ('belje',),
'beljede': ('belje',),
'beljende': ('belje',),
'beljet': ('belje',),
'beljete': ('belje',),
'belja': ('belje',),
'beljede': ('belje',),
'beljende': ('belje',),
'beljet': ('belje',),
'beljete': ('belje',),
'belma': ('belme',),
'belmede': ('belme',),
'belmende': ('belme',),
'belmet': ('belme',),
'belmete': ('belme',),
'beltegående': ('beltegående',),
'belysende': ('belyse',),
'belyst': ('belyse',),
'belyste': ('belyse',),
'belånende': ('belåne',),
'belånt': ('belåne',),
'belånte': ('belåne',),
'belærende': ('belære',),
'belært': ('belære',),
'belærte': ('belære',),
'belærende': ('belære',),
'belært': ('belære',),
'belærte': ('belære',),
'belærende': ('belærende',),
'belønna': ('belønne',),
'belønnede': ('belønne',),
'belønnende': ('belønne',),
'belønnet': ('belønne',),
'belønnete': ('belønne',),
'belønt': ('belønne',),
'belønte': ('belønne',),
'beløpende': ('beløpe',),
'beløpet': ('beløpe',),
'beløpt': ('beløpe',),
'beløpte': ('beløpe',),
'bemanna': ('bemanne',),
'bemannede': ('bemanne',),
'bemannende': ('bemanne',),
'bemannet': ('bemanne',),
'bemannete': ('bemanne',),
'bemektiga': ('bemektige',),
'bemektigede': ('bemektige',),
'bemektigende': ('bemektige',),
'bemektiget': ('bemektige',),
'bemektigete': ('bemektige',),
'bemerka': ('bemerke',),
'bemerkede': ('bemerke',),
'bemerkende': ('bemerke',),
'bemerket': ('bemerke',),
'bemerkete': ('bemerke',),
'bemerkelsesverdig': ('bemerkelsesverdig',),
'bemerkelsesverdige': ('bemerkelsesverdig',),
'bemerkelsesverdigere': ('bemerkelsesverdig',),
'bemerkelsesverdigst': ('bemerkelsesverdig',),
'bemerkelsesverdigste': ('bemerkelsesverdig',),
'bemidla': ('bemidla',),
'bemidlede': ('bemidlet',),
'bemidlet': ('bemidlet',),
'bemidlete': ('bemidlet',),
'bemidletere': ('bemidlet',),
'bemidletest': ('bemidlet',),
'bemidleteste': ('bemidlet',),
'bemyndiga': ('bemyndige',),
'bemyndigede': ('bemyndige',),
'bemyndigende': ('bemyndige',),
'bemyndiget': ('bemyndige',),
'bemyndigete': ('bemyndige',),
'bemøya': ('bemøye',),
'bemøyd': ('bemøye',),
'bemøyde': ('bemøye',),
'bemøyede': ('bemøye',),
'bemøyende': ('bemøye',),
'bemøyet': ('bemøye',),
'bemøyete': ('bemøye',),
'ben': ('ben',),
'bene': ('ben',),
'benere': ('ben',),
'benest': ('ben',),
'beneste': ('ben',),
'bent': ('ben',),
'bendende': ('bende',),
'bendt': ('bende',),
'bendte': ('bende',),
'bena': ('bene',),
'benede': ('bene',),
'benende': ('bene',),
'benet': ('bene',),
'benete': ('bene',),
'benefisert': ('benefisert',),
'benefiserte': ('benefisert',),
'benefisertere': ('benefisert',),
'benefisertest': ('benefisert',),
'benefiserteste': ('benefisert',),
'benekta': ('benekte',),
'benektede': ('benekte',),
'benektende': ('benekte',),
'benektet': ('benekte',),
'benektete': ('benekte',),
'benektende': ('benektende',),
'benet': ('benet',),
'benete': ('benet',),
'benetere': ('benet',),
'benetest': ('benet',),
'beneteste': ('benet',),
'benete': ('benete',),
'benevnende': ('benevne',),
'benevnt': ('benevne',),
'benevnte': ('benevne',),
'benevnt': ('benevnt',),
'benevnte': ('benevnt',),
'benevntere': ('benevnt',),
'benevntest': ('benevnt',),
'benevnteste': ('benevnt',),
'bengalsk': ('bengalsk',),
'bengalske': ('bengalsk',),
'bengalskere': ('bengalsk',),
'bengalskest': ('bengalsk',),
'bengalskeste': ('bengalsk',),
'beninsk': ('beninsk',),
'beninske': ('beninsk',),
'beninskere': ('beninsk',),
'beninskest': ('beninsk',),
'beninskeste': ('beninsk',),
'benka': ('benke',),
'benkede': ('benke',),
'benkende': ('benke',),
'benket': ('benke',),
'benkete': ('benke',),
'benka': ('benke',),
'benkede': ('benke',),
'benkende': ('benke',),
'benket': ('benke',),
'benkete': ('benke',),
'benløs': ('benløs',),
'benløse': ('benløs',),
'benløsere': ('benløs',),
'benløsest': ('benløs',),
'benløseste': ('benløs',),
'benløst': ('benløs',),
'bensindrevet': ('bensindrevet',),
'bensindrevne': ('bensindrevet',),
'bensindrevnere': ('bensindrevet',),
'bensindrevnest': ('bensindrevet',),
'bensindrevneste': ('bensindrevet',),
'bentfram': ('bentfram',),
'bentframme': ('bentfram',),
'bentframmere': ('bentfram',),
'bentframmest': ('bentfram',),
'bentframmeste': ('bentfram',),
'bentframt': ('bentfram',),
'bentfrem': ('bentfrem',),
'bentfremme': ('bentfrem',),
'bentfremmere': ('bentfrem',),
'bentfremmest': ('bentfrem',),
'bentfremmeste': ('bentfrem',),
'bentfremt': ('bentfrem',),
'benytta': ('benytte',),
'benyttede': ('benytte',),
'benyttende': ('benytte',),
'benyttet': ('benytte',),
'benyttete': ('benytte',),
'benåda': ('benåde',),
'benådede': ('benåde',),
'benådende': ('benåde',),
'benådet': ('benåde',),
'benådete': ('benåde',),
'beordra': ('beordre',),
'beordrede': ('beordre',),
'beordrende': ('beordre',),
'beordret': ('beordre',),
'beordrete': ('beordre',),
'beplanta': ('beplante',),
'beplantede': ('beplante',),
'beplantende': ('beplante',),
'beplantet': ('beplante',),
'beplantete': ('beplante',),
'beramma': ('beramme',),
'berammede': ('beramme',),
'berammende': ('beramme',),
'berammet': ('beramme',),
'berammete': ('beramme',),
'berbisk': ('berbisk',),
'berbiske': ('berbisk',),
'berbiskere': ('berbisk',),
'berbiskest': ('berbisk',),
'berbiskeste': ('berbisk',),
'beredende': ('berede',),
'beredt': ('berede',),
'beredte': ('berede',),
'beredt': ('beredt',),
'beredte': ('beredt',),
'beredtere': ('beredt',),
'beredtest': ('beredt',),
'beredteste': ('beredt',),
'beredvillig': ('beredvillig',),
'beredvillige': ('beredvillig',),
'beredvilligere': ('beredvillig',),
'beredvilligst': ('beredvillig',),
'beredvilligste': ('beredvillig',),
'beregnbar': ('beregnbar',),
'beregnbare': ('beregnbar',),
'beregnbarere': ('beregnbar',),
'beregnbarest': ('beregnbar',),
'beregnbareste': ('beregnbar',),
'beregnbart': ('beregnbar',),
'beregna': ('beregne',),
'beregnede': ('beregne',),
'beregnende': ('beregne',),
'beregnet': ('beregne',),
'beregnete': ('beregne',),
'beregnelig': ('beregnelig',),
'beregnelige': ('beregnelig',),
'beregneligere': ('beregnelig',),
'beregneligst': ('beregnelig',),
'beregneligste': ('beregnelig',),
'beregnende': ('beregnende',),
'bereist': ('bereist',),
'bereiste': ('bereist',),
'bereistere': ('bereist',),
'bereistest': ('bereist',),
'bereisteste': ('bereist',),
'bereknbar': ('bereknbar',),
'bereknbare': ('bereknbar',),
'bereknbarere': ('bereknbar',),
'bereknbarest': ('bereknbar',),
'bereknbareste': ('bereknbar',),
'bereknbart': ('bereknbar',),
'berekna': ('berekne',),
'bereknede': ('berekne',),
'bereknende': ('berekne',),
'bereknet': ('berekne',),
'bereknete': ('berekne',),
'bereknelig': ('bereknelig',),
'bereknelige': ('bereknelig',),
'berekneligere': ('bereknelig',),
'berekneligst': ('bereknelig',),
'berekneligste': ('bereknelig',),
'bereknende': ('bereknende',),
'beretta': ('berette',),
'berettede': ('berette',),
'berettende': ('berette',),
'berettet': ('berette',),
'berettete': ('berette',),
'berettiga': ('berettige',),
'berettigede': ('berettige',),
'berettigende': ('berettige',),
'berettiget': ('berettige',),
'berettigete': ('berettige',),
'berga': ('berge',),
'bergede': ('berge',),
'bergende': ('berge',),
'berget': ('berge',),
'bergete': ('berge',),
'bergensk': ('bergensk',),
'bergenske': ('bergensk',),
'bergenskere': ('bergensk',),
'bergenskest': ('bergensk',),
'bergenskeste': ('bergensk',),
'bergtakende': ('bergta',),
'bergtatt': ('bergta',),
'bergtatte': ('bergta',),
'berika': ('berike',),
'berikede': ('berike',),
'berikende': ('berike',),
'beriket': ('berike',),
'berikete': ('berike',),
'beriktiga': ('beriktige',),
'beriktigede': ('beriktige',),
'beriktigende': ('beriktige',),
'beriktiget': ('beriktige',),
'beriktigete': ('beriktige',),
'berlinsk': ('berlinsk',),
'berlinske': ('berlinsk',),
'berlinskere': ('berlinsk',),
'berlinskest': ('berlinsk',),
'berlinskeste': ('berlinsk',),
'berodd': ('bero',),
'berodde': ('bero',),
'beroende': ('bero',),
'beroliga': ('berolige',),
'beroligede': ('berolige',),
'beroligende': ('berolige',),
'beroliget': ('berolige',),
'beroligete': ('berolige',),
'beroligende': ('beroligende',),
'berrsynt': ('berrsynt',),
'berrsynte': ('berrsynt',),
'berrsyntere': ('berrsynt',),
'berrsyntest': ('berrsynt',),
'berrsynteste': ('berrsynt',),
'berta': ('berte',),
'bertede': ('berte',),
'bertende': ('berte',),
'bertet': ('berte',),
'bertete': ('berte',),
'berusa': ('berusa',),
'berusa': ('beruse',),
'berusede': ('beruse',),
'berusende': ('beruse',),
'beruset': ('beruse',),
'berusete': ('beruse',),
'berust': ('beruse',),
'beruste': ('beruse',),
'berusede': ('beruset',),
'beruset': ('beruset',),
'berusete': ('beruset',),
'berusetere': ('beruset',),
'berusetest': ('beruset',),
'beruseteste': ('beruset',),
'berykta': ('berykta',),
'beryktede': ('beryktet',),
'beryktet': ('beryktet',),
'beryktete': ('beryktet',),
'beryktetere': ('beryktet',),
'beryktetest': ('beryktet',),
'berykteteste': ('beryktet',),
'berømma': ('berømme',),
'berømmede': ('berømme',),
'berømmende': ('berømme',),
'berømmet': ('berømme',),
'berømmete': ('berømme',),
'berømt': ('berømme',),
'berømte': ('berømme',),
'berømmelig': ('berømmelig',),
'berømmelige': ('berømmelig',),
'berømmeligere': ('berømmelig',),
'berømmeligst': ('berømmelig',),
'berømmeligste': ('berømmelig',),
'berømt': ('berømt',),
'berømte': ('berømt',),
'berømtere': ('berømt',),
'berømtest': ('berømt',),
'berømteste': ('berømt',),
'berørende': ('berøre',),
'berørt': ('berøre',),
'berørte': ('berøre',),
'berøva': ('berøve',),
'berøvd': ('berøve',),
'berøvde': ('berøve',),
'berøvede': ('berøve',),
'berøvende': ('berøve',),
'berøvet': ('berøve',),
'berøvete': ('berøve',),
'besatt': ('besatt',),
'besatte': ('besatt',),
'besattere': ('besatt',),
'besattest': ('besatt',),
'besatteste': ('besatt',),
'beseende': ('bese',),
'besett': ('bese',),
'besette': ('bese',),
'besegla': ('besegle',),
'beseglede': ('besegle',),
'beseglende': ('besegle',),
'beseglet': ('besegle',),
'beseglete': ('besegle',),
'beseira': ('beseire',),
'beseirede': ('beseire',),
'beseirende': ('beseire',),
'beseiret': ('beseire',),
'beseirete': ('beseire',),
'besatt': ('besette',),
'besatte': ('besette',),
'besettende': ('besette',),
'besifra': ('besifre',),
'besifrede': ('besifre',),
'besifrende': ('besifre',),
'besifret': ('besifre',),
'besifrete': ('besifre',),
'besikta': ('besikte',),
'besiktede': ('besikte',),
'besiktende': ('besikte',),
'besiktet': ('besikte',),
'besiktete': ('besikte',),
'besiktiga': ('besiktige',),
'besiktigede': ('besiktige',),
'besiktigende': ('besiktige',),
'besiktiget': ('besiktige',),
'besiktigete': ('besiktige',),
'besindig': ('besindig',),
'besindige': ('besindig',),
'besindigere': ('besindig',),
'besindigst': ('besindig',),
'besindigste': ('besindig',),
'besinna': ('besinne',),
'besinnede': ('besinne',),
'besinnende': ('besinne',),
'besinnet': ('besinne',),
'besinnete': ('besinne',),
'besitne': ('besitte',),
'besitten': ('besitte',),
'besittende': ('besitte',),
'besittet': ('besitte',),
'besjelende': ('besjele',),
'besjelt': ('besjele',),
'besjelte': ('besjele',),
'besk': ('besk',),
'beske': ('besk',),
'beskere': ('besk',),
'beskest': ('besk',),
'beskeste': ('besk',),
'beskt': ('besk',),
'beskadiga': ('beskadige',),
'beskadigede': ('beskadige',),
'beskadigende': ('beskadige',),
'beskadiget': ('beskadige',),
'beskadigete': ('beskadige',),
'beskaffen': ('beskaffen',),
'beskaffent': ('beskaffen',),
'beskafne': ('beskaffen',),
'beskafnere': ('beskaffen',),
'beskafnest': ('beskaffen',),
'beskafneste': ('beskaffen',),
'beskatta': ('beskatte',),
'beskattede': ('beskatte',),
'beskattende': ('beskatte',),
'beskattet': ('beskatte',),
'beskattete': ('beskatte',),
'beskikka': ('beskikke',),
'beskikkede': ('beskikke',),
'beskikkende': ('beskikke',),
'beskikket': ('beskikke',),
'beskikkete': ('beskikke',),
'beskjeden': ('beskjeden',),
'beskjedent': ('beskjeden',),
'beskjedne': ('beskjeden',),
'beskjednere': ('beskjeden',),
'beskjednest': ('beskjeden',),
'beskjedneste': ('beskjeden',),
'beskjeftiga': ('beskjeftige',),
'beskjeftigede': ('beskjeftige',),
'beskjeftigende': ('beskjeftige',),
'beskjeftiget': ('beskjeftige',),
'beskjeftigete': ('beskjeftige',),
'beskjemma': ('beskjemma',),
'beskjemmede': ('beskjemmet',),
'beskjemmet': ('beskjemmet',),
'beskjemmete': ('beskjemmet',),
'beskjemmetere': ('beskjemmet',),
'beskjemmetest': ('beskjemmet',),
'beskjemmeteste': ('beskjemmet',),
'beskjærende': ('beskjære',),
'beskåren': ('beskjære',),
'beskåret': ('beskjære',),
'beskårne': ('beskjære',),
'beskjærende': ('beskjære',),
'beskåren': ('beskjære',),
'beskåret': ('beskjære',),
'beskårne': ('beskjære',),
'beskna': ('beskne',),
'besknede': ('beskne',),
'besknende': ('beskne',),
'besknet': ('beskne',),
'besknete': ('beskne',),
'beskreven': ('beskrive',),
'beskrevet': ('beskrive',),
'beskrevne': ('beskrive',),
'beskrivende': ('beskrive',),
'beskua': ('beskue',),
'beskuede': ('beskue',),
'beskuende': ('beskue',),
'beskuet': ('beskue',),
'beskuete': ('beskue',),
'beskyldende': ('beskylde',),
'beskyldt': ('beskylde',),
'beskyldte': ('beskylde',),
'beskutt': ('beskyte',),
'beskutte': ('beskyte',),
'beskytende': ('beskyte',),
'beskytta': ('beskytte',),
'beskyttede': ('beskytte',),
'beskyttende': ('beskytte',),
'beskyttet': ('beskytte',),
'beskyttete': ('beskytte',),
'beskyttende': ('beskyttende',),
'beslaglagt': ('beslaglegge',),
'beslaglagte': ('beslaglegge',),
'beslagleggende': ('beslaglegge',),
'beslekta': ('beslekta',),
'beslektede': ('beslektet',),
'beslektet': ('beslektet',),
'beslektete': ('beslektet',),
'beslektetere': ('beslektet',),
'beslektetest': ('beslektet',),
'beslekteteste': ('beslektet',),
'beslutningsdyktig': ('beslutningsdyktig',),
'beslutningsdyktige': ('beslutningsdyktig',),
'beslutningsdyktigere': ('beslutningsdyktig',),
'beslutningsdyktigst': ('beslutningsdyktig',),
'beslutningsdyktigste': ('beslutningsdyktig',),
'beslutta': ('beslutte',),
'besluttede': ('beslutte',),
'besluttende': ('beslutte',),
'besluttet': ('beslutte',),
'besluttete': ('beslutte',),
'besluttsom': ('besluttsom',),
'besluttsomme': ('besluttsom',),
'besluttsommere': ('besluttsom',),
'besluttsomst': ('besluttsom',),
'besluttsomste': ('besluttsom',),
'besluttsomt': ('besluttsom',),
'beslående': ('beslå',),
'beslått': ('beslå',),
'beslåtte': ('beslå',),
'besmitta': ('besmitte',),
'besmittede': ('besmitte',),
'besmittende': ('besmitte',),
'besmittet': ('besmitte',),
'besmittete': ('besmitte',),
'besnakka': ('besnakke',),
'besnakkede': ('besnakke',),
'besnakkende': ('besnakke',),
'besnakket': ('besnakke',),
'besnakkete': ('besnakke',),
'besnæra': ('besnære',),
'besnærede': ('besnære',),
'besnærende': ('besnære',),
'besnæret': ('besnære',),
'besnærete': ('besnære',),
'besnært': ('besnære',),
'besnærte': ('besnære',),
'besnærende': ('besnærende',),
'bespisende': ('bespise',),
'bespist': ('bespise',),
'bespiste': ('bespise',),
'bespotta': ('bespotte',),
'bespottede': ('bespotte',),
'bespottende': ('bespotte',),
'bespottet': ('bespotte',),
'bespottete': ('bespotte',),
'bespottelig': ('bespottelig',),
'bespottelige': ('bespottelig',),
'bespotteligere': ('bespottelig',),
'bespotteligst': ('bespottelig',),
'bespotteligste': ('bespottelig',),
'bestandig': ('bestandig',),
'bestandige': ('bestandig',),
'bestandigere': ('bestandig',),
'bestandigst': ('bestandig',),
'bestandigste': ('bestandig',),
'besteborgerlig': ('besteborgerlig',),
'besteborgerlige': ('besteborgerlig',),
'besteborgerligere': ('besteborgerlig',),
'besteborgerligst': ('besteborgerlig',),
'besteborgerligste': ('besteborgerlig',),
'bestemmende': ('bestemme',),
'bestemt': ('bestemme',),
'bestemte': ('bestemme',),
'bestemt': ('bestemt',),
'bestemte': ('bestemt',),
'bestemtere': ('bestemt',),
'bestemtest': ('bestemt',),
'bestemteste': ('bestemt',),
'bestialsk': ('bestialsk',),
'bestialske': ('bestialsk',),
'bestialskere': ('bestialsk',),
'bestialskest': ('bestialsk',),
'bestialskeste': ('bestialsk',),
'bestegen': ('bestige',),
'besteget': ('bestige',),
'bestegne': ('bestige',),
'bestigende': ('bestige',),
'bestikkende': ('bestikke',),
'bestukken': ('bestikke',),
'bestukket': ('bestikke',),
'bestukne': ('bestikke',),
'bestikkelig': ('bestikkelig',),
'bestikkelige': ('bestikkelig',),
'bestikkeligere': ('bestikkelig',),
'bestikkeligst': ('bestikkelig',),
'bestikkeligste': ('bestikkelig',),
'bestillende': ('bestille',),
'bestilt': ('bestille',),
'bestilte': ('bestille',),
'bestjelende': ('bestjele',),
'bestjålen': ('bestjele',),
'bestjålet': ('bestjele',),
'bestjålne': ('bestjele',),
'bestorma': ('bestorme',),
'bestormede': ('bestorme',),
'bestormende': ('bestorme',),
'bestormet': ('bestorme',),
'bestormete': ('bestorme',),
'bestreba': ('bestrebe',),
'bestrebede': ('bestrebe',),
'bestrebende': ('bestrebe',),
'bestrebet': ('bestrebe',),
'bestrebete': ('bestrebe',),
'bestridd': ('bestri',),
'bestridde': ('bestri',),
'bestridt': ('bestri',),
'bestridte': ('bestri',),
'bestriende': ('bestri',),
'bestridd': ('bestride',),
'bestridde': ('bestride',),
'bestridende': ('bestride',),
'bestridt': ('bestride',),
'bestridte': ('bestride',),
'bestrykende': ('bestryke',),
'bestrøken': ('bestryke',),
'bestrøket': ('bestryke',),
'bestrøkne': ('bestryke',),
'bestrålende': ('bestråle',),
'bestrålt': ('bestråle',),
'bestrålte': ('bestråle',),
'bestykka': ('bestykke',),
'bestykkede': ('bestykke',),
'bestykkende': ('bestykke',),
'bestykket': ('bestykke',),
'bestykkete': ('bestykke',),
'bestyrende': ('bestyre',),
'bestyrt': ('bestyre',),
'bestyrte': ('bestyre',),
'bestyrka': ('bestyrke',),
'bestyrkede': ('bestyrke',),
'bestyrkende': ('bestyrke',),
'bestyrket': ('bestyrke',),
'bestyrkete': ('bestyrke',),
'bestyrta': ('bestyrta',),
'bestyrtede': ('bestyrtet',),
'bestyrtet': ('bestyrtet',),
'bestyrtete': ('bestyrtet',),
'bestyrtetere': ('bestyrtet',),
'bestyrtetest': ('bestyrtet',),
'bestyrteteste': ('bestyrtet',),
'bestående': ('bestå',),
'bestått': ('bestå',),
'beståtte': ('bestå',),
'bestøva': ('bestøve',),
'bestøvede': ('bestøve',),
'bestøvende': ('bestøve',),
'bestøvet': ('bestøve',),
'bestøvete': ('bestøve',),
'besudla': ('besudle',),
'besudlede': ('besudle',),
'besudlende': ('besudle',),
'besudlet': ('besudle',),
'besudlete': ('besudle',),
'besvangra': ('besvangre',),
'besvangrede': ('besvangre',),
'besvangrende': ('besvangre',),
'besvangret': ('besvangre',),
'besvangrete': ('besvangre',),
'besvara': ('besvare',),
'besvarende': ('besvare',),
'besvart': ('besvare',),
'besvarte': ('besvare',),
'besverga': ('besverge',),
'besvergede': ('besverge',),
'besvergende': ('besverge',),
'besverget': ('besverge',),
'besvergete': ('besverge',),
'besvoren': ('besverge',),
'besvoret': ('besverge',),
'besvorne': ('besverge',),
'besverja': ('besverje',),
'besverjede': ('besverje',),
'besverjende': ('besverje',),
'besverjet': ('besverje',),
'besverjete': ('besverje',),
'besvoren': ('besverje',),
'besvoret': ('besverje',),
'besvorne': ('besverje',),
'besvimende': ('besvime',),
'besvimt': ('besvime',),
'besvimte': ('besvime',),
'besvogra': ('besvogra',),
'besvogrede': ('besvogret',),
'besvogret': ('besvogret',),
'besvogrete': ('besvogret',),
'besvogretere': ('besvogret',),
'besvogretest': ('besvogret',),
'besvogreteste': ('besvogret',),
'besværa': ('besvære',),
'besværede': ('besvære',),
'besværende': ('besvære',),
'besværet': ('besvære',),
'besværete': ('besvære',),
'besvært': ('besvære',),
'besværte': ('besvære',),
'besværlig': ('besværlig',),
'besværlige': ('besværlig',),
'besværligere': ('besværlig',),
'besværligst': ('besværlig',),
'besværligste': ('besværlig',),
'besynderlig': ('besynderlig',),
'besynderlige': ('besynderlig',),
'besynderligere': ('besynderlig',),
'besynderligst': ('besynderlig',),
'besynderligste': ('besynderlig',),
'besungen': ('besynge',),
'besunget': ('besynge',),
'besungne': ('besynge',),
'besyngende': ('besynge',),
'besådd': ('besådd',),
'besådde': ('besådd',),
'besåddere': ('besådd',),
'besåddest': ('besådd',),
'besåddeste': ('besådd',),
'besøkende': ('besøke',),
'besøkt': ('besøke',),
'besøkte': ('besøke',),
'besørga': ('besørge',),
'besørgede': ('besørge',),
'besørgende': ('besørge',),
'besørget': ('besørge',),
'besørgete': ('besørge',),
'betakende': ('beta',),
'betatt': ('beta',),
'betatte': ('beta',),
'betagende': ('betagende',),
'betakende': ('betakende',),
'betakka': ('betakke',),
'betakkede': ('betakke',),
'betakkende': ('betakke',),
'betakket': ('betakke',),
'betakkete': ('betakke',),
'betalende': ('betale',),
'betalt': ('betale',),
'betalte': ('betale',),
'betalingsdyktig': ('betalingsdyktig',),
'betalingsdyktige': ('betalingsdyktig',),
'betalingsdyktigere': ('betalingsdyktig',),
'betalingsdyktigst': ('betalingsdyktig',),
'betalingsdyktigste': ('betalingsdyktig',),
'betatt': ('betatt',),
'betatte': ('betatt',),
'betattere': ('betatt',),
'betattest': ('betatt',),
'betatteste': ('betatt',),
'betedd': ('bete',),
'betedde': ('bete',),
'beteende': ('bete',),
'betegna': ('betegne',),
'betegnede': ('betegne',),
'betegnende': ('betegne',),
'betegnet': ('betegne',),
'betegnete': ('betegne',),
'betegnende': ('betegnende',),
'betenkende': ('betenke',),
'betenkt': ('betenke',),
'betenkte': ('betenke',),
'betenkelig': ('betenkelig',),
'betenkelige': ('betenkelig',),
'betenkeligere': ('betenkelig',),
'betenkeligst': ('betenkelig',),
'betenkeligste': ('betenkelig',),
'betenksom': ('betenksom',),
'betenksomme': ('betenksom',),
'betenksommere': ('betenksom',),
'betenksomst': ('betenksom',),
'betenksomste': ('betenksom',),
'betenksomt': ('betenksom',),
'betenkt': ('betenkt',),
'betenkte': ('betenkt',),
'betenktere': ('betenkt',),
'betenktest': ('betenkt',),
'betenkteste': ('betenkt',),
'betent': ('betent',),
'betente': ('betent',),
'betentere': ('betent',),
'betentest': ('betent',),
'betenteste': ('betent',),
'betimelig': ('betimelig',),
'betimelige': ('betimelig',),
'betimeligere': ('betimelig',),
'betimeligst': ('betimelig',),
'betimeligste': ('betimelig',),
'betinga': ('betinge',),
'betingede': ('betinge',),
'betingende': ('betinge',),
'betinget': ('betinge',),
'betingete': ('betinge',),
'betingelseslaus': ('betingelseslaus',),
'betingelseslause': ('betingelseslaus',),
'betingelseslausere': ('betingelseslaus',),
'betingelseslausest': ('betingelseslaus',),
'betingelseslauseste': ('betingelseslaus',),
'betingelseslaust': ('betingelseslaus',),
'betingelsesløs': ('betingelsesløs',),
'betingelsesløse': ('betingelsesløs',),
'betingelsesløsere': ('betingelsesløs',),
'betingelsesløsest': ('betingelsesløs',),
'betingelsesløseste': ('betingelsesløs',),
'betingelsesløst': ('betingelsesløs',),
'betjenende': ('betjene',),
'betjent': ('betjene',),
'betjente': ('betjene',),
'betla': ('betle',),
'betlede': ('betle',),
'betlende': ('betle',),
'betlet': ('betle',),
'betlete': ('betle',),
'betona': ('betone',),
'betonede': ('betone',),
'betonende': ('betone',),
'betonet': ('betone',),
'betonete': ('betone',),
'betont': ('betone',),
'betonte': ('betone',),
'betrakta': ('betrakte',),
'betraktede': ('betrakte',),
'betraktende': ('betrakte',),
'betraktet': ('betrakte',),
'betraktete': ('betrakte',),
'betraktelig': ('betraktelig',),
'betraktelige': ('betraktelig',),
'betrakteligere': ('betraktelig',),
'betrakteligst': ('betraktelig',),
'betrakteligste': ('betraktelig',),
'betredende': ('betre',),
'betrådt': ('betre',),
'betrådte': ('betre',),
'betredende': ('betrede',),
'betrådt': ('betrede',),
'betrådte': ('betrede',),
'betrengt': ('betrengt',),
'betrengte': ('betrengt',),
'betrengtere': ('betrengt',),
'betrengtest': ('betrengt',),
'betrengteste': ('betrengt',),
'betrodd': ('betro',),
'betrodde': ('betro',),
'betroende': ('betro',),
'betrodd': ('betrodd',),
'betrodde': ('betrodd',),
'betroddere': ('betrodd',),
'betroddest': ('betrodd',),
'betroddeste': ('betrodd',),
'betryggende': ('betryggende',),
'betutta': ('betutta',),
'betuttede': ('betuttet',),
'betuttet': ('betuttet',),
'betuttete': ('betuttet',),
'betuttetere': ('betuttet',),
'betuttetest': ('betuttet',),
'betutteteste': ('betuttet',),
'betvilende': ('betvile',),
'betvilt': ('betvile',),
'betvilte': ('betvile',),
'betvingende': ('betvinge',),
'betvungen': ('betvinge',),
'betvunget': ('betvinge',),
'betvungne': ('betvinge',),
'betydd': ('bety',),
'betydde': ('bety',),
'betyende': ('bety',),
'betydelig': ('betydelig',),
'betydelige': ('betydelig',),
'betydeligere': ('betydelig',),
'betydeligst': ('betydelig',),
'betydeligste': ('betydelig',),
'betydningsbærende': ('betydningsbærende',),
'betydningsfull': ('betydningsfull',),
'betydningsfulle': ('betydningsfull',),
'betydningsfullere': ('betydningsfull',),
'betydningsfullest': ('betydningsfull',),
'betydningsfulleste': ('betydningsfull',),
'betydningsfullt': ('betydningsfull',),
'betydningslaus': ('betydningslaus',),
'betydningslause': ('betydningslaus',),
'betydningslausere': ('betydningslaus',),
'betydningslausest': ('betydningslaus',),
'betydningslauseste': ('betydningslaus',),
'betydningslaust': ('betydningslaus',),
'betydningsløs': ('betydningsløs',),
'betydningsløse': ('betydningsløs',),
'betydningsløsere': ('betydningsløs',),
'betydningsløsest': ('betydningsløs',),
'betydningsløseste': ('betydningsløs',),
'betydningsløst': ('betydningsløs',),
'betydningsrik': ('betydningsrik',),
'betydningsrike': ('betydningsrik',),
'betydningsrikere': ('betydningsrik',),
'betydningsrikest': ('betydningsrik',),
'betydningsrikeste': ('betydningsrik',),
'betydningsrikt': ('betydningsrik',),
'beundra': ('beundre',),
'beundrede': ('beundre',),
'beundrende': ('beundre',),
'beundret': ('beundre',),
'beundrete': ('beundre',),
'beundringsverdig': ('beundringsverdig',),
'beundringsverdige': ('beundringsverdig',),
'beundringsverdigere': ('beundringsverdig',),
'beundringsverdigst': ('beundringsverdig',),
'beundringsverdigste': ('beundringsverdig',),
'bevandra': ('bevandra',),
'bevandrede': ('bevandret',),
'bevandret': ('bevandret',),
'bevandrete': ('bevandret',),
'bevandretere': ('bevandret',),
'bevandretest': ('bevandret',),
'bevandreteste': ('bevandret',),
'bevarende': ('bevare',),
'bevart': ('bevare',),
'bevarte': ('bevare',),
'bevaringsverdig': ('bevaringsverdig',),
'bevaringsverdige': ('bevaringsverdig',),
'bevaringsverdigere': ('bevaringsverdig',),
'bevaringsverdigst': ('bevaringsverdig',),
'bevaringsverdigste': ('bevaringsverdig',),
'bevart': ('bevart',),
'bevarte': ('bevart',),
'bevartere': ('bevart',),
'bevartest': ('bevart',),
'bevarteste': ('bevart',),
'beva': ('beve',),
'bevd': ('beve',),
'bevde': ('beve',),
'bevede': ('beve',),
'bevende': ('beve',),
'bevet': ('beve',),
'bevete': ('beve',),
'bevega': ('bevege',),
'bevegd': ('bevege',),
'bevegde': ('bevege',),
'bevegede': ('bevege',),
'bevegende': ('bevege',),
'beveget': ('bevege',),
'bevegete': ('bevege',),
'bevegelig': ('bevegelig',),
'bevegelige': ('bevegelig',),
'bevegeligere': ('bevegelig',),
'bevegeligst': ('bevegelig',),
'bevegeligste': ('bevegelig',),
'bevegelseshemma': ('bevegelseshemma',),
'bevegelseshemmede': ('bevegelseshemmet',),
'bevegelseshemmet': ('bevegelseshemmet',),
'bevegelseshemmete': ('bevegelseshemmet',),
'bevegelseshemmetere': ('bevegelseshemmet',),
'bevegelseshemmetest': ('bevegelseshemmet',),
'bevegelseshemmeteste': ('bevegelseshemmet',),
'bevegede': ('beveget',),
'beveget': ('beveget',),
'bevegete': ('beveget',),
'bevegetere': ('beveget',),
'bevegetest': ('beveget',),
'bevegeteste': ('beveget',),
'bevendt': ('bevendt',),
'bevendte': ('bevendt',),
'bevendtere': ('bevendt',),
'bevendtest': ('bevendt',),
'bevendteste': ('bevendt',),
'beverta': ('beverte',),
'bevertede': ('beverte',),
'bevertende': ('beverte',),
'bevertet': ('beverte',),
'bevertete': ('beverte',),
'bevilga': ('bevilge',),
'bevilgede': ('bevilge',),
'bevilgende': ('bevilge',),
'bevilget': ('bevilge',),
'bevilgete': ('bevilge',),
'bevinga': ('bevinga',),
'bevingede': ('bevinget',),
'bevinget': ('bevinget',),
'bevingete': ('bevinget',),
'bevingetere': ('bevinget',),
'bevingetest': ('bevinget',),
'bevingeteste': ('bevinget',),
'bevirka': ('bevirke',),
'bevirkede': ('bevirke',),
'bevirkende': ('bevirke',),
'bevirket': ('bevirke',),
'bevirkete': ('bevirke',),
'bevisende': ('bevise',),
'bevist': ('bevise',),
'beviste': ('bevise',),
'beviselig': ('beviselig',),
'beviselige': ('beviselig',),
'beviseligere': ('beviselig',),
'beviseligst': ('beviselig',),
'beviseligste': ('beviselig',),
'bevislig': ('bevislig',),
'bevislige': ('bevislig',),
'bevisligere': ('bevislig',),
'bevisligst': ('bevislig',),
'bevisligste': ('bevislig',),
'bevisst': ('bevisst',),
'bevisste': ('bevisst',),
'bevisstere': ('bevisst',),
'bevisstest': ('bevisst',),
'bevissteste': ('bevisst',),
'bevisstgjort': ('bevisstgjøre',),
'bevisstgjorte': ('bevisstgjøre',),
'bevisstgjørende': ('bevisstgjøre',),
'bevissthetsutvidende': ('bevissthetsutvidende',),
'bevisstlaus': ('bevisstlaus',),
'bevisstlause': ('bevisstlaus',),
'bevisstlausere': ('bevisstlaus',),
'bevisstlausest': ('bevisstlaus',),
'bevisstlauseste': ('bevisstlaus',),
'bevisstlaust': ('bevisstlaus',),
'bevisstløs': ('bevisstløs',),
'bevisstløse': ('bevisstløs',),
'bevisstløsere': ('bevisstløs',),
'bevisstløsest': ('bevisstløs',),
'bevisstløseste': ('bevisstløs',),
'bevisstløst': ('bevisstløs',),
'bevitna': ('bevitne',),
'bevitnede': ('bevitne',),
'bevitnende': ('bevitne',),
'bevitnet': ('bevitne',),
'bevitnete': ('bevitne',),
'bevokst': ('bevokst',),
'bevokste': ('bevokst',),
'bevokstere': ('bevokst',),
'bevokstest': ('bevokst',),
'bevoksteste': ('bevokst',),
'bevokta': ('bevokte',),
'bevoktede': ('bevokte',),
'bevoktende': ('bevokte',),
'bevoktet': ('bevokte',),
'bevoktete': ('bevokte',),
'bevra': ('bevre',),
'bevrede': ('bevre',),
'bevrende': ('bevre',),
'bevret': ('bevre',),
'bevrete': ('bevre',),
'bevæpna': ('bevæpne',),
'bevæpnede': ('bevæpne',),
'bevæpnende': ('bevæpne',),
'bevæpnet': ('bevæpne',),
'bevæpnete': ('bevæpne',),
'beånda': ('beånde',),
'beåndede': ('beånde',),
'beåndende': ('beånde',),
'beåndet': ('beånde',),
'beåndete': ('beånde',),
'beæra': ('beære',),
'beærede': ('beære',),
'beærende': ('beære',),
'beæret': ('beære',),
'beærete': ('beære',),
'beæra': ('beære',),
'beærede': ('beære',),
'beærende': ('beære',),
'beæret': ('beære',),
'beærete': ('beære',),
'bhutansk': ('bhutansk',),
'bhutanske': ('bhutansk',),
'bhutanskere': ('bhutansk',),
'bhutanskest': ('bhutansk',),
'bhutanskeste': ('bhutansk',),
'biafransk': ('biafransk',),
'biafranske': ('biafransk',),
'biafranskere': ('biafransk',),
'biafranskest': ('biafransk',),
'biafranskeste': ('biafransk',),
'bibeholdende': ('bibeholde',),
'bibeholdt': ('bibeholde',),
'bibeholdte': ('bibeholde',),
'bibelsk': ('bibelsk',),
'bibelske': ('bibelsk',),
'bibelskere': ('bibelsk',),
'bibelskest': ('bibelsk',),
'bibelskeste': ('bibelsk',),
'bibelsprengt': ('bibelsprengt',),
'bibelsprengte': ('bibelsprengt',),
'bibelsprengtere': ('bibelsprengt',),
'bibelsprengtest': ('bibelsprengt',),
'bibelsprengteste': ('bibelsprengt',),
'bibliofil': ('bibliofil',),
'bibliofile': ('bibliofil',),
'bibliofilere': ('bibliofil',),
'bibliofilest': ('bibliofil',),
'bibliofileste': ('bibliofil',),
'bibliofilt': ('bibliofil',),
'bibliografisk': ('bibliografisk',),
'bibliografiske': ('bibliografisk',),
'bibliografiskere': ('bibliografisk',),
'bibliografiskest': ('bibliografisk',),
'bibliografiskeste': ('bibliografisk',),
'bibragt': ('bibringe',),
'bibragte': ('bibringe',),
'bibrakt': ('bibringe',),
'bibrakte': ('bibringe',),
'bibringende': ('bibringe',),
'bidig': ('bidig',),
'bidige': ('bidig',),
'bidigere': ('bidig',),
'bidigst': ('bidig',),
'bidigste': ('bidig',),
'bidradd': ('bidra',),
'bidradde': ('bidra',),
'bidragende': ('bidra',),
'bidratt': ('bidra',),
'bidratte': ('bidra',),
'bia': ('bie',),
'bidd': ('bie',),
'bidde': ('bie',),
'biede': ('bie',),
'biende': ('bie',),
'biet': ('bie',),
'biete': ('bie',),
'biennal': ('biennal',),
'biennale': ('biennal',),
'biennalere': ('biennal',),
'biennalest': ('biennal',),
'biennaleste': ('biennal',),
'biennalt': ('biennal',),
'bifallende': ('bifalle',),
'bifalt': ('bifalle',),
'bifalte': ('bifalle',),
'biff': ('biff',),
'bifil': ('bifil',),
'bifile': ('bifil',),
'bifilere': ('bifil',),
'bifilest': ('bifil',),
'bifileste': ('bifil',),
'bifilt': ('bifil',),
'bifokal': ('bifokal',),
'bifokale': ('bifokal',),
'bifokalere': ('bifokal',),
'bifokalest': ('bifokal',),
'bifokaleste': ('bifokal',),
'bifokalt': ('bifokal',),
'bigott': ('bigott',),
'bigotte': ('bigott',),
'bigottere': ('bigott',),
'bigottest': ('bigott',),
'bigotteste': ('bigott',),
'bikka': ('bikke',),
'bikkede': ('bikke',),
'bikkende': ('bikke',),
'bikket': ('bikke',),
'bikkete': ('bikke',),
'bikkjekald': ('bikkjekald',),
'bikkjekalde': ('bikkjekald',),
'bikkjekaldere': ('bikkjekald',),
'bikkjekaldest': ('bikkjekald',),
'bikkjekaldeste': ('bikkjekald',),
'bikkjekaldt': ('bikkjekald',),
'bikonkav': ('bikonkav',),
'bikonkave': ('bikonkav',),
'bikonkavere': ('bikonkav',),
'bikonkavest': ('bikonkav',),
'bikonkaveste': ('bikonkav',),
'bikonkavt': ('bikonkav',),
'bikonveks': ('bikonveks',),
'bikonvekse': ('bikonveks',),
'bikonveksere': ('bikonveks',),
'bikonveksest': ('bikonveks',),
'bikonvekseste': ('bikonveks',),
'bikonvekst': ('bikonveks',),
'bikta': ('bikte',),
'biktede': ('bikte',),
'biktende': ('bikte',),
'biktet': ('bikte',),
'biktete': ('bikte',),
'bilabial': ('bilabial',),
'bilabiale': ('bilabial',),
'bilabialere': ('bilabial',),
'bilabialest': ('bilabial',),
'bilabialeste': ('bilabial',),
'bilabialt': ('bilabial',),
'bilateral': ('bilateral',),
'bilaterale': ('bilateral',),
'bilateralere': ('bilateral',),
'bilateralest': ('bilateral',),
'bilateraleste': ('bilateral',),
'bilateralt': ('bilateral',),
'bildende': ('bildende',),
'bilderik': ('bilderik',),
'bilderike': ('bilderik',),
'bilderikere': ('bilderik',),
'bilderikest': ('bilderik',),
'bilderikeste': ('bilderik',),
'bilderikt': ('bilderik',),
'bildeskjønn': ('bildeskjønn',),
'bildeskjønne': ('bildeskjønn',),
'bildeskjønnere': ('bildeskjønn',),
'bildeskjønnest': ('bildeskjønn',),
'bildeskjønneste': ('bildeskjønn',),
'bildeskjønt': ('bildeskjønn',),
'bilende': ('bile',),
'bilt': ('bile',),
'bilte': ('bile',),
'bilagt': ('bilegge',),
'bilagte': ('bilegge',),
'bileggende': ('bilegge',),
'bilingv': ('bilingv',),
'bilingve': ('bilingv',),
'bilingvere': ('bilingv',),
'bilingvest': ('bilingv',),
'bilingveste': ('bilingv',),
'bilingval': ('bilingval',),
'bilingvale': ('bilingval',),
'bilingvalere': ('bilingval',),
'bilingvalest': ('bilingval',),
'bilingvaleste': ('bilingval',),
'bilingvalt': ('bilingval',),
'billedlig': ('billedlig',),
'billedlige': ('billedlig',),
'billedligere': ('billedlig',),
'billedligst': ('billedlig',),
'billedligste': ('billedlig',),
'billedrik': ('billedrik',),
'billedrike': ('billedrik',),
'billedrikere': ('billedrik',),
'billedrikest': ('billedrik',),
'billedrikeste': ('billedrik',),
'billedrikt': ('billedrik',),
'billedskjønn': ('billedskjønn',),
'billedskjønne': ('billedskjønn',),
'billedskjønnere': ('billedskjønn',),
'billedskjønnest': ('billedskjønn',),
'billedskjønneste': ('billedskjønn',),
'billedskjønt': ('billedskjønn',),
'billetterende': ('billettere',),
'billettert': ('billettere',),
'billetterte': ('billettere',),
'billig': ('billig',),
'billige': ('billig',),
'billigere': ('billig',),
'billigst': ('billig',),
'billigste': ('billig',),
'billiga': ('billige',),
'billigede': ('billige',),
'billigende': ('billige',),
'billiget': ('billige',),
'billigete': ('billige',),
'billiondels': ('billiondels',),
'billionte': ('billionte',),
'bilsakkyndig': ('bilsakkyndig',),
'bilsakkyndige': ('bilsakkyndig',),
'bilsakkyndigere': ('bilsakkyndig',),
'bilsakkyndigst': ('bilsakkyndig',),
'bilsakkyndigste': ('bilsakkyndig',),
'bilsjuk': ('bilsjuk',),
'bilsjuke': ('bilsjuk',),
'bilsjukere': ('bilsjuk',),
'bilsjukest': ('bilsjuk',),
'bilsjukeste': ('bilsjuk',),
'bilsjukt': ('bilsjuk',),
'bilsyk': ('bilsyk',),
'bilsyke': ('bilsyk',),
'bilsykere': ('bilsyk',),
'bilsykest': ('bilsyk',),
'bilsykeste': ('bilsyk',),
'bilsykt': ('bilsyk',),
'bindende': ('binde',),
'bunden': ('binde',),
'bundet': ('binde',),
'bundne': ('binde',),
'bindegal': ('bindegal',),
'bindegale': ('bindegal',),
'bindegalere': ('bindegal',),
'bindegalest': ('bindegal',),
'bindegaleste': ('bindegal',),
'bindegalt': ('bindegal',),
'bindegalen': ('bindegalen',),
'bindegalent': ('bindegalen',),
'bindegalne': ('bindegalen',),
'bindegalnere': ('bindegalen',),
'bindegalnest': ('bindegalen',),
'bindegalneste': ('bindegalen',),
'bindsterk': ('bindsterk',),
'bindsterke': ('bindsterk',),
'bindsterkere': ('bindsterk',),
'bindsterkest': ('bindsterk',),
'bindsterkeste': ('bindsterk',),
'bindsterkt': ('bindsterk',),
'binokular': ('binokular',),
'binokulare': ('binokular',),
'binokularere': ('binokular',),
'binokularest': ('binokular',),
'binokulareste': ('binokular',),
'binokulart': ('binokular',),
'binokulær': ('binokulær',),
'binokulære': ('binokulær',),
'binokulærere': ('binokulær',),
'binokulærest': ('binokulær',),
'binokulæreste': ('binokulær',),
'binokulært': ('binokulær',),
'binomial': ('binomial',),
'binomiale': ('binomial',),
'binomialere': ('binomial',),
'binomialest': ('binomial',),
'binomialeste': ('binomial',),
'binomialt': ('binomial',),
'binær': ('binær',),
'binære': ('binær',),
'binærere': ('binær',),
'binærest': ('binær',),
'binæreste': ('binær',),
'binært': ('binær',),
'biodynamisk': ('biodynamisk',),
'biodynamiske': ('biodynamisk',),
'biodynamiskere': ('biodynamisk',),
'biodynamiskest': ('biodynamisk',),
'biodynamiskeste': ('biodynamisk',),
'biogeokjemisk': ('biogeokjemisk',),
'biogeokjemiske': ('biogeokjemisk',),
'biogeokjemiskere': ('biogeokjemisk',),
'biogeokjemiskest': ('biogeokjemisk',),
'biogeokjemiskeste': ('biogeokjemisk',),
'biografisk': ('biografisk',),
'biografiske': ('biografisk',),
'biografiskere': ('biografisk',),
'biografiskest': ('biografisk',),
'biografiskeste': ('biografisk',),
'biokjemisk': ('biokjemisk',),
'biokjemiske': ('biokjemisk',),
'biokjemiskere': ('biokjemisk',),
'biokjemiskest': ('biokjemisk',),
'biokjemiskeste': ('biokjemisk',),
'biologisk': ('biologisk',),
'biologiske': ('biologisk',),
'biologiskere': ('biologisk',),
'biologiskest': ('biologisk',),
'biologiskeste': ('biologisk',),
'biotisk': ('biotisk',),
'biotiske': ('biotisk',),
'biotiskere': ('biotisk',),
'biotiskest': ('biotisk',),
'biotiskeste': ('biotisk',),
'bisarr': ('bisarr',),
'bisarre': ('bisarr',),
'bisarrere': ('bisarr',),
'bisarrest': ('bisarr',),
'bisarreste': ('bisarr',),
'bisart': ('bisarr',),
'biseksuell': ('biseksuell',),
'biseksuelle': ('biseksuell',),
'biseksuellere': ('biseksuell',),
'biseksuellest': ('biseksuell',),
'biseksuelleste': ('biseksuell',),
'biseksuelt': ('biseksuell',),
'bisatt': ('bisette',),
'bisatte': ('bisette',),
'bisettende': ('bisette',),
'bisk': ('bisk',),
'biske': ('bisk',),
'biskere': ('bisk',),
'biskest': ('bisk',),
'biskeste': ('bisk',),
'biskt': ('bisk',),
'biskoppelig': ('biskoppelig',),
'biskoppelige': ('biskoppelig',),
'biskoppeligere': ('biskoppelig',),
'biskoppeligst': ('biskoppelig',),
'biskoppeligste': ('biskoppelig',),
'bister': ('bister',),
'bistert': ('bister',),
'bistre': ('bister',),
'bistrere': ('bister',),
'bistrest': ('bister',),
'bistreste': ('bister',),
'bistående': ('bistå',),
'bistått': ('bistå',),
'biståtte': ('bistå',),
'bitende': ('bite',),
'bitt': ('bite',),
'bitte': ('bite',),
'bitende': ('bitende',),
'bitre': ('bitter',),
'bitrere': ('bitter',),
'bitrest': ('bitter',),
'bitreste': ('bitter',),
'bitter': ('bitter',),
'bittert': ('bitter',),
'bitterste': ('bitterste',),
'bittersøt': ('bittersøt',),
'bittersøte': ('bittersøt',),
'bittersøtere': ('bittersøt',),
'bittersøtest': ('bittersøt',),
'bittersøteste': ('bittersøt',),
'bittersøtt': ('bittersøt',),
'bitumiøs': ('bitumiøs',),
'bitumiøse': ('bitumiøs',),
'bitumiøsere': ('bitumiøs',),
'bitumiøsest': ('bitumiøs',),
'bitumiøseste': ('bitumiøs',),
'bitumiøst': ('bitumiøs',),
'bivalent': ('bivalent',),
'bivalente': ('bivalent',),
'bivalentere': ('bivalent',),
'bivalentest': ('bivalent',),
'bivalenteste': ('bivalent',),
'bivuakkerende': ('bivuakkere',),
'bivuakkert': ('bivuakkere',),
'bivuakkerte': ('bivuakkere',),
'bivåna': ('bivåne',),
'bivånede': ('bivåne',),
'bivånende': ('bivåne',),
'bivånet': ('bivåne',),
'bivånete': ('bivåne',),
'bivånt': ('bivåne',),
'bivånte': ('bivåne',),
'bjeffa': ('bjeffe',),
'bjeffede': ('bjeffe',),
'bjeffende': ('bjeffe',),
'bjeffet': ('bjeffe',),
'bjeffete': ('bjeffe',),
'bladd': ('bla',),
'bladde': ('bla',),
'blaende': ('bla',),
'bladtynn': ('bladtynn',),
'bladtynne': ('bladtynn',),
'bladtynnere': ('bladtynn',),
'bladtynnest': ('bladtynn',),
'bladtynneste': ('bladtynn',),
'bladtynt': ('bladtynn',),
'blaffa': ('blaffe',),
'blaffede': ('blaffe',),
'blaffende': ('blaffe',),
'blaffet': ('blaffe',),
'blaffete': ('blaffe',),
'blafra': ('blafre',),
'blafrede': ('blafre',),
'blafrende': ('blafre',),
'blafret': ('blafre',),
'blafrete': ('blafre',),
'blakk': ('blakk',),
'blakke': ('blakk',),
'blakkere': ('blakk',),
'blakkest': ('blakk',),
'blakkeste': ('blakk',),
'blakt': ('blakk',),
'blakka': ('blakke',),
'blakkede': ('blakke',),
'blakkende': ('blakke',),
'blakket': ('blakke',),
'blakkete': ('blakke',),
'blakna': ('blakne',),
'blaknede': ('blakne',),
'blaknende': ('blakne',),
'blaknet': ('blakne',),
'blaknete': ('blakne',),
'blakra': ('blakre',),
'blakrede': ('blakre',),
'blakrende': ('blakre',),
'blakret': ('blakre',),
'blakrete': ('blakre',),
'blamerende': ('blamere',),
'blamert': ('blamere',),
'blamerte': ('blamere',),
'blanda': ('blande',),
'blandede': ('blande',),
'blandende': ('blande',),
'blandet': ('blande',),
'blandete': ('blande',),
'blank': ('blank',),
'blanke': ('blank',),
'blankere': ('blank',),
'blankest': ('blank',),
'blankeste': ('blank',),
'blankt': ('blank',),
'blanka': ('blanke',),
'blankede': ('blanke',),
'blankende': ('blanke',),
'blanket': ('blanke',),
'blankete': ('blanke',),
'blankpussa': ('blankpusse',),
'blankpussede': ('blankpusse',),
'blankpussende': ('blankpusse',),
'blankpusset': ('blankpusse',),
'blankpussete': ('blankpusse',),
'blankslitende': ('blankslite',),
'blankslitt': ('blankslite',),
'blankslitte': ('blankslite',),
'blankøyd': ('blankøyd',),
'blankøyde': ('blankøyd',),
'blankøydere': ('blankøyd',),
'blankøydest': ('blankøyd',),
'blankøydeste': ('blankøyd',),
'blasert': ('blasert',),
'blaserte': ('blasert',),
'blasertere': ('blasert',),
'blasertest': ('blasert',),
'blaserteste': ('blasert',),
'blasfemisk': ('blasfemisk',),
'blasfemiske': ('blasfemisk',),
'blasfemiskere': ('blasfemisk',),
'blasfemiskest': ('blasfemisk',),
'blasfemiskeste': ('blasfemisk',),
'blasonerende': ('blasonere',),
'blasonert': ('blasonere',),
'blasonerte': ('blasonere',),
'blass': ('blass',),
'blasse': ('blass',),
'blassere': ('blass',),
'blassest': ('blass',),
'blasseste': ('blass',),
'blast': ('blass',),
'blaut': ('blaut',),
'blaute': ('blaut',),
'blautere': ('blaut',),
'blautest': ('blaut',),
'blauteste': ('blaut',),
'blautt': ('blaut',),
'blautgjort': ('blautgjøre',),
'blautgjorte': ('blautgjøre',),
'blautgjørende': ('blautgjøre',),
'blauthjertede': ('blauthjertet',),
'blauthjertet': ('blauthjertet',),
'blauthjertete': ('blauthjertet',),
'blauthjertetere': ('blauthjertet',),
'blauthjertetest': ('blauthjertet',),
'blauthjerteteste': ('blauthjertet',),
'blautkokende': ('blautkoke',),
'blautkokt': ('blautkoke',),
'blautkokte': ('blautkoke',),
'blautlendt': ('blautlendt',),
'blautlendte': ('blautlendt',),
'blautlendtere': ('blautlendt',),
'blautlendtest': ('blautlendt',),
'blautlendteste': ('blautlendt',),
'bleigd': ('bleige',),
'bleigde': ('bleige',),
'bleigende': ('bleige',),
'bleik': ('bleik',),
'bleike': ('bleik',),
'bleikere': ('bleik',),
'bleikest': ('bleik',),
'bleikeste': ('bleik',),
'bleikt': ('bleik',),
'bleikblå': ('bleikblå',),
'bleikblåe': ('bleikblå',),
'bleikblåere': ('bleikblå',),
'bleikblåest': ('bleikblå',),
'bleikblåeste': ('bleikblå',),
'bleikblått': ('bleikblå',),
'bleikbrun': ('bleikbrun',),
'bleikbrune': ('bleikbrun',),
'bleikbrunere': ('bleikbrun',),
'bleikbrunest': ('bleikbrun',),
'bleikbruneste': ('bleikbrun',),
'bleikbrunt': ('bleikbrun',),
'bleika': ('bleike',),
'bleikede': ('bleike',),
'bleikende': ('bleike',),
'bleiket': ('bleike',),
'bleikete': ('bleike',),
'bleikt': ('bleike',),
'bleikte': ('bleike',),
'bleikfeit': ('bleikfeit',),
'bleikfeite': ('bleikfeit',),
'bleikfeitere': ('bleikfeit',),
'bleikfeitest': ('bleikfeit',),
'bleikfeiteste': ('bleikfeit',),
'bleikfeitt': ('bleikfeit',),
'bleikfett': ('bleikfeit',),
'bleikna': ('bleikne',),
'bleiknede': ('bleikne',),
'bleiknende': ('bleikne',),
'bleiknet': ('bleikne',),
'bleiknete': ('bleikne',),
'bleiknebba': ('bleiknebba',),
'bleiknebbede': ('bleiknebbet',),
'bleiknebbet': ('bleiknebbet',),
'bleiknebbete': ('bleiknebbet',),
'bleiknebbetere': ('bleiknebbet',),
'bleiknebbetest': ('bleiknebbet',),
'bleiknebbeteste': ('bleiknebbet',),
'blek': ('blek',),
'bleke': ('blek',),
'blekere': ('blek',),
'blekest': ('blek',),
'blekeste': ('blek',),
'blekt': ('blek',),
'blekblå': ('blekblå',),
'blekblåe': ('blekblå',),
'blekblåere': ('blekblå',),
'blekblåest': ('blekblå',),
'blekblåeste': ('blekblå',),
'blekblått': ('blekblå',),
'blekbrun': ('blekbrun',),
'blekbrune': ('blekbrun',),
'blekbrunere': ('blekbrun',),
'blekbrunest': ('blekbrun',),
'blekbruneste': ('blekbrun',),
'blekbrunt': ('blekbrun',),
'bleka': ('bleke',),
'blekede': ('bleke',),
'blekende': ('bleke',),
'bleket': ('bleke',),
'blekete': ('bleke',),
'blekt': ('bleke',),
'blekte': ('bleke',),
'blekfet': ('blekfet',),
'blekfete': ('blekfet',),
'blekfetere': ('blekfet',),
'blekfetest': ('blekfet',),
'blekfeteste': ('blekfet',),
'blekfett': ('blekfet',),
'blekka': ('blekke',),
'blekkede': ('blekke',),
'blekkende': ('blekke',),
'blekket': ('blekke',),
'blekkete': ('blekke',),
'blekkende': ('blekke',),
'blekt': ('blekke',),
'blekte': ('blekke',),
'blekket': ('blekket',),
'blekkete': ('blekket',),
'blekketere': ('blekket',),
'blekketest': ('blekket',),
'blekketeste': ('blekket',),
'blekkete': ('blekkete',),
'blekna': ('blekne',),
'bleknede': ('blekne',),
'bleknende': ('blekne',),
'bleknet': ('blekne',),
'bleknete': ('blekne',),
'blemmet': ('blemmet',),
'blemmete': ('blemmet',),
'blemmetere': ('blemmet',),
'blemmetest': ('blemmet',),
'blemmeteste': ('blemmet',),
'blemmete': ('blemmete',),
'blenda': ('blende',),
'blendede': ('blende',),
'blendende': ('blende',),
'blendet': ('blende',),
'blendete': ('blende',),
'blendende': ('blendende',),
'blivende': ('bli',),
'blitt': ('bli',),
'blitte': ('bli',),
'blivende': ('bli',),
'blid': ('blid',),
'blide': ('blid',),
'blidere': ('blid',),
'blidest': ('blid',),
'blideste': ('blid',),
'blidt': ('blid',),
'blidgjort': ('blidgjøre',),
'blidgjorte': ('blidgjøre',),
'blidgjørende': ('blidgjøre',),
'blidlåten': ('blidlåten',),
'blidlåtent': ('blidlåten',),
'blidlåtne': ('blidlåten',),
'blidlåtnere': ('blidlåten',),
'blidlåtnest': ('blidlåten',),
'blidlåtneste': ('blidlåten',),
'blikkstille': ('blikkstille',),
'blind': ('blind',),
'blinde': ('blind',),
'blindere': ('blind',),
'blindest': ('blind',),
'blindeste': ('blind',),
'blindt': ('blind',),
'blinda': ('blinde',),
'blindede': ('blinde',),
'blindende': ('blinde',),
'blindet': ('blinde',),
'blindete': ('blinde',),
'blingsa': ('blingse',),
'blingsede': ('blingse',),
'blingsende': ('blingse',),
'blingset': ('blingse',),
'blingsete': ('blingse',),
'blingset': ('blingset',),
'blingsete': ('blingset',),
'blingsetere': ('blingset',),
'blingsetest': ('blingset',),
'blingseteste': ('blingset',),
'blingsete': ('blingsete',),
'blinka': ('blinke',),
'blinkede': ('blinke',),
'blinkende': ('blinke',),
'blinket': ('blinke',),
'blinkete': ('blinke',),
'blinka': ('blinke',),
'blinkede': ('blinke',),
'blinkende': ('blinke',),
'blinket': ('blinke',),
'blinkete': ('blinke',),
'blitsa': ('blitse',),
'blitsede': ('blitse',),
'blitsende': ('blitse',),
'blitset': ('blitse',),
'blitsete': ('blitse',),
'blitt': ('blive',),
'blitte': ('blive',),
'blivende': ('blive',),
'blivende': ('blivende',),
'bloddryppende': ('bloddryppende',),
'blodet': ('blodet',),
'blodete': ('blodet',),
'blodetere': ('blodet',),
'blodetest': ('blodet',),
'blodeteste': ('blodet',),
'blodete': ('blodete',),
'blodfattig': ('blodfattig',),
'blodfattige': ('blodfattig',),
'blodfattigere': ('blodfattig',),
'blodfattigst': ('blodfattig',),
'blodfattigste': ('blodfattig',),
'blodfersk': ('blodfersk',),
'blodferske': ('blodfersk',),
'blodferskere': ('blodfersk',),
'blodferskest': ('blodfersk',),
'blodferskeste': ('blodfersk',),
'blodferskt': ('blodfersk',),
'blodfull': ('blodfull',),
'blodfulle': ('blodfull',),
'blodfullere': ('blodfull',),
'blodfullest': ('blodfull',),
'blodfulleste': ('blodfull',),
'blodfullt': ('blodfull',),
'blodig': ('blodig',),
'blodige': ('blodig',),
'blodigere': ('blodig',),
'blodigst': ('blodig',),
'blodigste': ('blodig',),
'blodrød': ('blodrød',),
'blodrøde': ('blodrød',),
'blodrødere': ('blodrød',),
'blodrødest': ('blodrød',),
'blodrødeste': ('blodrød',),
'blodrødt': ('blodrød',),
'blodskutt': ('blodskutt',),
'blodskutte': ('blodskutt',),
'blodskuttere': ('blodskutt',),
'blodskuttest': ('blodskutt',),
'blodskutteste': ('blodskutt',),
'blodsprengt': ('blodsprengt',),
'blodsprengte': ('blodsprengt',),
'blodsprengtere': ('blodsprengt',),
'blodsprengtest': ('blodsprengt',),
'blodsprengteste': ('blodsprengt',),
'blodstillende': ('blodstillende',),
'blodtørstig': ('blodtørstig',),
'blodtørstige': ('blodtørstig',),
'blodtørstigere': ('blodtørstig',),
'blodtørstigst': ('blodtørstig',),
'blodtørstigste': ('blodtørstig',),
'blodunderløpen': ('blodunderløpen',),
'blodunderløpent': ('blodunderløpen',),
'blodunderløpne': ('blodunderløpen',),
'blodunderløpnere': ('blodunderløpen',),
'blodunderløpnest': ('blodunderløpen',),
'blodunderløpneste': ('blodunderløpen',),
'blogga': ('blogge',),
'bloggede': ('blogge',),
'bloggende': ('blogge',),
'blogget': ('blogge',),
'bloggete': ('blogge',),
'blokka': ('blokke',),
'blokkede': ('blokke',),
'blokkende': ('blokke',),
'blokket': ('blokke',),
'blokkete': ('blokke',),
'blokkerende': ('blokkere',),
'blokkert': ('blokkere',),
'blokkerte': ('blokkere',),
'blomstra': ('blomstre',),
'blomstrede': ('blomstre',),
'blomstrende': ('blomstre',),
'blomstret': ('blomstre',),
'blomstrete': ('blomstre',),
'blomstrende': ('blomstrende',),
'blomstret': ('blomstret',),
'blomstrete': ('blomstret',),
'blomstretere': ('blomstret',),
'blomstretest': ('blomstret',),
'blomstreteste': ('blomstret',),
'blomstrete': ('blomstrete',),
'blond': ('blond',),
'blonde': ('blond',),
'blondere': ('blond',),
'blondest': ('blond',),
'blondeste': ('blond',),
'blondt': ('blond',),
'blota': ('blote',),
'blotede': ('blote',),
'blotende': ('blote',),
'blotet': ('blote',),
'blotete': ('blote',),
'blott': ('blott',),
'blotte': ('blott',),
'blottere': ('blott',),
'blottest': ('blott',),
'blotteste': ('blott',),
'blotta': ('blotte',),
'blottede': ('blotte',),
'blottende': ('blotte',),
'blottet': ('blotte',),
'blottete': ('blotte',),
'blottlagt': ('blottlegge',),
'blottlagte': ('blottlegge',),
'blottleggende': ('blottlegge',),
'blottstillende': ('blottstille',),
'blottstilt': ('blottstille',),
'blottstilte': ('blottstille',),
'bluferdig': ('bluferdig',),
'bluferdige': ('bluferdig',),
'bluferdigere': ('bluferdig',),
'bluferdigst': ('bluferdig',),
'bluferdigste': ('bluferdig',),
'blunda': ('blunde',),
'blundede': ('blunde',),
'blundende': ('blunde',),
'blundet': ('blunde',),
'blundete': ('blunde',),
'blunka': ('blunke',),
'blunkede': ('blunke',),
'blunkende': ('blunke',),
'blunket': ('blunke',),
'blunkete': ('blunke',),
'blussa': ('blusse',),
'blussede': ('blusse',),
'blussende': ('blusse',),
'blusset': ('blusse',),
'blussete': ('blusse',),
'blussende': ('blussende',),
'blyg': ('blyg',),
'blyge': ('blyg',),
'blygere': ('blyg',),
'blygest': ('blyg',),
'blygeste': ('blyg',),
'blygt': ('blyg',),
'blygrå': ('blygrå',),
'blygråe': ('blygrå',),
'blygråere': ('blygrå',),
'blygråest': ('blygrå',),
'blygråeste': ('blygrå',),
'blygrått': ('blygrå',),
'blyholdig': ('blyholdig',),
'blyholdige': ('blyholdig',),
'blyholdigere': ('blyholdig',),
'blyholdigst': ('blyholdig',),
'blyholdigste': ('blyholdig',),
'blytung': ('blytung',),
'blytunge': ('blytung',),
'blytungere': ('blytung',),
'blytungest': ('blytung',),
'blytungeste': ('blytung',),
'blytungt': ('blytung',),
'blytyngre': ('blytung',),
'blytyngst': ('blytung',),
'blytyngste': ('blytung',),
'blå': ('blå',),
'blåe': ('blå',),
'blåere': ('blå',),
'blåest': ('blå',),
'blåeste': ('blå',),
'blått': ('blå',),
'blåfiolett': ('blåfiolett',),
'blåfiolette': ('blåfiolett',),
'blåfiolettere': ('blåfiolett',),
'blåfiolettest': ('blåfiolett',),
'blåfioletteste': ('blåfiolett',),
'blåfrosne': ('blåfrossen',),
'blåfrosnere': ('blåfrossen',),
'blåfrosnest': ('blåfrossen',),
'blåfrosneste': ('blåfrossen',),
'blåfrossen': ('blåfrossen',),
'blåfrossent': ('blåfrossen',),
'blåfrosset': ('blåfrossen',),
'blåfrosne': ('blåfrosset',),
'blåfrosnere': ('blåfrosset',),
'blåfrosnest': ('blåfrosset',),
'blåfrosneste': ('blåfrosset',),
'blåfrosset': ('blåfrosset',),
'blågul': ('blågul',),
'blågule': ('blågul',),
'blågulere': ('blågul',),
'blågulest': ('blågul',),
'blåguleste': ('blågul',),
'blågult': ('blågul',),
'blåhard': ('blåhard',),
'blåharde': ('blåhard',),
'blåhardere': ('blåhard',),
'blåhardest': ('blåhard',),
'blåhardeste': ('blåhard',),
'blåhardt': ('blåhard',),
'blåholdende': ('blåholde',),
'blåholdt': ('blåholde',),
'blåholdte': ('blåholde',),
'blålig': ('blålig',),
'blålige': ('blålig',),
'blåligere': ('blålig',),
'blåligst': ('blålig',),
'blåligste': ('blålig',),
'blåna': ('blåne',),
'blånede': ('blåne',),
'blånende': ('blåne',),
'blånet': ('blåne',),
'blånete': ('blåne',),
'blånt': ('blåne',),
'blånte': ('blåne',),
'blånekta': ('blånekte',),
'blånektede': ('blånekte',),
'blånektende': ('blånekte',),
'blånektet': ('blånekte',),
'blånektete': ('blånekte',),
'blånøye': ('blånøye',),
'blåsende': ('blåse',),
'blåst': ('blåse',),
'blåste': ('blåse',),
'blåsur': ('blåsur',),
'blåsure': ('blåsur',),
'blåsurere': ('blåsur',),
'blåsurest': ('blåsur',),
'blåsureste': ('blåsur',),
'blåsurt': ('blåsur',),
'blåøyd': ('blåøyd',),
'blåøyde': ('blåøyd',),
'blåøydere': ('blåøyd',),
'blåøydest': ('blåøyd',),
'blåøydeste': ('blåøyd',),
'blæra': ('blære',),
'blærede': ('blære',),
'blærende': ('blære',),
'blæret': ('blære',),
'blærete': ('blære',),
'blæret': ('blæret',),
'blærete': ('blæret',),
'blæretere': ('blæret',),
'blæretest': ('blæret',),
'blæreteste': ('blæret',),
'blærete': ('blærete',),
'blødd': ('blø',),
'blødde': ('blø',),
'bløende': ('blø',),
'blødd': ('bløde',),
'blødde': ('bløde',),
'blødende': ('bløde',),
'bløffa': ('bløffe',),
'bløffede': ('bløffe',),
'bløffende': ('bløffe',),
'bløffet': ('bløffe',),
'bløffete': ('bløffe',),
'bløgga': ('bløgge',),
'bløggede': ('bløgge',),
'bløggende': ('bløgge',),
'bløgget': ('bløgge',),
'bløggete': ('bløgge',),
'bløt': ('bløt',),
'bløte': ('bløt',),
'bløtere': ('bløt',),
'bløtest': ('bløt',),
'bløteste': ('bløt',),
'bløtt': ('bløt',),
'bløtaktig': ('bløtaktig',),
'bløtaktige': ('bløtaktig',),
'bløtaktigere': ('bløtaktig',),
'bløtaktigst': ('bløtaktig',),
'bløtaktigste': ('bløtaktig',),
'bløtende': ('bløte',),
'bløtt': ('bløte',),
'bløtte': ('bløte',),
'bløtgjort': ('bløtgjøre',),
'bløtgjorte': ('bløtgjøre',),
'bløtgjørende': ('bløtgjøre',),
'bløthjerta': ('bløthjerta',),
'bløthjertede': ('bløthjertet',),
'bløthjertet': ('bløthjertet',),
'bløthjertete': ('bløthjertet',),
'bløthjertetere': ('bløthjertet',),
'bløthjertetest': ('bløthjertet',),
'bløthjerteteste': ('bløthjertet',),
'bløtkokende': ('bløtkoke',),
'bløtkokt': ('bløtkoke',),
'bløtkokte': ('bløtkoke',),
'bløtlagt': ('bløtlegge',),
'bløtlagte': ('bløtlegge',),
'bløtleggende': ('bløtlegge',),
'bløtt': ('bløyte',),
'bløtte': ('bløyte',),
'bløytende': ('bløyte',),
'bløytt': ('bløyte',),
'bløytte': ('bløyte',),
'bløytlagt': ('bløytlegge',),
'bløytlagte': ('bløytlegge',),
'bløytleggende': ('bløytlegge',),
'bodd': ('bo',),
'bodde': ('bo',),
'boende': ('bo',),
'bobla': ('boble',),
'boblede': ('boble',),
'boblende': ('boble',),
'boblet': ('boble',),
'boblete': ('boble',),
'bofast': ('bofast',),
'bofaste': ('bofast',),
'bofastere': ('bofast',),
'bofastest': ('bofast',),
'bofasteste': ('bofast',),
'boga': ('boge',),
'bogede': ('boge',),
'bogende': ('boge',),
'boget': ('boge',),
'bogete': ('boge',),
'bogeforma': ('bogeforma',),
'bogeformede': ('bogeformet',),
'bogeformet': ('bogeformet',),
'bogeformete': ('bogeformet',),
'bogeformetere': ('bogeformet',),
'bogeformetest': ('bogeformet',),
'bogeformeteste': ('bogeformet',),
'bogna': ('bogne',),
'bognede': ('bogne',),
'bognende': ('bogne',),
'bognet': ('bogne',),
'bognete': ('bogne',),
'boikotta': ('boikotte',),
'boikottede': ('boikotte',),
'boikottende': ('boikotte',),
'boikottet': ('boikotte',),
'boikottete': ('boikotte',),
'bokførende': ('bokføre',),
'bokført': ('bokføre',),
'bokførte': ('bokføre',),
'boklig': ('boklig',),
'boklige': ('boklig',),
'bokligere': ('boklig',),
'bokligst': ('boklig',),
'bokligste': ('boklig',),
'bokna': ('bokne',),
'boknede': ('bokne',),
'boknende': ('bokne',),
'boknet': ('bokne',),
'boknete': ('bokne',),
'boksa': ('bokse',),
'boksede': ('bokse',),
'boksende': ('bokse',),
'bokset': ('bokse',),
'boksete': ('bokse',),
'bokstavelig': ('bokstavelig',),
'bokstavelige': ('bokstavelig',),
'bokstaveligere': ('bokstavelig',),
'bokstaveligst': ('bokstavelig',),
'bokstaveligste': ('bokstavelig',),
'bokstaverende': ('bokstavere',),
'bokstavert': ('bokstavere',),
'bokstaverte': ('bokstavere',),
'bokstavrett': ('bokstavrett',),
'bokstavrette': ('bokstavrett',),
'bokstavrettere': ('bokstavrett',),
'bokstavrettest': ('bokstavrett',),
'bokstavretteste': ('bokstavrett',),
'bold': ('bold',),
'bolde': ('bold',),
'boldere': ('bold',),
'boldest': ('bold',),
'boldeste': ('bold',),
'boldt': ('bold',),
'bola': ('bole',),
'bolede': ('bole',),
'bolende': ('bole',),
'bolet': ('bole',),
'bolete': ('bole',),
'bolt': ('bole',),
'bolte': ('bole',),
'boligsøkende': ('boligsøkende',),
'boliviansk': ('boliviansk',),
'bolivianske': ('boliviansk',),
'bolivianskere': ('boliviansk',),
'bolivianskest': ('boliviansk',),
'bolivianskeste': ('boliviansk',),
'bolna': ('bolne',),
'bolnede': ('bolne',),
'bolnende': ('bolne',),
'bolnet': ('bolne',),
'bolnete': ('bolne',),
'bolta': ('bolte',),
'boltede': ('bolte',),
'boltende': ('bolte',),
'boltet': ('bolte',),
'boltete': ('bolte',),
'boltra': ('boltre',),
'boltrede': ('boltre',),
'boltrende': ('boltre',),
'boltret': ('boltre',),
'boltrete': ('boltre',),
'bombarderende': ('bombardere',),
'bombardert': ('bombardere',),
'bombarderte': ('bombardere',),
'bombastisk': ('bombastisk',),
'bombastiske': ('bombastisk',),
'bombastiskere': ('bombastisk',),
'bombastiskest': ('bombastisk',),
'bombastiskeste': ('bombastisk',),
'bomba': ('bombe',),
'bombede': ('bombe',),
'bombende': ('bombe',),
'bombet': ('bombe',),
'bombete': ('bombe',),
'bombesikker': ('bombesikker',),
'bombesikkert': ('bombesikker',),
'bombesikre': ('bombesikker',),
'bombesikrere': ('bombesikker',),
'bombesikrest': ('bombesikker',),
'bombesikreste': ('bombesikker',),
'bomfast': ('bomfast',),
'bomfaste': ('bomfast',),
'bomfastere': ('bomfast',),
'bomfastest': ('bomfast',),
'bomfasteste': ('bomfast',),
'bomma': ('bomme',),
'bommede': ('bomme',),
'bommende': ('bomme',),
'bommet': ('bomme',),
'bommete': ('bomme',),
'bomma': ('bomme',),
'bommede': ('bomme',),
'bommende': ('bomme',),
'bommet': ('bomme',),
'bommete': ('bomme',),
'bomma': ('bomme',),
'bommede': ('bomme',),
'bommende': ('bomme',),
'bommet': ('bomme',),
'bommete': ('bomme',),
'bomsterk': ('bomsterk',),
'bomsterke': ('bomsterk',),
'bomsterkere': ('bomsterk',),
'bomsterkest': ('bomsterk',),
'bomsterkeste': ('bomsterk',),
'bomsterkt': ('bomsterk',),
'bomstille': ('bomstille',),
'bondeblå': ('bondeblå',),
'bondeblåe': ('bondeblå',),
'bondeblåere': ('bondeblå',),
'bondeblåest': ('bondeblå',),
'bondeblåeste': ('bondeblå',),
'bondeblått': ('bondeblå',),
'bondsk': ('bondsk',),
'bondske': ('bondsk',),
'bondskere': ('bondsk',),
'bondskest': ('bondsk',),
'bondskeste': ('bondsk',),
'bona': ('bone',),
'bonede': ('bone',),
'bonende': ('bone',),
'bonet': ('bone',),
'bonete': ('bone',),
'bont': ('bone',),
'bonte': ('bone',),
'bonga': ('bonge',),
'bongede': ('bonge',),
'bongende': ('bonge',),
'bonget': ('bonge',),
'bongete': ('bonge',),
'boniterende': ('bonitere',),
'bonitert': ('bonitere',),
'boniterte': ('bonitere',),
'booka': ('booke',),
'bookede': ('booke',),
'bookende': ('booke',),
'booket': ('booke',),
'bookete': ('booke',),
'boolsk': ('boolsk',),
'boolske': ('boolsk',),
'boolskere': ('boolsk',),
'boolskest': ('boolsk',),
'boolskeste': ('boolsk',),
'borda': ('borde',),
'bordede': ('borde',),
'bordende': ('borde',),
'bordet': ('borde',),
'bordete': ('borde',),
'bordkledd': ('bordkle',),
'bordkledde': ('bordkle',),
'bordkleende': ('bordkle',),
'bora': ('bore',),
'borede': ('bore',),
'borende': ('bore',),
'boret': ('bore',),
'borete': ('bore',),
'boreal': ('boreal',),
'boreale': ('boreal',),
'borealere': ('boreal',),
'borealest': ('boreal',),
'borealeste': ('boreal',),
'borealt': ('boreal',),
'borga': ('borge',),
'borgede': ('borge',),
'borgende': ('borge',),
'borget': ('borge',),
'borgete': ('borge',),
'borgerlig': ('borgerlig',),
'borgerlige': ('borgerlig',),
'borgerligere': ('borgerlig',),
'borgerligst': ('borgerlig',),
'borgerligste': ('borgerlig',),
'borket': ('borket',),
'borkete': ('borket',),
'borketere': ('borket',),
'borketest': ('borket',),
'borketeste': ('borket',),
'borkete': ('borkete',),
'bornert': ('bornert',),
'bornerte': ('bornert',),
'bornertere': ('bornert',),
'bornertest': ('bornert',),
'bornerteste': ('bornert',),
'bortbestilt': ('bortbestilt',),
'bortbestilte': ('bortbestilt',),
'bortbestiltere': ('bortbestilt',),
'bortbestiltest': ('bortbestilt',),
'bortbestilteste': ('bortbestilt',),
'bortbygsla': ('bortbygsle',),
'bortbygslede': ('bortbygsle',),
'bortbygslende': ('bortbygsle',),
'bortbygslet': ('bortbygsle',),
'bortbygslete': ('bortbygsle',),
'borterst': ('borterst',),
'borterste': ('borterst',),
'bortest': ('bortest',),
'borteste': ('bortest',),
'bortfesta': ('bortfeste',),
'bortfestede': ('bortfeste',),
'bortfestende': ('bortfeste',),
'bortfestet': ('bortfeste',),
'bortfestete': ('bortfeste',),
'bortforklarende': ('bortforklare',),
'bortforklart': ('bortforklare',),
'bortforklarte': ('bortforklare',),
'bortfrakta': ('bortfrakte',),
'bortfraktede': ('bortfrakte',),
'bortfraktende': ('bortfrakte',),
'bortfraktet': ('bortfrakte',),
'bortfraktete': ('bortfrakte',),
'bortførende': ('bortføre',),
'bortført': ('bortføre',),
'bortførte': ('bortføre',),
'bortgangen': ('bortgangen',),
'bortgangent': ('bortgangen',),
'bortgangne': ('bortgangen',),
'bortgangnere': ('bortgangen',),
'bortgangnest': ('bortgangen',),
'bortgangneste': ('bortgangen',),
'bortgjemt': ('bortgjemt',),
'bortgjemte': ('bortgjemt',),
'bortgjemtere': ('bortgjemt',),
'bortgjemtest': ('bortgjemt',),
'bortgjemteste': ('bortgjemt',),
'bortgjømt': ('bortgjømt',),
'bortgjømte': ('bortgjømt',),
'bortgjømtere': ('bortgjømt',),
'bortgjømtest': ('bortgjømt',),
'bortgjømteste': ('bortgjømt',),
'bortglemt': ('bortglemt',),
'bortglemte': ('bortglemt',),
'bortglemtere': ('bortglemt',),
'bortglemtest': ('bortglemt',),
'bortglemteste': ('bortglemt',),
'bortglømt': ('bortglømt',),
'bortglømte': ('bortglømt',),
'bortglømtere': ('bortglømt',),
'bortglømtest': ('bortglømt',),
'bortglømteste': ('bortglømt',),
'bortkasta': ('bortkasta',),
'bortkastede': ('bortkastet',),
'bortkastet': ('bortkastet',),
'bortkastete': ('bortkastet',),
'bortkastetere': ('bortkastet',),
'bortkastetest': ('bortkastet',),
'bortkasteteste': ('bortkastet',),
'bortkommen': ('bortkommen',),
'bortkomment': ('bortkommen',),
'bortkomne': ('bortkommen',),
'bortkomnere': ('bortkommen',),
'bortkomnest': ('bortkommen',),
'bortkomneste': ('bortkommen',),
'bortkommen': ('bortkommen',),
'bortkommet': ('bortkommen',),
'bortkomne': ('bortkommen',),
'bortkomnere': ('bortkommen',),
'bortkomnest': ('bortkommen',),
'bortkomneste': ('bortkommen',),
'bortkommet': ('bortkommet',),
'bortkomne': ('bortkommet',),
'bortkomnere': ('bortkommet',),
'bortkomnest': ('bortkommet',),
'bortkomneste': ('bortkommet',),
'bortleda': ('bortlede',),
'bortledede': ('bortlede',),
'bortledende': ('bortlede',),
'bortledet': ('bortlede',),
'bortledete': ('bortlede',),
'bortleid': ('bortleid',),
'bortleide': ('bortleid',),
'bortleidere': ('bortleid',),
'bortleidest': ('bortleid',),
'bortleideste': ('bortleid',),
'bortløpen': ('bortløpen',),
'bortløpent': ('bortløpen',),
'bortløpet': ('bortløpen',),
'bortløpne': ('bortløpen',),
'bortløpnere': ('bortløpen',),
'bortløpnest': ('bortløpen',),
'bortløpneste': ('bortløpen',),
'bortløpte': ('bortløpen',),
'borterst': ('bortre',),
'borterste': ('bortre',),
'bortre': ('bortre',),
'bortreist': ('bortreist',),
'bortreiste': ('bortreist',),
'bortreistere': ('bortreist',),
'bortreistest': ('bortreist',),
'bortreisteste': ('bortreist',),
'bortseende': ('bortse',),
'bortsett': ('bortse',),
'bortsette': ('bortse',),
'bortsatt': ('bortsette',),
'bortsatte': ('bortsette',),
'bortsettende': ('bortsette',),
'bortskjemt': ('bortskjemt',),
'bortskjemte': ('bortskjemt',),
'bortskjemtere': ('bortskjemt',),
'bortskjemtest': ('bortskjemt',),
'bortskjemteste': ('bortskjemt',),
'bortødsla': ('bortødsle',),
'bortødslede': ('bortødsle',),
'bortødslende': ('bortødsle',),
'bortødslet': ('bortødsle',),
'bortødslete': ('bortødsle',),
'bosatt': ('bosatt',),
'bosatte': ('bosatt',),
'bosattere': ('bosatt',),
'bosattest': ('bosatt',),
'bosatteste': ('bosatt',),
'bosatt': ('bosette',),
'bosatte': ('bosette',),
'bosettende': ('bosette',),
'bosnisk': ('bosnisk',),
'bosniske': ('bosnisk',),
'bosniskere': ('bosnisk',),
'bosniskest': ('bosnisk',),
'bosniskeste': ('bosnisk',),
'botaniserende': ('botanisere',),
'botanisert': ('botanisere',),
'botaniserte': ('botanisere',),
'botanisk': ('botanisk',),
'botaniske': ('botanisk',),
'botaniskere': ('botanisk',),
'botaniskest': ('botanisk',),
'botaniskeste': ('botanisk',),
'botferdig': ('botferdig',),
'botferdige': ('botferdig',),
'botferdigere': ('botferdig',),
'botferdigst': ('botferdig',),
'botferdigste': ('botferdig',),
'botlagt': ('botlegge',),
'botlagte': ('botlegge',),
'botleggende': ('botlegge',),
'botna': ('botne',),
'botnede': ('botne',),
'botnende': ('botne',),
'botnet': ('botne',),
'botnete': ('botne',),
'botnfellende': ('botnfelle',),
'botnfelt': ('botnfelle',),
'botnfelte': ('botnfelle',),
'botnlaus': ('botnlaus',),
'botnlause': ('botnlaus',),
'botnlausere': ('botnlaus',),
'botnlausest': ('botnlaus',),
'botnlauseste': ('botnlaus',),
'botnlaust': ('botnlaus',),
'botnløs': ('botnløs',),
'botnløse': ('botnløs',),
'botnløsere': ('botnløs',),
'botnløsest': ('botnløs',),
'botnløseste': ('botnløs',),
'botnløst': ('botnløs',),
'botnskrapa': ('botnskrape',),
'botnskrapede': ('botnskrape',),
'botnskrapende': ('botnskrape',),
'botnskrapet': ('botnskrape',),
'botnskrapete': ('botnskrape',),
'botnskrapt': ('botnskrape',),
'botnskrapte': ('botnskrape',),
'botswansk': ('botswansk',),
'botswanske': ('botswansk',),
'botswanskere': ('botswansk',),
'botswanskest': ('botswansk',),
'botswanskeste': ('botswansk',),
'bowla': ('bowle',),
'bowlede': ('bowle',),
'bowlende': ('bowle',),
'bowlet': ('bowle',),
'bowlete': ('bowle',),
'bra': ('bra',),
'braka': ('brake',),
'brakede': ('brake',),
'brakende': ('brake',),
'braket': ('brake',),
'brakete': ('brake',),
'brakt': ('brake',),
'brakte': ('brake',),
'brakk': ('brakk',),
'brakke': ('brakk',),
'brakkere': ('brakk',),
'brakkest': ('brakk',),
'brakkeste': ('brakk',),
'brakt': ('brakk',),
'brakk': ('brakk',),
'brakke': ('brakk',),
'brakkere': ('brakk',),
'brakkest': ('brakk',),
'brakkeste': ('brakk',),
'brakt': ('brakk',),
'brakka': ('brakke',),
'brakkede': ('brakke',),
'brakkende': ('brakke',),
'brakket': ('brakke',),
'brakkete': ('brakke',),
'bramansk': ('bramansk',),
'bramanske': ('bramansk',),
'bramanskere': ('bramansk',),
'bramanskest': ('bramansk',),
'bramanskeste': ('bramansk',),
'bramfri': ('bramfri',),
'bramfrie': ('bramfri',),
'bramfriere': ('bramfri',),
'bramfriest': ('bramfri',),
'bramfrieste': ('bramfri',),
'bramfritt': ('bramfri',),
'bramfull': ('bramfull',),
'bramfulle': ('bramfull',),
'bramfullere': ('bramfull',),
'bramfullest': ('bramfull',),
'bramfulleste': ('bramfull',),
'bramfullt': ('bramfull',),
'bramma': ('bramme',),
'brammede': ('bramme',),
'brammende': ('bramme',),
'brammet': ('bramme',),
'brammete': ('bramme',),
'brannet': ('brannet',),
'brannete': ('brannet',),
'brannetere': ('brannet',),
'brannetest': ('brannet',),
'branneteste': ('brannet',),
'brannete': ('brannete',),
'brannfarlig': ('brannfarlig',),
'brannfarlige': ('brannfarlig',),
'brannfarligere': ('brannfarlig',),
'brannfarligst': ('brannfarlig',),
'brannfarligste': ('brannfarlig',),
'branngul': ('branngul',),
'branngule': ('branngul',),
'branngulere': ('branngul',),
'branngulest': ('branngul',),
'brannguleste': ('branngul',),
'branngult': ('branngul',),
'brannrød': ('brannrød',),
'brannrøde': ('brannrød',),
'brannrødere': ('brannrød',),
'brannrødest': ('brannrød',),
'brannrødeste': ('brannrød',),
'brannrødt': ('brannrød',),
'brannsikker': ('brannsikker',),
'brannsikkert': ('brannsikker',),
'brannsikre': ('brannsikker',),
'brannsikrere': ('brannsikker',),
'brannsikrest': ('brannsikker',),
'brannsikreste': ('brannsikker',),
'brasiliansk': ('brasiliansk',),
'brasilianske': ('brasiliansk',),
'brasilianskere': ('brasiliansk',),
'brasilianskest': ('brasiliansk',),
'brasilianskeste': ('brasiliansk',),
'braska': ('braske',),
'braskede': ('braske',),
'braskende': ('braske',),
'brasket': ('braske',),
'braskete': ('braske',),
'bratna': ('bratne',),
'bratnede': ('bratne',),
'bratnende': ('bratne',),
'bratnet': ('bratne',),
'bratnete': ('bratne',),
'bratt': ('bratt',),
'bratte': ('bratt',),
'brattere': ('bratt',),
'brattest': ('bratt',),
'bratteste': ('bratt',),
'brattlendt': ('brattlendt',),
'brattlendte': ('brattlendt',),
'brattlendtere': ('brattlendt',),
'brattlendtest': ('brattlendt',),
'brattlendteste': ('brattlendt',),
'brauta': ('braute',),
'brautede': ('braute',),
'brautende': ('braute',),
'brautet': ('braute',),
'brautete': ('braute',),
'brav': ('brav',),
'brave': ('brav',),
'bravere': ('brav',),
'bravest': ('brav',),
'braveste': ('brav',),
'bravt': ('brav',),
'braverende': ('bravere',),
'bravert': ('bravere',),
'braverte': ('bravere',),
'bred': ('bred',),
'brede': ('bred',),
'bredere': ('bred',),
'bredest': ('bred',),
'bredeste': ('bred',),
'bredt': ('bred',),
'bredakslede': ('bredakslet',),
'bredakslet': ('bredakslet',),
'bredakslete': ('bredakslet',),
'bredaksletere': ('bredakslet',),
'bredaksletest': ('bredakslet',),
'bredaksleteste': ('bredakslet',),
'breddfull': ('breddfull',),
'breddfulle': ('breddfull',),
'breddfullere': ('breddfull',),
'breddfullest': ('breddfull',),
'breddfulleste': ('breddfull',),
'breddfullt': ('breddfull',),
'bredkinna': ('bredkinna',),
'bredkinnede': ('bredkinnet',),
'bredkinnet': ('bredkinnet',),
'bredkinnete': ('bredkinnet',),
'bredkinnetere': ('bredkinnet',),
'bredkinnetest': ('bredkinnet',),
'bredkinneteste': ('bredkinnet',),
'bredkjefta': ('bredkjefta',),
'bredkjeftede': ('bredkjeftet',),
'bredkjeftet': ('bredkjeftet',),
'bredkjeftete': ('bredkjeftet',),
'bredkjeftetere': ('bredkjeftet',),
'bredkjeftetest': ('bredkjeftet',),
'bredkjefteteste': ('bredkjeftet',),
'bredpanna': ('bredpanna',),
'bredpannede': ('bredpannet',),
'bredpannet': ('bredpannet',),
'bredpannete': ('bredpannet',),
'bredpannetere': ('bredpannet',),
'bredpannetest': ('bredpannet',),
'bredpanneteste': ('bredpannet',),
'bredskuldra': ('bredskuldra',),
'bredskuldrede': ('bredskuldret',),
'bredskuldret': ('bredskuldret',),
'bredskuldrete': ('bredskuldret',),
'bredskuldretere': ('bredskuldret',),
'bredskuldretest': ('bredskuldret',),
'bredskuldreteste': ('bredskuldret',),
'bredskåren': ('bredskåren',),
'bredskårent': ('bredskåren',),
'bredskårne': ('bredskåren',),
'bredskårnere': ('bredskåren',),
'bredskårnest': ('bredskåren',),
'bredskårneste': ('bredskåren',),
'bredspora': ('bredspora',),
'bredsporede': ('bredsporet',),
'bredsporet': ('bredsporet',),
'bredsporete': ('bredsporet',),
'bredsporetere': ('bredsporet',),
'bredsporetest': ('bredsporet',),
'bredsporeteste': ('bredsporet',),
'bredvokst': ('bredvokst',),
'bredvokste': ('bredvokst',),
'bredvokstere': ('bredvokst',),
'bredvokstest': ('bredvokst',),
'bredvoksteste': ('bredvokst',),
'bregrøn': ('bregrøn',),
'bregrøne': ('bregrøn',),
'bregrønere': ('bregrøn',),
'bregrønest': ('bregrøn',),
'bregrøneste': ('bregrøn',),
'bregrønt': ('bregrøn',),
'bregrønn': ('bregrønn',),
'bregrønne': ('bregrønn',),
'bregrønnere': ('bregrønn',),
'bregrønnest': ('bregrønn',),
'bregrønneste': ('bregrønn',),
'bregrønt': ('bregrønn',),
'brei': ('brei',),
'breie': ('brei',),
'breiere': ('brei',),
'breiest': ('brei',),
'breieste': ('brei',),
'breit': ('brei',),
'breitt': ('brei',),
'breiakslede': ('breiakslet',),
'breiakslet': ('breiakslet',),
'breiakslete': ('breiakslet',),
'breiaksletere': ('breiakslet',),
'breiaksletest': ('breiakslet',),
'breiaksleteste': ('breiakslet',),
'breia': ('breie',),
'breid': ('breie',),
'breidd': ('breie',),
'breidde': ('breie',),
'breide': ('breie',),
'breiede': ('breie',),
'breiende': ('breie',),
'breiet': ('breie',),
'breiete': ('breie',),
'breia': ('breie',),
'breid': ('breie',),
'breidd': ('breie',),
'breidde': ('breie',),
'breide': ('breie',),
'breiede': ('breie',),
'breiende': ('breie',),
'breiet': ('breie',),
'breiete': ('breie',),
'breikinna': ('breikinna',),
'breikinnede': ('breikinnet',),
'breikinnet': ('breikinnet',),
'breikinnete': ('breikinnet',),
'breikinnetere': ('breikinnet',),
'breikinnetest': ('breikinnet',),
'breikinneteste': ('breikinnet',),
'breikjefta': ('breikjefta',),
'breikjeftede': ('breikjeftet',),
'breikjeftet': ('breikjeftet',),
'breikjeftete': ('breikjeftet',),
'breikjeftetere': ('breikjeftet',),
'breikjeftetest': ('breikjeftet',),
'breikjefteteste': ('breikjeftet',),
'breipanna': ('breipanna',),
'breipannede': ('breipannet',),
'breipannet': ('breipannet',),
'breipannete': ('breipannet',),
'breipannetere': ('breipannet',),
'breipannetest': ('breipannet',),
'breipanneteste': ('breipannet',),
'breiskuldra': ('breiskuldra',),
'breiskuldrede': ('breiskuldret',),
'breiskuldret': ('breiskuldret',),
'breiskuldrete': ('breiskuldret',),
'breiskuldretere': ('breiskuldret',),
'breiskuldretest': ('breiskuldret',),
'breiskuldreteste': ('breiskuldret',),
'breiskåren': ('breiskåren',),
'breiskårent': ('breiskåren',),
'breiskårne': ('breiskåren',),
'breiskårnere': ('breiskåren',),
'breiskårnest': ('breiskåren',),
'breiskårneste': ('breiskåren',),
'breispora': ('breispora',),
'breisporede': ('breisporet',),
'breisporet': ('breisporet',),
'breisporete': ('breisporet',),
'breisporetere': ('breisporet',),
'breisporetest': ('breisporet',),
'breisporeteste': ('breisporet',),
'breivokst': ('breivokst',),
'breivokste': ('breivokst',),
'breivokstere': ('breivokst',),
'breivokstest': ('breivokst',),
'breivoksteste': ('breivokst',),
'breka': ('breke',),
'brekede': ('breke',),
'brekende': ('breke',),
'breket': ('breke',),
'brekete': ('breke',),
'brekt': ('breke',),
'brekte': ('breke',),
'brekka': ('brekke',),
'brekkede': ('brekke',),
'brekkende': ('brekke',),
'brekket': ('brekke',),
'brekkete': ('brekke',),
'brekt': ('brekke',),
'brekte': ('brekke',),
'brekkende': ('brekke',),
'brukken': ('brekke',),
'brukket': ('brekke',),
'brukne': ('brekke',),
'bremma': ('bremme',),
'bremmede': ('bremme',),
'bremmende': ('bremme',),
'bremmet': ('bremme',),
'bremmete': ('bremme',),
'bremsa': ('bremse',),
'bremsede': ('bremse',),
'bremsende': ('bremse',),
'bremset': ('bremse',),
'bremsete': ('bremse',),
'brennaktuell': ('brennaktuell',),
'brennaktuelle': ('brennaktuell',),
'brennaktuellere': ('brennaktuell',),
'brennaktuellest': ('brennaktuell',),
'brennaktuelleste': ('brennaktuell',),
'brennaktuelt': ('brennaktuell',),
'brennbar': ('brennbar',),
'brennbare': ('brennbar',),
'brennbarere': ('brennbar',),
'brennbarest': ('brennbar',),
'brennbareste': ('brennbar',),
'brennbart': ('brennbar',),
'brennemerka': ('brennemerke',),
'brennemerkede': ('brennemerke',),
'brennemerkende': ('brennemerke',),
'brennemerket': ('brennemerke',),
'brennemerkete': ('brennemerke',),
'brennhet': ('brennhet',),
'brennhete': ('brennhet',),
'brennhetere': ('brennhet',),
'brennhetest': ('brennhet',),
'brennheteste': ('brennhet',),
'brennhett': ('brennhet',),
'brennrød': ('brennrød',),
'brennrøde': ('brennrød',),
'brennrødere': ('brennrød',),
'brennrødest': ('brennrød',),
'brennrødeste': ('brennrød',),
'brennrødt': ('brennrød',),
'brennsikker': ('brennsikker',),
'brennsikkert': ('brennsikker',),
'brennsikre': ('brennsikker',),
'brennsikrere': ('brennsikker',),
'brennsikrest': ('brennsikker',),
'brennsikreste': ('brennsikker',),
'brennsnar': ('brennsnar',),
'brennsnare': ('brennsnar',),
'brennsnarere': ('brennsnar',),
'brennsnarest': ('brennsnar',),
'brennsnareste': ('brennsnar',),
'brennsnart': ('brennsnar',),
'breserende': ('bresere',),
'bresert': ('bresere',),
'breserte': ('bresere',),
'bresta': ('breste',),
'brestede': ('breste',),
'brestende': ('breste',),
'brestet': ('breste',),
'brestete': ('breste',),
'bresten': ('breste',),
'brestende': ('breste',),
'brestet': ('breste',),
'brestne': ('breste',),
'bresten': ('breste',),
'brestende': ('breste',),
'brestet': ('breste',),
'brestne': ('breste',),
'bretagnsk': ('bretagnsk',),
'bretagnske': ('bretagnsk',),
'bretagnskere': ('bretagnsk',),
'bretagnskest': ('bretagnsk',),
'bretagnskeste': ('bretagnsk',),
'bretonsk': ('bretonsk',),
'bretonske': ('bretonsk',),
'bretonskere': ('bretonsk',),
'bretonskest': ('bretonsk',),
'bretonskeste': ('bretonsk',),
'bretta': ('brette',),
'brettede': ('brette',),
'brettende': ('brette',),
'brettet': ('brette',),
'brettete': ('brette',),
'brettsegla': ('brettsegle',),
'brettseglede': ('brettsegle',),
'brettseglende': ('brettsegle',),
'brettseglet': ('brettsegle',),
'brettseglete': ('brettsegle',),
'brettseilende': ('brettseile',),
'brettseilt': ('brettseile',),
'brettseilte': ('brettseile',),
'brevveksla': ('brevveksle',),
'brevvekslede': ('brevveksle',),
'brevvekslende': ('brevveksle',),
'brevvekslet': ('brevveksle',),
'brevvekslete': ('brevveksle',),
'brifa': ('brife',),
'brifede': ('brife',),
'brifende': ('brife',),
'brifet': ('brife',),
'brifete': ('brife',),
'briketterende': ('brikettere',),
'brikettert': ('brikettere',),
'briketterte': ('brikettere',),
'briljant': ('briljant',),
'briljante': ('briljant',),
'briljantere': ('briljant',),
'briljantest': ('briljant',),
'briljanteste': ('briljant',),
'briljerende': ('briljere',),
'briljert': ('briljere',),
'briljerte': ('briljere',),
'brillefin': ('brillefin',),
'brillefine': ('brillefin',),
'brillefinere': ('brillefin',),
'brillefinest': ('brillefin',),
'brillefineste': ('brillefin',),
'brillefint': ('brillefin',),
'bragt': ('bringe',),
'bragte': ('bringe',),
'brakt': ('bringe',),
'brakte': ('bringe',),
'bringende': ('bringe',),
'bringebred': ('bringebred',),
'bringebrede': ('bringebred',),
'bringebredere': ('bringebred',),
'bringebredest': ('bringebred',),
'bringebredeste': ('bringebred',),
'bringebredt': ('bringebred',),
'bringebrei': ('bringebrei',),
'bringebreie': ('bringebrei',),
'bringebreiere': ('bringebrei',),
'bringebreiest': ('bringebrei',),
'bringebreieste': ('bringebrei',),
'bringebreit': ('bringebrei',),
'bringebreitt': ('bringebrei',),
'brisant': ('brisant',),
'brisante': ('brisant',),
'brisantere': ('brisant',),
'brisantest': ('brisant',),
'brisanteste': ('brisant',),
'brisende': ('brise',),
'brist': ('brise',),
'briste': ('brise',),
'brisen': ('brisen',),
'brisent': ('brisen',),
'brisne': ('brisen',),
'brisnere': ('brisen',),
'brisnest': ('brisen',),
'brisneste': ('brisen',),
'briska': ('briske',),
'briskede': ('briske',),
'briskende': ('briske',),
'brisket': ('briske',),
'briskete': ('briske',),
'bristen': ('briste',),
'bristende': ('briste',),
'bristet': ('briste',),
'bristne': ('briste',),
'brusten': ('briste',),
'brustet': ('briste',),
'brustne': ('briste',),
'bristen': ('briste',),
'bristende': ('briste',),
'bristet': ('briste',),
'bristne': ('briste',),
'brusten': ('briste',),
'brustet': ('briste',),
'brustne': ('briste',),
'bristeferdig': ('bristeferdig',),
'bristeferdige': ('bristeferdig',),
'bristeferdigere': ('bristeferdig',),
'bristeferdigst': ('bristeferdig',),
'bristeferdigste': ('bristeferdig',),
'bristfeldig': ('bristfeldig',),
'bristfeldige': ('bristfeldig',),
'bristfeldigere': ('bristfeldig',),
'bristfeldigst': ('bristfeldig',),
'bristfeldigste': ('bristfeldig',),
'britannisk': ('britannisk',),
'britanniske': ('britannisk',),
'britanniskere': ('britannisk',),
'britanniskest': ('britannisk',),
'britanniskeste': ('britannisk',),
'britisk': ('britisk',),
'britiske': ('britisk',),
'britiskere': ('britisk',),
'britiskest': ('britisk',),
'britiskeste': ('britisk',),
'brittonsk': ('brittonsk',),
'brittonske': ('brittonsk',),
'brittonskere': ('brittonsk',),
'brittonskest': ('brittonsk',),
'brittonskeste': ('brittonsk',),
'brodda': ('brodde',),
'broddede': ('brodde',),
'broddende': ('brodde',),
'broddet': ('brodde',),
'broddete': ('brodde',),
'brodden': ('brodden',),
'broddent': ('brodden',),
'brodne': ('brodden',),
'brodnere': ('brodden',),
'brodnest': ('brodden',),
'brodneste': ('brodden',),
'broderende': ('brodere',),
'brodert': ('brodere',),
'broderte': ('brodere',),
'broderlig': ('broderlig',),
'broderlige': ('broderlig',),
'broderligere': ('broderlig',),
'broderligst': ('broderlig',),
'broderligste': ('broderlig',),
'broket': ('broket',),
'brokete': ('broket',),
'broketere': ('broket',),
'broketest': ('broket',),
'broketeste': ('broket',),
'brokete': ('brokete',),
'brokksjuk': ('brokksjuk',),
'brokksjuke': ('brokksjuk',),
'brokksjukere': ('brokksjuk',),
'brokksjukest': ('brokksjuk',),
'brokksjukeste': ('brokksjuk',),
'brokksjukt': ('brokksjuk',),
'brokksyk': ('brokksyk',),
'brokksyke': ('brokksyk',),
'brokksykere': ('brokksyk',),
'brokksykest': ('brokksyk',),
'brokksykeste': ('brokksyk',),
'brokksykt': ('brokksyk',),
'brolagt': ('brolegge',),
'brolagte': ('brolegge',),
'broleggende': ('brolegge',),
'bronkial': ('bronkial',),
'bronkiale': ('bronkial',),
'bronkialere': ('bronkial',),
'bronkialest': ('bronkial',),
'bronkialeste': ('bronkial',),
'bronkialt': ('bronkial',),
'bronkittisk': ('bronkittisk',),
'bronkittiske': ('bronkittisk',),
'bronkittiskere': ('bronkittisk',),
'bronkittiskest': ('bronkittisk',),
'bronkittiskeste': ('bronkittisk',),
'bronsa': ('bronse',),
'bronsede': ('bronse',),
'bronsende': ('bronse',),
'bronset': ('bronse',),
'bronsete': ('bronse',),
'bronsebrun': ('bronsebrun',),
'bronsebrune': ('bronsebrun',),
'bronsebrunere': ('bronsebrun',),
'bronsebrunest': ('bronsebrun',),
'bronsebruneste': ('bronsebrun',),
'bronsebrunt': ('bronsebrun',),
'bronserende': ('bronsere',),
'bronsert': ('bronsere',),
'bronserte': ('bronsere',),
'brosjerende': ('brosjere',),
'brosjert': ('brosjere',),
'brosjerte': ('brosjere',),
'brotna': ('brotne',),
'brotnede': ('brotne',),
'brotnende': ('brotne',),
'brotnet': ('brotne',),
'brotnete': ('brotne',),
'brotsja': ('brotsje',),
'brotsjede': ('brotsje',),
'brotsjende': ('brotsje',),
'brotsjet': ('brotsje',),
'brotsjete': ('brotsje',),
'brottfast': ('brottfast',),
'brottfaste': ('brottfast',),
'brottfastere': ('brottfast',),
'brottfastest': ('brottfast',),
'brottfasteste': ('brottfast',),
'brudden': ('brudden',),
'bruddent': ('brudden',),
'brudne': ('brudden',),
'brudnere': ('brudden',),
'brudnest': ('brudden',),
'brudneste': ('brudden',),
'bruddfast': ('bruddfast',),
'bruddfaste': ('bruddfast',),
'bruddfastere': ('bruddfast',),
'bruddfastest': ('bruddfast',),
'bruddfasteste': ('bruddfast',),
'brukbar': ('brukbar',),
'brukbare': ('brukbar',),
'brukbarere': ('brukbar',),
'brukbarest': ('brukbar',),
'brukbareste': ('brukbar',),
'brukbart': ('brukbar',),
'brukende': ('bruke',),
'brukt': ('bruke',),
'brukte': ('bruke',),
'brukelig': ('brukelig',),
'brukelige': ('brukelig',),
'brukeligere': ('brukelig',),
'brukeligst': ('brukelig',),
'brukeligste': ('brukelig',),
'brukervennlig': ('brukervennlig',),
'brukervennlige': ('brukervennlig',),
'brukervennligere': ('brukervennlig',),
'brukervennligst': ('brukervennlig',),
'brukervennligste': ('brukervennlig',),
'brukken': ('brukken',),
'brukket': ('brukken',),
'brukne': ('brukken',),
'bruknere': ('brukken',),
'bruknest': ('brukken',),
'brukneste': ('brukken',),
'brukket': ('brukket',),
'brukne': ('brukket',),
'bruknere': ('brukket',),
'bruknest': ('brukket',),
'brukneste': ('brukket',),
'brukt': ('brukt',),
'brukte': ('brukt',),
'bruktere': ('brukt',),
'bruktest': ('brukt',),
'brukteste': ('brukt',),
'brulagt': ('brulegge',),
'brulagte': ('brulegge',),
'bruleggende': ('brulegge',),
'brumla': ('brumle',),
'brumlede': ('brumle',),
'brumlende': ('brumle',),
'brumlet': ('brumle',),
'brumlete': ('brumle',),
'brumma': ('brumme',),
'brummede': ('brumme',),
'brummende': ('brumme',),
'brummet': ('brumme',),
'brummete': ('brumme',),
'brun': ('brun',),
'brune': ('brun',),
'brunere': ('brun',),
'brunest': ('brun',),
'bruneste': ('brun',),
'brunt': ('brun',),
'brunbarka': ('brunbarka',),
'brunbarkede': ('brunbarket',),
'brunbarket': ('brunbarket',),
'brunbarkete': ('brunbarket',),
'brunbarketere': ('brunbarket',),
'brunbarketest': ('brunbarket',),
'brunbarketeste': ('brunbarket',),
'bruna': ('brune',),
'brunede': ('brune',),
'brunende': ('brune',),
'brunet': ('brune',),
'brunete': ('brune',),
'brunt': ('brune',),
'brunte': ('brune',),
'bruneisk': ('bruneisk',),
'bruneiske': ('bruneisk',),
'bruneiskere': ('bruneisk',),
'bruneiskest': ('bruneisk',),
'bruneiskeste': ('bruneisk',),
'brunlig': ('brunlig',),
'brunlige': ('brunlig',),
'brunligere': ('brunlig',),
'brunligst': ('brunlig',),
'brunligste': ('brunlig',),
'brunsteikende': ('brunsteike',),
'brunsteikt': ('brunsteike',),
'brunsteikte': ('brunsteike',),
'brunstekende': ('brunsteke',),
'brunstekt': ('brunsteke',),
'brunstekte': ('brunsteke',),
'brunstig': ('brunstig',),
'brunstige': ('brunstig',),
'brunstigere': ('brunstig',),
'brunstigst': ('brunstig',),
'brunstigste': ('brunstig',),
'brunøyd': ('brunøyd',),
'brunøyde': ('brunøyd',),
'brunøydere': ('brunøyd',),
'brunøydest': ('brunøyd',),
'brunøydeste': ('brunøyd',),
'brusende': ('bruse',),
'brust': ('bruse',),
'bruste': ('bruse',),
'brusten': ('brusten',),
'brustent': ('brusten',),
'brustne': ('brusten',),
'brustnere': ('brusten',),
'brustnest': ('brusten',),
'brustneste': ('brusten',),
'brutal': ('brutal',),
'brutale': ('brutal',),
'brutalere': ('brutal',),
'brutalest': ('brutal',),
'brutaleste': ('brutal',),
'brutalt': ('brutal',),
'brutaliserende': ('brutalisere',),
'brutalisert': ('brutalisere',),
'brutaliserte': ('brutalisere',),
'brydd': ('bry',),
'brydde': ('bry',),
'bryende': ('bry',),
'brydd': ('brydd',),
'brydde': ('brydd',),
'bryddere': ('brydd',),
'bryddest': ('brydd',),
'bryddeste': ('brydd',),
'brydda': ('brydde',),
'bryddede': ('brydde',),
'bryddende': ('brydde',),
'bryddet': ('brydde',),
'bryddete': ('brydde',),
'brygd': ('brygge',),
'brygde': ('brygge',),
'brygga': ('brygge',),
'bryggede': ('brygge',),
'bryggende': ('brygge',),
'brygget': ('brygge',),
'bryggete': ('brygge',),
'brynende': ('bryne',),
'brynt': ('bryne',),
'brynte': ('bryne',),
'bryologisk': ('bryologisk',),
'bryologiske': ('bryologisk',),
'bryologiskere': ('bryologisk',),
'bryologiskest': ('bryologisk',),
'bryologiskeste': ('bryologisk',),
'brysk': ('brysk',),
'bryske': ('brysk',),
'bryskere': ('brysk',),
'bryskest': ('brysk',),
'bryskeste': ('brysk',),
'bryskt': ('brysk',),
'bryska': ('bryske',),
'bryskede': ('bryske',),
'bryskende': ('bryske',),
'brysket': ('bryske',),
'bryskete': ('bryske',),
'brysom': ('brysom',),
'brysomme': ('brysom',),
'brysommere': ('brysom',),
'brysomst': ('brysom',),
'brysomste': ('brysom',),
'brysomt': ('brysom',),
'brysta': ('bryste',),
'brystede': ('bryste',),
'brystende': ('bryste',),
'brystet': ('bryste',),
'brystete': ('bryste',),
'brytbar': ('brytbar',),
'brytbare': ('brytbar',),
'brytbarere': ('brytbar',),
'brytbarest': ('brytbar',),
'brytbareste': ('brytbar',),
'brytbart': ('brytbar',),
'brutt': ('bryte',),
'brutte': ('bryte',),
'brytende': ('bryte',),
'brå': ('brå',),
'bråe': ('brå',),
'bråere': ('brå',),
'bråest': ('brå',),
'bråeste': ('brå',),
'brått': ('brå',),
'bråbremsa': ('bråbremse',),
'bråbremsede': ('bråbremse',),
'bråbremsende': ('bråbremse',),
'bråbremset': ('bråbremse',),
'bråbremsete': ('bråbremse',),
'brådjup': ('brådjup',),
'brådjupe': ('brådjup',),
'brådjupere': ('brådjup',),
'brådjupest': ('brådjup',),
'brådjupeste': ('brådjup',),
'brådjupt': ('brådjup',),
'brådyp': ('brådyp',),
'brådype': ('brådyp',),
'brådypere': ('brådyp',),
'brådypest': ('brådyp',),
'brådypeste': ('brådyp',),
'brådypt': ('brådyp',),
'bråka': ('bråke',),
'bråkede': ('bråke',),
'bråkende': ('bråke',),
'bråket': ('bråke',),
'bråkete': ('bråke',),
'bråkt': ('bråke',),
'bråkte': ('bråke',),
'bråka': ('bråke',),
'bråkede': ('bråke',),
'bråkende': ('bråke',),
'bråket': ('bråke',),
'bråkete': ('bråke',),
'bråkt': ('bråke',),
'bråkte': ('bråke',),
'bråket': ('bråket',),
'bråkete': ('bråket',),
'bråketere': ('bråket',),
'bråketest': ('bråket',),
'bråketeste': ('bråket',),
'bråkete': ('bråkete',),
'bråkjekk': ('bråkjekk',),
'bråkjekke': ('bråkjekk',),
'bråkjekkere': ('bråkjekk',),
'bråkjekkest': ('bråkjekk',),
'bråkjekkeste': ('bråkjekk',),
'bråkjekt': ('bråkjekk',),
'bråmoden': ('bråmoden',),
'bråmodent': ('bråmoden',),
'bråmodne': ('bråmoden',),
'bråmodnere': ('bråmoden',),
'bråmodnest': ('bråmoden',),
'bråmodneste': ('bråmoden',),
'bråna': ('bråne',),
'brånede': ('bråne',),
'brånende': ('bråne',),
'brånet': ('bråne',),
'brånete': ('bråne',),
'brånt': ('bråne',),
'brånte': ('bråne',),
'bråsinna': ('bråsinna',),
'bråsint': ('bråsint',),
'bråsinte': ('bråsint',),
'bråsintere': ('bråsint',),
'bråsintest': ('bråsint',),
'bråsinteste': ('bråsint',),
'bråvakker': ('bråvakker',),
'bråvakkert': ('bråvakker',),
'bråvakre': ('bråvakker',),
'bråvakrere': ('bråvakker',),
'bråvakrest': ('bråvakker',),
'bråvakreste': ('bråvakker',),
'brødefull': ('brødefull',),
'brødefulle': ('brødefull',),
'brødefullere': ('brødefull',),
'brødefullest': ('brødefull',),
'brødefulleste': ('brødefull',),
'brødefullt': ('brødefull',),
'brødfødd': ('brødfø',),
'brødfødde': ('brødfø',),
'brødføende': ('brødfø',),
'brødlaus': ('brødlaus',),
'brødlause': ('brødlaus',),
'brødlausere': ('brødlaus',),
'brødlausest': ('brødlaus',),
'brødlauseste': ('brødlaus',),
'brødlaust': ('brødlaus',),
'brødløs': ('brødløs',),
'brødløse': ('brødløs',),
'brødløsere': ('brødløs',),
'brødløsest': ('brødløs',),
'brødløseste': ('brødløs',),
'brødløst': ('brødløs',),
'brølende': ('brøle',),
'brølt': ('brøle',),
'brølte': ('brøle',),
'brøstfeldig': ('brøstfeldig',),
'brøstfeldige': ('brøstfeldig',),
'brøstfeldigere': ('brøstfeldig',),
'brøstfeldigst': ('brøstfeldig',),
'brøstfeldigste': ('brøstfeldig',),
'brøstholden': ('brøstholden',),
'brøstholdent': ('brøstholden',),
'brøstholdne': ('brøstholden',),
'brøstholdnere': ('brøstholden',),
'brøstholdnest': ('brøstholden',),
'brøstholdneste': ('brøstholden',),
'brøyta': ('brøyte',),
'brøytede': ('brøyte',),
'brøytende': ('brøyte',),
'brøytet': ('brøyte',),
'brøytete': ('brøyte',),
'brøytt': ('brøyte',),
'brøytte': ('brøyte',),
'budd': ('bu',),
'budde': ('bu',),
'buende': ('bu',),
'budd': ('bu',),
'budde': ('bu',),
'buende': ('bu',),
'bua': ('bua',),
'buddhistisk': ('buddhistisk',),
'buddhistiske': ('buddhistisk',),
'buddhistiskere': ('buddhistisk',),
'buddhistiskest': ('buddhistisk',),
'buddhistiskeste': ('buddhistisk',),
'buden': ('buden',),
'budent': ('buden',),
'budne': ('buden',),
'budnere': ('buden',),
'budnest': ('buden',),
'budneste': ('buden',),
'budsendende': ('budsende',),
'budsendt': ('budsende',),
'budsendte': ('budsende',),
'budsjetterende': ('budsjettere',),
'budsjettert': ('budsjettere',),
'budsjetterte': ('budsjettere',),
'bua': ('bue',),
'buede': ('bue',),
'buende': ('bue',),
'buet': ('bue',),
'buete': ('bue',),
'bueforma': ('bueforma',),
'bueformede': ('bueformet',),
'bueformet': ('bueformet',),
'bueformete': ('bueformet',),
'bueformetere': ('bueformet',),
'bueformetest': ('bueformet',),
'bueformeteste': ('bueformet',),
'buede': ('buet',),
'buet': ('buet',),
'buete': ('buet',),
'buetere': ('buet',),
'buetest': ('buet',),
'bueteste': ('buet',),
'bufast': ('bufast',),
'bufaste': ('bufast',),
'bufastere': ('bufast',),
'bufastest': ('bufast',),
'bufasteste': ('bufast',),
'bugna': ('bugne',),
'bugnede': ('bugne',),
'bugnende': ('bugne',),
'bugnet': ('bugne',),
'bugnete': ('bugne',),
'bukka': ('bukke',),
'bukkede': ('bukke',),
'bukkende': ('bukke',),
'bukket': ('bukke',),
'bukkete': ('bukke',),
'bukka': ('bukke',),
'bukkede': ('bukke',),
'bukkende': ('bukke',),
'bukket': ('bukke',),
'bukkete': ('bukke',),
'buklanda': ('buklande',),
'buklandede': ('buklande',),
'buklandende': ('buklande',),
'buklandet': ('buklande',),
'buklandete': ('buklande',),
'buklet': ('buklet',),
'buklete': ('buklet',),
'bukletere': ('buklet',),
'bukletest': ('buklet',),
'bukleteste': ('buklet',),
'buklete': ('buklete',),
'bukolisk': ('bukolisk',),
'bukoliske': ('bukolisk',),
'bukoliskere': ('bukolisk',),
'bukoliskest': ('bukolisk',),
'bukoliskeste': ('bukolisk',),
'bukserende': ('buksere',),
'buksert': ('buksere',),
'bukserte': ('buksere',),
'bukta': ('bukte',),
'buktede': ('bukte',),
'buktende': ('bukte',),
'buktet': ('bukte',),
'buktete': ('bukte',),
'buktet': ('buktet',),
'buktete': ('buktet',),
'buktetere': ('buktet',),
'buktetest': ('buktet',),
'bukteteste': ('buktet',),
'buktete': ('buktete',),
'buldra': ('buldre',),
'buldrede': ('buldre',),
'buldrende': ('buldre',),
'buldret': ('buldre',),
'buldrete': ('buldre',),
'bula': ('bule',),
'bulede': ('bule',),
'bulende': ('bule',),
'bulet': ('bule',),
'bulete': ('bule',),
'bult': ('bule',),
'bulte': ('bule',),
'bulet': ('bulet',),
'bulete': ('bulet',),
'buletere': ('bulet',),
'buletest': ('bulet',),
'buleteste': ('bulet',),
'bulete': ('bulete',),
'bulgarsk': ('bulgarsk',),
'bulgarske': ('bulgarsk',),
'bulgarskere': ('bulgarsk',),
'bulgarskest': ('bulgarsk',),
'bulgarskeste': ('bulgarsk',),
'bulka': ('bulke',),
'bulkede': ('bulke',),
'bulkende': ('bulke',),
'bulket': ('bulke',),
'bulkete': ('bulke',),
'bulket': ('bulket',),
'bulkete': ('bulket',),
'bulketere': ('bulket',),
'bulketest': ('bulket',),
'bulketeste': ('bulket',),
'bulkete': ('bulkete',),
'bulna': ('bulne',),
'bulnede': ('bulne',),
'bulnende': ('bulne',),
'bulnet': ('bulne',),
'bulnete': ('bulne',),
'bumsa': ('bumse',),
'bumsede': ('bumse',),
'bumsende': ('bumse',),
'bumset': ('bumse',),
'bumsete': ('bumse',),
'bumset': ('bumset',),
'bumsete': ('bumset',),
'bumsetere': ('bumset',),
'bumsetest': ('bumset',),
'bumseteste': ('bumset',),
'bumsete': ('bumsete',),
'bunadkledd': ('bunadkledd',),
'bunadkledde': ('bunadkledd',),
'bunadkleddere': ('bunadkledd',),
'bunadkleddest': ('bunadkledd',),
'bunadkleddeste': ('bunadkledd',),
'bunadskledd': ('bunadskledd',),
'bunadskledde': ('bunadskledd',),
'bunadskleddere': ('bunadskledd',),
'bunadskleddest': ('bunadskledd',),
'bunadskleddeste': ('bunadskledd',),
'bunden': ('bunden',),
'bundet': ('bunden',),
'bundne': ('bunden',),
'bundnere': ('bunden',),
'bundnest': ('bunden',),
'bundneste': ('bunden',),
'bundet': ('bundet',),
'bundne': ('bundet',),
'bundnere': ('bundet',),
'bundnest': ('bundet',),
'bundneste': ('bundet',),
'bundsforvandt': ('bundsforvandt',),
'bundsforvandte': ('bundsforvandt',),
'bundsforvandtere': ('bundsforvandt',),
'bundsforvandtest': ('bundsforvandt',),
'bundsforvandteste': ('bundsforvandt',),
'bunka': ('bunke',),
'bunkede': ('bunke',),
'bunkende': ('bunke',),
'bunket': ('bunke',),
'bunkete': ('bunke',),
'bunkra': ('bunkre',),
'bunkrede': ('bunkre',),
'bunkrende': ('bunkre',),
'bunkret': ('bunkre',),
'bunkrete': ('bunkre',),
'bunnfalsk': ('bunnfalsk',),
'bunnfalske': ('bunnfalsk',),
'bunnfalskere': ('bunnfalsk',),
'bunnfalskest': ('bunnfalsk',),
'bunnfalskeste': ('bunnfalsk',),
'bunnfalskt': ('bunnfalsk',),
'bunnfellende': ('bunnfelle',),
'bunnfelt': ('bunnfelle',),
'bunnfelte': ('bunnfelle',),
'bunnhederlig': ('bunnhederlig',),
'bunnhederlige': ('bunnhederlig',),
'bunnhederligere': ('bunnhederlig',),
'bunnhederligst': ('bunnhederlig',),
'bunnhederligste': ('bunnhederlig',),
'bunnlaus': ('bunnlaus',),
'bunnlause': ('bunnlaus',),
'bunnlausere': ('bunnlaus',),
'bunnlausest': ('bunnlaus',),
'bunnlauseste': ('bunnlaus',),
'bunnlaust': ('bunnlaus',),
'bunnløs': ('bunnløs',),
'bunnløse': ('bunnløs',),
'bunnløsere': ('bunnløs',),
'bunnløsest': ('bunnløs',),
'bunnløseste': ('bunnløs',),
'bunnløst': ('bunnløs',),
'bunnskrapa': ('bunnskrape',),
'bunnskrapede': ('bunnskrape',),
'bunnskrapende': ('bunnskrape',),
'bunnskrapet': ('bunnskrape',),
'bunnskrapete': ('bunnskrape',),
'bunnskrapt': ('bunnskrape',),
'bunnskrapte': ('bunnskrape',),
'bunnsolid': ('bunnsolid',),
'bunnsolide': ('bunnsolid',),
'bunnsolidere': ('bunnsolid',),
'bunnsolidest': ('bunnsolid',),
'bunnsolideste': ('bunnsolid',),
'bunta': ('bunte',),
'buntede': ('bunte',),
'buntende': ('bunte',),
'buntet': ('bunte',),
'buntete': ('bunte',),
'bura': ('bure',),
'burede': ('bure',),
'burende': ('bure',),
'buret': ('bure',),
'burete': ('bure',),
'burt': ('bure',),
'burte': ('bure',),
'bura': ('bure',),
'burede': ('bure',),
'burende': ('bure',),
'buret': ('bure',),
'burete': ('bure',),
'burt': ('bure',),
'burte': ('bure',),
'burgunderrød': ('burgunderrød',),
'burgunderrøde': ('burgunderrød',),
'burgunderrødere': ('burgunderrød',),
'burgunderrødest': ('burgunderrød',),
'burgunderrødeste': ('burgunderrød',),
'burgunderrødt': ('burgunderrød',),
'burgundisk': ('burgundisk',),
'burgundiske': ('burgundisk',),
'burgundiskere': ('burgundisk',),
'burgundiskest': ('burgundisk',),
'burgundiskeste': ('burgundisk',),
'burjatisk': ('burjatisk',),
'burjatiske': ('burjatisk',),
'burjatiskere': ('burjatisk',),
'burjatiskest': ('burjatisk',),
'burjatiskeste': ('burjatisk',),
'burkinsk': ('burkinsk',),
'burkinske': ('burkinsk',),
'burkinskere': ('burkinsk',),
'burkinskest': ('burkinsk',),
'burkinskeste': ('burkinsk',),
'burlesk': ('burlesk',),
'burleske': ('burlesk',),
'burleskere': ('burlesk',),
'burleskest': ('burlesk',),
'burleskeste': ('burlesk',),
'burmansk': ('burmansk',),
'burmanske': ('burmansk',),
'burmanskere': ('burmansk',),
'burmanskest': ('burmansk',),
'burmanskeste': ('burmansk',),
'bursjikos': ('bursjikos',),
'bursjikose': ('bursjikos',),
'bursjikosere': ('bursjikos',),
'bursjikosest': ('bursjikos',),
'bursjikoseste': ('bursjikos',),
'burundisk': ('burundisk',),
'burundiske': ('burundisk',),
'burundiskere': ('burundisk',),
'burundiskest': ('burundisk',),
'burundiskeste': ('burundisk',),
'busatt': ('busatt',),
'busatte': ('busatt',),
'busattere': ('busatt',),
'busattest': ('busatt',),
'busatteste': ('busatt',),
'busa': ('buse',),
'busede': ('buse',),
'busende': ('buse',),
'buset': ('buse',),
'busete': ('buse',),
'bust': ('buse',),
'buste': ('buse',),
'busatt': ('busette',),
'busatte': ('busette',),
'busettende': ('busette',),
'buska': ('buske',),
'buskede': ('buske',),
'buskende': ('buske',),
'busket': ('buske',),
'buskete': ('buske',),
'busket': ('busket',),
'buskete': ('busket',),
'busketere': ('busket',),
'busketest': ('busket',),
'busketeste': ('busket',),
'buskete': ('buskete',),
'bussa': ('busse',),
'bussede': ('busse',),
'bussende': ('busse',),
'busset': ('busse',),
'bussete': ('busse',),
'busta': ('buste',),
'bustede': ('buste',),
'bustende': ('buste',),
'bustet': ('buste',),
'bustete': ('buste',),
'bustet': ('bustet',),
'bustete': ('bustet',),
'bustetere': ('bustet',),
'bustetest': ('bustet',),
'busteteste': ('bustet',),
'bustete': ('bustete',),
'butt': ('butt',),
'butte': ('butt',),
'buttere': ('butt',),
'buttest': ('butt',),
'butteste': ('butt',),
'butta': ('butte',),
'buttede': ('butte',),
'buttende': ('butte',),
'buttet': ('butte',),
'buttete': ('butte',),
'buttet': ('buttet',),
'buttete': ('buttet',),
'buttetere': ('buttet',),
'buttetest': ('buttet',),
'butteteste': ('buttet',),
'buttete': ('buttete',),
'budt': ('by',),
'budte': ('by',),
'bydd': ('by',),
'bydde': ('by',),
'byende': ('by',),
'budt': ('by',),
'budte': ('by',),
'bydd': ('by',),
'bydde': ('by',),
'byende': ('by',),
'budt': ('byde',),
'budte': ('byde',),
'bydd': ('byde',),
'bydde': ('byde',),
'bydende': ('byde',),
'bydende': ('bydende',),
'byet': ('byet',),
'byete': ('byet',),
'byetere': ('byet',),
'byetest': ('byet',),
'byeteste': ('byet',),
'byet': ('byet',),
'byete': ('byet',),
'byetere': ('byet',),
'byetest': ('byet',),
'byeteste': ('byet',),
'byete': ('byete',),
'byete': ('byete',),
'byget': ('byget',),
'bygete': ('byget',),
'bygetere': ('byget',),
'bygetest': ('byget',),
'bygeteste': ('byget',),
'byget': ('byget',),
'bygete': ('byget',),
'bygetere': ('byget',),
'bygetest': ('byget',),
'bygeteste': ('byget',),
'bygete': ('bygete',),
'bygete': ('bygete',),
'bygd': ('bygge',),
'bygde': ('bygge',),
'bygga': ('bygge',),
'byggede': ('bygge',),
'byggende': ('bygge',),
'bygget': ('bygge',),
'byggete': ('bygge',),
'byggeklar': ('byggeklar',),
'byggeklare': ('byggeklar',),
'byggeklarere': ('byggeklar',),
'byggeklarest': ('byggeklar',),
'byggeklareste': ('byggeklar',),
'byggeklart': ('byggeklar',),
'bygsla': ('bygsle',),
'bygslede': ('bygsle',),
'bygslende': ('bygsle',),
'bygslet': ('bygsle',),
'bygslete': ('bygsle',),
'byksende': ('bykse',),
'bykst': ('bykse',),
'bykste': ('bykse',),
'bylta': ('bylte',),
'byltede': ('bylte',),
'byltende': ('bylte',),
'byltet': ('bylte',),
'byltete': ('bylte',),
'bymessig': ('bymessig',),
'bymessige': ('bymessig',),
'bymessigere': ('bymessig',),
'bymessigst': ('bymessig',),
'bymessigste': ('bymessig',),
'byrdefull': ('byrdefull',),
'byrdefulle': ('byrdefull',),
'byrdefullere': ('byrdefull',),
'byrdefullest': ('byrdefull',),
'byrdefulleste': ('byrdefull',),
'byrdefullt': ('byrdefull',),
'byrg': ('byrg',),
'byrge': ('byrg',),
'byrgere': ('byrg',),
'byrgest': ('byrg',),
'byrgeste': ('byrg',),
'byrgt': ('byrg',),
'byråkratiserende': ('byråkratisere',),
'byråkratisert': ('byråkratisere',),
'byråkratiserte': ('byråkratisere',),
'byråkratisk': ('byråkratisk',),
'byråkratiske': ('byråkratisk',),
'byråkratiskere': ('byråkratisk',),
'byråkratiskest': ('byråkratisk',),
'byråkratiskeste': ('byråkratisk',),
'bysantinsk': ('bysantinsk',),
'bysantinske': ('bysantinsk',),
'bysantinskere': ('bysantinsk',),
'bysantinskest': ('bysantinsk',),
'bysantinskeste': ('bysantinsk',),
'byssa': ('bysse',),
'byssede': ('bysse',),
'byssende': ('bysse',),
'bysset': ('bysse',),
'byssete': ('bysse',),
'bytta': ('bytte',),
'byttede': ('bytte',),
'byttende': ('bytte',),
'byttet': ('bytte',),
'byttete': ('bytte',),
'byttelånende': ('byttelåne',),
'byttelånt': ('byttelåne',),
'byttelånte': ('byttelåne',),
'båndlagt': ('båndlegge',),
'båndlagte': ('båndlegge',),
'båndleggende': ('båndlegge',),
'båra': ('båre',),
'bårede': ('båre',),
'bårende': ('båre',),
'båret': ('båre',),
'bårete': ('båre',),
'båtvant': ('båtvant',),
'båtvante': ('båtvant',),
'båtvantere': ('båtvant',),
'båtvantest': ('båtvant',),
'båtvanteste': ('båtvant',),
'bærbar': ('bærbar',),
'bærbare': ('bærbar',),
'bærbarere': ('bærbar',),
'bærbarest': ('bærbar',),
'bærbareste': ('bærbar',),
'bærbart': ('bærbar',),
'bærekraftig': ('bærekraftig',),
'bærekraftige': ('bærekraftig',),
'bærekraftigere': ('bærekraftig',),
'bærekraftigst': ('bærekraftig',),
'bærekraftigste': ('bærekraftig',),
'bæsja': ('bæsje',),
'bæsjede': ('bæsje',),
'bæsjende': ('bæsje',),
'bæsjet': ('bæsje',),
'bæsjete': ('bæsje',),
'bøhmisk': ('bøhmisk',),
'bøhmiske': ('bøhmisk',),
'bøhmiskere': ('bøhmisk',),
'bøhmiskest': ('bøhmisk',),
'bøhmiskeste': ('bøhmisk',),
'bølga': ('bølge',),
'bølgede': ('bølge',),
'bølgende': ('bølge',),
'bølget': ('bølge',),
'bølgete': ('bølge',),
'bølgja': ('bølgje',),
'bølgjede': ('bølgje',),
'bølgjende': ('bølgje',),
'bølgjet': ('bølgje',),
'bølgjete': ('bølgje',),
'bøllet': ('bøllet',),
'bøllete': ('bøllet',),
'bølletere': ('bøllet',),
'bølletest': ('bøllet',),
'bølleteste': ('bøllet',),
'bøllete': ('bøllete',),
'bønnfallende': ('bønnfalle',),
'bønnfalt': ('bønnfalle',),
'bønnfalte': ('bønnfalle',),
'bønnhørende': ('bønnhøre',),
'bønnhørt': ('bønnhøre',),
'bønnhørte': ('bønnhøre',),
'bønnlig': ('bønnlig',),
'bønnlige': ('bønnlig',),
'bønnligere': ('bønnlig',),
'bønnligst': ('bønnlig',),
'bønnligste': ('bønnlig',),
'børsa': ('børse',),
'børsede': ('børse',),
'børsende': ('børse',),
'børset': ('børse',),
'børsete': ('børse',),
'børsnoterende': ('børsnotere',),
'børsnotert': ('børsnotere',),
'børsnoterte': ('børsnotere',),
'børsta': ('børste',),
'børstede': ('børste',),
'børstende': ('børste',),
'børstet': ('børste',),
'børstete': ('børste',),
'børsten': ('børsten',),
'børstent': ('børsten',),
'børstne': ('børsten',),
'børstnere': ('børsten',),
'børstnest': ('børsten',),
'børstneste': ('børsten',),
'bøs': ('bøs',),
'bøse': ('bøs',),
'bøsere': ('bøs',),
'bøsest': ('bøs',),
'bøseste': ('bøs',),
'bøst': ('bøs',),
'bøtende': ('bøte',),
'bøtt': ('bøte',),
'bøtte': ('bøte',),
'bøtelagt': ('bøtelegge',),
'bøtelagte': ('bøtelegge',),
'bøteleggende': ('bøtelegge',),
'bøya': ('bøye',),
'bøyd': ('bøye',),
'bøyde': ('bøye',),
'bøyede': ('bøye',),
'bøyende': ('bøye',),
'bøyet': ('bøye',),
'bøyete': ('bøye',),
'bøyefast': ('bøyefast',),
'bøyefaste': ('bøyefast',),
'bøyefastere': ('bøyefast',),
'bøyefastest': ('bøyefast',),
'bøyefasteste': ('bøyefast',),
'bøyelig': ('bøyelig',),
'bøyelige': ('bøyelig',),
'bøyeligere': ('bøyelig',),
'bøyeligst': ('bøyelig',),
'bøyeligste': ('bøyelig',),
'bøyet': ('bøyet',),
'bøyete': ('bøyet',),
'bøyetere': ('bøyet',),
'bøyetest': ('bøyet',),
'bøyeteste': ('bøyet',),
'bøyet': ('bøyet',),
'bøyete': ('bøyet',),
'bøyetere': ('bøyet',),
'bøyetest': ('bøyet',),
'bøyeteste': ('bøyet',),
'bøyete': ('bøyete',),
'bøyete': ('bøyete',),
'californisk': ('californisk',),
'californiske': ('californisk',),
'californiskere': ('californisk',),
'californiskest': ('californisk',),
'californiskeste': ('californisk',),
'campa': ('campe',),
'campede': ('campe',),
'campende': ('campe',),
'campet': ('campe',),
'campete': ('campe',),
'canadisk': ('canadisk',),
'canadiske': ('canadisk',),
'canadiskere': ('canadisk',),
'canadiskest': ('canadisk',),
'canadiskeste': ('canadisk',),
'cash': ('cash',),
'casha': ('cashe',),
'cashede': ('cashe',),
'cashende': ('cashe',),
'cashet': ('cashe',),
'cashete': ('cashe',),
'celeber': ('celeber',),
'celebert': ('celeber',),
'celebre': ('celeber',),
'celebrere': ('celeber',),
'celebrest': ('celeber',),
'celebreste': ('celeber',),
'celebrerende': ('celebrere',),
'celebrert': ('celebrere',),
'celebrerte': ('celebrere',),
'celest': ('celest',),
'celeste': ('celest',),
'celestere': ('celest',),
'celestest': ('celest',),
'celesteste': ('celest',),
'cellular': ('cellular',),
'cellulare': ('cellular',),
'cellularere': ('cellular',),
'cellularest': ('cellular',),
'cellulareste': ('cellular',),
'cellulart': ('cellular',),
'cellulær': ('cellulær',),
'cellulære': ('cellulær',),
'cellulærere': ('cellulær',),
'cellulærest': ('cellulær',),
'cellulæreste': ('cellulær',),
'cellulært': ('cellulær',),
'cendre': ('cendre',),
'cerebral': ('cerebral',),
'cerebrale': ('cerebral',),
'cerebralere': ('cerebral',),
'cerebralest': ('cerebral',),
'cerebraleste': ('cerebral',),
'cerebralt': ('cerebral',),
'cerebral parese-ramma': ('cerebral parese-ramma',),
'cerebral parese-rammede': ('cerebral parese-rammet',),
'cerebral parese-rammet': ('cerebral parese-rammet',),
'cerebral parese-rammete': ('cerebral parese-rammet',),
'cerebral parese-rammetere': ('cerebral parese-rammet',),
'cerebral parese-rammetest': ('cerebral parese-rammet',),
'cerebral parese-rammeteste': ('cerebral parese-rammet',),
'ceylonsk': ('ceylonsk',),
'ceylonske': ('ceylonsk',),
'ceylonskere': ('ceylonsk',),
'ceylonskest': ('ceylonsk',),
'ceylonskeste': ('ceylonsk',),
'changeant': ('changeant',),
'changerende': ('changere',),
'changert': ('changere',),
'changerte': ('changere',),
'chartra': ('chartre',),
'chartrede': ('chartre',),
'chartrende': ('chartre',),
'chartret': ('chartre',),
'chartrete': ('chartre',),
'chevaleresk': ('chevaleresk',),
'chevalereske': ('chevaleresk',),
'chevalereskere': ('chevaleresk',),
'chevalereskest': ('chevaleresk',),
'chevalereskeste': ('chevaleresk',),
'chevroterende': ('chevrotere',),
'chevrotert': ('chevrotere',),
'chevroterte': ('chevrotere',),
'chic': ('chic',),
'chice': ('chic',),
'chicere': ('chic',),
'chicest': ('chic',),
'chiceste': ('chic',),
'chict': ('chic',),
'chiffrerende': ('chiffrere',),
'chiffrert': ('chiffrere',),
'chiffrerte': ('chiffrere',),
'chilensk': ('chilensk',),
'chilenske': ('chilensk',),
'chilenskere': ('chilensk',),
'chilenskest': ('chilensk',),
'chilenskeste': ('chilensk',),
'choka': ('choke',),
'chokede': ('choke',),
'chokende': ('choke',),
'choket': ('choke',),
'chokete': ('choke',),
'cirkumpolar': ('cirkumpolar',),
'cirkumpolare': ('cirkumpolar',),
'cirkumpolarere': ('cirkumpolar',),
'cirkumpolarest': ('cirkumpolar',),
'cirkumpolareste': ('cirkumpolar',),
'cirkumpolart': ('cirkumpolar',),
'cirkumpolær': ('cirkumpolær',),
'cirkumpolære': ('cirkumpolær',),
'cirkumpolærere': ('cirkumpolær',),
'cirkumpolærest': ('cirkumpolær',),
'cirkumpolæreste': ('cirkumpolær',),
'cirkumpolært': ('cirkumpolær',),
'cisalpinsk': ('cisalpinsk',),
'cisalpinske': ('cisalpinsk',),
'cisalpinskere': ('cisalpinsk',),
'cisalpinskest': ('cisalpinsk',),
'cisalpinskeste': ('cisalpinsk',),
'clairvoyant': ('clairvoyant',),
'clairvoyante': ('clairvoyant',),
'clairvoyantere': ('clairvoyant',),
'clairvoyantest': ('clairvoyant',),
'clairvoyanteste': ('clairvoyant',),
'clincha': ('clinche',),
'clinchede': ('clinche',),
'clinchende': ('clinche',),
'clinchet': ('clinche',),
'clinchete': ('clinche',),
'clutcha': ('clutche',),
'clutchede': ('clutche',),
'clutchende': ('clutche',),
'clutchet': ('clutche',),
'clutchete': ('clutche',),
'colombiansk': ('colombiansk',),
'colombianske': ('colombiansk',),
'colombianskere': ('colombiansk',),
'colombianskest': ('colombiansk',),
'colombianskeste': ('colombiansk',),
'comme il faut': ('comme il faut',),
'corny': ('corny',),
'corsicansk': ('corsicansk',),
'corsicanske': ('corsicansk',),
'corsicanskere': ('corsicansk',),
'corsicanskest': ('corsicansk',),
'corsicanskeste': ('corsicansk',),
'costaricansk': ('costaricansk',),
'costaricanske': ('costaricansk',),
'costaricanskere': ('costaricansk',),
'costaricanskest': ('costaricansk',),
'costaricanskeste': ('costaricansk',),
'crazy': ('crazy',),
'cruisa': ('cruise',),
'cruisede': ('cruise',),
'cruisende': ('cruise',),
'cruiset': ('cruise',),
'cruisete': ('cruise',),
'cubansk': ('cubansk',),
'cubanske': ('cubansk',),
'cubanskere': ('cubansk',),
'cubanskest': ('cubansk',),
'cubanskeste': ('cubansk',),
'cyanidiserende': ('cyanidisere',),
'cyanidisert': ('cyanidisere',),
'cyanidiserte': ('cyanidisere',),
'cyklamen': ('cyklamen',),
'cystisk': ('cystisk',),
'cystiske': ('cystisk',),
'cystiskere': ('cystisk',),
'cystiskest': ('cystisk',),
'cystiskeste': ('cystisk',),
'cytologisk': ('cytologisk',),
'cytologiske': ('cytologisk',),
'cytologiskere': ('cytologisk',),
'cytologiskest': ('cytologisk',),
'cytologiskeste': ('cytologisk',),
'cæsarisk': ('cæsarisk',),
'cæsariske': ('cæsarisk',),
'cæsariskere': ('cæsarisk',),
'cæsariskest': ('cæsarisk',),
'cæsariskeste': ('cæsarisk',),
'cøliakisk': ('cøliakisk',),
'cøliakiske': ('cøliakisk',),
'cøliakiskere': ('cøliakisk',),
'cøliakiskest': ('cøliakisk',),
'cøliakiskeste': ('cøliakisk',),
'dabba': ('dabbe',),
'dabbede': ('dabbe',),
'dabbende': ('dabbe',),
'dabbet': ('dabbe',),
'dabbete': ('dabbe',),
'dadaistisk': ('dadaistisk',),
'dadaistiske': ('dadaistisk',),
'dadaistiskere': ('dadaistisk',),
'dadaistiskest': ('dadaistisk',),
'dadaistiskeste': ('dadaistisk',),
'daddellaus': ('daddellaus',),
'daddellause': ('daddellaus',),
'daddellausere': ('daddellaus',),
'daddellausest': ('daddellaus',),
'daddellauseste': ('daddellaus',),
'daddellaust': ('daddellaus',),
'daddelløs': ('daddelløs',),
'daddelløse': ('daddelløs',),
'daddelløsere': ('daddelløs',),
'daddelløsest': ('daddelløs',),
'daddelløseste': ('daddelløs',),
'daddelløst': ('daddelløs',),
'daddelverdig': ('daddelverdig',),
'daddelverdige': ('daddelverdig',),
'daddelverdigere': ('daddelverdig',),
'daddelverdigst': ('daddelverdig',),
'daddelverdigste': ('daddelverdig',),
'dadla': ('dadle',),
'dadlede': ('dadle',),
'dadlende': ('dadle',),
'dadlet': ('dadle',),
'dadlete': ('dadle',),
'daff': ('daff',),
'daffe': ('daff',),
'daffere': ('daff',),
'daffest': ('daff',),
'daffeste': ('daff',),
'daft': ('daff',),
'daffa': ('daffe',),
'daffede': ('daffe',),
'daffende': ('daffe',),
'daffet': ('daffe',),
'daffete': ('daffe',),
'dagdrømmende': ('dagdrømme',),
'dagdrømt': ('dagdrømme',),
'dagdrømte': ('dagdrømme',),
'daga': ('dage',),
'dagede': ('dage',),
'dagende': ('dage',),
'daget': ('dage',),
'dagete': ('dage',),
'daghavende': ('daghavende',),
'dagjeldende': ('dagjeldende',),
'daglig': ('daglig',),
'daglige': ('daglig',),
'dagligere': ('daglig',),
'dagligst': ('daglig',),
'dagligste': ('daglig',),
'dagligdags': ('dagligdags',),
'dagligdagse': ('dagligdags',),
'dagligdagsere': ('dagligdags',),
'dagligdagsest': ('dagligdags',),
'dagligdagseste': ('dagligdags',),
'dagsaktuell': ('dagsaktuell',),
'dagsaktuelle': ('dagsaktuell',),
'dagsaktuellere': ('dagsaktuell',),
'dagsaktuellest': ('dagsaktuell',),
'dagsaktuelleste': ('dagsaktuell',),
'dagsaktuelt': ('dagsaktuell',),
'dagsens': ('dagsens',),
'dagvill': ('dagvill',),
'dagville': ('dagvill',),
'dagvillere': ('dagvill',),
'dagvillest': ('dagvill',),
'dagvilleste': ('dagvill',),
'dagvilt': ('dagvill',),
'dagviss': ('dagviss',),
'dagvisse': ('dagviss',),
'dagvissere': ('dagviss',),
'dagvissest': ('dagviss',),
'dagvisseste': ('dagviss',),
'dagvisst': ('dagviss',),
'daktylisk': ('daktylisk',),
'daktyliske': ('daktylisk',),
'daktyliskere': ('daktylisk',),
'daktyliskest': ('daktylisk',),
'daktyliskeste': ('daktylisk',),
'dalende': ('dale',),
'dalt': ('dale',),
'dalte': ('dale',),
'dalet': ('dalet',),
'dalete': ('dalet',),
'daletere': ('dalet',),
'daletest': ('dalet',),
'daleteste': ('dalet',),
'dalete': ('dalete',),
'dalevende': ('dalevende',),
'dalka': ('dalke',),
'dalkede': ('dalke',),
'dalkende': ('dalke',),
'dalket': ('dalke',),
'dalkete': ('dalke',),
'dalmatisk': ('dalmatisk',),
'dalmatiske': ('dalmatisk',),
'dalmatiskere': ('dalmatisk',),
'dalmatiskest': ('dalmatisk',),
'dalmatiskeste': ('dalmatisk',),
'dalta': ('dalte',),
'daltede': ('dalte',),
'daltende': ('dalte',),
'daltet': ('dalte',),
'daltete': ('dalte',),
'damascerende': ('damascere',),
'damascert': ('damascere',),
'damascerte': ('damascere',),
'dampdrevet': ('dampdrevet',),
'dampdrevne': ('dampdrevet',),
'dampdrevnere': ('dampdrevet',),
'dampdrevnest': ('dampdrevet',),
'dampdrevneste': ('dampdrevet',),
'dampa': ('dampe',),
'dampede': ('dampe',),
'dampende': ('dampe',),
'dampet': ('dampe',),
'dampete': ('dampe',),
'dampkokende': ('dampkoke',),
'dampkokt': ('dampkoke',),
'dampkokte': ('dampkoke',),
'danderende': ('dandere',),
'dandert': ('dandere',),
'danderte': ('dandere',),
'dangla': ('dangle',),
'danglede': ('dangle',),
'danglende': ('dangle',),
'danglet': ('dangle',),
'danglete': ('dangle',),
'danka': ('danke',),
'dankede': ('danke',),
'dankende': ('danke',),
'danket': ('danke',),
'dankete': ('danke',),
'danna': ('danna',),
'danna': ('danne',),
'dannede': ('danne',),
'dannende': ('danne',),
'dannet': ('danne',),
'dannete': ('danne',),
'dannede': ('dannet',),
'dannet': ('dannet',),
'dannete': ('dannet',),
'dannetere': ('dannet',),
'dannetest': ('dannet',),
'danneteste': ('dannet',),
'dansa': ('danse',),
'dansede': ('danse',),
'dansende': ('danse',),
'danset': ('danse',),
'dansete': ('danse',),
'dansegal': ('dansegal',),
'dansegale': ('dansegal',),
'dansegalere': ('dansegal',),
'dansegalest': ('dansegal',),
'dansegaleste': ('dansegal',),
'dansegalt': ('dansegal',),
'dansk': ('dansk',),
'danske': ('dansk',),
'danskere': ('dansk',),
'danskest': ('dansk',),
'danskeste': ('dansk',),
'dansk-norsk': ('dansk-norsk',),
'dansk-norske': ('dansk-norsk',),
'dansk-norskere': ('dansk-norsk',),
'dansk-norskest': ('dansk-norsk',),
'dansk-norskeste': ('dansk-norsk',),
'danska': ('danske',),
'danskede': ('danske',),
'danskende': ('danske',),
'dansket': ('danske',),
'danskete': ('danske',),
'darra': ('darre',),
'darrede': ('darre',),
'darrende': ('darre',),
'darret': ('darre',),
'darrete': ('darre',),
'daska': ('daske',),
'daskede': ('daske',),
'daskende': ('daske',),
'dasket': ('daske',),
'daskete': ('daske',),
'databehandla': ('databehandle',),
'databehandlede': ('databehandle',),
'databehandlende': ('databehandle',),
'databehandlet': ('databehandle',),
'databehandlete': ('databehandle',),
'dataførende': ('dataføre',),
'dataført': ('dataføre',),
'dataførte': ('dataføre',),
'datagrafisk': ('datagrafisk',),
'datagrafiske': ('datagrafisk',),
'datagrafiskere': ('datagrafisk',),
'datagrafiskest': ('datagrafisk',),
'datagrafiskeste': ('datagrafisk',),
'datamaskinassistert': ('datamaskinassistert',),
'datamaskinassisterte': ('datamaskinassistert',),
'datamaskinassistertere': ('datamaskinassistert',),
'datamaskinassistertest': ('datamaskinassistert',),
'datamaskinassisterteste': ('datamaskinassistert',),
'datamaskinell': ('datamaskinell',),
'datamaskinelle': ('datamaskinell',),
'datamaskinellere': ('datamaskinell',),
'datamaskinellest': ('datamaskinell',),
'datamaskinelleste': ('datamaskinell',),
'datamaskinelt': ('datamaskinell',),
'datastyrende': ('datastyre',),
'datastyrt': ('datastyre',),
'datastyrte': ('datastyre',),
'daterende': ('datere',),
'datert': ('datere',),
'daterte': ('datere',),
'datidig': ('datidig',),
'datidige': ('datidig',),
'datidigere': ('datidig',),
'datidigst': ('datidig',),
'datidigste': ('datidig',),
'datostempla': ('datostemple',),
'datostemplede': ('datostemple',),
'datostemplende': ('datostemple',),
'datostemplet': ('datostemple',),
'datostemplete': ('datostemple',),
'dau': ('dau',),
'daue': ('dau',),
'dauere': ('dau',),
'dauest': ('dau',),
'daueste': ('dau',),
'daut': ('dau',),
'daubakt': ('daubakt',),
'daubakte': ('daubakt',),
'daubaktere': ('daubakt',),
'daubaktest': ('daubakt',),
'daubakteste': ('daubakt',),
'daud': ('daud',),
'daude': ('daud',),
'daudere': ('daud',),
'daudest': ('daud',),
'daudeste': ('daud',),
'daudt': ('daud',),
'daudbleik': ('daudbleik',),
'daudbleike': ('daudbleik',),
'daudbleikere': ('daudbleik',),
'daudbleikest': ('daudbleik',),
'daudbleikeste': ('daudbleik',),
'daudbleikt': ('daudbleik',),
'daudblek': ('daudblek',),
'daudbleke': ('daudblek',),
'daudblekere': ('daudblek',),
'daudblekest': ('daudblek',),
'daudblekeste': ('daudblek',),
'daudblekt': ('daudblek',),
'daudbrent': ('daudbrent',),
'daudbrente': ('daudbrent',),
'daudbrentere': ('daudbrent',),
'daudbrentest': ('daudbrent',),
'daudbrenteste': ('daudbrent',),
'dauddrukken': ('dauddrukken',),
'dauddrukkent': ('dauddrukken',),
'dauddrukne': ('dauddrukken',),
'dauddruknere': ('dauddrukken',),
'dauddruknest': ('dauddrukken',),
'dauddrukneste': ('dauddrukken',),
'dauda': ('daude',),
'daudede': ('daude',),
'daudende': ('daude',),
'daudet': ('daude',),
'daudete': ('daude',),
'daudfødd': ('daudfødd',),
'daudfødde': ('daudfødd',),
'daudføddere': ('daudfødd',),
'daudføddest': ('daudfødd',),
'daudføddeste': ('daudfødd',),
'daudfødt': ('daudfødt',),
'daudfødte': ('daudfødt',),
'daudfødtere': ('daudfødt',),
'daudfødtest': ('daudfødt',),
'daudfødteste': ('daudfødt',),
'daugjødsla': ('daugjødsle',),
'daugjødslede': ('daugjødsle',),
'daugjødslende': ('daugjødsle',),
'daugjødslet': ('daugjødsle',),
'daugjødslete': ('daugjødsle',),
'dauhogd': ('dauhogge',),
'dauhogde': ('dauhogge',),
'dauhoggede': ('dauhogge',),
'dauhoggende': ('dauhogge',),
'dauhogget': ('dauhogge',),
'dauhoggete': ('dauhogge',),
'dauhugd': ('dauhugge',),
'dauhugde': ('dauhugge',),
'dauhugga': ('dauhugge',),
'dauhuggede': ('dauhugge',),
'dauhuggende': ('dauhugge',),
'dauhugget': ('dauhugge',),
'dauhuggete': ('dauhugge',),
'daukjørende': ('daukjøre',),
'daukjørt': ('daukjøre',),
'daukjørte': ('daukjøre',),
'dausteikt': ('dausteikt',),
'dausteikte': ('dausteikt',),
'dausteiktere': ('dausteikt',),
'dausteiktest': ('dausteikt',),
'dausteikteste': ('dausteikt',),
'daustekt': ('daustekt',),
'daustekte': ('daustekt',),
'daustektere': ('daustekt',),
'daustektest': ('daustekt',),
'daustekteste': ('daustekt',),
'daværende': ('daværende',),
'debatterende': ('debattere',),
'debattert': ('debattere',),
'debatterte': ('debattere',),
'debil': ('debil',),
'debile': ('debil',),
'debilere': ('debil',),
'debilest': ('debil',),
'debileste': ('debil',),
'debilt': ('debil',),
'debiterende': ('debitere',),
'debitert': ('debitere',),
'debiterte': ('debitere',),
'debuterende': ('debutere',),
'debutert': ('debutere',),
'debuterte': ('debutere',),
'dechiffrerende': ('dechiffrere',),
'dechiffrert': ('dechiffrere',),
'dechiffrerte': ('dechiffrere',),
'dediserende': ('dedisere',),
'dedisert': ('dedisere',),
'dediserte': ('dedisere',),
'deduktiv': ('deduktiv',),
'deduktive': ('deduktiv',),
'deduktivere': ('deduktiv',),
'deduktivest': ('deduktiv',),
'deduktiveste': ('deduktiv',),
'deduktivt': ('deduktiv',),
'deduserende': ('dedusere',),
'dedusert': ('dedusere',),
'deduserte': ('dedusere',),
'defaitistisk': ('defaitistisk',),
'defaitistiske': ('defaitistisk',),
'defaitistiskere': ('defaitistisk',),
'defaitistiskest': ('defaitistisk',),
'defaitistiskeste': ('defaitistisk',),
'defekt': ('defekt',),
'defekte': ('defekt',),
'defektere': ('defekt',),
'defektest': ('defekt',),
'defekteste': ('defekt',),
'defensiv': ('defensiv',),
'defensive': ('defensiv',),
'defensivere': ('defensiv',),
'defensivest': ('defensiv',),
'defensiveste': ('defensiv',),
'defensivt': ('defensiv',),
'defilerende': ('defilere',),
'defilert': ('defilere',),
'defilerte': ('defilere',),
'definerbar': ('definerbar',),
'definerbare': ('definerbar',),
'definerbarere': ('definerbar',),
'definerbarest': ('definerbar',),
'definerbareste': ('definerbar',),
'definerbart': ('definerbar',),
'definerende': ('definere',),
'definert': ('definere',),
'definerte': ('definere',),
'definisjonsmessig': ('definisjonsmessig',),
'definisjonsmessige': ('definisjonsmessig',),
'definisjonsmessigere': ('definisjonsmessig',),
'definisjonsmessigst': ('definisjonsmessig',),
'definisjonsmessigste': ('definisjonsmessig',),
'definitiv': ('definitiv',),
'definitive': ('definitiv',),
'definitivere': ('definitiv',),
'definitivest': ('definitiv',),
'definitiveste': ('definitiv',),
'definitivt': ('definitiv',),
'definitorisk': ('definitorisk',),
'definitoriske': ('definitorisk',),
'definitoriskere': ('definitorisk',),
'definitoriskest': ('definitorisk',),
'definitoriskeste': ('definitorisk',),
'deflaterende': ('deflatere',),
'deflatert': ('deflatere',),
'deflaterte': ('deflatere',),
'deflatorisk': ('deflatorisk',),
'deflatoriske': ('deflatorisk',),
'deflatoriskere': ('deflatorisk',),
'deflatoriskest': ('deflatorisk',),
'deflatoriskeste': ('deflatorisk',),
'deflorerende': ('deflorere',),
'deflorert': ('deflorere',),
'deflorerte': ('deflorere',),
'deform': ('deform',),
'deforme': ('deform',),
'deformere': ('deform',),
'deformest': ('deform',),
'deformeste': ('deform',),
'deformt': ('deform',),
'deformerende': ('deformere',),
'deformert': ('deformere',),
'deformerte': ('deformere',),
'degenererende': ('degenerere',),
'degenerert': ('degenerere',),
'degenererte': ('degenerere',),
'degenerert': ('degenerert',),
'degenererte': ('degenerert',),
'degenerertere': ('degenerert',),
'degenerertest': ('degenerert',),
'degenererteste': ('degenerert',),
'degga': ('degge',),
'deggede': ('degge',),
'deggende': ('degge',),
'degget': ('degge',),
'deggete': ('degge',),
'degraderende': ('degradere',),
'degradert': ('degradere',),
'degraderte': ('degradere',),
'degressiv': ('degressiv',),
'degressive': ('degressiv',),
'degressivere': ('degressiv',),
'degressivest': ('degressiv',),
'degressiveste': ('degressiv',),
'degressivt': ('degressiv',),
'dehydrerende': ('dehydrere',),
'dehydrert': ('dehydrere',),
'dehydrerte': ('dehydrere',),
'deiget': ('deiget',),
'deigete': ('deiget',),
'deigetere': ('deiget',),
'deigetest': ('deiget',),
'deigeteste': ('deiget',),
'deigete': ('deigete',),
'deiktisk': ('deiktisk',),
'deiktiske': ('deiktisk',),
'deiktiskere': ('deiktisk',),
'deiktiskest': ('deiktisk',),
'deiktiskeste': ('deiktisk',),
'deilig': ('deilig',),
'deilige': ('deilig',),
'deiligere': ('deilig',),
'deiligst': ('deilig',),
'deiligste': ('deilig',),
'deisa': ('deise',),
'deisede': ('deise',),
'deisende': ('deise',),
'deiset': ('deise',),
'deisete': ('deise',),
'deist': ('deise',),
'deiste': ('deise',),
'deistisk': ('deistisk',),
'deistiske': ('deistisk',),
'deistiskere': ('deistisk',),
'deistiskest': ('deistisk',),
'deistiskeste': ('deistisk',),
'dekadent': ('dekadent',),
'dekadente': ('dekadent',),
'dekadentere': ('dekadent',),
'dekadentest': ('dekadent',),
'dekadenteste': ('dekadent',),
'dekadisk': ('dekadisk',),
'dekadiske': ('dekadisk',),
'dekadiskere': ('dekadisk',),
'dekadiskest': ('dekadisk',),
'dekadiskeste': ('dekadisk',),
'dekanterende': ('dekantere',),
'dekantert': ('dekantere',),
'dekanterte': ('dekantere',),
'dekaterende': ('dekatere',),
'dekatert': ('dekatere',),
'dekaterte': ('dekatere',),
'dekka': ('dekke',),
'dekkede': ('dekke',),
'dekkende': ('dekke',),
'dekket': ('dekke',),
'dekkete': ('dekke',),
'dekt': ('dekke',),
'dekte': ('dekke',),
'dekkende': ('dekkende',),
'dekkfrøa': ('dekkfrøa',),
'dekkfrøede': ('dekkfrøet',),
'dekkfrøet': ('dekkfrøet',),
'dekkfrøete': ('dekkfrøet',),
'dekkfrøetere': ('dekkfrøet',),
'dekkfrøetest': ('dekkfrøet',),
'dekkfrøeteste': ('dekkfrøet',),
'deklamerende': ('deklamere',),
'deklamert': ('deklamere',),
'deklamerte': ('deklamere',),
'deklaratorisk': ('deklaratorisk',),
'deklaratoriske': ('deklaratorisk',),
'deklaratoriskere': ('deklaratorisk',),
'deklaratoriskest': ('deklaratorisk',),
'deklaratoriskeste': ('deklaratorisk',),
'deklarerende': ('deklarere',),
'deklarert': ('deklarere',),
'deklarerte': ('deklarere',),
'deklasserende': ('deklassere',),
'deklassert': ('deklassere',),
'deklasserte': ('deklassere',),
'deklinabel': ('deklinabel',),
'deklinabelt': ('deklinabel',),
'deklinable': ('deklinabel',),
'deklinablere': ('deklinabel',),
'deklinablest': ('deklinabel',),
'deklinableste': ('deklinabel',),
'deklinerende': ('deklinere',),
'deklinert': ('deklinere',),
'deklinerte': ('deklinere',),
'dekningslaus': ('dekningslaus',),
'dekningslause': ('dekningslaus',),
'dekningslausere': ('dekningslaus',),
'dekningslausest': ('dekningslaus',),
'dekningslauseste': ('dekningslaus',),
'dekningslaust': ('dekningslaus',),
'dekningsløs': ('dekningsløs',),
'dekningsløse': ('dekningsløs',),
'dekningsløsere': ('dekningsløs',),
'dekningsløsest': ('dekningsløs',),
'dekningsløseste': ('dekningsløs',),
'dekningsløst': ('dekningsløs',),
'dekoda': ('dekode',),
'dekodede': ('dekode',),
'dekodende': ('dekode',),
'dekodet': ('dekode',),
'dekodete': ('dekode',),
'dekolletert': ('dekolletert',),
'dekolleterte': ('dekolletert',),
'dekolletertere': ('dekolletert',),
'dekolletertest': ('dekolletert',),
'dekolleterteste': ('dekolletert',),
'dekomponerende': ('dekomponere',),
'dekomponert': ('dekomponere',),
'dekomponerte': ('dekomponere',),
'dekorativ': ('dekorativ',),
'dekorative': ('dekorativ',),
'dekorativere': ('dekorativ',),
'dekorativest': ('dekorativ',),
'dekorativeste': ('dekorativ',),
'dekorativt': ('dekorativ',),
'dekorerende': ('dekorere',),
'dekorert': ('dekorere',),
'dekorerte': ('dekorere',),
'dekorterende': ('dekortere',),
'dekortert': ('dekortere',),
'dekorterte': ('dekortere',),
'dekreterende': ('dekretere',),
'dekretert': ('dekretere',),
'dekreterte': ('dekretere',),
'dekuperende': ('dekupere',),
'dekupert': ('dekupere',),
'dekuperte': ('dekupere',),
'delabialiserende': ('delabialisere',),
'delabialisert': ('delabialisere',),
'delabialiserte': ('delabialisere',),
'delaktig': ('delaktig',),
'delaktige': ('delaktig',),
'delaktigere': ('delaktig',),
'delaktigst': ('delaktig',),
'delaktigste': ('delaktig',),
'delende': ('dele',),
'delt': ('dele',),
'delte': ('dele',),
'delegerende': ('delegere',),
'delegert': ('delegere',),
'delegerte': ('delegere',),
'delegert': ('delegert',),
'delegerte': ('delegert',),
'delegertere': ('delegert',),
'delegertest': ('delegert',),
'delegerteste': ('delegert',),
'delelig': ('delelig',),
'delelige': ('delelig',),
'deleligere': ('delelig',),
'deleligst': ('delelig',),
'deleligste': ('delelig',),
'delerende': ('delere',),
'delert': ('delere',),
'delerte': ('delere',),
'delikat': ('delikat',),
'delikate': ('delikat',),
'delikatere': ('delikat',),
'delikatest': ('delikat',),
'delikateste': ('delikat',),
'delikaterende': ('delikatere',),
'delikatert': ('delikatere',),
'delikaterte': ('delikatere',),
'delirant': ('delirant',),
'delirante': ('delirant',),
'delirantere': ('delirant',),
'delirantest': ('delirant',),
'deliranteste': ('delirant',),
'delirerende': ('delirere',),
'delirert': ('delirere',),
'delirerte': ('delirere',),
'delja': ('delje',),
'deljede': ('delje',),
'deljende': ('delje',),
'deljet': ('delje',),
'deljete': ('delje',),
'deltakende': ('delta',),
'deltatt': ('delta',),
'deltatte': ('delta',),
'deltaforma': ('deltaforma',),
'deltaformede': ('deltaformet',),
'deltaformet': ('deltaformet',),
'deltaformete': ('deltaformet',),
'deltaformetere': ('deltaformet',),
'deltaformetest': ('deltaformet',),
'deltaformeteste': ('deltaformet',),
'deltagende': ('deltagende',),
'deltakende': ('deltakende',),
'deltidsansatt': ('deltidsansatt',),
'deltidsansatte': ('deltidsansatt',),
'deltidsansattere': ('deltidsansatt',),
'deltidsansattest': ('deltidsansatt',),
'deltidsansatteste': ('deltidsansatt',),
'demagogisk': ('demagogisk',),
'demagogiske': ('demagogisk',),
'demagogiskere': ('demagogisk',),
'demagogiskest': ('demagogisk',),
'demagogiskeste': ('demagogisk',),
'demaskerende': ('demaskere',),
'demaskert': ('demaskere',),
'demaskerte': ('demaskere',),
'dementerende': ('dementere',),
'dementert': ('dementere',),
'dementerte': ('dementere',),
'demi-sec': ('demi-sec',),
'demilitariserende': ('demilitarisere',),
'demilitarisert': ('demilitarisere',),
'demilitariserte': ('demilitarisere',),
'demisjonerende': ('demisjonere',),
'demisjonert': ('demisjonere',),
'demisjonerte': ('demisjonere',),
'demma': ('demme',),
'demmede': ('demme',),
'demmende': ('demme',),
'demmet': ('demme',),
'demmete': ('demme',),
'demt': ('demme',),
'demte': ('demme',),
'demobiliserende': ('demobilisere',),
'demobilisert': ('demobilisere',),
'demobiliserte': ('demobilisere',),
'demografisk': ('demografisk',),
'demografiske': ('demografisk',),
'demografiskere': ('demografisk',),
'demografiskest': ('demografisk',),
'demografiskeste': ('demografisk',),
'demokratiserende': ('demokratisere',),
'demokratisert': ('demokratisere',),
'demokratiserte': ('demokratisere',),
'demokratisk': ('demokratisk',),
'demokratiske': ('demokratisk',),
'demokratiskere': ('demokratisk',),
'demokratiskest': ('demokratisk',),
'demokratiskeste': ('demokratisk',),
'demolerende': ('demolere',),
'demolert': ('demolere',),
'demolerte': ('demolere',),
'demonisk': ('demonisk',),
'demoniske': ('demonisk',),
'demoniskere': ('demonisk',),
'demoniskest': ('demonisk',),
'demoniskeste': ('demonisk',),
'demonstrativ': ('demonstrativ',),
'demonstrative': ('demonstrativ',),
'demonstrativere': ('demonstrativ',),
'demonstrativest': ('demonstrativ',),
'demonstrativeste': ('demonstrativ',),
'demonstrativt': ('demonstrativ',),
'demonstrerende': ('demonstrere',),
'demonstrert': ('demonstrere',),
'demonstrerte': ('demonstrere',),
'demonterende': ('demontere',),
'demontert': ('demontere',),
'demonterte': ('demontere',),
'demoraliserende': ('demoralisere',),
'demoralisert': ('demoralisere',),
'demoraliserte': ('demoralisere',),
'dempa': ('dempe',),
'dempede': ('dempe',),
'dempende': ('dempe',),
'dempet': ('dempe',),
'dempete': ('dempe',),
'demra': ('demre',),
'demrede': ('demre',),
'demrende': ('demre',),
'demret': ('demre',),
'demrete': ('demre',),
'den slags': ('den slags',),
'denasjonaliserende': ('denasjonalisere',),
'denasjonalisert': ('denasjonalisere',),
'denasjonaliserte': ('denasjonalisere',),
'denaturaliserende': ('denaturalisere',),
'denaturalisert': ('denaturalisere',),
'denaturaliserte': ('denaturalisere',),
'denaturerende': ('denaturere',),
'denaturert': ('denaturere',),
'denaturerte': ('denaturere',),
'dengende': ('denge',),
'dengt': ('denge',),
'dengte': ('denge',),
'dennesidig': ('dennesidig',),
'dennesidige': ('dennesidig',),
'dennesidigere': ('dennesidig',),
'dennesidigst': ('dennesidig',),
'dennesidigste': ('dennesidig',),
'denominativ': ('denominativ',),
'denominative': ('denominativ',),
'denominativere': ('denominativ',),
'denominativest': ('denominativ',),
'denominativeste': ('denominativ',),
'denominativt': ('denominativ',),
'denotativ': ('denotativ',),
'denotative': ('denotativ',),
'denotativere': ('denotativ',),
'denotativest': ('denotativ',),
'denotativeste': ('denotativ',),
'denotativt': ('denotativ',),
'denoterende': ('denotere',),
'denotert': ('denotere',),
'denoterte': ('denotere',),
'dental': ('dental',),
'dentale': ('dental',),
'dentalere': ('dental',),
'dentalest': ('dental',),
'dentaleste': ('dental',),
'dentalt': ('dental',),
'denuderende': ('denudere',),
'denudert': ('denudere',),
'denuderte': ('denudere',),
'deoksiderende': ('deoksidere',),
'deoksidert': ('deoksidere',),
'deoksiderte': ('deoksidere',),
'departemental': ('departemental',),
'departementale': ('departemental',),
'departementalere': ('departemental',),
'departementalest': ('departemental',),
'departementaleste': ('departemental',),
'departementalt': ('departemental',),
'deponent': ('deponent',),
'deponente': ('deponent',),
'deponentere': ('deponent',),
'deponentest': ('deponent',),
'deponenteste': ('deponent',),
'deponerende': ('deponere',),
'deponert': ('deponere',),
'deponerte': ('deponere',),
'deporterende': ('deportere',),
'deportert': ('deportere',),
'deporterte': ('deportere',),
'deppa': ('deppa',),
'deppa': ('deppe',),
'deppede': ('deppe',),
'deppende': ('deppe',),
'deppet': ('deppe',),
'deppete': ('deppe',),
'depraverende': ('depravere',),
'depravert': ('depravere',),
'depraverte': ('depravere',),
'depressiv': ('depressiv',),
'depressive': ('depressiv',),
'depressivere': ('depressiv',),
'depressivest': ('depressiv',),
'depressiveste': ('depressiv',),
'depressivt': ('depressiv',),
'deprimerende': ('deprimere',),
'deprimert': ('deprimere',),
'deprimerte': ('deprimere',),
'deprimert': ('deprimert',),
'deprimerte': ('deprimert',),
'deprimertere': ('deprimert',),
'deprimertest': ('deprimert',),
'deprimerteste': ('deprimert',),
'deprivatiserende': ('deprivatisere',),
'deprivatisert': ('deprivatisere',),
'deprivatiserte': ('deprivatisere',),
'deputert': ('deputert',),
'deputerte': ('deputert',),
'deputertere': ('deputert',),
'deputertest': ('deputert',),
'deputerteste': ('deputert',),
'derangerende': ('derangere',),
'derangert': ('derangere',),
'derangerte': ('derangere',),
'derangert': ('derangert',),
'derangerte': ('derangert',),
'derangertere': ('derangert',),
'derangertest': ('derangert',),
'derangerteste': ('derangert',),
'derelinkverende': ('derelinkvere',),
'derelinkvert': ('derelinkvere',),
'derelinkverte': ('derelinkvere',),
'deriverbar': ('deriverbar',),
'deriverbare': ('deriverbar',),
'deriverbarere': ('deriverbar',),
'deriverbarest': ('deriverbar',),
'deriverbareste': ('deriverbar',),
'deriverbart': ('deriverbar',),
'deriverende': ('derivere',),
'derivert': ('derivere',),
'deriverte': ('derivere',),
'derværende': ('derværende',),
'desarmerende': ('desarmere',),
'desarmert': ('desarmere',),
'desarmerte': ('desarmere',),
'desavuerende': ('desavuere',),
'desavuert': ('desavuere',),
'desavuerte': ('desavuere',),
'desentraliserende': ('desentralisere',),
'desentralisert': ('desentralisere',),
'desentraliserte': ('desentralisere',),
'deserterende': ('desertere',),
'desertert': ('desertere',),
'deserterte': ('desertere',),
'desiderende': ('desidere',),
'desidert': ('desidere',),
'desiderte': ('desidere',),
'desidert': ('desidert',),
'desiderte': ('desidert',),
'desidertere': ('desidert',),
'desidertest': ('desidert',),
'desiderteste': ('desidert',),
'designa': ('designe',),
'designede': ('designe',),
'designende': ('designe',),
'designet': ('designe',),
'designete': ('designe',),
'desillusjonerende': ('desillusjonere',),
'desillusjonert': ('desillusjonere',),
'desillusjonerte': ('desillusjonere',),
'desillusjonert': ('desillusjonert',),
'desillusjonerte': ('desillusjonert',),
'desillusjonertere': ('desillusjonert',),
'desillusjonertest': ('desillusjonert',),
'desillusjonerteste': ('desillusjonert',),
'desimerende': ('desimere',),
'desimert': ('desimere',),
'desimerte': ('desimere',),
'desinfiserende': ('desinfisere',),
'desinfisert': ('desinfisere',),
'desinfiserte': ('desinfisere',),
'desinformerende': ('desinformere',),
'desinformert': ('desinformere',),
'desinformerte': ('desinformere',),
'desintegrerende': ('desintegrere',),
'desintegrert': ('desintegrere',),
'desintegrerte': ('desintegrere',),
'deskriptiv': ('deskriptiv',),
'deskriptive': ('deskriptiv',),
'deskriptivere': ('deskriptiv',),
'deskriptivest': ('deskriptiv',),
'deskriptiveste': ('deskriptiv',),
'deskriptivt': ('deskriptiv',),
'desoksiderende': ('desoksidere',),
'desoksidert': ('desoksidere',),
'desoksiderte': ('desoksidere',),
'desorganiserende': ('desorganisere',),
'desorganisert': ('desorganisere',),
'desorganiserte': ('desorganisere',),
'desorienterende': ('desorientere',),
'desorientert': ('desorientere',),
'desorienterte': ('desorientere',),
'desorientert': ('desorientert',),
'desorienterte': ('desorientert',),
'desorientertere': ('desorientert',),
'desorientertest': ('desorientert',),
'desorienterteste': ('desorientert',),
'desperat': ('desperat',),
'desperate': ('desperat',),
'desperatere': ('desperat',),
'desperatest': ('desperat',),
'desperateste': ('desperat',),
'despotisk': ('despotisk',),
'despotiske': ('despotisk',),
'despotiskere': ('despotisk',),
'despotiskest': ('despotisk',),
'despotiskeste': ('despotisk',),
'desslike': ('desslike',),
'destillerende': ('destillere',),
'destillert': ('destillere',),
'destillerte': ('destillere',),
'destruerende': ('destruere',),
'destruert': ('destruere',),
'destruerte': ('destruere',),
'destruktiv': ('destruktiv',),
'destruktive': ('destruktiv',),
'destruktivere': ('destruktiv',),
'destruktivest': ('destruktiv',),
'destruktiveste': ('destruktiv',),
'destruktivt': ('destruktiv',),
'detaljbehandla': ('detaljbehandle',),
'detaljbehandlede': ('detaljbehandle',),
'detaljbehandlende': ('detaljbehandle',),
'detaljbehandlet': ('detaljbehandle',),
'detaljbehandlete': ('detaljbehandle',),
'detaljerende': ('detaljere',),
'detaljert': ('detaljere',),
'detaljerte': ('detaljere',),
'detaljert': ('detaljert',),
'detaljerte': ('detaljert',),
'detaljertere': ('detaljert',),
'detaljertest': ('detaljert',),
'detaljerteste': ('detaljert',),
'detaljrik': ('detaljrik',),
'detaljrike': ('detaljrik',),
'detaljrikere': ('detaljrik',),
'detaljrikest': ('detaljrik',),
'detaljrikeste': ('detaljrik',),
'detaljrikt': ('detaljrik',),
'detasjerende': ('detasjere',),
'detasjert': ('detasjere',),
'detasjerte': ('detasjere',),
'detasjerende': ('detasjere',),
'detasjert': ('detasjere',),
'detasjerte': ('detasjere',),
'determinativ': ('determinativ',),
'determinative': ('determinativ',),
'determinativere': ('determinativ',),
'determinativest': ('determinativ',),
'determinativeste': ('determinativ',),
'determinativt': ('determinativ',),
'determinerende': ('determinere',),
'determinert': ('determinere',),
'determinerte': ('determinere',),
'deterministisk': ('deterministisk',),
'deterministiske': ('deterministisk',),
'deterministiskere': ('deterministisk',),
'deterministiskest': ('deterministisk',),
'deterministiskeste': ('deterministisk',),
'detonerende': ('detonere',),
'detonert': ('detonere',),
'detonerte': ('detonere',),
'detonerende': ('detonere',),
'detonert': ('detonere',),
'detonerte': ('detonere',),
'detroniserende': ('detronisere',),
'detronisert': ('detronisere',),
'detroniserte': ('detronisere',),
'detne': ('dette',),
'detten': ('dette',),
'dettende': ('dette',),
'dettet': ('dette',),
'devaluerende': ('devaluere',),
'devaluert': ('devaluere',),
'devaluerte': ('devaluere',),
'devierende': ('deviere',),
'deviert': ('deviere',),
'devierte': ('deviere',),
'devot': ('devot',),
'diabetisk': ('diabetisk',),
'diabetiske': ('diabetisk',),
'diabetiskere': ('diabetisk',),
'diabetiskest': ('diabetisk',),
'diabetiskeste': ('diabetisk',),
'diabolsk': ('diabolsk',),
'diabolske': ('diabolsk',),
'diabolskere': ('diabolsk',),
'diabolskest': ('diabolsk',),
'diabolskeste': ('diabolsk',),
'diagnostiserende': ('diagnostisere',),
'diagnostisert': ('diagnostisere',),
'diagnostiserte': ('diagnostisere',),
'diagnostisk': ('diagnostisk',),
'diagnostiske': ('diagnostisk',),
'diagnostiskere': ('diagnostisk',),
'diagnostiskest': ('diagnostisk',),
'diagnostiskeste': ('diagnostisk',),
'diagonal': ('diagonal',),
'diagonale': ('diagonal',),
'diagonalere': ('diagonal',),
'diagonalest': ('diagonal',),
'diagonaleste': ('diagonal',),
'diagonalt': ('diagonal',),
'diagonalvevd': ('diagonalvevd',),
'diagonalvevde': ('diagonalvevd',),
'diagonalvevdere': ('diagonalvevd',),
'diagonalvevdest': ('diagonalvevd',),
'diagonalvevdeste': ('diagonalvevd',),
'diakonal': ('diakonal',),
'diakonale': ('diakonal',),
'diakonalere': ('diakonal',),
'diakonalest': ('diakonal',),
'diakonaleste': ('diakonal',),
'diakonalt': ('diakonal',),
'diakritisk': ('diakritisk',),
'diakritiske': ('diakritisk',),
'diakritiskere': ('diakritisk',),
'diakritiskest': ('diakritisk',),
'diakritiskeste': ('diakritisk',),
'diakron': ('diakron',),
'diakrone': ('diakron',),
'diakronere': ('diakron',),
'diakronest': ('diakron',),
'diakroneste': ('diakron',),
'diakront': ('diakron',),
'diakronisk': ('diakronisk',),
'diakroniske': ('diakronisk',),
'diakroniskere': ('diakronisk',),
'diakroniskest': ('diakronisk',),
'diakroniskeste': ('diakronisk',),
'dialektal': ('dialektal',),
'dialektale': ('dialektal',),
'dialektalere': ('dialektal',),
'dialektalest': ('dialektal',),
'dialektaleste': ('dialektal',),
'dialektalt': ('dialektal',),
'dialektfarga': ('dialektfarga',),
'dialektfargede': ('dialektfarget',),
'dialektfarget': ('dialektfarget',),
'dialektfargete': ('dialektfarget',),
'dialektfargetere': ('dialektfarget',),
'dialektfargetest': ('dialektfarget',),
'dialektfargeteste': ('dialektfarget',),
'dialektisk': ('dialektisk',),
'dialektiske': ('dialektisk',),
'dialektiskere': ('dialektisk',),
'dialektiskest': ('dialektisk',),
'dialektiskeste': ('dialektisk',),
'dialyserende': ('dialysere',),
'dialysert': ('dialysere',),
'dialyserte': ('dialysere',),
'diametral': ('diametral',),
'diametrale': ('diametral',),
'diametralere': ('diametral',),
'diametralest': ('diametral',),
'diametraleste': ('diametral',),
'diametralt': ('diametral',),
'diatonisk': ('diatonisk',),
'diatoniske': ('diatonisk',),
'diatoniskere': ('diatonisk',),
'diatoniskest': ('diatonisk',),
'diatoniskeste': ('diatonisk',),
'didaktisk': ('didaktisk',),
'didaktiske': ('didaktisk',),
'didaktiskere': ('didaktisk',),
'didaktiskest': ('didaktisk',),
'didaktiskeste': ('didaktisk',),
'dia': ('die',),
'diede': ('die',),
'diende': ('die',),
'diet': ('die',),
'diete': ('die',),
'dieseldrevet': ('dieseldrevet',),
'dieseldrevne': ('dieseldrevet',),
'dieseldrevnere': ('dieseldrevet',),
'dieseldrevnest': ('dieseldrevet',),
'dieseldrevneste': ('dieseldrevet',),
'differensierende': ('differensiere',),
'differensiert': ('differensiere',),
'differensierte': ('differensiere',),
'differerende': ('differere',),
'differert': ('differere',),
'differerte': ('differere',),
'diffunderende': ('diffundere',),
'diffundert': ('diffundere',),
'diffunderte': ('diffundere',),
'diffus': ('diffus',),
'diffuse': ('diffus',),
'diffusere': ('diffus',),
'diffusest': ('diffus',),
'diffuseste': ('diffus',),
'diffust': ('diffus',),
'difterisk': ('difterisk',),
'difteriske': ('difterisk',),
'difteriskere': ('difterisk',),
'difteriskest': ('difterisk',),
'difteriskeste': ('difterisk',),
'difterittisk': ('difterittisk',),
'difterittiske': ('difterittisk',),
'difterittiskere': ('difterittisk',),
'difterittiskest': ('difterittisk',),
'difterittiskeste': ('difterittisk',),
'diftongerende': ('diftongere',),
'diftongert': ('diftongere',),
'diftongerte': ('diftongere',),
'diger': ('diger',),
'digert': ('diger',),
'digre': ('diger',),
'digrere': ('diger',),
'digrest': ('diger',),
'digreste': ('diger',),
'digga': ('digge',),
'diggede': ('digge',),
'diggende': ('digge',),
'digget': ('digge',),
'diggete': ('digge',),
'digital': ('digital',),
'digitale': ('digital',),
'digitalere': ('digital',),
'digitalest': ('digital',),
'digitaleste': ('digital',),
'digitalt': ('digital',),
'digitaliserende': ('digitalisere',),
'digitalisert': ('digitalisere',),
'digitaliserte': ('digitalisere',),
'dikka': ('dikke',),
'dikkede': ('dikke',),
'dikkende': ('dikke',),
'dikket': ('dikke',),
'dikkete': ('dikke',),
'dikka': ('dikke',),
'dikkede': ('dikke',),
'dikkende': ('dikke',),
'dikket': ('dikke',),
'dikkete': ('dikke',),
'diktatorisk': ('diktatorisk',),
'diktatoriske': ('diktatorisk',),
'diktatoriskere': ('diktatorisk',),
'diktatoriskest': ('diktatorisk',),
'diktatoriskeste': ('diktatorisk',),
'dikta': ('dikte',),
'diktede': ('dikte',),
'diktende': ('dikte',),
'diktet': ('dikte',),
'diktete': ('dikte',),
'dikterende': ('diktere',),
'diktert': ('diktere',),
'dikterte': ('diktere',),
'dikterisk': ('dikterisk',),
'dikteriske': ('dikterisk',),
'dikteriskere': ('dikterisk',),
'dikteriskest': ('dikterisk',),
'dikteriskeste': ('dikterisk',),
'dilettantisk': ('dilettantisk',),
'dilettantiske': ('dilettantisk',),
'dilettantiskere': ('dilettantisk',),
'dilettantiskest': ('dilettantisk',),
'dilettantiskeste': ('dilettantisk',),
'dilettantmessig': ('dilettantmessig',),
'dilettantmessige': ('dilettantmessig',),
'dilettantmessigere': ('dilettantmessig',),
'dilettantmessigst': ('dilettantmessig',),
'dilettantmessigste': ('dilettantmessig',),
'dilla': ('dille',),
'dillede': ('dille',),
'dillende': ('dille',),
'dillet': ('dille',),
'dillete': ('dille',),
'dillet': ('dillet',),
'dillete': ('dillet',),
'dilletere': ('dillet',),
'dilletest': ('dillet',),
'dilleteste': ('dillet',),
'dillete': ('dillete',),
'dilta': ('dilte',),
'diltede': ('dilte',),
'diltende': ('dilte',),
'diltet': ('dilte',),
'diltete': ('dilte',),
'diluvial': ('diluvial',),
'diluviale': ('diluvial',),
'diluvialere': ('diluvial',),
'diluvialest': ('diluvial',),
'diluvialeste': ('diluvial',),
'diluvialt': ('diluvial',),
'diluviansk': ('diluviansk',),
'diluvianske': ('diluviansk',),
'diluvianskere': ('diluviansk',),
'diluvianskest': ('diluviansk',),
'diluvianskeste': ('diluviansk',),
'dim': ('dim',),
'dimme': ('dim',),
'dimmere': ('dim',),
'dimmest': ('dim',),
'dimmeste': ('dim',),
'dimt': ('dim',),
'dimensjonal': ('dimensjonal',),
'dimensjonale': ('dimensjonal',),
'dimensjonalere': ('dimensjonal',),
'dimensjonalest': ('dimensjonal',),
'dimensjonaleste': ('dimensjonal',),
'dimensjonalt': ('dimensjonal',),
'dimensjonerende': ('dimensjonere',),
'dimensjonert': ('dimensjonere',),
'dimensjonerte': ('dimensjonere',),
'diminutiv': ('diminutiv',),
'diminutive': ('diminutiv',),
'diminutivere': ('diminutiv',),
'diminutivest': ('diminutiv',),
'diminutiveste': ('diminutiv',),
'diminutivt': ('diminutiv',),
'dimitterende': ('dimittere',),
'dimittert': ('dimittere',),
'dimitterte': ('dimittere',),
'dimma': ('dimme',),
'dimmede': ('dimme',),
'dimmende': ('dimme',),
'dimmet': ('dimme',),
'dimmete': ('dimme',),
'dimma': ('dimme',),
'dimmede': ('dimme',),
'dimmende': ('dimme',),
'dimmet': ('dimme',),
'dimmete': ('dimme',),
'dimmende': ('dimme',),
'dimt': ('dimme',),
'dimte': ('dimme',),
'dimorf': ('dimorf',),
'dimorfe': ('dimorf',),
'dimorfere': ('dimorf',),
'dimorfest': ('dimorf',),
'dimorfeste': ('dimorf',),
'dimorft': ('dimorf',),
'dinerende': ('dinere',),
'dinert': ('dinere',),
'dinerte': ('dinere',),
'dingla': ('dingle',),
'dinglede': ('dingle',),
'dinglende': ('dingle',),
'dinglet': ('dingle',),
'dinglete': ('dingle',),
'dionysisk': ('dionysisk',),
'dionysiske': ('dionysisk',),
'dionysiskere': ('dionysisk',),
'dionysiskest': ('dionysisk',),
'dionysiskeste': ('dionysisk',),
'diploid': ('diploid',),
'diploide': ('diploid',),
'diploidere': ('diploid',),
'diploidest': ('diploid',),
'diploideste': ('diploid',),
'diplomatarisk': ('diplomatarisk',),
'diplomatariske': ('diplomatarisk',),
'diplomatariskere': ('diplomatarisk',),
'diplomatariskest': ('diplomatarisk',),
'diplomatariskeste': ('diplomatarisk',),
'diplomatisk': ('diplomatisk',),
'diplomatiske': ('diplomatisk',),
'diplomatiskere': ('diplomatisk',),
'diplomatiskest': ('diplomatisk',),
'diplomatiskeste': ('diplomatisk',),
'direkte': ('direkte',),
'direktekobla': ('direktekobla',),
'direktekoblede': ('direktekoblet',),
'direktekoblet': ('direktekoblet',),
'direktekoblete': ('direktekoblet',),
'direktekobletere': ('direktekoblet',),
'direktekobletest': ('direktekoblet',),
'direktekobleteste': ('direktekoblet',),
'direktekopla': ('direktekopla',),
'direktekoplede': ('direktekoplet',),
'direktekoplet': ('direktekoplet',),
'direktekoplete': ('direktekoplet',),
'direktekopletere': ('direktekoplet',),
'direktekopletest': ('direktekoplet',),
'direktekopleteste': ('direktekoplet',),
'direktiv': ('direktiv',),
'direktive': ('direktiv',),
'direktivere': ('direktiv',),
'direktivest': ('direktiv',),
'direktiveste': ('direktiv',),
'direktivt': ('direktiv',),
'dirigerende': ('dirigere',),
'dirigert': ('dirigere',),
'dirigerte': ('dirigere',),
'dirka': ('dirke',),
'dirkede': ('dirke',),
'dirkende': ('dirke',),
'dirket': ('dirke',),
'dirkete': ('dirke',),
'dirkefri': ('dirkefri',),
'dirkefrie': ('dirkefri',),
'dirkefriere': ('dirkefri',),
'dirkefriest': ('dirkefri',),
'dirkefrieste': ('dirkefri',),
'dirkefritt': ('dirkefri',),
'dirra': ('dirre',),
'dirrede': ('dirre',),
'dirrende': ('dirre',),
'dirret': ('dirre',),
'dirrete': ('dirre',),
'diset': ('diset',),
'disete': ('diset',),
'disetere': ('diset',),
'disetest': ('diset',),
'diseteste': ('diset',),
'disete': ('disete',),
'disharmonisk': ('disharmonisk',),
'disharmoniske': ('disharmonisk',),
'disharmoniskere': ('disharmonisk',),
'disharmoniskest': ('disharmonisk',),
'disharmoniskeste': ('disharmonisk',),
'disig': ('disig',),
'disige': ('disig',),
'disigere': ('disig',),
'disigst': ('disig',),
'disigste': ('disig',),
'disiplinerende': ('disiplinere',),
'disiplinert': ('disiplinere',),
'disiplinerte': ('disiplinere',),
'disiplinær': ('disiplinær',),
'disiplinære': ('disiplinær',),
'disiplinærere': ('disiplinær',),
'disiplinærest': ('disiplinær',),
'disiplinæreste': ('disiplinær',),
'disiplinært': ('disiplinær',),
'disjunktiv': ('disjunktiv',),
'disjunktive': ('disjunktiv',),
'disjunktivere': ('disjunktiv',),
'disjunktivest': ('disjunktiv',),
'disjunktiveste': ('disjunktiv',),
'disjunktivt': ('disjunktiv',),
'diska': ('diske',),
'diskede': ('diske',),
'diskende': ('diske',),
'disket': ('diske',),
'diskete': ('diske',),
'diska': ('diske',),
'diskede': ('diske',),
'diskende': ('diske',),
'disket': ('diske',),
'diskete': ('diske',),
'diskonterende': ('diskontere',),
'diskontert': ('diskontere',),
'diskonterte': ('diskontere',),
'diskontinuerlig': ('diskontinuerlig',),
'diskontinuerlige': ('diskontinuerlig',),
'diskontinuerligere': ('diskontinuerlig',),
'diskontinuerligst': ('diskontinuerlig',),
'diskontinuerligste': ('diskontinuerlig',),
'diskré': ('diskré',),
'diskrée': ('diskré',),
'diskréere': ('diskré',),
'diskréest': ('diskré',),
'diskréeste': ('diskré',),
'diskrediterende': ('diskreditere',),
'diskreditert': ('diskreditere',),
'diskrediterte': ('diskreditere',),
'diskret': ('diskret',),
'diskrete': ('diskret',),
'diskretere': ('diskret',),
'diskretest': ('diskret',),
'diskreteste': ('diskret',),
'diskriminerende': ('diskriminere',),
'diskriminert': ('diskriminere',),
'diskriminerte': ('diskriminere',),
'diskursiv': ('diskursiv',),
'diskursive': ('diskursiv',),
'diskursivere': ('diskursiv',),
'diskursivest': ('diskursiv',),
'diskursiveste': ('diskursiv',),
'diskursivt': ('diskursiv',),
'diskutabel': ('diskutabel',),
'diskutabelt': ('diskutabel',),
'diskutable': ('diskutabel',),
'diskutablere': ('diskutabel',),
'diskutablest': ('diskutabel',),
'diskutableste': ('diskutabel',),
'diskuterende': ('diskutere',),
'diskutert': ('diskutere',),
'diskuterte': ('diskutere',),
'diskvalifiserende': ('diskvalifisere',),
'diskvalifisert': ('diskvalifisere',),
'diskvalifiserte': ('diskvalifisere',),
'dispasjerende': ('dispasjere',),
'dispasjert': ('dispasjere',),
'dispasjerte': ('dispasjere',),
'dispenserende': ('dispensere',),
'dispensert': ('dispensere',),
'dispenserte': ('dispensere',),
'disponerende': ('disponere',),
'disponert': ('disponere',),
'disponerte': ('disponere',),
'disponibel': ('disponibel',),
'disponibelt': ('disponibel',),
'disponible': ('disponibel',),
'disponiblere': ('disponibel',),
'disponiblest': ('disponibel',),
'disponibleste': ('disponibel',),
'disputerende': ('disputere',),
'disputert': ('disputere',),
'disputerte': ('disputere',),
'dissa': ('disse',),
'dissede': ('disse',),
'dissende': ('disse',),
'disset': ('disse',),
'dissete': ('disse',),
'dissekerende': ('dissekere',),
'dissekert': ('dissekere',),
'dissekerte': ('dissekere',),
'dissenterende': ('dissentere',),
'dissentert': ('dissentere',),
'dissenterte': ('dissentere',),
'dissimilerende': ('dissimilere',),
'dissimilert': ('dissimilere',),
'dissimilerte': ('dissimilere',),
'dissonerende': ('dissonere',),
'dissonert': ('dissonere',),
'dissonerte': ('dissonere',),
'dissosierende': ('dissosiere',),
'dissosiert': ('dissosiere',),
'dissosierte': ('dissosiere',),
'distanserende': ('distansere',),
'distansert': ('distansere',),
'distanserte': ('distansere',),
'distingverende': ('distingvere',),
'distingvert': ('distingvere',),
'distingverte': ('distingvere',),
'distingvert': ('distingvert',),
'distingverte': ('distingvert',),
'distingvertere': ('distingvert',),
'distingvertest': ('distingvert',),
'distingverteste': ('distingvert',),
'distinkt': ('distinkt',),
'distinkte': ('distinkt',),
'distinktere': ('distinkt',),
'distinktest': ('distinkt',),
'distinkteste': ('distinkt',),
'distinktiv': ('distinktiv',),
'distinktive': ('distinktiv',),
'distinktivere': ('distinktiv',),
'distinktivest': ('distinktiv',),
'distinktiveste': ('distinktiv',),
'distinktivt': ('distinktiv',),
'distré': ('distré',),
'distrée': ('distré',),
'distréere': ('distré',),
'distréest': ('distré',),
'distréeste': ('distré',),
'distraherende': ('distrahere',),
'distrahert': ('distrahere',),
'distraherte': ('distrahere',),
'distribuerende': ('distribuere',),
'distribuert': ('distribuere',),
'distribuerte': ('distribuere',),
'distributiv': ('distributiv',),
'distributive': ('distributiv',),
'distributivere': ('distributiv',),
'distributivest': ('distributiv',),
'distributiveste': ('distributiv',),
'distributivt': ('distributiv',),
'divergent': ('divergent',),
'divergente': ('divergent',),
'divergentere': ('divergent',),
'divergentest': ('divergent',),
'divergenteste': ('divergent',),
'divergerende': ('divergere',),
'divergert': ('divergere',),
'divergerte': ('divergere',),
'diverse': ('diverse',),
'diverterende': ('divertere',),
'divertert': ('divertere',),
'diverterte': ('divertere',),
'dividerende': ('dividere',),
'dividert': ('dividere',),
'dividerte': ('dividere',),
'diøcisk': ('diøcisk',),
'diøciske': ('diøcisk',),
'diøciskere': ('diøcisk',),
'diøciskest': ('diøcisk',),
'diøciskeste': ('diøcisk',),
'djerv': ('djerv',),
'djerve': ('djerv',),
'djervere': ('djerv',),
'djervest': ('djerv',),
'djerveste': ('djerv',),
'djervt': ('djerv',),
'djevelsk': ('djevelsk',),
'djevelske': ('djevelsk',),
'djevelskere': ('djevelsk',),
'djevelskest': ('djevelsk',),
'djevelskeste': ('djevelsk',),
'djevla': ('djevla',),
'djevlebesatt': ('djevlebesatt',),
'djevlebesatte': ('djevlebesatt',),
'djevlebesattere': ('djevlebesatt',),
'djevlebesattest': ('djevlebesatt',),
'djevlebesatteste': ('djevlebesatt',),
'djevlig': ('djevlig',),
'djevlige': ('djevlig',),
'djevligere': ('djevlig',),
'djevligst': ('djevlig',),
'djevligste': ('djevlig',),
'djiboutisk': ('djiboutisk',),
'djiboutiske': ('djiboutisk',),
'djiboutiskere': ('djiboutisk',),
'djiboutiskest': ('djiboutisk',),
'djiboutiskeste': ('djiboutisk',),
'djup': ('djup',),
'djupe': ('djup',),
'djupere': ('djup',),
'djupest': ('djup',),
'djupeste': ('djup',),
'djupt': ('djup',),
'djupblå': ('djupblå',),
'djupblåe': ('djupblå',),
'djupblåere': ('djupblå',),
'djupblåest': ('djupblå',),
'djupblåeste': ('djupblå',),
'djupblått': ('djupblå',),
'djuperegående': ('djuperegående',),
'djupereliggende': ('djupereliggende',),
'djupetsa': ('djupetse',),
'djupetsede': ('djupetse',),
'djupetsende': ('djupetse',),
'djupetset': ('djupetse',),
'djupetsete': ('djupetse',),
'djupfrysende': ('djupfryse',),
'djupfryst': ('djupfryse',),
'djupfryste': ('djupfryse',),
'djupfølt': ('djupfølt',),
'djupfølte': ('djupfølt',),
'djupføltere': ('djupfølt',),
'djupføltest': ('djupfølt',),
'djupfølteste': ('djupfølt',),
'djuplendt': ('djuplendt',),
'djuplendte': ('djuplendt',),
'djuplendtere': ('djuplendt',),
'djuplendtest': ('djuplendt',),
'djuplendteste': ('djuplendt',),
'djupna': ('djupne',),
'djupnede': ('djupne',),
'djupnende': ('djupne',),
'djupnet': ('djupne',),
'djupnete': ('djupne',),
'djuprød': ('djuprød',),
'djuprøde': ('djuprød',),
'djuprødere': ('djuprød',),
'djuprødest': ('djuprød',),
'djuprødeste': ('djuprød',),
'djuprødt': ('djuprød',),
'djupsindig': ('djupsindig',),
'djupsindige': ('djupsindig',),
'djupsindigere': ('djupsindig',),
'djupsindigst': ('djupsindig',),
'djupsindigste': ('djupsindig',),
'djuptfølt': ('djuptfølt',),
'djuptfølte': ('djuptfølt',),
'djuptføltere': ('djuptfølt',),
'djuptføltest': ('djuptfølt',),
'djuptfølteste': ('djuptfølt',),
'djuptgripende': ('djuptgripende',),
'djuptgående': ('djuptgående',),
'djuptloddende': ('djuptloddende',),
'djupttenkende': ('djupttenkende',),
'dobbel': ('dobbel',),
'dobbelt': ('dobbel',),
'doble': ('dobbel',),
'doblere': ('dobbel',),
'doblest': ('dobbel',),
'dobleste': ('dobbel',),
'dobbelt': ('dobbelt',),
'dobbelte': ('dobbelt',),
'dobbeltere': ('dobbelt',),
'dobbeltest': ('dobbelt',),
'dobbelteste': ('dobbelt',),
'dobbeltarbeidende': ('dobbeltarbeidende',),
'dobbeltbotna': ('dobbeltbotna',),
'dobbeltbotnede': ('dobbeltbotnet',),
'dobbeltbotnet': ('dobbeltbotnet',),
'dobbeltbotnete': ('dobbeltbotnet',),
'dobbeltbotnetere': ('dobbeltbotnet',),
'dobbeltbotnetest': ('dobbeltbotnet',),
'dobbeltbotneteste': ('dobbeltbotnet',),
'dobbeltbunna': ('dobbeltbunna',),
'dobbeltbunnede': ('dobbeltbunnet',),
'dobbeltbunnet': ('dobbeltbunnet',),
'dobbeltbunnete': ('dobbeltbunnet',),
'dobbeltbunnetere': ('dobbeltbunnet',),
'dobbeltbunnetest': ('dobbeltbunnet',),
'dobbeltbunneteste': ('dobbeltbunnet',),
'dobbeltknappa': ('dobbeltknappa',),
'dobbeltknappede': ('dobbeltknappet',),
'dobbeltknappet': ('dobbeltknappet',),
'dobbeltknappete': ('dobbeltknappet',),
'dobbeltknappetere': ('dobbeltknappet',),
'dobbeltknappetest': ('dobbeltknappet',),
'dobbeltknappeteste': ('dobbeltknappet',),
'dobbeltrensa': ('dobbeltrensa',),
'dobbeltrensede': ('dobbeltrenset',),
'dobbeltrenset': ('dobbeltrenset',),
'dobbeltrensete': ('dobbeltrenset',),
'dobbeltrensetere': ('dobbeltrenset',),
'dobbeltrensetest': ('dobbeltrenset',),
'dobbeltrenseteste': ('dobbeltrenset',),
'dobbeltsidig': ('dobbeltsidig',),
'dobbeltsidige': ('dobbeltsidig',),
'dobbeltsidigere': ('dobbeltsidig',),
'dobbeltsidigst': ('dobbeltsidig',),
'dobbeltsidigste': ('dobbeltsidig',),
'dobbeltspora': ('dobbeltspora',),
'dobbeltsporede': ('dobbeltsporet',),
'dobbeltsporet': ('dobbeltsporet',),
'dobbeltsporete': ('dobbeltsporet',),
'dobbeltsporetere': ('dobbeltsporet',),
'dobbeltsporetest': ('dobbeltsporet',),
'dobbeltsporeteste': ('dobbeltsporet',),
'dobla': ('doble',),
'doblede': ('doble',),
'doblende': ('doble',),
'doblet': ('doble',),
'doblete': ('doble',),
'dogga': ('dogge',),
'doggede': ('dogge',),
'doggende': ('dogge',),
'dogget': ('dogge',),
'doggete': ('dogge',),
'dogga': ('dogge',),
'doggede': ('dogge',),
'doggende': ('dogge',),
'dogget': ('dogge',),
'doggete': ('dogge',),
'dogget': ('dogget',),
'doggete': ('dogget',),
'doggetere': ('dogget',),
'doggetest': ('dogget',),
'doggeteste': ('dogget',),
'doggete': ('doggete',),
'doggfri': ('doggfri',),
'doggfrie': ('doggfri',),
'doggfriere': ('doggfri',),
'doggfriest': ('doggfri',),
'doggfrieste': ('doggfri',),
'doggfritt': ('doggfri',),
'doggfrisk': ('doggfrisk',),
'doggfriske': ('doggfrisk',),
'doggfriskere': ('doggfrisk',),
'doggfriskest': ('doggfrisk',),
'doggfriskeste': ('doggfrisk',),
'doggfriskt': ('doggfrisk',),
'doggvåt': ('doggvåt',),
'doggvåte': ('doggvåt',),
'doggvåtere': ('doggvåt',),
'doggvåtest': ('doggvåt',),
'doggvåteste': ('doggvåt',),
'doggvått': ('doggvåt',),
'dogmatisk': ('dogmatisk',),
'dogmatiske': ('dogmatisk',),
'dogmatiskere': ('dogmatisk',),
'dogmatiskest': ('dogmatisk',),
'dogmatiskeste': ('dogmatisk',),
'dokka': ('dokke',),
'dokkede': ('dokke',),
'dokkende': ('dokke',),
'dokket': ('dokke',),
'dokkete': ('dokke',),
'dokkeaktig': ('dokkeaktig',),
'dokkeaktige': ('dokkeaktig',),
'dokkeaktigere': ('dokkeaktig',),
'dokkeaktigst': ('dokkeaktig',),
'dokkeaktigste': ('dokkeaktig',),
'dokksatt': ('dokksette',),
'dokksatte': ('dokksette',),
'dokksettende': ('dokksette',),
'doktorerende': ('doktorere',),
'doktorert': ('doktorere',),
'doktorerte': ('doktorere',),
'doktrinær': ('doktrinær',),
'doktrinære': ('doktrinær',),
'doktrinærere': ('doktrinær',),
'doktrinærest': ('doktrinær',),
'doktrinæreste': ('doktrinær',),
'doktrinært': ('doktrinær',),
'dokumentarisk': ('dokumentarisk',),
'dokumentariske': ('dokumentarisk',),
'dokumentariskere': ('dokumentarisk',),
'dokumentariskest': ('dokumentarisk',),
'dokumentariskeste': ('dokumentarisk',),
'dokumenterende': ('dokumentere',),
'dokumentert': ('dokumentere',),
'dokumenterte': ('dokumentere',),
'dolka': ('dolke',),
'dolkede': ('dolke',),
'dolkende': ('dolke',),
'dolket': ('dolke',),
'dolkete': ('dolke',),
'domfellende': ('domfelle',),
'domfelt': ('domfelle',),
'domfelte': ('domfelle',),
'dominant': ('dominant',),
'dominante': ('dominant',),
'dominantere': ('dominant',),
'dominantest': ('dominant',),
'dominanteste': ('dominant',),
'dominerende': ('dominere',),
'dominert': ('dominere',),
'dominerte': ('dominere',),
'dominerende': ('dominerende',),
'dominikansk': ('dominikansk',),
'dominikanske': ('dominikansk',),
'dominikanskere': ('dominikansk',),
'dominikanskest': ('dominikansk',),
'dominikanskeste': ('dominikansk',),
'dominikisk': ('dominikisk',),
'dominikiske': ('dominikisk',),
'dominikiskere': ('dominikisk',),
'dominikiskest': ('dominikisk',),
'dominikiskeste': ('dominikisk',),
'domisilierende': ('domisiliere',),
'domisiliert': ('domisiliere',),
'domisilierte': ('domisiliere',),
'donerende': ('donere',),
'donert': ('donere',),
'donerte': ('donere',),
'dopa': ('dope',),
'dopede': ('dope',),
'dopende': ('dope',),
'dopet': ('dope',),
'dopete': ('dope',),
'dora': ('dore',),
'dorede': ('dore',),
'dorende': ('dore',),
'doret': ('dore',),
'dorete': ('dore',),
'dort': ('dore',),
'dorte': ('dore',),
'dorga': ('dorge',),
'dorgede': ('dorge',),
'dorgende': ('dorge',),
'dorget': ('dorge',),
'dorgete': ('dorge',),
'dorisk': ('dorisk',),
'doriske': ('dorisk',),
'doriskere': ('dorisk',),
'doriskest': ('dorisk',),
'doriskeste': ('dorisk',),
'dorma': ('dorme',),
'dormede': ('dorme',),
'dormende': ('dorme',),
'dormet': ('dorme',),
'dormete': ('dorme',),
'dorsal': ('dorsal',),
'dorsale': ('dorsal',),
'dorsalere': ('dorsal',),
'dorsalest': ('dorsal',),
'dorsaleste': ('dorsal',),
'dorsalt': ('dorsal',),
'dorsk': ('dorsk',),
'dorske': ('dorsk',),
'dorskere': ('dorsk',),
'dorskest': ('dorsk',),
'dorskeste': ('dorsk',),
'dorskt': ('dorsk',),
'doserende': ('dosere',),
'dosert': ('dosere',),
'doserte': ('dosere',),
'doserende': ('dosere',),
'dosert': ('dosere',),
'doserte': ('dosere',),
'dosserende': ('dossere',),
'dossert': ('dossere',),
'dosserte': ('dossere',),
'doterende': ('dotere',),
'dotert': ('dotere',),
'doterte': ('dotere',),
'dottet': ('dottet',),
'dottete': ('dottet',),
'dottetere': ('dottet',),
'dottetest': ('dottet',),
'dotteteste': ('dottet',),
'dottete': ('dottete',),
'dov': ('dov',),
'dove': ('dov',),
'dovere': ('dov',),
'dovest': ('dov',),
'doveste': ('dov',),
'dovt': ('dov',),
'doven': ('doven',),
'dovent': ('doven',),
'dovne': ('doven',),
'dovnere': ('doven',),
'dovnest': ('doven',),
'dovneste': ('doven',),
'dovna': ('dovne',),
'dovnede': ('dovne',),
'dovnende': ('dovne',),
'dovnet': ('dovne',),
'dovnete': ('dovne',),
'dradd': ('dra',),
'dradde': ('dra',),
'dragende': ('dra',),
'dratt': ('dra',),
'dratte': ('dra',),
'drabelig': ('drabelig',),
'drabelige': ('drabelig',),
'drabeligere': ('drabelig',),
'drabeligst': ('drabelig',),
'drabeligste': ('drabelig',),
'dradd': ('drage',),
'dradde': ('drage',),
'dragende': ('drage',),
'dratt': ('drage',),
'dratte': ('drage',),
'dradd': ('drage',),
'dradde': ('drage',),
'dragende': ('drage',),
'dratt': ('drage',),
'dratte': ('drage',),
'dragen': ('dragen',),
'draget': ('dragen',),
'dragne': ('dragen',),
'dragnere': ('dragen',),
'dragnest': ('dragen',),
'dragneste': ('dragen',),
'dragende': ('dragende',),
'dragsa': ('dragse',),
'dragsede': ('dragse',),
'dragsende': ('dragse',),
'dragset': ('dragse',),
'dragsete': ('dragse',),
'drakonisk': ('drakonisk',),
'drakoniske': ('drakonisk',),
'drakoniskere': ('drakonisk',),
'drakoniskest': ('drakonisk',),
'drakoniskeste': ('drakonisk',),
'dramatiserende': ('dramatisere',),
'dramatisert': ('dramatisere',),
'dramatiserte': ('dramatisere',),
'dramatisk': ('dramatisk',),
'dramatiske': ('dramatisk',),
'dramatiskere': ('dramatisk',),
'dramatiskest': ('dramatisk',),
'dramatiskeste': ('dramatisk',),
'dramaturgisk': ('dramaturgisk',),
'dramaturgiske': ('dramaturgisk',),
'dramaturgiskere': ('dramaturgisk',),
'dramaturgiskest': ('dramaturgisk',),
'dramaturgiskeste': ('dramaturgisk',),
'draperende': ('drapere',),
'drapert': ('drapere',),
'draperte': ('drapere',),
'drapsmistenkt': ('drapsmistenkt',),
'drapsmistenkte': ('drapsmistenkt',),
'drapsmistenktere': ('drapsmistenkt',),
'drapsmistenktest': ('drapsmistenkt',),
'drapsmistenkteste': ('drapsmistenkt',),
'drasjerende': ('drasjere',),
'drasjert': ('drasjere',),
'drasjerte': ('drasjere',),
'drassa': ('drasse',),
'drassede': ('drasse',),
'drassende': ('drasse',),
'drasset': ('drasse',),
'drassete': ('drasse',),
'drastisk': ('drastisk',),
'drastiske': ('drastisk',),
'drastiskere': ('drastisk',),
'drastiskest': ('drastisk',),
'drastiskeste': ('drastisk',),
'dratta': ('dratte',),
'drattede': ('dratte',),
'drattende': ('dratte',),
'drattet': ('dratte',),
'drattete': ('dratte',),
'draugbleik': ('draugbleik',),
'draugbleike': ('draugbleik',),
'draugbleikere': ('draugbleik',),
'draugbleikest': ('draugbleik',),
'draugbleikeste': ('draugbleik',),
'draugbleikt': ('draugbleik',),
'draugblek': ('draugblek',),
'draugbleke': ('draugblek',),
'draugblekere': ('draugblek',),
'draugblekest': ('draugblek',),
'draugblekeste': ('draugblek',),
'draugblekt': ('draugblek',),
'dravidisk': ('dravidisk',),
'dravidiske': ('dravidisk',),
'dravidiskere': ('dravidisk',),
'dravidiskest': ('dravidisk',),
'dravidiskeste': ('dravidisk',),
'dregga': ('dregge',),
'dreggede': ('dregge',),
'dreggende': ('dregge',),
'dregget': ('dregge',),
'dreggete': ('dregge',),
'dreibar': ('dreibar',),
'dreibare': ('dreibar',),
'dreibarere': ('dreibar',),
'dreibarest': ('dreibar',),
'dreibareste': ('dreibar',),
'dreibart': ('dreibar',),
'dreia': ('dreie',),
'dreid': ('dreie',),
'dreidd': ('dreie',),
'dreidde': ('dreie',),
'dreide': ('dreie',),
'dreiede': ('dreie',),
'dreiende': ('dreie',),
'dreiet': ('dreie',),
'dreiete': ('dreie',),
'dreielig': ('dreielig',),
'dreielige': ('dreielig',),
'dreieligere': ('dreielig',),
'dreieligst': ('dreielig',),
'dreieligste': ('dreielig',),
'dreisende': ('dreise',),
'dreist': ('dreise',),
'dreiste': ('dreise',),
'drektig': ('drektig',),
'drektige': ('drektig',),
'drektigere': ('drektig',),
'drektigst': ('drektig',),
'drektigste': ('drektig',),
'drenende': ('drene',),
'drent': ('drene',),
'drente': ('drene',),
'drenerende': ('drenere',),
'drenert': ('drenere',),
'drenerte': ('drenere',),
'drepende': ('drepe',),
'drept': ('drepe',),
'drepte': ('drepe',),
'drepende': ('drepende',),
'dressa': ('dresse',),
'dressede': ('dresse',),
'dressende': ('dresse',),
'dresset': ('dresse',),
'dressete': ('dresse',),
'dresserende': ('dressere',),
'dressert': ('dressere',),
'dresserte': ('dressere',),
'dretta': ('drette',),
'drettede': ('drette',),
'drettende': ('drette',),
'drettet': ('drette',),
'drettete': ('drette',),
'dreven': ('dreven',),
'drevent': ('dreven',),
'drevne': ('dreven',),
'drevnere': ('dreven',),
'drevnest': ('dreven',),
'drevneste': ('dreven',),
'driblete': ('drible',),
'dribla': ('drible',),
'driblede': ('drible',),
'driblende': ('drible',),
'driblet': ('drible',),
'drifta': ('drifte',),
'driftede': ('drifte',),
'driftende': ('drifte',),
'driftet': ('drifte',),
'driftete': ('drifte',),
'driftig': ('driftig',),
'driftige': ('driftig',),
'driftigere': ('driftig',),
'driftigst': ('driftig',),
'driftigste': ('driftig',),
'driftsmessig': ('driftsmessig',),
'driftsmessige': ('driftsmessig',),
'driftsmessigere': ('driftsmessig',),
'driftsmessigst': ('driftsmessig',),
'driftsmessigste': ('driftsmessig',),
'driftssikker': ('driftssikker',),
'driftssikkert': ('driftssikker',),
'driftssikre': ('driftssikker',),
'driftssikrere': ('driftssikker',),
'driftssikrest': ('driftssikker',),
'driftssikreste': ('driftssikker',),
'drikkende': ('drikke',),
'drukken': ('drikke',),
'drukket': ('drikke',),
'drukne': ('drikke',),
'drikkelig': ('drikkelig',),
'drikkelige': ('drikkelig',),
'drikkeligere': ('drikkelig',),
'drikkeligst': ('drikkelig',),
'drikkeligste': ('drikkelig',),
'drikkfeldig': ('drikkfeldig',),
'drikkfeldige': ('drikkfeldig',),
'drikkfeldigere': ('drikkfeldig',),
'drikkfeldigst': ('drikkfeldig',),
'drikkfeldigste': ('drikkfeldig',),
'drilla': ('drille',),
'drillede': ('drille',),
'drillende': ('drille',),
'drillet': ('drille',),
'drillete': ('drille',),
'drilla': ('drille',),
'drillede': ('drille',),
'drillende': ('drille',),
'drillet': ('drille',),
'drillete': ('drille',),
'drilt': ('drille',),
'drilte': ('drille',),
'drilla': ('drille',),
'drillede': ('drille',),
'drillende': ('drille',),
'drillet': ('drille',),
'drillete': ('drille',),
'drilt': ('drille',),
'drilte': ('drille',),
'drilla': ('drille',),
'drillede': ('drille',),
'drillende': ('drille',),
'drillet': ('drille',),
'drillete': ('drille',),
'drilt': ('drille',),
'drilte': ('drille',),
'drista': ('driste',),
'dristede': ('driste',),
'dristende': ('driste',),
'dristet': ('driste',),
'dristete': ('driste',),
'dristig': ('dristig',),
'dristige': ('dristig',),
'dristigere': ('dristig',),
'dristigst': ('dristig',),
'dristigste': ('dristig',),
'driten': ('drite',),
'dritende': ('drite',),
'dritet': ('drite',),
'dritne': ('drite',),
'dritt': ('drite',),
'dritte': ('drite',),
'drittlei': ('drittlei',),
'drittleie': ('drittlei',),
'drittleiere': ('drittlei',),
'drittleiest': ('drittlei',),
'drittleieste': ('drittlei',),
'drittleit': ('drittlei',),
'dreven': ('drive',),
'drevet': ('drive',),
'drevne': ('drive',),
'drivende': ('drive',),
'drivende': ('drivende',),
'drivendes': ('drivendes',),
'drivhvit': ('drivhvit',),
'drivhvite': ('drivhvit',),
'drivhvitere': ('drivhvit',),
'drivhvitest': ('drivhvit',),
'drivhviteste': ('drivhvit',),
'drivhvitt': ('drivhvit',),
'drivkvit': ('drivkvit',),
'drivkvite': ('drivkvit',),
'drivkvitere': ('drivkvit',),
'drivkvitest': ('drivkvit',),
'drivkviteste': ('drivkvit',),
'drivkvitt': ('drivkvit',),
'drivverdig': ('drivverdig',),
'drivverdige': ('drivverdig',),
'drivverdigere': ('drivverdig',),
'drivverdigst': ('drivverdig',),
'drivverdigste': ('drivverdig',),
'drivvåt': ('drivvåt',),
'drivvåte': ('drivvåt',),
'drivvåtere': ('drivvåt',),
'drivvåtest': ('drivvåt',),
'drivvåteste': ('drivvåt',),
'drivvått': ('drivvåt',),
'drodla': ('drodle',),
'drodlede': ('drodle',),
'drodlende': ('drodle',),
'drodlet': ('drodle',),
'drodlete': ('drodle',),
'droplet': ('droplet',),
'droplete': ('droplet',),
'dropletere': ('droplet',),
'dropletest': ('droplet',),
'dropleteste': ('droplet',),
'droplete': ('droplete',),
'droppa': ('droppe',),
'droppede': ('droppe',),
'droppende': ('droppe',),
'droppet': ('droppe',),
'droppete': ('droppe',),
'drukken': ('drukken',),
'drukkent': ('drukken',),
'drukne': ('drukken',),
'druknere': ('drukken',),
'druknest': ('drukken',),
'drukneste': ('drukken',),
'drukna': ('drukne',),
'druknede': ('drukne',),
'druknende': ('drukne',),
'druknet': ('drukne',),
'druknete': ('drukne',),
'drusisk': ('drusisk',),
'drusiske': ('drusisk',),
'drusiskere': ('drusisk',),
'drusiskest': ('drusisk',),
'drusiskeste': ('drusisk',),
'dry': ('dry',),
'dryg': ('dryg',),
'dryge': ('dryg',),
'drygere': ('dryg',),
'drygest': ('dryg',),
'drygeste': ('dryg',),
'drygt': ('dryg',),
'drygd': ('dryge',),
'drygde': ('dryge',),
'drygende': ('dryge',),
'dryppa': ('dryppe',),
'dryppede': ('dryppe',),
'dryppende': ('dryppe',),
'dryppet': ('dryppe',),
'dryppete': ('dryppe',),
'drypt': ('dryppe',),
'drypte': ('dryppe',),
'dryppefri': ('dryppefri',),
'dryppefrie': ('dryppefri',),
'dryppefriere': ('dryppefri',),
'dryppefriest': ('dryppefri',),
'dryppefrieste': ('dryppefri',),
'dryppefritt': ('dryppefri',),
'dryppfri': ('dryppfri',),
'dryppfrie': ('dryppfri',),
'dryppfriere': ('dryppfri',),
'dryppfriest': ('dryppfri',),
'dryppfrieste': ('dryppfri',),
'dryppfritt': ('dryppfri',),
'drypptørka': ('drypptørke',),
'drypptørkede': ('drypptørke',),
'drypptørkende': ('drypptørke',),
'drypptørket': ('drypptørke',),
'drypptørkete': ('drypptørke',),
'drypptørra': ('drypptørre',),
'drypptørrede': ('drypptørre',),
'drypptørrende': ('drypptørre',),
'drypptørret': ('drypptørre',),
'drypptørrete': ('drypptørre',),
'dryppvåt': ('dryppvåt',),
'dryppvåte': ('dryppvåt',),
'dryppvåtere': ('dryppvåt',),
'dryppvåtest': ('dryppvåt',),
'dryppvåteste': ('dryppvåt',),
'dryppvått': ('dryppvåt',),
'dryssa': ('drysse',),
'dryssede': ('drysse',),
'dryssende': ('drysse',),
'drysset': ('drysse',),
'dryssete': ('drysse',),
'dryst': ('drysse',),
'dryste': ('drysse',),
'dråpeforma': ('dråpeforma',),
'dråpeformede': ('dråpeformet',),
'dråpeformet': ('dråpeformet',),
'dråpeformete': ('dråpeformet',),
'dråpeformetere': ('dråpeformet',),
'dråpeformetest': ('dråpeformet',),
'dråpeformeteste': ('dråpeformet',),
'drøfta': ('drøfte',),
'drøftede': ('drøfte',),
'drøftende': ('drøfte',),
'drøftet': ('drøfte',),
'drøftete': ('drøfte',),
'drømmende': ('drømme',),
'drømt': ('drømme',),
'drømte': ('drømme',),
'drømmende': ('drømmende',),
'drønna': ('drønne',),
'drønnede': ('drønne',),
'drønnende': ('drønne',),
'drønnet': ('drønne',),
'drønnete': ('drønne',),
'drønt': ('drønne',),
'drønte': ('drønne',),
'drøsende': ('drøse',),
'drøst': ('drøse',),
'drøste': ('drøse',),
'drøvtygd': ('drøvtygge',),
'drøvtygde': ('drøvtygge',),
'drøvtyggede': ('drøvtygge',),
'drøvtyggende': ('drøvtygge',),
'drøvtygget': ('drøvtygge',),
'drøvtyggete': ('drøvtygge',),
'drøy': ('drøy',),
'drøye': ('drøy',),
'drøyere': ('drøy',),
'drøyest': ('drøy',),
'drøyeste': ('drøy',),
'drøyt': ('drøy',),
'drøyd': ('drøye',),
'drøyde': ('drøye',),
'drøyende': ('drøye',),
'dualistisk': ('dualistisk',),
'dualistiske': ('dualistisk',),
'dualistiskere': ('dualistisk',),
'dualistiskest': ('dualistisk',),
'dualistiskeste': ('dualistisk',),
'dubba': ('dubbe',),
'dubbede': ('dubbe',),
'dubbende': ('dubbe',),
'dubbet': ('dubbe',),
'dubbete': ('dubbe',),
'dubba': ('dubbe',),
'dubbede': ('dubbe',),
'dubbende': ('dubbe',),
'dubbet': ('dubbe',),
'dubbete': ('dubbe',),
'dubiøs': ('dubiøs',),
'dubiøse': ('dubiøs',),
'dubiøsere': ('dubiøs',),
'dubiøsest': ('dubiøs',),
'dubiøseste': ('dubiøs',),
'dubiøst': ('dubiøs',),
'dublerende': ('dublere',),
'dublert': ('dublere',),
'dublerte': ('dublere',),
'dueblå': ('dueblå',),
'dueblåe': ('dueblå',),
'dueblåere': ('dueblå',),
'dueblåest': ('dueblå',),
'dueblåeste': ('dueblå',),
'dueblått': ('dueblå',),
'duellerende': ('duellere',),
'duellert': ('duellere',),
'duellerte': ('duellere',),
'dufta': ('dufte',),
'duftede': ('dufte',),
'duftende': ('dufte',),
'duftet': ('dufte',),
'duftete': ('dufte',),
'dugd': ('duge',),
'dugde': ('duge',),
'dugende': ('duge',),
'dugelig': ('dugelig',),
'dugelige': ('dugelig',),
'dugeligere': ('dugelig',),
'dugeligst': ('dugelig',),
'dugeligste': ('dugelig',),
'dugga': ('dugge',),
'duggede': ('dugge',),
'duggende': ('dugge',),
'dugget': ('dugge',),
'duggete': ('dugge',),
'dugget': ('dugget',),
'duggete': ('dugget',),
'duggetere': ('dugget',),
'duggetest': ('dugget',),
'duggeteste': ('dugget',),
'duggete': ('duggete',),
'duggfri': ('duggfri',),
'duggfrie': ('duggfri',),
'duggfriere': ('duggfri',),
'duggfriest': ('duggfri',),
'duggfrieste': ('duggfri',),
'duggfritt': ('duggfri',),
'duggfrisk': ('duggfrisk',),
'duggfriske': ('duggfrisk',),
'duggfriskere': ('duggfrisk',),
'duggfriskest': ('duggfrisk',),
'duggfriskeste': ('duggfrisk',),
'duggfriskt': ('duggfrisk',),
'duggvåt': ('duggvåt',),
'duggvåte': ('duggvåt',),
'duggvåtere': ('duggvåt',),
'duggvåtest': ('duggvåt',),
'duggvåteste': ('duggvåt',),
'duggvått': ('duggvåt',),
'duka': ('duke',),
'dukede': ('duke',),
'dukende': ('duke',),
'duket': ('duke',),
'dukete': ('duke',),
'dukka': ('dukke',),
'dukkede': ('dukke',),
'dukkende': ('dukke',),
'dukket': ('dukke',),
'dukkete': ('dukke',),
'dukkeaktig': ('dukkeaktig',),
'dukkeaktige': ('dukkeaktig',),
'dukkeaktigere': ('dukkeaktig',),
'dukkeaktigst': ('dukkeaktig',),
'dukkeaktigste': ('dukkeaktig',),
'dukknakka': ('dukknakka',),
'dukknakkede': ('dukknakket',),
'dukknakket': ('dukknakket',),
'dukknakkete': ('dukknakket',),
'dukknakketere': ('dukknakket',),
'dukknakketest': ('dukknakket',),
'dukknakketeste': ('dukknakket',),
'dulgt': ('dulgt',),
'dulgte': ('dulgt',),
'dulgtere': ('dulgt',),
'dulgtest': ('dulgt',),
'dulgteste': ('dulgt',),
'dulla': ('dulle',),
'dullede': ('dulle',),
'dullende': ('dulle',),
'dullet': ('dulle',),
'dullete': ('dulle',),
'dulma': ('dulme',),
'dulmede': ('dulme',),
'dulmende': ('dulme',),
'dulmet': ('dulme',),
'dulmete': ('dulme',),
'dulta': ('dulte',),
'dultede': ('dulte',),
'dultende': ('dulte',),
'dultet': ('dulte',),
'dultete': ('dulte',),
'dum': ('dum',),
'dumme': ('dum',),
'dummere': ('dum',),
'dummest': ('dum',),
'dummeste': ('dum',),
'dumt': ('dum',),
'dumdristig': ('dumdristig',),
'dumdristige': ('dumdristig',),
'dumdristigere': ('dumdristig',),
'dumdristigst': ('dumdristig',),
'dumdristigste': ('dumdristig',),
'dumma': ('dumme',),
'dummede': ('dumme',),
'dummende': ('dumme',),
'dummet': ('dumme',),
'dummete': ('dumme',),
'dump': ('dump',),
'dumpe': ('dump',),
'dumpere': ('dump',),
'dumpest': ('dump',),
'dumpeste': ('dump',),
'dumpt': ('dump',),
'dumpa': ('dumpe',),
'dumpede': ('dumpe',),
'dumpende': ('dumpe',),
'dumpet': ('dumpe',),
'dumpete': ('dumpe',),
'dumpa': ('dumpe',),
'dumpede': ('dumpe',),
'dumpende': ('dumpe',),
'dumpet': ('dumpe',),
'dumpete': ('dumpe',),
'dumpet': ('dumpet',),
'dumpete': ('dumpet',),
'dumpetere': ('dumpet',),
'dumpetest': ('dumpet',),
'dumpeteste': ('dumpet',),
'dumpete': ('dumpete',),
'dumsnill': ('dumsnill',),
'dumsnille': ('dumsnill',),
'dumsnillere': ('dumsnill',),
'dumsnillest': ('dumsnill',),
'dumsnilleste': ('dumsnill',),
'dumsnilt': ('dumsnill',),
'dumstolt': ('dumstolt',),
'dumstolte': ('dumstolt',),
'dumstoltere': ('dumstolt',),
'dumstoltest': ('dumstolt',),
'dumstolteste': ('dumstolt',),
'dunbløt': ('dunbløt',),
'dunbløte': ('dunbløt',),
'dunbløtere': ('dunbløt',),
'dunbløtest': ('dunbløt',),
'dunbløteste': ('dunbløt',),
'dunbløtt': ('dunbløt',),
'dundra': ('dundre',),
'dundrede': ('dundre',),
'dundrende': ('dundre',),
'dundret': ('dundre',),
'dundrete': ('dundre',),
'dundrende': ('dundrende',),
'dunet': ('dunet',),
'dunete': ('dunet',),
'dunetere': ('dunet',),
'dunetest': ('dunet',),
'duneteste': ('dunet',),
'dunete': ('dunete',),
'dunga': ('dunge',),
'dungede': ('dunge',),
'dungende': ('dunge',),
'dunget': ('dunge',),
'dungete': ('dunge',),
'dunhåra': ('dunhåra',),
'dunhårede': ('dunhåret',),
'dunhåret': ('dunhåret',),
'dunhårete': ('dunhåret',),
'dunhåretere': ('dunhåret',),
'dunhåretest': ('dunhåret',),
'dunhåreteste': ('dunhåret',),
'dunka': ('dunke',),
'dunkede': ('dunke',),
'dunkende': ('dunke',),
'dunket': ('dunke',),
'dunkete': ('dunke',),
'dunkel': ('dunkel',),
'dunkelt': ('dunkel',),
'dunkle': ('dunkel',),
'dunklere': ('dunkel',),
'dunklest': ('dunkel',),
'dunkleste': ('dunkel',),
'dunkledd': ('dunkledd',),
'dunkledde': ('dunkledd',),
'dunkleddere': ('dunkledd',),
'dunkleddest': ('dunkledd',),
'dunkleddeste': ('dunkledd',),
'dunlett': ('dunlett',),
'dunlette': ('dunlett',),
'dunlettere': ('dunlett',),
'dunlettest': ('dunlett',),
'dunletteste': ('dunlett',),
'dunsta': ('dunste',),
'dunstede': ('dunste',),
'dunstende': ('dunste',),
'dunstet': ('dunste',),
'dunstete': ('dunste',),
'duperende': ('dupere',),
'dupert': ('dupere',),
'duperte': ('dupere',),
'dupliserende': ('duplisere',),
'duplisert': ('duplisere',),
'dupliserte': ('duplisere',),
'duppa': ('duppe',),
'duppede': ('duppe',),
'duppende': ('duppe',),
'duppet': ('duppe',),
'duppete': ('duppe',),
'durabel': ('durabel',),
'durabelt': ('durabel',),
'durable': ('durabel',),
'durablere': ('durabel',),
'durablest': ('durabel',),
'durableste': ('durabel',),
'durabelig': ('durabelig',),
'durabelige': ('durabelig',),
'durabeligere': ('durabelig',),
'durabeligst': ('durabelig',),
'durabeligste': ('durabelig',),
'durativ': ('durativ',),
'durative': ('durativ',),
'durativere': ('durativ',),
'durativest': ('durativ',),
'durativeste': ('durativ',),
'durativt': ('durativ',),
'dura': ('dure',),
'durede': ('dure',),
'durende': ('dure',),
'duret': ('dure',),
'durete': ('dure',),
'durt': ('dure',),
'durte': ('dure',),
'durkdreven': ('durkdreven',),
'durkdrevent': ('durkdreven',),
'durkdrevne': ('durkdreven',),
'durkdrevnere': ('durkdreven',),
'durkdrevnest': ('durkdreven',),
'durkdrevneste': ('durkdreven',),
'durksydd': ('durksy',),
'durksydde': ('durksy',),
'durksyende': ('durksy',),
'dus': ('dus',),
'duse': ('dus',),
'dusere': ('dus',),
'dusest': ('dus',),
'duseste': ('dus',),
'dust': ('dus',),
'dusende': ('duse',),
'dust': ('duse',),
'duste': ('duse',),
'dusende': ('duse',),
'dust': ('duse',),
'duste': ('duse',),
'dusement': ('dusement',),
'dusemente': ('dusement',),
'dusementere': ('dusement',),
'dusementest': ('dusement',),
'dusementeste': ('dusement',),
'dusja': ('dusje',),
'dusjede': ('dusje',),
'dusjende': ('dusje',),
'dusjet': ('dusje',),
'dusjete': ('dusje',),
'duskregna': ('duskregne',),
'duskregnede': ('duskregne',),
'duskregnende': ('duskregne',),
'duskregnet': ('duskregne',),
'duskregnete': ('duskregne',),
'duskregnt': ('duskregne',),
'duskregnte': ('duskregne',),
'dustet': ('dustet',),
'dustete': ('dustet',),
'dustetere': ('dustet',),
'dustetest': ('dustet',),
'dusteteste': ('dustet',),
'dustete': ('dustete',),
'dutta': ('dutte',),
'duttede': ('dutte',),
'duttende': ('dutte',),
'duttet': ('dutte',),
'duttete': ('dutte',),
'dutta': ('dutte',),
'duttede': ('dutte',),
'duttende': ('dutte',),
'duttet': ('dutte',),
'duttete': ('dutte',),
'duva': ('duve',),
'duvd': ('duve',),
'duvde': ('duve',),
'duvede': ('duve',),
'duvende': ('duve',),
'duvet': ('duve',),
'duvete': ('duve',),
'dvask': ('dvask',),
'dvaske': ('dvask',),
'dvaskere': ('dvask',),
'dvaskest': ('dvask',),
'dvaskeste': ('dvask',),
'dvaskt': ('dvask',),
'dvelende': ('dvele',),
'dvelt': ('dvele',),
'dvelte': ('dvele',),
'dydd': ('dy',),
'dydde': ('dy',),
'dyende': ('dy',),
'dyadisk': ('dyadisk',),
'dyadiske': ('dyadisk',),
'dyadiskere': ('dyadisk',),
'dyadiskest': ('dyadisk',),
'dyadiskeste': ('dyadisk',),
'dydig': ('dydig',),
'dydige': ('dydig',),
'dydigere': ('dydig',),
'dydigst': ('dydig',),
'dydigste': ('dydig',),
'dydsirede': ('dydsiret',),
'dydsiret': ('dydsiret',),
'dydsirete': ('dydsiret',),
'dydsiretere': ('dydsiret',),
'dydsiretest': ('dydsiret',),
'dydsireteste': ('dydsiret',),
'dykka': ('dykke',),
'dykkede': ('dykke',),
'dykkende': ('dykke',),
'dykket': ('dykke',),
'dykkete': ('dykke',),
'dyktig': ('dyktig',),
'dyktige': ('dyktig',),
'dyktigere': ('dyktig',),
'dyktigst': ('dyktig',),
'dyktigste': ('dyktig',),
'dyktiggjort': ('dyktiggjøre',),
'dyktiggjorte': ('dyktiggjøre',),
'dyktiggjørende': ('dyktiggjøre',),
'dynamisk': ('dynamisk',),
'dynamiske': ('dynamisk',),
'dynamiskere': ('dynamisk',),
'dynamiskest': ('dynamisk',),
'dynamiskeste': ('dynamisk',),
'dynastisk': ('dynastisk',),
'dynastiske': ('dynastisk',),
'dynastiskere': ('dynastisk',),
'dynastiskest': ('dynastisk',),
'dynastiskeste': ('dynastisk',),
'dynga': ('dynge',),
'dyngede': ('dynge',),
'dyngende': ('dynge',),
'dynget': ('dynge',),
'dyngete': ('dynge',),
'dynka': ('dynke',),
'dynkede': ('dynke',),
'dynkende': ('dynke',),
'dynket': ('dynke',),
'dynkete': ('dynke',),
'dyp': ('dyp',),
'dype': ('dyp',),
'dypere': ('dyp',),
'dypest': ('dyp',),
'dypeste': ('dyp',),
'dypt': ('dyp',),
'dypblå': ('dypblå',),
'dypblåe': ('dypblå',),
'dypblåere': ('dypblå',),
'dypblåest': ('dypblå',),
'dypblåeste': ('dypblå',),
'dypblått': ('dypblå',),
'dyperegående': ('dyperegående',),
'dypereliggende': ('dypereliggende',),
'dypetsa': ('dypetse',),
'dypetsede': ('dypetse',),
'dypetsende': ('dypetse',),
'dypetset': ('dypetse',),
'dypetsete': ('dypetse',),
'dypfrysende': ('dypfryse',),
'dypfryst': ('dypfryse',),
'dypfryste': ('dypfryse',),
'dyppa': ('dyppe',),
'dyppede': ('dyppe',),
'dyppende': ('dyppe',),
'dyppet': ('dyppe',),
'dyppete': ('dyppe',),
'dyprød': ('dyprød',),
'dyprøde': ('dyprød',),
'dyprødere': ('dyprød',),
'dyprødest': ('dyprød',),
'dyprødeste': ('dyprød',),
'dyprødt': ('dyprød',),
'dypsindig': ('dypsindig',),
'dypsindige': ('dypsindig',),
'dypsindigere': ('dypsindig',),
'dypsindigst': ('dypsindig',),
'dypsindigste': ('dypsindig',),
'dyptfølt': ('dyptfølt',),
'dyptfølte': ('dyptfølt',),
'dyptføltere': ('dyptfølt',),
'dyptføltest': ('dyptfølt',),
'dyptfølteste': ('dyptfølt',),
'dyptgripende': ('dyptgripende',),
'dyptgående': ('dyptgående',),
'dyptloddende': ('dyptloddende',),
'dypttenkende': ('dypttenkende',),
'dyr': ('dyr',),
'dyre': ('dyr',),
'dyrere': ('dyr',),
'dyrest': ('dyr',),
'dyreste': ('dyr',),
'dyrt': ('dyr',),
'dyrebar': ('dyrebar',),
'dyrebare': ('dyrebar',),
'dyrebarere': ('dyrebar',),
'dyrebarest': ('dyrebar',),
'dyrebareste': ('dyrebar',),
'dyrebart': ('dyrebar',),
'dyrebedre': ('dyregod',),
'dyrebest': ('dyregod',),
'dyrebeste': ('dyregod',),
'dyregod': ('dyregod',),
'dyregode': ('dyregod',),
'dyregodt': ('dyregod',),
'dyrekjøpt': ('dyrekjøpt',),
'dyrekjøpte': ('dyrekjøpt',),
'dyrekjøptere': ('dyrekjøpt',),
'dyrekjøptest': ('dyrekjøpt',),
'dyrekjøpteste': ('dyrekjøpt',),
'dyrisk': ('dyrisk',),
'dyriske': ('dyrisk',),
'dyriskere': ('dyrisk',),
'dyriskest': ('dyrisk',),
'dyriskeste': ('dyrisk',),
'dyrkbar': ('dyrkbar',),
'dyrkbare': ('dyrkbar',),
'dyrkbarere': ('dyrkbar',),
'dyrkbarest': ('dyrkbar',),
'dyrkbareste': ('dyrkbar',),
'dyrkbart': ('dyrkbar',),
'dyrka': ('dyrke',),
'dyrkede': ('dyrke',),
'dyrkende': ('dyrke',),
'dyrket': ('dyrke',),
'dyrkete': ('dyrke',),
'dysfunksjonell': ('dysfunksjonell',),
'dysfunksjonelle': ('dysfunksjonell',),
'dysfunksjonellere': ('dysfunksjonell',),
'dysfunksjonellest': ('dysfunksjonell',),
'dysfunksjonelleste': ('dysfunksjonell',),
'dysfunksjonelt': ('dysfunksjonell',),
'dyssa': ('dysse',),
'dyssede': ('dysse',),
'dyssende': ('dysse',),
'dysset': ('dysse',),
'dyssete': ('dysse',),
'dyster': ('dyster',),
'dystert': ('dyster',),
'dystre': ('dyster',),
'dystrere': ('dyster',),
'dystrest': ('dyster',),
'dystreste': ('dyster',),
'dytta': ('dytte',),
'dyttede': ('dytte',),
'dyttende': ('dytte',),
'dyttet': ('dytte',),
'dyttete': ('dytte',),
'dytta': ('dytte',),
'dyttede': ('dytte',),
'dyttende': ('dytte',),
'dyttet': ('dytte',),
'dyttete': ('dytte',),
'dyvåt': ('dyvåt',),
'dyvåte': ('dyvåt',),
'dyvåtere': ('dyvåt',),
'dyvåtest': ('dyvåt',),
'dyvåteste': ('dyvåt',),
'dyvått': ('dyvåt',),
'dådlaus': ('dådlaus',),
'dådlause': ('dådlaus',),
'dådlausere': ('dådlaus',),
'dådlausest': ('dådlaus',),
'dådlauseste': ('dådlaus',),
'dådlaust': ('dådlaus',),
'dådløs': ('dådløs',),
'dådløse': ('dådløs',),
'dådløsere': ('dådløs',),
'dådløsest': ('dådløs',),
'dådløseste': ('dådløs',),
'dådløst': ('dådløs',),
'dådrik': ('dådrik',),
'dådrike': ('dådrik',),
'dådrikere': ('dådrik',),
'dådrikest': ('dådrik',),
'dådrikeste': ('dådrik',),
'dådrikt': ('dådrik',),
'dåna': ('dåne',),
'dånede': ('dåne',),
'dånende': ('dåne',),
'dånet': ('dåne',),
'dånete': ('dåne',),
'dånt': ('dåne',),
'dånte': ('dåne',),
'dåneferdig': ('dåneferdig',),
'dåneferdige': ('dåneferdig',),
'dåneferdigere': ('dåneferdig',),
'dåneferdigst': ('dåneferdig',),
'dåneferdigste': ('dåneferdig',),
'dåraktig': ('dåraktig',),
'dåraktige': ('dåraktig',),
'dåraktigere': ('dåraktig',),
'dåraktigst': ('dåraktig',),
'dåraktigste': ('dåraktig',),
'dåra': ('dåre',),
'dårede': ('dåre',),
'dårende': ('dåre',),
'dåret': ('dåre',),
'dårete': ('dåre',),
'dårlig': ('dårlig',),
'dårlige': ('dårlig',),
'dårligere': ('dårlig',),
'dårligst': ('dårlig',),
'dårligste': ('dårlig',),
'dåset': ('dåset',),
'dåsete': ('dåset',),
'dåsetere': ('dåset',),
'dåsetest': ('dåset',),
'dåseteste': ('dåset',),
'dåsete': ('dåsete',),
'dødd': ('dø',),
'dødde': ('dø',),
'døende': ('dø',),
'død': ('død',),
'døde': ('død',),
'dødere': ('død',),
'dødest': ('død',),
'dødeste': ('død',),
'dødt': ('død',),
'dødbleik': ('dødbleik',),
'dødbleike': ('dødbleik',),
'dødbleikere': ('dødbleik',),
'dødbleikest': ('dødbleik',),
'dødbleikeste': ('dødbleik',),
'dødbleikt': ('dødbleik',),
'dødblek': ('dødblek',),
'dødbleke': ('dødblek',),
'dødblekere': ('dødblek',),
'dødblekest': ('dødblek',),
'dødblekeste': ('dødblek',),
'dødblekt': ('dødblek',),
'dødbrent': ('dødbrent',),
'dødbrente': ('dødbrent',),
'dødbrentere': ('dødbrent',),
'dødbrentest': ('dødbrent',),
'dødbrenteste': ('dødbrent',),
'dødbringende': ('dødbringende',),
'døddrukken': ('døddrukken',),
'døddrukkent': ('døddrukken',),
'døddrukne': ('døddrukken',),
'døddruknere': ('døddrukken',),
'døddruknest': ('døddrukken',),
'døddrukneste': ('døddrukken',),
'døda': ('døde',),
'dødede': ('døde',),
'dødende': ('døde',),
'dødet': ('døde',),
'dødete': ('døde',),
'dødelig': ('dødelig',),
'dødelige': ('dødelig',),
'dødeligere': ('dødelig',),
'dødeligst': ('dødelig',),
'dødeligste': ('dødelig',),
'dødfødd': ('dødfødd',),
'dødfødde': ('dødfødd',),
'dødføddere': ('dødfødd',),
'dødføddest': ('dødfødd',),
'dødføddeste': ('dødfødd',),
'dødfødt': ('dødfødt',),
'dødfødte': ('dødfødt',),
'dødfødtere': ('dødfødt',),
'dødfødtest': ('dødfødt',),
'dødfødteste': ('dødfødt',),
'dødsdømt': ('dødsdømt',),
'dødsdømte': ('dødsdømt',),
'dødsdømtere': ('dødsdømt',),
'dødsdømtest': ('dødsdømt',),
'dødsdømteste': ('dødsdømt',),
'dødsens': ('dødsens',),
'dødslei': ('dødslei',),
'dødsleie': ('dødslei',),
'dødsleiere': ('dødslei',),
'dødsleiest': ('dødslei',),
'dødsleieste': ('dødslei',),
'dødsleit': ('dødslei',),
'dødsleitt': ('dødslei',),
'dødsmerka': ('dødsmerka',),
'dødsmerkede': ('dødsmerket',),
'dødsmerket': ('dødsmerket',),
'dødsmerkete': ('dødsmerket',),
'dødsmerketere': ('dødsmerket',),
'dødsmerketest': ('dødsmerket',),
'dødsmerketeste': ('dødsmerket',),
'dødssjuk': ('dødssjuk',),
'dødssjuke': ('dødssjuk',),
'dødssjukere': ('dødssjuk',),
'dødssjukest': ('dødssjuk',),
'dødssjukeste': ('dødssjuk',),
'dødssjukt': ('dødssjuk',),
'dødssyk': ('dødssyk',),
'dødssyke': ('dødssyk',),
'dødssykere': ('dødssyk',),
'dødssykest': ('dødssyk',),
'dødssykeste': ('dødssyk',),
'dødssykt': ('dødssyk',),
'dødstrett': ('dødstrett',),
'dødstrette': ('dødstrett',),
'dødstrettere': ('dødstrett',),
'dødstrettest': ('dødstrett',),
'dødstretteste': ('dødstrett',),
'dødstrøtt': ('dødstrøtt',),
'dødstrøtte': ('dødstrøtt',),
'dødstrøttere': ('dødstrøtt',),
'dødstrøttest': ('dødstrøtt',),
'dødstrøtteste': ('dødstrøtt',),
'døgervill': ('døgervill',),
'døgerville': ('døgervill',),
'døgervillere': ('døgervill',),
'døgervillest': ('døgervill',),
'døgervilleste': ('døgervill',),
'døgervilt': ('døgervill',),
'døgneldre': ('døgngammel',),
'døgneldst': ('døgngammel',),
'døgneldste': ('døgngammel',),
'døgngamle': ('døgngammel',),
'døgngammel': ('døgngammel',),
'døgngammelt': ('døgngammel',),
'døgnkontinuerlig': ('døgnkontinuerlig',),
'døgnkontinuerlige': ('døgnkontinuerlig',),
'døgnkontinuerligere': ('døgnkontinuerlig',),
'døgnkontinuerligst': ('døgnkontinuerlig',),
'døgnkontinuerligste': ('døgnkontinuerlig',),
'døgnvill': ('døgnvill',),
'døgnville': ('døgnvill',),
'døgnvillere': ('døgnvill',),
'døgnvillest': ('døgnvill',),
'døgnvilleste': ('døgnvill',),
'døgnvilt': ('døgnvill',),
'døgnåpen': ('døgnåpen',),
'døgnåpent': ('døgnåpen',),
'døgnåpne': ('døgnåpen',),
'døgnåpnere': ('døgnåpen',),
'døgnåpnest': ('døgnåpen',),
'døgnåpneste': ('døgnåpen',),
'dulgt': ('dølge',),
'dulgte': ('dølge',),
'dølgende': ('dølge',),
'dølsk': ('dølsk',),
'dølske': ('dølsk',),
'dølskere': ('dølsk',),
'dølskest': ('dølsk',),
'dølskeste': ('dølsk',),
'dømmende': ('dømme',),
'dømt': ('dømme',),
'dømte': ('dømme',),
'dømmesjuk': ('dømmesjuk',),
'dømmesjuke': ('dømmesjuk',),
'dømmesjukere': ('dømmesjuk',),
'dømmesjukest': ('dømmesjuk',),
'dømmesjukeste': ('dømmesjuk',),
'dømmesjukt': ('dømmesjuk',),
'dømmesyk': ('dømmesyk',),
'dømmesyke': ('dømmesyk',),
'dømmesykere': ('dømmesyk',),
'dømmesykest': ('dømmesyk',),
'dømmesykeste': ('dømmesyk',),
'dømmesykt': ('dømmesyk',),
'dønna': ('dønne',),
'dønnede': ('dønne',),
'dønnende': ('dønne',),
'dønnet': ('dønne',),
'dønnete': ('dønne',),
'dønt': ('dønne',),
'dønte': ('dønne',),
'døpende': ('døpe',),
'døpt': ('døpe',),
'døpte': ('døpe',),
'døsa': ('døse',),
'døsede': ('døse',),
'døsende': ('døse',),
'døset': ('døse',),
'døsete': ('døse',),
'døst': ('døse',),
'døste': ('døse',),
'døsen': ('døsen',),
'døsent': ('døsen',),
'døsne': ('døsen',),
'døsnere': ('døsen',),
'døsnest': ('døsen',),
'døsneste': ('døsen',),
'døsig': ('døsig',),
'døsige': ('døsig',),
'døsigere': ('døsig',),
'døsigst': ('døsig',),
'døsigste': ('døsig',),
'døv': ('døv',),
'døve': ('døv',),
'døvere': ('døv',),
'døvest': ('døv',),
'døveste': ('døv',),
'døvt': ('døv',),
'døvblind': ('døvblind',),
'døvblinde': ('døvblind',),
'døvblindere': ('døvblind',),
'døvblindest': ('døvblind',),
'døvblindeste': ('døvblind',),
'døvblindt': ('døvblind',),
'døvfødd': ('døvfødd',),
'døvfødde': ('døvfødd',),
'døvføddere': ('døvfødd',),
'døvføddest': ('døvfødd',),
'døvføddeste': ('døvfødd',),
'døvfødt': ('døvfødt',),
'døvfødte': ('døvfødt',),
'døvfødtere': ('døvfødt',),
'døvfødtest': ('døvfødt',),
'døvfødteste': ('døvfødt',),
'døvhørt': ('døvhørt',),
'døvhørte': ('døvhørt',),
'døvhørtere': ('døvhørt',),
'døvhørtest': ('døvhørt',),
'døvhørteste': ('døvhørt',),
'døvstum': ('døvstum',),
'døvstumme': ('døvstum',),
'døvstummere': ('døvstum',),
'døvstummest': ('døvstum',),
'døvstummeste': ('døvstum',),
'døvstumt': ('døvstum',),
'døya': ('døye',),
'døyd': ('døye',),
'døyde': ('døye',),
'døyede': ('døye',),
'døyende': ('døye',),
'døyet': ('døye',),
'døyete': ('døye',),
'døyva': ('døyve',),
'døyvd': ('døyve',),
'døyvde': ('døyve',),
'døyvede': ('døyve',),
'døyvende': ('døyve',),
'døyvet': ('døyve',),
'døyvete': ('døyve',),
'ebba': ('ebbe',),
'ebbede': ('ebbe',),
'ebbende': ('ebbe',),
'ebbet': ('ebbe',),
'ebbete': ('ebbe',),
'ecru': ('ecru',),
'ecuadoriansk': ('ecuadoriansk',),
'ecuadorianske': ('ecuadoriansk',),
'ecuadorianskere': ('ecuadoriansk',),
'ecuadorianskest': ('ecuadoriansk',),
'ecuadorianskeste': ('ecuadoriansk',),
'edafisk': ('edafisk',),
'edafiske': ('edafisk',),
'edafiskere': ('edafisk',),
'edafiskest': ('edafisk',),
'edafiskeste': ('edafisk',),
'eddiksur': ('eddiksur',),
'eddiksure': ('eddiksur',),
'eddiksurere': ('eddiksur',),
'eddiksurest': ('eddiksur',),
'eddiksureste': ('eddiksur',),
'eddiksurt': ('eddiksur',),
'edel': ('edel',),
'edelt': ('edel',),
'edle': ('edel',),
'edlere': ('edel',),
'edlest': ('edel',),
'edleste': ('edel',),
'edelig': ('edelig',),
'edelige': ('edelig',),
'edeligere': ('edelig',),
'edeligst': ('edelig',),
'edeligste': ('edelig',),
'edelmodig': ('edelmodig',),
'edelmodige': ('edelmodig',),
'edelmodigere': ('edelmodig',),
'edelmodigst': ('edelmodig',),
'edelmodigste': ('edelmodig',),
'edfesta': ('edfeste',),
'edfestede': ('edfeste',),
'edfestende': ('edfeste',),
'edfestet': ('edfeste',),
'edfestete': ('edfeste',),
'edru': ('edru',),
'edrue': ('edru',),
'edruere': ('edru',),
'edruest': ('edru',),
'edrueste': ('edru',),
'edruelig': ('edruelig',),
'edruelige': ('edruelig',),
'edrueligere': ('edruelig',),
'edrueligst': ('edruelig',),
'edrueligste': ('edruelig',),
'edsvoren': ('edsvoren',),
'edsvorent': ('edsvoren',),
'edsvorne': ('edsvoren',),
'edsvornere': ('edsvoren',),
'edsvornest': ('edsvoren',),
'edsvorneste': ('edsvoren',),
'efemer': ('efemer',),
'efemere': ('efemer',),
'efemerere': ('efemer',),
'efemerest': ('efemer',),
'efemereste': ('efemer',),
'efemert': ('efemer',),
'effektfull': ('effektfull',),
'effektfulle': ('effektfull',),
'effektfullere': ('effektfull',),
'effektfullest': ('effektfull',),
'effektfulleste': ('effektfull',),
'effektfullt': ('effektfull',),
'effektiv': ('effektiv',),
'effektive': ('effektiv',),
'effektivere': ('effektiv',),
'effektivest': ('effektiv',),
'effektiveste': ('effektiv',),
'effektivt': ('effektiv',),
'effektiviserende': ('effektivisere',),
'effektivisert': ('effektivisere',),
'effektiviserte': ('effektivisere',),
'effektuerende': ('effektuere',),
'effektuert': ('effektuere',),
'effektuerte': ('effektuere',),
'egal': ('egal',),
'egale': ('egal',),
'egalere': ('egal',),
'egalest': ('egal',),
'egaleste': ('egal',),
'egalt': ('egal',),
'egaliserende': ('egalisere',),
'egalisert': ('egalisere',),
'egaliserte': ('egalisere',),
'egalitær': ('egalitær',),
'egalitære': ('egalitær',),
'egalitærere': ('egalitær',),
'egalitærest': ('egalitær',),
'egalitæreste': ('egalitær',),
'egalitært': ('egalitær',),
'egdsk': ('egdsk',),
'egdske': ('egdsk',),
'egdskere': ('egdsk',),
'egdskest': ('egdsk',),
'egdskeste': ('egdsk',),
'egeisk': ('egeisk',),
'egeiske': ('egeisk',),
'egeiskere': ('egeisk',),
'egeiskest': ('egeisk',),
'egeiskeste': ('egeisk',),
'egen': ('egen',),
'egent': ('egen',),
'egne': ('egen',),
'egnere': ('egen',),
'egnest': ('egen',),
'egneste': ('egen',),
'egenarta': ('egenarta',),
'egenartede': ('egenartet',),
'egenartet': ('egenartet',),
'egenartete': ('egenartet',),
'egenartetere': ('egenartet',),
'egenartetest': ('egenartet',),
'egenarteteste': ('egenartet',),
'egenhendig': ('egenhendig',),
'egenhendige': ('egenhendig',),
'egenhendigere': ('egenhendig',),
'egenhendigst': ('egenhendig',),
'egenhendigste': ('egenhendig',),
'egenkjærlig': ('egenkjærlig',),
'egenkjærlige': ('egenkjærlig',),
'egenkjærligere': ('egenkjærlig',),
'egenkjærligst': ('egenkjærlig',),
'egenkjærligste': ('egenkjærlig',),
'egenmektig': ('egenmektig',),
'egenmektige': ('egenmektig',),
'egenmektigere': ('egenmektig',),
'egenmektigst': ('egenmektig',),
'egenmektigste': ('egenmektig',),
'egenprodusert': ('egenprodusert',),
'egenproduserte': ('egenprodusert',),
'egenprodusertere': ('egenprodusert',),
'egenprodusertest': ('egenprodusert',),
'egenproduserteste': ('egenprodusert',),
'egenrettferdig': ('egenrettferdig',),
'egenrettferdige': ('egenrettferdig',),
'egenrettferdigere': ('egenrettferdig',),
'egenrettferdigst': ('egenrettferdig',),
'egenrettferdigste': ('egenrettferdig',),
'egenrådig': ('egenrådig',),
'egenrådige': ('egenrådig',),
'egenrådigere': ('egenrådig',),
'egenrådigst': ('egenrådig',),
'egenrådigste': ('egenrådig',),
'egensikker': ('egensikker',),
'egensikkert': ('egensikker',),
'egensikre': ('egensikker',),
'egensikrere': ('egensikker',),
'egensikrest': ('egensikker',),
'egensikreste': ('egensikker',),
'egensindig': ('egensindig',),
'egensindige': ('egensindig',),
'egensindigere': ('egensindig',),
'egensindigst': ('egensindig',),
'egensindigste': ('egensindig',),
'egentlig': ('egentlig',),
'egentlige': ('egentlig',),
'egentligere': ('egentlig',),
'egentligst': ('egentlig',),
'egentligste': ('egentlig',),
'egga': ('egge',),
'eggede': ('egge',),
'eggende': ('egge',),
'egget': ('egge',),
'eggete': ('egge',),
'eggeforma': ('eggeforma',),
'eggeformede': ('eggeformet',),
'eggeformet': ('eggeformet',),
'eggeformete': ('eggeformet',),
'eggeformetere': ('eggeformet',),
'eggeformetest': ('eggeformet',),
'eggeformeteste': ('eggeformet',),
'eggeskalfarga': ('eggeskalfarga',),
'eggeskalfargede': ('eggeskalfarget',),
'eggeskalfarget': ('eggeskalfarget',),
'eggeskalfargete': ('eggeskalfarget',),
'eggeskalfargetere': ('eggeskalfarget',),
'eggeskalfargetest': ('eggeskalfarget',),
'eggeskalfargeteste': ('eggeskalfarget',),
'eggeskallfarga': ('eggeskallfarga',),
'eggeskallfargede': ('eggeskallfarget',),
'eggeskallfarget': ('eggeskallfarget',),
'eggeskallfargete': ('eggeskallfarget',),
'eggeskallfargetere': ('eggeskallfarget',),
'eggeskallfargetest': ('eggeskallfarget',),
'eggeskallfargeteste': ('eggeskallfarget',),
'eggforma': ('eggforma',),
'eggformede': ('eggformet',),
'eggformet': ('eggformet',),
'eggformete': ('eggformet',),
'eggformetere': ('eggformet',),
'eggformetest': ('eggformet',),
'eggformeteste': ('eggformet',),
'egla': ('egle',),
'eglede': ('egle',),
'eglende': ('egle',),
'eglet': ('egle',),
'eglete': ('egle',),
'eglet': ('eglet',),
'eglete': ('eglet',),
'egletere': ('eglet',),
'egletest': ('eglet',),
'egleteste': ('eglet',),
'eglete': ('eglete',),
'egna': ('egna',),
'egna': ('egne',),
'egnede': ('egne',),
'egnende': ('egne',),
'egnet': ('egne',),
'egnete': ('egne',),
'egna': ('egne',),
'egnede': ('egne',),
'egnende': ('egne',),
'egnet': ('egne',),
'egnete': ('egne',),
'egnt': ('egne',),
'egnte': ('egne',),
'egnede': ('egnet',),
'egnet': ('egnet',),
'egnete': ('egnet',),
'egnetere': ('egnet',),
'egnetest': ('egnet',),
'egneteste': ('egnet',),
'egoistisk': ('egoistisk',),
'egoistiske': ('egoistisk',),
'egoistiskere': ('egoistisk',),
'egoistiskest': ('egoistisk',),
'egoistiskeste': ('egoistisk',),
'egosentrisk': ('egosentrisk',),
'egosentriske': ('egosentrisk',),
'egosentriskere': ('egosentrisk',),
'egosentriskest': ('egosentrisk',),
'egosentriskeste': ('egosentrisk',),
'egyptisk': ('egyptisk',),
'egyptiske': ('egyptisk',),
'egyptiskere': ('egyptisk',),
'egyptiskest': ('egyptisk',),
'egyptiskeste': ('egyptisk',),
'eid': ('eie',),
'eide': ('eie',),
'eiede': ('eie',),
'eiende': ('eie',),
'eiet': ('eie',),
'eiete': ('eie',),
'ått': ('eie',),
'åtte': ('eie',),
'eiebedre': ('eiegod',),
'eiebest': ('eiegod',),
'eiebeste': ('eiegod',),
'eiegod': ('eiegod',),
'eiegode': ('eiegod',),
'eiegodt': ('eiegod',),
'eiendommelig': ('eiendommelig',),
'eiendommelige': ('eiendommelig',),
'eiendommeligere': ('eiendommelig',),
'eiendommeligst': ('eiendommelig',),
'eiendommeligste': ('eiendommelig',),
'eiendomslaus': ('eiendomslaus',),
'eiendomslause': ('eiendomslaus',),
'eiendomslausere': ('eiendomslaus',),
'eiendomslausest': ('eiendomslaus',),
'eiendomslauseste': ('eiendomslaus',),
'eiendomslaust': ('eiendomslaus',),
'eiendomsløs': ('eiendomsløs',),
'eiendomsløse': ('eiendomsløs',),
'eiendomsløsere': ('eiendomsløs',),
'eiendomsløsest': ('eiendomsløs',),
'eiendomsløseste': ('eiendomsløs',),
'eiendomsløst': ('eiendomsløs',),
'eiesnill': ('eiesnill',),
'eiesnille': ('eiesnill',),
'eiesnillere': ('eiesnill',),
'eiesnillest': ('eiesnill',),
'eiesnilleste': ('eiesnill',),
'eiesnilt': ('eiesnill',),
'eigenarta': ('eigenarta',),
'eigenartede': ('eigenartet',),
'eigenartet': ('eigenartet',),
'eigenartete': ('eigenartet',),
'eigenartetere': ('eigenartet',),
'eigenartetest': ('eigenartet',),
'eigenarteteste': ('eigenartet',),
'eigenhendig': ('eigenhendig',),
'eigenhendige': ('eigenhendig',),
'eigenhendigere': ('eigenhendig',),
'eigenhendigst': ('eigenhendig',),
'eigenhendigste': ('eigenhendig',),
'eigenkjærlig': ('eigenkjærlig',),
'eigenkjærlige': ('eigenkjærlig',),
'eigenkjærligere': ('eigenkjærlig',),
'eigenkjærligst': ('eigenkjærlig',),
'eigenkjærligste': ('eigenkjærlig',),
'eigenmektig': ('eigenmektig',),
'eigenmektige': ('eigenmektig',),
'eigenmektigere': ('eigenmektig',),
'eigenmektigst': ('eigenmektig',),
'eigenmektigste': ('eigenmektig',),
'eigenprodusert': ('eigenprodusert',),
'eigenproduserte': ('eigenprodusert',),
'eigenprodusertere': ('eigenprodusert',),
'eigenprodusertest': ('eigenprodusert',),
'eigenproduserteste': ('eigenprodusert',),
'eigenrettferdig': ('eigenrettferdig',),
'eigenrettferdige': ('eigenrettferdig',),
'eigenrettferdigere': ('eigenrettferdig',),
'eigenrettferdigst': ('eigenrettferdig',),
'eigenrettferdigste': ('eigenrettferdig',),
'eigenrådig': ('eigenrådig',),
'eigenrådige': ('eigenrådig',),
'eigenrådigere': ('eigenrådig',),
'eigenrådigst': ('eigenrådig',),
'eigenrådigste': ('eigenrådig',),
'eigensikker': ('eigensikker',),
'eigensikkert': ('eigensikker',),
'eigensikre': ('eigensikker',),
'eigensikrere': ('eigensikker',),
'eigensikrest': ('eigensikker',),
'eigensikreste': ('eigensikker',),
'eigensindig': ('eigensindig',),
'eigensindige': ('eigensindig',),
'eigensindigere': ('eigensindig',),
'eigensindigst': ('eigensindig',),
'eigensindigste': ('eigensindig',),
'eima': ('eime',),
'eimede': ('eime',),
'eimende': ('eime',),
'eimet': ('eime',),
'eimete': ('eime',),
'einslig': ('einslig',),
'einslige': ('einslig',),
'einsligere': ('einslig',),
'einsligst': ('einslig',),
'einsligste': ('einslig',),
'einsligstilt': ('einsligstilt',),
'einsligstilte': ('einsligstilt',),
'einsligstiltere': ('einsligstilt',),
'einsligstiltest': ('einsligstilt',),
'einsligstilteste': ('einsligstilt',),
'eira': ('eire',),
'eirede': ('eire',),
'eirende': ('eire',),
'eiret': ('eire',),
'eirete': ('eire',),
'eiret': ('eiret',),
'eirete': ('eiret',),
'eiretere': ('eiret',),
'eiretest': ('eiret',),
'eireteste': ('eiret',),
'eirete': ('eirete',),
'eirgrøn': ('eirgrøn',),
'eirgrøne': ('eirgrøn',),
'eirgrønere': ('eirgrøn',),
'eirgrønest': ('eirgrøn',),
'eirgrøneste': ('eirgrøn',),
'eirgrønt': ('eirgrøn',),
'eirgrønn': ('eirgrønn',),
'eirgrønne': ('eirgrønn',),
'eirgrønnere': ('eirgrønn',),
'eirgrønnest': ('eirgrønn',),
'eirgrønneste': ('eirgrønn',),
'eirgrønt': ('eirgrønn',),
'ejakulerende': ('ejakulere',),
'ejakulert': ('ejakulere',),
'ejakulerte': ('ejakulere',),
'ekkel': ('ekkel',),
'ekkelt': ('ekkel',),
'ekle': ('ekkel',),
'eklere': ('ekkel',),
'eklest': ('ekkel',),
'ekleste': ('ekkel',),
'eklatant': ('eklatant',),
'eklatante': ('eklatant',),
'eklatantere': ('eklatant',),
'eklatantest': ('eklatant',),
'eklatanteste': ('eklatant',),
'eklektisk': ('eklektisk',),
'eklektiske': ('eklektisk',),
'eklektiskere': ('eklektisk',),
'eklektiskest': ('eklektisk',),
'eklektiskeste': ('eklektisk',),
'eksakt': ('eksakt',),
'eksakte': ('eksakt',),
'eksaktere': ('eksakt',),
'eksaktest': ('eksakt',),
'eksakteste': ('eksakt',),
'eksaltert': ('eksaltert',),
'eksalterte': ('eksaltert',),
'eksaltertere': ('eksaltert',),
'eksaltertest': ('eksaltert',),
'eksalterteste': ('eksaltert',),
'eksamensberettiga': ('eksamensberettiga',),
'eksamensberettigede': ('eksamensberettiget',),
'eksamensberettiget': ('eksamensberettiget',),
'eksamensberettigete': ('eksamensberettiget',),
'eksamensberettigetere': ('eksamensberettiget',),
'eksamensberettigetest': ('eksamensberettiget',),
'eksamensberettigeteste': ('eksamensberettiget',),
'eksamensfri': ('eksamensfri',),
'eksamensfrie': ('eksamensfri',),
'eksamensfriere': ('eksamensfri',),
'eksamensfriest': ('eksamensfri',),
'eksamensfrieste': ('eksamensfri',),
'eksamensfritt': ('eksamensfri',),
'eksamensretta': ('eksamensretta',),
'eksamensrettede': ('eksamensrettet',),
'eksamensrettet': ('eksamensrettet',),
'eksamensrettete': ('eksamensrettet',),
'eksamensrettetere': ('eksamensrettet',),
'eksamensrettetest': ('eksamensrettet',),
'eksamensretteteste': ('eksamensrettet',),
'eksaminatorisk': ('eksaminatorisk',),
'eksaminatoriske': ('eksaminatorisk',),
'eksaminatoriskere': ('eksaminatorisk',),
'eksaminatoriskest': ('eksaminatorisk',),
'eksaminatoriskeste': ('eksaminatorisk',),
'eksaminerende': ('eksaminere',),
'eksaminert': ('eksaminere',),
'eksaminerte': ('eksaminere',),
'eksegerende': ('eksegere',),
'eksegert': ('eksegere',),
'eksegerte': ('eksegere',),
'eksegetisk': ('eksegetisk',),
'eksegetiske': ('eksegetisk',),
'eksegetiskere': ('eksegetisk',),
'eksegetiskest': ('eksegetisk',),
'eksegetiskeste': ('eksegetisk',),
'eksekutiv': ('eksekutiv',),
'eksekutive': ('eksekutiv',),
'eksekutivere': ('eksekutiv',),
'eksekutivest': ('eksekutiv',),
'eksekutiveste': ('eksekutiv',),
'eksekutivt': ('eksekutiv',),
'eksekverende': ('eksekvere',),
'eksekvert': ('eksekvere',),
'eksekverte': ('eksekvere',),
'eksellent': ('eksellent',),
'eksellente': ('eksellent',),
'eksellentere': ('eksellent',),
'eksellentest': ('eksellent',),
'eksellenteste': ('eksellent',),
'eksellerende': ('eksellere',),
'eksellert': ('eksellere',),
'eksellerte': ('eksellere',),
'eksemplarisk': ('eksemplarisk',),
'eksemplariske': ('eksemplarisk',),
'eksemplariskere': ('eksemplarisk',),
'eksemplariskest': ('eksemplarisk',),
'eksemplariskeste': ('eksemplarisk',),
'eksemplifiserende': ('eksemplifisere',),
'eksemplifisert': ('eksemplifisere',),
'eksemplifiserte': ('eksemplifisere',),
'eksentrisk': ('eksentrisk',),
'eksentriske': ('eksentrisk',),
'eksentriskere': ('eksentrisk',),
'eksentriskest': ('eksentrisk',),
'eksentriskeste': ('eksentrisk',),
'eksepsjonell': ('eksepsjonell',),
'eksepsjonelle': ('eksepsjonell',),
'eksepsjonellere': ('eksepsjonell',),
'eksepsjonellest': ('eksepsjonell',),
'eksepsjonelleste': ('eksepsjonell',),
'eksepsjonelt': ('eksepsjonell',),
'ekserperende': ('ekserpere',),
'ekserpert': ('ekserpere',),
'ekserperte': ('ekserpere',),
'ekserserende': ('eksersere',),
'eksersert': ('eksersere',),
'ekserserte': ('eksersere',),
'ekshalerende': ('ekshalere',),
'ekshalert': ('ekshalere',),
'ekshalerte': ('ekshalere',),
'ekshibisjonistisk': ('ekshibisjonistisk',),
'ekshibisjonistiske': ('ekshibisjonistisk',),
'ekshibisjonistiskere': ('ekshibisjonistisk',),
'ekshibisjonistiskest': ('ekshibisjonistisk',),
'ekshibisjonistiskeste': ('ekshibisjonistisk',),
'eksistensialistisk': ('eksistensialistisk',),
'eksistensialistiske': ('eksistensialistisk',),
'eksistensialistiskere': ('eksistensialistisk',),
'eksistensialistiskest': ('eksistensialistisk',),
'eksistensialistiskeste': ('eksistensialistisk',),
'eksistensiell': ('eksistensiell',),
'eksistensielle': ('eksistensiell',),
'eksistensiellere': ('eksistensiell',),
'eksistensiellest': ('eksistensiell',),
'eksistensielleste': ('eksistensiell',),
'eksistensielt': ('eksistensiell',),
'eksisterende': ('eksistere',),
'eksistert': ('eksistere',),
'eksisterte': ('eksistere',),
'eksklamerende': ('eksklamere',),
'eksklamert': ('eksklamere',),
'eksklamerte': ('eksklamere',),
'ekskluderende': ('ekskludere',),
'ekskludert': ('ekskludere',),
'ekskluderte': ('ekskludere',),
'eksklusiv': ('eksklusiv',),
'eksklusive': ('eksklusiv',),
'eksklusivere': ('eksklusiv',),
'eksklusivest': ('eksklusiv',),
'eksklusiveste': ('eksklusiv',),
'eksklusivt': ('eksklusiv',),
'ekskommuniserende': ('ekskommunisere',),
'ekskommunisert': ('ekskommunisere',),
'ekskommuniserte': ('ekskommunisere',),
'eksogen': ('eksogen',),
'eksogene': ('eksogen',),
'eksogenere': ('eksogen',),
'eksogenest': ('eksogen',),
'eksogeneste': ('eksogen',),
'eksogent': ('eksogen',),
'eksokrin': ('eksokrin',),
'eksokrine': ('eksokrin',),
'eksokrinere': ('eksokrin',),
'eksokrinest': ('eksokrin',),
'eksokrineste': ('eksokrin',),
'eksokrint': ('eksokrin',),
'eksosforgifta': ('eksosforgifta',),
'eksosforgiftede': ('eksosforgiftet',),
'eksosforgiftet': ('eksosforgiftet',),
'eksosforgiftete': ('eksosforgiftet',),
'eksosforgiftetere': ('eksosforgiftet',),
'eksosforgiftetest': ('eksosforgiftet',),
'eksosforgifteteste': ('eksosforgiftet',),
'eksoterisk': ('eksoterisk',),
'eksoteriske': ('eksoterisk',),
'eksoteriskere': ('eksoterisk',),
'eksoteriskest': ('eksoterisk',),
'eksoteriskeste': ('eksoterisk',),
'eksoterm': ('eksoterm',),
'eksoterme': ('eksoterm',),
'eksotermere': ('eksoterm',),
'eksotermest': ('eksoterm',),
'eksotermeste': ('eksoterm',),
'eksotermt': ('eksoterm',),
'eksotisk': ('eksotisk',),
'eksotiske': ('eksotisk',),
'eksotiskere': ('eksotisk',),
'eksotiskest': ('eksotisk',),
'eksotiskeste': ('eksotisk',),
'ekspanderende': ('ekspandere',),
'ekspandert': ('ekspandere',),
'ekspanderte': ('ekspandere',),
'ekspansiv': ('ekspansiv',),
'ekspansive': ('ekspansiv',),
'ekspansivere': ('ekspansiv',),
'ekspansivest': ('ekspansiv',),
'ekspansiveste': ('ekspansiv',),
'ekspansivt': ('ekspansiv',),
'ekspatrierende': ('ekspatriere',),
'ekspatriert': ('ekspatriere',),
'ekspatrierte': ('ekspatriere',),
'ekspederende': ('ekspedere',),
'ekspedert': ('ekspedere',),
'ekspederte': ('ekspedere',),
'ekspeditt': ('ekspeditt',),
'ekspeditte': ('ekspeditt',),
'ekspedittere': ('ekspeditt',),
'ekspedittest': ('ekspeditt',),
'ekspeditteste': ('ekspeditt',),
'eksperimentell': ('eksperimentell',),
'eksperimentelle': ('eksperimentell',),
'eksperimentellere': ('eksperimentell',),
'eksperimentellest': ('eksperimentell',),
'eksperimentelleste': ('eksperimentell',),
'eksperimentelt': ('eksperimentell',),
'eksperimenterende': ('eksperimentere',),
'eksperimentert': ('eksperimentere',),
'eksperimenterte': ('eksperimentere',),
'ekspiratorisk': ('ekspiratorisk',),
'ekspiratoriske': ('ekspiratorisk',),
'ekspiratoriskere': ('ekspiratorisk',),
'ekspiratoriskest': ('ekspiratorisk',),
'ekspiratoriskeste': ('ekspiratorisk',),
'ekspirerende': ('ekspirere',),
'ekspirert': ('ekspirere',),
'ekspirerte': ('ekspirere',),
'eksplisitt': ('eksplisitt',),
'eksplisitte': ('eksplisitt',),
'eksplisittere': ('eksplisitt',),
'eksplisittest': ('eksplisitt',),
'eksplisitteste': ('eksplisitt',),
'eksplisitterende': ('eksplisittere',),
'eksplisittert': ('eksplisittere',),
'eksplisitterte': ('eksplisittere',),
'eksploaterende': ('eksploatere',),
'eksploatert': ('eksploatere',),
'eksploaterte': ('eksploatere',),
'eksploderende': ('eksplodere',),
'eksplodert': ('eksplodere',),
'eksploderte': ('eksplodere',),
'eksplosiv': ('eksplosiv',),
'eksplosive': ('eksplosiv',),
'eksplosivere': ('eksplosiv',),
'eksplosivest': ('eksplosiv',),
'eksplosiveste': ('eksplosiv',),
'eksplosivt': ('eksplosiv',),
'eksplosjonsarta': ('eksplosjonsarta',),
'eksplosjonsartede': ('eksplosjonsartet',),
'eksplosjonsartet': ('eksplosjonsartet',),
'eksplosjonsartete': ('eksplosjonsartet',),
'eksplosjonsartetere': ('eksplosjonsartet',),
'eksplosjonsartetest': ('eksplosjonsartet',),
'eksplosjonsarteteste': ('eksplosjonsartet',),
'eksplosjonsfarlig': ('eksplosjonsfarlig',),
'eksplosjonsfarlige': ('eksplosjonsfarlig',),
'eksplosjonsfarligere': ('eksplosjonsfarlig',),
'eksplosjonsfarligst': ('eksplosjonsfarlig',),
'eksplosjonsfarligste': ('eksplosjonsfarlig',),
'eksplosjonssikker': ('eksplosjonssikker',),
'eksplosjonssikkert': ('eksplosjonssikker',),
'eksplosjonssikre': ('eksplosjonssikker',),
'eksplosjonssikrere': ('eksplosjonssikker',),
'eksplosjonssikrest': ('eksplosjonssikker',),
'eksplosjonssikreste': ('eksplosjonssikker',),
'eksplosjonstett': ('eksplosjonstett',),
'eksplosjonstette': ('eksplosjonstett',),
'eksplosjonstettere': ('eksplosjonstett',),
'eksplosjonstettest': ('eksplosjonstett',),
'eksplosjonstetteste': ('eksplosjonstett',),
'eksponerende': ('eksponere',),
'eksponert': ('eksponere',),
'eksponerte': ('eksponere',),
'eksporterende': ('eksportere',),
'eksportert': ('eksportere',),
'eksporterte': ('eksportere',),
'eksportfremmende': ('eksportfremmende',),
'eksportregulerende': ('eksportregulerende',),
'ekspresjonistisk': ('ekspresjonistisk',),
'ekspresjonistiske': ('ekspresjonistisk',),
'ekspresjonistiskere': ('ekspresjonistisk',),
'ekspresjonistiskest': ('ekspresjonistisk',),
'ekspresjonistiskeste': ('ekspresjonistisk',),
'ekspressiv': ('ekspressiv',),
'ekspressive': ('ekspressiv',),
'ekspressivere': ('ekspressiv',),
'ekspressivest': ('ekspressiv',),
'ekspressiveste': ('ekspressiv',),
'ekspressivt': ('ekspressiv',),
'eksproprierende': ('ekspropriere',),
'ekspropriert': ('ekspropriere',),
'eksproprierte': ('ekspropriere',),
'ekstatisk': ('ekstatisk',),
'ekstatiske': ('ekstatisk',),
'ekstatiskere': ('ekstatisk',),
'ekstatiskest': ('ekstatisk',),
'ekstatiskeste': ('ekstatisk',),
'ekstemporal': ('ekstemporal',),
'ekstemporale': ('ekstemporal',),
'ekstemporalere': ('ekstemporal',),
'ekstemporalest': ('ekstemporal',),
'ekstemporaleste': ('ekstemporal',),
'ekstemporalt': ('ekstemporal',),
'ekstemporerende': ('ekstemporere',),
'ekstemporert': ('ekstemporere',),
'ekstemporerte': ('ekstemporere',),
'ekstensiv': ('ekstensiv',),
'ekstensive': ('ekstensiv',),
'ekstensivere': ('ekstensiv',),
'ekstensivest': ('ekstensiv',),
'ekstensiveste': ('ekstensiv',),
'ekstensivt': ('ekstensiv',),
'ekstensiverende': ('ekstensivere',),
'ekstensivert': ('ekstensivere',),
'ekstensiverte': ('ekstensivere',),
'ekstern': ('ekstern',),
'eksterne': ('ekstern',),
'eksternere': ('ekstern',),
'eksternest': ('ekstern',),
'eksterneste': ('ekstern',),
'eksternt': ('ekstern',),
'eksterritorial': ('eksterritorial',),
'eksterritoriale': ('eksterritorial',),
'eksterritorialere': ('eksterritorial',),
'eksterritorialest': ('eksterritorial',),
'eksterritorialeste': ('eksterritorial',),
'eksterritorialt': ('eksterritorial',),
'ekstra': ('ekstra',),
'ekstraherende': ('ekstrahere',),
'ekstrahert': ('ekstrahere',),
'ekstraherte': ('ekstrahere',),
'ekstraordinær': ('ekstraordinær',),
'ekstraordinære': ('ekstraordinær',),
'ekstraordinærere': ('ekstraordinær',),
'ekstraordinærest': ('ekstraordinær',),
'ekstraordinæreste': ('ekstraordinær',),
'ekstraordinært': ('ekstraordinær',),
'ekstrapolerende': ('ekstrapolere',),
'ekstrapolert': ('ekstrapolere',),
'ekstrapolerte': ('ekstrapolere',),
'ekstrauterin': ('ekstrauterin',),
'ekstrauterine': ('ekstrauterin',),
'ekstrauterinere': ('ekstrauterin',),
'ekstrauterinest': ('ekstrauterin',),
'ekstrauterineste': ('ekstrauterin',),
'ekstrauterint': ('ekstrauterin',),
'ekstravagant': ('ekstravagant',),
'ekstravagante': ('ekstravagant',),
'ekstravagantere': ('ekstravagant',),
'ekstravagantest': ('ekstravagant',),
'ekstravaganteste': ('ekstravagant',),
'ekstrem': ('ekstrem',),
'ekstreme': ('ekstrem',),
'ekstremere': ('ekstrem',),
'ekstremest': ('ekstrem',),
'ekstremeste': ('ekstrem',),
'ekstremt': ('ekstrem',),
'ekstremistisk': ('ekstremistisk',),
'ekstremistiske': ('ekstremistisk',),
'ekstremistiskere': ('ekstremistisk',),
'ekstremistiskest': ('ekstremistisk',),
'ekstremistiskeste': ('ekstremistisk',),
'ekstrovert': ('ekstrovert',),
'ekstroverte': ('ekstrovert',),
'ekstrovertere': ('ekstrovert',),
'ekstrovertest': ('ekstrovert',),
'ekstroverteste': ('ekstrovert',),
'ekta': ('ekte',),
'ektede': ('ekte',),
'ektende': ('ekte',),
'ektet': ('ekte',),
'ektete': ('ekte',),
'ekte': ('ekte',),
'ekteskapelig': ('ekteskapelig',),
'ekteskapelige': ('ekteskapelig',),
'ekteskapeligere': ('ekteskapelig',),
'ekteskapeligst': ('ekteskapelig',),
'ekteskapeligste': ('ekteskapelig',),
'ektevia': ('ektevie',),
'ektevidd': ('ektevie',),
'ektevidde': ('ektevie',),
'ekteviede': ('ektevie',),
'ekteviende': ('ektevie',),
'ekteviet': ('ektevie',),
'ekteviete': ('ektevie',),
'ektevigd': ('ektevie',),
'ektevigde': ('ektevie',),
'ekvatorial': ('ekvatorial',),
'ekvatoriale': ('ekvatorial',),
'ekvatorialere': ('ekvatorial',),
'ekvatorialest': ('ekvatorial',),
'ekvatorialeste': ('ekvatorial',),
'ekvatorialt': ('ekvatorial',),
'ekvatorialguineansk': ('ekvatorialguineansk',),
'ekvatorialguineanske': ('ekvatorialguineansk',),
'ekvatorialguineanskere': ('ekvatorialguineansk',),
'ekvatorialguineanskest': ('ekvatorialguineansk',),
'ekvatorialguineanskeste': ('ekvatorialguineansk',),
'ekvilibristisk': ('ekvilibristisk',),
'ekvilibristiske': ('ekvilibristisk',),
'ekvilibristiskere': ('ekvilibristisk',),
'ekvilibristiskest': ('ekvilibristisk',),
'ekvilibristiskeste': ('ekvilibristisk',),
'ekviperende': ('ekvipere',),
'ekvipert': ('ekvipere',),
'ekviperte': ('ekvipere',),
'ekvivalent': ('ekvivalent',),
'ekvivalente': ('ekvivalent',),
'ekvivalentere': ('ekvivalent',),
'ekvivalentest': ('ekvivalent',),
'ekvivalenteste': ('ekvivalent',),
'ekvivalerende': ('ekvivalere',),
'ekvivalert': ('ekvivalere',),
'ekvivalerte': ('ekvivalere',),
'elastisk': ('elastisk',),
'elastiske': ('elastisk',),
'elastiskere': ('elastisk',),
'elastiskest': ('elastisk',),
'elastiskeste': ('elastisk',),
'elda': ('elde',),
'eldede': ('elde',),
'eldende': ('elde',),
'eldet': ('elde',),
'eldete': ('elde',),
'elda': ('elde',),
'eldede': ('elde',),
'eldende': ('elde',),
'eldet': ('elde',),
'eldete': ('elde',),
'elda': ('elde',),
'eldede': ('elde',),
'eldende': ('elde',),
'eldet': ('elde',),
'eldete': ('elde',),
'eldfast': ('eldfast',),
'eldfaste': ('eldfast',),
'eldfastere': ('eldfast',),
'eldfastest': ('eldfast',),
'eldfasteste': ('eldfast',),
'eldfast': ('eldfast',),
'eldfaste': ('eldfast',),
'eldfastere': ('eldfast',),
'eldfastest': ('eldfast',),
'eldfasteste': ('eldfast',),
'eldfull': ('eldfull',),
'eldfulle': ('eldfull',),
'eldfullere': ('eldfull',),
'eldfullest': ('eldfull',),
'eldfulleste': ('eldfull',),
'eldfullt': ('eldfull',),
'eldfull': ('eldfull',),
'eldfulle': ('eldfull',),
'eldfullere': ('eldfull',),
'eldfullest': ('eldfull',),
'eldfulleste': ('eldfull',),
'eldfullt': ('eldfull',),
'eldeldre': ('eldgammel',),
'eldeldst': ('eldgammel',),
'eldeldste': ('eldgammel',),
'eldgamle': ('eldgammel',),
'eldgammel': ('eldgammel',),
'eldgammelt': ('eldgammel',),
'eldhuga': ('eldhuga',),
'eldre': ('eldre',),
'eldrød': ('eldrød',),
'eldrøde': ('eldrød',),
'eldrødere': ('eldrød',),
'eldrødest': ('eldrød',),
'eldrødeste': ('eldrød',),
'eldrødt': ('eldrød',),
'eldrød': ('eldrød',),
'eldrøde': ('eldrød',),
'eldrødere': ('eldrød',),
'eldrødest': ('eldrød',),
'eldrødeste': ('eldrød',),
'eldrødt': ('eldrød',),
'eldrød': ('eldrød',),
'eldrøde': ('eldrød',),
'eldrødere': ('eldrød',),
'eldrødest': ('eldrød',),
'eldrødeste': ('eldrød',),
'eldrødt': ('eldrød',),
'eldsfarlig': ('eldsfarlig',),
'eldsfarlige': ('eldsfarlig',),
'eldsfarligere': ('eldsfarlig',),
'eldsfarligst': ('eldsfarlig',),
'eldsfarligste': ('eldsfarlig',),
'eldsfarlig': ('eldsfarlig',),
'eldsfarlige': ('eldsfarlig',),
'eldsfarligere': ('eldsfarlig',),
'eldsfarligst': ('eldsfarlig',),
'eldsfarligste': ('eldsfarlig',),
'eldsikker': ('eldsikker',),
'eldsikkert': ('eldsikker',),
'eldsikre': ('eldsikker',),
'eldsikrere': ('eldsikker',),
'eldsikrest': ('eldsikker',),
'eldsikreste': ('eldsikker',),
'eldsikker': ('eldsikker',),
'eldsikkert': ('eldsikker',),
'eldsikre': ('eldsikker',),
'eldsikrere': ('eldsikker',),
'eldsikrest': ('eldsikker',),
'eldsikreste': ('eldsikker',),
'eldsprutende': ('eldsprutende',),
'eldsprutende': ('eldsprutende',),
'elegant': ('elegant',),
'elegante': ('elegant',),
'elegantere': ('elegant',),
'elegantest': ('elegant',),
'eleganteste': ('elegant',),
'elegisk': ('elegisk',),
'elegiske': ('elegisk',),
'elegiskere': ('elegisk',),
'elegiskest': ('elegisk',),
'elegiskeste': ('elegisk',),
'elektiv': ('elektiv',),
'elektive': ('elektiv',),
'elektivere': ('elektiv',),
'elektivest': ('elektiv',),
'elektiveste': ('elektiv',),
'elektivt': ('elektiv',),
'elektoral': ('elektoral',),
'elektorale': ('elektoral',),
'elektoralere': ('elektoral',),
'elektoralest': ('elektoral',),
'elektoraleste': ('elektoral',),
'elektoralt': ('elektoral',),
'elektrifiserende': ('elektrifisere',),
'elektrifisert': ('elektrifisere',),
'elektrifiserte': ('elektrifisere',),
'elektriserende': ('elektrisere',),
'elektrisert': ('elektrisere',),
'elektriserte': ('elektrisere',),
'elektrisk': ('elektrisk',),
'elektriske': ('elektrisk',),
'elektriskere': ('elektrisk',),
'elektriskest': ('elektrisk',),
'elektriskeste': ('elektrisk',),
'elektrokjemisk': ('elektrokjemisk',),
'elektrokjemiske': ('elektrokjemisk',),
'elektrokjemiskere': ('elektrokjemisk',),
'elektrokjemiskest': ('elektrokjemisk',),
'elektrokjemiskeste': ('elektrokjemisk',),
'elektrolytisk': ('elektrolytisk',),
'elektrolytiske': ('elektrolytisk',),
'elektrolytiskere': ('elektrolytisk',),
'elektrolytiskest': ('elektrolytisk',),
'elektrolytiskeste': ('elektrolytisk',),
'elektromagnetisk': ('elektromagnetisk',),
'elektromagnetiske': ('elektromagnetisk',),
'elektromagnetiskere': ('elektromagnetisk',),
'elektromagnetiskest': ('elektromagnetisk',),
'elektromagnetiskeste': ('elektromagnetisk',),
'elektrometallurgisk': ('elektrometallurgisk',),
'elektrometallurgiske': ('elektrometallurgisk',),
'elektrometallurgiskere': ('elektrometallurgisk',),
'elektrometallurgiskest': ('elektrometallurgisk',),
'elektrometallurgiskeste': ('elektrometallurgisk',),
'elektronisk': ('elektronisk',),
'elektroniske': ('elektronisk',),
'elektroniskere': ('elektronisk',),
'elektroniskest': ('elektronisk',),
'elektroniskeste': ('elektronisk',),
'elementær': ('elementær',),
'elementære': ('elementær',),
'elementærere': ('elementær',),
'elementærest': ('elementær',),
'elementæreste': ('elementær',),
'elementært': ('elementær',),
'elendig': ('elendig',),
'elendige': ('elendig',),
'elendigere': ('elendig',),
'elendigst': ('elendig',),
'elendigste': ('elendig',),
'eleverende': ('elevere',),
'elevert': ('elevere',),
'eleverte': ('elevere',),
'elevert': ('elevert',),
'eleverte': ('elevert',),
'elevertere': ('elevert',),
'elevertest': ('elevert',),
'eleverteste': ('elevert',),
'elgsblakk': ('elgsblakk',),
'elgsblakke': ('elgsblakk',),
'elgsblakkere': ('elgsblakk',),
'elgsblakkest': ('elgsblakk',),
'elgsblakkeste': ('elgsblakk',),
'elgsblakt': ('elgsblakk',),
'elgsgrå': ('elgsgrå',),
'elgsgråe': ('elgsgrå',),
'elgsgråere': ('elgsgrå',),
'elgsgråest': ('elgsgrå',),
'elgsgråeste': ('elgsgrå',),
'elgsgrått': ('elgsgrå',),
'eligerende': ('eligere',),
'eligert': ('eligere',),
'eligerte': ('eligere',),
'eliminerende': ('eliminere',),
'eliminert': ('eliminere',),
'eliminerte': ('eliminere',),
'ella': ('elle',),
'ellede': ('elle',),
'ellende': ('elle',),
'ellet': ('elle',),
'ellete': ('elle',),
'elleveårig': ('elleveårig',),
'elleveårige': ('elleveårig',),
'elleveårigere': ('elleveårig',),
'elleveårigst': ('elleveårig',),
'elleveårigste': ('elleveårig',),
'elleveårs': ('elleveårs',),
'ellevill': ('ellevill',),
'elleville': ('ellevill',),
'ellevillere': ('ellevill',),
'ellevillest': ('ellevill',),
'ellevilleste': ('ellevill',),
'ellevilt': ('ellevill',),
'ellevte': ('ellevte',),
'ellipseforma': ('ellipseforma',),
'ellipseformede': ('ellipseformet',),
'ellipseformet': ('ellipseformet',),
'ellipseformete': ('ellipseformet',),
'ellipseformetere': ('ellipseformet',),
'ellipseformetest': ('ellipseformet',),
'ellipseformeteste': ('ellipseformet',),
'elliptisk': ('elliptisk',),
'elliptiske': ('elliptisk',),
'elliptiskere': ('elliptisk',),
'elliptiskest': ('elliptisk',),
'elliptiskeste': ('elliptisk',),
'elokserende': ('eloksere',),
'eloksert': ('eloksere',),
'elokserte': ('eloksere',),
'elska': ('elske',),
'elskede': ('elske',),
'elskende': ('elske',),
'elsket': ('elske',),
'elskete': ('elske',),
'elskelig': ('elskelig',),
'elskelige': ('elskelig',),
'elskeligere': ('elskelig',),
'elskeligst': ('elskelig',),
'elskeligste': ('elskelig',),
'elskovsfull': ('elskovsfull',),
'elskovsfulle': ('elskovsfull',),
'elskovsfullere': ('elskovsfull',),
'elskovsfullest': ('elskovsfull',),
'elskovsfulleste': ('elskovsfull',),
'elskovsfullt': ('elskovsfull',),
'elskverdig': ('elskverdig',),
'elskverdige': ('elskverdig',),
'elskverdigere': ('elskverdig',),
'elskverdigst': ('elskverdig',),
'elskverdigste': ('elskverdig',),
'elta': ('elte',),
'eltede': ('elte',),
'eltende': ('elte',),
'eltet': ('elte',),
'eltete': ('elte',),
'eluderende': ('eludere',),
'eludert': ('eludere',),
'eluderte': ('eludere',),
'elyseisk': ('elyseisk',),
'elyseiske': ('elyseisk',),
'elyseiskere': ('elyseisk',),
'elyseiskest': ('elyseisk',),
'elyseiskeste': ('elyseisk',),
'elysisk': ('elysisk',),
'elysiske': ('elysisk',),
'elysiskere': ('elysisk',),
'elysiskest': ('elysisk',),
'elysiskeste': ('elysisk',),
'elzevirsk': ('elzevirsk',),
'elzevirske': ('elzevirsk',),
'elzevirskere': ('elzevirsk',),
'elzevirskest': ('elzevirsk',),
'elzevirskeste': ('elzevirsk',),
'emaljerende': ('emaljere',),
'emaljert': ('emaljere',),
'emaljerte': ('emaljere',),
'emansiperende': ('emansipere',),
'emansipert': ('emansipere',),
'emansiperte': ('emansipere',),
'emansipert': ('emansipert',),
'emansiperte': ('emansipert',),
'emansipertere': ('emansipert',),
'emansipertest': ('emansipert',),
'emansiperteste': ('emansipert',),
'emballerende': ('emballere',),
'emballert': ('emballere',),
'emballerte': ('emballere',),
'embarkerende': ('embarkere',),
'embarkert': ('embarkere',),
'embarkerte': ('embarkere',),
'emeriti': ('emeritus',),
'emeritus': ('emeritus',),
'emfatisk': ('emfatisk',),
'emfatiske': ('emfatisk',),
'emfatiskere': ('emfatisk',),
'emfatiskest': ('emfatisk',),
'emfatiskeste': ('emfatisk',),
'emigrerende': ('emigrere',),
'emigrert': ('emigrere',),
'emigrerte': ('emigrere',),
'eminent': ('eminent',),
'eminente': ('eminent',),
'eminentere': ('eminent',),
'eminentest': ('eminent',),
'eminenteste': ('eminent',),
'emitterende': ('emittere',),
'emittert': ('emittere',),
'emitterte': ('emittere',),
'emmen': ('emmen',),
'emment': ('emmen',),
'emne': ('emmen',),
'emnere': ('emmen',),
'emnest': ('emmen',),
'emneste': ('emmen',),
'emna': ('emne',),
'emnede': ('emne',),
'emnende': ('emne',),
'emnet': ('emne',),
'emnete': ('emne',),
'emnelig': ('emnelig',),
'emnelige': ('emnelig',),
'emneligere': ('emnelig',),
'emneligst': ('emnelig',),
'emneligste': ('emnelig',),
'emosjonell': ('emosjonell',),
'emosjonelle': ('emosjonell',),
'emosjonellere': ('emosjonell',),
'emosjonellest': ('emosjonell',),
'emosjonelleste': ('emosjonell',),
'emosjonelt': ('emosjonell',),
'emotiv': ('emotiv',),
'emotive': ('emotiv',),
'emotivere': ('emotiv',),
'emotivest': ('emotiv',),
'emotiveste': ('emotiv',),
'emotivt': ('emotiv',),
'empirisk': ('empirisk',),
'empiriske': ('empirisk',),
'empiriskere': ('empirisk',),
'empiriskest': ('empirisk',),
'empiriskeste': ('empirisk',),
'employerende': ('employere',),
'employert': ('employere',),
'employerte': ('employere',),
'emulgerende': ('emulgere',),
'emulgert': ('emulgere',),
'emulgerte': ('emulgere',),
'en vogue': ('en vogue',),
'enarma': ('enarma',),
'enarmede': ('enarmet',),
'enarmet': ('enarmet',),
'enarmete': ('enarmet',),
'enarmetere': ('enarmet',),
'enarmetest': ('enarmet',),
'enarmeteste': ('enarmet',),
'enatomig': ('enatomig',),
'enatomige': ('enatomig',),
'enatomigere': ('enatomig',),
'enatomigst': ('enatomig',),
'enatomigste': ('enatomig',),
'enbo': ('enbo',),
'enbu': ('enbu',),
'enbåren': ('enbåren',),
'enbårent': ('enbåren',),
'enbårne': ('enbåren',),
'enbårnere': ('enbåren',),
'enbårnest': ('enbåren',),
'enbårneste': ('enbåren',),
'encella': ('encella',),
'encellede': ('encellet',),
'encellet': ('encellet',),
'encellete': ('encellet',),
'encelletere': ('encellet',),
'encelletest': ('encellet',),
'encelleteste': ('encellet',),
'encyklisk': ('encyklisk',),
'encykliske': ('encyklisk',),
'encykliskere': ('encyklisk',),
'encykliskest': ('encyklisk',),
'encykliskeste': ('encyklisk',),
'encyklopedisk': ('encyklopedisk',),
'encyklopediske': ('encyklopedisk',),
'encyklopediskere': ('encyklopedisk',),
'encyklopediskest': ('encyklopedisk',),
'encyklopediskeste': ('encyklopedisk',),
'endende': ('ende',),
'endt': ('ende',),
'endte': ('ende',),
'endefram': ('endefram',),
'endeframme': ('endefram',),
'endeframmere': ('endefram',),
'endeframmest': ('endefram',),
'endeframmeste': ('endefram',),
'endeframt': ('endefram',),
'endefrem': ('endefrem',),
'endefremme': ('endefrem',),
'endefremmere': ('endefrem',),
'endefremmest': ('endefrem',),
'endefremmeste': ('endefrem',),
'endefremt': ('endefrem',),
'endegyldig': ('endegyldig',),
'endegyldige': ('endegyldig',),
'endegyldigere': ('endegyldig',),
'endegyldigst': ('endegyldig',),
'endegyldigste': ('endegyldig',),
'endelaus': ('endelaus',),
'endelause': ('endelaus',),
'endelausere': ('endelaus',),
'endelausest': ('endelaus',),
'endelauseste': ('endelaus',),
'endelaust': ('endelaus',),
'endelig': ('endelig',),
'endelige': ('endelig',),
'endeligere': ('endelig',),
'endeligst': ('endelig',),
'endeligste': ('endelig',),
'endeløs': ('endeløs',),
'endeløse': ('endeløs',),
'endeløsere': ('endeløs',),
'endeløsest': ('endeløs',),
'endeløseste': ('endeløs',),
'endeløst': ('endeløs',),
'endemisk': ('endemisk',),
'endemiske': ('endemisk',),
'endemiskere': ('endemisk',),
'endemiskest': ('endemisk',),
'endemiskeste': ('endemisk',),
'endetil': ('endetil',),
'endevendende': ('endevende',),
'endevendt': ('endevende',),
'endevendte': ('endevende',),
'endimensjonal': ('endimensjonal',),
'endimensjonale': ('endimensjonal',),
'endimensjonalere': ('endimensjonal',),
'endimensjonalest': ('endimensjonal',),
'endimensjonaleste': ('endimensjonal',),
'endimensjonalt': ('endimensjonal',),
'endogen': ('endogen',),
'endogene': ('endogen',),
'endogenere': ('endogen',),
'endogenest': ('endogen',),
'endogeneste': ('endogen',),
'endogent': ('endogen',),
'endokrin': ('endokrin',),
'endokrine': ('endokrin',),
'endokrinere': ('endokrin',),
'endokrinest': ('endokrin',),
'endokrineste': ('endokrin',),
'endokrint': ('endokrin',),
'endosserende': ('endossere',),
'endossert': ('endossere',),
'endosserte': ('endossere',),
'endoterm': ('endoterm',),
'endoterme': ('endoterm',),
'endotermere': ('endoterm',),
'endotermest': ('endoterm',),
'endotermeste': ('endoterm',),
'endotermt': ('endoterm',),
'endra': ('endre',),
'endrede': ('endre',),
'endrende': ('endre',),
'endret': ('endre',),
'endrete': ('endre',),
'enende': ('ene',),
'ent': ('ene',),
'ente': ('ene',),
'eneberettiga': ('eneberettiga',),
'eneberettigede': ('eneberettiget',),
'eneberettiget': ('eneberettiget',),
'eneberettigete': ('eneberettiget',),
'eneberettigetere': ('eneberettiget',),
'eneberettigetest': ('eneberettiget',),
'eneberettigeteste': ('eneberettiget',),
'eneherskende': ('eneherskende',),
'energetisk': ('energetisk',),
'energetiske': ('energetisk',),
'energetiskere': ('energetisk',),
'energetiskest': ('energetisk',),
'energetiskeste': ('energetisk',),
'energisk': ('energisk',),
'energiske': ('energisk',),
'energiskere': ('energisk',),
'energiskest': ('energisk',),
'energiskeste': ('energisk',),
'enerverende': ('enervere',),
'enervert': ('enervere',),
'enerverte': ('enervere',),
'enerverende': ('enerverende',),
'enerådende': ('enerådende',),
'enerådig': ('enerådig',),
'enerådige': ('enerådig',),
'enerådigere': ('enerådig',),
'enerådigst': ('enerådig',),
'enerådigste': ('enerådig',),
'enestående': ('enestående',),
'enetasjes': ('enetasjes',),
'eneveldig': ('eneveldig',),
'eneveldige': ('eneveldig',),
'eneveldigere': ('eneveldig',),
'eneveldigst': ('eneveldig',),
'eneveldigste': ('eneveldig',),
'enfasa': ('enfasa',),
'enfasede': ('enfaset',),
'enfaset': ('enfaset',),
'enfasete': ('enfaset',),
'enfasetere': ('enfaset',),
'enfasetest': ('enfaset',),
'enfaseteste': ('enfaset',),
'enfoldig': ('enfoldig',),
'enfoldige': ('enfoldig',),
'enfoldigere': ('enfoldig',),
'enfoldigst': ('enfoldig',),
'enfoldigste': ('enfoldig',),
'enfrøblada': ('enfrøblada',),
'enfrøbladede': ('enfrøbladet',),
'enfrøbladet': ('enfrøbladet',),
'enfrøbladete': ('enfrøbladet',),
'enfrøbladetere': ('enfrøbladet',),
'enfrøbladetest': ('enfrøbladet',),
'enfrøbladeteste': ('enfrøbladet',),
'eng': ('eng',),
'enge': ('eng',),
'engere': ('eng',),
'engest': ('eng',),
'engeste': ('eng',),
'engt': ('eng',),
'engangs': ('engangs',),
'engasjerende': ('engasjere',),
'engasjert': ('engasjere',),
'engasjerte': ('engasjere',),
'engelsk': ('engelsk',),
'engelske': ('engelsk',),
'engelskere': ('engelsk',),
'engelskest': ('engelsk',),
'engelskeste': ('engelsk',),
'engelsk-norsk': ('engelsk-norsk',),
'engelsk-norske': ('engelsk-norsk',),
'engelsk-norskere': ('engelsk-norsk',),
'engelsk-norskest': ('engelsk-norsk',),
'engelsk-norskeste': ('engelsk-norsk',),
'engelskspråklig': ('engelskspråklig',),
'engelskspråklige': ('engelskspråklig',),
'engelskspråkligere': ('engelskspråklig',),
'engelskspråkligst': ('engelskspråklig',),
'engelskspråkligste': ('engelskspråklig',),
'engelsktalende': ('engelsktalende',),
'engleaktig': ('engleaktig',),
'engleaktige': ('engleaktig',),
'engleaktigere': ('engleaktig',),
'engleaktigst': ('engleaktig',),
'engleaktigste': ('engleaktig',),
'engsta': ('engste',),
'engstede': ('engste',),
'engstende': ('engste',),
'engstet': ('engste',),
'engstete': ('engste',),
'engstelig': ('engstelig',),
'engstelige': ('engstelig',),
'engsteligere': ('engstelig',),
'engsteligst': ('engstelig',),
'engsteligste': ('engstelig',),
'enhetlig': ('enhetlig',),
'enhetlige': ('enhetlig',),
'enhetligere': ('enhetlig',),
'enhetligst': ('enhetlig',),
'enhetligste': ('enhetlig',),
'enhånds': ('enhånds',),
'enig': ('enig',),
'enige': ('enig',),
'enigere': ('enig',),
'enigst': ('enig',),
'enigste': ('enig',),
'enigmatisk': ('enigmatisk',),
'enigmatiske': ('enigmatisk',),
'enigmatiskere': ('enigmatisk',),
'enigmatiskest': ('enigmatisk',),
'enigmatiskeste': ('enigmatisk',),
'enkel': ('enkel',),
'enkelt': ('enkel',),
'enkle': ('enkel',),
'enklere': ('enkel',),
'enklest': ('enkel',),
'enkleste': ('enkel',),
'enkelt': ('enkelt',),
'enkelte': ('enkelt',),
'enkeltere': ('enkelt',),
'enkeltest': ('enkelt',),
'enkelteste': ('enkelt',),
'enkeltknappa': ('enkeltknappa',),
'enkeltknappede': ('enkeltknappet',),
'enkeltknappet': ('enkeltknappet',),
'enkeltknappete': ('enkeltknappet',),
'enkeltknappetere': ('enkeltknappet',),
'enkeltknappetest': ('enkeltknappet',),
'enkeltknappeteste': ('enkeltknappet',),
'enkeltløpa': ('enkeltløpa',),
'enkeltløpede': ('enkeltløpet',),
'enkeltløpet': ('enkeltløpet',),
'enkeltløpete': ('enkeltløpet',),
'enkeltløpetere': ('enkeltløpet',),
'enkeltløpetest': ('enkeltløpet',),
'enkeltløpeteste': ('enkeltløpet',),
'enkeltspent': ('enkeltspent',),
'enkeltspente': ('enkeltspent',),
'enkeltspentere': ('enkeltspent',),
'enkeltspentest': ('enkeltspent',),
'enkeltspenteste': ('enkeltspent',),
'enkeltspora': ('enkeltspora',),
'enkeltsporede': ('enkeltsporet',),
'enkeltsporet': ('enkeltsporet',),
'enkeltsporete': ('enkeltsporet',),
'enkeltsporetere': ('enkeltsporet',),
'enkeltsporetest': ('enkeltsporet',),
'enkeltsporeteste': ('enkeltsporet',),
'enkeltstående': ('enkeltstående',),
'enkjønna': ('enkjønna',),
'enkjønnede': ('enkjønnet',),
'enkjønnet': ('enkjønnet',),
'enkjønnete': ('enkjønnet',),
'enkjønnetere': ('enkjønnet',),
'enkjønnetest': ('enkjønnet',),
'enkjønneteste': ('enkjønnet',),
'enklitisk': ('enklitisk',),
'enklitiske': ('enklitisk',),
'enklitiskere': ('enklitisk',),
'enklitiskest': ('enklitisk',),
'enklitiskeste': ('enklitisk',),
'enmanns': ('enmanns',),
'enmannsbetjent': ('enmannsbetjent',),
'enmannsbetjente': ('enmannsbetjent',),
'enmannsbetjentere': ('enmannsbetjent',),
'enmannsbetjentest': ('enmannsbetjent',),
'enmannsbetjenteste': ('enmannsbetjent',),
'enmotors': ('enmotors',),
'enorm': ('enorm',),
'enorme': ('enorm',),
'enormere': ('enorm',),
'enormest': ('enorm',),
'enormeste': ('enorm',),
'enormt': ('enorm',),
'enpukla': ('enpukla',),
'enpuklede': ('enpuklet',),
'enpuklet': ('enpuklet',),
'enpuklete': ('enpuklet',),
'enpukletere': ('enpuklet',),
'enpukletest': ('enpuklet',),
'enpukleteste': ('enpuklet',),
'ens': ('ens',),
'ensarta': ('ensarta',),
'ensartede': ('ensartet',),
'ensartet': ('ensartet',),
'ensartete': ('ensartet',),
'ensartetere': ('ensartet',),
'ensartetest': ('ensartet',),
'ensarteteste': ('ensartet',),
'ensbetydende': ('ensbetydende',),
'ensa': ('ense',),
'ensede': ('ense',),
'ensende': ('ense',),
'enset': ('ense',),
'ensete': ('ense',),
'enst': ('ense',),
'enste': ('ense',),
'ensfarga': ('ensfarga',),
'ensfargede': ('ensfarget',),
'ensfarget': ('ensfarget',),
'ensfargete': ('ensfarget',),
'ensfargetere': ('ensfarget',),
'ensfargetest': ('ensfarget',),
'ensfargeteste': ('ensfarget',),
'ensforma': ('ensforma',),
'ensformede': ('ensformet',),
'ensformet': ('ensformet',),
'ensformete': ('ensformet',),
'ensformetere': ('ensformet',),
'ensformetest': ('ensformet',),
'ensformeteste': ('ensformet',),
'ensformig': ('ensformig',),
'ensformige': ('ensformig',),
'ensformigere': ('ensformig',),
'ensformigst': ('ensformig',),
'ensformigste': ('ensformig',),
'ensidig': ('ensidig',),
'ensidige': ('ensidig',),
'ensidigere': ('ensidig',),
'ensidigst': ('ensidig',),
'ensidigste': ('ensidig',),
'ensifra': ('ensifra',),
'ensifrede': ('ensifret',),
'ensifret': ('ensifret',),
'ensifrete': ('ensifret',),
'ensifretere': ('ensifret',),
'ensifretest': ('ensifret',),
'ensifreteste': ('ensifret',),
'ensilerende': ('ensilere',),
'ensilert': ('ensilere',),
'ensilerte': ('ensilere',),
'enskafta': ('enskafta',),
'enskaftede': ('enskaftet',),
'enskaftet': ('enskaftet',),
'enskaftete': ('enskaftet',),
'enskaftetere': ('enskaftet',),
'enskaftetest': ('enskaftet',),
'enskafteteste': ('enskaftet',),
'enskjærs': ('enskjærs',),
'enslig': ('enslig',),
'enslige': ('enslig',),
'ensligere': ('enslig',),
'ensligst': ('enslig',),
'ensligste': ('enslig',),
'ensligstilt': ('ensligstilt',),
'ensligstilte': ('ensligstilt',),
'ensligstiltere': ('ensligstilt',),
'ensligstiltest': ('ensligstilt',),
'ensligstilteste': ('ensligstilt',),
'enslydende': ('enslydende',),
'ensom': ('ensom',),
'ensomme': ('ensom',),
'ensommere': ('ensom',),
'ensomst': ('ensom',),
'ensomste': ('ensom',),
'ensomt': ('ensom',),
'enspora': ('enspora',),
'ensporede': ('ensporet',),
'ensporet': ('ensporet',),
'ensporete': ('ensporet',),
'ensporetere': ('ensporet',),
'ensporetest': ('ensporet',),
'ensporeteste': ('ensporet',),
'enspråklig': ('enspråklig',),
'enspråklige': ('enspråklig',),
'enspråkligere': ('enspråklig',),
'enspråkligst': ('enspråklig',),
'enspråkligste': ('enspråklig',),
'ensretta': ('ensrette',),
'ensrettede': ('ensrette',),
'ensrettende': ('ensrette',),
'ensrettet': ('ensrette',),
'ensrettete': ('ensrette',),
'enstava': ('enstava',),
'enstavede': ('enstavet',),
'enstavet': ('enstavet',),
'enstavete': ('enstavet',),
'enstavetere': ('enstavet',),
'enstavetest': ('enstavet',),
'enstaveteste': ('enstavet',),
'enstemmig': ('enstemmig',),
'enstemmige': ('enstemmig',),
'enstemmigere': ('enstemmig',),
'enstemmigst': ('enstemmig',),
'enstemmigste': ('enstemmig',),
'enstonig': ('enstonig',),
'enstonige': ('enstonig',),
'enstonigere': ('enstonig',),
'enstonigst': ('enstonig',),
'enstonigste': ('enstonig',),
'enstrøken': ('enstrøken',),
'enstrøket': ('enstrøken',),
'enstrøkne': ('enstrøken',),
'enstrøknere': ('enstrøken',),
'enstrøknest': ('enstrøken',),
'enstrøkneste': ('enstrøken',),
'enstrøket': ('enstrøket',),
'enstrøkne': ('enstrøket',),
'enstrøknere': ('enstrøket',),
'enstrøknest': ('enstrøket',),
'enstrøkneste': ('enstrøket',),
'enstydig': ('enstydig',),
'enstydige': ('enstydig',),
'enstydigere': ('enstydig',),
'enstydigst': ('enstydig',),
'enstydigste': ('enstydig',),
'ente': ('ente',),
'entoms': ('entoms',),
'entra': ('entre',),
'entrede': ('entre',),
'entrende': ('entre',),
'entret': ('entre',),
'entrete': ('entre',),
'entreprenant': ('entreprenant',),
'entreprenante': ('entreprenant',),
'entreprenantere': ('entreprenant',),
'entreprenantest': ('entreprenant',),
'entreprenanteste': ('entreprenant',),
'entusiastisk': ('entusiastisk',),
'entusiastiske': ('entusiastisk',),
'entusiastiskere': ('entusiastisk',),
'entusiastiskest': ('entusiastisk',),
'entusiastiskeste': ('entusiastisk',),
'entydig': ('entydig',),
'entydige': ('entydig',),
'entydigere': ('entydig',),
'entydigst': ('entydig',),
'entydigste': ('entydig',),
'envegsregulerende': ('envegsregulere',),
'envegsregulert': ('envegsregulere',),
'envegsregulerte': ('envegsregulere',),
'enveisregulerende': ('enveisregulere',),
'enveisregulert': ('enveisregulere',),
'enveisregulerte': ('enveisregulere',),
'enverdig': ('enverdig',),
'enverdige': ('enverdig',),
'enverdigere': ('enverdig',),
'enverdigst': ('enverdig',),
'enverdigste': ('enverdig',),
'envis': ('envis',),
'envise': ('envis',),
'envisere': ('envis',),
'envisest': ('envis',),
'enviseste': ('envis',),
'envist': ('envis',),
'enzymatisk': ('enzymatisk',),
'enzymatiske': ('enzymatisk',),
'enzymatiskere': ('enzymatisk',),
'enzymatiskest': ('enzymatisk',),
'enzymatiskeste': ('enzymatisk',),
'enøres': ('enøres',),
'enøyd': ('enøyd',),
'enøyde': ('enøyd',),
'enøydere': ('enøyd',),
'enøydest': ('enøyd',),
'enøydeste': ('enøyd',),
'epidemisk': ('epidemisk',),
'epidemiske': ('epidemisk',),
'epidemiskere': ('epidemisk',),
'epidemiskest': ('epidemisk',),
'epidemiskeste': ('epidemisk',),
'epidural': ('epidural',),
'epidurale': ('epidural',),
'epiduralere': ('epidural',),
'epiduralest': ('epidural',),
'epiduraleste': ('epidural',),
'epiduralt': ('epidural',),
'epikureisk': ('epikureisk',),
'epikureiske': ('epikureisk',),
'epikureiskere': ('epikureisk',),
'epikureiskest': ('epikureisk',),
'epikureiskeste': ('epikureisk',),
'epileptisk': ('epileptisk',),
'epileptiske': ('epileptisk',),
'epileptiskere': ('epileptisk',),
'epileptiskest': ('epileptisk',),
'epileptiskeste': ('epileptisk',),
'episk': ('episk',),
'episke': ('episk',),
'episkere': ('episk',),
'episkest': ('episk',),
'episkeste': ('episk',),
'episkopal': ('episkopal',),
'episkopale': ('episkopal',),
'episkopalere': ('episkopal',),
'episkopalest': ('episkopal',),
'episkopaleste': ('episkopal',),
'episkopalt': ('episkopal',),
'episodisk': ('episodisk',),
'episodiske': ('episodisk',),
'episodiskere': ('episodisk',),
'episodiskest': ('episodisk',),
'episodiskeste': ('episodisk',),
'epistemisk': ('epistemisk',),
'epistemiske': ('epistemisk',),
'epistemiskere': ('epistemisk',),
'epistemiskest': ('epistemisk',),
'epistemiskeste': ('epistemisk',),
'epistemologisk': ('epistemologisk',),
'epistemologiske': ('epistemologisk',),
'epistemologiskere': ('epistemologisk',),
'epistemologiskest': ('epistemologisk',),
'epistemologiskeste': ('epistemologisk',),
'epokegjørende': ('epokegjørende',),
'erfarende': ('erfare',),
'erfart': ('erfare',),
'erfarte': ('erfare',),
'erfaren': ('erfaren',),
'erfarent': ('erfaren',),
'erfarne': ('erfaren',),
'erfarnere': ('erfaren',),
'erfarnest': ('erfaren',),
'erfarneste': ('erfaren',),
'erfaringsmessig': ('erfaringsmessig',),
'erfaringsmessige': ('erfaringsmessig',),
'erfaringsmessigere': ('erfaringsmessig',),
'erfaringsmessigst': ('erfaringsmessig',),
'erfaringsmessigste': ('erfaringsmessig',),
'ergerlig': ('ergerlig',),
'ergerlige': ('ergerlig',),
'ergerligere': ('ergerlig',),
'ergerligst': ('ergerlig',),
'ergerligste': ('ergerlig',),
'ergra': ('ergre',),
'ergrede': ('ergre',),
'ergrende': ('ergre',),
'ergret': ('ergre',),
'ergrete': ('ergre',),
'erholdende': ('erholde',),
'erholdt': ('erholde',),
'erholdte': ('erholde',),
'erigerende': ('erigere',),
'erigert': ('erigere',),
'erigerte': ('erigere',),
'erindra': ('erindre',),
'erindrede': ('erindre',),
'erindrende': ('erindre',),
'erindret': ('erindre',),
'erindrete': ('erindre',),
'eritreisk': ('eritreisk',),
'eritreiske': ('eritreisk',),
'eritreiskere': ('eritreisk',),
'eritreiskest': ('eritreisk',),
'eritreiskeste': ('eritreisk',),
'erkekonservativ': ('erkekonservativ',),
'erkekonservative': ('erkekonservativ',),
'erkekonservativere': ('erkekonservativ',),
'erkekonservativest': ('erkekonservativ',),
'erkekonservativeste': ('erkekonservativ',),
'erkekonservativt': ('erkekonservativ',),
'erkjennende': ('erkjenne',),
'erkjent': ('erkjenne',),
'erkjente': ('erkjenne',),
'erklærende': ('erklære',),
'erklært': ('erklære',),
'erklærte': ('erklære',),
'erklært': ('erklært',),
'erklærte': ('erklært',),
'erklærtere': ('erklært',),
'erklærtest': ('erklært',),
'erklærteste': ('erklært',),
'erlagt': ('erlegge',),
'erlagte': ('erlegge',),
'erleggende': ('erlegge',),
'ernærende': ('ernære',),
'ernært': ('ernære',),
'ernærte': ('ernære',),
'erobra': ('erobre',),
'erobrede': ('erobre',),
'erobrende': ('erobre',),
'erobret': ('erobre',),
'erobrete': ('erobre',),
'eroderende': ('erodere',),
'erodert': ('erodere',),
'eroderte': ('erodere',),
'erogen': ('erogen',),
'erogene': ('erogen',),
'erogenere': ('erogen',),
'erogenest': ('erogen',),
'erogeneste': ('erogen',),
'erogent': ('erogen',),
'erotiserende': ('erotisere',),
'erotisert': ('erotisere',),
'erotiserte': ('erotisere',),
'erotisk': ('erotisk',),
'erotiske': ('erotisk',),
'erotiskere': ('erotisk',),
'erotiskest': ('erotisk',),
'erotiskeste': ('erotisk',),
'erotoman': ('erotoman',),
'erotomane': ('erotoman',),
'erotomanere': ('erotoman',),
'erotomanest': ('erotoman',),
'erotomaneste': ('erotoman',),
'erotomant': ('erotoman',),
'erstatta': ('erstatte',),
'erstattede': ('erstatte',),
'erstattende': ('erstatte',),
'erstattet': ('erstatte',),
'erstattete': ('erstatte',),
'erstattelig': ('erstattelig',),
'erstattelige': ('erstattelig',),
'erstatteligere': ('erstattelig',),
'erstatteligst': ('erstattelig',),
'erstatteligste': ('erstattelig',),
'erta': ('erte',),
'ertede': ('erte',),
'ertende': ('erte',),
'ertet': ('erte',),
'ertete': ('erte',),
'erteblomstra': ('erteblomstra',),
'erteblomstrede': ('erteblomstret',),
'erteblomstret': ('erteblomstret',),
'erteblomstrete': ('erteblomstret',),
'erteblomstretere': ('erteblomstret',),
'erteblomstretest': ('erteblomstret',),
'erteblomstreteste': ('erteblomstret',),
'erten': ('erten',),
'ertent': ('erten',),
'ertne': ('erten',),
'ertnere': ('erten',),
'ertnest': ('erten',),
'ertneste': ('erten',),
'ertet': ('ertet',),
'ertete': ('ertet',),
'ertetere': ('ertet',),
'ertetest': ('ertet',),
'erteteste': ('ertet',),
'ertete': ('ertete',),
'eruptiv': ('eruptiv',),
'eruptive': ('eruptiv',),
'eruptivere': ('eruptiv',),
'eruptivest': ('eruptiv',),
'eruptiveste': ('eruptiv',),
'eruptivt': ('eruptiv',),
'erverva': ('erverve',),
'ervervede': ('erverve',),
'ervervende': ('erverve',),
'ervervet': ('erverve',),
'ervervete': ('erverve',),
'ervervsdyktig': ('ervervsdyktig',),
'ervervsdyktige': ('ervervsdyktig',),
'ervervsdyktigere': ('ervervsdyktig',),
'ervervsdyktigst': ('ervervsdyktig',),
'ervervsdyktigste': ('ervervsdyktig',),
'ervervslaus': ('ervervslaus',),
'ervervslause': ('ervervslaus',),
'ervervslausere': ('ervervslaus',),
'ervervslausest': ('ervervslaus',),
'ervervslauseste': ('ervervslaus',),
'ervervslaust': ('ervervslaus',),
'ervervsløs': ('ervervsløs',),
'ervervsløse': ('ervervsløs',),
'ervervsløsere': ('ervervsløs',),
'ervervsløsest': ('ervervsløs',),
'ervervsløseste': ('ervervsløs',),
'ervervsløst': ('ervervsløs',),
'ervervsmessig': ('ervervsmessig',),
'ervervsmessige': ('ervervsmessig',),
'ervervsmessigere': ('ervervsmessig',),
'ervervsmessigst': ('ervervsmessig',),
'ervervsmessigste': ('ervervsmessig',),
'esende': ('ese',),
'est': ('ese',),
'este': ('ese',),
'eskalerende': ('eskalere',),
'eskalert': ('eskalere',),
'eskalerte': ('eskalere',),
'eskamoterende': ('eskamotere',),
'eskamotert': ('eskamotere',),
'eskamoterte': ('eskamotere',),
'eskaperende': ('eskapere',),
'eskapert': ('eskapere',),
'eskaperte': ('eskapere',),
'eskapistisk': ('eskapistisk',),
'eskapistiske': ('eskapistisk',),
'eskapistiskere': ('eskapistisk',),
'eskapistiskest': ('eskapistisk',),
'eskapistiskeste': ('eskapistisk',),
'eskatologisk': ('eskatologisk',),
'eskatologiske': ('eskatologisk',),
'eskatologiskere': ('eskatologisk',),
'eskatologiskest': ('eskatologisk',),
'eskatologiskeste': ('eskatologisk',),
'eska': ('eske',),
'eskede': ('eske',),
'eskende': ('eske',),
'esket': ('eske',),
'eskete': ('eske',),
'eskimoisk': ('eskimoisk',),
'eskimoiske': ('eskimoisk',),
'eskimoiskere': ('eskimoisk',),
'eskimoiskest': ('eskimoisk',),
'eskimoiskeste': ('eskimoisk',),
'eskimoisk-aleutisk': ('eskimoisk-aleutisk',),
'eskimoisk-aleutiske': ('eskimoisk-aleutisk',),
'eskimoisk-aleutiskere': ('eskimoisk-aleutisk',),
'eskimoisk-aleutiskest': ('eskimoisk-aleutisk',),
'eskimoisk-aleutiskeste': ('eskimoisk-aleutisk',),
'eskorterende': ('eskortere',),
'eskortert': ('eskortere',),
'eskorterte': ('eskortere',),
'esla': ('esle',),
'eslede': ('esle',),
'eslende': ('esle',),
'eslet': ('esle',),
'eslete': ('esle',),
'esoterisk': ('esoterisk',),
'esoteriske': ('esoterisk',),
'esoteriskere': ('esoterisk',),
'esoteriskest': ('esoterisk',),
'esoteriskeste': ('esoterisk',),
'essensiell': ('essensiell',),
'essensielle': ('essensiell',),
'essensiellere': ('essensiell',),
'essensiellest': ('essensiell',),
'essensielleste': ('essensiell',),
'essensielt': ('essensiell',),
'estetiserende': ('estetisere',),
'estetisert': ('estetisere',),
'estetiserte': ('estetisere',),
'estetisk': ('estetisk',),
'estetiske': ('estetisk',),
'estetiskere': ('estetisk',),
'estetiskest': ('estetisk',),
'estetiskeste': ('estetisk',),
'estimerende': ('estimere',),
'estimert': ('estimere',),
'estimerte': ('estimere',),
'estisk': ('estisk',),
'estiske': ('estisk',),
'estiskere': ('estisk',),
'estiskest': ('estisk',),
'estiskeste': ('estisk',),
'estlandsk': ('estlandsk',),
'estlandske': ('estlandsk',),
'estlandskere': ('estlandsk',),
'estlandskest': ('estlandsk',),
'estlandskeste': ('estlandsk',),
'etablerende': ('etablere',),
'etablert': ('etablere',),
'etablerte': ('etablere',),
'etablert': ('etablert',),
'etablerte': ('etablert',),
'etablertere': ('etablert',),
'etablertest': ('etablert',),
'etablerteste': ('etablert',),
'etende': ('ete',),
'ett': ('ete',),
'ette': ('ete',),
'eterisk': ('eterisk',),
'eteriske': ('eterisk',),
'eteriskere': ('eterisk',),
'eteriskest': ('eterisk',),
'eteriskeste': ('eterisk',),
'etiketterende': ('etikettere',),
'etikettert': ('etikettere',),
'etiketterte': ('etikettere',),
'etiopisk': ('etiopisk',),
'etiopiske': ('etiopisk',),
'etiopiskere': ('etiopisk',),
'etiopiskest': ('etiopisk',),
'etiopiskeste': ('etiopisk',),
'etisk': ('etisk',),
'etiske': ('etisk',),
'etiskere': ('etisk',),
'etiskest': ('etisk',),
'etiskeste': ('etisk',),
'etla': ('etle',),
'etlede': ('etle',),
'etlende': ('etle',),
'etlet': ('etle',),
'etlete': ('etle',),
'etnisk': ('etnisk',),
'etniske': ('etnisk',),
'etniskere': ('etnisk',),
'etniskest': ('etnisk',),
'etniskeste': ('etnisk',),
'etnografisk': ('etnografisk',),
'etnografiske': ('etnografisk',),
'etnografiskere': ('etnografisk',),
'etnografiskest': ('etnografisk',),
'etnografiskeste': ('etnografisk',),
'etnologisk': ('etnologisk',),
'etnologiske': ('etnologisk',),
'etnologiskere': ('etnologisk',),
'etnologiskest': ('etnologisk',),
'etnologiskeste': ('etnologisk',),
'etnosentrisk': ('etnosentrisk',),
'etnosentriske': ('etnosentrisk',),
'etnosentriskere': ('etnosentrisk',),
'etnosentriskest': ('etnosentrisk',),
'etnosentriskeste': ('etnosentrisk',),
'etologisk': ('etologisk',),
'etologiske': ('etologisk',),
'etologiskere': ('etologisk',),
'etologiskest': ('etologisk',),
'etologiskeste': ('etologisk',),
'etrurisk': ('etrurisk',),
'etruriske': ('etrurisk',),
'etruriskere': ('etrurisk',),
'etruriskest': ('etrurisk',),
'etruriskeste': ('etrurisk',),
'etruskisk': ('etruskisk',),
'etruskiske': ('etruskisk',),
'etruskiskere': ('etruskisk',),
'etruskiskest': ('etruskisk',),
'etruskiskeste': ('etruskisk',),
'etsa': ('etse',),
'etsede': ('etse',),
'etsende': ('etse',),
'etset': ('etse',),
'etsete': ('etse',),
'etteranmeldende': ('etteranmelde',),
'etteranmeldt': ('etteranmelde',),
'etteranmeldte': ('etteranmelde',),
'etterapa': ('etterape',),
'etterapede': ('etterape',),
'etterapende': ('etterape',),
'etterapet': ('etterape',),
'etterapete': ('etterape',),
'etterapt': ('etterape',),
'etterapte': ('etterape',),
'etterbehandla': ('etterbehandle',),
'etterbehandlede': ('etterbehandle',),
'etterbehandlende': ('etterbehandle',),
'etterbehandlet': ('etterbehandle',),
'etterbehandlete': ('etterbehandle',),
'etterbetalende': ('etterbetale',),
'etterbetalt': ('etterbetale',),
'etterbetalte': ('etterbetale',),
'etterforska': ('etterforske',),
'etterforskede': ('etterforske',),
'etterforskende': ('etterforske',),
'etterforsket': ('etterforske',),
'etterforskete': ('etterforske',),
'etterfyllende': ('etterfylle',),
'etterfylt': ('etterfylle',),
'etterfylte': ('etterfylle',),
'ettergiende': ('ettergi',),
'ettergitt': ('ettergi',),
'ettergitte': ('ettergi',),
'ettergivende': ('ettergi',),
'ettergiven': ('ettergiven',),
'ettergivent': ('ettergiven',),
'ettergivne': ('ettergiven',),
'ettergivnere': ('ettergiven',),
'ettergivnest': ('ettergiven',),
'ettergivneste': ('ettergiven',),
'ettergivende': ('ettergivende',),
'ettergjort': ('ettergjøre',),
'ettergjorte': ('ettergjøre',),
'ettergjørende': ('ettergjøre',),
'ettergymnasial': ('ettergymnasial',),
'ettergymnasiale': ('ettergymnasial',),
'ettergymnasialere': ('ettergymnasial',),
'ettergymnasialest': ('ettergymnasial',),
'ettergymnasialeste': ('ettergymnasial',),
'ettergymnasialt': ('ettergymnasial',),
'etterhengt': ('etterhengt',),
'etterhengte': ('etterhengt',),
'etterhengtere': ('etterhengt',),
'etterhengtest': ('etterhengt',),
'etterhengteste': ('etterhengt',),
'etterisolerende': ('etterisolere',),
'etterisolert': ('etterisolere',),
'etterisolerte': ('etterisolere',),
'etterklok': ('etterklok',),
'etterkloke': ('etterklok',),
'etterklokere': ('etterklok',),
'etterklokest': ('etterklok',),
'etterklokeste': ('etterklok',),
'etterklokt': ('etterklok',),
'etterlatende': ('etterlate',),
'etterlatt': ('etterlate',),
'etterlatte': ('etterlate',),
'etterlengta': ('etterlengta',),
'etterlengtede': ('etterlengtet',),
'etterlengtet': ('etterlengtet',),
'etterlengtete': ('etterlengtet',),
'etterlengtetere': ('etterlengtet',),
'etterlengtetest': ('etterlengtet',),
'etterlengteteste': ('etterlengtet',),
'etterlevd': ('etterleve',),
'etterlevde': ('etterleve',),
'etterlevende': ('etterleve',),
'etterlevende': ('etterlevende',),
'etterligna': ('etterligne',),
'etterlignede': ('etterligne',),
'etterlignende': ('etterligne',),
'etterlignet': ('etterligne',),
'etterlignete': ('etterligne',),
'etterlikna': ('etterlikne',),
'etterliknede': ('etterlikne',),
'etterliknende': ('etterlikne',),
'etterliknet': ('etterlikne',),
'etterliknete': ('etterlikne',),
'etterlysende': ('etterlyse',),
'etterlyst': ('etterlyse',),
'etterlyste': ('etterlyse',),
'etterplapra': ('etterplapre',),
'etterplaprede': ('etterplapre',),
'etterplaprende': ('etterplapre',),
'etterplapret': ('etterplapre',),
'etterplaprete': ('etterplapre',),
'etterprøvd': ('etterprøve',),
'etterprøvde': ('etterprøve',),
'etterprøvende': ('etterprøve',),
'etterpåklok': ('etterpåklok',),
'etterpåkloke': ('etterpåklok',),
'etterpåklokere': ('etterpåklok',),
'etterpåklokest': ('etterpåklok',),
'etterpåklokeste': ('etterpåklok',),
'etterpåklokt': ('etterpåklok',),
'etterrettelig': ('etterrettelig',),
'etterrettelige': ('etterrettelig',),
'etterretteligere': ('etterrettelig',),
'etterretteligst': ('etterrettelig',),
'etterretteligste': ('etterrettelig',),
'etterseende': ('etterse',),
'ettersett': ('etterse',),
'ettersette': ('etterse',),
'ettersendende': ('ettersende',),
'ettersendt': ('ettersende',),
'ettersendte': ('ettersende',),
'ettersittende': ('ettersittende',),
'etterslokka': ('etterslokke',),
'etterslokkede': ('etterslokke',),
'etterslokkende': ('etterslokke',),
'etterslokket': ('etterslokke',),
'etterslokkete': ('etterslokke',),
'etterslokt': ('etterslokke',),
'etterslokte': ('etterslokke',),
'etterslukka': ('etterslukke',),
'etterslukkede': ('etterslukke',),
'etterslukkende': ('etterslukke',),
'etterslukket': ('etterslukke',),
'etterslukkete': ('etterslukke',),
'etterslukt': ('etterslukke',),
'etterslukte': ('etterslukke',),
'etterspora': ('etterspore',),
'ettersporede': ('etterspore',),
'ettersporende': ('etterspore',),
'ettersporet': ('etterspore',),
'ettersporete': ('etterspore',),
'ettersport': ('etterspore',),
'ettersporte': ('etterspore',),
'etterspurt': ('etterspurt',),
'etterspurte': ('etterspurt',),
'etterspurtere': ('etterspurt',),
'etterspurtest': ('etterspurt',),
'etterspurteste': ('etterspurt',),
'etterstreba': ('etterstrebe',),
'etterstrebede': ('etterstrebe',),
'etterstrebende': ('etterstrebe',),
'etterstrebet': ('etterstrebe',),
'etterstrebete': ('etterstrebe',),
'ettersynkroniserende': ('ettersynkronisere',),
'ettersynkronisert': ('ettersynkronisere',),
'ettersynkroniserte': ('ettersynkronisere',),
'ettersøkende': ('ettersøke',),
'ettersøkt': ('ettersøke',),
'ettersøkte': ('ettersøke',),
'ettertenksom': ('ettertenksom',),
'ettertenksomme': ('ettertenksom',),
'ettertenksommere': ('ettertenksom',),
'ettertenksomst': ('ettertenksom',),
'ettertenksomste': ('ettertenksom',),
'ettertenksomt': ('ettertenksom',),
'ettertrakta': ('ettertrakta',),
'ettertrakta': ('ettertrakte',),
'ettertraktede': ('ettertrakte',),
'ettertraktende': ('ettertrakte',),
'ettertraktet': ('ettertrakte',),
'ettertraktete': ('ettertrakte',),
'ettertraktelsesverdig': ('ettertraktelsesverdig',),
'ettertraktelsesverdige': ('ettertraktelsesverdig',),
'ettertraktelsesverdigere': ('ettertraktelsesverdig',),
'ettertraktelsesverdigst': ('ettertraktelsesverdig',),
'ettertraktelsesverdigste': ('ettertraktelsesverdig',),
'ettertraktede': ('ettertraktet',),
'ettertraktet': ('ettertraktet',),
'ettertraktete': ('ettertraktet',),
'ettertraktetere': ('ettertraktet',),
'ettertraktetest': ('ettertraktet',),
'ettertrakteteste': ('ettertraktet',),
'ettertrykkelig': ('ettertrykkelig',),
'ettertrykkelige': ('ettertrykkelig',),
'ettertrykkeligere': ('ettertrykkelig',),
'ettertrykkeligst': ('ettertrykkelig',),
'ettertrykkeligste': ('ettertrykkelig',),
'ettfags': ('ettfags',),
'ettroms': ('ettroms',),
'ettårig': ('ettårig',),
'ettårige': ('ettårig',),
'ettårigere': ('ettårig',),
'ettårigst': ('ettårig',),
'ettårigste': ('ettårig',),
'ettårs': ('ettårs',),
'ettøres': ('ettøres',),
'etymologisk': ('etymologisk',),
'etymologiske': ('etymologisk',),
'etymologiskere': ('etymologisk',),
'etymologiskest': ('etymologisk',),
'etymologiskeste': ('etymologisk',),
'eufemistisk': ('eufemistisk',),
'eufemistiske': ('eufemistisk',),
'eufemistiskere': ('eufemistisk',),
'eufemistiskest': ('eufemistisk',),
'eufemistiskeste': ('eufemistisk',),
'eufonisk': ('eufonisk',),
'eufoniske': ('eufonisk',),
'eufoniskere': ('eufonisk',),
'eufoniskest': ('eufonisk',),
'eufoniskeste': ('eufonisk',),
'euforiserende': ('euforiserende',),
'eugenetisk': ('eugenetisk',),
'eugenetiske': ('eugenetisk',),
'eugenetiskere': ('eugenetisk',),
'eugenetiskest': ('eugenetisk',),
'eugenetiskeste': ('eugenetisk',),
'eugenisk': ('eugenisk',),
'eugeniske': ('eugenisk',),
'eugeniskere': ('eugenisk',),
'eugeniskest': ('eugenisk',),
'eugeniskeste': ('eugenisk',),
'eukaryot': ('eukaryot',),
'eukaryote': ('eukaryot',),
'eukaryotere': ('eukaryot',),
'eukaryotest': ('eukaryot',),
'eukaryoteste': ('eukaryot',),
'euklidsk': ('euklidsk',),
'euklidske': ('euklidsk',),
'euklidskere': ('euklidsk',),
'euklidskest': ('euklidsk',),
'euklidskeste': ('euklidsk',),
'eurasisk': ('eurasisk',),
'eurasiske': ('eurasisk',),
'eurasiskere': ('eurasisk',),
'eurasiskest': ('eurasisk',),
'eurasiskeste': ('eurasisk',),
'europeiserende': ('europeisere',),
'europeisert': ('europeisere',),
'europeiserte': ('europeisere',),
'europeisk': ('europeisk',),
'europeiske': ('europeisk',),
'europeiskere': ('europeisk',),
'europeiskest': ('europeisk',),
'europeiskeste': ('europeisk',),
'eutrof': ('eutrof',),
'eutrofe': ('eutrof',),
'eutrofere': ('eutrof',),
'eutrofest': ('eutrof',),
'eutrofeste': ('eutrof',),
'eutroft': ('eutrof',),
'evakuerende': ('evakuere',),
'evakuert': ('evakuere',),
'evakuerte': ('evakuere',),
'evaluerende': ('evaluere',),
'evaluert': ('evaluere',),
'evaluerte': ('evaluere',),
'evangeliserende': ('evangelisere',),
'evangelisert': ('evangelisere',),
'evangeliserte': ('evangelisere',),
'evangelisk': ('evangelisk',),
'evangeliske': ('evangelisk',),
'evangeliskere': ('evangelisk',),
'evangeliskest': ('evangelisk',),
'evangeliskeste': ('evangelisk',),
'evangelisk-luthersk': ('evangelisk-luthersk',),
'evangelisk-lutherske': ('evangelisk-luthersk',),
'evangelisk-lutherskere': ('evangelisk-luthersk',),
'evangelisk-lutherskest': ('evangelisk-luthersk',),
'evangelisk-lutherskeste': ('evangelisk-luthersk',),
'evaporerende': ('evaporere',),
'evaporert': ('evaporere',),
'evaporerte': ('evaporere',),
'evasiv': ('evasiv',),
'evasive': ('evasiv',),
'evasivere': ('evasiv',),
'evasivest': ('evasiv',),
'evasiveste': ('evasiv',),
'evasivt': ('evasiv',),
'eva': ('eve',),
'evede': ('eve',),
'evende': ('eve',),
'evet': ('eve',),
'evete': ('eve',),
'eventuell': ('eventuell',),
'eventuelle': ('eventuell',),
'eventuellere': ('eventuell',),
'eventuellest': ('eventuell',),
'eventuelleste': ('eventuell',),
'eventuelt': ('eventuell',),
'eventyraktig': ('eventyraktig',),
'eventyraktige': ('eventyraktig',),
'eventyraktigere': ('eventyraktig',),
'eventyraktigst': ('eventyraktig',),
'eventyraktigste': ('eventyraktig',),
'eventyrlig': ('eventyrlig',),
'eventyrlige': ('eventyrlig',),
'eventyrligere': ('eventyrlig',),
'eventyrligst': ('eventyrlig',),
'eventyrligste': ('eventyrlig',),
'eventyrlysten': ('eventyrlysten',),
'eventyrlystent': ('eventyrlysten',),
'eventyrlystne': ('eventyrlysten',),
'eventyrlystnere': ('eventyrlysten',),
'eventyrlystnest': ('eventyrlysten',),
'eventyrlystneste': ('eventyrlysten',),
'evfemistisk': ('evfemistisk',),
'evfemistiske': ('evfemistisk',),
'evfemistiskere': ('evfemistisk',),
'evfemistiskest': ('evfemistisk',),
'evfemistiskeste': ('evfemistisk',),
'evident': ('evident',),
'evidente': ('evident',),
'evidentere': ('evident',),
'evidentest': ('evident',),
'evidenteste': ('evident',),
'evig': ('evig',),
'evige': ('evig',),
'evigere': ('evig',),
'evigst': ('evig',),
'evigste': ('evig',),
'eviggrøn': ('eviggrøn',),
'eviggrøne': ('eviggrøn',),
'eviggrønere': ('eviggrøn',),
'eviggrønest': ('eviggrøn',),
'eviggrøneste': ('eviggrøn',),
'eviggrønt': ('eviggrøn',),
'eviggrønn': ('eviggrønn',),
'eviggrønne': ('eviggrønn',),
'eviggrønnere': ('eviggrønn',),
'eviggrønnest': ('eviggrønn',),
'eviggrønneste': ('eviggrønn',),
'eviggrønt': ('eviggrønn',),
'evigung': ('evigung',),
'evigunge': ('evigung',),
'evigungt': ('evigung',),
'evigyngre': ('evigung',),
'evigyngst': ('evigung',),
'evigyngste': ('evigung',),
'evigvarende': ('evigvarende',),
'evinnelig': ('evinnelig',),
'evinnelige': ('evinnelig',),
'evinneligere': ('evinnelig',),
'evinneligst': ('evinnelig',),
'evinneligste': ('evinnelig',),
'evna': ('evne',),
'evnede': ('evne',),
'evnende': ('evne',),
'evnet': ('evne',),
'evnete': ('evne',),
'evnelaus': ('evnelaus',),
'evnelause': ('evnelaus',),
'evnelausere': ('evnelaus',),
'evnelausest': ('evnelaus',),
'evnelauseste': ('evnelaus',),
'evnelaust': ('evnelaus',),
'evneløs': ('evneløs',),
'evneløse': ('evneløs',),
'evneløsere': ('evneløs',),
'evneløsest': ('evneløs',),
'evneløseste': ('evneløs',),
'evneløst': ('evneløs',),
'evnerik': ('evnerik',),
'evnerike': ('evnerik',),
'evnerikere': ('evnerik',),
'evnerikest': ('evnerik',),
'evnerikeste': ('evnerik',),
'evnerikt': ('evnerik',),
'evneveik': ('evneveik',),
'evneveike': ('evneveik',),
'evneveikere': ('evneveik',),
'evneveikest': ('evneveik',),
'evneveikeste': ('evneveik',),
'evneveikt': ('evneveik',),
'evnevek': ('evnevek',),
'evneveke': ('evnevek',),
'evnevekere': ('evnevek',),
'evnevekest': ('evnevek',),
'evnevekeste': ('evnevek',),
'evnevekt': ('evnevek',),
'evolusjonistisk': ('evolusjonistisk',),
'evolusjonistiske': ('evolusjonistisk',),
'evolusjonistiskere': ('evolusjonistisk',),
'evolusjonistiskest': ('evolusjonistisk',),
'evolusjonistiskeste': ('evolusjonistisk',),
'exa': ('exe',),
'exede': ('exe',),
'exende': ('exe',),
'exet': ('exe',),
'exete': ('exe',),
'fôra': ('fôre',),
'fôrede': ('fôre',),
'fôrende': ('fôre',),
'fôret': ('fôre',),
'fôrete': ('fôre',),
'fôrt': ('fôre',),
'fôrte': ('fôre',),
'fôra': ('fôre',),
'fôrede': ('fôre',),
'fôrende': ('fôre',),
'fôret': ('fôre',),
'fôrete': ('fôre',),
'fôrt': ('fôre',),
'fôrte': ('fôre',),
'fabelaktig': ('fabelaktig',),
'fabelaktige': ('fabelaktig',),
'fabelaktigere': ('fabelaktig',),
'fabelaktigst': ('fabelaktig',),
'fabelaktigste': ('fabelaktig',),
'fabla': ('fable',),
'fablede': ('fable',),
'fablende': ('fable',),
'fablet': ('fable',),
'fablete': ('fable',),
'fabrikkerende': ('fabrikkere',),
'fabrikkert': ('fabrikkere',),
'fabrikkerte': ('fabrikkere',),
'fabrikkmessig': ('fabrikkmessig',),
'fabrikkmessige': ('fabrikkmessig',),
'fabrikkmessigere': ('fabrikkmessig',),
'fabrikkmessigst': ('fabrikkmessig',),
'fabrikkmessigste': ('fabrikkmessig',),
'fabrikkny': ('fabrikkny',),
'fabrikknye': ('fabrikkny',),
'fabrikknyere': ('fabrikkny',),
'fabrikknyest': ('fabrikkny',),
'fabrikknyeste': ('fabrikkny',),
'fabrikknytt': ('fabrikkny',),
'fabulerende': ('fabulere',),
'fabulert': ('fabulere',),
'fabulerte': ('fabulere',),
'fada': ('fade',),
'fadede': ('fade',),
'fadende': ('fade',),
'fadet': ('fade',),
'fadete': ('fade',),
'faderlig': ('faderlig',),
'faderlige': ('faderlig',),
'faderligere': ('faderlig',),
'faderligst': ('faderlig',),
'faderligste': ('faderlig',),
'faderløs': ('faderløs',),
'faderløse': ('faderløs',),
'faderløsere': ('faderløs',),
'faderløsest': ('faderløs',),
'faderløseste': ('faderløs',),
'faderløst': ('faderløs',),
'faens': ('faens',),
'fager': ('fager',),
'fagert': ('fager',),
'fagre': ('fager',),
'fagrere': ('fager',),
'fagrest': ('fager',),
'fagreste': ('fager',),
'faglig': ('faglig',),
'faglige': ('faglig',),
'fagligere': ('faglig',),
'fagligst': ('faglig',),
'fagligste': ('faglig',),
'faglært': ('faglært',),
'faglærte': ('faglært',),
'faglærtere': ('faglært',),
'faglærtest': ('faglært',),
'faglærteste': ('faglært',),
'fagmessig': ('fagmessig',),
'fagmessige': ('fagmessig',),
'fagmessigere': ('fagmessig',),
'fagmessigst': ('fagmessig',),
'fagmessigste': ('fagmessig',),
'fagna': ('fagne',),
'fagnede': ('fagne',),
'fagnende': ('fagne',),
'fagnet': ('fagne',),
'fagnete': ('fagne',),
'fagorganisert': ('fagorganisert',),
'fagorganiserte': ('fagorganisert',),
'fagorganisertere': ('fagorganisert',),
'fagorganisertest': ('fagorganisert',),
'fagorganiserteste': ('fagorganisert',),
'fair': ('fair',),
'fakka': ('fakke',),
'fakkede': ('fakke',),
'fakkende': ('fakke',),
'fakket': ('fakke',),
'fakkete': ('fakke',),
'faksa': ('fakse',),
'faksede': ('fakse',),
'faksende': ('fakse',),
'fakset': ('fakse',),
'faksete': ('fakse',),
'fakset': ('fakset',),
'faksete': ('fakset',),
'faksetere': ('fakset',),
'faksetest': ('fakset',),
'fakseteste': ('fakset',),
'faksete': ('faksete',),
'faksimilerende': ('faksimilere',),
'faksimilert': ('faksimilere',),
'faksimilerte': ('faksimilere',),
'faktisk': ('faktisk',),
'faktiske': ('faktisk',),
'faktiskere': ('faktisk',),
'faktiskest': ('faktisk',),
'faktiskeste': ('faktisk',),
'faktoriserende': ('faktorisere',),
'faktorisert': ('faktorisere',),
'faktoriserte': ('faktorisere',),
'faktuell': ('faktuell',),
'faktuelle': ('faktuell',),
'faktuellere': ('faktuell',),
'faktuellest': ('faktuell',),
'faktuelleste': ('faktuell',),
'faktuelt': ('faktuell',),
'fakturerende': ('fakturere',),
'fakturert': ('fakturere',),
'fakturerte': ('fakturere',),
'fakultativ': ('fakultativ',),
'fakultative': ('fakultativ',),
'fakultativere': ('fakultativ',),
'fakultativest': ('fakultativ',),
'fakultativeste': ('fakultativ',),
'fakultativt': ('fakultativ',),
'fal': ('fal',),
'falbudt': ('falby',),
'falbudte': ('falby',),
'falbydd': ('falby',),
'falbydde': ('falby',),
'falbyende': ('falby',),
'falda': ('falde',),
'faldede': ('falde',),
'faldende': ('falde',),
'faldet': ('falde',),
'faldete': ('falde',),
'falklandsk': ('falklandsk',),
'falklandske': ('falklandsk',),
'falklandskere': ('falklandsk',),
'falklandskest': ('falklandsk',),
'falklandskeste': ('falklandsk',),
'fallende': ('falle',),
'falt': ('falle',),
'falte': ('falle',),
'falleferdig': ('falleferdig',),
'falleferdige': ('falleferdig',),
'falleferdigere': ('falleferdig',),
'falleferdigst': ('falleferdig',),
'falleferdigste': ('falleferdig',),
'fallen': ('fallen',),
'fallent': ('fallen',),
'falne': ('fallen',),
'falnere': ('fallen',),
'falnest': ('fallen',),
'falneste': ('fallen',),
'fallerende': ('fallere',),
'fallert': ('fallere',),
'fallerte': ('fallere',),
'fallesjuk': ('fallesjuk',),
'fallesjuke': ('fallesjuk',),
'fallesjukere': ('fallesjuk',),
'fallesjukest': ('fallesjuk',),
'fallesjukeste': ('fallesjuk',),
'fallesjukt': ('fallesjuk',),
'fallesyk': ('fallesyk',),
'fallesyke': ('fallesyk',),
'fallesykere': ('fallesyk',),
'fallesykest': ('fallesyk',),
'fallesykeste': ('fallesyk',),
'fallesykt': ('fallesyk',),
'fallisk': ('fallisk',),
'falliske': ('fallisk',),
'falliskere': ('fallisk',),
'falliskest': ('fallisk',),
'falliskeste': ('fallisk',),
'fallitt': ('fallitt',),
'fallitte': ('fallitt',),
'fallittere': ('fallitt',),
'fallittest': ('fallitt',),
'fallitteste': ('fallitt',),
'falma': ('falme',),
'falmede': ('falme',),
'falmende': ('falme',),
'falmet': ('falme',),
'falmete': ('falme',),
'falsa': ('false',),
'falsede': ('false',),
'falsende': ('false',),
'falset': ('false',),
'falsete': ('false',),
'falsifiserbar': ('falsifiserbar',),
'falsifiserbare': ('falsifiserbar',),
'falsifiserbarere': ('falsifiserbar',),
'falsifiserbarest': ('falsifiserbar',),
'falsifiserbareste': ('falsifiserbar',),
'falsifiserbart': ('falsifiserbar',),
'falsifiserende': ('falsifisere',),
'falsifisert': ('falsifisere',),
'falsifiserte': ('falsifisere',),
'falsk': ('falsk',),
'falske': ('falsk',),
'falskere': ('falsk',),
'falskest': ('falsk',),
'falskeste': ('falsk',),
'falskt': ('falsk',),
'familievennlig': ('familievennlig',),
'familievennlige': ('familievennlig',),
'familievennligere': ('familievennlig',),
'familievennligst': ('familievennlig',),
'familievennligste': ('familievennlig',),
'familiær': ('familiær',),
'familiære': ('familiær',),
'familiærere': ('familiær',),
'familiærest': ('familiær',),
'familiæreste': ('familiær',),
'familiært': ('familiær',),
'famla': ('famle',),
'famlede': ('famle',),
'famlende': ('famle',),
'famlet': ('famle',),
'famlete': ('famle',),
'famlende': ('famlende',),
'famna': ('famne',),
'famnede': ('famne',),
'famnende': ('famne',),
'famnet': ('famne',),
'famnete': ('famne',),
'famna': ('famne',),
'famnede': ('famne',),
'famnende': ('famne',),
'famnet': ('famne',),
'famnete': ('famne',),
'famøs': ('famøs',),
'famøse': ('famøs',),
'famøsere': ('famøs',),
'famøsest': ('famøs',),
'famøseste': ('famøs',),
'famøst': ('famøs',),
'fanatisk': ('fanatisk',),
'fanatiske': ('fanatisk',),
'fanatiskere': ('fanatisk',),
'fanatiskest': ('fanatisk',),
'fanatiskeste': ('fanatisk',),
'fancy': ('fancy',),
'fandenivoldsk': ('fandenivoldsk',),
'fandenivoldske': ('fandenivoldsk',),
'fandenivoldskere': ('fandenivoldsk',),
'fandenivoldskest': ('fandenivoldsk',),
'fandenivoldskeste': ('fandenivoldsk',),
'fandens': ('fandens',),
'fanga': ('fange',),
'fangede': ('fange',),
'fangende': ('fange',),
'fanget': ('fange',),
'fangete': ('fange',),
'fangen': ('fangen',),
'fangent': ('fangen',),
'fangne': ('fangen',),
'fangnere': ('fangen',),
'fangnest': ('fangen',),
'fangneste': ('fangen',),
'fangsta': ('fangste',),
'fangstede': ('fangste',),
'fangstende': ('fangste',),
'fangstet': ('fangste',),
'fangstete': ('fangste',),
'fans': ('fans',),
'fantaserende': ('fantasere',),
'fantasert': ('fantasere',),
'fantaserte': ('fantasere',),
'fantasifull': ('fantasifull',),
'fantasifulle': ('fantasifull',),
'fantasifullere': ('fantasifull',),
'fantasifullest': ('fantasifull',),
'fantasifulleste': ('fantasifull',),
'fantasifullt': ('fantasifull',),
'fantasilaus': ('fantasilaus',),
'fantasilause': ('fantasilaus',),
'fantasilausere': ('fantasilaus',),
'fantasilausest': ('fantasilaus',),
'fantasilauseste': ('fantasilaus',),
'fantasilaust': ('fantasilaus',),
'fantasiløs': ('fantasiløs',),
'fantasiløse': ('fantasiløs',),
'fantasiløsere': ('fantasiløs',),
'fantasiløsest': ('fantasiløs',),
'fantasiløseste': ('fantasiløs',),
'fantasiløst': ('fantasiløs',),
'fantasirik': ('fantasirik',),
'fantasirike': ('fantasirik',),
'fantasirikere': ('fantasirik',),
'fantasirikest': ('fantasirik',),
'fantasirikeste': ('fantasirik',),
'fantasirikt': ('fantasirik',),
'fantastisk': ('fantastisk',),
'fantastiske': ('fantastisk',),
'fantastiskere': ('fantastisk',),
'fantastiskest': ('fantastisk',),
'fantastiskeste': ('fantastisk',),
'fantegående': ('fantegå',),
'fantegått': ('fantegå',),
'fantegåtte': ('fantegå',),
'faraoisk': ('faraoisk',),
'faraoiske': ('faraoisk',),
'faraoiskere': ('faraoisk',),
'faraoiskest': ('faraoisk',),
'faraoiskeste': ('faraoisk',),
'farbar': ('farbar',),
'farbare': ('farbar',),
'farbarere': ('farbar',),
'farbarest': ('farbar',),
'farbareste': ('farbar',),
'farbart': ('farbar',),
'farende': ('fare',),
'fart': ('fare',),
'farte': ('fare',),
'farefri': ('farefri',),
'farefrie': ('farefri',),
'farefriere': ('farefri',),
'farefriest': ('farefri',),
'farefrieste': ('farefri',),
'farefritt': ('farefri',),
'farefull': ('farefull',),
'farefulle': ('farefull',),
'farefullere': ('farefull',),
'farefullest': ('farefull',),
'farefulleste': ('farefull',),
'farefullt': ('farefull',),
'faren': ('faren',),
'farent': ('faren',),
'farne': ('faren',),
'farnere': ('faren',),
'farnest': ('faren',),
'farneste': ('faren',),
'faretruende': ('faretruende',),
'farga': ('farga',),
'farga': ('farge',),
'fargede': ('farge',),
'fargende': ('farge',),
'farget': ('farge',),
'fargete': ('farge',),
'fargeblind': ('fargeblind',),
'fargeblinde': ('fargeblind',),
'fargeblindere': ('fargeblind',),
'fargeblindest': ('fargeblind',),
'fargeblindeste': ('fargeblind',),
'fargeblindt': ('fargeblind',),
'fargeekte': ('fargeekte',),
'fargelaus': ('fargelaus',),
'fargelause': ('fargelaus',),
'fargelausere': ('fargelaus',),
'fargelausest': ('fargelaus',),
'fargelauseste': ('fargelaus',),
'fargelaust': ('fargelaus',),
'fargeløs': ('fargeløs',),
'fargeløse': ('fargeløs',),
'fargeløsere': ('fargeløs',),
'fargeløsest': ('fargeløs',),
'fargeløseste': ('fargeløs',),
'fargeløst': ('fargeløs',),
'fargerik': ('fargerik',),
'fargerike': ('fargerik',),
'fargerikere': ('fargerik',),
'fargerikest': ('fargerik',),
'fargerikeste': ('fargerik',),
'fargerikt': ('fargerik',),
'fargede': ('farget',),
'farget': ('farget',),
'fargete': ('farget',),
'fargetere': ('farget',),
'fargetest': ('farget',),
'fargeteste': ('farget',),
'fariseisk': ('fariseisk',),
'fariseiske': ('fariseisk',),
'fariseiskere': ('fariseisk',),
'fariseiskest': ('fariseisk',),
'fariseiskeste': ('fariseisk',),
'farlaus': ('farlaus',),
'farlause': ('farlaus',),
'farlausere': ('farlaus',),
'farlausest': ('farlaus',),
'farlauseste': ('farlaus',),
'farlaust': ('farlaus',),
'farlig': ('farlig',),
'farlige': ('farlig',),
'farligere': ('farlig',),
'farligst': ('farlig',),
'farligste': ('farlig',),
'farløs': ('farløs',),
'farløse': ('farløs',),
'farløsere': ('farløs',),
'farløsest': ('farløs',),
'farløseste': ('farløs',),
'farløst': ('farløs',),
'farmakologisk': ('farmakologisk',),
'farmakologiske': ('farmakologisk',),
'farmakologiskere': ('farmakologisk',),
'farmakologiskest': ('farmakologisk',),
'farmakologiskeste': ('farmakologisk',),
'farmasøytisk': ('farmasøytisk',),
'farmasøytiske': ('farmasøytisk',),
'farmasøytiskere': ('farmasøytisk',),
'farmasøytiskest': ('farmasøytisk',),
'farmasøytiskeste': ('farmasøytisk',),
'farserende': ('farsere',),
'farsert': ('farsere',),
'farserte': ('farsere',),
'farta': ('farte',),
'fartede': ('farte',),
'fartende': ('farte',),
'fartet': ('farte',),
'fartete': ('farte',),
'fartsgal': ('fartsgal',),
'fartsgale': ('fartsgal',),
'fartsgalere': ('fartsgal',),
'fartsgalest': ('fartsgal',),
'fartsgaleste': ('fartsgal',),
'fartsgalt': ('fartsgal',),
'fasadefri': ('fasadefri',),
'fasadefrie': ('fasadefri',),
'fasadefriere': ('fasadefri',),
'fasadefriest': ('fasadefri',),
'fasadefrieste': ('fasadefri',),
'fasadefritt': ('fasadefri',),
'fascinerende': ('fascinere',),
'fascinert': ('fascinere',),
'fascinerte': ('fascinere',),
'fascistisk': ('fascistisk',),
'fascistiske': ('fascistisk',),
'fascistiskere': ('fascistisk',),
'fascistiskest': ('fascistisk',),
'fascistiskeste': ('fascistisk',),
'fasa': ('fase',),
'fasede': ('fase',),
'fasende': ('fase',),
'faset': ('fase',),
'fasete': ('fase',),
'fasetterende': ('fasettere',),
'fasettert': ('fasettere',),
'fasetterte': ('fasettere',),
'fasjonabel': ('fasjonabel',),
'fasjonabelt': ('fasjonabel',),
'fasjonable': ('fasjonabel',),
'fasjonablere': ('fasjonabel',),
'fasjonablest': ('fasjonabel',),
'fasjonableste': ('fasjonabel',),
'fasla': ('fasle',),
'faslede': ('fasle',),
'faslende': ('fasle',),
'faslet': ('fasle',),
'faslete': ('fasle',),
'fasongerende': ('fasongere',),
'fasongert': ('fasongere',),
'fasongerte': ('fasongere',),
'fasongsydd': ('fasongsydd',),
'fasongsydde': ('fasongsydd',),
'fasongsyddere': ('fasongsydd',),
'fasongsyddest': ('fasongsydd',),
'fasongsyddeste': ('fasongsydd',),
'fast': ('fast',),
'faste': ('fast',),
'fastere': ('fast',),
'fastest': ('fast',),
'fasteste': ('fast',),
'fastboende': ('fastboende',),
'fastbuende': ('fastbuende',),
'fasta': ('faste',),
'fastede': ('faste',),
'fastende': ('faste',),
'fastet': ('faste',),
'fastete': ('faste',),
'fastfrosne': ('fastfrossen',),
'fastfrosnere': ('fastfrossen',),
'fastfrosnest': ('fastfrossen',),
'fastfrosneste': ('fastfrossen',),
'fastfrossen': ('fastfrossen',),
'fastfrosset': ('fastfrossen',),
'fastfrosne': ('fastfrosset',),
'fastfrosnere': ('fastfrosset',),
'fastfrosnest': ('fastfrosset',),
'fastfrosneste': ('fastfrosset',),
'fastfrosset': ('fastfrosset',),
'fastgrodd': ('fastgrodd',),
'fastgrodde': ('fastgrodd',),
'fastgroddere': ('fastgrodd',),
'fastgroddest': ('fastgrodd',),
'fastgroddeste': ('fastgrodd',),
'fastholdende': ('fastholde',),
'fastholdt': ('fastholde',),
'fastholdte': ('fastholde',),
'fastklemt': ('fastklemt',),
'fastklemte': ('fastklemt',),
'fastklemtere': ('fastklemt',),
'fastklemtest': ('fastklemt',),
'fastklemteste': ('fastklemt',),
'fastlagt': ('fastlegge',),
'fastlagte': ('fastlegge',),
'fastleggende': ('fastlegge',),
'fastlåsende': ('fastlåse',),
'fastlåst': ('fastlåse',),
'fastlåste': ('fastlåse',),
'fastlønna': ('fastlønna',),
'fastlønnede': ('fastlønnet',),
'fastlønnet': ('fastlønnet',),
'fastlønnete': ('fastlønnet',),
'fastlønnetere': ('fastlønnet',),
'fastlønnetest': ('fastlønnet',),
'fastlønneteste': ('fastlønnet',),
'fastlønt': ('fastlønt',),
'fastlønte': ('fastlønt',),
'fastløntere': ('fastlønt',),
'fastløntest': ('fastlønt',),
'fastlønteste': ('fastlønt',),
'fastnagla': ('fastnagla',),
'fastnaglede': ('fastnaglet',),
'fastnaglet': ('fastnaglet',),
'fastnaglete': ('fastnaglet',),
'fastnagletere': ('fastnaglet',),
'fastnagletest': ('fastnaglet',),
'fastnagleteste': ('fastnaglet',),
'fastna': ('fastne',),
'fastnede': ('fastne',),
'fastnende': ('fastne',),
'fastnet': ('fastne',),
'fastnete': ('fastne',),
'fastrusta': ('fastrusta',),
'fastrustede': ('fastrustet',),
'fastrustet': ('fastrustet',),
'fastrustete': ('fastrustet',),
'fastrustetere': ('fastrustet',),
'fastrustetest': ('fastrustet',),
'fastrusteteste': ('fastrustet',),
'fastsatt': ('fastsette',),
'fastsatte': ('fastsette',),
'fastsettende': ('fastsette',),
'fasttømra': ('fasttømra',),
'fasttømrede': ('fasttømret',),
'fasttømret': ('fasttømret',),
'fasttømrete': ('fasttømret',),
'fasttømretere': ('fasttømret',),
'fasttømretest': ('fasttømret',),
'fasttømreteste': ('fasttømret',),
'fatal': ('fatal',),
'fatale': ('fatal',),
'fatalere': ('fatal',),
'fatalest': ('fatal',),
'fataleste': ('fatal',),
'fatalt': ('fatal',),
'fatalistisk': ('fatalistisk',),
'fatalistiske': ('fatalistisk',),
'fatalistiskere': ('fatalistisk',),
'fatalistiskest': ('fatalistisk',),
'fatalistiskeste': ('fatalistisk',),
'fata': ('fate',),
'fatede': ('fate',),
'fatende': ('fate',),
'fatet': ('fate',),
'fatete': ('fate',),
'fatla': ('fatle',),
'fatlede': ('fatle',),
'fatlende': ('fatle',),
'fatlet': ('fatle',),
'fatlete': ('fatle',),
'fatta': ('fatta',),
'fattbar': ('fattbar',),
'fattbare': ('fattbar',),
'fattbarere': ('fattbar',),
'fattbarest': ('fattbar',),
'fattbareste': ('fattbar',),
'fattbart': ('fattbar',),
'fatta': ('fatte',),
'fattede': ('fatte',),
'fattende': ('fatte',),
'fattet': ('fatte',),
'fattete': ('fatte',),
'fattelig': ('fattelig',),
'fattelige': ('fattelig',),
'fatteligere': ('fattelig',),
'fatteligst': ('fattelig',),
'fatteligste': ('fattelig',),
'fattede': ('fattet',),
'fattet': ('fattet',),
'fattete': ('fattet',),
'fattetere': ('fattet',),
'fattetest': ('fattet',),
'fatteteste': ('fattet',),
'fattig': ('fattig',),
'fattige': ('fattig',),
'fattigere': ('fattig',),
'fattigst': ('fattig',),
'fattigste': ('fattig',),
'fattigfornem': ('fattigfornem',),
'fattigfornemme': ('fattigfornem',),
'fattigfornemmere': ('fattigfornem',),
'fattigfornemmest': ('fattigfornem',),
'fattigfornemmeste': ('fattigfornem',),
'fattigfornemt': ('fattigfornem',),
'fattigslig': ('fattigslig',),
'fattigslige': ('fattigslig',),
'fattigsligere': ('fattigslig',),
'fattigsligst': ('fattigslig',),
'fattigsligste': ('fattigslig',),
'favna': ('favne',),
'favnede': ('favne',),
'favnende': ('favne',),
'favnet': ('favne',),
'favnete': ('favne',),
'favna': ('favne',),
'favnede': ('favne',),
'favnende': ('favne',),
'favnet': ('favne',),
'favnete': ('favne',),
'favoriserende': ('favorisere',),
'favorisert': ('favorisere',),
'favoriserte': ('favorisere',),
'feberdrivende': ('feberdrivende',),
'feberhet': ('feberhet',),
'feberhete': ('feberhet',),
'feberhetere': ('feberhet',),
'feberhetest': ('feberhet',),
'feberheteste': ('feberhet',),
'feberhett': ('feberhet',),
'feberstillende': ('feberstillende',),
'febril': ('febril',),
'febrile': ('febril',),
'febrilere': ('febril',),
'febrilest': ('febril',),
'febrileste': ('febril',),
'febrilt': ('febril',),
'febrilsk': ('febrilsk',),
'febrilske': ('febrilsk',),
'febrilskere': ('febrilsk',),
'febrilskest': ('febrilsk',),
'febrilskeste': ('febrilsk',),
'fedrene': ('fedrene',),
'feida': ('feide',),
'feidede': ('feide',),
'feidende': ('feide',),
'feidet': ('feide',),
'feidete': ('feide',),
'feia': ('feie',),
'feid': ('feie',),
'feide': ('feie',),
'feiede': ('feie',),
'feiende': ('feie',),
'feiet': ('feie',),
'feiete': ('feie',),
'feiende': ('feiende',),
'feig': ('feig',),
'feige': ('feig',),
'feigere': ('feig',),
'feigest': ('feig',),
'feigeste': ('feig',),
'feigt': ('feig',),
'feilaktig': ('feilaktig',),
'feilaktige': ('feilaktig',),
'feilaktigere': ('feilaktig',),
'feilaktigst': ('feilaktig',),
'feilaktigste': ('feilaktig',),
'feilbedømmende': ('feilbedømme',),
'feilbedømt': ('feilbedømme',),
'feilbedømte': ('feilbedømme',),
'feila': ('feile',),
'feilede': ('feile',),
'feilende': ('feile',),
'feilet': ('feile',),
'feilete': ('feile',),
'feilt': ('feile',),
'feilte': ('feile',),
'feilslått': ('feilslått',),
'feilslåtte': ('feilslått',),
'feilslåttere': ('feilslått',),
'feilslåttest': ('feilslått',),
'feilslåtteste': ('feilslått',),
'feilvurderende': ('feilvurdere',),
'feilvurdert': ('feilvurdere',),
'feilvurderte': ('feilvurdere',),
'feira': ('feire',),
'feirede': ('feire',),
'feirende': ('feire',),
'feiret': ('feire',),
'feirete': ('feire',),
'feit': ('feit',),
'feite': ('feit',),
'feitere': ('feit',),
'feitest': ('feit',),
'feiteste': ('feit',),
'feitt': ('feit',),
'fett': ('feit',),
'feita': ('feite',),
'feitede': ('feite',),
'feitende': ('feite',),
'feitet': ('feite',),
'feitete': ('feite',),
'feitladen': ('feitladen',),
'feitladent': ('feitladen',),
'feitladne': ('feitladen',),
'feitladnere': ('feitladen',),
'feitladnest': ('feitladen',),
'feitladneste': ('feitladen',),
'feitlaten': ('feitlaten',),
'feitlatent': ('feitlaten',),
'feitlatne': ('feitlaten',),
'feitlatnere': ('feitlaten',),
'feitlatnest': ('feitlaten',),
'feitlatneste': ('feitlaten',),
'feitna': ('feitne',),
'feitnede': ('feitne',),
'feitnende': ('feitne',),
'feitnet': ('feitne',),
'feitnete': ('feitne',),
'fekta': ('fekte',),
'fektede': ('fekte',),
'fektende': ('fekte',),
'fektet': ('fekte',),
'fektete': ('fekte',),
'fellende': ('felle',),
'felt': ('felle',),
'felte': ('felle',),
'fellende': ('fellende',),
'felles': ('felles',),
'felleskirkelig': ('felleskirkelig',),
'felleskirkelige': ('felleskirkelig',),
'felleskirkeligere': ('felleskirkelig',),
'felleskirkeligst': ('felleskirkelig',),
'felleskirkeligste': ('felleskirkelig',),
'femblada': ('femblada',),
'fembladede': ('fembladet',),
'fembladet': ('fembladet',),
'fembladete': ('fembladet',),
'fembladetere': ('fembladet',),
'fembladetest': ('fembladet',),
'fembladeteste': ('fembladet',),
'femdobbel': ('femdobbel',),
'femdobbelt': ('femdobbel',),
'femdoble': ('femdobbel',),
'femdoblere': ('femdobbel',),
'femdoblest': ('femdobbel',),
'femdobleste': ('femdobbel',),
'femdobbelt': ('femdobbelt',),
'femdobbelte': ('femdobbelt',),
'femdobbeltere': ('femdobbelt',),
'femdobbeltest': ('femdobbelt',),
'femdobbelteste': ('femdobbelt',),
'femdobla': ('femdoble',),
'femdoblede': ('femdoble',),
'femdoblende': ('femdoble',),
'femdoblet': ('femdoble',),
'femdoblete': ('femdoble',),
'femetasjes': ('femetasjes',),
'femfota': ('femfota',),
'femfotede': ('femfotet',),
'femfotet': ('femfotet',),
'femfotete': ('femfotet',),
'femfotetere': ('femfotet',),
'femfotetest': ('femfotet',),
'femfoteteste': ('femfotet',),
'femføtt': ('femføtt',),
'femføtte': ('femføtt',),
'femføttere': ('femføtt',),
'femføttest': ('femføtt',),
'femføtteste': ('femføtt',),
'feminin': ('feminin',),
'feminine': ('feminin',),
'femininere': ('feminin',),
'femininest': ('feminin',),
'feminineste': ('feminin',),
'feminint': ('feminin',),
'feminiserende': ('feminisere',),
'feminisert': ('feminisere',),
'feminiserte': ('feminisere',),
'femkanta': ('femkanta',),
'femkantede': ('femkantet',),
'femkantet': ('femkantet',),
'femkantete': ('femkantet',),
'femkantetere': ('femkantet',),
'femkantetest': ('femkantet',),
'femkanteteste': ('femkantet',),
'femmasta': ('femmasta',),
'femmastede': ('femmastet',),
'femmastet': ('femmastet',),
'femmastete': ('femmastet',),
'femmastetere': ('femmastet',),
'femmastetest': ('femmastet',),
'femmasteteste': ('femmastet',),
'femroms': ('femroms',),
'femsida': ('femsida',),
'femsidede': ('femsidet',),
'femsidet': ('femsidet',),
'femsidete': ('femsidet',),
'femsidetere': ('femsidet',),
'femsidetest': ('femsidet',),
'femsideteste': ('femsidet',),
'femte': ('femte',),
'femtende': ('femtende',),
'femtenårig': ('femtenårig',),
'femtenårige': ('femtenårig',),
'femtenårigere': ('femtenårig',),
'femtenårigst': ('femtenårig',),
'femtenårigste': ('femtenårig',),
'femtenårs': ('femtenårs',),
'femtiende': ('femtiende',),
'femtiårig': ('femtiårig',),
'femtiårige': ('femtiårig',),
'femtiårigere': ('femtiårig',),
'femtiårigst': ('femtiårig',),
'femtiårigste': ('femtiårig',),
'femtiøres': ('femtiøres',),
'femtoms': ('femtoms',),
'femårig': ('femårig',),
'femårige': ('femårig',),
'femårigere': ('femårig',),
'femårigst': ('femårig',),
'femårigste': ('femårig',),
'femårs': ('femårs',),
'femøres': ('femøres',),
'fenga': ('fenge',),
'fengede': ('fenge',),
'fengende': ('fenge',),
'fenget': ('fenge',),
'fengete': ('fenge',),
'fengt': ('fenge',),
'fengte': ('fenge',),
'fengende': ('fengende',),
'fengsla': ('fengsle',),
'fengslede': ('fengsle',),
'fengslende': ('fengsle',),
'fengslet': ('fengsle',),
'fengslete': ('fengsle',),
'fengslig': ('fengslig',),
'fengslige': ('fengslig',),
'fengsligere': ('fengslig',),
'fengsligst': ('fengslig',),
'fengsligste': ('fengslig',),
'fennoskandisk': ('fennoskandisk',),
'fennoskandiske': ('fennoskandisk',),
'fennoskandiskere': ('fennoskandisk',),
'fennoskandiskest': ('fennoskandisk',),
'fennoskandiskeste': ('fennoskandisk',),
'fenologisk': ('fenologisk',),
'fenologiske': ('fenologisk',),
'fenologiskere': ('fenologisk',),
'fenologiskest': ('fenologisk',),
'fenologiskeste': ('fenologisk',),
'fenomenal': ('fenomenal',),
'fenomenale': ('fenomenal',),
'fenomenalere': ('fenomenal',),
'fenomenalest': ('fenomenal',),
'fenomenaleste': ('fenomenal',),
'fenomenalt': ('fenomenal',),
'fenomenologisk': ('fenomenologisk',),
'fenomenologiske': ('fenomenologisk',),
'fenomenologiskere': ('fenomenologisk',),
'fenomenologiskest': ('fenomenologisk',),
'fenomenologiskeste': ('fenomenologisk',),
'ferda': ('ferde',),
'ferdede': ('ferde',),
'ferdende': ('ferde',),
'ferdet': ('ferde',),
'ferdete': ('ferde',),
'ferdig': ('ferdig',),
'ferdige': ('ferdig',),
'ferdigere': ('ferdig',),
'ferdigst': ('ferdig',),
'ferdigste': ('ferdig',),
'ferdigbehandla': ('ferdigbehandle',),
'ferdigbehandlede': ('ferdigbehandle',),
'ferdigbehandlende': ('ferdigbehandle',),
'ferdigbehandlet': ('ferdigbehandle',),
'ferdigbehandlete': ('ferdigbehandle',),
'ferdiglaga': ('ferdiglaga',),
'ferdiglagd': ('ferdiglagd',),
'ferdiglagde': ('ferdiglagd',),
'ferdiglagdere': ('ferdiglagd',),
'ferdiglagdest': ('ferdiglagd',),
'ferdiglagdeste': ('ferdiglagd',),
'ferdiglagede': ('ferdiglaget',),
'ferdiglaget': ('ferdiglaget',),
'ferdiglagete': ('ferdiglaget',),
'ferdiglagetere': ('ferdiglaget',),
'ferdiglagetest': ('ferdiglaget',),
'ferdiglageteste': ('ferdiglaget',),
'ferdigpakka': ('ferdigpakka',),
'ferdigpakkede': ('ferdigpakket',),
'ferdigpakket': ('ferdigpakket',),
'ferdigpakkete': ('ferdigpakket',),
'ferdigpakketere': ('ferdigpakket',),
'ferdigpakketest': ('ferdigpakket',),
'ferdigpakketeste': ('ferdigpakket',),
'ferga': ('ferge',),
'fergede': ('ferge',),
'fergende': ('ferge',),
'ferget': ('ferge',),
'fergete': ('ferge',),
'ferierende': ('feriere',),
'feriert': ('feriere',),
'ferierte': ('feriere',),
'ferja': ('ferje',),
'ferjede': ('ferje',),
'ferjende': ('ferje',),
'ferjet': ('ferje',),
'ferjete': ('ferje',),
'ferm': ('ferm',),
'ferme': ('ferm',),
'fermere': ('ferm',),
'fermest': ('ferm',),
'fermeste': ('ferm',),
'fermt': ('ferm',),
'ferma': ('ferme',),
'fermede': ('ferme',),
'fermende': ('ferme',),
'fermet': ('ferme',),
'fermete': ('ferme',),
'fermenterende': ('fermentere',),
'fermentert': ('fermentere',),
'fermenterte': ('fermentere',),
'fernisserende': ('fernissere',),
'fernissert': ('fernissere',),
'fernisserte': ('fernissere',),
'fersk': ('fersk',),
'ferske': ('fersk',),
'ferskere': ('fersk',),
'ferskest': ('fersk',),
'ferskeste': ('fersk',),
'ferskt': ('fersk',),
'ferska': ('ferske',),
'ferskede': ('ferske',),
'ferskende': ('ferske',),
'fersket': ('ferske',),
'ferskete': ('ferske',),
'ferskenfargede': ('ferskenfarget',),
'ferskenfarget': ('ferskenfarget',),
'ferskenfargete': ('ferskenfarget',),
'ferskenfargetere': ('ferskenfarget',),
'ferskenfargetest': ('ferskenfarget',),
'ferskenfargeteste': ('ferskenfarget',),
'fertil': ('fertil',),
'fertile': ('fertil',),
'fertilere': ('fertil',),
'fertilest': ('fertil',),
'fertileste': ('fertil',),
'fertilt': ('fertil',),
'festa': ('feste',),
'festede': ('feste',),
'festende': ('feste',),
'festet': ('feste',),
'festete': ('feste',),
'festa': ('feste',),
'festede': ('feste',),
'festende': ('feste',),
'festet': ('feste',),
'festete': ('feste',),
'festlig': ('festlig',),
'festlige': ('festlig',),
'festligere': ('festlig',),
'festligst': ('festlig',),
'festligste': ('festlig',),
'festna': ('festne',),
'festnede': ('festne',),
'festnende': ('festne',),
'festnet': ('festne',),
'festnete': ('festne',),
'feststemt': ('feststemt',),
'feststemte': ('feststemt',),
'feststemtere': ('feststemt',),
'feststemtest': ('feststemt',),
'feststemteste': ('feststemt',),
'fet': ('fet',),
'fete': ('fet',),
'fetere': ('fet',),
'fetest': ('fet',),
'feteste': ('fet',),
'fett': ('fet',),
'feta': ('fete',),
'fetede': ('fete',),
'fetende': ('fete',),
'fetet': ('fete',),
'fetete': ('fete',),
'feterende': ('fetere',),
'fetert': ('fetere',),
'feterte': ('fetere',),
'fetlaten': ('fetlaten',),
'fetlatent': ('fetlaten',),
'fetlatne': ('fetlaten',),
'fetlatnere': ('fetlaten',),
'fetlatnest': ('fetlaten',),
'fetlatneste': ('fetlaten',),
'fetna': ('fetne',),
'fetnede': ('fetne',),
'fetnende': ('fetne',),
'fetnet': ('fetne',),
'fetnete': ('fetne',),
'fettet': ('fettet',),
'fettete': ('fettet',),
'fettetere': ('fettet',),
'fettetest': ('fettet',),
'fetteteste': ('fettet',),
'fettete': ('fettete',),
'fettglinsende': ('fettglinsende',),
'fiberrik': ('fiberrik',),
'fiberrike': ('fiberrik',),
'fiberrikere': ('fiberrik',),
'fiberrikest': ('fiberrik',),
'fiberrikeste': ('fiberrik',),
'fiberrikt': ('fiberrik',),
'fibrøs': ('fibrøs',),
'fibrøse': ('fibrøs',),
'fibrøsere': ('fibrøs',),
'fibrøsest': ('fibrøs',),
'fibrøseste': ('fibrøs',),
'fibrøst': ('fibrøs',),
'fiendsk': ('fiendsk',),
'fiendske': ('fiendsk',),
'fiendskere': ('fiendsk',),
'fiendskest': ('fiendsk',),
'fiendskeste': ('fiendsk',),
'fiendtlig': ('fiendtlig',),
'fiendtlige': ('fiendtlig',),
'fiendtligere': ('fiendtlig',),
'fiendtligst': ('fiendtlig',),
'fiendtligste': ('fiendtlig',),
'fiendtligsinna': ('fiendtligsinna',),
'fiendtligsinnede': ('fiendtligsinnet',),
'fiendtligsinnet': ('fiendtligsinnet',),
'fiendtligsinnete': ('fiendtligsinnet',),
'fiendtligsinnetere': ('fiendtligsinnet',),
'fiendtligsinnetest': ('fiendtligsinnet',),
'fiendtligsinneteste': ('fiendtligsinnet',),
'fiffa': ('fiffe',),
'fiffede': ('fiffe',),
'fiffende': ('fiffe',),
'fiffet': ('fiffe',),
'fiffete': ('fiffe',),
'fiffig': ('fiffig',),
'fiffige': ('fiffig',),
'fiffigere': ('fiffig',),
'fiffigst': ('fiffig',),
'fiffigste': ('fiffig',),
'fighta': ('fighte',),
'fightede': ('fighte',),
'fightende': ('fighte',),
'fightet': ('fighte',),
'fightete': ('fighte',),
'figurativ': ('figurativ',),
'figurative': ('figurativ',),
'figurativere': ('figurativ',),
'figurativest': ('figurativ',),
'figurativeste': ('figurativ',),
'figurativt': ('figurativ',),
'figurerende': ('figurere',),
'figurert': ('figurere',),
'figurerte': ('figurere',),
'figurlig': ('figurlig',),
'figurlige': ('figurlig',),
'figurligere': ('figurlig',),
'figurligst': ('figurlig',),
'figurligste': ('figurlig',),
'fijiansk': ('fijiansk',),
'fijianske': ('fijiansk',),
'fijianskere': ('fijiansk',),
'fijianskest': ('fijiansk',),
'fijianskeste': ('fijiansk',),
'fika': ('fike',),
'fikede': ('fike',),
'fikende': ('fike',),
'fiket': ('fike',),
'fikete': ('fike',),
'fikt': ('fike',),
'fikte': ('fike',),
'fiken': ('fiken',),
'fikent': ('fiken',),
'fikne': ('fiken',),
'fiknere': ('fiken',),
'fiknest': ('fiken',),
'fikneste': ('fiken',),
'fikla': ('fikle',),
'fiklede': ('fikle',),
'fiklende': ('fikle',),
'fiklet': ('fikle',),
'fiklete': ('fikle',),
'fiks': ('fiks',),
'fikse': ('fiks',),
'fiksere': ('fiks',),
'fiksest': ('fiks',),
'fikseste': ('fiks',),
'fikst': ('fiks',),
'fiksa': ('fikse',),
'fiksede': ('fikse',),
'fiksende': ('fikse',),
'fikset': ('fikse',),
'fiksete': ('fikse',),
'fikserende': ('fiksere',),
'fiksert': ('fiksere',),
'fikserte': ('fiksere',),
'fiktiv': ('fiktiv',),
'fiktive': ('fiktiv',),
'fiktivere': ('fiktiv',),
'fiktivest': ('fiktiv',),
'fiktiveste': ('fiktiv',),
'fiktivt': ('fiktiv',),
'filantropisk': ('filantropisk',),
'filantropiske': ('filantropisk',),
'filantropiskere': ('filantropisk',),
'filantropiskest': ('filantropisk',),
'filantropiskeste': ('filantropisk',),
'filatelistisk': ('filatelistisk',),
'filatelistiske': ('filatelistisk',),
'filatelistiskere': ('filatelistisk',),
'filatelistiskest': ('filatelistisk',),
'filatelistiskeste': ('filatelistisk',),
'fila': ('file',),
'filede': ('file',),
'filende': ('file',),
'filet': ('file',),
'filete': ('file',),
'filt': ('file',),
'filte': ('file',),
'filerende': ('filere',),
'filert': ('filere',),
'filerte': ('filere',),
'filerende': ('filere',),
'filert': ('filere',),
'filerte': ('filere',),
'filerende': ('filere',),
'filert': ('filere',),
'filerte': ('filere',),
'fileterende': ('filetere',),
'filetert': ('filetere',),
'fileterte': ('filetere',),
'fileterende': ('filetere',),
'filetert': ('filetere',),
'fileterte': ('filetere',),
'filharmonisk': ('filharmonisk',),
'filharmoniske': ('filharmonisk',),
'filharmoniskere': ('filharmonisk',),
'filharmoniskest': ('filharmonisk',),
'filharmoniskeste': ('filharmonisk',),
'filippinsk': ('filippinsk',),
'filippinske': ('filippinsk',),
'filippinskere': ('filippinsk',),
'filippinskest': ('filippinsk',),
'filippinskeste': ('filippinsk',),
'filistrøs': ('filistrøs',),
'filistrøse': ('filistrøs',),
'filistrøsere': ('filistrøs',),
'filistrøsest': ('filistrøs',),
'filistrøseste': ('filistrøs',),
'filistrøst': ('filistrøs',),
'fille': ('fille',),
'fillet': ('fillet',),
'fillete': ('fillet',),
'filletere': ('fillet',),
'filletest': ('fillet',),
'filleteste': ('fillet',),
'fillete': ('fillete',),
'filmatiserende': ('filmatisere',),
'filmatisert': ('filmatisere',),
'filmatiserte': ('filmatisere',),
'filmatisk': ('filmatisk',),
'filmatiske': ('filmatisk',),
'filmatiskere': ('filmatisk',),
'filmatiskest': ('filmatisk',),
'filmatiskeste': ('filmatisk',),
'filma': ('filme',),
'filmede': ('filme',),
'filmende': ('filme',),
'filmet': ('filme',),
'filmete': ('filme',),
'filologisk': ('filologisk',),
'filologiske': ('filologisk',),
'filologiskere': ('filologisk',),
'filologiskest': ('filologisk',),
'filologiskeste': ('filologisk',),
'filosoferende': ('filosofere',),
'filosofert': ('filosofere',),
'filosoferte': ('filosofere',),
'filosofisk': ('filosofisk',),
'filosofiske': ('filosofisk',),
'filosofiskere': ('filosofisk',),
'filosofiskest': ('filosofisk',),
'filosofiskeste': ('filosofisk',),
'filthåra': ('filthåra',),
'filthårede': ('filthåret',),
'filthåret': ('filthåret',),
'filthårete': ('filthåret',),
'filthåretere': ('filthåret',),
'filthåretest': ('filthåret',),
'filthåreteste': ('filthåret',),
'filtra': ('filtre',),
'filtrede': ('filtre',),
'filtrende': ('filtre',),
'filtret': ('filtre',),
'filtrete': ('filtre',),
'filtrerende': ('filtrere',),
'filtrert': ('filtrere',),
'filtrerte': ('filtrere',),
'fin': ('fin',),
'fine': ('fin',),
'finere': ('fin',),
'finest': ('fin',),
'fineste': ('fin',),
'fint': ('fin',),
'final': ('final',),
'finale': ('final',),
'finalere': ('final',),
'finalest': ('final',),
'finaleste': ('final',),
'finalt': ('final',),
'finansiell': ('finansiell',),
'finansielle': ('finansiell',),
'finansiellere': ('finansiell',),
'finansiellest': ('finansiell',),
'finansielleste': ('finansiell',),
'finansielt': ('finansiell',),
'finansierende': ('finansiere',),
'finansiert': ('finansiere',),
'finansierte': ('finansiere',),
'finerende': ('finere',),
'finert': ('finere',),
'finerte': ('finere',),
'finfin': ('finfin',),
'finfine': ('finfin',),
'finfinere': ('finfin',),
'finfinest': ('finfin',),
'finfineste': ('finfin',),
'finfint': ('finfin',),
'finfordelende': ('finfordele',),
'finfordelt': ('finfordele',),
'finfordelte': ('finfordele',),
'finfølende': ('finfølende',),
'fingerende': ('fingere',),
'fingert': ('fingere',),
'fingerte': ('fingere',),
'fingerferdig': ('fingerferdig',),
'fingerferdige': ('fingerferdig',),
'fingerferdigere': ('fingerferdig',),
'fingerferdigst': ('fingerferdig',),
'fingerferdigste': ('fingerferdig',),
'fingernem': ('fingernem',),
'fingernemme': ('fingernem',),
'fingernemmere': ('fingernem',),
'fingernemmest': ('fingernem',),
'fingernemmeste': ('fingernem',),
'fingernemt': ('fingernem',),
'fingert': ('fingert',),
'fingerte': ('fingert',),
'fingertere': ('fingert',),
'fingertest': ('fingert',),
'fingerteste': ('fingert',),
'fingra': ('fingra',),
'fingra': ('fingre',),
'fingrede': ('fingre',),
'fingrende': ('fingre',),
'fingret': ('fingre',),
'fingrete': ('fingre',),
'fingrede': ('fingret',),
'fingret': ('fingret',),
'fingrete': ('fingret',),
'fingretere': ('fingret',),
'fingretest': ('fingret',),
'fingreteste': ('fingret',),
'finhakka': ('finhakke',),
'finhakkede': ('finhakke',),
'finhakkende': ('finhakke',),
'finhakket': ('finhakke',),
'finhakkete': ('finhakke',),
'finhøvla': ('finhøvle',),
'finhøvlede': ('finhøvle',),
'finhøvlende': ('finhøvle',),
'finhøvlet': ('finhøvle',),
'finhøvlete': ('finhøvle',),
'fininnstillende': ('fininnstille',),
'fininnstilt': ('fininnstille',),
'fininnstilte': ('fininnstille',),
'finitt': ('finitt',),
'finitte': ('finitt',),
'finittere': ('finitt',),
'finittest': ('finitt',),
'finitteste': ('finitt',),
'finkjemma': ('finkjemme',),
'finkjemmede': ('finkjemme',),
'finkjemmende': ('finkjemme',),
'finkjemmet': ('finkjemme',),
'finkjemmete': ('finkjemme',),
'finkjemt': ('finkjemme',),
'finkjemte': ('finkjemme',),
'finkorna': ('finkorna',),
'finkornede': ('finkornet',),
'finkornet': ('finkornet',),
'finkornete': ('finkornet',),
'finkornetere': ('finkornet',),
'finkornetest': ('finkornet',),
'finkorneteste': ('finkornet',),
'finlandsk': ('finlandsk',),
'finlandske': ('finlandsk',),
'finlandskere': ('finlandsk',),
'finlandskest': ('finlandsk',),
'finlandskeste': ('finlandsk',),
'finmalende': ('finmale',),
'finmalt': ('finmale',),
'finmalte': ('finmale',),
'finmaska': ('finmaska',),
'finmaskede': ('finmasket',),
'finmasket': ('finmasket',),
'finmaskete': ('finmasket',),
'finmasketere': ('finmasket',),
'finmasketest': ('finmasket',),
'finmasketeste': ('finmasket',),
'finnende': ('finne',),
'funne': ('finne',),
'funnen': ('finne',),
'funnet': ('finne',),
'finnet': ('finnet',),
'finnete': ('finnet',),
'finnetere': ('finnet',),
'finnetest': ('finnet',),
'finneteste': ('finnet',),
'finnete': ('finnete',),
'finpussa': ('finpusse',),
'finpussede': ('finpusse',),
'finpussende': ('finpusse',),
'finpusset': ('finpusse',),
'finpussete': ('finpusse',),
'finsikta': ('finsikte',),
'finsiktede': ('finsikte',),
'finsiktende': ('finsikte',),
'finsiktet': ('finsikte',),
'finsiktete': ('finsikte',),
'finsk': ('finsk',),
'finske': ('finsk',),
'finskere': ('finsk',),
'finskest': ('finsk',),
'finskeste': ('finsk',),
'finsk-ugrisk': ('finsk-ugrisk',),
'finsk-ugriske': ('finsk-ugrisk',),
'finsk-ugriskere': ('finsk-ugrisk',),
'finsk-ugriskest': ('finsk-ugrisk',),
'finsk-ugriskeste': ('finsk-ugrisk',),
'finskåren': ('finskåren',),
'finskåret': ('finskåren',),
'finskårne': ('finskåren',),
'finskårnere': ('finskåren',),
'finskårnest': ('finskåren',),
'finskårneste': ('finskåren',),
'finskåret': ('finskåret',),
'finskårne': ('finskåret',),
'finskårnere': ('finskåret',),
'finskårnest': ('finskåret',),
'finskårneste': ('finskåret',),
'finstilt': ('finstilt',),
'finstilte': ('finstilt',),
'finstiltere': ('finstilt',),
'finstiltest': ('finstilt',),
'finstilteste': ('finstilt',),
'finta': ('finte',),
'fintede': ('finte',),
'fintende': ('finte',),
'fintet': ('finte',),
'fintete': ('finte',),
'fintalt': ('fintelle',),
'fintalte': ('fintelle',),
'fintella': ('fintelle',),
'fintellede': ('fintelle',),
'fintellende': ('fintelle',),
'fintellet': ('fintelle',),
'fintellete': ('fintelle',),
'fintelt': ('fintelle',),
'fintelte': ('fintelle',),
'fintfølende': ('fintfølende',),
'finurlig': ('finurlig',),
'finurlige': ('finurlig',),
'finurligere': ('finurlig',),
'finurligst': ('finurlig',),
'finurligste': ('finurlig',),
'fiolblå': ('fiolblå',),
'fiolblåe': ('fiolblå',),
'fiolblåere': ('fiolblå',),
'fiolblåest': ('fiolblå',),
'fiolblåeste': ('fiolblå',),
'fiolblått': ('fiolblå',),
'fiolett': ('fiolett',),
'fiolette': ('fiolett',),
'fiolettere': ('fiolett',),
'fiolettest': ('fiolett',),
'fioletteste': ('fiolett',),
'firbeint': ('firbeint',),
'firbeinte': ('firbeint',),
'firbeintere': ('firbeint',),
'firbeintest': ('firbeint',),
'firbeinteste': ('firbeint',),
'firbent': ('firbent',),
'firbente': ('firbent',),
'firbentere': ('firbent',),
'firbentest': ('firbent',),
'firbenteste': ('firbent',),
'firblada': ('firblada',),
'firbladede': ('firbladet',),
'firbladet': ('firbladet',),
'firbladete': ('firbladet',),
'firbladetere': ('firbladet',),
'firbladetest': ('firbladet',),
'firbladeteste': ('firbladet',),
'firdelt': ('firdelt',),
'firdelte': ('firdelt',),
'firdeltere': ('firdelt',),
'firdeltest': ('firdelt',),
'firdelteste': ('firdelt',),
'firdobbel': ('firdobbel',),
'firdobbelt': ('firdobbel',),
'firdoble': ('firdobbel',),
'firdoblere': ('firdobbel',),
'firdoblest': ('firdobbel',),
'firdobleste': ('firdobbel',),
'firdobbelt': ('firdobbelt',),
'firdobbelte': ('firdobbelt',),
'firdobbeltere': ('firdobbelt',),
'firdobbeltest': ('firdobbelt',),
'firdobbelteste': ('firdobbelt',),
'firdobla': ('firdoble',),
'firdoblede': ('firdoble',),
'firdoblende': ('firdoble',),
'firdoblet': ('firdoble',),
'firdoblete': ('firdoble',),
'fira': ('fire',),
'firede': ('fire',),
'firende': ('fire',),
'firet': ('fire',),
'firete': ('fire',),
'firt': ('fire',),
'firte': ('fire',),
'firebeint': ('firebeint',),
'firebeinte': ('firebeint',),
'firebeintere': ('firebeint',),
'firebeintest': ('firebeint',),
'firebeinteste': ('firebeint',),
'firebent': ('firebent',),
'firebente': ('firebent',),
'firebentere': ('firebent',),
'firebentest': ('firebent',),
'firebenteste': ('firebent',),
'fireblada': ('fireblada',),
'firebladede': ('firebladet',),
'firebladet': ('firebladet',),
'firebladete': ('firebladet',),
'firebladetere': ('firebladet',),
'firebladetest': ('firebladet',),
'firebladeteste': ('firebladet',),
'firedelt': ('firedelt',),
'firedelte': ('firedelt',),
'firedeltere': ('firedelt',),
'firedeltest': ('firedelt',),
'firedelteste': ('firedelt',),
'firedimensjonal': ('firedimensjonal',),
'firedimensjonale': ('firedimensjonal',),
'firedimensjonalere': ('firedimensjonal',),
'firedimensjonalest': ('firedimensjonal',),
'firedimensjonaleste': ('firedimensjonal',),
'firedimensjonalt': ('firedimensjonal',),
'firedobbel': ('firedobbel',),
'firedobbelt': ('firedobbel',),
'firedoble': ('firedobbel',),
'firedoblere': ('firedobbel',),
'firedoblest': ('firedobbel',),
'firedobleste': ('firedobbel',),
'firedobbelt': ('firedobbelt',),
'firedobbelte': ('firedobbelt',),
'firedobbeltere': ('firedobbelt',),
'firedobbeltest': ('firedobbelt',),
'firedobbelteste': ('firedobbelt',),
'firedobla': ('firedoble',),
'firedoblede': ('firedoble',),
'firedoblende': ('firedoble',),
'firedoblet': ('firedoble',),
'firedoblete': ('firedoble',),
'fireetasjes': ('fireetasjes',),
'firefelta': ('firefelta',),
'firefeltede': ('firefeltet',),
'firefeltet': ('firefeltet',),
'firefeltete': ('firefeltet',),
'firefeltetere': ('firefeltet',),
'firefeltetest': ('firefeltet',),
'firefelteteste': ('firefeltet',),
'firefelts': ('firefelts',),
'firefota': ('firefota',),
'firefotede': ('firefotet',),
'firefotet': ('firefotet',),
'firefotete': ('firefotet',),
'firefotetere': ('firefotet',),
'firefotetest': ('firefotet',),
'firefoteteste': ('firefotet',),
'fireføtt': ('fireføtt',),
'fireføtte': ('fireføtt',),
'fireføttere': ('fireføtt',),
'fireføttest': ('fireføtt',),
'fireføtteste': ('fireføtt',),
'firehendig': ('firehendig',),
'firehendige': ('firehendig',),
'firehendigere': ('firehendig',),
'firehendigst': ('firehendig',),
'firehendigste': ('firehendig',),
'firehjuls': ('firehjuls',),
'fireliters': ('fireliters',),
'firemasta': ('firemasta',),
'firemastede': ('firemastet',),
'firemastet': ('firemastet',),
'firemastete': ('firemastet',),
'firemastetere': ('firemastet',),
'firemastetest': ('firemastet',),
'firemasteteste': ('firemastet',),
'fireroms': ('fireroms',),
'firesifra': ('firesifra',),
'firesifrede': ('firesifret',),
'firesifret': ('firesifret',),
'firesifrete': ('firesifret',),
'firesifretere': ('firesifret',),
'firesifretest': ('firesifret',),
'firesifreteste': ('firesifret',),
'firesylindra': ('firesylindra',),
'firesylindrede': ('firesylindret',),
'firesylindret': ('firesylindret',),
'firesylindrete': ('firesylindret',),
'firesylindretere': ('firesylindret',),
'firesylindretest': ('firesylindret',),
'firesylindreteste': ('firesylindret',),
'firetoms': ('firetoms',),
'fireårig': ('fireårig',),
'fireårige': ('fireårig',),
'fireårigere': ('fireårig',),
'fireårigst': ('fireårig',),
'fireårigste': ('fireårig',),
'fireårs': ('fireårs',),
'firfota': ('firfota',),
'firfotede': ('firfotet',),
'firfotet': ('firfotet',),
'firfotete': ('firfotet',),
'firfotetere': ('firfotet',),
'firfotetest': ('firfotet',),
'firfoteteste': ('firfotet',),
'firføtt': ('firføtt',),
'firføtte': ('firføtt',),
'firføttere': ('firføtt',),
'firføttest': ('firføtt',),
'firføtteste': ('firføtt',),
'firhendig': ('firhendig',),
'firhendige': ('firhendig',),
'firhendigere': ('firhendig',),
'firhendigst': ('firhendig',),
'firhendigste': ('firhendig',),
'firhjuls': ('firhjuls',),
'firkanta': ('firkanta',),
'firkantede': ('firkantet',),
'firkantet': ('firkantet',),
'firkantete': ('firkantet',),
'firkantetere': ('firkantet',),
'firkantetest': ('firkantet',),
'firkanteteste': ('firkantet',),
'firmasta': ('firmasta',),
'firmastede': ('firmastet',),
'firmastet': ('firmastet',),
'firmastete': ('firmastet',),
'firmastetere': ('firmastet',),
'firmastetest': ('firmastet',),
'firmasteteste': ('firmastet',),
'firsifra': ('firsifra',),
'firsifrede': ('firsifret',),
'firsifret': ('firsifret',),
'firsifrete': ('firsifret',),
'firsifretere': ('firsifret',),
'firsifretest': ('firsifret',),
'firsifreteste': ('firsifret',),
'firskåren': ('firskåren',),
'firskåret': ('firskåren',),
'firskårne': ('firskåren',),
'firskårnere': ('firskåren',),
'firskårnest': ('firskåren',),
'firskårneste': ('firskåren',),
'firskåren': ('firskåren',),
'firskårent': ('firskåren',),
'firskårne': ('firskåren',),
'firskårnere': ('firskåren',),
'firskårnest': ('firskåren',),
'firskårneste': ('firskåren',),
'firskåret': ('firskåret',),
'firskårne': ('firskåret',),
'firskårnere': ('firskåret',),
'firskårnest': ('firskåret',),
'firskårneste': ('firskåret',),
'firstrøken': ('firstrøken',),
'firstrøket': ('firstrøken',),
'firstrøkne': ('firstrøken',),
'firstrøknere': ('firstrøken',),
'firstrøknest': ('firstrøken',),
'firstrøkneste': ('firstrøken',),
'firstrøket': ('firstrøket',),
'firstrøkne': ('firstrøket',),
'firstrøknere': ('firstrøket',),
'firstrøknest': ('firstrøket',),
'firstrøkneste': ('firstrøket',),
'firtoms': ('firtoms',),
'fisblid': ('fisblid',),
'fisblide': ('fisblid',),
'fisblidere': ('fisblid',),
'fisblidest': ('fisblid',),
'fisblideste': ('fisblid',),
'fisblidt': ('fisblid',),
'fesen': ('fise',),
'feset': ('fise',),
'fesne': ('fise',),
'fisende': ('fise',),
'fist': ('fise',),
'fiste': ('fise',),
'fiseblid': ('fiseblid',),
'fiseblide': ('fiseblid',),
'fiseblidere': ('fiseblid',),
'fiseblidest': ('fiseblid',),
'fiseblideste': ('fiseblid',),
'fiseblidt': ('fiseblid',),
'fisefin': ('fisefin',),
'fisefine': ('fisefin',),
'fisefinere': ('fisefin',),
'fisefinest': ('fisefin',),
'fisefineste': ('fisefin',),
'fisefint': ('fisefin',),
'fisefornem': ('fisefornem',),
'fisefornemme': ('fisefornem',),
'fisefornemmere': ('fisefornem',),
'fisefornemmest': ('fisefornem',),
'fisefornemmeste': ('fisefornem',),
'fisefornemt': ('fisefornem',),
'fisfin': ('fisfin',),
'fisfine': ('fisfin',),
'fisfinere': ('fisfin',),
'fisfinest': ('fisfin',),
'fisfineste': ('fisfin',),
'fisfint': ('fisfin',),
'fisfornem': ('fisfornem',),
'fisfornemme': ('fisfornem',),
'fisfornemmere': ('fisfornem',),
'fisfornemmest': ('fisfornem',),
'fisfornemmeste': ('fisfornem',),
'fisfornemt': ('fisfornem',),
'fisjonerende': ('fisjonere',),
'fisjonert': ('fisjonere',),
'fisjonerte': ('fisjonere',),
'fiskal': ('fiskal',),
'fiskale': ('fiskal',),
'fiskalere': ('fiskal',),
'fiskalest': ('fiskal',),
'fiskaleste': ('fiskal',),
'fiskalt': ('fiskal',),
'fiska': ('fiske',),
'fiskede': ('fiske',),
'fiskende': ('fiske',),
'fisket': ('fiske',),
'fiskete': ('fiske',),
'fiska': ('fiske',),
'fiskede': ('fiske',),
'fiskende': ('fiske',),
'fisket': ('fiske',),
'fiskete': ('fiske',),
'fiska': ('fiske',),
'fiskede': ('fiske',),
'fiskende': ('fiske',),
'fisket': ('fiske',),
'fiskete': ('fiske',),
'fisla': ('fisle',),
'fislede': ('fisle',),
'fislende': ('fisle',),
'fislet': ('fisle',),
'fislete': ('fisle',),
'fissil': ('fissil',),
'fissile': ('fissil',),
'fissilere': ('fissil',),
'fissilest': ('fissil',),
'fissileste': ('fissil',),
'fissilt': ('fissil',),
'fjamsa': ('fjamse',),
'fjamsede': ('fjamse',),
'fjamsende': ('fjamse',),
'fjamset': ('fjamse',),
'fjamsete': ('fjamse',),
'fjasa': ('fjase',),
'fjasede': ('fjase',),
'fjasende': ('fjase',),
'fjaset': ('fjase',),
'fjasete': ('fjase',),
'fjast': ('fjase',),
'fjaste': ('fjase',),
'fjaset': ('fjaset',),
'fjasete': ('fjaset',),
'fjasetere': ('fjaset',),
'fjasetest': ('fjaset',),
'fjaseteste': ('fjaset',),
'fjasete': ('fjasete',),
'fjelg': ('fjelg',),
'fjelge': ('fjelg',),
'fjelgere': ('fjelg',),
'fjelgest': ('fjelg',),
'fjelgeste': ('fjelg',),
'fjelgt': ('fjelg',),
'fjelga': ('fjelge',),
'fjelgede': ('fjelge',),
'fjelgende': ('fjelge',),
'fjelget': ('fjelge',),
'fjelgete': ('fjelge',),
'fjerde': ('fjerde',),
'fjern': ('fjern',),
'fjerne': ('fjern',),
'fjernere': ('fjern',),
'fjernest': ('fjern',),
'fjerneste': ('fjern',),
'fjernt': ('fjern',),
'fjerna': ('fjerne',),
'fjernede': ('fjerne',),
'fjernende': ('fjerne',),
'fjernet': ('fjerne',),
'fjernete': ('fjerne',),
'fjernstyrende': ('fjernstyre',),
'fjernstyrt': ('fjernstyre',),
'fjernstyrte': ('fjernstyre',),
'fjernstyrt': ('fjernstyrt',),
'fjernstyrte': ('fjernstyrt',),
'fjernstyrtere': ('fjernstyrt',),
'fjernstyrtest': ('fjernstyrt',),
'fjernstyrteste': ('fjernstyrt',),
'fjerta': ('fjerte',),
'fjertede': ('fjerte',),
'fjertende': ('fjerte',),
'fjertet': ('fjerte',),
'fjertete': ('fjerte',),
'fjeska': ('fjeske',),
'fjeskede': ('fjeske',),
'fjeskende': ('fjeske',),
'fjesket': ('fjeske',),
'fjeskete': ('fjeske',),
'fjetra': ('fjetre',),
'fjetrede': ('fjetre',),
'fjetrende': ('fjetre',),
'fjetret': ('fjetre',),
'fjetrete': ('fjetre',),
'fjolla': ('fjolle',),
'fjollede': ('fjolle',),
'fjollende': ('fjolle',),
'fjollet': ('fjolle',),
'fjollete': ('fjolle',),
'fjollet': ('fjollet',),
'fjollete': ('fjollet',),
'fjolletere': ('fjollet',),
'fjolletest': ('fjollet',),
'fjolleteste': ('fjollet',),
'fjollete': ('fjollete',),
'fjong': ('fjong',),
'fjonge': ('fjong',),
'fjongere': ('fjong',),
'fjongest': ('fjong',),
'fjongeste': ('fjong',),
'fjongt': ('fjong',),
'fjoreldre': ('fjorgammal',),
'fjoreldst': ('fjorgammal',),
'fjoreldste': ('fjorgammal',),
'fjorgamle': ('fjorgammal',),
'fjorgammal': ('fjorgammal',),
'fjorgammalt': ('fjorgammal',),
'fjoreldre': ('fjorgammel',),
'fjoreldst': ('fjorgammel',),
'fjoreldste': ('fjorgammel',),
'fjorgamle': ('fjorgammel',),
'fjorgammel': ('fjorgammel',),
'fjorgammelt': ('fjorgammel',),
'fjortende': ('fjortende',),
'fjortenårig': ('fjortenårig',),
'fjortenårige': ('fjortenårig',),
'fjortenårigere': ('fjortenårig',),
'fjortenårigst': ('fjortenårig',),
'fjortenårigste': ('fjortenårig',),
'fjortenårs': ('fjortenårs',),
'fjottet': ('fjottet',),
'fjottete': ('fjottet',),
'fjottetere': ('fjottet',),
'fjottetest': ('fjottet',),
'fjotteteste': ('fjottet',),
'fjottete': ('fjottete',),
'fjuska': ('fjuske',),
'fjuskede': ('fjuske',),
'fjuskende': ('fjuske',),
'fjusket': ('fjuske',),
'fjuskete': ('fjuske',),
'fjæra': ('fjære',),
'fjærede': ('fjære',),
'fjærende': ('fjære',),
'fjæret': ('fjære',),
'fjærete': ('fjære',),
'fjæra': ('fjære',),
'fjærede': ('fjære',),
'fjærende': ('fjære',),
'fjæret': ('fjære',),
'fjærete': ('fjære',),
'fjæret': ('fjæret',),
'fjærete': ('fjæret',),
'fjæretere': ('fjæret',),
'fjæretest': ('fjæret',),
'fjæreteste': ('fjæret',),
'fjærete': ('fjærete',),
'fjærlett': ('fjærlett',),
'fjærlette': ('fjærlett',),
'fjærlettere': ('fjærlett',),
'fjærlettest': ('fjærlett',),
'fjærletteste': ('fjærlett',),
'fjøra': ('fjøre',),
'fjørede': ('fjøre',),
'fjørende': ('fjøre',),
'fjøret': ('fjøre',),
'fjørete': ('fjøre',),
'fjøret': ('fjøret',),
'fjørete': ('fjøret',),
'fjøretere': ('fjøret',),
'fjøretest': ('fjøret',),
'fjøreteste': ('fjøret',),
'fjørete': ('fjørete',),
'fjørlett': ('fjørlett',),
'fjørlette': ('fjørlett',),
'fjørlettere': ('fjørlett',),
'fjørlettest': ('fjørlett',),
'fjørletteste': ('fjørlett',),
'flagga': ('flagge',),
'flaggede': ('flagge',),
'flaggende': ('flagge',),
'flagget': ('flagge',),
'flaggete': ('flagge',),
'flagrant': ('flagrant',),
'flagrante': ('flagrant',),
'flagrantere': ('flagrant',),
'flagrantest': ('flagrant',),
'flagranteste': ('flagrant',),
'flagra': ('flagre',),
'flagrede': ('flagre',),
'flagrende': ('flagre',),
'flagret': ('flagre',),
'flagrete': ('flagre',),
'flaka': ('flake',),
'flakede': ('flake',),
'flakende': ('flake',),
'flaket': ('flake',),
'flakete': ('flake',),
'flakt': ('flake',),
'flakte': ('flake',),
'flakk': ('flakk',),
'flakke': ('flakk',),
'flakkere': ('flakk',),
'flakkest': ('flakk',),
'flakkeste': ('flakk',),
'flakt': ('flakk',),
'flakka': ('flakke',),
'flakkede': ('flakke',),
'flakkende': ('flakke',),
'flakket': ('flakke',),
'flakkete': ('flakke',),
'flakna': ('flakne',),
'flaknede': ('flakne',),
'flaknende': ('flakne',),
'flaknet': ('flakne',),
'flaknete': ('flakne',),
'flaksa': ('flakse',),
'flaksede': ('flakse',),
'flaksende': ('flakse',),
'flakset': ('flakse',),
'flaksete': ('flakse',),
'flamberende': ('flambere',),
'flambert': ('flambere',),
'flamberte': ('flambere',),
'flamma': ('flamme',),
'flammede': ('flamme',),
'flammende': ('flamme',),
'flammet': ('flamme',),
'flammete': ('flamme',),
'flammende': ('flammende',),
'flammesikker': ('flammesikker',),
'flammesikkert': ('flammesikker',),
'flammesikre': ('flammesikker',),
'flammesikrere': ('flammesikker',),
'flammesikrest': ('flammesikker',),
'flammesikreste': ('flammesikker',),
'flammet': ('flammet',),
'flammete': ('flammet',),
'flammetere': ('flammet',),
'flammetest': ('flammet',),
'flammeteste': ('flammet',),
'flammete': ('flammete',),
'flamsk': ('flamsk',),
'flamske': ('flamsk',),
'flamskere': ('flamsk',),
'flamskest': ('flamsk',),
'flamskeste': ('flamsk',),
'flamsktalende': ('flamsktalende',),
'flana': ('flane',),
'flanede': ('flane',),
'flanende': ('flane',),
'flanet': ('flane',),
'flanete': ('flane',),
'flant': ('flane',),
'flante': ('flane',),
'flanerende': ('flanere',),
'flanert': ('flanere',),
'flanerte': ('flanere',),
'flankerende': ('flankere',),
'flankert': ('flankere',),
'flankerte': ('flankere',),
'flara': ('flare',),
'flarede': ('flare',),
'flarende': ('flare',),
'flaret': ('flare',),
'flarete': ('flare',),
'flart': ('flare',),
'flarte': ('flare',),
'flaska': ('flaske',),
'flaskede': ('flaske',),
'flaskende': ('flaske',),
'flasket': ('flaske',),
'flaskete': ('flaske',),
'flaska': ('flaske',),
'flaskede': ('flaske',),
'flaskende': ('flaske',),
'flasket': ('flaske',),
'flaskete': ('flaske',),
'flaskegrøn': ('flaskegrøn',),
'flaskegrøne': ('flaskegrøn',),
'flaskegrønere': ('flaskegrøn',),
'flaskegrønest': ('flaskegrøn',),
'flaskegrøneste': ('flaskegrøn',),
'flaskegrønt': ('flaskegrøn',),
'flaskegrønn': ('flaskegrønn',),
'flaskegrønne': ('flaskegrønn',),
'flaskegrønnere': ('flaskegrønn',),
'flaskegrønnest': ('flaskegrønn',),
'flaskegrønneste': ('flaskegrønn',),
'flaskegrønt': ('flaskegrønn',),
'flassa': ('flasse',),
'flassede': ('flasse',),
'flassende': ('flasse',),
'flasset': ('flasse',),
'flassete': ('flasse',),
'flasset': ('flasset',),
'flassete': ('flasset',),
'flassetere': ('flasset',),
'flassetest': ('flasset',),
'flasseteste': ('flasset',),
'flassete': ('flassete',),
'flat': ('flat',),
'flate': ('flat',),
'flatere': ('flat',),
'flatest': ('flat',),
'flateste': ('flat',),
'flatt': ('flat',),
'flatbotna': ('flatbotna',),
'flatbotnede': ('flatbotnet',),
'flatbotnet': ('flatbotnet',),
'flatbotnete': ('flatbotnet',),
'flatbotnetere': ('flatbotnet',),
'flatbotnetest': ('flatbotnet',),
'flatbotneteste': ('flatbotnet',),
'flatbrysta': ('flatbrysta',),
'flatbrystede': ('flatbrystet',),
'flatbrystet': ('flatbrystet',),
'flatbrystete': ('flatbrystet',),
'flatbrystetere': ('flatbrystet',),
'flatbrystetest': ('flatbrystet',),
'flatbrysteteste': ('flatbrystet',),
'flatbunna': ('flatbunna',),
'flatbunnede': ('flatbunnet',),
'flatbunnet': ('flatbunnet',),
'flatbunnete': ('flatbunnet',),
'flatbunnetere': ('flatbunnet',),
'flatbunnetest': ('flatbunnet',),
'flatbunneteste': ('flatbunnet',),
'flata': ('flate',),
'flatede': ('flate',),
'flatende': ('flate',),
'flatet': ('flate',),
'flatete': ('flate',),
'flatklemt': ('flatklemt',),
'flatklemte': ('flatklemt',),
'flatklemtere': ('flatklemt',),
'flatklemtest': ('flatklemt',),
'flatklemteste': ('flatklemt',),
'flatlendt': ('flatlendt',),
'flatlendte': ('flatlendt',),
'flatlendtere': ('flatlendt',),
'flatlendtest': ('flatlendt',),
'flatlendteste': ('flatlendt',),
'flatna': ('flatne',),
'flatnede': ('flatne',),
'flatnende': ('flatne',),
'flatnet': ('flatne',),
'flatnete': ('flatne',),
'flatterende': ('flattere',),
'flattert': ('flattere',),
'flatterte': ('flattere',),
'flatterende': ('flatterende',),
'flattrykt': ('flattrykt',),
'flattrykte': ('flattrykt',),
'flattryktere': ('flattrykt',),
'flattryktest': ('flattrykt',),
'flattrykteste': ('flattrykt',),
'flau': ('flau',),
'flaue': ('flau',),
'flauere': ('flau',),
'flauest': ('flau',),
'flaueste': ('flau',),
'flaut': ('flau',),
'flautt': ('flau',),
'flaua': ('flaue',),
'flauede': ('flaue',),
'flauende': ('flaue',),
'flauet': ('flaue',),
'flauete': ('flaue',),
'flegmatisk': ('flegmatisk',),
'flegmatiske': ('flegmatisk',),
'flegmatiskere': ('flegmatisk',),
'flegmatiskest': ('flegmatisk',),
'flegmatiskeste': ('flegmatisk',),
'fleinskalla': ('fleinskalla',),
'fleinskallede': ('fleinskallet',),
'fleinskallet': ('fleinskallet',),
'fleinskallete': ('fleinskallet',),
'fleinskalletere': ('fleinskallet',),
'fleinskalletest': ('fleinskallet',),
'fleinskalleteste': ('fleinskallet',),
'fleipa': ('fleipe',),
'fleipede': ('fleipe',),
'fleipende': ('fleipe',),
'fleipet': ('fleipe',),
'fleipete': ('fleipe',),
'fleipt': ('fleipe',),
'fleipte': ('fleipe',),
'fleipet': ('fleipet',),
'fleipete': ('fleipet',),
'fleipetere': ('fleipet',),
'fleipetest': ('fleipet',),
'fleipeteste': ('fleipet',),
'fleipete': ('fleipete',),
'flekka': ('flekke',),
'flekkede': ('flekke',),
'flekkende': ('flekke',),
'flekket': ('flekke',),
'flekkete': ('flekke',),
'flekka': ('flekke',),
'flekkede': ('flekke',),
'flekkende': ('flekke',),
'flekket': ('flekke',),
'flekkete': ('flekke',),
'flekt': ('flekke',),
'flekte': ('flekke',),
'flekket': ('flekket',),
'flekkete': ('flekket',),
'flekketere': ('flekket',),
'flekketest': ('flekket',),
'flekketeste': ('flekket',),
'flekkete': ('flekkete',),
'fleksa': ('flekse',),
'fleksede': ('flekse',),
'fleksende': ('flekse',),
'flekset': ('flekse',),
'fleksete': ('flekse',),
'fleksibel': ('fleksibel',),
'fleksibelt': ('fleksibel',),
'fleksible': ('fleksibel',),
'fleksiblere': ('fleksibel',),
'fleksiblest': ('fleksibel',),
'fleksibleste': ('fleksibel',),
'flekterende': ('flektere',),
'flektert': ('flektere',),
'flekterte': ('flektere',),
'flenga': ('flenge',),
'flengede': ('flenge',),
'flengende': ('flenge',),
'flenget': ('flenge',),
'flengete': ('flenge',),
'flengt': ('flenge',),
'flengte': ('flenge',),
'flengende': ('flengende',),
'flensa': ('flense',),
'flensede': ('flense',),
'flensende': ('flense',),
'flenset': ('flense',),
'flensete': ('flense',),
'flensa': ('flense',),
'flensede': ('flense',),
'flensende': ('flense',),
'flenset': ('flense',),
'flensete': ('flense',),
'flerbo': ('flerbo',),
'flerbu': ('flerbu',),
'flercella': ('flercella',),
'flercellede': ('flercellet',),
'flercellet': ('flercellet',),
'flercellete': ('flercellet',),
'flercelletere': ('flercellet',),
'flercelletest': ('flercellet',),
'flercelleteste': ('flercellet',),
'flerdobbel': ('flerdobbel',),
'flerdobbelt': ('flerdobbel',),
'flerdoble': ('flerdobbel',),
'flerdoblere': ('flerdobbel',),
'flerdoblest': ('flerdobbel',),
'flerdobleste': ('flerdobbel',),
'flerdobbelt': ('flerdobbelt',),
'flerdobbelte': ('flerdobbelt',),
'flerdobbeltere': ('flerdobbelt',),
'flerdobbeltest': ('flerdobbelt',),
'flerdobbelteste': ('flerdobbelt',),
'flerdobla': ('flerdoble',),
'flerdoblede': ('flerdoble',),
'flerdoblende': ('flerdoble',),
'flerdoblet': ('flerdoble',),
'flerdoblete': ('flerdoble',),
'flerfargede': ('flerfarget',),
'flerfarget': ('flerfarget',),
'flerfargete': ('flerfarget',),
'flerfargetere': ('flerfarget',),
'flerfargetest': ('flerfarget',),
'flerfargeteste': ('flerfarget',),
'flerfasa': ('flerfasa',),
'flerfasede': ('flerfaset',),
'flerfaset': ('flerfaset',),
'flerfasete': ('flerfaset',),
'flerfasetere': ('flerfaset',),
'flerfasetest': ('flerfaset',),
'flerfaseteste': ('flerfaset',),
'flerfoldig': ('flerfoldig',),
'flerfoldige': ('flerfoldig',),
'flerfoldigere': ('flerfoldig',),
'flerfoldigst': ('flerfoldig',),
'flerfoldigste': ('flerfoldig',),
'flernasjonal': ('flernasjonal',),
'flernasjonale': ('flernasjonal',),
'flernasjonalere': ('flernasjonal',),
'flernasjonalest': ('flernasjonal',),
'flernasjonaleste': ('flernasjonal',),
'flernasjonalt': ('flernasjonal',),
'flersida': ('flersida',),
'flersidede': ('flersidet',),
'flersidet': ('flersidet',),
'flersidete': ('flersidet',),
'flersidetere': ('flersidet',),
'flersidetest': ('flersidet',),
'flersideteste': ('flersidet',),
'flersidig': ('flersidig',),
'flersidige': ('flersidig',),
'flersidigere': ('flersidig',),
'flersidigst': ('flersidig',),
'flersidigste': ('flersidig',),
'flersifra': ('flersifra',),
'flersifrede': ('flersifret',),
'flersifret': ('flersifret',),
'flersifrete': ('flersifret',),
'flersifretere': ('flersifret',),
'flersifretest': ('flersifret',),
'flersifreteste': ('flersifret',),
'flerspråklig': ('flerspråklig',),
'flerspråklige': ('flerspråklig',),
'flerspråkligere': ('flerspråklig',),
'flerspråkligst': ('flerspråklig',),
'flerspråkligste': ('flerspråklig',),
'flerstemmig': ('flerstemmig',),
'flerstemmige': ('flerstemmig',),
'flerstemmigere': ('flerstemmig',),
'flerstemmigst': ('flerstemmig',),
'flerstemmigste': ('flerstemmig',),
'flerstemt': ('flerstemt',),
'flerstemte': ('flerstemt',),
'flerstemtere': ('flerstemt',),
'flerstemtest': ('flerstemt',),
'flerstemteste': ('flerstemt',),
'flertydig': ('flertydig',),
'flertydige': ('flertydig',),
'flertydigere': ('flertydig',),
'flertydigst': ('flertydig',),
'flertydigste': ('flertydig',),
'flerverdig': ('flerverdig',),
'flerverdige': ('flerverdig',),
'flerverdigere': ('flerverdig',),
'flerverdigst': ('flerverdig',),
'flerverdigste': ('flerverdig',),
'flerårig': ('flerårig',),
'flerårige': ('flerårig',),
'flerårigere': ('flerårig',),
'flerårigst': ('flerårig',),
'flerårigste': ('flerårig',),
'flesket': ('flesket',),
'fleskete': ('flesket',),
'flesketere': ('flesket',),
'flesketest': ('flesket',),
'flesketeste': ('flesket',),
'fleskete': ('fleskete',),
'fletta': ('flette',),
'flettede': ('flette',),
'flettende': ('flette',),
'flettet': ('flette',),
'flettete': ('flette',),
'fletta': ('flette',),
'flettede': ('flette',),
'flettende': ('flette',),
'flettet': ('flette',),
'flettete': ('flette',),
'flidd': ('fli',),
'flidde': ('fli',),
'fliende': ('fli',),
'flidd': ('flidd',),
'flidde': ('flidd',),
'fliddere': ('flidd',),
'fliddest': ('flidd',),
'fliddeste': ('flidd',),
'fliket': ('fliket',),
'flikete': ('fliket',),
'fliketere': ('fliket',),
'fliketest': ('fliket',),
'fliketeste': ('fliket',),
'flikete': ('flikete',),
'flikka': ('flikke',),
'flikkede': ('flikke',),
'flikkende': ('flikke',),
'flikket': ('flikke',),
'flikkete': ('flikke',),
'flimra': ('flimre',),
'flimrede': ('flimre',),
'flimrende': ('flimre',),
'flimret': ('flimre',),
'flimrete': ('flimre',),
'flink': ('flink',),
'flinke': ('flink',),
'flinkere': ('flink',),
'flinkest': ('flink',),
'flinkeste': ('flink',),
'flinkt': ('flink',),
'flinthard': ('flinthard',),
'flintharde': ('flinthard',),
'flinthardere': ('flinthard',),
'flinthardest': ('flinthard',),
'flinthardeste': ('flinthard',),
'flinthardt': ('flinthard',),
'flintskalla': ('flintskalla',),
'flintskallede': ('flintskallet',),
'flintskallet': ('flintskallet',),
'flintskallete': ('flintskallet',),
'flintskalletere': ('flintskallet',),
'flintskalletest': ('flintskallet',),
'flintskalleteste': ('flintskallet',),
'flippa': ('flippe',),
'flippede': ('flippe',),
'flippende': ('flippe',),
'flippet': ('flippe',),
'flippete': ('flippe',),
'flirende': ('flire',),
'flirt': ('flire',),
'flirte': ('flire',),
'flisbelagt': ('flisbelagt',),
'flisbelagte': ('flisbelagt',),
'flisbelagtere': ('flisbelagt',),
'flisbelagtest': ('flisbelagt',),
'flisbelagteste': ('flisbelagt',),
'flisa': ('flise',),
'flisede': ('flise',),
'flisende': ('flise',),
'fliset': ('flise',),
'flisete': ('flise',),
'flist': ('flise',),
'fliste': ('flise',),
'flisebelagt': ('flisebelagt',),
'flisebelagte': ('flisebelagt',),
'flisebelagtere': ('flisebelagt',),
'flisebelagtest': ('flisebelagt',),
'flisebelagteste': ('flisebelagt',),
'fliselagt': ('fliselagt',),
'fliselagte': ('fliselagt',),
'fliselagtere': ('fliselagt',),
'fliselagtest': ('fliselagt',),
'fliselagteste': ('fliselagt',),
'fliselagt': ('fliselegge',),
'fliselagte': ('fliselegge',),
'fliseleggende': ('fliselegge',),
'fliset': ('fliset',),
'flisete': ('fliset',),
'flisetere': ('fliset',),
'flisetest': ('fliset',),
'fliseteste': ('fliset',),
'flisete': ('flisete',),
'flislagt': ('flislagt',),
'flislagte': ('flislagt',),
'flislagtere': ('flislagt',),
'flislagtest': ('flislagt',),
'flislagteste': ('flislagt',),
'flislagt': ('flislegge',),
'flislagte': ('flislegge',),
'flisleggende': ('flislegge',),
'flittig': ('flittig',),
'flittige': ('flittig',),
'flittigere': ('flittig',),
'flittigst': ('flittig',),
'flittigste': ('flittig',),
'floka': ('floke',),
'flokede': ('floke',),
'flokende': ('floke',),
'floket': ('floke',),
'flokete': ('floke',),
'floket': ('floket',),
'flokete': ('floket',),
'floketere': ('floket',),
'floketest': ('floket',),
'floketeste': ('floket',),
'flokete': ('flokete',),
'flokka': ('flokke',),
'flokkede': ('flokke',),
'flokkende': ('flokke',),
'flokket': ('flokke',),
'flokkete': ('flokke',),
'floksa': ('flokse',),
'floksede': ('flokse',),
'floksende': ('flokse',),
'flokset': ('flokse',),
'floksete': ('flokse',),
'flomherja': ('flomherja',),
'flomherjede': ('flomherjet',),
'flomherjet': ('flomherjet',),
'flomherjete': ('flomherjet',),
'flomherjetere': ('flomherjet',),
'flomherjetest': ('flomherjet',),
'flomherjeteste': ('flomherjet',),
'flomma': ('flomme',),
'flommede': ('flomme',),
'flommende': ('flomme',),
'flommet': ('flomme',),
'flommete': ('flomme',),
'floppa': ('floppe',),
'floppede': ('floppe',),
'floppende': ('floppe',),
'floppet': ('floppe',),
'floppete': ('floppe',),
'floppa': ('floppe',),
'floppede': ('floppe',),
'floppende': ('floppe',),
'floppet': ('floppe',),
'floppete': ('floppe',),
'floragraferende': ('floragrafere',),
'floragrafert': ('floragrafere',),
'floragraferte': ('floragrafere',),
'florentinsk': ('florentinsk',),
'florentinske': ('florentinsk',),
'florentinskere': ('florentinsk',),
'florentinskest': ('florentinsk',),
'florentinskeste': ('florentinsk',),
'florerende': ('florere',),
'florert': ('florere',),
'florerte': ('florere',),
'florisant': ('florisant',),
'florisante': ('florisant',),
'florisantere': ('florisant',),
'florisantest': ('florisant',),
'florisanteste': ('florisant',),
'florlett': ('florlett',),
'florlette': ('florlett',),
'florlettere': ('florlett',),
'florlettest': ('florlett',),
'florletteste': ('florlett',),
'floromvundet': ('floromvundet',),
'floromvundne': ('floromvundet',),
'floromvundnere': ('floromvundet',),
'floromvundnest': ('floromvundet',),
'floromvundneste': ('floromvundet',),
'flotta': ('flotte',),
'flottede': ('flotte',),
'flottende': ('flotte',),
'flottet': ('flotte',),
'flottete': ('flotte',),
'fluid': ('fluid',),
'fluide': ('fluid',),
'fluidere': ('fluid',),
'fluidest': ('fluid',),
'fluideste': ('fluid',),
'flukta': ('flukte',),
'fluktede': ('flukte',),
'fluktende': ('flukte',),
'fluktet': ('flukte',),
'fluktete': ('flukte',),
'fluktsikker': ('fluktsikker',),
'fluktsikkert': ('fluktsikker',),
'fluktsikre': ('fluktsikker',),
'fluktsikrere': ('fluktsikker',),
'fluktsikrest': ('fluktsikker',),
'fluktsikreste': ('fluktsikker',),
'fluktuerende': ('fluktuere',),
'fluktuert': ('fluktuere',),
'fluktuerte': ('fluktuere',),
'fluorescerende': ('fluorescere',),
'fluorescert': ('fluorescere',),
'fluorescerte': ('fluorescere',),
'fluoriderende': ('fluoridere',),
'fluoridert': ('fluoridere',),
'fluoriderte': ('fluoridere',),
'fluoriserende': ('fluorisere',),
'fluorisert': ('fluorisere',),
'fluoriserte': ('fluorisere',),
'flydd': ('fly',),
'flydde': ('fly',),
'flyende': ('fly',),
'fløyen': ('fly',),
'fløyet': ('fly',),
'fløyne': ('fly',),
'flybåren': ('flybåren',),
'flybåret': ('flybåren',),
'flybårne': ('flybåren',),
'flybårnere': ('flybåren',),
'flybårnest': ('flybåren',),
'flybårneste': ('flybåren',),
'flybåret': ('flybåret',),
'flybårne': ('flybåret',),
'flybårnere': ('flybåret',),
'flybårnest': ('flybåret',),
'flybårneste': ('flybåret',),
'flydyktig': ('flydyktig',),
'flydyktige': ('flydyktig',),
'flydyktigere': ('flydyktig',),
'flydyktigst': ('flydyktig',),
'flydyktigste': ('flydyktig',),
'flyende': ('flyende',),
'flyferdig': ('flyferdig',),
'flyferdige': ('flyferdig',),
'flyferdigere': ('flyferdig',),
'flyferdigst': ('flyferdig',),
'flyferdigste': ('flyferdig',),
'flydd': ('flyge',),
'flydde': ('flyge',),
'flygende': ('flyge',),
'fløyen': ('flyge',),
'fløyet': ('flyge',),
'fløyne': ('flyge',),
'flygedyktig': ('flygedyktig',),
'flygedyktige': ('flygedyktig',),
'flygedyktigere': ('flygedyktig',),
'flygedyktigst': ('flygedyktig',),
'flygedyktigste': ('flygedyktig',),
'flygeferdig': ('flygeferdig',),
'flygeferdige': ('flygeferdig',),
'flygeferdigere': ('flygeferdig',),
'flygeferdigst': ('flygeferdig',),
'flygeferdigste': ('flygeferdig',),
'flygende': ('flygende',),
'flykta': ('flykte',),
'flyktede': ('flykte',),
'flyktende': ('flykte',),
'flyktet': ('flykte',),
'flyktete': ('flykte',),
'flyktig': ('flyktig',),
'flyktige': ('flyktig',),
'flyktigere': ('flyktig',),
'flyktigst': ('flyktig',),
'flyktigste': ('flyktig',),
'flytende': ('flyte',),
'flytt': ('flyte',),
'flytte': ('flyte',),
'flytende': ('flytende',),
'flyttbar': ('flyttbar',),
'flyttbare': ('flyttbar',),
'flyttbarere': ('flyttbar',),
'flyttbarest': ('flyttbar',),
'flyttbareste': ('flyttbar',),
'flyttbart': ('flyttbar',),
'flytta': ('flytte',),
'flyttede': ('flytte',),
'flyttende': ('flytte',),
'flyttet': ('flytte',),
'flyttete': ('flytte',),
'flådd': ('flå',),
'flådde': ('flå',),
'flående': ('flå',),
'flå': ('flå',),
'flåe': ('flå',),
'flåere': ('flå',),
'flåest': ('flå',),
'flåeste': ('flå',),
'flått': ('flå',),
'flåkjefta': ('flåkjefta',),
'flåkjeftede': ('flåkjeftet',),
'flåkjeftet': ('flåkjeftet',),
'flåkjeftete': ('flåkjeftet',),
'flåkjeftetere': ('flåkjeftet',),
'flåkjeftetest': ('flåkjeftet',),
'flåkjefteteste': ('flåkjeftet',),
'flåsende': ('flåse',),
'flåst': ('flåse',),
'flåste': ('flåse',),
'flåset': ('flåset',),
'flåsete': ('flåset',),
'flåsetere': ('flåset',),
'flåsetest': ('flåset',),
'flåseteste': ('flåset',),
'flåsete': ('flåsete',),
'flædd': ('flæ',),
'flædde': ('flæ',),
'flæende': ('flæ',),
'flæra': ('flære',),
'flærede': ('flære',),
'flærende': ('flære',),
'flæret': ('flære',),
'flærete': ('flære',),
'flødd': ('flø',),
'flødde': ('flø',),
'fløende': ('flø',),
'fløkende': ('fløke',),
'fløkt': ('fløke',),
'fløkte': ('fløke',),
'flømma': ('flømme',),
'flømmede': ('flømme',),
'flømmende': ('flømme',),
'flømmet': ('flømme',),
'flømmete': ('flømme',),
'flømt': ('flømme',),
'flømte': ('flømme',),
'flørta': ('flørte',),
'flørtede': ('flørte',),
'flørtende': ('flørte',),
'flørtet': ('flørte',),
'flørtete': ('flørte',),
'fløta': ('fløte',),
'fløtede': ('fløte',),
'fløtende': ('fløte',),
'fløtet': ('fløte',),
'fløtete': ('fløte',),
'fløtt': ('fløte',),
'fløtte': ('fløte',),
'fløyta': ('fløyte',),
'fløytede': ('fløyte',),
'fløytende': ('fløyte',),
'fløytet': ('fløyte',),
'fløytete': ('fløyte',),
'fløyta': ('fløyte',),
'fløytede': ('fløyte',),
'fløytende': ('fløyte',),
'fløytet': ('fløyte',),
'fløytete': ('fløyte',),
'fløytt': ('fløyte',),
'fløytte': ('fløyte',),
'fnisende': ('fnise',),
'fnist': ('fnise',),
'fniste': ('fnise',),
'fniset': ('fniset',),
'fnisete': ('fniset',),
'fnisetere': ('fniset',),
'fnisetest': ('fniset',),
'fniseteste': ('fniset',),
'fnisete': ('fnisete',),
'fnugglett': ('fnugglett',),
'fnugglette': ('fnugglett',),
'fnugglettere': ('fnugglett',),
'fnugglettest': ('fnugglett',),
'fnuggletteste': ('fnugglett',),
'fnysende': ('fnyse',),
'fnyst': ('fnyse',),
'fnyste': ('fnyse',),
'fnysende': ('fnysende',),
'fokal': ('fokal',),
'fokale': ('fokal',),
'fokalere': ('fokal',),
'fokalest': ('fokal',),
'fokaleste': ('fokal',),
'fokalt': ('fokal',),
'fokuserende': ('fokusere',),
'fokusert': ('fokusere',),
'fokuserte': ('fokusere',),
'folda': ('folde',),
'foldede': ('folde',),
'foldende': ('folde',),
'foldet': ('folde',),
'foldete': ('folde',),
'fola': ('fole',),
'folede': ('fole',),
'folende': ('fole',),
'folet': ('fole',),
'folete': ('fole',),
'folierende': ('foliere',),
'foliert': ('foliere',),
'folierte': ('foliere',),
'folka': ('folke',),
'folkede': ('folke',),
'folkende': ('folke',),
'folket': ('folke',),
'folkete': ('folke',),
'folkelig': ('folkelig',),
'folkelige': ('folkelig',),
'folkeligere': ('folkelig',),
'folkeligst': ('folkelig',),
'folkeligste': ('folkelig',),
'folkevalgt': ('folkevalgt',),
'folkevalgte': ('folkevalgt',),
'folkevalgtere': ('folkevalgt',),
'folkevalgtest': ('folkevalgt',),
'folkevalgteste': ('folkevalgt',),
'folkeverre': ('folkevond',),
'folkeverst': ('folkevond',),
'folkeverste': ('folkevond',),
'folkevond': ('folkevond',),
'folkevonde': ('folkevond',),
'folkevondere': ('folkevond',),
'folkevondest': ('folkevond',),
'folkevondeste': ('folkevond',),
'folkevondt': ('folkevond',),
'folkloristisk': ('folkloristisk',),
'folkloristiske': ('folkloristisk',),
'folkloristiskere': ('folkloristisk',),
'folkloristiskest': ('folkloristisk',),
'folkloristiskeste': ('folkloristisk',),
'folksom': ('folksom',),
'folksomme': ('folksom',),
'folksommere': ('folksom',),
'folksomst': ('folksom',),
'folksomste': ('folksom',),
'folksomt': ('folksom',),
'folla': ('folle',),
'follede': ('folle',),
'follende': ('folle',),
'follet': ('folle',),
'follete': ('folle',),
'follrik': ('follrik',),
'follrike': ('follrik',),
'follrikere': ('follrik',),
'follrikest': ('follrik',),
'follrikeste': ('follrik',),
'follrikt': ('follrik',),
'folna': ('folne',),
'folnede': ('folne',),
'folnende': ('folne',),
'folnet': ('folne',),
'folnete': ('folne',),
'fomla': ('fomle',),
'fomlede': ('fomle',),
'fomlende': ('fomle',),
'fomlet': ('fomle',),
'fomlete': ('fomle',),
'fonetisk': ('fonetisk',),
'fonetiske': ('fonetisk',),
'fonetiskere': ('fonetisk',),
'fonetiskest': ('fonetisk',),
'fonetiskeste': ('fonetisk',),
'fonna': ('fonne',),
'fonnede': ('fonne',),
'fonnende': ('fonne',),
'fonnet': ('fonne',),
'fonnete': ('fonne',),
'fonnet': ('fonnet',),
'fonnete': ('fonnet',),
'fonnetere': ('fonnet',),
'fonnetest': ('fonnet',),
'fonneteste': ('fonnet',),
'fonnete': ('fonnete',),
'fonologisk': ('fonologisk',),
'fonologiske': ('fonologisk',),
'fonologiskere': ('fonologisk',),
'fonologiskest': ('fonologisk',),
'fonologiskeste': ('fonologisk',),
'forakta': ('forakte',),
'foraktede': ('forakte',),
'foraktende': ('forakte',),
'foraktet': ('forakte',),
'foraktete': ('forakte',),
'foraktelig': ('foraktelig',),
'foraktelige': ('foraktelig',),
'forakteligere': ('foraktelig',),
'forakteligst': ('foraktelig',),
'forakteligste': ('foraktelig',),
'foranderlig': ('foranderlig',),
'foranderlige': ('foranderlig',),
'foranderligere': ('foranderlig',),
'foranderligst': ('foranderlig',),
'foranderligste': ('foranderlig',),
'forandra': ('forandre',),
'forandrede': ('forandre',),
'forandrende': ('forandre',),
'forandret': ('forandre',),
'forandrete': ('forandre',),
'forankra': ('forankre',),
'forankrede': ('forankre',),
'forankrende': ('forankre',),
'forankret': ('forankre',),
'forankrete': ('forankre',),
'foranlediga': ('foranledige',),
'foranledigede': ('foranledige',),
'foranledigende': ('foranledige',),
'foranlediget': ('foranledige',),
'foranledigete': ('foranledige',),
'forannevnt': ('forannevnt',),
'forannevnte': ('forannevnt',),
'forannevntere': ('forannevnt',),
'forannevntest': ('forannevnt',),
'forannevnteste': ('forannevnt',),
'foranstalta': ('foranstalte',),
'foranstaltede': ('foranstalte',),
'foranstaltende': ('foranstalte',),
'foranstaltet': ('foranstalte',),
'foranstaltete': ('foranstalte',),
'foranstilt': ('foranstilt',),
'foranstilte': ('foranstilt',),
'foranstiltere': ('foranstilt',),
'foranstiltest': ('foranstilt',),
'foranstilteste': ('foranstilt',),
'forarbeida': ('forarbeide',),
'forarbeidd': ('forarbeide',),
'forarbeidde': ('forarbeide',),
'forarbeidede': ('forarbeide',),
'forarbeidende': ('forarbeide',),
'forarbeidet': ('forarbeide',),
'forarbeidete': ('forarbeide',),
'forarga': ('forarge',),
'forargede': ('forarge',),
'forargende': ('forarge',),
'forarget': ('forarge',),
'forargete': ('forarge',),
'forargelig': ('forargelig',),
'forargelige': ('forargelig',),
'forargeligere': ('forargelig',),
'forargeligst': ('forargelig',),
'forargeligste': ('forargelig',),
'forarma': ('forarme',),
'forarmede': ('forarme',),
'forarmende': ('forarme',),
'forarmet': ('forarme',),
'forarmete': ('forarme',),
'forbanna': ('forbanna',),
'forbanna': ('forbanne',),
'forbannede': ('forbanne',),
'forbannende': ('forbanne',),
'forbannet': ('forbanne',),
'forbannete': ('forbanne',),
'forbant': ('forbanne',),
'forbante': ('forbanne',),
'forbannede': ('forbannet',),
'forbannet': ('forbannet',),
'forbannete': ('forbannet',),
'forbannetere': ('forbannet',),
'forbannetest': ('forbannet',),
'forbanneteste': ('forbannet',),
'forbarma': ('forbarme',),
'forbarmede': ('forbarme',),
'forbarmende': ('forbarme',),
'forbarmet': ('forbarme',),
'forbarmete': ('forbarme',),
'forbaska': ('forbaska',),
'forbaskede': ('forbasket',),
'forbasket': ('forbasket',),
'forbaskete': ('forbasket',),
'forbasketere': ('forbasket',),
'forbasketest': ('forbasket',),
'forbasketeste': ('forbasket',),
'forbausa': ('forbause',),
'forbausede': ('forbause',),
'forbausende': ('forbause',),
'forbauset': ('forbause',),
'forbausete': ('forbause',),
'forbedra': ('forbedre',),
'forbedrede': ('forbedre',),
'forbedrende': ('forbedre',),
'forbedret': ('forbedre',),
'forbedrete': ('forbedre',),
'forbeholdende': ('forbeholde',),
'forbeholdt': ('forbeholde',),
'forbeholdte': ('forbeholde',),
'forbeholden': ('forbeholden',),
'forbeholdent': ('forbeholden',),
'forbeholdne': ('forbeholden',),
'forbeholdnere': ('forbeholden',),
'forbeholdnest': ('forbeholden',),
'forbeholdneste': ('forbeholden',),
'forbeina': ('forbeine',),
'forbeinede': ('forbeine',),
'forbeinende': ('forbeine',),
'forbeinet': ('forbeine',),
'forbeinete': ('forbeine',),
'forbena': ('forbene',),
'forbenede': ('forbene',),
'forbenende': ('forbene',),
'forbenet': ('forbene',),
'forbenete': ('forbene',),
'forberedende': ('forberede',),
'forberedt': ('forberede',),
'forberedte': ('forberede',),
'forberedende': ('forberedende',),
'forberedt': ('forberedt',),
'forberedte': ('forberedt',),
'forberedtere': ('forberedt',),
'forberedtest': ('forberedt',),
'forberedteste': ('forberedt',),
'forbigående': ('forbigå',),
'forbigått': ('forbigå',),
'forbigåtte': ('forbigå',),
'forbigående': ('forbigående',),
'forbilledlig': ('forbilledlig',),
'forbilledlige': ('forbilledlig',),
'forbilledligere': ('forbilledlig',),
'forbilledligst': ('forbilledlig',),
'forbilledligste': ('forbilledlig',),
'forbindende': ('forbinde',),
'forbunden': ('forbinde',),
'forbundet': ('forbinde',),
'forbundne': ('forbinde',),
'forbindtlig': ('forbindtlig',),
'forbindtlige': ('forbindtlig',),
'forbindtligere': ('forbindtlig',),
'forbindtligst': ('forbindtlig',),
'forbindtligste': ('forbindtlig',),
'forbipasserende': ('forbipasserende',),
'forbistra': ('forbistra',),
'forbistrede': ('forbistret',),
'forbistret': ('forbistret',),
'forbistrete': ('forbistret',),
'forbistretere': ('forbistret',),
'forbistretest': ('forbistret',),
'forbistreteste': ('forbistret',),
'forbitra': ('forbitra',),
'forbitra': ('forbitre',),
'forbitrede': ('forbitre',),
'forbitrende': ('forbitre',),
'forbitret': ('forbitre',),
'forbitrete': ('forbitre',),
'forbitrede': ('forbitret',),
'forbitret': ('forbitret',),
'forbitrete': ('forbitret',),
'forbitretere': ('forbitret',),
'forbitretest': ('forbitret',),
'forbitreteste': ('forbitret',),
'forblenda': ('forblende',),
'forblendede': ('forblende',),
'forblendende': ('forblende',),
'forblendet': ('forblende',),
'forblendete': ('forblende',),
'forblitt': ('forbli',),
'forblitte': ('forbli',),
'forblivende': ('forbli',),
'forblinda': ('forblinde',),
'forblindede': ('forblinde',),
'forblindende': ('forblinde',),
'forblindet': ('forblinde',),
'forblindete': ('forblinde',),
'forblomma': ('forblomma',),
'forblommede': ('forblommet',),
'forblommet': ('forblommet',),
'forblommete': ('forblommet',),
'forblommetere': ('forblommet',),
'forblommetest': ('forblommet',),
'forblommeteste': ('forblommet',),
'forblåst': ('forblåst',),
'forblåste': ('forblåst',),
'forblåstere': ('forblåst',),
'forblåstest': ('forblåst',),
'forblåsteste': ('forblåst',),
'forblødd': ('forblø',),
'forblødde': ('forblø',),
'forbløende': ('forblø',),
'forbløffa': ('forbløffe',),
'forbløffede': ('forbløffe',),
'forbløffende': ('forbløffe',),
'forbløffet': ('forbløffe',),
'forbløffete': ('forbløffe',),
'forbløffende': ('forbløffende',),
'forborgen': ('forborgen',),
'forborgent': ('forborgen',),
'forborgne': ('forborgen',),
'forborgnere': ('forborgen',),
'forborgnest': ('forborgen',),
'forborgneste': ('forborgen',),
'forbrukende': ('forbruke',),
'forbrukt': ('forbruke',),
'forbrukte': ('forbruke',),
'forbrukervennlig': ('forbrukervennlig',),
'forbrukervennlige': ('forbrukervennlig',),
'forbrukervennligere': ('forbrukervennlig',),
'forbrukervennligst': ('forbrukervennlig',),
'forbrukervennligste': ('forbrukervennlig',),
'forbrutt': ('forbryte',),
'forbrutte': ('forbryte',),
'forbrytende': ('forbryte',),
'forbrytersk': ('forbrytersk',),
'forbryterske': ('forbrytersk',),
'forbryterskere': ('forbrytersk',),
'forbryterskest': ('forbrytersk',),
'forbryterskeste': ('forbrytersk',),
'forbuden': ('forbuden',),
'forbudent': ('forbuden',),
'forbudne': ('forbuden',),
'forbudnere': ('forbuden',),
'forbudnest': ('forbuden',),
'forbudneste': ('forbuden',),
'forbudt': ('forbudt',),
'forbudte': ('forbudt',),
'forbudtere': ('forbudt',),
'forbudtest': ('forbudt',),
'forbudteste': ('forbudt',),
'forbundsvis': ('forbundsvis',),
'forbundsvise': ('forbundsvis',),
'forbundsvisere': ('forbundsvis',),
'forbundsvisest': ('forbundsvis',),
'forbundsviseste': ('forbundsvis',),
'forbundsvist': ('forbundsvis',),
'forbudt': ('forby',),
'forbudte': ('forby',),
'forbydd': ('forby',),
'forbydde': ('forby',),
'forbyende': ('forby',),
'forbytta': ('forbytte',),
'forbyttede': ('forbytte',),
'forbyttende': ('forbytte',),
'forbyttet': ('forbytte',),
'forbyttete': ('forbytte',),
'fordampa': ('fordampe',),
'fordampede': ('fordampe',),
'fordampende': ('fordampe',),
'fordampet': ('fordampe',),
'fordampete': ('fordampe',),
'fordanska': ('fordanske',),
'fordanskede': ('fordanske',),
'fordanskende': ('fordanske',),
'fordansket': ('fordanske',),
'fordanskete': ('fordanske',),
'fordekt': ('fordekt',),
'fordekte': ('fordekt',),
'fordektere': ('fordekt',),
'fordektest': ('fordekt',),
'fordekteste': ('fordekt',),
'fordektig': ('fordektig',),
'fordektige': ('fordektig',),
'fordektigere': ('fordektig',),
'fordektigst': ('fordektig',),
'fordektigste': ('fordektig',),
'fordelaktig': ('fordelaktig',),
'fordelaktige': ('fordelaktig',),
'fordelaktigere': ('fordelaktig',),
'fordelaktigst': ('fordelaktig',),
'fordelaktigste': ('fordelaktig',),
'fordelende': ('fordele',),
'fordelt': ('fordele',),
'fordelte': ('fordele',),
'forderva': ('forderve',),
'fordervede': ('forderve',),
'fordervende': ('forderve',),
'fordervet': ('forderve',),
'fordervete': ('forderve',),
'fordervelig': ('fordervelig',),
'fordervelige': ('fordervelig',),
'forderveligere': ('fordervelig',),
'forderveligst': ('fordervelig',),
'forderveligste': ('fordervelig',),
'fordjupa': ('fordjupe',),
'fordjupede': ('fordjupe',),
'fordjupende': ('fordjupe',),
'fordjupet': ('fordjupe',),
'fordjupete': ('fordjupe',),
'fordobla': ('fordoble',),
'fordoblede': ('fordoble',),
'fordoblende': ('fordoble',),
'fordoblet': ('fordoble',),
'fordoblete': ('fordoble',),
'fordomsfull': ('fordomsfull',),
'fordomsfulle': ('fordomsfull',),
'fordomsfullere': ('fordomsfull',),
'fordomsfullest': ('fordomsfull',),
'fordomsfulleste': ('fordomsfull',),
'fordomsfullt': ('fordomsfull',),
'fordomslaus': ('fordomslaus',),
'fordomslause': ('fordomslaus',),
'fordomslausere': ('fordomslaus',),
'fordomslausest': ('fordomslaus',),
'fordomslauseste': ('fordomslaus',),
'fordomslaust': ('fordomslaus',),
'fordomsløs': ('fordomsløs',),
'fordomsløse': ('fordomsløs',),
'fordomsløsere': ('fordomsløs',),
'fordomsløsest': ('fordomsløs',),
'fordomsløseste': ('fordomsløs',),
'fordomsløst': ('fordomsløs',),
'fordradd': ('fordra',),
'fordradde': ('fordra',),
'fordragende': ('fordra',),
'fordratt': ('fordra',),
'fordratte': ('fordra',),
'fordragelig': ('fordragelig',),
'fordragelige': ('fordragelig',),
'fordrageligere': ('fordragelig',),
'fordrageligst': ('fordragelig',),
'fordrageligste': ('fordragelig',),
'fordra': ('fordre',),
'fordrede': ('fordre',),
'fordrende': ('fordre',),
'fordret': ('fordre',),
'fordrete': ('fordre',),
'fordreia': ('fordreie',),
'fordreid': ('fordreie',),
'fordreidd': ('fordreie',),
'fordreidde': ('fordreie',),
'fordreide': ('fordreie',),
'fordreiede': ('fordreie',),
'fordreiende': ('fordreie',),
'fordreiet': ('fordreie',),
'fordreiete': ('fordreie',),
'fordringsfull': ('fordringsfull',),
'fordringsfulle': ('fordringsfull',),
'fordringsfullere': ('fordringsfull',),
'fordringsfullest': ('fordringsfull',),
'fordringsfulleste': ('fordringsfull',),
'fordringsfullt': ('fordringsfull',),
'fordringslaus': ('fordringslaus',),
'fordringslause': ('fordringslaus',),
'fordringslausere': ('fordringslaus',),
'fordringslausest': ('fordringslaus',),
'fordringslauseste': ('fordringslaus',),
'fordringslaust': ('fordringslaus',),
'fordringsløs': ('fordringsløs',),
'fordringsløse': ('fordringsløs',),
'fordringsløsere': ('fordringsløs',),
'fordringsløsest': ('fordringsløs',),
'fordringsløseste': ('fordringsløs',),
'fordringsløst': ('fordringsløs',),
'fordrista': ('fordriste',),
'fordristede': ('fordriste',),
'fordristende': ('fordriste',),
'fordristet': ('fordriste',),
'fordristete': ('fordriste',),
'fordreven': ('fordrive',),
'fordrevet': ('fordrive',),
'fordrevne': ('fordrive',),
'fordrivende': ('fordrive',),
'fordrukken': ('fordrukken',),
'fordrukkent': ('fordrukken',),
'fordrukne': ('fordrukken',),
'fordruknere': ('fordrukken',),
'fordruknest': ('fordrukken',),
'fordrukneste': ('fordrukken',),
'fordufta': ('fordufte',),
'forduftede': ('fordufte',),
'forduftende': ('fordufte',),
'forduftet': ('fordufte',),
'forduftete': ('fordufte',),
'fordulgt': ('fordulgt',),
'fordulgte': ('fordulgt',),
'fordulgtere': ('fordulgt',),
'fordulgtest': ('fordulgt',),
'fordulgteste': ('fordulgt',),
'fordumma': ('fordumme',),
'fordummede': ('fordumme',),
'fordummende': ('fordumme',),
'fordummet': ('fordumme',),
'fordummete': ('fordumme',),
'fordums': ('fordums',),
'fordunkla': ('fordunkle',),
'fordunklede': ('fordunkle',),
'fordunklende': ('fordunkle',),
'fordunklet': ('fordunkle',),
'fordunklete': ('fordunkle',),
'fordunsta': ('fordunste',),
'fordunstede': ('fordunste',),
'fordunstende': ('fordunste',),
'fordunstet': ('fordunste',),
'fordunstete': ('fordunste',),
'fordypa': ('fordype',),
'fordypede': ('fordype',),
'fordypende': ('fordype',),
'fordypet': ('fordype',),
'fordypete': ('fordype',),
'fordyra': ('fordyre',),
'fordyrede': ('fordyre',),
'fordyrende': ('fordyre',),
'fordyret': ('fordyre',),
'fordyrete': ('fordyre',),
'fordømmende': ('fordømme',),
'fordømt': ('fordømme',),
'fordømte': ('fordømme',),
'fordømt': ('fordømt',),
'fordømte': ('fordømt',),
'fordømtere': ('fordømt',),
'fordømtest': ('fordømt',),
'fordømteste': ('fordømt',),
'fordøya': ('fordøye',),
'fordøyd': ('fordøye',),
'fordøyde': ('fordøye',),
'fordøyede': ('fordøye',),
'fordøyende': ('fordøye',),
'fordøyet': ('fordøye',),
'fordøyete': ('fordøye',),
'fordøyelig': ('fordøyelig',),
'fordøyelige': ('fordøyelig',),
'fordøyeligere': ('fordøyelig',),
'fordøyeligst': ('fordøyelig',),
'fordøyeligste': ('fordøyelig',),
'forebragt': ('forebringe',),
'forebragte': ('forebringe',),
'forebrakt': ('forebringe',),
'forebrakte': ('forebringe',),
'forebringende': ('forebringe',),
'forebygd': ('forebygge',),
'forebygde': ('forebygge',),
'forebygga': ('forebygge',),
'forebyggede': ('forebygge',),
'forebyggende': ('forebygge',),
'forebygget': ('forebygge',),
'forebyggete': ('forebygge',),
'foredla': ('foredle',),
'foredlede': ('foredle',),
'foredlende': ('foredle',),
'foredlet': ('foredle',),
'foredlete': ('foredle',),
'foredradd': ('foredra',),
'foredradde': ('foredra',),
'foredragende': ('foredra',),
'foredratt': ('foredra',),
'foredratte': ('foredra',),
'forefallende': ('forefalle',),
'forefalt': ('forefalle',),
'forefalte': ('forefalle',),
'forefallende': ('forefallende',),
'foregiende': ('foregi',),
'foregitt': ('foregi',),
'foregitte': ('foregi',),
'foregivende': ('foregi',),
'foregrepen': ('foregripe',),
'foregrepet': ('foregripe',),
'foregrepne': ('foregripe',),
'foregripende': ('foregripe',),
'foregående': ('foregå',),
'foregått': ('foregå',),
'foregåtte': ('foregå',),
'foregående': ('foregående',),
'foreholdende': ('foreholde',),
'foreholdt': ('foreholde',),
'foreholdte': ('foreholde',),
'forekommen': ('forekomme',),
'forekommende': ('forekomme',),
'forekommet': ('forekomme',),
'forekomne': ('forekomme',),
'forekommende': ('forekommende',),
'forelda': ('forelda',),
'foreldede': ('foreldet',),
'foreldet': ('foreldet',),
'foreldete': ('foreldet',),
'foreldetere': ('foreldet',),
'foreldetest': ('foreldet',),
'foreldeteste': ('foreldet',),
'foreldrelaus': ('foreldrelaus',),
'foreldrelause': ('foreldrelaus',),
'foreldrelausere': ('foreldrelaus',),
'foreldrelausest': ('foreldrelaus',),
'foreldrelauseste': ('foreldrelaus',),
'foreldrelaust': ('foreldrelaus',),
'foreldreløs': ('foreldreløs',),
'foreldreløse': ('foreldreløs',),
'foreldreløsere': ('foreldreløs',),
'foreldreløsest': ('foreldreløs',),
'foreldreløseste': ('foreldreløs',),
'foreldreløst': ('foreldreløs',),
'forelagt': ('forelegge',),
'forelagte': ('forelegge',),
'foreleggende': ('forelegge',),
'forelesende': ('forelese',),
'forelest': ('forelese',),
'foreleste': ('forelese',),
'foreliggen': ('foreligge',),
'foreliggende': ('foreligge',),
'foreligget': ('foreligge',),
'foreligne': ('foreligge',),
'forelska': ('forelska',),
'forelska': ('forelske',),
'forelskede': ('forelske',),
'forelskende': ('forelske',),
'forelsket': ('forelske',),
'forelskete': ('forelske',),
'forelskede': ('forelsket',),
'forelsket': ('forelsket',),
'forelskete': ('forelsket',),
'forelsketere': ('forelsket',),
'forelsketest': ('forelsket',),
'forelsketeste': ('forelsket',),
'foreløpig': ('foreløpig',),
'foreløpige': ('foreløpig',),
'foreløpigere': ('foreløpig',),
'foreløpigst': ('foreløpig',),
'foreløpigste': ('foreløpig',),
'forena': ('forene',),
'forenede': ('forene',),
'forenende': ('forene',),
'forenet': ('forene',),
'forenete': ('forene',),
'forent': ('forene',),
'forente': ('forene',),
'forena': ('forene',),
'forenede': ('forene',),
'forenende': ('forene',),
'forenet': ('forene',),
'forenete': ('forene',),
'forent': ('forene',),
'forente': ('forene',),
'forenelig': ('forenelig',),
'forenelige': ('forenelig',),
'foreneligere': ('forenelig',),
'foreneligst': ('forenelig',),
'foreneligste': ('forenelig',),
'forenkla': ('forenkle',),
'forenklede': ('forenkle',),
'forenklende': ('forenkle',),
'forenklet': ('forenkle',),
'forenklete': ('forenkle',),
'forenlig': ('forenlig',),
'forenlige': ('forenlig',),
'forenligere': ('forenlig',),
'forenligst': ('forenlig',),
'forenligste': ('forenlig',),
'foresatt': ('foresatt',),
'foresatte': ('foresatt',),
'foresattere': ('foresatt',),
'foresattest': ('foresatt',),
'foresatteste': ('foresatt',),
'foresatt': ('foresette',),
'foresatte': ('foresette',),
'foresettende': ('foresette',),
'foresagt': ('foresi',),
'foresagte': ('foresi',),
'foresiende': ('foresi',),
'foreskreven': ('foreskrive',),
'foreskrevet': ('foreskrive',),
'foreskrevne': ('foreskrive',),
'foreskrivende': ('foreskrive',),
'foreslående': ('foreslå',),
'foreslått': ('foreslå',),
'foreslåtte': ('foreslå',),
'forespeila': ('forespeile',),
'forespeilede': ('forespeile',),
'forespeilende': ('forespeile',),
'forespeilet': ('forespeile',),
'forespeilete': ('forespeile',),
'forespeilt': ('forespeile',),
'forespeilte': ('forespeile',),
'forespurt': ('forespørre',),
'forespurte': ('forespørre',),
'forespørrende': ('forespørre',),
'forestillende': ('forestille',),
'forestilt': ('forestille',),
'forestilte': ('forestille',),
'forestående': ('forestå',),
'forestått': ('forestå',),
'foreståtte': ('forestå',),
'forestående': ('forestående',),
'foresveva': ('foresveve',),
'foresvevd': ('foresveve',),
'foresvevde': ('foresveve',),
'foresvevede': ('foresveve',),
'foresvevende': ('foresveve',),
'foresvevet': ('foresveve',),
'foresvevete': ('foresveve',),
'foretakende': ('foreta',),
'foretatt': ('foreta',),
'foretatte': ('foreta',),
'foretaksom': ('foretaksom',),
'foretaksomme': ('foretaksom',),
'foretaksommere': ('foretaksom',),
'foretaksommest': ('foretaksom',),
'foretaksommeste': ('foretaksom',),
'foretaksomt': ('foretaksom',),
'foretrekkende': ('foretrekke',),
'foretrukken': ('foretrekke',),
'foretrukket': ('foretrekke',),
'foretrukne': ('foretrekke',),
'foreviga': ('forevige',),
'forevigede': ('forevige',),
'forevigende': ('forevige',),
'foreviget': ('forevige',),
'forevigete': ('forevige',),
'forevisende': ('forevise',),
'forevist': ('forevise',),
'foreviste': ('forevise',),
'forfallende': ('forfalle',),
'forfalt': ('forfalle',),
'forfalte': ('forfalle',),
'forfallen': ('forfallen',),
'forfallent': ('forfallen',),
'forfalne': ('forfallen',),
'forfalnere': ('forfallen',),
'forfalnest': ('forfallen',),
'forfalneste': ('forfallen',),
'forfalska': ('forfalske',),
'forfalskede': ('forfalske',),
'forfalskende': ('forfalske',),
'forfalsket': ('forfalske',),
'forfalskete': ('forfalske',),
'forfatningsstridig': ('forfatningsstridig',),
'forfatningsstridige': ('forfatningsstridig',),
'forfatningsstridigere': ('forfatningsstridig',),
'forfatningsstridigst': ('forfatningsstridig',),
'forfatningsstridigste': ('forfatningsstridig',),
'forfatningstro': ('forfatningstro',),
'forfatningstru': ('forfatningstru',),
'forfatningstrue': ('forfatningstru',),
'forfatningstruere': ('forfatningstru',),
'forfatningstruest': ('forfatningstru',),
'forfatningstrueste': ('forfatningstru',),
'forfatta': ('forfatte',),
'forfattede': ('forfatte',),
'forfattende': ('forfatte',),
'forfattet': ('forfatte',),
'forfattete': ('forfatte',),
'forfeila': ('forfeile',),
'forfeilede': ('forfeile',),
'forfeilende': ('forfeile',),
'forfeilet': ('forfeile',),
'forfeilete': ('forfeile',),
'forfeilt': ('forfeile',),
'forfeilte': ('forfeile',),
'forfekta': ('forfekte',),
'forfektede': ('forfekte',),
'forfektende': ('forfekte',),
'forfektet': ('forfekte',),
'forfektete': ('forfekte',),
'forfengelig': ('forfengelig',),
'forfengelige': ('forfengelig',),
'forfengeligere': ('forfengelig',),
'forfengeligst': ('forfengelig',),
'forfengeligste': ('forfengelig',),
'forferda': ('forferde',),
'forferdede': ('forferde',),
'forferdende': ('forferde',),
'forferdet': ('forferde',),
'forferdete': ('forferde',),
'forferdelig': ('forferdelig',),
'forferdelige': ('forferdelig',),
'forferdeligere': ('forferdelig',),
'forferdeligst': ('forferdelig',),
'forferdeligste': ('forferdelig',),
'forferdiga': ('forferdige',),
'forferdigede': ('forferdige',),
'forferdigende': ('forferdige',),
'forferdiget': ('forferdige',),
'forferdigete': ('forferdige',),
'forfina': ('forfina',),
'forfina': ('forfine',),
'forfinede': ('forfine',),
'forfinende': ('forfine',),
'forfinet': ('forfine',),
'forfinete': ('forfine',),
'forfinede': ('forfinet',),
'forfinet': ('forfinet',),
'forfinete': ('forfinet',),
'forfinetere': ('forfinet',),
'forfinetest': ('forfinet',),
'forfineteste': ('forfinet',),
'forfjamsa': ('forfjamsa',),
'forfjamsa': ('forfjamse',),
'forfjamsede': ('forfjamse',),
'forfjamsende': ('forfjamse',),
'forfjamset': ('forfjamse',),
'forfjamsete': ('forfjamse',),
'forfjamsede': ('forfjamset',),
'forfjamset': ('forfjamset',),
'forfjamsete': ('forfjamset',),
'forfjamsetere': ('forfjamset',),
'forfjamsetest': ('forfjamset',),
'forfjamseteste': ('forfjamset',),
'forfjetra': ('forfjetra',),
'forfjetrede': ('forfjetret',),
'forfjetret': ('forfjetret',),
'forfjetrete': ('forfjetret',),
'forfjetretere': ('forfjetret',),
'forfjetretest': ('forfjetret',),
'forfjetreteste': ('forfjetret',),
'forflata': ('forflate',),
'forflatede': ('forflate',),
'forflatende': ('forflate',),
'forflatet': ('forflate',),
'forflatete': ('forflate',),
'forflera': ('forflere',),
'forflerede': ('forflere',),
'forflerende': ('forflere',),
'forfleret': ('forflere',),
'forflerete': ('forflere',),
'forflert': ('forflere',),
'forflerte': ('forflere',),
'forflytta': ('forflytte',),
'forflyttede': ('forflytte',),
'forflyttende': ('forflytte',),
'forflyttet': ('forflytte',),
'forflyttete': ('forflytte',),
'forfløyen': ('forfløyen',),
'forfløyenne': ('forfløyen',),
'forfløyennere': ('forfløyen',),
'forfløyennest': ('forfløyen',),
'forfløyenneste': ('forfløyen',),
'forfløyent': ('forfløyen',),
'forfløyne': ('forfløyen',),
'forfløynere': ('forfløyen',),
'forfløynest': ('forfløyen',),
'forfløyneste': ('forfløyen',),
'forfordelende': ('forfordele',),
'forfordelt': ('forfordele',),
'forfordelte': ('forfordele',),
'forfremma': ('forfremme',),
'forfremmede': ('forfremme',),
'forfremmende': ('forfremme',),
'forfremmet': ('forfremme',),
'forfremmete': ('forfremme',),
'forfriska': ('forfriske',),
'forfriskede': ('forfriske',),
'forfriskende': ('forfriske',),
'forfrisket': ('forfriske',),
'forfriskete': ('forfriske',),
'forfrosne': ('forfryse',),
'forfrossen': ('forfryse',),
'forfrosset': ('forfryse',),
'forfryse': ('forfryse',),
'forfrysende': ('forfryse',),
'forfylla': ('forfylla',),
'forfyllede': ('forfyllet',),
'forfyllet': ('forfyllet',),
'forfyllete': ('forfyllet',),
'forfylletere': ('forfyllet',),
'forfylletest': ('forfyllet',),
'forfylleteste': ('forfyllet',),
'forfulgt': ('forfølge',),
'forfulgte': ('forfølge',),
'forfølgende': ('forfølge',),
'forførende': ('forføre',),
'forført': ('forføre',),
'forførte': ('forføre',),
'forførerisk': ('forførerisk',),
'forføreriske': ('forførerisk',),
'forføreriskere': ('forførerisk',),
'forføreriskest': ('forførerisk',),
'forføreriskeste': ('forførerisk',),
'forførersk': ('forførersk',),
'forførerske': ('forførersk',),
'forførerskere': ('forførersk',),
'forførerskest': ('forførersk',),
'forførerskeste': ('forførersk',),
'forføya': ('forføye',),
'forføyd': ('forføye',),
'forføydd': ('forføye',),
'forføydde': ('forføye',),
'forføyde': ('forføye',),
'forføyede': ('forføye',),
'forføyende': ('forføye',),
'forføyet': ('forføye',),
'forføyete': ('forføye',),
'forgangen': ('forgangen',),
'forgangent': ('forgangen',),
'forgangne': ('forgangen',),
'forgangnere': ('forgangen',),
'forgangnest': ('forgangen',),
'forgangneste': ('forgangen',),
'forgapa': ('forgape',),
'forgapende': ('forgape',),
'forgapt': ('forgape',),
'forgapte': ('forgape',),
'forgassa': ('forgasse',),
'forgassede': ('forgasse',),
'forgassende': ('forgasse',),
'forgasset': ('forgasse',),
'forgassete': ('forgasse',),
'forgiende': ('forgi',),
'forgitt': ('forgi',),
'forgitte': ('forgi',),
'forgivende': ('forgi',),
'forgifta': ('forgifte',),
'forgiftede': ('forgifte',),
'forgiftende': ('forgifte',),
'forgiftet': ('forgifte',),
'forgiftete': ('forgifte',),
'forgjelda': ('forgjelde',),
'forgjeldede': ('forgjelde',),
'forgjeldende': ('forgjelde',),
'forgjeldet': ('forgjelde',),
'forgjeldete': ('forgjelde',),
'forgjengelig': ('forgjengelig',),
'forgjengelige': ('forgjengelig',),
'forgjengeligere': ('forgjengelig',),
'forgjengeligst': ('forgjengelig',),
'forgjengeligste': ('forgjengelig',),
'forgjeves': ('forgjeves',),
'forgjort': ('forgjøre',),
'forgjorte': ('forgjøre',),
'forgjørende': ('forgjøre',),
'forglemmende': ('forglemme',),
'forglemt': ('forglemme',),
'forglemte': ('forglemme',),
'forglømmende': ('forglømme',),
'forglømt': ('forglømme',),
'forglømte': ('forglømme',),
'forgreina': ('forgreine',),
'forgreinede': ('forgreine',),
'forgreinende': ('forgreine',),
'forgreinet': ('forgreine',),
'forgreinete': ('forgreine',),
'forgreint': ('forgreine',),
'forgreinte': ('forgreine',),
'forgremma': ('forgremma',),
'forgremmede': ('forgremmet',),
'forgremmet': ('forgremmet',),
'forgremmete': ('forgremmet',),
'forgremmetere': ('forgremmet',),
'forgremmetest': ('forgremmet',),
'forgremmeteste': ('forgremmet',),
'forgremt': ('forgremt',),
'forgremte': ('forgremt',),
'forgremtere': ('forgremt',),
'forgremtest': ('forgremt',),
'forgremteste': ('forgremt',),
'forgrena': ('forgrene',),
'forgrenede': ('forgrene',),
'forgrenende': ('forgrene',),
'forgrenet': ('forgrene',),
'forgrenete': ('forgrene',),
'forgrent': ('forgrene',),
'forgrente': ('forgrene',),
'forgrepen': ('forgripe',),
'forgrepet': ('forgripe',),
'forgrepne': ('forgripe',),
'forgripende': ('forgripe',),
'forgrova': ('forgrove',),
'forgrovede': ('forgrove',),
'forgrovende': ('forgrove',),
'forgrovet': ('forgrove',),
'forgrovete': ('forgrove',),
'forgrått': ('forgrått',),
'forgråtte': ('forgrått',),
'forgråttere': ('forgrått',),
'forgråttest': ('forgrått',),
'forgråtteste': ('forgrått',),
'forgubba': ('forgubbe',),
'forgubbede': ('forgubbe',),
'forgubbende': ('forgubbe',),
'forgubbet': ('forgubbe',),
'forgubbete': ('forgubbe',),
'forguda': ('forgude',),
'forgudede': ('forgude',),
'forgudende': ('forgude',),
'forgudet': ('forgude',),
'forgudete': ('forgude',),
'forgylla': ('forgylle',),
'forgyllede': ('forgylle',),
'forgyllende': ('forgylle',),
'forgyllet': ('forgylle',),
'forgyllete': ('forgylle',),
'forgylt': ('forgylle',),
'forgylte': ('forgylle',),
'forgående': ('forgå',),
'forgått': ('forgå',),
'forgåtte': ('forgå',),
'forhala': ('forhale',),
'forhalede': ('forhale',),
'forhalende': ('forhale',),
'forhalet': ('forhale',),
'forhalete': ('forhale',),
'forhalt': ('forhale',),
'forhalte': ('forhale',),
'forhandla': ('forhandle',),
'forhandlede': ('forhandle',),
'forhandlende': ('forhandle',),
'forhandlet': ('forhandle',),
'forhandlete': ('forhandle',),
'forhandsbestillende': ('forhandsbestille',),
'forhandsbestilt': ('forhandsbestille',),
'forhandsbestilte': ('forhandsbestille',),
'forhandsomtala': ('forhandsomtale',),
'forhandsomtalende': ('forhandsomtale',),
'forhandsomtalt': ('forhandsomtale',),
'forhandsomtalte': ('forhandsomtale',),
'forhandsstemmende': ('forhandsstemme',),
'forhandsstemt': ('forhandsstemme',),
'forhandsstemte': ('forhandsstemme',),
'forhasta': ('forhaste',),
'forhastede': ('forhaste',),
'forhastende': ('forhaste',),
'forhastet': ('forhaste',),
'forhastete': ('forhaste',),
'forhatt': ('forhatt',),
'forhatte': ('forhatt',),
'forhattere': ('forhatt',),
'forhattest': ('forhatt',),
'forhatteste': ('forhatt',),
'forheksa': ('forhekse',),
'forheksede': ('forhekse',),
'forheksende': ('forhekse',),
'forhekset': ('forhekse',),
'forheksete': ('forhekse',),
'forhenværende': ('forhenværende',),
'forherda': ('forherde',),
'forherdede': ('forherde',),
'forherdende': ('forherde',),
'forherdet': ('forherde',),
'forherdete': ('forherde',),
'forherliga': ('forherlige',),
'forherligede': ('forherlige',),
'forherligende': ('forherlige',),
'forherliget': ('forherlige',),
'forherligete': ('forherlige',),
'forhindra': ('forhindre',),
'forhindrede': ('forhindre',),
'forhindrende': ('forhindre',),
'forhindret': ('forhindre',),
'forhindrete': ('forhindre',),
'forhipne': ('forhippen',),
'forhipnere': ('forhippen',),
'forhipnest': ('forhippen',),
'forhipneste': ('forhippen',),
'forhippen': ('forhippen',),
'forhippent': ('forhippen',),
'forhistorisk': ('forhistorisk',),
'forhistoriske': ('forhistorisk',),
'forhistoriskere': ('forhistorisk',),
'forhistoriskest': ('forhistorisk',),
'forhistoriskeste': ('forhistorisk',),
'forhjulsdrevet': ('forhjulsdrevet',),
'forhjulsdrevne': ('forhjulsdrevet',),
'forhjulsdrevnere': ('forhjulsdrevet',),
'forhjulsdrevnest': ('forhjulsdrevet',),
'forhjulsdrevneste': ('forhjulsdrevet',),
'forholdende': ('forholde',),
'forholdt': ('forholde',),
'forholdte': ('forholde',),
'forholdsmessig': ('forholdsmessig',),
'forholdsmessige': ('forholdsmessig',),
'forholdsmessigere': ('forholdsmessig',),
'forholdsmessigst': ('forholdsmessig',),
'forholdsmessigste': ('forholdsmessig',),
'forhutla': ('forhutla',),
'forhutlede': ('forhutlet',),
'forhutlet': ('forhutlet',),
'forhutlete': ('forhutlet',),
'forhutletere': ('forhutlet',),
'forhutletest': ('forhutlet',),
'forhutleteste': ('forhutlet',),
'forhyrende': ('forhyre',),
'forhyrt': ('forhyre',),
'forhyrte': ('forhyre',),
'forhåndsbestillende': ('forhåndsbestille',),
'forhåndsbestilt': ('forhåndsbestille',),
'forhåndsbestilte': ('forhåndsbestille',),
'forhåndsomtala': ('forhåndsomtale',),
'forhåndsomtalende': ('forhåndsomtale',),
'forhåndsomtalt': ('forhåndsomtale',),
'forhåndsomtalte': ('forhåndsomtale',),
'forhåndsstemmende': ('forhåndsstemme',),
'forhåndsstemt': ('forhåndsstemme',),
'forhåndsstemte': ('forhåndsstemme',),
'forhåna': ('forhåne',),
'forhånede': ('forhåne',),
'forhånende': ('forhåne',),
'forhånet': ('forhåne',),
'forhånete': ('forhåne',),
'forhånt': ('forhåne',),
'forhånte': ('forhåne',),
'forhåpningsfull': ('forhåpningsfull',),
'forhåpningsfulle': ('forhåpningsfull',),
'forhåpningsfullere': ('forhåpningsfull',),
'forhåpningsfullest': ('forhåpningsfull',),
'forhåpningsfulleste': ('forhåpningsfull',),
'forhåpningsfullt': ('forhåpningsfull',),
'forhørende': ('forhøre',),
'forhørt': ('forhøre',),
'forhørte': ('forhøre',),
'forhøya': ('forhøye',),
'forhøyd': ('forhøye',),
'forhøyde': ('forhøye',),
'forhøyede': ('forhøye',),
'forhøyende': ('forhøye',),
'forhøyet': ('forhøye',),
'forhøyete': ('forhøye',),
'forivra': ('forivre',),
'forivrede': ('forivre',),
'forivrende': ('forivre',),
'forivret': ('forivre',),
'forivrete': ('forivre',),
'forjaga': ('forjaga',),
'forjagd': ('forjagd',),
'forjagde': ('forjagd',),
'forjagdere': ('forjagd',),
'forjagdest': ('forjagd',),
'forjagdeste': ('forjagd',),
'forjagede': ('forjaget',),
'forjaget': ('forjaget',),
'forjagete': ('forjaget',),
'forjagetere': ('forjaget',),
'forjagetest': ('forjaget',),
'forjageteste': ('forjaget',),
'forjetta': ('forjette',),
'forjettede': ('forjette',),
'forjettende': ('forjette',),
'forjettet': ('forjette',),
'forjettete': ('forjette',),
'forkalka': ('forkalke',),
'forkalkede': ('forkalke',),
'forkalkende': ('forkalke',),
'forkalket': ('forkalke',),
'forkalkete': ('forkalke',),
'forkasta': ('forkaste',),
'forkastede': ('forkaste',),
'forkastende': ('forkaste',),
'forkastet': ('forkaste',),
'forkastete': ('forkaste',),
'forkastelig': ('forkastelig',),
'forkastelige': ('forkastelig',),
'forkasteligere': ('forkastelig',),
'forkasteligst': ('forkastelig',),
'forkasteligste': ('forkastelig',),
'forkava': ('forkava',),
'forkavd': ('forkavd',),
'forkavde': ('forkavd',),
'forkavdere': ('forkavd',),
'forkavdest': ('forkavd',),
'forkavdeste': ('forkavd',),
'forkavede': ('forkavet',),
'forkavet': ('forkavet',),
'forkavete': ('forkavet',),
'forkavetere': ('forkavet',),
'forkavetest': ('forkavet',),
'forkaveteste': ('forkavet',),
'forkjetra': ('forkjetre',),
'forkjetrede': ('forkjetre',),
'forkjetrende': ('forkjetre',),
'forkjetret': ('forkjetre',),
'forkjetrete': ('forkjetre',),
'forkjælende': ('forkjæle',),
'forkjælt': ('forkjæle',),
'forkjælte': ('forkjæle',),
'forkjært': ('forkjært',),
'forkjærte': ('forkjært',),
'forkjærtere': ('forkjært',),
'forkjærtest': ('forkjært',),
'forkjærteste': ('forkjært',),
'forkjøla': ('forkjøle',),
'forkjølede': ('forkjøle',),
'forkjølende': ('forkjøle',),
'forkjølet': ('forkjøle',),
'forkjølete': ('forkjøle',),
'forkjølt': ('forkjøle',),
'forkjølte': ('forkjøle',),
'forkjøpende': ('forkjøpe',),
'forkjøpt': ('forkjøpe',),
'forkjøpte': ('forkjøpe',),
'forklarende': ('forklare',),
'forklart': ('forklare',),
'forklarte': ('forklare',),
'forklarede': ('forklaret',),
'forklaret': ('forklaret',),
'forklarete': ('forklaret',),
'forklaretere': ('forklaret',),
'forklaretest': ('forklaret',),
'forklareteste': ('forklaret',),
'forklarlig': ('forklarlig',),
'forklarlige': ('forklarlig',),
'forklarligere': ('forklarlig',),
'forklarligst': ('forklarlig',),
'forklarligste': ('forklarlig',),
'forkledd': ('forkle',),
'forkledde': ('forkle',),
'forkleende': ('forkle',),
'forkleina': ('forkleine',),
'forkleinede': ('forkleine',),
'forkleinende': ('forkleine',),
'forkleinet': ('forkleine',),
'forkleinete': ('forkleine',),
'forkludra': ('forkludre',),
'forkludrede': ('forkludre',),
'forkludrende': ('forkludre',),
'forkludret': ('forkludre',),
'forkludrete': ('forkludre',),
'forknytt': ('forknytt',),
'forknytte': ('forknytt',),
'forknyttere': ('forknytt',),
'forknyttest': ('forknytt',),
'forknytteste': ('forknytt',),
'forkobra': ('forkobre',),
'forkobrede': ('forkobre',),
'forkobrende': ('forkobre',),
'forkobret': ('forkobre',),
'forkobrete': ('forkobre',),
'forkommen': ('forkomme',),
'forkommende': ('forkomme',),
'forkommet': ('forkomme',),
'forkomne': ('forkomme',),
'forkommen': ('forkommen',),
'forkomment': ('forkommen',),
'forkomne': ('forkommen',),
'forkomnere': ('forkommen',),
'forkomnest': ('forkommen',),
'forkomneste': ('forkommen',),
'forkopra': ('forkopre',),
'forkoprede': ('forkopre',),
'forkoprende': ('forkopre',),
'forkopret': ('forkopre',),
'forkoprete': ('forkopre',),
'forkorta': ('forkorte',),
'forkortede': ('forkorte',),
'forkortende': ('forkorte',),
'forkortet': ('forkorte',),
'forkortete': ('forkorte',),
'forkromma': ('forkromme',),
'forkrommede': ('forkromme',),
'forkrommende': ('forkromme',),
'forkrommet': ('forkromme',),
'forkrommete': ('forkromme',),
'forkrøpla': ('forkrøpla',),
'forkrøplede': ('forkrøplet',),
'forkrøplet': ('forkrøplet',),
'forkrøplete': ('forkrøplet',),
'forkrøpletere': ('forkrøplet',),
'forkrøpletest': ('forkrøplet',),
'forkrøpleteste': ('forkrøplet',),
'forkua': ('forkue',),
'forkuede': ('forkue',),
'forkuende': ('forkue',),
'forkuet': ('forkue',),
'forkuete': ('forkue',),
'forkulla': ('forkulle',),
'forkullede': ('forkulle',),
'forkullende': ('forkulle',),
'forkullet': ('forkulle',),
'forkullete': ('forkulle',),
'forkvakla': ('forkvakle',),
'forkvaklede': ('forkvakle',),
'forkvaklende': ('forkvakle',),
'forkvaklet': ('forkvakle',),
'forkvaklete': ('forkvakle',),
'forkynnende': ('forkynne',),
'forkynt': ('forkynne',),
'forkynte': ('forkynne',),
'forlangende': ('forlange',),
'forlangt': ('forlange',),
'forlangte': ('forlange',),
'forlatende': ('forlate',),
'forlatt': ('forlate',),
'forlatte': ('forlate',),
'forlatt': ('forlatt',),
'forlatte': ('forlatt',),
'forlattere': ('forlatt',),
'forlattest': ('forlatt',),
'forlatteste': ('forlatt',),
'forleda': ('forlede',),
'forledede': ('forlede',),
'forledende': ('forlede',),
'forledet': ('forlede',),
'forledete': ('forlede',),
'forleden': ('forleden',),
'forlegen': ('forlegen',),
'forlegent': ('forlegen',),
'forlegne': ('forlegen',),
'forlegnere': ('forlegen',),
'forlegnest': ('forlegen',),
'forlegneste': ('forlegen',),
'forlagt': ('forlegge',),
'forlagte': ('forlegge',),
'forleggende': ('forlegge',),
'forlenga': ('forlenge',),
'forlengede': ('forlenge',),
'forlengende': ('forlenge',),
'forlenget': ('forlenge',),
'forlengete': ('forlenge',),
'forlesende': ('forlese',),
'forlest': ('forlese',),
'forleste': ('forlese',),
'forlibende': ('forlibe',),
'forlibt': ('forlibe',),
'forlibte': ('forlibe',),
'forlikende': ('forlike',),
'forlikt': ('forlike',),
'forlikte': ('forlike',),
'forlikelig': ('forlikelig',),
'forlikelige': ('forlikelig',),
'forlikeligere': ('forlikelig',),
'forlikeligst': ('forlikelig',),
'forlikeligste': ('forlikelig',),
'forlisende': ('forlise',),
'forlist': ('forlise',),
'forliste': ('forlise',),
'forlodds': ('forlodds',),
'forlokka': ('forlokke',),
'forlokkede': ('forlokke',),
'forlokkende': ('forlokke',),
'forlokket': ('forlokke',),
'forlokkete': ('forlokke',),
'forlokkende': ('forlokkende',),
'forloren': ('forloren',),
'forlorent': ('forloren',),
'forlorne': ('forloren',),
'forlornere': ('forloren',),
'forlornest': ('forloren',),
'forlorneste': ('forloren',),
'forlova': ('forlove',),
'forlovede': ('forlove',),
'forlovende': ('forlove',),
'forlovet': ('forlove',),
'forlovete': ('forlove',),
'forlydende': ('forlyde',),
'forlydt': ('forlyde',),
'forlydte': ('forlyde',),
'forlysta': ('forlyste',),
'forlystede': ('forlyste',),
'forlystende': ('forlyste',),
'forlystet': ('forlyste',),
'forlystete': ('forlyste',),
'forløfta': ('forløfte',),
'forløftede': ('forløfte',),
'forløftende': ('forløfte',),
'forløftet': ('forløfte',),
'forløftete': ('forløfte',),
'forløpende': ('forløpe',),
'forløpet': ('forløpe',),
'forløpt': ('forløpe',),
'forløpte': ('forløpe',),
'forløpen': ('forløpen',),
'forløpent': ('forløpen',),
'forløpne': ('forløpen',),
'forløpnere': ('forløpen',),
'forløpnest': ('forløpen',),
'forløpneste': ('forløpen',),
'forløsende': ('forløse',),
'forløst': ('forløse',),
'forløste': ('forløse',),
'forløyet': ('forløyet',),
'forløyne': ('forløyet',),
'forløynere': ('forløyet',),
'forløynest': ('forløyet',),
'forløyneste': ('forløyet',),
'forløysende': ('forløyse',),
'forløyst': ('forløyse',),
'forløyste': ('forløyse',),
'formal': ('formal',),
'formale': ('formal',),
'formalere': ('formal',),
'formalest': ('formal',),
'formaleste': ('formal',),
'formalt': ('formal',),
'formaldannende': ('formaldannende',),
'formalende': ('formale',),
'formalt': ('formale',),
'formalte': ('formale',),
'formaliserende': ('formalisere',),
'formalisert': ('formalisere',),
'formaliserte': ('formalisere',),
'formalistisk': ('formalistisk',),
'formalistiske': ('formalistisk',),
'formalistiskere': ('formalistisk',),
'formalistiskest': ('formalistisk',),
'formalistiskeste': ('formalistisk',),
'formana': ('formane',),
'formanede': ('formane',),
'formanende': ('formane',),
'formanet': ('formane',),
'formanete': ('formane',),
'formant': ('formane',),
'formante': ('formane',),
'formasta': ('formaste',),
'formastede': ('formaste',),
'formastende': ('formaste',),
'formastet': ('formaste',),
'formastete': ('formaste',),
'formastelig': ('formastelig',),
'formastelige': ('formastelig',),
'formasteligere': ('formastelig',),
'formasteligst': ('formastelig',),
'formasteligste': ('formastelig',),
'formaterende': ('formatere',),
'formatert': ('formatere',),
'formaterte': ('formatere',),
'formativ': ('formativ',),
'formative': ('formativ',),
'formativere': ('formativ',),
'formativest': ('formativ',),
'formativeste': ('formativ',),
'formativt': ('formativ',),
'forma': ('forme',),
'formede': ('forme',),
'formende': ('forme',),
'formet': ('forme',),
'formete': ('forme',),
'formell': ('formell',),
'formelle': ('formell',),
'formellere': ('formell',),
'formellest': ('formell',),
'formelleste': ('formell',),
'formelt': ('formell',),
'formenende': ('formene',),
'forment': ('formene',),
'formente': ('formene',),
'formentlig': ('formentlig',),
'formentlige': ('formentlig',),
'formentligere': ('formentlig',),
'formentligst': ('formentlig',),
'formentligste': ('formentlig',),
'formerende': ('formere',),
'formert': ('formere',),
'formerte': ('formere',),
'formerende': ('formere',),
'formert': ('formere',),
'formerte': ('formere',),
'formfullendt': ('formfullendt',),
'formfullendte': ('formfullendt',),
'formfullendtere': ('formfullendt',),
'formfullendtest': ('formfullendt',),
'formfullendteste': ('formfullendt',),
'formgiende': ('formgi',),
'formgitt': ('formgi',),
'formgitte': ('formgi',),
'formgivende': ('formgi',),
'formidabel': ('formidabel',),
'formidabelt': ('formidabel',),
'formidable': ('formidabel',),
'formidablere': ('formidabel',),
'formidablest': ('formidabel',),
'formidableste': ('formidabel',),
'formidla': ('formidle',),
'formidlede': ('formidle',),
'formidlende': ('formidle',),
'formidlet': ('formidle',),
'formidlete': ('formidle',),
'formilda': ('formilde',),
'formildede': ('formilde',),
'formildende': ('formilde',),
'formildet': ('formilde',),
'formildete': ('formilde',),
'forminska': ('forminske',),
'forminskede': ('forminske',),
'forminskende': ('forminske',),
'forminsket': ('forminske',),
'forminskete': ('forminske',),
'formlaus': ('formlaus',),
'formlause': ('formlaus',),
'formlausere': ('formlaus',),
'formlausest': ('formlaus',),
'formlauseste': ('formlaus',),
'formlaust': ('formlaus',),
'formløs': ('formløs',),
'formløse': ('formløs',),
'formløsere': ('formløs',),
'formløsest': ('formløs',),
'formløseste': ('formløs',),
'formløst': ('formløs',),
'formoda': ('formode',),
'formodede': ('formode',),
'formodende': ('formode',),
'formodet': ('formode',),
'formodete': ('formode',),
'formodentlig': ('formodentlig',),
'formodentlige': ('formodentlig',),
'formodentligere': ('formodentlig',),
'formodentligst': ('formodentlig',),
'formodentligste': ('formodentlig',),
'formolda': ('formolde',),
'formoldede': ('formolde',),
'formoldende': ('formolde',),
'formoldet': ('formolde',),
'formoldete': ('formolde',),
'formosansk': ('formosansk',),
'formosanske': ('formosansk',),
'formosanskere': ('formosansk',),
'formosanskest': ('formosansk',),
'formosanskeste': ('formosansk',),
'formuende': ('formuende',),
'formulda': ('formulde',),
'formuldede': ('formulde',),
'formuldende': ('formulde',),
'formuldet': ('formulde',),
'formuldete': ('formulde',),
'formulerende': ('formulere',),
'formulert': ('formulere',),
'formulerte': ('formulere',),
'formumma': ('formumme',),
'formummede': ('formumme',),
'formummende': ('formumme',),
'formummet': ('formumme',),
'formummete': ('formumme',),
'formådd': ('formå',),
'formådde': ('formå',),
'formående': ('formå',),
'formålslaus': ('formålslaus',),
'formålslause': ('formålslaus',),
'formålslausere': ('formålslaus',),
'formålslausest': ('formålslaus',),
'formålslauseste': ('formålslaus',),
'formålslaust': ('formålslaus',),
'formålsløs': ('formålsløs',),
'formålsløse': ('formålsløs',),
'formålsløsere': ('formålsløs',),
'formålsløsest': ('formålsløs',),
'formålsløseste': ('formålsløs',),
'formålsløst': ('formålsløs',),
'formålstjenlig': ('formålstjenlig',),
'formålstjenlige': ('formålstjenlig',),
'formålstjenligere': ('formålstjenlig',),
'formålstjenligst': ('formålstjenlig',),
'formålstjenligste': ('formålstjenlig',),
'formælende': ('formæle',),
'formælt': ('formæle',),
'formælte': ('formæle',),
'formørka': ('formørke',),
'formørkede': ('formørke',),
'formørkende': ('formørke',),
'formørket': ('formørke',),
'formørkete': ('formørke',),
'forn': ('forn',),
'forne': ('forn',),
'fornere': ('forn',),
'fornest': ('forn',),
'forneste': ('forn',),
'fornt': ('forn',),
'fornedra': ('fornedre',),
'fornedrede': ('fornedre',),
'fornedrende': ('fornedre',),
'fornedret': ('fornedre',),
'fornedrete': ('fornedre',),
'fornekta': ('fornekte',),
'fornektede': ('fornekte',),
'fornektende': ('fornekte',),
'fornektet': ('fornekte',),
'fornektete': ('fornekte',),
'fornem': ('fornem',),
'fornemme': ('fornem',),
'fornemmere': ('fornem',),
'fornemmest': ('fornem',),
'fornemmeste': ('fornem',),
'fornemt': ('fornem',),
'fornemma': ('fornemme',),
'fornemmede': ('fornemme',),
'fornemmende': ('fornemme',),
'fornemmet': ('fornemme',),
'fornemmete': ('fornemme',),
'fornemne': ('fornemme',),
'fornikla': ('fornikle',),
'forniklede': ('fornikle',),
'forniklende': ('fornikle',),
'forniklet': ('fornikle',),
'forniklete': ('fornikle',),
'fornorska': ('fornorske',),
'fornorskede': ('fornorske',),
'fornorskende': ('fornorske',),
'fornorsket': ('fornorske',),
'fornorskete': ('fornorske',),
'fornuftig': ('fornuftig',),
'fornuftige': ('fornuftig',),
'fornuftigere': ('fornuftig',),
'fornuftigst': ('fornuftig',),
'fornuftigste': ('fornuftig',),
'fornuftsstridig': ('fornuftsstridig',),
'fornuftsstridige': ('fornuftsstridig',),
'fornuftsstridigere': ('fornuftsstridig',),
'fornuftsstridigst': ('fornuftsstridig',),
'fornuftsstridigste': ('fornuftsstridig',),
'fornuftstridig': ('fornuftstridig',),
'fornuftstridige': ('fornuftstridig',),
'fornuftstridigere': ('fornuftstridig',),
'fornuftstridigst': ('fornuftstridig',),
'fornuftstridigste': ('fornuftstridig',),
'fornybar': ('fornybar',),
'fornybare': ('fornybar',),
'fornybarere': ('fornybar',),
'fornybarest': ('fornybar',),
'fornybareste': ('fornybar',),
'fornybart': ('fornybar',),
'fornya': ('fornye',),
'fornyede': ('fornye',),
'fornyende': ('fornye',),
'fornyet': ('fornye',),
'fornyete': ('fornye',),
'fornærma': ('fornærma',),
'fornærma': ('fornærme',),
'fornærmede': ('fornærme',),
'fornærmende': ('fornærme',),
'fornærmet': ('fornærme',),
'fornærmete': ('fornærme',),
'fornærmelig': ('fornærmelig',),
'fornærmelige': ('fornærmelig',),
'fornærmeligere': ('fornærmelig',),
'fornærmeligst': ('fornærmelig',),
'fornærmeligste': ('fornærmelig',),
'fornærmede': ('fornærmet',),
'fornærmet': ('fornærmet',),
'fornærmete': ('fornærmet',),
'fornærmetere': ('fornærmet',),
'fornærmetest': ('fornærmet',),
'fornærmeteste': ('fornærmet',),
'fornøden': ('fornøden',),
'fornødent': ('fornøden',),
'fornødne': ('fornøden',),
'fornødnere': ('fornøden',),
'fornødnest': ('fornøden',),
'fornødneste': ('fornøden',),
'fornøgd': ('fornøgd',),
'fornøgde': ('fornøgd',),
'fornøgdere': ('fornøgd',),
'fornøgdest': ('fornøgd',),
'fornøgdeste': ('fornøgd',),
'fornøyd': ('fornøyd',),
'fornøyde': ('fornøyd',),
'fornøydere': ('fornøyd',),
'fornøydest': ('fornøyd',),
'fornøydeste': ('fornøyd',),
'fornøya': ('fornøye',),
'fornøyd': ('fornøye',),
'fornøyde': ('fornøye',),
'fornøyede': ('fornøye',),
'fornøyende': ('fornøye',),
'fornøyet': ('fornøye',),
'fornøyete': ('fornøye',),
'fornøyelig': ('fornøyelig',),
'fornøyelige': ('fornøyelig',),
'fornøyeligere': ('fornøyelig',),
'fornøyeligst': ('fornøyelig',),
'fornøyeligste': ('fornøyelig',),
'fornøyelsessjuk': ('fornøyelsessjuk',),
'fornøyelsessjuke': ('fornøyelsessjuk',),
'fornøyelsessjukere': ('fornøyelsessjuk',),
'fornøyelsessjukest': ('fornøyelsessjuk',),
'fornøyelsessjukeste': ('fornøyelsessjuk',),
'fornøyelsessjukt': ('fornøyelsessjuk',),
'fornøyelsessyk': ('fornøyelsessyk',),
'fornøyelsessyke': ('fornøyelsessyk',),
'fornøyelsessykere': ('fornøyelsessyk',),
'fornøyelsessykest': ('fornøyelsessyk',),
'fornøyelsessykeste': ('fornøyelsessyk',),
'fornøyelsessykt': ('fornøyelsessyk',),
'forordna': ('forordne',),
'forordnede': ('forordne',),
'forordnende': ('forordne',),
'forordnet': ('forordne',),
'forordnete': ('forordne',),
'foroverbøyd': ('foroverbøyd',),
'foroverbøyde': ('foroverbøyd',),
'foroverbøydere': ('foroverbøyd',),
'foroverbøydest': ('foroverbøyd',),
'foroverbøydeste': ('foroverbøyd',),
'forpakta': ('forpakte',),
'forpaktede': ('forpakte',),
'forpaktende': ('forpakte',),
'forpaktet': ('forpakte',),
'forpaktete': ('forpakte',),
'forpesta': ('forpeste',),
'forpestede': ('forpeste',),
'forpestende': ('forpeste',),
'forpestet': ('forpeste',),
'forpestete': ('forpeste',),
'forpint': ('forpint',),
'forpinte': ('forpint',),
'forpintere': ('forpint',),
'forpintest': ('forpint',),
'forpinteste': ('forpint',),
'forpjuska': ('forpjuska',),
'forpjuskede': ('forpjusket',),
'forpjusket': ('forpjusket',),
'forpjuskete': ('forpjusket',),
'forpjusketere': ('forpjusket',),
'forpjusketest': ('forpjusket',),
'forpjusketeste': ('forpjusket',),
'forplanta': ('forplante',),
'forplantede': ('forplante',),
'forplantende': ('forplante',),
'forplantet': ('forplante',),
'forplantete': ('forplante',),
'forplantingsdyktig': ('forplantingsdyktig',),
'forplantingsdyktige': ('forplantingsdyktig',),
'forplantingsdyktigere': ('forplantingsdyktig',),
'forplantingsdyktigst': ('forplantingsdyktig',),
'forplantingsdyktigste': ('forplantingsdyktig',),
'forplantningsdyktig': ('forplantningsdyktig',),
'forplantningsdyktige': ('forplantningsdyktig',),
'forplantningsdyktigere': ('forplantningsdyktig',),
'forplantningsdyktigst': ('forplantningsdyktig',),
'forplantningsdyktigste': ('forplantningsdyktig',),
'forpleia': ('forpleie',),
'forpleid': ('forpleie',),
'forpleidd': ('forpleie',),
'forpleidde': ('forpleie',),
'forpleide': ('forpleie',),
'forpleiede': ('forpleie',),
'forpleiende': ('forpleie',),
'forpleiet': ('forpleie',),
'forpleiete': ('forpleie',),
'forplikta': ('forplikte',),
'forpliktede': ('forplikte',),
'forpliktende': ('forplikte',),
'forpliktet': ('forplikte',),
'forpliktete': ('forplikte',),
'forpliktende': ('forpliktende',),
'forprosjekterende': ('forprosjektere',),
'forprosjektert': ('forprosjektere',),
'forprosjekterte': ('forprosjektere',),
'forpuppa': ('forpuppe',),
'forpuppede': ('forpuppe',),
'forpuppende': ('forpuppe',),
'forpuppet': ('forpuppe',),
'forpuppete': ('forpuppe',),
'forpurra': ('forpurre',),
'forpurrede': ('forpurre',),
'forpurrende': ('forpurre',),
'forpurret': ('forpurre',),
'forpurrete': ('forpurre',),
'forrangla': ('forrangla',),
'forranglede': ('forranglet',),
'forranglet': ('forranglet',),
'forranglete': ('forranglet',),
'forrangletere': ('forranglet',),
'forrangletest': ('forranglet',),
'forrangleteste': ('forranglet',),
'forre': ('forre',),
'forregna': ('forregne',),
'forregnede': ('forregne',),
'forregnende': ('forregne',),
'forregnet': ('forregne',),
'forregnete': ('forregne',),
'forrekna': ('forrekne',),
'forreknede': ('forrekne',),
'forreknende': ('forrekne',),
'forreknet': ('forrekne',),
'forreknete': ('forrekne',),
'forrenta': ('forrente',),
'forrentede': ('forrente',),
'forrentende': ('forrente',),
'forrentet': ('forrente',),
'forrentete': ('forrente',),
'forrest': ('forrest',),
'forreste': ('forrest',),
'forretningsdrivende': ('forretningsdrivende',),
'forretningsmessig': ('forretningsmessig',),
'forretningsmessige': ('forretningsmessig',),
'forretningsmessigere': ('forretningsmessig',),
'forretningsmessigst': ('forretningsmessig',),
'forretningsmessigste': ('forretningsmessig',),
'forretta': ('forrette',),
'forrettede': ('forrette',),
'forrettende': ('forrette',),
'forrettet': ('forrette',),
'forrettete': ('forrette',),
'forreven': ('forreven',),
'forrevent': ('forreven',),
'forrevet': ('forreven',),
'forrevne': ('forreven',),
'forrevnere': ('forreven',),
'forrevnest': ('forreven',),
'forrevneste': ('forreven',),
'forrevet': ('forrevet',),
'forrevne': ('forrevet',),
'forrevnere': ('forrevet',),
'forrevnest': ('forrevet',),
'forrevneste': ('forrevet',),
'forringa': ('forringe',),
'forringede': ('forringe',),
'forringende': ('forringe',),
'forringet': ('forringe',),
'forringete': ('forringe',),
'forrykende': ('forrykende',),
'forrykka': ('forrykke',),
'forrykkede': ('forrykke',),
'forrykkende': ('forrykke',),
'forrykket': ('forrykke',),
'forrykkete': ('forrykke',),
'forrykt': ('forrykke',),
'forrykte': ('forrykke',),
'forrykt': ('forrykt',),
'forrykte': ('forrykt',),
'forryktere': ('forrykt',),
'forryktest': ('forrykt',),
'forrykteste': ('forrykt',),
'forrådende': ('forråde',),
'forrådt': ('forråde',),
'forrådte': ('forråde',),
'forråa': ('forråe',),
'forråede': ('forråe',),
'forrående': ('forråe',),
'forrået': ('forråe',),
'forråete': ('forråe',),
'forrædersk': ('forrædersk',),
'forræderske': ('forrædersk',),
'forræderskere': ('forrædersk',),
'forræderskest': ('forrædersk',),
'forræderskeste': ('forrædersk',),
'forsaga': ('forsage',),
'forsagede': ('forsage',),
'forsagende': ('forsage',),
'forsaget': ('forsage',),
'forsagete': ('forsage',),
'forsagt': ('forsagt',),
'forsagte': ('forsagt',),
'forsagtere': ('forsagt',),
'forsagtest': ('forsagt',),
'forsagteste': ('forsagt',),
'forsaka': ('forsake',),
'forsakede': ('forsake',),
'forsakende': ('forsake',),
'forsaket': ('forsake',),
'forsakete': ('forsake',),
'forseende': ('forse',),
'forsett': ('forse',),
'forsette': ('forse',),
'forseggjort': ('forseggjort',),
'forseggjorte': ('forseggjort',),
'forseggjortere': ('forseggjort',),
'forseggjortest': ('forseggjort',),
'forseggjorteste': ('forseggjort',),
'forsegla': ('forsegle',),
'forseglede': ('forsegle',),
'forseglende': ('forsegle',),
'forseglet': ('forsegle',),
'forseglete': ('forsegle',),
'forsenka': ('forsenke',),
'forsenkede': ('forsenke',),
'forsenkende': ('forsenke',),
'forsenket': ('forsenke',),
'forsenkete': ('forsenke',),
'forserende': ('forsere',),
'forsert': ('forsere',),
'forserte': ('forsere',),
'forsert': ('forsert',),
'forserte': ('forsert',),
'forsertere': ('forsert',),
'forsertest': ('forsert',),
'forserteste': ('forsert',),
'forsettlig': ('forsettlig',),
'forsettlige': ('forsettlig',),
'forsettligere': ('forsettlig',),
'forsettligst': ('forsettlig',),
'forsettligste': ('forsettlig',),
'forsikra': ('forsikre',),
'forsikrede': ('forsikre',),
'forsikrende': ('forsikre',),
'forsikret': ('forsikre',),
'forsikrete': ('forsikre',),
'forsiktig': ('forsiktig',),
'forsiktige': ('forsiktig',),
'forsiktigere': ('forsiktig',),
'forsiktigst': ('forsiktig',),
'forsiktigste': ('forsiktig',),
'forsimpla': ('forsimple',),
'forsimplede': ('forsimple',),
'forsimplende': ('forsimple',),
'forsimplet': ('forsimple',),
'forsimplete': ('forsimple',),
'forsinka': ('forsinke',),
'forsinkede': ('forsinke',),
'forsinkende': ('forsinke',),
'forsinket': ('forsinke',),
'forsinkete': ('forsinke',),
'forsinka': ('forsinke',),
'forsinkede': ('forsinke',),
'forsinkende': ('forsinke',),
'forsinket': ('forsinke',),
'forsinkete': ('forsinke',),
'forsirende': ('forsire',),
'forsirt': ('forsire',),
'forsirte': ('forsire',),
'forsjofla': ('forsjofle',),
'forsjoflede': ('forsjofle',),
'forsjoflende': ('forsjofle',),
'forsjoflet': ('forsjofle',),
'forsjoflete': ('forsjofle',),
'forskala': ('forskale',),
'forskalede': ('forskale',),
'forskalende': ('forskale',),
'forskalet': ('forskale',),
'forskalete': ('forskale',),
'forskalt': ('forskale',),
'forskalte': ('forskale',),
'forskansa': ('forskanse',),
'forskansede': ('forskanse',),
'forskansende': ('forskanse',),
'forskanset': ('forskanse',),
'forskansete': ('forskanse',),
'forska': ('forske',),
'forskede': ('forske',),
'forskende': ('forske',),
'forsket': ('forske',),
'forskete': ('forske',),
'forskende': ('forskende',),
'forskjellig': ('forskjellig',),
'forskjellige': ('forskjellig',),
'forskjelligere': ('forskjellig',),
'forskjelligst': ('forskjellig',),
'forskjelligste': ('forskjellig',),
'forskjellsbehandla': ('forskjellsbehandle',),
'forskjellsbehandlede': ('forskjellsbehandle',),
'forskjellsbehandlende': ('forskjellsbehandle',),
'forskjellsbehandlet': ('forskjellsbehandle',),
'forskjellsbehandlete': ('forskjellsbehandle',),
'forskjønna': ('forskjønne',),
'forskjønnede': ('forskjønne',),
'forskjønnende': ('forskjønne',),
'forskjønnet': ('forskjønne',),
'forskjønnete': ('forskjønne',),
'forskotterende': ('forskottere',),
'forskottert': ('forskottere',),
'forskotterte': ('forskottere',),
'forskrekka': ('forskrekke',),
'forskrekkede': ('forskrekke',),
'forskrekkende': ('forskrekke',),
'forskrekket': ('forskrekke',),
'forskrekkete': ('forskrekke',),
'forskrekkelig': ('forskrekkelig',),
'forskrekkelige': ('forskrekkelig',),
'forskrekkeligere': ('forskrekkelig',),
'forskrekkeligst': ('forskrekkelig',),
'forskrekkeligste': ('forskrekkelig',),
'forskremt': ('forskremt',),
'forskremte': ('forskremt',),
'forskremtere': ('forskremt',),
'forskremtest': ('forskremt',),
'forskremteste': ('forskremt',),
'forskreva': ('forskreve',),
'forskrevd': ('forskreve',),
'forskrevde': ('forskreve',),
'forskrevede': ('forskreve',),
'forskrevende': ('forskreve',),
'forskrevet': ('forskreve',),
'forskrevete': ('forskreve',),
'forskriftmessig': ('forskriftmessig',),
'forskriftmessige': ('forskriftmessig',),
'forskriftmessigere': ('forskriftmessig',),
'forskriftmessigst': ('forskriftmessig',),
'forskriftmessigste': ('forskriftmessig',),
'forskriftsmessig': ('forskriftsmessig',),
'forskriftsmessige': ('forskriftsmessig',),
'forskriftsmessigere': ('forskriftsmessig',),
'forskriftsmessigst': ('forskriftsmessig',),
'forskriftsmessigste': ('forskriftsmessig',),
'forskreven': ('forskrive',),
'forskrevet': ('forskrive',),
'forskrevne': ('forskrive',),
'forskrivende': ('forskrive',),
'forskrudd': ('forskrudd',),
'forskrudde': ('forskrudd',),
'forskruddere': ('forskrudd',),
'forskruddest': ('forskrudd',),
'forskruddeste': ('forskrudd',),
'forskusla': ('forskusle',),
'forskuslede': ('forskusle',),
'forskuslende': ('forskusle',),
'forskuslet': ('forskusle',),
'forskuslete': ('forskusle',),
'forskutterende': ('forskuttere',),
'forskuttert': ('forskuttere',),
'forskutterte': ('forskuttere',),
'forskyldende': ('forskylde',),
'forskyldt': ('forskylde',),
'forskyldte': ('forskylde',),
'forskjøven': ('forskyve',),
'forskjøvet': ('forskyve',),
'forskjøvne': ('forskyve',),
'forskyvd': ('forskyve',),
'forskyvde': ('forskyve',),
'forskyvende': ('forskyve',),
'forskåna': ('forskåne',),
'forskånede': ('forskåne',),
'forskånende': ('forskåne',),
'forskånet': ('forskåne',),
'forskånete': ('forskåne',),
'forskånt': ('forskåne',),
'forskånte': ('forskåne',),
'forslagen': ('forslagen',),
'forslagent': ('forslagen',),
'forslagne': ('forslagen',),
'forslagnere': ('forslagen',),
'forslagnest': ('forslagen',),
'forslagneste': ('forslagen',),
'forslitt': ('forslitt',),
'forslitte': ('forslitt',),
'forslittere': ('forslitt',),
'forslittest': ('forslitt',),
'forslitteste': ('forslitt',),
'forslukende': ('forsluke',),
'forslukt': ('forsluke',),
'forslukte': ('forsluke',),
'forsluken': ('forsluken',),
'forslukent': ('forsluken',),
'forslukne': ('forsluken',),
'forsluknere': ('forsluken',),
'forsluknest': ('forsluken',),
'forslukneste': ('forsluken',),
'forslumma': ('forslumme',),
'forslummede': ('forslumme',),
'forslummende': ('forslumme',),
'forslummet': ('forslumme',),
'forslummete': ('forslumme',),
'forslående': ('forslå',),
'forslått': ('forslå',),
'forslåtte': ('forslå',),
'forslått': ('forslått',),
'forslåtte': ('forslått',),
'forslåttere': ('forslått',),
'forslåttest': ('forslått',),
'forslåtteste': ('forslått',),
'forsmedelig': ('forsmedelig',),
'forsmedelige': ('forsmedelig',),
'forsmedeligere': ('forsmedelig',),
'forsmedeligst': ('forsmedelig',),
'forsmedeligste': ('forsmedelig',),
'forsmådd': ('forsmå',),
'forsmådde': ('forsmå',),
'forsmående': ('forsmå',),
'forsnakka': ('forsnakke',),
'forsnakkede': ('forsnakke',),
'forsnakkende': ('forsnakke',),
'forsnakket': ('forsnakke',),
'forsnakkete': ('forsnakke',),
'forsnevra': ('forsnevre',),
'forsnevrede': ('forsnevre',),
'forsnevrende': ('forsnevre',),
'forsnevret': ('forsnevre',),
'forsnevrete': ('forsnevre',),
'forsoffen': ('forsoffen',),
'forsoffent': ('forsoffen',),
'forsofne': ('forsoffen',),
'forsofnere': ('forsoffen',),
'forsofnest': ('forsoffen',),
'forsofneste': ('forsoffen',),
'forsona': ('forsone',),
'forsonede': ('forsone',),
'forsonende': ('forsone',),
'forsonet': ('forsone',),
'forsonete': ('forsone',),
'forsont': ('forsone',),
'forsonte': ('forsone',),
'forsonlig': ('forsonlig',),
'forsonlige': ('forsonlig',),
'forsonligere': ('forsonlig',),
'forsonligst': ('forsonlig',),
'forsonligste': ('forsonlig',),
'forsoren': ('forsoren',),
'forsorent': ('forsoren',),
'forsorne': ('forsoren',),
'forsornere': ('forsoren',),
'forsornest': ('forsoren',),
'forsorneste': ('forsoren',),
'forsoven': ('forsove',),
'forsovende': ('forsove',),
'forsovet': ('forsove',),
'forsovne': ('forsove',),
'forspennende': ('forspenne',),
'forspent': ('forspenne',),
'forspente': ('forspenne',),
'forspennende': ('forspenne',),
'forspent': ('forspenne',),
'forspente': ('forspenne',),
'forspillende': ('forspille',),
'forspilt': ('forspille',),
'forspilte': ('forspille',),
'forspisende': ('forspise',),
'forspist': ('forspise',),
'forspiste': ('forspise',),
'forsprengt': ('forsprengt',),
'forsprengte': ('forsprengt',),
'forsprengtere': ('forsprengt',),
'forsprengtest': ('forsprengt',),
'forsprengteste': ('forsprengt',),
'forspurt': ('forspørre',),
'forspurte': ('forspørre',),
'forspørrende': ('forspørre',),
'forstandig': ('forstandig',),
'forstandige': ('forstandig',),
'forstandigere': ('forstandig',),
'forstandigst': ('forstandig',),
'forstandigste': ('forstandig',),
'forstandsmessig': ('forstandsmessig',),
'forstandsmessige': ('forstandsmessig',),
'forstandsmessigere': ('forstandsmessig',),
'forstandsmessigst': ('forstandsmessig',),
'forstandsmessigste': ('forstandsmessig',),
'forsteina': ('forsteina',),
'forsteinede': ('forsteinet',),
'forsteinet': ('forsteinet',),
'forsteinete': ('forsteinet',),
'forsteinetere': ('forsteinet',),
'forsteinetest': ('forsteinet',),
'forsteineteste': ('forsteinet',),
'forstemmende': ('forstemmende',),
'forstemt': ('forstemt',),
'forstemte': ('forstemt',),
'forstemtere': ('forstemt',),
'forstemtest': ('forstemt',),
'forstemteste': ('forstemt',),
'forstenede': ('forstenet',),
'forstenet': ('forstenet',),
'forstenete': ('forstenet',),
'forstenetere': ('forstenet',),
'forstenetest': ('forstenet',),
'forsteneteste': ('forstenet',),
'forsterka': ('forsterke',),
'forsterkede': ('forsterke',),
'forsterkende': ('forsterke',),
'forsterket': ('forsterke',),
'forsterkete': ('forsterke',),
'forstikkende': ('forstikke',),
'forstukken': ('forstikke',),
'forstukket': ('forstikke',),
'forstukne': ('forstikke',),
'forstillende': ('forstille',),
'forstilt': ('forstille',),
'forstilte': ('forstille',),
'forstokka': ('forstokka',),
'forstokkede': ('forstokket',),
'forstokket': ('forstokket',),
'forstokkete': ('forstokket',),
'forstokketere': ('forstokket',),
'forstokketest': ('forstokket',),
'forstokketeste': ('forstokket',),
'forstua': ('forstue',),
'forstuede': ('forstue',),
'forstuende': ('forstue',),
'forstuet': ('forstue',),
'forstuete': ('forstue',),
'forstua': ('forstue',),
'forstuede': ('forstue',),
'forstuende': ('forstue',),
'forstuet': ('forstue',),
'forstuete': ('forstue',),
'forstua': ('forstue',),
'forstuede': ('forstue',),
'forstuende': ('forstue',),
'forstuet': ('forstue',),
'forstuete': ('forstue',),
'forstumma': ('forstumme',),
'forstummede': ('forstumme',),
'forstummende': ('forstumme',),
'forstummet': ('forstumme',),
'forstummete': ('forstumme',),
'forstuva': ('forstuve',),
'forstuvede': ('forstuve',),
'forstuvende': ('forstuve',),
'forstuvet': ('forstuve',),
'forstuvete': ('forstuve',),
'forstuva': ('forstuve',),
'forstuvede': ('forstuve',),
'forstuvende': ('forstuve',),
'forstuvet': ('forstuve',),
'forstuvete': ('forstuve',),
'forstyrra': ('forstyrra',),
'forstyrra': ('forstyrre',),
'forstyrrede': ('forstyrre',),
'forstyrrende': ('forstyrre',),
'forstyrret': ('forstyrre',),
'forstyrrete': ('forstyrre',),
'forstyrrede': ('forstyrret',),
'forstyrret': ('forstyrret',),
'forstyrrete': ('forstyrret',),
'forstyrretere': ('forstyrret',),
'forstyrretest': ('forstyrret',),
'forstyrreteste': ('forstyrret',),
'forstående': ('forstå',),
'forstått': ('forstå',),
'forståtte': ('forstå',),
'forståelig': ('forståelig',),
'forståelige': ('forståelig',),
'forståeligere': ('forståelig',),
'forståeligst': ('forståelig',),
'forståeligste': ('forståelig',),
'forståelsesfull': ('forståelsesfull',),
'forståelsesfulle': ('forståelsesfull',),
'forståelsesfullere': ('forståelsesfull',),
'forståelsesfullest': ('forståelsesfull',),
'forståelsesfulleste': ('forståelsesfull',),
'forståelsesfullt': ('forståelsesfull',),
'forstøkt': ('forstøkt',),
'forstøkte': ('forstøkt',),
'forstøktere': ('forstøkt',),
'forstøktest': ('forstøkt',),
'forstøkteste': ('forstøkt',),
'forstørra': ('forstørre',),
'forstørrede': ('forstørre',),
'forstørrende': ('forstørre',),
'forstørret': ('forstørre',),
'forstørrete': ('forstørre',),
'forstøtende': ('forstøte',),
'forstøtt': ('forstøte',),
'forstøtte': ('forstøte',),
'forstøtta': ('forstøtte',),
'forstøttede': ('forstøtte',),
'forstøttende': ('forstøtte',),
'forstøttet': ('forstøtte',),
'forstøttete': ('forstøtte',),
'forstøva': ('forstøve',),
'forstøvede': ('forstøve',),
'forstøvende': ('forstøve',),
'forstøvet': ('forstøve',),
'forstøvete': ('forstøve',),
'forsumpa': ('forsumpe',),
'forsumpede': ('forsumpe',),
'forsumpende': ('forsumpe',),
'forsumpet': ('forsumpe',),
'forsumpete': ('forsumpe',),
'forsura': ('forsure',),
'forsurede': ('forsure',),
'forsurende': ('forsure',),
'forsuret': ('forsure',),
'forsurete': ('forsure',),
'forsvarende': ('forsvare',),
'forsvart': ('forsvare',),
'forsvarte': ('forsvare',),
'forsvarlig': ('forsvarlig',),
'forsvarlige': ('forsvarlig',),
'forsvarligere': ('forsvarlig',),
'forsvarligst': ('forsvarlig',),
'forsvarligste': ('forsvarlig',),
'forsvarslaus': ('forsvarslaus',),
'forsvarslause': ('forsvarslaus',),
'forsvarslausere': ('forsvarslaus',),
'forsvarslausest': ('forsvarslaus',),
'forsvarslauseste': ('forsvarslaus',),
'forsvarslaust': ('forsvarslaus',),
'forsvarsløs': ('forsvarsløs',),
'forsvarsløse': ('forsvarsløs',),
'forsvarsløsere': ('forsvarsløs',),
'forsvarsløsest': ('forsvarsløs',),
'forsvarsløseste': ('forsvarsløs',),
'forsvarsløst': ('forsvarsløs',),
'forsvenska': ('forsvenske',),
'forsvenskede': ('forsvenske',),
'forsvenskende': ('forsvenske',),
'forsvensket': ('forsvenske',),
'forsvenskete': ('forsvenske',),
'forsverga': ('forsverge',),
'forsvergede': ('forsverge',),
'forsvergende': ('forsverge',),
'forsverget': ('forsverge',),
'forsvergete': ('forsverge',),
'forsvoren': ('forsverge',),
'forsvoret': ('forsverge',),
'forsvorne': ('forsverge',),
'forsverja': ('forsverje',),
'forsverjede': ('forsverje',),
'forsverjende': ('forsverje',),
'forsverjet': ('forsverje',),
'forsverjete': ('forsverje',),
'forsvoren': ('forsverje',),
'forsvoret': ('forsverje',),
'forsvorne': ('forsverje',),
'forsvinnende': ('forsvinne',),
'forsvunne': ('forsvinne',),
'forsvunnen': ('forsvinne',),
'forsvunnet': ('forsvinne',),
'forsvinnende': ('forsvinnende',),
'forsynda': ('forsynde',),
'forsyndede': ('forsynde',),
'forsyndende': ('forsynde',),
'forsyndet': ('forsynde',),
'forsyndete': ('forsynde',),
'forsynende': ('forsyne',),
'forsynt': ('forsyne',),
'forsynte': ('forsyne',),
'forsynlig': ('forsynlig',),
'forsynlige': ('forsynlig',),
'forsynligere': ('forsynlig',),
'forsynligst': ('forsynlig',),
'forsynligste': ('forsynlig',),
'forsøkende': ('forsøke',),
'forsøkt': ('forsøke',),
'forsøkte': ('forsøke',),
'forsølva': ('forsølve',),
'forsølvede': ('forsølve',),
'forsølvende': ('forsølve',),
'forsølvet': ('forsølve',),
'forsølvete': ('forsølve',),
'forsømmende': ('forsømme',),
'forsømt': ('forsømme',),
'forsømte': ('forsømme',),
'forsømmelig': ('forsømmelig',),
'forsømmelige': ('forsømmelig',),
'forsømmeligere': ('forsømmelig',),
'forsømmeligst': ('forsømmelig',),
'forsømmeligste': ('forsømmelig',),
'forsømt': ('forsømt',),
'forsømte': ('forsømt',),
'forsømtere': ('forsømt',),
'forsømtest': ('forsømt',),
'forsømteste': ('forsømt',),
'forsøpla': ('forsøple',),
'forsøplede': ('forsøple',),
'forsøplende': ('forsøple',),
'forsøplet': ('forsøple',),
'forsøplete': ('forsøple',),
'forsørga': ('forsørge',),
'forsørgd': ('forsørge',),
'forsørgde': ('forsørge',),
'forsørgede': ('forsørge',),
'forsørgende': ('forsørge',),
'forsørget': ('forsørge',),
'forsørgete': ('forsørge',),
'forsøta': ('forsøte',),
'forsøtede': ('forsøte',),
'forsøtende': ('forsøte',),
'forsøtet': ('forsøte',),
'forsøtete': ('forsøte',),
'fort': ('fort',),
'fortere': ('fort',),
'fortest': ('fort',),
'fortakende': ('forta',),
'fortatt': ('forta',),
'fortatte': ('forta',),
'fortapende': ('fortape',),
'fortapt': ('fortape',),
'fortapte': ('fortape',),
'fortapt': ('fortapt',),
'fortapte': ('fortapt',),
'fortaptere': ('fortapt',),
'fortaptest': ('fortapt',),
'fortapteste': ('fortapt',),
'forta': ('forte',),
'fortede': ('forte',),
'fortende': ('forte',),
'fortet': ('forte',),
'fortete': ('forte',),
'fortegna': ('fortegne',),
'fortegnede': ('fortegne',),
'fortegnende': ('fortegne',),
'fortegnet': ('fortegne',),
'fortegnete': ('fortegne',),
'fortalt': ('fortelle',),
'fortalte': ('fortelle',),
'fortellende': ('fortelle',),
'fortellende': ('fortellende',),
'fortenkende': ('fortenke',),
'fortenkt': ('fortenke',),
'fortenkte': ('fortenke',),
'fortenkt': ('fortenkt',),
'fortenkte': ('fortenkt',),
'fortenktere': ('fortenkt',),
'fortenktest': ('fortenkt',),
'fortenkteste': ('fortenkt',),
'forterpa': ('forterpa',),
'forterpede': ('forterpet',),
'forterpet': ('forterpet',),
'forterpete': ('forterpet',),
'forterpetere': ('forterpet',),
'forterpetest': ('forterpet',),
'forterpeteste': ('forterpet',),
'forterska': ('forterska',),
'forterskede': ('fortersket',),
'fortersket': ('fortersket',),
'forterskete': ('fortersket',),
'fortersketere': ('fortersket',),
'fortersketest': ('fortersket',),
'fortersketeste': ('fortersket',),
'fortetta': ('fortette',),
'fortettede': ('fortette',),
'fortettende': ('fortette',),
'fortettet': ('fortette',),
'fortettete': ('fortette',),
'fortidig': ('fortidig',),
'fortidige': ('fortidig',),
'fortidigere': ('fortidig',),
'fortidigst': ('fortidig',),
'fortidigste': ('fortidig',),
'fortia': ('fortie',),
'fortidd': ('fortie',),
'fortidde': ('fortie',),
'fortiede': ('fortie',),
'fortiende': ('fortie',),
'fortiet': ('fortie',),
'fortiete': ('fortie',),
'fortinna': ('fortinne',),
'fortinnede': ('fortinne',),
'fortinnende': ('fortinne',),
'fortinnet': ('fortinne',),
'fortinnete': ('fortinne',),
'fortjenende': ('fortjene',),
'fortjent': ('fortjene',),
'fortjente': ('fortjene',),
'fortjenestefull': ('fortjenestefull',),
'fortjenestefulle': ('fortjenestefull',),
'fortjenestefullere': ('fortjenestefull',),
'fortjenestefullest': ('fortjenestefull',),
'fortjenestefulleste': ('fortjenestefull',),
'fortjenestefullt': ('fortjenestefull',),
'fortjenstfull': ('fortjenstfull',),
'fortjenstfulle': ('fortjenstfull',),
'fortjenstfullere': ('fortjenstfull',),
'fortjenstfullest': ('fortjenstfull',),
'fortjenstfulleste': ('fortjenstfull',),
'fortjenstfullt': ('fortjenstfull',),
'fortløpende': ('fortløpende',),
'fortna': ('fortne',),
'fortnede': ('fortne',),
'fortnende': ('fortne',),
'fortnet': ('fortne',),
'fortnete': ('fortne',),
'fortolka': ('fortolke',),
'fortolkede': ('fortolke',),
'fortolkende': ('fortolke',),
'fortolket': ('fortolke',),
'fortolkete': ('fortolke',),
'fortolla': ('fortolle',),
'fortollede': ('fortolle',),
'fortollende': ('fortolle',),
'fortollet': ('fortolle',),
'fortollete': ('fortolle',),
'fortona': ('fortone',),
'fortonede': ('fortone',),
'fortonende': ('fortone',),
'fortonet': ('fortone',),
'fortonete': ('fortone',),
'fortont': ('fortone',),
'fortonte': ('fortone',),
'fortorva': ('fortorve',),
'fortorvede': ('fortorve',),
'fortorvende': ('fortorve',),
'fortorvet': ('fortorve',),
'fortorvete': ('fortorve',),
'fortredelig': ('fortredelig',),
'fortredelige': ('fortredelig',),
'fortredeligere': ('fortredelig',),
'fortredeligst': ('fortredelig',),
'fortredeligste': ('fortredelig',),
'fortreffelig': ('fortreffelig',),
'fortreffelige': ('fortreffelig',),
'fortreffeligere': ('fortreffelig',),
'fortreffeligst': ('fortreffelig',),
'fortreffeligste': ('fortreffelig',),
'fortrekkende': ('fortrekke',),
'fortrukken': ('fortrekke',),
'fortrukket': ('fortrekke',),
'fortrukne': ('fortrekke',),
'fortrengende': ('fortrenge',),
'fortrengt': ('fortrenge',),
'fortrengte': ('fortrenge',),
'fortrinnlig': ('fortrinnlig',),
'fortrinnlige': ('fortrinnlig',),
'fortrinnligere': ('fortrinnlig',),
'fortrinnligst': ('fortrinnlig',),
'fortrinnligste': ('fortrinnlig',),
'fortrinnsberettiga': ('fortrinnsberettiga',),
'fortrinnsberettigede': ('fortrinnsberettiget',),
'fortrinnsberettiget': ('fortrinnsberettiget',),
'fortrinnsberettigete': ('fortrinnsberettiget',),
'fortrinnsberettigetere': ('fortrinnsberettiget',),
'fortrinnsberettigetest': ('fortrinnsberettiget',),
'fortrinnsberettigeteste': ('fortrinnsberettiget',),
'fortrolig': ('fortrolig',),
'fortrolige': ('fortrolig',),
'fortroligere': ('fortrolig',),
'fortroligst': ('fortrolig',),
'fortroligste': ('fortrolig',),
'fortrolla': ('fortrolle',),
'fortrollede': ('fortrolle',),
'fortrollende': ('fortrolle',),
'fortrollet': ('fortrolle',),
'fortrollete': ('fortrolle',),
'fortrykt': ('fortrykt',),
'fortrykte': ('fortrykt',),
'fortryktere': ('fortrykt',),
'fortryktest': ('fortrykt',),
'fortrykteste': ('fortrykt',),
'fortrylla': ('fortrylle',),
'fortryllede': ('fortrylle',),
'fortryllende': ('fortrylle',),
'fortryllet': ('fortrylle',),
'fortryllete': ('fortrylle',),
'fortrylt': ('fortrylle',),
'fortrylte': ('fortrylle',),
'fortrutt': ('fortryte',),
'fortrutte': ('fortryte',),
'fortrytende': ('fortryte',),
'fortrytelig': ('fortrytelig',),
'fortrytelige': ('fortrytelig',),
'fortryteligere': ('fortrytelig',),
'fortryteligst': ('fortrytelig',),
'fortryteligste': ('fortrytelig',),
'fortrøsta': ('fortrøste',),
'fortrøstede': ('fortrøste',),
'fortrøstende': ('fortrøste',),
'fortrøstet': ('fortrøste',),
'fortrøstete': ('fortrøste',),
'fortrøstningsfull': ('fortrøstningsfull',),
'fortrøstningsfulle': ('fortrøstningsfull',),
'fortrøstningsfullere': ('fortrøstningsfull',),
'fortrøstningsfullest': ('fortrøstningsfull',),
'fortrøstningsfulleste': ('fortrøstningsfull',),
'fortrøstningsfullt': ('fortrøstningsfull',),
'fortsatt': ('fortsette',),
'fortsatte': ('fortsette',),
'fortsettende': ('fortsette',),
'fortulla': ('fortulla',),
'fortullede': ('fortullet',),
'fortullet': ('fortullet',),
'fortullete': ('fortullet',),
'fortulletere': ('fortullet',),
'fortulletest': ('fortullet',),
'fortulleteste': ('fortullet',),
'fortumla': ('fortumla',),
'fortumlede': ('fortumlet',),
'fortumlet': ('fortumlet',),
'fortumlete': ('fortumlet',),
'fortumletere': ('fortumlet',),
'fortumletest': ('fortumlet',),
'fortumleteste': ('fortumlet',),
'fortvila': ('fortvila',),
'fortvilende': ('fortvile',),
'fortvilt': ('fortvile',),
'fortvilte': ('fortvile',),
'fortvilede': ('fortvilet',),
'fortvilet': ('fortvilet',),
'fortvilete': ('fortvilet',),
'fortviletere': ('fortvilet',),
'fortviletest': ('fortvilet',),
'fortvileteste': ('fortvilet',),
'fortvilt': ('fortvilt',),
'fortvilte': ('fortvilt',),
'fortviltere': ('fortvilt',),
'fortviltest': ('fortvilt',),
'fortvilteste': ('fortvilt',),
'fortykka': ('fortykke',),
'fortykkede': ('fortykke',),
'fortykkende': ('fortykke',),
'fortykket': ('fortykke',),
'fortykkete': ('fortykke',),
'fortynna': ('fortynne',),
'fortynnede': ('fortynne',),
'fortynnende': ('fortynne',),
'fortynnet': ('fortynne',),
'fortynnete': ('fortynne',),
'fortærende': ('fortære',),
'fortært': ('fortære',),
'fortærte': ('fortære',),
'fortærende': ('fortærende',),
'fortørna': ('fortørne',),
'fortørnede': ('fortørne',),
'fortørnende': ('fortørne',),
'fortørnet': ('fortørne',),
'fortørnete': ('fortørne',),
'fortøyd': ('fortøye',),
'fortøyde': ('fortøye',),
'fortøyende': ('fortøye',),
'foruleiliga': ('foruleilige',),
'foruleiligede': ('foruleilige',),
'foruleiligende': ('foruleilige',),
'foruleiliget': ('foruleilige',),
'foruleiligete': ('foruleilige',),
'forulempa': ('forulempe',),
'forulempede': ('forulempe',),
'forulempende': ('forulempe',),
'forulempet': ('forulempe',),
'forulempete': ('forulempe',),
'forulykka': ('forulykke',),
'forulykkede': ('forulykke',),
'forulykkende': ('forulykke',),
'forulykket': ('forulykke',),
'forulykkete': ('forulykke',),
'forunderlig': ('forunderlig',),
'forunderlige': ('forunderlig',),
'forunderligere': ('forunderlig',),
'forunderligst': ('forunderlig',),
'forunderligste': ('forunderlig',),
'forundra': ('forundre',),
'forundrede': ('forundre',),
'forundrende': ('forundre',),
'forundret': ('forundre',),
'forundrete': ('forundre',),
'forundra': ('forundre',),
'forundrede': ('forundre',),
'forundrende': ('forundre',),
'forundret': ('forundre',),
'forundrete': ('forundre',),
'forunnende': ('forunne',),
'forunt': ('forunne',),
'forunte': ('forunne',),
'forurensa': ('forurense',),
'forurensede': ('forurense',),
'forurensende': ('forurense',),
'forurenset': ('forurense',),
'forurensete': ('forurense',),
'foruretta': ('forurette',),
'forurettede': ('forurette',),
'forurettende': ('forurette',),
'forurettet': ('forurette',),
'forurettete': ('forurette',),
'foruroliga': ('forurolige',),
'foruroligede': ('forurolige',),
'foruroligende': ('forurolige',),
'foruroliget': ('forurolige',),
'foruroligete': ('forurolige',),
'foruroligende': ('foruroligende',),
'forutberegna': ('forutberegne',),
'forutberegnede': ('forutberegne',),
'forutberegnende': ('forutberegne',),
'forutberegnet': ('forutberegne',),
'forutberegnete': ('forutberegne',),
'forutberekna': ('forutberekne',),
'forutbereknede': ('forutberekne',),
'forutbereknende': ('forutberekne',),
'forutbereknet': ('forutberekne',),
'forutbereknete': ('forutberekne',),
'forutbestemmende': ('forutbestemme',),
'forutbestemt': ('forutbestemme',),
'forutbestemte': ('forutbestemme',),
'forutfatta': ('forutfatta',),
'forutfattede': ('forutfattet',),
'forutfattet': ('forutfattet',),
'forutfattete': ('forutfattet',),
'forutfattetere': ('forutfattet',),
'forutfattetest': ('forutfattet',),
'forutfatteteste': ('forutfattet',),
'forutgående': ('forutgående',),
'forutinntatt': ('forutinntatt',),
'forutinntatte': ('forutinntatt',),
'forutinntattere': ('forutinntatt',),
'forutinntattest': ('forutinntatt',),
'forutinntatteste': ('forutinntatt',),
'forutseende': ('forutse',),
'forutsett': ('forutse',),
'forutsette': ('forutse',),
'forutseende': ('forutseende',),
'forutsetningslaus': ('forutsetningslaus',),
'forutsetningslause': ('forutsetningslaus',),
'forutsetningslausere': ('forutsetningslaus',),
'forutsetningslausest': ('forutsetningslaus',),
'forutsetningslauseste': ('forutsetningslaus',),
'forutsetningslaust': ('forutsetningslaus',),
'forutsetningsløs': ('forutsetningsløs',),
'forutsetningsløse': ('forutsetningsløs',),
'forutsetningsløsere': ('forutsetningsløs',),
'forutsetningsløsest': ('forutsetningsløs',),
'forutsetningsløseste': ('forutsetningsløs',),
'forutsetningsløst': ('forutsetningsløs',),
'forutsatt': ('forutsette',),
'forutsatte': ('forutsette',),
'forutsettende': ('forutsette',),
'forutsigelig': ('forutsigelig',),
'forutsigelige': ('forutsigelig',),
'forutsigeligere': ('forutsigelig',),
'forutsigeligst': ('forutsigelig',),
'forutsigeligste': ('forutsigelig',),
'forutskikka': ('forutskikke',),
'forutskikkede': ('forutskikke',),
'forutskikkende': ('forutskikke',),
'forutskikket': ('forutskikke',),
'forutskikkete': ('forutskikke',),
'forvalta': ('forvalte',),
'forvaltede': ('forvalte',),
'forvaltende': ('forvalte',),
'forvaltet': ('forvalte',),
'forvaltete': ('forvalte',),
'forvandla': ('forvandle',),
'forvandlede': ('forvandle',),
'forvandlende': ('forvandle',),
'forvandlet': ('forvandle',),
'forvandlete': ('forvandle',),
'forvanska': ('forvanske',),
'forvanskede': ('forvanske',),
'forvanskende': ('forvanske',),
'forvansket': ('forvanske',),
'forvanskete': ('forvanske',),
'forvarende': ('forvare',),
'forvart': ('forvare',),
'forvarte': ('forvare',),
'forveda': ('forvede',),
'forvedede': ('forvede',),
'forvedende': ('forvede',),
'forvedet': ('forvede',),
'forvedete': ('forvede',),
'forveksla': ('forveksle',),
'forvekslede': ('forveksle',),
'forvekslende': ('forveksle',),
'forvekslet': ('forveksle',),
'forvekslete': ('forveksle',),
'forvella': ('forvelle',),
'forvellede': ('forvelle',),
'forvellende': ('forvelle',),
'forvellet': ('forvelle',),
'forvellete': ('forvelle',),
'forvelt': ('forvelle',),
'forvelte': ('forvelle',),
'forvennende': ('forvenne',),
'forvent': ('forvenne',),
'forvente': ('forvenne',),
'forvent': ('forvent',),
'forvente': ('forvent',),
'forventere': ('forvent',),
'forventest': ('forvent',),
'forventeste': ('forvent',),
'forventa': ('forvente',),
'forventede': ('forvente',),
'forventende': ('forvente',),
'forventet': ('forvente',),
'forventete': ('forvente',),
'forventningsfull': ('forventningsfull',),
'forventningsfulle': ('forventningsfull',),
'forventningsfullere': ('forventningsfull',),
'forventningsfullest': ('forventningsfull',),
'forventningsfulleste': ('forventningsfull',),
'forventningsfullt': ('forventningsfull',),
'forverra': ('forverre',),
'forverrede': ('forverre',),
'forverrende': ('forverre',),
'forverret': ('forverre',),
'forverrete': ('forverre',),
'forvilla': ('forville',),
'forvillede': ('forville',),
'forvillende': ('forville',),
'forvillet': ('forville',),
'forvillete': ('forville',),
'forvirra': ('forvirra',),
'forvirra': ('forvirre',),
'forvirrede': ('forvirre',),
'forvirrende': ('forvirre',),
'forvirret': ('forvirre',),
'forvirrete': ('forvirre',),
'forvirrede': ('forvirret',),
'forvirret': ('forvirret',),
'forvirrete': ('forvirret',),
'forvirretere': ('forvirret',),
'forvirretest': ('forvirret',),
'forvirreteste': ('forvirret',),
'forvisende': ('forvise',),
'forvist': ('forvise',),
'forviste': ('forvise',),
'forvissa': ('forvisse',),
'forvissede': ('forvisse',),
'forvissende': ('forvisse',),
'forvisset': ('forvisse',),
'forvissete': ('forvisse',),
'forviten': ('forviten',),
'forvitent': ('forviten',),
'forvitne': ('forviten',),
'forvitnere': ('forviten',),
'forvitnest': ('forviten',),
'forvitneste': ('forviten',),
'forvitra': ('forvitre',),
'forvitrede': ('forvitre',),
'forvitrende': ('forvitre',),
'forvitret': ('forvitre',),
'forvitrete': ('forvitre',),
'forvokst': ('forvokst',),
'forvokste': ('forvokst',),
'forvokstere': ('forvokst',),
'forvokstest': ('forvokst',),
'forvoksteste': ('forvokst',),
'forvoldende': ('forvolde',),
'forvoldt': ('forvolde',),
'forvoldte': ('forvolde',),
'forvorpen': ('forvorpen',),
'forvorpent': ('forvorpen',),
'forvorpne': ('forvorpen',),
'forvorpnere': ('forvorpen',),
'forvorpnest': ('forvorpen',),
'forvorpneste': ('forvorpen',),
'forvrengende': ('forvrenge',),
'forvrengt': ('forvrenge',),
'forvrengte': ('forvrenge',),
'forvridd': ('forvri',),
'forvridde': ('forvri',),
'forvriende': ('forvri',),
'forvrøvla': ('forvrøvla',),
'forvrøvlede': ('forvrøvlet',),
'forvrøvlet': ('forvrøvlet',),
'forvrøvlete': ('forvrøvlet',),
'forvrøvletere': ('forvrøvlet',),
'forvrøvletest': ('forvrøvlet',),
'forvrøvleteste': ('forvrøvlet',),
'forvåka': ('forvåka',),
'forvåkede': ('forvåket',),
'forvåket': ('forvåket',),
'forvåkete': ('forvåket',),
'forvåketere': ('forvåket',),
'forvåketest': ('forvåket',),
'forvåketeste': ('forvåket',),
'forvåkt': ('forvåkt',),
'forvåkte': ('forvåkt',),
'forvåktere': ('forvåkt',),
'forvåktest': ('forvåkt',),
'forvåkteste': ('forvåkt',),
'forynga': ('forynge',),
'foryngede': ('forynge',),
'foryngende': ('forynge',),
'forynget': ('forynge',),
'foryngete': ('forynge',),
'forårsaka': ('forårsake',),
'forårsakede': ('forårsake',),
'forårsakende': ('forårsake',),
'forårsaket': ('forårsake',),
'forårsakete': ('forårsake',),
'forærende': ('forære',),
'forært': ('forære',),
'forærte': ('forære',),
'forøda': ('forøde',),
'forødede': ('forøde',),
'forødende': ('forøde',),
'forødet': ('forøde',),
'forødete': ('forøde',),
'forødt': ('forøde',),
'forødte': ('forøde',),
'forøka': ('forøke',),
'forøkede': ('forøke',),
'forøkende': ('forøke',),
'forøket': ('forøke',),
'forøkete': ('forøke',),
'forøkt': ('forøke',),
'forøkte': ('forøke',),
'forønska': ('forønska',),
'forønskede': ('forønsket',),
'forønsket': ('forønsket',),
'forønskete': ('forønsket',),
'forønsketere': ('forønsket',),
'forønsketest': ('forønsket',),
'forønsketeste': ('forønsket',),
'forøva': ('forøve',),
'forøvd': ('forøve',),
'forøvde': ('forøve',),
'forøvede': ('forøve',),
'forøvende': ('forøve',),
'forøvet': ('forøve',),
'forøvete': ('forøve',),
'fosforescerende': ('fosforescere',),
'fosforescert': ('fosforescere',),
'fosforescerte': ('fosforescere',),
'fosforsur': ('fosforsur',),
'fosforsure': ('fosforsur',),
'fosforsurere': ('fosforsur',),
'fosforsurest': ('fosforsur',),
'fosforsureste': ('fosforsur',),
'fosforsurt': ('fosforsur',),
'fossa': ('fosse',),
'fossede': ('fosse',),
'fossende': ('fosse',),
'fosset': ('fosse',),
'fossete': ('fosse',),
'fossil': ('fossil',),
'fossile': ('fossil',),
'fossilere': ('fossil',),
'fossilest': ('fossil',),
'fossileste': ('fossil',),
'fossilt': ('fossil',),
'fosskokende': ('fosskoke',),
'fosskokt': ('fosskoke',),
'fosskokte': ('fosskoke',),
'fossregna': ('fossregne',),
'fossregnede': ('fossregne',),
'fossregnende': ('fossregne',),
'fossregnet': ('fossregne',),
'fossregnete': ('fossregne',),
'fossregnt': ('fossregne',),
'fossregnte': ('fossregne',),
'fossrodd': ('fossro',),
'fossrodde': ('fossro',),
'fossroende': ('fossro',),
'fostra': ('fostre',),
'fostrede': ('fostre',),
'fostrende': ('fostre',),
'fostret': ('fostre',),
'fostrete': ('fostre',),
'fota': ('fote',),
'fotede': ('fote',),
'fotende': ('fote',),
'fotet': ('fote',),
'fotete': ('fote',),
'fotogen': ('fotogen',),
'fotogene': ('fotogen',),
'fotogenere': ('fotogen',),
'fotogenest': ('fotogen',),
'fotogeneste': ('fotogen',),
'fotogent': ('fotogen',),
'fotograferende': ('fotografere',),
'fotografert': ('fotografere',),
'fotograferte': ('fotografere',),
'fotografisk': ('fotografisk',),
'fotografiske': ('fotografisk',),
'fotografiskere': ('fotografisk',),
'fotografiskest': ('fotografisk',),
'fotografiskeste': ('fotografisk',),
'fotokopierende': ('fotokopiere',),
'fotokopiert': ('fotokopiere',),
'fotokopierte': ('fotokopiere',),
'fotostatisk': ('fotostatisk',),
'fotostatiske': ('fotostatisk',),
'fotostatiskere': ('fotostatisk',),
'fotostatiskest': ('fotostatisk',),
'fotostatiskeste': ('fotostatisk',),
'fotosyntetisk': ('fotosyntetisk',),
'fotosyntetiske': ('fotosyntetisk',),
'fotosyntetiskere': ('fotosyntetisk',),
'fotosyntetiskest': ('fotosyntetisk',),
'fotosyntetiskeste': ('fotosyntetisk',),
'fototaktisk': ('fototaktisk',),
'fototaktiske': ('fototaktisk',),
'fototaktiskere': ('fototaktisk',),
'fototaktiskest': ('fototaktisk',),
'fototaktiskeste': ('fototaktisk',),
'fotsid': ('fotsid',),
'fotside': ('fotsid',),
'fotsidere': ('fotsid',),
'fotsidest': ('fotsid',),
'fotsideste': ('fotsid',),
'fotsidt': ('fotsid',),
'frabedt': ('frabe',),
'frabedte': ('frabe',),
'frabeende': ('frabe',),
'frabeordra': ('frabeordre',),
'frabeordrede': ('frabeordre',),
'frabeordrende': ('frabeordre',),
'frabeordret': ('frabeordre',),
'frabeordrete': ('frabeordre',),
'fradragsberettiga': ('fradragsberettiga',),
'fradragsberettigede': ('fradragsberettiget',),
'fradragsberettiget': ('fradragsberettiget',),
'fradragsberettigete': ('fradragsberettiget',),
'fradragsberettigetere': ('fradragsberettiget',),
'fradragsberettigetest': ('fradragsberettiget',),
'fradragsberettigeteste': ('fradragsberettiget',),
'fradømmende': ('fradømme',),
'fradømt': ('fradømme',),
'fradømte': ('fradømme',),
'frafallen': ('frafallen',),
'frafallent': ('frafallen',),
'frafalne': ('frafallen',),
'frafalnere': ('frafallen',),
'frafalnest': ('frafallen',),
'frafalneste': ('frafallen',),
'fraflytta': ('fraflytte',),
'fraflyttede': ('fraflytte',),
'fraflyttende': ('fraflytte',),
'fraflyttet': ('fraflytte',),
'fraflyttete': ('fraflytte',),
'fragil': ('fragil',),
'fragile': ('fragil',),
'fragilere': ('fragil',),
'fragilest': ('fragil',),
'fragileste': ('fragil',),
'fragilt': ('fragil',),
'fragmentarisk': ('fragmentarisk',),
'fragmentariske': ('fragmentarisk',),
'fragmentariskere': ('fragmentarisk',),
'fragmentariskest': ('fragmentarisk',),
'fragmentariskeste': ('fragmentarisk',),
'fragmenterende': ('fragmentere',),
'fragmentert': ('fragmentere',),
'fragmenterte': ('fragmentere',),
'fragående': ('fragå',),
'fragått': ('fragå',),
'fragåtte': ('fragå',),
'fraise': ('fraise',),
'frakjennende': ('frakjenne',),
'frakjent': ('frakjenne',),
'frakjente': ('frakjenne',),
'frakobla': ('frakobla',),
'frakobla': ('frakoble',),
'frakoblede': ('frakoble',),
'frakoblende': ('frakoble',),
'frakoblet': ('frakoble',),
'frakoblete': ('frakoble',),
'frakoblede': ('frakoblet',),
'frakoblet': ('frakoblet',),
'frakoblete': ('frakoblet',),
'frakobletere': ('frakoblet',),
'frakobletest': ('frakoblet',),
'frakobleteste': ('frakoblet',),
'frakopla': ('frakopla',),
'frakopla': ('frakople',),
'frakoplede': ('frakople',),
'frakoplende': ('frakople',),
'frakoplet': ('frakople',),
'frakoplete': ('frakople',),
'frakoplede': ('frakoplet',),
'frakoplet': ('frakoplet',),
'frakoplete': ('frakoplet',),
'frakopletere': ('frakoplet',),
'frakopletest': ('frakoplet',),
'frakopleteste': ('frakoplet',),
'fraksjonerende': ('fraksjonere',),
'fraksjonert': ('fraksjonere',),
'fraksjonerte': ('fraksjonere',),
'fraktal': ('fraktal',),
'fraktale': ('fraktal',),
'fraktalere': ('fraktal',),
'fraktalest': ('fraktal',),
'fraktaleste': ('fraktal',),
'fraktalt': ('fraktal',),
'frakta': ('frakte',),
'fraktede': ('frakte',),
'fraktende': ('frakte',),
'fraktet': ('frakte',),
'fraktete': ('frakte',),
'fralands': ('fralands',),
'fralagt': ('fralegge',),
'fralagte': ('fralegge',),
'fraleggende': ('fralegge',),
'fralokka': ('fralokke',),
'fralokkede': ('fralokke',),
'fralokkende': ('fralokke',),
'fralokket': ('fralokke',),
'fralokkete': ('fralokke',),
'framdaterende': ('framdatere',),
'framdatert': ('framdatere',),
'framdaterte': ('framdatere',),
'framelska': ('framelske',),
'framelskede': ('framelske',),
'framelskende': ('framelske',),
'framelsket': ('framelske',),
'framelskete': ('framelske',),
'framfaren': ('framfaren',),
'framfarent': ('framfaren',),
'framfarne': ('framfaren',),
'framfarnere': ('framfaren',),
'framfarnest': ('framfaren',),
'framfarneste': ('framfaren',),
'framfus': ('framfus',),
'framfuse': ('framfus',),
'framfusere': ('framfus',),
'framfusest': ('framfus',),
'framfuseste': ('framfus',),
'framfust': ('framfus',),
'framfusende': ('framfusende',),
'framførende': ('framføre',),
'framført': ('framføre',),
'framførte': ('framføre',),
'framgangsrik': ('framgangsrik',),
'framgangsrike': ('framgangsrik',),
'framgangsrikere': ('framgangsrik',),
'framgangsrikest': ('framgangsrik',),
'framgangsrikeste': ('framgangsrik',),
'framgangsrikt': ('framgangsrik',),
'framgående': ('framgå',),
'framgått': ('framgå',),
'framgåtte': ('framgå',),
'framherskende': ('framherskende',),
'framheva': ('framheve',),
'framhevd': ('framheve',),
'framhevde': ('framheve',),
'framhevede': ('framheve',),
'framhevende': ('framheve',),
'framhevet': ('framheve',),
'framhevete': ('framheve',),
'framholdende': ('framholde',),
'framholdt': ('framholde',),
'framholdte': ('framholde',),
'framifrå': ('framifrå',),
'framkallende': ('framkalle',),
'framkalt': ('framkalle',),
'framkalte': ('framkalle',),
'framkasta': ('framkaste',),
'framkastede': ('framkaste',),
'framkastende': ('framkaste',),
'framkastet': ('framkaste',),
'framkastete': ('framkaste',),
'framkommelig': ('framkommelig',),
'framkommelige': ('framkommelig',),
'framkommeligere': ('framkommelig',),
'framkommeligst': ('framkommelig',),
'framkommeligste': ('framkommelig',),
'framlagt': ('framlegge',),
'framlagte': ('framlegge',),
'framleggende': ('framlegge',),
'framleid': ('framleie',),
'framleide': ('framleie',),
'framleiede': ('framleie',),
'framleiende': ('framleie',),
'framleiet': ('framleie',),
'framleiete': ('framleie',),
'framlut': ('framlut',),
'framlute': ('framlut',),
'framlutere': ('framlut',),
'framlutest': ('framlut',),
'framluteste': ('framlut',),
'framlutt': ('framlut',),
'frammøtt': ('frammøtt',),
'frammøtte': ('frammøtt',),
'frammøttere': ('frammøtt',),
'frammøttest': ('frammøtt',),
'frammøtteste': ('frammøtt',),
'framoverbøyd': ('framoverbøyd',),
'framoverbøyde': ('framoverbøyd',),
'framoverbøydere': ('framoverbøyd',),
'framoverbøydest': ('framoverbøyd',),
'framoverbøydeste': ('framoverbøyd',),
'framoverlut': ('framoverlut',),
'framoverlute': ('framoverlut',),
'framoverlutere': ('framoverlut',),
'framoverlutest': ('framoverlut',),
'framoverluteste': ('framoverlut',),
'framoverlutt': ('framoverlut',),
'framsatt': ('framsette',),
'framsatte': ('framsette',),
'framsettende': ('framsette',),
'framsagt': ('framsi',),
'framsagte': ('framsi',),
'framsiende': ('framsi',),
'framskaffa': ('framskaffe',),
'framskaffede': ('framskaffe',),
'framskaffende': ('framskaffe',),
'framskaffet': ('framskaffe',),
'framskaffete': ('framskaffe',),
'framskreden': ('framskreden',),
'framskredent': ('framskreden',),
'framskredne': ('framskreden',),
'framskrednere': ('framskreden',),
'framskrednest': ('framskreden',),
'framskredneste': ('framskreden',),
'framskrittsfiendtlig': ('framskrittsfiendtlig',),
'framskrittsfiendtlige': ('framskrittsfiendtlig',),
'framskrittsfiendtligere': ('framskrittsfiendtlig',),
'framskrittsfiendtligst': ('framskrittsfiendtlig',),
'framskrittsfiendtligste': ('framskrittsfiendtlig',),
'framskrittsvennlig': ('framskrittsvennlig',),
'framskrittsvennlige': ('framskrittsvennlig',),
'framskrittsvennligere': ('framskrittsvennlig',),
'framskrittsvennligst': ('framskrittsvennlig',),
'framskrittsvennligste': ('framskrittsvennlig',),
'framskreven': ('framskrive',),
'framskrevet': ('framskrive',),
'framskrevne': ('framskrive',),
'framskrivende': ('framskrive',),
'framskutt': ('framskutt',),
'framskutte': ('framskutt',),
'framskuttere': ('framskutt',),
'framskuttest': ('framskutt',),
'framskutteste': ('framskutt',),
'framskynda': ('framskynde',),
'framskyndede': ('framskynde',),
'framskyndende': ('framskynde',),
'framskyndet': ('framskynde',),
'framskyndete': ('framskynde',),
'framskyndt': ('framskynde',),
'framskyndte': ('framskynde',),
'framskutt': ('framskyte',),
'framskutte': ('framskyte',),
'framskytende': ('framskyte',),
'framspringende': ('framspringende',),
'framstillende': ('framstille',),
'framstilt': ('framstille',),
'framstilte': ('framstille',),
'framstående': ('framstå',),
'framstått': ('framstå',),
'framståtte': ('framstå',),
'framstående': ('framstående',),
'framsynt': ('framsynt',),
'framsynte': ('framsynt',),
'framsyntere': ('framsynt',),
'framsyntest': ('framsynt',),
'framsynteste': ('framsynt',),
'framtidig': ('framtidig',),
'framtidige': ('framtidig',),
'framtidigere': ('framtidig',),
'framtidigst': ('framtidig',),
'framtidigste': ('framtidig',),
'framtidsretta': ('framtidsretta',),
'framtidsrettede': ('framtidsrettet',),
'framtidsrettet': ('framtidsrettet',),
'framtidsrettete': ('framtidsrettet',),
'framtidsrettetere': ('framtidsrettet',),
'framtidsrettetest': ('framtidsrettet',),
'framtidsretteteste': ('framtidsrettet',),
'framtredende': ('framtredende',),
'framvisende': ('framvise',),
'framvist': ('framvise',),
'framviste': ('framvise',),
'franarra': ('franarre',),
'franarrede': ('franarre',),
'franarrende': ('franarre',),
'franarret': ('franarre',),
'franarrete': ('franarre',),
'frank': ('frank',),
'franke': ('frank',),
'frankere': ('frank',),
'frankest': ('frank',),
'frankeste': ('frank',),
'frankt': ('frank',),
'frankerende': ('frankere',),
'frankert': ('frankere',),
'frankerte': ('frankere',),
'frankofil': ('frankofil',),
'frankofile': ('frankofil',),
'frankofilere': ('frankofil',),
'frankofilest': ('frankofil',),
'frankofileste': ('frankofil',),
'frankofilt': ('frankofil',),
'frankoman': ('frankoman',),
'frankomane': ('frankoman',),
'frankomanere': ('frankoman',),
'frankomanest': ('frankoman',),
'frankomaneste': ('frankoman',),
'frankomant': ('frankoman',),
'fransk': ('fransk',),
'franske': ('fransk',),
'franskere': ('fransk',),
'franskest': ('fransk',),
'franskeste': ('fransk',),
'frappant': ('frappant',),
'frappante': ('frappant',),
'frappantere': ('frappant',),
'frappantest': ('frappant',),
'frappanteste': ('frappant',),
'frappantt': ('frappant',),
'frapperende': ('frappere',),
'frappert': ('frappere',),
'frapperte': ('frappere',),
'frapperende': ('frapperende',),
'frarana': ('frarane',),
'fraranede': ('frarane',),
'fraranende': ('frarane',),
'fraranet': ('frarane',),
'fraranete': ('frarane',),
'frarant': ('frarane',),
'frarante': ('frarane',),
'fraregna': ('fraregna',),
'fraregnede': ('fraregnet',),
'fraregnet': ('fraregnet',),
'fraregnete': ('fraregnet',),
'fraregnetere': ('fraregnet',),
'fraregnetest': ('fraregnet',),
'fraregneteste': ('fraregnet',),
'frarekna': ('frarekna',),
'frareknede': ('frareknet',),
'frareknet': ('frareknet',),
'frareknete': ('frareknet',),
'frareknetere': ('frareknet',),
'frareknetest': ('frareknet',),
'frarekneteste': ('frareknet',),
'frarådd': ('frarå',),
'frarådde': ('frarå',),
'frarående': ('frarå',),
'fraråda': ('fraråde',),
'frarådd': ('fraråde',),
'frarådde': ('fraråde',),
'frarådede': ('fraråde',),
'frarådende': ('fraråde',),
'frarådet': ('fraråde',),
'frarådete': ('fraråde',),
'frasefylt': ('frasefylt',),
'frasefylte': ('frasefylt',),
'frasefyltere': ('frasefylt',),
'frasefyltest': ('frasefylt',),
'frasefylteste': ('frasefylt',),
'fraselgende': ('fraselge',),
'frasolgt': ('fraselge',),
'frasolgte': ('fraselge',),
'fraseologisk': ('fraseologisk',),
'fraseologiske': ('fraseologisk',),
'fraseologiskere': ('fraseologisk',),
'fraseologiskest': ('fraseologisk',),
'fraseologiskeste': ('fraseologisk',),
'fraseparert': ('fraseparert',),
'fraseparerte': ('fraseparert',),
'fraseparertere': ('fraseparert',),
'fraseparertest': ('fraseparert',),
'fraseparerteste': ('fraseparert',),
'fraserende': ('frasere',),
'frasert': ('frasere',),
'fraserte': ('frasere',),
'frasagt': ('frasi',),
'frasagte': ('frasi',),
'frasiende': ('frasi',),
'fraskillende': ('fraskille',),
'fraskilt': ('fraskille',),
'fraskilte': ('fraskille',),
'fraskjøta': ('fraskjøte',),
'fraskjøtede': ('fraskjøte',),
'fraskjøtende': ('fraskjøte',),
'fraskjøtet': ('fraskjøte',),
'fraskjøtete': ('fraskjøte',),
'fraskjøtt': ('fraskjøte',),
'fraskjøtte': ('fraskjøte',),
'fraskreven': ('fraskrive',),
'fraskrevet': ('fraskrive',),
'fraskrevne': ('fraskrive',),
'fraskrivende': ('fraskrive',),
'frastjelende': ('frastjele',),
'frastjålen': ('frastjele',),
'frastjålet': ('frastjele',),
'frastjålne': ('frastjele',),
'frastøtende': ('frastøte',),
'frastøtt': ('frastøte',),
'frastøtte': ('frastøte',),
'frastøtende': ('frastøtende',),
'fratakende': ('frata',),
'fratatt': ('frata',),
'fratatte': ('frata',),
'fraterniserende': ('fraternisere',),
'fraternisert': ('fraternisere',),
'fraterniserte': ('fraternisere',),
'fratredende': ('fratre',),
'fratrådt': ('fratre',),
'fratrådte': ('fratre',),
'fraveken': ('fravike',),
'fraveket': ('fravike',),
'fravekne': ('fravike',),
'fravikende': ('fravike',),
'fravikelig': ('fravikelig',),
'fravikelige': ('fravikelig',),
'fravikeligere': ('fravikelig',),
'fravikeligst': ('fravikelig',),
'fravikeligste': ('fravikelig',),
'fravrista': ('fravriste',),
'fravristede': ('fravriste',),
'fravristende': ('fravriste',),
'fravristet': ('fravriste',),
'fravristete': ('fravriste',),
'fraværende': ('fraværende',),
'freda': ('frede',),
'fredede': ('frede',),
'fredende': ('frede',),
'fredet': ('frede',),
'fredete': ('frede',),
'fredelig': ('fredelig',),
'fredelige': ('fredelig',),
'fredeligere': ('fredelig',),
'fredeligst': ('fredelig',),
'fredeligste': ('fredelig',),
'fredeligsinna': ('fredeligsinna',),
'fredeligsinnede': ('fredeligsinnet',),
'fredeligsinnet': ('fredeligsinnet',),
'fredeligsinnete': ('fredeligsinnet',),
'fredeligsinnetere': ('fredeligsinnet',),
'fredeligsinnetest': ('fredeligsinnet',),
'fredeligsinneteste': ('fredeligsinnet',),
'fredfull': ('fredfull',),
'fredfulle': ('fredfull',),
'fredfullere': ('fredfull',),
'fredfullest': ('fredfull',),
'fredfulleste': ('fredfull',),
'fredfullt': ('fredfull',),
'fredhellig': ('fredhellig',),
'fredhellige': ('fredhellig',),
'fredhelligere': ('fredhellig',),
'fredhelligst': ('fredhellig',),
'fredhelligste': ('fredhellig',),
'fredlaus': ('fredlaus',),
'fredlause': ('fredlaus',),
'fredlausere': ('fredlaus',),
'fredlausest': ('fredlaus',),
'fredlauseste': ('fredlaus',),
'fredlaust': ('fredlaus',),
'fredløs': ('fredløs',),
'fredløse': ('fredløs',),
'fredløsere': ('fredløs',),
'fredløsest': ('fredløs',),
'fredløseste': ('fredløs',),
'fredløst': ('fredløs',),
'fredsbevarende': ('fredsbevarende',),
'fredselskende': ('fredselskende',),
'fredsommelig': ('fredsommelig',),
'fredsommelige': ('fredsommelig',),
'fredsommeligere': ('fredsommelig',),
'fredsommeligst': ('fredsommelig',),
'fredsommeligste': ('fredsommelig',),
'fredsæl': ('fredsæl',),
'fredsæle': ('fredsæl',),
'fredsælere': ('fredsæl',),
'fredsælest': ('fredsæl',),
'fredsæleste': ('fredsæl',),
'fredsælt': ('fredsæl',),
'frega': ('frege',),
'fregede': ('frege',),
'fregende': ('frege',),
'freget': ('frege',),
'fregete': ('frege',),
'fregnet': ('fregnet',),
'fregnete': ('fregnet',),
'fregnetere': ('fregnet',),
'fregnetest': ('fregnet',),
'fregneteste': ('fregnet',),
'fregnete': ('fregnete',),
'freidig': ('freidig',),
'freidige': ('freidig',),
'freidigere': ('freidig',),
'freidigst': ('freidig',),
'freidigste': ('freidig',),
'frekk': ('frekk',),
'frekke': ('frekk',),
'frekkere': ('frekk',),
'frekkest': ('frekk',),
'frekkeste': ('frekk',),
'frekt': ('frekk',),
'frekvent': ('frekvent',),
'frekvente': ('frekvent',),
'frekventere': ('frekvent',),
'frekventest': ('frekvent',),
'frekventeste': ('frekvent',),
'frekventerende': ('frekventere',),
'frekventert': ('frekventere',),
'frekventerte': ('frekventere',),
'frelsende': ('frelse',),
'frelst': ('frelse',),
'frelste': ('frelse',),
'frelst': ('frelst',),
'frelste': ('frelst',),
'frelstere': ('frelst',),
'frelstest': ('frelst',),
'frelsteste': ('frelst',),
'fremadretta': ('fremadretta',),
'fremadrettede': ('fremadrettet',),
'fremadrettet': ('fremadrettet',),
'fremadrettete': ('fremadrettet',),
'fremadrettetere': ('fremadrettet',),
'fremadrettetest': ('fremadrettet',),
'fremadretteteste': ('fremadrettet',),
'fremadstormende': ('fremadstormende',),
'fremadstrebende': ('fremadstrebende',),
'fremdaterende': ('fremdatere',),
'fremdatert': ('fremdatere',),
'fremdaterte': ('fremdatere',),
'fremelska': ('fremelske',),
'fremelskede': ('fremelske',),
'fremelskende': ('fremelske',),
'fremelsket': ('fremelske',),
'fremelskete': ('fremelske',),
'fremfaren': ('fremfaren',),
'fremfarent': ('fremfaren',),
'fremfarne': ('fremfaren',),
'fremfarnere': ('fremfaren',),
'fremfarnest': ('fremfaren',),
'fremfarneste': ('fremfaren',),
'fremfus': ('fremfus',),
'fremfuse': ('fremfus',),
'fremfusere': ('fremfus',),
'fremfusest': ('fremfus',),
'fremfuseste': ('fremfus',),
'fremfust': ('fremfus',),
'fremfusende': ('fremfusende',),
'fremførende': ('fremføre',),
'fremført': ('fremføre',),
'fremførte': ('fremføre',),
'fremgangsrik': ('fremgangsrik',),
'fremgangsrike': ('fremgangsrik',),
'fremgangsrikere': ('fremgangsrik',),
'fremgangsrikest': ('fremgangsrik',),
'fremgangsrikeste': ('fremgangsrik',),
'fremgangsrikt': ('fremgangsrik',),
'fremgående': ('fremgå',),
'fremgått': ('fremgå',),
'fremgåtte': ('fremgå',),
'fremherskende': ('fremherskende',),
'fremheva': ('fremheve',),
'fremhevd': ('fremheve',),
'fremhevde': ('fremheve',),
'fremhevede': ('fremheve',),
'fremhevende': ('fremheve',),
'fremhevet': ('fremheve',),
'fremhevete': ('fremheve',),
'fremholdende': ('fremholde',),
'fremholdt': ('fremholde',),
'fremholdte': ('fremholde',),
'fremkallende': ('fremkalle',),
'fremkalt': ('fremkalle',),
'fremkalte': ('fremkalle',),
'fremkasta': ('fremkaste',),
'fremkastede': ('fremkaste',),
'fremkastende': ('fremkaste',),
'fremkastet': ('fremkaste',),
'fremkastete': ('fremkaste',),
'fremkommelig': ('fremkommelig',),
'fremkommelige': ('fremkommelig',),
'fremkommeligere': ('fremkommelig',),
'fremkommeligst': ('fremkommelig',),
'fremkommeligste': ('fremkommelig',),
'fremlagt': ('fremlegge',),
'fremlagte': ('fremlegge',),
'fremleggende': ('fremlegge',),
'fremleid': ('fremleie',),
'fremleide': ('fremleie',),
'fremleiede': ('fremleie',),
'fremleiende': ('fremleie',),
'fremleiet': ('fremleie',),
'fremleiete': ('fremleie',),
'fremlut': ('fremlut',),
'fremlute': ('fremlut',),
'fremlutere': ('fremlut',),
'fremlutest': ('fremlut',),
'fremluteste': ('fremlut',),
'fremlutt': ('fremlut',),
'fremma': ('fremme',),
'fremmede': ('fremme',),
'fremmende': ('fremme',),
'fremmet': ('fremme',),
'fremmete': ('fremme',),
'fremmed': ('fremmed',),
'fremmede': ('fremmed',),
'fremmedere': ('fremmed',),
'fremmedest': ('fremmed',),
'fremmedeste': ('fremmed',),
'fremmed': ('fremmed',),
'fremmede': ('fremmed',),
'fremmedere': ('fremmed',),
'fremmedest': ('fremmed',),
'fremmedeste': ('fremmed',),
'fremmedarta': ('fremmedarta',),
'fremmedarta': ('fremmedarta',),
'fremmedartede': ('fremmedartet',),
'fremmedartet': ('fremmedartet',),
'fremmedartete': ('fremmedartet',),
'fremmedartetere': ('fremmedartet',),
'fremmedartetest': ('fremmedartet',),
'fremmedarteteste': ('fremmedartet',),
'fremmedartede': ('fremmedartet',),
'fremmedartet': ('fremmedartet',),
'fremmedartete': ('fremmedartet',),
'fremmedartetere': ('fremmedartet',),
'fremmedartetest': ('fremmedartet',),
'fremmedarteteste': ('fremmedartet',),
'fremmedgjort': ('fremmedgjøre',),
'fremmedgjorte': ('fremmedgjøre',),
'fremmedgjørende': ('fremmedgjøre',),
'fremmedgjort': ('fremmedgjøre',),
'fremmedgjorte': ('fremmedgjøre',),
'fremmedgjørende': ('fremmedgjøre',),
'fremmedspråklig': ('fremmedspråklig',),
'fremmedspråklige': ('fremmedspråklig',),
'fremmedspråkligere': ('fremmedspråklig',),
'fremmedspråkligst': ('fremmedspråklig',),
'fremmedspråkligste': ('fremmedspråklig',),
'fremmedspråklig': ('fremmedspråklig',),
'fremmedspråklige': ('fremmedspråklig',),
'fremmedspråkligere': ('fremmedspråklig',),
'fremmedspråkligst': ('fremmedspråklig',),
'fremmedspråkligste': ('fremmedspråklig',),
'fremmelig': ('fremmelig',),
'fremmelige': ('fremmelig',),
'fremmeligere': ('fremmelig',),
'fremmeligst': ('fremmelig',),
'fremmeligste': ('fremmelig',),
'fremmend': ('fremmend',),
'fremmende': ('fremmend',),
'fremmendere': ('fremmend',),
'fremmendest': ('fremmend',),
'fremmendeste': ('fremmend',),
'fremmendt': ('fremmend',),
'fremmend': ('fremmend',),
'fremmende': ('fremmend',),
'fremmendere': ('fremmend',),
'fremmendest': ('fremmend',),
'fremmendeste': ('fremmend',),
'fremmendt': ('fremmend',),
'fremmendarta': ('fremmendarta',),
'fremmendarta': ('fremmendarta',),
'fremmendartede': ('fremmendartet',),
'fremmendartet': ('fremmendartet',),
'fremmendartete': ('fremmendartet',),
'fremmendartetere': ('fremmendartet',),
'fremmendartetest': ('fremmendartet',),
'fremmendarteteste': ('fremmendartet',),
'fremmendartede': ('fremmendartet',),
'fremmendartet': ('fremmendartet',),
'fremmendartete': ('fremmendartet',),
'fremmendartetere': ('fremmendartet',),
'fremmendartetest': ('fremmendartet',),
'fremmendarteteste': ('fremmendartet',),
'fremmendgjort': ('fremmendgjøre',),
'fremmendgjorte': ('fremmendgjøre',),
'fremmendgjørende': ('fremmendgjøre',),
'fremmendgjort': ('fremmendgjøre',),
'fremmendgjorte': ('fremmendgjøre',),
'fremmendgjørende': ('fremmendgjøre',),
'fremmendspråklig': ('fremmendspråklig',),
'fremmendspråklige': ('fremmendspråklig',),
'fremmendspråkligere': ('fremmendspråklig',),
'fremmendspråkligst': ('fremmendspråklig',),
'fremmendspråkligste': ('fremmendspråklig',),
'fremmendspråklig': ('fremmendspråklig',),
'fremmendspråklige': ('fremmendspråklig',),
'fremmendspråkligere': ('fremmendspråklig',),
'fremmendspråkligst': ('fremmendspråklig',),
'fremmendspråkligste': ('fremmendspråklig',),
'fremmøtt': ('fremmøtt',),
'fremmøtte': ('fremmøtt',),
'fremmøttere': ('fremmøtt',),
'fremmøttest': ('fremmøtt',),
'fremmøtteste': ('fremmøtt',),
'fremoverbøyd': ('fremoverbøyd',),
'fremoverbøyde': ('fremoverbøyd',),
'fremoverbøydere': ('fremoverbøyd',),
'fremoverbøydest': ('fremoverbøyd',),
'fremoverbøydeste': ('fremoverbøyd',),
'fremoverlut': ('fremoverlut',),
'fremoverlute': ('fremoverlut',),
'fremoverlutere': ('fremoverlut',),
'fremoverlutest': ('fremoverlut',),
'fremoverluteste': ('fremoverlut',),
'fremoverlutt': ('fremoverlut',),
'fremragende': ('fremragende',),
'fremre': ('fremre',),
'fremst': ('fremre',),
'fremste': ('fremre',),
'fremsatt': ('fremsette',),
'fremsatte': ('fremsette',),
'fremsettende': ('fremsette',),
'fremsagt': ('fremsi',),
'fremsagte': ('fremsi',),
'fremsiende': ('fremsi',),
'fremskaffa': ('fremskaffe',),
'fremskaffede': ('fremskaffe',),
'fremskaffende': ('fremskaffe',),
'fremskaffet': ('fremskaffe',),
'fremskaffete': ('fremskaffe',),
'fremskreden': ('fremskreden',),
'fremskredent': ('fremskreden',),
'fremskredne': ('fremskreden',),
'fremskrednere': ('fremskreden',),
'fremskrednest': ('fremskreden',),
'fremskredneste': ('fremskreden',),
'fremskrittsfiendtlig': ('fremskrittsfiendtlig',),
'fremskrittsfiendtlige': ('fremskrittsfiendtlig',),
'fremskrittsfiendtligere': ('fremskrittsfiendtlig',),
'fremskrittsfiendtligst': ('fremskrittsfiendtlig',),
'fremskrittsfiendtligste': ('fremskrittsfiendtlig',),
'fremskrittsvennlig': ('fremskrittsvennlig',),
'fremskrittsvennlige': ('fremskrittsvennlig',),
'fremskrittsvennligere': ('fremskrittsvennlig',),
'fremskrittsvennligst': ('fremskrittsvennlig',),
'fremskrittsvennligste': ('fremskrittsvennlig',),
'fremskreven': ('fremskrive',),
'fremskrevet': ('fremskrive',),
'fremskrevne': ('fremskrive',),
'fremskrivende': ('fremskrive',),
'fremskutt': ('fremskutt',),
'fremskutte': ('fremskutt',),
'fremskuttere': ('fremskutt',),
'fremskuttest': ('fremskutt',),
'fremskutteste': ('fremskutt',),
'fremskynda': ('fremskynde',),
'fremskyndede': ('fremskynde',),
'fremskyndende': ('fremskynde',),
'fremskyndet': ('fremskynde',),
'fremskyndete': ('fremskynde',),
'fremskyndt': ('fremskynde',),
'fremskyndte': ('fremskynde',),
'fremskutt': ('fremskyte',),
'fremskutte': ('fremskyte',),
'fremskytende': ('fremskyte',),
'fremspringende': ('fremspringende',),
'fremstillende': ('fremstille',),
'fremstilt': ('fremstille',),
'fremstilte': ('fremstille',),
'fremstående': ('fremstå',),
'fremstått': ('fremstå',),
'fremståtte': ('fremstå',),
'fremstående': ('fremstående',),
'fremsynt': ('fremsynt',),
'fremsynte': ('fremsynt',),
'fremsyntere': ('fremsynt',),
'fremsyntest': ('fremsynt',),
'fremsynteste': ('fremsynt',),
'fremtidig': ('fremtidig',),
'fremtidige': ('fremtidig',),
'fremtidigere': ('fremtidig',),
'fremtidigst': ('fremtidig',),
'fremtidigste': ('fremtidig',),
'fremtidsretta': ('fremtidsretta',),
'fremtidsrettede': ('fremtidsrettet',),
'fremtidsrettet': ('fremtidsrettet',),
'fremtidsrettete': ('fremtidsrettet',),
'fremtidsrettetere': ('fremtidsrettet',),
'fremtidsrettetest': ('fremtidsrettet',),
'fremtidsretteteste': ('fremtidsrettet',),
'fremtredende': ('fremtredende',),
'fremvisende': ('fremvise',),
'fremvist': ('fremvise',),
'fremviste': ('fremvise',),
'frenetisk': ('frenetisk',),
'frenetiske': ('frenetisk',),
'frenetiskere': ('frenetisk',),
'frenetiskest': ('frenetisk',),
'frenetiskeste': ('frenetisk',),
'fresende': ('frese',),
'frest': ('frese',),
'freste': ('frese',),
'fresende': ('frese',),
'frest': ('frese',),
'freste': ('frese',),
'fresta': ('freste',),
'frestede': ('freste',),
'frestende': ('freste',),
'frestet': ('freste',),
'frestete': ('freste',),
'fretta': ('frette',),
'frettede': ('frette',),
'frettende': ('frette',),
'frettet': ('frette',),
'frettete': ('frette',),
'freudiansk': ('freudiansk',),
'freudianske': ('freudiansk',),
'freudianskere': ('freudiansk',),
'freudianskest': ('freudiansk',),
'freudianskeste': ('freudiansk',),
'freudsk': ('freudsk',),
'freudske': ('freudsk',),
'freudskere': ('freudsk',),
'freudskest': ('freudsk',),
'freudskeste': ('freudsk',),
'fridd': ('fri',),
'fridde': ('fri',),
'friende': ('fri',),
'fridd': ('fri',),
'fridde': ('fri',),
'friende': ('fri',),
'fri': ('fri',),
'frie': ('fri',),
'friere': ('fri',),
'friest': ('fri',),
'frieste': ('fri',),
'fritt': ('fri',),
'fribåren': ('fribåren',),
'fribårent': ('fribåren',),
'fribårne': ('fribåren',),
'fribårnere': ('fribåren',),
'fribårnest': ('fribåren',),
'fribårneste': ('fribåren',),
'frigiende': ('frigi',),
'frigitt': ('frigi',),
'frigitte': ('frigi',),
'frigivende': ('frigi',),
'frigid': ('frigid',),
'frigide': ('frigid',),
'frigidere': ('frigid',),
'frigidest': ('frigid',),
'frigideste': ('frigid',),
'frigjort': ('frigjort',),
'frigjorte': ('frigjort',),
'frigjortere': ('frigjort',),
'frigjortest': ('frigjort',),
'frigjorteste': ('frigjort',),
'frigjort': ('frigjøre',),
'frigjorte': ('frigjøre',),
'frigjørende': ('frigjøre',),
'frigjørende': ('frigjørende',),
'frikativ': ('frikativ',),
'frikative': ('frikativ',),
'frikativere': ('frikativ',),
'frikativest': ('frikativ',),
'frikativeste': ('frikativ',),
'frikativt': ('frikativ',),
'friket': ('friket',),
'frikete': ('friket',),
'friketere': ('friket',),
'friketest': ('friket',),
'friketeste': ('friket',),
'frikete': ('frikete',),
'frikjennende': ('frikjenne',),
'frikjent': ('frikjenne',),
'frikjente': ('frikjenne',),
'frikostig': ('frikostig',),
'frikostige': ('frikostig',),
'frikostigere': ('frikostig',),
'frikostigst': ('frikostig',),
'frikostigste': ('frikostig',),
'friksjonsfri': ('friksjonsfri',),
'friksjonsfrie': ('friksjonsfri',),
'friksjonsfriere': ('friksjonsfri',),
'friksjonsfriest': ('friksjonsfri',),
'friksjonsfrieste': ('friksjonsfri',),
'friksjonsfritt': ('friksjonsfri',),
'frilans': ('frilans',),
'frilansa': ('frilanse',),
'frilansede': ('frilanse',),
'frilansende': ('frilanse',),
'frilanset': ('frilanse',),
'frilansete': ('frilanse',),
'frilista': ('friliste',),
'frilistede': ('friliste',),
'frilistende': ('friliste',),
'frilistet': ('friliste',),
'frilistete': ('friliste',),
'frilynt': ('frilynt',),
'frilynte': ('frilynt',),
'frilyntere': ('frilynt',),
'frilyntest': ('frilynt',),
'frilynteste': ('frilynt',),
'frimodig': ('frimodig',),
'frimodige': ('frimodig',),
'frimodigere': ('frimodig',),
'frimodigst': ('frimodig',),
'frimodigste': ('frimodig',),
'fripostig': ('fripostig',),
'fripostige': ('fripostig',),
'fripostigere': ('fripostig',),
'fripostigst': ('fripostig',),
'fripostigste': ('fripostig',),
'frirådig': ('frirådig',),
'frirådige': ('frirådig',),
'frirådigere': ('frirådig',),
'frirådigst': ('frirådig',),
'frirådigste': ('frirådig',),
'friserende': ('frisere',),
'frisert': ('frisere',),
'friserte': ('frisere',),
'frisinna': ('frisinna',),
'frisinnede': ('frisinnet',),
'frisinnet': ('frisinnet',),
'frisinnete': ('frisinnet',),
'frisinnetere': ('frisinnet',),
'frisinnetest': ('frisinnet',),
'frisinneteste': ('frisinnet',),
'frisisk': ('frisisk',),
'frisiske': ('frisisk',),
'frisiskere': ('frisisk',),
'frisiskest': ('frisisk',),
'frisiskeste': ('frisisk',),
'frisk': ('frisk',),
'friske': ('frisk',),
'friskere': ('frisk',),
'friskest': ('frisk',),
'friskeste': ('frisk',),
'friskt': ('frisk',),
'friska': ('friske',),
'friskede': ('friske',),
'friskende': ('friske',),
'frisket': ('friske',),
'friskete': ('friske',),
'friskfyraktig': ('friskfyraktig',),
'friskfyraktige': ('friskfyraktig',),
'friskfyraktigere': ('friskfyraktig',),
'friskfyraktigst': ('friskfyraktig',),
'friskfyraktigste': ('friskfyraktig',),
'friskmeldende': ('friskmelde',),
'friskmeldt': ('friskmelde',),
'friskmeldte': ('friskmelde',),
'friskna': ('friskne',),
'frisknede': ('friskne',),
'frisknende': ('friskne',),
'frisknet': ('friskne',),
'frisknete': ('friskne',),
'frista': ('friste',),
'fristede': ('friste',),
'fristende': ('friste',),
'fristet': ('friste',),
'fristete': ('friste',),
'frista': ('friste',),
'fristede': ('friste',),
'fristende': ('friste',),
'fristet': ('friste',),
'fristete': ('friste',),
'frista': ('friste',),
'fristede': ('friste',),
'fristende': ('friste',),
'fristet': ('friste',),
'fristete': ('friste',),
'fristende': ('fristende',),
'fritakende': ('frita',),
'fritatt': ('frita',),
'fritatte': ('frita',),
'fritalende': ('fritalende',),
'fritenkersk': ('fritenkersk',),
'fritenkerske': ('fritenkersk',),
'fritenkerskere': ('fritenkersk',),
'fritenkerskest': ('fritenkersk',),
'fritenkerskeste': ('fritenkersk',),
'friterende': ('fritere',),
'fritert': ('fritere',),
'friterte': ('fritere',),
'fritt-talende': ('fritt-talende',),
'frittalende': ('frittalende',),
'fritta': ('fritte',),
'frittede': ('fritte',),
'frittende': ('fritte',),
'frittet': ('fritte',),
'frittete': ('fritte',),
'frittliggende': ('frittliggende',),
'frittstående': ('frittstående',),
'frityrkokt': ('frityrkokt',),
'frityrkokte': ('frityrkokt',),
'frityrkoktere': ('frityrkokt',),
'frityrkoktest': ('frityrkokt',),
'frityrkokteste': ('frityrkokt',),
'frityrsteikt': ('frityrsteikt',),
'frityrsteikte': ('frityrsteikt',),
'frityrsteiktere': ('frityrsteikt',),
'frityrsteiktest': ('frityrsteikt',),
'frityrsteikteste': ('frityrsteikt',),
'frityrstekt': ('frityrstekt',),
'frityrstekte': ('frityrstekt',),
'frityrstektere': ('frityrstekt',),
'frityrstektest': ('frityrstekt',),
'frityrstekteste': ('frityrstekt',),
'frivillig': ('frivillig',),
'frivillige': ('frivillig',),
'frivilligere': ('frivillig',),
'frivilligst': ('frivillig',),
'frivilligste': ('frivillig',),
'frivol': ('frivol',),
'frivole': ('frivol',),
'frivolere': ('frivol',),
'frivolest': ('frivol',),
'frivoleste': ('frivol',),
'frivolt': ('frivol',),
'frodig': ('frodig',),
'frodige': ('frodig',),
'frodigere': ('frodig',),
'frodigst': ('frodig',),
'frodigste': ('frodig',),
'from': ('from',),
'fromme': ('from',),
'frommere': ('from',),
'frommest': ('from',),
'frommeste': ('from',),
'fromt': ('from',),
'fronderende': ('frondere',),
'frondert': ('frondere',),
'fronderte': ('frondere',),
'frontal': ('frontal',),
'frontale': ('frontal',),
'frontalere': ('frontal',),
'frontalest': ('frontal',),
'frontaleste': ('frontal',),
'frontalt': ('frontal',),
'frosne': ('frossen',),
'frosnere': ('frossen',),
'frosnest': ('frossen',),
'frosneste': ('frossen',),
'frossen': ('frossen',),
'frossent': ('frossen',),
'frostlendt': ('frostlendt',),
'frostlendte': ('frostlendt',),
'frostlendtere': ('frostlendt',),
'frostlendtest': ('frostlendt',),
'frostlendteste': ('frostlendt',),
'frostskada': ('frostskada',),
'frostskadd': ('frostskadd',),
'frostskadde': ('frostskadd',),
'frostskaddere': ('frostskadd',),
'frostskaddest': ('frostskadd',),
'frostskaddeste': ('frostskadd',),
'frostskadede': ('frostskadet',),
'frostskadet': ('frostskadet',),
'frostskadete': ('frostskadet',),
'frostskadetere': ('frostskadet',),
'frostskadetest': ('frostskadet',),
'frostskadeteste': ('frostskadet',),
'frotterende': ('frottere',),
'frottert': ('frottere',),
'frotterte': ('frottere',),
'frugal': ('frugal',),
'frugale': ('frugal',),
'frugalere': ('frugal',),
'frugalest': ('frugal',),
'frugaleste': ('frugal',),
'frugalt': ('frugal',),
'fruktbar': ('fruktbar',),
'fruktbare': ('fruktbar',),
'fruktbarere': ('fruktbar',),
'fruktbarest': ('fruktbar',),
'fruktbareste': ('fruktbar',),
'fruktbart': ('fruktbar',),
'fruktbringende': ('fruktbringende',),
'frukta': ('frukte',),
'fruktede': ('frukte',),
'fruktende': ('frukte',),
'fruktet': ('frukte',),
'fruktete': ('frukte',),
'fruktesløs': ('fruktesløs',),
'fruktesløse': ('fruktesløs',),
'fruktesløsere': ('fruktesløs',),
'fruktesløsest': ('fruktesløs',),
'fruktesløseste': ('fruktesløs',),
'fruktesløst': ('fruktesløs',),
'fruktsommelig': ('fruktsommelig',),
'fruktsommelige': ('fruktsommelig',),
'fruktsommeligere': ('fruktsommelig',),
'fruktsommeligst': ('fruktsommelig',),
'fruktsommeligste': ('fruktsommelig',),
'frustrerende': ('frustrere',),
'frustrert': ('frustrere',),
'frustrerte': ('frustrere',),
'fryda': ('fryde',),
'frydede': ('fryde',),
'frydende': ('fryde',),
'frydet': ('fryde',),
'frydete': ('fryde',),
'frydefull': ('frydefull',),
'frydefulle': ('frydefull',),
'frydefullere': ('frydefull',),
'frydefullest': ('frydefull',),
'frydefulleste': ('frydefull',),
'frydefullt': ('frydefull',),
'frygisk': ('frygisk',),
'frygiske': ('frygisk',),
'frygiskere': ('frygisk',),
'frygiskest': ('frygisk',),
'frygiskeste': ('frygisk',),
'fryktblanda': ('fryktblanda',),
'fryktblandede': ('fryktblandet',),
'fryktblandet': ('fryktblandet',),
'fryktblandete': ('fryktblandet',),
'fryktblandetere': ('fryktblandet',),
'fryktblandetest': ('fryktblandet',),
'fryktblandeteste': ('fryktblandet',),
'frykta': ('frykte',),
'fryktede': ('frykte',),
'fryktende': ('frykte',),
'fryktet': ('frykte',),
'fryktete': ('frykte',),
'fryktelig': ('fryktelig',),
'fryktelige': ('fryktelig',),
'frykteligere': ('fryktelig',),
'frykteligst': ('fryktelig',),
'frykteligste': ('fryktelig',),
'fryktinngytende': ('fryktinngytende',),
'fryktlaus': ('fryktlaus',),
'fryktlause': ('fryktlaus',),
'fryktlausere': ('fryktlaus',),
'fryktlausest': ('fryktlaus',),
'fryktlauseste': ('fryktlaus',),
'fryktlaust': ('fryktlaus',),
'fryktløs': ('fryktløs',),
'fryktløse': ('fryktløs',),
'fryktløsere': ('fryktløs',),
'fryktløsest': ('fryktløs',),
'fryktløseste': ('fryktløs',),
'fryktløst': ('fryktløs',),
'fryktsom': ('fryktsom',),
'fryktsomme': ('fryktsom',),
'fryktsommere': ('fryktsom',),
'fryktsomst': ('fryktsom',),
'fryktsomste': ('fryktsom',),
'fryktsomt': ('fryktsom',),
'frynsa': ('frynse',),
'frynsede': ('frynse',),
'frynsende': ('frynse',),
'frynset': ('frynse',),
'frynsete': ('frynse',),
'frynset': ('frynset',),
'frynsete': ('frynset',),
'frynsetere': ('frynset',),
'frynsetest': ('frynset',),
'frynseteste': ('frynset',),
'frynsete': ('frynsete',),
'fråda': ('fråde',),
'frådede': ('fråde',),
'frådende': ('fråde',),
'frådet': ('fråde',),
'frådete': ('fråde',),
'fråssa': ('fråsse',),
'fråssede': ('fråsse',),
'fråssende': ('fråsse',),
'fråsset': ('fråsse',),
'fråssete': ('fråsse',),
'fråtsa': ('fråtse',),
'fråtsede': ('fråtse',),
'fråtsende': ('fråtse',),
'fråtset': ('fråtse',),
'fråtsete': ('fråtse',),
'frødd': ('frø',),
'frødde': ('frø',),
'frøende': ('frø',),
'frøkenaktig': ('frøkenaktig',),
'frøkenaktige': ('frøkenaktig',),
'frøkenaktigere': ('frøkenaktig',),
'frøkenaktigst': ('frøkenaktig',),
'frøkenaktigste': ('frøkenaktig',),
'frøsende': ('frøse',),
'frøst': ('frøse',),
'frøste': ('frøse',),
'frøsen': ('frøsen',),
'frøsent': ('frøsen',),
'frøsne': ('frøsen',),
'frøsnere': ('frøsen',),
'frøsnest': ('frøsen',),
'frøsneste': ('frøsen',),
'fuga': ('fuge',),
'fugede': ('fuge',),
'fugende': ('fuge',),
'fuget': ('fuge',),
'fugete': ('fuge',),
'fuktbestandig': ('fuktbestandig',),
'fuktbestandige': ('fuktbestandig',),
'fuktbestandigere': ('fuktbestandig',),
'fuktbestandigst': ('fuktbestandig',),
'fuktbestandigste': ('fuktbestandig',),
'fukta': ('fukte',),
'fuktede': ('fukte',),
'fuktende': ('fukte',),
'fuktet': ('fukte',),
'fuktete': ('fukte',),
'fuktig': ('fuktig',),
'fuktige': ('fuktig',),
'fuktigere': ('fuktig',),
'fuktigst': ('fuktig',),
'fuktigste': ('fuktig',),
'ful': ('ful',),
'fule': ('ful',),
'fulere': ('ful',),
'fulest': ('ful',),
'fuleste': ('ful',),
'fult': ('ful',),
'full': ('full',),
'fulle': ('full',),
'fullere': ('full',),
'fullest': ('full',),
'fulleste': ('full',),
'fullt': ('full',),
'full-lasta': ('full-lasta',),
'full-lastede': ('full-lastet',),
'full-lastet': ('full-lastet',),
'full-lastete': ('full-lastet',),
'full-lastetere': ('full-lastet',),
'full-lastetest': ('full-lastet',),
'full-lasteteste': ('full-lastet',),
'fullasta': ('fullasta',),
'fullastede': ('fullastet',),
'fullastet': ('fullastet',),
'fullastete': ('fullastet',),
'fullastetere': ('fullastet',),
'fullastetest': ('fullastet',),
'fullasteteste': ('fullastet',),
'fullbefaren': ('fullbefaren',),
'fullbefarent': ('fullbefaren',),
'fullbefarne': ('fullbefaren',),
'fullbefarnere': ('fullbefaren',),
'fullbefarnest': ('fullbefaren',),
'fullbefarneste': ('fullbefaren',),
'fullblods': ('fullblods',),
'fullbragt': ('fullbringe',),
'fullbragte': ('fullbringe',),
'fullbrakt': ('fullbringe',),
'fullbrakte': ('fullbringe',),
'fullbringende': ('fullbringe',),
'fullbyrda': ('fullbyrde',),
'fullbyrdede': ('fullbyrde',),
'fullbyrdende': ('fullbyrde',),
'fullbyrdet': ('fullbyrde',),
'fullbyrdete': ('fullbyrde',),
'fullbåren': ('fullbåren',),
'fullbårent': ('fullbåren',),
'fullbårne': ('fullbåren',),
'fullbårnere': ('fullbåren',),
'fullbårnest': ('fullbåren',),
'fullbårneste': ('fullbåren',),
'fullendende': ('fullende',),
'fullendt': ('fullende',),
'fullendte': ('fullende',),
'fullendt': ('fullendt',),
'fullendte': ('fullendt',),
'fullendtere': ('fullendt',),
'fullendtest': ('fullendt',),
'fullendteste': ('fullendt',),
'fullførende': ('fullføre',),
'fullført': ('fullføre',),
'fullførte': ('fullføre',),
'fullbedre': ('fullgod',),
'fullbest': ('fullgod',),
'fullbeste': ('fullgod',),
'fullgod': ('fullgod',),
'fullgode': ('fullgod',),
'fullgodt': ('fullgod',),
'fullkommen': ('fullkommen',),
'fullkomment': ('fullkommen',),
'fullkomne': ('fullkommen',),
'fullkomnere': ('fullkommen',),
'fullkomnest': ('fullkommen',),
'fullkomneste': ('fullkommen',),
'fullmoden': ('fullmoden',),
'fullmodent': ('fullmoden',),
'fullmodne': ('fullmoden',),
'fullmodnere': ('fullmoden',),
'fullmodnest': ('fullmoden',),
'fullmodneste': ('fullmoden',),
'fullpakka': ('fullpakka',),
'fullpakkede': ('fullpakket',),
'fullpakket': ('fullpakket',),
'fullpakkete': ('fullpakket',),
'fullpakketere': ('fullpakket',),
'fullpakketest': ('fullpakket',),
'fullpakketeste': ('fullpakket',),
'fullrigga': ('fullrigga',),
'fullriggede': ('fullrigget',),
'fullrigget': ('fullrigget',),
'fullriggete': ('fullrigget',),
'fullriggetere': ('fullrigget',),
'fullriggetest': ('fullrigget',),
'fullriggeteste': ('fullrigget',),
'fullrosende': ('fullrose',),
'fullrost': ('fullrose',),
'fullroste': ('fullrose',),
'fullsatt': ('fullsatt',),
'fullsatte': ('fullsatt',),
'fullsattere': ('fullsatt',),
'fullsattest': ('fullsatt',),
'fullsatteste': ('fullsatt',),
'fullstappa': ('fullstappa',),
'fullstappede': ('fullstappet',),
'fullstappet': ('fullstappet',),
'fullstappete': ('fullstappet',),
'fullstappetere': ('fullstappet',),
'fullstappetest': ('fullstappet',),
'fullstappeteste': ('fullstappet',),
'fullstendig': ('fullstendig',),
'fullstendige': ('fullstendig',),
'fullstendigere': ('fullstendig',),
'fullstendigst': ('fullstendig',),
'fullstendigste': ('fullstendig',),
'fulltakka': ('fulltakke',),
'fulltakkede': ('fulltakke',),
'fulltakkende': ('fulltakke',),
'fulltakket': ('fulltakke',),
'fulltakkete': ('fulltakke',),
'fulltallig': ('fulltallig',),
'fulltallige': ('fulltallig',),
'fulltalligere': ('fulltallig',),
'fulltalligst': ('fulltallig',),
'fulltalligste': ('fulltallig',),
'fulltegna': ('fulltegna',),
'fulltegnede': ('fulltegnet',),
'fulltegnet': ('fulltegnet',),
'fulltegnete': ('fulltegnet',),
'fulltegnetere': ('fulltegnet',),
'fulltegnetest': ('fulltegnet',),
'fulltegneteste': ('fulltegnet',),
'fulltonende': ('fulltonende',),
'fullverdig': ('fullverdig',),
'fullverdige': ('fullverdig',),
'fullverdigere': ('fullverdig',),
'fullverdigst': ('fullverdig',),
'fullverdigste': ('fullverdig',),
'fullvoksen': ('fullvoksen',),
'fullvoksent': ('fullvoksen',),
'fullvoksne': ('fullvoksen',),
'fullvoksnere': ('fullvoksen',),
'fullvoksnest': ('fullvoksen',),
'fullvoksneste': ('fullvoksen',),
'fundamental': ('fundamental',),
'fundamentale': ('fundamental',),
'fundamentalere': ('fundamental',),
'fundamentalest': ('fundamental',),
'fundamentaleste': ('fundamental',),
'fundamentalt': ('fundamental',),
'fundamentalistisk': ('fundamentalistisk',),
'fundamentalistiske': ('fundamentalistisk',),
'fundamentalistiskere': ('fundamentalistisk',),
'fundamentalistiskest': ('fundamentalistisk',),
'fundamentalistiskeste': ('fundamentalistisk',),
'fundamenterende': ('fundamentere',),
'fundamentert': ('fundamentere',),
'fundamenterte': ('fundamentere',),
'funderende': ('fundere',),
'fundert': ('fundere',),
'funderte': ('fundere',),
'fungerende': ('fungere',),
'fungert': ('fungere',),
'fungerte': ('fungere',),
'funkla': ('funkle',),
'funklede': ('funkle',),
'funklende': ('funkle',),
'funklet': ('funkle',),
'funklete': ('funkle',),
'funksjonalistisk': ('funksjonalistisk',),
'funksjonalistiske': ('funksjonalistisk',),
'funksjonalistiskere': ('funksjonalistisk',),
'funksjonalistiskest': ('funksjonalistisk',),
'funksjonalistiskeste': ('funksjonalistisk',),
'funksjonell': ('funksjonell',),
'funksjonelle': ('funksjonell',),
'funksjonellere': ('funksjonell',),
'funksjonellest': ('funksjonell',),
'funksjonelleste': ('funksjonell',),
'funksjonelt': ('funksjonell',),
'funksjonerende': ('funksjonere',),
'funksjonert': ('funksjonere',),
'funksjonerte': ('funksjonere',),
'funksjonsdyktig': ('funksjonsdyktig',),
'funksjonsdyktige': ('funksjonsdyktig',),
'funksjonsdyktigere': ('funksjonsdyktig',),
'funksjonsdyktigst': ('funksjonsdyktig',),
'funksjonsdyktigste': ('funksjonsdyktig',),
'funksjonshemma': ('funksjonshemma',),
'funksjonshemmede': ('funksjonshemmet',),
'funksjonshemmet': ('funksjonshemmet',),
'funksjonshemmete': ('funksjonshemmet',),
'funksjonshemmetere': ('funksjonshemmet',),
'funksjonshemmetest': ('funksjonshemmet',),
'funksjonshemmeteste': ('funksjonshemmet',),
'funksjonsriktig': ('funksjonsriktig',),
'funksjonsriktige': ('funksjonsriktig',),
'funksjonsriktigere': ('funksjonsriktig',),
'funksjonsriktigst': ('funksjonsriktig',),
'funksjonsriktigste': ('funksjonsriktig',),
'furasjerende': ('furasjere',),
'furasjert': ('furasjere',),
'furasjerte': ('furasjere',),
'fura': ('fure',),
'furede': ('fure',),
'furende': ('fure',),
'furet': ('fure',),
'furete': ('fure',),
'furt': ('fure',),
'furte': ('fure',),
'furet': ('furet',),
'furete': ('furet',),
'furetere': ('furet',),
'furetest': ('furet',),
'fureteste': ('furet',),
'furete': ('furete',),
'furnerende': ('furnere',),
'furnert': ('furnere',),
'furnerte': ('furnere',),
'furta': ('furte',),
'furtede': ('furte',),
'furtende': ('furte',),
'furtet': ('furte',),
'furtete': ('furte',),
'furten': ('furten',),
'furtent': ('furten',),
'furtne': ('furten',),
'furtnere': ('furten',),
'furtnest': ('furten',),
'furtneste': ('furten',),
'fus': ('fus',),
'fuse': ('fus',),
'fusere': ('fus',),
'fusest': ('fus',),
'fuseste': ('fus',),
'fust': ('fus',),
'fusende': ('fuse',),
'fust': ('fuse',),
'fuste': ('fuse',),
'fusjonerende': ('fusjonere',),
'fusjonert': ('fusjonere',),
'fusjonerte': ('fusjonere',),
'fuska': ('fuske',),
'fuskede': ('fuske',),
'fuskende': ('fuske',),
'fusket': ('fuske',),
'fuskete': ('fuske',),
'futil': ('futil',),
'futile': ('futil',),
'futilere': ('futil',),
'futilest': ('futil',),
'futileste': ('futil',),
'futilt': ('futil',),
'futta': ('futte',),
'futtede': ('futte',),
'futtende': ('futte',),
'futtet': ('futte',),
'futtete': ('futte',),
'futurisk': ('futurisk',),
'futuriske': ('futurisk',),
'futuriskere': ('futurisk',),
'futuriskest': ('futurisk',),
'futuriskeste': ('futurisk',),
'futuristisk': ('futuristisk',),
'futuristiske': ('futuristisk',),
'futuristiskere': ('futuristisk',),
'futuristiskest': ('futuristisk',),
'futuristiskeste': ('futuristisk',),
'fykende': ('fyke',),
'føken': ('fyke',),
'føket': ('fyke',),
'føkne': ('fyke',),
'fykende': ('fykende',),
'fyldig': ('fyldig',),
'fyldige': ('fyldig',),
'fyldigere': ('fyldig',),
'fyldigst': ('fyldig',),
'fyldigste': ('fyldig',),
'fylka': ('fylke',),
'fylkede': ('fylke',),
'fylkende': ('fylke',),
'fylket': ('fylke',),
'fylkete': ('fylke',),
'fylkt': ('fylke',),
'fylkte': ('fylke',),
'fylkeskommunal': ('fylkeskommunal',),
'fylkeskommunale': ('fylkeskommunal',),
'fylkeskommunalere': ('fylkeskommunal',),
'fylkeskommunalest': ('fylkeskommunal',),
'fylkeskommunaleste': ('fylkeskommunal',),
'fylkeskommunalt': ('fylkeskommunal',),
'fylla': ('fylle',),
'fyllede': ('fylle',),
'fyllende': ('fylle',),
'fyllet': ('fylle',),
'fyllete': ('fylle',),
'fyllende': ('fylle',),
'fylt': ('fylle',),
'fylte': ('fylle',),
'fyllekjørende': ('fyllekjøre',),
'fyllekjørt': ('fyllekjøre',),
'fyllekjørte': ('fyllekjøre',),
'fyllesjuk': ('fyllesjuk',),
'fyllesjuke': ('fyllesjuk',),
'fyllesjukere': ('fyllesjuk',),
'fyllesjukest': ('fyllesjuk',),
'fyllesjukeste': ('fyllesjuk',),
'fyllesjukt': ('fyllesjuk',),
'fyllestgjørende': ('fyllestgjørende',),
'fyllesyk': ('fyllesyk',),
'fyllesyke': ('fyllesyk',),
'fyllesykere': ('fyllesyk',),
'fyllesykest': ('fyllesyk',),
'fyllesykeste': ('fyllesyk',),
'fyllesykt': ('fyllesyk',),
'fyndig': ('fyndig',),
'fyndige': ('fyndig',),
'fyndigere': ('fyndig',),
'fyndigst': ('fyndig',),
'fyndigste': ('fyndig',),
'fyrende': ('fyre',),
'fyrt': ('fyre',),
'fyrte': ('fyre',),
'fyrig': ('fyrig',),
'fyrige': ('fyrig',),
'fyrigere': ('fyrig',),
'fyrigst': ('fyrig',),
'fyrigste': ('fyrig',),
'fyrstelig': ('fyrstelig',),
'fyrstelige': ('fyrstelig',),
'fyrsteligere': ('fyrstelig',),
'fyrsteligst': ('fyrstelig',),
'fyrsteligste': ('fyrstelig',),
'fysende': ('fyse',),
'fyst': ('fyse',),
'fyste': ('fyse',),
'fysen': ('fysen',),
'fysent': ('fysen',),
'fysne': ('fysen',),
'fysnere': ('fysen',),
'fysnest': ('fysen',),
'fysneste': ('fysen',),
'fysikalsk': ('fysikalsk',),
'fysikalske': ('fysikalsk',),
'fysikalskere': ('fysikalsk',),
'fysikalskest': ('fysikalsk',),
'fysikalskeste': ('fysikalsk',),
'fysiologisk': ('fysiologisk',),
'fysiologiske': ('fysiologisk',),
'fysiologiskere': ('fysiologisk',),
'fysiologiskest': ('fysiologisk',),
'fysiologiskeste': ('fysiologisk',),
'fysisk': ('fysisk',),
'fysiske': ('fysisk',),
'fysiskere': ('fysisk',),
'fysiskest': ('fysisk',),
'fysiskeste': ('fysisk',),
'fående': ('få',),
'fått': ('få',),
'fåtte': ('få',),
'få': ('få',),
'færre': ('få',),
'færrest': ('få',),
'færreste': ('få',),
'fåfengt': ('fåfengt',),
'fåfengte': ('fåfengt',),
'fåfengtere': ('fåfengt',),
'fåfengtest': ('fåfengt',),
'fåfengteste': ('fåfengt',),
'fåkunnig': ('fåkunnig',),
'fåkunnige': ('fåkunnig',),
'fåkunnigere': ('fåkunnig',),
'fåkunnigst': ('fåkunnig',),
'fåkunnigste': ('fåkunnig',),
'fåment': ('fåment',),
'fåmente': ('fåment',),
'fåmentere': ('fåment',),
'fåmentest': ('fåment',),
'fåmenteste': ('fåment',),
'fåmælt': ('fåmælt',),
'fåmælte': ('fåmælt',),
'fåmæltere': ('fåmælt',),
'fåmæltest': ('fåmælt',),
'fåmælteste': ('fåmælt',),
'fånyttes': ('fånyttes',),
'fåret': ('fåret',),
'fårete': ('fåret',),
'fåretere': ('fåret',),
'fåretest': ('fåret',),
'fåreteste': ('fåret',),
'fårete': ('fårete',),
'fåtallig': ('fåtallig',),
'fåtallige': ('fåtallig',),
'fåtalligere': ('fåtallig',),
'fåtalligst': ('fåtallig',),
'fåtalligste': ('fåtallig',),
'fåtenkt': ('fåtenkt',),
'fåtenkte': ('fåtenkt',),
'fåtenktere': ('fåtenkt',),
'fåtenktest': ('fåtenkt',),
'fåtenkteste': ('fåtenkt',),
'fæl': ('fæl',),
'fæle': ('fæl',),
'fælere': ('fæl',),
'fælest': ('fæl',),
'fæleste': ('fæl',),
'fælt': ('fæl',),
'fælende': ('fæle',),
'fælt': ('fæle',),
'fælte': ('fæle',),
'fælen': ('fælen',),
'fælent': ('fælen',),
'fælne': ('fælen',),
'fælnere': ('fælen',),
'fælnest': ('fælen',),
'fælneste': ('fælen',),
'færre': ('færre',),
'færrest': ('færrest',),
'færreste': ('færrest',),
'færøysk': ('færøysk',),
'færøyske': ('færøysk',),
'færøyskere': ('færøysk',),
'færøyskest': ('færøysk',),
'færøyskeste': ('færøysk',),
'fødd': ('fø',),
'fødde': ('fø',),
'føende': ('fø',),
'fødd': ('føde',),
'fødde': ('føde',),
'fødende': ('føde',),
'født': ('føde',),
'fødte': ('føde',),
'fødd': ('føde',),
'fødde': ('føde',),
'fødende': ('føde',),
'født': ('føde',),
'fødte': ('føde',),
'føderal': ('føderal',),
'føderale': ('føderal',),
'føderalere': ('føderal',),
'føderalest': ('føderal',),
'føderaleste': ('føderal',),
'føderalt': ('føderal',),
'føderativ': ('føderativ',),
'føderative': ('føderativ',),
'føderativere': ('føderativ',),
'føderativest': ('føderativ',),
'føderativeste': ('føderativ',),
'føderativt': ('føderativ',),
'følbar': ('følbar',),
'følbare': ('følbar',),
'følbarere': ('følbar',),
'følbarest': ('følbar',),
'følbareste': ('følbar',),
'følbart': ('følbar',),
'følende': ('føle',),
'følt': ('føle',),
'følte': ('føle',),
'følelig': ('følelig',),
'følelige': ('følelig',),
'føleligere': ('følelig',),
'føleligst': ('følelig',),
'føleligste': ('følelig',),
'følelsesbetona': ('følelsesbetona',),
'følelsesbetonede': ('følelsesbetonet',),
'følelsesbetonet': ('følelsesbetonet',),
'følelsesbetonete': ('følelsesbetonet',),
'følelsesbetonetere': ('følelsesbetonet',),
'følelsesbetonetest': ('følelsesbetonet',),
'følelsesbetoneteste': ('følelsesbetonet',),
'følelsesbetont': ('følelsesbetont',),
'følelsesbetonte': ('følelsesbetont',),
'følelsesbetontere': ('følelsesbetont',),
'følelsesbetontest': ('følelsesbetont',),
'følelsesbetonteste': ('følelsesbetont',),
'følelsesfull': ('følelsesfull',),
'følelsesfulle': ('følelsesfull',),
'følelsesfullere': ('følelsesfull',),
'følelsesfullest': ('følelsesfull',),
'følelsesfulleste': ('følelsesfull',),
'følelsesfullt': ('følelsesfull',),
'følelseskald': ('følelseskald',),
'følelseskalde': ('følelseskald',),
'følelseskaldere': ('følelseskald',),
'følelseskaldest': ('følelseskald',),
'følelseskaldeste': ('følelseskald',),
'følelseskaldt': ('følelseskald',),
'følelseslada': ('følelseslada',),
'følelsesladd': ('følelsesladd',),
'følelsesladde': ('følelsesladd',),
'følelsesladdere': ('følelsesladd',),
'følelsesladdest': ('følelsesladd',),
'følelsesladdeste': ('følelsesladd',),
'følelsesladede': ('følelsesladet',),
'følelsesladet': ('følelsesladet',),
'følelsesladete': ('følelsesladet',),
'følelsesladetere': ('følelsesladet',),
'følelsesladetest': ('følelsesladet',),
'følelsesladeteste': ('følelsesladet',),
'følelseslaus': ('følelseslaus',),
'følelseslause': ('følelseslaus',),
'følelseslausere': ('følelseslaus',),
'følelseslausest': ('følelseslaus',),
'følelseslauseste': ('følelseslaus',),
'følelseslaust': ('følelseslaus',),
'følelsesløs': ('følelsesløs',),
'følelsesløse': ('følelsesløs',),
'følelsesløsere': ('følelsesløs',),
'følelsesløsest': ('følelsesløs',),
'følelsesløseste': ('følelsesløs',),
'følelsesløst': ('følelsesløs',),
'følelsesmessig': ('følelsesmessig',),
'følelsesmessige': ('følelsesmessig',),
'følelsesmessigere': ('følelsesmessig',),
'følelsesmessigst': ('følelsesmessig',),
'følelsesmessigste': ('følelsesmessig',),
'følgende': ('følgende',),
'følgeriktig': ('følgeriktig',),
'følgeriktige': ('følgeriktig',),
'følgeriktigere': ('følgeriktig',),
'følgeriktigst': ('følgeriktig',),
'følgeriktigste': ('følgeriktig',),
'følgende': ('følgje',),
'følgt': ('følgje',),
'følgte': ('følgje',),
'følgende': ('følgje',),
'følgt': ('følgje',),
'følgte': ('følgje',),
'følla': ('følle',),
'føllede': ('følle',),
'føllende': ('følle',),
'føllet': ('følle',),
'føllete': ('følle',),
'følsom': ('følsom',),
'følsomme': ('følsom',),
'følsommere': ('følsom',),
'følsomst': ('følsom',),
'følsomste': ('følsom',),
'følsomt': ('følsom',),
'føna': ('føne',),
'fønede': ('føne',),
'fønende': ('føne',),
'fønet': ('føne',),
'fønete': ('føne',),
'fønt': ('føne',),
'fønte': ('føne',),
'før': ('før',),
'føre': ('før',),
'førere': ('før',),
'førest': ('før',),
'føreste': ('før',),
'ført': ('før',),
'førende': ('føre',),
'ført': ('føre',),
'førte': ('føre',),
'førebels': ('førebels',),
'førebudd': ('førebu',),
'førebudde': ('førebu',),
'førebuende': ('førebu',),
'førekteskapelig': ('førekteskapelig',),
'førekteskapelige': ('førekteskapelig',),
'førekteskapeligere': ('førekteskapelig',),
'førekteskapeligst': ('førekteskapelig',),
'førekteskapeligste': ('førekteskapelig',),
'førhistorisk': ('førhistorisk',),
'førhistoriske': ('førhistorisk',),
'førhistoriskere': ('førhistorisk',),
'førhistoriskest': ('førhistorisk',),
'førhistoriskeste': ('førhistorisk',),
'førkolumbisk': ('førkolumbisk',),
'førkolumbiske': ('førkolumbisk',),
'førkolumbiskere': ('førkolumbisk',),
'førkolumbiskest': ('førkolumbisk',),
'førkolumbiskeste': ('førkolumbisk',),
'førkrigs': ('førkrigs',),
'førlig': ('førlig',),
'førlige': ('førlig',),
'førligere': ('førlig',),
'førligst': ('førlig',),
'førligste': ('førlig',),
'førnevnt': ('førnevnt',),
'førnevnte': ('førnevnt',),
'førnevntere': ('førnevnt',),
'førnevntest': ('førnevnt',),
'førnevnteste': ('førnevnt',),
'første': ('første',),
'førstefødd': ('førstefødd',),
'førstefødde': ('førstefødd',),
'førsteføddere': ('førstefødd',),
'førsteføddest': ('førstefødd',),
'førsteføddeste': ('førstefødd',),
'førstefødt': ('førstefødt',),
'førstefødte': ('førstefødt',),
'førstefødtere': ('førstefødt',),
'førstefødtest': ('førstefødt',),
'førstefødteste': ('førstefødt',),
'førstegangsfødende': ('førstegangsfødende',),
'førstehands': ('førstehands',),
'førstehånds': ('førstehånds',),
'førsteklasses': ('førsteklasses',),
'førsterangs': ('førsterangs',),
'førstkommende': ('førstkommende',),
'førstnevnt': ('førstnevnt',),
'førstnevnte': ('førstnevnt',),
'førstnevntere': ('førstnevnt',),
'førstnevntest': ('førstnevnt',),
'førstnevnteste': ('førstnevnt',),
'førtidspensjonerende': ('førtidspensjonere',),
'førtidspensjonert': ('førtidspensjonere',),
'førtidspensjonerte': ('førtidspensjonere',),
'førtiende': ('førtiende',),
'føydal': ('føydal',),
'føydale': ('føydal',),
'føydalere': ('føydal',),
'føydalest': ('føydal',),
'føydaleste': ('føydal',),
'føydalt': ('føydal',),
'føya': ('føye',),
'føyd': ('føye',),
'føydd': ('føye',),
'føydde': ('føye',),
'føyde': ('føye',),
'føyede': ('føye',),
'føyende': ('føye',),
'føyet': ('føye',),
'føyete': ('føye',),
'føyelig': ('føyelig',),
'føyelige': ('føyelig',),
'føyeligere': ('føyelig',),
'føyeligst': ('føyelig',),
'føyeligste': ('føyelig',),
'føyka': ('føyke',),
'føykede': ('føyke',),
'føykende': ('føyke',),
'føyket': ('føyke',),
'føykete': ('føyke',),
'føykt': ('føyke',),
'føykte': ('føyke',),
'føysende': ('føyse',),
'føyst': ('føyse',),
'føyste': ('føyse',),
'gabonsk': ('gabonsk',),
'gabonske': ('gabonsk',),
'gabonskere': ('gabonsk',),
'gabonskest': ('gabonsk',),
'gabonskeste': ('gabonsk',),
'gaffelforma': ('gaffelforma',),
'gaffelformede': ('gaffelformet',),
'gaffelformet': ('gaffelformet',),
'gaffelformete': ('gaffelformet',),
'gaffelformetere': ('gaffelformet',),
'gaffelformetest': ('gaffelformet',),
'gaffelformeteste': ('gaffelformet',),
'gafla': ('gafle',),
'gaflede': ('gafle',),
'gaflende': ('gafle',),
'gaflet': ('gafle',),
'gaflete': ('gafle',),
'gagna': ('gagne',),
'gagnede': ('gagne',),
'gagnende': ('gagne',),
'gagnet': ('gagne',),
'gagnete': ('gagne',),
'gagnlaus': ('gagnlaus',),
'gagnlause': ('gagnlaus',),
'gagnlausere': ('gagnlaus',),
'gagnlausest': ('gagnlaus',),
'gagnlauseste': ('gagnlaus',),
'gagnlaust': ('gagnlaus',),
'gagnlig': ('gagnlig',),
'gagnlige': ('gagnlig',),
'gagnligere': ('gagnlig',),
'gagnligst': ('gagnlig',),
'gagnligste': ('gagnlig',),
'gagnløs': ('gagnløs',),
'gagnløse': ('gagnløs',),
'gagnløsere': ('gagnløs',),
'gagnløsest': ('gagnløs',),
'gagnløseste': ('gagnløs',),
'gagnløst': ('gagnløs',),
'gagns': ('gagns',),
'gakka': ('gakke',),
'gakkede': ('gakke',),
'gakkende': ('gakke',),
'gakket': ('gakke',),
'gakkete': ('gakke',),
'gal': ('gal',),
'gale': ('gal',),
'galere': ('gal',),
'galest': ('gal',),
'galeste': ('gal',),
'galt': ('gal',),
'galaktisk': ('galaktisk',),
'galaktiske': ('galaktisk',),
'galaktiskere': ('galaktisk',),
'galaktiskest': ('galaktisk',),
'galaktiskeste': ('galaktisk',),
'galant': ('galant',),
'galante': ('galant',),
'galantere': ('galant',),
'galantest': ('galant',),
'galanteste': ('galant',),
'galdra': ('galdre',),
'galdrede': ('galdre',),
'galdrende': ('galdre',),
'galdret': ('galdre',),
'galdrete': ('galdre',),
'galende': ('gale',),
'galt': ('gale',),
'galte': ('gale',),
'galen': ('galen',),
'galent': ('galen',),
'galne': ('galen',),
'galnere': ('galen',),
'galnest': ('galen',),
'galneste': ('galen',),
'galgenhumoristisk': ('galgenhumoristisk',),
'galgenhumoristiske': ('galgenhumoristisk',),
'galgenhumoristiskere': ('galgenhumoristisk',),
'galgenhumoristiskest': ('galgenhumoristisk',),
'galgenhumoristiskeste': ('galgenhumoristisk',),
'galileisk': ('galileisk',),
'galileiske': ('galileisk',),
'galileiskere': ('galileisk',),
'galileiskest': ('galileisk',),
'galileiskeste': ('galileisk',),
'galileisk': ('galileisk',),
'galileiske': ('galileisk',),
'galileiskere': ('galileisk',),
'galileiskest': ('galileisk',),
'galileiskeste': ('galileisk',),
'gallegrøn': ('gallegrøn',),
'gallegrøne': ('gallegrøn',),
'gallegrønere': ('gallegrøn',),
'gallegrønest': ('gallegrøn',),
'gallegrøneste': ('gallegrøn',),
'gallegrønt': ('gallegrøn',),
'gallegrønn': ('gallegrønn',),
'gallegrønne': ('gallegrønn',),
'gallegrønnere': ('gallegrønn',),
'gallegrønnest': ('gallegrønn',),
'gallegrønneste': ('gallegrønn',),
'gallegrønt': ('gallegrønn',),
'gallisk': ('gallisk',),
'galliske': ('gallisk',),
'galliskere': ('gallisk',),
'galliskest': ('gallisk',),
'galliskeste': ('gallisk',),
'galopperende': ('galoppere',),
'galoppert': ('galoppere',),
'galopperte': ('galoppere',),
'galvaniserende': ('galvanisere',),
'galvanisert': ('galvanisere',),
'galvaniserte': ('galvanisere',),
'galvanisk': ('galvanisk',),
'galvaniske': ('galvanisk',),
'galvaniskere': ('galvanisk',),
'galvaniskest': ('galvanisk',),
'galvaniskeste': ('galvanisk',),
'gambisk': ('gambisk',),
'gambiske': ('gambisk',),
'gambiskere': ('gambisk',),
'gambiskest': ('gambisk',),
'gambiskeste': ('gambisk',),
'gambla': ('gamble',),
'gamblede': ('gamble',),
'gamblende': ('gamble',),
'gamblet': ('gamble',),
'gamblete': ('gamble',),
'game': ('game',),
'eldre': ('gammal',),
'eldst': ('gammal',),
'eldste': ('gammal',),
'gamle': ('gammal',),
'gammal': ('gammal',),
'gammalt': ('gammal',),
'gammaldansk': ('gammaldansk',),
'gammaldanske': ('gammaldansk',),
'gammaldanskere': ('gammaldansk',),
'gammaldanskest': ('gammaldansk',),
'gammaldanskeste': ('gammaldansk',),
'gammalkjent': ('gammalkjent',),
'gammalkjente': ('gammalkjent',),
'gammalkjentere': ('gammalkjent',),
'gammalkjentest': ('gammalkjent',),
'gammalkjenteste': ('gammalkjent',),
'gammalmannsaktig': ('gammalmannsaktig',),
'gammalmannsaktige': ('gammalmannsaktig',),
'gammalmannsaktigere': ('gammalmannsaktig',),
'gammalmannsaktigst': ('gammalmannsaktig',),
'gammalmannsaktigste': ('gammalmannsaktig',),
'gammalmodig': ('gammalmodig',),
'gammalmodige': ('gammalmodig',),
'gammalmodigere': ('gammalmodig',),
'gammalmodigst': ('gammalmodig',),
'gammalmodigste': ('gammalmodig',),
'gammalnorsk': ('gammalnorsk',),
'gammalnorske': ('gammalnorsk',),
'gammalnorskere': ('gammalnorsk',),
'gammalnorskest': ('gammalnorsk',),
'gammalnorskeste': ('gammalnorsk',),
'gammalrosa': ('gammalrosa',),
'gammaltestamentlig': ('gammaltestamentlig',),
'gammaltestamentlige': ('gammaltestamentlig',),
'gammaltestamentligere': ('gammaltestamentlig',),
'gammaltestamentligst': ('gammaltestamentlig',),
'gammaltestamentligste': ('gammaltestamentlig',),
'gammalvoren': ('gammalvoren',),
'gammalvorent': ('gammalvoren',),
'gammalvorne': ('gammalvoren',),
'gammalvornere': ('gammalvoren',),
'gammalvornest': ('gammalvoren',),
'gammalvorneste': ('gammalvoren',),
'eldre': ('gammel',),
'eldst': ('gammel',),
'eldste': ('gammel',),
'gamle': ('gammel',),
'gammel': ('gammel',),
'gammelt': ('gammel',),
'gammeldansk': ('gammeldansk',),
'gammeldanske': ('gammeldansk',),
'gammeldanskere': ('gammeldansk',),
'gammeldanskest': ('gammeldansk',),
'gammeldanskeste': ('gammeldansk',),
'gammelkjent': ('gammelkjent',),
'gammelkjente': ('gammelkjent',),
'gammelkjentere': ('gammelkjent',),
'gammelkjentest': ('gammelkjent',),
'gammelkjenteste': ('gammelkjent',),
'gammelmannsaktig': ('gammelmannsaktig',),
'gammelmannsaktige': ('gammelmannsaktig',),
'gammelmannsaktigere': ('gammelmannsaktig',),
'gammelmannsaktigst': ('gammelmannsaktig',),
'gammelmannsaktigste': ('gammelmannsaktig',),
'gammelmodig': ('gammelmodig',),
'gammelmodige': ('gammelmodig',),
'gammelmodigere': ('gammelmodig',),
'gammelmodigst': ('gammelmodig',),
'gammelmodigste': ('gammelmodig',),
'gammelnorsk': ('gammelnorsk',),
'gammelnorske': ('gammelnorsk',),
'gammelnorskere': ('gammelnorsk',),
'gammelnorskest': ('gammelnorsk',),
'gammelnorskeste': ('gammelnorsk',),
'gammelrosa': ('gammelrosa',),
'gammeltestamentlig': ('gammeltestamentlig',),
'gammeltestamentlige': ('gammeltestamentlig',),
'gammeltestamentligere': ('gammeltestamentlig',),
'gammeltestamentligst': ('gammeltestamentlig',),
'gammeltestamentligste': ('gammeltestamentlig',),
'gammelvoren': ('gammelvoren',),
'gammelvorent': ('gammelvoren',),
'gammelvorne': ('gammelvoren',),
'gammelvornere': ('gammelvoren',),
'gammelvornest': ('gammelvoren',),
'gammelvorneste': ('gammelvoren',),
'ganda': ('gande',),
'gandede': ('gande',),
'gandende': ('gande',),
'gandet': ('gande',),
'gandete': ('gande',),
'gana': ('gane',),
'ganede': ('gane',),
'ganende': ('gane',),
'ganet': ('gane',),
'ganete': ('gane',),
'gant': ('gane',),
'gante': ('gane',),
'gangbar': ('gangbar',),
'gangbare': ('gangbar',),
'gangbarere': ('gangbar',),
'gangbarest': ('gangbar',),
'gangbareste': ('gangbar',),
'gangbart': ('gangbar',),
'ganga': ('gange',),
'gangede': ('gange',),
'gangende': ('gange',),
'ganget': ('gange',),
'gangete': ('gange',),
'gangfør': ('gangfør',),
'gangføre': ('gangfør',),
'gangførere': ('gangfør',),
'gangførest': ('gangfør',),
'gangføreste': ('gangfør',),
'gangført': ('gangfør',),
'gangrenøs': ('gangrenøs',),
'gangrenøse': ('gangrenøs',),
'gangrenøsere': ('gangrenøs',),
'gangrenøsest': ('gangrenøs',),
'gangrenøseste': ('gangrenøs',),
'gangrenøst': ('gangrenøs',),
'gangsynt': ('gangsynt',),
'gangsynte': ('gangsynt',),
'gangsyntere': ('gangsynt',),
'gangsyntest': ('gangsynt',),
'gangsynteste': ('gangsynt',),
'ganta': ('gante',),
'gantede': ('gante',),
'gantende': ('gante',),
'gantet': ('gante',),
'gantete': ('gante',),
'gapa': ('gape',),
'gapende': ('gape',),
'gapt': ('gape',),
'gapte': ('gape',),
'gapen': ('gapen',),
'gapent': ('gapen',),
'gapne': ('gapen',),
'gapnere': ('gapen',),
'gapnest': ('gapen',),
'gapneste': ('gapen',),
'gapet': ('gapet',),
'gapete': ('gapet',),
'gapetere': ('gapet',),
'gapetest': ('gapet',),
'gapeteste': ('gapet',),
'gapete': ('gapete',),
'gapskratta': ('gapskratte',),
'gapskrattede': ('gapskratte',),
'gapskrattende': ('gapskratte',),
'gapskrattet': ('gapskratte',),
'gapskrattete': ('gapskratte',),
'garanterende': ('garantere',),
'garantert': ('garantere',),
'garanterte': ('garantere',),
'garderende': ('gardere',),
'gardert': ('gardere',),
'garderte': ('gardere',),
'garna': ('garne',),
'garnede': ('garne',),
'garnende': ('garne',),
'garnet': ('garne',),
'garnete': ('garne',),
'garnerende': ('garnere',),
'garnert': ('garnere',),
'garnerte': ('garnere',),
'garnisonerende': ('garnisonere',),
'garnisonert': ('garnisonere',),
'garnisonerte': ('garnisonere',),
'garpa': ('garpe',),
'garpede': ('garpe',),
'garpende': ('garpe',),
'garpet': ('garpe',),
'garpete': ('garpe',),
'garva': ('garva',),
'garva': ('garve',),
'garvede': ('garve',),
'garvende': ('garve',),
'garvet': ('garve',),
'garvete': ('garve',),
'garvede': ('garvet',),
'garvet': ('garvet',),
'garvete': ('garvet',),
'garvetere': ('garvet',),
'garvetest': ('garvet',),
'garveteste': ('garvet',),
'gasjerende': ('gasjere',),
'gasjert': ('gasjere',),
'gasjerte': ('gasjere',),
'gassa': ('gasse',),
'gassede': ('gasse',),
'gassende': ('gasse',),
'gasset': ('gasse',),
'gassete': ('gasse',),
'gassa': ('gasse',),
'gassede': ('gasse',),
'gassende': ('gasse',),
'gasset': ('gasse',),
'gassete': ('gasse',),
'gassformig': ('gassformig',),
'gassformige': ('gassformig',),
'gassformigere': ('gassformig',),
'gassformigst': ('gassformig',),
'gassformigste': ('gassformig',),
'gassisk': ('gassisk',),
'gassiske': ('gassisk',),
'gassiskere': ('gassisk',),
'gassiskest': ('gassisk',),
'gassiskeste': ('gassisk',),
'gasta': ('gasta',),
'gastrisk': ('gastrisk',),
'gastriske': ('gastrisk',),
'gastriskere': ('gastrisk',),
'gastriskest': ('gastrisk',),
'gastriskeste': ('gastrisk',),
'gastronomisk': ('gastronomisk',),
'gastronomiske': ('gastronomisk',),
'gastronomiskere': ('gastronomisk',),
'gastronomiskest': ('gastronomisk',),
'gastronomiskeste': ('gastronomisk',),
'gauka': ('gauke',),
'gaukede': ('gauke',),
'gaukende': ('gauke',),
'gauket': ('gauke',),
'gaukete': ('gauke',),
'gaula': ('gaule',),
'gaulede': ('gaule',),
'gaulende': ('gaule',),
'gaulet': ('gaule',),
'gaulete': ('gaule',),
'gault': ('gaule',),
'gaulte': ('gaule',),
'gauma': ('gaume',),
'gaumede': ('gaume',),
'gaumende': ('gaume',),
'gaumet': ('gaume',),
'gaumete': ('gaume',),
'gaussisk': ('gaussisk',),
'gaussiske': ('gaussisk',),
'gaussiskere': ('gaussisk',),
'gaussiskest': ('gaussisk',),
'gaussiskeste': ('gaussisk',),
'gaussk': ('gaussk',),
'gausske': ('gaussk',),
'gausskere': ('gaussk',),
'gausskest': ('gaussk',),
'gausskeste': ('gaussk',),
'gavmild': ('gavmild',),
'gavmilde': ('gavmild',),
'gavmildere': ('gavmild',),
'gavmildest': ('gavmild',),
'gavmildeste': ('gavmild',),
'gavmildt': ('gavmild',),
'geberda': ('geberde',),
'geberdede': ('geberde',),
'geberdende': ('geberde',),
'geberdet': ('geberde',),
'geberdete': ('geberde',),
'gebrekkelig': ('gebrekkelig',),
'gebrekkelige': ('gebrekkelig',),
'gebrekkeligere': ('gebrekkelig',),
'gebrekkeligst': ('gebrekkelig',),
'gebrekkeligste': ('gebrekkelig',),
'gebrokken': ('gebrokken',),
'gebrokkent': ('gebrokken',),
'gebrokne': ('gebrokken',),
'gebroknere': ('gebrokken',),
'gebroknest': ('gebrokken',),
'gebrokneste': ('gebrokken',),
'gedigen': ('gedigen',),
'gedigent': ('gedigen',),
'gedigne': ('gedigen',),
'gedignere': ('gedigen',),
'gedignest': ('gedigen',),
'gedigneste': ('gedigen',),
'geil': ('geil',),
'geile': ('geil',),
'geilere': ('geil',),
'geilest': ('geil',),
'geileste': ('geil',),
'geilt': ('geil',),
'geipa': ('geipe',),
'geipede': ('geipe',),
'geipende': ('geipe',),
'geipet': ('geipe',),
'geipete': ('geipe',),
'geipt': ('geipe',),
'geipte': ('geipe',),
'geipet': ('geipet',),
'geipete': ('geipet',),
'geipetere': ('geipet',),
'geipetest': ('geipet',),
'geipeteste': ('geipet',),
'geipete': ('geipete',),
'geistlig': ('geistlig',),
'geistlige': ('geistlig',),
'geistligere': ('geistlig',),
'geistligst': ('geistlig',),
'geistligste': ('geistlig',),
'geitet': ('geitet',),
'geitete': ('geitet',),
'geitetere': ('geitet',),
'geitetest': ('geitet',),
'geiteteste': ('geitet',),
'geitete': ('geitete',),
'geléaktig': ('geléaktig',),
'geléaktige': ('geléaktig',),
'geléaktigere': ('geléaktig',),
'geléaktigst': ('geléaktig',),
'geléaktigste': ('geléaktig',),
'geleida': ('geleide',),
'geleidede': ('geleide',),
'geleidende': ('geleide',),
'geleidet': ('geleide',),
'geleidete': ('geleide',),
'gemeinslig': ('gemeinslig',),
'gemeinslige': ('gemeinslig',),
'gemeinsligere': ('gemeinslig',),
'gemeinsligst': ('gemeinslig',),
'gemeinsligste': ('gemeinslig',),
'gemen': ('gemen',),
'gemene': ('gemen',),
'gemenere': ('gemen',),
'gemenest': ('gemen',),
'gemeneste': ('gemen',),
'gement': ('gemen',),
'gemenslig': ('gemenslig',),
'gemenslige': ('gemenslig',),
'gemensligere': ('gemenslig',),
'gemensligst': ('gemenslig',),
'gemensligste': ('gemenslig',),
'geminerende': ('geminere',),
'geminert': ('geminere',),
'geminerte': ('geminere',),
'gemyttlig': ('gemyttlig',),
'gemyttlige': ('gemyttlig',),
'gemyttligere': ('gemyttlig',),
'gemyttligst': ('gemyttlig',),
'gemyttligste': ('gemyttlig',),
'genealogisk': ('genealogisk',),
'genealogiske': ('genealogisk',),
'genealogiskere': ('genealogisk',),
'genealogiskest': ('genealogisk',),
'genealogiskeste': ('genealogisk',),
'generaliserende': ('generalisere',),
'generalisert': ('generalisere',),
'generaliserte': ('generalisere',),
'generalpreventiv': ('generalpreventiv',),
'generalpreventive': ('generalpreventiv',),
'generalpreventivere': ('generalpreventiv',),
'generalpreventivest': ('generalpreventiv',),
'generalpreventiveste': ('generalpreventiv',),
'generalpreventivt': ('generalpreventiv',),
'generativ': ('generativ',),
'generative': ('generativ',),
'generativere': ('generativ',),
'generativest': ('generativ',),
'generativeste': ('generativ',),
'generativt': ('generativ',),
'generell': ('generell',),
'generelle': ('generell',),
'generellere': ('generell',),
'generellest': ('generell',),
'generelleste': ('generell',),
'generelt': ('generell',),
'genererende': ('generere',),
'generert': ('generere',),
'genererte': ('generere',),
'generisk': ('generisk',),
'generiske': ('generisk',),
'generiskere': ('generisk',),
'generiskest': ('generisk',),
'generiskeste': ('generisk',),
'genetisk': ('genetisk',),
'genetiske': ('genetisk',),
'genetiskere': ('genetisk',),
'genetiskest': ('genetisk',),
'genetiskeste': ('genetisk',),
'genial': ('genial',),
'geniale': ('genial',),
'genialere': ('genial',),
'genialest': ('genial',),
'genialeste': ('genial',),
'genialt': ('genial',),
'genierklærende': ('genierklære',),
'genierklært': ('genierklære',),
'genierklærte': ('genierklære',),
'genital': ('genital',),
'genitale': ('genital',),
'genitalere': ('genital',),
'genitalest': ('genital',),
'genitaleste': ('genital',),
'genitalt': ('genital',),
'genovesisk': ('genovesisk',),
'genovesiske': ('genovesisk',),
'genovesiskere': ('genovesisk',),
'genovesiskest': ('genovesisk',),
'genovesiskeste': ('genovesisk',),
'gentil': ('gentil',),
'gentile': ('gentil',),
'gentilere': ('gentil',),
'gentilest': ('gentil',),
'gentileste': ('gentil',),
'gentilt': ('gentil',),
'genuesisk': ('genuesisk',),
'genuesiske': ('genuesisk',),
'genuesiskere': ('genuesisk',),
'genuesiskest': ('genuesisk',),
'genuesiskeste': ('genuesisk',),
'genuin': ('genuin',),
'genuine': ('genuin',),
'genuinere': ('genuin',),
'genuinest': ('genuin',),
'genuineste': ('genuin',),
'genuint': ('genuin',),
'geodetisk': ('geodetisk',),
'geodetiske': ('geodetisk',),
'geodetiskere': ('geodetisk',),
'geodetiskest': ('geodetisk',),
'geodetiskeste': ('geodetisk',),
'geofysisk': ('geofysisk',),
'geofysiske': ('geofysisk',),
'geofysiskere': ('geofysisk',),
'geofysiskest': ('geofysisk',),
'geofysiskeste': ('geofysisk',),
'geografisk': ('geografisk',),
'geografiske': ('geografisk',),
'geografiskere': ('geografisk',),
'geografiskest': ('geografisk',),
'geografiskeste': ('geografisk',),
'geologisk': ('geologisk',),
'geologiske': ('geologisk',),
'geologiskere': ('geologisk',),
'geologiskest': ('geologisk',),
'geologiskeste': ('geologisk',),
'geometrisk': ('geometrisk',),
'geometriske': ('geometrisk',),
'geometriskere': ('geometrisk',),
'geometriskest': ('geometrisk',),
'geometriskeste': ('geometrisk',),
'georgisk': ('georgisk',),
'georgiske': ('georgisk',),
'georgiskere': ('georgisk',),
'georgiskest': ('georgisk',),
'georgiskeste': ('georgisk',),
'georgistisk': ('georgistisk',),
'georgistiske': ('georgistisk',),
'georgistiskere': ('georgistisk',),
'georgistiskest': ('georgistisk',),
'georgistiskeste': ('georgistisk',),
'geosentrisk': ('geosentrisk',),
'geosentriske': ('geosentrisk',),
'geosentriskere': ('geosentrisk',),
'geosentriskest': ('geosentrisk',),
'geosentriskeste': ('geosentrisk',),
'gererende': ('gerere',),
'gerert': ('gerere',),
'gererte': ('gerere',),
'geriatrisk': ('geriatrisk',),
'geriatriske': ('geriatrisk',),
'geriatriskere': ('geriatrisk',),
'geriatriskest': ('geriatrisk',),
'geriatriskeste': ('geriatrisk',),
'germaniserende': ('germanisere',),
'germanisert': ('germanisere',),
'germaniserte': ('germanisere',),
'germansk': ('germansk',),
'germanske': ('germansk',),
'germanskere': ('germansk',),
'germanskest': ('germansk',),
'germanskeste': ('germansk',),
'geråda': ('geråde',),
'gerådede': ('geråde',),
'gerådende': ('geråde',),
'gerådet': ('geråde',),
'gerådete': ('geråde',),
'geskjeftig': ('geskjeftig',),
'geskjeftige': ('geskjeftig',),
'geskjeftigere': ('geskjeftig',),
'geskjeftigst': ('geskjeftig',),
'geskjeftigste': ('geskjeftig',),
'gestalta': ('gestalte',),
'gestaltede': ('gestalte',),
'gestaltende': ('gestalte',),
'gestaltet': ('gestalte',),
'gestaltete': ('gestalte',),
'gestikulerende': ('gestikulere',),
'gestikulert': ('gestikulere',),
'gestikulerte': ('gestikulere',),
'gesvint': ('gesvint',),
'gesvinte': ('gesvint',),
'gesvintere': ('gesvint',),
'gesvintest': ('gesvint',),
'gesvinteste': ('gesvint',),
'ghanesisk': ('ghanesisk',),
'ghanesiske': ('ghanesisk',),
'ghanesiskere': ('ghanesisk',),
'ghanesiskest': ('ghanesisk',),
'ghanesiskeste': ('ghanesisk',),
'giende': ('gi',),
'gitt': ('gi',),
'gitte': ('gi',),
'givende': ('gi',),
'gidden': ('gidde',),
'giddende': ('gidde',),
'giddet': ('gidde',),
'gidne': ('gidde',),
'giddelaus': ('giddelaus',),
'giddelause': ('giddelaus',),
'giddelausere': ('giddelaus',),
'giddelausest': ('giddelaus',),
'giddelauseste': ('giddelaus',),
'giddelaust': ('giddelaus',),
'giddeløs': ('giddeløs',),
'giddeløse': ('giddeløs',),
'giddeløsere': ('giddeløs',),
'giddeløsest': ('giddeløs',),
'giddeløseste': ('giddeløs',),
'giddeløst': ('giddeløs',),
'gift': ('gift',),
'gifte': ('gift',),
'giftere': ('gift',),
'giftest': ('gift',),
'gifteste': ('gift',),
'gifta': ('gifte',),
'giftede': ('gifte',),
'giftende': ('gifte',),
'giftet': ('gifte',),
'giftete': ('gifte',),
'giftegal': ('giftegal',),
'giftegale': ('giftegal',),
'giftegalere': ('giftegal',),
'giftegalest': ('giftegal',),
'giftegaleste': ('giftegal',),
'giftegalt': ('giftegal',),
'giftgrøn': ('giftgrøn',),
'giftgrøne': ('giftgrøn',),
'giftgrønere': ('giftgrøn',),
'giftgrønest': ('giftgrøn',),
'giftgrøneste': ('giftgrøn',),
'giftgrønt': ('giftgrøn',),
'giftgrønn': ('giftgrønn',),
'giftgrønne': ('giftgrønn',),
'giftgrønnere': ('giftgrønn',),
'giftgrønnest': ('giftgrønn',),
'giftgrønneste': ('giftgrønn',),
'giftgrønt': ('giftgrønn',),
'giftig': ('giftig',),
'giftige': ('giftig',),
'giftigere': ('giftig',),
'giftigst': ('giftig',),
'giftigste': ('giftig',),
'giftiggrøn': ('giftiggrøn',),
'giftiggrøne': ('giftiggrøn',),
'giftiggrønere': ('giftiggrøn',),
'giftiggrønest': ('giftiggrøn',),
'giftiggrøneste': ('giftiggrøn',),
'giftiggrønt': ('giftiggrøn',),
'giftiggrønn': ('giftiggrønn',),
'giftiggrønne': ('giftiggrønn',),
'giftiggrønnere': ('giftiggrønn',),
'giftiggrønnest': ('giftiggrønn',),
'giftiggrønneste': ('giftiggrønn',),
'giftiggrønt': ('giftiggrønn',),
'gigantisk': ('gigantisk',),
'gigantiske': ('gigantisk',),
'gigantiskere': ('gigantisk',),
'gigantiskest': ('gigantisk',),
'gigantiskeste': ('gigantisk',),
'gigga': ('gigge',),
'giggede': ('gigge',),
'giggende': ('gigge',),
'gigget': ('gigge',),
'giggete': ('gigge',),
'giktisk': ('giktisk',),
'giktiske': ('giktisk',),
'giktiskere': ('giktisk',),
'giktiskest': ('giktisk',),
'giktiskeste': ('giktisk',),
'giktsjuk': ('giktsjuk',),
'giktsjuke': ('giktsjuk',),
'giktsjukere': ('giktsjuk',),
'giktsjukest': ('giktsjuk',),
'giktsjukeste': ('giktsjuk',),
'giktsjukt': ('giktsjuk',),
'giktsyk': ('giktsyk',),
'giktsyke': ('giktsyk',),
'giktsykere': ('giktsyk',),
'giktsykest': ('giktsyk',),
'giktsykeste': ('giktsyk',),
'giktsykt': ('giktsyk',),
'gild': ('gild',),
'gilde': ('gild',),
'gildere': ('gild',),
'gildest': ('gild',),
'gildeste': ('gild',),
'gildt': ('gild',),
'gildra': ('gildre',),
'gildrede': ('gildre',),
'gildrende': ('gildre',),
'gildret': ('gildre',),
'gildrete': ('gildre',),
'giljotinerende': ('giljotinere',),
'giljotinert': ('giljotinere',),
'giljotinerte': ('giljotinere',),
'gimpa': ('gimpe',),
'gimpede': ('gimpe',),
'gimpende': ('gimpe',),
'gimpet': ('gimpe',),
'gimpete': ('gimpe',),
'gingival': ('gingival',),
'gingivale': ('gingival',),
'gingivalere': ('gingival',),
'gingivalest': ('gingival',),
'gingivaleste': ('gingival',),
'gingivalt': ('gingival',),
'gipsa': ('gipse',),
'gipsede': ('gipse',),
'gipsende': ('gipse',),
'gipset': ('gipse',),
'gipsete': ('gipse',),
'gipst': ('gipse',),
'gipste': ('gipse',),
'girerende': ('girere',),
'girert': ('girere',),
'girerte': ('girere',),
'gisna': ('gisne',),
'gisnede': ('gisne',),
'gisnende': ('gisne',),
'gisnet': ('gisne',),
'gisnete': ('gisne',),
'gispa': ('gispe',),
'gispede': ('gispe',),
'gispende': ('gispe',),
'gispet': ('gispe',),
'gispete': ('gispe',),
'gissa': ('gisse',),
'gissede': ('gisse',),
'gissende': ('gisse',),
'gisset': ('gisse',),
'gissete': ('gisse',),
'gisne': ('gissen',),
'gisnere': ('gissen',),
'gisnest': ('gissen',),
'gisneste': ('gissen',),
'gissen': ('gissen',),
'gissent': ('gissen',),
'gitra': ('gitre',),
'gitrede': ('gitre',),
'gitrende': ('gitre',),
'gitret': ('gitre',),
'gitrete': ('gitre',),
'givende': ('givende',),
'gjalla': ('gjalle',),
'gjallede': ('gjalle',),
'gjallende': ('gjalle',),
'gjallet': ('gjalle',),
'gjallete': ('gjalle',),
'gjekka': ('gjekke',),
'gjekkede': ('gjekke',),
'gjekkende': ('gjekke',),
'gjekket': ('gjekke',),
'gjekkete': ('gjekke',),
'gjeld': ('gjeld',),
'gjelde': ('gjeld',),
'gjeldere': ('gjeld',),
'gjeldest': ('gjeld',),
'gjeldeste': ('gjeld',),
'gjeldt': ('gjeld',),
'gjeldbunden': ('gjeldbunden',),
'gjeldbundet': ('gjeldbunden',),
'gjeldbundne': ('gjeldbunden',),
'gjeldbundnere': ('gjeldbunden',),
'gjeldbundnest': ('gjeldbunden',),
'gjeldbundneste': ('gjeldbunden',),
'gjeldbundet': ('gjeldbundet',),
'gjeldbundne': ('gjeldbundet',),
'gjeldbundnere': ('gjeldbundet',),
'gjeldbundnest': ('gjeldbundet',),
'gjeldbundneste': ('gjeldbundet',),
'gjelda': ('gjelde',),
'gjeldede': ('gjelde',),
'gjeldende': ('gjelde',),
'gjeldet': ('gjelde',),
'gjeldete': ('gjelde',),
'gjeldt': ('gjelde',),
'gjeldte': ('gjelde',),
'gjeldende': ('gjelde',),
'gjeldt': ('gjelde',),
'gjeldte': ('gjelde',),
'gjeldende': ('gjeldende',),
'gjeldfri': ('gjeldfri',),
'gjeldfrie': ('gjeldfri',),
'gjeldfriere': ('gjeldfri',),
'gjeldfriest': ('gjeldfri',),
'gjeldfrieste': ('gjeldfri',),
'gjeldfritt': ('gjeldfri',),
'gjellende': ('gjelle',),
'gjelt': ('gjelle',),
'gjelte': ('gjelle',),
'gjemmende': ('gjemme',),
'gjemt': ('gjemme',),
'gjemte': ('gjemme',),
'gjenbrukbar': ('gjenbrukbar',),
'gjenbrukbare': ('gjenbrukbar',),
'gjenbrukbarere': ('gjenbrukbar',),
'gjenbrukbarest': ('gjenbrukbar',),
'gjenbrukbareste': ('gjenbrukbar',),
'gjenbrukbart': ('gjenbrukbar',),
'gjenbrukende': ('gjenbruke',),
'gjenbrukt': ('gjenbruke',),
'gjenbrukte': ('gjenbruke',),
'gjendrivelig': ('gjendrivelig',),
'gjendrivelige': ('gjendrivelig',),
'gjendriveligere': ('gjendrivelig',),
'gjendriveligst': ('gjendrivelig',),
'gjendriveligste': ('gjendrivelig',),
'gjenerobra': ('gjenerobre',),
'gjenerobrede': ('gjenerobre',),
'gjenerobrende': ('gjenerobre',),
'gjenerobret': ('gjenerobre',),
'gjenerobrete': ('gjenerobre',),
'gjenforena': ('gjenforene',),
'gjenforenede': ('gjenforene',),
'gjenforenende': ('gjenforene',),
'gjenforenet': ('gjenforene',),
'gjenforenete': ('gjenforene',),
'gjenforent': ('gjenforene',),
'gjenforente': ('gjenforene',),
'gjenforsikret': ('gjenforsikre',),
'gjenforsikrete': ('gjenforsikre',),
'gjenforsikra': ('gjenforsikre',),
'gjenforsikrede': ('gjenforsikre',),
'gjenforsikrende': ('gjenforsikre',),
'gjenga': ('gjenge',),
'gjengede': ('gjenge',),
'gjengende': ('gjenge',),
'gjenget': ('gjenge',),
'gjengete': ('gjenge',),
'gjenget': ('gjenget',),
'gjengete': ('gjenget',),
'gjengetere': ('gjenget',),
'gjengetest': ('gjenget',),
'gjengeteste': ('gjenget',),
'gjengete': ('gjengete',),
'gjengiende': ('gjengi',),
'gjengitt': ('gjengi',),
'gjengitte': ('gjengi',),
'gjengivende': ('gjengi',),
'gjengifta': ('gjengifte',),
'gjengiftede': ('gjengifte',),
'gjengiftende': ('gjengifte',),
'gjengiftet': ('gjengifte',),
'gjengiftete': ('gjengifte',),
'gjengjeldende': ('gjengjelde',),
'gjengjeldt': ('gjengjelde',),
'gjengjeldte': ('gjengjelde',),
'gjenglemt': ('gjenglemt',),
'gjenglemte': ('gjenglemt',),
'gjenglemtere': ('gjenglemt',),
'gjenglemtest': ('gjenglemt',),
'gjenglemteste': ('gjenglemt',),
'gjenglømt': ('gjenglømt',),
'gjenglømte': ('gjenglømt',),
'gjenglømtere': ('gjenglømt',),
'gjenglømtest': ('gjenglømt',),
'gjenglømteste': ('gjenglømt',),
'gjengrodd': ('gjengrodd',),
'gjengrodde': ('gjengrodd',),
'gjengroddere': ('gjengrodd',),
'gjengroddest': ('gjengrodd',),
'gjengroddeste': ('gjengrodd',),
'gjengs': ('gjengs',),
'gjengse': ('gjengs',),
'gjengsere': ('gjengs',),
'gjengsest': ('gjengs',),
'gjengseste': ('gjengs',),
'gjeninnførende': ('gjeninnføre',),
'gjeninnført': ('gjeninnføre',),
'gjeninnførte': ('gjeninnføre',),
'gjeninnsatt': ('gjeninnsette',),
'gjeninnsatte': ('gjeninnsette',),
'gjeninnsettende': ('gjeninnsette',),
'gjeninntakende': ('gjeninnta',),
'gjeninntatt': ('gjeninnta',),
'gjeninntatte': ('gjeninnta',),
'gjenkallende': ('gjenkalle',),
'gjenkalt': ('gjenkalle',),
'gjenkalte': ('gjenkalle',),
'gjenkjennende': ('gjenkjenne',),
'gjenkjent': ('gjenkjenne',),
'gjenkjente': ('gjenkjenne',),
'gjenkjennelig': ('gjenkjennelig',),
'gjenkjennelige': ('gjenkjennelig',),
'gjenkjenneligere': ('gjenkjennelig',),
'gjenkjenneligst': ('gjenkjennelig',),
'gjenkjenneligste': ('gjenkjennelig',),
'gjenlagt': ('gjenlegge',),
'gjenlagte': ('gjenlegge',),
'gjenleggende': ('gjenlegge',),
'gjenlevende': ('gjenlevende',),
'gjenløsende': ('gjenløse',),
'gjenløst': ('gjenløse',),
'gjenløste': ('gjenløse',),
'gjennomarbeida': ('gjennomarbeide',),
'gjennomarbeidd': ('gjennomarbeide',),
'gjennomarbeidde': ('gjennomarbeide',),
'gjennomarbeidede': ('gjennomarbeide',),
'gjennomarbeidende': ('gjennomarbeide',),
'gjennomarbeidet': ('gjennomarbeide',),
'gjennomarbeidete': ('gjennomarbeide',),
'gjennombarka': ('gjennombarka',),
'gjennombarkede': ('gjennombarket',),
'gjennombarket': ('gjennombarket',),
'gjennombarkete': ('gjennombarket',),
'gjennombarketere': ('gjennombarket',),
'gjennombarketest': ('gjennombarket',),
'gjennombarketeste': ('gjennombarket',),
'gjennomblaut': ('gjennomblaut',),
'gjennomblaute': ('gjennomblaut',),
'gjennomblautere': ('gjennomblaut',),
'gjennomblautest': ('gjennomblaut',),
'gjennomblauteste': ('gjennomblaut',),
'gjennomblautt': ('gjennomblaut',),
'gjennombløt': ('gjennombløt',),
'gjennombløte': ('gjennombløt',),
'gjennombløtere': ('gjennombløt',),
'gjennombløtest': ('gjennombløt',),
'gjennombløteste': ('gjennombløt',),
'gjennombløtt': ('gjennombløt',),
'gjennombora': ('gjennombore',),
'gjennomborede': ('gjennombore',),
'gjennomborende': ('gjennombore',),
'gjennomboret': ('gjennombore',),
'gjennomborete': ('gjennombore',),
'gjennomdrøfta': ('gjennomdrøfte',),
'gjennomdrøftede': ('gjennomdrøfte',),
'gjennomdrøftende': ('gjennomdrøfte',),
'gjennomdrøftet': ('gjennomdrøfte',),
'gjennomdrøftete': ('gjennomdrøfte',),
'gjennomfrosne': ('gjennomfrossen',),
'gjennomfrosnere': ('gjennomfrossen',),
'gjennomfrosnest': ('gjennomfrossen',),
'gjennomfrosneste': ('gjennomfrossen',),
'gjennomfrossen': ('gjennomfrossen',),
'gjennomfrosset': ('gjennomfrossen',),
'gjennomfrosne': ('gjennomfrosset',),
'gjennomfrosnere': ('gjennomfrosset',),
'gjennomfrosnest': ('gjennomfrosset',),
'gjennomfrosneste': ('gjennomfrosset',),
'gjennomfrosset': ('gjennomfrosset',),
'gjennomførende': ('gjennomføre',),
'gjennomført': ('gjennomføre',),
'gjennomførte': ('gjennomføre',),
'gjennomførlig': ('gjennomførlig',),
'gjennomførlige': ('gjennomførlig',),
'gjennomførligere': ('gjennomførlig',),
'gjennomførligst': ('gjennomførlig',),
'gjennomførligste': ('gjennomførlig',),
'gjennomført': ('gjennomført',),
'gjennomførte': ('gjennomført',),
'gjennomførtere': ('gjennomført',),
'gjennomførtest': ('gjennomført',),
'gjennomførteste': ('gjennomført',),
'gjennomgripende': ('gjennomgripende',),
'gjennomgående': ('gjennomgå',),
'gjennomgått': ('gjennomgå',),
'gjennomgåtte': ('gjennomgå',),
'gjennomgående': ('gjennomgående',),
'gjennomhulla': ('gjennomhulle',),
'gjennomhullede': ('gjennomhulle',),
'gjennomhullende': ('gjennomhulle',),
'gjennomhullet': ('gjennomhulle',),
'gjennomhullete': ('gjennomhulle',),
'gjennomillustrerende': ('gjennomillustrere',),
'gjennomillustrert': ('gjennomillustrere',),
'gjennomillustrerte': ('gjennomillustrere',),
'gjennomlesende': ('gjennomlese',),
'gjennomlest': ('gjennomlese',),
'gjennomleste': ('gjennomlese',),
'gjennomlevd': ('gjennomleve',),
'gjennomlevde': ('gjennomleve',),
'gjennomlevende': ('gjennomleve',),
'gjennomlufta': ('gjennomlufte',),
'gjennomluftede': ('gjennomlufte',),
'gjennomluftende': ('gjennomlufte',),
'gjennomluftet': ('gjennomlufte',),
'gjennomluftete': ('gjennomlufte',),
'gjennomlysende': ('gjennomlyse',),
'gjennomlyst': ('gjennomlyse',),
'gjennomlyste': ('gjennomlyse',),
'gjennomprøvd': ('gjennomprøve',),
'gjennomprøvde': ('gjennomprøve',),
'gjennomprøvende': ('gjennomprøve',),
'gjennomseende': ('gjennomse',),
'gjennomsett': ('gjennomse',),
'gjennomsette': ('gjennomse',),
'gjennomsiktig': ('gjennomsiktig',),
'gjennomsiktige': ('gjennomsiktig',),
'gjennomsiktigere': ('gjennomsiktig',),
'gjennomsiktigst': ('gjennomsiktig',),
'gjennomsiktigste': ('gjennomsiktig',),
'gjennomskinnelig': ('gjennomskinnelig',),
'gjennomskinnelige': ('gjennomskinnelig',),
'gjennomskinneligere': ('gjennomskinnelig',),
'gjennomskinneligst': ('gjennomskinnelig',),
'gjennomskinneligste': ('gjennomskinnelig',),
'gjennomskua': ('gjennomskue',),
'gjennomskuede': ('gjennomskue',),
'gjennomskuende': ('gjennomskue',),
'gjennomskuet': ('gjennomskue',),
'gjennomskuete': ('gjennomskue',),
'gjennomsnittlig': ('gjennomsnittlig',),
'gjennomsnittlige': ('gjennomsnittlig',),
'gjennomsnittligere': ('gjennomsnittlig',),
'gjennomsnittligst': ('gjennomsnittlig',),
'gjennomsnittligste': ('gjennomsnittlig',),
'gjennomsteikende': ('gjennomsteike',),
'gjennomsteikt': ('gjennomsteike',),
'gjennomsteikte': ('gjennomsteike',),
'gjennomstekende': ('gjennomsteke',),
'gjennomstekt': ('gjennomsteke',),
'gjennomstekte': ('gjennomsteke',),
'gjennomstrømma': ('gjennomstrømme',),
'gjennomstrømmede': ('gjennomstrømme',),
'gjennomstrømmende': ('gjennomstrømme',),
'gjennomstrømmet': ('gjennomstrømme',),
'gjennomstrømmete': ('gjennomstrømme',),
'gjennomstrømt': ('gjennomstrømme',),
'gjennomstrømte': ('gjennomstrømme',),
'gjennomsvett': ('gjennomsvett',),
'gjennomsvette': ('gjennomsvett',),
'gjennomsvettere': ('gjennomsvett',),
'gjennomsvettest': ('gjennomsvett',),
'gjennomsvetteste': ('gjennomsvett',),
'gjennomsyra': ('gjennomsyre',),
'gjennomsyrede': ('gjennomsyre',),
'gjennomsyrende': ('gjennomsyre',),
'gjennomsyret': ('gjennomsyre',),
'gjennomsyrete': ('gjennomsyre',),
'gjennomsyrt': ('gjennomsyre',),
'gjennomsyrte': ('gjennomsyre',),
'gjennomtenkende': ('gjennomtenke',),
'gjennomtenkt': ('gjennomtenke',),
'gjennomtenkte': ('gjennomtenke',),
'gjennomtrengende': ('gjennomtrenge',),
'gjennomtrengt': ('gjennomtrenge',),
'gjennomtrengte': ('gjennomtrenge',),
'gjennomtrengelig': ('gjennomtrengelig',),
'gjennomtrengelige': ('gjennomtrengelig',),
'gjennomtrengeligere': ('gjennomtrengelig',),
'gjennomtrengeligst': ('gjennomtrengelig',),
'gjennomtrengeligste': ('gjennomtrengelig',),
'gjennomtrengende': ('gjennomtrengende',),
'gjennomtråla': ('gjennomtråle',),
'gjennomtrålede': ('gjennomtråle',),
'gjennomtrålende': ('gjennomtråle',),
'gjennomtrålet': ('gjennomtråle',),
'gjennomtrålete': ('gjennomtråle',),
'gjennomtrålt': ('gjennomtråle',),
'gjennomtrålte': ('gjennomtråle',),
'gjennomtørr': ('gjennomtørr',),
'gjennomtørre': ('gjennomtørr',),
'gjennomtørrere': ('gjennomtørr',),
'gjennomtørrest': ('gjennomtørr',),
'gjennomtørreste': ('gjennomtørr',),
'gjennomtørt': ('gjennomtørr',),
'gjennomvarm': ('gjennomvarm',),
'gjennomvarme': ('gjennomvarm',),
'gjennomvarmere': ('gjennomvarm',),
'gjennomvarmest': ('gjennomvarm',),
'gjennomvarmeste': ('gjennomvarm',),
'gjennomvarmt': ('gjennomvarm',),
'gjennomvåt': ('gjennomvåt',),
'gjennomvåte': ('gjennomvåt',),
'gjennomvåtere': ('gjennomvåt',),
'gjennomvåtest': ('gjennomvåt',),
'gjennomvåteste': ('gjennomvåt',),
'gjennomvått': ('gjennomvåt',),
'gjenoppblussa': ('gjenoppblusse',),
'gjenoppblussede': ('gjenoppblusse',),
'gjenoppblussende': ('gjenoppblusse',),
'gjenoppblusset': ('gjenoppblusse',),
'gjenoppblussete': ('gjenoppblusse',),
'gjenoppbygd': ('gjenoppbygge',),
'gjenoppbygde': ('gjenoppbygge',),
'gjenoppbygga': ('gjenoppbygge',),
'gjenoppbyggede': ('gjenoppbygge',),
'gjenoppbyggende': ('gjenoppbygge',),
'gjenoppbygget': ('gjenoppbygge',),
'gjenoppbyggete': ('gjenoppbygge',),
'gjenoppdaga': ('gjenoppdage',),
'gjenoppdagede': ('gjenoppdage',),
'gjenoppdagende': ('gjenoppdage',),
'gjenoppdaget': ('gjenoppdage',),
'gjenoppdagete': ('gjenoppdage',),
'gjenoppfriska': ('gjenoppfriske',),
'gjenoppfriskede': ('gjenoppfriske',),
'gjenoppfriskende': ('gjenoppfriske',),
'gjenoppfrisket': ('gjenoppfriske',),
'gjenoppfriskete': ('gjenoppfriske',),
'gjenopplevd': ('gjenoppleve',),
'gjenopplevde': ('gjenoppleve',),
'gjenopplevende': ('gjenoppleve',),
'gjenoppliva': ('gjenopplive',),
'gjenopplivede': ('gjenopplive',),
'gjenopplivende': ('gjenopplive',),
'gjenopplivet': ('gjenopplive',),
'gjenopplivete': ('gjenopplive',),
'gjenoppretta': ('gjenopprette',),
'gjenopprettede': ('gjenopprette',),
'gjenopprettende': ('gjenopprette',),
'gjenopprettet': ('gjenopprette',),
'gjenopprettete': ('gjenopprette',),
'gjenopptakende': ('gjenoppta',),
'gjenopptatt': ('gjenoppta',),
'gjenopptatte': ('gjenoppta',),
'gjenopptrykka': ('gjenopptrykke',),
'gjenopptrykkede': ('gjenopptrykke',),
'gjenopptrykkende': ('gjenopptrykke',),
'gjenopptrykket': ('gjenopptrykke',),
'gjenopptrykkete': ('gjenopptrykke',),
'gjenopptrykt': ('gjenopptrykke',),
'gjenopptrykte': ('gjenopptrykke',),
'gjenoppvekka': ('gjenoppvekke',),
'gjenoppvekkede': ('gjenoppvekke',),
'gjenoppvekkende': ('gjenoppvekke',),
'gjenoppvekket': ('gjenoppvekke',),
'gjenoppvekkete': ('gjenoppvekke',),
'gjenoppvekt': ('gjenoppvekke',),
'gjenoppvekte': ('gjenoppvekke',),
'gjenreisende': ('gjenreise',),
'gjenreist': ('gjenreise',),
'gjenreiste': ('gjenreise',),
'gjensidig': ('gjensidig',),
'gjensidige': ('gjensidig',),
'gjensidigere': ('gjensidig',),
'gjensidigst': ('gjensidig',),
'gjensidigste': ('gjensidig',),
'gjenskapa': ('gjenskape',),
'gjenskapende': ('gjenskape',),
'gjenskapt': ('gjenskape',),
'gjenskapte': ('gjenskape',),
'gjensnødd': ('gjensnødd',),
'gjensnødde': ('gjensnødd',),
'gjensnøddere': ('gjensnødd',),
'gjensnøddest': ('gjensnødd',),
'gjensnøddeste': ('gjensnødd',),
'gjenspeila': ('gjenspeile',),
'gjenspeilede': ('gjenspeile',),
'gjenspeilende': ('gjenspeile',),
'gjenspeilet': ('gjenspeile',),
'gjenspeilete': ('gjenspeile',),
'gjenspeilt': ('gjenspeile',),
'gjenspeilte': ('gjenspeile',),
'gjenstridig': ('gjenstridig',),
'gjenstridige': ('gjenstridig',),
'gjenstridigere': ('gjenstridig',),
'gjenstridigst': ('gjenstridig',),
'gjenstridigste': ('gjenstridig',),
'gjentakende': ('gjenta',),
'gjentatt': ('gjenta',),
'gjentatte': ('gjenta',),
'gjenvalgt': ('gjenvelge',),
'gjenvalgte': ('gjenvelge',),
'gjenvelgende': ('gjenvelge',),
'gjenvinnbar': ('gjenvinnbar',),
'gjenvinnbare': ('gjenvinnbar',),
'gjenvinnbarere': ('gjenvinnbar',),
'gjenvinnbarest': ('gjenvinnbar',),
'gjenvinnbareste': ('gjenvinnbar',),
'gjenvinnbart': ('gjenvinnbar',),
'gjenværende': ('gjenværende',),
'gjenåpna': ('gjenåpne',),
'gjenåpnede': ('gjenåpne',),
'gjenåpnende': ('gjenåpne',),
'gjenåpnet': ('gjenåpne',),
'gjenåpnete': ('gjenåpne',),
'gjerda': ('gjerde',),
'gjerdede': ('gjerde',),
'gjerdende': ('gjerde',),
'gjerdet': ('gjerde',),
'gjerdete': ('gjerde',),
'gjerdelaus': ('gjerdelaus',),
'gjerdelause': ('gjerdelaus',),
'gjerdelausere': ('gjerdelaus',),
'gjerdelausest': ('gjerdelaus',),
'gjerdelauseste': ('gjerdelaus',),
'gjerdelaust': ('gjerdelaus',),
'gjerdeløs': ('gjerdeløs',),
'gjerdeløse': ('gjerdeløs',),
'gjerdeløsere': ('gjerdeløs',),
'gjerdeløsest': ('gjerdeløs',),
'gjerdeløseste': ('gjerdeløs',),
'gjerdeløst': ('gjerdeløs',),
'gjerrig': ('gjerrig',),
'gjerrige': ('gjerrig',),
'gjerrigere': ('gjerrig',),
'gjerrigst': ('gjerrig',),
'gjerrigste': ('gjerrig',),
'gjespa': ('gjespe',),
'gjespede': ('gjespe',),
'gjespende': ('gjespe',),
'gjespet': ('gjespe',),
'gjespete': ('gjespe',),
'gjesta': ('gjeste',),
'gjestede': ('gjeste',),
'gjestende': ('gjeste',),
'gjestet': ('gjeste',),
'gjestete': ('gjeste',),
'gjestfri': ('gjestfri',),
'gjestfrie': ('gjestfri',),
'gjestfriere': ('gjestfri',),
'gjestfriest': ('gjestfri',),
'gjestfrieste': ('gjestfri',),
'gjestfritt': ('gjestfri',),
'gjestmild': ('gjestmild',),
'gjestmilde': ('gjestmild',),
'gjestmildere': ('gjestmild',),
'gjestmildest': ('gjestmild',),
'gjestmildeste': ('gjestmild',),
'gjestmildt': ('gjestmild',),
'gjetende': ('gjete',),
'gjett': ('gjete',),
'gjette': ('gjete',),
'gjetta': ('gjette',),
'gjettede': ('gjette',),
'gjettende': ('gjette',),
'gjettet': ('gjette',),
'gjettete': ('gjette',),
'gjev': ('gjev',),
'gjeve': ('gjev',),
'gjevere': ('gjev',),
'gjevest': ('gjev',),
'gjeveste': ('gjev',),
'gjevt': ('gjev',),
'gjev': ('gjev',),
'gjeve': ('gjev',),
'gjevere': ('gjev',),
'gjevest': ('gjev',),
'gjeveste': ('gjev',),
'gjevt': ('gjev',),
'gjorda': ('gjorde',),
'gjordede': ('gjorde',),
'gjordende': ('gjorde',),
'gjordet': ('gjorde',),
'gjordete': ('gjorde',),
'gjura': ('gjure',),
'gjurede': ('gjure',),
'gjurende': ('gjure',),
'gjuret': ('gjure',),
'gjurete': ('gjure',),
'gjurt': ('gjure',),
'gjurte': ('gjure',),
'gjæra': ('gjære',),
'gjærede': ('gjære',),
'gjærende': ('gjære',),
'gjæret': ('gjære',),
'gjærete': ('gjære',),
'gjært': ('gjære',),
'gjærte': ('gjære',),
'gjæra': ('gjære',),
'gjærede': ('gjære',),
'gjærende': ('gjære',),
'gjæret': ('gjære',),
'gjærete': ('gjære',),
'gjært': ('gjære',),
'gjærte': ('gjære',),
'gjæv': ('gjæv',),
'gjæve': ('gjæv',),
'gjævere': ('gjæv',),
'gjævest': ('gjæv',),
'gjæveste': ('gjæv',),
'gjævt': ('gjæv',),
'gjæv': ('gjæv',),
'gjæve': ('gjæv',),
'gjævere': ('gjæv',),
'gjævest': ('gjæv',),
'gjæveste': ('gjæv',),
'gjævt': ('gjæv',),
'gjødd': ('gjø',),
'gjødde': ('gjø',),
'gjøende': ('gjø',),
'gjødd': ('gjø',),
'gjødde': ('gjø',),
'gjøende': ('gjø',),
'gjødd': ('gjøde',),
'gjødde': ('gjøde',),
'gjødende': ('gjøde',),
'gjødsla': ('gjødsle',),
'gjødslede': ('gjødsle',),
'gjødslende': ('gjødsle',),
'gjødslet': ('gjødsle',),
'gjødslete': ('gjødsle',),
'gjøgla': ('gjøgle',),
'gjøglede': ('gjøgle',),
'gjøglende': ('gjøgle',),
'gjøglet': ('gjøgle',),
'gjøglete': ('gjøgle',),
'gjølende': ('gjøle',),
'gjølt': ('gjøle',),
'gjølte': ('gjøle',),
'gjølet': ('gjølet',),
'gjølete': ('gjølet',),
'gjøletere': ('gjølet',),
'gjøletest': ('gjølet',),
'gjøleteste': ('gjølet',),
'gjølete': ('gjølete',),
'gjømmende': ('gjømme',),
'gjømt': ('gjømme',),
'gjømte': ('gjømme',),
'gjønende': ('gjøne',),
'gjønt': ('gjøne',),
'gjønte': ('gjøne',),
'gjort': ('gjøre',),
'gjorte': ('gjøre',),
'gjørende': ('gjøre',),
'gjørlig': ('gjørlig',),
'gjørlige': ('gjørlig',),
'gjørligere': ('gjørlig',),
'gjørligst': ('gjørlig',),
'gjørligste': ('gjørlig',),
'gjørma': ('gjørme',),
'gjørmede': ('gjørme',),
'gjørmende': ('gjørme',),
'gjørmet': ('gjørme',),
'gjørmete': ('gjørme',),
'gjørmet': ('gjørmet',),
'gjørmete': ('gjørmet',),
'gjørmetere': ('gjørmet',),
'gjørmetest': ('gjørmet',),
'gjørmeteste': ('gjørmet',),
'gjørmete': ('gjørmete',),
'gladd': ('gla',),
'gladde': ('gla',),
'glaende': ('gla',),
'glad': ('glad',),
'glade': ('glad',),
'gladere': ('glad',),
'gladest': ('glad',),
'gladeste': ('glad',),
'gladlynt': ('gladlynt',),
'gladlynte': ('gladlynt',),
'gladlyntere': ('gladlynt',),
'gladlyntest': ('gladlynt',),
'gladlynteste': ('gladlynt',),
'glafsa': ('glafse',),
'glafsede': ('glafse',),
'glafsende': ('glafse',),
'glafset': ('glafse',),
'glafsete': ('glafse',),
'glamma': ('glamme',),
'glammede': ('glamme',),
'glammende': ('glamme',),
'glammet': ('glamme',),
'glammete': ('glamme',),
'glamoriserende': ('glamorisere',),
'glamorisert': ('glamorisere',),
'glamoriserte': ('glamorisere',),
'glamorøs': ('glamorøs',),
'glamorøse': ('glamorøs',),
'glamorøsere': ('glamorøs',),
'glamorøsest': ('glamorøs',),
'glamorøseste': ('glamorøs',),
'glamorøst': ('glamorøs',),
'glana': ('glane',),
'glanende': ('glane',),
'glant': ('glane',),
'glante': ('glane',),
'glansa': ('glanse',),
'glansede': ('glanse',),
'glansende': ('glanse',),
'glanset': ('glanse',),
'glansete': ('glanse',),
'glasaktig': ('glasaktig',),
'glasaktige': ('glasaktig',),
'glasaktigere': ('glasaktig',),
'glasaktigst': ('glasaktig',),
'glasaktigste': ('glasaktig',),
'glasaktig': ('glasaktig',),
'glasaktige': ('glasaktig',),
'glasaktigere': ('glasaktig',),
'glasaktigst': ('glasaktig',),
'glasaktigste': ('glasaktig',),
'glasblank': ('glasblank',),
'glasblanke': ('glasblank',),
'glasblankere': ('glasblank',),
'glasblankest': ('glasblank',),
'glasblankeste': ('glasblank',),
'glasblankt': ('glasblank',),
'glasblank': ('glasblank',),
'glasblanke': ('glasblank',),
'glasblankere': ('glasblank',),
'glasblankest': ('glasblank',),
'glasblankeste': ('glasblank',),
'glasblankt': ('glasblank',),
'glaserende': ('glasere',),
'glasert': ('glasere',),
'glaserte': ('glasere',),
'glaserende': ('glasere',),
'glasert': ('glasere',),
'glaserte': ('glasere',),
'glashard': ('glashard',),
'glasharde': ('glashard',),
'glashardere': ('glashard',),
'glashardest': ('glashard',),
'glashardeste': ('glashard',),
'glashardt': ('glashard',),
'glashard': ('glashard',),
'glasharde': ('glashard',),
'glashardere': ('glashard',),
'glashardest': ('glashard',),
'glashardeste': ('glashard',),
'glashardt': ('glashard',),
'glasial': ('glasial',),
'glasiale': ('glasial',),
'glasialere': ('glasial',),
'glasialest': ('glasial',),
'glasialeste': ('glasial',),
'glasialt': ('glasial',),
'glasiologisk': ('glasiologisk',),
'glasiologiske': ('glasiologisk',),
'glasiologiskere': ('glasiologisk',),
'glasiologiskest': ('glasiologisk',),
'glasiologiskeste': ('glasiologisk',),
'glasklar': ('glasklar',),
'glasklare': ('glasklar',),
'glasklarere': ('glasklar',),
'glasklarest': ('glasklar',),
'glasklareste': ('glasklar',),
'glasklart': ('glasklar',),
'glasklar': ('glasklar',),
'glasklare': ('glasklar',),
'glasklarere': ('glasklar',),
'glasklarest': ('glasklar',),
'glasklareste': ('glasklar',),
'glasklart': ('glasklar',),
'glassaktig': ('glassaktig',),
'glassaktige': ('glassaktig',),
'glassaktigere': ('glassaktig',),
'glassaktigst': ('glassaktig',),
'glassaktigste': ('glassaktig',),
'glassaktig': ('glassaktig',),
'glassaktige': ('glassaktig',),
'glassaktigere': ('glassaktig',),
'glassaktigst': ('glassaktig',),
'glassaktigste': ('glassaktig',),
'glassblank': ('glassblank',),
'glassblanke': ('glassblank',),
'glassblankere': ('glassblank',),
'glassblankest': ('glassblank',),
'glassblankeste': ('glassblank',),
'glassblankt': ('glassblank',),
'glassblank': ('glassblank',),
'glassblanke': ('glassblank',),
'glassblankere': ('glassblank',),
'glassblankest': ('glassblank',),
'glassblankeste': ('glassblank',),
'glassblankt': ('glassblank',),
'glasserende': ('glassere',),
'glassert': ('glassere',),
'glasserte': ('glassere',),
'glasserende': ('glassere',),
'glassert': ('glassere',),
'glasserte': ('glassere',),
'glasshard': ('glasshard',),
'glassharde': ('glasshard',),
'glasshardere': ('glasshard',),
'glasshardest': ('glasshard',),
'glasshardeste': ('glasshard',),
'glasshardt': ('glasshard',),
'glasshard': ('glasshard',),
'glassharde': ('glasshard',),
'glasshardere': ('glasshard',),
'glasshardest': ('glasshard',),
'glasshardeste': ('glasshard',),
'glasshardt': ('glasshard',),
'glassklar': ('glassklar',),
'glassklare': ('glassklar',),
'glassklarere': ('glassklar',),
'glassklarest': ('glassklar',),
'glassklareste': ('glassklar',),
'glassklart': ('glassklar',),
'glassklar': ('glassklar',),
'glassklare': ('glassklar',),
'glassklarere': ('glassklar',),
'glassklarest': ('glassklar',),
'glassklareste': ('glassklar',),
'glassklart': ('glassklar',),
'glatt': ('glatt',),
'glatte': ('glatt',),
'glattere': ('glatt',),
'glattest': ('glatt',),
'glatteste': ('glatt',),
'glattbarberende': ('glattbarbere',),
'glattbarbert': ('glattbarbere',),
'glattbarberte': ('glattbarbere',),
'glatta': ('glatte',),
'glattede': ('glatte',),
'glattende': ('glatte',),
'glattet': ('glatte',),
'glattete': ('glatte',),
'glatthåra': ('glatthåra',),
'glatthårede': ('glatthåret',),
'glatthåret': ('glatthåret',),
'glatthårete': ('glatthåret',),
'glatthåretere': ('glatthåret',),
'glatthåretest': ('glatthåret',),
'glatthåreteste': ('glatthåret',),
'glattkjemma': ('glattkjemme',),
'glattkjemmede': ('glattkjemme',),
'glattkjemmende': ('glattkjemme',),
'glattkjemmet': ('glattkjemme',),
'glattkjemmete': ('glattkjemme',),
'glattkjemt': ('glattkjemme',),
'glattkjemte': ('glattkjemme',),
'glattløpa': ('glattløpa',),
'glattløpede': ('glattløpet',),
'glattløpet': ('glattløpet',),
'glattløpete': ('glattløpet',),
'glattløpetere': ('glattløpet',),
'glattløpetest': ('glattløpet',),
'glattløpeteste': ('glattløpet',),
'glattstrykende': ('glattstryke',),
'glattstrøken': ('glattstryke',),
'glattstrøket': ('glattstryke',),
'glattstrøkne': ('glattstryke',),
'gledd': ('gle',),
'gledde': ('gle',),
'gleende': ('gle',),
'gledd': ('gle',),
'gledde': ('gle',),
'gleende': ('gle',),
'gleda': ('glede',),
'gledd': ('glede',),
'gledde': ('glede',),
'gledede': ('glede',),
'gledende': ('glede',),
'gledet': ('glede',),
'gledete': ('glede',),
'gleda': ('glede',),
'gledd': ('glede',),
'gledde': ('glede',),
'gledede': ('glede',),
'gledende': ('glede',),
'gledet': ('glede',),
'gledete': ('glede',),
'gledefylt': ('gledefylt',),
'gledefylte': ('gledefylt',),
'gledefyltere': ('gledefylt',),
'gledefyltest': ('gledefylt',),
'gledefylteste': ('gledefylt',),
'gledelaus': ('gledelaus',),
'gledelause': ('gledelaus',),
'gledelausere': ('gledelaus',),
'gledelausest': ('gledelaus',),
'gledelauseste': ('gledelaus',),
'gledelaust': ('gledelaus',),
'gledelig': ('gledelig',),
'gledelige': ('gledelig',),
'gledeligere': ('gledelig',),
'gledeligst': ('gledelig',),
'gledeligste': ('gledelig',),
'gledeløs': ('gledeløs',),
'gledeløse': ('gledeløs',),
'gledeløsere': ('gledeløs',),
'gledeløsest': ('gledeløs',),
'gledeløseste': ('gledeløs',),
'gledeløst': ('gledeløs',),
'glederik': ('glederik',),
'glederike': ('glederik',),
'glederikere': ('glederik',),
'glederikest': ('glederik',),
'glederikeste': ('glederik',),
'glederikt': ('glederik',),
'gledestrålende': ('gledestrålende',),
'glefsa': ('glefse',),
'glefsede': ('glefse',),
'glefsende': ('glefse',),
'glefset': ('glefse',),
'glefsete': ('glefse',),
'glefst': ('glefse',),
'glefste': ('glefse',),
'glemmende': ('glemme',),
'glemt': ('glemme',),
'glemte': ('glemme',),
'glemsk': ('glemsk',),
'glemske': ('glemsk',),
'glemskere': ('glemsk',),
'glemskest': ('glemsk',),
'glemskeste': ('glemsk',),
'glemsom': ('glemsom',),
'glemsomme': ('glemsom',),
'glemsommere': ('glemsom',),
'glemsomst': ('glemsom',),
'glemsomste': ('glemsom',),
'glemsomt': ('glemsom',),
'glepne': ('gleppe',),
'gleppen': ('gleppe',),
'gleppende': ('gleppe',),
'gleppet': ('gleppe',),
'glidd': ('gli',),
'glidde': ('gli',),
'gliende': ('gli',),
'glidd': ('gli',),
'glidde': ('gli',),
'gliende': ('gli',),
'glideflydd': ('glidefly',),
'glideflydde': ('glidefly',),
'glideflyende': ('glidefly',),
'glidefløyen': ('glidefly',),
'glidefløyet': ('glidefly',),
'glidefløyne': ('glidefly',),
'glideflydd': ('glideflyge',),
'glideflydde': ('glideflyge',),
'glideflygende': ('glideflyge',),
'glidefløyen': ('glideflyge',),
'glidefløyet': ('glideflyge',),
'glidefløyne': ('glideflyge',),
'glidende': ('glidende',),
'glimende': ('glime',),
'glimt': ('glime',),
'glimte': ('glime',),
'glimra': ('glimre',),
'glimrede': ('glimre',),
'glimrende': ('glimre',),
'glimret': ('glimre',),
'glimrete': ('glimre',),
'glimrende': ('glimrende',),
'glimta': ('glimte',),
'glimtede': ('glimte',),
'glimtende': ('glimte',),
'glimtet': ('glimte',),
'glimtete': ('glimte',),
'glinsa': ('glinse',),
'glinsede': ('glinse',),
'glinsende': ('glinse',),
'glinset': ('glinse',),
'glinsete': ('glinse',),
'glipende': ('glipe',),
'glipt': ('glipe',),
'glipte': ('glipe',),
'glirende': ('glire',),
'glirt': ('glire',),
'glirte': ('glire',),
'glisende': ('glise',),
'glist': ('glise',),
'gliste': ('glise',),
'glisen': ('glisen',),
'glisent': ('glisen',),
'glisne': ('glisen',),
'glisnere': ('glisen',),
'glisnest': ('glisen',),
'glisneste': ('glisen',),
'glisen': ('glisen',),
'glisent': ('glisen',),
'glisne': ('glisen',),
'glisnere': ('glisen',),
'glisnest': ('glisen',),
'glisneste': ('glisen',),
'glisne': ('glissen',),
'glisnere': ('glissen',),
'glisnest': ('glissen',),
'glisneste': ('glissen',),
'glissen': ('glissen',),
'glissent': ('glissen',),
'glisne': ('glissen',),
'glisnere': ('glissen',),
'glisnest': ('glissen',),
'glisneste': ('glissen',),
'glissen': ('glissen',),
'glissent': ('glissen',),
'glitra': ('glitre',),
'glitrede': ('glitre',),
'glitrende': ('glitre',),
'glitret': ('glitre',),
'glitrete': ('glitre',),
'glitrende': ('glitrende',),
'glitta': ('glitte',),
'glittede': ('glitte',),
'glittende': ('glitte',),
'glittet': ('glitte',),
'glittete': ('glitte',),
'glodd': ('glo',),
'glodde': ('glo',),
'gloende': ('glo',),
'global': ('global',),
'globale': ('global',),
'globalere': ('global',),
'globalest': ('global',),
'globaleste': ('global',),
'globalt': ('global',),
'gloende': ('gloende',),
'glohet': ('glohet',),
'glohete': ('glohet',),
'glohetere': ('glohet',),
'glohetest': ('glohet',),
'gloheteste': ('glohet',),
'glohett': ('glohet',),
'glora': ('glore',),
'glorede': ('glore',),
'glorende': ('glore',),
'gloret': ('glore',),
'glorete': ('glore',),
'glort': ('glore',),
'glorte': ('glore',),
'gloret': ('gloret',),
'glorete': ('gloret',),
'gloretere': ('gloret',),
'gloretest': ('gloret',),
'gloreteste': ('gloret',),
'glorete': ('glorete',),
'glorifiserende': ('glorifisere',),
'glorifisert': ('glorifisere',),
'glorifiserte': ('glorifisere',),
'gloriøs': ('gloriøs',),
'gloriøse': ('gloriøs',),
'gloriøsere': ('gloriøs',),
'gloriøsest': ('gloriøs',),
'gloriøseste': ('gloriøs',),
'gloriøst': ('gloriøs',),
'glorverdig': ('glorverdig',),
'glorverdige': ('glorverdig',),
'glorverdigere': ('glorverdig',),
'glorverdigst': ('glorverdig',),
'glorverdigste': ('glorverdig',),
'glorød': ('glorød',),
'glorøde': ('glorød',),
'glorødere': ('glorød',),
'glorødest': ('glorød',),
'glorødeste': ('glorød',),
'glorødt': ('glorød',),
'glottal': ('glottal',),
'glottale': ('glottal',),
'glottalere': ('glottal',),
'glottalest': ('glottal',),
'glottaleste': ('glottal',),
'glottalt': ('glottal',),
'glovarm': ('glovarm',),
'glovarme': ('glovarm',),
'glovarmere': ('glovarm',),
'glovarmest': ('glovarm',),
'glovarmeste': ('glovarm',),
'glovarmt': ('glovarm',),
'glup': ('glup',),
'glupe': ('glup',),
'glupere': ('glup',),
'glupest': ('glup',),
'glupeste': ('glup',),
'glupt': ('glup',),
'glupende': ('glupende',),
'glupsk': ('glupsk',),
'glupske': ('glupsk',),
'glupskere': ('glupsk',),
'glupskest': ('glupsk',),
'glupskeste': ('glupsk',),
'glutenholdig': ('glutenholdig',),
'glutenholdige': ('glutenholdig',),
'glutenholdigere': ('glutenholdig',),
'glutenholdigst': ('glutenholdig',),
'glutenholdigste': ('glutenholdig',),
'glødd': ('glø',),
'glødde': ('glø',),
'gløende': ('glø',),
'glødd': ('glø',),
'glødde': ('glø',),
'gløende': ('glø',),
'gløda': ('gløde',),
'glødd': ('gløde',),
'glødde': ('gløde',),
'glødede': ('gløde',),
'glødende': ('gløde',),
'glødet': ('gløde',),
'glødete': ('gløde',),
'gløda': ('gløde',),
'glødd': ('gløde',),
'glødde': ('gløde',),
'glødede': ('gløde',),
'glødende': ('gløde',),
'glødet': ('gløde',),
'glødete': ('gløde',),
'glødende': ('glødende',),
'gløgg': ('gløgg',),
'gløgge': ('gløgg',),
'gløggere': ('gløgg',),
'gløggest': ('gløgg',),
'gløggeste': ('gløgg',),
'gløgt': ('gløgg',),
'gløggtenkt': ('gløggtenkt',),
'gløggtenkte': ('gløggtenkt',),
'gløggtenktere': ('gløggtenkt',),
'gløggtenktest': ('gløggtenkt',),
'gløggtenkteste': ('gløggtenkt',),
'glømmende': ('glømme',),
'glømt': ('glømme',),
'glømte': ('glømme',),
'glømsk': ('glømsk',),
'glømske': ('glømsk',),
'glømskere': ('glømsk',),
'glømskest': ('glømsk',),
'glømskeste': ('glømsk',),
'glømsom': ('glømsom',),
'glømsomme': ('glømsom',),
'glømsommere': ('glømsom',),
'glømsomst': ('glømsom',),
'glømsomste': ('glømsom',),
'glømsomt': ('glømsom',),
'gløtta': ('gløtte',),
'gløttede': ('gløtte',),
'gløttende': ('gløtte',),
'gløttet': ('gløtte',),
'gløttete': ('gløtte',),
'gnafsa': ('gnafse',),
'gnafsede': ('gnafse',),
'gnafsende': ('gnafse',),
'gnafset': ('gnafse',),
'gnafsete': ('gnafse',),
'gnafst': ('gnafse',),
'gnafste': ('gnafse',),
'gnagd': ('gnage',),
'gnagde': ('gnage',),
'gnagede': ('gnage',),
'gnagende': ('gnage',),
'gnaget': ('gnage',),
'gnagete': ('gnage',),
'gnaldra': ('gnaldre',),
'gnaldrede': ('gnaldre',),
'gnaldrende': ('gnaldre',),
'gnaldret': ('gnaldre',),
'gnaldrete': ('gnaldre',),
'gneldra': ('gneldre',),
'gneldrede': ('gneldre',),
'gneldrende': ('gneldre',),
'gneldret': ('gneldre',),
'gneldrete': ('gneldre',),
'gnell': ('gnell',),
'gnelle': ('gnell',),
'gnellere': ('gnell',),
'gnellest': ('gnell',),
'gnelleste': ('gnell',),
'gnelt': ('gnell',),
'gnellende': ('gnelle',),
'gnelt': ('gnelle',),
'gnelte': ('gnelle',),
'gnidd': ('gni',),
'gnidde': ('gni',),
'gniende': ('gni',),
'gnidra': ('gnidre',),
'gnidrede': ('gnidre',),
'gnidrende': ('gnidre',),
'gnidret': ('gnidre',),
'gnidrete': ('gnidre',),
'gnidret': ('gnidret',),
'gnidrete': ('gnidret',),
'gnidretere': ('gnidret',),
'gnidretest': ('gnidret',),
'gnidreteste': ('gnidret',),
'gnidrete': ('gnidrete',),
'gnieraktig': ('gnieraktig',),
'gnieraktige': ('gnieraktig',),
'gnieraktigere': ('gnieraktig',),
'gnieraktigst': ('gnieraktig',),
'gnieraktigste': ('gnieraktig',),
'gnika': ('gnike',),
'gnikede': ('gnike',),
'gnikende': ('gnike',),
'gniket': ('gnike',),
'gnikete': ('gnike',),
'gnika': ('gnike',),
'gnikede': ('gnike',),
'gnikende': ('gnike',),
'gniket': ('gnike',),
'gnikete': ('gnike',),
'gniken': ('gniken',),
'gnikent': ('gniken',),
'gnikne': ('gniken',),
'gniknere': ('gniken',),
'gniknest': ('gniken',),
'gnikneste': ('gniken',),
'gnikka': ('gnikke',),
'gnikkede': ('gnikke',),
'gnikkende': ('gnikke',),
'gnikket': ('gnikke',),
'gnikkete': ('gnikke',),
'gnikka': ('gnikke',),
'gnikkede': ('gnikke',),
'gnikkende': ('gnikke',),
'gnikket': ('gnikke',),
'gnikkete': ('gnikke',),
'gniksa': ('gnikse',),
'gniksede': ('gnikse',),
'gniksende': ('gnikse',),
'gnikset': ('gnikse',),
'gniksete': ('gnikse',),
'gnirka': ('gnirke',),
'gnirkede': ('gnirke',),
'gnirkende': ('gnirke',),
'gnirket': ('gnirke',),
'gnirkete': ('gnirke',),
'gnisla': ('gnisle',),
'gnislede': ('gnisle',),
'gnislende': ('gnisle',),
'gnislet': ('gnisle',),
'gnislete': ('gnisle',),
'gnissa': ('gnisse',),
'gnissede': ('gnisse',),
'gnissende': ('gnisse',),
'gnisset': ('gnisse',),
'gnissete': ('gnisse',),
'gnista': ('gniste',),
'gnistede': ('gniste',),
'gnistende': ('gniste',),
'gnistet': ('gniste',),
'gnistete': ('gniste',),
'gnistra': ('gnistre',),
'gnistrede': ('gnistre',),
'gnistrende': ('gnistre',),
'gnistret': ('gnistre',),
'gnistrete': ('gnistre',),
'gnistrende': ('gnistrende',),
'gnomisk': ('gnomisk',),
'gnomiske': ('gnomisk',),
'gnomiskere': ('gnomisk',),
'gnomiskest': ('gnomisk',),
'gnomiskeste': ('gnomisk',),
'gnostisk': ('gnostisk',),
'gnostiske': ('gnostisk',),
'gnostiskere': ('gnostisk',),
'gnostiskest': ('gnostisk',),
'gnostiskeste': ('gnostisk',),
'gnudd': ('gnu',),
'gnudde': ('gnu',),
'gnuende': ('gnu',),
'gnubba': ('gnubbe',),
'gnubbede': ('gnubbe',),
'gnubbende': ('gnubbe',),
'gnubbet': ('gnubbe',),
'gnubbete': ('gnubbe',),
'gnugga': ('gnugge',),
'gnuggede': ('gnugge',),
'gnuggende': ('gnugge',),
'gnugget': ('gnugge',),
'gnuggete': ('gnugge',),
'gnukka': ('gnukke',),
'gnukkede': ('gnukke',),
'gnukkende': ('gnukke',),
'gnukket': ('gnukke',),
'gnukkete': ('gnukke',),
'gnura': ('gnure',),
'gnurede': ('gnure',),
'gnurende': ('gnure',),
'gnuret': ('gnure',),
'gnurete': ('gnure',),
'gnurt': ('gnure',),
'gnurte': ('gnure',),
'gnusla': ('gnusle',),
'gnuslede': ('gnusle',),
'gnuslende': ('gnusle',),
'gnuslet': ('gnusle',),
'gnuslete': ('gnusle',),
'gnussa': ('gnusse',),
'gnussede': ('gnusse',),
'gnussende': ('gnusse',),
'gnusset': ('gnusse',),
'gnussete': ('gnusse',),
'gnydd': ('gny',),
'gnydde': ('gny',),
'gnyende': ('gny',),
'gnålende': ('gnåle',),
'gnålt': ('gnåle',),
'gnålte': ('gnåle',),
'goanesisk': ('goanesisk',),
'goanesiske': ('goanesisk',),
'goanesiskere': ('goanesisk',),
'goanesiskest': ('goanesisk',),
'goanesiskeste': ('goanesisk',),
'bedre': ('god',),
'best': ('god',),
'beste': ('god',),
'god': ('god',),
'gode': ('god',),
'godt': ('god',),
'godarta': ('godarta',),
'godartede': ('godartet',),
'godartet': ('godartet',),
'godartete': ('godartet',),
'godartetere': ('godartet',),
'godartetest': ('godartet',),
'godarteteste': ('godartet',),
'godfjottet': ('godfjottet',),
'godfjottete': ('godfjottet',),
'godfjottetere': ('godfjottet',),
'godfjottetest': ('godfjottet',),
'godfjotteteste': ('godfjottet',),
'godfjottete': ('godfjottete',),
'godgjort': ('godgjøre',),
'godgjorte': ('godgjøre',),
'godgjørende': ('godgjøre',),
'godgjørende': ('godgjørende',),
'godhjerta': ('godhjerta',),
'godhjertede': ('godhjertet',),
'godhjertet': ('godhjertet',),
'godhjertete': ('godhjertet',),
'godhjertetere': ('godhjertet',),
'godhjertetest': ('godhjertet',),
'godhjerteteste': ('godhjertet',),
'godkjennende': ('godkjenne',),
'godkjent': ('godkjenne',),
'godkjente': ('godkjenne',),
'godkjent': ('godkjent',),
'godkjente': ('godkjent',),
'godkjentere': ('godkjent',),
'godkjentest': ('godkjent',),
'godkjenteste': ('godkjent',),
'godlynt': ('godlynt',),
'godlynte': ('godlynt',),
'godlyntere': ('godlynt',),
'godlyntest': ('godlynt',),
'godlynteste': ('godlynt',),
'godmodig': ('godmodig',),
'godmodige': ('godmodig',),
'godmodigere': ('godmodig',),
'godmodigst': ('godmodig',),
'godmodigste': ('godmodig',),
'godskreven': ('godskrive',),
'godskrevet': ('godskrive',),
'godskrevne': ('godskrive',),
'godskrivende': ('godskrive',),
'godslig': ('godslig',),
'godslige': ('godslig',),
'godsligere': ('godslig',),
'godsligst': ('godslig',),
'godsligste': ('godslig',),
'godsnakka': ('godsnakke',),
'godsnakkede': ('godsnakke',),
'godsnakkende': ('godsnakke',),
'godsnakket': ('godsnakke',),
'godsnakkete': ('godsnakke',),
'godtakende': ('godta',),
'godtatt': ('godta',),
'godtatte': ('godta',),
'godta': ('godte',),
'godtede': ('godte',),
'godtende': ('godte',),
'godtet': ('godte',),
'godtete': ('godte',),
'godtekkelig': ('godtekkelig',),
'godtekkelige': ('godtekkelig',),
'godtekkeligere': ('godtekkelig',),
'godtekkeligst': ('godtekkelig',),
'godtekkeligste': ('godtekkelig',),
'godtgjort': ('godtgjøre',),
'godtgjorte': ('godtgjøre',),
'godtgjørende': ('godtgjøre',),
'godtkjøps': ('godtkjøps',),
'godtroende': ('godtroende',),
'godtruen': ('godtruen',),
'godtruene': ('godtruen',),
'godtruenere': ('godtruen',),
'godtruenest': ('godtruen',),
'godtrueneste': ('godtruen',),
'godtruent': ('godtruen',),
'godtrune': ('godtruen',),
'godtrunere': ('godtruen',),
'godtrunest': ('godtruen',),
'godtruneste': ('godtruen',),
'godtruende': ('godtruende',),
'godvillig': ('godvillig',),
'godvillige': ('godvillig',),
'godvilligere': ('godvillig',),
'godvilligst': ('godvillig',),
'godvilligste': ('godvillig',),
'gold': ('gold',),
'golde': ('gold',),
'goldere': ('gold',),
'goldest': ('gold',),
'goldeste': ('gold',),
'goldt': ('gold',),
'gomla': ('gomle',),
'gomlede': ('gomle',),
'gomlende': ('gomle',),
'gomlet': ('gomle',),
'gomlete': ('gomle',),
'gordisk': ('gordisk',),
'gordiske': ('gordisk',),
'gordiskere': ('gordisk',),
'gordiskest': ('gordisk',),
'gordiskeste': ('gordisk',),
'gotisk': ('gotisk',),
'gotiske': ('gotisk',),
'gotiskere': ('gotisk',),
'gotiskest': ('gotisk',),
'gotiskeste': ('gotisk',),
'gotlandsk': ('gotlandsk',),
'gotlandske': ('gotlandsk',),
'gotlandskere': ('gotlandsk',),
'gotlandskest': ('gotlandsk',),
'gotlandskeste': ('gotlandsk',),
'gova': ('gove',),
'govede': ('gove',),
'govende': ('gove',),
'govet': ('gove',),
'govete': ('gove',),
'gra': ('gra',),
'grae': ('gra',),
'graere': ('gra',),
'graest': ('gra',),
'graeste': ('gra',),
'grabba': ('grabbe',),
'grabbede': ('grabbe',),
'grabbende': ('grabbe',),
'grabbet': ('grabbe',),
'grabbete': ('grabbe',),
'gradbøya': ('gradbøye',),
'gradbøyd': ('gradbøye',),
'gradbøyde': ('gradbøye',),
'gradbøyede': ('gradbøye',),
'gradbøyende': ('gradbøye',),
'gradbøyet': ('gradbøye',),
'gradbøyete': ('gradbøye',),
'grada': ('grade',),
'gradede': ('grade',),
'gradende': ('grade',),
'gradet': ('grade',),
'gradete': ('grade',),
'graderende': ('gradere',),
'gradert': ('gradere',),
'graderte': ('gradere',),
'gradual': ('gradual',),
'graduale': ('gradual',),
'gradualere': ('gradual',),
'gradualest': ('gradual',),
'gradualeste': ('gradual',),
'gradualt': ('gradual',),
'graduell': ('graduell',),
'graduelle': ('graduell',),
'graduellere': ('graduell',),
'graduellest': ('graduell',),
'graduelleste': ('graduell',),
'graduelt': ('graduell',),
'graduerende': ('graduere',),
'graduert': ('graduere',),
'graduerte': ('graduere',),
'grafisk': ('grafisk',),
'grafiske': ('grafisk',),
'grafiskere': ('grafisk',),
'grafiskest': ('grafisk',),
'grafiskeste': ('grafisk',),
'grafologisk': ('grafologisk',),
'grafologiske': ('grafologisk',),
'grafologiskere': ('grafologisk',),
'grafologiskest': ('grafologisk',),
'grafologiskeste': ('grafologisk',),
'grafsa': ('grafse',),
'grafsede': ('grafse',),
'grafsende': ('grafse',),
'grafset': ('grafse',),
'grafsete': ('grafse',),
'grafsen': ('grafsen',),
'grafsent': ('grafsen',),
'grafsne': ('grafsen',),
'grafsnere': ('grafsen',),
'grafsnest': ('grafsen',),
'grafsneste': ('grafsen',),
'gram': ('gram',),
'gramme': ('gram',),
'grammere': ('gram',),
'grammest': ('gram',),
'grammeste': ('gram',),
'gramt': ('gram',),
'grammatikalsk': ('grammatikalsk',),
'grammatikalske': ('grammatikalsk',),
'grammatikalskere': ('grammatikalsk',),
'grammatikalskest': ('grammatikalsk',),
'grammatikalskeste': ('grammatikalsk',),
'grammatisk': ('grammatisk',),
'grammatiske': ('grammatisk',),
'grammatiskere': ('grammatisk',),
'grammatiskest': ('grammatisk',),
'grammatiskeste': ('grammatisk',),
'gramnegativ': ('gramnegativ',),
'gramnegative': ('gramnegativ',),
'gramnegativere': ('gramnegativ',),
'gramnegativest': ('gramnegativ',),
'gramnegativeste': ('gramnegativ',),
'gramnegativt': ('gramnegativ',),
'grampositiv': ('grampositiv',),
'grampositive': ('grampositiv',),
'grampositivere': ('grampositiv',),
'grampositivest': ('grampositiv',),
'grampositiveste': ('grampositiv',),
'grampositivt': ('grampositiv',),
'gramsa': ('gramse',),
'gramsede': ('gramse',),
'gramsende': ('gramse',),
'gramset': ('gramse',),
'gramsete': ('gramse',),
'grand': ('grand',),
'grandios': ('grandios',),
'grandiose': ('grandios',),
'grandiosere': ('grandios',),
'grandiosest': ('grandios',),
'grandioseste': ('grandios',),
'grandiost': ('grandios',),
'granittisk': ('granittisk',),
'granittiske': ('granittisk',),
'granittiskere': ('granittisk',),
'granittiskest': ('granittisk',),
'granittiskeste': ('granittisk',),
'grann': ('grann',),
'granne': ('grann',),
'grannere': ('grann',),
'grannest': ('grann',),
'granneste': ('grann',),
'grant': ('grann',),
'grannmælt': ('grannmælt',),
'grannmælte': ('grannmælt',),
'grannmæltere': ('grannmælt',),
'grannmæltest': ('grannmælt',),
'grannmælteste': ('grannmælt',),
'grannvokst': ('grannvokst',),
'grannvokste': ('grannvokst',),
'grannvokstere': ('grannvokst',),
'grannvokstest': ('grannvokst',),
'grannvoksteste': ('grannvokst',),
'granska': ('granske',),
'granskede': ('granske',),
'granskende': ('granske',),
'gransket': ('granske',),
'granskete': ('granske',),
'granulerende': ('granulere',),
'granulert': ('granulere',),
'granulerte': ('granulere',),
'grasa': ('grase',),
'grasede': ('grase',),
'grasende': ('grase',),
'graset': ('grase',),
'grasete': ('grase',),
'grasgrodd': ('grasgrodd',),
'grasgrodde': ('grasgrodd',),
'grasgroddere': ('grasgrodd',),
'grasgroddest': ('grasgrodd',),
'grasgroddeste': ('grasgrodd',),
'grasil': ('grasil',),
'grasile': ('grasil',),
'grasilere': ('grasil',),
'grasilest': ('grasil',),
'grasileste': ('grasil',),
'grasilt': ('grasil',),
'grasiøs': ('grasiøs',),
'grasiøse': ('grasiøs',),
'grasiøsere': ('grasiøs',),
'grasiøsest': ('grasiøs',),
'grasiøseste': ('grasiøs',),
'grasiøst': ('grasiøs',),
'graskledd': ('graskledd',),
'graskledde': ('graskledd',),
'graskleddere': ('graskledd',),
'graskleddest': ('graskledd',),
'graskleddeste': ('graskledd',),
'grasserende': ('grassere',),
'grassert': ('grassere',),
'grasserte': ('grassere',),
'gratinerende': ('gratinere',),
'gratinert': ('gratinere',),
'gratinerte': ('gratinere',),
'gratis': ('gratis',),
'gratulerende': ('gratulere',),
'gratulert': ('gratulere',),
'gratulerte': ('gratulere',),
'grautaktig': ('grautaktig',),
'grautaktige': ('grautaktig',),
'grautaktigere': ('grautaktig',),
'grautaktigst': ('grautaktig',),
'grautaktigste': ('grautaktig',),
'grauten': ('grauten',),
'grautent': ('grauten',),
'grautne': ('grauten',),
'grautnere': ('grauten',),
'grautnest': ('grauten',),
'grautneste': ('grauten',),
'grautet': ('grautet',),
'grautete': ('grautet',),
'grautetere': ('grautet',),
'grautetest': ('grautet',),
'grauteteste': ('grautet',),
'grautete': ('grautete',),
'gravalvorlig': ('gravalvorlig',),
'gravalvorlige': ('gravalvorlig',),
'gravalvorligere': ('gravalvorlig',),
'gravalvorligst': ('gravalvorlig',),
'gravalvorligste': ('gravalvorlig',),
'grava': ('grave',),
'gravd': ('grave',),
'gravde': ('grave',),
'gravede': ('grave',),
'gravende': ('grave',),
'gravet': ('grave',),
'gravete': ('grave',),
'gravd': ('grave',),
'gravde': ('grave',),
'gravende': ('grave',),
'graverende': ('gravere',),
'gravert': ('gravere',),
'graverte': ('gravere',),
'graverende': ('graverende',),
'gravid': ('gravid',),
'gravide': ('gravid',),
'gravidere': ('gravid',),
'gravidest': ('gravid',),
'gravideste': ('gravid',),
'graviterende': ('gravitere',),
'gravitert': ('gravitere',),
'graviterte': ('gravitere',),
'gravitetisk': ('gravitetisk',),
'gravitetiske': ('gravitetisk',),
'gravitetiskere': ('gravitetisk',),
'gravitetiskest': ('gravitetisk',),
'gravitetiskeste': ('gravitetisk',),
'gravlagt': ('gravlegge',),
'gravlagte': ('gravlegge',),
'gravleggende': ('gravlegge',),
'gredd': ('gre',),
'gredde': ('gre',),
'greende': ('gre',),
'gregoriansk': ('gregoriansk',),
'gregorianske': ('gregoriansk',),
'gregorianskere': ('gregoriansk',),
'gregorianskest': ('gregoriansk',),
'gregorianskeste': ('gregoriansk',),
'grei': ('grei',),
'greie': ('grei',),
'greiere': ('grei',),
'greiest': ('grei',),
'greieste': ('grei',),
'greit': ('grei',),
'greitt': ('grei',),
'greid': ('greie',),
'greidd': ('greie',),
'greidde': ('greie',),
'greide': ('greie',),
'greiende': ('greie',),
'greid': ('greie',),
'greidd': ('greie',),
'greidde': ('greie',),
'greide': ('greie',),
'greiende': ('greie',),
'greina': ('greine',),
'greinede': ('greine',),
'greinende': ('greine',),
'greinet': ('greine',),
'greinete': ('greine',),
'greint': ('greine',),
'greinte': ('greine',),
'greinet': ('greinet',),
'greinete': ('greinet',),
'greinetere': ('greinet',),
'greinetest': ('greinet',),
'greineteste': ('greinet',),
'greinete': ('greinete',),
'grell': ('grell',),
'grelle': ('grell',),
'grellere': ('grell',),
'grellest': ('grell',),
'grelleste': ('grell',),
'grelt': ('grell',),
'gremma': ('gremme',),
'gremmede': ('gremme',),
'gremmende': ('gremme',),
'gremmet': ('gremme',),
'gremmete': ('gremme',),
'gremt': ('gremme',),
'gremte': ('gremme',),
'grenadisk': ('grenadisk',),
'grenadiske': ('grenadisk',),
'grenadiskere': ('grenadisk',),
'grenadiskest': ('grenadisk',),
'grenadiskeste': ('grenadisk',),
'grena': ('grene',),
'grenede': ('grene',),
'grenende': ('grene',),
'grenet': ('grene',),
'grenete': ('grene',),
'grent': ('grene',),
'grente': ('grene',),
'grenet': ('grenet',),
'grenete': ('grenet',),
'grenetere': ('grenet',),
'grenetest': ('grenet',),
'greneteste': ('grenet',),
'grenete': ('grenete',),
'grensa': ('grense',),
'grensede': ('grense',),
'grensende': ('grense',),
'grenset': ('grense',),
'grensete': ('grense',),
'grenselaus': ('grenselaus',),
'grenselause': ('grenselaus',),
'grenselausere': ('grenselaus',),
'grenselausest': ('grenselaus',),
'grenselauseste': ('grenselaus',),
'grenselaust': ('grenselaus',),
'grenseløs': ('grenseløs',),
'grenseløse': ('grenseløs',),
'grenseløsere': ('grenseløs',),
'grenseløsest': ('grenseløs',),
'grenseløseste': ('grenseløs',),
'grenseløst': ('grenseløs',),
'grepa': ('grepa',),
'grepen': ('grepen',),
'grepet': ('grepen',),
'grepne': ('grepen',),
'grepnere': ('grepen',),
'grepnest': ('grepen',),
'grepneste': ('grepen',),
'grepet': ('grepet',),
'grepne': ('grepet',),
'grepnere': ('grepet',),
'grepnest': ('grepet',),
'grepneste': ('grepet',),
'gresk': ('gresk',),
'greske': ('gresk',),
'greskere': ('gresk',),
'greskest': ('gresk',),
'greskeste': ('gresk',),
'gresk-katolsk': ('gresk-katolsk',),
'gresk-katolske': ('gresk-katolsk',),
'gresk-katolskere': ('gresk-katolsk',),
'gresk-katolskest': ('gresk-katolsk',),
'gresk-katolskeste': ('gresk-katolsk',),
'gresk-ortodoks': ('gresk-ortodoks',),
'gresk-ortodokse': ('gresk-ortodoks',),
'gresk-ortodoksere': ('gresk-ortodoks',),
'gresk-ortodoksest': ('gresk-ortodoks',),
'gresk-ortodokseste': ('gresk-ortodoks',),
'gresk-ortodokst': ('gresk-ortodoks',),
'gresk-romersk': ('gresk-romersk',),
'gresk-romerske': ('gresk-romersk',),
'gresk-romerskere': ('gresk-romersk',),
'gresk-romerskest': ('gresk-romersk',),
'gresk-romerskeste': ('gresk-romersk',),
'gressa': ('gresse',),
'gressede': ('gresse',),
'gressende': ('gresse',),
'gresset': ('gresse',),
'gressete': ('gresse',),
'gresselig': ('gresselig',),
'gresselige': ('gresselig',),
'gresseligere': ('gresselig',),
'gresseligst': ('gresselig',),
'gresseligste': ('gresselig',),
'gressgrodd': ('gressgrodd',),
'gressgrodde': ('gressgrodd',),
'gressgroddere': ('gressgrodd',),
'gressgroddest': ('gressgrodd',),
'gressgroddeste': ('gressgrodd',),
'gresskledd': ('gresskledd',),
'gresskledde': ('gresskledd',),
'gresskleddere': ('gresskledd',),
'gresskleddest': ('gresskledd',),
'gresskleddeste': ('gresskledd',),
'gretne': ('gretten',),
'gretnere': ('gretten',),
'gretnest': ('gretten',),
'gretneste': ('gretten',),
'gretten': ('gretten',),
'grettent': ('gretten',),
'grevelig': ('grevelig',),
'grevelige': ('grevelig',),
'greveligere': ('grevelig',),
'greveligst': ('grevelig',),
'greveligste': ('grevelig',),
'griljerende': ('griljere',),
'griljert': ('griljere',),
'griljerte': ('griljere',),
'grilla': ('grille',),
'grillede': ('grille',),
'grillende': ('grille',),
'grillet': ('grille',),
'grillete': ('grille',),
'grillsteikt': ('grillsteikt',),
'grillsteikte': ('grillsteikt',),
'grillsteiktere': ('grillsteikt',),
'grillsteiktest': ('grillsteikt',),
'grillsteikteste': ('grillsteikt',),
'grillstekt': ('grillstekt',),
'grillstekte': ('grillstekt',),
'grillstektere': ('grillstekt',),
'grillstektest': ('grillstekt',),
'grillstekteste': ('grillstekt',),
'grim': ('grim',),
'grimme': ('grim',),
'grimmere': ('grim',),
'grimmest': ('grim',),
'grimmeste': ('grim',),
'grimt': ('grim',),
'grima': ('grime',),
'grimede': ('grime',),
'grimende': ('grime',),
'grimet': ('grime',),
'grimete': ('grime',),
'grimet': ('grimet',),
'grimete': ('grimet',),
'grimetere': ('grimet',),
'grimetest': ('grimet',),
'grimeteste': ('grimet',),
'grimete': ('grimete',),
'grinaktig': ('grinaktig',),
'grinaktige': ('grinaktig',),
'grinaktigere': ('grinaktig',),
'grinaktigst': ('grinaktig',),
'grinaktigste': ('grinaktig',),
'grinende': ('grine',),
'grint': ('grine',),
'grinte': ('grine',),
'grinet': ('grinet',),
'grinete': ('grinet',),
'grinetere': ('grinet',),
'grinetest': ('grinet',),
'grineteste': ('grinet',),
'grinete': ('grinete',),
'grepen': ('gripe',),
'grepet': ('gripe',),
'grepne': ('gripe',),
'gripende': ('gripe',),
'gripende': ('gripende',),
'grisa': ('grise',),
'grisede': ('grise',),
'grisende': ('grise',),
'griset': ('grise',),
'grisete': ('grise',),
'grist': ('grise',),
'griste': ('grise',),
'griset': ('griset',),
'grisete': ('griset',),
'grisetere': ('griset',),
'grisetest': ('griset',),
'griseteste': ('griset',),
'grisete': ('grisete',),
'grisgrendt': ('grisgrendt',),
'grisgrendte': ('grisgrendt',),
'grisgrendtere': ('grisgrendt',),
'grisgrendtest': ('grisgrendt',),
'grisgrendteste': ('grisgrendt',),
'grisk': ('grisk',),
'griske': ('grisk',),
'griskere': ('grisk',),
'griskest': ('grisk',),
'griskeste': ('grisk',),
'griskt': ('grisk',),
'grisla': ('grisle',),
'grislede': ('grisle',),
'grislende': ('grisle',),
'grislet': ('grisle',),
'grislete': ('grisle',),
'grisna': ('grisne',),
'grisnede': ('grisne',),
'grisnende': ('grisne',),
'grisnet': ('grisne',),
'grisnete': ('grisne',),
'grisne': ('grissen',),
'grisnere': ('grissen',),
'grisnest': ('grissen',),
'grisneste': ('grissen',),
'grissen': ('grissen',),
'grissent': ('grissen',),
'grissgrendt': ('grissgrendt',),
'grissgrendte': ('grissgrendt',),
'grissgrendtere': ('grissgrendt',),
'grissgrendtest': ('grissgrendt',),
'grissgrendteste': ('grissgrendt',),
'grisøyd': ('grisøyd',),
'grisøyde': ('grisøyd',),
'grisøydere': ('grisøyd',),
'grisøydest': ('grisøyd',),
'grisøydeste': ('grisøyd',),
'grodd': ('gro',),
'grodde': ('gro',),
'groende': ('gro',),
'groggy': ('groggy',),
'grom': ('grom',),
'gromme': ('grom',),
'grommere': ('grom',),
'grommest': ('grom',),
'grommeste': ('grom',),
'gromt': ('grom',),
'gropa': ('grope',),
'gropede': ('grope',),
'gropende': ('grope',),
'gropet': ('grope',),
'gropete': ('grope',),
'grotesk': ('grotesk',),
'groteske': ('grotesk',),
'groteskere': ('grotesk',),
'groteskest': ('grotesk',),
'groteskeste': ('grotesk',),
'grov': ('grov',),
'grove': ('grov',),
'grovere': ('grov',),
'grovest': ('grov',),
'groveste': ('grov',),
'grovt': ('grov',),
'grøvst': ('grov',),
'grøvste': ('grov',),
'grovbarka': ('grovbarka',),
'grovbarkede': ('grovbarket',),
'grovbarket': ('grovbarket',),
'grovbarkete': ('grovbarket',),
'grovbarketere': ('grovbarket',),
'grovbarketest': ('grovbarket',),
'grovbarketeste': ('grovbarket',),
'grovbygd': ('grovbygd',),
'grovbygde': ('grovbygd',),
'grovbygdere': ('grovbygd',),
'grovbygdest': ('grovbygd',),
'grovbygdeste': ('grovbygd',),
'grovdimensjonert': ('grovdimensjonert',),
'grovdimensjonerte': ('grovdimensjonert',),
'grovdimensjonertere': ('grovdimensjonert',),
'grovdimensjonertest': ('grovdimensjonert',),
'grovdimensjonerteste': ('grovdimensjonert',),
'grovhakka': ('grovhakke',),
'grovhakkede': ('grovhakke',),
'grovhakkende': ('grovhakke',),
'grovhakket': ('grovhakke',),
'grovhakkete': ('grovhakke',),
'grovkorna': ('grovkorna',),
'grovkornede': ('grovkornet',),
'grovkornet': ('grovkornet',),
'grovkornete': ('grovkornet',),
'grovkornetere': ('grovkornet',),
'grovkornetest': ('grovkornet',),
'grovkorneteste': ('grovkornet',),
'grovmalende': ('grovmale',),
'grovmalt': ('grovmale',),
'grovmalte': ('grovmale',),
'grovmælt': ('grovmælt',),
'grovmælte': ('grovmælt',),
'grovmæltere': ('grovmælt',),
'grovmæltest': ('grovmælt',),
'grovmælteste': ('grovmælt',),
'grovsikta': ('grovsikte',),
'grovsiktede': ('grovsikte',),
'grovsiktende': ('grovsikte',),
'grovsiktet': ('grovsikte',),
'grovsiktete': ('grovsikte',),
'grovskåret': ('grovskåret',),
'grovskårne': ('grovskåret',),
'grovskårnere': ('grovskåret',),
'grovskårnest': ('grovskåret',),
'grovskårneste': ('grovskåret',),
'grovsorterende': ('grovsortere',),
'grovsortert': ('grovsortere',),
'grovsorterte': ('grovsortere',),
'grovtalt': ('grovtelle',),
'grovtalte': ('grovtelle',),
'grovtella': ('grovtelle',),
'grovtellede': ('grovtelle',),
'grovtellende': ('grovtelle',),
'grovtellet': ('grovtelle',),
'grovtellete': ('grovtelle',),
'grovtelt': ('grovtelle',),
'grovtelte': ('grovtelle',),
'grubla': ('gruble',),
'grublede': ('gruble',),
'grublende': ('gruble',),
'grublet': ('gruble',),
'grublete': ('gruble',),
'grua': ('grue',),
'grudd': ('grue',),
'grudde': ('grue',),
'gruede': ('grue',),
'gruende': ('grue',),
'gruet': ('grue',),
'gruete': ('grue',),
'gruelig': ('gruelig',),
'gruelige': ('gruelig',),
'grueligere': ('gruelig',),
'grueligst': ('gruelig',),
'grueligste': ('gruelig',),
'grufull': ('grufull',),
'grufulle': ('grufull',),
'grufullere': ('grufull',),
'grufullest': ('grufull',),
'grufulleste': ('grufull',),
'grufullt': ('grufull',),
'gruggen': ('gruggen',),
'gruggent': ('gruggen',),
'grugne': ('gruggen',),
'grugnere': ('gruggen',),
'grugnest': ('gruggen',),
'grugneste': ('gruggen',),
'grugget': ('grugget',),
'gruggete': ('grugget',),
'gruggetere': ('grugget',),
'gruggetest': ('grugget',),
'gruggeteste': ('grugget',),
'gruggete': ('gruggete',),
'grum': ('grum',),
'grumme': ('grum',),
'grummere': ('grum',),
'grummest': ('grum',),
'grummeste': ('grum',),
'grumt': ('grum',),
'grumsa': ('grumse',),
'grumsede': ('grumse',),
'grumsende': ('grumse',),
'grumset': ('grumse',),
'grumsete': ('grumse',),
'grumset': ('grumset',),
'grumsete': ('grumset',),
'grumsetere': ('grumset',),
'grumsetest': ('grumset',),
'grumseteste': ('grumset',),
'grumsete': ('grumsete',),
'grunderende': ('grundere',),
'grundert': ('grundere',),
'grunderte': ('grundere',),
'grundig': ('grundig',),
'grundige': ('grundig',),
'grundigere': ('grundig',),
'grundigst': ('grundig',),
'grundigste': ('grundig',),
'grundtvigiansk': ('grundtvigiansk',),
'grundtvigianske': ('grundtvigiansk',),
'grundtvigianskere': ('grundtvigiansk',),
'grundtvigianskest': ('grundtvigiansk',),
'grundtvigianskeste': ('grundtvigiansk',),
'grunn': ('grunn',),
'grunne': ('grunn',),
'grunnere': ('grunn',),
'grunnest': ('grunn',),
'grunneste': ('grunn',),
'grunt': ('grunn',),
'grunna': ('grunne',),
'grunnede': ('grunne',),
'grunnende': ('grunne',),
'grunnet': ('grunne',),
'grunnete': ('grunne',),
'grunna': ('grunne',),
'grunnede': ('grunne',),
'grunnende': ('grunne',),
'grunnet': ('grunne',),
'grunnete': ('grunne',),
'grunna': ('grunne',),
'grunnede': ('grunne',),
'grunnende': ('grunne',),
'grunnet': ('grunne',),
'grunnete': ('grunne',),
'grunnfalsk': ('grunnfalsk',),
'grunnfalske': ('grunnfalsk',),
'grunnfalskere': ('grunnfalsk',),
'grunnfalskest': ('grunnfalsk',),
'grunnfalskeste': ('grunnfalsk',),
'grunnfalskt': ('grunnfalsk',),
'grunnfast': ('grunnfast',),
'grunnfaste': ('grunnfast',),
'grunnfastere': ('grunnfast',),
'grunnfastest': ('grunnfast',),
'grunnfasteste': ('grunnfast',),
'grunnfesta': ('grunnfesta',),
'grunnfesta': ('grunnfeste',),
'grunnfestede': ('grunnfeste',),
'grunnfestende': ('grunnfeste',),
'grunnfestet': ('grunnfeste',),
'grunnfestete': ('grunnfeste',),
'grunnfestede': ('grunnfestet',),
'grunnfestet': ('grunnfestet',),
'grunnfestete': ('grunnfestet',),
'grunnfestetere': ('grunnfestet',),
'grunnfestetest': ('grunnfestet',),
'grunnfesteteste': ('grunnfestet',),
'grunngiende': ('grunngi',),
'grunngitt': ('grunngi',),
'grunngitte': ('grunngi',),
'grunngivende': ('grunngi',),
'grunnlaus': ('grunnlaus',),
'grunnlause': ('grunnlaus',),
'grunnlausere': ('grunnlaus',),
'grunnlausest': ('grunnlaus',),
'grunnlauseste': ('grunnlaus',),
'grunnlaust': ('grunnlaus',),
'grunnlagt': ('grunnlegge',),
'grunnlagte': ('grunnlegge',),
'grunnleggende': ('grunnlegge',),
'grunnleggende': ('grunnleggende',),
'grunnlovfesta': ('grunnlovfesta',),
'grunnlovfestede': ('grunnlovfestet',),
'grunnlovfestet': ('grunnlovfestet',),
'grunnlovfestete': ('grunnlovfestet',),
'grunnlovfestetere': ('grunnlovfestet',),
'grunnlovfestetest': ('grunnlovfestet',),
'grunnlovfesteteste': ('grunnlovfestet',),
'grunnlovgivende': ('grunnlovgivende',),
'grunnlovlig': ('grunnlovlig',),
'grunnlovlige': ('grunnlovlig',),
'grunnlovligere': ('grunnlovlig',),
'grunnlovligst': ('grunnlovlig',),
'grunnlovligste': ('grunnlovlig',),
'grunnlovsstridig': ('grunnlovsstridig',),
'grunnlovsstridige': ('grunnlovsstridig',),
'grunnlovsstridigere': ('grunnlovsstridig',),
'grunnlovsstridigst': ('grunnlovsstridig',),
'grunnlovsstridigste': ('grunnlovsstridig',),
'grunnløs': ('grunnløs',),
'grunnløse': ('grunnløs',),
'grunnløsere': ('grunnløs',),
'grunnløsest': ('grunnløs',),
'grunnløseste': ('grunnløs',),
'grunnløst': ('grunnløs',),
'grunnrik': ('grunnrik',),
'grunnrike': ('grunnrik',),
'grunnrikere': ('grunnrik',),
'grunnrikest': ('grunnrik',),
'grunnrikeste': ('grunnrik',),
'grunnrikt': ('grunnrik',),
'grunnsatt': ('grunnsette',),
'grunnsatte': ('grunnsette',),
'grunnsettende': ('grunnsette',),
'grunnsolid': ('grunnsolid',),
'grunnsolide': ('grunnsolid',),
'grunnsolidere': ('grunnsolid',),
'grunnsolidest': ('grunnsolid',),
'grunnsolideste': ('grunnsolid',),
'grunnstøtende': ('grunnstøte',),
'grunnstøtt': ('grunnstøte',),
'grunnstøtte': ('grunnstøte',),
'gruntgående': ('gruntgående',),
'grupperende': ('gruppere',),
'gruppert': ('gruppere',),
'grupperte': ('gruppere',),
'grusa': ('gruse',),
'grusede': ('gruse',),
'grusende': ('gruse',),
'gruset': ('gruse',),
'grusete': ('gruse',),
'gruselig': ('gruselig',),
'gruselige': ('gruselig',),
'gruseligere': ('gruselig',),
'gruseligst': ('gruselig',),
'gruseligste': ('gruselig',),
'gruset': ('gruset',),
'grusete': ('gruset',),
'grusetere': ('gruset',),
'grusetest': ('gruset',),
'gruseteste': ('gruset',),
'grusete': ('grusete',),
'grusisk': ('grusisk',),
'grusiske': ('grusisk',),
'grusiskere': ('grusisk',),
'grusiskest': ('grusisk',),
'grusiskeste': ('grusisk',),
'gruslagt': ('gruslegge',),
'gruslagte': ('gruslegge',),
'grusleggende': ('gruslegge',),
'grusom': ('grusom',),
'grusomme': ('grusom',),
'grusommere': ('grusom',),
'grusomst': ('grusom',),
'grusomste': ('grusom',),
'grusomt': ('grusom',),
'grydd': ('gry',),
'grydde': ('gry',),
'gryende': ('gry',),
'grynende': ('gryne',),
'grynt': ('gryne',),
'grynte': ('gryne',),
'grynet': ('grynet',),
'grynete': ('grynet',),
'grynetere': ('grynet',),
'grynetest': ('grynet',),
'gryneteste': ('grynet',),
'grynete': ('grynete',),
'grynta': ('grynte',),
'gryntede': ('grynte',),
'gryntende': ('grynte',),
'gryntet': ('grynte',),
'gryntete': ('grynte',),
'gryteferdig': ('gryteferdig',),
'gryteferdige': ('gryteferdig',),
'gryteferdigere': ('gryteferdig',),
'gryteferdigst': ('gryteferdig',),
'gryteferdigste': ('gryteferdig',),
'grytidlig': ('grytidlig',),
'grytidlige': ('grytidlig',),
'grytidligere': ('grytidlig',),
'grytidligst': ('grytidlig',),
'grytidligste': ('grytidlig',),
'grå': ('grå',),
'gråe': ('grå',),
'gråere': ('grå',),
'gråest': ('grå',),
'gråeste': ('grå',),
'grått': ('grå',),
'gråaktig': ('gråaktig',),
'gråaktige': ('gråaktig',),
'gråaktigere': ('gråaktig',),
'gråaktigst': ('gråaktig',),
'gråaktigste': ('gråaktig',),
'grådig': ('grådig',),
'grådige': ('grådig',),
'grådigere': ('grådig',),
'grådigst': ('grådig',),
'grådigste': ('grådig',),
'gråhåra': ('gråhåra',),
'gråhårede': ('gråhåret',),
'gråhåret': ('gråhåret',),
'gråhårete': ('gråhåret',),
'gråhåretere': ('gråhåret',),
'gråhåretest': ('gråhåret',),
'gråhåreteste': ('gråhåret',),
'gråkald': ('gråkald',),
'gråkalde': ('gråkald',),
'gråkaldere': ('gråkald',),
'gråkaldest': ('gråkald',),
'gråkaldeste': ('gråkald',),
'gråkaldt': ('gråkald',),
'grålende': ('gråle',),
'grålt': ('gråle',),
'grålte': ('gråle',),
'grålig': ('grålig',),
'grålige': ('grålig',),
'gråligere': ('grålig',),
'gråligst': ('grålig',),
'gråligste': ('grålig',),
'gråna': ('gråne',),
'grånede': ('gråne',),
'grånende': ('gråne',),
'grånet': ('gråne',),
'grånete': ('gråne',),
'gråskitne': ('gråskitten',),
'gråskitnere': ('gråskitten',),
'gråskitnest': ('gråskitten',),
'gråskitneste': ('gråskitten',),
'gråskitten': ('gråskitten',),
'gråskittent': ('gråskitten',),
'gråtblanda': ('gråtblanda',),
'gråtblandede': ('gråtblandet',),
'gråtblandet': ('gråtblandet',),
'gråtblandete': ('gråtblandet',),
'gråtblandetere': ('gråtblandet',),
'gråtblandetest': ('gråtblandet',),
'gråtblandeteste': ('gråtblandet',),
'gråtende': ('gråte',),
'grått': ('gråte',),
'gråtte': ('gråte',),
'gråteferdig': ('gråteferdig',),
'gråteferdige': ('gråteferdig',),
'gråteferdigere': ('gråteferdig',),
'gråteferdigst': ('gråteferdig',),
'gråteferdigste': ('gråteferdig',),
'gråtkvalt': ('gråtkvalt',),
'gråtkvalte': ('gråtkvalt',),
'gråtkvaltere': ('gråtkvalt',),
'gråtkvaltest': ('gråtkvalt',),
'gråtkvalteste': ('gråtkvalt',),
'gråøyd': ('gråøyd',),
'gråøyde': ('gråøyd',),
'gråøydere': ('gråøyd',),
'gråøydest': ('gråøyd',),
'gråøydeste': ('gråøyd',),
'grødd': ('grø',),
'grødde': ('grø',),
'grøende': ('grø',),
'grødd': ('grø',),
'grødde': ('grø',),
'grøende': ('grø',),
'grødd': ('grøde',),
'grødde': ('grøde',),
'grødende': ('grøde',),
'grødd': ('grøde',),
'grødde': ('grøde',),
'grødende': ('grøde',),
'grødefull': ('grødefull',),
'grødefulle': ('grødefull',),
'grødefullere': ('grødefull',),
'grødefullest': ('grødefull',),
'grødefulleste': ('grødefull',),
'grødefullt': ('grødefull',),
'grøderik': ('grøderik',),
'grøderike': ('grøderik',),
'grøderikere': ('grøderik',),
'grøderikest': ('grøderik',),
'grøderikeste': ('grøderik',),
'grøderikt': ('grøderik',),
'grøfta': ('grøfte',),
'grøftede': ('grøfte',),
'grøftende': ('grøfte',),
'grøftet': ('grøfte',),
'grøftete': ('grøfte',),
'grøn': ('grøn',),
'grøne': ('grøn',),
'grønere': ('grøn',),
'grønest': ('grøn',),
'grøneste': ('grøn',),
'grønt': ('grøn',),
'grøn': ('grøn',),
'grøne': ('grøn',),
'grønere': ('grøn',),
'grønest': ('grøn',),
'grøneste': ('grøn',),
'grønt': ('grøn',),
'grønaktig': ('grønaktig',),
'grønaktige': ('grønaktig',),
'grønaktigere': ('grønaktig',),
'grønaktigst': ('grønaktig',),
'grønaktigste': ('grønaktig',),
'grønaktig': ('grønaktig',),
'grønaktige': ('grønaktig',),
'grønaktigere': ('grønaktig',),
'grønaktigst': ('grønaktig',),
'grønaktigste': ('grønaktig',),
'grønka': ('grønke',),
'grønkede': ('grønke',),
'grønkende': ('grønke',),
'grønket': ('grønke',),
'grønkete': ('grønke',),
'grønlandsk': ('grønlandsk',),
'grønlandske': ('grønlandsk',),
'grønlandskere': ('grønlandsk',),
'grønlandskest': ('grønlandsk',),
'grønlandskeste': ('grønlandsk',),
'grønlig': ('grønlig',),
'grønlige': ('grønlig',),
'grønligere': ('grønlig',),
'grønligst': ('grønlig',),
'grønligste': ('grønlig',),
'grønlig': ('grønlig',),
'grønlige': ('grønlig',),
'grønligere': ('grønlig',),
'grønligst': ('grønlig',),
'grønligste': ('grønlig',),
'grønn': ('grønn',),
'grønne': ('grønn',),
'grønnere': ('grønn',),
'grønnest': ('grønn',),
'grønneste': ('grønn',),
'grønt': ('grønn',),
'grønn': ('grønn',),
'grønne': ('grønn',),
'grønnere': ('grønn',),
'grønnest': ('grønn',),
'grønneste': ('grønn',),
'grønt': ('grønn',),
'grønnaktig': ('grønnaktig',),
'grønnaktige': ('grønnaktig',),
'grønnaktigere': ('grønnaktig',),
'grønnaktigst': ('grønnaktig',),
'grønnaktigste': ('grønnaktig',),
'grønnaktig': ('grønnaktig',),
'grønnaktige': ('grønnaktig',),
'grønnaktigere': ('grønnaktig',),
'grønnaktigst': ('grønnaktig',),
'grønnaktigste': ('grønnaktig',),
'grønnlig': ('grønnlig',),
'grønnlige': ('grønnlig',),
'grønnligere': ('grønnlig',),
'grønnligst': ('grønnlig',),
'grønnligste': ('grønnlig',),
'grønnlig': ('grønnlig',),
'grønnlige': ('grønnlig',),
'grønnligere': ('grønnlig',),
'grønnligst': ('grønnlig',),
'grønnligste': ('grønnlig',),
'grønska': ('grønske',),
'grønskede': ('grønske',),
'grønskende': ('grønske',),
'grønsket': ('grønske',),
'grønskete': ('grønske',),
'grønsket': ('grønsket',),
'grønskete': ('grønsket',),
'grønsketere': ('grønsket',),
'grønsketest': ('grønsket',),
'grønsketeste': ('grønsket',),
'grønskete': ('grønskete',),
'grøppa': ('grøppe',),
'grøppede': ('grøppe',),
'grøppende': ('grøppe',),
'grøppet': ('grøppe',),
'grøppete': ('grøppe',),
'grøpt': ('grøppe',),
'grøpte': ('grøppe',),
'grøssa': ('grøsse',),
'grøssede': ('grøsse',),
'grøssende': ('grøsse',),
'grøsset': ('grøsse',),
'grøssete': ('grøsse',),
'grøst': ('grøsse',),
'grøste': ('grøsse',),
'grøtaktig': ('grøtaktig',),
'grøtaktige': ('grøtaktig',),
'grøtaktigere': ('grøtaktig',),
'grøtaktigst': ('grøtaktig',),
'grøtaktigste': ('grøtaktig',),
'grøtet': ('grøtet',),
'grøtete': ('grøtet',),
'grøtetere': ('grøtet',),
'grøtetest': ('grøtet',),
'grøteteste': ('grøtet',),
'grøtete': ('grøtete',),
'guatemalansk': ('guatemalansk',),
'guatemalanske': ('guatemalansk',),
'guatemalanskere': ('guatemalansk',),
'guatemalanskest': ('guatemalansk',),
'guatemalanskeste': ('guatemalansk',),
'gudbenåda': ('gudbenåda',),
'gudbenådede': ('gudbenådet',),
'gudbenådet': ('gudbenådet',),
'gudbenådete': ('gudbenådet',),
'gudbenådetere': ('gudbenådet',),
'gudbenådetest': ('gudbenådet',),
'gudbenådeteste': ('gudbenådet',),
'gudbrandsdalsk': ('gudbrandsdalsk',),
'gudbrandsdalske': ('gudbrandsdalsk',),
'gudbrandsdalskere': ('gudbrandsdalsk',),
'gudbrandsdalskest': ('gudbrandsdalsk',),
'gudbrandsdalskeste': ('gudbrandsdalsk',),
'guddommelig': ('guddommelig',),
'guddommelige': ('guddommelig',),
'guddommeligere': ('guddommelig',),
'guddommeligst': ('guddommelig',),
'guddommeligste': ('guddommelig',),
'gudelig': ('gudelig',),
'gudelige': ('gudelig',),
'gudeligere': ('gudelig',),
'gudeligst': ('gudelig',),
'gudeligste': ('gudelig',),
'gudfryktig': ('gudfryktig',),
'gudfryktige': ('gudfryktig',),
'gudfryktigere': ('gudfryktig',),
'gudfryktigst': ('gudfryktig',),
'gudfryktigste': ('gudfryktig',),
'gudgitt': ('gudgitt',),
'gudgitte': ('gudgitt',),
'gudgittere': ('gudgitt',),
'gudgittest': ('gudgitt',),
'gudgitteste': ('gudgitt',),
'gudhengiven': ('gudhengiven',),
'gudhengivent': ('gudhengiven',),
'gudhengivne': ('gudhengiven',),
'gudhengivnere': ('gudhengiven',),
'gudhengivnest': ('gudhengiven',),
'gudhengivneste': ('gudhengiven',),
'gudlaus': ('gudlaus',),
'gudlause': ('gudlaus',),
'gudlausere': ('gudlaus',),
'gudlausest': ('gudlaus',),
'gudlauseste': ('gudlaus',),
'gudlaust': ('gudlaus',),
'gudløs': ('gudløs',),
'gudløse': ('gudløs',),
'gudløsere': ('gudløs',),
'gudløsest': ('gudløs',),
'gudløseste': ('gudløs',),
'gudløst': ('gudløs',),
'gudnådslig': ('gudnådslig',),
'gudnådslige': ('gudnådslig',),
'gudnådsligere': ('gudnådslig',),
'gudnådsligst': ('gudnådslig',),
'gudnådsligste': ('gudnådslig',),
'gudsbespottelig': ('gudsbespottelig',),
'gudsbespottelige': ('gudsbespottelig',),
'gudsbespotteligere': ('gudsbespottelig',),
'gudsbespotteligst': ('gudsbespottelig',),
'gudsbespotteligste': ('gudsbespottelig',),
'gudsendt': ('gudsendt',),
'gudsendte': ('gudsendt',),
'gudsendtere': ('gudsendt',),
'gudsendtest': ('gudsendt',),
'gudsendteste': ('gudsendt',),
'gudsens': ('gudsens',),
'gudsforlatt': ('gudsforlatt',),
'gudsforlatte': ('gudsforlatt',),
'gudsforlattere': ('gudsforlatt',),
'gudsforlattest': ('gudsforlatt',),
'gudsforlatteste': ('gudsforlatt',),
'gudsjammerlig': ('gudsjammerlig',),
'gudsjammerlige': ('gudsjammerlig',),
'gudsjammerligere': ('gudsjammerlig',),
'gudsjammerligst': ('gudsjammerlig',),
'gudsjammerligste': ('gudsjammerlig',),
'gudskapt': ('gudskapt',),
'gudskapte': ('gudskapt',),
'gudskaptere': ('gudskapt',),
'gudskaptest': ('gudskapt',),
'gudskapteste': ('gudskapt',),
'gudstjenstlig': ('gudstjenstlig',),
'gudstjenstlige': ('gudstjenstlig',),
'gudstjenstligere': ('gudstjenstlig',),
'gudstjenstligst': ('gudstjenstlig',),
'gudstjenstligste': ('gudstjenstlig',),
'guffen': ('guffen',),
'guffent': ('guffen',),
'gufne': ('guffen',),
'gufnere': ('guffen',),
'gufnest': ('guffen',),
'gufneste': ('guffen',),
'gufsa': ('gufse',),
'gufsede': ('gufse',),
'gufsende': ('gufse',),
'gufset': ('gufse',),
'gufsete': ('gufse',),
'guida': ('guide',),
'guidede': ('guide',),
'guidende': ('guide',),
'guidet': ('guide',),
'guidete': ('guide',),
'guineansk': ('guineansk',),
'guineanske': ('guineansk',),
'guineanskere': ('guineansk',),
'guineanskest': ('guineansk',),
'guineanskeste': ('guineansk',),
'gul': ('gul',),
'gule': ('gul',),
'gulere': ('gul',),
'gulest': ('gul',),
'guleste': ('gul',),
'gult': ('gul',),
'gulblakk': ('gulblakk',),
'gulblakke': ('gulblakk',),
'gulblakkere': ('gulblakk',),
'gulblakkest': ('gulblakk',),
'gulblakkeste': ('gulblakk',),
'gulblakt': ('gulblakk',),
'gula': ('gule',),
'gulede': ('gule',),
'gulende': ('gule',),
'gulet': ('gule',),
'gulete': ('gule',),
'gulka': ('gulke',),
'gulkede': ('gulke',),
'gulkende': ('gulke',),
'gulket': ('gulke',),
'gulkete': ('gulke',),
'gullblank': ('gullblank',),
'gullblanke': ('gullblank',),
'gullblankere': ('gullblank',),
'gullblankest': ('gullblank',),
'gullblankeste': ('gullblank',),
'gullblankt': ('gullblank',),
'gullkanta': ('gullkanta',),
'gullkantede': ('gullkantet',),
'gullkantet': ('gullkantet',),
'gullkantete': ('gullkantet',),
'gullkantetere': ('gullkantet',),
'gullkantetest': ('gullkantet',),
'gullkanteteste': ('gullkantet',),
'gullslått': ('gullslått',),
'gullslåtte': ('gullslått',),
'gullslåttere': ('gullslått',),
'gullslåttest': ('gullslått',),
'gullslåtteste': ('gullslått',),
'gulmoden': ('gulmoden',),
'gulmodent': ('gulmoden',),
'gulmodne': ('gulmoden',),
'gulmodnere': ('gulmoden',),
'gulmodnest': ('gulmoden',),
'gulmodneste': ('gulmoden',),
'gulna': ('gulne',),
'gulnede': ('gulne',),
'gulnende': ('gulne',),
'gulnet': ('gulne',),
'gulnete': ('gulne',),
'gulpa': ('gulpe',),
'gulpede': ('gulpe',),
'gulpende': ('gulpe',),
'gulpet': ('gulpe',),
'gulpete': ('gulpe',),
'gulrotfarga': ('gulrotfarga',),
'gulrotfargede': ('gulrotfarget',),
'gulrotfarget': ('gulrotfarget',),
'gulrotfargete': ('gulrotfarget',),
'gulrotfargetere': ('gulrotfarget',),
'gulrotfargetest': ('gulrotfarget',),
'gulrotfargeteste': ('gulrotfarget',),
'gummierende': ('gummiere',),
'gummiert': ('gummiere',),
'gummierte': ('gummiere',),
'gunstig': ('gunstig',),
'gunstige': ('gunstig',),
'gunstigere': ('gunstig',),
'gunstigst': ('gunstig',),
'gunstigste': ('gunstig',),
'gurgla': ('gurgle',),
'gurglede': ('gurgle',),
'gurglende': ('gurgle',),
'gurglet': ('gurgle',),
'gurglete': ('gurgle',),
'gurpa': ('gurpe',),
'gurpede': ('gurpe',),
'gurpende': ('gurpe',),
'gurpet': ('gurpe',),
'gurpete': ('gurpe',),
'gursegrøn': ('gursegrøn',),
'gursegrøne': ('gursegrøn',),
'gursegrønere': ('gursegrøn',),
'gursegrønest': ('gursegrøn',),
'gursegrøneste': ('gursegrøn',),
'gursegrønt': ('gursegrøn',),
'gursegrønn': ('gursegrønn',),
'gursegrønne': ('gursegrønn',),
'gursegrønnere': ('gursegrønn',),
'gursegrønnest': ('gursegrønn',),
'gursegrønneste': ('gursegrønn',),
'gursegrønt': ('gursegrønn',),
'gursegul': ('gursegul',),
'gursegule': ('gursegul',),
'gursegulere': ('gursegul',),
'gursegulest': ('gursegul',),
'gurseguleste': ('gursegul',),
'gursegult': ('gursegul',),
'gusta': ('guste',),
'gustede': ('guste',),
'gustende': ('guste',),
'gustet': ('guste',),
'gustete': ('guste',),
'gusten': ('gusten',),
'gustent': ('gusten',),
'gustne': ('gusten',),
'gustnere': ('gusten',),
'gustnest': ('gusten',),
'gustneste': ('gusten',),
'guterende': ('gutere',),
'gutert': ('gutere',),
'guterte': ('gutere',),
'guttaktig': ('guttaktig',),
'guttaktige': ('guttaktig',),
'guttaktigere': ('guttaktig',),
'guttaktigst': ('guttaktig',),
'guttaktigste': ('guttaktig',),
'gutteaktig': ('gutteaktig',),
'gutteaktige': ('gutteaktig',),
'gutteaktigere': ('gutteaktig',),
'gutteaktigst': ('gutteaktig',),
'gutteaktigste': ('gutteaktig',),
'guttegal': ('guttegal',),
'guttegale': ('guttegal',),
'guttegalere': ('guttegal',),
'guttegalest': ('guttegal',),
'guttegaleste': ('guttegal',),
'guttegalt': ('guttegal',),
'guttural': ('guttural',),
'gutturale': ('guttural',),
'gutturalere': ('guttural',),
'gutturalest': ('guttural',),
'gutturaleste': ('guttural',),
'gutturalt': ('guttural',),
'guyansk': ('guyansk',),
'guyanske': ('guyansk',),
'guyanskere': ('guyansk',),
'guyanskest': ('guyansk',),
'guyanskeste': ('guyansk',),
'gyldig': ('gyldig',),
'gyldige': ('gyldig',),
'gyldigere': ('gyldig',),
'gyldigst': ('gyldig',),
'gyldigste': ('gyldig',),
'gylla': ('gylle',),
'gyllede': ('gylle',),
'gyllende': ('gylle',),
'gyllet': ('gylle',),
'gyllete': ('gylle',),
'gylt': ('gylle',),
'gylte': ('gylle',),
'gyllen': ('gyllen',),
'gyllent': ('gyllen',),
'gylne': ('gyllen',),
'gylnere': ('gyllen',),
'gylnest': ('gyllen',),
'gylneste': ('gyllen',),
'gyllenblank': ('gyllenblank',),
'gyllenblanke': ('gyllenblank',),
'gyllenblankere': ('gyllenblank',),
'gyllenblankest': ('gyllenblank',),
'gyllenblankeste': ('gyllenblank',),
'gyllenblankt': ('gyllenblank',),
'gyllenbrun': ('gyllenbrun',),
'gyllenbrune': ('gyllenbrun',),
'gyllenbrunere': ('gyllenbrun',),
'gyllenbrunest': ('gyllenbrun',),
'gyllenbruneste': ('gyllenbrun',),
'gyllenbrunt': ('gyllenbrun',),
'gymnasial': ('gymnasial',),
'gymnasiale': ('gymnasial',),
'gymnasialere': ('gymnasial',),
'gymnasialest': ('gymnasial',),
'gymnasialeste': ('gymnasial',),
'gymnasialt': ('gymnasial',),
'gymnastiserende': ('gymnastisere',),
'gymnastisert': ('gymnastisere',),
'gymnastiserte': ('gymnastisere',),
'gymnastisk': ('gymnastisk',),
'gymnastiske': ('gymnastisk',),
'gymnastiskere': ('gymnastisk',),
'gymnastiskest': ('gymnastisk',),
'gymnastiskeste': ('gymnastisk',),
'gynekologisk': ('gynekologisk',),
'gynekologiske': ('gynekologisk',),
'gynekologiskere': ('gynekologisk',),
'gynekologiskest': ('gynekologisk',),
'gynekologiskeste': ('gynekologisk',),
'gynga': ('gynge',),
'gyngede': ('gynge',),
'gyngende': ('gynge',),
'gynget': ('gynge',),
'gyngete': ('gynge',),
'gysende': ('gyse',),
'gyss': ('gyse',),
'gysse': ('gyse',),
'gyst': ('gyse',),
'gyste': ('gyse',),
'gyselig': ('gyselig',),
'gyselige': ('gyselig',),
'gyseligere': ('gyselig',),
'gyseligst': ('gyselig',),
'gyseligste': ('gyselig',),
'gytende': ('gyte',),
'gytt': ('gyte',),
'gytte': ('gyte',),
'gyteferdig': ('gyteferdig',),
'gyteferdige': ('gyteferdig',),
'gyteferdigere': ('gyteferdig',),
'gyteferdigst': ('gyteferdig',),
'gyteferdigste': ('gyteferdig',),
'gjøven': ('gyve',),
'gjøvet': ('gyve',),
'gjøvne': ('gyve',),
'gyvd': ('gyve',),
'gyvde': ('gyve',),
'gyvende': ('gyve',),
'gående': ('gå',),
'gått': ('gå',),
'gåtte': ('gå',),
'gåen': ('gåen',),
'gåent': ('gåen',),
'gået': ('gåen',),
'gåne': ('gåen',),
'gånere': ('gåen',),
'gånest': ('gåen',),
'gåneste': ('gåen',),
'gående': ('gående',),
'gåra': ('gåre',),
'gårede': ('gåre',),
'gårende': ('gåre',),
'gåret': ('gåre',),
'gårete': ('gåre',),
'gåtefull': ('gåtefull',),
'gåtefulle': ('gåtefull',),
'gåtefullere': ('gåtefull',),
'gåtefullest': ('gåtefull',),
'gåtefulleste': ('gåtefull',),
'gåtefullt': ('gåtefull',),
'gælisk': ('gælisk',),
'gæliske': ('gælisk',),
'gæliskere': ('gælisk',),
'gæliskest': ('gælisk',),
'gæliskeste': ('gælisk',),
'gørr': ('gørr',),
'gørre': ('gørr',),
'gørrere': ('gørr',),
'gørrest': ('gørr',),
'gørreste': ('gørr',),
'gørrkjedelig': ('gørrkjedelig',),
'gørrkjedelige': ('gørrkjedelig',),
'gørrkjedeligere': ('gørrkjedelig',),
'gørrkjedeligst': ('gørrkjedelig',),
'gørrkjedeligste': ('gørrkjedelig',),
'gørrlei': ('gørrlei',),
'gørrleie': ('gørrlei',),
'gørrleiere': ('gørrlei',),
'gørrleiest': ('gørrlei',),
'gørrleieste': ('gørrlei',),
'gørrleit': ('gørrlei',),
'gøy': ('gøy',),
'gøye': ('gøy',),
'gøyere': ('gøy',),
'gøyest': ('gøy',),
'gøyeste': ('gøy',),
'gøyal': ('gøyal',),
'gøyale': ('gøyal',),
'gøyalere': ('gøyal',),
'gøyalest': ('gøyal',),
'gøyaleste': ('gøyal',),
'gøyalt': ('gøyal',),
'gøysende': ('gøyse',),
'gøyst': ('gøyse',),
'gøyste': ('gøyse',),
'haende': ('ha',),
'ha-stemt': ('ha-stemt',),
'ha-stemte': ('ha-stemt',),
'ha-stemtere': ('ha-stemt',),
'ha-stemtest': ('ha-stemt',),
'ha-stemteste': ('ha-stemt',),
'habil': ('habil',),
'habile': ('habil',),
'habilere': ('habil',),
'habilest': ('habil',),
'habileste': ('habil',),
'habilt': ('habil',),
'habiliterende': ('habilitere',),
'habilitert': ('habilitere',),
'habiliterte': ('habilitere',),
'habituell': ('habituell',),
'habituelle': ('habituell',),
'habituellere': ('habituell',),
'habituellest': ('habituell',),
'habituelleste': ('habituell',),
'habituelt': ('habituell',),
'habsburgisk': ('habsburgisk',),
'habsburgiske': ('habsburgisk',),
'habsburgiskere': ('habsburgisk',),
'habsburgiskest': ('habsburgisk',),
'habsburgiskeste': ('habsburgisk',),
'habsburgsk': ('habsburgsk',),
'habsburgske': ('habsburgsk',),
'habsburgskere': ('habsburgsk',),
'habsburgskest': ('habsburgsk',),
'habsburgskeste': ('habsburgsk',),
'hag': ('hag',),
'hage': ('hag',),
'hagere': ('hag',),
'hagest': ('hag',),
'hageste': ('hag',),
'hagt': ('hag',),
'haglblanda': ('haglblanda',),
'haglblandede': ('haglblandet',),
'haglblandet': ('haglblandet',),
'haglblandete': ('haglblandet',),
'haglblandetere': ('haglblandet',),
'haglblandetest': ('haglblandet',),
'haglblandeteste': ('haglblandet',),
'hagla': ('hagle',),
'haglede': ('hagle',),
'haglende': ('hagle',),
'haglet': ('hagle',),
'haglete': ('hagle',),
'haika': ('haike',),
'haikede': ('haike',),
'haikende': ('haike',),
'haiket': ('haike',),
'haikete': ('haike',),
'haitiansk': ('haitiansk',),
'haitianske': ('haitiansk',),
'haitianskere': ('haitiansk',),
'haitianskest': ('haitiansk',),
'haitianskeste': ('haitiansk',),
'haitisk': ('haitisk',),
'haitiske': ('haitisk',),
'haitiskere': ('haitisk',),
'haitiskest': ('haitisk',),
'haitiskeste': ('haitisk',),
'haka': ('hake',),
'hakede': ('hake',),
'hakende': ('hake',),
'haket': ('hake',),
'hakete': ('hake',),
'hakt': ('hake',),
'hakte': ('hake',),
'hakka': ('hakke',),
'hakkede': ('hakke',),
'hakkende': ('hakke',),
'hakket': ('hakke',),
'hakkete': ('hakke',),
'hakket': ('hakket',),
'hakkete': ('hakket',),
'hakketere': ('hakket',),
'hakketest': ('hakket',),
'hakketeste': ('hakket',),
'hakkete': ('hakkete',),
'hala': ('hale',),
'halede': ('hale',),
'halende': ('hale',),
'halet': ('hale',),
'halete': ('hale',),
'halt': ('hale',),
'halte': ('hale',),
'halelaus': ('halelaus',),
'halelause': ('halelaus',),
'halelausere': ('halelaus',),
'halelausest': ('halelaus',),
'halelauseste': ('halelaus',),
'halelaust': ('halelaus',),
'haleløs': ('haleløs',),
'haleløse': ('haleløs',),
'haleløsere': ('haleløs',),
'haleløsest': ('haleløs',),
'haleløseste': ('haleløs',),
'haleløst': ('haleløs',),
'hall': ('hall',),
'halle': ('hall',),
'hallere': ('hall',),
'hallest': ('hall',),
'halleste': ('hall',),
'halt': ('hall',),
'halla': ('halle',),
'hallede': ('halle',),
'hallende': ('halle',),
'hallet': ('halle',),
'hallete': ('halle',),
'hallusinatorisk': ('hallusinatorisk',),
'hallusinatoriske': ('hallusinatorisk',),
'hallusinatoriskere': ('hallusinatorisk',),
'hallusinatoriskest': ('hallusinatorisk',),
'hallusinatoriskeste': ('hallusinatorisk',),
'hallusinerende': ('hallusinere',),
'hallusinert': ('hallusinere',),
'hallusinerte': ('hallusinere',),
'hallusinogen': ('hallusinogen',),
'hallusinogene': ('hallusinogen',),
'hallusinogenere': ('hallusinogen',),
'hallusinogenest': ('hallusinogen',),
'hallusinogeneste': ('hallusinogen',),
'hallusinogent': ('hallusinogen',),
'halofil': ('halofil',),
'halofile': ('halofil',),
'halofilere': ('halofil',),
'halofilest': ('halofil',),
'halofileste': ('halofil',),
'halofilt': ('halofil',),
'halsbrekkende': ('halsbrekkende',),
'halsa': ('halse',),
'halsede': ('halse',),
'halsende': ('halse',),
'halset': ('halse',),
'halsete': ('halse',),
'halslaus': ('halslaus',),
'halslause': ('halslaus',),
'halslausere': ('halslaus',),
'halslausest': ('halslaus',),
'halslauseste': ('halslaus',),
'halslaust': ('halslaus',),
'halsløs': ('halsløs',),
'halsløse': ('halsløs',),
'halsløsere': ('halsløs',),
'halsløsest': ('halsløs',),
'halsløseste': ('halsløs',),
'halsløst': ('halsløs',),
'halsstarrig': ('halsstarrig',),
'halsstarrige': ('halsstarrig',),
'halsstarrigere': ('halsstarrig',),
'halsstarrigst': ('halsstarrig',),
'halsstarrigste': ('halsstarrig',),
'halt': ('halt',),
'halte': ('halt',),
'haltere': ('halt',),
'haltest': ('halt',),
'halteste': ('halt',),
'halta': ('halte',),
'haltede': ('halte',),
'haltende': ('halte',),
'haltet': ('halte',),
'haltete': ('halte',),
'halv': ('halv',),
'halve': ('halv',),
'halvere': ('halv',),
'halvest': ('halv',),
'halveste': ('halv',),
'halvt': ('halv',),
'halvautomatisk': ('halvautomatisk',),
'halvautomatiske': ('halvautomatisk',),
'halvautomatiskere': ('halvautomatisk',),
'halvautomatiskest': ('halvautomatisk',),
'halvautomatiskeste': ('halvautomatisk',),
'halvblind': ('halvblind',),
'halvblinde': ('halvblind',),
'halvblindere': ('halvblind',),
'halvblindest': ('halvblind',),
'halvblindeste': ('halvblind',),
'halvblindt': ('halvblind',),
'halvblods': ('halvblods',),
'halvdaud': ('halvdaud',),
'halvdaude': ('halvdaud',),
'halvdaudere': ('halvdaud',),
'halvdaudest': ('halvdaud',),
'halvdaudeste': ('halvdaud',),
'halvdaudt': ('halvdaud',),
'halvdokumentarisk': ('halvdokumentarisk',),
'halvdokumentariske': ('halvdokumentarisk',),
'halvdokumentariskere': ('halvdokumentarisk',),
'halvdokumentariskest': ('halvdokumentarisk',),
'halvdokumentariskeste': ('halvdokumentarisk',),
'halvdød': ('halvdød',),
'halvdøde': ('halvdød',),
'halvdødere': ('halvdød',),
'halvdødest': ('halvdød',),
'halvdødeste': ('halvdød',),
'halvdødt': ('halvdød',),
'halva': ('halve',),
'halvede': ('halve',),
'halvende': ('halve',),
'halvet': ('halve',),
'halvete': ('halve',),
'halverende': ('halvere',),
'halvert': ('halvere',),
'halverte': ('halvere',),
'halvferdig': ('halvferdig',),
'halvferdige': ('halvferdig',),
'halvferdigere': ('halvferdig',),
'halvferdigst': ('halvferdig',),
'halvferdigste': ('halvferdig',),
'halvfet': ('halvfet',),
'halvfete': ('halvfet',),
'halvfetere': ('halvfet',),
'halvfetest': ('halvfet',),
'halvfeteste': ('halvfet',),
'halvfett': ('halvfet',),
'halvfordøya': ('halvfordøya',),
'halvfordøyd': ('halvfordøyd',),
'halvfordøyde': ('halvfordøyd',),
'halvfordøydere': ('halvfordøyd',),
'halvfordøydest': ('halvfordøyd',),
'halvfordøydeste': ('halvfordøyd',),
'halvfordøyede': ('halvfordøyet',),
'halvfordøyet': ('halvfordøyet',),
'halvfordøyete': ('halvfordøyet',),
'halvfordøyetere': ('halvfordøyet',),
'halvfordøyetest': ('halvfordøyet',),
'halvfordøyeteste': ('halvfordøyet',),
'halvfull': ('halvfull',),
'halvfulle': ('halvfull',),
'halvfullere': ('halvfull',),
'halvfullest': ('halvfull',),
'halvfulleste': ('halvfull',),
'halvfullt': ('halvfull',),
'halvgal': ('halvgal',),
'halvgale': ('halvgal',),
'halvgalere': ('halvgal',),
'halvgalest': ('halvgal',),
'halvgaleste': ('halvgal',),
'halvgalt': ('halvgal',),
'halveldre': ('halvgammel',),
'halveldst': ('halvgammel',),
'halveldste': ('halvgammel',),
'halvgamle': ('halvgammel',),
'halvgammel': ('halvgammel',),
'halvgammelt': ('halvgammel',),
'halvgarderende': ('halvgardere',),
'halvgardert': ('halvgardere',),
'halvgarderte': ('halvgardere',),
'halvgjort': ('halvgjort',),
'halvgjorte': ('halvgjort',),
'halvgjortere': ('halvgjort',),
'halvgjortest': ('halvgjort',),
'halvgjorteste': ('halvgjort',),
'halvbedre': ('halvgod',),
'halvbest': ('halvgod',),
'halvbeste': ('halvgod',),
'halvgod': ('halvgod',),
'halvgode': ('halvgod',),
'halvgodt': ('halvgod',),
'halvgått': ('halvgått',),
'halvgåtte': ('halvgått',),
'halvgåttere': ('halvgått',),
'halvgåttest': ('halvgått',),
'halvgåtteste': ('halvgått',),
'halvhjerta': ('halvhjerta',),
'halvhjertede': ('halvhjertet',),
'halvhjertet': ('halvhjertet',),
'halvhjertete': ('halvhjertet',),
'halvhjertetere': ('halvhjertet',),
'halvhjertetest': ('halvhjertet',),
'halvhjerteteste': ('halvhjertet',),
'halvhøg': ('halvhøg',),
'halvhøge': ('halvhøg',),
'halvhøgere': ('halvhøg',),
'halvhøgest': ('halvhøg',),
'halvhøgeste': ('halvhøg',),
'halvhøgre': ('halvhøg',),
'halvhøgst': ('halvhøg',),
'halvhøgste': ('halvhøg',),
'halvhøgt': ('halvhøg',),
'halvhøy': ('halvhøy',),
'halvhøye': ('halvhøy',),
'halvhøyere': ('halvhøy',),
'halvhøyest': ('halvhøy',),
'halvhøyeste': ('halvhøy',),
'halvhøyt': ('halvhøy',),
'halvklarende': ('halvklare',),
'halvklart': ('halvklare',),
'halvklarte': ('halvklare',),
'halvkvedede': ('halvkvedet',),
'halvkvedet': ('halvkvedet',),
'halvkvedete': ('halvkvedet',),
'halvkvedetere': ('halvkvedet',),
'halvkvedetest': ('halvkvedet',),
'halvkvedeteste': ('halvkvedet',),
'halvmett': ('halvmett',),
'halvmette': ('halvmett',),
'halvmettere': ('halvmett',),
'halvmettest': ('halvmett',),
'halvmetteste': ('halvmett',),
'halvmoden': ('halvmoden',),
'halvmodent': ('halvmoden',),
'halvmodne': ('halvmoden',),
'halvmodnere': ('halvmoden',),
'halvmodnest': ('halvmoden',),
'halvmodneste': ('halvmoden',),
'halvnaken': ('halvnaken',),
'halvnakent': ('halvnaken',),
'halvnakne': ('halvnaken',),
'halvnaknere': ('halvnaken',),
'halvnaknest': ('halvnaken',),
'halvnakneste': ('halvnaken',),
'halvsoven': ('halvsove',),
'halvsovende': ('halvsove',),
'halvsovet': ('halvsove',),
'halvsovne': ('halvsove',),
'halvstudert': ('halvstudert',),
'halvstuderte': ('halvstudert',),
'halvstudertere': ('halvstudert',),
'halvstudertest': ('halvstudert',),
'halvstuderteste': ('halvstudert',),
'halvsåla': ('halvsåle',),
'halvsålede': ('halvsåle',),
'halvsålende': ('halvsåle',),
'halvsålet': ('halvsåle',),
'halvsålete': ('halvsåle',),
'halvsålt': ('halvsåle',),
'halvsålte': ('halvsåle',),
'halvtoms': ('halvtoms',),
'halvtredje': ('halvtredje',),
'halvtullet': ('halvtullet',),
'halvtullete': ('halvtullet',),
'halvtulletere': ('halvtullet',),
'halvtulletest': ('halvtullet',),
'halvtulleteste': ('halvtullet',),
'halvtullete': ('halvtullete',),
'halvtårs': ('halvtårs',),
'halvtørr': ('halvtørr',),
'halvtørre': ('halvtørr',),
'halvtørrere': ('halvtørr',),
'halvtørrest': ('halvtørr',),
'halvtørreste': ('halvtørr',),
'halvtørt': ('halvtørr',),
'halvvoksen': ('halvvoksen',),
'halvvoksent': ('halvvoksen',),
'halvvoksne': ('halvvoksen',),
'halvvoksnere': ('halvvoksen',),
'halvvoksnest': ('halvvoksen',),
'halvvoksneste': ('halvvoksen',),
'halvårig': ('halvårig',),
'halvårige': ('halvårig',),
'halvårigere': ('halvårig',),
'halvårigst': ('halvårig',),
'halvårigste': ('halvårig',),
'halvårlig': ('halvårlig',),
'halvårlige': ('halvårlig',),
'halvårligere': ('halvårlig',),
'halvårligst': ('halvårlig',),
'halvårligste': ('halvårlig',),
'hamburgsk': ('hamburgsk',),
'hamburgske': ('hamburgsk',),
'hamburgskere': ('hamburgsk',),
'hamburgskest': ('hamburgsk',),
'hamburgskeste': ('hamburgsk',),
'hamittisk': ('hamittisk',),
'hamittiske': ('hamittisk',),
'hamittiskere': ('hamittisk',),
'hamittiskest': ('hamittisk',),
'hamittiskeste': ('hamittisk',),
'hamla': ('hamle',),
'hamlede': ('hamle',),
'hamlende': ('hamle',),
'hamlet': ('hamle',),
'hamlete': ('hamle',),
'hamla': ('hamle',),
'hamlede': ('hamle',),
'hamlende': ('hamle',),
'hamlet': ('hamle',),
'hamlete': ('hamle',),
'hamna': ('hamne',),
'hamnede': ('hamne',),
'hamnende': ('hamne',),
'hamnet': ('hamne',),
'hamnete': ('hamne',),
'hamna': ('hamne',),
'hamnede': ('hamne',),
'hamnende': ('hamne',),
'hamnet': ('hamne',),
'hamnete': ('hamne',),
'hamna': ('hamne',),
'hamnede': ('hamne',),
'hamnende': ('hamne',),
'hamnet': ('hamne',),
'hamnete': ('hamne',),
'hamra': ('hamre',),
'hamrede': ('hamre',),
'hamrende': ('hamre',),
'hamret': ('hamre',),
'hamrete': ('hamre',),
'hamsa': ('hamse',),
'hamsede': ('hamse',),
'hamsende': ('hamse',),
'hamset': ('hamse',),
'hamsete': ('hamse',),
'hamstra': ('hamstre',),
'hamstrede': ('hamstre',),
'hamstrende': ('hamstre',),
'hamstret': ('hamstre',),
'hamstrete': ('hamstre',),
'handdrevet': ('handdrevet',),
'handdrevne': ('handdrevet',),
'handdrevnere': ('handdrevet',),
'handdrevnest': ('handdrevet',),
'handdrevneste': ('handdrevet',),
'handelspolitisk': ('handelspolitisk',),
'handelspolitiske': ('handelspolitisk',),
'handelspolitiskere': ('handelspolitisk',),
'handelspolitiskest': ('handelspolitisk',),
'handelspolitiskeste': ('handelspolitisk',),
'handfallen': ('handfallen',),
'handfallent': ('handfallen',),
'handfalne': ('handfallen',),
'handfalnere': ('handfallen',),
'handfalnest': ('handfallen',),
'handfalneste': ('handfallen',),
'handfarende': ('handfare',),
'handfart': ('handfare',),
'handfarte': ('handfare',),
'handfast': ('handfast',),
'handfaste': ('handfast',),
'handfastere': ('handfast',),
'handfastest': ('handfast',),
'handfasteste': ('handfast',),
'handgangen': ('handgangen',),
'handgangent': ('handgangen',),
'handgangne': ('handgangen',),
'handgangnere': ('handgangen',),
'handgangnest': ('handgangen',),
'handgangneste': ('handgangen',),
'handgiende': ('handgi',),
'handgitt': ('handgi',),
'handgitte': ('handgi',),
'handgivende': ('handgi',),
'handgripelig': ('handgripelig',),
'handgripelige': ('handgripelig',),
'handgripeligere': ('handgripelig',),
'handgripeligst': ('handgripelig',),
'handgripeligste': ('handgripelig',),
'handhelsende': ('handhelse',),
'handhelst': ('handhelse',),
'handhelste': ('handhelse',),
'handheva': ('handheve',),
'handhevd': ('handheve',),
'handhevde': ('handheve',),
'handhevede': ('handheve',),
'handhevende': ('handheve',),
'handhevet': ('handheve',),
'handhevete': ('handheve',),
'handhilsende': ('handhilse',),
'handhilst': ('handhilse',),
'handhilste': ('handhilse',),
'handhilsende': ('handhilse',),
'handhilst': ('handhilse',),
'handhilste': ('handhilse',),
'handikappa': ('handikappe',),
'handikappede': ('handikappe',),
'handikappende': ('handikappe',),
'handikappet': ('handikappe',),
'handikappete': ('handikappe',),
'handlaga': ('handlaga',),
'handlagd': ('handlagd',),
'handlagde': ('handlagd',),
'handlagdere': ('handlagd',),
'handlagdest': ('handlagd',),
'handlagdeste': ('handlagd',),
'handlagede': ('handlaget',),
'handlaget': ('handlaget',),
'handlagete': ('handlaget',),
'handlagetere': ('handlaget',),
'handlagetest': ('handlaget',),
'handlageteste': ('handlaget',),
'handla': ('handle',),
'handlede': ('handle',),
'handlende': ('handle',),
'handlet': ('handle',),
'handlete': ('handle',),
'handledyktig': ('handledyktig',),
'handledyktige': ('handledyktig',),
'handledyktigere': ('handledyktig',),
'handledyktigst': ('handledyktig',),
'handledyktigste': ('handledyktig',),
'handlekraftig': ('handlekraftig',),
'handlekraftige': ('handlekraftig',),
'handlekraftigere': ('handlekraftig',),
'handlekraftigst': ('handlekraftig',),
'handlekraftigste': ('handlekraftig',),
'handlingslamma': ('handlingslamma',),
'handlingslammede': ('handlingslammet',),
'handlingslammet': ('handlingslammet',),
'handlingslammete': ('handlingslammet',),
'handlingslammetere': ('handlingslammet',),
'handlingslammetest': ('handlingslammet',),
'handlingslammeteste': ('handlingslammet',),
'handlingsmetta': ('handlingsmetta',),
'handlingsmettede': ('handlingsmettet',),
'handlingsmettet': ('handlingsmettet',),
'handlingsmettete': ('handlingsmettet',),
'handlingsmettetere': ('handlingsmettet',),
'handlingsmettetest': ('handlingsmettet',),
'handlingsmetteteste': ('handlingsmettet',),
'handnerva': ('handnerva',),
'handnervede': ('handnervet',),
'handnervet': ('handnervet',),
'handnervete': ('handnervet',),
'handnervetere': ('handnervet',),
'handnervetest': ('handnervet',),
'handnerveteste': ('handnervet',),
'handplukka': ('handplukke',),
'handplukkede': ('handplukke',),
'handplukkende': ('handplukke',),
'handplukket': ('handplukke',),
'handplukkete': ('handplukke',),
'handsama': ('handsame',),
'handsamede': ('handsame',),
'handsamende': ('handsame',),
'handsamet': ('handsame',),
'handsamete': ('handsame',),
'handsa': ('handse',),
'handsede': ('handse',),
'handsende': ('handse',),
'handset': ('handse',),
'handsete': ('handse',),
'handskreven': ('handskreven',),
'handskrevet': ('handskreven',),
'handskrevne': ('handskreven',),
'handskrevnere': ('handskreven',),
'handskrevnest': ('handskreven',),
'handskrevneste': ('handskreven',),
'handskrevet': ('handskrevet',),
'handskrevne': ('handskrevet',),
'handskrevnere': ('handskrevet',),
'handskrevnest': ('handskrevet',),
'handskrevneste': ('handskrevet',),
'handskåren': ('handskåren',),
'handskåret': ('handskåren',),
'handskårne': ('handskåren',),
'handskårnere': ('handskåren',),
'handskårnest': ('handskåren',),
'handskårneste': ('handskåren',),
'handskåret': ('handskåret',),
'handskårne': ('handskåret',),
'handskårnere': ('handskåret',),
'handskårnest': ('handskåret',),
'handskårneste': ('handskåret',),
'handstående': ('handstående',),
'handterende': ('handtere',),
'handtert': ('handtere',),
'handterte': ('handtere',),
'handterlig': ('handterlig',),
'handterlige': ('handterlig',),
'handterligere': ('handterlig',),
'handterligst': ('handterlig',),
'handterligste': ('handterlig',),
'handvarm': ('handvarm',),
'handvarme': ('handvarm',),
'handvarmere': ('handvarm',),
'handvarmest': ('handvarm',),
'handvarmeste': ('handvarm',),
'handvarmt': ('handvarm',),
'handverksmessig': ('handverksmessig',),
'handverksmessige': ('handverksmessig',),
'handverksmessigere': ('handverksmessig',),
'handverksmessigst': ('handverksmessig',),
'handverksmessigste': ('handverksmessig',),
'hangla': ('hangle',),
'hanglede': ('hangle',),
'hanglende': ('hangle',),
'hanglet': ('hangle',),
'hanglete': ('hangle',),
'hanglet': ('hanglet',),
'hanglete': ('hanglet',),
'hangletere': ('hanglet',),
'hangletest': ('hanglet',),
'hangleteste': ('hanglet',),
'hanglete': ('hanglete',),
'hankelaus': ('hankelaus',),
'hankelause': ('hankelaus',),
'hankelausere': ('hankelaus',),
'hankelausest': ('hankelaus',),
'hankelauseste': ('hankelaus',),
'hankelaust': ('hankelaus',),
'hankeløs': ('hankeløs',),
'hankeløse': ('hankeløs',),
'hankeløsere': ('hankeløs',),
'hankeløsest': ('hankeløs',),
'hankeløseste': ('hankeløs',),
'hankeløst': ('hankeløs',),
'hanlig': ('hanlig',),
'hanlige': ('hanlig',),
'hanligere': ('hanlig',),
'hanligst': ('hanlig',),
'hanligste': ('hanlig',),
'hannlig': ('hannlig',),
'hannlige': ('hannlig',),
'hannligere': ('hannlig',),
'hannligst': ('hannlig',),
'hannligste': ('hannlig',),
'hanseatisk': ('hanseatisk',),
'hanseatiske': ('hanseatisk',),
'hanseatiskere': ('hanseatisk',),
'hanseatiskest': ('hanseatisk',),
'hanseatiskeste': ('hanseatisk',),
'haploid': ('haploid',),
'haploide': ('haploid',),
'haploidere': ('haploid',),
'haploidest': ('haploid',),
'haploideste': ('haploid',),
'hard': ('hard',),
'harde': ('hard',),
'hardere': ('hard',),
'hardest': ('hard',),
'hardeste': ('hard',),
'hardt': ('hard',),
'hardbalen': ('hardbalen',),
'hardbalent': ('hardbalen',),
'hardbalne': ('hardbalen',),
'hardbalnere': ('hardbalen',),
'hardbalnest': ('hardbalen',),
'hardbalneste': ('hardbalen',),
'hardbarkede': ('hardbarket',),
'hardbarket': ('hardbarket',),
'hardbarkete': ('hardbarket',),
'hardbarketere': ('hardbarket',),
'hardbarketest': ('hardbarket',),
'hardbarketeste': ('hardbarket',),
'hardfrosne': ('hardfrossen',),
'hardfrosnere': ('hardfrossen',),
'hardfrosnest': ('hardfrossen',),
'hardfrosneste': ('hardfrossen',),
'hardfrossen': ('hardfrossen',),
'hardfrosset': ('hardfrossen',),
'hardfrosne': ('hardfrosset',),
'hardfrosnere': ('hardfrosset',),
'hardfrosnest': ('hardfrosset',),
'hardfrosneste': ('hardfrosset',),
'hardfrosset': ('hardfrosset',),
'hardfør': ('hardfør',),
'hardføre': ('hardfør',),
'hardførere': ('hardfør',),
'hardførest': ('hardfør',),
'hardføreste': ('hardfør',),
'hardført': ('hardfør',),
'hardhendt': ('hardhendt',),
'hardhendte': ('hardhendt',),
'hardhendtere': ('hardhendt',),
'hardhendtest': ('hardhendt',),
'hardhendteste': ('hardhendt',),
'hardhjerta': ('hardhjerta',),
'hardhjertede': ('hardhjertet',),
'hardhjertet': ('hardhjertet',),
'hardhjertete': ('hardhjertet',),
'hardhjertetere': ('hardhjertet',),
'hardhjertetest': ('hardhjertet',),
'hardhjerteteste': ('hardhjertet',),
'hardhuda': ('hardhuda',),
'hardhudede': ('hardhudet',),
'hardhudet': ('hardhudet',),
'hardhudete': ('hardhudet',),
'hardhudetere': ('hardhudet',),
'hardhudetest': ('hardhudet',),
'hardhudeteste': ('hardhudet',),
'hardkokende': ('hardkoke',),
'hardkokt': ('hardkoke',),
'hardkokte': ('hardkoke',),
'hardlynt': ('hardlynt',),
'hardlynte': ('hardlynt',),
'hardlyntere': ('hardlynt',),
'hardlyntest': ('hardlynt',),
'hardlynteste': ('hardlynt',),
'hardnakka': ('hardnakka',),
'hardnakkede': ('hardnakket',),
'hardnakket': ('hardnakket',),
'hardnakkete': ('hardnakket',),
'hardnakketere': ('hardnakket',),
'hardnakketest': ('hardnakket',),
'hardnakketeste': ('hardnakket',),
'hardna': ('hardne',),
'hardnede': ('hardne',),
'hardnende': ('hardne',),
'hardnet': ('hardne',),
'hardnete': ('hardne',),
'hardstappa': ('hardstappa',),
'hardstappede': ('hardstappet',),
'hardstappet': ('hardstappet',),
'hardstappete': ('hardstappet',),
'hardstappetere': ('hardstappet',),
'hardstappetest': ('hardstappet',),
'hardstappeteste': ('hardstappet',),
'hardtrampa': ('hardtrampe',),
'hardtrampede': ('hardtrampe',),
'hardtrampende': ('hardtrampe',),
'hardtrampet': ('hardtrampe',),
'hardtrampete': ('hardtrampe',),
'hardtrena': ('hardtrene',),
'hardtrenede': ('hardtrene',),
'hardtrenende': ('hardtrene',),
'hardtrenet': ('hardtrene',),
'hardtrenete': ('hardtrene',),
'hardtrent': ('hardtrene',),
'hardtrente': ('hardtrene',),
'haremynt': ('haremynt',),
'haremynte': ('haremynt',),
'haremyntere': ('haremynt',),
'haremyntest': ('haremynt',),
'haremynteste': ('haremynt',),
'harka': ('harke',),
'harkede': ('harke',),
'harkende': ('harke',),
'harket': ('harke',),
'harkete': ('harke',),
'harm': ('harm',),
'harme': ('harm',),
'harmere': ('harm',),
'harmest': ('harm',),
'harmeste': ('harm',),
'harmt': ('harm',),
'harmdirrende': ('harmdirrende',),
'harma': ('harme',),
'harmede': ('harme',),
'harmende': ('harme',),
'harmet': ('harme',),
'harmete': ('harme',),
'harmelig': ('harmelig',),
'harmelige': ('harmelig',),
'harmeligere': ('harmelig',),
'harmeligst': ('harmelig',),
'harmeligste': ('harmelig',),
'harmfull': ('harmfull',),
'harmfulle': ('harmfull',),
'harmfullere': ('harmfull',),
'harmfullest': ('harmfull',),
'harmfulleste': ('harmfull',),
'harmfullt': ('harmfull',),
'harmlaus': ('harmlaus',),
'harmlause': ('harmlaus',),
'harmlausere': ('harmlaus',),
'harmlausest': ('harmlaus',),
'harmlauseste': ('harmlaus',),
'harmlaust': ('harmlaus',),
'harmløs': ('harmløs',),
'harmløse': ('harmløs',),
'harmløsere': ('harmløs',),
'harmløsest': ('harmløs',),
'harmløseste': ('harmløs',),
'harmløst': ('harmløs',),
'harmonerende': ('harmonere',),
'harmonert': ('harmonere',),
'harmonerte': ('harmonere',),
'harmoniserende': ('harmonisere',),
'harmonisert': ('harmonisere',),
'harmoniserte': ('harmonisere',),
'harmonisk': ('harmonisk',),
'harmoniske': ('harmonisk',),
'harmoniskere': ('harmonisk',),
'harmoniskest': ('harmonisk',),
'harmoniskeste': ('harmonisk',),
'harpa': ('harpe',),
'harpede': ('harpe',),
'harpende': ('harpe',),
'harpet': ('harpe',),
'harpete': ('harpe',),
'harpeserende': ('harpesere',),
'harpesert': ('harpesere',),
'harpeserte': ('harpesere',),
'harpunerende': ('harpunere',),
'harpunert': ('harpunere',),
'harpunerte': ('harpunere',),
'harselerende': ('harselere',),
'harselert': ('harselere',),
'harselerte': ('harselere',),
'harsk': ('harsk',),
'harske': ('harsk',),
'harskere': ('harsk',),
'harskest': ('harsk',),
'harskeste': ('harsk',),
'harskt': ('harsk',),
'harska': ('harske',),
'harskede': ('harske',),
'harskende': ('harske',),
'harsket': ('harske',),
'harskete': ('harske',),
'harskna': ('harskne',),
'harsknede': ('harskne',),
'harsknende': ('harskne',),
'harsknet': ('harskne',),
'harsknete': ('harskne',),
'harva': ('harve',),
'harvede': ('harve',),
'harvende': ('harve',),
'harvet': ('harve',),
'harvete': ('harve',),
'harva': ('harve',),
'harvede': ('harve',),
'harvende': ('harve',),
'harvet': ('harve',),
'harvete': ('harve',),
'hasardiøs': ('hasardiøs',),
'hasardiøse': ('hasardiøs',),
'hasardiøsere': ('hasardiøs',),
'hasardiøsest': ('hasardiøs',),
'hasardiøseste': ('hasardiøs',),
'hasardiøst': ('hasardiøs',),
'haspa': ('haspe',),
'haspede': ('haspe',),
'haspende': ('haspe',),
'haspet': ('haspe',),
'haspete': ('haspe',),
'haspla': ('hasple',),
'hasplede': ('hasple',),
'hasplende': ('hasple',),
'hasplet': ('hasple',),
'hasplete': ('hasple',),
'hasta': ('haste',),
'hastede': ('haste',),
'hastende': ('haste',),
'hastet': ('haste',),
'hastete': ('haste',),
'hastig': ('hastig',),
'hastige': ('hastig',),
'hastigere': ('hastig',),
'hastigst': ('hastig',),
'hastigste': ('hastig',),
'hata': ('hate',),
'hatede': ('hate',),
'hatende': ('hate',),
'hatet': ('hate',),
'hatete': ('hate',),
'hatefull': ('hatefull',),
'hatefulle': ('hatefull',),
'hatefullere': ('hatefull',),
'hatefullest': ('hatefull',),
'hatefulleste': ('hatefull',),
'hatefullt': ('hatefull',),
'hatig': ('hatig',),
'hatige': ('hatig',),
'hatigere': ('hatig',),
'hatigst': ('hatig',),
'hatigste': ('hatig',),
'hatsk': ('hatsk',),
'hatske': ('hatsk',),
'hatskere': ('hatsk',),
'hatskest': ('hatsk',),
'hatskeste': ('hatsk',),
'hauga': ('hauge',),
'haugede': ('hauge',),
'haugende': ('hauge',),
'hauget': ('hauge',),
'haugete': ('hauge',),
'hauget': ('hauget',),
'haugete': ('hauget',),
'haugetere': ('hauget',),
'haugetest': ('hauget',),
'haugeteste': ('hauget',),
'haugete': ('haugete',),
'haugiansk': ('haugiansk',),
'haugianske': ('haugiansk',),
'haugianskere': ('haugiansk',),
'haugianskest': ('haugiansk',),
'haugianskeste': ('haugiansk',),
'hauglagt': ('hauglegge',),
'hauglagte': ('hauglegge',),
'haugleggende': ('hauglegge',),
'haugtakende': ('haugta',),
'haugtatt': ('haugta',),
'haugtatte': ('haugta',),
'hauka': ('hauke',),
'haukede': ('hauke',),
'haukende': ('hauke',),
'hauket': ('hauke',),
'haukete': ('hauke',),
'haussa': ('hausse',),
'haussede': ('hausse',),
'haussende': ('hausse',),
'hausset': ('hausse',),
'haussete': ('hausse',),
'havannesisk': ('havannesisk',),
'havannesiske': ('havannesisk',),
'havannesiskere': ('havannesisk',),
'havannesiskest': ('havannesisk',),
'havannesiskeste': ('havannesisk',),
'havarerende': ('havarere',),
'havarert': ('havarere',),
'havarerte': ('havarere',),
'havesjuk': ('havesjuk',),
'havesjuke': ('havesjuk',),
'havesjukere': ('havesjuk',),
'havesjukest': ('havesjuk',),
'havesjukeste': ('havesjuk',),
'havesjukt': ('havesjuk',),
'havesyk': ('havesyk',),
'havesyke': ('havesyk',),
'havesykere': ('havesyk',),
'havesykest': ('havesyk',),
'havesykeste': ('havesyk',),
'havesykt': ('havesyk',),
'havgående': ('havgående',),
'havna': ('havne',),
'havnede': ('havne',),
'havnende': ('havne',),
'havnet': ('havne',),
'havnete': ('havne',),
'havna': ('havne',),
'havnede': ('havne',),
'havnende': ('havne',),
'havnet': ('havne',),
'havnete': ('havne',),
'havna': ('havne',),
'havnede': ('havne',),
'havnende': ('havne',),
'havnet': ('havne',),
'havnete': ('havne',),
'havsalt': ('havsalt',),
'havsalte': ('havsalt',),
'havsaltere': ('havsalt',),
'havsaltest': ('havsalt',),
'havsalteste': ('havsalt',),
'hawaiisk': ('hawaiisk',),
'hawaiiske': ('hawaiisk',),
'hawaiiskere': ('hawaiisk',),
'hawaiiskest': ('hawaiisk',),
'hawaiiskeste': ('hawaiisk',),
'hawaisk': ('hawaisk',),
'hawaiske': ('hawaisk',),
'hawaiskere': ('hawaisk',),
'hawaiskest': ('hawaisk',),
'hawaiskeste': ('hawaisk',),
'heada': ('heade',),
'headede': ('heade',),
'headende': ('heade',),
'headet': ('heade',),
'headete': ('heade',),
'hebraisk': ('hebraisk',),
'hebraiske': ('hebraisk',),
'hebraiskere': ('hebraisk',),
'hebraiskest': ('hebraisk',),
'hebraiskeste': ('hebraisk',),
'hebridisk': ('hebridisk',),
'hebridiske': ('hebridisk',),
'hebridiskere': ('hebridisk',),
'hebridiskest': ('hebridisk',),
'hebridiskeste': ('hebridisk',),
'hedensk': ('hedensk',),
'hedenske': ('hedensk',),
'hedenskere': ('hedensk',),
'hedenskest': ('hedensk',),
'hedenskeste': ('hedensk',),
'hederlig': ('hederlig',),
'hederlige': ('hederlig',),
'hederligere': ('hederlig',),
'hederligst': ('hederlig',),
'hederligste': ('hederlig',),
'hederskrona': ('hederskrona',),
'hederskronede': ('hederskronet',),
'hederskronet': ('hederskronet',),
'hederskronete': ('hederskronet',),
'hederskronetere': ('hederskronet',),
'hederskronetest': ('hederskronet',),
'hederskroneteste': ('hederskronet',),
'hederskront': ('hederskront',),
'hederskronte': ('hederskront',),
'hederskrontere': ('hederskront',),
'hederskrontest': ('hederskront',),
'hederskronteste': ('hederskront',),
'hedningkristen': ('hedningkristen',),
'hedningkristent': ('hedningkristen',),
'hedningkristne': ('hedningkristen',),
'hedningkristnere': ('hedningkristen',),
'hedningkristnest': ('hedningkristen',),
'hedningkristneste': ('hedningkristen',),
'hedonistisk': ('hedonistisk',),
'hedonistiske': ('hedonistisk',),
'hedonistiskere': ('hedonistisk',),
'hedonistiskest': ('hedonistisk',),
'hedonistiskeste': ('hedonistisk',),
'hedra': ('hedre',),
'hedrede': ('hedre',),
'hedrende': ('hedre',),
'hedret': ('hedre',),
'hedrete': ('hedre',),
'hefta': ('hefte',),
'heftede': ('hefte',),
'heftende': ('hefte',),
'heftet': ('hefte',),
'heftete': ('hefte',),
'heftig': ('heftig',),
'heftige': ('heftig',),
'heftigere': ('heftig',),
'heftigst': ('heftig',),
'heftigste': ('heftig',),
'hegda': ('hegde',),
'hegdede': ('hegde',),
'hegdende': ('hegde',),
'hegdet': ('hegde',),
'hegdete': ('hegde',),
'hegeliansk': ('hegeliansk',),
'hegelianske': ('hegeliansk',),
'hegelianskere': ('hegeliansk',),
'hegelianskest': ('hegeliansk',),
'hegelianskeste': ('hegeliansk',),
'hegelsk': ('hegelsk',),
'hegelske': ('hegelsk',),
'hegelskere': ('hegelsk',),
'hegelskest': ('hegelsk',),
'hegelskeste': ('hegelsk',),
'hegna': ('hegne',),
'hegnede': ('hegne',),
'hegnende': ('hegne',),
'hegnet': ('hegne',),
'hegnete': ('hegne',),
'heidundrende': ('heidundrende',),
'heia': ('heie',),
'heiede': ('heie',),
'heiende': ('heie',),
'heiet': ('heie',),
'heiete': ('heie',),
'heil': ('heil',),
'heile': ('heil',),
'heilere': ('heil',),
'heilest': ('heil',),
'heileste': ('heil',),
'heilt': ('heil',),
'heilaftens': ('heilaftens',),
'heilautomatisk': ('heilautomatisk',),
'heilautomatiske': ('heilautomatisk',),
'heilautomatiskere': ('heilautomatisk',),
'heilautomatiskest': ('heilautomatisk',),
'heilautomatiskeste': ('heilautomatisk',),
'heildekkende': ('heildekkende',),
'heilfet': ('heilfet',),
'heilfete': ('heilfet',),
'heilfetere': ('heilfet',),
'heilfetest': ('heilfet',),
'heilfeteste': ('heilfet',),
'heilfett': ('heilfet',),
'heilfrelst': ('heilfrelst',),
'heilfrelste': ('heilfrelst',),
'heilfrelstere': ('heilfrelst',),
'heilfrelstest': ('heilfrelst',),
'heilfrelsteste': ('heilfrelst',),
'heilgarderende': ('heilgardere',),
'heilgardert': ('heilgardere',),
'heilgarderte': ('heilgardere',),
'heilhetlig': ('heilhetlig',),
'heilhetlige': ('heilhetlig',),
'heilhetligere': ('heilhetlig',),
'heilhetligst': ('heilhetlig',),
'heilhetligste': ('heilhetlig',),
'heilhjerta': ('heilhjerta',),
'heilhjertede': ('heilhjertet',),
'heilhjertet': ('heilhjertet',),
'heilhjertete': ('heilhjertet',),
'heilhjertetere': ('heilhjertet',),
'heilhjertetest': ('heilhjertet',),
'heilhjerteteste': ('heilhjertet',),
'heilhuga': ('heilhuga',),
'heilkontinuerlig': ('heilkontinuerlig',),
'heilkontinuerlige': ('heilkontinuerlig',),
'heilkontinuerligere': ('heilkontinuerlig',),
'heilkontinuerligst': ('heilkontinuerlig',),
'heilkontinuerligste': ('heilkontinuerlig',),
'heilnorsk': ('heilnorsk',),
'heilnorske': ('heilnorsk',),
'heilnorskere': ('heilnorsk',),
'heilnorskest': ('heilnorsk',),
'heilnorskeste': ('heilnorsk',),
'heilnorsk': ('heilnorsk',),
'heilnorske': ('heilnorsk',),
'heilnorskere': ('heilnorsk',),
'heilnorskest': ('heilnorsk',),
'heilnorskeste': ('heilnorsk',),
'heilskinna': ('heilskinna',),
'heilskinnede': ('heilskinnet',),
'heilskinnet': ('heilskinnet',),
'heilskinnete': ('heilskinnet',),
'heilskinnetere': ('heilskinnet',),
'heilskinnetest': ('heilskinnet',),
'heilskinneteste': ('heilskinnet',),
'heilskåren': ('heilskåren',),
'heilskåret': ('heilskåren',),
'heilskårne': ('heilskåren',),
'heilskårnere': ('heilskåren',),
'heilskårnest': ('heilskåren',),
'heilskårneste': ('heilskåren',),
'heilskåret': ('heilskåret',),
'heilskårne': ('heilskåret',),
'heilskårnere': ('heilskåret',),
'heilskårnest': ('heilskåret',),
'heilskårneste': ('heilskåret',),
'heilstaut': ('heilstaut',),
'heilstaute': ('heilstaut',),
'heilstautere': ('heilstaut',),
'heilstautest': ('heilstaut',),
'heilstauteste': ('heilstaut',),
'heilsteikende': ('heilsteike',),
'heilsteikt': ('heilsteike',),
'heilsteikte': ('heilsteike',),
'heilstekende': ('heilsteke',),
'heilstekt': ('heilsteke',),
'heilstekte': ('heilsteke',),
'heilstøpende': ('heilstøpe',),
'heilstøpt': ('heilstøpe',),
'heilstøpte': ('heilstøpe',),
'heilstøypende': ('heilstøype',),
'heilstøypt': ('heilstøype',),
'heilstøypte': ('heilstøype',),
'heilsvart': ('heilsvart',),
'heilsvarte': ('heilsvart',),
'heilsvartere': ('heilsvart',),
'heilsvartest': ('heilsvart',),
'heilsvarteste': ('heilsvart',),
'heilsynkroniserende': ('heilsynkronisere',),
'heilsynkronisert': ('heilsynkronisere',),
'heilsynkroniserte': ('heilsynkronisere',),
'heiltallig': ('heiltallig',),
'heiltallige': ('heiltallig',),
'heiltalligere': ('heiltallig',),
'heiltalligst': ('heiltallig',),
'heiltalligste': ('heiltallig',),
'heiltidsansatt': ('heiltidsansatt',),
'heiltidsansatte': ('heiltidsansatt',),
'heiltidsansattere': ('heiltidsansatt',),
'heiltidsansattest': ('heiltidsansatt',),
'heiltidsansatteste': ('heiltidsansatt',),
'heiltres': ('heiltres',),
'heiltrukket': ('heiltrukket',),
'heiltrukne': ('heiltrukket',),
'heiltruknere': ('heiltrukket',),
'heiltruknest': ('heiltrukket',),
'heiltrukneste': ('heiltrukket',),
'heilårig': ('heilårig',),
'heilårige': ('heilårig',),
'heilårigere': ('heilårig',),
'heilårigst': ('heilårig',),
'heilårigste': ('heilårig',),
'heilårs': ('heilårs',),
'heimattkommen': ('heimattkommen',),
'heimattkomment': ('heimattkommen',),
'heimattkommet': ('heimattkommen',),
'heimattkomne': ('heimattkommen',),
'heimattkomnere': ('heimattkommen',),
'heimattkomnest': ('heimattkommen',),
'heimattkomneste': ('heimattkommen',),
'heimattkommet': ('heimattkommet',),
'heimattkomne': ('heimattkommet',),
'heimattkomnere': ('heimattkommet',),
'heimattkomnest': ('heimattkommet',),
'heimattkomneste': ('heimattkommet',),
'heima': ('heime',),
'heimede': ('heime',),
'heimende': ('heime',),
'heimet': ('heime',),
'heimete': ('heime',),
'heimearbeidende': ('heimearbeidende',),
'heimeavla': ('heimeavla',),
'heimeavlede': ('heimeavlet',),
'heimeavlet': ('heimeavlet',),
'heimeavlete': ('heimeavlet',),
'heimeavletere': ('heimeavlet',),
'heimeavletest': ('heimeavlet',),
'heimeavleteste': ('heimeavlet',),
'heimebakt': ('heimebakt',),
'heimebakte': ('heimebakt',),
'heimebaktere': ('heimebakt',),
'heimebaktest': ('heimebakt',),
'heimebakteste': ('heimebakt',),
'heimegjort': ('heimegjort',),
'heimegjorte': ('heimegjort',),
'heimegjortere': ('heimegjort',),
'heimegjortest': ('heimegjort',),
'heimegjorteste': ('heimegjort',),
'heimehørende': ('heimehørende',),
'heimekjent': ('heimekjent',),
'heimekjente': ('heimekjent',),
'heimekjentere': ('heimekjent',),
'heimekjentest': ('heimekjent',),
'heimekjenteste': ('heimekjent',),
'heimekjær': ('heimekjær',),
'heimekjære': ('heimekjær',),
'heimekjærere': ('heimekjær',),
'heimekjærest': ('heimekjær',),
'heimekjæreste': ('heimekjær',),
'heimekjært': ('heimekjær',),
'heimekoselig': ('heimekoselig',),
'heimekoselige': ('heimekoselig',),
'heimekoseligere': ('heimekoselig',),
'heimekoseligst': ('heimekoselig',),
'heimekoseligste': ('heimekoselig',),
'heimelaga': ('heimelaga',),
'heimelagd': ('heimelagd',),
'heimelagde': ('heimelagd',),
'heimelagdere': ('heimelagd',),
'heimelagdest': ('heimelagd',),
'heimelagdeste': ('heimelagd',),
'heimelagede': ('heimelaget',),
'heimelaget': ('heimelaget',),
'heimelagete': ('heimelaget',),
'heimelagetere': ('heimelaget',),
'heimelagetest': ('heimelaget',),
'heimelageteste': ('heimelaget',),
'heimestrikka': ('heimestrikka',),
'heimestrikkede': ('heimestrikket',),
'heimestrikket': ('heimestrikket',),
'heimestrikkete': ('heimestrikket',),
'heimestrikketere': ('heimestrikket',),
'heimestrikketest': ('heimestrikket',),
'heimestrikketeste': ('heimestrikket',),
'heimevant': ('heimevant',),
'heimevante': ('heimevant',),
'heimevantere': ('heimevant',),
'heimevantest': ('heimevant',),
'heimevanteste': ('heimevant',),
'heimeværende': ('heimeværende',),
'heimfallende': ('heimfalle',),
'heimfalt': ('heimfalle',),
'heimfalte': ('heimfalle',),
'heimfallen': ('heimfallen',),
'heimfallent': ('heimfallen',),
'heimfalne': ('heimfallen',),
'heimfalnere': ('heimfallen',),
'heimfalnest': ('heimfallen',),
'heimfalneste': ('heimfallen',),
'heimfesta': ('heimfeste',),
'heimfestede': ('heimfeste',),
'heimfestende': ('heimfeste',),
'heimfestet': ('heimfeste',),
'heimfestete': ('heimfeste',),
'heimfus': ('heimfus',),
'heimfuse': ('heimfus',),
'heimfusere': ('heimfus',),
'heimfusest': ('heimfus',),
'heimfuseste': ('heimfus',),
'heimfust': ('heimfus',),
'heimførende': ('heimføre',),
'heimført': ('heimføre',),
'heimførte': ('heimføre',),
'heimhuga': ('heimhuga',),
'heimkallende': ('heimkalle',),
'heimkalt': ('heimkalle',),
'heimkalte': ('heimkalle',),
'heimkommet': ('heimkommet',),
'heimkomne': ('heimkommet',),
'heimkomnere': ('heimkommet',),
'heimkomnest': ('heimkommet',),
'heimkomneste': ('heimkommet',),
'heimlaus': ('heimlaus',),
'heimlause': ('heimlaus',),
'heimlausere': ('heimlaus',),
'heimlausest': ('heimlaus',),
'heimlauseste': ('heimlaus',),
'heimlaust': ('heimlaus',),
'heimla': ('heimle',),
'heimlede': ('heimle',),
'heimlende': ('heimle',),
'heimlet': ('heimle',),
'heimlete': ('heimle',),
'heimlig': ('heimlig',),
'heimlige': ('heimlig',),
'heimligere': ('heimlig',),
'heimligst': ('heimlig',),
'heimligste': ('heimlig',),
'heimløs': ('heimløs',),
'heimløse': ('heimløs',),
'heimløsere': ('heimløs',),
'heimløsest': ('heimløs',),
'heimløseste': ('heimløs',),
'heimløst': ('heimløs',),
'heimsendende': ('heimsende',),
'heimsendt': ('heimsende',),
'heimsendte': ('heimsende',),
'heimsøkende': ('heimsøke',),
'heimsøkt': ('heimsøke',),
'heimsøkte': ('heimsøke',),
'heimvendt': ('heimvendt',),
'heimvendte': ('heimvendt',),
'heimvendtere': ('heimvendt',),
'heimvendtest': ('heimvendt',),
'heimvendteste': ('heimvendt',),
'heinende': ('heine',),
'heint': ('heine',),
'heinte': ('heine',),
'heisende': ('heise',),
'heist': ('heise',),
'heiste': ('heise',),
'heisende': ('heise',),
'heist': ('heise',),
'heiste': ('heise',),
'heit': ('heit',),
'heite': ('heit',),
'heitere': ('heit',),
'heitest': ('heit',),
'heiteste': ('heit',),
'heitt': ('heit',),
'hett': ('heit',),
'heitna': ('heitne',),
'heitnede': ('heitne',),
'heitnende': ('heitne',),
'heitnet': ('heitne',),
'heitnete': ('heitne',),
'hekka': ('hekke',),
'hekkede': ('hekke',),
'hekkende': ('hekke',),
'hekket': ('hekke',),
'hekkete': ('hekke',),
'hekla': ('hekle',),
'heklede': ('hekle',),
'heklende': ('hekle',),
'heklet': ('hekle',),
'heklete': ('hekle',),
'hekla': ('hekle',),
'heklede': ('hekle',),
'heklende': ('hekle',),
'heklet': ('hekle',),
'heklete': ('hekle',),
'heksa': ('hekse',),
'heksede': ('hekse',),
'heksende': ('hekse',),
'hekset': ('hekse',),
'heksete': ('hekse',),
'hekta': ('hekte',),
'hektede': ('hekte',),
'hektende': ('hekte',),
'hektet': ('hekte',),
'hektete': ('hekte',),
'hektisk': ('hektisk',),
'hektiske': ('hektisk',),
'hektiskere': ('hektisk',),
'hektiskest': ('hektisk',),
'hektiskeste': ('hektisk',),
'hektograferende': ('hektografere',),
'hektografert': ('hektografere',),
'hektograferte': ('hektografere',),
'hel': ('hel',),
'hele': ('hel',),
'helere': ('hel',),
'helest': ('hel',),
'heleste': ('hel',),
'helt': ('hel',),
'helaftens': ('helaftens',),
'helautomatisk': ('helautomatisk',),
'helautomatiske': ('helautomatisk',),
'helautomatiskere': ('helautomatisk',),
'helautomatiskest': ('helautomatisk',),
'helautomatiskeste': ('helautomatisk',),
'helbreda': ('helbrede',),
'helbredede': ('helbrede',),
'helbredende': ('helbrede',),
'helbredet': ('helbrede',),
'helbredete': ('helbrede',),
'helbredelig': ('helbredelig',),
'helbredelige': ('helbredelig',),
'helbredeligere': ('helbredelig',),
'helbredeligst': ('helbredelig',),
'helbredeligste': ('helbredelig',),
'helda': ('helde',),
'heldede': ('helde',),
'heldende': ('helde',),
'heldet': ('helde',),
'heldete': ('helde',),
'heldekkende': ('heldekkende',),
'heldig': ('heldig',),
'heldige': ('heldig',),
'heldigere': ('heldig',),
'heldigst': ('heldig',),
'heldigste': ('heldig',),
'helfet': ('helfet',),
'helfete': ('helfet',),
'helfetere': ('helfet',),
'helfetest': ('helfet',),
'helfeteste': ('helfet',),
'helfett': ('helfet',),
'helfrelst': ('helfrelst',),
'helfrelste': ('helfrelst',),
'helfrelstere': ('helfrelst',),
'helfrelstest': ('helfrelst',),
'helfrelsteste': ('helfrelst',),
'helgarderende': ('helgardere',),
'helgardert': ('helgardere',),
'helgarderte': ('helgardere',),
'helhetlig': ('helhetlig',),
'helhetlige': ('helhetlig',),
'helhetligere': ('helhetlig',),
'helhetligst': ('helhetlig',),
'helhetligste': ('helhetlig',),
'helhjerta': ('helhjerta',),
'helhjertede': ('helhjertet',),
'helhjertet': ('helhjertet',),
'helhjertete': ('helhjertet',),
'helhjertetere': ('helhjertet',),
'helhjertetest': ('helhjertet',),
'helhjerteteste': ('helhjertet',),
'heliosentrisk': ('heliosentrisk',),
'heliosentriske': ('heliosentrisk',),
'heliosentriskere': ('heliosentrisk',),
'heliosentriskest': ('heliosentrisk',),
'heliosentriskeste': ('heliosentrisk',),
'helkontinuerlig': ('helkontinuerlig',),
'helkontinuerlige': ('helkontinuerlig',),
'helkontinuerligere': ('helkontinuerlig',),
'helkontinuerligst': ('helkontinuerlig',),
'helkontinuerligste': ('helkontinuerlig',),
'hella': ('helle',),
'hellede': ('helle',),
'hellende': ('helle',),
'hellet': ('helle',),
'hellete': ('helle',),
'helt': ('helle',),
'helte': ('helle',),
'hellelagt': ('hellelegge',),
'hellelagte': ('hellelegge',),
'helleleggende': ('hellelegge',),
'hellenistisk': ('hellenistisk',),
'hellenistiske': ('hellenistisk',),
'hellenistiskere': ('hellenistisk',),
'hellenistiskest': ('hellenistisk',),
'hellenistiskeste': ('hellenistisk',),
'hellensk': ('hellensk',),
'hellenske': ('hellensk',),
'hellenskere': ('hellensk',),
'hellenskest': ('hellensk',),
'hellenskeste': ('hellensk',),
'hellig': ('hellig',),
'hellige': ('hellig',),
'helligere': ('hellig',),
'helligst': ('hellig',),
'helligste': ('hellig',),
'helliga': ('hellige',),
'helligede': ('hellige',),
'helligende': ('hellige',),
'helliget': ('hellige',),
'helligete': ('hellige',),
'helligholdende': ('helligholde',),
'helligholdt': ('helligholde',),
'helligholdte': ('helligholde',),
'helnorsk': ('helnorsk',),
'helnorske': ('helnorsk',),
'helnorskere': ('helnorsk',),
'helnorskest': ('helnorsk',),
'helnorskeste': ('helnorsk',),
'helsende': ('helse',),
'helst': ('helse',),
'helste': ('helse',),
'helsende': ('helse',),
'helst': ('helse',),
'helste': ('helse',),
'helsebringende': ('helsebringende',),
'helsebrutt': ('helsebrutt',),
'helsebrutte': ('helsebrutt',),
'helsebruttere': ('helsebrutt',),
'helsebruttest': ('helsebrutt',),
'helsebrutteste': ('helsebrutt',),
'helsefarlig': ('helsefarlig',),
'helsefarlige': ('helsefarlig',),
'helsefarligere': ('helsefarlig',),
'helsefarligst': ('helsefarlig',),
'helsefarligste': ('helsefarlig',),
'helselaus': ('helselaus',),
'helselause': ('helselaus',),
'helselausere': ('helselaus',),
'helselausest': ('helselaus',),
'helselauseste': ('helselaus',),
'helselaust': ('helselaus',),
'helseløs': ('helseløs',),
'helseløse': ('helseløs',),
'helseløsere': ('helseløs',),
'helseløsest': ('helseløs',),
'helseløseste': ('helseløs',),
'helseløst': ('helseløs',),
'helseslående': ('helseslå',),
'helseslått': ('helseslå',),
'helseslåtte': ('helseslå',),
'helsikes': ('helsikes',),
'helskinna': ('helskinna',),
'helskinnede': ('helskinnet',),
'helskinnet': ('helskinnet',),
'helskinnete': ('helskinnet',),
'helskinnetere': ('helskinnet',),
'helskinnetest': ('helskinnet',),
'helskinneteste': ('helskinnet',),
'helskåren': ('helskåren',),
'helskåret': ('helskåren',),
'helskårne': ('helskåren',),
'helskårnere': ('helskåren',),
'helskårnest': ('helskåren',),
'helskårneste': ('helskåren',),
'helskåret': ('helskåret',),
'helskårne': ('helskåret',),
'helskårnere': ('helskåret',),
'helskårnest': ('helskåret',),
'helskårneste': ('helskåret',),
'helstaut': ('helstaut',),
'helstaute': ('helstaut',),
'helstautere': ('helstaut',),
'helstautest': ('helstaut',),
'helstauteste': ('helstaut',),
'helsteikende': ('helsteike',),
'helsteikt': ('helsteike',),
'helsteikte': ('helsteike',),
'helstekende': ('helsteke',),
'helstekt': ('helsteke',),
'helstekte': ('helsteke',),
'helstøpende': ('helstøpe',),
'helstøpt': ('helstøpe',),
'helstøpte': ('helstøpe',),
'helstøypende': ('helstøype',),
'helstøypt': ('helstøype',),
'helstøypte': ('helstøype',),
'helsvart': ('helsvart',),
'helsvarte': ('helsvart',),
'helsvartere': ('helsvart',),
'helsvartest': ('helsvart',),
'helsvarteste': ('helsvart',),
'helsynkroniserende': ('helsynkronisere',),
'helsynkronisert': ('helsynkronisere',),
'helsynkroniserte': ('helsynkronisere',),
'heltallig': ('heltallig',),
'heltallige': ('heltallig',),
'heltalligere': ('heltallig',),
'heltalligst': ('heltallig',),
'heltalligste': ('heltallig',),
'heltemodig': ('heltemodig',),
'heltemodige': ('heltemodig',),
'heltemodigere': ('heltemodig',),
'heltemodigst': ('heltemodig',),
'heltemodigste': ('heltemodig',),
'heltidsansatt': ('heltidsansatt',),
'heltidsansatte': ('heltidsansatt',),
'heltidsansattere': ('heltidsansatt',),
'heltidsansattest': ('heltidsansatt',),
'heltidsansatteste': ('heltidsansatt',),
'heltres': ('heltres',),
'heltrukket': ('heltrukket',),
'heltrukne': ('heltrukket',),
'heltruknere': ('heltrukket',),
'heltruknest': ('heltrukket',),
'heltrukneste': ('heltrukket',),
'helvetes': ('helvetes',),
'helårig': ('helårig',),
'helårige': ('helårig',),
'helårigere': ('helårig',),
'helårigst': ('helårig',),
'helårigste': ('helårig',),
'helårs': ('helårs',),
'hematologisk': ('hematologisk',),
'hematologiske': ('hematologisk',),
'hematologiskere': ('hematologisk',),
'hematologiskest': ('hematologisk',),
'hematologiskeste': ('hematologisk',),
'hemisfærisk': ('hemisfærisk',),
'hemisfæriske': ('hemisfærisk',),
'hemisfæriskere': ('hemisfærisk',),
'hemisfæriskest': ('hemisfærisk',),
'hemisfæriskeste': ('hemisfærisk',),
'hemma': ('hemme',),
'hemmede': ('hemme',),
'hemmende': ('hemme',),
'hemmet': ('hemme',),
'hemmete': ('hemme',),
'hemmelig': ('hemmelig',),
'hemmelige': ('hemmelig',),
'hemmeligere': ('hemmelig',),
'hemmeligst': ('hemmelig',),
'hemmeligste': ('hemmelig',),
'hemmelighetsfull': ('hemmelighetsfull',),
'hemmelighetsfulle': ('hemmelighetsfull',),
'hemmelighetsfullere': ('hemmelighetsfull',),
'hemmelighetsfullest': ('hemmelighetsfull',),
'hemmelighetsfulleste': ('hemmelighetsfull',),
'hemmelighetsfullt': ('hemmelighetsfull',),
'hemmeligholdende': ('hemmeligholde',),
'hemmeligholdt': ('hemmeligholde',),
'hemmeligholdte': ('hemmeligholde',),
'hemmeligstempla': ('hemmeligstemple',),
'hemmeligstemplede': ('hemmeligstemple',),
'hemmeligstemplende': ('hemmeligstemple',),
'hemmeligstemplet': ('hemmeligstemple',),
'hemmeligstemplete': ('hemmeligstemple',),
'hemningslaus': ('hemningslaus',),
'hemningslause': ('hemningslaus',),
'hemningslausere': ('hemningslaus',),
'hemningslausest': ('hemningslaus',),
'hemningslauseste': ('hemningslaus',),
'hemningslaust': ('hemningslaus',),
'hemningsløs': ('hemningsløs',),
'hemningsløse': ('hemningsløs',),
'hemningsløsere': ('hemningsløs',),
'hemningsløsest': ('hemningsløs',),
'hemningsløseste': ('hemningsløs',),
'hemningsløst': ('hemningsløs',),
'hendende': ('hende',),
'hendt': ('hende',),
'hendte': ('hende',),
'hende': ('hende',),
'hendelig': ('hendelig',),
'hendelige': ('hendelig',),
'hendeligere': ('hendelig',),
'hendeligst': ('hendelig',),
'hendeligste': ('hendelig',),
'hendig': ('hendig',),
'hendige': ('hendig',),
'hendigere': ('hendig',),
'hendigst': ('hendig',),
'hendigste': ('hendig',),
'hendt': ('hendt',),
'hendte': ('hendt',),
'hendtere': ('hendt',),
'hendtest': ('hendt',),
'hendteste': ('hendt',),
'hendøende': ('hendøende',),
'henfallen': ('henfallen',),
'henfallent': ('henfallen',),
'henfalne': ('henfallen',),
'henfalnere': ('henfallen',),
'henfalnest': ('henfallen',),
'henfalneste': ('henfallen',),
'henfaren': ('henfaren',),
'henfarent': ('henfaren',),
'henfarne': ('henfaren',),
'henfarnere': ('henfaren',),
'henfarnest': ('henfaren',),
'henfarneste': ('henfaren',),
'henførende': ('henføre',),
'henført': ('henføre',),
'henførte': ('henføre',),
'hengebratt': ('hengebratt',),
'hengebratte': ('hengebratt',),
'hengebrattere': ('hengebratt',),
'hengebrattest': ('hengebratt',),
'hengebratteste': ('hengebratt',),
'hengeskuldra': ('hengeskuldra',),
'hengeskuldrede': ('hengeskuldret',),
'hengeskuldret': ('hengeskuldret',),
'hengeskuldrete': ('hengeskuldret',),
'hengeskuldretere': ('hengeskuldret',),
'hengeskuldretest': ('hengeskuldret',),
'hengeskuldreteste': ('hengeskuldret',),
'hengiende': ('hengi',),
'hengitt': ('hengi',),
'hengitte': ('hengi',),
'hengivende': ('hengi',),
'hengiven': ('hengiven',),
'hengivent': ('hengiven',),
'hengivne': ('hengiven',),
'hengivnere': ('hengiven',),
'hengivnest': ('hengiven',),
'hengivneste': ('hengiven',),
'hengsla': ('hengsle',),
'hengslede': ('hengsle',),
'hengslende': ('hengsle',),
'hengslet': ('hengsle',),
'hengslete': ('hengsle',),
'hengslet': ('hengslet',),
'hengslete': ('hengslet',),
'hengsletere': ('hengslet',),
'hengsletest': ('hengslet',),
'hengsleteste': ('hengslet',),
'hengslete': ('hengslete',),
'henholdende': ('henholde',),
'henholdt': ('henholde',),
'henholdte': ('henholde',),
'henhørende': ('henhøre',),
'henhørt': ('henhøre',),
'henhørte': ('henhøre',),
'henkasta': ('henkaste',),
'henkastede': ('henkaste',),
'henkastende': ('henkaste',),
'henkastet': ('henkaste',),
'henkastete': ('henkaste',),
'henleda': ('henlede',),
'henledede': ('henlede',),
'henledende': ('henlede',),
'henledet': ('henlede',),
'henledete': ('henlede',),
'henlagt': ('henlegge',),
'henlagte': ('henlegge',),
'henleggende': ('henlegge',),
'hennafarga': ('hennafarga',),
'hennafargede': ('hennafarget',),
'hennafarget': ('hennafarget',),
'hennafargete': ('hennafarget',),
'hennafargetere': ('hennafarget',),
'hennafargetest': ('hennafarget',),
'hennafargeteste': ('hennafarget',),
'henrekna': ('henrekne',),
'henreknede': ('henrekne',),
'henreknende': ('henrekne',),
'henreknet': ('henrekne',),
'henreknete': ('henrekne',),
'henretta': ('henrette',),
'henrettede': ('henrette',),
'henrettende': ('henrette',),
'henrettet': ('henrette',),
'henrettete': ('henrette',),
'henrivende': ('henrivende',),
'henrykka': ('henrykke',),
'henrykkede': ('henrykke',),
'henrykkende': ('henrykke',),
'henrykket': ('henrykke',),
'henrykkete': ('henrykke',),
'henrykt': ('henrykke',),
'henrykte': ('henrykke',),
'henrykt': ('henrykt',),
'henrykte': ('henrykt',),
'henryktere': ('henrykt',),
'henryktest': ('henrykt',),
'henrykteste': ('henrykt',),
'hensatt': ('hensette',),
'hensatte': ('hensette',),
'hensettende': ('hensette',),
'hensiktsmessig': ('hensiktsmessig',),
'hensiktsmessige': ('hensiktsmessig',),
'hensiktsmessigere': ('hensiktsmessig',),
'hensiktsmessigst': ('hensiktsmessig',),
'hensiktsmessigste': ('hensiktsmessig',),
'hensiktssvarende': ('hensiktssvarende',),
'henskutt': ('henskyte',),
'henskutte': ('henskyte',),
'henskytende': ('henskyte',),
'henslengt': ('henslengt',),
'henslengte': ('henslengt',),
'henslengtere': ('henslengt',),
'henslengtest': ('henslengt',),
'henslengteste': ('henslengt',),
'henslepende': ('henslepe',),
'henslept': ('henslepe',),
'henslepte': ('henslepe',),
'henspillende': ('henspille',),
'henspilt': ('henspille',),
'henspilte': ('henspille',),
'henstillende': ('henstille',),
'henstilt': ('henstille',),
'henstilte': ('henstille',),
'henstrakt': ('henstrakt',),
'henstrakte': ('henstrakt',),
'henstraktere': ('henstrakt',),
'henstraktest': ('henstrakt',),
'henstrakteste': ('henstrakt',),
'hensynsfull': ('hensynsfull',),
'hensynsfulle': ('hensynsfull',),
'hensynsfullere': ('hensynsfull',),
'hensynsfullest': ('hensynsfull',),
'hensynsfulleste': ('hensynsfull',),
'hensynsfullt': ('hensynsfull',),
'hensynslaus': ('hensynslaus',),
'hensynslause': ('hensynslaus',),
'hensynslausere': ('hensynslaus',),
'hensynslausest': ('hensynslaus',),
'hensynslauseste': ('hensynslaus',),
'hensynslaust': ('hensynslaus',),
'hensynsløs': ('hensynsløs',),
'hensynsløse': ('hensynsløs',),
'hensynsløsere': ('hensynsløs',),
'hensynsløsest': ('hensynsløs',),
'hensynsløseste': ('hensynsløs',),
'hensynsløst': ('hensynsløs',),
'henta': ('hente',),
'hentede': ('hente',),
'hentende': ('hente',),
'hentet': ('hente',),
'hentete': ('hente',),
'hentyda': ('hentyde',),
'hentydede': ('hentyde',),
'hentydende': ('hentyde',),
'hentydet': ('hentyde',),
'hentydete': ('hentyde',),
'henvendende': ('henvende',),
'henvendt': ('henvende',),
'henvendte': ('henvende',),
'henvisende': ('henvise',),
'henvist': ('henvise',),
'henviste': ('henvise',),
'heppa': ('heppe',),
'heppede': ('heppe',),
'heppende': ('heppe',),
'heppet': ('heppe',),
'heppete': ('heppe',),
'hepne': ('heppen',),
'hepnere': ('heppen',),
'hepnest': ('heppen',),
'hepneste': ('heppen',),
'heppen': ('heppen',),
'heppent': ('heppen',),
'heraldisk': ('heraldisk',),
'heraldiske': ('heraldisk',),
'heraldiskere': ('heraldisk',),
'heraldiskest': ('heraldisk',),
'heraldiskeste': ('heraldisk',),
'herda': ('herde',),
'herdede': ('herde',),
'herdende': ('herde',),
'herdet': ('herde',),
'herdete': ('herde',),
'herdebrei': ('herdebrei',),
'herdebreie': ('herdebrei',),
'herdebreiere': ('herdebrei',),
'herdebreiest': ('herdebrei',),
'herdebreieste': ('herdebrei',),
'herdebreit': ('herdebrei',),
'herdig': ('herdig',),
'herdige': ('herdig',),
'herdigere': ('herdig',),
'herdigst': ('herdig',),
'herdigste': ('herdig',),
'herdna': ('herdne',),
'herdnede': ('herdne',),
'herdnende': ('herdne',),
'herdnet': ('herdne',),
'herdnete': ('herdne',),
'hereditær': ('hereditær',),
'hereditære': ('hereditær',),
'hereditærere': ('hereditær',),
'hereditærest': ('hereditær',),
'hereditæreste': ('hereditær',),
'hereditært': ('hereditær',),
'heretisk': ('heretisk',),
'heretiske': ('heretisk',),
'heretiskere': ('heretisk',),
'heretiskest': ('heretisk',),
'heretiskeste': ('heretisk',),
'herja': ('herje',),
'herjede': ('herje',),
'herjende': ('herje',),
'herjet': ('herje',),
'herjete': ('herje',),
'herkulisk': ('herkulisk',),
'herkuliske': ('herkulisk',),
'herkuliskere': ('herkulisk',),
'herkuliskest': ('herkulisk',),
'herkuliskeste': ('herkulisk',),
'herlig': ('herlig',),
'herlige': ('herlig',),
'herligere': ('herlig',),
'herligst': ('herlig',),
'herligste': ('herlig',),
'herliggjort': ('herliggjøre',),
'herliggjorte': ('herliggjøre',),
'herliggjørende': ('herliggjøre',),
'hermafrodittisk': ('hermafrodittisk',),
'hermafrodittiske': ('hermafrodittisk',),
'hermafrodittiskere': ('hermafrodittisk',),
'hermafrodittiskest': ('hermafrodittisk',),
'hermafrodittiskeste': ('hermafrodittisk',),
'herma': ('herme',),
'hermede': ('herme',),
'hermende': ('herme',),
'hermet': ('herme',),
'hermete': ('herme',),
'hermt': ('herme',),
'hermte': ('herme',),
'hermeneutisk': ('hermeneutisk',),
'hermeneutiske': ('hermeneutisk',),
'hermeneutiskere': ('hermeneutisk',),
'hermeneutiskest': ('hermeneutisk',),
'hermeneutiskeste': ('hermeneutisk',),
'hermetiserende': ('hermetisere',),
'hermetisert': ('hermetisere',),
'hermetiserte': ('hermetisere',),
'hermetisk': ('hermetisk',),
'hermetiske': ('hermetisk',),
'hermetiskere': ('hermetisk',),
'hermetiskest': ('hermetisk',),
'hermetiskeste': ('hermetisk',),
'heroiserende': ('heroisere',),
'heroisert': ('heroisere',),
'heroiserte': ('heroisere',),
'heroisk': ('heroisk',),
'heroiske': ('heroisk',),
'heroiskere': ('heroisk',),
'heroiskest': ('heroisk',),
'heroiskeste': ('heroisk',),
'herostratisk': ('herostratisk',),
'herostratiske': ('herostratisk',),
'herostratiskere': ('herostratisk',),
'herostratiskest': ('herostratisk',),
'herostratiskeste': ('herostratisk',),
'herrelaus': ('herrelaus',),
'herrelause': ('herrelaus',),
'herrelausere': ('herrelaus',),
'herrelausest': ('herrelaus',),
'herrelauseste': ('herrelaus',),
'herrelaust': ('herrelaus',),
'herreløs': ('herreløs',),
'herreløse': ('herreløs',),
'herreløsere': ('herreløs',),
'herreløsest': ('herreløs',),
'herreløseste': ('herreløs',),
'herreløst': ('herreløs',),
'herrnhutisk': ('herrnhutisk',),
'herrnhutiske': ('herrnhutisk',),
'herrnhutiskere': ('herrnhutisk',),
'herrnhutiskest': ('herrnhutisk',),
'herrnhutiskeste': ('herrnhutisk',),
'hersa': ('herse',),
'hersede': ('herse',),
'hersende': ('herse',),
'herset': ('herse',),
'hersete': ('herse',),
'herskapelig': ('herskapelig',),
'herskapelige': ('herskapelig',),
'herskapeligere': ('herskapelig',),
'herskapeligst': ('herskapelig',),
'herskapeligste': ('herskapelig',),
'herska': ('herske',),
'herskede': ('herske',),
'herskende': ('herske',),
'hersket': ('herske',),
'herskete': ('herske',),
'herskesjuk': ('herskesjuk',),
'herskesjuke': ('herskesjuk',),
'herskesjukere': ('herskesjuk',),
'herskesjukest': ('herskesjuk',),
'herskesjukeste': ('herskesjuk',),
'herskesjukt': ('herskesjuk',),
'herskesyk': ('herskesyk',),
'herskesyke': ('herskesyk',),
'herskesykere': ('herskesyk',),
'herskesykest': ('herskesyk',),
'herskesykeste': ('herskesyk',),
'herskesykt': ('herskesyk',),
'herværende': ('herværende',),
'hes': ('hes',),
'hese': ('hes',),
'hesere': ('hes',),
'hesest': ('hes',),
'heseste': ('hes',),
'hest': ('hes',),
'heseblesende': ('heseblesende',),
'hesja': ('hesje',),
'hesjede': ('hesje',),
'hesjende': ('hesje',),
'hesjet': ('hesje',),
'hesjete': ('hesje',),
'heslig': ('heslig',),
'heslige': ('heslig',),
'hesligere': ('heslig',),
'hesligst': ('heslig',),
'hesligste': ('heslig',),
'hespa': ('hespe',),
'hespede': ('hespe',),
'hespende': ('hespe',),
'hespet': ('hespe',),
'hespete': ('hespe',),
'hespla': ('hesple',),
'hesplede': ('hesple',),
'hesplende': ('hesple',),
'hesplet': ('hesple',),
'hesplete': ('hesple',),
'hestedum': ('hestedum',),
'hestedumme': ('hestedum',),
'hestedummere': ('hestedum',),
'hestedummest': ('hestedum',),
'hestedummeste': ('hestedum',),
'hestedumt': ('hestedum',),
'hestegal': ('hestegal',),
'hestegale': ('hestegal',),
'hestegalere': ('hestegal',),
'hestegalest': ('hestegal',),
'hestegaleste': ('hestegal',),
'hestegalt': ('hestegal',),
'hestehandla': ('hestehandle',),
'hestehandlede': ('hestehandle',),
'hestehandlende': ('hestehandle',),
'hestehandlet': ('hestehandle',),
'hestehandlete': ('hestehandle',),
'hestgal': ('hestgal',),
'hestgale': ('hestgal',),
'hestgalere': ('hestgal',),
'hestgalest': ('hestgal',),
'hestgaleste': ('hestgal',),
'hestgalt': ('hestgal',),
'het': ('het',),
'hete': ('het',),
'hetere': ('het',),
'hetest': ('het',),
'heteste': ('het',),
'hett': ('het',),
'heta': ('hete',),
'hetede': ('hete',),
'hetende': ('hete',),
'hetet': ('hete',),
'hetete': ('hete',),
'hetende': ('hete',),
'hett': ('hete',),
'hette': ('hete',),
'heterodoks': ('heterodoks',),
'heterodokse': ('heterodoks',),
'heterodoksere': ('heterodoks',),
'heterodoksest': ('heterodoks',),
'heterodokseste': ('heterodoks',),
'heterodokst': ('heterodoks',),
'heterofil': ('heterofil',),
'heterofile': ('heterofil',),
'heterofilere': ('heterofil',),
'heterofilest': ('heterofil',),
'heterofileste': ('heterofil',),
'heterofilt': ('heterofil',),
'heterogen': ('heterogen',),
'heterogene': ('heterogen',),
'heterogenere': ('heterogen',),
'heterogenest': ('heterogen',),
'heterogeneste': ('heterogen',),
'heterogent': ('heterogen',),
'heteromorf': ('heteromorf',),
'heteromorfe': ('heteromorf',),
'heteromorfere': ('heteromorf',),
'heteromorfest': ('heteromorf',),
'heteromorfeste': ('heteromorf',),
'heteromorft': ('heteromorf',),
'heteroseksuell': ('heteroseksuell',),
'heteroseksuelle': ('heteroseksuell',),
'heteroseksuellere': ('heteroseksuell',),
'heteroseksuellest': ('heteroseksuell',),
'heteroseksuelleste': ('heteroseksuell',),
'heteroseksuelt': ('heteroseksuell',),
'hetna': ('hetne',),
'hetnede': ('hetne',),
'hetnende': ('hetne',),
'hetnet': ('hetne',),
'hetnete': ('hetne',),
'hetsa': ('hetse',),
'hetsede': ('hetse',),
'hetsende': ('hetse',),
'hetset': ('hetse',),
'hetsete': ('hetse',),
'hettittisk': ('hettittisk',),
'hettittiske': ('hettittisk',),
'hettittiskere': ('hettittisk',),
'hettittiskest': ('hettittisk',),
'hettittiskeste': ('hettittisk',),
'heuristisk': ('heuristisk',),
'heuristiske': ('heuristisk',),
'heuristiskere': ('heuristisk',),
'heuristiskest': ('heuristisk',),
'heuristiskeste': ('heuristisk',),
'hevbar': ('hevbar',),
'hevbare': ('hevbar',),
'hevbarere': ('hevbar',),
'hevbarest': ('hevbar',),
'hevbareste': ('hevbar',),
'hevbart': ('hevbar',),
'hevda': ('hevde',),
'hevdede': ('hevde',),
'hevdende': ('hevde',),
'hevdet': ('hevde',),
'hevdete': ('hevde',),
'hevdvunne': ('hevdvunnen',),
'hevdvunnen': ('hevdvunnen',),
'hevdvunnere': ('hevdvunnen',),
'hevdvunnest': ('hevdvunnen',),
'hevdvunneste': ('hevdvunnen',),
'hevdvunnet': ('hevdvunnen',),
'hevdvunne': ('hevdvunnet',),
'hevdvunnere': ('hevdvunnet',),
'hevdvunnest': ('hevdvunnet',),
'hevdvunneste': ('hevdvunnet',),
'hevdvunnet': ('hevdvunnet',),
'heva': ('heve',),
'hevd': ('heve',),
'hevde': ('heve',),
'hevede': ('heve',),
'hevende': ('heve',),
'hevet': ('heve',),
'hevete': ('heve',),
'hevla': ('hevle',),
'hevlede': ('hevle',),
'hevlende': ('hevle',),
'hevlet': ('hevle',),
'hevlete': ('hevle',),
'hevna': ('hevne',),
'hevnede': ('hevne',),
'hevnende': ('hevne',),
'hevnet': ('hevne',),
'hevnete': ('hevne',),
'hevngjerrig': ('hevngjerrig',),
'hevngjerrige': ('hevngjerrig',),
'hevngjerrigere': ('hevngjerrig',),
'hevngjerrigst': ('hevngjerrig',),
'hevngjerrigste': ('hevngjerrig',),
'hia': ('hie',),
'hiede': ('hie',),
'hiende': ('hie',),
'hiet': ('hie',),
'hiete': ('hie',),
'hierarkisk': ('hierarkisk',),
'hierarkiske': ('hierarkisk',),
'hierarkiskere': ('hierarkisk',),
'hierarkiskest': ('hierarkisk',),
'hierarkiskeste': ('hierarkisk',),
'hieratisk': ('hieratisk',),
'hieratiske': ('hieratisk',),
'hieratiskere': ('hieratisk',),
'hieratiskest': ('hieratisk',),
'hieratiskeste': ('hieratisk',),
'hieroglyfisk': ('hieroglyfisk',),
'hieroglyfiske': ('hieroglyfisk',),
'hieroglyfiskere': ('hieroglyfisk',),
'hieroglyfiskest': ('hieroglyfisk',),
'hieroglyfiskeste': ('hieroglyfisk',),
'higa': ('hige',),
'higede': ('hige',),
'higende': ('hige',),
'higet': ('hige',),
'higete': ('hige',),
'hikka': ('hikke',),
'hikkede': ('hikke',),
'hikkende': ('hikke',),
'hikket': ('hikke',),
'hikkete': ('hikke',),
'hiksta': ('hikste',),
'hikstede': ('hikste',),
'hikstende': ('hikste',),
'hikstet': ('hikste',),
'hikstete': ('hikste',),
'hikstegråtende': ('hikstegråte',),
'hikstegrått': ('hikstegråte',),
'hikstegråtte': ('hikstegråte',),
'hilda': ('hilde',),
'hildede': ('hilde',),
'hildende': ('hilde',),
'hildet': ('hilde',),
'hildete': ('hilde',),
'hildra': ('hildre',),
'hildrede': ('hildre',),
'hildrende': ('hildre',),
'hildret': ('hildre',),
'hildrete': ('hildre',),
'hilsende': ('hilse',),
'hilst': ('hilse',),
'hilste': ('hilse',),
'hilsende': ('hilse',),
'hilst': ('hilse',),
'hilste': ('hilse',),
'himla': ('himle',),
'himlede': ('himle',),
'himlende': ('himle',),
'himlet': ('himle',),
'himlete': ('himle',),
'himla': ('himle',),
'himlede': ('himle',),
'himlende': ('himle',),
'himlet': ('himle',),
'himlete': ('himle',),
'himmelblå': ('himmelblå',),
'himmelblåe': ('himmelblå',),
'himmelblåere': ('himmelblå',),
'himmelblåest': ('himmelblå',),
'himmelblåeste': ('himmelblå',),
'himmelblått': ('himmelblå',),
'himmelfallen': ('himmelfallen',),
'himmelfallent': ('himmelfallen',),
'himmelfalne': ('himmelfallen',),
'himmelfalnere': ('himmelfallen',),
'himmelfalnest': ('himmelfallen',),
'himmelfalneste': ('himmelfallen',),
'himmelhenrykt': ('himmelhenrykt',),
'himmelhenrykte': ('himmelhenrykt',),
'himmelhenryktere': ('himmelhenrykt',),
'himmelhenryktest': ('himmelhenrykt',),
'himmelhenrykteste': ('himmelhenrykt',),
'himmelhøg': ('himmelhøg',),
'himmelhøge': ('himmelhøg',),
'himmelhøgere': ('himmelhøg',),
'himmelhøgest': ('himmelhøg',),
'himmelhøgeste': ('himmelhøg',),
'himmelhøgre': ('himmelhøg',),
'himmelhøgst': ('himmelhøg',),
'himmelhøgste': ('himmelhøg',),
'himmelhøgt': ('himmelhøg',),
'himmelhøy': ('himmelhøy',),
'himmelhøye': ('himmelhøy',),
'himmelhøyere': ('himmelhøy',),
'himmelhøyest': ('himmelhøy',),
'himmelhøyeste': ('himmelhøy',),
'himmelhøyt': ('himmelhøy',),
'himmelropende': ('himmelropende',),
'himmelsk': ('himmelsk',),
'himmelske': ('himmelsk',),
'himmelskere': ('himmelsk',),
'himmelskest': ('himmelsk',),
'himmelskeste': ('himmelsk',),
'himmelstormende': ('himmelstormende',),
'himmelvid': ('himmelvid',),
'himmelvide': ('himmelvid',),
'himmelvidere': ('himmelvid',),
'himmelvidest': ('himmelvid',),
'himmelvideste': ('himmelvid',),
'himmelvidt': ('himmelvid',),
'hindra': ('hindre',),
'hindrede': ('hindre',),
'hindrende': ('hindre',),
'hindret': ('hindre',),
'hindrete': ('hindre',),
'hinduisk': ('hinduisk',),
'hinduiske': ('hinduisk',),
'hinduiskere': ('hinduisk',),
'hinduiskest': ('hinduisk',),
'hinduiskeste': ('hinduisk',),
'hinduistisk': ('hinduistisk',),
'hinduistiske': ('hinduistisk',),
'hinduistiskere': ('hinduistisk',),
'hinduistiskest': ('hinduistisk',),
'hinduistiskeste': ('hinduistisk',),
'hindustansk': ('hindustansk',),
'hindustanske': ('hindustansk',),
'hindustanskere': ('hindustansk',),
'hindustanskest': ('hindustansk',),
'hindustanskeste': ('hindustansk',),
'hingstegal': ('hingstegal',),
'hingstegale': ('hingstegal',),
'hingstegalere': ('hingstegal',),
'hingstegalest': ('hingstegal',),
'hingstegaleste': ('hingstegal',),
'hingstegalt': ('hingstegal',),
'hingstgal': ('hingstgal',),
'hingstgale': ('hingstgal',),
'hingstgalere': ('hingstgal',),
'hingstgalest': ('hingstgal',),
'hingstgaleste': ('hingstgal',),
'hingstgalt': ('hingstgal',),
'hinka': ('hinke',),
'hinkede': ('hinke',),
'hinkende': ('hinke',),
'hinket': ('hinke',),
'hinkete': ('hinke',),
'hinnet': ('hinnet',),
'hinnete': ('hinnet',),
'hinnetere': ('hinnet',),
'hinnetest': ('hinnet',),
'hinneteste': ('hinnet',),
'hinnete': ('hinnete',),
'hinsidig': ('hinsidig',),
'hinsidige': ('hinsidig',),
'hinsidigere': ('hinsidig',),
'hinsidigst': ('hinsidig',),
'hinsidigste': ('hinsidig',),
'hipa': ('hipe',),
'hipede': ('hipe',),
'hipende': ('hipe',),
'hipet': ('hipe',),
'hipete': ('hipe',),
'hipt': ('hipe',),
'hipte': ('hipe',),
'hipp': ('hipp',),
'hippe': ('hipp',),
'hippere': ('hipp',),
'hippest': ('hipp',),
'hippeste': ('hipp',),
'hipt': ('hipp',),
'hipne': ('hippen',),
'hipnere': ('hippen',),
'hipnest': ('hippen',),
'hipneste': ('hippen',),
'hippen': ('hippen',),
'hippent': ('hippen',),
'hirende': ('hire',),
'hirt': ('hire',),
'hirte': ('hire',),
'hiren': ('hiren',),
'hirent': ('hiren',),
'hirne': ('hiren',),
'hirnere': ('hiren',),
'hirnest': ('hiren',),
'hirneste': ('hiren',),
'hissa': ('hisse',),
'hissede': ('hisse',),
'hissende': ('hisse',),
'hisset': ('hisse',),
'hissete': ('hisse',),
'hissig': ('hissig',),
'hissige': ('hissig',),
'hissigere': ('hissig',),
'hissigst': ('hissig',),
'hissigste': ('hissig',),
'historiografisk': ('historiografisk',),
'historiografiske': ('historiografisk',),
'historiografiskere': ('historiografisk',),
'historiografiskest': ('historiografisk',),
'historiografiskeste': ('historiografisk',),
'historisk': ('historisk',),
'historiske': ('historisk',),
'historiskere': ('historisk',),
'historiskest': ('historisk',),
'historiskeste': ('historisk',),
'hithørende': ('hithørende',),
'hitre': ('hitre',),
'hitterst': ('hitre',),
'hitterste': ('hitre',),
'hitsatt': ('hitsette',),
'hitsatte': ('hitsette',),
'hitsettende': ('hitsette',),
'hitta': ('hitte',),
'hittede': ('hitte',),
'hittende': ('hitte',),
'hittet': ('hitte',),
'hittete': ('hitte',),
'hitterst': ('hitterst',),
'hitterste': ('hitterst',),
'hivd': ('hive',),
'hivde': ('hive',),
'hivende': ('hive',),
'hjelpende': ('hjelpe',),
'hjulpen': ('hjelpe',),
'hjulpet': ('hjelpe',),
'hjulpne': ('hjelpe',),
'hjelpelaus': ('hjelpelaus',),
'hjelpelause': ('hjelpelaus',),
'hjelpelausere': ('hjelpelaus',),
'hjelpelausest': ('hjelpelaus',),
'hjelpelauseste': ('hjelpelaus',),
'hjelpelaust': ('hjelpelaus',),
'hjelpeløs': ('hjelpeløs',),
'hjelpeløse': ('hjelpeløs',),
'hjelpeløsere': ('hjelpeløs',),
'hjelpeløsest': ('hjelpeløs',),
'hjelpeløseste': ('hjelpeløs',),
'hjelpeløst': ('hjelpeløs',),
'hjelpetrengende': ('hjelpetrengende',),
'hjelpsom': ('hjelpsom',),
'hjelpsomme': ('hjelpsom',),
'hjelpsommere': ('hjelpsom',),
'hjelpsomst': ('hjelpsom',),
'hjelpsomste': ('hjelpsom',),
'hjelpsomt': ('hjelpsom',),
'hjemfallende': ('hjemfalle',),
'hjemfalt': ('hjemfalle',),
'hjemfalte': ('hjemfalle',),
'hjemfallen': ('hjemfallen',),
'hjemfallent': ('hjemfallen',),
'hjemfalne': ('hjemfallen',),
'hjemfalnere': ('hjemfallen',),
'hjemfalnest': ('hjemfallen',),
'hjemfalneste': ('hjemfallen',),
'hjemfesta': ('hjemfeste',),
'hjemfestede': ('hjemfeste',),
'hjemfestende': ('hjemfeste',),
'hjemfestet': ('hjemfeste',),
'hjemfestete': ('hjemfeste',),
'hjemførende': ('hjemføre',),
'hjemført': ('hjemføre',),
'hjemførte': ('hjemføre',),
'hjemkallende': ('hjemkalle',),
'hjemkalt': ('hjemkalle',),
'hjemkalte': ('hjemkalle',),
'hjemkommet': ('hjemkommet',),
'hjemkomne': ('hjemkommet',),
'hjemkomnere': ('hjemkommet',),
'hjemkomnest': ('hjemkommet',),
'hjemkomneste': ('hjemkommet',),
'hjemlaus': ('hjemlaus',),
'hjemlause': ('hjemlaus',),
'hjemlausere': ('hjemlaus',),
'hjemlausest': ('hjemlaus',),
'hjemlauseste': ('hjemlaus',),
'hjemlaust': ('hjemlaus',),
'hjemla': ('hjemle',),
'hjemlede': ('hjemle',),
'hjemlende': ('hjemle',),
'hjemlet': ('hjemle',),
'hjemlete': ('hjemle',),
'hjemlig': ('hjemlig',),
'hjemlige': ('hjemlig',),
'hjemligere': ('hjemlig',),
'hjemligst': ('hjemlig',),
'hjemligste': ('hjemlig',),
'hjemløs': ('hjemløs',),
'hjemløse': ('hjemløs',),
'hjemløsere': ('hjemløs',),
'hjemløsest': ('hjemløs',),
'hjemløseste': ('hjemløs',),
'hjemløst': ('hjemløs',),
'hjemmearbeidende': ('hjemmearbeidende',),
'hjemmeavla': ('hjemmeavla',),
'hjemmeavlede': ('hjemmeavlet',),
'hjemmeavlet': ('hjemmeavlet',),
'hjemmeavlete': ('hjemmeavlet',),
'hjemmeavletere': ('hjemmeavlet',),
'hjemmeavletest': ('hjemmeavlet',),
'hjemmeavleteste': ('hjemmeavlet',),
'hjemmegjort': ('hjemmegjort',),
'hjemmegjorte': ('hjemmegjort',),
'hjemmegjortere': ('hjemmegjort',),
'hjemmegjortest': ('hjemmegjort',),
'hjemmegjorteste': ('hjemmegjort',),
'hjemmehørende': ('hjemmehørende',),
'hjemmekjent': ('hjemmekjent',),
'hjemmekjente': ('hjemmekjent',),
'hjemmekjentere': ('hjemmekjent',),
'hjemmekjentest': ('hjemmekjent',),
'hjemmekjenteste': ('hjemmekjent',),
'hjemmekjær': ('hjemmekjær',),
'hjemmekjære': ('hjemmekjær',),
'hjemmekjærere': ('hjemmekjær',),
'hjemmekjærest': ('hjemmekjær',),
'hjemmekjæreste': ('hjemmekjær',),
'hjemmekjært': ('hjemmekjær',),
'hjemmekoselig': ('hjemmekoselig',),
'hjemmekoselige': ('hjemmekoselig',),
'hjemmekoseligere': ('hjemmekoselig',),
'hjemmekoseligst': ('hjemmekoselig',),
'hjemmekoseligste': ('hjemmekoselig',),
'hjemmelaga': ('hjemmelaga',),
'hjemmelagd': ('hjemmelagd',),
'hjemmelagde': ('hjemmelagd',),
'hjemmelagdere': ('hjemmelagd',),
'hjemmelagdest': ('hjemmelagd',),
'hjemmelagdeste': ('hjemmelagd',),
'hjemmelagede': ('hjemmelaget',),
'hjemmelaget': ('hjemmelaget',),
'hjemmelagete': ('hjemmelaget',),
'hjemmelagetere': ('hjemmelaget',),
'hjemmelagetest': ('hjemmelaget',),
'hjemmelageteste': ('hjemmelaget',),
'hjemmestrikka': ('hjemmestrikka',),
'hjemmestrikkede': ('hjemmestrikket',),
'hjemmestrikket': ('hjemmestrikket',),
'hjemmestrikkete': ('hjemmestrikket',),
'hjemmestrikketere': ('hjemmestrikket',),
'hjemmestrikketest': ('hjemmestrikket',),
'hjemmestrikketeste': ('hjemmestrikket',),
'hjemmevant': ('hjemmevant',),
'hjemmevante': ('hjemmevant',),
'hjemmevantere': ('hjemmevant',),
'hjemmevantest': ('hjemmevant',),
'hjemmevanteste': ('hjemmevant',),
'hjemmeværende': ('hjemmeværende',),
'hjemsendende': ('hjemsende',),
'hjemsendt': ('hjemsende',),
'hjemsendte': ('hjemsende',),
'hjemstavnsberettiga': ('hjemstavnsberettiga',),
'hjemstavnsberettigede': ('hjemstavnsberettiget',),
'hjemstavnsberettiget': ('hjemstavnsberettiget',),
'hjemstavnsberettigete': ('hjemstavnsberettiget',),
'hjemstavnsberettigetere': ('hjemstavnsberettiget',),
'hjemstavnsberettigetest': ('hjemstavnsberettiget',),
'hjemstavnsberettigeteste': ('hjemstavnsberettiget',),
'hjemsøkende': ('hjemsøke',),
'hjemsøkt': ('hjemsøke',),
'hjemsøkte': ('hjemsøke',),
'hjemvendt': ('hjemvendt',),
'hjemvendte': ('hjemvendt',),
'hjemvendtere': ('hjemvendt',),
'hjemvendtest': ('hjemvendt',),
'hjemvendteste': ('hjemvendt',),
'hjernedød': ('hjernedød',),
'hjernedøde': ('hjernedød',),
'hjernedødere': ('hjernedød',),
'hjernedødest': ('hjernedød',),
'hjernedødeste': ('hjernedød',),
'hjernedødt': ('hjernedød',),
'hjernevaska': ('hjernevaske',),
'hjernevaskede': ('hjernevaske',),
'hjernevaskende': ('hjernevaske',),
'hjernevasket': ('hjernevaske',),
'hjernevaskete': ('hjernevaske',),
'hjerta': ('hjerta',),
'hjerteforma': ('hjerteforma',),
'hjerteformede': ('hjerteformet',),
'hjerteformet': ('hjerteformet',),
'hjerteformete': ('hjerteformet',),
'hjerteformetere': ('hjerteformet',),
'hjerteformetest': ('hjerteformet',),
'hjerteformeteste': ('hjerteformet',),
'hjertebedre': ('hjertegod',),
'hjertebest': ('hjertegod',),
'hjertebeste': ('hjertegod',),
'hjertegod': ('hjertegod',),
'hjertegode': ('hjertegod',),
'hjertegodt': ('hjertegod',),
'hjertelaus': ('hjertelaus',),
'hjertelause': ('hjertelaus',),
'hjertelausere': ('hjertelaus',),
'hjertelausest': ('hjertelaus',),
'hjertelauseste': ('hjertelaus',),
'hjertelaust': ('hjertelaus',),
'hjertelig': ('hjertelig',),
'hjertelige': ('hjertelig',),
'hjerteligere': ('hjertelig',),
'hjerteligst': ('hjertelig',),
'hjerteligste': ('hjertelig',),
'hjerteløs': ('hjerteløs',),
'hjerteløse': ('hjerteløs',),
'hjerteløsere': ('hjerteløs',),
'hjerteløsest': ('hjerteløs',),
'hjerteløseste': ('hjerteløs',),
'hjerteløst': ('hjerteløs',),
'hjertens': ('hjertens',),
'hjerterå': ('hjerterå',),
'hjerteråe': ('hjerterå',),
'hjerteråere': ('hjerterå',),
'hjerteråest': ('hjerterå',),
'hjerteråeste': ('hjerterå',),
'hjerterått': ('hjerterå',),
'hjerteskjærende': ('hjerteskjærende',),
'hjertevarm': ('hjertevarm',),
'hjertevarme': ('hjertevarm',),
'hjertevarmere': ('hjertevarm',),
'hjertevarmest': ('hjertevarm',),
'hjertevarmeste': ('hjertevarm',),
'hjertevarmt': ('hjertevarm',),
'hjonslig': ('hjonslig',),
'hjonslige': ('hjonslig',),
'hjonsligere': ('hjonslig',),
'hjonsligst': ('hjonslig',),
'hjonsligste': ('hjonslig',),
'hjulbeint': ('hjulbeint',),
'hjulbeinte': ('hjulbeint',),
'hjulbeintere': ('hjulbeint',),
'hjulbeintest': ('hjulbeint',),
'hjulbeinteste': ('hjulbeint',),
'hjulbent': ('hjulbent',),
'hjulbente': ('hjulbent',),
'hjulbentere': ('hjulbent',),
'hjulbentest': ('hjulbent',),
'hjulbenteste': ('hjulbent',),
'hjulpen': ('hjulpen',),
'hjulpent': ('hjulpen',),
'hjulpne': ('hjulpen',),
'hjulpnere': ('hjulpen',),
'hjulpnest': ('hjulpen',),
'hjulpneste': ('hjulpen',),
'hodegal': ('hodegal',),
'hodegale': ('hodegal',),
'hodegalere': ('hodegal',),
'hodegalest': ('hodegal',),
'hodegaleste': ('hodegal',),
'hodegalt': ('hodegal',),
'hodegalen': ('hodegalen',),
'hodegalent': ('hodegalen',),
'hodegalne': ('hodegalen',),
'hodegalnere': ('hodegalen',),
'hodegalnest': ('hodegalen',),
'hodegalneste': ('hodegalen',),
'hoderystende': ('hoderystende',),
'hofferda': ('hofferde',),
'hofferdede': ('hofferde',),
'hofferdende': ('hofferde',),
'hofferdet': ('hofferde',),
'hofferdete': ('hofferde',),
'hofferdig': ('hofferdig',),
'hofferdige': ('hofferdig',),
'hofferdigere': ('hofferdig',),
'hofferdigst': ('hofferdig',),
'hofferdigste': ('hofferdig',),
'hoggbratt': ('hoggbratt',),
'hoggbratte': ('hoggbratt',),
'hoggbrattere': ('hoggbratt',),
'hoggbrattest': ('hoggbratt',),
'hoggbratteste': ('hoggbratt',),
'hogstmoden': ('hogstmoden',),
'hogstmodent': ('hogstmoden',),
'hogstmodne': ('hogstmoden',),
'hogstmodnere': ('hogstmoden',),
'hogstmodnest': ('hogstmoden',),
'hogstmodneste': ('hogstmoden',),
'hoia': ('hoie',),
'hoiede': ('hoie',),
'hoiende': ('hoie',),
'hoiet': ('hoie',),
'hoiete': ('hoie',),
'hol': ('hol',),
'hole': ('hol',),
'holere': ('hol',),
'holest': ('hol',),
'holeste': ('hol',),
'holt': ('hol',),
'holdbar': ('holdbar',),
'holdbare': ('holdbar',),
'holdbarere': ('holdbar',),
'holdbarest': ('holdbar',),
'holdbareste': ('holdbar',),
'holdbart': ('holdbar',),
'holdende': ('holde',),
'holdt': ('holde',),
'holdte': ('holde',),
'holden': ('holden',),
'holdent': ('holden',),
'holdne': ('holden',),
'holdnere': ('holden',),
'holdnest': ('holden',),
'holdneste': ('holden',),
'holdningslaus': ('holdningslaus',),
'holdningslause': ('holdningslaus',),
'holdningslausere': ('holdningslaus',),
'holdningslausest': ('holdningslaus',),
'holdningslauseste': ('holdningslaus',),
'holdningslaust': ('holdningslaus',),
'holdningsløs': ('holdningsløs',),
'holdningsløse': ('holdningsløs',),
'holdningsløsere': ('holdningsløs',),
'holdningsløsest': ('holdningsløs',),
'holdningsløseste': ('holdningsløs',),
'holdningsløst': ('holdningsløs',),
'holdningsskapende': ('holdningsskapende',),
'holende': ('hole',),
'holt': ('hole',),
'holte': ('hole',),
'holet': ('holet',),
'holete': ('holet',),
'holetere': ('holet',),
'holetest': ('holet',),
'holeteste': ('holet',),
'holete': ('holete',),
'holka': ('holke',),
'holkede': ('holke',),
'holkende': ('holke',),
'holket': ('holke',),
'holkete': ('holke',),
'holkinna': ('holkinna',),
'holkinnede': ('holkinnet',),
'holkinnet': ('holkinnet',),
'holkinnete': ('holkinnet',),
'holkinnetere': ('holkinnet',),
'holkinnetest': ('holkinnet',),
'holkinneteste': ('holkinnet',),
'hollandsk': ('hollandsk',),
'hollandske': ('hollandsk',),
'hollandskere': ('hollandsk',),
'hollandskest': ('hollandsk',),
'hollandskeste': ('hollandsk',),
'holna': ('holne',),
'holnede': ('holne',),
'holnende': ('holne',),
'holnet': ('holne',),
'holnete': ('holne',),
'holograf': ('holograf',),
'holografe': ('holograf',),
'holografere': ('holograf',),
'holografest': ('holograf',),
'holografeste': ('holograf',),
'holograft': ('holograf',),
'holografisk': ('holografisk',),
'holografiske': ('holografisk',),
'holografiskere': ('holografisk',),
'holografiskest': ('holografisk',),
'holografiskeste': ('holografisk',),
'holsteinsk': ('holsteinsk',),
'holsteinske': ('holsteinsk',),
'holsteinskere': ('holsteinsk',),
'holsteinskest': ('holsteinsk',),
'holsteinskeste': ('holsteinsk',),
'holøyd': ('holøyd',),
'holøyde': ('holøyd',),
'holøydere': ('holøyd',),
'holøydest': ('holøyd',),
'holøydeste': ('holøyd',),
'homerisk': ('homerisk',),
'homeriske': ('homerisk',),
'homeriskere': ('homerisk',),
'homeriskest': ('homerisk',),
'homeriskeste': ('homerisk',),
'homiletisk': ('homiletisk',),
'homiletiske': ('homiletisk',),
'homiletiskere': ('homiletisk',),
'homiletiskest': ('homiletisk',),
'homiletiskeste': ('homiletisk',),
'homma': ('homme',),
'hommede': ('homme',),
'hommende': ('homme',),
'hommet': ('homme',),
'hommete': ('homme',),
'homo': ('homo',),
'homofil': ('homofil',),
'homofile': ('homofil',),
'homofilere': ('homofil',),
'homofilest': ('homofil',),
'homofileste': ('homofil',),
'homofilt': ('homofil',),
'homofon': ('homofon',),
'homofone': ('homofon',),
'homofonere': ('homofon',),
'homofonest': ('homofon',),
'homofoneste': ('homofon',),
'homofont': ('homofon',),
'homogen': ('homogen',),
'homogene': ('homogen',),
'homogenere': ('homogen',),
'homogenest': ('homogen',),
'homogeneste': ('homogen',),
'homogent': ('homogen',),
'homogeniserende': ('homogenisere',),
'homogenisert': ('homogenisere',),
'homogeniserte': ('homogenisere',),
'homonym': ('homonym',),
'homonyme': ('homonym',),
'homonymere': ('homonym',),
'homonymest': ('homonym',),
'homonymeste': ('homonym',),
'homonymt': ('homonym',),
'homoseksuell': ('homoseksuell',),
'homoseksuelle': ('homoseksuell',),
'homoseksuellere': ('homoseksuell',),
'homoseksuellest': ('homoseksuell',),
'homoseksuelleste': ('homoseksuell',),
'homoseksuelt': ('homoseksuell',),
'homøopatisk': ('homøopatisk',),
'homøopatiske': ('homøopatisk',),
'homøopatiskere': ('homøopatisk',),
'homøopatiskest': ('homøopatisk',),
'homøopatiskeste': ('homøopatisk',),
'honduransk': ('honduransk',),
'honduranske': ('honduransk',),
'honduranskere': ('honduransk',),
'honduranskest': ('honduransk',),
'honduranskeste': ('honduransk',),
'honnett': ('honnett',),
'honnette': ('honnett',),
'honnettere': ('honnett',),
'honnettest': ('honnett',),
'honnetteste': ('honnett',),
'honninggjømmende': ('honninggjømme',),
'honninggjømt': ('honninggjømme',),
'honninggjømte': ('honninggjømme',),
'honningsøt': ('honningsøt',),
'honningsøte': ('honningsøt',),
'honningsøtere': ('honningsøt',),
'honningsøtest': ('honningsøt',),
'honningsøteste': ('honningsøt',),
'honningsøtt': ('honningsøt',),
'honorabel': ('honorabel',),
'honorabelt': ('honorabel',),
'honorable': ('honorabel',),
'honorablere': ('honorabel',),
'honorablest': ('honorabel',),
'honorableste': ('honorabel',),
'honorerende': ('honorere',),
'honorert': ('honorere',),
'honorerte': ('honorere',),
'honorær': ('honorær',),
'honorære': ('honorær',),
'honorærere': ('honorær',),
'honorærest': ('honorær',),
'honoræreste': ('honorær',),
'honorært': ('honorær',),
'hopa': ('hope',),
'hopede': ('hope',),
'hopende': ('hope',),
'hopet': ('hope',),
'hopete': ('hope',),
'hopa': ('hope',),
'hopede': ('hope',),
'hopende': ('hope',),
'hopet': ('hope',),
'hopete': ('hope',),
'hoppa': ('hoppe',),
'hoppede': ('hoppe',),
'hoppende': ('hoppe',),
'hoppet': ('hoppe',),
'hoppete': ('hoppe',),
'hora': ('hore',),
'horede': ('hore',),
'horende': ('hore',),
'horet': ('hore',),
'horete': ('hore',),
'hort': ('hore',),
'horte': ('hore',),
'horisontal': ('horisontal',),
'horisontale': ('horisontal',),
'horisontalere': ('horisontal',),
'horisontalest': ('horisontal',),
'horisontaleste': ('horisontal',),
'horisontalt': ('horisontal',),
'horisontaldelt': ('horisontaldelt',),
'horisontaldelte': ('horisontaldelt',),
'horisontaldeltere': ('horisontaldelt',),
'horisontaldeltest': ('horisontaldelt',),
'horisontaldelteste': ('horisontaldelt',),
'hormonal': ('hormonal',),
'hormonale': ('hormonal',),
'hormonalere': ('hormonal',),
'hormonalest': ('hormonal',),
'hormonaleste': ('hormonal',),
'hormonalt': ('hormonal',),
'hormonell': ('hormonell',),
'hormonelle': ('hormonell',),
'hormonellere': ('hormonell',),
'hormonellest': ('hormonell',),
'hormonelleste': ('hormonell',),
'hormonelt': ('hormonell',),
'hornet': ('hornet',),
'hornete': ('hornet',),
'hornetere': ('hornet',),
'hornetest': ('hornet',),
'horneteste': ('hornet',),
'hornete': ('hornete',),
'horribel': ('horribel',),
'horribelt': ('horribel',),
'horrible': ('horribel',),
'horriblere': ('horribel',),
'horriblest': ('horribel',),
'horribleste': ('horribel',),
'horsa': ('horse',),
'horsede': ('horse',),
'horsende': ('horse',),
'horset': ('horse',),
'horsete': ('horse',),
'hosliggende': ('hosliggende',),
'hospitaliserende': ('hospitalisere',),
'hospitalisert': ('hospitalisere',),
'hospitaliserte': ('hospitalisere',),
'hospiterende': ('hospitere',),
'hospitert': ('hospitere',),
'hospiterte': ('hospitere',),
'hosstående': ('hosstående',),
'hosta': ('hoste',),
'hostede': ('hoste',),
'hostende': ('hoste',),
'hostet': ('hoste',),
'hostete': ('hoste',),
'hota': ('hote',),
'hotede': ('hote',),
'hotende': ('hote',),
'hotet': ('hote',),
'hotete': ('hote',),
'hottentottisk': ('hottentottisk',),
'hottentottiske': ('hottentottisk',),
'hottentottiskere': ('hottentottisk',),
'hottentottiskest': ('hottentottisk',),
'hottentottiskeste': ('hottentottisk',),
'hovedsakelig': ('hovedsakelig',),
'hovedsakelige': ('hovedsakelig',),
'hovedsakeligere': ('hovedsakelig',),
'hovedsakeligst': ('hovedsakelig',),
'hovedsakeligste': ('hovedsakelig',),
'hoven': ('hoven',),
'hovent': ('hoven',),
'hovne': ('hoven',),
'hovnere': ('hoven',),
'hovnest': ('hoven',),
'hovneste': ('hoven',),
'hoverende': ('hovere',),
'hovert': ('hovere',),
'hoverte': ('hovere',),
'hovmestererende': ('hovmesterere',),
'hovmesterert': ('hovmesterere',),
'hovmestererte': ('hovmesterere',),
'hovmoda': ('hovmode',),
'hovmodede': ('hovmode',),
'hovmodende': ('hovmode',),
'hovmodet': ('hovmode',),
'hovmodete': ('hovmode',),
'hovmodig': ('hovmodig',),
'hovmodige': ('hovmodig',),
'hovmodigere': ('hovmodig',),
'hovmodigst': ('hovmodig',),
'hovmodigste': ('hovmodig',),
'hovna': ('hovne',),
'hovnede': ('hovne',),
'hovnende': ('hovne',),
'hovnet': ('hovne',),
'hovnete': ('hovne',),
'hudfletta': ('hudflette',),
'hudflettede': ('hudflette',),
'hudflettende': ('hudflette',),
'hudflettet': ('hudflette',),
'hudflettete': ('hudflette',),
'hudlaus': ('hudlaus',),
'hudlause': ('hudlaus',),
'hudlausere': ('hudlaus',),
'hudlausest': ('hudlaus',),
'hudlauseste': ('hudlaus',),
'hudlaust': ('hudlaus',),
'hudløs': ('hudløs',),
'hudløse': ('hudløs',),
'hudløsere': ('hudløs',),
'hudløsest': ('hudløs',),
'hudløseste': ('hudløs',),
'hudløst': ('hudløs',),
'hudstrykende': ('hudstryke',),
'hudstrøken': ('hudstryke',),
'hudstrøket': ('hudstryke',),
'hudstrøkne': ('hudstryke',),
'huegæren': ('huegæren',),
'huegærent': ('huegæren',),
'huegærne': ('huegæren',),
'huegærnere': ('huegæren',),
'huegærnest': ('huegæren',),
'huegærneste': ('huegæren',),
'hufsa': ('hufse',),
'hufsede': ('hufse',),
'hufsende': ('hufse',),
'hufset': ('hufse',),
'hufsete': ('hufse',),
'huga': ('huga',),
'hugal': ('hugal',),
'hugale': ('hugal',),
'hugalere': ('hugal',),
'hugalest': ('hugal',),
'hugaleste': ('hugal',),
'hugalt': ('hugal',),
'huga': ('huge',),
'hugede': ('huge',),
'hugende': ('huge',),
'huget': ('huge',),
'hugete': ('huge',),
'hugheil': ('hugheil',),
'hugheile': ('hugheil',),
'hugheilere': ('hugheil',),
'hugheilest': ('hugheil',),
'hugheileste': ('hugheil',),
'hugheilt': ('hugheil',),
'hugnadsam': ('hugnadsam',),
'hugnadsame': ('hugnadsam',),
'hugnadsamere': ('hugnadsam',),
'hugnadsamest': ('hugnadsam',),
'hugnadsameste': ('hugnadsam',),
'hugnadsamt': ('hugnadsam',),
'hugsa': ('hugse',),
'hugsede': ('hugse',),
'hugsende': ('hugse',),
'hugset': ('hugse',),
'hugsete': ('hugse',),
'hugstmoden': ('hugstmoden',),
'hugstmodent': ('hugstmoden',),
'hugstmodne': ('hugstmoden',),
'hugstmodnere': ('hugstmoden',),
'hugstmodnest': ('hugstmoden',),
'hugstmodneste': ('hugstmoden',),
'hugsvala': ('hugsvale',),
'hugsvalede': ('hugsvale',),
'hugsvalende': ('hugsvale',),
'hugsvalet': ('hugsvale',),
'hugsvalete': ('hugsvale',),
'hugsvalt': ('hugsvale',),
'hugsvalte': ('hugsvale',),
'hugtakende': ('hugta',),
'hugtatt': ('hugta',),
'hugtatte': ('hugta',),
'hugæren': ('hugæren',),
'hugærent': ('hugæren',),
'hugærne': ('hugæren',),
'hugærnere': ('hugæren',),
'hugærnest': ('hugæren',),
'hugærneste': ('hugæren',),
'huia': ('huie',),
'huiede': ('huie',),
'huiende': ('huie',),
'huiet': ('huie',),
'huiete': ('huie',),
'huka': ('huke',),
'hukede': ('huke',),
'hukende': ('huke',),
'huket': ('huke',),
'hukete': ('huke',),
'hukt': ('huke',),
'hukte': ('huke',),
'huka': ('huke',),
'hukede': ('huke',),
'hukende': ('huke',),
'huket': ('huke',),
'hukete': ('huke',),
'hukt': ('huke',),
'hukte': ('huke',),
'hukra': ('hukre',),
'hukrede': ('hukre',),
'hukrende': ('hukre',),
'hukret': ('hukre',),
'hukrete': ('hukre',),
'huksittende': ('huksittende',),
'hul': ('hul',),
'hule': ('hul',),
'hulere': ('hul',),
'hulest': ('hul',),
'huleste': ('hul',),
'hult': ('hul',),
'hulbrysta': ('hulbrysta',),
'hulbrystede': ('hulbrystet',),
'hulbrystet': ('hulbrystet',),
'hulbrystete': ('hulbrystet',),
'hulbrystetere': ('hulbrystet',),
'hulbrystetest': ('hulbrystet',),
'hulbrysteteste': ('hulbrystet',),
'huldren': ('huldren',),
'huldrene': ('huldren',),
'huldrenere': ('huldren',),
'huldrenest': ('huldren',),
'huldreneste': ('huldren',),
'huldrent': ('huldren',),
'huldrne': ('huldren',),
'huldrnere': ('huldren',),
'huldrnest': ('huldren',),
'huldrneste': ('huldren',),
'hula': ('hule',),
'hulede': ('hule',),
'hulende': ('hule',),
'hulet': ('hule',),
'hulete': ('hule',),
'hult': ('hule',),
'hulte': ('hule',),
'hulka': ('hulke',),
'hulkede': ('hulke',),
'hulkende': ('hulke',),
'hulket': ('hulke',),
'hulkete': ('hulke',),
'hulkinna': ('hulkinna',),
'hulkinnede': ('hulkinnet',),
'hulkinnet': ('hulkinnet',),
'hulkinnete': ('hulkinnet',),
'hulkinnetere': ('hulkinnet',),
'hulkinnetest': ('hulkinnet',),
'hulkinneteste': ('hulkinnet',),
'hull': ('hull',),
'hulle': ('hull',),
'hullere': ('hull',),
'hullest': ('hull',),
'hulleste': ('hull',),
'hult': ('hull',),
'hulla': ('hulle',),
'hullede': ('hulle',),
'hullende': ('hulle',),
'hullet': ('hulle',),
'hullete': ('hulle',),
'hullet': ('hullet',),
'hullete': ('hullet',),
'hulletere': ('hullet',),
'hulletest': ('hullet',),
'hulleteste': ('hullet',),
'hullete': ('hullete',),
'huløyd': ('huløyd',),
'huløyde': ('huløyd',),
'huløydere': ('huløyd',),
'huløydest': ('huløyd',),
'huløydeste': ('huløyd',),
'human': ('human',),
'humane': ('human',),
'humanere': ('human',),
'humanest': ('human',),
'humaneste': ('human',),
'humant': ('human',),
'humanetisk': ('humanetisk',),
'humanetiske': ('humanetisk',),
'humanetiskere': ('humanetisk',),
'humanetiskest': ('humanetisk',),
'humanetiskeste': ('humanetisk',),
'humaniserende': ('humanisere',),
'humanisert': ('humanisere',),
'humaniserte': ('humanisere',),
'humanistisk': ('humanistisk',),
'humanistiske': ('humanistisk',),
'humanistiskere': ('humanistisk',),
'humanistiskest': ('humanistisk',),
'humanistiskeste': ('humanistisk',),
'humanitær': ('humanitær',),
'humanitære': ('humanitær',),
'humanitærere': ('humanitær',),
'humanitærest': ('humanitær',),
'humanitæreste': ('humanitær',),
'humanitært': ('humanitær',),
'humid': ('humid',),
'humide': ('humid',),
'humidere': ('humid',),
'humidest': ('humid',),
'humideste': ('humid',),
'humoral': ('humoral',),
'humorale': ('humoral',),
'humoralere': ('humoral',),
'humoralest': ('humoral',),
'humoraleste': ('humoral',),
'humoralt': ('humoral',),
'humoristisk': ('humoristisk',),
'humoristiske': ('humoristisk',),
'humoristiskere': ('humoristisk',),
'humoristiskest': ('humoristisk',),
'humoristiskeste': ('humoristisk',),
'humpa': ('humpe',),
'humpede': ('humpe',),
'humpende': ('humpe',),
'humpet': ('humpe',),
'humpete': ('humpe',),
'humpet': ('humpet',),
'humpete': ('humpet',),
'humpetere': ('humpet',),
'humpetest': ('humpet',),
'humpeteste': ('humpet',),
'humpete': ('humpete',),
'humra': ('humre',),
'humrede': ('humre',),
'humrende': ('humre',),
'humret': ('humre',),
'humrete': ('humre',),
'humørfylt': ('humørfylt',),
'humørfylte': ('humørfylt',),
'humørfyltere': ('humørfylt',),
'humørfyltest': ('humørfylt',),
'humørfylteste': ('humørfylt',),
'humørsjuk': ('humørsjuk',),
'humørsjuke': ('humørsjuk',),
'humørsjukere': ('humørsjuk',),
'humørsjukest': ('humørsjuk',),
'humørsjukeste': ('humørsjuk',),
'humørsjukt': ('humørsjuk',),
'humørsyk': ('humørsyk',),
'humørsyke': ('humørsyk',),
'humørsykere': ('humørsyk',),
'humørsykest': ('humørsyk',),
'humørsykeste': ('humørsyk',),
'humørsykt': ('humørsyk',),
'hundekald': ('hundekald',),
'hundekalde': ('hundekald',),
'hundekaldere': ('hundekald',),
'hundekaldest': ('hundekald',),
'hundekaldeste': ('hundekald',),
'hundekaldt': ('hundekald',),
'hundeldre': ('hundgammal',),
'hundeldst': ('hundgammal',),
'hundeldste': ('hundgammal',),
'hundgamle': ('hundgammal',),
'hundgammal': ('hundgammal',),
'hundgammalt': ('hundgammal',),
'hundeldre': ('hundgammel',),
'hundeldst': ('hundgammel',),
'hundeldste': ('hundgammel',),
'hundgamle': ('hundgammel',),
'hundgammel': ('hundgammel',),
'hundgammelt': ('hundgammel',),
'hundjaga': ('hundjage',),
'hundjagd': ('hundjage',),
'hundjagde': ('hundjage',),
'hundjagede': ('hundjage',),
'hundjagende': ('hundjage',),
'hundjaget': ('hundjage',),
'hundjagete': ('hundjage',),
'hundrede': ('hundrede',),
'hundretalls': ('hundretalls',),
'hundretals': ('hundretals',),
'hundreårig': ('hundreårig',),
'hundreårige': ('hundreårig',),
'hundreårigere': ('hundreårig',),
'hundreårigst': ('hundreårig',),
'hundreårigste': ('hundreårig',),
'hundreårs': ('hundreårs',),
'hundsa': ('hundse',),
'hundsede': ('hundse',),
'hundsende': ('hundse',),
'hundset': ('hundse',),
'hundsete': ('hundse',),
'hundsk': ('hundsk',),
'hundske': ('hundsk',),
'hundskere': ('hundsk',),
'hundskest': ('hundsk',),
'hundskeste': ('hundsk',),
'hungerramma': ('hungerramma',),
'hungerrammede': ('hungerrammet',),
'hungerrammet': ('hungerrammet',),
'hungerrammete': ('hungerrammet',),
'hungerrammetere': ('hungerrammet',),
'hungerrammetest': ('hungerrammet',),
'hungerrammeteste': ('hungerrammet',),
'hungra': ('hungre',),
'hungrede': ('hungre',),
'hungrende': ('hungre',),
'hungret': ('hungre',),
'hungrete': ('hungre',),
'hungrig': ('hungrig',),
'hungrige': ('hungrig',),
'hungrigere': ('hungrig',),
'hungrigst': ('hungrig',),
'hungrigste': ('hungrig',),
'hunisk': ('hunisk',),
'huniske': ('hunisk',),
'huniskere': ('hunisk',),
'huniskest': ('hunisk',),
'huniskeste': ('hunisk',),
'hunlig': ('hunlig',),
'hunlige': ('hunlig',),
'hunligere': ('hunlig',),
'hunligst': ('hunlig',),
'hunligste': ('hunlig',),
'hunnlig': ('hunnlig',),
'hunnlige': ('hunnlig',),
'hunnligere': ('hunnlig',),
'hunnligst': ('hunnlig',),
'hunnligste': ('hunnlig',),
'hurpa': ('hurpe',),
'hurpede': ('hurpe',),
'hurpende': ('hurpe',),
'hurpet': ('hurpe',),
'hurpete': ('hurpe',),
'hurpet': ('hurpet',),
'hurpete': ('hurpet',),
'hurpetere': ('hurpet',),
'hurpetest': ('hurpet',),
'hurpeteste': ('hurpet',),
'hurpete': ('hurpete',),
'hurra': ('hurre',),
'hurrede': ('hurre',),
'hurrende': ('hurre',),
'hurret': ('hurre',),
'hurrete': ('hurre',),
'hurtig': ('hurtig',),
'hurtige': ('hurtig',),
'hurtigere': ('hurtig',),
'hurtigst': ('hurtig',),
'hurtigste': ('hurtig',),
'hurtigarbeidende': ('hurtigarbeidende',),
'hurtiggående': ('hurtiggående',),
'husbankfinansierende': ('husbankfinansiere',),
'husbankfinansiert': ('husbankfinansiere',),
'husbankfinansierte': ('husbankfinansiere',),
'husa': ('huse',),
'husede': ('huse',),
'husende': ('huse',),
'huset': ('huse',),
'husete': ('huse',),
'hust': ('huse',),
'huste': ('huse',),
'huserende': ('husere',),
'husert': ('husere',),
'huserte': ('husere',),
'husholdende': ('husholde',),
'husholdt': ('husholde',),
'husholdte': ('husholde',),
'husholderende': ('husholdere',),
'husholdert': ('husholdere',),
'husholderte': ('husholdere',),
'husholdererende': ('husholderere',),
'husholderert': ('husholderere',),
'husholdererte': ('husholderere',),
'husittisk': ('husittisk',),
'husittiske': ('husittisk',),
'husittiskere': ('husittisk',),
'husittiskest': ('husittisk',),
'husittiskeste': ('husittisk',),
'huskald': ('huskald',),
'huskalde': ('huskald',),
'huskaldere': ('huskald',),
'huskaldest': ('huskald',),
'huskaldeste': ('huskald',),
'huskaldt': ('huskald',),
'huska': ('huske',),
'huskede': ('huske',),
'huskende': ('huske',),
'husket': ('huske',),
'huskete': ('huske',),
'huska': ('huske',),
'huskede': ('huske',),
'huskende': ('huske',),
'husket': ('huske',),
'huskete': ('huske',),
'huslaus': ('huslaus',),
'huslause': ('huslaus',),
'huslausere': ('huslaus',),
'huslausest': ('huslaus',),
'huslauseste': ('huslaus',),
'huslaust': ('huslaus',),
'huslaus': ('huslaus',),
'huslause': ('huslaus',),
'huslausere': ('huslaus',),
'huslausest': ('huslaus',),
'huslauseste': ('huslaus',),
'huslaust': ('huslaus',),
'huslig': ('huslig',),
'huslige': ('huslig',),
'husligere': ('huslig',),
'husligst': ('huslig',),
'husligste': ('huslig',),
'husløs': ('husløs',),
'husløse': ('husløs',),
'husløsere': ('husløs',),
'husløsest': ('husløs',),
'husløseste': ('husløs',),
'husløst': ('husløs',),
'hussøkende': ('hussøkende',),
'hustra': ('hustre',),
'hustrede': ('hustre',),
'hustrende': ('hustre',),
'hustret': ('hustre',),
'hustrete': ('hustre',),
'hustren': ('hustren',),
'hustrene': ('hustren',),
'hustrenere': ('hustren',),
'hustrenest': ('hustren',),
'hustreneste': ('hustren',),
'hustrent': ('hustren',),
'hustrne': ('hustren',),
'hustrnere': ('hustren',),
'hustrnest': ('hustren',),
'hustrneste': ('hustren',),
'hustrig': ('hustrig',),
'hustrige': ('hustrig',),
'hustrigere': ('hustrig',),
'hustrigst': ('hustrig',),
'hustrigste': ('hustrig',),
'husvalende': ('husvale',),
'husvalt': ('husvale',),
'husvalte': ('husvale',),
'husvarm': ('husvarm',),
'husvarme': ('husvarm',),
'husvarmere': ('husvarm',),
'husvarmest': ('husvarm',),
'husvarmeste': ('husvarm',),
'husvarmt': ('husvarm',),
'husvill': ('husvill',),
'husville': ('husvill',),
'husvillere': ('husvill',),
'husvillest': ('husvill',),
'husvilleste': ('husvill',),
'husvilt': ('husvill',),
'huta': ('hute',),
'hutede': ('hute',),
'hutende': ('hute',),
'hutet': ('hute',),
'hutete': ('hute',),
'hutra': ('hutre',),
'hutrede': ('hutre',),
'hutrende': ('hutre',),
'hutret': ('hutre',),
'hutrete': ('hutre',),
'hvass': ('hvass',),
'hvasse': ('hvass',),
'hvassere': ('hvass',),
'hvassest': ('hvass',),
'hvasseste': ('hvass',),
'hvast': ('hvass',),
'hvassøyd': ('hvassøyd',),
'hvassøyde': ('hvassøyd',),
'hvassøydere': ('hvassøyd',),
'hvassøydest': ('hvassøyd',),
'hvassøydeste': ('hvassøyd',),
'hvelva': ('hvelve',),
'hvelvede': ('hvelve',),
'hvelvende': ('hvelve',),
'hvelvet': ('hvelve',),
'hvelvete': ('hvelve',),
'hverdagslig': ('hverdagslig',),
'hverdagslige': ('hverdagslig',),
'hverdagsligere': ('hverdagslig',),
'hverdagsligst': ('hverdagslig',),
'hverdagsligste': ('hverdagslig',),
'hvesende': ('hvese',),
'hvest': ('hvese',),
'hveste': ('hvese',),
'hvessa': ('hvesse',),
'hvessede': ('hvesse',),
'hvessende': ('hvesse',),
'hvesset': ('hvesse',),
'hvessete': ('hvesse',),
'hvest': ('hvesse',),
'hveste': ('hvesse',),
'hvilende': ('hvile',),
'hvilt': ('hvile',),
'hvilte': ('hvile',),
'hvilelaus': ('hvilelaus',),
'hvilelause': ('hvilelaus',),
'hvilelausere': ('hvilelaus',),
'hvilelausest': ('hvilelaus',),
'hvilelauseste': ('hvilelaus',),
'hvilelaust': ('hvilelaus',),
'hvileløs': ('hvileløs',),
'hvileløse': ('hvileløs',),
'hvileløsere': ('hvileløs',),
'hvileløsest': ('hvileløs',),
'hvileløseste': ('hvileløs',),
'hvileløst': ('hvileløs',),
'hvinende': ('hvine',),
'hvint': ('hvine',),
'hvinte': ('hvine',),
'hviska': ('hviske',),
'hviskede': ('hviske',),
'hviskende': ('hviske',),
'hvisket': ('hviske',),
'hviskete': ('hviske',),
'hviska': ('hviske',),
'hviskede': ('hviske',),
'hviskende': ('hviske',),
'hvisket': ('hviske',),
'hviskete': ('hviske',),
'hvit': ('hvit',),
'hvite': ('hvit',),
'hvitere': ('hvit',),
'hvitest': ('hvit',),
'hviteste': ('hvit',),
'hvitt': ('hvit',),
'hvitbleik': ('hvitbleik',),
'hvitbleike': ('hvitbleik',),
'hvitbleikere': ('hvitbleik',),
'hvitbleikest': ('hvitbleik',),
'hvitbleikeste': ('hvitbleik',),
'hvitbleikt': ('hvitbleik',),
'hvitblek': ('hvitblek',),
'hvitbleke': ('hvitblek',),
'hvitblekere': ('hvitblek',),
'hvitblekest': ('hvitblek',),
'hvitblekeste': ('hvitblek',),
'hvitblekt': ('hvitblek',),
'hviterussisk': ('hviterussisk',),
'hviterussiske': ('hviterussisk',),
'hviterussiskere': ('hviterussisk',),
'hviterussiskest': ('hviterussisk',),
'hviterussiskeste': ('hviterussisk',),
'hvitglødende': ('hvitglødende',),
'hvithåra': ('hvithåra',),
'hvithårede': ('hvithåret',),
'hvithåret': ('hvithåret',),
'hvithårete': ('hvithåret',),
'hvithåretere': ('hvithåret',),
'hvithåretest': ('hvithåret',),
'hvithåreteste': ('hvithåret',),
'hvitkalka': ('hvitkalke',),
'hvitkalkede': ('hvitkalke',),
'hvitkalkende': ('hvitkalke',),
'hvitkalket': ('hvitkalke',),
'hvitkalkete': ('hvitkalke',),
'hvitkledd': ('hvitkledd',),
'hvitkledde': ('hvitkledd',),
'hvitkleddere': ('hvitkledd',),
'hvitkleddest': ('hvitkledd',),
'hvitkleddeste': ('hvitkledd',),
'hvitlett': ('hvitlett',),
'hvitlette': ('hvitlett',),
'hvitlettere': ('hvitlett',),
'hvitlettest': ('hvitlett',),
'hvitletteste': ('hvitlett',),
'hvitna': ('hvitne',),
'hvitnede': ('hvitne',),
'hvitnende': ('hvitne',),
'hvitnet': ('hvitne',),
'hvitnete': ('hvitne',),
'hvitta': ('hvitte',),
'hvittede': ('hvitte',),
'hvittende': ('hvitte',),
'hvittet': ('hvitte',),
'hvittete': ('hvitte',),
'hvitvaska': ('hvitvaske',),
'hvitvaskede': ('hvitvaske',),
'hvitvaskende': ('hvitvaske',),
'hvitvasket': ('hvitvaske',),
'hvitvaskete': ('hvitvaske',),
'hybrid': ('hybrid',),
'hybride': ('hybrid',),
'hybridere': ('hybrid',),
'hybridest': ('hybrid',),
'hybrideste': ('hybrid',),
'hydraulisk': ('hydraulisk',),
'hydrauliske': ('hydraulisk',),
'hydrauliskere': ('hydraulisk',),
'hydrauliskest': ('hydraulisk',),
'hydrauliskeste': ('hydraulisk',),
'hydroelektrisk': ('hydroelektrisk',),
'hydroelektriske': ('hydroelektrisk',),
'hydroelektriskere': ('hydroelektrisk',),
'hydroelektriskest': ('hydroelektrisk',),
'hydroelektriskeste': ('hydroelektrisk',),
'hydrofil': ('hydrofil',),
'hydrofile': ('hydrofil',),
'hydrofilere': ('hydrofil',),
'hydrofilest': ('hydrofil',),
'hydrofileste': ('hydrofil',),
'hydrofilt': ('hydrofil',),
'hydrofob': ('hydrofob',),
'hydrofobe': ('hydrofob',),
'hydrofobere': ('hydrofob',),
'hydrofobest': ('hydrofob',),
'hydrofobeste': ('hydrofob',),
'hydrofobt': ('hydrofob',),
'hydroteknisk': ('hydroteknisk',),
'hydrotekniske': ('hydroteknisk',),
'hydrotekniskere': ('hydroteknisk',),
'hydrotekniskest': ('hydroteknisk',),
'hydrotekniskeste': ('hydroteknisk',),
'hyet': ('hyet',),
'hyete': ('hyet',),
'hyetere': ('hyet',),
'hyetest': ('hyet',),
'hyeteste': ('hyet',),
'hyete': ('hyete',),
'hygd': ('hygge',),
'hygde': ('hygge',),
'hygga': ('hygge',),
'hyggede': ('hygge',),
'hyggende': ('hygge',),
'hygget': ('hygge',),
'hyggete': ('hygge',),
'hyggelig': ('hyggelig',),
'hyggelige': ('hyggelig',),
'hyggeligere': ('hyggelig',),
'hyggeligst': ('hyggelig',),
'hyggeligste': ('hyggelig',),
'hygienisk': ('hygienisk',),
'hygieniske': ('hygienisk',),
'hygieniskere': ('hygienisk',),
'hygieniskest': ('hygienisk',),
'hygieniskeste': ('hygienisk',),
'hygroskopisk': ('hygroskopisk',),
'hygroskopiske': ('hygroskopisk',),
'hygroskopiskere': ('hygroskopisk',),
'hygroskopiskest': ('hygroskopisk',),
'hygroskopiskeste': ('hygroskopisk',),
'hykkelsk': ('hykkelsk',),
'hykkelske': ('hykkelsk',),
'hykkelskere': ('hykkelsk',),
'hykkelskest': ('hykkelsk',),
'hykkelskeste': ('hykkelsk',),
'hykla': ('hykle',),
'hyklede': ('hykle',),
'hyklende': ('hykle',),
'hyklet': ('hykle',),
'hyklete': ('hykle',),
'hyklersk': ('hyklersk',),
'hyklerske': ('hyklersk',),
'hyklerskere': ('hyklersk',),
'hyklerskest': ('hyklersk',),
'hyklerskeste': ('hyklersk',),
'hylende': ('hyle',),
'hylt': ('hyle',),
'hylte': ('hyle',),
'hylla': ('hylle',),
'hyllede': ('hylle',),
'hyllende': ('hylle',),
'hyllet': ('hylle',),
'hyllete': ('hylle',),
'hylla': ('hylle',),
'hyllede': ('hylle',),
'hyllende': ('hylle',),
'hyllet': ('hylle',),
'hyllete': ('hylle',),
'hyperaktiv': ('hyperaktiv',),
'hyperaktive': ('hyperaktiv',),
'hyperaktivere': ('hyperaktiv',),
'hyperaktivest': ('hyperaktiv',),
'hyperaktiveste': ('hyperaktiv',),
'hyperaktivt': ('hyperaktiv',),
'hyperaktuell': ('hyperaktuell',),
'hyperaktuelle': ('hyperaktuell',),
'hyperaktuellere': ('hyperaktuell',),
'hyperaktuellest': ('hyperaktuell',),
'hyperaktuelleste': ('hyperaktuell',),
'hyperaktuelt': ('hyperaktuell',),
'hyperbolsk': ('hyperbolsk',),
'hyperbolske': ('hyperbolsk',),
'hyperbolskere': ('hyperbolsk',),
'hyperbolskest': ('hyperbolsk',),
'hyperbolskeste': ('hyperbolsk',),
'hyperelegant': ('hyperelegant',),
'hyperelegante': ('hyperelegant',),
'hyperelegantere': ('hyperelegant',),
'hyperelegantest': ('hyperelegant',),
'hypereleganteste': ('hyperelegant',),
'hyperkorrekt': ('hyperkorrekt',),
'hyperkorrekte': ('hyperkorrekt',),
'hyperkorrektere': ('hyperkorrekt',),
'hyperkorrektest': ('hyperkorrekt',),
'hyperkorrekteste': ('hyperkorrekt',),
'hypermoderne': ('hypermoderne',),
'hypersonisk': ('hypersonisk',),
'hypersoniske': ('hypersonisk',),
'hypersoniskere': ('hypersonisk',),
'hypersoniskest': ('hypersonisk',),
'hypersoniskeste': ('hypersonisk',),
'hypnotiserende': ('hypnotisere',),
'hypnotisert': ('hypnotisere',),
'hypnotiserte': ('hypnotisere',),
'hypnotisk': ('hypnotisk',),
'hypnotiske': ('hypnotisk',),
'hypnotiskere': ('hypnotisk',),
'hypnotiskest': ('hypnotisk',),
'hypnotiskeste': ('hypnotisk',),
'hypokonder': ('hypokonder',),
'hypokondert': ('hypokonder',),
'hypokondre': ('hypokonder',),
'hypokondrere': ('hypokonder',),
'hypokondrest': ('hypokonder',),
'hypokondreste': ('hypokonder',),
'hypokondrisk': ('hypokondrisk',),
'hypokondriske': ('hypokondrisk',),
'hypokondriskere': ('hypokondrisk',),
'hypokondriskest': ('hypokondrisk',),
'hypokondriskeste': ('hypokondrisk',),
'hypotaktisk': ('hypotaktisk',),
'hypotaktiske': ('hypotaktisk',),
'hypotaktiskere': ('hypotaktisk',),
'hypotaktiskest': ('hypotaktisk',),
'hypotaktiskeste': ('hypotaktisk',),
'hypotetisk': ('hypotetisk',),
'hypotetiske': ('hypotetisk',),
'hypotetiskere': ('hypotetisk',),
'hypotetiskest': ('hypotetisk',),
'hypotetiskeste': ('hypotetisk',),
'hypp': ('hypp',),
'hyppe': ('hypp',),
'hyppere': ('hypp',),
'hyppest': ('hypp',),
'hyppeste': ('hypp',),
'hypt': ('hypp',),
'hyppa': ('hyppe',),
'hyppede': ('hyppe',),
'hyppende': ('hyppe',),
'hyppet': ('hyppe',),
'hyppete': ('hyppe',),
'hyppig': ('hyppig',),
'hyppige': ('hyppig',),
'hyppigere': ('hyppig',),
'hyppigst': ('hyppig',),
'hyppigste': ('hyppig',),
'hyra': ('hyre',),
'hyrede': ('hyre',),
'hyrende': ('hyre',),
'hyret': ('hyre',),
'hyrete': ('hyre',),
'hyrt': ('hyre',),
'hyrte': ('hyre',),
'hyra': ('hyre',),
'hyrede': ('hyre',),
'hyrende': ('hyre',),
'hyret': ('hyre',),
'hyrete': ('hyre',),
'hyrt': ('hyre',),
'hyrte': ('hyre',),
'hysja': ('hysje',),
'hysjede': ('hysje',),
'hysjende': ('hysje',),
'hysjet': ('hysje',),
'hysjete': ('hysje',),
'hyssa': ('hysse',),
'hyssede': ('hysse',),
'hyssende': ('hysse',),
'hysset': ('hysse',),
'hyssete': ('hysse',),
'hysterisk': ('hysterisk',),
'hysteriske': ('hysterisk',),
'hysteriskere': ('hysterisk',),
'hysteriskest': ('hysterisk',),
'hysteriskeste': ('hysterisk',),
'hytta': ('hytte',),
'hyttede': ('hytte',),
'hyttende': ('hytte',),
'hyttet': ('hytte',),
'hyttete': ('hytte',),
'hytta': ('hytte',),
'hyttede': ('hytte',),
'hyttende': ('hytte',),
'hyttet': ('hytte',),
'hyttete': ('hytte',),
'hål': ('hål',),
'håle': ('hål',),
'hålere': ('hål',),
'hålest': ('hål',),
'håleste': ('hål',),
'hålt': ('hål',),
'hålket': ('hålket',),
'hålkete': ('hålket',),
'hålketere': ('hålket',),
'hålketest': ('hålket',),
'hålketeste': ('hålket',),
'hålkete': ('hålkete',),
'hånddrevet': ('hånddrevet',),
'hånddrevne': ('hånddrevet',),
'hånddrevnere': ('hånddrevet',),
'hånddrevnest': ('hånddrevet',),
'hånddrevneste': ('hånddrevet',),
'håndfallen': ('håndfallen',),
'håndfallent': ('håndfallen',),
'håndfalne': ('håndfallen',),
'håndfalnere': ('håndfallen',),
'håndfalnest': ('håndfallen',),
'håndfalneste': ('håndfallen',),
'håndfast': ('håndfast',),
'håndfaste': ('håndfast',),
'håndfastere': ('håndfast',),
'håndfastest': ('håndfast',),
'håndfasteste': ('håndfast',),
'håndgangen': ('håndgangen',),
'håndgangent': ('håndgangen',),
'håndgangne': ('håndgangen',),
'håndgangnere': ('håndgangen',),
'håndgangnest': ('håndgangen',),
'håndgangneste': ('håndgangen',),
'håndgiende': ('håndgi',),
'håndgitt': ('håndgi',),
'håndgitte': ('håndgi',),
'håndgivende': ('håndgi',),
'håndgripelig': ('håndgripelig',),
'håndgripelige': ('håndgripelig',),
'håndgripeligere': ('håndgripelig',),
'håndgripeligst': ('håndgripelig',),
'håndgripeligste': ('håndgripelig',),
'håndheva': ('håndheve',),
'håndhevd': ('håndheve',),
'håndhevde': ('håndheve',),
'håndhevede': ('håndheve',),
'håndhevende': ('håndheve',),
'håndhevet': ('håndheve',),
'håndhevete': ('håndheve',),
'håndhilsende': ('håndhilse',),
'håndhilst': ('håndhilse',),
'håndhilste': ('håndhilse',),
'håndhilsende': ('håndhilse',),
'håndhilst': ('håndhilse',),
'håndhilste': ('håndhilse',),
'håndlaga': ('håndlaga',),
'håndlagd': ('håndlagd',),
'håndlagde': ('håndlagd',),
'håndlagdere': ('håndlagd',),
'håndlagdest': ('håndlagd',),
'håndlagdeste': ('håndlagd',),
'håndlagede': ('håndlaget',),
'håndlaget': ('håndlaget',),
'håndlagete': ('håndlaget',),
'håndlagetere': ('håndlaget',),
'håndlagetest': ('håndlaget',),
'håndlageteste': ('håndlaget',),
'håndnerva': ('håndnerva',),
'håndnervede': ('håndnervet',),
'håndnervet': ('håndnervet',),
'håndnervete': ('håndnervet',),
'håndnervetere': ('håndnervet',),
'håndnervetest': ('håndnervet',),
'håndnerveteste': ('håndnervet',),
'håndplukka': ('håndplukke',),
'håndplukkede': ('håndplukke',),
'håndplukkende': ('håndplukke',),
'håndplukket': ('håndplukke',),
'håndplukkete': ('håndplukke',),
'håndskreven': ('håndskreven',),
'håndskrevet': ('håndskreven',),
'håndskrevne': ('håndskreven',),
'håndskrevnere': ('håndskreven',),
'håndskrevnest': ('håndskreven',),
'håndskrevneste': ('håndskreven',),
'håndskrevet': ('håndskrevet',),
'håndskrevne': ('håndskrevet',),
'håndskrevnere': ('håndskrevet',),
'håndskrevnest': ('håndskrevet',),
'håndskrevneste': ('håndskrevet',),
'håndskåren': ('håndskåren',),
'håndskåret': ('håndskåren',),
'håndskårne': ('håndskåren',),
'håndskårnere': ('håndskåren',),
'håndskårnest': ('håndskåren',),
'håndskårneste': ('håndskåren',),
'håndskåret': ('håndskåret',),
'håndskårne': ('håndskåret',),
'håndskårnere': ('håndskåret',),
'håndskårnest': ('håndskåret',),
'håndskårneste': ('håndskåret',),
'håndstående': ('håndstående',),
'håndterende': ('håndtere',),
'håndtert': ('håndtere',),
'håndterte': ('håndtere',),
'håndterlig': ('håndterlig',),
'håndterlige': ('håndterlig',),
'håndterligere': ('håndterlig',),
'håndterligst': ('håndterlig',),
'håndterligste': ('håndterlig',),
'håndvarm': ('håndvarm',),
'håndvarme': ('håndvarm',),
'håndvarmere': ('håndvarm',),
'håndvarmest': ('håndvarm',),
'håndvarmeste': ('håndvarm',),
'håndvarmt': ('håndvarm',),
'håndverksmessig': ('håndverksmessig',),
'håndverksmessige': ('håndverksmessig',),
'håndverksmessigere': ('håndverksmessig',),
'håndverksmessigst': ('håndverksmessig',),
'håndverksmessigste': ('håndverksmessig',),
'håna': ('håne',),
'hånede': ('håne',),
'hånende': ('håne',),
'hånet': ('håne',),
'hånete': ('håne',),
'hånt': ('håne',),
'hånte': ('håne',),
'hånflirende': ('hånflire',),
'hånflirt': ('hånflire',),
'hånflirte': ('hånflire',),
'hånledd': ('hånle',),
'hånledde': ('hånle',),
'hånleende': ('hånle',),
'hånlig': ('hånlig',),
'hånlige': ('hånlig',),
'hånligere': ('hånlig',),
'hånligst': ('hånlig',),
'hånligste': ('hånlig',),
'hånsk': ('hånsk',),
'hånske': ('hånsk',),
'hånskere': ('hånsk',),
'hånskest': ('hånsk',),
'hånskeste': ('hånsk',),
'håpa': ('håpe',),
'håpede': ('håpe',),
'håpende': ('håpe',),
'håpet': ('håpe',),
'håpete': ('håpe',),
'håpt': ('håpe',),
'håpte': ('håpe',),
'håpefull': ('håpefull',),
'håpefulle': ('håpefull',),
'håpefullere': ('håpefull',),
'håpefullest': ('håpefull',),
'håpefulleste': ('håpefull',),
'håpefullt': ('håpefull',),
'håplaus': ('håplaus',),
'håplause': ('håplaus',),
'håplausere': ('håplaus',),
'håplausest': ('håplaus',),
'håplauseste': ('håplaus',),
'håplaust': ('håplaus',),
'håpløs': ('håpløs',),
'håpløse': ('håpløs',),
'håpløsere': ('håpløs',),
'håpløsest': ('håpløs',),
'håpløseste': ('håpløs',),
'håpløst': ('håpløs',),
'håret': ('håret',),
'hårete': ('håret',),
'håretere': ('håret',),
'håretest': ('håret',),
'håreteste': ('håret',),
'hårete': ('hårete',),
'hårfager': ('hårfager',),
'hårfagert': ('hårfager',),
'hårfagre': ('hårfager',),
'hårfagrere': ('hårfager',),
'hårfagrest': ('hårfager',),
'hårfagreste': ('hårfager',),
'hårfin': ('hårfin',),
'hårfine': ('hårfin',),
'hårfinere': ('hårfin',),
'hårfinest': ('hårfin',),
'hårfineste': ('hårfin',),
'hårfint': ('hårfin',),
'hårreisende': ('hårreisende',),
'hårsår': ('hårsår',),
'hårsåre': ('hårsår',),
'hårsårere': ('hårsår',),
'hårsårest': ('hårsår',),
'hårsåreste': ('hårsår',),
'hårsårt': ('hårsår',),
'hås': ('hås',),
'håse': ('hås',),
'håsere': ('hås',),
'håsest': ('hås',),
'håseste': ('hås',),
'håst': ('hås',),
'håva': ('håve',),
'håvede': ('håve',),
'håvende': ('håve',),
'håvet': ('håve',),
'håvete': ('håve',),
'hæla': ('hæle',),
'hælede': ('hæle',),
'hælende': ('hæle',),
'hælet': ('hæle',),
'hælete': ('hæle',),
'hælt': ('hæle',),
'hælte': ('hæle',),
'hælsparka': ('hælsparke',),
'hælsparkede': ('hælsparke',),
'hælsparkende': ('hælsparke',),
'hælsparket': ('hælsparke',),
'hælsparkete': ('hælsparke',),
'hærkledd': ('hærkledd',),
'hærkledde': ('hærkledd',),
'hærkleddere': ('hærkledd',),
'hærkleddest': ('hærkledd',),
'hærkleddeste': ('hærkledd',),
'hærtakende': ('hærta',),
'hærtatt': ('hærta',),
'hærtatte': ('hærta',),
'høflig': ('høflig',),
'høflige': ('høflig',),
'høfligere': ('høflig',),
'høfligst': ('høflig',),
'høfligste': ('høflig',),
'høg': ('høg',),
'høge': ('høg',),
'høgere': ('høg',),
'høgest': ('høg',),
'høgeste': ('høg',),
'høgre': ('høg',),
'høgst': ('høg',),
'høgste': ('høg',),
'høgt': ('høg',),
'høgborgerlig': ('høgborgerlig',),
'høgborgerlige': ('høgborgerlig',),
'høgborgerligere': ('høgborgerlig',),
'høgborgerligst': ('høgborgerlig',),
'høgborgerligste': ('høgborgerlig',),
'høgereliggende': ('høgereliggende',),
'høgerestående': ('høgerestående',),
'høgfrekvent': ('høgfrekvent',),
'høgfrekvente': ('høgfrekvent',),
'høgfrekventere': ('høgfrekvent',),
'høgfrekventest': ('høgfrekvent',),
'høgfrekventeste': ('høgfrekvent',),
'høggravid': ('høggravid',),
'høggravide': ('høggravid',),
'høggravidere': ('høggravid',),
'høggravidest': ('høggravid',),
'høggravideste': ('høggravid',),
'høghalsede': ('høghalset',),
'høghalset': ('høghalset',),
'høghalsete': ('høghalset',),
'høghalsetere': ('høghalset',),
'høghalsetest': ('høghalset',),
'høghalseteste': ('høghalset',),
'høghælt': ('høghælt',),
'høghælte': ('høghælt',),
'høghæltere': ('høghælt',),
'høghæltest': ('høghælt',),
'høghælteste': ('høghælt',),
'høgkirkelig': ('høgkirkelig',),
'høgkirkelige': ('høgkirkelig',),
'høgkirkeligere': ('høgkirkelig',),
'høgkirkeligst': ('høgkirkelig',),
'høgkirkeligste': ('høgkirkelig',),
'høglofta': ('høglofta',),
'høgloftede': ('høgloftet',),
'høgloftet': ('høgloftet',),
'høgloftete': ('høgloftet',),
'høgloftetere': ('høgloftet',),
'høgloftetest': ('høgloftet',),
'høglofteteste': ('høgloftet',),
'høglys': ('høglys',),
'høglyse': ('høglys',),
'høglysere': ('høglys',),
'høglysest': ('høglys',),
'høglyseste': ('høglys',),
'høglyst': ('høglys',),
'høglytt': ('høglytt',),
'høglytte': ('høglytt',),
'høglyttere': ('høglytt',),
'høglyttest': ('høglytt',),
'høglytteste': ('høglytt',),
'høgmælt': ('høgmælt',),
'høgmælte': ('høgmælt',),
'høgmæltere': ('høgmælt',),
'høgmæltest': ('høgmælt',),
'høgmælteste': ('høgmælt',),
'høgre': ('høgre',),
'høgrehendt': ('høgrehendt',),
'høgrehendte': ('høgrehendt',),
'høgrehendtere': ('høgrehendt',),
'høgrehendtest': ('høgrehendt',),
'høgrehendteste': ('høgrehendt',),
'høgrehengsla': ('høgrehengsla',),
'høgrehengslede': ('høgrehengslet',),
'høgrehengslet': ('høgrehengslet',),
'høgrehengslete': ('høgrehengslet',),
'høgrehengsletere': ('høgrehengslet',),
'høgrehengsletest': ('høgrehengslet',),
'høgrehengsleteste': ('høgrehengslet',),
'høgreliggende': ('høgreliggende',),
'høgreorientert': ('høgreorientert',),
'høgreorienterte': ('høgreorientert',),
'høgreorientertere': ('høgreorientert',),
'høgreorientertest': ('høgreorientert',),
'høgreorienterteste': ('høgreorientert',),
'høgrestående': ('høgrestående',),
'høgrevridd': ('høgrevridd',),
'høgrevridde': ('høgrevridd',),
'høgrevriddere': ('høgrevridd',),
'høgrevriddest': ('høgrevridd',),
'høgrevriddeste': ('høgrevridd',),
'høgrygga': ('høgrygga',),
'høgryggede': ('høgrygget',),
'høgrygget': ('høgrygget',),
'høgryggete': ('høgrygget',),
'høgryggetere': ('høgrygget',),
'høgryggetest': ('høgrygget',),
'høgryggeteste': ('høgrygget',),
'høgrøsta': ('høgrøsta',),
'høgrøstede': ('høgrøstet',),
'høgrøstet': ('høgrøstet',),
'høgrøstete': ('høgrøstet',),
'høgrøstetere': ('høgrøstet',),
'høgrøstetest': ('høgrøstet',),
'høgrøsteteste': ('høgrøstet',),
'høgspent': ('høgspent',),
'høgspente': ('høgspent',),
'høgspentere': ('høgspent',),
'høgspentest': ('høgspent',),
'høgspenteste': ('høgspent',),
'høgstemt': ('høgstemt',),
'høgstemte': ('høgstemt',),
'høgstemtere': ('høgstemt',),
'høgstemtest': ('høgstemt',),
'høgstemteste': ('høgstemt',),
'høgtflygende': ('høgtflygende',),
'høgtidelig': ('høgtidelig',),
'høgtidelige': ('høgtidelig',),
'høgtideligere': ('høgtidelig',),
'høgtideligst': ('høgtidelig',),
'høgtideligste': ('høgtidelig',),
'høgtidsfull': ('høgtidsfull',),
'høgtidsfulle': ('høgtidsfull',),
'høgtidsfullere': ('høgtidsfull',),
'høgtidsfullest': ('høgtidsfull',),
'høgtidsfulleste': ('høgtidsfull',),
'høgtidsfullt': ('høgtidsfull',),
'høgtidsfull': ('høgtidsfull',),
'høgtidsfulle': ('høgtidsfull',),
'høgtidsfullere': ('høgtidsfull',),
'høgtidsfullest': ('høgtidsfull',),
'høgtidsfulleste': ('høgtidsfull',),
'høgtidsfullt': ('høgtidsfull',),
'høgtliggende': ('høgtliggende',),
'høgtlønna': ('høgtlønna',),
'høgtlønnede': ('høgtlønnet',),
'høgtlønnet': ('høgtlønnet',),
'høgtlønnete': ('høgtlønnet',),
'høgtlønnetere': ('høgtlønnet',),
'høgtlønnetest': ('høgtlønnet',),
'høgtlønneteste': ('høgtlønnet',),
'høgtlønt': ('høgtlønt',),
'høgtlønte': ('høgtlønt',),
'høgtløntere': ('høgtlønt',),
'høgtløntest': ('høgtlønt',),
'høgtlønteste': ('høgtlønt',),
'høgtstående': ('høgtstående',),
'høgtsvevende': ('høgtsvevende',),
'høgtysk': ('høgtysk',),
'høgtyske': ('høgtysk',),
'høgtyskere': ('høgtysk',),
'høgtyskest': ('høgtysk',),
'høgtyskeste': ('høgtysk',),
'høgvelbåren': ('høgvelbåren',),
'høgvelbårent': ('høgvelbåren',),
'høgvelbårne': ('høgvelbåren',),
'høgvelbårnere': ('høgvelbåren',),
'høgvelbårnest': ('høgvelbåren',),
'høgvelbårneste': ('høgvelbåren',),
'høgverdig': ('høgverdig',),
'høgverdige': ('høgverdig',),
'høgverdigere': ('høgverdig',),
'høgverdigst': ('høgverdig',),
'høgverdigste': ('høgverdig',),
'høgvokst': ('høgvokst',),
'høgvokste': ('høgvokst',),
'høgvokstere': ('høgvokst',),
'høgvokstest': ('høgvokst',),
'høgvoksteste': ('høgvokst',),
'høgætta': ('høgætta',),
'høgættede': ('høgættet',),
'høgættet': ('høgættet',),
'høgættete': ('høgættet',),
'høgættetere': ('høgættet',),
'høgættetest': ('høgættet',),
'høgætteteste': ('høgættet',),
'høkeraktig': ('høkeraktig',),
'høkeraktige': ('høkeraktig',),
'høkeraktigere': ('høkeraktig',),
'høkeraktigst': ('høkeraktig',),
'høkeraktigste': ('høkeraktig',),
'høkra': ('høkre',),
'høkrede': ('høkre',),
'høkrende': ('høkre',),
'høkret': ('høkre',),
'høkrete': ('høkre',),
'hølja': ('hølje',),
'høljede': ('hølje',),
'høljende': ('hølje',),
'høljet': ('hølje',),
'høljete': ('hølje',),
'høljeregna': ('høljeregne',),
'høljeregnede': ('høljeregne',),
'høljeregnende': ('høljeregne',),
'høljeregnet': ('høljeregne',),
'høljeregnete': ('høljeregne',),
'høljeregnt': ('høljeregne',),
'høljeregnte': ('høljeregne',),
'høljregna': ('høljregne',),
'høljregnede': ('høljregne',),
'høljregnende': ('høljregne',),
'høljregnet': ('høljregne',),
'høljregnete': ('høljregne',),
'høljregnt': ('høljregne',),
'høljregnte': ('høljregne',),
'hørbar': ('hørbar',),
'hørbare': ('hørbar',),
'hørbarere': ('hørbar',),
'hørbarest': ('hørbar',),
'hørbareste': ('hørbar',),
'hørbart': ('hørbar',),
'hørende': ('høre',),
'hørt': ('høre',),
'hørte': ('høre',),
'hørlig': ('hørlig',),
'hørlige': ('hørlig',),
'hørligere': ('hørlig',),
'hørligst': ('hørlig',),
'hørligste': ('hørlig',),
'hørselshemma': ('hørselshemma',),
'hørselshemmede': ('hørselshemmet',),
'hørselshemmet': ('hørselshemmet',),
'hørselshemmete': ('hørselshemmet',),
'hørselshemmetere': ('hørselshemmet',),
'hørselshemmetest': ('hørselshemmet',),
'hørselshemmeteste': ('hørselshemmet',),
'hørselssvekka': ('hørselssvekka',),
'hørselssvekket': ('hørselssvekket',),
'hørselssvekkete': ('hørselssvekket',),
'hørselssvekketere': ('hørselssvekket',),
'hørselssvekketest': ('hørselssvekket',),
'hørselssvekketeste': ('hørselssvekket',),
'høstbær': ('høstbær',),
'høstbære': ('høstbær',),
'høstbærere': ('høstbær',),
'høstbærest': ('høstbær',),
'høstbæreste': ('høstbær',),
'høstbært': ('høstbær',),
'høsta': ('høste',),
'høstede': ('høste',),
'høstende': ('høste',),
'høstet': ('høste',),
'høstete': ('høste',),
'høstlig': ('høstlig',),
'høstlige': ('høstlig',),
'høstligere': ('høstlig',),
'høstligst': ('høstlig',),
'høstligste': ('høstlig',),
'høvd': ('høve',),
'høvde': ('høve',),
'høvende': ('høve',),
'høvelig': ('høvelig',),
'høvelige': ('høvelig',),
'høveligere': ('høvelig',),
'høveligst': ('høvelig',),
'høveligste': ('høvelig',),
'høvisk': ('høvisk',),
'høviske': ('høvisk',),
'høviskere': ('høvisk',),
'høviskest': ('høvisk',),
'høviskeste': ('høvisk',),
'høvla': ('høvle',),
'høvlede': ('høvle',),
'høvlende': ('høvle',),
'høvlet': ('høvle',),
'høvlete': ('høvle',),
'høy': ('høy',),
'høye': ('høy',),
'høyere': ('høy',),
'høyest': ('høy',),
'høyeste': ('høy',),
'høyt': ('høy',),
'høyborgerlig': ('høyborgerlig',),
'høyborgerlige': ('høyborgerlig',),
'høyborgerligere': ('høyborgerlig',),
'høyborgerligst': ('høyborgerlig',),
'høyborgerligste': ('høyborgerlig',),
'høya': ('høye',),
'høyede': ('høye',),
'høyende': ('høye',),
'høyet': ('høye',),
'høyete': ('høye',),
'høyereliggende': ('høyereliggende',),
'høyerestående': ('høyerestående',),
'høyfrekvent': ('høyfrekvent',),
'høyfrekvente': ('høyfrekvent',),
'høyfrekventere': ('høyfrekvent',),
'høyfrekventest': ('høyfrekvent',),
'høyfrekventeste': ('høyfrekvent',),
'høygravid': ('høygravid',),
'høygravide': ('høygravid',),
'høygravidere': ('høygravid',),
'høygravidest': ('høygravid',),
'høygravideste': ('høygravid',),
'høyhalsede': ('høyhalset',),
'høyhalset': ('høyhalset',),
'høyhalsete': ('høyhalset',),
'høyhalsetere': ('høyhalset',),
'høyhalsetest': ('høyhalset',),
'høyhalseteste': ('høyhalset',),
'høyhælt': ('høyhælt',),
'høyhælte': ('høyhælt',),
'høyhæltere': ('høyhælt',),
'høyhæltest': ('høyhælt',),
'høyhælteste': ('høyhælt',),
'høykirkelig': ('høykirkelig',),
'høykirkelige': ('høykirkelig',),
'høykirkeligere': ('høykirkelig',),
'høykirkeligst': ('høykirkelig',),
'høykirkeligste': ('høykirkelig',),
'høylofta': ('høylofta',),
'høyloftede': ('høyloftet',),
'høyloftet': ('høyloftet',),
'høyloftete': ('høyloftet',),
'høyloftetere': ('høyloftet',),
'høyloftetest': ('høyloftet',),
'høylofteteste': ('høyloftet',),
'høylys': ('høylys',),
'høylyse': ('høylys',),
'høylysere': ('høylys',),
'høylysest': ('høylys',),
'høylyseste': ('høylys',),
'høylyst': ('høylys',),
'høylytt': ('høylytt',),
'høylytte': ('høylytt',),
'høylyttere': ('høylytt',),
'høylyttest': ('høylytt',),
'høylytteste': ('høylytt',),
'høymælt': ('høymælt',),
'høymælte': ('høymælt',),
'høymæltere': ('høymælt',),
'høymæltest': ('høymælt',),
'høymælteste': ('høymælt',),
'høyna': ('høyne',),
'høynede': ('høyne',),
'høynende': ('høyne',),
'høynet': ('høyne',),
'høynete': ('høyne',),
'høyre': ('høyre',),
'høyrehendt': ('høyrehendt',),
'høyrehendte': ('høyrehendt',),
'høyrehendtere': ('høyrehendt',),
'høyrehendtest': ('høyrehendt',),
'høyrehendteste': ('høyrehendt',),
'høyrehengsla': ('høyrehengsla',),
'høyrehengslede': ('høyrehengslet',),
'høyrehengslet': ('høyrehengslet',),
'høyrehengslete': ('høyrehengslet',),
'høyrehengsletere': ('høyrehengslet',),
'høyrehengsletest': ('høyrehengslet',),
'høyrehengsleteste': ('høyrehengslet',),
'høyreorientert': ('høyreorientert',),
'høyreorienterte': ('høyreorientert',),
'høyreorientertere': ('høyreorientert',),
'høyreorientertest': ('høyreorientert',),
'høyreorienterteste': ('høyreorientert',),
'høyrevridd': ('høyrevridd',),
'høyrevridde': ('høyrevridd',),
'høyrevriddere': ('høyrevridd',),
'høyrevriddest': ('høyrevridd',),
'høyrevriddeste': ('høyrevridd',),
'høyrygga': ('høyrygga',),
'høyryggede': ('høyrygget',),
'høyrygget': ('høyrygget',),
'høyryggete': ('høyrygget',),
'høyryggetere': ('høyrygget',),
'høyryggetest': ('høyrygget',),
'høyryggeteste': ('høyrygget',),
'høyrøsta': ('høyrøsta',),
'høyrøstede': ('høyrøstet',),
'høyrøstet': ('høyrøstet',),
'høyrøstete': ('høyrøstet',),
'høyrøstetere': ('høyrøstet',),
'høyrøstetest': ('høyrøstet',),
'høyrøsteteste': ('høyrøstet',),
'høyspent': ('høyspent',),
'høyspente': ('høyspent',),
'høyspentere': ('høyspent',),
'høyspentest': ('høyspent',),
'høyspenteste': ('høyspent',),
'høystbydende': ('høystbydende',),
'høystemt': ('høystemt',),
'høystemte': ('høystemt',),
'høystemtere': ('høystemt',),
'høystemtest': ('høystemt',),
'høystemteste': ('høystemt',),
'høystærede': ('høystæret',),
'høystæret': ('høystæret',),
'høystærete': ('høystæret',),
'høystæretere': ('høystæret',),
'høystæretest': ('høystæret',),
'høystæreteste': ('høystæret',),
'høytflygende': ('høytflygende',),
'høytidelig': ('høytidelig',),
'høytidelige': ('høytidelig',),
'høytideligere': ('høytidelig',),
'høytideligst': ('høytidelig',),
'høytideligste': ('høytidelig',),
'høytidsfull': ('høytidsfull',),
'høytidsfulle': ('høytidsfull',),
'høytidsfullere': ('høytidsfull',),
'høytidsfullest': ('høytidsfull',),
'høytidsfulleste': ('høytidsfull',),
'høytidsfullt': ('høytidsfull',),
'høytidsfull': ('høytidsfull',),
'høytidsfulle': ('høytidsfull',),
'høytidsfullere': ('høytidsfull',),
'høytidsfullest': ('høytidsfull',),
'høytidsfulleste': ('høytidsfull',),
'høytidsfullt': ('høytidsfull',),
'høytliggende': ('høytliggende',),
'høytlønt': ('høytlønt',),
'høytlønte': ('høytlønt',),
'høytløntere': ('høytlønt',),
'høytløntest': ('høytlønt',),
'høytlønteste': ('høytlønt',),
'høytlønt': ('høytlønt',),
'høytlønte': ('høytlønt',),
'høytløntere': ('høytlønt',),
'høytløntest': ('høytlønt',),
'høytlønteste': ('høytlønt',),
'høytstående': ('høytstående',),
'høytsvevende': ('høytsvevende',),
'høyttravende': ('høyttravende',),
'høytysk': ('høytysk',),
'høytyske': ('høytysk',),
'høytyskere': ('høytysk',),
'høytyskest': ('høytysk',),
'høytyskeste': ('høytysk',),
'høyvelbåren': ('høyvelbåren',),
'høyvelbårent': ('høyvelbåren',),
'høyvelbårne': ('høyvelbåren',),
'høyvelbårnere': ('høyvelbåren',),
'høyvelbårnest': ('høyvelbåren',),
'høyvelbårneste': ('høyvelbåren',),
'høyverdig': ('høyverdig',),
'høyverdige': ('høyverdig',),
'høyverdigere': ('høyverdig',),
'høyverdigst': ('høyverdig',),
'høyverdigste': ('høyverdig',),
'høyvokst': ('høyvokst',),
'høyvokste': ('høyvokst',),
'høyvokstere': ('høyvokst',),
'høyvokstest': ('høyvokst',),
'høyvoksteste': ('høyvokst',),
'høyætta': ('høyætta',),
'høyættede': ('høyættet',),
'høyættet': ('høyættet',),
'høyættete': ('høyættet',),
'høyættetere': ('høyættet',),
'høyættetest': ('høyættet',),
'høyætteteste': ('høyættet',),
'iakttakende': ('iaktta',),
'iakttatt': ('iaktta',),
'iakttatte': ('iaktta',),
'iatrogen': ('iatrogen',),
'iatrogene': ('iatrogen',),
'iatrogenere': ('iatrogen',),
'iatrogenest': ('iatrogen',),
'iatrogeneste': ('iatrogen',),
'iatrogent': ('iatrogen',),
'iberegna': ('iberegne',),
'iberegnede': ('iberegne',),
'iberegnende': ('iberegne',),
'iberegnet': ('iberegne',),
'iberegnete': ('iberegne',),
'iberisk': ('iberisk',),
'iberiske': ('iberisk',),
'iberiskere': ('iberisk',),
'iberiskest': ('iberisk',),
'iberiskeste': ('iberisk',),
'iblanda': ('iblande',),
'iblandede': ('iblande',),
'iblandende': ('iblande',),
'iblandet': ('iblande',),
'iblandete': ('iblande',),
'iboende': ('iboende',),
'ibsensk': ('ibsensk',),
'ibsenske': ('ibsensk',),
'ibsenskere': ('ibsensk',),
'ibsenskest': ('ibsensk',),
'ibsenskeste': ('ibsensk',),
'ibuende': ('ibuende',),
'idéhistorisk': ('idéhistorisk',),
'idéhistoriske': ('idéhistorisk',),
'idéhistoriskere': ('idéhistorisk',),
'idéhistoriskest': ('idéhistorisk',),
'idéhistoriskeste': ('idéhistorisk',),
'idélaus': ('idélaus',),
'idélause': ('idélaus',),
'idélausere': ('idélaus',),
'idélausest': ('idélaus',),
'idélauseste': ('idélaus',),
'idélaust': ('idélaus',),
'idéløs': ('idéløs',),
'idéløse': ('idéløs',),
'idéløsere': ('idéløs',),
'idéløsest': ('idéløs',),
'idéløseste': ('idéløs',),
'idéløst': ('idéløs',),
'idérik': ('idérik',),
'idérike': ('idérik',),
'idérikere': ('idérik',),
'idérikest': ('idérik',),
'idérikeste': ('idérik',),
'idérikt': ('idérik',),
'ideal': ('ideal',),
'ideale': ('ideal',),
'idealere': ('ideal',),
'idealest': ('ideal',),
'idealeste': ('ideal',),
'idealt': ('ideal',),
'idealiserende': ('idealisere',),
'idealisert': ('idealisere',),
'idealiserte': ('idealisere',),
'idealistisk': ('idealistisk',),
'idealistiske': ('idealistisk',),
'idealistiskere': ('idealistisk',),
'idealistiskest': ('idealistisk',),
'idealistiskeste': ('idealistisk',),
'ideell': ('ideell',),
'ideelle': ('ideell',),
'ideellere': ('ideell',),
'ideellest': ('ideell',),
'ideelleste': ('ideell',),
'ideelt': ('ideell',),
'idel': ('idel',),
'idelig': ('idelig',),
'idelige': ('idelig',),
'ideligere': ('idelig',),
'ideligst': ('idelig',),
'ideligste': ('idelig',),
'identifiserende': ('identifisere',),
'identifisert': ('identifisere',),
'identifiserte': ('identifisere',),
'identisk': ('identisk',),
'identiske': ('identisk',),
'identiskere': ('identisk',),
'identiskest': ('identisk',),
'identiskeste': ('identisk',),
'ideografisk': ('ideografisk',),
'ideografiske': ('ideografisk',),
'ideografiskere': ('ideografisk',),
'ideografiskest': ('ideografisk',),
'ideografiskeste': ('ideografisk',),
'ideologiserende': ('ideologisere',),
'ideologisert': ('ideologisere',),
'ideologiserte': ('ideologisere',),
'ideologisk': ('ideologisk',),
'ideologiske': ('ideologisk',),
'ideologiskere': ('ideologisk',),
'ideologiskest': ('ideologisk',),
'ideologiskeste': ('ideologisk',),
'idig': ('idig',),
'idige': ('idig',),
'idigere': ('idig',),
'idigst': ('idig',),
'idigste': ('idig',),
'idiomatisk': ('idiomatisk',),
'idiomatiske': ('idiomatisk',),
'idiomatiskere': ('idiomatisk',),
'idiomatiskest': ('idiomatisk',),
'idiomatiskeste': ('idiomatisk',),
'idiosynkratisk': ('idiosynkratisk',),
'idiosynkratiske': ('idiosynkratisk',),
'idiosynkratiskere': ('idiosynkratisk',),
'idiosynkratiskest': ('idiosynkratisk',),
'idiosynkratiskeste': ('idiosynkratisk',),
'idiotisk': ('idiotisk',),
'idiotiske': ('idiotisk',),
'idiotiskere': ('idiotisk',),
'idiotiskest': ('idiotisk',),
'idiotiskeste': ('idiotisk',),
'idiotsikker': ('idiotsikker',),
'idiotsikkert': ('idiotsikker',),
'idiotsikre': ('idiotsikker',),
'idiotsikrere': ('idiotsikker',),
'idiotsikrest': ('idiotsikker',),
'idiotsikreste': ('idiotsikker',),
'idka': ('idke',),
'idkede': ('idke',),
'idkende': ('idke',),
'idket': ('idke',),
'idkete': ('idke',),
'idrettslig': ('idrettslig',),
'idrettslige': ('idrettslig',),
'idrettsligere': ('idrettslig',),
'idrettsligst': ('idrettslig',),
'idrettsligste': ('idrettslig',),
'idylliserende': ('idyllisere',),
'idyllisert': ('idyllisere',),
'idylliserte': ('idyllisere',),
'idyllisk': ('idyllisk',),
'idylliske': ('idyllisk',),
'idylliskere': ('idyllisk',),
'idylliskest': ('idyllisk',),
'idylliskeste': ('idyllisk',),
'idømmende': ('idømme',),
'idømt': ('idømme',),
'idømte': ('idømme',),
'iførende': ('iføre',),
'iført': ('iføre',),
'iførte': ('iføre',),
'igangsatt': ('igangsette',),
'igangsatte': ('igangsette',),
'igangsettende': ('igangsette',),
'igangværende': ('igangværende',),
'ignorerende': ('ignorere',),
'ignorert': ('ignorere',),
'ignorerte': ('ignorere',),
'ihelfrosne': ('ihelfrosset',),
'ihelfrosnere': ('ihelfrosset',),
'ihelfrosnest': ('ihelfrosset',),
'ihelfrosneste': ('ihelfrosset',),
'ihelfrosset': ('ihelfrosset',),
'iherdig': ('iherdig',),
'iherdige': ('iherdig',),
'iherdigere': ('iherdig',),
'iherdigst': ('iherdig',),
'iherdigste': ('iherdig',),
'ihjelfrosne': ('ihjelfrosset',),
'ihjelfrosnere': ('ihjelfrosset',),
'ihjelfrosnest': ('ihjelfrosset',),
'ihjelfrosneste': ('ihjelfrosset',),
'ihjelfrosset': ('ihjelfrosset',),
'ihjelkjørt': ('ihjelkjørt',),
'ihjelkjørte': ('ihjelkjørt',),
'ihjelkjørtere': ('ihjelkjørt',),
'ihjelkjørtest': ('ihjelkjørt',),
'ihjelkjørteste': ('ihjelkjørt',),
'ihopfletta': ('ihopfletta',),
'ihopflettede': ('ihopflettet',),
'ihopflettet': ('ihopflettet',),
'ihopflettete': ('ihopflettet',),
'ihopflettetere': ('ihopflettet',),
'ihopflettetest': ('ihopflettet',),
'ihopfletteteste': ('ihopflettet',),
'ihopklemt': ('ihopklemt',),
'ihopklemte': ('ihopklemt',),
'ihopklemtere': ('ihopklemt',),
'ihopklemtest': ('ihopklemt',),
'ihopklemteste': ('ihopklemt',),
'ihopkrøkt': ('ihopkrøkt',),
'ihopkrøkte': ('ihopkrøkt',),
'ihopkrøktere': ('ihopkrøkt',),
'ihopkrøktest': ('ihopkrøkt',),
'ihopkrøkteste': ('ihopkrøkt',),
'ihuga': ('ihuga',),
'ihukommen': ('ihukomme',),
'ihukommende': ('ihukomme',),
'ihukommet': ('ihukomme',),
'ihukomne': ('ihukomme',),
'ikke-ledende': ('ikke-ledende',),
'ikke-stridende': ('ikke-stridende',),
'ikledd': ('ikle',),
'ikledde': ('ikle',),
'ikleende': ('ikle',),
'ikonisk': ('ikonisk',),
'ikoniske': ('ikonisk',),
'ikoniskere': ('ikonisk',),
'ikoniskest': ('ikonisk',),
'ikoniskeste': ('ikonisk',),
'ilanddrevet': ('ilanddrevet',),
'ilanddrevne': ('ilanddrevet',),
'ilanddrevnere': ('ilanddrevet',),
'ilanddrevnest': ('ilanddrevet',),
'ilanddrevneste': ('ilanddrevet',),
'ilandførende': ('ilandføre',),
'ilandført': ('ilandføre',),
'ilandførte': ('ilandføre',),
'ilda': ('ilde',),
'ildede': ('ilde',),
'ildende': ('ilde',),
'ildet': ('ilde',),
'ildete': ('ilde',),
'ilda': ('ilde',),
'ildede': ('ilde',),
'ildende': ('ilde',),
'ildet': ('ilde',),
'ildete': ('ilde',),
'ildfast': ('ildfast',),
'ildfaste': ('ildfast',),
'ildfastere': ('ildfast',),
'ildfastest': ('ildfast',),
'ildfasteste': ('ildfast',),
'ildfast': ('ildfast',),
'ildfaste': ('ildfast',),
'ildfastere': ('ildfast',),
'ildfastest': ('ildfast',),
'ildfasteste': ('ildfast',),
'ildfull': ('ildfull',),
'ildfulle': ('ildfull',),
'ildfullere': ('ildfull',),
'ildfullest': ('ildfull',),
'ildfulleste': ('ildfull',),
'ildfullt': ('ildfull',),
'ildfull': ('ildfull',),
'ildfulle': ('ildfull',),
'ildfullere': ('ildfull',),
'ildfullest': ('ildfull',),
'ildfulleste': ('ildfull',),
'ildfullt': ('ildfull',),
'ildna': ('ildne',),
'ildnede': ('ildne',),
'ildnende': ('ildne',),
'ildnet': ('ildne',),
'ildnete': ('ildne',),
'ildnende': ('ildnende',),
'ildrød': ('ildrød',),
'ildrøde': ('ildrød',),
'ildrødere': ('ildrød',),
'ildrødest': ('ildrød',),
'ildrødeste': ('ildrød',),
'ildrødt': ('ildrød',),
'ildrød': ('ildrød',),
'ildrøde': ('ildrød',),
'ildrødere': ('ildrød',),
'ildrødest': ('ildrød',),
'ildrødeste': ('ildrød',),
'ildrødt': ('ildrød',),
'ildrød': ('ildrød',),
'ildrøde': ('ildrød',),
'ildrødere': ('ildrød',),
'ildrødest': ('ildrød',),
'ildrødeste': ('ildrød',),
'ildrødt': ('ildrød',),
'ildsfarlig': ('ildsfarlig',),
'ildsfarlige': ('ildsfarlig',),
'ildsfarligere': ('ildsfarlig',),
'ildsfarligst': ('ildsfarlig',),
'ildsfarligste': ('ildsfarlig',),
'ildsfarlig': ('ildsfarlig',),
'ildsfarlige': ('ildsfarlig',),
'ildsfarligere': ('ildsfarlig',),
'ildsfarligst': ('ildsfarlig',),
'ildsfarligste': ('ildsfarlig',),
'ildsikker': ('ildsikker',),
'ildsikkert': ('ildsikker',),
'ildsikre': ('ildsikker',),
'ildsikrere': ('ildsikker',),
'ildsikrest': ('ildsikker',),
'ildsikreste': ('ildsikker',),
'ildsikker': ('ildsikker',),
'ildsikkert': ('ildsikker',),
'ildsikre': ('ildsikker',),
'ildsikrere': ('ildsikker',),
'ildsikrest': ('ildsikker',),
'ildsikreste': ('ildsikker',),
'ildsprutende': ('ildsprutende',),
'ildsprutende': ('ildsprutende',),
'ilende': ('ile',),
'ilt': ('ile',),
'ilte': ('ile',),
'ilagt': ('ilegge',),
'ilagte': ('ilegge',),
'ileggende': ('ilegge',),
'iligna': ('iligne',),
'ilignede': ('iligne',),
'ilignende': ('iligne',),
'ilignet': ('iligne',),
'ilignete': ('iligne',),
'ilikna': ('ilikne',),
'iliknede': ('ilikne',),
'iliknende': ('ilikne',),
'iliknet': ('ilikne',),
'iliknete': ('ilikne',),
'ill': ('ill',),
'ille': ('ill',),
'illere': ('ill',),
'illest': ('ill',),
'illeste': ('ill',),
'ilt': ('ill',),
'ille': ('ille',),
'verre': ('ille',),
'verst': ('ille',),
'verste': ('ille',),
'illegal': ('illegal',),
'illegale': ('illegal',),
'illegalere': ('illegal',),
'illegalest': ('illegal',),
'illegaleste': ('illegal',),
'illegalt': ('illegal',),
'illegitim': ('illegitim',),
'illegitime': ('illegitim',),
'illegitimere': ('illegitim',),
'illegitimest': ('illegitim',),
'illegitimeste': ('illegitim',),
'illegitimt': ('illegitim',),
'illeluktende': ('illeluktende',),
'illevarslende': ('illevarslende',),
'illgjeten': ('illgjeten',),
'illgjetent': ('illgjeten',),
'illgjetne': ('illgjeten',),
'illgjetnere': ('illgjeten',),
'illgjetnest': ('illgjeten',),
'illgjetneste': ('illgjeten',),
'illgjødd': ('illgjø',),
'illgjødde': ('illgjø',),
'illgjøende': ('illgjø',),
'illhervelig': ('illhervelig',),
'illhervelige': ('illhervelig',),
'illherveligere': ('illhervelig',),
'illherveligst': ('illhervelig',),
'illherveligste': ('illhervelig',),
'illhuia': ('illhuie',),
'illhuiede': ('illhuie',),
'illhuiende': ('illhuie',),
'illhuiet': ('illhuie',),
'illhuiete': ('illhuie',),
'illiberal': ('illiberal',),
'illiberale': ('illiberal',),
'illiberalere': ('illiberal',),
'illiberalest': ('illiberal',),
'illiberaleste': ('illiberal',),
'illiberalt': ('illiberal',),
'illojal': ('illojal',),
'illojale': ('illojal',),
'illojalere': ('illojal',),
'illojalest': ('illojal',),
'illojaleste': ('illojal',),
'illojalt': ('illojal',),
'illrød': ('illrød',),
'illrøde': ('illrød',),
'illrødere': ('illrød',),
'illrødest': ('illrød',),
'illrødeste': ('illrød',),
'illrødt': ('illrød',),
'illsinna': ('illsinna',),
'illsint': ('illsint',),
'illsinte': ('illsint',),
'illsintere': ('illsint',),
'illsintest': ('illsint',),
'illsinteste': ('illsint',),
'illskreken': ('illskrike',),
'illskreket': ('illskrike',),
'illskrekne': ('illskrike',),
'illskrikende': ('illskrike',),
'illsvien': ('illsvien',),
'illsviene': ('illsvien',),
'illsvienere': ('illsvien',),
'illsvienest': ('illsvien',),
'illsvieneste': ('illsvien',),
'illsvient': ('illsvien',),
'illuderende': ('illudere',),
'illudert': ('illudere',),
'illuderte': ('illudere',),
'illuminerende': ('illuminere',),
'illuminert': ('illuminere',),
'illuminerte': ('illuminere',),
'illusjonær': ('illusjonær',),
'illusjonære': ('illusjonær',),
'illusjonærere': ('illusjonær',),
'illusjonærest': ('illusjonær',),
'illusjonæreste': ('illusjonær',),
'illusjonært': ('illusjonær',),
'illusorisk': ('illusorisk',),
'illusoriske': ('illusorisk',),
'illusoriskere': ('illusorisk',),
'illusoriskest': ('illusorisk',),
'illusoriskeste': ('illusorisk',),
'illustrativ': ('illustrativ',),
'illustrative': ('illustrativ',),
'illustrativere': ('illustrativ',),
'illustrativest': ('illustrativ',),
'illustrativeste': ('illustrativ',),
'illustrativt': ('illustrativ',),
'illustre': ('illustre',),
'illustrerende': ('illustrere',),
'illustrert': ('illustrere',),
'illustrerte': ('illustrere',),
'ilsk': ('ilsk',),
'ilske': ('ilsk',),
'ilskere': ('ilsk',),
'ilskest': ('ilsk',),
'ilskeste': ('ilsk',),
'ilska': ('ilske',),
'ilskede': ('ilske',),
'ilskende': ('ilske',),
'ilsket': ('ilske',),
'ilskete': ('ilske',),
'ilsken': ('ilsken',),
'ilskent': ('ilsken',),
'ilskne': ('ilsken',),
'ilsknere': ('ilsken',),
'ilsknest': ('ilsken',),
'ilskneste': ('ilsken',),
'ilskna': ('ilskne',),
'ilsknede': ('ilskne',),
'ilsknende': ('ilskne',),
'ilsknet': ('ilskne',),
'ilsknete': ('ilskne',),
'ilsom': ('ilsom',),
'ilsomme': ('ilsom',),
'ilsommere': ('ilsom',),
'ilsomst': ('ilsom',),
'ilsomste': ('ilsom',),
'ilsomt': ('ilsom',),
'ilter': ('ilter',),
'iltert': ('ilter',),
'iltre': ('ilter',),
'iltrere': ('ilter',),
'iltrest': ('ilter',),
'iltreste': ('ilter',),
'imaginal': ('imaginal',),
'imaginale': ('imaginal',),
'imaginalere': ('imaginal',),
'imaginalest': ('imaginal',),
'imaginaleste': ('imaginal',),
'imaginalt': ('imaginal',),
'imaginerende': ('imaginere',),
'imaginert': ('imaginere',),
'imaginerte': ('imaginere',),
'imaginær': ('imaginær',),
'imaginære': ('imaginær',),
'imaginærere': ('imaginær',),
'imaginærest': ('imaginær',),
'imaginæreste': ('imaginær',),
'imaginært': ('imaginær',),
'imbesill': ('imbesill',),
'imbesille': ('imbesill',),
'imbesillere': ('imbesill',),
'imbesillest': ('imbesill',),
'imbesilleste': ('imbesill',),
'imbesilt': ('imbesill',),
'imiterende': ('imitere',),
'imitert': ('imitere',),
'imiterte': ('imitere',),
'immanent': ('immanent',),
'immanente': ('immanent',),
'immanentere': ('immanent',),
'immanentest': ('immanent',),
'immanenteste': ('immanent',),
'immateriell': ('immateriell',),
'immaterielle': ('immateriell',),
'immateriellere': ('immateriell',),
'immateriellest': ('immateriell',),
'immaterielleste': ('immateriell',),
'immaterielt': ('immateriell',),
'immatrikulerende': ('immatrikulere',),
'immatrikulert': ('immatrikulere',),
'immatrikulerte': ('immatrikulere',),
'immigrerende': ('immigrere',),
'immigrert': ('immigrere',),
'immigrerte': ('immigrere',),
'immobil': ('immobil',),
'immobile': ('immobil',),
'immobilere': ('immobil',),
'immobilest': ('immobil',),
'immobileste': ('immobil',),
'immobilt': ('immobil',),
'immortaliserende': ('immortalisere',),
'immortalisert': ('immortalisere',),
'immortaliserte': ('immortalisere',),
'immortell': ('immortell',),
'immortelle': ('immortell',),
'immortellere': ('immortell',),
'immortellest': ('immortell',),
'immortelleste': ('immortell',),
'immortelt': ('immortell',),
'immun': ('immun',),
'immune': ('immun',),
'immunere': ('immun',),
'immunest': ('immun',),
'immuneste': ('immun',),
'immunt': ('immun',),
'immuniserende': ('immunisere',),
'immunisert': ('immunisere',),
'immuniserte': ('immunisere',),
'immunologisk': ('immunologisk',),
'immunologiske': ('immunologisk',),
'immunologiskere': ('immunologisk',),
'immunologiskest': ('immunologisk',),
'immunologiskeste': ('immunologisk',),
'impenetrabel': ('impenetrabel',),
'impenetrabelt': ('impenetrabel',),
'impenetrable': ('impenetrabel',),
'impenetrablere': ('impenetrabel',),
'impenetrablest': ('impenetrabel',),
'impenetrableste': ('impenetrabel',),
'imperativ': ('imperativ',),
'imperative': ('imperativ',),
'imperativere': ('imperativ',),
'imperativest': ('imperativ',),
'imperativeste': ('imperativ',),
'imperativt': ('imperativ',),
'imperativisk': ('imperativisk',),
'imperativiske': ('imperativisk',),
'imperativiskere': ('imperativisk',),
'imperativiskest': ('imperativisk',),
'imperativiskeste': ('imperativisk',),
'imperfektiv': ('imperfektiv',),
'imperfektive': ('imperfektiv',),
'imperfektivere': ('imperfektiv',),
'imperfektivest': ('imperfektiv',),
'imperfektiveste': ('imperfektiv',),
'imperfektivt': ('imperfektiv',),
'imperial': ('imperial',),
'imperiale': ('imperial',),
'imperialere': ('imperial',),
'imperialest': ('imperial',),
'imperialeste': ('imperial',),
'imperialt': ('imperial',),
'imperialistisk': ('imperialistisk',),
'imperialistiske': ('imperialistisk',),
'imperialistiskere': ('imperialistisk',),
'imperialistiskest': ('imperialistisk',),
'imperialistiskeste': ('imperialistisk',),
'impermeabel': ('impermeabel',),
'impermeabelt': ('impermeabel',),
'impermeable': ('impermeabel',),
'impermeablere': ('impermeabel',),
'impermeablest': ('impermeabel',),
'impermeableste': ('impermeabel',),
'impertinent': ('impertinent',),
'impertinente': ('impertinent',),
'impertinentere': ('impertinent',),
'impertinentest': ('impertinent',),
'impertinenteste': ('impertinent',),
'implanterende': ('implantere',),
'implantert': ('implantere',),
'implanterte': ('implantere',),
'implementerende': ('implementere',),
'implementert': ('implementere',),
'implementerte': ('implementere',),
'impliserende': ('implisere',),
'implisert': ('implisere',),
'impliserte': ('implisere',),
'implisitt': ('implisitt',),
'implisitte': ('implisitt',),
'implisittere': ('implisitt',),
'implisittest': ('implisitt',),
'implisitteste': ('implisitt',),
'imploderende': ('implodere',),
'implodert': ('implodere',),
'imploderte': ('implodere',),
'implosjonssikker': ('implosjonssikker',),
'implosjonssikkert': ('implosjonssikker',),
'implosjonssikre': ('implosjonssikker',),
'implosjonssikrere': ('implosjonssikker',),
'implosjonssikrest': ('implosjonssikker',),
'implosjonssikreste': ('implosjonssikker',),
'imponerende': ('imponere',),
'imponert': ('imponere',),
'imponerte': ('imponere',),
'importerende': ('importere',),
'importert': ('importere',),
'importerte': ('importere',),
'imposant': ('imposant',),
'imposante': ('imposant',),
'imposantere': ('imposant',),
'imposantest': ('imposant',),
'imposanteste': ('imposant',),
'impotent': ('impotent',),
'impotente': ('impotent',),
'impotentere': ('impotent',),
'impotentest': ('impotent',),
'impotenteste': ('impotent',),
'impregnerende': ('impregnere',),
'impregnert': ('impregnere',),
'impregnerte': ('impregnere',),
'impresjonistisk': ('impresjonistisk',),
'impresjonistiske': ('impresjonistisk',),
'impresjonistiskere': ('impresjonistisk',),
'impresjonistiskest': ('impresjonistisk',),
'impresjonistiskeste': ('impresjonistisk',),
'improviserende': ('improvisere',),
'improvisert': ('improvisere',),
'improviserte': ('improvisere',),
'impulsiv': ('impulsiv',),
'impulsive': ('impulsiv',),
'impulsivere': ('impulsiv',),
'impulsivest': ('impulsiv',),
'impulsiveste': ('impulsiv',),
'impulsivt': ('impulsiv',),
'imøtegående': ('imøtegå',),
'imøtegått': ('imøtegå',),
'imøtegåtte': ('imøtegå',),
'imøteseende': ('imøtese',),
'imøtesett': ('imøtese',),
'imøtesette': ('imøtese',),
'in': ('in',),
'inadekvat': ('inadekvat',),
'inadekvate': ('inadekvat',),
'inadekvatere': ('inadekvat',),
'inadekvatest': ('inadekvat',),
'inadekvateste': ('inadekvat',),
'inaktiv': ('inaktiv',),
'inaktive': ('inaktiv',),
'inaktivere': ('inaktiv',),
'inaktivest': ('inaktiv',),
'inaktiveste': ('inaktiv',),
'inaktivt': ('inaktiv',),
'inaktiverende': ('inaktivere',),
'inaktivert': ('inaktivere',),
'inaktiverte': ('inaktivere',),
'inappellabel': ('inappellabel',),
'inappellabelt': ('inappellabel',),
'inappellable': ('inappellabel',),
'inappellablere': ('inappellabel',),
'inappellablest': ('inappellabel',),
'inappellableste': ('inappellabel',),
'inaugurerende': ('inaugurere',),
'inaugurert': ('inaugurere',),
'inaugurerte': ('inaugurere',),
'incestuøs': ('incestuøs',),
'incestuøse': ('incestuøs',),
'incestuøsere': ('incestuøs',),
'incestuøsest': ('incestuøs',),
'incestuøseste': ('incestuøs',),
'incestuøst': ('incestuøs',),
'inciterende': ('incitere',),
'incitert': ('incitere',),
'inciterte': ('incitere',),
'inderlig': ('inderlig',),
'inderlige': ('inderlig',),
'inderligere': ('inderlig',),
'inderligst': ('inderlig',),
'inderligste': ('inderlig',),
'indiansk': ('indiansk',),
'indianske': ('indiansk',),
'indianskere': ('indiansk',),
'indianskest': ('indiansk',),
'indianskeste': ('indiansk',),
'indifferent': ('indifferent',),
'indifferente': ('indifferent',),
'indifferentere': ('indifferent',),
'indifferentest': ('indifferent',),
'indifferenteste': ('indifferent',),
'indignert': ('indignert',),
'indignerte': ('indignert',),
'indignertere': ('indignert',),
'indignertest': ('indignert',),
'indignerteste': ('indignert',),
'indigoblå': ('indigoblå',),
'indigoblåe': ('indigoblå',),
'indigoblåere': ('indigoblå',),
'indigoblåest': ('indigoblå',),
'indigoblåeste': ('indigoblå',),
'indigoblått': ('indigoblå',),
'indikativisk': ('indikativisk',),
'indikativiske': ('indikativisk',),
'indikativiskere': ('indikativisk',),
'indikativiskest': ('indikativisk',),
'indikativiskeste': ('indikativisk',),
'indikerende': ('indikere',),
'indikert': ('indikere',),
'indikerte': ('indikere',),
'indirekte': ('indirekte',),
'indisk': ('indisk',),
'indiske': ('indisk',),
'indiskere': ('indisk',),
'indiskest': ('indisk',),
'indiskeste': ('indisk',),
'indiskre': ('indiskre',),
'indiskree': ('indiskre',),
'indiskreere': ('indiskre',),
'indiskreest': ('indiskre',),
'indiskreeste': ('indiskre',),
'indiskutabel': ('indiskutabel',),
'indiskutabelt': ('indiskutabel',),
'indiskutable': ('indiskutabel',),
'indiskutablere': ('indiskutabel',),
'indiskutablest': ('indiskutabel',),
'indiskutableste': ('indiskutabel',),
'indisponert': ('indisponert',),
'indisponerte': ('indisponert',),
'indisponertere': ('indisponert',),
'indisponertest': ('indisponert',),
'indisponerteste': ('indisponert',),
'indisponibel': ('indisponibel',),
'indisponibelt': ('indisponibel',),
'indisponible': ('indisponibel',),
'indisponiblere': ('indisponibel',),
'indisponiblest': ('indisponibel',),
'indisponibleste': ('indisponibel',),
'individualiserende': ('individualisere',),
'individualisert': ('individualisere',),
'individualiserte': ('individualisere',),
'individualistisk': ('individualistisk',),
'individualistiske': ('individualistisk',),
'individualistiskere': ('individualistisk',),
'individualistiskest': ('individualistisk',),
'individualistiskeste': ('individualistisk',),
'individualpreventiv': ('individualpreventiv',),
'individualpreventive': ('individualpreventiv',),
'individualpreventivere': ('individualpreventiv',),
'individualpreventivest': ('individualpreventiv',),
'individualpreventiveste': ('individualpreventiv',),
'individualpreventivt': ('individualpreventiv',),
'individuell': ('individuell',),
'individuelle': ('individuell',),
'individuellere': ('individuell',),
'individuellest': ('individuell',),
'individuelleste': ('individuell',),
'individuelt': ('individuell',),
'indoarisk': ('indoarisk',),
'indoariske': ('indoarisk',),
'indoariskere': ('indoarisk',),
'indoariskest': ('indoarisk',),
'indoariskeste': ('indoarisk',),
'indoeuropeisk': ('indoeuropeisk',),
'indoeuropeiske': ('indoeuropeisk',),
'indoeuropeiskere': ('indoeuropeisk',),
'indoeuropeiskest': ('indoeuropeisk',),
'indoeuropeiskeste': ('indoeuropeisk',),
'indoiransk': ('indoiransk',),
'indoiranske': ('indoiransk',),
'indoiranskere': ('indoiransk',),
'indoiranskest': ('indoiransk',),
'indoiranskeste': ('indoiransk',),
'indoiransk': ('indoiransk',),
'indoiranske': ('indoiransk',),
'indoiranskere': ('indoiransk',),
'indoiranskest': ('indoiransk',),
'indoiranskeste': ('indoiransk',),
'indokinesisk': ('indokinesisk',),
'indokinesiske': ('indokinesisk',),
'indokinesiskere': ('indokinesisk',),
'indokinesiskest': ('indokinesisk',),
'indokinesiskeste': ('indokinesisk',),
'indoktrinerende': ('indoktrinere',),
'indoktrinert': ('indoktrinere',),
'indoktrinerte': ('indoktrinere',),
'indolent': ('indolent',),
'indolente': ('indolent',),
'indolentere': ('indolent',),
'indolentest': ('indolent',),
'indolenteste': ('indolent',),
'indonesisk': ('indonesisk',),
'indonesiske': ('indonesisk',),
'indonesiskere': ('indonesisk',),
'indonesiskest': ('indonesisk',),
'indonesiskeste': ('indonesisk',),
'indre': ('indre',),
'innerst': ('indre',),
'innerste': ('indre',),
'inst': ('indre',),
'inste': ('indre',),
'indremedisinsk': ('indremedisinsk',),
'indremedisinske': ('indremedisinsk',),
'indremedisinskere': ('indremedisinsk',),
'indremedisinskest': ('indremedisinsk',),
'indremedisinskeste': ('indremedisinsk',),
'indrepolitisk': ('indrepolitisk',),
'indrepolitiske': ('indrepolitisk',),
'indrepolitiskere': ('indrepolitisk',),
'indrepolitiskest': ('indrepolitisk',),
'indrepolitiskeste': ('indrepolitisk',),
'indresekretorisk': ('indresekretorisk',),
'indresekretoriske': ('indresekretorisk',),
'indresekretoriskere': ('indresekretorisk',),
'indresekretoriskest': ('indresekretorisk',),
'indresekretoriskeste': ('indresekretorisk',),
'induktiv': ('induktiv',),
'induktive': ('induktiv',),
'induktivere': ('induktiv',),
'induktivest': ('induktiv',),
'induktiveste': ('induktiv',),
'induktivt': ('induktiv',),
'induserende': ('indusere',),
'indusert': ('indusere',),
'induserte': ('indusere',),
'industrialiserende': ('industrialisere',),
'industrialisert': ('industrialisere',),
'industrialiserte': ('industrialisere',),
'industriell': ('industriell',),
'industrielle': ('industriell',),
'industriellere': ('industriell',),
'industriellest': ('industriell',),
'industrielleste': ('industriell',),
'industrielt': ('industriell',),
'ineffektiv': ('ineffektiv',),
'ineffektive': ('ineffektiv',),
'ineffektivere': ('ineffektiv',),
'ineffektivest': ('ineffektiv',),
'ineffektiveste': ('ineffektiv',),
'ineffektivt': ('ineffektiv',),
'inert': ('inert',),
'inerte': ('inert',),
'inertere': ('inert',),
'inertest': ('inert',),
'inerteste': ('inert',),
'infam': ('infam',),
'infame': ('infam',),
'infamere': ('infam',),
'infamest': ('infam',),
'infameste': ('infam',),
'infamt': ('infam',),
'infamerende': ('infamere',),
'infamert': ('infamere',),
'infamerte': ('infamere',),
'infantil': ('infantil',),
'infantile': ('infantil',),
'infantilere': ('infantil',),
'infantilest': ('infantil',),
'infantileste': ('infantil',),
'infantilt': ('infantil',),
'infantiliserende': ('infantilisere',),
'infantilisert': ('infantilisere',),
'infantiliserte': ('infantilisere',),
'infeksiøs': ('infeksiøs',),
'infeksiøse': ('infeksiøs',),
'infeksiøsere': ('infeksiøs',),
'infeksiøsest': ('infeksiøs',),
'infeksiøseste': ('infeksiøs',),
'infeksiøst': ('infeksiøs',),
'inferiør': ('inferiør',),
'inferiøre': ('inferiør',),
'inferiørere': ('inferiør',),
'inferiørest': ('inferiør',),
'inferiøreste': ('inferiør',),
'inferiørt': ('inferiør',),
'infernalsk': ('infernalsk',),
'infernalske': ('infernalsk',),
'infernalskere': ('infernalsk',),
'infernalskest': ('infernalsk',),
'infernalskeste': ('infernalsk',),
'infiltrerende': ('infiltrere',),
'infiltrert': ('infiltrere',),
'infiltrerte': ('infiltrere',),
'infinitt': ('infinitt',),
'infinitte': ('infinitt',),
'infinittere': ('infinitt',),
'infinittest': ('infinitt',),
'infinitteste': ('infinitt',),
'infiserende': ('infisere',),
'infisert': ('infisere',),
'infiserte': ('infisere',),
'inflammatorisk': ('inflammatorisk',),
'inflammatoriske': ('inflammatorisk',),
'inflammatoriskere': ('inflammatorisk',),
'inflammatoriskest': ('inflammatorisk',),
'inflammatoriskeste': ('inflammatorisk',),
'inflammerende': ('inflammere',),
'inflammert': ('inflammere',),
'inflammerte': ('inflammere',),
'inflasjonistisk': ('inflasjonistisk',),
'inflasjonistiske': ('inflasjonistisk',),
'inflasjonistiskere': ('inflasjonistisk',),
'inflasjonistiskest': ('inflasjonistisk',),
'inflasjonistiskeste': ('inflasjonistisk',),
'inflasjonsdrivende': ('inflasjonsdrivende',),
'inflaterende': ('inflatere',),
'inflatert': ('inflatere',),
'inflaterte': ('inflatere',),
'inflatorisk': ('inflatorisk',),
'inflatoriske': ('inflatorisk',),
'inflatoriskere': ('inflatorisk',),
'inflatoriskest': ('inflatorisk',),
'inflatoriskeste': ('inflatorisk',),
'influerende': ('influere',),
'influert': ('influere',),
'influerte': ('influere',),
'informativ': ('informativ',),
'informative': ('informativ',),
'informativere': ('informativ',),
'informativest': ('informativ',),
'informativeste': ('informativ',),
'informativt': ('informativ',),
'informerende': ('informere',),
'informert': ('informere',),
'informerte': ('informere',),
'infrarød': ('infrarød',),
'infrarøde': ('infrarød',),
'infrarødere': ('infrarød',),
'infrarødest': ('infrarød',),
'infrarødeste': ('infrarød',),
'infrarødt': ('infrarød',),
'inhabil': ('inhabil',),
'inhabile': ('inhabil',),
'inhabilere': ('inhabil',),
'inhabilest': ('inhabil',),
'inhabileste': ('inhabil',),
'inhabilt': ('inhabil',),
'inhalerende': ('inhalere',),
'inhalert': ('inhalere',),
'inhalerte': ('inhalere',),
'inherent': ('inherent',),
'inherente': ('inherent',),
'inherentere': ('inherent',),
'inherentest': ('inherent',),
'inherenteste': ('inherent',),
'inhererende': ('inherere',),
'inherert': ('inherere',),
'inhererte': ('inherere',),
'inhiberende': ('inhibere',),
'inhibert': ('inhibere',),
'inhiberte': ('inhibere',),
'inhibitorisk': ('inhibitorisk',),
'inhibitoriske': ('inhibitorisk',),
'inhibitoriskere': ('inhibitorisk',),
'inhibitoriskest': ('inhibitorisk',),
'inhibitoriskeste': ('inhibitorisk',),
'inhuman': ('inhuman',),
'inhumane': ('inhuman',),
'inhumanere': ('inhuman',),
'inhumanest': ('inhuman',),
'inhumaneste': ('inhuman',),
'inhumant': ('inhuman',),
'initial': ('initial',),
'initiale': ('initial',),
'initialere': ('initial',),
'initialest': ('initial',),
'initialeste': ('initial',),
'initialt': ('initial',),
'initiativlaus': ('initiativlaus',),
'initiativlause': ('initiativlaus',),
'initiativlausere': ('initiativlaus',),
'initiativlausest': ('initiativlaus',),
'initiativlauseste': ('initiativlaus',),
'initiativlaust': ('initiativlaus',),
'initiativløs': ('initiativløs',),
'initiativløse': ('initiativløs',),
'initiativløsere': ('initiativløs',),
'initiativløsest': ('initiativløs',),
'initiativløseste': ('initiativløs',),
'initiativløst': ('initiativløs',),
'initiativrik': ('initiativrik',),
'initiativrike': ('initiativrik',),
'initiativrikere': ('initiativrik',),
'initiativrikest': ('initiativrik',),
'initiativrikeste': ('initiativrik',),
'initiativrikt': ('initiativrik',),
'initierende': ('initiere',),
'initiert': ('initiere',),
'initierte': ('initiere',),
'injiserende': ('injisere',),
'injisert': ('injisere',),
'injiserte': ('injisere',),
'injurierende': ('injuriere',),
'injuriert': ('injuriere',),
'injurierte': ('injuriere',),
'inkapabel': ('inkapabel',),
'inkapabelt': ('inkapabel',),
'inkapable': ('inkapabel',),
'inkapablere': ('inkapabel',),
'inkapablest': ('inkapabel',),
'inkapableste': ('inkapabel',),
'inkarnerende': ('inkarnere',),
'inkarnert': ('inkarnere',),
'inkarnerte': ('inkarnere',),
'inklinerende': ('inklinere',),
'inklinert': ('inklinere',),
'inklinerte': ('inklinere',),
'inkluderende': ('inkludere',),
'inkludert': ('inkludere',),
'inkluderte': ('inkludere',),
'inklusiv': ('inklusiv',),
'inklusive': ('inklusiv',),
'inklusivere': ('inklusiv',),
'inklusivest': ('inklusiv',),
'inklusiveste': ('inklusiv',),
'inklusivt': ('inklusiv',),
'inkoativ': ('inkoativ',),
'inkoative': ('inkoativ',),
'inkoativere': ('inkoativ',),
'inkoativest': ('inkoativ',),
'inkoativeste': ('inkoativ',),
'inkoativt': ('inkoativ',),
'inkommensurabel': ('inkommensurabel',),
'inkommensurabelt': ('inkommensurabel',),
'inkommensurable': ('inkommensurabel',),
'inkommensurablere': ('inkommensurabel',),
'inkommensurablest': ('inkommensurabel',),
'inkommensurableste': ('inkommensurabel',),
'inkontinent': ('inkontinent',),
'inkontinente': ('inkontinent',),
'inkontinentere': ('inkontinent',),
'inkontinentest': ('inkontinent',),
'inkontinenteste': ('inkontinent',),
'inkorporerende': ('inkorporere',),
'inkorporert': ('inkorporere',),
'inkorporerte': ('inkorporere',),
'inkvisitorisk': ('inkvisitorisk',),
'inkvisitoriske': ('inkvisitorisk',),
'inkvisitoriskere': ('inkvisitorisk',),
'inkvisitoriskest': ('inkvisitorisk',),
'inkvisitoriskeste': ('inkvisitorisk',),
'innabords': ('innabords',),
'innabygds': ('innabygds',),
'innabygdsboende': ('innabygdsboende',),
'innabys': ('innabys',),
'innadvendt': ('innadvendt',),
'innadvendte': ('innadvendt',),
'innadvendtere': ('innadvendt',),
'innadvendtest': ('innadvendt',),
'innadvendteste': ('innadvendt',),
'innadørs': ('innadørs',),
'innalandsk': ('innalandsk',),
'innalandske': ('innalandsk',),
'innalandskere': ('innalandsk',),
'innalandskest': ('innalandsk',),
'innalandskeste': ('innalandsk',),
'innanka': ('innanke',),
'innankede': ('innanke',),
'innankende': ('innanke',),
'innanket': ('innanke',),
'innankete': ('innanke',),
'innarbeida': ('innarbeide',),
'innarbeidd': ('innarbeide',),
'innarbeidde': ('innarbeide',),
'innarbeidede': ('innarbeide',),
'innarbeidende': ('innarbeide',),
'innarbeidet': ('innarbeide',),
'innarbeidete': ('innarbeide',),
'innariks': ('innariks',),
'innariksk': ('innariksk',),
'innarikske': ('innariksk',),
'innarikskere': ('innariksk',),
'innarikskest': ('innariksk',),
'innarikskeste': ('innariksk',),
'innbakt': ('innbakt',),
'innbakte': ('innbakt',),
'innbaktere': ('innbakt',),
'innbaktest': ('innbakt',),
'innbakteste': ('innbakt',),
'innballa': ('innballa',),
'innballede': ('innballet',),
'innballet': ('innballet',),
'innballete': ('innballet',),
'innballetere': ('innballet',),
'innballetest': ('innballet',),
'innballeteste': ('innballet',),
'innbarka': ('innbarka',),
'innbarkede': ('innbarket',),
'innbarket': ('innbarket',),
'innbarkete': ('innbarket',),
'innbarketere': ('innbarket',),
'innbarketest': ('innbarket',),
'innbarketeste': ('innbarket',),
'innbefatta': ('innbefatte',),
'innbefattede': ('innbefatte',),
'innbefattende': ('innbefatte',),
'innbefattet': ('innbefatte',),
'innbefattete': ('innbefatte',),
'innberetta': ('innberette',),
'innberettede': ('innberette',),
'innberettende': ('innberette',),
'innberettet': ('innberette',),
'innberettete': ('innberette',),
'innbetalende': ('innbetale',),
'innbetalt': ('innbetale',),
'innbetalte': ('innbetale',),
'innbillende': ('innbille',),
'innbilt': ('innbille',),
'innbilte': ('innbille',),
'innbilsk': ('innbilsk',),
'innbilske': ('innbilsk',),
'innbilskere': ('innbilsk',),
'innbilskest': ('innbilsk',),
'innbilskeste': ('innbilsk',),
'innbindende': ('innbinde',),
'innbunden': ('innbinde',),
'innbundet': ('innbinde',),
'innbundne': ('innbinde',),
'innbitt': ('innbitt',),
'innbitte': ('innbitt',),
'innbittere': ('innbitt',),
'innbittest': ('innbitt',),
'innbitteste': ('innbitt',),
'innblanda': ('innblande',),
'innblandede': ('innblande',),
'innblandende': ('innblande',),
'innblandet': ('innblande',),
'innblandete': ('innblande',),
'innbragt': ('innbringe',),
'innbragte': ('innbringe',),
'innbrakt': ('innbringe',),
'innbrakte': ('innbringe',),
'innbringende': ('innbringe',),
'innbringende': ('innbringende',),
'innbudt': ('innby',),
'innbudte': ('innby',),
'innbydd': ('innby',),
'innbydde': ('innby',),
'innbyende': ('innby',),
'innbydende': ('innbydende',),
'innbygd': ('innbygd',),
'innbygde': ('innbygd',),
'innbygdere': ('innbygd',),
'innbygdest': ('innbygd',),
'innbygdeste': ('innbygd',),
'innbyrdes': ('innbyrdes',),
'inndampa': ('inndampe',),
'inndampede': ('inndampe',),
'inndampende': ('inndampe',),
'inndampet': ('inndampe',),
'inndampete': ('inndampe',),
'inndelende': ('inndele',),
'inndelt': ('inndele',),
'inndelte': ('inndele',),
'inndradd': ('inndra',),
'inndradde': ('inndra',),
'inndragende': ('inndra',),
'inndratt': ('inndra',),
'inndratte': ('inndra',),
'inndreven': ('inndrive',),
'inndrevet': ('inndrive',),
'inndrevne': ('inndrive',),
'inndrivende': ('inndrive',),
'innebygd': ('innebygd',),
'innebygde': ('innebygd',),
'innebygdere': ('innebygd',),
'innebygdest': ('innebygd',),
'innebygdeste': ('innebygd',),
'innebåren': ('innebære',),
'innebåret': ('innebære',),
'innebårne': ('innebære',),
'innebærende': ('innebære',),
'innefrosne': ('innefrosset',),
'innefrosnere': ('innefrosset',),
'innefrosnest': ('innefrosset',),
'innefrosneste': ('innefrosset',),
'innefrosset': ('innefrosset',),
'innehaende': ('inneha',),
'innehatt': ('inneha',),
'innehatte': ('inneha',),
'inneholdende': ('inneholde',),
'inneholdt': ('inneholde',),
'inneholdte': ('inneholde',),
'inneklemt': ('inneklemt',),
'inneklemte': ('inneklemt',),
'inneklemtere': ('inneklemt',),
'inneklemtest': ('inneklemt',),
'inneklemteste': ('inneklemt',),
'innekserserende': ('inneksersere',),
'inneksersert': ('inneksersere',),
'innekserserte': ('inneksersere',),
'innelukka': ('innelukka',),
'innelukkede': ('innelukket',),
'innelukket': ('innelukket',),
'innelukkete': ('innelukket',),
'innelukketere': ('innelukket',),
'innelukketest': ('innelukket',),
'innelukketeste': ('innelukket',),
'innemurt': ('innemurt',),
'innemurte': ('innemurt',),
'innemurtere': ('innemurt',),
'innemurtest': ('innemurt',),
'innemurteste': ('innemurt',),
'innenbords': ('innenbords',),
'innenbygds': ('innenbygds',),
'innenbygdsboende': ('innenbygdsboende',),
'innenbys': ('innenbys',),
'innendørs': ('innendørs',),
'innenlandsk': ('innenlandsk',),
'innenlandske': ('innenlandsk',),
'innenlandskere': ('innenlandsk',),
'innenlandskest': ('innenlandsk',),
'innenlandskeste': ('innenlandsk',),
'innenriks': ('innenriks',),
'innenriksk': ('innenriksk',),
'innenrikske': ('innenriksk',),
'innenrikskere': ('innenriksk',),
'innenrikskest': ('innenriksk',),
'innenrikskeste': ('innenriksk',),
'inneslutta': ('inneslutta',),
'innesluttede': ('innesluttet',),
'innesluttet': ('innesluttet',),
'innesluttete': ('innesluttet',),
'innesluttetere': ('innesluttet',),
'innesluttetest': ('innesluttet',),
'inneslutteteste': ('innesluttet',),
'innesnødd': ('innesnødd',),
'innesnødde': ('innesnødd',),
'innesnøddere': ('innesnødd',),
'innesnøddest': ('innesnødd',),
'innesnøddeste': ('innesnødd',),
'innesperra': ('innesperra',),
'innesperrede': ('innesperret',),
'innesperret': ('innesperret',),
'innesperrete': ('innesperret',),
'innesperretere': ('innesperret',),
'innesperretest': ('innesperret',),
'innesperreteste': ('innesperret',),
'innestengt': ('innestengt',),
'innestengte': ('innestengt',),
'innestengtere': ('innestengt',),
'innestengtest': ('innestengt',),
'innestengteste': ('innestengt',),
'innett': ('innett',),
'innette': ('innett',),
'innettere': ('innett',),
'innettest': ('innett',),
'innetteste': ('innett',),
'inneværende': ('inneværende',),
'innfallen': ('innfallen',),
'innfallent': ('innfallen',),
'innfalne': ('innfallen',),
'innfalnere': ('innfallen',),
'innfalnest': ('innfallen',),
'innfalneste': ('innfallen',),
'innfallsrik': ('innfallsrik',),
'innfallsrike': ('innfallsrik',),
'innfallsrikere': ('innfallsrik',),
'innfallsrikest': ('innfallsrik',),
'innfallsrikeste': ('innfallsrik',),
'innfallsrikt': ('innfallsrik',),
'innfatta': ('innfatte',),
'innfattede': ('innfatte',),
'innfattende': ('innfatte',),
'innfattet': ('innfatte',),
'innfattete': ('innfatte',),
'innfellende': ('innfelle',),
'innfelt': ('innfelle',),
'innfelte': ('innfelle',),
'innfiltra': ('innfiltre',),
'innfiltrede': ('innfiltre',),
'innfiltrende': ('innfiltre',),
'innfiltret': ('innfiltre',),
'innfiltrete': ('innfiltre',),
'innfinnende': ('innfinne',),
'innfunne': ('innfinne',),
'innfunnen': ('innfinne',),
'innfunnet': ('innfinne',),
'innfletta': ('innfletta',),
'innflettede': ('innflettet',),
'innflettet': ('innflettet',),
'innflettete': ('innflettet',),
'innflettetere': ('innflettet',),
'innflettetest': ('innflettet',),
'innfletteteste': ('innflettet',),
'innflytelsesrik': ('innflytelsesrik',),
'innflytelsesrike': ('innflytelsesrik',),
'innflytelsesrikere': ('innflytelsesrik',),
'innflytelsesrikest': ('innflytelsesrik',),
'innflytelsesrikeste': ('innflytelsesrik',),
'innflytelsesrikt': ('innflytelsesrik',),
'innflytningsklar': ('innflytningsklar',),
'innflytningsklare': ('innflytningsklar',),
'innflytningsklarere': ('innflytningsklar',),
'innflytningsklarest': ('innflytningsklar',),
'innflytningsklareste': ('innflytningsklar',),
'innflytningsklart': ('innflytningsklar',),
'innflyttingsklar': ('innflyttingsklar',),
'innflyttingsklare': ('innflyttingsklar',),
'innflyttingsklarere': ('innflyttingsklar',),
'innflyttingsklarest': ('innflyttingsklar',),
'innflyttingsklareste': ('innflyttingsklar',),
'innflyttingsklart': ('innflyttingsklar',),
'innfløkt': ('innfløkt',),
'innfløkte': ('innfløkt',),
'innfløktere': ('innfløkt',),
'innfløktest': ('innfløkt',),
'innfløkteste': ('innfløkt',),
'innforliva': ('innforlive',),
'innforlivede': ('innforlive',),
'innforlivende': ('innforlive',),
'innforlivet': ('innforlive',),
'innforlivete': ('innforlive',),
'innforstått': ('innforstått',),
'innforståtte': ('innforstått',),
'innforståttere': ('innforstått',),
'innforståttest': ('innforstått',),
'innforståtteste': ('innforstått',),
'innfridd': ('innfri',),
'innfridde': ('innfri',),
'innfriende': ('innfri',),
'innful': ('innful',),
'innfule': ('innful',),
'innfulere': ('innful',),
'innfulest': ('innful',),
'innfuleste': ('innful',),
'innfult': ('innful',),
'innfødd': ('innfødd',),
'innfødde': ('innfødd',),
'innføddere': ('innfødd',),
'innføddest': ('innfødd',),
'innføddeste': ('innfødd',),
'innfødt': ('innfødt',),
'innfødte': ('innfødt',),
'innfødtere': ('innfødt',),
'innfødtest': ('innfødt',),
'innfødteste': ('innfødt',),
'innførende': ('innføre',),
'innført': ('innføre',),
'innførte': ('innføre',),
'innføya': ('innføye',),
'innføyd': ('innføye',),
'innføydd': ('innføye',),
'innføydde': ('innføye',),
'innføyde': ('innføye',),
'innføyede': ('innføye',),
'innføyende': ('innføye',),
'innføyet': ('innføye',),
'innføyete': ('innføye',),
'inngiende': ('inngi',),
'inngitt': ('inngi',),
'inngitte': ('inngi',),
'inngivende': ('inngi',),
'inngifta': ('inngifta',),
'inngifta': ('inngifte',),
'inngiftede': ('inngifte',),
'inngiftende': ('inngifte',),
'inngiftet': ('inngifte',),
'inngiftete': ('inngifte',),
'inngiftede': ('inngiftet',),
'inngiftet': ('inngiftet',),
'inngiftete': ('inngiftet',),
'inngiftetere': ('inngiftet',),
'inngiftetest': ('inngiftet',),
'inngifteteste': ('inngiftet',),
'inngjerda': ('inngjerde',),
'inngjerdede': ('inngjerde',),
'inngjerdende': ('inngjerde',),
'inngjerdet': ('inngjerde',),
'inngjerdete': ('inngjerde',),
'inngnidd': ('inngnidd',),
'inngnidde': ('inngnidd',),
'inngniddere': ('inngnidd',),
'inngniddest': ('inngnidd',),
'inngniddeste': ('inngnidd',),
'inngraverende': ('inngravere',),
'inngravert': ('inngravere',),
'inngraverte': ('inngravere',),
'inngripende': ('inngripende',),
'inngrodd': ('inngrodd',),
'inngrodde': ('inngrodd',),
'inngroddere': ('inngrodd',),
'inngroddest': ('inngrodd',),
'inngroddeste': ('inngrodd',),
'inngytende': ('inngyte',),
'inngytt': ('inngyte',),
'inngytte': ('inngyte',),
'inngående': ('inngå',),
'inngått': ('inngå',),
'inngåtte': ('inngå',),
'inngående': ('inngående',),
'innhegna': ('innhegne',),
'innhegnede': ('innhegne',),
'innhegnende': ('innhegne',),
'innhegnet': ('innhegne',),
'innhegnete': ('innhegne',),
'innhenta': ('innhente',),
'innhentede': ('innhente',),
'innhentende': ('innhente',),
'innhentet': ('innhente',),
'innhentete': ('innhente',),
'innhogd': ('innhogd',),
'innhogde': ('innhogd',),
'innhogdere': ('innhogd',),
'innhogdest': ('innhogd',),
'innhogdeste': ('innhogd',),
'innhol': ('innhol',),
'innhole': ('innhol',),
'innholere': ('innhol',),
'innholest': ('innhol',),
'innholeste': ('innhol',),
'innholt': ('innhol',),
'innholdslaus': ('innholdslaus',),
'innholdslause': ('innholdslaus',),
'innholdslausere': ('innholdslaus',),
'innholdslausest': ('innholdslaus',),
'innholdslauseste': ('innholdslaus',),
'innholdslaust': ('innholdslaus',),
'innholdsløs': ('innholdsløs',),
'innholdsløse': ('innholdsløs',),
'innholdsløsere': ('innholdsløs',),
'innholdsløsest': ('innholdsløs',),
'innholdsløseste': ('innholdsløs',),
'innholdsløst': ('innholdsløs',),
'innholdsrik': ('innholdsrik',),
'innholdsrike': ('innholdsrik',),
'innholdsrikere': ('innholdsrik',),
'innholdsrikest': ('innholdsrik',),
'innholdsrikeste': ('innholdsrik',),
'innholdsrikt': ('innholdsrik',),
'innhul': ('innhul',),
'innhule': ('innhul',),
'innhulere': ('innhul',),
'innhulest': ('innhul',),
'innhuleste': ('innhul',),
'innhult': ('innhul',),
'innhylla': ('innhylle',),
'innhyllede': ('innhylle',),
'innhyllende': ('innhylle',),
'innhyllet': ('innhylle',),
'innhyllete': ('innhylle',),
'innhøsta': ('innhøste',),
'innhøstede': ('innhøste',),
'innhøstende': ('innhøste',),
'innhøstet': ('innhøste',),
'innhøstete': ('innhøste',),
'innkalkulerende': ('innkalkulere',),
'innkalkulert': ('innkalkulere',),
'innkalkulerte': ('innkalkulere',),
'innkallende': ('innkalle',),
'innkalt': ('innkalle',),
'innkalte': ('innkalle',),
'innkapsla': ('innkapsle',),
'innkapslede': ('innkapsle',),
'innkapslende': ('innkapsle',),
'innkapslet': ('innkapsle',),
'innkapslete': ('innkapsle',),
'innkasserende': ('innkassere',),
'innkassert': ('innkassere',),
'innkasserte': ('innkassere',),
'innkasta': ('innkaste',),
'innkastede': ('innkaste',),
'innkastende': ('innkaste',),
'innkastet': ('innkaste',),
'innkastete': ('innkaste',),
'innkilt': ('innkilt',),
'innkilte': ('innkilt',),
'innkiltere': ('innkilt',),
'innkiltest': ('innkilt',),
'innkilteste': ('innkilt',),
'innkjøpt': ('innkjøpt',),
'innkjøpte': ('innkjøpt',),
'innkjøptere': ('innkjøpt',),
'innkjøptest': ('innkjøpt',),
'innkjøpteste': ('innkjøpt',),
'innkjørende': ('innkjøre',),
'innkjørt': ('innkjøre',),
'innkjørte': ('innkjøre',),
'innklaga': ('innklage',),
'innklagd': ('innklage',),
'innklagde': ('innklage',),
'innklagede': ('innklage',),
'innklagende': ('innklage',),
'innklaget': ('innklage',),
'innklagete': ('innklage',),
'innklarerende': ('innklarere',),
'innklarert': ('innklarere',),
'innklarerte': ('innklarere',),
'innklemt': ('innklemt',),
'innklemte': ('innklemt',),
'innklemtere': ('innklemt',),
'innklemtest': ('innklemt',),
'innklemteste': ('innklemt',),
'innklint': ('innklint',),
'innklinte': ('innklint',),
'innklintere': ('innklint',),
'innklintest': ('innklint',),
'innklinteste': ('innklint',),
'innkobla': ('innkoble',),
'innkoblede': ('innkoble',),
'innkoblende': ('innkoble',),
'innkoblet': ('innkoble',),
'innkoblete': ('innkoble',),
'innkokt': ('innkokt',),
'innkokte': ('innkokt',),
'innkoktere': ('innkokt',),
'innkoktest': ('innkokt',),
'innkokteste': ('innkokt',),
'innkommanderende': ('innkommandere',),
'innkommandert': ('innkommandere',),
'innkommanderte': ('innkommandere',),
'innkommen': ('innkomme',),
'innkommende': ('innkomme',),
'innkommet': ('innkomme',),
'innkomne': ('innkomme',),
'innkopla': ('innkople',),
'innkoplede': ('innkople',),
'innkoplende': ('innkople',),
'innkoplet': ('innkople',),
'innkoplete': ('innkople',),
'innkorta': ('innkorte',),
'innkortede': ('innkorte',),
'innkortende': ('innkorte',),
'innkortet': ('innkorte',),
'innkortete': ('innkorte',),
'innkreva': ('innkreve',),
'innkrevd': ('innkreve',),
'innkrevde': ('innkreve',),
'innkrevede': ('innkreve',),
'innkrevende': ('innkreve',),
'innkrevet': ('innkreve',),
'innkrevete': ('innkreve',),
'innkvarterende': ('innkvartere',),
'innkvartert': ('innkvartere',),
'innkvarterte': ('innkvartere',),
'innlagt': ('innlagt',),
'innlagte': ('innlagt',),
'innlagtere': ('innlagt',),
'innlagtest': ('innlagt',),
'innlagteste': ('innlagt',),
'innlasta': ('innlasta',),
'innlastede': ('innlastet',),
'innlastet': ('innlastet',),
'innlastete': ('innlastet',),
'innlastetere': ('innlastet',),
'innlastetest': ('innlastet',),
'innlasteteste': ('innlastet',),
'innlatende': ('innlate',),
'innlatt': ('innlate',),
'innlatte': ('innlate',),
'innleda': ('innlede',),
'innledede': ('innlede',),
'innledende': ('innlede',),
'innledet': ('innlede',),
'innledete': ('innlede',),
'innlagt': ('innlegge',),
'innlagte': ('innlegge',),
'innleggende': ('innlegge',),
'innleid': ('innleie',),
'innleide': ('innleie',),
'innleiede': ('innleie',),
'innleiende': ('innleie',),
'innleiet': ('innleie',),
'innleiete': ('innleie',),
'innlemma': ('innlemme',),
'innlemmede': ('innlemme',),
'innlemmende': ('innlemme',),
'innlemmet': ('innlemme',),
'innlemmete': ('innlemme',),
'innlesende': ('innlese',),
'innlest': ('innlese',),
'innleste': ('innlese',),
'innleverende': ('innlevere',),
'innlevert': ('innlevere',),
'innleverte': ('innlevere',),
'innlosjerende': ('innlosjere',),
'innlosjert': ('innlosjere',),
'innlosjerte': ('innlosjere',),
'innlysende': ('innlysende',),
'innlånende': ('innlåne',),
'innlånt': ('innlåne',),
'innlånte': ('innlåne',),
'innlåst': ('innlåst',),
'innlåste': ('innlåst',),
'innlåstere': ('innlåst',),
'innlåstest': ('innlåst',),
'innlåsteste': ('innlåst',),
'innlært': ('innlært',),
'innlærte': ('innlært',),
'innlærtere': ('innlært',),
'innlærtest': ('innlært',),
'innlærteste': ('innlært',),
'innløpende': ('innløpe',),
'innløpet': ('innløpe',),
'innløpt': ('innløpe',),
'innløpte': ('innløpe',),
'innløsende': ('innløse',),
'innløst': ('innløse',),
'innløste': ('innløse',),
'innløselig': ('innløselig',),
'innløselige': ('innløselig',),
'innløseligere': ('innløselig',),
'innløseligst': ('innløselig',),
'innløseligste': ('innløselig',),
'innløysende': ('innløyse',),
'innløyst': ('innløyse',),
'innløyste': ('innløyse',),
'innløyselig': ('innløyselig',),
'innløyselige': ('innløyselig',),
'innløyseligere': ('innløyselig',),
'innløyseligst': ('innløyselig',),
'innløyseligste': ('innløyselig',),
'innmari': ('innmari',),
'innmarisk': ('innmarisk',),
'innmariske': ('innmarisk',),
'innmariskere': ('innmarisk',),
'innmariskest': ('innmarisk',),
'innmariskeste': ('innmarisk',),
'innmeldt': ('innmeldt',),
'innmeldte': ('innmeldt',),
'innmeldtere': ('innmeldt',),
'innmeldtest': ('innmeldt',),
'innmeldteste': ('innmeldt',),
'innmura': ('innmure',),
'innmurede': ('innmure',),
'innmurende': ('innmure',),
'innmuret': ('innmure',),
'innmurete': ('innmure',),
'innmurt': ('innmure',),
'innmurte': ('innmure',),
'innordna': ('innordne',),
'innordnede': ('innordne',),
'innordnende': ('innordne',),
'innordnet': ('innordne',),
'innordnete': ('innordne',),
'innovativ': ('innovativ',),
'innovative': ('innovativ',),
'innovativere': ('innovativ',),
'innovativest': ('innovativ',),
'innovativeste': ('innovativ',),
'innovativt': ('innovativ',),
'innoverende': ('innovere',),
'innovert': ('innovere',),
'innoverte': ('innovere',),
'innpakka': ('innpakke',),
'innpakkede': ('innpakke',),
'innpakkende': ('innpakke',),
'innpakket': ('innpakke',),
'innpakkete': ('innpakke',),
'innpassa': ('innpasse',),
'innpassede': ('innpasse',),
'innpassende': ('innpasse',),
'innpasset': ('innpasse',),
'innpassete': ('innpasse',),
'innpasserende': ('innpassere',),
'innpassert': ('innpassere',),
'innpasserte': ('innpassere',),
'innpiska': ('innpiske',),
'innpiskede': ('innpiske',),
'innpiskende': ('innpiske',),
'innpisket': ('innpiske',),
'innpiskete': ('innpiske',),
'innplanta': ('innplante',),
'innplantede': ('innplante',),
'innplantende': ('innplante',),
'innplantet': ('innplante',),
'innplantete': ('innplante',),
'innpoda': ('innpode',),
'innpodede': ('innpode',),
'innpodende': ('innpode',),
'innpodet': ('innpode',),
'innpodete': ('innpode',),
'innpota': ('innpote',),
'innpotede': ('innpote',),
'innpotende': ('innpote',),
'innpotet': ('innpote',),
'innpotete': ('innpote',),
'innprenta': ('innprente',),
'innprentede': ('innprente',),
'innprentende': ('innprente',),
'innprentet': ('innprente',),
'innprentete': ('innprente',),
'innpåsliten': ('innpåsliten',),
'innpåslitent': ('innpåsliten',),
'innpåslitne': ('innpåsliten',),
'innpåslitnere': ('innpåsliten',),
'innpåslitnest': ('innpåsliten',),
'innpåslitneste': ('innpåsliten',),
'innramma': ('innramme',),
'innrammede': ('innramme',),
'innrammende': ('innramme',),
'innrammet': ('innramme',),
'innrammete': ('innramme',),
'innrapporterende': ('innrapportere',),
'innrapportert': ('innrapportere',),
'innrapporterte': ('innrapportere',),
'innreda': ('innrede',),
'innredede': ('innrede',),
'innredende': ('innrede',),
'innredet': ('innrede',),
'innredete': ('innrede',),
'innreid': ('innreie',),
'innreidd': ('innreie',),
'innreidde': ('innreie',),
'innreide': ('innreie',),
'innreiende': ('innreie',),
'innretta': ('innrette',),
'innrettede': ('innrette',),
'innrettende': ('innrette',),
'innrettet': ('innrette',),
'innrettete': ('innrette',),
'innrigga': ('innrigga',),
'innriggede': ('innrigget',),
'innrigget': ('innrigget',),
'innriggete': ('innrigget',),
'innriggetere': ('innrigget',),
'innriggetest': ('innrigget',),
'innriggeteste': ('innrigget',),
'innringa': ('innringe',),
'innringede': ('innringe',),
'innringende': ('innringe',),
'innringet': ('innringe',),
'innringete': ('innringe',),
'innrissa': ('innrissa',),
'innrissede': ('innrisset',),
'innrisset': ('innrisset',),
'innrissete': ('innrisset',),
'innrissetere': ('innrisset',),
'innrissetest': ('innrisset',),
'innrisseteste': ('innrisset',),
'innrullerende': ('innrullere',),
'innrullert': ('innrullere',),
'innrullerte': ('innrullere',),
'innrykka': ('innrykke',),
'innrykkede': ('innrykke',),
'innrykkende': ('innrykke',),
'innrykket': ('innrykke',),
'innrykkete': ('innrykke',),
'innrykt': ('innrykke',),
'innrykte': ('innrykke',),
'innrømma': ('innrømme',),
'innrømmede': ('innrømme',),
'innrømmende': ('innrømme',),
'innrømmet': ('innrømme',),
'innrømmete': ('innrømme',),
'innrømt': ('innrømme',),
'innrømte': ('innrømme',),
'innrøykt': ('innrøykt',),
'innrøykte': ('innrøykt',),
'innrøyktere': ('innrøykt',),
'innrøyktest': ('innrøykt',),
'innrøykteste': ('innrøykt',),
'innsamla': ('innsamle',),
'innsamlede': ('innsamle',),
'innsamlende': ('innsamle',),
'innsamlet': ('innsamle',),
'innsamlete': ('innsamle',),
'innsatt': ('innsatt',),
'innsatte': ('innsatt',),
'innsattere': ('innsatt',),
'innsattest': ('innsatt',),
'innsatteste': ('innsatt',),
'innsausa': ('innsausa',),
'innsausede': ('innsauset',),
'innsauset': ('innsauset',),
'innsausete': ('innsauset',),
'innsausetere': ('innsauset',),
'innsausetest': ('innsauset',),
'innsauseteste': ('innsauset',),
'innseende': ('innse',),
'innsett': ('innse',),
'innsette': ('innse',),
'innsegla': ('innsegle',),
'innseglede': ('innsegle',),
'innseglende': ('innsegle',),
'innseglet': ('innsegle',),
'innseglete': ('innsegle',),
'innseilende': ('innseile',),
'innseilt': ('innseile',),
'innseilte': ('innseile',),
'innsendende': ('innsende',),
'innsendt': ('innsende',),
'innsendte': ('innsende',),
'innsatt': ('innsette',),
'innsatte': ('innsette',),
'innsettende': ('innsette',),
'innsikta': ('innsikte',),
'innsiktede': ('innsikte',),
'innsiktende': ('innsikte',),
'innsiktet': ('innsikte',),
'innsiktete': ('innsikte',),
'innsiktsfull': ('innsiktsfull',),
'innsiktsfulle': ('innsiktsfull',),
'innsiktsfullere': ('innsiktsfull',),
'innsiktsfullest': ('innsiktsfull',),
'innsiktsfulleste': ('innsiktsfull',),
'innsiktsfullt': ('innsiktsfull',),
'innsirkla': ('innsirkle',),
'innsirklede': ('innsirkle',),
'innsirklende': ('innsirkle',),
'innsirklet': ('innsirkle',),
'innsirklete': ('innsirkle',),
'innskipa': ('innskipe',),
'innskipede': ('innskipe',),
'innskipende': ('innskipe',),
'innskipet': ('innskipe',),
'innskipete': ('innskipe',),
'innskjerpa': ('innskjerpe',),
'innskjerpede': ('innskjerpe',),
'innskjerpende': ('innskjerpe',),
'innskjerpet': ('innskjerpe',),
'innskjerpete': ('innskjerpe',),
'innskjærende': ('innskjære',),
'innskåren': ('innskjære',),
'innskåret': ('innskjære',),
'innskårne': ('innskjære',),
'innskrenka': ('innskrenke',),
'innskrenkede': ('innskrenke',),
'innskrenkende': ('innskrenke',),
'innskrenket': ('innskrenke',),
'innskrenkete': ('innskrenke',),
'innskreven': ('innskrive',),
'innskrevet': ('innskrive',),
'innskrevne': ('innskrive',),
'innskrivende': ('innskrive',),
'innskrumpa': ('innskrumpa',),
'innskrumpede': ('innskrumpet',),
'innskrumpet': ('innskrumpet',),
'innskrumpete': ('innskrumpet',),
'innskrumpetere': ('innskrumpet',),
'innskrumpetest': ('innskrumpet',),
'innskrumpeteste': ('innskrumpet',),
'innskutt': ('innskyte',),
'innskutte': ('innskyte',),
'innskytende': ('innskyte',),
'innslått': ('innslått',),
'innslåtte': ('innslått',),
'innslåttere': ('innslått',),
'innslåttest': ('innslått',),
'innslåtteste': ('innslått',),
'innsmigra': ('innsmigre',),
'innsmigrede': ('innsmigre',),
'innsmigrende': ('innsmigre',),
'innsmigret': ('innsmigre',),
'innsmigrete': ('innsmigre',),
'innsmugla': ('innsmugle',),
'innsmuglede': ('innsmugle',),
'innsmuglende': ('innsmugle',),
'innsmuglet': ('innsmugle',),
'innsmuglete': ('innsmugle',),
'innsmurt': ('innsmøre',),
'innsmurte': ('innsmøre',),
'innsmørende': ('innsmøre',),
'innsnevra': ('innsnevre',),
'innsnevrede': ('innsnevre',),
'innsnevrende': ('innsnevre',),
'innsnevret': ('innsnevre',),
'innsnevrete': ('innsnevre',),
'innsnørt': ('innsnørt',),
'innsnørte': ('innsnørt',),
'innsnørtere': ('innsnørt',),
'innsnørtest': ('innsnørt',),
'innsnørteste': ('innsnørt',),
'innspart': ('innspart',),
'innsparte': ('innspart',),
'innspartere': ('innspart',),
'innspartest': ('innspart',),
'innsparteste': ('innspart',),
'innspilt': ('innspilt',),
'innspilte': ('innspilt',),
'innspiltere': ('innspilt',),
'innspiltest': ('innspilt',),
'innspilteste': ('innspilt',),
'innsprengt': ('innsprengt',),
'innsprengte': ('innsprengt',),
'innsprengtere': ('innsprengt',),
'innsprengtest': ('innsprengt',),
'innsprengteste': ('innsprengt',),
'innsprøyta': ('innsprøyte',),
'innsprøytede': ('innsprøyte',),
'innsprøytende': ('innsprøyte',),
'innsprøytet': ('innsprøyte',),
'innsprøytete': ('innsprøyte',),
'innspunne': ('innspunnet',),
'innspunnere': ('innspunnet',),
'innspunnest': ('innspunnet',),
'innspunneste': ('innspunnet',),
'innspunnet': ('innspunnet',),
'innstendig': ('innstendig',),
'innstendige': ('innstendig',),
'innstendigere': ('innstendig',),
'innstendigst': ('innstendig',),
'innstendigste': ('innstendig',),
'innstevna': ('innstevne',),
'innstevnede': ('innstevne',),
'innstevnende': ('innstevne',),
'innstevnet': ('innstevne',),
'innstevnete': ('innstevne',),
'innstevnt': ('innstevne',),
'innstevnte': ('innstevne',),
'innstevna': ('innstevne',),
'innstevnede': ('innstevne',),
'innstevnende': ('innstevne',),
'innstevnet': ('innstevne',),
'innstevnete': ('innstevne',),
'innstevnt': ('innstevne',),
'innstevnte': ('innstevne',),
'innstifta': ('innstifte',),
'innstiftede': ('innstifte',),
'innstiftende': ('innstifte',),
'innstiftet': ('innstifte',),
'innstiftete': ('innstifte',),
'innstillende': ('innstille',),
'innstilt': ('innstille',),
'innstilte': ('innstille',),
'innstramma': ('innstramme',),
'innstrammede': ('innstramme',),
'innstrammende': ('innstramme',),
'innstrammet': ('innstramme',),
'innstrammete': ('innstramme',),
'innstuderende': ('innstudere',),
'innstudert': ('innstudere',),
'innstuderte': ('innstudere',),
'innstukket': ('innstukket',),
'innstukne': ('innstukket',),
'innstuknere': ('innstukket',),
'innstuknest': ('innstukket',),
'innstukneste': ('innstukket',),
'innstøpende': ('innstøpe',),
'innstøpt': ('innstøpe',),
'innstøpte': ('innstøpe',),
'innstøypende': ('innstøype',),
'innstøypt': ('innstøype',),
'innstøypte': ('innstøype',),
'innsuga': ('innsuge',),
'innsugd': ('innsuge',),
'innsugde': ('innsuge',),
'innsugede': ('innsuge',),
'innsugende': ('innsuge',),
'innsuget': ('innsuge',),
'innsugete': ('innsuge',),
'innsunket': ('innsunket',),
'innsunkne': ('innsunket',),
'innsunknere': ('innsunket',),
'innsunknest': ('innsunket',),
'innsunkneste': ('innsunket',),
'innsvinga': ('innsvinga',),
'innsvingede': ('innsvinget',),
'innsvinget': ('innsvinget',),
'innsvingete': ('innsvinget',),
'innsvingetere': ('innsvinget',),
'innsvingetest': ('innsvinget',),
'innsvingeteste': ('innsvinget',),
'innsvingt': ('innsvingt',),
'innsvingte': ('innsvingt',),
'innsvingtere': ('innsvingt',),
'innsvingtest': ('innsvingt',),
'innsvingteste': ('innsvingt',),
'innsvøpt': ('innsvøpt',),
'innsvøpte': ('innsvøpt',),
'innsvøptere': ('innsvøpt',),
'innsvøptest': ('innsvøpt',),
'innsvøpteste': ('innsvøpt',),
'innsydd': ('innsydd',),
'innsydde': ('innsydd',),
'innsyddere': ('innsydd',),
'innsyddest': ('innsydd',),
'innsyddeste': ('innsydd',),
'innsungen': ('innsynge',),
'innsunget': ('innsynge',),
'innsungne': ('innsynge',),
'innsyngende': ('innsynge',),
'innsåpa': ('innsåpa',),
'innsåpede': ('innsåpet',),
'innsåpet': ('innsåpet',),
'innsåpete': ('innsåpet',),
'innsåpetere': ('innsåpet',),
'innsåpetest': ('innsåpet',),
'innsåpeteste': ('innsåpet',),
'innsåpt': ('innsåpt',),
'innsåpte': ('innsåpt',),
'innsåptere': ('innsåpt',),
'innsåptest': ('innsåpt',),
'innsåpteste': ('innsåpt',),
'inntakende': ('innta',),
'inntatt': ('innta',),
'inntatte': ('innta',),
'inntagende': ('inntagende',),
'inntakende': ('inntakende',),
'inntasta': ('inntaste',),
'inntastede': ('inntaste',),
'inntastende': ('inntaste',),
'inntastet': ('inntaste',),
'inntastete': ('inntaste',),
'inntatt': ('inntatt',),
'inntatte': ('inntatt',),
'inntattere': ('inntatt',),
'inntattest': ('inntatt',),
'inntatteste': ('inntatt',),
'inntegna': ('inntegne',),
'inntegnede': ('inntegne',),
'inntegnende': ('inntegne',),
'inntegnet': ('inntegne',),
'inntegnete': ('inntegne',),
'inntektsgivende': ('inntektsgivende',),
'inntilbeins': ('inntilbeins',),
'inntilbens': ('inntilbens',),
'inntjent': ('inntjent',),
'inntjente': ('inntjent',),
'inntjentere': ('inntjent',),
'inntjentest': ('inntjent',),
'inntjenteste': ('inntjent',),
'inntredende': ('inntre',),
'inntrådt': ('inntre',),
'inntrådte': ('inntre',),
'inntreffende': ('inntreffe',),
'inntruffen': ('inntreffe',),
'inntruffet': ('inntreffe',),
'inntrufne': ('inntreffe',),
'inntrengende': ('inntrengende',),
'inntrykksøm': ('inntrykksøm',),
'inntrykksømme': ('inntrykksøm',),
'inntrykksømmere': ('inntrykksøm',),
'inntrykksømmest': ('inntrykksøm',),
'inntrykksømmeste': ('inntrykksøm',),
'inntrykksømt': ('inntrykksøm',),
'inntrykt': ('inntrykt',),
'inntrykte': ('inntrykt',),
'inntryktere': ('inntrykt',),
'inntryktest': ('inntrykt',),
'inntrykteste': ('inntrykt',),
'inntulla': ('inntulla',),
'inntullede': ('inntullet',),
'inntullet': ('inntullet',),
'inntullete': ('inntullet',),
'inntulletere': ('inntullet',),
'inntulletest': ('inntullet',),
'inntulleteste': ('inntullet',),
'inntørka': ('inntørka',),
'inntørkede': ('inntørket',),
'inntørket': ('inntørket',),
'inntørkete': ('inntørket',),
'inntørketere': ('inntørket',),
'inntørketest': ('inntørket',),
'inntørketeste': ('inntørket',),
'innvandra': ('innvandre',),
'innvandrede': ('innvandre',),
'innvandrende': ('innvandre',),
'innvandret': ('innvandre',),
'innvandrete': ('innvandre',),
'innvarsla': ('innvarsle',),
'innvarslede': ('innvarsle',),
'innvarslende': ('innvarsle',),
'innvarslet': ('innvarsle',),
'innvarslete': ('innvarsle',),
'innveid': ('innveie',),
'innveide': ('innveie',),
'innveiede': ('innveie',),
'innveiende': ('innveie',),
'innveiet': ('innveie',),
'innveiete': ('innveie',),
'innvalgt': ('innvelge',),
'innvalgte': ('innvelge',),
'innvelgende': ('innvelge',),
'innvendende': ('innvende',),
'innvendt': ('innvende',),
'innvendte': ('innvende',),
'innvendig': ('innvendig',),
'innvendige': ('innvendig',),
'innvendigere': ('innvendig',),
'innvendigst': ('innvendig',),
'innvendigste': ('innvendig',),
'innvevd': ('innvevd',),
'innvevde': ('innvevd',),
'innvevdere': ('innvevd',),
'innvevdest': ('innvevd',),
'innvevdeste': ('innvevd',),
'innvia': ('innvie',),
'innvidd': ('innvie',),
'innvidde': ('innvie',),
'innviede': ('innvie',),
'innviende': ('innvie',),
'innviet': ('innvie',),
'innviete': ('innvie',),
'innvigd': ('innvie',),
'innvigde': ('innvie',),
'innvikla': ('innvikla',),
'innvikla': ('innvikle',),
'innviklede': ('innvikle',),
'innviklende': ('innvikle',),
'innviklet': ('innvikle',),
'innviklete': ('innvikle',),
'innviklede': ('innviklet',),
'innviklet': ('innviklet',),
'innviklete': ('innviklet',),
'innvikletere': ('innviklet',),
'innvikletest': ('innviklet',),
'innvikleteste': ('innviklet',),
'innvilga': ('innvilge',),
'innvilgede': ('innvilge',),
'innvilgende': ('innvilge',),
'innvilget': ('innvilge',),
'innvilgete': ('innvilge',),
'innvinnende': ('innvinne',),
'innvunne': ('innvinne',),
'innvunnen': ('innvinne',),
'innvunnet': ('innvinne',),
'innvirka': ('innvirke',),
'innvirkede': ('innvirke',),
'innvirkende': ('innvirke',),
'innvirket': ('innvirke',),
'innvirkete': ('innvirke',),
'innvortes': ('innvortes',),
'innvoterende': ('innvotere',),
'innvotert': ('innvotere',),
'innvoterte': ('innvotere',),
'innynda': ('innynde',),
'innyndede': ('innynde',),
'innyndende': ('innynde',),
'innyndet': ('innynde',),
'innyndete': ('innynde',),
'innånda': ('innånde',),
'innåndede': ('innånde',),
'innåndende': ('innånde',),
'innåndet': ('innånde',),
'innåndete': ('innånde',),
'innøva': ('innøve',),
'innøvd': ('innøve',),
'innøvde': ('innøve',),
'innøvede': ('innøve',),
'innøvende': ('innøve',),
'innøvet': ('innøve',),
'innøvete': ('innøve',),
'inokulerende': ('inokulere',),
'inokulert': ('inokulere',),
'inokulerte': ('inokulere',),
'inopportun': ('inopportun',),
'inopportune': ('inopportun',),
'inopportunere': ('inopportun',),
'inopportunest': ('inopportun',),
'inopportuneste': ('inopportun',),
'inopportunt': ('inopportun',),
'insektdrepende': ('insektdrepende',),
'insektetende': ('insektetende',),
'inseminerende': ('inseminere',),
'inseminert': ('inseminere',),
'inseminerte': ('inseminere',),
'insinuant': ('insinuant',),
'insinuante': ('insinuant',),
'insinuantere': ('insinuant',),
'insinuantest': ('insinuant',),
'insinuanteste': ('insinuant',),
'insinuerende': ('insinuere',),
'insinuert': ('insinuere',),
'insinuerte': ('insinuere',),
'insisterende': ('insistere',),
'insistert': ('insistere',),
'insisterte': ('insistere',),
'inspirerende': ('inspirere',),
'inspirert': ('inspirere',),
'inspirerte': ('inspirere',),
'inspiserende': ('inspisere',),
'inspisert': ('inspisere',),
'inspiserte': ('inspisere',),
'instabil': ('instabil',),
'instabile': ('instabil',),
'instabilere': ('instabil',),
'instabilest': ('instabil',),
'instabileste': ('instabil',),
'instabilt': ('instabil',),
'installerende': ('installere',),
'installert': ('installere',),
'installerte': ('installere',),
'instinktiv': ('instinktiv',),
'instinktive': ('instinktiv',),
'instinktivere': ('instinktiv',),
'instinktivest': ('instinktiv',),
'instinktiveste': ('instinktiv',),
'instinktivt': ('instinktiv',),
'instituerende': ('instituere',),
'instituert': ('instituere',),
'instituerte': ('instituere',),
'institusjonaliserende': ('institusjonalisere',),
'institusjonalisert': ('institusjonalisere',),
'institusjonaliserte': ('institusjonalisere',),
'institusjonell': ('institusjonell',),
'institusjonelle': ('institusjonell',),
'institusjonellere': ('institusjonell',),
'institusjonellest': ('institusjonell',),
'institusjonelleste': ('institusjonell',),
'institusjonelt': ('institusjonell',),
'instruerende': ('instruere',),
'instruert': ('instruere',),
'instruerte': ('instruere',),
'instruktiv': ('instruktiv',),
'instruktive': ('instruktiv',),
'instruktivere': ('instruktiv',),
'instruktivest': ('instruktiv',),
'instruktiveste': ('instruktiv',),
'instruktivt': ('instruktiv',),
'instrumental': ('instrumental',),
'instrumentale': ('instrumental',),
'instrumentalere': ('instrumental',),
'instrumentalest': ('instrumental',),
'instrumentaleste': ('instrumental',),
'instrumentalt': ('instrumental',),
'instrumentell': ('instrumentell',),
'instrumentelle': ('instrumentell',),
'instrumentellere': ('instrumentell',),
'instrumentellest': ('instrumentell',),
'instrumentelleste': ('instrumentell',),
'instrumentelt': ('instrumentell',),
'instrumenterende': ('instrumentere',),
'instrumentert': ('instrumentere',),
'instrumenterte': ('instrumentere',),
'insuffisient': ('insuffisient',),
'insulær': ('insulær',),
'insulære': ('insulær',),
'insulærere': ('insulær',),
'insulærest': ('insulær',),
'insulæreste': ('insulær',),
'insulært': ('insulær',),
'intakt': ('intakt',),
'intakte': ('intakt',),
'intaktere': ('intakt',),
'intaktest': ('intakt',),
'intakteste': ('intakt',),
'integrerende': ('integrere',),
'integrert': ('integrere',),
'integrerte': ('integrere',),
'intellektualiserende': ('intellektualisere',),
'intellektualisert': ('intellektualisere',),
'intellektualiserte': ('intellektualisere',),
'intellektualistisk': ('intellektualistisk',),
'intellektualistiske': ('intellektualistisk',),
'intellektualistiskere': ('intellektualistisk',),
'intellektualistiskest': ('intellektualistisk',),
'intellektualistiskeste': ('intellektualistisk',),
'intellektuell': ('intellektuell',),
'intellektuelle': ('intellektuell',),
'intellektuellere': ('intellektuell',),
'intellektuellest': ('intellektuell',),
'intellektuelleste': ('intellektuell',),
'intellektuelt': ('intellektuell',),
'intelligent': ('intelligent',),
'intelligente': ('intelligent',),
'intelligentere': ('intelligent',),
'intelligentest': ('intelligent',),
'intelligenteste': ('intelligent',),
'intelligibel': ('intelligibel',),
'intelligibelt': ('intelligibel',),
'intelligible': ('intelligibel',),
'intelligiblere': ('intelligibel',),
'intelligiblest': ('intelligibel',),
'intelligibleste': ('intelligibel',),
'intenderende': ('intendere',),
'intendert': ('intendere',),
'intenderte': ('intendere',),
'intens': ('intens',),
'intense': ('intens',),
'intensere': ('intens',),
'intensest': ('intens',),
'intenseste': ('intens',),
'intenst': ('intens',),
'intensiv': ('intensiv',),
'intensive': ('intensiv',),
'intensivere': ('intensiv',),
'intensivest': ('intensiv',),
'intensiveste': ('intensiv',),
'intensivt': ('intensiv',),
'intensiverende': ('intensivere',),
'intensivert': ('intensivere',),
'intensiverte': ('intensivere',),
'intensjonal': ('intensjonal',),
'intensjonale': ('intensjonal',),
'intensjonalere': ('intensjonal',),
'intensjonalest': ('intensjonal',),
'intensjonaleste': ('intensjonal',),
'intensjonalt': ('intensjonal',),
'intensjonell': ('intensjonell',),
'intensjonelle': ('intensjonell',),
'intensjonellere': ('intensjonell',),
'intensjonellest': ('intensjonell',),
'intensjonelleste': ('intensjonell',),
'intensjonelt': ('intensjonell',),
'interdental': ('interdental',),
'interdentale': ('interdental',),
'interdentalere': ('interdental',),
'interdentalest': ('interdental',),
'interdentaleste': ('interdental',),
'interdentalt': ('interdental',),
'interdepartemental': ('interdepartemental',),
'interdepartementale': ('interdepartemental',),
'interdepartementalere': ('interdepartemental',),
'interdepartementalest': ('interdepartemental',),
'interdepartementaleste': ('interdepartemental',),
'interdepartementalt': ('interdepartemental',),
'interdisiplinær': ('interdisiplinær',),
'interdisiplinære': ('interdisiplinær',),
'interdisiplinærere': ('interdisiplinær',),
'interdisiplinærest': ('interdisiplinær',),
'interdisiplinæreste': ('interdisiplinær',),
'interdisiplinært': ('interdisiplinær',),
'interessant': ('interessant',),
'interessante': ('interessant',),
'interessantere': ('interessant',),
'interessantest': ('interessant',),
'interessanteste': ('interessant',),
'interesselaus': ('interesselaus',),
'interesselause': ('interesselaus',),
'interesselausere': ('interesselaus',),
'interesselausest': ('interesselaus',),
'interesselauseste': ('interesselaus',),
'interesselaust': ('interesselaus',),
'interesseløs': ('interesseløs',),
'interesseløse': ('interesseløs',),
'interesseløsere': ('interesseløs',),
'interesseløsest': ('interesseløs',),
'interesseløseste': ('interesseløs',),
'interesseløst': ('interesseløs',),
'interesserende': ('interessere',),
'interessert': ('interessere',),
'interesserte': ('interessere',),
'interessevekkende': ('interessevekkende',),
'intereuropeisk': ('intereuropeisk',),
'intereuropeiske': ('intereuropeisk',),
'intereuropeiskere': ('intereuropeisk',),
'intereuropeiskest': ('intereuropeisk',),
'intereuropeiskeste': ('intereuropeisk',),
'interfererende': ('interferere',),
'interferert': ('interferere',),
'interfererte': ('interferere',),
'interfolierende': ('interfoliere',),
'interfoliert': ('interfoliere',),
'interfolierte': ('interfoliere',),
'interglasial': ('interglasial',),
'interglasiale': ('interglasial',),
'interglasialere': ('interglasial',),
'interglasialest': ('interglasial',),
'interglasialeste': ('interglasial',),
'interglasialt': ('interglasial',),
'interimistisk': ('interimistisk',),
'interimistiske': ('interimistisk',),
'interimistiskere': ('interimistisk',),
'interimistiskest': ('interimistisk',),
'interimistiskeste': ('interimistisk',),
'interkommunal': ('interkommunal',),
'interkommunale': ('interkommunal',),
'interkommunalere': ('interkommunal',),
'interkommunalest': ('interkommunal',),
'interkommunaleste': ('interkommunal',),
'interkommunalt': ('interkommunal',),
'interkonfesjonell': ('interkonfesjonell',),
'interkonfesjonelle': ('interkonfesjonell',),
'interkonfesjonellere': ('interkonfesjonell',),
'interkonfesjonellest': ('interkonfesjonell',),
'interkonfesjonelleste': ('interkonfesjonell',),
'interkonfesjonelt': ('interkonfesjonell',),
'interkontinental': ('interkontinental',),
'interkontinentale': ('interkontinental',),
'interkontinentalere': ('interkontinental',),
'interkontinentalest': ('interkontinental',),
'interkontinentaleste': ('interkontinental',),
'interkontinentalt': ('interkontinental',),
'intern': ('intern',),
'interne': ('intern',),
'internere': ('intern',),
'internest': ('intern',),
'interneste': ('intern',),
'internt': ('intern',),
'internasjonal': ('internasjonal',),
'internasjonale': ('internasjonal',),
'internasjonalere': ('internasjonal',),
'internasjonalest': ('internasjonal',),
'internasjonaleste': ('internasjonal',),
'internasjonalt': ('internasjonal',),
'internasjonaliserende': ('internasjonalisere',),
'internasjonalisert': ('internasjonalisere',),
'internasjonaliserte': ('internasjonalisere',),
'internasjonalistisk': ('internasjonalistisk',),
'internasjonalistiske': ('internasjonalistisk',),
'internasjonalistiskere': ('internasjonalistisk',),
'internasjonalistiskest': ('internasjonalistisk',),
'internasjonalistiskeste': ('internasjonalistisk',),
'internerende': ('internere',),
'internert': ('internere',),
'internerte': ('internere',),
'internordisk': ('internordisk',),
'internordiske': ('internordisk',),
'internordiskere': ('internordisk',),
'internordiskest': ('internordisk',),
'internordiskeste': ('internordisk',),
'interparlamentarisk': ('interparlamentarisk',),
'interparlamentariske': ('interparlamentarisk',),
'interparlamentariskere': ('interparlamentarisk',),
'interparlamentariskest': ('interparlamentarisk',),
'interparlamentariskeste': ('interparlamentarisk',),
'interpellerende': ('interpellere',),
'interpellert': ('interpellere',),
'interpellerte': ('interpellere',),
'interplanetarisk': ('interplanetarisk',),
'interplanetariske': ('interplanetarisk',),
'interplanetariskere': ('interplanetarisk',),
'interplanetariskest': ('interplanetarisk',),
'interplanetariskeste': ('interplanetarisk',),
'interpolerende': ('interpolere',),
'interpolert': ('interpolere',),
'interpolerte': ('interpolere',),
'interpreterende': ('interpretere',),
'interpretert': ('interpretere',),
'interpreterte': ('interpretere',),
'interrogativ': ('interrogativ',),
'interrogative': ('interrogativ',),
'interrogativere': ('interrogativ',),
'interrogativest': ('interrogativ',),
'interrogativeste': ('interrogativ',),
'interrogativt': ('interrogativ',),
'interseksuell': ('interseksuell',),
'interseksuelle': ('interseksuell',),
'interseksuellere': ('interseksuell',),
'interseksuellest': ('interseksuell',),
'interseksuelleste': ('interseksuell',),
'interseksuelt': ('interseksuell',),
'interskandinavisk': ('interskandinavisk',),
'interskandinaviske': ('interskandinavisk',),
'interskandinaviskere': ('interskandinavisk',),
'interskandinaviskest': ('interskandinavisk',),
'interskandinaviskeste': ('interskandinavisk',),
'interstellar': ('interstellar',),
'interstellare': ('interstellar',),
'interstellarere': ('interstellar',),
'interstellarest': ('interstellar',),
'interstellareste': ('interstellar',),
'interstellart': ('interstellar',),
'intersubjektiv': ('intersubjektiv',),
'intersubjektive': ('intersubjektiv',),
'intersubjektivere': ('intersubjektiv',),
'intersubjektivest': ('intersubjektiv',),
'intersubjektiveste': ('intersubjektiv',),
'intersubjektivt': ('intersubjektiv',),
'intervenerende': ('intervenere',),
'intervenert': ('intervenere',),
'intervenerte': ('intervenere',),
'intervjua': ('intervjue',),
'intervjuede': ('intervjue',),
'intervjuende': ('intervjue',),
'intervjuet': ('intervjue',),
'intervjuete': ('intervjue',),
'intervokalisk': ('intervokalisk',),
'intervokaliske': ('intervokalisk',),
'intervokaliskere': ('intervokalisk',),
'intervokaliskest': ('intervokalisk',),
'intervokaliskeste': ('intervokalisk',),
'intetanende': ('intetanende',),
'intetsigende': ('intetsigende',),
'intim': ('intim',),
'intime': ('intim',),
'intimere': ('intim',),
'intimest': ('intim',),
'intimeste': ('intim',),
'intimt': ('intim',),
'intimiderende': ('intimidere',),
'intimidert': ('intimidere',),
'intimiderte': ('intimidere',),
'intonerende': ('intonere',),
'intonert': ('intonere',),
'intonerte': ('intonere',),
'intracellulær': ('intracellulær',),
'intracellulære': ('intracellulær',),
'intracellulærere': ('intracellulær',),
'intracellulærest': ('intracellulær',),
'intracellulæreste': ('intracellulær',),
'intracellulært': ('intracellulær',),
'intramolekylær': ('intramolekylær',),
'intramolekylære': ('intramolekylær',),
'intramolekylærere': ('intramolekylær',),
'intramolekylærest': ('intramolekylær',),
'intramolekylæreste': ('intramolekylær',),
'intramolekylært': ('intramolekylær',),
'intransitiv': ('intransitiv',),
'intransitive': ('intransitiv',),
'intransitivere': ('intransitiv',),
'intransitivest': ('intransitiv',),
'intransitiveste': ('intransitiv',),
'intransitivt': ('intransitiv',),
'intravenøs': ('intravenøs',),
'intravenøse': ('intravenøs',),
'intravenøsere': ('intravenøs',),
'intravenøsest': ('intravenøs',),
'intravenøseste': ('intravenøs',),
'intravenøst': ('intravenøs',),
'intrigant': ('intrigant',),
'intrigante': ('intrigant',),
'intrigantere': ('intrigant',),
'intrigantest': ('intrigant',),
'intriganteste': ('intrigant',),
'intrigerende': ('intrigere',),
'intrigert': ('intrigere',),
'intrigerte': ('intrigere',),
'intrikat': ('intrikat',),
'intrikate': ('intrikat',),
'intrikatere': ('intrikat',),
'intrikatest': ('intrikat',),
'intrikateste': ('intrikat',),
'introduserende': ('introdusere',),
'introdusert': ('introdusere',),
'introduserte': ('introdusere',),
'introspektiv': ('introspektiv',),
'introspektive': ('introspektiv',),
'introspektivere': ('introspektiv',),
'introspektivest': ('introspektiv',),
'introspektiveste': ('introspektiv',),
'introspektivt': ('introspektiv',),
'introvert': ('introvert',),
'introverte': ('introvert',),
'introvertere': ('introvert',),
'introvertest': ('introvert',),
'introverteste': ('introvert',),
'intuitiv': ('intuitiv',),
'intuitive': ('intuitiv',),
'intuitivere': ('intuitiv',),
'intuitivest': ('intuitiv',),
'intuitiveste': ('intuitiv',),
'intuitivt': ('intuitiv',),
'invaderende': ('invadere',),
'invadert': ('invadere',),
'invaderte': ('invadere',),
'invalid': ('invalid',),
'invalide': ('invalid',),
'invalidere': ('invalid',),
'invalidest': ('invalid',),
'invalideste': ('invalid',),
'invalidiserende': ('invalidisere',),
'invalidisert': ('invalidisere',),
'invalidiserte': ('invalidisere',),
'invariabel': ('invariabel',),
'invariabelt': ('invariabel',),
'invariable': ('invariabel',),
'invariablere': ('invariabel',),
'invariablest': ('invariabel',),
'invariableste': ('invariabel',),
'invariabel': ('invariabel',),
'invariabelt': ('invariabel',),
'invariable': ('invariabel',),
'invariablere': ('invariabel',),
'invariablest': ('invariabel',),
'invariableste': ('invariabel',),
'inventerende': ('inventere',),
'inventert': ('inventere',),
'inventerte': ('inventere',),
'invers': ('invers',),
'inverse': ('invers',),
'inversere': ('invers',),
'inversest': ('invers',),
'inverseste': ('invers',),
'inverst': ('invers',),
'inverterende': ('invertere',),
'invertert': ('invertere',),
'inverterte': ('invertere',),
'investerende': ('investere',),
'investert': ('investere',),
'investerte': ('investere',),
'inviterende': ('invitere',),
'invitert': ('invitere',),
'inviterte': ('invitere',),
'involverende': ('involvere',),
'involvert': ('involvere',),
'involverte': ('involvere',),
'ioniserende': ('ionisere',),
'ionisert': ('ionisere',),
'ioniserte': ('ionisere',),
'ionogen': ('ionogen',),
'ionogene': ('ionogen',),
'ionogenere': ('ionogen',),
'ionogenest': ('ionogen',),
'ionogeneste': ('ionogen',),
'ionogent': ('ionogen',),
'ionosfærisk': ('ionosfærisk',),
'ionosfæriske': ('ionosfærisk',),
'ionosfæriskere': ('ionosfærisk',),
'ionosfæriskest': ('ionosfærisk',),
'ionosfæriskeste': ('ionosfærisk',),
'irakisk': ('irakisk',),
'irakiske': ('irakisk',),
'irakiskere': ('irakisk',),
'irakiskest': ('irakisk',),
'irakiskeste': ('irakisk',),
'iraksk': ('iraksk',),
'irakske': ('iraksk',),
'irakskere': ('iraksk',),
'irakskest': ('iraksk',),
'irakskeste': ('iraksk',),
'iransk': ('iransk',),
'iranske': ('iransk',),
'iranskere': ('iransk',),
'iranskest': ('iransk',),
'iranskeste': ('iransk',),
'irettesatt': ('irettesette',),
'irettesatte': ('irettesette',),
'irettesettende': ('irettesette',),
'iriserende': ('irisere',),
'irisert': ('irisere',),
'iriserte': ('irisere',),
'irokesisk': ('irokesisk',),
'irokesiske': ('irokesisk',),
'irokesiskere': ('irokesisk',),
'irokesiskest': ('irokesisk',),
'irokesiskeste': ('irokesisk',),
'ironiserende': ('ironisere',),
'ironisert': ('ironisere',),
'ironiserte': ('ironisere',),
'ironisk': ('ironisk',),
'ironiske': ('ironisk',),
'ironiskere': ('ironisk',),
'ironiskest': ('ironisk',),
'ironiskeste': ('ironisk',),
'irrasjonal': ('irrasjonal',),
'irrasjonale': ('irrasjonal',),
'irrasjonalere': ('irrasjonal',),
'irrasjonalest': ('irrasjonal',),
'irrasjonaleste': ('irrasjonal',),
'irrasjonalt': ('irrasjonal',),
'irrasjonell': ('irrasjonell',),
'irrasjonelle': ('irrasjonell',),
'irrasjonellere': ('irrasjonell',),
'irrasjonellest': ('irrasjonell',),
'irrasjonelleste': ('irrasjonell',),
'irrasjonelt': ('irrasjonell',),
'irra': ('irre',),
'irrede': ('irre',),
'irrende': ('irre',),
'irret': ('irre',),
'irrete': ('irre',),
'irra': ('irre',),
'irrede': ('irre',),
'irrende': ('irre',),
'irret': ('irre',),
'irrete': ('irre',),
'irreal': ('irreal',),
'irreale': ('irreal',),
'irrealere': ('irreal',),
'irrealest': ('irreal',),
'irrealeste': ('irreal',),
'irrealt': ('irreal',),
'irreell': ('irreell',),
'irreelle': ('irreell',),
'irreellere': ('irreell',),
'irreellest': ('irreell',),
'irreelleste': ('irreell',),
'irreelt': ('irreell',),
'irreligiøs': ('irreligiøs',),
'irreligiøse': ('irreligiøs',),
'irreligiøsere': ('irreligiøs',),
'irreligiøsest': ('irreligiøs',),
'irreligiøseste': ('irreligiøs',),
'irreligiøst': ('irreligiøs',),
'irreparabel': ('irreparabel',),
'irreparabelt': ('irreparabel',),
'irreparable': ('irreparabel',),
'irreparablere': ('irreparabel',),
'irreparablest': ('irreparabel',),
'irreparableste': ('irreparabel',),
'irret': ('irret',),
'irrete': ('irret',),
'irretere': ('irret',),
'irretest': ('irret',),
'irreteste': ('irret',),
'irrete': ('irrete',),
'irreversibel': ('irreversibel',),
'irreversibelt': ('irreversibel',),
'irreversible': ('irreversibel',),
'irreversiblere': ('irreversibel',),
'irreversiblest': ('irreversibel',),
'irreversibleste': ('irreversibel',),
'irrgrøn': ('irrgrøn',),
'irrgrøne': ('irrgrøn',),
'irrgrønere': ('irrgrøn',),
'irrgrønest': ('irrgrøn',),
'irrgrøneste': ('irrgrøn',),
'irrgrønt': ('irrgrøn',),
'irrgrønn': ('irrgrønn',),
'irrgrønne': ('irrgrønn',),
'irrgrønnere': ('irrgrønn',),
'irrgrønnest': ('irrgrønn',),
'irrgrønneste': ('irrgrønn',),
'irrgrønt': ('irrgrønn',),
'irrigerende': ('irrigere',),
'irrigert': ('irrigere',),
'irrigerte': ('irrigere',),
'irritabel': ('irritabel',),
'irritabelt': ('irritabel',),
'irritable': ('irritabel',),
'irritablere': ('irritabel',),
'irritablest': ('irritabel',),
'irritableste': ('irritabel',),
'irriterende': ('irritere',),
'irritert': ('irritere',),
'irriterte': ('irritere',),
'irsk': ('irsk',),
'irske': ('irsk',),
'irskere': ('irsk',),
'irskest': ('irsk',),
'irskeste': ('irsk',),
'isblå': ('isblå',),
'isblåe': ('isblå',),
'isblåere': ('isblå',),
'isblåest': ('isblå',),
'isblåeste': ('isblå',),
'isblått': ('isblå',),
'iscenesatt': ('iscenesette',),
'iscenesatte': ('iscenesette',),
'iscenesettende': ('iscenesette',),
'isa': ('ise',),
'isede': ('ise',),
'isende': ('ise',),
'iset': ('ise',),
'isete': ('ise',),
'ist': ('ise',),
'iste': ('ise',),
'isende': ('isende',),
'iset': ('iset',),
'isete': ('iset',),
'isetere': ('iset',),
'isetest': ('iset',),
'iseteste': ('iset',),
'isete': ('isete',),
'isgrønn': ('isgrønn',),
'isgrønne': ('isgrønn',),
'isgrønnere': ('isgrønn',),
'isgrønnest': ('isgrønn',),
'isgrønneste': ('isgrønn',),
'isgrønt': ('isgrønn',),
'isgående': ('isgående',),
'iskald': ('iskald',),
'iskalde': ('iskald',),
'iskaldere': ('iskald',),
'iskaldest': ('iskald',),
'iskaldeste': ('iskald',),
'iskaldt': ('iskald',),
'islagt': ('islagt',),
'islagte': ('islagt',),
'islagtere': ('islagt',),
'islagtest': ('islagt',),
'islagteste': ('islagt',),
'islamiserende': ('islamisere',),
'islamisert': ('islamisere',),
'islamiserte': ('islamisere',),
'islamittisk': ('islamittisk',),
'islamittiske': ('islamittisk',),
'islamittiskere': ('islamittisk',),
'islamittiskest': ('islamittisk',),
'islamittiskeste': ('islamittisk',),
'islamsk': ('islamsk',),
'islamske': ('islamsk',),
'islamskere': ('islamsk',),
'islamskest': ('islamsk',),
'islamskeste': ('islamsk',),
'islandsk': ('islandsk',),
'islandske': ('islandsk',),
'islandskere': ('islandsk',),
'islandskest': ('islandsk',),
'islandskeste': ('islandsk',),
'isna': ('isne',),
'isnede': ('isne',),
'isnende': ('isne',),
'isnet': ('isne',),
'isnete': ('isne',),
'isokron': ('isokron',),
'isokrone': ('isokron',),
'isokronere': ('isokron',),
'isokronest': ('isokron',),
'isokroneste': ('isokron',),
'isokront': ('isokron',),
'isolasjonistisk': ('isolasjonistisk',),
'isolasjonistiske': ('isolasjonistisk',),
'isolasjonistiskere': ('isolasjonistisk',),
'isolasjonistiskest': ('isolasjonistisk',),
'isolasjonistiskeste': ('isolasjonistisk',),
'isolerende': ('isolere',),
'isolert': ('isolere',),
'isolerte': ('isolere',),
'isometrisk': ('isometrisk',),
'isometriske': ('isometrisk',),
'isometriskere': ('isometrisk',),
'isometriskest': ('isometrisk',),
'isometriskeste': ('isometrisk',),
'isomorf': ('isomorf',),
'isomorfe': ('isomorf',),
'isomorfere': ('isomorf',),
'isomorfest': ('isomorf',),
'isomorfeste': ('isomorf',),
'isomorft': ('isomorf',),
'isoterm': ('isoterm',),
'isoterme': ('isoterm',),
'isotermere': ('isoterm',),
'isotermest': ('isoterm',),
'isotermeste': ('isoterm',),
'isotermt': ('isoterm',),
'isotermisk': ('isotermisk',),
'isotermiske': ('isotermisk',),
'isotermiskere': ('isotermisk',),
'isotermiskest': ('isotermisk',),
'isotermiskeste': ('isotermisk',),
'isotonisk': ('isotonisk',),
'isotoniske': ('isotonisk',),
'isotoniskere': ('isotonisk',),
'isotoniskest': ('isotonisk',),
'isotoniskeste': ('isotonisk',),
'isotop': ('isotop',),
'isotope': ('isotop',),
'isotopere': ('isotop',),
'isotopest': ('isotop',),
'isotopeste': ('isotop',),
'isotopt': ('isotop',),
'isotopisk': ('isotopisk',),
'isotopiske': ('isotopisk',),
'isotopiskere': ('isotopisk',),
'isotopiskest': ('isotopisk',),
'isotopiskeste': ('isotopisk',),
'isotrop': ('isotrop',),
'isotrope': ('isotrop',),
'isotropere': ('isotrop',),
'isotropest': ('isotrop',),
'isotropeste': ('isotrop',),
'isotropt': ('isotrop',),
'ispedd': ('ispe',),
'ispedde': ('ispe',),
'ispeende': ('ispe',),
'isprengt': ('isprengt',),
'isprengte': ('isprengt',),
'isprengtere': ('isprengt',),
'isprengtest': ('isprengt',),
'isprengteste': ('isprengt',),
'israelittisk': ('israelittisk',),
'israelittiske': ('israelittisk',),
'israelittiskere': ('israelittisk',),
'israelittiskest': ('israelittisk',),
'israelittiskeste': ('israelittisk',),
'israelsk': ('israelsk',),
'israelske': ('israelsk',),
'israelskere': ('israelsk',),
'israelskest': ('israelsk',),
'israelskeste': ('israelsk',),
'istandsatt': ('istandsatt',),
'istandsatte': ('istandsatt',),
'istandsattere': ('istandsatt',),
'istandsattest': ('istandsatt',),
'istandsatteste': ('istandsatt',),
'istemmende': ('istemme',),
'istemt': ('istemme',),
'istemte': ('istemme',),
'istykkerslått': ('istykkerslått',),
'istykkerslåtte': ('istykkerslått',),
'istykkerslåttere': ('istykkerslått',),
'istykkerslåttest': ('istykkerslått',),
'istykkerslåtteste': ('istykkerslått',),
'italiensk': ('italiensk',),
'italienske': ('italiensk',),
'italienskere': ('italiensk',),
'italienskest': ('italiensk',),
'italienskeste': ('italiensk',),
'italisk': ('italisk',),
'italiske': ('italisk',),
'italiskere': ('italisk',),
'italiskest': ('italisk',),
'italiskeste': ('italisk',),
'iterativ': ('iterativ',),
'iterative': ('iterativ',),
'iterativere': ('iterativ',),
'iterativest': ('iterativ',),
'iterativeste': ('iterativ',),
'iterativt': ('iterativ',),
'itererende': ('iterere',),
'iterert': ('iterere',),
'itererte': ('iterere',),
'ivaretakende': ('ivareta',),
'ivaretatt': ('ivareta',),
'ivaretatte': ('ivareta',),
'iverksatt': ('iverksette',),
'iverksatte': ('iverksette',),
'iverksettende': ('iverksette',),
'ivoriansk': ('ivoriansk',),
'ivorianske': ('ivoriansk',),
'ivorianskere': ('ivoriansk',),
'ivorianskest': ('ivoriansk',),
'ivorianskeste': ('ivoriansk',),
'ivra': ('ivre',),
'ivrede': ('ivre',),
'ivrende': ('ivre',),
'ivret': ('ivre',),
'ivrete': ('ivre',),
'ivrig': ('ivrig',),
'ivrige': ('ivrig',),
'ivrigere': ('ivrig',),
'ivrigst': ('ivrig',),
'ivrigste': ('ivrig',),
'iørefallende': ('iørefallende',),
'iøynefallende': ('iøynefallende',),
'jabba': ('jabbe',),
'jabbede': ('jabbe',),
'jabbende': ('jabbe',),
'jabbet': ('jabbe',),
'jabbete': ('jabbe',),
'jabba': ('jabbe',),
'jabbede': ('jabbe',),
'jabbende': ('jabbe',),
'jabbet': ('jabbe',),
'jabbete': ('jabbe',),
'jafsa': ('jafse',),
'jafsede': ('jafse',),
'jafsende': ('jafse',),
'jafset': ('jafse',),
'jafsete': ('jafse',),
'jaga': ('jage',),
'jagd': ('jage',),
'jagde': ('jage',),
'jagede': ('jage',),
'jagende': ('jage',),
'jaget': ('jage',),
'jagete': ('jage',),
'jaktbar': ('jaktbar',),
'jaktbare': ('jaktbar',),
'jaktbarere': ('jaktbar',),
'jaktbarest': ('jaktbar',),
'jaktbareste': ('jaktbar',),
'jaktbart': ('jaktbar',),
'jakta': ('jakte',),
'jaktede': ('jakte',),
'jaktende': ('jakte',),
'jaktet': ('jakte',),
'jaktete': ('jakte',),
'jakutisk': ('jakutisk',),
'jakutiske': ('jakutisk',),
'jakutiskere': ('jakutisk',),
'jakutiskest': ('jakutisk',),
'jakutiskeste': ('jakutisk',),
'jalma': ('jalme',),
'jalmede': ('jalme',),
'jalmende': ('jalme',),
'jalmet': ('jalme',),
'jalmete': ('jalme',),
'jamaicansk': ('jamaicansk',),
'jamaicanske': ('jamaicansk',),
'jamaicanskere': ('jamaicansk',),
'jamaicanskest': ('jamaicansk',),
'jamaicanskeste': ('jamaicansk',),
'jamaicansk': ('jamaicansk',),
'jamaicanske': ('jamaicansk',),
'jamaicanskere': ('jamaicansk',),
'jamaicanskest': ('jamaicansk',),
'jamaicanskeste': ('jamaicansk',),
'jamaikansk': ('jamaikansk',),
'jamaikanske': ('jamaikansk',),
'jamaikanskere': ('jamaikansk',),
'jamaikanskest': ('jamaikansk',),
'jamaikanskeste': ('jamaikansk',),
'jamaikansk': ('jamaikansk',),
'jamaikanske': ('jamaikansk',),
'jamaikanskere': ('jamaikansk',),
'jamaikanskest': ('jamaikansk',),
'jamaikanskeste': ('jamaikansk',),
'jamaldra': ('jamaldra',),
'jamaldrede': ('jamaldret',),
'jamaldret': ('jamaldret',),
'jamaldrete': ('jamaldret',),
'jamaldretere': ('jamaldret',),
'jamaldretest': ('jamaldret',),
'jamaldreteste': ('jamaldret',),
'jambisk': ('jambisk',),
'jambiske': ('jambisk',),
'jambiskere': ('jambisk',),
'jambiskest': ('jambisk',),
'jambiskeste': ('jambisk',),
'jambyrdig': ('jambyrdig',),
'jambyrdige': ('jambyrdig',),
'jambyrdigere': ('jambyrdig',),
'jambyrdigst': ('jambyrdig',),
'jambyrdigste': ('jambyrdig',),
'jamførende': ('jamføre',),
'jamført': ('jamføre',),
'jamførte': ('jamføre',),
'jameldre': ('jamgammel',),
'jameldst': ('jamgammel',),
'jameldste': ('jamgammel',),
'jamgamle': ('jamgammel',),
'jamgammel': ('jamgammel',),
'jamgammelt': ('jamgammel',),
'jambedre': ('jamgod',),
'jambest': ('jamgod',),
'jambeste': ('jamgod',),
'jamgod': ('jamgod',),
'jamgode': ('jamgod',),
'jamgodt': ('jamgod',),
'jamlang': ('jamlang',),
'jamlange': ('jamlang',),
'jamlangt': ('jamlang',),
'jamlenger': ('jamlang',),
'jamlengre': ('jamlang',),
'jamlengst': ('jamlang',),
'jamlengste': ('jamlang',),
'jamlik': ('jamlik',),
'jamlike': ('jamlik',),
'jamlikere': ('jamlik',),
'jamlikest': ('jamlik',),
'jamlikeste': ('jamlik',),
'jamlikt': ('jamlik',),
'jamma': ('jamme',),
'jammede': ('jamme',),
'jammende': ('jamme',),
'jammet': ('jamme',),
'jammete': ('jamme',),
'jamma': ('jamme',),
'jammede': ('jamme',),
'jammende': ('jamme',),
'jammet': ('jamme',),
'jammete': ('jamme',),
'jammerlig': ('jammerlig',),
'jammerlige': ('jammerlig',),
'jammerligere': ('jammerlig',),
'jammerligst': ('jammerlig',),
'jammerligste': ('jammerlig',),
'jamn': ('jamn',),
'jamne': ('jamn',),
'jamnere': ('jamn',),
'jamnest': ('jamn',),
'jamneste': ('jamn',),
'jamt': ('jamn',),
'jamna': ('jamne',),
'jamnede': ('jamne',),
'jamnende': ('jamne',),
'jamnet': ('jamne',),
'jamnete': ('jamne',),
'jamra': ('jamre',),
'jamrede': ('jamre',),
'jamrende': ('jamre',),
'jamret': ('jamre',),
'jamrete': ('jamre',),
'jamspelt': ('jamspelt',),
'jamspelte': ('jamspelt',),
'jamspeltere': ('jamspelt',),
'jamspeltest': ('jamspelt',),
'jamspelteste': ('jamspelt',),
'jamspilt': ('jamspilt',),
'jamspilte': ('jamspilt',),
'jamspiltere': ('jamspilt',),
'jamspiltest': ('jamspilt',),
'jamspilteste': ('jamspilt',),
'jamsterk': ('jamsterk',),
'jamsterke': ('jamsterk',),
'jamsterkere': ('jamsterk',),
'jamsterkest': ('jamsterk',),
'jamsterkeste': ('jamsterk',),
'jamsterkt': ('jamsterk',),
'jamstillende': ('jamstille',),
'jamstilt': ('jamstille',),
'jamstilte': ('jamstille',),
'jamstor': ('jamstor',),
'jamstore': ('jamstor',),
'jamstort': ('jamstor',),
'jamstørre': ('jamstor',),
'jamstørst': ('jamstor',),
'jamstørste': ('jamstor',),
'jamtjukk': ('jamtjukk',),
'jamtjukke': ('jamtjukk',),
'jamtjukkere': ('jamtjukk',),
'jamtjukkest': ('jamtjukk',),
'jamtjukkeste': ('jamtjukk',),
'jamtjukt': ('jamtjukk',),
'jamtykk': ('jamtykk',),
'jamtykke': ('jamtykk',),
'jamtykkere': ('jamtykk',),
'jamtykkest': ('jamtykk',),
'jamtykkeste': ('jamtykk',),
'jamtykt': ('jamtykk',),
'japansk': ('japansk',),
'japanske': ('japansk',),
'japanskere': ('japansk',),
'japanskest': ('japansk',),
'japanskeste': ('japansk',),
'jara': ('jare',),
'jarede': ('jare',),
'jarende': ('jare',),
'jaret': ('jare',),
'jarete': ('jare',),
'jaska': ('jaske',),
'jaskede': ('jaske',),
'jaskende': ('jaske',),
'jasket': ('jaske',),
'jaskete': ('jaske',),
'jasket': ('jasket',),
'jaskete': ('jasket',),
'jasketere': ('jasket',),
'jasketest': ('jasket',),
'jasketeste': ('jasket',),
'jaskete': ('jaskete',),
'jassa': ('jasse',),
'jassede': ('jasse',),
'jassende': ('jasse',),
'jasset': ('jasse',),
'jassete': ('jasse',),
'jassifiserende': ('jassifisere',),
'jassifisert': ('jassifisere',),
'jassifiserte': ('jassifisere',),
'jatta': ('jatte',),
'jattede': ('jatte',),
'jattende': ('jatte',),
'jattet': ('jatte',),
'jattete': ('jatte',),
'jattet': ('jattet',),
'jattete': ('jattet',),
'jattetere': ('jattet',),
'jattetest': ('jattet',),
'jatteteste': ('jattet',),
'jattete': ('jattete',),
'javanesisk': ('javanesisk',),
'javanesiske': ('javanesisk',),
'javanesiskere': ('javanesisk',),
'javanesiskest': ('javanesisk',),
'javanesiskeste': ('javanesisk',),
'jazza': ('jazze',),
'jazzede': ('jazze',),
'jazzende': ('jazze',),
'jazzet': ('jazze',),
'jazzete': ('jazze',),
'jazzifiserende': ('jazzifisere',),
'jazzifisert': ('jazzifisere',),
'jazzifiserte': ('jazzifisere',),
'jekka': ('jekke',),
'jekkede': ('jekke',),
'jekkende': ('jekke',),
'jekket': ('jekke',),
'jekkete': ('jekke',),
'jelka': ('jelke',),
'jelkede': ('jelke',),
'jelkende': ('jelke',),
'jelket': ('jelke',),
'jelkete': ('jelke',),
'jemenittisk': ('jemenittisk',),
'jemenittiske': ('jemenittisk',),
'jemenittiskere': ('jemenittisk',),
'jemenittiskest': ('jemenittisk',),
'jemenittiskeste': ('jemenittisk',),
'jemenittisk': ('jemenittisk',),
'jemenittiske': ('jemenittisk',),
'jemenittiskere': ('jemenittisk',),
'jemenittiskest': ('jemenittisk',),
'jemenittiskeste': ('jemenittisk',),
'jenka': ('jenke',),
'jenkede': ('jenke',),
'jenkende': ('jenke',),
'jenket': ('jenke',),
'jenkete': ('jenke',),
'jentegalen': ('jentegalen',),
'jentegalent': ('jentegalen',),
'jentegalne': ('jentegalen',),
'jentegalnere': ('jentegalen',),
'jentegalnest': ('jentegalen',),
'jentegalneste': ('jentegalen',),
'jernfattig': ('jernfattig',),
'jernfattige': ('jernfattig',),
'jernfattigere': ('jernfattig',),
'jernfattigst': ('jernfattig',),
'jernfattigste': ('jernfattig',),
'jernførende': ('jernførende',),
'jernhard': ('jernhard',),
'jernharde': ('jernhard',),
'jernhardere': ('jernhard',),
'jernhardest': ('jernhard',),
'jernhardeste': ('jernhard',),
'jernhardt': ('jernhard',),
'jernholdig': ('jernholdig',),
'jernholdige': ('jernholdig',),
'jernholdigere': ('jernholdig',),
'jernholdigst': ('jernholdig',),
'jernholdigste': ('jernholdig',),
'jesuittisk': ('jesuittisk',),
'jesuittiske': ('jesuittisk',),
'jesuittiskere': ('jesuittisk',),
'jesuittiskest': ('jesuittisk',),
'jesuittiskeste': ('jesuittisk',),
'jetdrevet': ('jetdrevet',),
'jetdrevne': ('jetdrevet',),
'jetdrevnere': ('jetdrevet',),
'jetdrevnest': ('jetdrevet',),
'jetdrevneste': ('jetdrevet',),
'jettesterk': ('jettesterk',),
'jettesterke': ('jettesterk',),
'jettesterkere': ('jettesterk',),
'jettesterkest': ('jettesterk',),
'jettesterkeste': ('jettesterk',),
'jettesterkt': ('jettesterk',),
'jettestor': ('jettestor',),
'jettestore': ('jettestor',),
'jettestort': ('jettestor',),
'jettestørre': ('jettestor',),
'jettestørst': ('jettestor',),
'jettestørste': ('jettestor',),
'jevn': ('jevn',),
'jevne': ('jevn',),
'jevnere': ('jevn',),
'jevnest': ('jevn',),
'jevneste': ('jevn',),
'jevnt': ('jevn',),
'jevnaldrende': ('jevnaldrende',),
'jevnbyrdig': ('jevnbyrdig',),
'jevnbyrdige': ('jevnbyrdig',),
'jevnbyrdigere': ('jevnbyrdig',),
'jevnbyrdigst': ('jevnbyrdig',),
'jevnbyrdigste': ('jevnbyrdig',),
'jevna': ('jevne',),
'jevnede': ('jevne',),
'jevnende': ('jevne',),
'jevnet': ('jevne',),
'jevnete': ('jevne',),
'jevnførende': ('jevnføre',),
'jevnført': ('jevnføre',),
'jevnførte': ('jevnføre',),
'jevneldre': ('jevngammel',),
'jevneldst': ('jevngammel',),
'jevneldste': ('jevngammel',),
'jevngamle': ('jevngammel',),
'jevngammel': ('jevngammel',),
'jevngammelt': ('jevngammel',),
'jevnbedre': ('jevngod',),
'jevnbest': ('jevngod',),
'jevnbeste': ('jevngod',),
'jevngod': ('jevngod',),
'jevngode': ('jevngod',),
'jevngodt': ('jevngod',),
'jevnlang': ('jevnlang',),
'jevnlange': ('jevnlang',),
'jevnlangt': ('jevnlang',),
'jevnlenger': ('jevnlang',),
'jevnlengre': ('jevnlang',),
'jevnlengst': ('jevnlang',),
'jevnlengste': ('jevnlang',),
'jevnlik': ('jevnlik',),
'jevnlike': ('jevnlik',),
'jevnlikere': ('jevnlik',),
'jevnlikest': ('jevnlik',),
'jevnlikeste': ('jevnlik',),
'jevnlikt': ('jevnlik',),
'jevnspelt': ('jevnspelt',),
'jevnspelte': ('jevnspelt',),
'jevnspeltere': ('jevnspelt',),
'jevnspeltest': ('jevnspelt',),
'jevnspelteste': ('jevnspelt',),
'jevnspilt': ('jevnspilt',),
'jevnspilte': ('jevnspilt',),
'jevnspiltere': ('jevnspilt',),
'jevnspiltest': ('jevnspilt',),
'jevnspilteste': ('jevnspilt',),
'jevnsterk': ('jevnsterk',),
'jevnsterke': ('jevnsterk',),
'jevnsterkere': ('jevnsterk',),
'jevnsterkest': ('jevnsterk',),
'jevnsterkeste': ('jevnsterk',),
'jevnsterkt': ('jevnsterk',),
'jevnstor': ('jevnstor',),
'jevnstore': ('jevnstor',),
'jevnstort': ('jevnstor',),
'jevnstørre': ('jevnstor',),
'jevnstørst': ('jevnstor',),
'jevnstørste': ('jevnstor',),
'jevntjukk': ('jevntjukk',),
'jevntjukke': ('jevntjukk',),
'jevntjukkere': ('jevntjukk',),
'jevntjukkest': ('jevntjukk',),
'jevntjukkeste': ('jevntjukk',),
'jevntjukt': ('jevntjukk',),
'jevntykk': ('jevntykk',),
'jevntykke': ('jevntykk',),
'jevntykkere': ('jevntykk',),
'jevntykkest': ('jevntykk',),
'jevntykkeste': ('jevntykk',),
'jevntykt': ('jevntykk',),
'jibba': ('jibbe',),
'jibbede': ('jibbe',),
'jibbende': ('jibbe',),
'jibbet': ('jibbe',),
'jibbete': ('jibbe',),
'jiddisch': ('jiddisch',),
'jiddische': ('jiddisch',),
'jiddischere': ('jiddisch',),
'jiddischest': ('jiddisch',),
'jiddischeste': ('jiddisch',),
'jiddisk': ('jiddisk',),
'jiddiske': ('jiddisk',),
'jiddiskere': ('jiddisk',),
'jiddiskest': ('jiddisk',),
'jiddiskeste': ('jiddisk',),
'jobba': ('jobbe',),
'jobbede': ('jobbe',),
'jobbende': ('jobbe',),
'jobbet': ('jobbe',),
'jobbete': ('jobbe',),
'joderende': ('jodere',),
'jodert': ('jodere',),
'joderte': ('jodere',),
'jodiserende': ('jodisere',),
'jodisert': ('jodisere',),
'jodiserte': ('jodisere',),
'jodla': ('jodle',),
'jodlede': ('jodle',),
'jodlende': ('jodle',),
'jodlet': ('jodle',),
'jodlete': ('jodle',),
'jogga': ('jogge',),
'joggede': ('jogge',),
'joggende': ('jogge',),
'jogget': ('jogge',),
'joggete': ('jogge',),
'joika': ('joike',),
'joikede': ('joike',),
'joikende': ('joike',),
'joiket': ('joike',),
'joikete': ('joike',),
'jomfruelig': ('jomfruelig',),
'jomfruelige': ('jomfruelig',),
'jomfrueligere': ('jomfruelig',),
'jomfrueligst': ('jomfruelig',),
'jomfrueligste': ('jomfruelig',),
'jomfrunalsk': ('jomfrunalsk',),
'jomfrunalske': ('jomfrunalsk',),
'jomfrunalskere': ('jomfrunalsk',),
'jomfrunalskest': ('jomfrunalsk',),
'jomfrunalskeste': ('jomfrunalsk',),
'jonisk': ('jonisk',),
'joniske': ('jonisk',),
'joniskere': ('jonisk',),
'joniskest': ('jonisk',),
'joniskeste': ('jonisk',),
'jordansk': ('jordansk',),
'jordanske': ('jordansk',),
'jordanskere': ('jordansk',),
'jordanskest': ('jordansk',),
'jordanskeste': ('jordansk',),
'jordbunden': ('jordbunden',),
'jordbundet': ('jordbunden',),
'jordbundne': ('jordbunden',),
'jordbundnere': ('jordbunden',),
'jordbundnest': ('jordbunden',),
'jordbundneste': ('jordbunden',),
'jordbundet': ('jordbundet',),
'jordbundne': ('jordbundet',),
'jordbundnere': ('jordbundet',),
'jordbundnest': ('jordbundet',),
'jordbundneste': ('jordbundet',),
'jorda': ('jorde',),
'jordede': ('jorde',),
'jordende': ('jorde',),
'jordet': ('jorde',),
'jordete': ('jorde',),
'jordet': ('jordet',),
'jordete': ('jordet',),
'jordetere': ('jordet',),
'jordetest': ('jordet',),
'jordeteste': ('jordet',),
'jordete': ('jordete',),
'jordfast': ('jordfast',),
'jordfaste': ('jordfast',),
'jordfastere': ('jordfast',),
'jordfastest': ('jordfast',),
'jordfasteste': ('jordfast',),
'jordfesta': ('jordfeste',),
'jordfestede': ('jordfeste',),
'jordfestende': ('jordfeste',),
'jordfestet': ('jordfeste',),
'jordfestete': ('jordfeste',),
'jordisk': ('jordisk',),
'jordiske': ('jordisk',),
'jordiskere': ('jordisk',),
'jordiskest': ('jordisk',),
'jordiskeste': ('jordisk',),
'jordnær': ('jordnær',),
'jordnære': ('jordnær',),
'jordnærere': ('jordnær',),
'jordnærest': ('jordnær',),
'jordnæreste': ('jordnær',),
'jordnært': ('jordnær',),
'jordskjelvsikker': ('jordskjelvsikker',),
'jordskjelvsikkert': ('jordskjelvsikker',),
'jordskjelvsikre': ('jordskjelvsikker',),
'jordskjelvsikrere': ('jordskjelvsikker',),
'jordskjelvsikrest': ('jordskjelvsikker',),
'jordskjelvsikreste': ('jordskjelvsikker',),
'jordslående': ('jordslå',),
'jordslått': ('jordslå',),
'jordslåtte': ('jordslå',),
'jordslått': ('jordslått',),
'jordslåtte': ('jordslått',),
'jordslåttere': ('jordslått',),
'jordslåttest': ('jordslått',),
'jordslåtteste': ('jordslått',),
'jorta': ('jorte',),
'jortede': ('jorte',),
'jortende': ('jorte',),
'jortet': ('jorte',),
'jortete': ('jorte',),
'jourhavende': ('jourhavende',),
'journalførende': ('journalføre',),
'journalført': ('journalføre',),
'journalførte': ('journalføre',),
'journaliserende': ('journalisere',),
'journalisert': ('journalisere',),
'journaliserte': ('journalisere',),
'journalistisk': ('journalistisk',),
'journalistiske': ('journalistisk',),
'journalistiskere': ('journalistisk',),
'journalistiskest': ('journalistisk',),
'journalistiskeste': ('journalistisk',),
'jovial': ('jovial',),
'joviale': ('jovial',),
'jovialere': ('jovial',),
'jovialest': ('jovial',),
'jovialeste': ('jovial',),
'jovialt': ('jovial',),
'jubilerende': ('jubilere',),
'jubilert': ('jubilere',),
'jubilerte': ('jubilere',),
'jubla': ('juble',),
'jublede': ('juble',),
'jublende': ('juble',),
'jublet': ('juble',),
'jublete': ('juble',),
'judeisk': ('judeisk',),
'judeiske': ('judeisk',),
'judeiskere': ('judeisk',),
'judeiskest': ('judeisk',),
'judeiskeste': ('judeisk',),
'judisiell': ('judisiell',),
'judisielle': ('judisiell',),
'judisiellere': ('judisiell',),
'judisiellest': ('judisiell',),
'judisielleste': ('judisiell',),
'judisielt': ('judisiell',),
'jugla': ('jugle',),
'juglede': ('jugle',),
'juglende': ('jugle',),
'juglet': ('jugle',),
'juglete': ('jugle',),
'juglet': ('juglet',),
'juglete': ('juglet',),
'jugletere': ('juglet',),
'jugletest': ('juglet',),
'jugleteste': ('juglet',),
'juglete': ('juglete',),
'jugoslavisk': ('jugoslavisk',),
'jugoslaviske': ('jugoslavisk',),
'jugoslaviskere': ('jugoslavisk',),
'jugoslaviskest': ('jugoslavisk',),
'jugoslaviskeste': ('jugoslavisk',),
'juksa': ('jukse',),
'juksede': ('jukse',),
'juksende': ('jukse',),
'jukset': ('jukse',),
'juksete': ('jukse',),
'juksa': ('jukse',),
'juksede': ('jukse',),
'juksende': ('jukse',),
'jukset': ('jukse',),
'juksete': ('jukse',),
'julende': ('jule',),
'jult': ('jule',),
'julte': ('jule',),
'juliansk': ('juliansk',),
'julianske': ('juliansk',),
'julianskere': ('juliansk',),
'julianskest': ('juliansk',),
'julianskeste': ('juliansk',),
'jumpa': ('jumpe',),
'jumpede': ('jumpe',),
'jumpende': ('jumpe',),
'jumpet': ('jumpe',),
'jumpete': ('jumpe',),
'junior': ('junior',),
'junka': ('junke',),
'junkede': ('junke',),
'junkende': ('junke',),
'junket': ('junke',),
'junkete': ('junke',),
'junonisk': ('junonisk',),
'junoniske': ('junonisk',),
'junoniskere': ('junonisk',),
'junoniskest': ('junonisk',),
'junoniskeste': ('junonisk',),
'juraisk': ('juraisk',),
'juraiske': ('juraisk',),
'juraiskere': ('juraisk',),
'juraiskest': ('juraisk',),
'juraiskeste': ('juraisk',),
'juridisk': ('juridisk',),
'juridiske': ('juridisk',),
'juridiskere': ('juridisk',),
'juridiskest': ('juridisk',),
'juridiskeste': ('juridisk',),
'juryerende': ('juryere',),
'juryert': ('juryere',),
'juryerte': ('juryere',),
'justerbar': ('justerbar',),
'justerbare': ('justerbar',),
'justerbarere': ('justerbar',),
'justerbarest': ('justerbar',),
'justerbareste': ('justerbar',),
'justerbart': ('justerbar',),
'justerende': ('justere',),
'justert': ('justere',),
'justerte': ('justere',),
'justitiell': ('justitiell',),
'justitielle': ('justitiell',),
'justitiellere': ('justitiell',),
'justitiellest': ('justitiell',),
'justitielleste': ('justitiell',),
'justitielt': ('justitiell',),
'jyllandsk': ('jyllandsk',),
'jyllandske': ('jyllandsk',),
'jyllandskere': ('jyllandsk',),
'jyllandskest': ('jyllandsk',),
'jyllandskeste': ('jyllandsk',),
'jysk': ('jysk',),
'jyske': ('jysk',),
'jyskere': ('jysk',),
'jyskest': ('jysk',),
'jyskeste': ('jysk',),
'jåla': ('jåle',),
'jålede': ('jåle',),
'jålende': ('jåle',),
'jålet': ('jåle',),
'jålete': ('jåle',),
'jålt': ('jåle',),
'jålte': ('jåle',),
'jålet': ('jålet',),
'jålete': ('jålet',),
'jåletere': ('jålet',),
'jåletest': ('jålet',),
'jåleteste': ('jålet',),
'jålete': ('jålete',),
'jækla': ('jækla',),
'jæklig': ('jæklig',),
'jæklige': ('jæklig',),
'jækligere': ('jæklig',),
'jækligst': ('jæklig',),
'jækligste': ('jæklig',),
'jærsk': ('jærsk',),
'jærske': ('jærsk',),
'jærskere': ('jærsk',),
'jærskest': ('jærsk',),
'jærskeste': ('jærsk',),
'jævla': ('jævla',),
'jævlig': ('jævlig',),
'jævlige': ('jævlig',),
'jævligere': ('jævlig',),
'jævligst': ('jævlig',),
'jævligste': ('jævlig',),
'jødekristen': ('jødekristen',),
'jødekristent': ('jødekristen',),
'jødekristne': ('jødekristen',),
'jødekristnere': ('jødekristen',),
'jødekristnest': ('jødekristen',),
'jødekristneste': ('jødekristen',),
'jødisk': ('jødisk',),
'jødiske': ('jødisk',),
'jødiskere': ('jødisk',),
'jødiskest': ('jødisk',),
'jødiskeste': ('jødisk',),
'jøya': ('jøye',),
'jøyede': ('jøye',),
'jøyende': ('jøye',),
'jøyet': ('jøye',),
'jøyete': ('jøye',),
'kabbalistisk': ('kabbalistisk',),
'kabbalistiske': ('kabbalistisk',),
'kabbalistiskere': ('kabbalistisk',),
'kabbalistiskest': ('kabbalistisk',),
'kabbalistiskeste': ('kabbalistisk',),
'kabba': ('kabbe',),
'kabbede': ('kabbe',),
'kabbende': ('kabbe',),
'kabbet': ('kabbe',),
'kabbete': ('kabbe',),
'kabylsk': ('kabylsk',),
'kabylske': ('kabylsk',),
'kabylskere': ('kabylsk',),
'kabylskest': ('kabylsk',),
'kabylskeste': ('kabylsk',),
'kadmierende': ('kadmiere',),
'kadmiert': ('kadmiere',),
'kadmierte': ('kadmiere',),
'kadreia': ('kadreie',),
'kadreid': ('kadreie',),
'kadreidd': ('kadreie',),
'kadreidde': ('kadreie',),
'kadreide': ('kadreie',),
'kadreiede': ('kadreie',),
'kadreiende': ('kadreie',),
'kadreiet': ('kadreie',),
'kadreiete': ('kadreie',),
'kaka': ('kake',),
'kakede': ('kake',),
'kakende': ('kake',),
'kaket': ('kake',),
'kakete': ('kake',),
'kakka': ('kakke',),
'kakkede': ('kakke',),
'kakkende': ('kakke',),
'kakket': ('kakke',),
'kakkete': ('kakke',),
'kakla': ('kakle',),
'kaklede': ('kakle',),
'kaklende': ('kakle',),
'kaklet': ('kakle',),
'kaklete': ('kakle',),
'kakofon': ('kakofon',),
'kakofone': ('kakofon',),
'kakofonere': ('kakofon',),
'kakofonest': ('kakofon',),
'kakofoneste': ('kakofon',),
'kakofont': ('kakofon',),
'kakofonisk': ('kakofonisk',),
'kakofoniske': ('kakofonisk',),
'kakofoniskere': ('kakofonisk',),
'kakofoniskest': ('kakofonisk',),
'kakofoniskeste': ('kakofonisk',),
'kakstrykende': ('kakstryke',),
'kakstrøken': ('kakstryke',),
'kakstrøket': ('kakstryke',),
'kakstrøkne': ('kakstryke',),
'kakuminal': ('kakuminal',),
'kakuminale': ('kakuminal',),
'kakuminalere': ('kakuminal',),
'kakuminalest': ('kakuminal',),
'kakuminaleste': ('kakuminal',),
'kakuminalt': ('kakuminal',),
'kakuminaliserende': ('kakuminalisere',),
'kakuminalisert': ('kakuminalisere',),
'kakuminaliserte': ('kakuminalisere',),
'kalandrerende': ('kalandrere',),
'kalandrert': ('kalandrere',),
'kalandrerte': ('kalandrere',),
'kald': ('kald',),
'kalde': ('kald',),
'kaldere': ('kald',),
'kaldest': ('kald',),
'kaldeste': ('kald',),
'kaldt': ('kald',),
'kaldblodig': ('kaldblodig',),
'kaldblodige': ('kaldblodig',),
'kaldblodigere': ('kaldblodig',),
'kaldblodigst': ('kaldblodig',),
'kaldblodigste': ('kaldblodig',),
'kaldeisk': ('kaldeisk',),
'kaldeiske': ('kaldeisk',),
'kaldeiskere': ('kaldeisk',),
'kaldeiskest': ('kaldeisk',),
'kaldeiskeste': ('kaldeisk',),
'kaldflirende': ('kaldflire',),
'kaldflirt': ('kaldflire',),
'kaldflirte': ('kaldflire',),
'kaldrøyka': ('kaldrøyke',),
'kaldrøykede': ('kaldrøyke',),
'kaldrøykende': ('kaldrøyke',),
'kaldrøyket': ('kaldrøyke',),
'kaldrøykete': ('kaldrøyke',),
'kaldrøykt': ('kaldrøyke',),
'kaldrøykte': ('kaldrøyke',),
'kaldskjør': ('kaldskjør',),
'kaldskjøre': ('kaldskjør',),
'kaldskjørere': ('kaldskjør',),
'kaldskjørest': ('kaldskjør',),
'kaldskjøreste': ('kaldskjør',),
'kaldskjørt': ('kaldskjør',),
'kaldskratta': ('kaldskratte',),
'kaldskrattede': ('kaldskratte',),
'kaldskrattende': ('kaldskratte',),
'kaldskrattet': ('kaldskratte',),
'kaldskrattete': ('kaldskratte',),
'kaldslig': ('kaldslig',),
'kaldslige': ('kaldslig',),
'kaldsligere': ('kaldslig',),
'kaldsligst': ('kaldslig',),
'kaldsligste': ('kaldslig',),
'kaldsmidd': ('kaldsmi',),
'kaldsmidde': ('kaldsmi',),
'kaldsmiende': ('kaldsmi',),
'kaldsvetta': ('kaldsvette',),
'kaldsvettede': ('kaldsvette',),
'kaldsvettende': ('kaldsvette',),
'kaldsvettet': ('kaldsvette',),
'kaldsvettete': ('kaldsvette',),
'kaldsvetta': ('kaldsvette',),
'kaldsvettede': ('kaldsvette',),
'kaldsvettende': ('kaldsvette',),
'kaldsvettet': ('kaldsvette',),
'kaldsvettete': ('kaldsvette',),
'kaledonsk': ('kaledonsk',),
'kaledonske': ('kaledonsk',),
'kaledonskere': ('kaledonsk',),
'kaledonskest': ('kaledonsk',),
'kaledonskeste': ('kaledonsk',),
'kaleidoskopisk': ('kaleidoskopisk',),
'kaleidoskopiske': ('kaleidoskopisk',),
'kaleidoskopiskere': ('kaleidoskopisk',),
'kaleidoskopiskest': ('kaleidoskopisk',),
'kaleidoskopiskeste': ('kaleidoskopisk',),
'kalfatra': ('kalfatre',),
'kalfatrede': ('kalfatre',),
'kalfatrende': ('kalfatre',),
'kalfatret': ('kalfatre',),
'kalfatrete': ('kalfatre',),
'kalibrerende': ('kalibrere',),
'kalibrert': ('kalibrere',),
'kalibrerte': ('kalibrere',),
'kalifornisk': ('kalifornisk',),
'kaliforniske': ('kalifornisk',),
'kaliforniskere': ('kalifornisk',),
'kaliforniskest': ('kalifornisk',),
'kaliforniskeste': ('kalifornisk',),
'kalka': ('kalke',),
'kalkede': ('kalke',),
'kalkende': ('kalke',),
'kalket': ('kalke',),
'kalkete': ('kalke',),
'kalkerende': ('kalkere',),
'kalkert': ('kalkere',),
'kalkerte': ('kalkere',),
'kalkholdig': ('kalkholdig',),
'kalkholdige': ('kalkholdig',),
'kalkholdigere': ('kalkholdig',),
'kalkholdigst': ('kalkholdig',),
'kalkholdigste': ('kalkholdig',),
'kalkulatorisk': ('kalkulatorisk',),
'kalkulatoriske': ('kalkulatorisk',),
'kalkulatoriskere': ('kalkulatorisk',),
'kalkulatoriskest': ('kalkulatorisk',),
'kalkulatoriskeste': ('kalkulatorisk',),
'kalkulerende': ('kalkulere',),
'kalkulert': ('kalkulere',),
'kalkulerte': ('kalkulere',),
'kalkunsk': ('kalkunsk',),
'kalkunske': ('kalkunsk',),
'kalkunskere': ('kalkunsk',),
'kalkunskest': ('kalkunsk',),
'kalkunskeste': ('kalkunsk',),
'kallende': ('kalle',),
'kalt': ('kalle',),
'kalte': ('kalle',),
'kalligraferende': ('kalligrafere',),
'kalligrafert': ('kalligrafere',),
'kalligraferte': ('kalligrafere',),
'kalligrafisk': ('kalligrafisk',),
'kalligrafiske': ('kalligrafisk',),
'kalligrafiskere': ('kalligrafisk',),
'kalligrafiskest': ('kalligrafisk',),
'kalligrafiskeste': ('kalligrafisk',),
'kalmukkisk': ('kalmukkisk',),
'kalmukkiske': ('kalmukkisk',),
'kalmukkiskere': ('kalmukkisk',),
'kalmukkiskest': ('kalmukkisk',),
'kalmukkiskeste': ('kalmukkisk',),
'kalorifattig': ('kalorifattig',),
'kalorifattige': ('kalorifattig',),
'kalorifattigere': ('kalorifattig',),
'kalorifattigst': ('kalorifattig',),
'kalorifattigste': ('kalorifattig',),
'kalsinerende': ('kalsinere',),
'kalsinert': ('kalsinere',),
'kalsinerte': ('kalsinere',),
'kalvbeint': ('kalvbeint',),
'kalvbeinte': ('kalvbeint',),
'kalvbeintere': ('kalvbeint',),
'kalvbeintest': ('kalvbeint',),
'kalvbeinteste': ('kalvbeint',),
'kalvbent': ('kalvbent',),
'kalvbente': ('kalvbent',),
'kalvbentere': ('kalvbent',),
'kalvbentest': ('kalvbent',),
'kalvbenteste': ('kalvbent',),
'kalvdiger': ('kalvdiger',),
'kalvdigert': ('kalvdiger',),
'kalvdigre': ('kalvdiger',),
'kalvdigrere': ('kalvdiger',),
'kalvdigrest': ('kalvdiger',),
'kalvdigreste': ('kalvdiger',),
'kalva': ('kalve',),
'kalvede': ('kalve',),
'kalvende': ('kalve',),
'kalvet': ('kalve',),
'kalvete': ('kalve',),
'kalvet': ('kalvet',),
'kalvete': ('kalvet',),
'kalvetere': ('kalvet',),
'kalvetest': ('kalvet',),
'kalveteste': ('kalvet',),
'kalvete': ('kalvete',),
'kalvinistisk': ('kalvinistisk',),
'kalvinistiske': ('kalvinistisk',),
'kalvinistiskere': ('kalvinistisk',),
'kalvinistiskest': ('kalvinistisk',),
'kalvinistiskeste': ('kalvinistisk',),
'kalvinsk': ('kalvinsk',),
'kalvinske': ('kalvinsk',),
'kalvinskere': ('kalvinsk',),
'kalvinskest': ('kalvinsk',),
'kalvinskeste': ('kalvinsk',),
'kambial': ('kambial',),
'kambiale': ('kambial',),
'kambialere': ('kambial',),
'kambialest': ('kambial',),
'kambialeste': ('kambial',),
'kambialt': ('kambial',),
'kambodsjansk': ('kambodsjansk',),
'kambodsjanske': ('kambodsjansk',),
'kambodsjanskere': ('kambodsjansk',),
'kambodsjanskest': ('kambodsjansk',),
'kambodsjanskeste': ('kambodsjansk',),
'kambrisk': ('kambrisk',),
'kambriske': ('kambrisk',),
'kambriskere': ('kambrisk',),
'kambriskest': ('kambrisk',),
'kambriskeste': ('kambrisk',),
'kameleonaktig': ('kameleonaktig',),
'kameleonaktige': ('kameleonaktig',),
'kameleonaktigere': ('kameleonaktig',),
'kameleonaktigst': ('kameleonaktig',),
'kameleonaktigste': ('kameleonaktig',),
'kameratslig': ('kameratslig',),
'kameratslige': ('kameratslig',),
'kameratsligere': ('kameratslig',),
'kameratsligst': ('kameratslig',),
'kameratsligste': ('kameratslig',),
'kamerunsk': ('kamerunsk',),
'kamerunske': ('kamerunsk',),
'kamerunskere': ('kamerunsk',),
'kamerunskest': ('kamerunsk',),
'kamerunskeste': ('kamerunsk',),
'kamma': ('kamme',),
'kammede': ('kamme',),
'kammende': ('kamme',),
'kammet': ('kamme',),
'kammete': ('kamme',),
'kampdyktig': ('kampdyktig',),
'kampdyktige': ('kampdyktig',),
'kampdyktigere': ('kampdyktig',),
'kampdyktigst': ('kampdyktig',),
'kampdyktigste': ('kampdyktig',),
'kamperende': ('kampere',),
'kampert': ('kampere',),
'kamperte': ('kampere',),
'kamplysten': ('kamplysten',),
'kamplystent': ('kamplysten',),
'kamplystne': ('kamplysten',),
'kamplystnere': ('kamplysten',),
'kamplystnest': ('kamplysten',),
'kamplystneste': ('kamplysten',),
'kampudyktig': ('kampudyktig',),
'kampudyktige': ('kampudyktig',),
'kampudyktigere': ('kampudyktig',),
'kampudyktigst': ('kampudyktig',),
'kampudyktigste': ('kampudyktig',),
'kamsa': ('kamse',),
'kamsede': ('kamse',),
'kamsende': ('kamse',),
'kamset': ('kamse',),
'kamsete': ('kamse',),
'kamuflerende': ('kamuflere',),
'kamuflert': ('kamuflere',),
'kamuflerte': ('kamuflere',),
'kanaaneisk': ('kanaaneisk',),
'kanaaneiske': ('kanaaneisk',),
'kanaaneiskere': ('kanaaneisk',),
'kanaaneiskest': ('kanaaneisk',),
'kanaaneiskeste': ('kanaaneisk',),
'kanaanittisk': ('kanaanittisk',),
'kanaanittiske': ('kanaanittisk',),
'kanaanittiskere': ('kanaanittisk',),
'kanaanittiskest': ('kanaanittisk',),
'kanaanittiskeste': ('kanaanittisk',),
'kanadisk': ('kanadisk',),
'kanadiske': ('kanadisk',),
'kanadiskere': ('kanadisk',),
'kanadiskest': ('kanadisk',),
'kanadiskeste': ('kanadisk',),
'kanaliserende': ('kanalisere',),
'kanalisert': ('kanalisere',),
'kanaliserte': ('kanalisere',),
'kanarisk': ('kanarisk',),
'kanariske': ('kanarisk',),
'kanariskere': ('kanarisk',),
'kanariskest': ('kanarisk',),
'kanariskeste': ('kanarisk',),
'kandiderende': ('kandidere',),
'kandidert': ('kandidere',),
'kandiderte': ('kandidere',),
'kandiserende': ('kandisere',),
'kandisert': ('kandisere',),
'kandiserte': ('kandisere',),
'kannelerende': ('kannelere',),
'kannelert': ('kannelere',),
'kannelerte': ('kannelere',),
'kannibalsk': ('kannibalsk',),
'kannibalske': ('kannibalsk',),
'kannibalskere': ('kannibalsk',),
'kannibalskest': ('kannibalsk',),
'kannibalskeste': ('kannibalsk',),
'kanoniserende': ('kanonisere',),
'kanonisert': ('kanonisere',),
'kanoniserte': ('kanonisere',),
'kanonisk': ('kanonisk',),
'kanoniske': ('kanonisk',),
'kanoniskere': ('kanonisk',),
'kanoniskest': ('kanonisk',),
'kanoniskeste': ('kanonisk',),
'kansellerende': ('kansellere',),
'kansellert': ('kansellere',),
'kansellerte': ('kansellere',),
'kanta': ('kante',),
'kantede': ('kante',),
'kantende': ('kante',),
'kantet': ('kante',),
'kantete': ('kante',),
'kantet': ('kantet',),
'kantete': ('kantet',),
'kantetere': ('kantet',),
'kantetest': ('kantet',),
'kanteteste': ('kantet',),
'kantete': ('kantete',),
'kantra': ('kantre',),
'kantrede': ('kantre',),
'kantrende': ('kantre',),
'kantret': ('kantre',),
'kantrete': ('kantre',),
'kaotisk': ('kaotisk',),
'kaotiske': ('kaotisk',),
'kaotiskere': ('kaotisk',),
'kaotiskest': ('kaotisk',),
'kaotiskeste': ('kaotisk',),
'kapabel': ('kapabel',),
'kapabelt': ('kapabel',),
'kapable': ('kapabel',),
'kapablere': ('kapabel',),
'kapablest': ('kapabel',),
'kapableste': ('kapabel',),
'kapillær': ('kapillær',),
'kapillære': ('kapillær',),
'kapillærere': ('kapillær',),
'kapillærest': ('kapillær',),
'kapillæreste': ('kapillær',),
'kapillært': ('kapillær',),
'kapital': ('kapital',),
'kapitale': ('kapital',),
'kapitalere': ('kapital',),
'kapitalest': ('kapital',),
'kapitaleste': ('kapital',),
'kapitalt': ('kapital',),
'kapitalintensiv': ('kapitalintensiv',),
'kapitalintensive': ('kapitalintensiv',),
'kapitalintensivere': ('kapitalintensiv',),
'kapitalintensivest': ('kapitalintensiv',),
'kapitalintensiveste': ('kapitalintensiv',),
'kapitalintensivt': ('kapitalintensiv',),
'kapitaliserende': ('kapitalisere',),
'kapitalisert': ('kapitalisere',),
'kapitaliserte': ('kapitalisere',),
'kapitalistisk': ('kapitalistisk',),
'kapitalistiske': ('kapitalistisk',),
'kapitalistiskere': ('kapitalistisk',),
'kapitalistiskest': ('kapitalistisk',),
'kapitalistiskeste': ('kapitalistisk',),
'kapitalkrevende': ('kapitalkrevende',),
'kapitulerende': ('kapitulere',),
'kapitulert': ('kapitulere',),
'kapitulerte': ('kapitulere',),
'kappdrikkende': ('kappdrikke',),
'kappdrukken': ('kappdrikke',),
'kappdrukket': ('kappdrikke',),
'kappdrukne': ('kappdrikke',),
'kappa': ('kappe',),
'kappede': ('kappe',),
'kappende': ('kappe',),
'kappet': ('kappe',),
'kappete': ('kappe',),
'kappekledd': ('kappekledd',),
'kappekledde': ('kappekledd',),
'kappekleddere': ('kappekledd',),
'kappekleddest': ('kappekledd',),
'kappekleddeste': ('kappekledd',),
'kappkjørende': ('kappkjøre',),
'kappkjørt': ('kappkjøre',),
'kappkjørte': ('kappkjøre',),
'kappverdisk': ('kappverdisk',),
'kappverdiske': ('kappverdisk',),
'kappverdiskere': ('kappverdisk',),
'kappverdiskest': ('kappverdisk',),
'kappverdiskeste': ('kappverdisk',),
'kapra': ('kapre',),
'kaprede': ('kapre',),
'kaprende': ('kapre',),
'kapret': ('kapre',),
'kaprete': ('kapre',),
'kaprisiøs': ('kaprisiøs',),
'kaprisiøse': ('kaprisiøs',),
'kaprisiøsere': ('kaprisiøs',),
'kaprisiøsest': ('kaprisiøs',),
'kaprisiøseste': ('kaprisiøs',),
'kaprisiøst': ('kaprisiøs',),
'kapseisende': ('kapseise',),
'kapseist': ('kapseise',),
'kapseiste': ('kapseise',),
'kapsla': ('kapsle',),
'kapslede': ('kapsle',),
'kapslende': ('kapsle',),
'kapslet': ('kapsle',),
'kapslete': ('kapsle',),
'kapunerende': ('kapunere',),
'kapunert': ('kapunere',),
'kapunerte': ('kapunere',),
'kaputt': ('kaputt',),
'karakterdannende': ('karakterdannende',),
'karakterfast': ('karakterfast',),
'karakterfaste': ('karakterfast',),
'karakterfastere': ('karakterfast',),
'karakterfastest': ('karakterfast',),
'karakterfasteste': ('karakterfast',),
'karakteriserende': ('karakterisere',),
'karakterisert': ('karakterisere',),
'karakteriserte': ('karakterisere',),
'karakteristisk': ('karakteristisk',),
'karakteristiske': ('karakteristisk',),
'karakteristiskere': ('karakteristisk',),
'karakteristiskest': ('karakteristisk',),
'karakteristiskeste': ('karakteristisk',),
'karakterlaus': ('karakterlaus',),
'karakterlause': ('karakterlaus',),
'karakterlausere': ('karakterlaus',),
'karakterlausest': ('karakterlaus',),
'karakterlauseste': ('karakterlaus',),
'karakterlaust': ('karakterlaus',),
'karakterløs': ('karakterløs',),
'karakterløse': ('karakterløs',),
'karakterløsere': ('karakterløs',),
'karakterløsest': ('karakterløs',),
'karakterløseste': ('karakterløs',),
'karakterløst': ('karakterløs',),
'kardansk': ('kardansk',),
'kardanske': ('kardansk',),
'kardanskere': ('kardansk',),
'kardanskest': ('kardansk',),
'kardanskeste': ('kardansk',),
'karda': ('karde',),
'kardede': ('karde',),
'kardende': ('karde',),
'kardet': ('karde',),
'kardete': ('karde',),
'kara': ('kare',),
'karede': ('kare',),
'karende': ('kare',),
'karet': ('kare',),
'karete': ('kare',),
'karelsk': ('karelsk',),
'karelske': ('karelsk',),
'karelskere': ('karelsk',),
'karelskest': ('karelsk',),
'karelskeste': ('karelsk',),
'karibisk': ('karibisk',),
'karibiske': ('karibisk',),
'karibiskere': ('karibisk',),
'karibiskest': ('karibisk',),
'karibiskeste': ('karibisk',),
'karikerende': ('karikere',),
'karikert': ('karikere',),
'karikerte': ('karikere',),
'karismatisk': ('karismatisk',),
'karismatiske': ('karismatisk',),
'karismatiskere': ('karismatisk',),
'karismatiskest': ('karismatisk',),
'karismatiskeste': ('karismatisk',),
'kariøs': ('kariøs',),
'kariøse': ('kariøs',),
'kariøsere': ('kariøs',),
'kariøsest': ('kariøs',),
'kariøseste': ('kariøs',),
'kariøst': ('kariøs',),
'karminrød': ('karminrød',),
'karminrøde': ('karminrød',),
'karminrødere': ('karminrød',),
'karminrødest': ('karminrød',),
'karminrødeste': ('karminrød',),
'karminrødt': ('karminrød',),
'karnøfla': ('karnøfle',),
'karnøflede': ('karnøfle',),
'karnøflende': ('karnøfle',),
'karnøflet': ('karnøfle',),
'karnøflete': ('karnøfle',),
'karolingisk': ('karolingisk',),
'karolingiske': ('karolingisk',),
'karolingiskere': ('karolingisk',),
'karolingiskest': ('karolingisk',),
'karolingiskeste': ('karolingisk',),
'karolinsk': ('karolinsk',),
'karolinske': ('karolinsk',),
'karolinskere': ('karolinsk',),
'karolinskest': ('karolinsk',),
'karolinskeste': ('karolinsk',),
'karrig': ('karrig',),
'karrige': ('karrig',),
'karrigere': ('karrig',),
'karrigst': ('karrig',),
'karrigste': ('karrig',),
'karsk': ('karsk',),
'karske': ('karsk',),
'karskere': ('karsk',),
'karskest': ('karsk',),
'karskeste': ('karsk',),
'karskt': ('karsk',),
'karslig': ('karslig',),
'karslige': ('karslig',),
'karsligere': ('karslig',),
'karsligst': ('karslig',),
'karsligste': ('karslig',),
'karta': ('karte',),
'kartede': ('karte',),
'kartende': ('karte',),
'kartet': ('karte',),
'kartete': ('karte',),
'karterende': ('kartere',),
'kartert': ('kartere',),
'karterte': ('kartere',),
'kartesiansk': ('kartesiansk',),
'kartesianske': ('kartesiansk',),
'kartesianskere': ('kartesiansk',),
'kartesianskest': ('kartesiansk',),
'kartesianskeste': ('kartesiansk',),
'kartesisk': ('kartesisk',),
'kartesiske': ('kartesisk',),
'kartesiskere': ('kartesisk',),
'kartesiskest': ('kartesisk',),
'kartesiskeste': ('kartesisk',),
'kartlagt': ('kartlegge',),
'kartlagte': ('kartlegge',),
'kartleggende': ('kartlegge',),
'kartonerende': ('kartonere',),
'kartonert': ('kartonere',),
'kartonerte': ('kartonere',),
'karva': ('karve',),
'karvede': ('karve',),
'karvende': ('karve',),
'karvet': ('karve',),
'karvete': ('karve',),
'kasakhisk': ('kasakhisk',),
'kasakhiske': ('kasakhisk',),
'kasakhiskere': ('kasakhisk',),
'kasakhiskest': ('kasakhisk',),
'kasakhiskeste': ('kasakhisk',),
'kasa': ('kase',),
'kasede': ('kase',),
'kasende': ('kase',),
'kaset': ('kase',),
'kasete': ('kase',),
'kasjmirsk': ('kasjmirsk',),
'kasjmirske': ('kasjmirsk',),
'kasjmirskere': ('kasjmirsk',),
'kasjmirskest': ('kasjmirsk',),
'kasjmirskeste': ('kasjmirsk',),
'kassabel': ('kassabel',),
'kassabelt': ('kassabel',),
'kassable': ('kassabel',),
'kassablere': ('kassabel',),
'kassablest': ('kassabel',),
'kassableste': ('kassabel',),
'kasserende': ('kassere',),
'kassert': ('kassere',),
'kasserte': ('kassere',),
'kasserende': ('kassere',),
'kassert': ('kassere',),
'kasserte': ('kassere',),
'kastanjebrun': ('kastanjebrun',),
'kastanjebrune': ('kastanjebrun',),
'kastanjebrunere': ('kastanjebrun',),
'kastanjebrunest': ('kastanjebrun',),
'kastanjebruneste': ('kastanjebrun',),
'kastanjebrunt': ('kastanjebrun',),
'kasta': ('kaste',),
'kastede': ('kaste',),
'kastende': ('kaste',),
'kastet': ('kaste',),
'kastete': ('kaste',),
'kastebytta': ('kastebytte',),
'kastebyttede': ('kastebytte',),
'kastebyttende': ('kastebytte',),
'kastebyttet': ('kastebytte',),
'kastebyttete': ('kastebytte',),
'kastelaus': ('kastelaus',),
'kastelause': ('kastelaus',),
'kastelausere': ('kastelaus',),
'kastelausest': ('kastelaus',),
'kastelauseste': ('kastelaus',),
'kastelaust': ('kastelaus',),
'kasteløs': ('kasteløs',),
'kasteløse': ('kasteløs',),
'kasteløsere': ('kasteløs',),
'kasteløsest': ('kasteløs',),
'kasteløseste': ('kasteløs',),
'kasteløst': ('kasteløs',),
'kastiljansk': ('kastiljansk',),
'kastiljanske': ('kastiljansk',),
'kastiljanskere': ('kastiljansk',),
'kastiljanskest': ('kastiljansk',),
'kastiljanskeste': ('kastiljansk',),
'kastrerende': ('kastrere',),
'kastrert': ('kastrere',),
'kastrerte': ('kastrere',),
'kasuistisk': ('kasuistisk',),
'kasuistiske': ('kasuistisk',),
'kasuistiskere': ('kasuistisk',),
'kasuistiskest': ('kasuistisk',),
'kasuistiskeste': ('kasuistisk',),
'katalansk': ('katalansk',),
'katalanske': ('katalansk',),
'katalanskere': ('katalansk',),
'katalanskest': ('katalansk',),
'katalanskeste': ('katalansk',),
'katalogiserende': ('katalogisere',),
'katalogisert': ('katalogisere',),
'katalogiserte': ('katalogisere',),
'katalyserende': ('katalysere',),
'katalysert': ('katalysere',),
'katalyserte': ('katalysere',),
'katalytisk': ('katalytisk',),
'katalytiske': ('katalytisk',),
'katalytiskere': ('katalytisk',),
'katalytiskest': ('katalytisk',),
'katalytiskeste': ('katalytisk',),
'katarralsk': ('katarralsk',),
'katarralske': ('katarralsk',),
'katarralskere': ('katarralsk',),
'katarralskest': ('katarralsk',),
'katarralskeste': ('katarralsk',),
'katastrofal': ('katastrofal',),
'katastrofale': ('katastrofal',),
'katastrofalere': ('katastrofal',),
'katastrofalest': ('katastrofal',),
'katastrofaleste': ('katastrofal',),
'katastrofalt': ('katastrofal',),
'katataktisk': ('katataktisk',),
'katataktiske': ('katataktisk',),
'katataktiskere': ('katataktisk',),
'katataktiskest': ('katataktisk',),
'katataktiskeste': ('katataktisk',),
'kategoriserende': ('kategorisere',),
'kategorisert': ('kategorisere',),
'kategoriserte': ('kategorisere',),
'kategorisk': ('kategorisk',),
'kategoriske': ('kategorisk',),
'kategoriskere': ('kategorisk',),
'kategoriskest': ('kategorisk',),
'kategoriskeste': ('kategorisk',),
'kateketisk': ('kateketisk',),
'kateketiske': ('kateketisk',),
'kateketiskere': ('kateketisk',),
'kateketiskest': ('kateketisk',),
'kateketiskeste': ('kateketisk',),
'katekiserende': ('katekisere',),
'katekisert': ('katekisere',),
'katekiserte': ('katekisere',),
'katoliserende': ('katolisere',),
'katolisert': ('katolisere',),
'katoliserte': ('katolisere',),
'katolsk': ('katolsk',),
'katolske': ('katolsk',),
'katolskere': ('katolsk',),
'katolskest': ('katolsk',),
'katolskeste': ('katolsk',),
'kattaktig': ('kattaktig',),
'kattaktige': ('kattaktig',),
'kattaktigere': ('kattaktig',),
'kattaktigst': ('kattaktig',),
'kattaktigste': ('kattaktig',),
'katta': ('katte',),
'kattede': ('katte',),
'kattende': ('katte',),
'kattet': ('katte',),
'kattete': ('katte',),
'katteaktig': ('katteaktig',),
'katteaktige': ('katteaktig',),
'katteaktigere': ('katteaktig',),
'katteaktigst': ('katteaktig',),
'katteaktigste': ('katteaktig',),
'kattemjuk': ('kattemjuk',),
'kattemjuke': ('kattemjuk',),
'kattemjukere': ('kattemjuk',),
'kattemjukest': ('kattemjuk',),
'kattemjukeste': ('kattemjuk',),
'kattemjukt': ('kattemjuk',),
'kattemyk': ('kattemyk',),
'kattemyke': ('kattemyk',),
'kattemykere': ('kattemyk',),
'kattemykest': ('kattemyk',),
'kattemykeste': ('kattemyk',),
'kattemykt': ('kattemyk',),
'kaua': ('kaue',),
'kauede': ('kaue',),
'kauende': ('kaue',),
'kauet': ('kaue',),
'kauete': ('kaue',),
'kaukasisk': ('kaukasisk',),
'kaukasiske': ('kaukasisk',),
'kaukasiskere': ('kaukasisk',),
'kaukasiskest': ('kaukasisk',),
'kaukasiskeste': ('kaukasisk',),
'kaukasoid': ('kaukasoid',),
'kaukasoide': ('kaukasoid',),
'kaukasoidere': ('kaukasoid',),
'kaukasoidest': ('kaukasoid',),
'kaukasoideste': ('kaukasoid',),
'kauka': ('kauke',),
'kaukede': ('kauke',),
'kaukende': ('kauke',),
'kauket': ('kauke',),
'kaukete': ('kauke',),
'kausal': ('kausal',),
'kausale': ('kausal',),
'kausalere': ('kausal',),
'kausalest': ('kausal',),
'kausaleste': ('kausal',),
'kausalt': ('kausal',),
'kausativ': ('kausativ',),
'kausative': ('kausativ',),
'kausativere': ('kausativ',),
'kausativest': ('kausativ',),
'kausativeste': ('kausativ',),
'kausativt': ('kausativ',),
'kausjonerende': ('kausjonere',),
'kausjonert': ('kausjonere',),
'kausjonerte': ('kausjonere',),
'kaustisk': ('kaustisk',),
'kaustiske': ('kaustisk',),
'kaustiskere': ('kaustisk',),
'kaustiskest': ('kaustisk',),
'kaustiskeste': ('kaustisk',),
'kaut': ('kaut',),
'kaute': ('kaut',),
'kautere': ('kaut',),
'kautest': ('kaut',),
'kauteste': ('kaut',),
'kava': ('kave',),
'kavd': ('kave',),
'kavde': ('kave',),
'kavede': ('kave',),
'kavende': ('kave',),
'kavet': ('kave',),
'kavete': ('kave',),
'kaverende': ('kavere',),
'kavert': ('kavere',),
'kaverte': ('kavere',),
'kavernøs': ('kavernøs',),
'kavernøse': ('kavernøs',),
'kavernøsere': ('kavernøs',),
'kavernøsest': ('kavernøs',),
'kavernøseste': ('kavernøs',),
'kavernøst': ('kavernøs',),
'kavla': ('kavle',),
'kavlede': ('kavle',),
'kavlende': ('kavle',),
'kavlet': ('kavle',),
'kavlete': ('kavle',),
'kavla': ('kavle',),
'kavlede': ('kavle',),
'kavlende': ('kavle',),
'kavlet': ('kavle',),
'kavlete': ('kavle',),
'kavlet': ('kavlet',),
'kavlete': ('kavlet',),
'kavletere': ('kavlet',),
'kavletest': ('kavlet',),
'kavleteste': ('kavlet',),
'kavlete': ('kavlete',),
'keia': ('keie',),
'keiede': ('keie',),
'keiende': ('keie',),
'keiet': ('keie',),
'keiete': ('keie',),
'keik': ('keik',),
'keike': ('keik',),
'keikere': ('keik',),
'keikest': ('keik',),
'keikeste': ('keik',),
'keikt': ('keik',),
'keika': ('keike',),
'keikede': ('keike',),
'keikende': ('keike',),
'keiket': ('keike',),
'keikete': ('keike',),
'keikt': ('keike',),
'keikte': ('keike',),
'keiket': ('keiket',),
'keikete': ('keiket',),
'keiketere': ('keiket',),
'keiketest': ('keiket',),
'keiketeste': ('keiket',),
'keikete': ('keikete',),
'keisam': ('keisam',),
'keisamme': ('keisam',),
'keisammere': ('keisam',),
'keisamst': ('keisam',),
'keisamste': ('keisam',),
'keisamt': ('keisam',),
'keiserlig': ('keiserlig',),
'keiserlige': ('keiserlig',),
'keiserligere': ('keiserlig',),
'keiserligst': ('keiserlig',),
'keiserligste': ('keiserlig',),
'keisom': ('keisom',),
'keisomme': ('keisom',),
'keisommere': ('keisom',),
'keisomst': ('keisom',),
'keisomste': ('keisom',),
'keisomt': ('keisom',),
'keitet': ('keitet',),
'keitete': ('keitet',),
'keitetere': ('keitet',),
'keitetest': ('keitet',),
'keiteteste': ('keitet',),
'keitete': ('keitete',),
'keiv': ('keiv',),
'keive': ('keiv',),
'keivere': ('keiv',),
'keivest': ('keiv',),
'keiveste': ('keiv',),
'keivt': ('keiv',),
'keivelig': (