
var FILE_TYPE_NOT_SUPPORTED= new Array("audio","video","application/octet-stream","application/x-msdownload");

$(document).ready(
		function() {
			$(".RestApi").hide();
			$("#div1").show();
			$("#selectRestApi").change(function() {
				resetAll();
				$(this).find("option:selected").each(function() {
					$(".RestApi").hide();
					if ($(this).attr("value") == "1") {
						$("#div1").show();
					} else if ($(this).attr("value") == "2") {
						$("#div2").show();
					} else if ($(this).attr("value") == "3") {
						$("#div3").show();
					}
				});
			}).change();
			$("#submit").click(

					function() {
						$("#showPreview").contents().find("html").html('');
						$("#ajaxBusyMail").show();
						$("#submit").attr('disabled','disabled');
						$("#reset").attr('disabled','disabled');
						var selectedApi = $("#selectRestApi").find(
								"option:selected").attr("value");
						if (selectedApi == "1") {
							viaUploadFile();
						} else if (selectedApi == "2") {
							viaLocalFilePath();
						} else if (selectedApi == "3") {
							viaLocalFileDir();
						}
					});
			$("#reset").click(function() {
				resetAll();
			});

		});

function validateFileType(fileType){
	var result=true;
	if(fileType){
		if(invalidFileCheck(fileType)){
			alert("File type is not supported for preview generation");
			result = false
		}
	}else{
		alert("File type is not supported for preview generation");
		result=false;
	}
	return result;
}
function invalidFileCheck(fileType){
	var i=0;
	var isInvalid=false;
	while(i<FILE_TYPE_NOT_SUPPORTED.length){
		if(fileType.toLowerCase().indexOf(FILE_TYPE_NOT_SUPPORTED[i++])>=0){
			isInvalid=true;
			break;
		}
	}
	return isInvalid;
}

function resetAll() {
	$('#viaLocalDir').trigger("reset");
	$('#viaLocalFile').trigger("reset");
	$('#viaUploadFile').trigger("reset");
	$("#showPreview").contents().find("html").html('');
}
function viaUploadFile() {
	var formData = new FormData();
	var responseType = $("#ResponseTypeUpload").find("option:selected").attr(
			"value");
	if (validateFileType($('#fileUpload')[0].files[0].type)) {
		formData.append("file", $('#fileUpload')[0].files[0]);
		var CEConfigParam = new Object();
		CEConfigParam["responseType"]=parseInt(responseType);
		CEConfigParam["outputFilePath"]=$("#outputPathUpload").val();
		formData.append("CEConfigParams", JSON.stringify(CEConfigParam));

		var url = window.location.origin
				+ "/CvContentPreviewGenApp/rest/genPreview/viaUploadFile";
		ajaxCall(formData, url, responseType);
	}else{
		$("#ajaxBusyMail").hide();
		$("#submit").removeAttr('disabled');
		$("#reset").removeAttr('disabled');

	}

};
function viaLocalFileDir() {
	var formData = new FormData();
	var responseType = $("#ResponseTypeLocalDir").find("option:selected").attr(
			"value");
	var CEConfigParam = new Object();
	CEConfigParam["localFileDir"]=$('#input_Dir').val();
	CEConfigParam["responseType"]=parseInt(responseType);
	CEConfigParam["previewPathDir"]= $("#output_Dir").val();
	formData.append("CEConfigParams", JSON.stringify(CEConfigParam));
	var url = window.location.origin
			+ "/CvContentPreviewGenApp/rest/genPreview/ViaLocalDir";
	ajaxCall(formData,url,responseType);

};


function viaLocalFilePath() {
	var formData = new FormData();
	var responseType = $("#ResponseTypeLocalFile").find("option:selected").attr(
			"value");
	var CEConfigParam = new Object();
	CEConfigParam["localFilePath"]=$('#input_Path_LocalFile').val();
	CEConfigParam["responseType"]=parseInt(responseType);
	CEConfigParam["outputFilePath"]= $("#output_Path_LocalFile").val();
	formData.append("CEConfigParams", JSON.stringify(CEConfigParam));
	var url = window.location.origin
			+ "/CvContentPreviewGenApp/rest/genPreview/ViaLocalFilePath";
	ajaxCall(formData,url,responseType);

};
function ajaxCall(formData,url,responseType){
	$.ajax({
		async : true,
		crossDomain : true,
		url : url,
		method : "POST",
		headers : {},
		processData : false,
		contentType : false,
		mimeType : "multipart/form-data;charset=UTF-8",
		data : formData,
		success : function(response, status, request) {
			$("#ajaxBusyMail").hide();
			if (response) {
				if (responseType == 0) {
					$("#showPreview").contents().find("body").html('');
					$("#showPreview").contents().find('body').html(response);
				} else if(responseType == 1) {
					$("#showPreview").contents().find("body").html('');
					$("#showPreview").contents().find('html').html(response);
				}else if (responseType == 2) {
					$("#showPreview").contents().find("body").html('');
					var iframe = $("<iframe/>").attr({
						src : response,
						style : "visibility:hidden;display:none"
					});
					iframe.appendTo("body");
					iframe
							.load(function() {
								console
										.debug("Removing download iframe");
								try {
									$("body").remove(iframe);
								} catch (err) {
									console
											.debug("Could not remove iframe from body");
								}
								try {
									iframe.remove();
								} catch (err) {
									console
											.debug("Could not remove iframe");
								}
							});
				}
			} else {
				alert('Something went wrong');
			}
			$("#submit").removeAttr('disabled');
			$("#reset").removeAttr('disabled');
		},
		error : function(e) {
			$("#ajaxBusyMail").hide();
			$("#submit").removeAttr('disabled');
			$("#reset").removeAttr('disabled');
		}
	});
}