<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
<xsl:template match="/">

<!-- THIS IS AN XSL STYLESHEET TO DEMONSTRATE THE PRESENTATION OF XML OUTPUT FROM HTML EXPORT -->


<html>
<body>

<!-- If Word processor headings are available then output a table of contents -->

<xsl:if test="oiexport:DOCUMENT/oiexport:DOCBODY/oiexport:HEADING1SECTION/oiexport:HEADING1TITLE">

<font size="+2">Table Of Contents</font><p/>

<xsl:for-each select="oiexport:DOCUMENT/oiexport:DOCBODY/oiexport:HEADING1SECTION">

<b><xsl:value-of select="oiexport:HEADING1TITLE"/></b><br/>

</xsl:for-each><p/>

</xsl:if>

<!-- If section titles are available then output a table of contents -->

<xsl:if test="oiexport:DOCUMENT/oiexport:DOCBODY/oiexport:OTHERSECTION/oiexport:SECTIONTITLE">

<font size="+2">Table Of Contents</font><p/>

<xsl:for-each select="oiexport:DOCUMENT/oiexport:DOCBODY/oiexport:OTHERSECTION">

<b><xsl:value-of select="oiexport:SECTIONTITLE"/></b><br/>

</xsl:for-each><p/>

</xsl:if>

<hr width="400" />

<!-- Output each standard property -->
           
<font size="+2">Properties</font><br/>
<xsl:if test="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:AUTHOR"><b>Author:</b> <xsl:value-of select="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:AUTHOR"/><br/></xsl:if>

<xsl:if test="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:TITLE"><b>Title:</b> <xsl:value-of select="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:TITLE"/><br/></xsl:if>

<xsl:if test="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:SUBJECT"><b>Subject:</b> <xsl:value-of select="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:SUBJECT"/><br/></xsl:if>

<xsl:if test="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:KEYWORDS"><b>Keywords:</b> <xsl:value-of select="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:KEYWORDS"/><br/></xsl:if>

<xsl:if test="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:COMMENT"><b>Comments:</b> <xsl:value-of select="oiexport:DOCUMENT/oiexport:PROPERTY/oiexport:COMMENT"/><br/></xsl:if>
<p/>

<hr width="400" />
<!-- Output preface if it exists -->

<!-- The following commands allow HTML within the oiexport:PREFACE node to be rendered by the browser -->
     

            <xsl:apply-templates select="oiexport:DOCUMENT/oiexport:DOCBODY/oiexport:PREFACE">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates>
<p/>

<!-- Output the content of each first level heading -->

<xsl:for-each select="oiexport:DOCUMENT/oiexport:DOCBODY/oiexport:HEADING1SECTION">

<font size="+3" color="blue"><xsl:value-of select="oiexport:HEADING1TITLE"/></font><p/>

<!-- The following commands allow HTML within the oiexport:HEADING1CONTENT node to be rendered by the browser -->
     
            <xsl:apply-templates select="oiexport:HEADING1CONTENT">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates>

<p/>

</xsl:for-each>

<xsl:if test="oiexport:DOCUMENT/oiexport:DOCBODY/oiexport:NOHEADCONTENT">

<!-- The following commands allow HTML within the oiexport:NOHEADCONTENT node to be rendered by the browser -->
     
            <xsl:apply-templates select="oiexport:DOCUMENT/oiexport:DOCBODY/oiexport:NOHEADCONTENT">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates>

<p/>

</xsl:if>

<xsl:for-each select="oiexport:DOCUMENT/oiexport:DOCBODY/oiexport:OTHERSECTION">

<xsl:if test="oiexport:SECTIONTITLE">

<font size="+3" color="blue"><xsl:value-of select="oiexport:SECTIONTITLE"/></font>
<p/>
</xsl:if>

<xsl:if test="oiexport:SECTIONCONTENT">

<!-- The following commands allow HTML within the oiexport:SECTIONCONTENT node to be rendered by the browser -->
     
            <xsl:apply-templates select="oiexport:SECTIONCONTENT">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates>
<p/>
</xsl:if>

<xsl:if test="oiexport:PRESENTATIONTEXT">

<font color="red" size="+1">Text extracted from the slide</font><p/>

<!-- The following commands allow HTML within the oiexport:PRESENTATIONTEXT node to be rendered by the browser -->
     
            <xsl:apply-templates select="oiexport:PRESENTATIONTEXT">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates>
<p/>
</xsl:if>


</xsl:for-each>


<!-- Output any footnotes -->

<xsl:if test="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:FOOTNOTE"><b>Footnotes</b><br/></xsl:if>

<font size="-1">
<xsl:for-each select="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:FOOTNOTE">

<xsl:value-of select="oiexport:FNREF"/>

<!-- The following commands allow HTML within the oiexport:FNCONTENT node to be rendered by the browser -->
     
            <xsl:apply-templates select="oiexport:FNCONTENT">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates>

<p/>


</xsl:for-each>
</font>

<!-- Output any endnotes -->

<xsl:if test="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:ENDNOTE"><b>Endnotes</b><br/></xsl:if>

<font size="-1">
<xsl:for-each select="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:ENDNOTE">

<xsl:value-of select="oiexport:ENREF"/>

<!-- The following commands allow HTML within the oiexport:ENCONTENT node to be rendered by the browser -->
     
            <xsl:apply-templates select="oiexport:ENCONTENT">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates>
<p/>


</xsl:for-each>
</font>

<!-- Output any annotations -->

<xsl:if test="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:ANNOTATIONS"><b>Annotations</b><br/></xsl:if>

<font size="-1">
<xsl:for-each select="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:ANNOTATIONS">

<!-- The following commands allow HTML within the oiexport:ANCONTENT node to be rendered by the browser -->
     
            <xsl:apply-templates select="oiexport:ANCONTENT">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates><p/>


</xsl:for-each>
</font>

<!-- Output any Footers -->

<xsl:if test="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:FOOTERS"><b>Footers</b><br/></xsl:if>

<font size="-1">
<xsl:for-each select="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:FOOTERS">

<!-- The following commands allow HTML within the oiexport:FOOTERSCONTENT node to be rendered by the browser -->
     
            <xsl:apply-templates select="oiexport:FOOTERSCONTENT">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates><p/>


</xsl:for-each>
</font>

<!-- Output any Headers -->

<xsl:if test="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:HEADERS"><b>Headers</b><br/></xsl:if>

<font size="-1">
<xsl:for-each select="oiexport:DOCUMENT/oiexport:WPEXTRA/oiexport:HEADERS">

<!-- The following commands allow HTML within the oiexport:HEADERSCONTENT node to be rendered by the browser -->
     
            <xsl:apply-templates select="oiexport:HEADERSCONTENT">
              <xsl:template>
               <xsl:copy>
		<xsl:apply-templates select="@* | * | comment() | pi() | text()"/>
                </xsl:copy>
              </xsl:template>
            </xsl:apply-templates><p/>


</xsl:for-each>
</font>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
