/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.MinimumSpanningTree;

public class PrimMinimumSpanningTree<V, E>
implements MinimumSpanningTree<V, E> {
    private final Set<E> minimumSpanningTreeEdgeSet;
    private final double minimumSpanningTreeTotalWeight;

    public PrimMinimumSpanningTree(Graph<V, E> g) {
        this.minimumSpanningTreeEdgeSet = new HashSet(g.vertexSet().size());
        HashSet<V> unspanned = new HashSet<V>(g.vertexSet());
        while (!unspanned.isEmpty()) {
            Object next;
            Iterator ri = unspanned.iterator();
            Object root = ri.next();
            ri.remove();
            PriorityQueue<E> dangling = new PriorityQueue<E>(g.edgeSet().size(), (lop, rop) -> Double.valueOf(g.getEdgeWeight(lop)).compareTo(g.getEdgeWeight(rop)));
            dangling.addAll(g.edgesOf(root));
            while ((next = dangling.poll()) != null) {
                V t;
                V s = g.getEdgeSource(next);
                V v = t = unspanned.contains(s) ? s : g.getEdgeTarget(next);
                if (!unspanned.contains(t)) continue;
                this.minimumSpanningTreeEdgeSet.add(next);
                unspanned.remove(t);
                for (E e : g.edgesOf(t)) {
                    if (!unspanned.contains(g.getEdgeSource(e).equals(t) ? g.getEdgeTarget(e) : g.getEdgeSource(e))) continue;
                    dangling.add(e);
                }
            }
        }
        double spanningTreeWeight = 0.0;
        for (E e : this.minimumSpanningTreeEdgeSet) {
            spanningTreeWeight += g.getEdgeWeight(e);
        }
        this.minimumSpanningTreeTotalWeight = spanningTreeWeight;
    }

    @Override
    public Set<E> getMinimumSpanningTreeEdgeSet() {
        return Collections.unmodifiableSet(this.minimumSpanningTreeEdgeSet);
    }

    @Override
    public double getMinimumSpanningTreeTotalWeight() {
        return this.minimumSpanningTreeTotalWeight;
    }
}

