/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graphs;
import org.jgrapht.WeightedGraph;
import org.jgrapht.alg.interfaces.WeightedMatchingAlgorithm;

public class MaximumWeightBipartiteMatching<V, E>
implements WeightedMatchingAlgorithm<V, E> {
    private final WeightedGraph<V, E> graph;
    private final Set<V> partition1;
    private final Set<V> partition2;
    private Map<V, Long> vertexWeights;
    private Map<V, Boolean> hasVertexBeenProcessed;
    private Map<E, Boolean> isEdgeMatched;
    private Set<E> bipartiteMatching;

    public MaximumWeightBipartiteMatching(WeightedGraph<V, E> graph, Set<V> vertexPartition1, Set<V> vertexPartition2) {
        this.graph = graph;
        this.partition1 = vertexPartition1;
        this.partition2 = vertexPartition2;
        this.vertexWeights = new HashMap<V, Long>();
        this.hasVertexBeenProcessed = new HashMap<V, Boolean>();
        this.isEdgeMatched = new HashMap<E, Boolean>();
        this.initializeVerticesAndEdges();
    }

    @Override
    public Set<E> getMatching() {
        if (this.bipartiteMatching == null) {
            this.bipartiteMatching = this.maximumWeightBipartiteMatching();
        }
        return this.bipartiteMatching;
    }

    @Override
    public double getMatchingWeight() {
        if (this.bipartiteMatching == null) {
            this.getMatching();
        }
        long weight = 0L;
        for (E edge : this.bipartiteMatching) {
            weight = (long)((double)weight + this.graph.getEdgeWeight(edge));
        }
        return weight;
    }

    private void initializeVerticesAndEdges() {
        for (Object vertex : this.graph.vertexSet()) {
            if (this.isTargetVertex(vertex)) {
                this.hasVertexBeenProcessed.put((Boolean)vertex, true);
                this.setVertexWeight(vertex, 0L);
                continue;
            }
            this.hasVertexBeenProcessed.put((Boolean)vertex, false);
            this.setVertexWeight(vertex, this.maximumWeightOfEdgeIncidentToVertex(vertex));
        }
        for (Object edge : this.graph.edgeSet()) {
            this.isEdgeMatched.put(edge, false);
        }
    }

    private long maximumWeightOfEdgeIncidentToVertex(V vertex) {
        long maxWeight = 0L;
        for (Object edge : this.graph.edgesOf(vertex)) {
            if (!(this.graph.getEdgeWeight(edge) > (double)maxWeight)) continue;
            maxWeight = (long)this.graph.getEdgeWeight(edge);
        }
        return maxWeight;
    }

    private boolean isSourceVertex(V vertex) {
        return this.partition1.contains(vertex);
    }

    private boolean isTargetVertex(V vertex) {
        return this.partition2.contains(vertex);
    }

    private long vertexWeight(V vertex) {
        return this.vertexWeights.get(vertex);
    }

    private void setVertexWeight(V vertex, Long weight) {
        this.vertexWeights.put((Long)vertex, weight);
    }

    private long reducedWeight(E edge) {
        return (long)((double)(this.vertexWeight(this.graph.getEdgeSource(edge)) + this.vertexWeight(this.graph.getEdgeTarget(edge))) - this.graph.getEdgeWeight(edge));
    }

    private boolean isVertexMatched(V vertex, Set<E> matchings) {
        for (E edge : matchings) {
            if (!this.graph.getEdgeSource(edge).equals(vertex) && !this.graph.getEdgeTarget(edge).equals(vertex)) continue;
            return true;
        }
        return false;
    }

    private void addPathToMatchings(List<E> path, Set<E> matchings) {
        for (int i = 0; i < path.size(); ++i) {
            E edge = path.get(i);
            if (i % 2 == 0) {
                this.isEdgeMatched.put(edge, true);
                matchings.add(edge);
                continue;
            }
            this.isEdgeMatched.put(edge, false);
            matchings.remove(edge);
        }
    }

    private void adjustVertexWeights(Map<V, List<E>> reachableVertices) {
        long alpha = Long.MAX_VALUE;
        for (V vertex : reachableVertices.keySet()) {
            if (!this.isSourceVertex(vertex) || this.vertexWeights.get(vertex) >= alpha) continue;
            alpha = this.vertexWeights.get(vertex);
        }
        long beta = Long.MAX_VALUE;
        for (V vertex : reachableVertices.keySet()) {
            if (this.isTargetVertex(vertex)) continue;
            for (Object edge : this.graph.edgesOf(vertex)) {
                if (!this.hasVertexBeenProcessed.get(Graphs.getOppositeVertex(this.graph, edge, vertex)).booleanValue() || reachableVertices.keySet().contains(Graphs.getOppositeVertex(this.graph, edge, vertex)) || this.reducedWeight(edge) >= beta) continue;
                beta = this.reducedWeight(edge);
            }
        }
        assert (alpha > 0L && beta > 0L);
        long minValue = Math.min(alpha, beta);
        for (Object vertex : reachableVertices.keySet()) {
            if (this.isSourceVertex(vertex)) {
                this.vertexWeights.put((Long)vertex, this.vertexWeights.get(vertex) - minValue);
                continue;
            }
            this.vertexWeights.put((Long)vertex, this.vertexWeights.get(vertex) + minValue);
        }
    }

    private Map<V, List<E>> verticesReachableByTightAlternatingEdgesFromVertex(V vertex) {
        HashMap pathsToVertices = new HashMap();
        pathsToVertices.put(vertex, new ArrayList());
        this.findPathsToVerticesFromVertices(Collections.singletonList(vertex), false, pathsToVertices);
        return pathsToVertices;
    }

    private void findPathsToVerticesFromVertices(List<V> verticesToProcess, boolean needMatchedEdge, Map<V, List<E>> pathsToVertices) {
        if (verticesToProcess.size() == 0) {
            return;
        }
        ArrayList<V> nextVerticesToProcess = new ArrayList<V>();
        for (V vertex : verticesToProcess) {
            for (Object edge : this.graph.edgesOf(vertex)) {
                V adjacentVertex = Graphs.getOppositeVertex(this.graph, edge, vertex);
                if (!this.hasVertexBeenProcessed.get(adjacentVertex).booleanValue() || this.reducedWeight(edge) != 0L || pathsToVertices.keySet().contains(adjacentVertex) || (!needMatchedEdge || !this.isEdgeMatched.get(edge).booleanValue()) && (needMatchedEdge || this.isEdgeMatched.get(edge).booleanValue())) continue;
                nextVerticesToProcess.add(adjacentVertex);
                ArrayList pathToAdjacentVertex = new ArrayList(pathsToVertices.get(vertex));
                pathToAdjacentVertex.add(edge);
                pathsToVertices.put(adjacentVertex, pathToAdjacentVertex);
            }
        }
        this.findPathsToVerticesFromVertices(nextVerticesToProcess, !needMatchedEdge, pathsToVertices);
    }

    private Set<E> maximumWeightBipartiteMatching() {
        HashSet matchings = new HashSet();
        block0: for (V vertex : this.partition1) {
            this.hasVertexBeenProcessed.put((Boolean)vertex, true);
            while (true) {
                Map<V, List<E>> reachableVertices = this.verticesReachableByTightAlternatingEdgesFromVertex(vertex);
                boolean successful = false;
                for (V reachableVertex : reachableVertices.keySet()) {
                    if (this.isSourceVertex(reachableVertex) && this.vertexWeight(reachableVertex) == 0L) {
                        this.addPathToMatchings(reachableVertices.get(reachableVertex), matchings);
                        successful = true;
                        break;
                    }
                    if (!this.isTargetVertex(reachableVertex) || this.isVertexMatched(reachableVertex, matchings)) continue;
                    this.addPathToMatchings(reachableVertices.get(reachableVertex), matchings);
                    successful = true;
                    break;
                }
                if (successful) continue block0;
                this.adjustVertexWeights(reachableVertices);
            }
        }
        return matchings;
    }
}

