from sklearn.decomposition import PCA
from sklearn.cluster import KMeans, AgglomerativeClustering


class KMeansModel:
    def __init__(self, logging, n_clusters=2):
        self.logging = logging
        self.n_clusters = n_clusters
        self.model = self.get_model()

    def __del__(self):
        del self.model

    def __call__(self, features, column_name="text"):
        try:
            return self.model.fit_predict(features)
        except Exception as e:
            self.logging.exception(f"Failed to call kmeans. Exception {e}")
            raise

    def fit(self, features):
        try:
            self.model.fit(features)
        except Exception as e:
            self.logging.exception(f"Failed to fit using kmeans. Exception {e}")
            raise

    def predict(self, features):
        try:
            self.model.predict(features)
        except Exception as e:
            self.logging.exception(f"Failed to predict using kmeans. Exception {e}")
            raise

    def get_model(self):
        try:
            model = AgglomerativeClustering(n_clusters=self.n_clusters)
            return model
        except Exception as e:
            self.logging.exception(f"Failed to intialize kmeans model. Exception {e}")
            raise
