import os
import queue
import threading
import ujson

from multiprocessing import Queue, Process

from CvEEConfigHelper import CA_SUBTASK_MODULE_MAP, CA_ERROR_CODES, checkParentAndKill
from email_cluster_simhash import EmailCluster

PROCESS_ID = os.getpid()

module_name = "cvee_emailcluster_task"
LOGGER_Generic = None


def preProcess(params=None):
    return {"ErrorCode": CA_ERROR_CODES["success"]}


def doAnalysis(processing_input, params={}):    
    global LOGGER_Generic
    
    func_name = "doAnalysis"
    func_str = f"{module_name}::{func_name}() - "
    if "logger" in params:
        LOGGER_Generic = params["logger"]
    else:
        return {
            "ErrorCode": CA_ERROR_CODES["loggerNotFound"],
            "ErrorMessage": "Logger object was not sent in params",
        }    
    try:
        results = {"ErrorCode": CA_ERROR_CODES["success"], "ErrorMessage": None}
        jsonified_input = ujson.loads(processing_input)

        if "dataList" not in jsonified_input and "optTypedata" not in jsonified_input["dataList"]:
            return results

        csvFile = None
        csvSeparator = None
        for item in jsonified_input["dataList"]["optTypedata"]:
            if ( "attrKey" in item and "attrValue" in item):
                if item["attrKey"] == "SolrDocCSVPath":
                    csvFile = item["attrValue"]
                if item["attrKey"] == "SOLR_DOC_CSV_SEPARATOR":
                    csvSeparator = item["attrValue"]
        
        if not csvFile or not csvSeparator:
            return results
        
        resFile = csvFile.replace('.csv', '.xml')

        EmailCluster(csvFile, csvSeparator, resFile, LOGGER_Generic)
        os.remove(csvFile)

        results["email_tags"] = resFile

        LOGGER_Generic.info("job finished")

        return results
    except AttributeError as e:
        LOGGER_Generic.exception(f"Failed to pickle {e}.", func_str)
    except Exception as e:
        LOGGER_Generic.exception(f"Exception occured {e}.", func_str)
    
