import timeit, sys
from CvCAGenericLogger import get_logger_handler

logger_options = {"ROTATING_BACKUP_COUNT": 5, "ROTATING_MAX_BYTES": 5 * 1024 * 1024}

LOGGER_Generic = get_logger_handler(
    "CvCIEntityExtractionCsApi.dll", "ContentAnalyzer", logger_options
)


def printelapsedtime(st, logstr):
    logline = logstr + ": {0:.3f}".format(timeit.default_timer() - st)
    LOGGER_Generic.error(logline)
    return logline


def ensureUtf(word):
    try:
        if sys.version_info[0] < 3:
            if isinstance(word, str):
                word = word.decode("utf-8")
            return word
        else:
            if type(word) == bytes:
                return word.decode("utf-8")
            elif type(word) == str:
                return word.encode("utf8", "ignore")
            else:
                return str(word)
    except:
        return word
