from threading import Timer, Event
import threading, ctypes
import os, psutil
from CvEEConfigHelper import loadRegValue


def async_raise(target_tid, exception):
    """
    async_raise code refernce: https://github.com/glenfant/stopit/blob/master/src/stopit/threadstop.py
    """
    """Raises an asynchronous exception in another thread.
    Read http://docs.python.org/c-api/init.html#PyThreadState_SetAsyncExc
    for further enlightenments.
    :param target_tid: target thread identifier
    :param exception: Exception class to be raised in that thread
    """
    # Ensuring and releasing GIL are useless since we're not in C
    # gil_state = ctypes.pythonapi.PyGILState_Ensure()
    ret = ctypes.pythonapi.PyThreadState_SetAsyncExc(
        ctypes.c_long(target_tid), ctypes.py_object(exception)
    )
    # ctypes.pythonapi.PyGILState_Release(gil_state)
    if ret == 0:
        raise ValueError("Invalid thread ID {}".format(target_tid))
    elif ret > 1:
        ctypes.pythonapi.PyThreadState_SetAsyncExc(ctypes.c_long(target_tid), None)
        raise SystemError("PyThreadState_SetAsyncExc failed")


class Timeout:
    class ProcessingTimedOut(Exception):
        pass

    class MemoryLimitReached(Exception):
        pass

    def __init__(self, sec):
        self.sec = sec
        self.target_tid = threading.current_thread().ident
        self.MEMORY_LIMIT = float(loadRegValue("sEEGenericMemoryLimit", 5, type=int))  # 5 GB

    def __enter__(self):
        self.process_time_timer = Timer(self.sec, self.raise_timeout)
        self.process_time_timer.start()
        self.process_memory_timer = Timer(30.0, self.raise_memory_limit)
        self.process_memory_timer.start()
        self.done_processing = None

    def __exit__(self, *args):
        if self.process_time_timer is not None and self.process_time_timer.is_alive():
            self.process_time_timer.cancel()
        if self.process_memory_timer is not None and self.process_memory_timer.is_alive():
            self.process_memory_timer.cancel()
        if self.done_processing == "timeout":
            raise Timeout.ProcessingTimedOut("File processing timedout")
        elif self.done_processing == "memory":
            raise Timeout.MemoryLimitReached("File memory limit crossed")
        self.done_processing = "done"

    def raise_memory_limit(self, *args):
        process = psutil.Process(os.getpid())
        # print(process.memory_info().rss/ float(1048576*1024))
        mem = process.memory_info().rss / float(1048576 * 1024)
        # print("Thread {} mem {}".format('h',mem))
        if mem < self.MEMORY_LIMIT and self.done_processing is None:
            if self.process_memory_timer is not None:
                self.process_memory_timer.cancel()
            self.process_memory_timer = Timer(30.0, self.raise_memory_limit).start()
        elif mem >= self.MEMORY_LIMIT:
            self.done_processing = "memory"
            if self.process_memory_timer is not None:
                self.process_memory_timer.cancel()
                # self.process_time_timer.cancel()
            async_raise(self.target_tid, Timeout.MemoryLimitReached)

    def raise_timeout(self, *args):
        if self.process_time_timer is not None:
            self.process_time_timer.cancel()
        self.done_processing = "timeout"
        async_raise(self.target_tid, Timeout.ProcessingTimedOut)


# import time
# try:
#     with Timeout(2.0):
#         a = []
#         for i in xrange(100000):
#             temp = [12333455668*10] * 1233555
#             a.append(i)
#         print('Hello')
# except Timeout.MemoryLimitReached as e:
#     print("Memory error {} size of a {}".format(e, len(a)))
# except Timeout.ProcessingTimedOut as e:
#     print(e)
#     print('Time Error {} Size of a {}'.format(e,len(a)))
