import time
from CvEEConfigHelper import killProcessAndChildren, to_bytes, get_dll_logger

try:
    from stompest.config import StompConfig
    from stompest.protocol import StompSpec
    from stompest.sync import Stomp
except Exception as e:
    print("Couldn't import stompest as :".format(e))

logger = get_dll_logger()

class GenericMsgQueueCommunicator:
    def __init__(self):
        self.host = "localhost"
        self.stompPort = 61650
        self.clients = {}
        self.connected = False
        self.canReadInterval = 5
        self.prefetchSize = str(8)
        self.AMQ_CONNECT_WAIT_TIME = 2 * 60

    def getBrokerConfig(self):
        return StompConfig(
            "tcp://{0}:{1}".format(self.host, self.stompPort), login="guest", passcode="guest"
        )            
        

    def connectToQueue(self, handler_pid=None, retry=True, clients_=None):

        # Function to repeatedly try to connect to AMQ
        # if it goes down.
        while not self.connected:
            try:
                config = self.getBrokerConfig()
                self.connected = True
                if clients_ is None:
                    clients_ = list(self.clients.keys())
                for queue in clients_:
                    queue_obj = self.clients[queue]
                    is_subscribe = queue_obj["subscribe"]                    
                    if queue_obj["client"] is None:
                        try:
                            queue_obj["client"] = Stomp(config)                        
                            queue_obj["client"].connect()
                            logger.info(f"Connected to queue [{queue}]", func_str="connectToQueue() - ")
                            if is_subscribe:
                                logger.info(f"Subscribing to queue [{queue}]", func_str="connectToQueue() - ")
                                queue_obj["client"].subscribe(
                                    queue,
                                    {
                                        StompSpec.ACK_HEADER: StompSpec.ACK_CLIENT_INDIVIDUAL,
                                        "activemq.prefetchSize": self.prefetchSize,
                                    },
                                )
                        except:
                            queue_obj["client"] = None
                            self.connected = False
                            raise Exception("Unable to connect")
                
                if not retry:
                    return True
                self.AMQ_CONNECT_WAIT_TIME = 5 * 60
            except Exception as e:
                self.connected = False
                if handler_pid != None:
                    killProcessAndChildren(handler_pid)
                if retry:
                    time.sleep(self.AMQ_CONNECT_WAIT_TIME)
                else:
                    return "Unable to reach MessageQueue: {}".format(e)

        return True

    def getFrame(self, client):
        if client.canRead(self.canReadInterval):
            frame = client.receiveFrame()
            client.ack(frame)
            return frame.body
        return None

    def sendOnConnect(self, queue, message, client=None, headers=None, retry=True):
        # Function to ensure message is sent
        # only when connection is active
        sent = False
        try:
            queue = queue.decode()
        except:
            pass
        num_times = 5
        while not sent and num_times > 0:
            try:
                num_times-= 1
                if client == None:
                    client = self.clients[queue]["client"]                
                client.send(queue, to_bytes(message), headers)
                sent = True
            except Exception as e:
                logger.exception(f"Send message failed for queue [{queue}]. Exception {e}", func_str="sendOnConnect() - ")
                self.connected = False
                if not retry:
                    return False
                self.connectToQueue(clients_=[queue])
        if not sent and num_times == 0:
            return False
        return True

    def disconnectClients(self):
        for queue in self.clients:
            self.clients[queue]["client"].disconnect()
            logger.info(f"Disconnect queue [{queue}]", func_str="disconnectClients() - ")
