import cv2, os, sys, numpy, glob, time
import tesseract
import cv2.cv as cv
import logging, threading
from CvEEConfigHelper import CA_ERROR_CODES

PROCESS_ID = os.getpid()
THREAD_ID = threading.current_thread().ident
OCRThreshold = 75


def detect_text(image_path):
    global CA_ERROR_CODES
    try:
        full_img_path = os.path.normpath(image_path)
        image0 = cv2.imread(full_img_path, cv2.IMREAD_UNCHANGED)
        if image0 is None:
            LOGGER_Generic.exception("%s: Failed to open image [%s]" % (__name__, full_img_path))
            return
        #### you may need to thicken the border in order to make tesseract feel happy to ocr your image #####
        offset = 20
        height, width, channel = image0.shape
        image1 = cv2.copyMakeBorder(
            image0, offset, offset, offset, offset, cv2.BORDER_CONSTANT, value=(255, 255, 255)
        )
        api = tesseract.TessBaseAPI()
        api.Init(".", "eng", tesseract.OEM_DEFAULT)
        api.SetPageSegMode(tesseract.PSM_AUTO)
        height1, width1, channel1 = image1.shape
        width_step = width * image1.dtype.itemsize

        iplimage = cv.CreateImageHeader((width1, height1), cv.IPL_DEPTH_8U, channel1)
        cv.SetData(iplimage, image1.tostring(), image1.dtype.itemsize * channel1 * (width1))
        tesseract.SetCvImage(iplimage, api)

        text = api.GetUTF8Text()
        conf = api.MeanTextConf()
        image = None
        api.End()

        result = {
            "text": text,
            "conf": conf,
            "ErrorCode": CA_ERROR_CODES["success"],
            "ErrorMessage": None,
        }

        return result
    except Exception as e:
        return {
            "ErrorCode": CA_ERROR_CODES["OCRError"],
            "ErrorMessage": "Error processing text extraction: {}".format(e),
        }


def doAnalysis(input, params={}):
    global LOGGER_Generic, OCRThreshold, CA_ERROR_CODES
    try:
        if "logger" in params:
            LOGGER_Generic = params["logger"]
        else:
            return {
                "ErrorCode": CA_ERROR_CODES["loggerNotFound"],
                "ErrorMessage": "Logger object was not sent in params",
            }
        contentid = ""
        if "contentid" in params:
            contentid = params["contentid"]
        if "OCRThreshold" in params:
            OCRThreshold = params["OCRThreshold"]
        output = detect_text(input)
        if output["conf"] < OCRThreshold:
            output["text"] = "No recognized text!"
        return output
    except Exception as e:
        return {
            "ErrorCode": CA_ERROR_CODES["OCRError"],
            "ErrorMessage": "Text extraction failure for contentid {}: {}".format(contentid, e),
        }

    return output


if __name__ == "__main__":
    print(doAnalysis("C:\\catest\\i94.jpg"))
