"""
Created on Tue Aug 04 18:38:11 2015

@author: smujjiga@commvault.com
"""

from http.server import HTTPServer, BaseHTTPRequestHandler
from socketserver import ThreadingMixIn
from contextlib import contextmanager
import time
from urllib.parse import urlparse
import argparse

import CVEEHandler
import sys

reload(sys)
sys.setdefaultencoding("utf-8")

k = 0


@contextmanager
def timitContext(name, debug=True):
    startTime = time.time()
    yield
    elapsedTime = time.time() - startTime
    if debug == True:
        print("[{}] finished in {} ms".format(name, int(elapsedTime * 1000)))


class Handler(BaseHTTPRequestHandler):
    def isCVSea(self, theurl):
        urlparameters = urlparse(theurl)
        cvseaResourceRequested = False
        if urlparameters.path[0 : len("/cvsea/")] == "/cvsea/":
            cvseaResourceRequested = True
        return urlparameters, cvseaResourceRequested

    def getHandler(self, theurl):
        urlparameters = urlparse(theurl)
        handler = None

        handlers = {CVEEHandler.handleKey: CVEEHandler.HandleRequests}

        # first character is always '/'
        e = urlparameters.path.find("/", 1)
        if e != -1:
            handlerKey = urlparameters.path[1:e]
        else:
            handlerKey = urlparameters.path[1:]

        if handlerKey in handlers:
            handler = handlers[handlerKey]

        return urlparameters, handler

    def do_GET(self):
        self.send_response(200)
        self.send_header("Access-Control-Allow-Origin", "*")
        self.end_headers()

        urlparameters, handler = self.getHandler(self.path)

        if handler != None:
            self.wfile.write(handler(urlparameters, ""))
        else:
            self.wfile.write("Unknown Resource Requested")

        self.wfile.write("\n")
        return

    def do_POST(self):
        self.send_response(200)
        self.send_header("Access-Control-Allow-Origin", "*")
        self.end_headers()

        content_len = int(self.headers.getheader("content-length", 0))
        post_body = self.rfile.read(content_len)

        urlparameters, handler = self.getHandler(self.path)

        if handler != None:
            self.wfile.write(handler(urlparameters, post_body))
        else:
            self.wfile.write("Unknown Resource Requested")

        self.wfile.write("\n")
        return


class ThreadedHTTPServer(ThreadingMixIn, HTTPServer):
    """Handle requests in a separate thread."""


class Config:
    # Default Parameters
    serverIP = "127.0.0.1"
    serverPort = 38080


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Start Python Analytics Server")
    parser.add_argument("-s", help="Server IP Address")
    parser.add_argument("-p", type=int, help="Server Port Number")
    args = parser.parse_args()

    if args.s:
        Config.serverIP = args.s
    if args.p:
        Config.serverPort = args.p

    server = ThreadedHTTPServer((Config.serverIP, Config.serverPort), Handler)
    print("Starting server at [{0}:{1}]".format(Config.serverIP, Config.serverPort))
    print("use <Ctrl-C> to stop")
    server.serve_forever()
