# coding: utf8
"""
All wordforms are extracted from Norsk Ordbank in Norwegian Bokmål 2005
(CLARINO NB - Språkbanken), Nasjonalbiblioteket, Norway:
https://www.nb.no/sprakbanken/show?serial=oai%3Anb.no%3Asbr-5&lang=en
License:
Creative_Commons-BY (CC-BY) (https://creativecommons.org/licenses/by/4.0/)
"""

from __future__ import unicode_literals

ADVERBS_WORDFORMS = {
'à jour': ('à jour',),
'à la carte': ('à la carte',),
'à la grecque': ('à la grecque',),
'à la mode': ('à la mode',),
'òg': ('òg',),
'a': ('a',),
'a cappella': ('a cappella',),
'a conto': ('a conto',),
'a konto': ('a konto',),
'a posteriori': ('a posteriori',),
'a prima vista': ('a prima vista',),
'a priori': ('a priori',),
'a tempo': ('a tempo',),
'a verbo': ('a verbo',),
'a viso': ('a viso',),
'a vista': ('a vista',),
'ad absurdum': ('ad absurdum',),
'ad acta': ('ad acta',),
'ad hoc': ('ad hoc',),
'ad infinitum': ('ad infinitum',),
'ad notam': ('ad notam',),
'ad undas': ('ad undas',),
'adagio': ('adagio',),
'akkurat': ('akkurat',),
'al fresco': ('al fresco',),
'al secco': ('al secco',),
'aldeles': ('aldeles',),
'alders tid': ('alders tid',),
'aldri': ('aldri',),
'aleine': ('aleine',),
'alene': ('alene',),
'alias': ('alias',),
'allegretto': ('allegretto',),
'allegro': ('allegro',),
'aller': ('aller',),
'allerede': ('allerede',),
'allikevel': ('allikevel',),
'alltid': ('alltid',),
'alltids': ('alltids',),
'alt': ('alt',),
'altfor': ('altfor',),
'altså': ('altså',),
'amok': ('amok',),
'an': ('an',),
'ana': ('ana',),
'andante': ('andante',),
'andantino': ('andantino',),
'andelsvis': ('andelsvis',),
'andfares': ('andfares',),
'andføttes': ('andføttes',),
'annetsteds': ('annetsteds',),
'annetstedsfra': ('annetstedsfra',),
'annetstedshen': ('annetstedshen',),
'anno': ('anno',),
'anslagsvis': ('anslagsvis',),
'anstendigvis': ('anstendigvis',),
'anstigende': ('anstigende',),
'antakeligvis': ('antakeligvis',),
'antydningsvis': ('antydningsvis',),
'apropos': ('apropos',),
'argende': ('argende',),
'at': ('at',),
'atter': ('atter',),
'attpåtil': ('attpåtil',),
'attåt': ('attåt',),
'au': ('au',),
'avdelingsvis': ('avdelingsvis',),
'avdragsvis': ('avdragsvis',),
'avhendes': ('avhendes',),
'avhends': ('avhends',),
'avsatsvis': ('avsatsvis',),
'bakk': ('bakk',),
'baklengs': ('baklengs',),
'bare': ('bare',),
'bataljonsvis': ('bataljonsvis',),
'bekende': ('bekende',),
'belgende': ('belgende',),
'betids': ('betids',),
'bi': ('bi',),
'bidevind': ('bidevind',),
'bis': ('bis',),
'bitevis': ('bitevis',),
'bitte': ('bitte',),
'bitterlig': ('bitterlig',),
'blanko': ('blanko',),
'blidelig': ('blidelig',),
'blikk': ('blikk',),
'blikkende': ('blikkende',),
'blottende': ('blottende',),
'bom': ('bom',),
'bommende': ('bommende',),
'bona fide': ('bona fide',),
'brennfort': ('brennfort',),
'brutto': ('brutto',),
'bråtevis': ('bråtevis',),
'bums': ('bums',),
'buntevis': ('buntevis',),
'buntvis': ('buntvis',),
'bus': ('bus',),
'cantabile': ('cantabile',),
'cf': ('cf',),
'cif': ('cif',),
'cirka': ('cirka',),
'crescendo': ('crescendo',),
'da': ('da',),
'dagevis': ('dagevis',),
'dagstøtt': ('dagstøtt',),
'dakapo': ('dakapo',),
'dam': ('dam',),
'dammende': ('dammende',),
'dann': ('dann',),
'de facto': ('de facto',),
'de jure': ('de jure',),
'decrescendo': ('decrescendo',),
'delkredere': ('delkredere',),
'dels': ('dels',),
'delvis': ('delvis',),
'derav': ('derav',),
'deretter': ('deretter',),
'derfor': ('derfor',),
'derimot': ('derimot',),
'dermed': ('dermed',),
'dernest': ('dernest',),
'dess': ('dess',),
'dessuten': ('dessuten',),
'dessverre': ('dessverre',),
'desto': ('desto',),
'diminuendo': ('diminuendo',),
'dis': ('dis',),
'dog': ('dog',),
'dolce': ('dolce',),
'dorgende': ('dorgende',),
'dryppende': ('dryppende',),
'drøssevis': ('drøssevis',),
'dus': ('dus',),
'dusinvis': ('dusinvis',),
'dyende': ('dyende',),
'døgnvis': ('døgnvis',),
'dønn': ('dønn',),
'dørg': ('dørg',),
'dørgende': ('dørgende',),
'dørimellom': ('dørimellom',),
'ei': ('ei',),
'eiende': ('eiende',),
'einkom': ('einkom',),
'eitrende': ('eitrende',),
'eks': ('eks',),
'eksempelvis': ('eksempelvis',),
'ekspress': ('ekspress',),
'ekstempore': ('ekstempore',),
'eldende': ('eldende',),
'eldende': ('eldende',),
'ellers': ('ellers',),
'en': ('en',),
'en bloc': ('en bloc',),
'en detail': ('en detail',),
'en face': ('en face',),
'en gros': ('en gros',),
'en masse': ('en masse',),
'en passant': ('en passant',),
'en profil': ('en profil',),
'en suite': ('en suite',),
'enda': ('enda',),
'endatil': ('endatil',),
'ende': ('ende',),
'ender': ('ender',),
'endog': ('endog',),
'ene': ('ene',),
'engang': ('engang',),
'enkeltvis': ('enkeltvis',),
'enkom': ('enkom',),
'enn': ('enn',),
'ennå': ('ennå',),
'eo ipso': ('eo ipso',),
'ergo': ('ergo',),
'et cetera': ('et cetera',),
'etappevis': ('etappevis',),
'etterhånden': ('etterhånden',),
'etterpå': ('etterpå',),
'etterskottsvis': ('etterskottsvis',),
'etterskuddsvis': ('etterskuddsvis',),
'ex animo': ('ex animo',),
'ex auditorio': ('ex auditorio',),
'ex cathedra': ('ex cathedra',),
'ex officio': ('ex officio',),
'fas': ('fas',),
'fatt': ('fatt',),
'fatt': ('fatt',),
'feil': ('feil',),
'femti-femti': ('femti-femti',),
'fifty-fifty': ('fifty-fifty',),
'flekkevis': ('flekkevis',),
'flokkevis': ('flokkevis',),
'fluks': ('fluks',),
'fluksens': ('fluksens',),
'flunkende': ('flunkende',),
'flust': ('flust',),
'fly': ('fly',),
'fob': ('fob',),
'for': ('for',),
'for lengst': ('for lengst',),
'for resten': ('for resten',),
'for så vidt': ('for så vidt',),
'for visst': ('for visst',),
'for øvrig': ('for øvrig',),
'fordevind': ('fordevind',),
'fordum': ('fordum',),
'fore': ('fore',),
'forhakkende': ('forhakkende',),
'forholdsvis': ('forholdsvis',),
'forhåpentlig': ('forhåpentlig',),
'forhåpentligvis': ('forhåpentligvis',),
'forlengs': ('forlengs',),
'formelig': ('formelig',),
'forresten': ('forresten',),
'forsøksvis': ('forsøksvis',),
'forte': ('forte',),
'fortfarende': ('fortfarende',),
'fortissimo': ('fortissimo',),
'fortrinnsvis': ('fortrinnsvis',),
'framleis': ('framleis',),
'framlengs': ('framlengs',),
'framstupes': ('framstupes',),
'framstups': ('framstups',),
'franko': ('franko',),
'free on board': ('free on board',),
'free on rail': ('free on rail',),
'fremdeles': ('fremdeles',),
'fremlengs': ('fremlengs',),
'fremstupes': ('fremstupes',),
'fremstups': ('fremstups',),
'furioso': ('furioso',),
'fylkesvis': ('fylkesvis',),
'følgelig': ('følgelig',),
'først': ('først',),
'ganske': ('ganske',),
'gid': ('gid',),
'givetvis': ('givetvis',),
'gjerne': ('gjerne',),
'gladelig': ('gladelig',),
'glimtvis': ('glimtvis',),
'glissando': ('glissando',),
'glugg': ('glugg',),
'gorr': ('gorr',),
'gorrende': ('gorrende',),
'gradvis': ('gradvis',),
'grandioso': ('grandioso',),
'granngivelig': ('granngivelig',),
'grassat': ('grassat',),
'grave': ('grave',),
'gruppevis': ('gruppevis',),
'gudskjelov': ('gudskjelov',),
'gullende': ('gullende',),
'gørr': ('gørr',),
'gørrende': ('gørrende',),
'hakk': ('hakk',),
'hakkende': ('hakkende',),
'halvveis': ('halvveis',),
'haugevis': ('haugevis',),
'heden': ('heden',),
'heiman': ('heiman',),
'heldigvis': ('heldigvis',),
'heller': ('heller',),
'helst': ('helst',),
'henholdsvis': ('henholdsvis',),
'herre': ('herre',),
'hersens': ('hersens',),
'himlende': ('himlende',),
'hodekulls': ('hodekulls',),
'hodestupes': ('hodestupes',),
'hodestups': ('hodestups',),
'hoggende': ('hoggende',),
'honoris causa': ('honoris causa',),
'hoppende': ('hoppende',),
'hulter': ('hulter',),
'hundretusenvis': ('hundretusenvis',),
'hundrevis': ('hundrevis',),
'hurra-meg-rundt': ('hurra-meg-rundt',),
'hvi': ('hvi',),
'hvor': ('hvor',),
'hvorav': ('hvorav',),
'hvordan': ('hvordan',),
'hvorfor': ('hvorfor',),
'hånt': ('hånt',),
'høylig': ('høylig',),
'høyst': ('høyst',),
'i alle fall': ('i alle fall',),
'i stedet': ('i stedet',),
'iallfall': ('iallfall',),
'ibidem': ('ibidem',),
'id est': ('id est',),
'igjen': ('igjen',),
'ikke': ('ikke',),
'ildende': ('ildende',),
'ildende': ('ildende',),
'imens': ('imens',),
'imidlertid': ('imidlertid',),
'in absentia': ('in absentia',),
'in absurdum': ('in absurdum',),
'in blanko': ('in blanko',),
'in casu': ('in casu',),
'in contumaciam': ('in contumaciam',),
'in corpore': ('in corpore',),
'in duplo': ('in duplo',),
'in extenso': ('in extenso',),
'in flagranti': ('in flagranti',),
'in honorem': ('in honorem',),
'in medias res': ('in medias res',),
'in memoriam': ('in memoriam',),
'in mente': ('in mente',),
'in natura': ('in natura',),
'in nuce': ('in nuce',),
'in persona': ('in persona',),
'in quarto': ('in quarto',),
'in saldo': ('in saldo',),
'in salvo': ('in salvo',),
'in situ': ('in situ',),
'in solidum': ('in solidum',),
'in spe': ('in spe',),
'in triplo': ('in triplo',),
'in vitro': ('in vitro',),
'in vivo': ('in vivo',),
'ingenlunde': ('ingenlunde',),
'ingensteds': ('ingensteds',),
'inkognito': ('inkognito',),
'innenat': ('innenat',),
'innledningsvis': ('innledningsvis',),
'innleiingsvis': ('innleiingsvis',),
'isteden': ('isteden',),
'især': ('især',),
'item': ('item',),
'ja menn': ('ja menn',),
'ja så menn': ('ja så menn',),
'jammen': ('jammen',),
'jamnlig': ('jamnlig',),
'jamsides': ('jamsides',),
'jamt over': ('jamt over',),
'jamvel': ('jamvel',),
'jaså': ('jaså',),
'jevnlig': ('jevnlig',),
'jevnsides': ('jevnsides',),
'jevnt over': ('jevnt over',),
'jo menn': ('jo menn',),
'jommen': ('jommen',),
'just': ('just',),
'kanon': ('kanon',),
'kanskje': ('kanskje',),
'kav': ('kav',),
'kavende': ('kavende',),
'kilovis': ('kilovis',),
'klin': ('klin',),
'klink': ('klink',),
'klinkende': ('klinkende',),
'klokelig': ('klokelig',),
'knakende': ('knakende',),
'knapt': ('knapt',),
'knasende': ('knasende',),
'knekkende': ('knekkende',),
'knøtrende': ('knøtrende',),
'knøttende': ('knøttende',),
'kolende': ('kolende',),
'kul': ('kul',),
'kuli': ('kuli',),
'kun': ('kun',),
'kvartalsvis': ('kvartalsvis',),
'kvekk': ('kvekk',),
'kølende': ('kølende',),
'lagerfritt': ('lagerfritt',),
'lagom': ('lagom',),
'lagvis': ('lagvis',),
'larghetto': ('larghetto',),
'largo': ('largo',),
'lassevis': ('lassevis',),
'legato': ('legato',),
'leilighetsvis': ('leilighetsvis',),
'lell': ('lell',),
'lenger': ('lenger',),
'liddelig': ('liddelig',),
'like': ('like',),
'likeledes': ('likeledes',),
'likeså': ('likeså',),
'likevel': ('likevel',),
'likså': ('likså',),
'lissom': ('lissom',),
'litervis': ('litervis',),
'livende': ('livende',),
'lovformelig': ('lovformelig',),
'lovlig': ('lovlig',),
'lukt': ('lukt',),
'lut': ('lut',),
'luta': ('luta',),
'lutende': ('lutende',),
'lykkeligvis': ('lykkeligvis',),
'lynfort': ('lynfort',),
'lys': ('lys',),
'maestoso': ('maestoso',),
'mala fide': ('mala fide',),
'malapropos': ('malapropos',),
'massevis': ('massevis',),
'med rette': ('med rette',),
'medio': ('medio',),
'medium': ('medium',),
'meget': ('meget',),
'mengdevis': ('mengdevis',),
'metervis': ('metervis',),
'mezzoforte': ('mezzoforte',),
'midsommers': ('midsommers',),
'midsommers': ('midsommers',),
'midt': ('midt',),
'midtsommers': ('midtsommers',),
'midtsommers': ('midtsommers',),
'midtvinters': ('midtvinters',),
'midvinters': ('midvinters',),
'milevis': ('milevis',),
'millionvis': ('millionvis',),
'min sann': ('min sann',),
'min sant': ('min sant',),
'min santen': ('min santen',),
'minus': ('minus',),
'mo': ('mo',),
'molto': ('molto',),
'motsols': ('motsols',),
'motstrøms': ('motstrøms',),
'mukk': ('mukk',),
'mukkende': ('mukkende',),
'muligens': ('muligens',),
'muligvis': ('muligvis',),
'murende': ('murende',),
'musende': ('musende',),
'mutters': ('mutters',),
'månedsvis': ('månedsvis',),
'naggende': ('naggende',),
'naturligvis': ('naturligvis',),
'nauende': ('nauende',),
'navnlig': ('navnlig',),
'neigu': ('neigu',),
'neimen': ('neimen',),
'nemlig': ('nemlig',),
'neppe': ('neppe',),
'nesegrus': ('nesegrus',),
'nest': ('nest',),
'nesten': ('nesten',),
'netto': ('netto',),
'nettopp': ('nettopp',),
'noenlunde': ('noenlunde',),
'noensinne': ('noensinne',),
'noensteds': ('noensteds',),
'nok': ('nok',),
'nok': ('nok',),
'noksom': ('noksom',),
'nokså': ('nokså',),
'non stop': ('non stop',),
'nonstop': ('nonstop',),
'notabene': ('notabene',),
'nu': ('nu',),
'nylig': ('nylig',),
'nyss': ('nyss',),
'nå': ('nå',),
'når': ('når',),
'nåvel': ('nåvel',),
'nære': ('nære',),
'nærere': ('nærere',),
'nærest': ('nærest',),
'nærmere': ('nærmere',),
'nærmest': ('nærmest',),
'nødvendigvis': ('nødvendigvis',),
'offside': ('offside',),
'også': ('også',),
'om att': ('om att',),
'om igjen': ('om igjen',),
'omme': ('omme',),
'omsider': ('omsider',),
'omsonst': ('omsonst',),
'omtrent': ('omtrent',),
'onnimellom': ('onnimellom',),
'opp att': ('opp att',),
'opp ned': ('opp ned',),
'oppad': ('oppad',),
'oppstrøms': ('oppstrøms',),
'oven': ('oven',),
'overalt': ('overalt',),
'overens': ('overens',),
'overhodet': ('overhodet',),
'overlag': ('overlag',),
'overmorgen': ('overmorgen',),
'overmåte': ('overmåte',),
'overvettes': ('overvettes',),
'pakkende': ('pakkende',),
'pal': ('pal',),
'par avion': ('par avion',),
'par excellence': ('par excellence',),
'parlando': ('parlando',),
'pars pro toto': ('pars pro toto',),
'partout': ('partout',),
'parvis': ('parvis',),
'per capita': ('per capita',),
'peu à peu': ('peu à peu',),
'peu om peu': ('peu om peu',),
'pianissimo': ('pianissimo',),
'piano': ('piano',),
'pinende': ('pinende',),
'pinnende': ('pinnende',),
'pist': ('pist',),
'pizzicato': ('pizzicato',),
'pladask': ('pladask',),
'plent': ('plent',),
'plenty': ('plenty',),
'pluss': ('pluss',),
'porsjonsvis': ('porsjonsvis',),
'portamento': ('portamento',),
'portato': ('portato',),
'post festum': ('post festum',),
'post meridiem': ('post meridiem',),
'post mortem': ('post mortem',),
'prestissimo': ('prestissimo',),
'presto': ('presto',),
'prima vista': ('prima vista',),
'primo': ('primo',),
'pro anno': ('pro anno',),
'pro persona': ('pro persona',),
'pro tempore': ('pro tempore',),
'proforma': ('proforma',),
'prompt': ('prompt',),
'prompte': ('prompte',),
'proppende': ('proppende',),
'prosentvis': ('prosentvis',),
'pukka': ('pukka',),
'puljevis': ('puljevis',),
'punktvis': ('punktvis',),
'pyton': ('pyton',),
'pø om pø': ('pø om pø',),
'quantum satis': ('quantum satis',),
'rammende': ('rammende',),
'rangsøles': ('rangsøles',),
'rasende': ('rasende',),
'ratevis': ('ratevis',),
'ratt': ('ratt',),
'rav': ('rav',),
'ravende': ('ravende',),
'reint': ('reint',),
'rent': ('rent',),
'respektive': ('respektive',),
'rettsøles': ('rettsøles',),
'reverenter': ('reverenter',),
'riktig nok': ('riktig nok',),
'riktignok': ('riktignok',),
'rimeligvis': ('rimeligvis',),
'ringside': ('ringside',),
'rispende': ('rispende',),
'ritardando': ('ritardando',),
'riv': ('riv',),
'rubato': ('rubato',),
'ruskende': ('ruskende',),
'rykkevis': ('rykkevis',),
'saktelig': ('saktelig',),
'saktens': ('saktens',),
'sammen': ('sammen',),
'samstundes': ('samstundes',),
'samt': ('samt',),
'sann': ('sann',),
'sannelig': ('sannelig',),
'sannsynligvis': ('sannsynligvis',),
'sans phrase': ('sans phrase',),
'scilicet': ('scilicet',),
'seinhøstes': ('seinhøstes',),
'senhøstes': ('senhøstes',),
'sia': ('sia',),
'sic': ('sic',),
'sidelengs': ('sidelengs',),
'siden': ('siden',),
'sideveges': ('sideveges',),
'sidevegs': ('sidevegs',),
'sideveis': ('sideveis',),
'sikkerlig': ('sikkerlig',),
'silde': ('silde',),
'simpelthen': ('simpelthen',),
'sine anno': ('sine anno',),
'sjelden': ('sjelden',),
'sjøleies': ('sjøleies',),
'sjøleis': ('sjøleis',),
'sjøverts': ('sjøverts',),
'skeis': ('skeis',),
'skiftevis': ('skiftevis',),
'skita': ('skita',),
'skjøns': ('skjøns',),
'skogleies': ('skogleies',),
'skokkevis': ('skokkevis',),
'skrevs': ('skrevs',),
'skrittvis': ('skrittvis',),
'skrås': ('skrås',),
'skyllende': ('skyllende',),
'skåldende': ('skåldende',),
'slettes': ('slettes',),
'sluttelig': ('sluttelig',),
'smekk': ('smekk',),
'smellende': ('smellende',),
'småningom': ('småningom',),
'sneisevis': ('sneisevis',),
'snesevis': ('snesevis',),
'snuft': ('snuft',),
'snupt': ('snupt',),
'snyt': ('snyt',),
'snyta': ('snyta',),
'snyte': ('snyte',),
'solo': ('solo',),
'sommerstid': ('sommerstid',),
'spenna': ('spenna',),
'spent': ('spent',),
'spika': ('spika',),
'spikende': ('spikende',),
'spildrende': ('spildrende',),
'spill': ('spill',),
'splinter': ('splinter',),
'splitter': ('splitter',),
'sporenstreks': ('sporenstreks',),
'sprangvis': ('sprangvis',),
'sprell': ('sprell',),
'sprut': ('sprut',),
'sprutende': ('sprutende',),
'sprøyte': ('sprøyte',),
'stakkato': ('stakkato',),
'stapp': ('stapp',),
'stappa': ('stappa',),
'stappende': ('stappende',),
'staurende': ('staurende',),
'stedvis': ('stedvis',),
'steika': ('steika',),
'stein': ('stein',),
'steinsens': ('steinsens',),
'stokk': ('stokk',),
'stokkende': ('stokkende',),
'straks': ('straks',),
'stringendo': ('stringendo',),
'stummende': ('stummende',),
'stundimellom': ('stundimellom',),
'stundom': ('stundom',),
'stundomtil': ('stundomtil',),
'stupende': ('stupende',),
'styggelig': ('styggelig',),
'styggende': ('styggende',),
'stykkevis': ('stykkevis',),
'støtt': ('støtt',),
'støtvis': ('støtvis',),
'støytvis': ('støytvis',),
'sub rosa': ('sub rosa',),
'summa summarum': ('summa summarum',),
'surr': ('surr',),
'svinaktig': ('svinaktig',),
'sydøst': ('sydøst',),
'synderlig': ('synderlig',),
'så': ('så',),
'så pass': ('så pass',),
'sågar': ('sågar',),
'således': ('således',),
'såleis': ('såleis',),
'såpass': ('såpass',),
'såre': ('såre',),
'særdeles': ('særdeles',),
'særs': ('særs',),
'søkk': ('søkk',),
'søkkende': ('søkkende',),
'sønder': ('sønder',),
'takimellom': ('takimellom',),
'takomtil': ('takomtil',),
'temmelig': ('temmelig',),
'ti': ('ti',),
'tidligdags': ('tidligdags',),
'tidsnok': ('tidsnok',),
'tidvis': ('tidvis',),
'tilfeldigvis': ('tilfeldigvis',),
'tilmed': ('tilmed',),
'tilnærmelsesvis': ('tilnærmelsesvis',),
'timevis': ('timevis',),
'tjokkende': ('tjokkende',),
'tomreipes': ('tomreipes',),
'tott': ('tott',),
'trill': ('trill',),
'trillende': ('trillende',),
'trinnvis': ('trinnvis',),
'troppevis': ('troppevis',),
'troppo': ('troppo',),
'troppsvis': ('troppsvis',),
'trutt': ('trutt',),
'turevis': ('turevis',),
'turvis': ('turvis',),
'tusenfold': ('tusenfold',),
'tusenvis': ('tusenvis',),
'tvers': ('tvers',),
'tvert': ('tvert',),
'tydeligvis': ('tydeligvis',),
'tynnevis': ('tynnevis',),
'tynnevis': ('tynnevis',),
'tålig': ('tålig',),
'tønnevis': ('tønnevis',),
'tønnevis': ('tønnevis',),
'ufravendt': ('ufravendt',),
'ugjerne': ('ugjerne',),
'uheldigvis': ('uheldigvis',),
'ukevis': ('ukevis',),
'ukevis': ('ukevis',),
'ulykkeligvis': ('ulykkeligvis',),
'uløyves': ('uløyves',),
'underhånden': ('underhånden',),
'undertiden': ('undertiden',),
'unntakelsesvis': ('unntakelsesvis',),
'unntaksvis': ('unntaksvis',),
'ustyggelig': ('ustyggelig',),
'utaboks': ('utaboks',),
'utbygdes': ('utbygdes',),
'utdragsvis': ('utdragsvis',),
'utelukkende': ('utelukkende',),
'utenat': ('utenat',),
'utenboks': ('utenboks',),
'uvegerlig': ('uvegerlig',),
'uviselig': ('uviselig',),
'uvislig': ('uvislig',),
'va banque': ('va banque',),
'vanligvis': ('vanligvis',),
'vann': ('vann',),
'vekevis': ('vekevis',),
'vekevis': ('vekevis',),
'vekselvis': ('vekselvis',),
'vel': ('vel',),
'vibrato': ('vibrato',),
'vice versa': ('vice versa',),
'vide': ('vide',),
'viden': ('viden',),
'vinterstid': ('vinterstid',),
'viselig': ('viselig',),
'visselig': ('visselig',),
'visst': ('visst',),
'visst nok': ('visst nok',),
'visstnok': ('visstnok',),
'vivace': ('vivace',),
'vonlig': ('vonlig',),
'vonom': ('vonom',),
'vonoms': ('vonoms',),
'vrangsøles': ('vrangsøles',),
'ytterlig': ('ytterlig',),
'åkkesom': ('åkkesom',),
'årevis': ('årevis',),
'årlig års': ('årlig års',),
'åssen': ('åssen',),
'ørende': ('ørende',),
'øyensynlig': ('øyensynlig',),
'antageligvis': ('antageligvis',),
'coolly': ('coolly',),
'kor': ('kor',),
'korfor': ('korfor',),
'kor': ('kor',),
'korfor': ('korfor',),
'medels': ('medels',),
'nasegrus': ('nasegrus',),
'overimorgen': ('overimorgen',),
'unntagelsesvis': ('unntagelsesvis',),
'åffer': ('åffer',),
'åffer': ('åffer',),
'sist': ('sist',),
'seinhaustes': ('seinhaustes',),
'stetse': ('stetse',),
'stikk': ('stikk',),
'storlig': ('storlig',),
'A': ('A',),
'for': ('for',),
'benveges': ('benveges',),
'bunkevis': ('bunkevis',),
'selv': ('selv',),
'sjøl': ('sjøl',),
'skauleies': ('skauleies',),
'da capo': ('da capo',),
'beint frem': ('beint frem',),
'beintfrem': ('beintfrem',),
'beinveges': ('beinveges',),
'beinvegs': ('beinvegs',),
'beinveis': ('beinveis',),
'benvegs': ('benvegs',),
'benveis': ('benveis',),
'en garde': ('en garde',),
'framåt': ('framåt',),
'krittende': ('krittende',),
'kvivitt': ('kvivitt',),
'maksis': ('maksis',),
'mangesteds': ('mangesteds',),
'møkka': ('møkka',),
'pill': ('pill',),
'sellende': ('sellende',),
'sirka': ('sirka',),
'subito': ('subito',),
'til sammen': ('til sammen',),
'tomrepes': ('tomrepes',),
'medurs': ('medurs',),
'moturs': ('moturs',)
}
